/****************************************************************************
                          INTERNATIONAL AVS CENTRE
           (This disclaimer must remain at the top of all files)

WARRANTY DISCLAIMER

This module and the files associated with it are distributed free of charge.
It is placed in the public domain and permission is granted for anyone to use,
duplicate, modify, and redistribute it unless otherwise noted.  Some modules
may be copyrighted.  You agree to abide by the conditions also included in
the AVS Licensing Agreement, version 1.0, located in the main module
directory located at the International AVS Center ftp site and to include
the AVS Licensing Agreement when you distribute any files downloaded from 
that site.

The International AVS Centre, University of Manchester, the AVS Consortium and
the individual  submitting the module and files associated with said module
provide absolutely NO WARRANTY OF ANY KIND with respect to this software.  The
entire risk as to the quality and performance of this software is with the
user.  IN NO EVENT WILL The International AVS Centre, University of Manchester,
the AVS Consortium and the individual submitting the module and files
associated with said module BE LIABLE TO ANYONE FOR ANY DAMAGES ARISING FROM
THE USE OF THIS SOFTWARE, INCLUDING, WITHOUT LIMITATION, DAMAGES RESULTING FROM
LOST DATA OR LOST PROFITS, OR ANY SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES.

This AVS module and associated files are public domain software unless
otherwise noted.  Permission is hereby granted to do whatever you like with
it, subject to the conditions that may exist in copyrighted materials. Should
you wish to make a contribution toward the improvement, modification, or
general performance of this module, please send us your comments:  why you
liked or disliked it, how you use it, and most important, how it helps your
work. We will receive your comments at avs@iavsc.org.

Please send AVS module bug reports to avs@iavsc.org.

***************************************************************************/
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <stdio.h>
#include <avs/avs.h>
#include <avs/field.h>
#include "vr_util.h"

AVSinit_modules()
{
    int Vr_print_fld();
    AVSmodule_from_desc(Vr_print_fld);
}

static char NO_BUTTON_EVENTS_STRING[] = {"No Button Events"};

int
Vr_print_fld()
{
    int Vr_print_fld_compute();
    int parm;
    
    AVSset_module_name("VR print field",MODULE_RENDER);
    AVScreate_input_port("input field",VR_FIELD_STRING,REQUIRED);
    
    parm = AVSadd_parameter("d1","string","X, Y, Z Rotation", "","");
    AVSconnect_widget(parm,"text");
    AVSadd_parameter_prop(parm,"width","integer",4);
    
    parm = AVSadd_parameter("rotations","string","inactive", "","");
    AVSconnect_widget(parm,"text");
    AVSadd_parameter_prop(parm,"width","integer",4);
    
    parm = AVSadd_parameter("d3","string","X, Y, Z Translation", "","");
    AVSconnect_widget(parm,"text");
    AVSadd_parameter_prop(parm,"width","integer",4);
    
    parm = AVSadd_parameter("translations","string","inactive", "","");
    AVSconnect_widget(parm,"text");
    AVSadd_parameter_prop(parm,"width","integer",4);
    
    parm = AVSadd_parameter("d5","string","Button Events", "","");
    AVSconnect_widget(parm,"text");
    AVSadd_parameter_prop(parm,"width","integer",4);
    
    parm = AVSadd_parameter("buttons","string",NO_BUTTON_EVENTS_STRING, "","");
    AVSconnect_widget(parm,"text");
    AVSadd_parameter_prop(parm,"width","integer",4);
    
    AVSset_compute_proc(Vr_print_fld_compute);
}

int
Vr_print_fld_compute(inf)
AVSfield *inf;
{
    float *t;
    float trans[3],rot[3];
    char s_rot[32],s_trans[32],s_button[32];
    int have_button_event,b1,b2,b3,b4,b5,b6,b7,b8;

    t = inf->field_union.field_data_float_u;
    
    VR_GET_TRANS_VECTOR(trans[0],trans[1],trans[2],inf); 

    VR_GET_ROT_VECTOR(rot[0],rot[1],rot[2],inf); 

    sprintf(s_rot,"%4.3f %4.3f %4.3f",rot[0],rot[1],rot[2]);
    sprintf(s_trans,"%4.3f %4.3f %4.3f",trans[0],trans[1],trans[2]);

    sprintf(s_button,NO_BUTTON_EVENTS_STRING);
    
    TEST_BUTTONS_FLAG(have_button_event,inf);
    if (have_button_event)
    {
	VR_TEST_BUTTON(VR_BUTTON1_MASK,b1,inf);
	VR_TEST_BUTTON(VR_BUTTON2_MASK,b2,inf);
	VR_TEST_BUTTON(VR_BUTTON3_MASK,b3,inf);
	VR_TEST_BUTTON(VR_BUTTON4_MASK,b4,inf);
	
	VR_TEST_BUTTON(VR_BUTTON5_MASK,b5,inf);
	VR_TEST_BUTTON(VR_BUTTON6_MASK,b6,inf);
	VR_TEST_BUTTON(VR_BUTTON7_MASK,b7,inf);
	VR_TEST_BUTTON(VR_BUTTON8_MASK,b8,inf);

	if (b1)
	    sprintf(s_button,"Button 1 Event");
	else if (b2)
	    sprintf(s_button,"Button 2 Event");
	else if (b3)
	    sprintf(s_button,"Button 3 Event");
	else if (b4)
	    sprintf(s_button,"Button 4 Event");
	else if (b5)
	    sprintf(s_button,"Button 5 Event");
	else if (b6)
	    sprintf(s_button,"Button 6 Event");
	else if (b7)
	    sprintf(s_button,"Button 7 Event");
	else if (b8)
	    sprintf(s_button,"Button 8 Event");


    }
    
    AVSmodify_parameter("rotations",AVS_VALUE,s_rot,NULL,NULL);
    AVSmodify_parameter("translations",AVS_VALUE,s_trans,NULL,NULL);
    AVSmodify_parameter("buttons",AVS_VALUE,s_button,NULL,NULL);

    
    return(1);
}
