// INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
// Please read the file DISCLAIMER for conditions associated with this file.
// avs@iavsc.org, www.iavsc.org

flibrary ReadPapyrusMods {

  // Patient
  //   Data structure containing patient information extracted from DICOM file.
  group Patient {
    string PatientsNameP;
    string PatientIDP;
    string PatientsBirthDateP;
    string PatientsBirthTimeP;
    string PatientsSexP;
    string ReferencedPatientSequenceP;
    string OtherPatientID;
    string OtherPatientNamesP;
    string EthnicGroupP;
    string PatientCommentsP;
  };

  // General_Study
  //   Data structure containing general study information extracted from DICOM file.
  group General_Study {
    string StudyInstanceUIDGS;
    string StudyDateGS;
    string StudyTimeGS;
    string ReferringPhysiciansNameGS;
    string StudyIDGS;
    string AccessionNumberGS;
    string StudyDescriptionGS;
    string NameofPhysiciansReadingStudyGS;
    string ReferencedStudySequenceGS;
  };

  // General_Series
  //   Data structure containing general series information extracted from DICOM file.
  group General_Series {
    string ModalityGS;
    string SeriesInstanceUIDGS;
    string SeriesNumberGS;
    string Laterality;
    string SeriesDate;
    string SeriesTime;
    string PerformingPhysiciansNameGS;
    string ProtocolName;
    string SeriesDescription;
    string OperatorsName;
    string ReferencedStudyComponentSequenceGS;
    string BodyPartExaminedGS;
    string PatientPosition;
    int    SmallestPixelValueinSeries;
    int    LargestPixelValueinSeries;
  };

  // General_Equipment
  //   Data structure containing general equipment information extracted from DICOM file.
  group General_Equipment {
    string ManufacturerGE;
    string InstitutionNameGE;
    string InstitutionAddressGE;
    string StationName;
    string InstitutionalDepartmentName;
    string ManufacturersModelName;
    string DeviceSerialNumberGE;
    string SoftwareVersionsGE;
    string SpatialResolution;
    string DateofLastCalibration;
    string TimeofLastCalibration;
    int    PixelPaddingValue;
  };

  // Image_Series
  //   Data structure containing information pertinent to the use of the data
  group Image_Series {
    string Interpretation;
    int Rows;
    int Columns;
    int Slices; // actual # read in
    int BitsAllocated;
    float SliceSpacing;
    float XSpacing;
    float YSpacing;
    float WindowCentre;
    float WindowWidth;
  };

  // Image_Header
  //   data structure that groups the previously mentioned data structures together.
  //   This data contained within this structure is extracted from the DICOM file by
  //   the ReadDicomFile module.
  group Image_Header {
    Patient patient;
    General_Study generalStudy;
    General_Series generalSeries;
    General_Equipment generalEquipment;
    Image_Series imageSeries;
  };


  // Image_Data
  //   modified uniform field stucture.
  //   used to contain data generated by the ReadDicomFile module.
  Field_Unif Image_Data;



  // ReadPapyrusFile
  //   low-level module that uses C code to interface to the Papyrus 3.5 library.
  module ReadPapyrusFile <
    build_dir="iac_proj/rd_papy",
    src_file="rd_papy.c",
    c_src_files="rd_pyutl.c",
    out_hdr_file="gen.h",
#ifdef MSDOS
    hdr_dirs="include/pc .",
    link_files="lib/pc/papy3_32.lib"
#else
    link_files="-lP -lJpglless -lJpglossy"
#endif
    >
  {
    // Input: Papyrus filename
    string+read+notify+req+IPort2 filename;

    // External C code function
    omethod+req+notify_inst papyrus_update<status=1> = "Read_Papyrus_File";

    // Outputs: Currently busy, header information & image data
    int+write+nonotify+OPort2 busy = 0;
    int+write+nonotify+OPort2 done = 0;
    Image_Header+write+nonotify+OPort2 header;
    Image_Data+write+nonotify+OPort2 output_image;
  };

};

