/*
 * INTERNATIONAL AVS CENTRE - WARRANTY DISCLAIMER
 * Please read the file DISCLAIMER for conditions associated with this file.
 * avs@iavsc.org, www.iavsc.org
 */

/* ----------------------------------------------------------------------
 * RadioBox Module
 * ----------------------------------------------------------------------
 * Description:
 *   
 * RadioBox sets an array of groups (currently required to be type int) in   *
 * radio behavior according to the index of the element that changed or the  *
 * selectedItem input.                                                       *
 *
 * Authors: 
 *   Brian Selle, Leon Thrane, Advanced Visual Systems Inc.
 *   Documentation written by Ian Curington
 *
 * Revision: 8th February 2000 - Paul G. Lever, IAC
 *   Converted to IAC format.
 *
 * ----------------------------------------------------------------------
 * Note:
 *   The gen.h include file is generated by Express when the module is 
 *   compiled. It avoids including "user.h" or "express.h" directly, so 
 *   that the module may be moved across the processes by changing the V
 *   properties in the library.
 * ----------------------------------------------------------------------
 */

#include "iac_proj/radiobox/gen.h"
#include "XP_OM_CALL.h"

int
RadioBox_RadioBoxMods_RadioBox::update(OMevent_mask , int seq_num)
{
  int       status;       // Function return status 
  int       index = -1;
  int       dataType;
  OMobj_id  arrayElemId;
   
  // Check for valid active
  if( active == 0 )
  {
    return( XP_SUCCESS );
  }

  // Check for data
  int array_size = this->set.ret_array_size();  
  if( array_size == 0 )
  {
    return( XP_SUCCESS);
  }
  
  // Check if selectedItem changed
  if( this->selectedItem.changed( seq_num ) == 1 )
  {
    if( (int)selectedItem < array_size && (int)selectedItem >= 0 )
    {
      index = (int)selectedItem;

      // Only update the previous item if the selectedItem is new 
      if( index != (int)bufferItem )
      { 
	previousItem = (int)bufferItem;
	bufferItem   = (int)selectedItem;      
      }
    }
    else
    {
      printf( "Error: Invalid selectedItem input\n" );
      return( XP_FAILURE );
    }
  }

  // Find which "set" array element changed
  else
  {
    for( int i = 0; i < array_size; i++ )
    {
      OMCALLR_SUCCESS( "Unable to get array element reference", 
		       OMget_array_ref( this->set.obj_id(), i, 
					&arrayElemId, OM_OBJ_RW) ); 
      
      if( OMchanged( arrayElemId, seq_num ) == 1)
      {
	index = i;

	// Only update the previous item if the selectedItem is new 
        if( index != (int)bufferItem )
	{ 
	  previousItem = (int)selectedItem;
	  bufferItem   = index;
	}

        // Update selectedItem each time regardless to trigger other objects
	selectedItem = index;
	break;
      }       
    }  
  }

  // Set the array values
  if( index > -1 )
  {
    for( int i = 0; i < array_size; i++ )
    {
      OMCALLR_SUCCESS( "Unable to get array element reference", 
		       OMget_array_ref( this->set.obj_id(), i, 
					&arrayElemId, OM_OBJ_RW) ); 
      
      OMCALLR_SUCCESS( "Unable to array element data type",
		       OMget_data_type( arrayElemId, &dataType ) );
      
      if( dataType != OM_TYPE_INT )
      {
	printf( "Error: Set array must be of type (int)\n" );
	return( XP_FAILURE );
      }
      
      if( i == index ) 
      {
	OMCALLR_SUCCESS( "Unable to set array element value",
			 OMset_int_val( arrayElemId, 1 ) ); 
      }
      else
      {
	OMCALLR_SUCCESS( "Unable to set array element value",
			 OMset_int_val( arrayElemId, 0 ) ); 
      }
    }
  }

  // Successful return
  return( XP_SUCCESS );
}

/* end of file */

