
#include "user.h"


int
create_cube(OMobj_id cube_id, OMevent_mask event_mask, int seq_num)
{
   /***********************/
   /*  Declare variables  */
   /***********************/
   OMobj_id geom_id;
   int geom_nspace, geom_nnodes, geom_size;
   int  geom_nsets, geom_set_count, geom_ncells;
   int  geom_cell_nnodes, *geom_node_connect;
   OMobj_id geom_cell_set;
   float *geom_coord;

   /***********************/
   /* Function's Body     */
   /***********************/
   ERRverror("",ERR_NO_HEADER | ERR_INFO,"I'm in function: create_cube generated from method: cube.create\n");


   /***********************/
   /*  Set output values  */
   /***********************/
   /* set  geom mesh */

   /*  Get mesh id */
   geom_id = OMfind_subobj(cube_id, OMstr_to_name("geom"), OM_OBJ_RW);

   /* Set mesh nnodes */
   FLDset_nnodes (geom_id, geom_nnodes);

   /* Set mesh nspace */
   FLDset_nspace (geom_id, geom_nspace);

   /* Set mesh coordinates */
   /* First allocate geom_coord array */
   
   geom_coord = (float *)ARRalloc(NULL, DTYPE_FLOAT, 
                              geom_nspace*geom_nnodes, NULL);

   /*** Fill in geom_coord array with X[,Y,Z] values at each node ***/

   FLDset_coord (geom_id, geom_coord, geom_nspace*geom_nnodes, 
                 OM_SET_ARRAY_FREE);


   /* Set_number of cell sets to 0 initially, 
      the real number of cell_sets should be assigned to geom_nsets variable */
   FLDset_ncell_sets(geom_id, 0);

   /* For each cell set set information about cells */
   for (geom_set_count=0; geom_set_count<geom_nsets; geom_set_count++) {
      /* add cell set, the name can be one of the following:
         Point, Line, Polyline, Tri, Polytri, Polhedron, 
         Tet, Hex, Prism, Pyr,
      */
      FLDadd_cell_set(geom_id, "Line");

      /* Get cell set id */
      FLDget_cell_set(geom_id, geom_set_count, &geom_cell_set);

      /* Set number of cells */
      FLDset_ncells(geom_cell_set, geom_ncells);

      /* Set node connectivity list */
      /* First allocate geom_node_connect */

      FLDget_cell_set_nnodes(geom_cell_set,  &geom_cell_nnodes);
      geom_node_connect = (int *)ARRalloc(NULL, DTYPE_INT, 
                               geom_ncells*geom_cell_nnodes, NULL);

      /*** fill in  geom_node_connect array with node indecies for each cell ***/

      FLDset_node_connect(geom_cell_set, geom_node_connect, 
                          geom_ncells*geom_cell_nnodes, OM_SET_ARRAY_FREE);


      /***  NOTE: for POLY cell_sets such as Polyline, Polytri and Polhedron 
            use:
	FLDset_npolys()          instead of       FLDset_ncells()
        FLDset_poly_connect()    instead of       FLDset_node_connect()
      ***/

   }
   
   return(1);
}
