#include "iac_proj/overlay/gen.h"
#include "fld/Xfld.h"

int Overlay_OverlayMods_overlay_images::overlay(OMevent_mask event_mask, int seq_num)
{
  // check images are valid objs
  if( !(image1.nnodes && image2.nnodes))
    return 1;

  // mask (OMXint_array read req notify)
  int mask_size;
  int *mask_arr;

  // image1 (Field_Unif read req notify)

  // image1.ndim (int) 
  // image1.dims (int []) 
  int *image1_dims = (int *)image1.dims.ret_array_ptr(OM_GET_ARRAY_RD);
  // image1.nspace (int) 
  // image1.npoints (int)
  // image1.points (float [])
  // image1.nnodes (int)
  // image1.nnode_data (int)
  int  image1_data_size, image1_data_type;
  // image1.node_data[image1_data_comp].veclen (int) 
  // image1.node_data[image1_data_comp].values (char [])
  char *image1_node_data = (char *)image1.node_data[0].values.ret_array_ptr(OM_GET_ARRAY_RD, &image1_data_size, &image1_data_type);

  if (!image1_node_data)
  {
    ERRverror("",ERR_NO_HEADER | ERR_INFO,"overlay: can't access image1 node_data\n");
    return 1;
  }

  // image2 (Field_Unif read req notify)

  // image2.ndim (int) 
  // image2.dims (int []) 
  int *image2_dims = (int *)image2.dims.ret_array_ptr(OM_GET_ARRAY_RD);
  // image2.nspace (int) 
  // image2.npoints (int)
  // image2.points (float [])
  // image2.nnodes (int)
  // image2.nnode_data (int)
  int  image2_data_size, image2_data_type;
  // image2.node_data[image2_data_comp].veclen (int) 
  // image2.node_data[image2_data_comp].values (char [])
  char *image2_node_data = (char *)image2.node_data[0].values.ret_array_ptr(OM_GET_ARRAY_RD, &image2_data_size, &image2_data_type);

  if (!image2_node_data)
  {
    ERRverror("",ERR_NO_HEADER | ERR_INFO,"overlay: can't access image2 node_data\n");
    ARRfree((char *)image1_node_data);
    return 1;
  }

  // check images are both argb
  if( image1.node_data[0].id!=669 || image2.node_data[0].id!=669  )
  {
    ERRverror("",ERR_NO_HEADER | ERR_INFO,"overlay: images must be argb\n");
    return 1;
  }

  // check images are the same size
  if( image1_dims[0]!=image2_dims[0] || image1_dims[1]!=image2_dims[1] )
  {
    ERRverror("",ERR_NO_HEADER | ERR_INFO,"overlay: images must be of identical dims\n");
    return 1;
  }

  // compos (Field_Unif write)

  // compos.ndim (int) 
  // compos.dims (int []) 
  compos.ndim=2;
  int *compos_dims = (int *)compos.dims.ret_array_ptr(OM_GET_ARRAY_WR);
  // compos.nspace (int) 
  compos.nspace=2;
  // compos.npoints (int)
  compos.npoints=2;
  // compos.points (float [])
  float *compos_points = (float *)compos.points.ret_array_ptr(OM_GET_ARRAY_WR);
  // compos.nnodes (int)
  // compos.nnode_data (int)
  int  compos_data_size, compos_data_type;
  // compos.node_data[compos_data_comp].veclen (int) 
  // compos.node_data[compos_data_comp].values (char [])

  // set compos dims
  compos_dims[0]=image1_dims[0];
  compos_dims[1]=image1_dims[1];
  compos.nnodes=compos_dims[0]*compos_dims[1];

  // set points
  compos_points[0]=0;
  compos_points[1]=0;
  compos_points[2]=compos_dims[0]-1;
  compos_points[3]=compos_dims[1]-1;
  ARRfree((char *)compos_points);

  // set single node_data
  compos.nnode_data=1;
  compos.node_data[0].id=669; // argb data
  compos.node_data[0].veclen=4;
  // need to use ret_typed_array_ptr as the values array is instanced as a prim
  char *compos_node_data = (char *)compos.node_data[0].values.ret_typed_array_ptr(OM_GET_ARRAY_WR, OM_TYPE_BYTE, &compos_data_size);

  if(!compos_node_data)
  {
    ERRverror("",ERR_NO_HEADER | ERR_INFO,"overlay: can't access compos node_data\n");
    ARRfree((char *)image1_node_data);
    ARRfree((char *)image2_node_data);
    return 1;
  }

  /***********************/
  /* Function's Body     */
  /***********************/

  mask_arr = (int *)mask.ret_array_ptr(OM_GET_ARRAY_RD,&mask_size);
  if (mask_arr)
  {
    int i,j;

    // overlay image2 on image1
    for(i=0; i<compos.nnodes; i++)
      for(j=0; j<4; j++)
	compos_node_data[i*4+j] = 
	  (image2_node_data[i*4+j]==mask_arr[j]) ? image1_node_data[i*4+j] : image2_node_data[i*4+j];
   
    // free all the arrays
    ARRfree((char *)mask_arr);
    ARRfree((char *)image1_dims);
    ARRfree((char *)image2_dims);
    ARRfree((char *)compos_dims);
    ARRfree((char *)image1_node_data);
    ARRfree((char *)image2_node_data);
    ARRfree((char *)compos_node_data);
  }
  else
    ERRverror("",ERR_NO_HEADER | ERR_INFO,"overlay: can't access mask\n");

  // return 1 for success
  return(1);
}
