//
// Demo showing Threshold module in use
//
      macro ThresholdEg<NEx=286.,NEy=66.,NExOffset=131.,NEyOffset=101.> {
         file myfile<NEx=88.,NEy=-44.> {
            name = "modules/threshold/sample_data/mydata";
         };
         Mesh_Unif+Node_Data+Float myfield<NEx=88.,NEy=11.,NEportLevels={0,1}> {
            dims => cache(file_array_ascii(myfile,0,3,{1,1,1}));
            Data_Array+Float.node_data node_data[.nnode_data] {
               nvals => nnodes;
            } = {
               {
                  values=>
                  cache(file_array_ascii(myfile,file_skip_lines(myfile,0,1),4,{1})),veclen=
                  1
               }};
            nnode_data = 1;
            nspace = 3;
            ndim = 3;
            points => {
               0,0,0,(dims[0] - 1),(dims[1] - 1),(dims[2] - 1)
            };
         };
         Viewers.SimpleViewer3D SimpleViewer3D<NEx=88.,NEy=308.> {
            objs_in => {
               <-.isovolume.out_obj};
            ViewUI {
               Shell {
                  x = 285;
                  y = 613;
                  width = 321;
                  height = 317;
               };
            };
         };

         WORKSPACE_2.ThresholdHigh.Threshold MyThreshold<NEx=187.,NEy=154.> {
               in => <-.myfield;
	       ThresholdParams.min = 2.0;
	       ThresholdParams.max = 6.0;
         };

         MODS.Mappers.isovolume isovolume<NEx=88.,NEy=253.> {
            in_field => <-.MyThreshold.out;
         };

      };

