/*******************************************************************
  Miscellaneous functions library

     Version 1.0
 ******************************************************************
  Written by: M.J. Evers
      Created:       22/8/96
      Last Modified: 22/8/96

 ******************************************************************/

#include "misc.h"


void DeleteSectionList( SectionRecord ** the_list )
/*
** DeleteSectionList frees memory occupied by the given SectionList, 
** and makes the pointer to it NULL
*/
{
  SectionRecord * current, * next;

  current = *the_list;

  while( current->next != NULL ) {
    next = current->next;
    /* free the memory occupied by the knot vectors and the vertex vectors */
    deallocate_nrb( &current->nurb );

#ifdef __cplusplus
    delete current;
#else
    free( current );
#endif

    current = next;
  }
  *the_list = NULL;
}

void deallocate_nrb( PR_nurb * nrb )
/* 
** Deallocates the vertex vector and the knot vectors of 
** the given NURBS, setting the pointers to NULL.
*/
{
    nrb_deallocatepts( &nrb->pf_ppp );
    nrb_deallocateknots( &nrb->pf_v );
    nrb_deallocateknots( &nrb->pf_u );
    nrb->pf_ppp = NULL; 
    nrb->pf_v.pf_kk = NULL;
    nrb->pf_u.pf_kk = NULL;
}

void adjustWeights( PR_nurb * current, double f )
/*
** This function adjusts weight of given NURBS by multiplying them by the 
** given factor f.
*/
{
  int i, nbVertices;

  nbVertices = current->pf_u.pf_n * current->pf_v.pf_n;

  for( i=0; i < nbVertices; i++ ) {
    current->pf_ppp->pts[i].x *= f;
    current->pf_ppp->pts[i].y *= f;
    current->pf_ppp->pts[i].z *= f;
    current->pf_ppp->pts[i].w *= f;
  }
}

