/*******************************************************************
  Miscellaneous functions library

     Version 1.0
 ******************************************************************
  Written by: M.J. Evers
      Created:       22/8/96
      Last Modified: 22/8/96

 ******************************************************************/
#ifndef __MISC_LIB__
#define __MISC_LIB___

#ifndef __NURBH_H__
#define __NURBH_H__

#include "nurbh.h"

#endif

#include "skinning.h"


void DeleteSectionList( SectionRecord ** the_list );
/*
** DeleteSectionList frees memory occupied by the given SectionList, 
** and makes the pointer to it NULL
*/

void deallocate_nrb( PR_nurb * nrb );
/* 
** Deallocates the vertex vector and the knot vectors of 
** the given NURBS, setting the pointers to NULL.
*/

void adjustWeights( PR_nurb * current, double f );
/*
** This function adjusts weight of given NURBS by multiplying them by the 
** given factor f.
*/

#endif
