"======================================================================
|
|   ProcessorScheduler Method Definitions
|
|   $Revision: 1.7.5$
|   $Date: 2000/05/28 16:56:52$
|   $Author: pb$
|
 ======================================================================"


"======================================================================
|
| Copyright 1988-92, 1994-95, 1999, 2000 Free Software Foundation, Inc.
| Written by Steve Byrne.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"


Object subclass: #ProcessorScheduler
       instanceVariableNames: 'processLists activeProcess idleTasks'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Language-Processes'
!

ProcessorScheduler comment: 
'I provide methods that control the execution of processes.' !


!ProcessorScheduler class methodsFor: 'instance creation'!
new
    "Error---new instances of ProcessorScheduler should not be created."

    self error: 'Cannot create new ProcessSchedulers -- the
integrity of the system depends on the uniqueness of its instance'! !


!ProcessorScheduler methodsFor: 'basic'!

activeProcess
    "Answer the active process"
    ^activeProcess
!

activePriority
    "Answer the active process' priority"
    ^self activeProcess priority
!

changePriorityOf: aProcess to: aPriority
    "Private - Move aProcess to the execution list for aPriority,
     answer the new execution list"

    aProcess priority isNil ifFalse: [
	(processLists at: aProcess priority) remove: aProcess ifAbsent: [ ]
    ].
    ^(processLists at: aPriority) addLast: aProcess; yourself
!

processesAt: aPriority
    "Private - Answer a linked list of processes at the given priority"
    ^processLists at: aPriority
!

terminateActive
    "Private - Terminate the active process"
    self activeProcess terminate
!

yield
    "Let the active process yield control to other processes"
    self activeProcess yield
! !


!ProcessorScheduler methodsFor: 'priorities'!

priorityName: priority
    "Private - Answer a name for the given process priority"
    ^#('priority 1' 'systemBackgroundPriority' 'userBackgroundPriority'
       'userSchedulingPriority' 'userInterruptPriority' 'lowIOPriority'
       'highIOPriority' 'timingPriority' 'priority 9') at: priority
!

highestPriority
    "Answer the highest valid priority"
    ^processLists size
!

timingPriority
    "Answer the priority for system real-time processes."
    ^8
!

highIOPriority
    "Answer the priority for system high-priority I/O processes,
    such as a process handling input from a network."
    ^7
!

lowIOPriority
    "Answer the priority for system low-priority I/O processes.
    Examples are the process handling input from the user (keyboard, 
    pointing device, etc.) and the process distributing input from a
    network."
    ^6
!

userInterruptPriority
    "Answer the priority for user interrupt-priority processes.
    Processes run at this level will preempt the window scheduler
    and should, therefore, not consume the processor forever."
    ^5
!

userSchedulingPriority
    "Answer the priority for user standard-priority processes"
    ^4
!

userBackgroundPriority
    "Answer the priority for user background-priority processes"
    ^3
!

systemBackgroundPriority
    "Answer the priority for system background-priority processes.
    Examples are an incremental garbage collector or status checker."

    ^2
!

lowestPriority
    "Answer the lowest valid priority"
    ^1
! !


!ProcessorScheduler methodsFor: 'idle tasks'!

idle
    "Private - Call the next idle task"
    | index |
    idleTasks isNil ifTrue: [ ^self ].
    index := idleTasks at: 1.
    (idleTasks at: index + 2) value.
    idleTasks at: 1 put: (index + 1) \\ (idleTasks size - 1)
!

idleAdd: aBlock
    "Register aBlock to be executed when things are idle"
    idleTasks isNil ifTrue: [ idleTasks := OrderedCollection with: 0 ].
    idleTasks add: aBlock
! !
