This is Info file tar.info, produced by Makeinfo version 1.67 from the
input file tar.texi.

START-INFO-DIR-ENTRY
* tar: (tar).			Making tape (or disk) archives.
END-INFO-DIR-ENTRY

   This file documents GNU `tar', a utility used to store, backup, and
transport files.

   Copyright (C) 1992, 1994, 1995, 1996, 1997 Free Software Foundation,
Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided that
the entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Foundation.

   This file documents GNU `tar', which is a utility used to store,
backup, and transport files.  `tar' is a tape (or disk) archiver.  This
manual documents the release 1.12a.


File: tar.info,  Node: backup,  Next: Applications,  Prev: extract options,  Up: Subcommands

Backup options
==============

   GNU `tar' offers options for making backups of files before writing
new versions.  These options control the details of these backups.
They may apply to the archive itself before it is created or rewritten,
as well as individual extracted members.  Other GNU programs (`cp',
`install', `ln', and `mv', for example) offer similar options.

   Backup options may prove unexpectedly useful when extracting archives
containing many members having identical name, or when extracting
archives on systems having file name limitations, making different
members appear as having similar names through the side-effect of name
truncation.  (This is true only if we have a good scheme for truncated
backup names, which I'm not sure at all: I suspect work is needed in
this area.  The MS-DOS/MS-Windows version works with numbered backups,
even when file names are truncated.) When any existing file is backed
up before being overwritten by extraction, then clashing files are
automatically renamed to be unique, and the true name is kept for only
the last file of a series of clashing files.  By using verbose mode,
users may track exactly what happens.  We recommend that you *always*
use numbered backups when unpacking archives on MS-DOS and on other
systems that have file name limitations.

   At the detail level, some decisions are still experimental, and may
change in the future, we are waiting comments from our users.  So,
please do not learn to depend blindly on the details of the backup
features.  For example, currently, directories themselves are never
renamed through using these options, so, extracting a file over a
directory still has good chances to fail.  Also, backup options apply
to created archives, not only to extracted members.  For created
archives, backups will not be attempted when the archive is a block or
character device, or when it refers to a remote file.

   For the sake of simplicity and efficiency, backups are made by
renaming old files prior to creation or extraction, and not by copying.
The original name is restored if the file creation fails.  If a
failure occurs after a partial extraction of a file, both the backup
and the partially extracted file are kept.

`--backup'
     Make backups of files that are about to be overwritten or removed.
     Without this option, the original versions are destroyed.

`--suffix=SUFFIX'
     Append SUFFIX to each backup file made with `-b'.  If this option
     is not specified, the value of the `SIMPLE_BACKUP_SUFFIX'
     environment variable is used.  And if `SIMPLE_BACKUP_SUFFIX' is not
     set, the default is `~', just as in Emacs.

`--version-control=METHOD'
     Use METHOD to determine the type of backups made with `--backup'.
     If this option is not specified, the value of the `VERSION_CONTROL'
     environment variable is used.  And if `VERSION_CONTROL' is not set,
     the default backup type is `existing'.

     This option corresponds to the Emacs variable `version-control';
     the same values for METHOD are accepted as in Emacs.  The values
     that this option accepts have also more descriptive name.  Here
     are the valid METHODs (unique abbreviations are accepted):

    `t'
    `numbered'
          Always make numbered backups.

    `nil'
    `existing'
          Make numbered backups of files that already have them, simple
          backups of the others.

    `never'
    `simple'
          Always make simple backups.

   Some people express the desire to *always* use the `--backup'
option, by defining some kind of alias or script.  This is not as easy
as one may thing, due to the fact that old style options should appear
first and consume arguments a bit unpredictably for an alias or script.
But, if you are ready to give up using old style options, you may
resort to using something like a (Bourne shell) function here:

     tar () { /usr/local/bin/tar --backup $*; }


File: tar.info,  Node: Applications,  Next: looking ahead,  Prev: backup,  Up: Subcommands

Notable `tar' Usages
====================

     *(This message will disappear, once this node revised.)*

   You can easily use archive files to transport a group of files from
one system to another: put all relevant files into an archive on one
computer system, transfer the archive to another system, and extract
the contents there.  The basic transfer medium might be magnetic tape,
Internet FTP, or even electronic mail (though you must encode the
archive with `uuencode' in order to transport it properly by mail).
Both machines do not have to use the same operating system, as long as
they both support the `tar' program.

   For example, here is how you might copy a directory's contents from
one disk to another, while preserving the dates, modes, owners and
link-structure of all the files therein.  In this case, the transfer
medium is a "pipe", which is one a Unix redirection mechanism:

     $ cd sourcedir; tar --create --file=- . | (cd targetdir; tar --extract --file=-)

The command also works using short option forms:

     $ cd sourcedir; tar -cf - . | (cd targetdir; tar -xf -)

If you are really confident you are using GNU `tar' and that standard
input and output were not overriden by something else as the default
archive at your installation, you might write the above examples more
simply:

     $ cd sourcedir; tar --create . | (cd targetdir; tar --extract)
     $ cd sourcedir; tar -c . | (cd targetdir; tar -x)

   This is one of the easiest methods to transfer a `tar' archive.


File: tar.info,  Node: looking ahead,  Prev: Applications,  Up: Subcommands

Looking Ahead: The Rest of this Manual
======================================

   You have now seen how to use all eight of the subcommands available
to `tar', and a number of the possible options.  The next chapter
explains how to choose and change file and archive names, how to use
files to store names of other files which you can then call as
arguments to `tar' (this can help you save time if you expect to
archive the same list of files a number of times), and how to

   If there are too many files to conveniently list on the command line,
you can list the names in a file, and `tar' will read that file.
*Note files::.

   There are various ways of causing `tar' to skip over some files, and
not archive them.  *Note Choosing::.


File: tar.info,  Node: Backups,  Next: Choosing,  Prev: Subcommands,  Up: Top

Performing Backups and Restoring Files
**************************************

     *(This message will disappear, once this node revised.)*

   GNU `tar' is distributed along with the scripts which the Free
Software Foundation uses for performing backups.  There is no
corresponding scripts available yet for doing restoration of files.
Even if there is a good chance those scripts may be satisfying to you,
they are not the only scripts or methods available for doing backups
and restore.  You may well create your own, or use more sophisticated
packages dedicated to that purpose.

   Some users are enthusiastic about `Amanda' (The Advanced Maryland
Automatic Network Disk Archiver), a backup system developed by James da
Silva `jds@cs.umd.edu' and available on many Unix systems.  This is
free software, and it is available at these places:

     http://www.cs.umd.edu/projects/amanda/amanda.html
     ftp://ftp.cs.umd.edu/pub/amanda

   Here is a possible plan for a future documentation about the
backuping scripts which are provided within the GNU `tar' distribution.

     .* dumps
     . + what are dumps
     
     . + different levels of dumps
     .  - full dump = dump everything
     .  - level 1, level 2 dumps etc, -
     	A level n dump dumps everything changed since the last level
     	n-1 dump (?)
     
     . + how to use scripts for dumps  (ie, the concept)
     .  - scripts to run after editing backup specs (details)
     
     . + Backup Specs, what is it.
     .  - how to customize
     .  - actual text of script  [/sp/dump/backup-specs]
     
     . + Problems
     .  - rsh doesn't work
     .  - rtape isn't installed
     .  - (others?)
     
     . + the --incremental option of tar
     
     . + tapes
     .  - write protection
     .  - types of media
     .   : different sizes and types, useful for different things
     .  - files and tape marks
          one tape mark between files, two at end.
     .  - positioning the tape
          MT writes two at end of write,
            backspaces over one when writing again.

   This chapter documents both the provided FSF scripts and `tar'
options which are more specific to usage as a backup tool.

   To "back up" a file system means to create archives that contain all
the files in that file system.  Those archives can then be used to
restore any or all of those files (for instance if a disk crashes or a
file is accidently deleted).  File system "backups" are also called
"dumps".

* Menu:

* Full Dumps::                  Using `tar' to Perform Full Dumps
* Inc Dumps::                   Using `tar' to Perform Incremental Dumps
* incremental and listed-incremental::  The Incremental Options
* Backup Levels::               Levels of Backups
* Backup Parameters::           Setting Parameters for Backups and Restoration
* Scripted Backups::            Using the Backup Scripts
* Scripted Restoration::        Using the Restore Script


File: tar.info,  Node: Full Dumps,  Next: Inc Dumps,  Prev: Backups,  Up: Backups

Using `tar' to Perform Full Dumps
=================================

     *(This message will disappear, once this node revised.)*

   Full dumps should only be made when no other people or programs are
modifying files in the filesystem.  If files are modified while `tar'
is making the backup, they may not be stored properly in the archive,
in which case you won't be able to restore them if you have to.  (Files
being modified are written with no trouble, and do not corrupt the
entire archive.)

   You will want to use the `--label=ARCHIVE-LABEL' (`-V
ARCHIVE-LABEL') option to give the archive a volume label, so you can
tell what this archive is even if the label falls off the tape, or
anything like that.

   Unless the filesystem you are dumping is guaranteed to fit on one
volume, you will need to use the `--multi-volume' (`-M') option.  Make
sure you have enough tapes on hand to complete the backup.

   If you want to dump each filesystem separately you will need to use
the `--one-file-system' (`-l') option to prevent `tar' from crossing
filesystem boundaries when storing (sub)directories.

   The `--incremental' (`-G') option is not needed, since this is a
complete copy of everything in the filesystem, and a full restore from
this backup would only be done onto a completely empty disk.

   Unless you are in a hurry, and trust the `tar' program (and your
tapes), it is a good idea to use the `--verify' (`-W') option, to make
sure your files really made it onto the dump properly.  This will also
detect cases where the file was modified while (or just after) it was
being archived.  Not all media (notably cartridge tapes) are capable of
being verified, unfortunately.

   `--listed-incremental=SNAPSHOT-FILE' (`-g SNAPSHOT-FILE') takes a
file name argument always.  If the file doesn't exist, `tar' runs a
level zero dump, creating the file.  If the file exists, `tar' uses
that file to see what has changed.

   `--incremental' (`-G') handle old GNU-format incremental backup.

   The `--incremental' (`-G') option means the archive is an incremental
backup.  Its meaning depends on the command that it modifies.

   When this option is used for creating an incremental backup of a
filesystem, `tar' writes, at the beginning of the archive, an entry for
each of the directories that will be operated on.  The entry for a
directory includes a list of all the files in the directory at the time
the dump was done, and a flag for each file indicating whether the file
is going to be put in the archive.  This information is used when doing
a complete incremental restore.

   Note that this option causes `tar' to create a non-standard archive
that may not be readable by non-GNU versions of the `tar' program.

   If the `--incremental' (`-G') option is used with `--list' (`-t'),
`tar' will list, for each directory in the archive, the list of files in
that directory at the time the archive was created.  This information
is put out in a format that is not easy for humans to read, but which
is unambiguous for a program: each file name is preceded by either a
`Y' if the file is present in the archive, an `N' if the file is not
included in the archive, or a `D' if the file is a directory (and is
included in the archive).  Each file name is terminated by a null
character.  The last file is followed by an additional null and a
newline to indicate the end of the data.

   If the `--incremental' (`-G') option is used with `--extract'
(`--get', `-x'), then when the entry for a directory is found, all
files that currently exist in that directory but are not listed in the
archive *are deleted from the directory*.

   This behavior is convenient when you are restoring a damaged file
system from a succession of incremental backups: it restores the entire
state of the file system to that which obtained when the backup was
made.  If you don't use `--incremental' (`-G'), the file system will
probably fill up with files that shouldn't exist any more.

   `--listed-incremental=SNAPSHOT-FILE' (`-g SNAPSHOT-FILE') handles
new GNU-format incremental backup.

   `--listed-incremental=SNAPSHOT-FILE' (`-g SNAPSHOT-FILE') acts like
`--incremental' (`-G'), but when used in conjunction with `--create'
(`-c') will also cause `tar' to use the file FILE, which contains
information about the state of the filesystem at the time of the last
backup, to decide which files to include in the archive being created.
That file will then be updated by `tar'.  If the file FILE does not
exist when this option is specified, `tar' will create it, and include
all appropriate files in the archive.

   The file, which is archive independent, contains the date it was last
modified and a list of devices, inode numbers and directory names.
`tar' will archive files with newer mod dates or inode change times,
and directories with an unchanged inode number and device but a changed
directory name.  The file is updated after the files to be archived are
determined, but before the new archive is actually created.

   When restoring, only files newer than the saved time are restored,
and the directory list is used to speed up subcommands.

   GNU `tar' actually writes the file twice: once before the data and
written, and once after.


File: tar.info,  Node: Inc Dumps,  Next: incremental and listed-incremental,  Prev: Full Dumps,  Up: Backups

Using `tar' to Perform Incremental Dumps
========================================

     *(This message will disappear, once this node revised.)*

   Performing incremental dumps is similar to performing full dumps,
although a few more options will usually be needed.

   You will need to use the `-N DATE' option to tell `tar' to only
store files that have been modified since DATE.  DATE should be the
date and time of the last full/incremental dump.  *Note after::.

   A standard scheme is to do a *monthly* (full) dump once a month, a
*weekly* dump once a week of everything since the last monthly and a
*daily* dump every day of everything since the last (weekly or monthly)
dump.

   Here is a copy of the script used to dump the filesystems of the
machines here at the Free Software Foundation.  This script is run via
`cron' late at night when people are least likely to be using the
machines.  This script dumps several filesystems from several machines
at once (via NFS).  The operator is responsible for ensuring that all
the machines will be up at the time the dump happens.  If a machine is
not running, its files will not be dumped, and the next day's
incremental dump will *not* store files that would have gone onto that
dump.

     #!/bin/csh
     # Dump thingie
     set now = `date`
     set then = `cat date.nfs.dump`
     /u/hack/bin/tar -c -G -v\
      -f /dev/rtu20\
      -b 126\
      -N "$then"\
      -V "Dump from $then to $now"\
      /alpha-bits/gp\
      /gnu/hack\
      /hobbes/u\
      /spiff/u\
      /sugar-bombs/u
     echo $now > date.nfs.dump
     mt -f /dev/rtu20 rew

   Output from this script is stored in a file, for the operator to
read later.

   This script uses the file `date.nfs.dump' to store the date/time of
the last dump.

   Since this is a streaming tape drive, no attempt to verify the
archive is done.  This is also why the high blocking factor (126) is
used.  The tape drive must also be rewound by the `mt' command after
the dump is made.


File: tar.info,  Node: incremental and listed-incremental,  Next: Backup Levels,  Prev: Inc Dumps,  Up: Backups

The Incremental Options
=======================

     *(This message will disappear, once this node revised.)*

   `--incremental' (`-G') is used in conjunction with `--create' (`-c'),
`--extract' (`--get', `-x') or `--list' (`-t') when backing up and
restoring file systems.  An archive cannot be extracted or listed with
the `--incremental' (`-G') option specified unless it was created with
this option specified.  This option should only be used by a script,
not by the user, and is usually disregarded in favor of
`--listed-incremental=SNAPSHOT-FILE' (`-g SNAPSHOT-FILE'), which is
described below.

   `--incremental' (`-G') in conjunction with `--create' (`-c') causes
`tar' to write, at the beginning of the archive, an entry for each of
the directories that will be archived.  The entry for a directory
includes a list of all the files in the directory at the time the
archive was created and a flag for each file indicating whether or not
the file is going to be put in the archive.

   Note that this option causes `tar' to create a non-standard archive
that may not be readable by non-GNU versions of the `tar' program.

   `--incremental' (`-G') in conjunction with `--extract' (`--get',
`-x') causes `tar' to read the lists of directory contents previously
stored in the archive, *delete* files in the file system that did *not*
exist in their directories when the archive was created, and then
extract the files in the archive.

   This behavior is convenient when restoring a damaged file system from
a succession of incremental backups: it restores the entire state of
the file system to that which obtained when the backup was made.  If
`--incremental' (`-G') isn't specified, the file system will probably
fill up with files that shouldn't exist any more.

   `--incremental' (`-G') in conjunction with `--list' (`-t'), causes
`tar' to print, for each directory in the archive, the list of files in
that directory at the time the archive was created.  This information
is put out in a format that is not easy for humans to read, but which
is unambiguous for a program: each file name is preceded by either a
`Y' if the file is present in the archive, an `N' if the file is not
included in the archive, or a `D' if the file is a directory (and is
included in the archive).  Each file name is terminated by a null
character.  The last file is followed by an additional null and a
newline to indicate the end of the data.

   `--listed-incremental=SNAPSHOT-FILE' (`-g SNAPSHOT-FILE') acts like
`--incremental' (`-G'), but when used in conjunction with `--create'
(`-c') will also cause `tar' to use the file SNAPSHOT-FILE, which
contains information about the state of the file system at the time of
the last backup, to decide which files to include in the archive being
created.  That file will then be updated by `tar'.  If the file FILE
does not exist when this option is specified, `tar' will create it, and
include all appropriate files in the archive.

   The file FILE, which is archive independent, contains the date it
was last modified and a list of devices, inode numbers and directory
names.  `tar' will archive files with newer mod dates or inode change
times, and directories with an unchanged inode number and device but a
changed directory name.  The file is updated after the files to be
archived are determined, but before the new archive is actually created.

   Althought it should be obvious that a device has a non-volatile
value, NFS devices have non-dependable values when an automounter gets
in the picture.  This leads to a great deal of spurious redumping in
incremental dumps, so it is somewhat useless to compare two NFS devices
numbers over time.  So `tar' now considers all NFS devices as being
equal when it comes to comparing directories; this is fairly gross, but
there does not seem to be a better way to go.


File: tar.info,  Node: Backup Levels,  Next: Backup Parameters,  Prev: incremental and listed-incremental,  Up: Backups

Levels of Backups
=================

     *(This message will disappear, once this node revised.)*

   An archive containing all the files in the file system is called a
"full backup" or "full dump".  You could insure your data by creating a
full dump every day.  This strategy, however, would waste a substantial
amount of archive media and user time, as unchanged files are daily
re-archived.

   It is more efficient to do a full dump only occasionally.  To back up
files between full dumps, you can do an incremental dump.  A "level
one" dump archives all the files that have changed since the last full
dump.

   A typical dump strategy would be to perform a full dump once a week,
and a level one dump once a day.  This means some versions of files
will in fact be archived more than once, but this dump strategy makes
it possible to restore a file system to within one day of accuracy by
only extracting two archives--the last weekly (full) dump and the last
daily (level one) dump.  The only information lost would be in files
changed or created since the last daily backup.  (Doing dumps more than
once a day is usually not worth the trouble).

   GNU `tar' comes with scripts you can use to do full and level-one
dumps.  Using scripts (shell programs) to perform backups and
restoration is a convenient and reliable alternative to typing out file
name lists and `tar' commands by hand.

   Before you use these scripts, you need to edit the file
`backup-specs', which specifies parameters used by the backup scripts
and by the restore script.    *Note Script Syntax::.  Once the backup
parameters are set, you can perform backups or restoration by running
the appropriate script.

   The name of the restore script is `restore'.    The names of the
level one and full backup scripts are, respectively, `level-1' and
`level-0'.  The `level-0' script also exists under the name `weekly',
and the `level-1' under the name `daily'--these additional names can be
changed according to your backup schedule.  *Note Scripted
Restoration::, for more information on running the restoration script.
*Note Scripted Backups::, for more information on running the backup
scripts.

   *Please Note:* The backup scripts and the restoration scripts are
designed to be used together.  While it is possible to restore files by
hand from an archive which was created using a backup script, and to
create an archive by hand which could then be extracted using the
restore script, it is easier to use the scripts.   *Note Inc Dumps::,
and *Note Inc Dumps::, before making such an attempt.


File: tar.info,  Node: Backup Parameters,  Next: Scripted Backups,  Prev: Backup Levels,  Up: Backups

Setting Parameters for Backups and Restoration
==============================================

     *(This message will disappear, once this node revised.)*

   The file `backup-specs' specifies backup parameters for the backup
and restoration scripts provided with `tar'.  You must edit
`backup-specs' to fit your system configuration and schedule before
using these scripts.

   *Note Script Syntax::, for an explanation of this syntax.

   `backup-specs' specifies the following parameters:

`ADMINISTRATOR'
     The user name of the backup administrator.

`BACKUP_HOUR'
     The hour at which the backups are done.  This can be a number from
     0 to 23, or the string `now'.

`TAPE_FILE'
     The device `tar' writes the archive to.  This device should be
     attached to the host on which the dump scripts are run.

`TAPE_STATUS'
     The command to use to obtain the status of the archive device,
     including error count.  On some tape drives there may not be such a
     command; in that case, simply use `TAPE_STATUS=false'.

`BLOCKING'
     The blocking factor `tar' will use when writing the dump archive.
     *Note Blocking Factor::.

`BACKUP_DIRS'
     A list of file systems to be dumped.  You can include any directory
     name in the list--subdirectories on that file system will be
     included, regardless of how they may look to other networked
     machines.  Subdirectories on other file systems will be ignored.

`HOST_NAME'
     The host name specifies which host to run `tar' on, and should
     normally be the host that actually contains the file system.
     However, the host machine must have GNU `tar' installed, and must
     be able to access the directory containing the backup scripts and
     their support files using the same file name that is used on the
     machine where the scripts are run (i.e. what `pwd' will print when
     in that directory on that machine).  If the host that contains the
     file system does not have this capability, you can specify another
     host as long as it can access the file system through NFS.

`BACKUP_FILES'
     A list of individual files to be dumped.  These should be
     accessible from the machine on which the backup script is run.

* Menu:

* backup-specs example::        An Example Text of `Backup-specs'
* Script Syntax::               Syntax for `Backup-specs'


File: tar.info,  Node: backup-specs example,  Next: Script Syntax,  Prev: Backup Parameters,  Up: Backup Parameters

An Example Text of `Backup-specs'
---------------------------------

     *(This message will disappear, once this node revised.)*

   The following is the text of `backup-specs' as it appears at FSF:

     # site-specific parameters for file system backup.
     
     ADMINISTRATOR=friedman
     BACKUP_HOUR=1
     TAPE_FILE=/dev/nrsmt0
     TAPE_STATUS="mts -t $TAPE_FILE"
     BLOCKING=124
     BACKUP_DIRS="
     	albert:/fs/fsf
     	apple-gunkies:/gd
     	albert:/fs/gd2
     	albert:/fs/gp
     	geech:/usr/jla
     	churchy:/usr/roland
     	albert:/
     	albert:/usr
     	apple-gunkies:/
     	apple-gunkies:/usr
     	gnu:/hack
     	gnu:/u
     	apple-gunkies:/com/mailer/gnu
     	apple-gunkies:/com/archive/gnu"
     
     BACKUP_FILES="/com/mailer/aliases /com/mailer/league*[a-z]"


File: tar.info,  Node: Script Syntax,  Prev: backup-specs example,  Up: Backup Parameters

Syntax for `Backup-specs'
-------------------------

     *(This message will disappear, once this node revised.)*

   `backup-specs' is in shell script syntax.  The following conventions
should be considered when editing the script:

   A quoted string is considered to be contiguous, even if it is on more
than one line.  Therefore, you cannot include commented-out lines
within a multi-line quoted string.  BACKUP_FILES and BACKUP_DIRS are
the two most likely parameters to be multi-line.

   A quoted string typically cannot contain wildcards.  In
`backup-specs', however, the parameters BACKUP_DIRS and BACKUP_FILES
can contain wildcards.


File: tar.info,  Node: Scripted Backups,  Next: Scripted Restoration,  Prev: Backup Parameters,  Up: Backups

Using the Backup Scripts
========================

     *(This message will disappear, once this node revised.)*

   The syntax for running a backup script is:

     `script-name' [TIME-TO-BE-RUN]

   where TIME-TO-BE-RUN can be a specific system time, or can be `now'.
If you do not specify a time, the script runs at the time specified in
`backup-specs' (*note Script Syntax::.).

   You should start a script with a tape or disk mounted.  Once you
start a script, it prompts you for new tapes or disks as it needs them.
Media volumes don't have to correspond to archive files--a
multi-volume archive can be started in the middle of a tape that
already contains the end of another multi-volume archive.  The
`restore' script prompts for media by its archive volume, so to avoid
an error message you should keep track of which tape (or disk) contains
which volume of the archive.    *Note Scripted Restoration::.

   The backup scripts write two files on the file system.  The first is
a record file in `/etc/tar-backup/', which is used by the scripts to
store and retrieve information about which files were dumped.  This
file is not meant to be read by humans, and should not be deleted by
them.  *Note incremental and listed-incremental::, for a more detailed
explanation of this file.

   The second file is a log file containing the names of the file
systems and files dumped, the time when the backup was made, and any
error messages that were generated, as well as how much space was left
in the media volume after the last volume of the archive was written.
You should check this log file after every backup.  The file name is
`log-MMM-DDD-YYYY-level-1' or `log-MMM-DDD-YYYY-full'.

   The script also prints the name of each system being dumped to the
standard output.


File: tar.info,  Node: Scripted Restoration,  Prev: Scripted Backups,  Up: Backups

Using the Restore Script
========================

     *(This message will disappear, once this node revised.)*

     *Warning:* The GNU `tar' distribution does *not* provide any such
     `restore' script yet.  This section is only listed here for
     documentation maintenance purposes.  In any case, all contents is
     subject to change as things develop.

   To restore files that were archived using a scripted backup, use the
`restore' script.  The syntax for the script is:

   where ***** are the file systems to restore from, and ***** is a
regular expression which specifies which files to restore.  If you
specify -all, the script restores all the files in the file system.

   You should start the restore script with the media containing the
first volume of the archive mounted.  The script will prompt for other
volumes as they are needed.  If the archive is on tape, you don't need
to rewind the tape to to its beginning--if the tape head is positioned
past the beginning of the archive, the script will rewind the tape as
needed.  *Note Media::, for a discussion of tape positioning.

   If you specify `--all' as the FILES argument, the `restore' script
extracts all the files in the archived file system into the active file
system.

     *Warning:* The script will delete files from the active file
     system if they were not in the file system when the archive was
     made.

   *Note Inc Dumps::, and *Note Inc Dumps::, for an explanation of how
the script makes that determination.


File: tar.info,  Node: Choosing,  Next: Date input formats,  Prev: Backups,  Up: Top

Choosing Files and Names for `tar'
**********************************

     *(This message will disappear, once this node revised.)*

   Certain options to `tar' enable you to specify a name for your
archive.  Other options let you decide which files to include or exclude
from the archive, based on when or whether files were modified, whether
the file names do or don't match specified patterns, or whether files
are in specified directories.

* Menu:

* file::                        Choosing the Archive's Name
* Selecting Archive Members::
* files::                       Reading Names from a File
* exclude::                     Excluding Some Files
* Wildcards::
* after::                       Operating Only on New Files
* recurse::                     Descending into Directories
* one::                         Crossing Filesystem Boundaries


File: tar.info,  Node: file,  Next: Selecting Archive Members,  Prev: Choosing,  Up: Choosing

Choosing and Naming Archive Files
=================================

     *(This message will disappear, once this node revised.)*

   By default, `tar' uses an archive file name that was compiled into
it when `tar' was built on the system; usually this name refers to some
physical tape drive on the machine.  Later versions of GNU `tar' use
standard output as the default archive file name (wich you can redirect
to another file).  However, the person who installed `tar' on the
system may not set the default to a meaningful value as far as most
users are concerned.  As a result, you will usually want to tell `tar'
where to find (or create) the archive.  The `--file=ARCHIVE-NAME' (`-f
ARCHIVE-NAME') option allows you to either specify or name a file to
use as the archive instead of the default archive file location.

`--file=ARCHIVE-NAME'
`-f ARCHIVE-NAME'
     Name the archive to create or operate on.  Use in conjunction with
     any subcommand.

   For example, in this `tar' command,

     $ tar -cvf collection.tar blues folk jazz

`collection.tar' is the name of the archive.  It must directly follow
the `-f' option, since whatever directly follows `-f' *will* end up
naming the archive.  If you neglect to specify an archive name, you may
end up overwriting a file in the working directory with the archive you
create since `tar' will use this file's name for the archive name.

   An archive can be saved as a file in the file system, sent through a
pipe or over a network, or written to an I/O device such as a tape,
floppy disk, or CD write drive.

   If you do not name the archive, `tar' uses the value of the
environment variable `TAPE' as the file name for the archive.  If that
is not available, `tar' uses a default, compiled-in archive name,
usually that for tape unit zero (ie. `/dev/tu00'), or the standard
output.  `tar' always needs an archive name.

   If you use `-' as an ARCHIVE-NAME, `tar' reads the archive from
standard input (when listing or extracting files), or writes it to
standard output (when creating an archive).  If you use `-' as an
ARCHIVE-NAME when modifying an archive, `tar' reads the original
archive from its standard input and writes the entire new archive to
its standard output.

   To specify an archive file on a device attached to a remote machine,
use the following:

     --file=HOSTNAME:/DEV/FILE NAME

`tar' will initiate the remote connection, if possible, and prompt you
for a username and password.  If you use
`--file=USER@HOSTNAME:/DEV/FILE NAME', `tar' will initiate the remote
connection, if possible, using your username as the username on the
remote machine.

   If the archive file name includes a colon (`:'), then it is assumed
to be a file on another machine.  If the archive file is
`USER@HOST:FILE', then FILE is used on the host HOST.  The remote host
is accessed using the `rsh' program, with a username of USER.  If the
username is omitted (along with the `@' sign), then your user name will
be used.  (This is the normal `rsh' behavior.)  It is necessary for the
remote machine, in addition to permitting your `rsh' access, to have
the `/usr/ucb/rmt' program installed.  If you need to use a file whose
name includes a colon, then the remote tape drive behavior can be
inhibited by using the `--force-local' option.

   The MS-DOS/MS-Windows version of `tar' makes an exception to the
above: it does *not* treat archive names with drive letters, such as
`d:/backups/dayly.tar', as remote.  This is so you would not be forced
to use `--force-local' with the usual DOS-style absolute file names.
`tar' only makes this exception when the colon is preceded by a single
character in the range `[A-z]', which are valid MS-DOS/MS-Windows drive
letters.  (Yes, DOS also allows the drive letter to be one of the 6
characters between uppercase `Z' and lowercase `a'.)  This means that
remote machines with single-letter names are effectively disallowed by
the MS-DOS version of `tar'.  However, we find it hard to believe that
anybody will use a one-letter name for a machine.  (And as of now,
`tar' doesn't support remote access on MS-DOS anyway.)

   When the archive is being created to `/dev/null', GNU `tar' tries to
minimize input and output subcommands.  The Amanda backup system, when
used with GNU `tar', has an initial sizing pass which uses this feature.


File: tar.info,  Node: Selecting Archive Members,  Next: files,  Prev: file,  Up: Choosing

Selecting Archive Members
=========================

   "File Name arguments" specify which files in the file system `tar'
operates on, when creating or adding to an archive, or which archive
members `tar' operates on, when reading or deleting from an archive.  .

   To specify file names, you can include them as the last arguments on
the command line, as follows:
     tar SUBCOMMAND [OPTION1 OPTION2 ...] [FILE NAME-1 FILE NAME-2 ...]

   If you specify a directory name as a file name argument, all the
files in that directory are operated on by `tar'.

   If you do not specify files when `tar' is invoked with `--create'
(`-c'), `tar' operates on all the non-directory files in the working
directory.  If you specify either `--list' (`-t') or `--extract'
(`--get', `-x'), `tar' operates on all the archive members in the
archive.  If you specify any subcommand other than one of these three,
`tar' does nothing.

   By default, `tar' takes file names from the command line.  However,
there are other ways to specify file or member names, or to modify the
manner in which `tar' selects the files or members upon which to
operate; *Note files::; see *Note exclude::.  In general, these methods
work both for specifying the names of files and archive members.


File: tar.info,  Node: files,  Next: exclude,  Prev: Selecting Archive Members,  Up: Choosing

Reading Names from a File
=========================

     *(This message will disappear, once this node revised.)*

   Instead of giving the names of files or archive members on the
command line, you can put the names into a file, and then use the
`--files-from=FILE-OF-NAMES' (`-T FILE-OF-NAMES') option to `tar'.
Give the name of the file which contains the list of files to include
as the argument to `--files-from'.  In the list, the file names should
be separated by newlines.  You will frequently use this option when you
have generated the list of files to archive with the `find' utility.

`--files-from=FILE NAME'
`-T FILE NAME'
     Get names to extract or create from file FILE NAME.

   If you give a single dash as a file name for `--files-from', (i.e.,
you specify either `--files-from=-' or `-T -'), then the file names are
read from standard input.

   Unless you are running `tar' with `--create', you can not use both
`--files-from=-' and `--file=-' (`-f -') in the same command.

   The following example shows how to use `find' to generate a list of
files smaller than 400K in length and put that list into a file called
`small-files'.  You can then use the `-T' option to `tar' to specify
the files from that file, `small-files', to create the archive
`little.tgz'.  (The `-z' option to `tar' compresses the archive with
`gzip'; *note gzip::. for more information.)

     $ find . ! -type d -size -400 -print > small-files
     $ tar -c -v -z -T small-files -f little.tgz

The `! -type d' predicate is needed so that `find' won't print the name
`.' directory itself, if it happens to be small in size.  If `find'
were to print the name of `.', all of the files in the current
directory would end up in the archive, in addition to the files that
are smaller than 400KB!

* Menu:

* nul::


File: tar.info,  Node: nul,  Prev: files,  Up: files

`NUL' Terminated File Names
---------------------------

   The `--null' option causes `--files-from=FILE-OF-NAMES' (`-T
FILE-OF-NAMES') to read file names terminated by a `NUL' instead of a
newline, so files whose names contain newlines can be archived using
`--files-from'.

`--null'
     Only consider `NUL' terminated file names, instead of files that
     terminate in a newline.

   The `--null' option is just like the one in GNU `xargs' and `cpio',
and is useful with the `-print0' predicate of GNU `find'.  In `tar',
`--null' also causes `--directory=DIRECTORY' (`-C DIRECTORY') options
to be treated as file names to archive, in case there are any files out
there called `-C'.

   This example shows how to use `find' to generate a list of files
larger than 800K in length and put that list into a file called
`long-files'.  The `-print0' option to `find' works just like `-print',
except that it separates files with a `NUL' rather than with a newline.
You can then run `tar' with both the `--null' and `-T' options to
specify that `tar' get the files from that file, `long-files', to
create the archive `big.tgz'.  The `--null' option to `tar' will cause
`tar' to recognize the `NUL' separator between files.

     $ find . ! -type d -size +800 -print0 > long-files
     $ tar -c -v --null --files-from=long-files --file=big.tar

Again, you need the `! -type d' predicate to prevent `find' from
printing the `.' directory name, which would have caused `tar' to
include the entire directory in the archive.


File: tar.info,  Node: exclude,  Next: Wildcards,  Prev: files,  Up: Choosing

Excluding Some Files
====================

     *(This message will disappear, once this node revised.)*

   To avoid operating on files whose names match a particular pattern,
use the `--exclude=PATTERN' or `--exclude-from=FILE-OF-PATTERNS' (`-X
FILE-OF-PATTERNS') options.

`--exclude=PATTERN'
     Causes `tar' to ignore files that match the PATTERN.

   The `--exclude=PATTERN' option will prevent any file or member which
matches the shell wildcards (PATTERN) from being operated on (PATTERN
can be a single file name or a more complex expression).  For example,
if you want to create an archive with all the contents of `/tmp' except
the file `/tmp/foo', you can use the command `tar --create
--file=arch.tar --exclude=foo'.  You may give multiple `--exclude'
options.

`--exclude-from=FILE'
`-X FILE'
     Causes `tar' to ignore files that match the patterns listed in
     FILE.

   Use the `--exclude-from=FILE-OF-PATTERNS' option to read a list of
shell wildcards, one per line, from FILE; `tar' will ignore files
matching those wildcards.  Thus if `tar' is called as `tar -c -X foo .'
and the file `foo' contains a single line `*.o', no files whose names
end in `.o' will be added to the archive.

* Menu:

* problems with exclude::


File: tar.info,  Node: problems with exclude,  Prev: exclude,  Up: exclude

Problems with Using the `exclude' Options
-----------------------------------------

   Some users find `exclude' options confusing.  Here are some common
pitfalls:

   * The main operating mode of `tar' will always act on file names
     listed on the command line, no matter whether or not there is an
     exclusion which would otherwise affect them.  In the example
     above, if you create an archive and exclude files that end with
     `*.o', but explicitly name the file `catc.o' after all the options
     have been listed, `catc.o' *will* be included in the archive.

   * You can sometimes confuse the meanings of `--exclude=PATTERN' and
     `--exclude-from=FILE-OF-PATTERNS' (`-X FILE-OF-PATTERNS').  Be
     careful: use `--exclude=PATTERN' when files to be excluded are
     given as a pattern on the command line.  Use
     `--exclude-from=FILE-OF-PATTERNS' to introduce the name of a file
     which contains a list of patterns, one per line; each of these
     patterns can exclude zero, one, or many files.

   * When you use `--exclude=PATTERN', be sure to quote the PATTERN
     parameter, so GNU `tar' sees wildcard characters like `*'.  If you
     do not do this, the shell might expand the `*' itself using files
     at hand, so `tar' might receive a list of files instead of one
     pattern, or none at all, making the command somewhat illegal.
     This might not correspond to what you want.

     For example, write:

          $ tar -c -f ARCHIVE.TAR -X '*/tmp/*' DIRECTORY

     rather than:

          $ tar -c -f ARCHIVE.TAR -X */tmp/* DIRECTORY

   * You must use use shell syntax, or globbing, rather than `regexp'
     syntax, when using exclude options in `tar'.  If you try to use
     `regexp' syntax to describe files to be excluded, your command
     might fail.  *Note Wildcards::.

   * In earlier versions of `tar', what is now the
     `--exclude-from=FILE-OF-PATTERNS' option was called
     `--exclude-PATTERN' instead.  Now, `--exclude=PATTERN' applies to
     patterns listed on the command line and
     `--exclude-from=FILE-OF-PATTERNS' applies to patterns listed in a
     file.


File: tar.info,  Node: Wildcards,  Next: after,  Prev: exclude,  Up: Choosing

Wildcards Patterns and Matching
===============================

   "Globbing" is the operation by which "wildcard" characters, `*' or
`?' for example, are replaced and expanded into all existing files
matching the given pattern.  However, `tar' often uses wildcard
patterns for matching (or globbing) archive members instead of actual
files in the filesystem.  Wildcard patterns are also used for verifying
volume labels of `tar' archives.  This section has the purpose of
explaining wildcard syntax for `tar'.

   A PATTERN should be written according to shell syntax, using wildcard
characters to effect globbing.  Most characters in the pattern stand
for themselves in the matched string, and case is significant: `a' will
match only `a', and not `A'.  The character `?' in the pattern matches
any single character in the matched string.  The character `*' in the
pattern matches zero, one, or more single characters in the matched
string.  The character `\' says to take the following character of the
pattern *literally*; it is useful when one needs to match the `?', `*',
`[' or `\' characters, themselves.

   The character `[', up to the matching `]', introduces a "character
class".  A character class is a list of acceptable characters for the
next single character of the matched string.  For example, `[abcde]'
would match any of the first five letters of the alphabet.  Note that
within a character class, all of the "special characters" listed above
other than `\' lose their special meaning; for example, `[-\\[*?]]'
would match any of the characters, `-', `\', `[', `*', `?', or `]'.
(Due to parsing constraints, the characters `-' and `]' must either
come *first* or *last* in a character class.)

   If the first character of the class after the opening `[' is `!' or
`^', then the meaning of the class is reversed.  Rather than listing
character to match, it lists those characters which are *forbidden* as
the next single character of the matched string.

   Other characters of the class stand for themselves.  The special
construction `[A-E]', using an hyphen between two letters, is meant to
represent all characters between A and E, inclusive.

   Periods (`.') or forward slashes (`/') are not considered special
for wildcard matches.  However, if a pattern completely matches a
directory prefix of a matched string, then it matches the full matched
string: excluding a directory also excludes all the files beneath it.

   There are some discussions floating in the air and asking for
modifications in the way GNU `tar' accomplishes wildcard matches.  We
perceive any change of semantics in this area as a delicate thing to
impose on GNU `tar' users.  On the other hand, the GNU project should be
progressive enough to correct any ill design: compatibility at all price
is not always a good attitude.  In conclusion, it is *possible* that
slight amendments be later brought to the previous description.  Your
opinions on the matter are welcome.

