/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* Test of env_**stuff() */
#include <stdio.h>
#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#endif
#define SUPPL_DBG_HEAP
#define SUPPL_LOG_MEMORY
#define SUPPL_LOG_FUNCTION
#include "suppldbg.h"

#include "environ.h"
#include "dfn.h"
#include "mcb.h"

#define VAR "SK"
#define VAL1 "new variable"
#define VAL2 "change contents"

void hlpScreen()
{	exit(127);
}

int dispEnv(void *arg, word env, word offset)
{	unsigned char far *p;
	int *cnt;

	cnt = arg;
	p = MK_FP(env, offset);
	printf("%3u: ", ++*cnt);
	while(*p)
		putchar(*p++);
	putchar('\n');
	return 0;
}

main(int argc, char **argv)
{	word segm;
	int cnt;
	char *p;
	word newsegm;

	/** The DBG_ENTER() macro is used in its broken up format
		in order to have the opening of "main" to be logged **/
	DBG_ENTER1
		/* log everything incl. SUPPL library */
	DBG_CHANGE_STATE("l+;C+,+SUPPL")
	DBG_ENTER2("main", "usr")
	openlog("T", 0, 0);					/* memory logger */

	clrscr();

	chkHeap


	/* Fetch this program's shell's environment */
	if((segm = env_shell()) == 0) {
		puts("Failed to get environment of program's shell");
		if((segm = mcb_shell(_psp)) == 0) {
			puts("Failed to identify program's shell at all");
			puts("Possible memory corruption!");
			DBG_RETURN_I(40)
		}
		printf("shell's location is: 0x%04x\n", segm);
		puts("Probably the shell had discarded its environment");
		DBG_RETURN_I(30)
	}
	printf("Environment of current-most launched shell:\nSegment: 0x%04x\n"
	 , segm);


	chkHeap

	switch(env_check(segm)) {
	case 0: goto proceed;
	case 1: puts("No environment at all"); break;
	case 2: puts("Corrupt MCB"); break;
	case 3: puts("variable space corrupted"); break;
	case 4: puts("no string table"); break;
	case 5: puts("string table corrupted"); break;
	default: puts("Unkown env_check() error"); break;
	}
	segm = env_glbSeg;
	if(!segm) {
		puts("Failed to get my environment");
		DBG_RETURN_I( 51)
	}
	printf("Switching to my own environment for tests: 0x%04x\n", segm);
	switch(env_check(segm)) {
	case 0: goto proceed;
	case 1: puts("No environment at all"); break;
	case 2: puts("Corrupt MCB"); break;
	case 3: puts("variable space corrupted"); break;
	case 4: puts("no string table"); break;
	case 5: puts("string table corrupted"); break;
	default: puts("Unkown env_check() error"); break;
	}
	DBG_RETURN_I( 52)

proceed:
	cnt = 0;
	env_forAll(segm, dispEnv, &cnt);

	/* Try to set variable */
	puts("execute (add new envvar): SET " VAR "=" VAL1);
	switch(env_change(segm, VAR, VAL1)) {
	case 0: puts("Cannot insert variable"); break;
	case 1: puts("variable replaced or deleted"); break;
	case 2: puts("variable not found (could not delete)"); break;
	case 3: puts("variable newly inserted"); break;
	case 4: puts("no environment at all"); break;
	case -1: puts("Argument value error"); break;
	default: puts("Unknown error"); break;
	}
	chkHeap
	if((p = env_dupvar(segm, VAR)) == NULL)
		puts("Failed to retreive environment variable " VAR);
	else {
		if(strcmp(p, VAL1))
			puts("The retreived contents of "  VAR " does not match.");
		free(p);
	}
	chkHeap
	puts("execute (change existing envvar): SET " VAR "=" VAL2);
	switch(env_change(segm, VAR, VAL2)) {
	case 0: puts("Cannot insert variable"); break;
	case 1: puts("variable replaced or deleted"); break;
	case 2: puts("variable not found (could not delete)"); break;
	case 3: puts("variable newly inserted"); break;
	case 4: puts("no environment at all"); break;
	case -1: puts("Argument value error"); break;
	default: puts("Unknown error"); break;
	}
	chkHeap
	if((p = env_dupvar(segm, VAR)) == NULL)
		puts("Failed to retreive environment variable " VAR);
	else {
		if(strcmp(p, VAL2))
			puts("The retreived contents of " VAR " does not match.");
		free(p);
	}

	puts("Trying to resize my default/global environment");
	env_resizeCtrl |= ENV_ALLOWMOVE;
	env_setDfltSeg(env_glbSeg);		/* so both will be relocated */
	segm = env_dfltSeg;
	if(segm != env_glbSeg) {
		puts("default and global segments does not match");
		DBG_RETURN_I(52)
	}
		/* The "0" forces the segments to be relocated */
	cnt = 0;
	do {
		++cnt;
		newsegm = env_resize(0, 15);
	} while(newsegm == segm);
	printf("Number of resizes: %d\n", cnt);
	if(!newsegm) {
		puts("Segment was not resized");
		if(env_check(segm) != 0) {
			puts("My segment is corrupted now");
			DBG_RETURN_I(54)
		}
	} else {
		printf("Segment relocated from 0x%04x to 0x%04x\n", segm, newsegm);
		cnt = 0;
		if(newsegm != env_glbSeg) {
			cnt = 1;
			puts("Global segment had not changed");
		}
		if(newsegm != env_dfltSeg) {
			cnt = 1;
			puts("Default segment had not changed");
		}
		if(env_check(newsegm) != 0) {
			cnt = 1;
			puts("My environment is corrupted now");
		}
		if(cnt)
			DBG_RETURN_I(55)
	}

	chkHeap
	DBG_RETURN_I(0)
}
