/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:45:00 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PushbackReader;
import java.io.StringReader;
import java.io.Writer;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class FastaStreamSequence_ESTest extends FastaStreamSequence_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("qYjl}I");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(emblStreamSequence0);
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = null;
      try {
        fastaStreamSequence0 = new FastaStreamSequence((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      PushbackReader pushbackReader0 = new PushbackReader(pipedReader0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pushbackReader0);
      FastaStreamSequence fastaStreamSequence0 = null;
      try {
        fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = null;
      try {
        fastaStreamSequence0 = new FastaStreamSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = null;
      try {
        fastaStreamSequence0 = new FastaStreamSequence((String) null, (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = null;
      try {
        fastaStreamSequence0 = new FastaStreamSequence((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("qYjl}I");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(emblStreamSequence0);
      CharArrayWriter charArrayWriter0 = new CharArrayWriter();
      fastaStreamSequence0.writeToStream(charArrayWriter0);
      assertEquals("nnnnnnn\n", charArrayWriter0.toString());
      assertEquals(8, charArrayWriter0.size());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("\n", "\n");
      // Undeclared exception!
      try { 
        fastaStreamSequence0.writeToStream((Writer) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.FastaStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      StringReader stringReader0 = new StringReader(">");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      int int0 = fastaStreamSequence0.getFormatType();
      assertEquals(4, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      char[] charArray0 = new char[7];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(linePushBackReader0);
      StreamSequence streamSequence0 = fastaStreamSequence0.copy();
      assertEquals(0, streamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Hl;pWOcp4kzjQ/");
      assertEquals(15, fastaStreamSequence0.length());
  }
}
