var count = (function mod(BigNumber) {
    var start = +new Date(),
        log,
        error,
        undefined,
        passed = 0,
        total = 0,
        n = 'null',
        N = 'NaN',
        I = 'Infinity';

    if (typeof window === 'undefined') {
        log = console.log;
        error = console.error;
    } else {
        log = function (str) { document.body.innerHTML += str.replace('\n', '<br>') };
        error = function (str) { document.body.innerHTML += '<div style="color: red">' +
          str.replace('\n', '<br>') + '</div>' };
    }

    if (!BigNumber && typeof require === 'function') BigNumber = require('../bignumber');

    function assert(expected, actual) {
        total++;
        if (expected !== actual) {
           error('\n Test number: ' + total + ' failed');
           error(' Expected: ' + expected);
           error(' Actual:   ' + actual);
           //process.exit();
        }
        else {
            passed++;
            //log('\n Expected and actual: ' + actual);
        }
    }

    function T(a, b, expected) {
        assert(String(expected), String(new BigNumber(a).mod(new BigNumber(b))));
    }

    function isMinusZero(n) {
        return n.toString() === '0' && n.s == -1;
    }

    log('\n Testing mod...');

    BigNumber.config({
        DECIMAL_PLACES : 20,
        ROUNDING_MODE : 4,
        ERRORS : false,
        RANGE : 1E9,
        EXPONENTIAL_AT : [-7, 21]
    });

    T(1, 0, N);
    T(1, -0, N);
    T(-1, 0, N);
    T(-1, -0, N);
    T(1, N, N);
    T(-1, N, N);
    T(1, I, 1);
    T(1, -I, 1);
    T(-1, I, -1);
    T(-1, -I, -1);
    assert(false, isMinusZero(new BigNumber(0).mod(1)));
    assert(false, isMinusZero(new BigNumber(0).mod(-1)));
    assert(true, isMinusZero(new BigNumber(-0).mod(1)));
    assert(true, isMinusZero(new BigNumber(-0).mod(-1)));
    T(0, 0, N);
    T(0, -0, N);
    T(-0, 0, N);
    T(-0, -0, N);
    T(0, N, N);
    T(-0, N, N);
    assert(false, isMinusZero(new BigNumber(0).mod(I)));
    assert(false, isMinusZero(new BigNumber(0).mod(-I)));
    assert(true, isMinusZero(new BigNumber(-0).mod(I)));
    assert(true, isMinusZero(new BigNumber(-0).mod(-I)));
    T(N, 1, N);
    T(N, -1, N);
    T(N, 0, N);
    T(N, -0, N);
    T(N, N, N);
    T(N, I, N);
    T(N, -I, N);
    T(I, 1, N);
    T(I, -1, N);
    T(-I, 1, N);
    T(-I, -1, N);
    T(I, 0, N);
    T(I, -0, N);
    T(-I, 0, N);
    T(-I, -0, N);
    T(I, N, N);
    T(-I, N, N);
    T(I, I, N);
    T(I, -I, N);
    T(-I, I, N);
    T(-I, -I, N);

    T(1, '0', N);
    assert(false, isMinusZero(new BigNumber(1).mod(1)));
    T(1, '-45', '1');
    T(1, '22', '1');
    T(1, 0144, '1');
    T(1, '0144', '1');
    T(1, '6.1915', '1');
    T(1, '-1.02', '1');
    T(1, '-1.02', '1');
    T(1, 2, '1');
    T(1, -2, '1');
    T(-1, 2, '-1');
    T(-1, -2, '-1');

    // Due to Javascript's internal representation of 0.1 the next 4 results
    // match BigDecimal's remainder method, but not Javascript's % operator:
    //
    // 1 % -0.1                                      //  0.09999999999999995
    // new BigNumber(1).mod(-0.1)                       // '0'
    //
    // 0.1.toFixed(18)                               // '0.100000000000000006'
    // new BigNumber(1).mod('-0.100000000000000006')    // '0.099999999999999946'

    T( 1, -0.1, '0');               // JS:   0.09999999999999995
    T(-1, -0.1, '0');               // JS:  -0.09999999999999995
    T( 2, -0.1, '0');               // JS:   0.0999999999999999
    T(-2, -0.1, '0');               // JS:  -0.0999999999999999

    T( 2, -0.5, '0');               // JS:   0
    T(-2, -0.5, '0');               // JS:   0
    T(999.99, -0.99, '0.09');
    T(-999.99, -0.99, '-0.09');
    T(999.99, '3.01', '0.67');
    T(-999.99, '3.01', '-0.67');
    T(1, '0.09', '0.01');
    assert(false, isMinusZero(new BigNumber(1).mod('-0.0001')));
    assert(true, isMinusZero(new BigNumber(-0).mod(1)));
    assert(true, isMinusZero(new BigNumber(-0).mod(0.1)));
    assert(true, isMinusZero(new BigNumber('-0').mod('-1')));
    assert(true, isMinusZero(new BigNumber('-0').mod(Infinity)));
    T(1, '8e5', '1');
    T(1, '9E12', '1');
    assert(false, isMinusZero(new BigNumber(1).mod('1e-14')));
    T(1, '3.345E-9', '6.1e-10');
    T(1, '-345.43e+4', '1');
    T(1, '-94.12E+0', '1');
    T(1, '', N);
    T(1, '    ', N);
    T(1, '\t\t', N);
    T(1, 'ertgrt546', N);
    T(1, 'qweqwdewee', N);
    T(1, true, N);
    T(1, false, N);
    T(1, 'e 4.3', N);
    T(1, '4 .3', N);
    T(1, '4.0 01e', N);
    T(1, ' 4.001', '1');
    T(1, '4.001 ', '1');
    T(1, ' 4.001 ', '1');
    T(1, '    4.001', '1');
    T(1, ' 4.0 01', N);
    T(1, '4. 001', N);
    T(1, '4. 001 ', N);
    T(1, '  4.001e ', N);
    T(1, ' 4 .001 e ', N);
    T(1, undefined, N);
    T(1, null, N);
    T(1, Number.POSITIVE_INFINITY, '1');
    T(1, Number.NEGATIVE_INFINITY, '1');
    T(1, new Date(2012, 11, 4), N);
    T(1, new Object(), N);
    T(1, function () {}, N);
    T('0', 0, N);
    T(0, '+0', N);
    T('0', '0', N);
    T(3, -0, N);
    T(9.654, 0, N);
    T(0, '0.001', '0');
    T(0, '111.1111111110000', '0');
    T(N, '0', N);
    T(-1, 1, '0');
    T(-0.01, 0.01, '0');
    T(54, -54, '0');
    T(9.99, '-9.99', '0');
    T('0.0000023432495704937', '-0.0000023432495704937', '0');
    T(NaN, NaN, N);
    T(NaN, N, N);
    T(N, NaN, N);
    T(N, 4, N);
    T(N, '4534534.45435435', N);
    T(N, 99999.999, N);
    T(Infinity, '354.345341', N);
    T(3, -I, '3');
    T(-Infinity, -I, N);
    T(-I, -Infinity, N);
    T(I, '-999e999', N);
    T('1.21123e43', -I, '1.21123e+43');
    T('-999.0', I, '-999');
    T('657.342e-45', -I, '6.57342e-43');
    T(I, 123, N);
    T(-0, I, '0');
    T(100, 100, '0');
    T('10 ', 4, '2');
    T('03.333', -4, '3.333');
    T(43534.5435, '0.054645', '0.019545');
    T('99999', '1', '0');
    T('3e', 8, N);
    T('-3..0', 13, N);
    T('0 0', -0.4, N);
    T(' +3e0', 4, '3');
    T(9.9806, '+ 1', N);
    T(' +2 0', '1e1', N);
    T('e3', 4, N);
    T(' ', 0, N);
    T(323, null, N);
    T(undefined, undefined, N);
    T('undefined', undefined, N);
    T(null, null, N);

    T('-0.111', '21', '-0.111');
    T('0.000621', '-1', '0.000621');
    T('6.41', '11', '6.41');
    T('21', '11', '10');
    T('1531', '-11', '2');
    T('21', '-0.0161', '0.0056');
    T('-41', '-21', '-20');
    T('31', '-1', '0');
    T('31', '2.21', '0.06');
    T('-842658.56', '-19.52', '-19.2');
    T('-34.871', '-7325043345', '-34.871');
    T('78691958', '49006.018397', '37298.472815');
    T('-11618324684', '621.3', '-394.1');
    T('0', '69.07362125', '0');
    T('0.27474921216', '0.00000000002460017868', '2.224673016e-11');
    T('0', '59137483772', '0');
    T('-0.000000000000000000014634493', '-4.2', '-1.4634493e-20');
    T('-5.470', '-1.8989', '-1.6722');
    T('-95519.5319132', '4.1', '-1.8319132');
    T('43.257', '-4704608304', '43.257');
    T('-32128.403', '68263.11', '-32128.403');
    T('85.4005884', '-0.000000000000000010953667', '4.132633e-18');
    T('3197.909', '-10738864.39', '3197.909');
    T('1.03436722695', '2.6', '1.03436722695');
    T('-4', '-56.36464628', '-4');
    T('92.0618', '-454.866', '92.0618');
    T('-6.147123243', '-53259.9', '-6.147123243');
    T('-3', '-0.4911', '-0.0534');
    T('0', '-12.3', '0');
    T('-0.001713264153', '0.00000000000000000001843605', '-1.36779e-20');
    T('2', '-9325.1665961', '2');
    T('42016273.6500', '-122.861496017', '99.24210634');
    T('35.9', '3867744417', '35.9');
    T('0.000000000000000479760268839', '-209975.082', '4.79760268839e-16');
    T('0.0000000000000000000428713848', '3', '4.28713848e-20');
    T('0.000000000000000104698757876', '-15902.7654', '1.04698757876e-16');
    T('-4', '3124473.52104', '-4');
    T('-9.58', '1.00', '-0.58');
    T('79', '1', '0');
    T('0', '-0.0000000000013618', '0');
    T('1.55', '-31', '1.55');
    T('-2.6', '-13.58133', '-2.6');
    T('0', '90950', '0');
    T('-46.1', '61.8', '-46.1');
    T('-0.00000000000023461', '-0.00000000134', '-2.3461e-13');
    T('-9761.89778', '4645363921.75', '-9761.89778');
    T('0.000000000000000090372203', '0.00000322253', '9.0372203e-17');
    T('-23560577.226', '-0.5304109598', '-0.3270269352');
    T('-11752006.868', '0.003773', '-0.002016');
    T('0.000000036524', '-1.2', '3.6524e-8');
    T('4713.9562', '0.000000000000000000561', '2.23e-19');
    T('-351870798', '28.8', '-1.2');
    T('-4.6', '-0.00000000058', '-4.4e-10');
    T('-21863.82', '4214.9937962', '-788.851019');
    T('-30.221041721', '20401.1', '-30.221041721');
    T('-2.35', '3', '-2.35');
    T('64462', '90.840', '56.44');
    T('46', '433563.55477', '46');
    T('47852501568', '-147426331397', '47852501568');
    T('0', '3812504.1', '0');
    T('0.000000000000142963770', '1210345642.9', '1.4296377e-13');
    T('-0.0024002323743', '-0.000000000000000013220659', '-3.535752e-18');
    T('225.773', '66128.74787', '225.773');
    T('-158.4165', '12.78', '-5.0565');
    T('-21042099137', '10.935', '-4.565');
    T('32791.03', '411590460', '32791.03');
    T('-1984910.86246', '-153845.7', '-138762.46246');
    T('75010460639.6', '-0.00000000005103249', '2.835305e-11');
    T('-0.00000000000000025595509', '25.023', '-2.5595509e-16');
    T('-103052291', '-350.4', '-1.4');
    T('0.00000000000000015307870924', '-0.0000035499', '1.5307870924e-16');
    T('4402230', '122.112', '92.4');
    T('-3073677', '532.95653726', '-116.64962158');
    T('-0.026619162', '-0.00000000000000010', '0');
    T('0.000065666975666', '-6.558', '0.000065666975666');
    T('-3.3', '0.000000000033194405282', '-1.2721464422e-11');
    T('94101.0', '-810285.8180', '94101');
    T('229868', '9654.7078', '7809.7206');
    T('0.000000001926', '-0.00000000000000000005918', '2.562e-20');
    T('67', '0.00000006016496', '2.00248e-8');
    T('0.0000000000000000000832655', '-327907966408', '8.32655e-20');
    T('-1534', '-293318.339', '-1534');
    T('0.00000000000000000511522652', '-1145.46888006', '5.11522652e-18');
    T('0.00000000465574', '707.0', '4.65574e-9');
    T('0.230910067', '-1712.01', '0.230910067');
    T('-31874.7', '-2617976302', '-31874.7');
    T('22.8', '3819', '22.8');
    T('-0.0000015419', '329', '-0.0000015419');
    T('-9176.3441', '741523.991', '-9176.3441');
    T('-5.1103', '-25460.136', '-5.1103');
    T('15232730973', '-2.28', '1.32');
    T('0.081', '-1111.578', '0.081');
    T('3.1', '-42.207', '3.1');
    T('-0.000000000000000433', '0.00000000000000000254528412564', '-3.016986412e-19');
    T('-83943.1', '-4303134750', '-83943.1');
    T('19.825539', '4432543.44', '19.825539');
    T('-2416', '8097.16337', '-2416');
    T('-3.836', '0.00000823841385579', '-0.00000502522549283');
    T('2290356160', '-965232.20', '825381.6');
    T('1.12', '-35806.5278', '1.12');
    T('0', '-0.0000144726783', '0');
    T('-1571629111.33', '6.4736', '-3.8676');
    T('-0.0053778', '1.1', '-0.0053778');
    T('-0.0000013840', '-12.1', '-0.000001384');
    T('-22.9310218204', '-1.6843970', '-1.0338608204');
    T('-71.300', '-25.868806', '-19.562388');
    T('0.02847', '-63397392.02', '0.02847');
    T('-0.0000000000000331096', '0.00000183271', '-3.31096e-14');
    T('-27821115', '-34.83906', '-0.40734');
    T('0.000000000000436294954175', '-2261.01154', '4.36294954175e-13');
    T('45.86441', '-530611.936214', '45.86441');
    T('-1999679428', '0.00000000000000000002297558409', '-5.828173e-23');
    T('-105924.2800', '-426.10612', '-249.96224');
    T('754.9', '-1', '0.9');
    T('0.000000238266109662', '29355.83', '2.38266109662e-7');
    T('25.3', '-0.00000000000000086417416', '5.8408656e-16');
    T('-1261.3', '39.0', '-13.3');
    T('1.017', '-153', '1.017');
    T('27.690', '-21507592', '27.69');
    T('-2623.072516', '3.06', '-0.652516');
    T('91', '13034138.923', '91');
    T('-5212749.21', '-0.00000000000000000001986395', '-2.1827e-21');
    T('117.4212', '-29.978', '27.4872');
    T('-47179.732', '-77504621680', '-47179.732');
    T('0', '-3.7234', '0');
    T('443705716.830', '3024.9575', '1925.7725');
    T('-0.000000000000000000017191196518', '-14.725715414', '-1.7191196518e-20');
    T('30.4', '399719414108', '30.4');
    T('16145.97', '-48642', '16145.97');
    T('2765166', '-18.6825', '6.54');
    T('37.63', '-1284.342', '37.63');
    T('-0.0000000000000000000177845858', '0.0000005860954024', '-1.77845858e-20');
    T('-2.3', '2582.24565000', '-2.3');
    T('16.7', '-0.0000000017369', '1.362e-9');
    T('170180366706', '4626.181', '2388.659');
    T('-1404312.6', '-17000256053', '-1404312.6');
    T('-7603530366', '316.496322753', '-236.943012537');
    T('8', '1.59866', '0.0067');
    T('-4.963', '8.73', '-4.963');
    T('25644160.8', '-5842.06855', '3321.93405');
    T('-4.31384', '-220.2', '-4.31384');
    T('186.9', '-48200.85', '186.9');
    T('5', '57089.99', '5');
    T('-244278052979', '-2', '-1');
    T('8', '-5763.4', '8');
    T('29549', '-1', '0');
    T('-2.0', '-0.00000000000000446955628', '-3.76062704e-15');
    T('737330.9', '-746370915533', '737330.9');
    T('-0.000882183174', '-16.5', '-0.000882183174');
    T('-45', '0.000000001106035', '-7.5858e-10');
    T('-594.06', '-29.85802821', '-26.75746401');
    T('-27.648237', '-1047.5249', '-27.648237');
    T('2', '-739163.624', '2');
    T('544827.1330', '54848981.1', '544827.133');
    T('1', '0.00000000000076553', '2.9959e-13');
    T('-10.89', '0.000000000000000000047', '-5e-21');
    T('-3052.938', '9327.5819201', '-3052.938');
    T('-24.1', '127758.429', '-24.1');
    T('3.9', '12173.38', '3.9');
    T('0.0000000000000213926861909', '-77.4', '2.13926861909e-14');
    T('-90173804.260', '-5062619.06909', '-4109280.08547');
    T('637', '43943.2610', '637');
    T('14867.1', '894449', '14867.1');
    T('7.3', '-1.1', '0.7');
    T('2894844.4', '-1', '0.4');
    T('-0.00000000000196', '-2.6741', '-1.96e-12');
    T('0.00000000000000071433493', '5.9227', '7.1433493e-16');
    T('69', '-7204969', '69');
    T('-12468163', '-10022891.867', '-2445271.133');
    T('45469.1932906', '-3095367650', '45469.1932906');
    T('73072906.39', '-112013211', '73072906.39');
    T('1.4', '972.159255713', '1.4');
    T('66924.3855375', '19.93', '19.3755375');
    T('26.4256214076', '11.4775634275', '3.4704945526');
    T('23362.0174956', '-0.0000000001748', '1.536e-10');
    T('18276818006', '-5.74', '1.1');
    T('-8319.8', '3', '-0.8');
    T('-7.7413714358', '43763934316.0', '-7.7413714358');
    T('-688566579', '-1.83', '-0.3');
    T('29854', '-268509731.22', '29854');
    T('-194.15246', '-3.2255572', '-0.619028');
    T('2.0186177', '-326915', '2.0186177');
    T('-4', '1259', '-4');
    T('3.56', '-0.000000000000000000515993', '1.2338e-19');
    T('0.000001783', '-16426085', '0.000001783');
    T('-1766987819', '-87.259', '-49.72');
    T('-17.1', '0.00000000000000021840564', '-5.750892e-17');
    T('-8589.659', '0.000000000000000505', '-3.75e-16');
    T('-65891.7', '-38663.83', '-27227.87');
    T('-1.0', '0.00000000000000003836', '-1.78e-17');
    T('-33378.26', '-1226528.13', '-33378.26');
    T('2', '492342441', '2');
    T('1274', '-3092459411.0', '1274');
    T('0.2631770', '-493249535.4', '0.263177');
    T('-0.00000000000000000141', '4201192116', '-1.41e-18');
    T('-574.29154', '133427.3', '-574.29154');
    T('104617.3', '293188753.50', '104617.3');
    T('0', '38.96345', '0');
    T('-0.0000017289693288', '-5.4', '-0.0000017289693288');
    T('0', '4', '0');
    T('9.65', '1.2', '0.05');
    T('0.000000000017', '-50377365', '1.7e-11');
    T('137.3064', '0.0000001012', '7.04e-8');
    T('-9.89405', '29.2', '-9.89405');
    T('3.23', '-3048751.09', '3.23');
    T('87020568364', '-1', '0');
    T('-3658', '-0.4067222', '-0.3472554');
    T('0.0000000000483229749', '-508858', '4.83229749e-11');
    T('3', '-0.000000000000000006525172012', '6.0850742e-19');
    T('-52.63', '-373.710', '-52.63');
    T('-6.49915814', '352.2', '-6.49915814');
    T('0', '-44190.198', '0');
    T('0.00000000000000003763584929', '6', '3.763584929e-17');
    T('1.299983', '194.7', '1.299983');
    T('1', '9.52', '1');
    T('-86603.9', '446867516', '-86603.9');
    T('-1482885.420', '-0.0000000018878840', '-9.643e-10');
    T('-170.531717', '-633436587.6', '-170.531717');
    T('15.36378', '6540.267', '15.36378');
    T('-20570.61', '18.955913858', '-3.44346407');
    T('77', '0.000000000000027', '2.3e-14');
    T('0.000000001687849', '-0.0131699248663', '1.687849e-9');
    T('-0.000000000000026', '3291407.1', '-2.6e-14');
    T('-290.613', '0.00000000000000000008353794', '-6.386436e-20');
    T('200', '66.97', '66.06');
    T('2.2', '-43.41589', '2.2');
    T('98201.177964', '0.007000', '0.004964');
    T('35.453991547', '128.68861', '35.453991547');
    T('5.27', '1', '0.27');
    T('-1', '0.000119683476689', '-0.000044552263405');
    T('-34.0', '3', '-1');
    T('3378', '-44180', '3378');
    T('15', '-4', '3');
    T('0.0000004190944243', '37285824.4', '4.190944243e-7');
    T('-298.4', '506466', '-298.4');
    T('-0.00000010893', '-0.000426882829396', '-1.0893e-7');
    T('-1.9756065817', '941.5', '-1.9756065817');
    T('-1026297.2', '-205657.802', '-203665.992');
    T('2', '0.0000000005621541447', '3.513430991e-10');
    T('-7951901.67', '-0.0000000000055383', '-2.3814e-12');
    T('9', '0.000000000015125851830', '7.24233339e-12');
    T('72.245762', '-39.70217', '32.543592');
    T('6.62321', '-912632', '6.62321');
    T('617021', '-42.5970821', '2.2657815');
    T('1469815.28770', '537.217915', '524.290175');
    T('345897.6', '-0.00000000000108024', '9.7032e-13');
    T('0', '1.8688906295', '0');
    T('164', '-82114.2', '164');
    T('57.84537', '-1.4', '0.44537');
    T('114.340500', '6333334050', '114.3405');
    T('4.80', '-6077773.6', '4.8');
    T('162', '-37.75886044', '10.96455824');
    T('0.000000016367092', '1', '1.6367092e-8');
    T('148.2', '-46', '10.2');
    T('1.5768318844', '-7512089036.8', '1.5768318844');
    T('-0.0000000000000014460', '0.0011257005', '-1.446e-15');
    T('64.079', '-141', '64.079');
    T('-0.0582', '-13.35353476', '-0.0582');
    T('-1.0007', '63155.153933', '-1.0007');
    T('-623313173.6', '0.0000000081031', '-2.4548e-9');
    T('-36.9', '-1', '-0.9');
    T('2.0857', '0.000000000000000000205859744928', '1.887979864e-19');
    T('0.0000000494417', '492420240', '4.94417e-8');
    T('0.000000000000012194', '0.000000000000000013778591965', '1.372470294e-17');
    T('-16179.166', '16.4610327', '-14.4318886');
    T('3.24', '55986', '3.24');
    T('-61938', '47825328585', '-61938');
    T('4.36', '-1', '0.36');
    T('-9857364.3', '-1', '-0.3');
    T('9943.75', '3.5', '0.25');
    T('151.4907', '-1', '0.4907');
    T('0.000000000113985670', '-2286508', '1.1398567e-10');
    T('-1468', '-12915320.7', '-1468');
    T('46.543901', '0.00000014040913', '3.32077e-8');
    T('3', '190.34681', '3');
    T('-468.5022', '-0.00000000309208106131', '-1.13251725725e-9');
    T('-0.00000000000153707', '-112649.31435', '-1.53707e-12');
    T('-1.5', '0.000000067829063910', '-6.729086517e-8');
    T('42031.2', '-1.165644', '0.408648');
    T('-137623012.4', '-71.9609', '-21.9379');
    T('-278354', '8', '-2');
    T('5370.3', '71543859', '5370.3');
    T('-0.2469826911', '-0.0000000000008289323096', '-3.584481336e-13');
    T('338.68861185', '0.000000000000371927032', '2.00995384e-13');
    T('-0.00000000144', '115767.5757', '-1.44e-9');
    T('-3183918.6386', '-980.559', '-43.5656');
    T('-0.000000000004661097', '-0.051176618', '-4.661097e-12');
    T('-1', '948.171', '-1');
    T('1057394189', '62.751', '54.866');
    T('167.9', '0.00000000000009753', '8.45e-15');
    T('-12.172', '800.4476', '-12.172');
    T('-1.4', '-139187231194', '-1.4');
    T('359356.2', '-0.006806', '0.005734');
    T('4744567.6711', '-1.74', '0.0511');
    T('-0.0000000000234390', '-75.75283631', '-2.3439e-11');
    T('-6557078727.02', '-0.000000000000000015', '-5e-18');
    T('-1.33', '-5.111037', '-1.33');
    T('-431.277', '-1', '-0.277');
    T('0.0000000000000000000697336', '-8212.9015367', '6.97336e-20');
    T('3370.2674507', '445.572089', '251.2628277');
    T('-2.33567', '-0.0000000104784', '-8.888e-9');
    T('0.00000983659', '83423921', '0.00000983659');
    T('-51.2', '-0.0027394686', '-0.0020713346');
    T('0.000000000819617035421', '0.000000011', '8.19617035421e-10');
    T('0.00079279091535', '7', '0.00079279091535');
    T('-0.000000000095324834', '28091.00', '-9.5324834e-11');
    T('-0.00000000000000015', '23.52', '-1.5e-16');
    T('0.1438', '1035688.4', '0.1438');
    T('16693', '-1', '0');
    T('-781.09402123', '6.9', '-1.39402123');
    T('1', '20.70', '1');
    T('-3', '0.000006782445', '-0.00000249249');
    T('0.00000000000000000022', '-54710642.596', '2.2e-19');
    T('-590.69625205', '26.40', '-9.89625205');
    T('10', '-5.67', '4.33');
    T('-7', '-0.00000000000643634802', '-3.80362768e-12');
    T('-9680099.05', '-62.737684457', '-50.764391642');
    T('-1.5', '9914.9781', '-1.5');
    T('-1', '0.0000000507688288763', '-3.15199093625e-8');
    T('-0.000000000032713211391', '-0.000000046529', '-3.2713211391e-11');
    T('5.40', '1612427.39748', '5.4');
    T('0', '-0.0000000000000000000146', '0');
    T('-0.000000000000000000817527', '-52.0', '-8.17527e-19');
    T('1053329.8', '-120573.937', '88738.304');
    T('0.0000000000713', '-100743.840', '7.13e-11');
    T('8219', '-7505759130.86', '8219');
    T('16655.7', '243', '131.7');
    T('259.650', '278.73', '259.65');
    T('-284.091', '-1', '-0.091');
    T('0.1250', '-23713.35', '0.125');
    T('0.00000000490018764513', '-4.41', '4.90018764513e-9');
    T('-584.70403', '11076992', '-584.70403');
    T('-221.643', '-30.5', '-8.143');
    T('-9.69', '1177241', '-9.69');
    T('-4.97845868064', '-1.3178692059', '-1.02485106294');
    T('-1.04328912629', '-12.828540', '-1.04328912629');
    T('26', '-4.91596', '1.4202');
    T('94.686', '7.5851', '3.6648');
    T('0', '-0.000000000000000363', '0');
    T('-1.431', '65.06874', '-1.431');
    T('-878.898828', '-5.21', '-3.618828');
    T('-0.00000000000000014146660', '1.05112178985', '-1.414666e-16');
    T('0', '360.6112165', '0');
    T('4.464476', '0.00016302503', '0.00003555345');
    T('1145096', '-217.15', '64.05');
    T('29.46', '104.40', '29.46');
    T('841.82', '-2171922.59229', '841.82');
    T('46', '1', '0');
    T('22829.8889', '-1578709411', '22829.8889');
    T('-0.00374341104', '1.2', '-0.00374341104');
    T('410', '7', '4');
    T('0.076125848849', '1.103', '0.076125848849');
    T('0.000001844875808', '0.000000000000020813', '2.0037e-14');
    T('6.685', '0.003905472818', '0.002736008402');
    T('41011740.6', '908.670191', '728.869597');
    T('-152.527', '-1', '-0.527');
    T('12815.035', '-1497.81264', '832.53388');
    T('-0.000000000000004048729', '0.00000000126', '-4.048729e-15');
    T('-19949.700625', '-314.64', '-127.380625');
    T('-2.4', '569419658.2', '-2.4');
    T('0.00000000000000597954708', '4', '5.97954708e-15');
    T('-17.0', '1.58', '-1.2');
    T('22811600498', '2', '0');
    T('3.1328', '-119317.4', '3.1328');
    T('2.26039694', '1567.2', '2.26039694');
    T('-0.0004559', '-1.59', '-0.0004559');
    T('-0.000000000000165', '3', '-1.65e-13');
    T('-215.9051', '14846316.4792', '-215.9051');
    T('-1', '6004363.2', '-1');
    T('173513829480', '-117.2937046', '37.6296904');
    T('2269413223', '44.831', '39.204');
    T('-1411953.506', '0.000003338150524', '-0.000001742597716');
    T('-26.596', '-7', '-5.596');
    T('-0.00000000000010245141710', '6652789979', '-1.024514171e-13');
    T('2.042', '24673', '2.042');
    T('-2.71', '68.05392544', '-2.71');
    T('-3', '220821.80', '-3');
    T('116.073', '-0.0000000000024392780', '2.029598e-12');
    T('-0.00000006283674', '0.0000000000000079', '-5.7e-15');
    T('-3', '-7', '-3');
    T('-0.0000000000000005058', '-1.5', '-5.058e-16');
    T('-683', '1013123.5', '-683');
    T('-6', '16985130.432', '-6');
    T('-76481.64', '-0.0002575', '-0.0001725');
    T('1610.8849133', '-2.02567', '0.4772633');
    T('-19.3482', '-1.5', '-1.3482');
    T('779.8394', '390457.98231', '779.8394');
    T('0.00000012', '-8855.3', '1.2e-7');
    T('27226552.2', '2168.811', '1467.717');
    T('6.353167529', '1283573.56', '6.353167529');
    T('2', '26.2339535', '2');
    T('-34', '5319.486', '-34');
    T('0', '3123027047', '0');
    T('1', '27465.6301', '1');
    T('-1.5', '-41136.47', '-1.5');
    T('0.00000000000000000001311857', '-23', '1.311857e-20');
    T('14831.7', '4.41', '0.87');
    T('2953.07357', '34.48', '22.27357');
    T('-1.5', '-2465544', '-1.5');
    T('-376', '-244.16', '-131.84');
    T('-1799906518', '219', '-49');
    T('16431536', '987.209', '429.404');
    T('-0.0000000000000000406462459', '36617.26003', '-4.06462459e-17');
    T('-0.00000004133646', '26594407.6', '-4.133646e-8');
    T('6.3642', '-0.00000000000000000009857799', '8.84487e-20');
    T('1.780751', '11652994', '1.780751');
    T('95.6', '19178496109.2', '95.6');
    T('2.57393833', '852658757', '2.57393833');
    T('147.77838', '27.129', '12.13338');
    T('-773.3025', '-6', '-5.3025');
    T('3', '-31458.09', '3');
    T('-2.93096796427', '2.3', '-0.63096796427');
    T('2', '6190.943', '2');
    T('-2', '-2.47', '-2');
    T('-60.45556497', '0.00000067724055444', '-5.489328444e-7');
    T('0', '52221', '0');
    T('0.003001960', '-277761107', '0.00300196');
    T('5.3848225844', '434804', '5.3848225844');
    T('650.7467123', '-4', '2.7467123');
    T('1.4', '-65970188', '1.4');
    T('-3500.45', '500254.11730', '-3500.45');
    T('-0.000000000049', '4919966334', '-4.9e-11');
    T('17.92802', '-4.826', '3.45002');
    T('248.79', '936.1', '248.79');
    T('0.000000000000000000062725', '-1.050053808', '6.2725e-20');
    T('-21.4103', '1.9075', '-0.4278');
    T('-7785809980', '1574', '-92');
    T('688.6', '86674028', '688.6');
    T('0.000000000002917443', '-245.8', '2.917443e-12');
    T('-0.07547', '-15.028', '-0.07547');
    T('0.0031519195605', '-2272651712.25', '0.0031519195605');
    T('150494.446', '-51709.2935', '47075.859');
    T('-12010', '0.000000000000000016290', '-3.28e-18');
    T('-32.408275623', '-1', '-0.408275623');
    T('0.000000000000383814', '-1', '3.83814e-13');
    T('0.000000000000000003469380524', '0.0000000000036', '3.469380524e-18');
    T('1', '15.8856255428', '1');
    T('119.378058192', '-2.4396301', '2.275813392');
    T('33773052.62', '0.00000000111954987477', '7.3387294787e-10');
    T('6', '-120890538.30', '6');
    T('-0.00000000000059065444364', '22714637', '-5.9065444364e-13');
    T('-1774625862.4', '8507651416', '-1774625862.4');
    T('30.1', '5.7', '1.6');
    T('-1.806', '38.81', '-1.806');
    T('3', '-1683506', '3');
    T('-88.75', '-1411.1', '-88.75');
    T('-31', '0.00007026872', '-0.00004067864');
    T('2437.18437', '2.70220899140', '2.4940687486');
    T('0', '-41630623', '0');
    T('-258.66793', '-182.14421', '-76.52372');
    T('-14228.6', '95437.0', '-14228.6');
    T('1733.518', '-128426.9', '1733.518');
    T('0.0000000000000000000532527998218', '-63.28534135', '5.32527998218e-20');
    T('-295.03967', '-3', '-1.03967');
    T('2.956649054', '899957.06', '2.956649054');
    T('-2313.023', '-63930.69', '-2313.023');
    T('13803.9', '5.8329456', '3.1507104');
    T('21.8238290', '-3', '0.823829');
    T('-22.3', '-77.5771049044', '-22.3');
    T('0', '10.70', '0');
    T('0.000000101', '-14430384604.6', '1.01e-7');
    T('-600271019.62', '-2.4', '-2.02');
    T('-53874920.5', '21.676509', '-16.648855');
    T('-0.000000000000000061', '-69.27505', '-6.1e-17');
    T('-0.00000000000117570154770', '874813.194864', '-1.1757015477e-12');
    T('3724726', '0.0000000000009126675', '4.24705e-13');
    T('6493', '-82605.38', '6493');
    T('-2.88', '10', '-2.88');
    T('53970', '-99064', '53970');
    T('-12.440', '-0.000000000019', '-5e-12');
    T('54.64', '-6.1', '5.84');
    T('0.004000', '14', '0.004');
    T('-1570593.12158', '-2.56612', '-1.9417');
    T('-0.0000000000000113891', '-0.000000000042', '-1.13891e-14');
    T('-29.9444', '-2245', '-29.9444');
    T('0.568740', '3.7564033753', '0.56874');
    T('-52606.48321', '-4.34014413083', '-3.9363443404');
    T('-0.0000000334', '0.000000000902008057677', '-2.5701865951e-11');
    T('-634849.178', '3953007.487', '-634849.178');
    T('127992.04562', '3009797.1', '127992.04562');
    T('1', '-43.9035960', '1');
    T('-11.0349', '-2', '-1.0349');
    T('158.7', '257566', '158.7');
    T('43047346', '-115148338070', '43047346');
    T('9691.0996', '-15.5219', '5.434');
    T('-77.9', '-2.0', '-1.9');
    T('-38.3896', '-0.000000882', '-5.14e-7');

    T('2318237922853539360.167157597022570', '-9702015238687.680494235371626139504030926823802574', '9295675788919.833075194557918488338251940141560718');
    T('-3346995255.54414928936', '-19484973963827626752773520333240590885639375', '-3346995255.54414928936');
    T('-270721769', '22539228.03492196260802407744489638356810047', '-251032.58093644870371107066124339718279436');
    T('-0.00000000000000000308066481692295683548642301228852180070143433425056969292333', '206232915.762239501154732324', '-3.08066481692295683548642301228852180070143433425056969292333e-18');
    T('-0.00000000156454306292867840840689', '2635', '-1.56454306292867840840689e-9');
    T('12886035692416820.3977457533594029154555584175743', '-113496127978790341.941210015456704515', '12886035692416820.3977457533594029154555584175743');
    T('-299395547.883083669188105176893563510454667', '-3152.9580', '-115.077083669188105176893563510454667');
    T('8076327350.789696755252236317', '9', '5.789696755252236317');
    T('2241730616485747642201052100686334', '15115372376051.1433309224128', '15028644606255.6407694748928');
    T('0.000000020545442143', '910205431326260.56522101419792183224139104902865869227', '2.0545442143e-8');
    T('-299.2', '-1095069605114867345071265098807585478368438601713540771676', '-299.2');
    T('0', '-0.00000000000000000006258032721', '0');
    T('-9561792051.46130', '-0.00000037912322661422', '-3.0664875638608e-7');
    T('-4589.274150042', '5463826693798.059180748770', '-4589.274150042');
    T('-177372488891124.8209441829612234253673371', '-2184484411972.871928873110', '-429251521322.1947054610512234253673371');
    T('2840794355990579101690516447419567416103576933551526', '-225384346136689418.311568171615', '4159399848092788.810925291935');
    T('433169940324134426366793327.235', '-1918606541369710.9167801826', '369802826989779.100695574');
    T('0.00000231962990639112417450960779176176525188784519762202020426278', '11491626.8146875740651454657723913302260', '0.00000231962990639112417450960779176176525188784519762202020426278');
    T('-118317530966985340050567.3794340230', '-1290337888625470391870404816877827630953112876.297', '-1.18317530966985340050567379434023e+23');
    T('507941745866485347809651792.3258074064530387681549475622', '-78.8876', '48.5294074064530387681549475622');
    T('3280516686867.41769205935464611912132313550145186748', '-0.00000000000000125477', '5.0338132313550145186748e-16');
    T('39.99', '-196.666', '39.99');
    T('198328732837738155510399443.82996', '0.049415792708', '0.034407057628');
    T('23.9909397975464820637937485614', '0.0000000001050229258855441', '8.54924991032156614e-11');
    T('-1157214583831665284482', '1.0988344', '-0.0759048');
    T('19626.043251177620', '0.0000000034291719721621', '1.7452276531105e-9');
    T('11144329315299884830592174718286.015391668774749336449044', '-276730.619204816478', '84261.983174911066749336449044');
    T('71.3348063927327012696442274193666742024', '1.003', '0.1218063927327012696442274193666742024');
    T('2353.964728726069', '-1147885339335726766004631.4827280116227481840172642411087841', '2353.964728726069');
    T('-3.4', '99841150890712628939215423679763543630485717', '-3.4');
    T('-17423609848720294448155093008156493860946579332348817', '-407401303.1', '-39793145.5');
    T('268219889', '66408.228187594864', '63463.578491939168');
    T('-7067928231578399800943353710459167713.4021506', '-44099.172874028', '-34277.265446476');
    T('0.0000000000003143', '0.763206816948175243403280699590867', '3.143e-13');
    T('4.036744136250', '0.00971177', '0.00635958625');
    T('1793819.269108', '493646013195.8520', '1793819.269108');
    T('-15826468630.86978', '-0.000000000000000000372629410691473337097845426967193919000496413569810554360', '-3.3602620906243362074116532307435310028959396493592065148e-19');
    T('-18.7707479011363', '-0.00000000000002581603178761489486464393960475608950385662413624987', '-9.1067040799565470223405647782611453765936052898943e-15');
    T('238432236541400642177165.39210', '-5', '0.3921');
    T('-6811268416946324947973610791528879575619937612025', '0.0000000000000001069504654335424482337205845600046597647661', '-8.16882733210848477277494710610839496492589e-17');
    T('-0.0000000000000001763427790981229873712832162', '-0.00000000000000000002454861590426229238192323806393241482688272809526858064170', '-1.00710578069411919285971867734642985013640916857852506689e-20');
    T('19755770505453660565232908.50109071', '11636774869145974997.1', '6173329669666681241.40109071');
    T('-0.0000000000002209009508639970169662640887364083811', '0.000000000000000089645450775854240465099382429782771424049138745143690592', '-1.4560152292168460259210429423632311142922131965946381312e-17');
    T('563088', '-0.00000008456562014728262541201891984898', '2.11408406705846430113462806523e-8');
    T('0.000000000000014349029064561994176595511', '-185.73981699167343715247600', '1.4349029064561994176595511e-14');
    T('-0.00000000001083082172818863769543', '1190273509470734307.14840', '-1.083082172818863769543e-11');
    T('-0.0000007000816503264538441903792097551608671', '426939', '-7.000816503264538441903792097551608671e-7');
    T('-74639664.5738469080670677219615636886365697', '11681605088890876252615.81485333', '-74639664.5738469080670677219615636886365697');
    T('-17473762843659544328007830640965916', '4735599287262364762422146713625.0556784154158620151196', '-4.1370729486807194325314144030856023255308850262237956e+30');
    T('-35798372944152782907433662314743475258228956226653087.007402', '2986648933436031786673397525017144049.527376', '-2.586979851276128040119426347481949619034666e+36');
    T('594962882338997095.95600951831319665393181826', '-0.000040093460748026675395936734376802508692547860', '0.00000106629014969426833642467613848819248141182');
    T('-98128552510799809261642798951333594.3', '-0.0150759218573700771020952512609526302985126417', '-0.0093980498660155309329725865407755408137845842');
    T('-28905866.022560718711724183906982038769016', '784580.53565571528753557678117', '-660966.738954968360443419784862038769016');
    T('-47314330483943356635.9', '4636924735068749202877120062.478835103', '-47314330483943356635.9');
    T('792568.576', '-1979027334.876406', '792568.576');
    T('2082231914.648466978927', '0.000000238131951894409076127502052426857902593605206359', '4.9424034607223232258131091994225827538144585637e-8');
    T('-3411944212928743691.0878807671609226126352448564441', '-35500488815007653257376478967389.5309684', '-3411944212928743691.0878807671609226126352448564441');
    T('41501124315127150415.980342038928850343648471670', '0.000000000000000000053662500082765049695814837696308208138940564988179296927086', '5.264308454143252141026226146634076056628101699532578384974e-20');
    T('-8105952948653953296.0699944999485216414062634578', '-86.16623488113', '-12.7456165483885216414062634578');
    T('0.3363661610339352417675708613420020704697718205608204221483', '0.000000015893', '2.1879352417675708613420020704697718205608204221483e-9');
    T('-2210034411007336613344093585636474574394416824601186', '-5697969717442263672614992696703295962015334995729800', '-2.210034411007336613344093585636474574394416824601186e+51');
    T('-19624478.484621985479326459244324640415206', '1107819793188885.038860867', '-19624478.484621985479326459244324640415206');
    T('0.0000000000000000027', '3631127636124777836273261304119863249137.03745979717836204256', '2.7e-18');
    T('428890527306795', '1668185806826743336487.38672816383301425507832145712664', '428890527306795');
    T('-118370476542022564.70047766418757366578', '-1228521.83117210457036591052269149317400179607062584234', '-805751.95595400766902842055758098139122173498985457682');
    T('185286933', '2634674111701244320881602650.2421109389', '185286933');
    T('-7816588257503735832158705.4', '-11446124074192432060805137497617191.5046', '-7.8165882575037358321587054e+24');
    T('-31168709097858.0', '-17218.68615703', '-10432.31999475');
    T('-1193968682851815353278.892', '16233847.397485882794799291566785542165584', '-2556325.316384280762019592125096432742624');
    T('-0.000000000000000000429785230445766557625717658510987246778343793367089404', '-716612915846390386454071955208510757337687098919716', '-4.29785230445766557625717658510987246778343793367089404e-19');
    T('760.787298', '-2603560575.1399', '760.787298');
    T('-18743620234475404481049.76769588257', '2970338095303214.63301260929704123104600934034050653148876822', '-2683854960098077.08770269798321468491598555389258155949698992');
    T('-226541276978', '101925495756252505609089275771221594.112426392858882002885', '-226541276978');
    T('-0.0000000000026983', '487122954421920311203.9905962', '-2.6983e-12');
    T('203252938.721649167192089873629233502162687452', '221.20710344937374', '109.823743846799189873629233502162687452');
    T('-2171101234717018601412530711075541768098', '-1268548470639454153963685.60015', '-1.07365992860948866922827981755e+24');
    T('11052697820027335752485837522176323720287184.550750155', '-553810966103.02590552831652788244539331678489580819303648', '525192380831.77413824185332709628772520041226644631472352');
    T('-3884559198046300262478611735179875511934488582167963637380', '8.036636030768', '-3.27660412216');
    T('2.0', '-45.2', '2');
    T('0', '-0.163349511377933876791410190902077510', '0');
    T('-730572579439411951784822207340668557', '0.0000000000000028', '-4e-16');
    T('0.000000000000000001168651449131923286954932276275033439404771143330881475', '-47210255.27658777658181021168421281357', '1.168651449131923286954932276275033439404771143330881475e-18');
    T('-30769567698.202004635902421797597470637', '-2117030646075139493515312478944809325583483881105', '-30769567698.202004635902421797597470637');
    T('0.22203824107047587018951755693974277131200048220', '-136.52076', '0.2220382410704758701895175569397427713120004822');
    T('4489045408103326401151265241469016732232592556114681884438', '0.000000000000001314763381159004315842197', '6.8074495798791174068935e-16');
    T('-21348129287570112842795163717617654521736400718052510', '-1995504519697835638540568077.0196418', '-1.1402642626986948193867205135517104e+27');
    T('-14.48287435139371979106', '-278112747003022610742126629257947172194929.64536', '-14.48287435139371979106');
    T('0.0000000000000110719145581948062251355493585472867', '-7978399748.1558009430388367158631487853516499292946094', '1.10719145581948062251355493585472867e-14');
    T('119501784974', '-0.0031818401885065375156179', '0.0016290398380208417060804');
    T('-0.133707475845003705950317295850288779512882217932', '329652021145697865591302212038174941275757995054.713783674845', '-0.133707475845003705950317295850288779512882217932');
    T('-12542871568091185279.0460234294798148233', '25754.120417', '-21877.7952474294798148233');
    T('-3818054566.20841286030331762281612', '-1936.24778639274331686587963417792515204476546099', '-472.43293099041187629213445041741051174848665583');
    T('118000308055.9373727402663957624604063', '9918.67574327356', '4846.8753496034663957624604063');
    T('-11.38', '-24193758424792525116909481098205.677446', '-11.38');
    T('2.46889727437003280961289299604392122014099570', '-4644753841435365046988433379518839103541882981334804890807.8', '2.4688972743700328096128929960439212201409957');
    T('1805667164641860305883.31324', '0.00000000016618955069904640141657751519707415214669847044', '1.046133052518583849356487736801523519251586328e-11');
    T('-0.000000000000000000012169689776926610597997556555980427323944885949030949402', '-434910402113045297454505.1302573189763520', '-1.2169689776926610597997556555980427323944885949030949402e-20');
    T('-1739.4', '0.155584511367509963502532516739270411', '-0.120747422606118005188995371696075431');
    T('-569589695561180399227800563933576000706960457.3656765081522', '3483.46493456384339944984809629410413910476502', '-3467.25917700145185407850776398960809939327178');
    T('27827944878804.043096443231553973596298120', '327784539432851688676.574297', '27827944878804.04309644323155397359629812');
    T('-0.0000000000000000000273570270893076789122004877379023084477997941182649713787', '55071786762378989.632689594', '-2.73570270893076789122004877379023084477997941182649713787e-20');
    T('-1', '30698458.1545228514266', '-1');
    T('-77.6796737181065072239544734403386720988476876081692968190', '-48043379.33911367817680827247020826', '-77.679673718106507223954473440338672098847687608169296819');
    T('-0.00000000002231552048713565363805177481170756001463248', '-7745938658044151', '-2.231552048713565363805177481170756001463248e-11');
    T('4080930738001215900471542815678.870', '-259094.384407758455239', '219215.641754292988748');
    T('-65148376658415.8821831041618603950', '176.7', '-41.982183104161860395');
    T('-20649466814.805802613083057980846632715554163812995', '-0.0000000001319860149268122557211741866249364289650956', '-9.623959984992160004489809813728963916899e-11');
    T('-8637039792424460231', '1171511157428179825785002.9414399798460302750', '-8637039792424460231');
    T('170120714324740496497515610676549361259437493939036', '0.0000001984234593401508456286993357944778724317751259644793106', '1.80272091831781979821089649811533712715612789460516662e-8');
    T('3040385342.35657760274052', '-372946621956569451.93539995558371617994622295531744', '3040385342.35657760274052');
    T('234417346052636032.106833697570476435658983423056', '405728269025466785030711845788149565209977.743', '234417346052636032.106833697570476435658983423056');
    T('3003698058950457901967364.923201608', '-0.00000000000033926708389437080558726155721138587500872389823', '2.3077148260391721408496333950768060426097166773e-13');
    T('-1', '13121297327432473503324600878404', '-1');
    T('-0.00000000000086987493647337590015438704985', '1126309963348141179998313355117347492625867522.06445459173', '-8.6987493647337590015438704985e-13');
    T('0.01175883004658442799157', '-1304796615695885174911897002429657121243.096878772927435101', '0.01175883004658442799157');
    T('-4.1', '-925940.0049', '-4.1');
    T('94413979984015715031.72143', '-44956570520496128861135438942192313346223.4679844', '94413979984015715031.72143');
    T('-2084.96276512750756221737052806049261165250425', '1.5202660037865707', '-0.67807393611913251737052806049261165250425');
    T('5530042131715182582', '0.00000076755550127601384796182326285660346554068838', '4.3620483782819522891660511451578934939479584e-7');
    T('-67042.802', '-28411888994.212820705785482909844033014', '-67042.802');
    T('-5360742.0', '327368856548045.08220112714929243516', '-5360742');
    T('47117230722.16973123915245237545229011004357913004', '-47488231.617918014245187991287717374685823103416490829', '8904957.195061107925965018036654421707060540881097632');
    T('-0.000000000000151343572349948255798487186356', '42.39640064100021994629331666', '-1.51343572349948255798487186356e-13');
    T('113840373593648670861500086', '16082411799435623101958677220820405667', '1.13840373593648670861500086e+26');
    T('-8.22', '-2867798109411674.996765068247085164513407273890902397064937', '-8.22');
    T('-3.50238614', '-6860188389136636488339219859054193101069684390', '-3.50238614');
    T('107107360259917227679425620190.388983860971684', '8800479523270977282088607107997626691064406556317263323.341', '1.07107360259917227679425620190388983860971684e+29');
    T('-175822.1223383477', '-88621983013742415713.67926832', '-175822.1223383477');
    T('-0.0000000001165498478337125015371156469966957212161218123244751', '-62550285299530518719359714148367546793907', '-1.165498478337125015371156469966957212161218123244751e-10');
    T('0.0000000000000000320110187403311537074296810233047925148', '-60407506473103.897451724471', '3.20110187403311537074296810233047925148e-17');
    T('-0.000000000000000338282064563114', '-96190376454071434357.783403611375151575341982065544942431', '-3.38282064563114e-16');
    T('-0.000000000000446753711341', '-9.4', '-4.46753711341e-13');
    T('369078971611659797359596697169091.7394557', '4390355307871218680185944', '3.2920328769890124360129157394557e+24');
    T('0.00167752355829931578551694576878658836500507142636702529088528', '3276066309050', '0.00167752355829931578551694576878658836500507142636702529088528');
    T('-40341913269616270298908054352.555424105652', '-76.6805753', '-22.343535105652');
    T('0.000000000000000234899796181467417005659941', '-0.00000000000000002455754630676905247611', '1.3881879420545944720669941e-17');
    T('-2288200091016313974155687089998490026813781889257797', '173612435224249143072698340434416969557762958', '-4.06305517399251906560023908396396030698941e+41');
    T('-119.570203264189', '0.00000000000000000270873280446606560343105459296495864', '-3.0654086667132932857371380394960016e-19');
    T('9636003428434421863325355207384758', '27189148267469.7985900247652', '763104629651.47867591268');
    T('336.422676596', '45198935114500.3922307046', '336.422676596');
    T('-14.0627943158485824648781649958871436175344604029182482603314', '514937038588634.2538384203447', '-14.0627943158485824648781649958871436175344604029182482603314');
    T('0.00000023418399644897328432613203542773200097298268', '150.05994', '2.3418399644897328432613203542773200097298268e-7');
    T('-7549019185595.78985813486261693520665842030485693423', '0.00000107047', '-3.7760261693520665842030485693423e-7');
    T('2084', '-4702062390.892', '2084');
    T('-0.000000000000004338', '23.449915', '-4.338e-15');
    T('355378988141704324089218417352212802.4373051939435896809', '-410089.6820', '397574.1193051939435896809');
    T('-0.00000001989462540690061730462809985539649615779', '-38.286442069994941913718432', '-1.989462540690061730462809985539649615779e-8');
    T('18131048627056749262739468342.355859006591', '-1199.6142723004281428', '211.04880824112304');
    T('-7485271015053088795456302791998022618551521.6832', '0.0000000000000000000469320709938399196323702081094328803321', '-2.69710660151015687863998038860418026399e-20');
    T('0.000000000951589985684289940380019704065655070039753', '-26373114201649323963859575.5038618827163', '9.51589985684289940380019704065655070039753e-10');
    T('29612852829840055823.4234313598', '-0.000000000000000000390000839472495342007727670085919905954881', '1.00427280201824924510562417012541840544546e-19');
    T('-5607158.61839129739841', '7', '-4.61839129739841');
    T('-5033.1047890916762223467249791215764', '-125308255061340894094178.363334', '-5033.1047890916762223467249791215764');
    T('721650415570508.30568044521', '40444523802228.33072733', '34093510932626.68331583521');
    T('2909689458580570441', '35832160731.298726', '11893825723.095282');
    T('-5860896283.24109', '-0.000000000000000001291619269537172108644', '-3.63300889125010974528e-19');
    T('-194225255714783295041136360134265455943072328542285', '69.6', '-40.2');
    T('-64931541870946970276.043833373186791755', '0.0023858644', '-0.001926882786791755');
    T('1768097901758505513385227.27886663656389579248832549927529', '49683790014635', '22391913150827.27886663656389579248832549927529');
    T('15607444724715380472693190116075827307544230542858', '-30863780897913937221259082805810494697060093553853613140', '1.5607444724715380472693190116075827307544230542858e+49');
    T('-5', '-4637217487418.54919740129555570192754032790658061945', '-5');
    T('-0.0000000000000000000828', '131673552653745805914768.46227', '-8.28e-20');
    T('-0.00000000764789734', '1709371095001247612801478608832281576263433223592134788490', '-7.64789734e-9');
    T('154437761882957023383482721504354803201034660811788829', '-0.000000000000006907027', '5.846749e-15');
    T('715263.3', '0.00000000000001885535871127301429501799', '1.588206408282257808507009e-14');
    T('2', '-139137', '2');
    T('-33.5', '252567485444977003649.689937162645', '-33.5');
    T('0.000041876254378856129586442165482266321783', '322959107295001633.58', '0.000041876254378856129586442165482266321783');
    T('-54186163890839675559037155.29991407802075734', '0.0000000000022878015271202914230826203651610666594361551538884626909', '-2.2681269475854053487147725795128202226083088877672780421e-12');
    T('0.0000000009449673438295910508', '-17.0733222', '9.449673438295910508e-10');
    T('21265617482392966322733539382375295590999877466103755238889', '-352694528885882768342.45632391826455624336', '221163195874277534438.6290731360549322576');
    T('-1307793651716492003679476694280841686029964.654735755057269084', '-89261449075265.032742854725660037428102593', '-30163701590263.071635290265954147983863299');
    T('5914702572.83224302033871291000363', '-0.000000000000000886450497717875025851850', '4.967313925042229243866e-16');
    T('263730784.16038091', '-58734788098538430712.3', '263730784.16038091');
    T('0.000000001854032486183296214519', '-0.000000000355070869879153', '7.8678136787531214519e-11');
    T('-31884740503448053282155167604', '-9334262264990899277546182645450.74129764939998707', '-3.1884740503448053282155167604e+28');
    T('11557392706097.3454852500293825329599950094143', '2.52303246491988770256', '0.4512976779915504676799950094143');
    T('-71596377460606253231921860426759937622737054', '4887438282022459980414.75188230501531', '-3.01046057949271437163960532658638822e+21');
    T('233.31782712896541142', '-0.000000000000061176056765670789881258454117135367568123364367998', '3.1635882250994428931750935802393986143468670072e-15');
    T('365.885010333042430035757670950257510558158528', '0.00012', '0.000090333042430035757670950257510558158528');
    T('535753130902782277401868.255371439243127', '-143.10142002690254095307', '118.497092196935045142');
    T('0.000000000470393111281920', '-51.9318603511297101', '4.7039311128192e-10');
    T('13458.12201247046122595270157739959756782786002', '6387839814.018150125742976314622109379608051443', '13458.12201247046122595270157739959756782786002');
    T('-5.831075554650765329716', '-11970348016752784794040399571598021585032773536121.380962', '-5.831075554650765329716');
    T('0.00000000000262395619618229355713043239', '-87185298877269401376712558913.7470', '2.62395619618229355713043239e-12');
    T('141.0', '188771.3963534769931324152', '141');
    T('-9236972803514324.7806408277606845', '-0.00000000000007809628857086731989071851354', '-1.650710030068608338878824096e-14');
    T('1.2974663175859402553689735548443', '-0.0000000000001062828009896091833554986467183627932744813138557760818085', '7.61109945460281796836350249437619994413734484557859166905e-14');
    T('0.0270550933935502424060575696830352678525170478229935415832', '-451291.14957148684', '0.0270550933935502424060575696830352678525170478229935415832');
    T('-92.3630313298', '-0.0000000025494749392548', '-1.4586947958892e-9');
    T('5', '2.230', '0.54');
    T('0.00000000000000047652193195365538282280574751077165811188614512152190254', '-0.2219408161751349997065647158660685689613558', '4.7652193195365538282280574751077165811188614512152190254e-16');
    T('-11584699154744825490947848080895226756397973538', '87574.623306', '-81181.758812');
    T('677064505276662938729662254128.29994114', '707.4', '272.89994114');
    T('-0.00006824223430307152214885541', '-259323624933420687586166700605273793769205140227.53768209', '-0.00006824223430307152214885541');
    T('42649.4427', '6691515410463', '42649.4427');
    T('-1168876626035009643806416736226233', '615863945.824703012224567830126', '-392657283.272481237688137233096');
    T('-99850601104584713060403542.32679025848626541', '4984333871554095648842233050848980249665273650', '-9.985060110458471306040354232679025848626541e+25');
    T('1', '0.000000000020714284873094147095452920238214225', '8.535434304189538408987784126387475e-12');
    T('-40382172868238902141831024410171370609.8497129774930', '1302788268944196991798424860.3558746', '-6.82458913661894485779787415457058777493e+26');
    T('-0.0000002901522230060366316110382713638332433750838395', '1797816163.6022664896252467454244679282', '-2.901522230060366316110382713638332433750838395e-7');
    T('15.07', '-202256.9', '15.07');
    T('0.00000000001513399901378093', '-0.0000011431', '1.513399901378093e-11');
    T('8067543766555814361258.9809653', '-1063782.5113', '771356.4731653');
    T('-0.000007452478259217127353', '-1269742061.7650', '-0.000007452478259217127353');
    T('3083816844578.0036462734892162357142', '-62.043', '12.0776462734892162357142');
    T('0', '19676669.3210', '0');
    T('12000.579726', '-0.00000000000000000011473979542082043429', '6.885862514870385948e-20');
    T('157760.0162346769710343762123266316522595', '0.00000000000000002072', '6.6923266316522595e-18');
    T('12.56649651', '0.0000000011486174569183055328395211586383654058895981238621', '6.243894925921526655230893363862847927286267313448e-10');
    T('1619418216785919248186484303127025755692.6', '-5.32529795', '2.4485417');
    T('-7894381522375439472424053746795845545020655311347324165373', '22494560920042179494908995572822416399654.3988', '-1.79805849224239031722296510506179645210727012e+40');
    T('0.0000000000144180437967392496819227076903747539933453407576', '21.003335', '1.44180437967392496819227076903747539933453407576e-11');
    T('508588836239.155636417726778522264', '-402450669.2', '293641039.555636417726778522264');
    T('15935406874866887008916010678224808183941097', '-20533021922984769932524329949941646599184', '1.781862630705541277130637070090422974313e+39');
    T('10577358966.62645197', '-3902498.5606677997620066743', '1587867.216714614961912647');
    T('-2.3', '-247.215776', '-2.3');
    T('-0.0000000000000000004534097652705', '21900.378494953943', '-4.534097652705e-19');
    T('-622302543239963404259053402472736239978107701', '-37144508134104022867053839784711386961366245133.798061', '-6.22302543239963404259053402472736239978107701e+44');
    T('963', '-1143859.8306131050309784880555908137246920', '963');
    T('-1105334398087211096372825533031660097846.368', '676850877469691.4610087010635866598320915855', '-528741020326514.019428617163961817534907474');
    T('-33.537', '0.00000000000000000240610602831844082653894660603468520326205996616490648230', '-5.055045646408436609503461106111907664625346674246231926e-19');
    T('989.69', '1818860793340242.34985869797714179945790', '989.69');
    T('10897111350996763207208776906688937.9374615427', '34065063399932552093174621472004861573778946476274074', '1.08971113509967632072087769066889379374615427e+34');
    T('-11632431937037532580778695673.04032', '74582043438.8721965449504177221562482147014523596481', '-53296552278.8841298987146598409845587169502001115997');
    T('-141.4055769529530650', '136398726400805051012116675708221546904997943.0983953382506760', '-141.405576952953065');
    T('2436945370.995', '1123321514602145559580', '2436945370.995');
    T('68966344530824.7651173919961179400965271017811497107820', '3016650.5058630595142431070', '430737.119987074593653282096527101781149710782');
    T('0.000000000149640169704895568509292298172960103', '2388965841.03588731292125318485549177319506347036', '1.49640169704895568509292298172960103e-10');
    T('0.000015', '-3304.73941676117143286536062311830598946', '0.000015');
    T('0.00000000047066315132394427031416', '-6192', '4.7066315132394427031416e-10');
    T('-0.0000000000000000000581928591150593239271964107701426222875128', '5909007611163710886717422164.5826709875973058037321', '-5.81928591150593239271964107701426222875128e-20');
    T('31384923094914821999292552425.2009815380728309425967', '77537672972.35166', '11679771345.2858615380728309425967');
    T('-37567843820039777389745510805385', '-71883985.6201303', '-21998426.2683717');
    T('-8457.2', '-0.0000001173257195508166367392288464056131809270998457', '-2.69885424250247290675786668651098778106586768e-8');
    T('25100609273081546346038727027615', '0.0000000000000886831920439450', '5.162428876817e-14');
    T('-18047576.1098270311193001138015699506418833418804938917', '192214125807611.95755841586183852694517418512423624080241', '-18047576.1098270311193001138015699506418833418804938917');
    T('-95.588906373514114132242', '-0.0000000003929994337493746273806772122562877169246192899290', '-3.19339159019421511190151559546325880388122429492e-10');
    T('-0.0000000000000000002355739833279382506655556792223696880503752520', '-0.00000000000000079651826138154154521027236636093398105375492817', '-2.35573983327938250665555679222369688050375252e-19');
    T('-2007', '-6160033729282.9851660562442', '-2007');
    T('0.00000000000094972368099037971103433', '4734161412127674820247110768919593576233188914.242822976357', '9.4972368099037971103433e-13');
    T('0.138175287929598290229868824644141412392715', '-31558584857557504718252045560.11304', '0.138175287929598290229868824644141412392715');
    T('1196620705.9415675785887940558444736246545644683738095', '-70465530484696222361776144167727350283884319.64044686', '1196620705.9415675785887940558444736246545644683738095');
    T('11074860894', '1561765758632.45', '11074860894');
    T('-4381924184574059696448709.53108872210260149095882186', '1.028', '-0.23908872210260149095882186');
    T('0.00000001155422786572893769342087552370206756710219340', '-13931734385.2', '1.15542278657289376934208755237020675671021934e-8');
    T('69191800707.52', '8416.42298638305', '181.0075723297');
    T('2081967242.78645435603091', '-0.0000000641307577303646051321340042511613883', '1.04729585981376168223728825373660659e-8');
    T('851318799560282460315775006926769346175917826.47889714', '3053712.3623410179455158701230239730564268230', '440718.735027453982530562337797644313071866');
    T('-10058222.5796344546386', '6627451174822895.34794097800071486253721590178533538', '-10058222.5796344546386');
    T('0.000000000037566442917643747268847042234718910033651246885819716699339', '1.3779', '3.7566442917643747268847042234718910033651246885819716699339e-11');
    T('875.90002405088', '0.000000970077655599692785652735177637', '3.5638028118889148093740648709e-7');
    T('-62.7931846870391496', '-636485693987795148000356.1626652406993787', '-62.7931846870391496');
    T('0.00000000000000100341179', '-544501716519662.633193865233920', '1.00341179e-15');
    T('0.00000000000000351499628540049570637673', '-223431373521.7926681956463703562745846396661', '3.51499628540049570637673e-15');
    T('-220603353886874667147934643649.87295033625852695', '14892.592908', '-14434.15489033625852695');
    T('-0.0000000000000001612847241392420250768267369', '17433478642639304.4236073577621811634134', '-1.612847241392420250768267369e-16');
    T('-1883174595828380403709352050091085026369077660279268.9', '-0.0012895', '-0.001097');
    T('-125549014214.7375819121786172926612698843039792917253281', '-101.5885766453', '-100.8153792133786172926612698843039792917253281');
    T('1065766474589037077293252213448', '104.84555', '81.7216');
    T('-0.0047533898584759553535897361825760775807323217889394835', '-18213101567414468503998329412491692494599546949.8', '-0.0047533898584759553535897361825760775807323217889394835');
    T('1270005291407.8881300436', '4138621074845956468.09769209', '1270005291407.8881300436');
    T('-260441856275307932803222450437995247080731478', '704992903069127.4325788', '-431855187882906.333326');
    T('-0.00000000000000000009754763692467059466885260432113614665268499743', '-1095452837.106034703346392429672156', '-9.754763692467059466885260432113614665268499743e-20');
    T('15.2', '-9898.141488362', '15.2');
    T('-4.642097816103323517795932640', '2320173035769155029864.2360071417144711754883993503027', '-4.64209781610332351779593264');
    T('27232043073441728507866158240.138995261078', '-215290045818292170941580969748443497', '2.7232043073441728507866158240138995261078e+28');
    T('-7820551181460133788154158506805766936661586187217825438.43', '9043807302.81268', '-8827979159.46068');
    T('40454701041551859098452066940764312196468.06490346453770', '1.43336157528769251880838', '0.053020665769834197966');
    T('0', '6893071800513.175', '0');
    T('-23294105221282442798534198559904763230604376248570', '1108006854160532581.643019501', '-634324850398077026.428796591');
    T('-70.48', '425148951767015.661297750583259821000170', '-70.48');
    T('-40097263.65021696329198038628255519578725029828361985869', '8008783649.929271', '-40097263.65021696329198038628255519578725029828361985869');
    T('-3744957147569480041094559658.8985734744', '-1.39589737574796529539305515486016767152', '-0.007414375129527604087594017204876948');
    T('1', '12243765348634238072286305372976115524601373993259986307', '1');
    T('1133226250873003731000285272922.678821486883559776563400259', '-48449121713.05851357863749277194726', '46399517902.028653911554106994622540259');
    T('-1110.00985672050392625354008504049692', '0.000000000000000144467905969585159040405525015114077352752345766119586', '-5.0667226393916955793430389451065661055080904169044368e-17');
    T('281516884461013501680.63', '-1.4', '1.23');
    T('1424834076734161906.49994168746374', '-0.0008975084074165482738612610040251114952525910764632040285', '0.0003696875090618801911161885049781983725485998646848861645');
    T('-128763476617069.02187580755667', '-6603.36282886993434', '-2812.31711094080867');
    T('572750920744637008914545508209975834156579.5795909538492834', '-11502534832438064096814', '5.5309188778180859429155795909538492834e+21');
    T('-0.00000000000371736421699926447258798163058670009', '257486.470069146779', '-3.71736421699926447258798163058670009e-12');
    T('-0.00000000000000130129857', '0.0000000000021237415884955381438534891507974579736322323393189949494486', '-1.30129857e-15');
    T('97510480169357047959.778521006822362538', '-0.0046089528809', '0.003841092011662538');
    T('0.000000049938779602084071943723403', '0.00000000000000000040598762102204974283610961143933322030167695316672919233780', '2.328791623754087509772477793320317342677727105556945004032e-19');
    T('-0.000000000000017579612833728413841360648325607406735458075688296134041848', '-0.00000000000000000046795016181219', '-1.29104929872111360648325607406735458075688296134041848e-19');
    T('417587148573267450086061214415849335522635545129971', '72162262599593511511391535.25753637130715', '1.588290674385543384224627617743657423135e+25');
    T('1899704999505146.65318875024320183643806671', '8011298158372506449467236619268.06739540', '1899704999505146.65318875024320183643806671');
    T('-0.00000000011026161484148139283420032525', '3', '-1.1026161484148139283420032525e-10');
    T('-641378081607809826819509989054058308747306', '-32614433220951683931.97290822167335112076028624', '-32321533365320656543.47914416134229484916012224');
    T('73426.2174993055579013322865502961038551', '-22991170194389000791863400240', '73426.2174993055579013322865502961038551');
    T('0.0753432448671128796055779867138537182985932603289568836', '0.000696623968026162316598353569181604985489965', '0.0001078563202873494129558012422403798656770403289568836');
    T('-77918852302.666', '1', '-0.666');
    T('40834438105282568531887549132894212920316057.4119', '-69096.2816004', '9282.443256');
    T('0.0000001081007656128892877603069470142579', '-146763.9202434867', '1.081007656128892877603069470142579e-7');
    T('-19065040207291206222014126191923749015295117270838828148117', '-59458447985079036923403398069307106616288796371525.0', '-6.933918951125046770982521962871037753580749088442e+48');
    T('-50.454890710', '1.57811064514885740036542902647362298773', '-1.53346071038542058867170017931768738037');
    T('0.0000000000000000029130545090762297054692', '-0.0000000000000031732390760633505614997707573729383', '2.9130545090762297054692e-18');
    T('-0.0000000149477116306405895605823556902142791919238574341861798', '206795087.6', '-1.49477116306405895605823556902142791919238574341861798e-8');
    T('0.0000000000000000071', '5470646583815966704709512378933741816164381248458912550', '7.1e-18');
    T('-2357250201772857325710', '-177521457545596938.745399459682135971137972095', '-120288482421173048.58597434059857523000652259');
    T('0.0000000000000029091', '-22982331952112767752908263644179706433315770.17359251594', '2.9091e-15');
    T('70410732817903246800961841933624181629.60085297037', '0.0000000000000000000103454336294636075289', '3.524329949160506449e-21');
    T('-27369983157.1458440282472352878', '23.763912432052919566354032773607568646834308263895', '-6.32537443505237861917552362621110083695094947093');
    T('65056.653', '32408712.331948093248921801757883672', '65056.653');
    T('-79299703594581340711344589476907732591.49009044336', '-105750.084896815429373214442762165', '-104265.478222642869860762619825095');
    T('0.81012834507591033602543', '42890384.300', '0.81012834507591033602543');
    T('231647806.280', '2306380.2577620003122660083794072550721890979450664365063025', '1009780.50379996877339916205927449278109020549335634936975');
    T('-0.04266283385', '-231833828.7857580897334', '-0.04266283385');
    T('2.9617', '-417567079608596894283345450125373793666347.08065279467956618', '2.9617');
    T('0.00000000000005671393697246617', '0.00000000002372488709978367633405147788335971135485863563547', '5.671393697246617e-14');
    T('20411507237949901.00007048085657674491003063099663777294', '0.0000000000000179718685180331186307', '6.87219923858062022287294e-15');
    T('78562464348554551960.51656952881040712219428', '-360452902524757862924847627712001.90071009646781972063', '78562464348554551960.51656952881040712219428');
    T('-1784.7', '1.107', '-0.216');
    T('-21207.62887', '-30083662469912.93830185385', '-21207.62887');
    T('181794573664525362505571198963.74048513161596812818', '-0.000000000000000006966183124261834480', '1.44054114626355864e-18');
    T('1497127573695.63303', '-7299620151322256127312252586', '1497127573695.63303');
    T('-143331341997458746373473632414689879129001.0510139759652713223', '-1039245311665254920360224447402081.203667', '-4.163981858938863521252654102664372514539759652713223e+32');
    T('-7.42318768495154312740078', '-5725.37969786010009373491349369', '-7.42318768495154312740078');
    T('1.7', '0.000000000000000000358545942655', '3.3438498447e-19');
    T('-0.0000000000000000230187885344529285768794826532', '-97947.8515169117863685621966428355043134881268104806819344', '-2.30187885344529285768794826532e-17');
    T('0.00000000000032661966', '28146830442002.99800238434978678633563002677', '3.2661966e-13');
    T('131444649737941070', '20345737092636.1111991821569377453431132947653', '11188119511791.653283266182165083488115816162');
    T('-70.95', '0.00000007627177390524757759931', '-3.355915079851121925592e-8');
    T('-0.0000000359844794247092743644998506637111', '-821842552305272024445101236331.431697024181064278117', '-3.59844794247092743644998506637111e-8');
    T('11559244775803152829995363390516552788279232383634', '-0.000000003810335052601512043915061311335400346835301683933', '5.89171798463495478689746049513730071363650371891e-10');
    T('2527.74183', '43431759.31595200153', '2527.74183');
    T('-6716182884374088980171.84153844', '74722140.737467381748608636560886010812295783760526770', '-35823304.85096169083049875979729671181231669302395569');
    T('12972207321585575187726304322503969808542965.246569633947495', '831901009396237267279615788531418438.849563723', '5.26615819172264979504828722953264235810155283947495e+35');
    T('7665883776671616025905367508643801886903976481377913', '-0.000685209961385', '0.000289003802725');
    T('0.00000000000000130', '4084984.0344696574643138186852656784876', '1.3e-15');
    T('-23744.44703412', '-346011607426.441393159348354522971440097840365544826', '-23744.44703412');
    T('8434642778165686647233872583840184835847700452.5722438', '46', '26.5722438');
    T('0.0000000000000044601453487291992988959798617835937678162460190934757181', '-34957408111696949000006895.170094', '4.4601453487291992988959798617835937678162460190934757181e-15');
    T('-717775516482666361197134085201665528104789114410', '-2', '0');
    T('8276714696969298506623725320011988.89729', '-0.00616112392295074383996719947907960025278866567521351783', '0.00016560800550555404330800366686568701046935505208586586');
    T('-742605.43840212025', '-33.033107325052', '-21.18573495129');
    T('1172677829393895.629925304143622500366643409500207216001030', '37.100', '5.22992530414362250036664340950020721600103');
    T('10537016513706770761008.26248373823335994957890378', '94969063464568723440795883667.8253648809642701', '1.053701651370677076100826248373823335994957890378e+22');
    T('11451.575753798226574650597066008283798', '740458328282622534051565222682743827901164966582017856', '11451.575753798226574650597066008283798');
    T('1.572', '49515379454772293729194042647.91538', '1.572');
    T('-1', '7.059040', '-1');
    T('-34927437284064606817941117126.257390774', '-8736962940.827', '-3438064168.261390774');
    T('25409.947283363583521450111285770286331002016996164554', '-50439325984133502226433618670969699480790', '25409.947283363583521450111285770286331002016996164554');
    T('-541726513791047904976207535366014345', '-406733502885622404519647553066345.1969741566', '-3.642214502844845605566422347088878273975654e+32');
    T('-890820344589514985.0665574100007448', '-159324785981391287370653452100749211478426067970583818.931403', '-890820344589514985.0665574100007448');
    T('515196923836873751650822811674732842614640352.18206884311573', '440807068101717819348891.987', '2.0134973484292983702212721006884311573e+23');
    T('-443343.14120147', '-81519350429738153710983021502973.9213162228', '-443343.14120147');
    T('-0.0000000000000902702192042232797334789149068563741867484672231', '-7320', '-9.02702192042232797334789149068563741867484672231e-14');
    T('-45277903240084126.84557360106009', '-20896812318476199906609422.521834898564460854802489', '-45277903240084126.84557360106009');
    T('28165869957795828694237799735446687517170194.348151719250977', '-38550284385557947404379815866117040.122550', '1.842769006556153994091762719885883071901719250977e+33');
    T('15021482085.44976192138587853899725782258348', '-9904.699', '5677.35076192138587853899725782258348');
    T('4917.303585861', '-18.964359', '5.534604861');
    T('175476267.7992032958565', '-1036388592.3909824125745400050986887954', '175476267.7992032958565');
    T('170405946320111', '-17818386128487328808126289961', '170405946320111');
    T('8550180809850301212655626511667743382400090.02', '-6540107956116752962567.2', '3.55071180489327368509322e+21');
    T('-818705136461275003.08078930092467399502130815326105604518', '-39778740814076648429007.124204603754658', '-818705136461275003.08078930092467399502130815326105604518');
    T('-1.20675758374006649995086560', '-3', '-1.2067575837400664999508656');
    T('109.3', '94.6', '14.7');
    T('0.000000065573671480225125603602776141267516038374303', '553.480300880442516', '6.5573671480225125603602776141267516038374303e-8');
    T('296362415.06624949768701', '244445717421187779.650675510094172662242508672751839189', '296362415.06624949768701');
    T('29374332532.3238432343394', '0.00000000000000000005936857517089413921548905299963269225088201364509247681385', '3.119291720989480852560154607439451452770778662623725737015e-20');
    T('328821752173776490.719819431468332405273703018690', '-2542341869177777917056573693425171357215.954882228930423158', '328821752173776490.71981943146833240527370301869');
    T('-0.0012143107904367445170056', '-1003.4406', '-0.0012143107904367445170056');
    T('-3168184610490460.8945194460195', '-3573568062298202180968377963159', '-3168184610490460.8945194460195');
    T('-16901853866719201501332692.8432369358905099363918280445405398', '-31691345775963588152383111237433553165931816.117915', '-1.69018538667192015013326928432369358905099363918280445405398e+25');
    T('-93621088901252.29805520418', '-2.0188684214862682192621695358466139055618', '-1.8934621792649249958167189632731171199736');
    T('242258091070118423201219529950729719863290357823444711.8', '1108727758065732675.6587799039404934075575195715350085051', '882685173218682761.8921148545569801605823909846489452171');
    T('-3399066202816.303625', '2618943', '-318805.303625');
    T('-28834481903864652309.71183', '0.0000000000000004565222353934092602845491745327666313637270997826', '-5.34810620719243797216459942508340612766671723426e-17');
    T('213672683755841644553544017650723723396202652336.302605922', '-0.00000033677276118692029744817391550088675892', '2.934185014134463864485655375166849324e-7');
    T('-6', '-999457121904797189706147649392540679689483876019', '-6');
    T('0.000000000622195463951304359', '-448.8352331', '6.22195463951304359e-10');
    T('0.00273159264338707604', '131503167', '0.00273159264338707604');
    T('-0.8826707721080745', '-70.82', '-0.8826707721080745');
    T('-6.169582503328100', '-1', '-0.1695825033281');
    T('161790666328890520068178.994438807', '22534.8', '14223.794438807');
    T('-617570557615637.65256125752701839451975945', '-0.0148696896889671858', '-0.01332652388531174471975945');
    T('131606.29662152417276937754010546930907406', '0.000000000000009288216788868504125788635720602972497436211', '4.548851830590558791346414703724411897415634e-15');
    T('51.3977490595725037876457161936459379346361103', '-143177764436300664530563651.36873324', '51.3977490595725037876457161936459379346361103');
    T('-0.000000000000000000055480154187811579505094934438713145361465492675145621278503', '5', '-5.5480154187811579505094934438713145361465492675145621278503e-20');
    T('-426820677348783115368590283660534000419588.633035253', '5649682945695760173704.00', '-3.898820592824218831748633035253e+21');
    T('-18877995762227202359719425947641943773826', '0.000000003168736894305713249647662065', '-2.410163138756323232829425645e-9');
    T('-230734625.125675830245801', '-24887751.105039540142964', '-6744865.180319968959125');
    T('-2.55', '-0.000000000000000003328273034182616010363199785', '-1.2785182565162876532434802e-19');
    T('0.83072894855068062175257214671400', '347832.9728307138', '0.830728948550680621752572146714');
    T('1554', '-0.000000000000000009695649707683834887551815366596414977600762431389183799355', '6.05878904773660946108899894496980695021759226671044100733e-18');
    T('295506566.953646020992273150648001797147299', '-21973527294862.8233628', '295506566.953646020992273150648001797147299');
    T('2181379173600069460.2272418575314841', '-33121557.64630663141', '31392819.5003625467214841');
    T('-1102425661172241572593712529.4318', '-1655029068876808.4683087946075879962249', '-666832641952964.5659918135994689948094');
    T('98281131957208481431777620.35596736255967554627181769', '556842234645404079383345567305273.303513803874857641931', '9.828113195720848143177762035596736255967554627181769e+25');
    T('11835752763446.82223054394121198', '0.0000000408069264362150926140815302294483025590', '1.2484009569088335298499242835706081261e-8');
    T('-50148655247666948.0767382', '-374032530098.019610', '-243774774968.8659882');
    T('-173042648372113278197497944864583449315536350193384127', '0.0000000000000000000366841720', '-3.265408e-21');
    T('2', '-3771771239046067919037045', '2');
    T('-0.0053190456442251124794436212618', '798725962261113.7', '-0.0053190456442251124794436212618');
    T('-370307', '152017395754118405461987924364280', '-370307');
    T('-277699892815627339975120', '-143.6810986', '-27.6564706');
    T('-5775916.6464283799155032293780149633514899100', '2134.505358', '-2079.65303837991550322937801496335148991');
    T('1429207694023.57717520337', '3', '1.57717520337');
    T('-5', '4', '-1');
    T('-52848862092.572286019', '813661418640716426286793.75702600471722081556694278784', '-52848862092.572286019');
    T('1844275644561406088.1', '66184292639.361611328054340279', '30103188873.61915648682705296');
    T('-195554.912236539033400998430626025643711716348904995', '0.00177428671859871088664745504177813109978841798', '-0.00128510649380978957377209918017012798784363842');
    T('78.250868739', '200592382754.965094921301649595609', '78.250868739');
    T('-1.605', '-0.00000050108803722427943381', '-4.8521755346940298951e-7');
    T('-175950845282749621749.3060626398844805224872563725036868663', '-0.00031', '-0.0001626398844805224872563725036868663');
    T('570951706006271.614500911029949202716327198256', '9579594454359595046.96141239240213595155989807741151781', '570951706006271.614500911029949202716327198256');
    T('-101348056.99', '1.2', '-0.19');
    T('0.000001115108462416442750881276832385920295416166957454340', '2.391104283537695024603255485729184', '0.00000111510846241644275088127683238592029541616695745434');
    T('-384.29267210', '-42.6115840552808285042372718273816', '-0.7884156024725434618645535535656');
    T('-0.00000000000000394320', '1490433052780511340442598422397421169.9727476', '-3.9432e-15');
    T('-2', '-124412814393298131.63102541685397', '-2');
    T('39255373365250694983.01012619735480364604931589', '0.00000000000028924174', '2.8356244931589e-13');
    T('83649682374745658097928332400566916840.904100062101', '12515556884', '3441295412.904100062101');
    T('-37978362152425454856329406585920723065797640812416', '-40807030880665280609832.633548429382227699775', '-8.44139811680207521268650854435671218648655e+21');
    T('0.00000000117630746081997641552101447', '126289176518.39164497878613023988707803064880568', '1.17630746081997641552101447e-9');
    T('-1880854096029528626232093236836285358.8229354826767064', '-13.55', '-12.4729354826767064');
    T('0.02073', '607.8621233700367', '0.02073');
    T('-804231633252810472161116.753061839', '-51.139385439676348957', '-3.050773812069762116');
    T('5877876231822600040431086011103959340188703599.31851144', '-5388452483964553888.345931647692324169003115975043825880851', '1930961800526326288.60986182402199524006990099301495612649');
    T('77946964651085243.218457918863112', '0.00000000001144602007465348949097950134087916681540997', '8.85127498118220306889399715954400610693283e-12');
    T('-288323254635330759933511.4835', '-0.000000799099661848570195554780769778567229952228099', '-6.07308413294153274384235191515598586543048706e-7');
    T('34156.9612032703394033850068373910911950393885281598409066705', '-790.014721903868173877309773404251366', '186.3281614040079266606865810082824570393885281598409066705');
    T('-62309462096741992398456920.82284105487052640595', '-0.0000000069200714440436038475285366066199260381235724356693', '-5.1591434837700767752333272066996752713093302820209e-9');
    T('-0.03081418420901964033772890', '-2258.6097737546792912978930040107448576', '-0.0308141842090196403377289');
    T('19440352005832939832434953349.524735305804224848165284560319', '13663546035.3870791', '9500641135.581258405804224848165284560319');
    T('0.000000000000000000174792814753795064312182753542642524992498259236217566516', '-77523522800322397605770.38924241467650641624', '1.74792814753795064312182753542642524992498259236217566516e-19');
    T('-1815265994282465978739.24367005494108', '0.00000000000000000687759', '-4.05185e-18');
    T('-1.34345147096631', '-6865002719881812387470285582221951284174906039012461831', '-1.34345147096631');
    T('-1331063.88165', '11341955270415278370914418086588317083074.0482', '-1331063.88165');
    T('2.046', '-0.0000000000000005877097220931', '4.012083803814e-16');
    T('3545.91036649009998376741645699670257681183407320627384466111', '250.0', '45.91036649009998376741645699670257681183407320627384466111');
    T('3304.02', '299035.58', '3304.02');
    T('-0.0000000000000000000942622', '-0.00000000000000000025221802', '-9.42622e-20');
    T('342502985242332681201199551069.576', '-25743002421256401.04397330499669057', '13427630853006016.61638681371921084');
    T('0.00000000000004233681060170499506821015920037', '255095113757561337754353944933355753406.38155', '4.233681060170499506821015920037e-14');
    T('-28.5269472861067005353912', '-270472762833365.3801132655767', '-28.5269472861067005353912');
    T('-277847759.515216', '135166968528972', '-277847759.515216');
    T('-29856675437162421995266099874726439278', '-19896996992.6267371979256450155346521949519355', '-17602172309.435172515150769689705114114019276');
    T('2', '-2017800319934087984840833728734', '2');
    T('0.00000000000000007184336760908973', '-579084.38782881989356541750992', '7.184336760908973e-17');
    T('-0.0000000000000199905729465678002272254515680192399295794760827', '0.832997729248146391449238508309446517475', '-1.99905729465678002272254515680192399295794760827e-14');
    T('-0.000000000000000127832283699455', '-17051853.75327', '-1.27832283699455e-16');
    T('-1698692.68276072', '0.000000000000342190555852264550226068807192', '-1.32201147548526749368535158272e-13');
    T('-89715846809778312.0866002761050235922348184666331', '5683352', '-4378864.0866002761050235922348184666331');
    T('1867077.167389665646672502266524422230512016', '-8121328626157873800223785135.111300799674416212197931655390', '1867077.167389665646672502266524422230512016');
    T('215901.879', '-29.8', '0.879');
    T('5119759698.60147051603509092616983122712457476', '97582629730470.286607', '5119759698.60147051603509092616983122712457476');
    T('5632091904144.80457549', '-260531502143715092510.9558622691', '5632091904144.80457549');
    T('-0.000691477562292642246090904144721704048411477714', '-202833029325548043615849420487515503451726003', '-0.000691477562292642246090904144721704048411477714');
    T('-5014290818995813355670219945.489013253728448913277', '-49', '-38.489013253728448913277');
    T('-1.19', '1.14', '-0.05');
    T('6.01200548016561079', '-25.3', '6.01200548016561079');
    T('0.0000000000000008934209997058692257', '-9845722515207.841', '8.934209997058692257e-16');
    T('-8271.180908766644265814', '-532.21', '-288.030908766644265814');
    T('18149268424457.205469', '21102403', '20109889.205469');
    T('0.000000000000000005630166790779595999136', '0.000579481131868747005452691950764827230956628754512075686', '5.630166790779595999136e-18');
    T('-0.0000969512096310107418573215633893505216', '146313161286844954805207556174167131617843885.68176097', '-0.0000969512096310107418573215633893505216');
    T('-4.4', '-6.1775206278626', '-4.4');
    T('-534834.70968332438874787934900992041831587', '-38363548234134309078598125637011026.84251944598377781303061', '-534834.70968332438874787934900992041831587');
    T('-0.00003406607808', '-0.0000652979835334948349904827499755959633629915945362770066', '-0.00003406607808');
    T('-1', '-2110983581171793713817325.1475619322694002968191006', '-1');
    T('-80227305.1656', '1944676344179122208154551672251566716245569224444.0', '-80227305.1656');
    T('-45889999955242942968871808966625304007272799508621', '8550404.862499169389885162309987843918802343917887', '-4729231.891447747380274990179385678025799484562412');
    T('-27878389918833569427320729603169170858.95474004228507890192', '23932009803269840591376795875', '-3.41193385706058529612983948395474004228507890192e+27');
    T('567202319309292978520604165782060160263365186515328568', '-11334572195439351811672.1473522129007618', '8.0497193228717959915213827171314311074e+21');
    T('-8697359171345893713842426564522034778871562.5154932', '15619404167072.618217767650', '-3493725216866.96939850825');
    T('-218.363776', '697131146810968473489.82299654842890962', '-218.363776');
    T('26202481114591937993.735307329625927271775', '-304156997.304184411106538785706126202394720899', '140113250.272976945765125367941961760435198404');
    T('-0.007731087980246464302345811575', '-24413038924588027145692146.387588856788321', '-0.007731087980246464302345811575');
    T('680497639988324180.39625512073408', '-4532942013750624897951996571799269425412122', '680497639988324180.39625512073408');
    T('-0.0000009293033204732942233089593840249955775555658283600103866', '-173511.41982571409206143199884579179605', '-9.293033204732942233089593840249955775555658283600103866e-7');
    T('0.0000000000098336953795657517132120257800838', '23300757376665714817666483157023722058388.5033214128449579573', '9.8336953795657517132120257800838e-12');
    T('41084687427290874759976776474299799533721185272283', '193585163.52662', '163743760.94914');
    T('-116.95132', '-39255072372928843286086966431.00', '-116.95132');
    T('2347142650267689935587322698.7284595028691', '-3', '1.7284595028691');
    T('0.000000000000014286361610', '0.3810969482393140582407695856576689976423039861', '1.428636161e-14');
    T('-7308074599589641011784024611055476301285', '-2979647.083231856789860049490151382783519022739462374', '-41940.765367177770459610205511353021036633288408806');
    T('357753139664202.5873944', '-41.95942286390296', '23.4743830801152');
    T('854571067694022997.4884', '6537373963.3180845607368152893095548460', '6053336053.291260561298904945337925438');
    T('-0.00000000000004386908462560891112864885989973', '129740635819911122760039.7464589619454', '-4.386908462560891112864885989973e-14');
    T('0.00000000000000021290574183432875072166863135108510281580702', '61908914489485349291471752909373768165637670.8208', '2.1290574183432875072166863135108510281580702e-16');
    T('2871883224301570575582468652.9376262287274595077514806', '-0.00000152916795423240707414339', '5.3155439780727520002144e-7');
    T('3', '80708788610217964553584510306368.549353793563', '3');
    T('-10835622995844.77266724348161957054233451560047028326613046', '-1175193791680339.76056817361012416666902891954476177079', '-10835622995844.77266724348161957054233451560047028326613046');
    T('1025038648031221253.57383030896217', '-5242.40711853563044167975', '2542.2793327788128154595');
    T('-0.00000000252', '-220187026862816215614922589820191309081445441861274232.84', '-2.52e-9');
    T('2438882128515521004992810616244816644660.875', '-14585625494005545128827621', '6.211192260353379557970309875e+24');
    T('-1253637.42184071686942470', '6043.294', '-2675.5638407168694247');
    T('30.3149681983737', '3.96', '2.5949681983737');
    T('458648663984496211521246069201336181', '0.00000000000000041796956694972368386032730115563266442065659', '1.189340470755219691379214537787056846685979e-16');
    T('-877569106991311.769260729863', '2246530785645583.53767418', '-877569106991311.769260729863');
    T('-33180244.9424', '68040037.571844483716882853268188712468340362', '-33180244.9424');
    T('26056925297726128046555.65872815844589322660275', '23799748744565261102060860.628349245228', '2.605692529772612804655565872815844589322660275e+22');
    T('-2.932266679268', '-2061492876.118067901623547245130932150882910', '-2.932266679268');
    T('-24303392384298907971178613116155773044858954198134', '0.000000144547733182595133021', '-6.2763446759435083203e-8');

    T('9977', '793339.568052455522323049704543732060826', '9977');
    T('3044797849984420605285366.474651143157', '25186260049851668345583291614301619318511974775753812002050.8326735955299366787084106211969141751506', '3.044797849984420605285366474651143157e+24');
    T('639737463904283952640443433078141655542321388667481890755297474427803997023609757112922145297681502347448794470168805201764741986941', '-14552442514714892538227035420.61249278214225741', '3.07716512012830819205367001585789874568359778e+27');
    T('0.0000009480666812553237528290117310639076036954221787358487462393246935364400792376', '1.0', '9.480666812553237528290117310639076036954221787358487462393246935364400792376e-7');
    T('16673429143256557896853574875292172327063389650998117777668136985538005.9156698099892691658894660539763873869793114863329930039146096813387028', '-107478408440617999633969729.9071529239187240331642550654002067338975836414285167506215860', '8.20260811545606661396908107304136068380872993912615354808000919495595106968750582594596813387028e+25');
    T('-2433298586307081.77465641473337660801763802817481653388429397435772288734383710955919905923279924807', '8945608818026652762135420517379.424606537007', '-2433298586307081.77465641473337660801763802817481653388429397435772288734383710955919905923279924807');
    T('-70843295832985633806095066724872543838444364150876355516508644344503020757888058408332911592444048015580157647', '159194370214483300881159411658565511338185028333524386712582766324718381977826309423371642975467856662959008464353958219661', '-7.0843295832985633806095066724872543838444364150876355516508644344503020757888058408332911592444048015580157647e+109');
    T('3.2263', '71756256022538928427069542438.00966178692388729446382444038774751007836179716329976575691385315023922435789196791754653262230986812059146', '3.2263');
    T('108061134.3910585273259047952072200021695505338334592792817809710438', '1260951025714501457005284501987116458944716243549637898428510181316826466436575714044748818353924236900363398289', '108061134.3910585273259047952072200021695505338334592792817809710438');
    T('43607983963968869595947769368216107706521387015680146006305613629433990860442947600228456010092', '121385730326389922895424600532542775257956396540395781939587936260842487516174244325430.384295616198856908112758', '1.1504925896106825966642741273863721105609952802207648727165046290817382897631508088378461034727326937297965944e+86');
    T('-2.6480956814', '2148671523057716670055099537649941488566244507589768590863804139800870729193528442.071130969310679730958621114', '-2.6480956814');
    T('-470479333263.84377245126007813562135983915023544360010239389244912214130585392185699431847364158901094167357758815083446794565320814454973581796', '27849448232164647723510637195798019946766053448137414448566670989993.67717797401551478004030639298176072944', '-470479333263.84377245126007813562135983915023544360010239389244912214130585392185699431847364158901094167357758815083446794565320814454973581796');
    T('0', '-6993020667326513594.01598727239030644128692238032346465300777782504759087255641592855556786881965341488969418534051814789', '0');
    T('-10372286284244779022048585', '-0.0000001930730138191035178741471788596965420386122185118633654121349245216394001018297980054707996074710125164147', '-8.47592995170001700266169749815180334434465081954780254569435821161404742961756995939834569063835498482552e-8');
    T('274897009856813.734380955979520483734957204601027214931003941720546146487845256149072527968056465339318846303131569226913408938616354923540700172412', '7', '1.734380955979520483734957204601027214931003941720546146487845256149072527968056465339318846303131569226913408938616354923540700172412');
    T('738408012842109785457164849764507323379297.79095792233769102310198027453532813226348191188862586945019214410536832', '15306177324248047715406533.5158700026', '1.506634005344982055089315836033881173769102310198027453532813226348191188862586945019214410536832e+25');
    T('0.000000001307002813605936443383593439823579112009200431906135937099617451361199016339230482184530115838223218189460633917243083200', '-156347131201.0667716470724866', '1.3070028136059364433835934398235791120092004319061359370996174513611990163392304821845301158382232181894606339172430832e-9');
    T('-4792567274869561212802263.9162146352653952716695372928501404982289832583166534206544945624150460220976057951121526613072397239125750526383369389', '-2571615359217819081745372380499521952091705406387642084116393860754896982150026573094709965566690085424189906211974018648786870967996877095142', '-4.7925672748695612128022639162146352653952716695372928501404982289832583166534206544945624150460220976057951121526613072397239125750526383369389e+24');
    T('-40.05748869168454725527441481953494139473673991070979113635160468475219376406826789262579745739976', '-41875468662578995790027634863433077814557063632577215827031.031982081918392876105825240291071725658144212578666', '-40.05748869168454725527441481953494139473673991070979113635160468475219376406826789262579745739976');
    T('-0.0000022907766811721016183225617138609000543876574860984718810338550238748128247445010491861049613', '-3279074504656188611648707.4983942082641992057679531912380705659521798322669577604617597486447068188912830230847051445600458515668443081070949175', '-0.0000022907766811721016183225617138609000543876574860984718810338550238748128247445010491861049613');
    T('-0.000000000340313277', '-0.000000001255112168870655023338247473949331250106676281883642901353991', '-3.40313277e-10');
    T('-50225365.1475566438998761801442412', '284028617245837000189928101232939099744527904229835535.835746075', '-50225365.1475566438998761801442412');
    T('63.344721423304857459331086841825237874925064097', '57155073593666.40553442288889921516416834083269742567707391607', '63.344721423304857459331086841825237874925064097');
    T('-405919933.1066287819696386581647229483641869199888974504501408794124002251348919063696581146156799005', '2647178729438306865645909642983752549443679075960964976334982663855617.77', '-405919933.1066287819696386581647229483641869199888974504501408794124002251348919063696581146156799005');
    T('-0.000000000000130754174234156809102364575558', '1512769765054847098913787446631276445464675564737758845532029029227218416561642292270741819169983956650914922547871552583245517440681359875', '-1.30754174234156809102364575558e-13');
    T('-42805325218726498366672740080295203192725414965527973209314316749.7120445518644682586008052614425260815242140724520046592053081', '0.000123298332335657505901061098051881119196170384724006568439947745355121025753230625359269654114501774394590171609541470588517', '-0.000032325304000891296915093212441483965264186154572168660357953720611674306961720593830907904561258705086770592138813164224068');
    T('-75210406056668422373802918016368260769067586508935441638493539318778550326.50528533489988415483952', '440622997.6355053630471029', '-340429684.42458949795004585483952');
    T('-1222922824327546500522220970819290434122898473371530650066004876062845284114.47721875136651190', '-1379027454245733767586', '-881180208974102493198.4772187513665119');
    T('-30656582150188875494703614722772772221409126232115063256882064964663663147033209144753246762464712.948730003091026599897432459556025696', '-2913934951186033025005819092772439514996587951119743767357433798109195725658300879072952407504422194931477368634077', '-3.0656582150188875494703614722772772221409126232115063256882064964663663147033209144753246762464712948730003091026599897432459556025696e+97');
    T('-6460522065030402275014019.2874194931729240210323452441436174892', '-84550416554285528170014238135907266547165974999578715609084038263.46129840157771271779704084743623515311185778729738812', '-6.4605220650304022750140192874194931729240210323452441436174892e+24');
    T('-0.016364386296444405533757351682555346465502820950062088651150128675773350177464733695707386307349689534592475248473689442', '-662351516465.9032743599806965674027961010966377214913163', '-0.016364386296444405533757351682555346465502820950062088651150128675773350177464733695707386307349689534592475248473689442');
    T('1103343525164099798605597537113983882179727144422100669678631936027042820706120285756898888893404677995338896062374110057717750895679', '91748792242920404655427917872546031638524.76204683127448751123961871264830271567888066463998429231705219642715054074868199195373673227635494751953719', '3.076328553647557636193208401331029365654020485144903415117912662361833098755573989373555529561896396760648323565651091850507799771898789127729144278e+40');
    T('-0.0894652716283348818337684886989151280762017763427032659791509101256464820297', '-12966.6884', '-0.0894652716283348818337684886989151280762017763427032659791509101256464820297');
    T('13114418006467273871814114136828793244459258873580991741468083458844936', '4759000553255960840361168620.3774494470837273198', '4.2761722071204063036259345611428685193209688534e+27');
    T('-28951495771059579052038784935583719855135835316878812739160571275658593082655402834569052032878823395641241968136.92574783376902191547024436698530', '-3031768663774740737176934765360849728180780437211886327623459816735182479695223019269147895285170079834032202516966937529989903070284157092473214668.7', '-2.89514957710595790520387849355837198551358353168788127391605712756585930826554028345690520328788233956412419681369257478337690219154702443669853e+112');
    T('2393723882767965821294763322394195744548891304060902', '-140981135960273230.0025778', '86668711566444988.9814302');
    T('-3224488416109581472101333552995382215707383396998952009319985210337309105631785072396803.91964338865842816515912815197781787', '102818159313377657005579111128189067224885718.140628085554012525428767372817189722551478405035418445112060974169840360487565259217', '-8.1595634025043932590241822413741540317627232887069206304733728507469999734166316619875329520357299837254473649437591096347440866e+43');
    T('0.000000000000000162614535957335504400161243268689702722565890737357214918357356590168738846464706769774484467251167640135858015634083627803179977581109102', '0.00000106803134832455205844954340150714254354766339175870844951355513521917239107042458407307482848507498559', '1.62614535957335504400161243268689702722565890737357214918357356590168738846464706769774484467251167640135858015634083627803179977581109102e-16');
    T('-3927.4031809', '-0.0000000035029583866611658486269733571456482523405154883369032001554318344330512146832289592781514675456658500756286236294841624823979375753461327906', '-2.6932691679676130460056959057199199083055272525449126446015947490329456323969370838199750438158748550553789684640297326857241719276712355958e-9');
    T('2592701578783037181466698143885146669128411307594485136303860886846006143235135122817836647040961317262173311873893155', '-2476735053659095937599211826013828027536167714634610749923083443278572078026871812469079060633677096037053974280521689349022693979242065', '2.592701578783037181466698143885146669128411307594485136303860886846006143235135122817836647040961317262173311873893155e+117');
    T('96.04335877730532081621787788158383111099350287030581038188446699532128180774027960706578', '19731419380883276630592147059117156462461951865864609673166.4479371059569659447212290002838890816175493435199181043231716596224989574671224595362826', '96.04335877730532081621787788158383111099350287030581038188446699532128180774027960706578');
    T('325023114939529014657978169628372760601480839073817238211782426113558723164836055970989007713696933704', '106223840476390782472173917090144170488887005908229635819404889799358852135763.040387492', '1.05150216674283695595324235267625323135707751092953285615150305395692443496735212656796e+77');
    T('-0.00000000000000033647992217979179179186957', '-0.00000000000000000003156150266634952697310752', '-2.74225383948473157029928e-21');
    T('67711097909563003399071203293654909244735459519561246144664768566612029202546308760389038038790661412078936611567061527752843866673871533', '0.0000000250914595238219383127319568059987481594970145735261435136883603429568', '1.1931039593784471503157310210681907892950978516052505236994695043296e-8');
    T('942307044555108835920493820461160734540503253601173239.92559776036964181595894387449189836528222244015903442453788542293705358104537', '-341315427404722210577937787468731.95', '4.792118403841194654638154768215812559776036964181595894387449189836528222244015903442453788542293705358104537e+31');
    T('-94130661760152187286400649382778774100247360104073487553172289492592909079685814047724040987.545360', '582.270609307311781203990506333968732999092917722', '-429.29359293653441023844377749905124203115916886');
    T('3313638785820621590180176562638.00992668522579291400041235393589181972606810182197653338554677836315505146', '90527335216395767852035210539.14', '5.465471803037394750690898322896992668522579291400041235393589181972606810182197653338554677836315505146e+28');
    T('-0.306955389372676043580907106603221153651127238512560719', '66.904579801977727781298', '-0.306955389372676043580907106603221153651127238512560719');
    T('141390900187450346.4446228025914244', '-255850256279441962530367023331027625163686895444551579538905939296353570502455036176395785785059148507467346341628419844281564795408561', '141390900187450346.4446228025914244');
    T('-31281694978574998092.32325767151', '-1542462855.73276869937293894166028800355184049470473', '-519767223.60416992161136296357867627633975428783569');
    T('0.00000000465065764192519767209223768411174160970559048882576195807880851927339930867660413363177803', '695983282190820825900286910552083743912340874031142607911981006600892487992712378.27501435873441215408642204715421306049', '4.65065764192519767209223768411174160970559048882576195807880851927339930867660413363177803e-9');
    T('0.000002299699', '105', '0.000002299699');
    T('-751157538.56375056723760379542086174039490718435868835658852', '-0.000000281235130627575144572363209737439923', '-2.4952865744315606513538295859410866335658852e-7');
    T('-1492151820229229.7080972636031810741838557504286290118227845200639080208767965213313891261997405771908981', '518534900915966328248424169467.8926376495890764066267652', '-1492151820229229.7080972636031810741838557504286290118227845200639080208767965213313891261997405771908981');
    T('477573736732380117689005270695410306243996300502014352674644518059825662478485969426161545468188704450446835856', '-44107433160804154887771872206618010747863690779283512394813143542934429409262133052168377457307.7801829320544', '4.26587795612760356325706643922768450442822164299827765862986444105362242670998534111196655345782505509351168e+94');
    T('-1708419546267714621908304198526.86627770247445328880', '-6561936.23828726436959004970934079513865615878124751998092886724055429258975571944079950471550813589210381712752008129366876', '-3255473.411304257056507423459569857877329230063250469248244750150261213529383645499126139366386431281819493395691345793149');
    T('0.0000000000000004527321152996104608068898547927166509996670208320178171898523653701667544358478578289218730097763063669131852', '0.000000000000011707656496202100248575019665652640050450842478555351860415163190039866', '4.527321152996104608068898547927166509996670208320178171898523653701667544358478578289218730097763063669131852e-16');
    T('-404484', '-85217.71121979405', '-63613.1551208238');
    T('-18533', '8494505138020021210045546239850616033745106209211751083199296574492725741699134845133691829140.5819', '-18533');
    T('14584780882835094104107586638253636777793348510840823526783209012506801757754406089008052927648564160645244670', '-21080989782.41894706651964371557621722316246417', '17111578889.18009353060098900510442621989297665');
    T('-18850349239022849269493437768828110069.075', '-266968030820801670345292489489385463532596835667614989691512484830998922088460557950927724249457393516001647830350289181903170.7820256518', '-1.8850349239022849269493437768828110069075e+37');
    T('-19610683914857783540233383.2728721254117951549911093483423563874335264906700610318012707642300033397357755301605728080', '-13420179588.2352455625807856166075321914322366264262368350508886102902970310625894710130400', '-7601279880.505746566871435903625090660503811218236450145616817130204180995181500543203615530160572808');
    T('-124398303.94329995879106090298579425682430326155902347006975479300049695495574497472662209495203134041033423161', '-37909502210888557786693637049239639643429705500565493503854388407978303534883740337011543195819593982677420420894837793713.5474583522280847996415528834', '-124398303.94329995879106090298579425682430326155902347006975479300049695495574497472662209495203134041033423161');
    T('-481349016.43741541655560095983436187596328463184925547241485317034574087191806756468994011864', '-0.000000115888750399354267961415724244044331087', '-8.505867489584104076963971731986268339341485317034574087191806756468994011864e-8');
    T('4253613611868.577209622157479284930905750102791384', '-43984324685835869000303697875967.082217047029855677646732359601172199279', '4253613611868.577209622157479284930905750102791384');
    T('-121720240860962699516920276862045784990182862', '1391.961143', '-606.43001');
    T('-536976703647420516808876195121833670717045212754909788504401613131.09832340493070', '-0.19', '-0.1083234049307');
    T('-153530020474096871971881884794986454397802757290849940749180641455669', '17505687549970976977562427455563558027158236049114219594525022835524956857408951202033619176205709302677596086790722061676556549481353529948', '-1.53530020474096871971881884794986454397802757290849940749180641455669e+68');
    T('-68463793074671329', '526225751933655101274278816933572067012685551994.60347692993', '-68463793074671329');
    T('928', '-0.0265270808592803498688377952309584753581754116559858632164273181218506763174144086', '0.0031302997955205384474094353796565449495740386465470997231301432977903878917439462');
    T('-5145804390488853836236431219.38753169290767614', '-644164778290743967724692154273953884635573804098220159016', '-5.14580439048885383623643121938753169290767614e+27');
    T('-48662.5540827771318125347572899275647466291424610808453885768596532572841012738459644479349273928355994065901331259154173718078854995422986659565794', '30351303292454515546174815773976.50499295966113', '-48662.5540827771318125347572899275647466291424610808453885768596532572841012738459644479349273928355994065901331259154173718078854995422986659565794');
    T('-3764151.657035364928443897184118536717270878944518929297476941743265064271975725529716777507698244379183234036', '0.00000000000000092398996106085832046054510220753163692327079109794497033611990981439273055580421698549040809961268572', '-1.1361392097591721210516136641195398063669177345191861811669379578999595682832164502803562581741006244e-16');
    T('-4.9187386', '-65979133267007831443913.4285', '-4.9187386');
    T('-2941173670207131755888751957586931136097649817241', '-0.0000004814846478935692967474817070197814917779433964', '-4.143231488767554469914989546635670710760768348e-7');
    T('504086121738234114557048964595466438854236194.1238871658511576861524800891', '0.00000000129609070', '6.848482861524800891e-10');
    T('195880.545202875997253', '0.0000000000629389391841695155107474938177568932398308312865', '6.2576456087309632014641966027161174341134495538e-11');
    T('177588678283865131748445.20341144781962491999105521', '17633411549371694148601456488804240695997368248839673881068256513149766988205700935004.46173570', '1.7758867828386513174844520341144781962491999105521e+23');
    T('2996061752747054491320141560401547784315542844732729476182822177717526975778111415770939188808229.09633410131208348150766825247507152776287', '-16624186814169509834280278960.382105391846684300669229217099456249591810668575643552119700009655524933947866332356', '1.814501977947587086559582750402803833652237808310528352266882376452699987265363325517337507007541497009363881064e+27');
    T('-0.00000000323462065679722578298211032318052426076792102642153162888985566640317479966266628791447782540983746324805874876', '-9760478555851830779132259667610197027614293415305346099207953950643351758497122945313648929352', '-3.23462065679722578298211032318052426076792102642153162888985566640317479966266628791447782540983746324805874876e-9');
    T('-4425946782408559872230702296548525017691907874768090.842721989595157930188728939976', '-20910144556974972002031925667197905782.3842669103600658807854243828908705698618611597944713721513', '-8.1174842407036734952567527185747399937378885936959608945880838786170489622477090755781556136846e+36');
    T('-0.0000000915636502802479794654280073153529001575316015250756659772393754338719833895732465666755842320466463187168294526995626879755559065', '-3893976987070430373575695657419905796411.063325237201233825164129403122912495195291694115473863', '-9.15636502802479794654280073153529001575316015250756659772393754338719833895732465666755842320466463187168294526995626879755559065e-8');
    T('-1361794.7698127968', '62068.38928754185504150471180387153', '-58358.59477441784412840105211869787');
    T('56946343438026239453088.035469510090959501909086942675972', '0.00000000000175389432812412891469059096827552600092473688468378873071', '9.3971542153953297729457229138638683477757090580201369713e-13');
    T('-216423551430826376828740104992259241726966617148112640804095596112778449.41524', '0.4617285434914380589707413098498642094246733418452292890078428014343835392766', '-0.405084120420214123348047058484819751957998976642922377415700300110247041758');
    T('-609540688948287254916667914127779172583532177977109039873.52', '59942.85701', '-2421.80657');
    T('209146818192414024940477485662106872447921248923844.06942710', '194887998177776027858422538823791035671522302666816586057503286336727561981.277418658314883331800489638082180', '2.091468181924140249404774856621068724479212489238440694271e+50');
    T('-0.000000000383471293733892695539029352514599525885254801315847674728451500273625909999928055692998459043656614805973747464908442983325518554611862099', '1436914643087593231998188537.43007915688640422462805553206387040332979752282514782607648003897995312517526015858941762085280', '-3.83471293733892695539029352514599525885254801315847674728451500273625909999928055692998459043656614805973747464908442983325518554611862099e-10');
    T('10973736.04887910157362615080', '-1914749385959783542863340891438235602833614861656892143731096463693925359032389835949786237963580576640993170', '10973736.0488791015736261508');
    T('760745776921863883695925202158755621973717376920162944676687742379357095109520213981477435495396177945964651.782946554742559101819380914', '-69587305864702662068384544.416103380560483738456', '5.8598017452652424661892011091840662374011392595380914e+25');
    T('16517561.49886168205217694542953018253109738947136601119171501851647671572730355', '884446285891886647986941885828001196309147.2792', '16517561.49886168205217694542953018253109738947136601119171501851647671572730355');
    T('-126432585406331428026504773834234402700464127021090.294922390288914827690266641336640485828519895540001279706441657289346676025896', '-93341638437704.72913174198140578585969178589732172645484624397170924423918151900900579966645769211771726282849407857845312304820605914315', '-75654522250027.80364908433251628732320633450589708873254066633079438869841763142004458404461623673413329149660061709636674643820441363495');
    T('14047.80', '-231827244539352913982806428147776204855673320603750218551746829240475.071834413853548835', '14047.8');
    T('765290437.4274705525375273645201254509124811109914652423385744196687082906715458538518828538063', '-170265424568071609492595764439416049305779878526025255248414508', '765290437.4274705525375273645201254509124811109914652423385744196687082906715458538518828538063');
    T('3311720.61', '-404471983513006673196933.1466618881459376508409282781068373319987742328030853185755897212344359', '3311720.61');
    T('45991089210393111564308702224024179778983272166206394790320.6444639679813430135956296', '221492062325759306969421300129294571085950901905658970894066426987989464689596714996882711.33527373477304903881568245457206872272357', '4.59910892103931115643087022240241797789832721662063947903206444639679813430135956296e+58');
    T('-2676337743.2669218950557047383697749234730579636349195010443938930301809798701005736724197628525', '-0.0000000050641988267157160357685504958602', '-3.7830662640990149837887633696455195010443938930301809798701005736724197628525e-9');
    T('-0.00000000380228587817867341197616338523104640068872756692679613177059750823089', '-4137484037122167456128781504273195141726445714.987850478841723411486102808695385497342585068965', '-3.80228587817867341197616338523104640068872756692679613177059750823089e-9');
    T('17754236857117435132308613993859837766610271655972290799038080', '1704833941929076220640814071735309403232964483307878895509518095943568281423168227984718596.14467827501524520840433884710', '1.775423685711743513230861399385983776661027165597229079903808e+61');
    T('10027836760407284995344.880831', '-3855354419049536789489248488666738929318752483890215632137859537808426365760274903064967999211093775524598713395085010.359171925318425848171423905809', '1.0027836760407284995344880831e+22');
    T('22202026217695996204973556985884720436842373263831402061744953156987742182762967091937136', '43185871335981070591623795158076323942623952636793.0437867028967265139844569485433664719704674775842634206503820291927569963965227634755940752', '3.26504703695283949129971347692208384440451033569938192969127171775632235348169726099152160569117154517580009333832314710480195174528249498288e+49');
    T('0.0000000000000002128976517031894937726394149810371372904281093627057948171053965578050857567259999271356289456690', '1638227219164.830694905159101117562037676449467894880755446732079715327877', '2.12897651703189493772639414981037137290428109362705794817105396557805085756725999927135628945669e-16');
    T('4814208595346449.043008706195329135991290736899', '-42226706042290308331808643328.1624582074527758568288134403184705773169740487518531767292082378956608507002902325', '4814208595346449.043008706195329135991290736899');
    T('3038935470646078516363834582672813654955.584857107298587208166650999390267178660250688913496749522905532796141150317042799346138826323656895204692822688', '141878380568380505848720966069502343909172636', '3.038935470646078516363834582672813654955584857107298587208166650999390267178660250688913496749522905532796141150317042799346138826323656895204692822688e+39');
    T('-6169003413317472256185593952980507739590492599058739528722582082779602743497784.3427049376611779107', '-31.42072280707122325885993720075056590730611405102283453158861014159701198218841889427', '-22.19776446374536431053795008714160003252266054630255634003844573319866809719521193069');
    T('-0.000024509540379901693081094681822253648979115777140798043255679480624', '-0.0000760', '-0.000024509540379901693081094681822253648979115777140798043255679480624');
    T('724279904087095753394226280693707412319943662527127531541790583722341314962022986924003081613987164108631904455425855235377854', '6273776855104234371654058867999.169516300774', '1.476368318259034422871338396645233240954186e+30');
    T('-18588676215231158085.946211173603363600678120130466593615153207303801832898083927420536813131520643032959684506944922819431821478386072330111143921503', '2387112710.1232817341660077099628961860306411347682458219818878317649399403544141963545255184471115705860288103752677826329794816', '-1517183187.470515201152916387886061279636026354398496623478118729449319473763829860908182395451873749194364531069367833125880637311143921503');
    T('0.0000000131867789180977263531745735221989806107871520141527201347496177906746916558678489315586403635471727664914100888', '-0.000000000000114689475499172124081924590658780042763626380186641948', '1.24041539138704830479374337688539109180730530022376056177906746916558678489315586403635471727664914100888e-14');
    T('4311427478.283637806857955975409340894341757614838371194103474257204535', '-649782518102516258848559576865098567584081840293172629619735846503681807002436279687009986', '4311427478.283637806857955975409340894341757614838371194103474257204535');
    T('1084223088975587942008961639610672564432452165063129695399364194.7724214344063983401791208462284827932750', '-84781318440.755680735460810732984305718976302629343574203', '76961803391.186713545521492205652920042921934475118638462');
    T('-0.000000061', '8786983807198223058379063246618879186867662783902087862998860315406531227728533477069121826634550907069994890047651666829499803810', '-6.1e-8');
    T('100528259107227.081922566140125579756940512053795436712849097175289286237932581152', '942713200517839530382833024395280742818911844807588995366076616161481.3198459965316435128156454232997381607367702732751935460', '100528259107227.081922566140125579756940512053795436712849097175289286237932581152');
    T('-27531354435.67909536742252514929056355009540359368305025535772692824010557599100912735927621003', '11000389644039856717798395867260.389464825121873765842743496221295063610909330014396388749003477966675244072', '-27531354435.67909536742252514929056355009540359368305025535772692824010557599100912735927621003');
    T('1241134823.82242025576415', '-2436983229830352502914812262238245631.638630950318028', '1241134823.82242025576415');
    T('-144010855465.52294929635059866397929363679648857972113703', '-0.000000000000000000016080987773993260753935707240', '-1.063553116788584594723506728e-20');
    T('-0.00004038256977505864160533312084023171599294433697748308177067704771939462', '-2155348555606824361074827496727023440.727544202034420464676729642053697349860774140137856318160073308875496365295680765947736972447496259', '-0.00004038256977505864160533312084023171599294433697748308177067704771939462');
    T('562656152020791212164121284176482277264519513933510410360247916921555.021006097720457824068898265551508', '269214854076690329599299119058534607707434613306556247775662477434328445134773154913640995897232700833.3509809427607', '5.62656152020791212164121284176482277264519513933510410360247916921555021006097720457824068898265551508e+68');
    T('-0.00000000538631554992448118188735718881805592894263653000803275203171961114344766766783936939408658883502898545560241278071', '0.00000000000052', '-1.5554992448118188735718881805592894263653000803275203171961114344766766783936939408658883502898545560241278071e-13');
    T('-420165011302009959726745508121475336218614630482602804564105573952263470925277981868876777955931.586980555730131401861', '-0.00000002570711692260590889431201869485340369724462830564055937185895849465134', '-1.195661613348988387547281332958532992374725080459688873047446880846196e-8');
    T('206614495821030856258957814325343392659221587476465034962662750862453963123443714469071555929832788665781745529.367727', '-0.0000000001661160112583532898587677052979754226652657040117961034695013256023840810657258489771022699005804343245729475750048', '1.0429548835437312814921716318665620042989758877917059041179013022218706823693124370915675661873453951861654108688e-11');
    T('2.129629456244559693351889093283039010248199571059181269533286862278672114837554726244186016512512923248786195784306579695279176870950', '167942663220994525565277036378341943077.97', '2.12962945624455969335188909328303901024819957105918126953328686227867211483755472624418601651251292324878619578430657969527917687095');
    T('12176138559764154534976504354019977304742047856939022090614225781269098414670923528582943.10977195914', '-583632504653.317910211697569945462945466919', '159535682461.909372767660403987685629831037');
    T('26801.70776', '-1839840489500540849073275119242455920755679371644846892291102931868727750660630725018122594847841701320602357870867176213530.54397', '26801.70776');
    T('-337515772588445810907775628658674617832446340456706715404089682413724911029602181006534947673106470310169888744481390287932929420452374671107329763', '747003702426526.08588776581732211783056883055836800674965151006190388206832049147104586571457728195327987825881461665724657243756841', '-447197560243704.27747928725749075767284852291932690545433431257640274850422177065998793355714235779800038252557174834517670442529162');
    T('0.00000006362058132140170298', '0.00000000000001458044816', '5.95243898298e-15');
    T('-3594215153876751761296964832202126901729901462252166973917215.57369585920992111877692697850590420143534264638009736180', '-0.00000000000535939139326835434743507032712041831099958079045601050357452232464286959087518022443128930720117303095792238065043970685201723040458303209993', '-1.06066578271026895852431656785059635221975944055981884000221087847830772261936494977835528139047391689269307714517916852256490493941403060644e-12');
    T('0.03040477493704564561379391504523657646163165', '-3829968110375376699653656403680127708.96', '0.03040477493704564561379391504523657646163165');
    T('143839023389620287917080598136939204834211679465632489449268587070547858891919951735433984918754860511172087386798608655301168386080537222501170274566', '0.000000000000000000050904519883269410714066625387981521860251471402534287519580544338323972447562512119520450981009639220992736058455654970440678522343564343711', '6.947705519998581358090053013911144054426549810249668609792468243672747095472094889504331332164049453364474197265004105580867309484110017621e-21');
    T('-358101998722704280658404123884651237259779040468133477835791002975414884911463470305794344', '339013470613986503939750434731451482.80428540724852964369292178705210529584067980487', '-9.197311229967124089066230086719075507485006197972684367837222888572478434033179797e+34');
    T('319046228556.957337976107234589381614513669506109842572986792638453', '25341573899216649823607289015612827072.54559124982886262122240971817339', '319046228556.957337976107234589381614513669506109842572986792638453');
    T('0.0000000000000000006665605465014236098898571199127258214891647138029333052871478626750277409', '9.2994763002872765347756456272', '6.665605465014236098898571199127258214891647138029333052871478626750277409e-19');
    T('-8597100765432', '1.4061930205430936722438880987030631627463886746451173645000969851082153846054399284881', '-0.7694289567800680544500753441563271099198878457218307264536433333802305802000687849826');
    T('-0.0000000000000000071063790240674330676736540699556204549815235157130766649', '-15261432741466337551829351259412618954339608783801902625.23542905091', '-7.1063790240674330676736540699556204549815235157130766649e-18');
    T('24597860958863607.704638609505578054232793927642701487793854676929560010244268672980', '1802481949139187718903504517799237488488797785109994700474213611312061877322390386.5344597552', '24597860958863607.70463860950557805423279392764270148779385467692956001024426867298');
    T('-844517336468436751756396415750.8694448224004606845713303248407308924369', '-6675658540060519673536104856700279546693289387521217726077810.838663278894308972962912969825', '-8.445173364684367517563964157508694448224004606845713303248407308924369e+29');
    T('297434395027988881726438857041249149217423028818746940800314053389411843447774222656867639852014201825402955.835636255767352939888666344841', '-1165785127343555259111383115954948069159135335071767276621771249681211270602118289526766642905999531428644272986091711103938455034315028421', '2.97434395027988881726438857041249149217423028818746940800314053389411843447774222656867639852014201825402955835636255767352939888666344841e+107');
    T('0.0000000000000004255616740012919799050699535141777230034734861498243296211362650503864808633010961169436418851564388251642437913320231793888336551754996718520300', '-1651576988821130188451193720811416856607234210129237.883909970833794549608325237454309557258670200886', '4.2556167400129197990506995351417772300347348614982432962113626505038648086330109611694364188515643882516424379133202317938883365517549967185203e-16');
    T('0.0000000044147096298613431712166079076764897780999854959248060119312935665040776072223628259716132024850399516711414810843280407052112788935682838888941697129', '-54936210850503.113414', '4.4147096298613431712166079076764897780999854959248060119312935665040776072223628259716132024850399516711414810843280407052112788935682838888941697129e-9');
    T('-0.4323857463176142463414675213681184495653706035704024732142', '0.0000000001609886172491629520941112538601281073954128848183360', '-8.6849995449369811756464752459042905872384200820824e-11');
    T('202209.7253876600644276744210492692', '-0.00000000000000000338892963079640180409274746855742569075588575425187261714270297603518981332021947785032402317811726294429963236196669448038', '2.48774060567808536908087435166803363667804416042024979495412690793460127819789298078609537589467861727739804721043627194686e-18');
    T('0.00000000000009465531808110383618357128551578926701934798401879351466017414251990316347221304454773710889175218068990694997919702598', '-15569690510391365108565127049060079732945584147892308249635814990299790974106289975322836618585675485711', '9.465531808110383618357128551578926701934798401879351466017414251990316347221304454773710889175218068990694997919702598e-14');
    T('-906454225978706010766508621855689367113309691338376322545315495042716078153614424771069415704594308824862632391131402393608738253280649702961.6641981', '11660199610678028374818731841856.7121334882150901542261870618813695156', '-7.528070467742355916798912382526137282899052453804150111657562206506e+30');
    T('-0.0000000000004101322450307718410872494863474574665562369115054909734079224620478881782969556316998111941117895920501524161853814989807532', '423210910279868701995463018234848119188756375891085182100812368574543773666', '-4.101322450307718410872494863474574665562369115054909734079224620478881782969556316998111941117895920501524161853814989807532e-13');
    T('-470158060793806640223969538148754202660458782.612615684822290245236803305653425956424810905330203916882572522005759948', '-0.152695767111052424631688337299212951189573836707404959632830139430511960774250914378066254704926391912654597758822835198889', '-0.073651654118155896924523703948320110247909645704509802452201735369382844041627083824661314684771341842243469753325238257779');
    T('9.994426780915974145347014135575893960205706681677054334376705730901774629743310179236', '-7', '2.994426780915974145347014135575893960205706681677054334376705730901774629743310179236');
    T('-39230663720925065911.709', '-0.0010728700907817921430794540906048057564326188014160081208465534724741317514197503024274778176377553223843602448853719066858744960609415784093590679', '-0.0001564596298149334550945778894989078903899810456404686403803445329346353151049500880628673488460793553585288642059251153644557695926708694554291526');
    T('-9075671784025800106573820389326423822119789380499', '438119.273000651189410948408459618402001563677344624063470699316786673102238473929433190146989564587119083078896154298057276810', '-78320.54798431882932621652203547903308024478004733552908568056196964210261306773644726193677870886973142528414057490679038002');
    T('1079464599531882583207284547902100846423694366679824675144404048.87000005666550200', '0.000000017634963780257411646578062463223304619646810432414929790810861732698710183011522017480097941669752799780304922650857504090532971627', '1.3442627394777667466341237152453278981336433385361428945890803207704744384963683817727469649088690273630173830384666866982410070125e-8');
    T('-1377931339724154311913175642590.56223327166804475379410759818086421', '-7343859629910618280997050209823875113651629358554', '-1.37793133972415431191317564259056223327166804475379410759818086421e+30');
    T('1802318417733734399696737845540821628492664765097395909955021748011122554913873397', '-8.79', '1.97');
    T('0.0020082022907469851361342734885482', '17100037717357489922255553618227047318529253455381725674352785.849074888', '0.0020082022907469851361342734885482');
    T('-0.000000000000000201309146027982061988473635139635744221112298825585606183375367564795322337419170860', '112.510399403346289716543031187076', '-2.0130914602798206198847363513963574422111229882558560618337536756479532233741917086e-16');
    T('5143252640334.9471010534789709623389109664', '-12505822857859299547007903357.4580719301', '5143252640334.9471010534789709623389109664');
    T('-310614518267845321018804317663129885461172347268277845899925992136506193955.6878276728370903441307046405502757962598225976', '828661056524342624928394882871650012268186140555930515187891793804915086043336905141599671004678775857.154200318917132520559533243825', '-3.106145182678453210188043176631298854611723472682778458999259921365061939556878276728370903441307046405502757962598225976e+74');
    T('-1929389822669343098632227827981105567.947555377437838103088250130930057647071898153543733069402740720937034698316740', '-307415836138079404706197455082684322873455098421189046955.7609473524278956753826621443402955422788867828551884929404606716804681', '-1.92938982266934309863222782798110556794755537743783810308825013093005764707189815354373306940274072093703469831674e+36');
    T('-11914253674.453144069362', '-0.00000000000000640136130420098419950776623218693603250164367282493846395409073044734225569347829418824701162864570620545495518155534050427613', '-4.8273343562972522020998663785108839173049437316343375965321326163190438505924066772178429290654069832627450922751727028332871e-16');
    T('-0.15173695389851714323653081625731481081839738235113367548743715930033221373451204809777430598802691008061', '-691161057878002558587.1381127439742482649867259644071300276564300364420601832039698998854339739003491064795364533103890488', '-0.15173695389851714323653081625731481081839738235113367548743715930033221373451204809777430598802691008061');
    T('-3838177724.07192160266376738721758615938561957533876517355792902066836939676750568185', '-117267768035354.5367107462355928310645', '-3838177724.07192160266376738721758615938561957533876517355792902066836939676750568185');
    T('47087514451451061936440267540468779859177214505564890370985541624177363716426632243202744881820164276529614848', '-1172054812668893105303.109439', '456515720116084107668.775007');
    T('11.3734955974031313554231883290508217719632632214092285252072004770873986564338', '0.0000000882199238947298298119767888364932094713663602767583773895510', '4.07724040263961106723900703199982684406983245152715796283133986564338e-8');
    T('113112144333915213154140879978802.056322513047654529205838659001489881104759568822806', '-1070387536549080109047458692952163930429421126062620116475206035463717082814252900889701717285876343686799120756181867129129332436.65606609657679300632', '1.13112144333915213154140879978802056322513047654529205838659001489881104759568822806e+32');
    T('3375429238215022669388.0525445329603537774437395034276346136375188392713458484753507732527974095303619960839673965312316444565719192307138736', '-15283720773236316823.1386624805243134789068589159295817320630835525511329', '13010668103032968297.5467988176113884179347779989196535597591372780221078484753507732527974095303619960839673965312316444565719192307138736');
    T('546144540025218603622035747267.184599682578', '-1960769463.9717088415363003312719807015447675844185997229455947383216237877444003008215006845488457016693384374828878563804', '444038342.3009350705462712125797459325898357133660731360753819139185958293625962717311560001031089517417729661706079253452');
    T('-9560649763280410877866958.6894727605272476369381283550793302379468448211577761', '-23461693036891534270.66763', '-9850747110662569899.4644727605272476369381283550793302379468448211577761');
    T('-7.556218606', '0.394476467282531274033012749331622902099878763812408645207952399507467807592020641605998980948602455345622981947021804677652524', '-0.061165727631905793372757762699164860102303487564235741048904409358111655751607809486019361976553348433163343006585711124602044');
    T('-58056996634143665360898635240765086115939487200129800582322012124896427026358562634.523876053912312753303154016822967233902154761507412776886982546', '-0.00000000000570977225444819760113544221498368980194767956186945188399903686296', '-2.45163677721343452196746595282018225334170521591501642928558451408e-12');
    T('18782896745334687682661478191340244563495.026805139784759687443039109825113018630522104252165496195754', '-9359445141829484597852388054639726608853279955027525490131658108964763122303352.11139858', '1.8782896745334687682661478191340244563495026805139784759687443039109825113018630522104252165496195754e+40');
    T('8', '3900985326526441441709979123557070376512415196847270644745821164883858274100930336537915531', '8');
    T('4.77286747468879908670114975931', '-3524175598424140013239.80796623070242774065271011395748053461', '4.77286747468879908670114975931');
    T('0.0000012222802813622598440592629347721226314717119700537496676757382132', '0.3110009405107017209802725018936257999673470989741925009496294357363888407985893667857735227882746384521443945285824197537397541092276675845639132411538', '0.0000012222802813622598440592629347721226314717119700537496676757382132');
    T('0.00000000000018384088619365879016178677544274849275468587911722905323257047268461042780866', '-74691051227281886487283380566166059678639451432198951288186231108115005924732001159134690543080138545.89943551', '1.8384088619365879016178677544274849275468587911722905323257047268461042780866e-13');
    T('-0.0000000000000000143373721383179309670662810405823454166842726925', '-4713427367869967855559206933578165851630208266683044', '-1.43373721383179309670662810405823454166842726925e-17');
    T('279088431668978817721818400435457144048964563707000478127542007364526390756155888729758450016626555984216682907494069.3863391561390029008', '183068579713138743128987913913465863438011702698993606515690229413.9450791032516285344867478204174704882799732', '1.15006278031659660278253789496724532897780093575043549889457711140788489320423312230736014908551612694280186e+65');
    T('-16267494087786592277827896738531922083730', '0.000000000000000000088706162618472944512399910698929840282305406666674993734458901273843764276', '-2.5909627800753460482545058108789409575362212803250623497766964477362719992e-20');
    T('-44.24084992', '68339625270.168878456952498', '-44.24084992');
    T('-56857196985399826069072678731164191368337062143007401708', '-592412264968673971778440741608484470265561140708351266072976205766765457328334968787621711087457877572916180459788168624044681603157772.513540649385856', '-5.6857196985399826069072678731164191368337062143007401708e+55');
    T('1104996654.18304259798965034573324286', '2510117408561620824893581029911555831891170476567955656689227848034987920.73715648491088584003908515877296524588851119764300771', '1104996654.18304259798965034573324286');
    T('48029.5677151', '39713342481092.2036831420612922', '48029.5677151');
    T('-2677.39369111834569676567245932', '-2034534263100368999018977132035007334300490999268060730506703.57', '-2677.39369111834569676567245932');
    T('6075972262973206757621791006694737099204289938612010291817208034207716598155036627342694635533302369062510053834294276312030673359251989177221', '-4216877637213071624668885955274710017470051201390436656203.3175514798774907157554310607394066223414256256857538268149428', '3.4548483050634980937680079005687259547830032613011978548019536253507542566475495763279403287594055753811530981533191188e+57');
    T('-39778415088348582474737099860821880822219551752035911412802038639306564534087888730860157447303578769441574808129741.7837578735678589361592672812', '-438147577016143338832668633949246668826241701286508135724906278119313424092726.09783913373814771620054174557624677579917', '-1.2108902975451343030038388997376413494545893581949027873931312889359460168754039828862401872164621816124117110545720507e+77');
    T('115429370.636804045497572883414508754301504446475', '0.000000000000058502293269352180410451175558983836676566315944378566117451162832925169472129608582', '4.904729335492343815789815485351399819289163720633876216160558528963863725402504712e-15');
    T('1866863299414485869402976070337638006397265759003452910.410739287460164932952655292210247956540858637537378190', '13247512825788295255972523418673482573223602517867812976052652428259865841176971399205990505517917171898503843932790970.39116746434798125080894456', '1.86686329941448586940297607033763800639726575900345291041073928746016493295265529221024795654085863753737819e+54');
    T('-7434850786753.20616600514461', '0.0000000001503863022082014768371050790030147497084483425232971401283357127842725596313687', '-1.119036084550700826530363097548971535460013328630270913936600073612544699109413e-10');
    T('-0.000000000000004381873159982123279917425506558261522812871473725919073758015893922809957534001480944265329307788953888508410293960888807232862971987255245464', '8109725899091573689402454319931.18350836066336534830831850485049011849459896265310046326036965005589194064300915126620', '-4.381873159982123279917425506558261522812871473725919073758015893922809957534001480944265329307788953888508410293960888807232862971987255245464e-15');
    T('73314226283.9570', '0.00000000000002960597549365951830985161616855027789228405534080693647514805969585779006342966275284091628479572363547635870715940487197244239361', '2.924235162215933531454887853805516514067221019818723756217344334797277757263190674533556736476951724389592416040236618857138094942e-14');
    T('1429287903385', '0.0000000000000000026227169585162217601788967257094420724372717782024286696197384612049185', '2.1241263611786451580084403357462126454870868777472160598748154573957925e-18');
    T('-1399843654872820025220110414591055060649943.5381869', '-233177597420892.6290391881528712', '-56301841991516.0574900024787824');
    T('0.00009781914227799259379359855012042142895087114611171661229344677069', '-21540700792390405728340.4941249102647270294567971', '0.00009781914227799259379359855012042142895087114611171661229344677069');
    T('-0.00000001302596750035354750648883838249600391852130416107', '-2.4', '-1.302596750035354750648883838249600391852130416107e-8');
    T('-2539711480375833.8787680706295245', '-10090855425.2645916699959021555055665745313421124618054996540701587614046326913632297741', '-4623523540.3888968219914182369822556536917671629446250650061622946364257069368775354156');
    T('7345.4230955739343601041285338890479611692071680966332935062378031079686398419251932', '10343720308772182919388574543611215023360174132529300268435042772499308507904636046339051573', '7345.4230955739343601041285338890479611692071680966332935062378031079686398419251932');
    T('532915932842606535532293569407035699330783484419226736382170882419377135.138557713281159484931821544535832004298377411148874', '0.000000000000000097120843870050544930766762870205724485889381952725697657146115928483473606129290764002', '1.71016654827126847483437088121564862848406256560494847328799197734413796459426367264e-18');
    T('2786090273650860122222172462282569662586653226066049425730478407697344778285269847718642316826852059959216286066975560496533.825834439051898', '-5380036545379490040214706947292642792370009348813692.063289320229799931446171213951400074916491', '1.781447213237295796176679883614734919384147627324841950220937474739207582830548622084657210704e+51');
    T('-716.7348911856148935007182289841612962001831614930661016798201260045476506309090856624487785381070365022326338215134362779468515437452558', '-0.0000000306560034406942657956579747805603108115582439761037677331584709683937577229617811570358119993112158520602288036719', '-2.19481002399560872732138539978666667251957992848584452120211572484597113365001309147957304008789361389740924421480515437452558e-8');
    T('-336717351299839216882509548843025942568273773003071.497660', '-0.0000000000000000031038145656560174696376744', '-2.2939638463514411725670632e-18');
    T('-0.00000000088871076289105659831158653574816303487230', '5925437964261078438361385421140', '-8.887107628910565983115865357481630348723e-10');
    T('0.48996271173862812059175117673224279978397098563975331374734405038121210035666997472343508724564255860333', '-981298146452103756333.6485476848759145496522568968470756059845109847612507162899799', '0.48996271173862812059175117673224279978397098563975331374734405038121210035666997472343508724564255860333');
    T('-0.00000000000018739622832508484881716365605238857842994033219621274071493422768019281918672926632721149273548760595828153562533317', '0.00000106753414191503143009924816334903', '-1.8739622832508484881716365605238857842994033219621274071493422768019281918672926632721149273548760595828153562533317e-13');
    T('-3724.961037270823216784122123949498899097506867404482079742878', '42728642472000954973441392924603786297505608884064716022000636585801915420974504713108514988096981528010203', '-3724.961037270823216784122123949498899097506867404482079742878');
    T('14978135246.4293498541153489397855384604096560034577747263780459028396569631858547180442863807949567', '828303155938367860166633696033166352096650401684421199987339292282009346446', '14978135246.4293498541153489397855384604096560034577747263780459028396569631858547180442863807949567');
    T('-0.047628555773786673881971100151948530011265912029463606745633469100975125377519599189', '528778913516649959178290334959803065311351416856125792866633653171089280622199248330023808917526801982365664091823181214120997718352635826074081634962', '-0.047628555773786673881971100151948530011265912029463606745633469100975125377519599189');
    T('-14939980526.554849200622465480029433340799030707', '-4277663.20464126532165338128222730657269719173360820748109791236846681210102912850976196526639900951364332750470003', '-2380615.94755069740885804249167878894043717324013947600609000931389214320628324391121728973465877835750035358749524');
    T('2254531950203810106512216769432345108091659826174197419189904121779.389571456070872185209145597270163484908459842159938150', '351324574544938907598852971025447067037136331.482475343426592007773285255333055388053662880975118962130456971569884230555', '3.8576251388287727477083730712363952890778696110331013414195946435626943548779101574535478551480436462182350780178784985e+43');
    T('-908518.75611434289871133928585849050982371141988492763900495559', '-2779194162891933223959992755504791535540247332661669041569801472568536678056446261493500597102205548860753869532010745212712506064454.783702', '-908518.75611434289871133928585849050982371141988492763900495559');
    T('-9751937701702146526197396852280722495497246508393405343698179859443679270762240734774756447384850662119283788899226828510395349600364', '0.0002072564098631731321614418369973126331436239029891982973755759590617485920152211028657689658898215', '-0.000065268138309116378751853481282714106859124860733683378586695149698540722854723270248930520518111');
    T('-57002171357681472900693.4729019652902136412209956798425272', '42968990107768657015543291491936311784108036470373857830494358', '-5.70021713576814729006934729019652902136412209956798425272e+22');
    T('-779.38806641', '-276143375215931856852117654482995176051154954022602259784790966214726724258520671956887000901811473384735495734582327432375381533', '-779.38806641');
    T('41533880399742218630278604056671763202881405110846632341263992670456086753127.62137428620211383152736798612114176', '-5742400619641926749269144425184140455944367080.9420632770462859801809027506509', '3.39721948198633333959235038541298988556228578133396634945632115085817616022404176e+45');
    T('-0.15640159643564267665063068794647422832178482162992118215600544420009053201945', '-172445117372769.48208', '-0.15640159643564267665063068794647422832178482162992118215600544420009053201945');
    T('-0.0112275442296349836418573333090591', '-2255922450411587809292229473263097797796627000972898359618569482413455833816036469768975961421349683187.94437348566944556679726583316945094', '-0.0112275442296349836418573333090591');
    T('-3368.00', '-345972426936711495192918207758303734495983755979074790217123728465.80047743465885662352027565018300048657834525845654295443495093971910868969090063171', '-3368');
    T('117.5750947029273379673675410632947676619639847307327388', '-70731203121207004885270875832693445747215727294572904020461929095227705068450.50513528539516122022720282675281', '117.5750947029273379673675410632947676619639847307327388');
    T('-138977748373044113.3788174734339534653', '-0.000000001480926486083', '-3.3086978011e-11');
    T('1179292018572.9841303121610809323250406574524443113684922518685441369442051369712691843553144676353714219768250', '0.0000000000000001266875917107419', '1.2238670441939944311368492251868544136944205136971269184355314467635371421976825e-17');
    T('-14538354899514474066263227062556630420353609726008', '2842.054050193988254028322928854402650042920389288352515795', '-787.841734262540552719016400749913558239542081451238833495');
    T('-515534361438701466202657012041091704270306493888955748464478928404889500948.6256180199199867611', '-0.000000000000000009203', '-8.732e-18');
    T('-0.00000000000000002436967040184567917080710249017189150294192', '537233794697555587617971898562122287499751326330104438900861362285369159209579.20894448555179628336166706113083738', '-2.436967040184567917080710249017189150294192e-17');
    T('-10973344995231896444164895312752280156537575740345780145078213554021817209401278502799260096810348280045597821463610756008906936006453379225098199184', '66541527624892473810370053621624002938324370658164532933374927090501743364535993599537688484603548966183655370713388789701765327723856591.969224975', '-1.450342823427219830229311998566498376289753623139511311534558115476690478306521429471030288042940332558759442503472209827991313811102369736966505e+136');
    T('-0.4316267645066591176857475783149345786635888459807302418058772908006064030240231203951076853432363297761508', '-55028014026.1557830721022778741606190299296', '-0.4316267645066591176857475783149345786635888459807302418058772908006064030240231203951076853432363297761508');
    T('-2909306841301704095060647742525040306501994081937165245987916403783220066141979481349904813308176225805597723367483244491162516969865072625547738', '-4233.78204828611709673177663912398115727530134420059828072548075540672034293877636097492224160666425080181579999527423978551885309647443462307117921121', '-988.81224272086075541367603049719895260811349125347394416104634518954247717715773679094698039335395189402484412782423394374527794816743393185901317177');
    T('-6548887805272011465.323257524030453759629949332296153558585801121085431308130680538770399260078998930389034743598626100088171804960350705360197054', '-12080564112679438322760485786027548072559769334761890502356163626145033668765598657336384176583391733506824623', '-6548887805272011465.323257524030453759629949332296153558585801121085431308130680538770399260078998930389034743598626100088171804960350705360197054');
    T('-17825205605614995267760724571708651253966055640698821354906323632546554721347699817715902863307436433504779452592432809608477.333181451786', '30680736166916309201884925906.6012446662423515442058844013145290522721220129756414013822170839078121709611675310', '-1.476583352405265718076287125956418384435618608746712341181884632993097339340803769809278074193221038608038868e+28');
    T('0.00000000912468064832360078329428188145559810429725609376050682286774993859391174656196966186924848665919094718780', '21914190263.100035808759435146366532139123334498047338566', '9.1246806483236007832942818814555981042972560937605068228677499385939117465619696618692484866591909471878e-9');
    T('-20606794163218373220385623629829988033.57174497128', '0.0000000000000921595473430223940199410848478707835684064295358119717430281404961143732177360181223932368247886620954', '-8.55963065519011748284526920363755341557853021589815372874944759648859916695380966744766940378956445724e-14');
    T('-0.00116515061047312393907595074853372157514235898351272755761457983036507134829330366786074496438528935230083275916775473045004', '-410007620964954722625074616747232948064935562193648550794528374214082044.695992770579155345699714674119972463090345', '-0.00116515061047312393907595074853372157514235898351272755761457983036507134829330366786074496438528935230083275916775473045004');
    T('0.000000000000000002866262471198013003247450550898087733157498823752490067442065500489968029757441844010991443903735220764', '-2387063555802958241360682309588269568721119805287196269429670036507643298607.716703434577233592987993414932', '2.866262471198013003247450550898087733157498823752490067442065500489968029757441844010991443903735220764e-18');
    T('383137082334366134473626747321368129198523267298422116111379309501154', '7792834478569981342900412293473610112927620218475883827152315031697511988080100013693178713319824297431492360416857', '3.83137082334366134473626747321368129198523267298422116111379309501154e+68');
    T('-5192609399231404787818967904763339039804702106.2642098584571392384864215', '11995.0', '-8751.2642098584571392384864215');
    T('0.0001613753330983460459597', '1343718759722202811633465441653970587609134570741564553699639538938957247416670787866631449', '0.0001613753330983460459597');
    T('18625.82', '-108460234364121807955833.501117158', '18625.82');
    T('0.0000000086960654123918299935978162138867774634877845457981404751377524026363658271257851070628323331401981944601936516808916534072490865752', '8049043891570.20498300587421', '8.6960654123918299935978162138867774634877845457981404751377524026363658271257851070628323331401981944601936516808916534072490865752e-9');
    T('92177258893168796369930099881793244231828885.994885469150932397211053118484704286168', '0.001697557910838632235527648236671741804284351643458802110983125809001092966432046553593908808466256476', '0.001048051559814391786998156983752684121311392378515748632423171613713154633150574252483089353288542512');
    T('0.000000000000000000135340591193604907157819487179265603170243663378275824462740462', '-3538552385863005446402997819693840644728948859866382289131015243925156152538296009253.88595397921380748370626209756254143', '1.35340591193604907157819487179265603170243663378275824462740462e-19');
    T('-8942810941342318692131683034298222491.298966162751297487298160818082351741848617', '81468788300903008016446735094927250.9025421163811657618870083563515329169085218713537560955357573689069255755678460294064978585998748322865700882101945', '-6.27130165438908183389889089511521429218754772042294416142499757652637988197330224405855866024467891451122631047827946917334126136432807638603850887995e+34');
    T('4112.5', '16501231733092448026854714811537782791022.61367458788581352140616404436355216872103784298148436462627878442916700470', '4112.5');
    T('-0.000000000000000100039272920978804953224514434658947574659086841906774034035770202605930568482069278916', '8360130279092670037383877853101379752066508243.7914548725194425829919568', '-1.00039272920978804953224514434658947574659086841906774034035770202605930568482069278916e-16');
    T('-0.55733808633010832738832311322243', '-30341809.7768885100044771345', '-0.55733808633010832738832311322243');
    T('106317245251707976645199.36121706418143436338271', '-0.59881135427287180381497846634181133656689910033999166', '0.32560278164243629083243463276569802027691289241346654');
    T('-5809879419309871900248097028036783697200487662.72078280568345188008643358457456973', '97479961515864803630625758944755018442629963763620', '-5.80987941930987190024809702803678369720048766272078280568345188008643358457456973e+45');
    T('-0.0000002582736304792493854476455750807714448789871391914969265606245281578616804637963665810949001173698932167004137735325550552542025992276', '121930479865943189690176599713519584015951299852971842228.150293808603', '-2.582736304792493854476455750807714448789871391914969265606245281578616804637963665810949001173698932167004137735325550552542025992276e-7');
    T('-141', '-1.290460', '-0.33986');
    T('-1672922546593.31971778277173', '-24004744487670982178071549599909616293578410420429907254240481309690669724949467538663.43257166059', '-1672922546593.31971778277173');
    T('-0.000000000000000000096506747661828537633255606033313182920993286310754098242241527192506663129986680230116508640760013474440576093964790427764', '-0.00000010591032418873774305782488821422031008159269224396547763341455910365931704698604755331650104205032352591665834970710247264938146932851', '-9.6506747661828537633255606033313182920993286310754098242241527192506663129986680230116508640760013474440576093964790427764e-20');
    T('-13827401304111289312736198643718536550239860723009716248160536677', '-0.0000039286228820013610690203711803131600098718683633', '-0.0000018687648571863700673078239442130544157030166194');
    T('-42.4692049472839584484885223292994575479989813667615626032513742843562250259364746786558133445767723482540247', '-0.00000000000000000819275717705512539909834846743982191143678579675280080605996356880686842267', '-6.4653951124095444397419580073920159575587091030342708998343881853687266199867723482540247e-18');
    T('-2466733580603659963575534598558841787749140591761688146584246949860119069729862200150585805915812920870610199177565657789103756293844601451975927', '0.00000000000000000001220964545466869353977', '-1.73255416774937445048e-21');
    T('-15028378815304663676509006037945962004972477648490101799915638280371939420560.0041911393147636614007445', '50622452443346007758014952215939952642084376096904097662205047592117731694004927204947361193840079003397393315495612132043954828016869740815677950', '-1.50283788153046636765090060379459620049724776484901017999156382803719394205600041911393147636614007445e+76');
    T('142588144195311580010051.5364511066747054069508651215066362734114680562635989353532168705092760233791521149157821867553492562330410494546864139650', '-14503165820788.7989118526503493452200602820958797693990568472997380353527541143720627492477025', '2915050714654.819054833603896590465362673501332752905041274459514111791099261470796120059809614915782186755349256233041049454686413965');
    T('-969615612019600562266997847', '0.000000191644650609545820597008991399827106864514006', '-1.231577096546224847608911542095213749611614e-7');
    T('2256513056638995361107016553105302955081979298952482814125065516118737356068145.82', '-158065108111543929811518473313411.60992867508424058272054757815774769019280374359986010771', '1.2747118706198757060172327002063737680496619401702267612146633003684640606557668930745563e+32');
    T('0.0000000009237134280775239488177645583957175262248471518379247948959', '-0.0000000000000001658030328961634', '2.71610961190711645583957175262248471518379247948959e-17');
    T('-29037971633171746964110337225165989562263266513890039145139101509478815612783351650243947553265889073155208935272292022915303266220845856601847833', '0.0002291490081859774827', '-0.0000175625699645664842');
    T('-7419630363912248895351350605409627746954992624899840002172405589436855414.53245142763', '548.8847974769155367539649264103154853090755290', '-311.331663008566145443936338341729777410460137');
    T('-31531682519443763389714.61342909941642731349791408998579283062988631957213607', '-0.0049509892638980905715921538869775154076564720153', '-0.00240704556517700786995420557935621901418625076453607');
    T('10.199939958363750394845392764', '-938958758058.7364', '10.199939958363750394845392764');
    T('0.00000000000000000547428861001874500', '8542.618867822931747906923388', '5.474288610018745e-18');
    T('0.00000000000605257123060057047947264779334280422324573184783056036871244530739641764616333500517830537807440912208', '-7720892347085081968920717984388501900819875846611343246381710158287747831369369498946504999.69677595776775728276345177652950285580722556865359060', '6.05257123060057047947264779334280422324573184783056036871244530739641764616333500517830537807440912208e-12');
    T('5197872005452089687845492226606310126958533004786.01262820209011362035440472786789414494121891863808333760222524857381721029192192394837170796', '-1553107578156990684479674739994879909980690781747809215157294762487391417358259.146954264798337814197978', '5.19787200545208968784549222660631012695853300478601262820209011362035440472786789414494121891863808333760222524857381721029192192394837170796e+48');
    T('-0.000010459044875719686467201064277204760401116231048766758416108501254604582446941866638877706771900478867008604302', '4570483969034967530134798231269839607555086988204402691978.0846842677197598069225306405016', '-0.000010459044875719686467201064277204760401116231048766758416108501254604582446941866638877706771900478867008604302');
    T('34950082865877722140999896945527676095434244644489049.47442671960077158711230616940136639915609220577207968', '379002403.050778311803417819043114867', '283625356.05019950260262830045876010540136639915609220577207968');
    T('-0.0031090306995447730433562939728182473162977550600870500009238934708225472008899875393691975288926245842294981202786862852967148112', '-179021575013512153729485967283056990.1980994548847179904114211031571610186752960630950031860150656109870473715205099194325984', '-0.0031090306995447730433562939728182473162977550600870500009238934708225472008899875393691975288926245842294981202786862852967148112');
    T('350213646089009419745026624604797595763993333334620301840610383877418878521099968820864105567.6181312666', '0.00000324117432025964624180746008701209658337644053764142142257723637790781637027233123642211394947389418444055224', '5.7055181542801922990712697286936826369136399715709266248399293604043992259309658307682824893308496146676808e-7');
    T('3328107.8494', '418714348020467109958856616981538014194347311895744037569297648600727758725623', '3328107.8494');
    T('-551844215309008408275168733.623176966939595953994851048267562459636894172209764669184645704359671910176962904921966067381393678263185580431892958828100', '52489.2323', '-38379.2058769669395959539948510482675624596368941722097646691846457043596719101769629049219660673813936782631855804318929588281');
    T('-9161822288156514844155956374210640490022366908510', '1389019572848235000704785709077750964197706899388709294785368095533089044973589', '-9.16182228815651484415595637421064049002236690851e+48');
    T('91056139545088458766054934573084198168.5710642286038189576393294864960', '-4517685791348280307925690612882502300237833708968552977972888084474038473.394339218360256523962637702858180915401362080730', '9.1056139545088458766054934573084198168571064228603818957639329486496e+37');
    T('390029336502365918513931.130015474228581793566056937195029617483963133928361072920643966836693549318455838606', '-677948403080048563372.836374', '209004731337994574550.214965474228581793566056937195029617483963133928361072920643966836693549318455838606');
    T('-402587804331.52384475209667561672439292038632064986705375834023160394', '22953293360768232064948813431816046275755734572489568108170437942795164066617787530406717846925329560915859870010112631465336783868468156816495', '-402587804331.52384475209667561672439292038632064986705375834023160394');
    T('-625315195115297944213401252771807597994808320636040980', '1245525668172581544516010393636352381040839194590487646892457620457541581549954855850913555273127518858.5699453665074315653164442153272409410', '-6.2531519511529794421340125277180759799480832063604098e+53');
    T('0.00000000000000000106014797651953270761670971091554825136816009688246397263410062266680994943', '-2837919311814592501835.894615149733052873373862623419869', '1.06014797651953270761670971091554825136816009688246397263410062266680994943e-18');
    T('237381233514476032201357341.4041', '-0.065815324672679848778208005159859', '0.049044652806221841033273417056172');
    T('-0.0000000000000005144544006903982929329271186335022979326957607423453760483024388746093708635051243834072032', '53859.824448316', '-5.144544006903982929329271186335022979326957607423453760483024388746093708635051243834072032e-16');
    T('9.465307046802752058394916832226320349420927855272418', '3177012152819988337055628473453787701666615', '9.465307046802752058394916832226320349420927855272418');
    T('9573738794726021107.734106032', '-185794949125622556219134912729610938207753649877619366539537127820541141774242915', '9573738794726021107.734106032');
    T('-234.492043915944790198500267399199969588539805', '-0.0000000000000000070050048053389237694672406069762', '-1.7957735143268502710881087411774e-18');
    T('257434448562147186372612642412.726354747500293136781463967693646812824724851090463016', '10376593029095719663406559308.704088391790279215064412899034913970170280677326597734060879629830748435773301327', '8.396215863849914450855219003828233344533591975235554390855711528737988595252117398538888884062037541440768152e+27');
    T('12285490012463121838351929674277761291240995729813968431132385721778827202446854153384062524345407227973315579239229493694920.48275614705', '-197015608939.8609489308', '196270462249.41659606705');
    T('0.000000000002240974449242592254790173835564041606148621842662292012652507440629547097709122038267701655839515607132861720217869106265565545', '-23335987271047953972812286009148867302941199929709819822218.47662872390777570098607457661024567895703928912305401676859', '2.240974449242592254790173835564041606148621842662292012652507440629547097709122038267701655839515607132861720217869106265565545e-12');
    T('165366904096962525782012054078987504568761069721.4060389256731697873983611830230858921671529412698579846557699', '3444399121879479169341765797909079931147798377878056422577985615184975145614404658705092317852628448.8200951', '1.653669040969625257820120540789875045687610697214060389256731697873983611830230858921671529412698579846557699e+47');
    T('2705886232366102755195760426990938611198454960222419636993746631582409715337015469937064177880977434.52524166361088019858326697993', '-153335210993719572189122942382836225292613994436997443668536033261124985431110232311472271345055289442071134321117800654483720838841', '2.70588623236610275519576042699093861119845496022241963699374663158240971533701546993706417788097743452524166361088019858326697993e+99');
    T('-2.131', '81.141175482525877411234926403452', '-2.131');
    T('36280697805.456872085448120623178135789191532017507413855482045239572847567984946', '-0.003264019500578350726232120923403720087351790298292836973891286679030626156471457', '0.000840690677320778506160517859695422697759302805218793948421046952872287436211442');
    T('-0.0000000000000000383294424564471974556118502909006204805914338360402016898543', '189834035009171131324219625463596327097619764552465816576075046748053426206833060327761155383041718993336', '-3.83294424564471974556118502909006204805914338360402016898543e-17');
    T('10640490.5446167580829516100444812115028794128019', '-3356962116245265447.78909316730481260744693416477010628711925187303', '10640490.5446167580829516100444812115028794128019');
    T('66770.3424620469504716946257076842243098386178403211027502322850765242199540112623715366358838507920992543105400494508613543146408231317', '12.513626579144904009386433045173431405442032767743437096384724485707600961521450554612546096', '10.1446623088875816180054116839677618053730244098658410197799452741688242943236626787024616907920992543105400494508613543146408231317');
    T('2006898576304765006614781291454031779440425434725470591551164794.861776715854234923976439', '6.073', '1.986776715854234923976439');
    T('1659509756014472961738450001016716874178644554.45519598', '35836996.118873689899485945983497236111', '33163606.3246718766078753085595268271');
    T('-6249029048938249062243170609092474550191037331.385626639511695286190999439371', '-108733052645.39651948756068195820182', '-49787722470.154741457236628551037439439371');
    T('3229906275442392424418195788904419876739.198022479413785727883243013449038330977486395796373161974679847911', '0.398968452931', '0.076770579754785727883243013449038330977486395796373161974679847911');
    T('-68.48010837866100691663949964911341141391335', '-431347497460708500535477713.921644368607', '-68.48010837866100691663949964911341141391335');
    T('-0.0000000000042873818496651474800023665212086183152315505087', '-0.0004833294030302505015641228567431906450483537828093124623545261018465548063776320121938591921894456004211776094377978846', '-4.2873818496651474800023665212086183152315505087e-12');
    T('-16963834223166719706079539302.342838131750515721187172994523', '5062538155437557.3543319054238404926367207556617251997556392366074322977693815298577958036063656158349192791752169723637271257149', '-4653064987731577.213544580641442966920884382870283356443820101043539787185918274106379472389554877383448200968409644573003915622');
    T('27752292382966155484621019967155951075006009060959254418846816259283474988719280207751032859907637274084223944989149146855286224303', '7999040368028070748765438.41605114691880938406', '9.2270733244135400413176158796214648476494776e+23');
    T('-0.0000000220775496923969762820783886936932950453320119723971850235755245075630658843057584853140734663613038065152584371146863744860271944228900', '278937252004422983259089672008219526227049167', '-2.207754969239697628207838869369329504533201197239718502357552450756306588430575848531407346636130380651525843711468637448602719442289e-8');
    T('4088817811601835043414165021549173.34648405001199965780370323214083852306094738315385019245330167477793092158413628', '3872463786824467850519422587588270837871264684182279002671582068189548558089190.6338668856949165', '4.08881781160183504341416502154917334648405001199965780370323214083852306094738315385019245330167477793092158413628e+33');
    T('243322131742241598643288437886384992875664969619768995471553676078266766770945268905658381465660972347322840413666337352', '-520908752399942059927.489465648336426083977336790367066585385183838514818914251238668315053257532155725', '336517846493051868082.5236480255207660421751407980256923055283675410001569182573777995089783207908381');
    T('0.000001076734879087', '259571475955474', '0.000001076734879087');
    T('-0.0000000000000000001708230742803565810750173450663838191720653599608146843168311123', '443087835486092973824776431839302000581260502094303047590360860043969772847300210', '-1.708230742803565810750173450663838191720653599608146843168311123e-19');
    T('-10116828102714929396303805403687032885954344533722862963220965618949477520274569058488672373457467461916061160346468283787006793', '993946132322903524101486258672429377833245402642388403366584727501532708958381633056725438997379324147994463788158057061040895860915826346549.0421', '-1.0116828102714929396303805403687032885954344533722862963220965618949477520274569058488672373457467461916061160346468283787006793e+127');
    T('-389784540685386262354634876838022505911248721618526216253571784.633075923', '14179193090251546307844809845741115123.68591663451283228630854744359859823006233091006350233571476950897344052975285852270872779781057686080568', '-7.1414462195758796324750930879094812700989420115077711452950042736953900296594912665141710395533192640587241839627883909055803037985187199944e+35');
    T('-45984185801341303910880240243.76714118367503791509966241100863013219378666011186705299', '0.0000000051570812174238260137276061944120837059018185942344919696042121715357536276082362935247589887241145383799', '-2.8738700535334248371703727635151089062632056136632218642673399518792415040952650429114119520426674977435e-9');
    T('-14905432087844530139366283324831046272631676943288697485416020309138739737561809233765151341023796257375655678814935895432051879324532', '94242798089904800354993279286346515', '-6.8721799631260899670134950264021572e+34');
    T('1289853511883958265825415665788637565052635440054342593643104070764287224769.93948274270941526387678146636906574620943512848445780376', '87.9539218424403804769323138636392398940152461892195350593552856971443615078621862619014423', '72.2591398780413624803529381690619313389774065636772867904263511510258955159663755970342588');
    T('53465238938510497274637223297650593182339185202252203083.1774604451123035468314690671136303407336840099522332334123316657221949276993', '-21334279.8165058978', '2832435.5604826875123035468314690671136303407336840099522332334123316657221949276993');
    T('-3108015.3661', '61126330169820996757526065.416264018282776618615327293283282822614202595204241400248642232068625532106', '-3108015.3661');
    T('-1275542230072231958406146247425815282449610680324545602271.8884038039259', '-243043979558321439267025469546543715381639907851772902031.084835381233691203862582992711992315936833776447731819010', '-6.032233228062476207101889969309670554141114106568109211646422689775744398068708503644003842031583111776134090495e+55');
    T('-0.000000000000000214815544265849149385478069939689813189252105406530375164638737376691673594643332117128360303977189949176016884413230594676158437978215', '-51027595198082649357603319772041435902079915041106170467.57451940249204354029924413238799739283659245365065632265429523372460397305377634', '-2.14815544265849149385478069939689813189252105406530375164638737376691673594643332117128360303977189949176016884413230594676158437978215e-16');
    T('-111350.754570123005196804918034331227325061895360176437728709656573510003457243639517558983859956764977218771481494447793', '0.00000000000034514677625704452', '-2.04176719106943547325061895360176437728709656573510003457243639517558983859956764977218771481494447793e-13');
    T('0.0000000000000596075948515369263847934641280425766058217698627698921776443246618249228249287653194626588231171757500449899328884288', '0.00015836637201409230200', '5.96075948515369263847934641280425766058217698627698921776443246618249228249287653194626588231171757500449899328884288e-14');
    T('2350976577509944947853224866479625205856731752244171284555163774825992062785340964744094088086550435965919613918802628710407949945051994', '2863077556.17572911282887032307292811887736', '1969784678.28266366932123519437643424462424');
    T('-109420981536615914626321665928421681390611584416442196835511987438396387.3285665769331549736310', '-0.707107', '-0.147319576933154973631');
    T('-155772215583445307101973376728964254746022086862918345349651130316968950879085903647.4700888378639266', '-0.00000000156250631895772405757624035051977475', '-2.005231219066573949078690311357765e-10');
    T('0.0000001837341912533402186255699654239577837158324509985744336931487388729640675913909', '-0.1644732520351148576255123808206799034683336488831104519232031408287760056008', '1.837341912533402186255699654239577837158324509985744336931487388729640675913909e-7');
    T('-0.000000000000001833320027801786983664774213824269815', '-32078261563376466267956235494913303920.158358109032084353548239902600710775887991985', '-1.833320027801786983664774213824269815e-15');
    T('-39.6', '-84001578606.1', '-39.6');
    T('-29724877149747295025888412038962646.2553837903819421016896996057751232598092947824478468469244594', '0.010594787103499106023921039896104036529348362781865379404768004199946120463319843372131130828257677', '-0.010560411121165907362703538197379906418141401977625517318897269171797412206019222827160029917370617');
    T('0.0000000297371329456338047054799880006249839037726', '-0.0000000000000000399', '2.08338047054799880006249839037726e-17');
    T('3510347687348.9918310', '0.000000000535137751617828949087071435929520771260034369415874463215729', '4.3970413363665598746475030544260422065911721854665904296016e-11');
    T('1172939419948541405468859374692318735483069696661.0016798921467104516384190202866844256851817314237012552533419694922981805635888196421299458565', '836225885046.0339803680834170441728042601393459064753318767659265177747', '489848285142.9652308075799720859670922143649859637996694219485574044875419694922981805635888196421299458565');
    T('3304012503481.86462667433235823859144825699221873', '-6331887562487821340332306152704795208243157181038687350549806653670754776238030105276438.1', '3304012503481.86462667433235823859144825699221873');
    T('-150211288508225998712214977612499531708.2501845877268623292755528138', '-12205845572868490041320605820426679815.764517713', '-3.7411416338041182163677077673793739190759720317268623292755528138e+36');
    T('0.000000011094742677563476721248293381876559856937729234232159020961832701368001460631326', '-6221917952403340240791870643787532087969062682748828170364381367809149895647888374041427464551506847.51299431101992176148174207489487663558', '1.1094742677563476721248293381876559856937729234232159020961832701368001460631326e-8');
    T('326721863970144140942581356605337628165729694455912.5775012098511224625843', '-5268757703002526369983689288253', '1.3801824327726670886183774879205775012098511224625843e+30');
    T('-165640236596750856195.895988', '11701057069048906945118088505193697795574', '-165640236596750856195.895988');
    T('-46180228389542924839944399544341711000150191241548446973614685877508179228647290933889351181899671153310459870760689493.0640313663321381860', '-13302007.25660543726751034427143226054726399423446928373342294891495068748409491646', '-8810440.01892587916183525077832797812112229177221241364171480643762179372031812578');
    T('647315854763046741826812737683933902168764597679636554385105093993558679.47', '-4490828077170522297233893004993.13249786', '2.82037423805486254216576591662663109074e+30');
    T('1599377725182495758517742498272843305960693020206048973447583115243269.1410087798545951915296847822871200148003875672207221059954691330107473', '5088063662255167160094549907732541865919416012140789.267488408929408273548538461707216938135207', '2.1844508625218647076211356222081320411196598385437706721627302640180596421073005329651875848335672207221059954691330107473e+51');
    T('0.00000000000000000091951455826031110073950473421217054945023004137', '880047376210923670087515320566136957381678956755035166368292510311615040924779967631184922.514417518390289574344', '9.1951455826031110073950473421217054945023004137e-19');
    T('-347310950900872385776467889423388243805166699963730339415360267534470.83828754168432611788446288344053', '-268630368745759667653.586235048837', '-254067255574127219771.59303783483232611788446288344053');
    T('186870193173432148130646645388.879740942923234926201708997173946572', '-30134593142508069785581273.715295334882352524247146983041708195688381392356164514745081831753250268038414517', '5.581096739607390257167080333369337455232069643267155541425108346985999423844065747561298095087893791580083e+24');
    T('-0.1807674864812454987374199', '-4469727073230097681266362826888054961977099149359.0374588261941846339229668347809983286076968459321981644745510609932772908293349139744841118084627847', '-0.1807674864812454987374199');
    T('-609942528111000950646441027284423914421676073338789300919146249735345832203325180490401721.169829288886540318797384013020069162311817163984967658940423', '0.00000000000491817438446678148457562512594581494844507213406015271765904587', '-8.43098438842919315107982234851497412708959280904973168566191e-13');
    T('9224445890397894331131171246915533737228450834032414548525009296813800.6194126855929999859102381839862079418242513149339463', '0.00200244838742528040113150017076386237193859471381402369402196727101743578532914482170210335402189674320', '0.0013517807556936445819076570223433161315655337951471334183465116029136530599646156000418832705275726904');
    T('-48683037685508014142805509729454.7708328664705019554487311077038575660905772924', '-3009.86809', '-2773.5774628664705019554487311077038575660905772924');
    T('-45.40878406155210820981388806994', '17322674941061069468.90696296162077004226138639510007304608119673036621826170347783883962799199837139339763365258311616188171455884', '-45.40878406155210820981388806994');
    T('-0.00000045798269200527002110503804633046978211168710862544855', '-0.0332022903595637863650592445124818543441138270869626594601406767165779904542946340747', '-4.5798269200527002110503804633046978211168710862544855e-7');
    T('-0.0263593463400', '16431622834110668320883651807426049458531131391388126888382321455092604238225568419342828987836945825243059', '-0.02635934634');
    T('146967376566418942423384976079370477844114594100864341309675391342034713364.6833806684984731707692088346576', '-0.013333681564204393251252427627958', '0.005064205951219194772596398940182');
    T('211754646034325622462.5754245', '0.00000000000160680374735486298985', '2.036680263359390281e-13');
    T('51605045186016481873235601735007249791991888297129512533440103662214424121299.1344940307379598284739161103280966', '0.000000000000000000011786218512737462780105791891803245937674332997646395012525762681', '2.588799129973576402223004629808690177116789885879883368785248142e-21');
    T('-617.554294656699194846345554', '-4.010908756729124879238839707729807689382950249519874348632636426606498742511278085488539497726029165636382561543373147540415292914484080714369027', '-3.885254877143088322803078717339423524408611823459224659206626729205692395774452920253456847917537657633468083863908426316460184083935650701538869');
    T('-0.000099945023165063334867500208938018190178130741558039812499297741499312773735009571', '-6722316615037541443129.257975301497143186395975837045082051651840624355546256470906712376653728222403894020565138962973624024728169204846444569100775', '-0.000099945023165063334867500208938018190178130741558039812499297741499312773735009571');
    T('1.47399214966951503197706669234', '-0.0000000001840478582583371644381', '5.02470037070635715408e-11');
    T('-3418446258', '-3958503176047281021850594866790858400.121417849614913', '-3418446258');
    T('-12686959556778981227071587746211507082286108179183876439271646348604072647005650127081913277412890.87493710443296410449', '75268789302897574467144387179003360679990148424', '-6.783811385634916183071487831399702281781586685087493710443296410449e+46');
    T('-13107.4826208600544806407030932767550902829117391520', '-0.0000000000000000037384466887246671347259264227228597229847149881116611194168157515133538054652289640187466938841', '-2.0126616347799094847193752802827297838499598456064986684374889162126566609421987606571510583884e-18');
    T('35404712862830131528829951583097767175730528979755821351149896205565020402884938392577568669927538981512991749406271', '-1031829364936517351885757530329733298799430897476255354154166810707348414663475611609730484965498257348081066493148106978487899', '3.5404712862830131528829951583097767175730528979755821351149896205565020402884938392577568669927538981512991749406271e+115');
    T('100539201018290722728826872367457614631333', '-1045913633296200056145880201567560454793511080052389543593290266185071912897427558382653862152861912376736712460547.2617511718', '1.00539201018290722728826872367457614631333e+41');
    T('5900417857967.684122320330266311315988571303719434583688056', '8470102.1', '743371.984122320330266311315988571303719434583688056');
    T('-0.0000000000000162275925487344742900779431398339947832550078717275513304235810620', '-98527398065181443.95890070566948299821236792792', '-1.6227592548734474290077943139833994783255007871727551330423581062e-14');
    T('673799374274922.944483940435547205550045463560294607616912043082182683195821140728435', '-0.000000000000000016485778560418899864685352845577378671092383279170185079302767621027277318696115879445674705947984124222523466771393786233625', '7.82834750139086490154197864647850303623771092697051197255144188339215023494951403366683672964266180245577656923491776051375e-19');
    T('-359760700574909877872.1893981874549355621361385437217', '-0.0000000000000012525895046273044615704543219559935320885590084464816796118205647431065997743952', '-5.273873466758084448309839663582338093952872688281491316326187652956128120625712e-16');
    T('-0.00000000000000000344', '-278600563952441146592998231079910916344907758061277029729847723704754927633299267404490050381652171978731152168944.3624353', '-3.44e-18');
    T('-19885391235.72444811560527014674591026983', '-0.0000000000000001210077665069172292508225410469346919696252649033898358285924802170280105173635047594325479625128232032868344035725367034768312666555169667118', '-3.27041730165540323618629447140644363558794072504731638157226990591284204649561893100263048858295969889235470457661290945938793086438381112962e-17');
    T('-4388062185.483', '-39594387554948541710295853541397266260999826140754757455063575150482412990992087849313100923544071923172382024125465206259558449365491157951841915852', '-4388062185.483');
    T('1.27', '21551626592.4081971013247452256236019543192696982517035660906335460694567861697569727904693502', '1.27');
    T('0.00000001329440489079501558889737803395626', '-1309144737900.376642959151800307497717804787800342628351', '1.329440489079501558889737803395626e-8');
    T('-156180543107.87592902679287176867109874431', '-4686280179444986299955463199189.092904143822557816915953501163200171428106923307793221186641484591113126104675812379227570402', '-156180543107.87592902679287176867109874431');
    T('4295520.77026900841676666457392998671922680353168654102503126542727033', '-38.020', '21.17026900841676666457392998671922680353168654102503126542727033');
    T('3756201184729.353948914504331418531', '98764.22688418263420', '9105.893120837470131418531');
    T('-183445480599552748298061627642.054002297', '-0.0000107', '-0.000007397');
    T('0.000000000000909591216320809881489928409865189195215922428863268009816135413196049055956596319025228879647140264146595335905308933772188246737897', '-12795.4852229887102245317', '9.09591216320809881489928409865189195215922428863268009816135413196049055956596319025228879647140264146595335905308933772188246737897e-13');
    T('-398115161708797899244094', '-0.00000190822', '-2.2942e-7');
    T('-848992173816.728883939845041393969214986771465330815208069567930789668049373073351425877934822175812944020178983059783798362', '58562228020085626501399449892933178818812686495472026995354960915893982723005540323314902834042032988.31762122657557564887837408661222893484485', '-848992173816.728883939845041393969214986771465330815208069567930789668049373073351425877934822175812944020178983059783798362');
    T('170689702928493785198704770480731726844384694228880632000086674248431636854235360847784394580.85956251018513598050194639733320', '0.00000000000000003249511361722935184708182221178448630186575980523410123888723074013021153647708920596380343297194452156472646750', '1.32996935134055436147559167404493656358621211234030812331554355557884963071617424821454322841322328537630845975e-17');
    T('1321696536903060333507124214923130056533062275039547547929702694853188954923451499474519149', '-0.00000000000000025469171278', '1.218603981e-16');
    T('1519725031000099259255503608727143117600103.950594546108601767133460279781', '36369953008089867650245915598882421133753955282.449761084477781573225146186400665554685339940078210117714275205598825657812211050146', '1.519725031000099259255503608727143117600103950594546108601767133460279781e+42');
    T('-83497099821374016986286773.646990311001433716310815087541958164127982967474303128253316028', '34.885503706835596', '-31.096961763167985716310815087541958164127982967474303128253316028');
    T('-281551500617863299353204258388337646826959732785417359702291456810294245173', '-680761080887665089.960819023854303651778569787', '-75711260041960558.526892392939593150576805521');
    T('-1.15721309733221526556327685277570425765587629667165133407328940007759291237969184088163508432164257007784170132569200710694878', '-3218490902199503763628322542391806103361580787103.2620354099117464128382431498128680419559189', '-1.15721309733221526556327685277570425765587629667165133407328940007759291237969184088163508432164257007784170132569200710694878');
    T('72685543', '-501466282854557781199312940523192072364105342282967607632661628.19377138387', '72685543');
    T('245721737418068480302255303255239643597822590292208445238466792403750601113775053588192850226', '3386598210277254485823559672192', '7.42596358685217392305157389746e+29');
    T('-2659239972.775732441119988378284430845255754722338730479949959770532563552221440837219977492287', '-366766093425414896727693582201631208201498739206701475487999587.04784925264477357068332', '-2659239972.775732441119988378284430845255754722338730479949959770532563552221440837219977492287');
    T('-202937664456304.89555195325400615051606086193279', '367508289819471739156301421289081005042399.214321331102128714358354131581972689141507241561', '-202937664456304.89555195325400615051606086193279');
    T('-272399937191.733', '-33398478226504197401967686042303959950770799816157551894222273006.68924', '-272399937191.733');
    T('0.0087589373702205672661687978512384214861196280910391339165', '-373449691484745421909661659779737619793741839646928018592372485434538362245960211318420579829536.7917148942879686985463255295177053873', '0.0087589373702205672661687978512384214861196280910391339165');
    T('-0.0000000003525427146401188285154486', '894317500882.51091293970592971909046143867805856323040', '-3.525427146401188285154486e-10');
    T('-91451509534712961197767251912.12413503036698723430206046435825379830131588169', '175966443745543358277161986311916627186504872290571423072359410287954017058417918465262148785893573180476929551596101110996620722038220', '-9.145150953471296119776725191212413503036698723430206046435825379830131588169e+28');
    T('5239772947176538407844432421154043692127337338786315971056005937511720316060149414713137609138942592364274998260.3914418522', '-0.000351999447227731010425590682', '0.000220009266937371477472993074');
    T('0.0000000000000000119885361224350878697901381513746669638803014061044667195642049359814289191991814187212222202848050879631237494325242872', '-78535546704.5392511810713502849597204629156277123901805', '1.19885361224350878697901381513746669638803014061044667195642049359814289191991814187212222202848050879631237494325242872e-17');
    T('-39212530235163840641.889', '0.0000153516323003372462432711273284710', '-9.9431734462012600433819830344e-8');
    T('0.00000000003095857781498', '101110441905084702.0357403762824', '3.095857781498e-11');
    T('-10334049534629711384154568939144539037486810844012775904747573760967321021577642786297034994468008867806308331807710193171907638257163287742135', '7', '-4');
    T('-15218677194629873309845552539810909.24144546875160065973098514044701774323707782894779555789259131657466804', '-34518535980025586317185189406244975538787915397779.23976886730365452862236233621200723924917399966293372039141790286540026470', '-1.521867719462987330984555253981090924144546875160065973098514044701774323707782894779555789259131657466804e+34');
    T('1140580.761784', '5541289870140054.14605122999270451642719393072416088141141309658972740905789791956116896048544622227464211', '1140580.761784');
    T('-19230493275938204954207576965451693824417167596.852559467', '1772734380358953111610301912647488842242624961779873682671334193795568636568468773326514107362478536842717561130919918', '-1.9230493275938204954207576965451693824417167596852559467e+46');
    T('599.7', '-1619645435801723194772984.179363365313908446470145035129596757155977', '599.7');
    T('0.00000003527897184750897367124288669208530527416142299801842725622500628314084302757630841538287485331290943712878461770448393129110928068601146662', '-78850.70929109605094', '3.527897184750897367124288669208530527416142299801842725622500628314084302757630841538287485331290943712878461770448393129110928068601146662e-8');
    T('176028.398859288392592242830374424713538809024937584968933934', '-55388056.672', '176028.398859288392592242830374424713538809024937584968933934');
    T('-3687887449589971447806306109197252366886458742730568279682018480906663049444897395704418760650684470725759432270992', '-3.7420395715065178572722', '-1.37688512348852048922');
    T('0.00000000000000000005256579563216950668763224444694962365341802542', '8723053021165901635236330129212563.3636641322636657590577963894918834488095316505676835145660950358', '5.256579563216950668763224444694962365341802542e-20');
    T('-0.00000000031', '-40709625512787616635932401858411015489778633837395274172588092946942501539158146828356731279975556752797552634865553259851', '-3.1e-10');
    T('-149135372988628919970496739114893960253872819.29190786741735400203191111811808959575782606817793421565345731848675379351509', '-27246318921164548382835661684073753930547046090475812149871172745414922', '-1.4913537298862891997049673911489396025387281929190786741735400203191111811808959575782606817793421565345731848675379351509e+44');
    T('-24363147306500486229311532771740994620057318471544291974564601298526862244753274543680731501921598200150080347486100220249.95', '155112283879060815501594513038826638314014.151622292976655', '-6.0684495386164490837630162468104486251948666896636943585e+40');
    T('-21581136768145783809281720761.44048211993924021469354146024085251250876602551196346646616560379632610', '3976135041682843254167378300.9535996945876700278842158983543387014253903902294', '-1.7004615597315675384448292566724836470008900752724619684691590053818140743649634664661656037963261e+27');
    T('0.0000040326918148754448903294471525102', '-47372770302411027590776261462082130188562141598263.7', '0.0000040326918148754448903294471525102');
    T('-0.000207149307738031286357317412628083411158171708095191007176464575073542347747004508854126911118', '4571168574.53730007', '-0.000207149307738031286357317412628083411158171708095191007176464575073542347747004508854126911118');
    T('-97509529222819532741120.7501430099139821788', '413204.03894124413846481557841831902206393440828094465180414091136336556519710979330', '-225763.5035665848727274739410862425313052713554127953879950852567857905478666569684');
    T('-2.00', '-27821012567074003433639721305709103428961197219622539.5685794624070639394524366200311619036627965777978152267632220', '-2');
    T('-0.0000000000000000294734806609719368469844343453588795984107909582873623530491162658480309441610559248449712368676186348212527994', '125.2766533052382457665605834964486208493706839813580506', '-2.94734806609719368469844343453588795984107909582873623530491162658480309441610559248449712368676186348212527994e-17');
    T('-0.001633958178625393150319605773581603368794536210123014338662866483443630520788262608537108853222673749309263319138110819633916150775', '984041712528385604819023678382822872190082698761085069290999301227.7932731339787355560947196826063289233812103279464', '-0.001633958178625393150319605773581603368794536210123014338662866483443630520788262608537108853222673749309263319138110819633916150775');
    T('-647590209400834319944871139406631294085860629844127321070709716929419594078771338864670085558591972653967722448703626313095422674915141792986000', '0.1598243963757636855858934473058567117813241414088147740804621207975238365569266130451403849392927831342716601396536406385033', '-0.1044367829611085137461733259113676442705082608844196425772771026984610209105052891722465431157849664696915079658107241925781');
    T('-25494638.01708', '53771122205901307230592753088190036050267061395902109215165014594840247575345774715515212', '-25494638.01708');
    T('3699534688828621863573818255225145699064136663560216492004997448846', '-9352801580752779322144587524942771278907911645795358120645130483618643349473297562259322949157930678655.0985025', '3.699534688828621863573818255225145699064136663560216492004997448846e+66');
    T('85032671555909805603615516661404.435251', '-731048436229736323522.991409687588012443676785142131368263222377948374546633511253019699058056630484634450274338643065674171', '313431824866633070885.329503399810155585075007013107299041216892826957929258111083849330121077202750028714374886317572152301');
    T('-209945559192857.1946165', '-27531413554176324889547266436322269.24', '-209945559192857.1946165');
    T('-295428170594032684107120468868902197984687862352304428967023482208137265881.1518679174044920', '8841356497728907803087292.54', '-6.173111942792252980851311451867917404492e+24');
    T('-24870862326767803723609181211951886785506016576823555683020976203476199.6383226631946206831968357575', '39.0192876', '-36.8342102631946206831968357575');
    T('0.00000000000104093732456948791535660490005579952856632590144252349583941188680067059085582490969', '-0.000000000001845', '1.04093732456948791535660490005579952856632590144252349583941188680067059085582490969e-12');
    T('-110171543516072519154077470043041622245899518010724357.97', '-215985365493128751969338708436174659881146326.47130407981449301251477', '-1.8642809482641267496491145390027069075248347603428080841787298772523e+44');
    T('-5897509163.33237929190342310229239099251637748593970183365297489393099622646591458028949809204', '-0.00000000000000001049808087192732915451590248336583114743497320652254457639908692412845756123814307660410407578158294', '-8.86866462108221132146017741372701042754803104583264417668482799703357268955774117913535569071970096e-18');
    T('1947618330530090666893298405354739308961415698078028620052704641974391377424081.4370720895447112874307354517864830938810415902572192711612629905619', '35798247027.429407843795', '17046145447.5748487031747112874307354517864830938810415902572192711612629905619');
    T('1452534530844578587286793835405885853021971526781401425425378487935294373177736296627509724.7721554655330008757886130352256', '-2230097289481941875743.70308986073045123685990370268605393875797132020959914189', '1.533131766810854713997740773599277043497855099271539159216055642143596393742e+21');
    T('128826616832138303811999586234163151680224444940', '-0.00000000001208356353496390300985175475564359178694913852139721834444645980664649972867877606030662673387062705957528277363458571248', '6.69584035445008621624129454859440871477459703283008018887200388923227463902698155614027423236686957320538416711587060032e-12');
    T('274755781466764052656410387030227146979693383969398878026929839099188933143187954.316630799958652729870465414351983831108637697738523329171365404311371', '5027580651709666928642445905700005774592840179967656101.79182444554585905527707052212762780497609', '5.48687928393824668751094954125758077209867579670314978177150003853834520394957509967430136734987697738523329171365404311371e+53');
    T('-2406059574284703894148440688533903170413209795439273014905177947511690472468600917700926344523744291780294283495749086476739113840212', '-203.98100910360', '-185.5516256192');
    T('0.000000000000000003179154784807166104910307727154315003026622310376783873362697561702481688909293567273102622264690939490656665370251098076', '-5350134300750700517120759400898359875793', '3.179154784807166104910307727154315003026622310376783873362697561702481688909293567273102622264690939490656665370251098076e-18');
    T('0.00012091743522867814073847484062603275868239331576857596900007215494716545366688505334', '-10378723922985921543083277863626740941254369901608094932235751553750705682535457043031.41378179327287353', '0.00012091743522867814073847484062603275868239331576857596900007215494716545366688505334');
    T('-1660767751.4', '2459907786914500616387727754259763565894446392427524988.3089887', '-1660767751.4');
    T('-0.000000000000000000033631822597167449133998986776130306365257623634866807914936753769658125021314951009961432799089', '797319763411607221.38591797885093271728899657566132838267977116823008412182171464', '-3.3631822597167449133998986776130306365257623634866807914936753769658125021314951009961432799089e-20');
    T('0.00000000000000007281386061841728062540615021553752512420210250015235565748841313988186929535298959795327001', '-0.000000000000018307307966434251165', '7.281386061841728062540615021553752512420210250015235565748841313988186929535298959795327001e-17');
    T('12297805724713550651709585300138356133248943868', '-163701508250759793576897510100944.363665567661696351838785854587582512790473802696800243554593953318621704650392740611277466227704883765281194971', '3.1332237910487269499049391286794358622794996271733943713726789898996217900759489344672017564153060898774887549719068362196506671085592851829665e+31');
    T('17961425562245817409581216294804746.065661120381362624317312407718862471407015786507000357168717692371625586', '9046942197910576941857651741.55434563534612137400298066696827535805595960684000066125477228083537184278377', '6.49408647019344859254849589352376161554251481462630160649054320755389913647417290498278294020058008596034e+27');
    T('-3360310711195664412184900840786504257661992132828215038244142041.22859603911690657528947205783809347874816594', '-5735628655860989.451138', '-3519456098473580.96254003911690657528947205783809347874816594');
    T('-0.00000000000000001469591999823677591002239452537827102191452346037061990719157543642750620200165386046868332215843328867721811877823863271769224341852627352', '-52861761302592655772535505924331973233.9199278286451051457115517367966126642231724169207509694259781203858104417456554118076000749697086', '-1.469591999823677591002239452537827102191452346037061990719157543642750620200165386046868332215843328867721811877823863271769224341852627352e-17');
    T('263428047166492021214430897.349', '-935321863128449821208776543.4661', '2.63428047166492021214430897349e+26');
    T('-64.23084746043437274748289661517354551174901810407232904876189241671863464191391813766386551115089149323979310399810268895863595', '19838093993118866366953732423596875847833914', '-64.23084746043437274748289661517354551174901810407232904876189241671863464191391813766386551115089149323979310399810268895863595');
    T('0.00000001042725590087839885246040660938289118002692929859', '1895509692.418538195', '1.042725590087839885246040660938289118002692929859e-8');
    T('-108703266290337059775.6444368018636935234787428949076436661761248981668101717329076241048414498', '-2258330970500035491281882848071727906499835424315004637497720003971765589145517945042230744562306208501662783826524402', '-108703266290337059775.6444368018636935234787428949076436661761248981668101717329076241048414498');
    T('19785588947095741.16', '-209378513090293702090937928908481270047755761853726892468236568171933572299844184320681716923601277379094105477', '19785588947095741.16');
    T('6.5627', '-24491197303184669250685680749224554131071232120525816290954743983460746359901828278732159826845479302974005432248.98478397721775763807590701860762', '6.5627');
    T('98040252941.5584387068346031648', '5799356330802.26678574689410221475982263208559136859429961045221424410142780663576353327734590059939940621596297615', '98040252941.5584387068346031648');
    T('116459945', '285087451924', '116459945');
    T('-0.000000000000024977925576784464857382157052766774720130135842951378009457010637198779202473727325439', '382620017160416816899117416971.937114437851011757205933117037959418794157533127476013068487945074162512915274505494963681134423226214835793018854460', '-2.4977925576784464857382157052766774720130135842951378009457010637198779202473727325439e-14');
    T('15693959990166898467530406779039841070032574908199729638250529357153104897', '-0.0000000000002824974164922651345048893785611071689041377509099951591709879707481443285597447959', '1.171281807977374285869977160622664270509881729566135484299178262958875818964075864e-13');
    T('38848812619964290843361545253566362214', '0.0000000000000058425180574815230559485050316708859218673791077977584355914797766947281173401829358941785694963992', '3.1516654254079360183309571610860641637778291889893615348383342541484388461460984134093274298941168e-15');
    T('1747169015246368594998.464722228648492098168730638104125762700809327003329875209', '0.0000000000000000000284393447186198269469304488191298546623882877275494399348981067472547693385217621583802872048566279451580304473660909939163358', '1.51262832017785291204651557051891862995924391738284925362711136214365955363154169051468433756051932474065931228616555991508102e-20');
    T('1431452840526919937933101541902740083072.42410139031811129499443', '-37469198013000024864225724154390.5943722958', '2.035118407303377297932806595854716825940131811129499443e+31');
    T('15195.99', '6038496355477993856241855699590649428405756', '15195.99');
    T('-2041396228526158683078620920473339987062472388906811556.219705106443467336064724639399525662209445478538446773454254723160644110', '-9896112700699691291.92454132620577755838251', '-437387204257609623.94163554707241697768552463939952566220944547853844677345425472316064411');
    T('0.0000000001675722009116506345401287561663653181456651402449423225303665889095', '2318773737623386732448176059369887376294723563923814698031839194174397762959815701', '1.675722009116506345401287561663653181456651402449423225303665889095e-10');
    T('-0.001277093413988786193792338596676914602745937422', '-9054497669216982378641234353912833868366784112824225472373455575687.06067706432215821280', '-0.001277093413988786193792338596676914602745937422');
    T('-7586359.946325387213858428685527361653731476271038018930272114935277172424094509714364626279197619817316315689963471346611526175969', '0.0000000000000000430136274016202618412879577873962429424232143628863509810616167892960358806475007016344779281704267625230587638895190481865206340', '-1.7310828493766802121394011969560202470214375466524665165343928089767553023528999738804774624545501070324448831891021818491806068e-17');
    T('-103412754444480069058780993539472717862718628742017032622717305153554156500660602780.3951870520597328029305', '0.00000000000020266200284082826503473600665777073078290305445466856192999389981999174414790577002212363701234328068734339302422794462188621520017527973975244678966', '-1.1778610247698432518015282589512280988772755012414363311971091185982964630918238442878242291061344089450155031117839124238643126352705822770745553166e-13');
    T('-4649840103983286431118728885.5686899779272666748077658422319061095341256831328876230', '-0.000018283271700643090900759826621345966959563090797', '-0.000012253346082427405840049943876343545027546355616623');
    T('11177150046419761513519128718157640126', '411523640124736736627670200725572416567962335255822909421', '1.1177150046419761513519128718157640126e+37');
    T('1096935867719575049333091824804333510580945589.83824692435717061889762037572296699239931905470583854219762636627842602007335719758', '191153987761529206300925.3273', '1.2912957009764464951516411274692435717061889762037572296699239931905470583854219762636627842602007335719758e+23');
    T('281098490751309919781.837846365353940940012601874942516251228270125', '-0.00000025737546499923055582341344593708193968274528519657943958684105481278501660321915687980677654353727621750', '1.513406720586607228234865179218366144830241157041834126753669969930905426261187858947727786029406807325e-7');
    T('35010488237245036697520709084885266506843.425268', '5352655279155382458162.94330921', '3.34054595183665523603034231901e+21');
    T('31145808975597255138857994779920960247290282089774585062872200414184550100684.303586528813', '18.3819835858', '11.042075433813');
    T('356018189420944082693927775557.325504971417155535076952686936532414415559512252384067063438680483994312420857090610153342560066768401075', '-8727338718894573084672497563561164796452986318031589007265947314318840375612702741093080619723378442544516952773104113190035800', '3.56018189420944082693927775557325504971417155535076952686936532414415559512252384067063438680483994312420857090610153342560066768401075e+29');
    T('131429872161991712843260938039674340723308898895521699771855.024419884969996712236865308648727765263561351531', '24712061.01438024179678320259', '3429325.950976494326109883486865308648727765263561351531');
    T('-34341392.101415133561441008979017430685687626916432806544362758', '-1799749026300082270308704328638985.5768', '-34341392.101415133561441008979017430685687626916432806544362758');
    T('-8413086128647.685221', '1606998396292485000476010332910518280001488901905838129531.210325550440342452530296261171681625711233494822776448488394', '-8413086128647.685221');
    T('-3.0', '-3139', '-3');
    T('153157.73428689664192233409327048703188379081578410604659706896677053628345674074129524175863661791683502264736428459474866594560693363338143', '-750845024214409.258', '153157.73428689664192233409327048703188379081578410604659706896677053628345674074129524175863661791683502264736428459474866594560693363338143');
    T('0.0000000000079148423562335767793913910035210781639819699467034642740182963781086448957016588218561890889449126109310405024351752573234749277921432649542353715', '20.00', '7.9148423562335767793913910035210781639819699467034642740182963781086448957016588218561890889449126109310405024351752573234749277921432649542353715e-12');
    T('11859857545035115534901402622688845103.26562817190421979271737710348373108096466579924379735578113634951611925484107971222', '1851265684423437968651977889678101896760692374632438502425532634360068350.385560161140916692762655434938124023616766184141', '1.185985754503511553490140262268884510326562817190421979271737710348373108096466579924379735578113634951611925484107971222e+37');
    T('48109224570352158844369436263326645.893373810649056419300323575418280726520558310461296', '997.098677101792499906198905275633517346903196994899968608672152519988658750302936220222619145776458182531806754907465557169', '935.865574632282320424247042476598393609973055983379471096359067799052781834688483510305261831102736621823846394515810747161');
    T('288352547873858.5', '0.00000000054104505228159386805524414898723018589882606496349575056289472447535373273397426133779673431360860889934275', '8.2673783217939116398724200124183517796838889199181998847282343820866487394178542482519715167131249859192e-11');
    T('0.01383525030381675505711753283705031809489417131896036954963744982627869295128813174764504280572980911841888', '367605263666452149870730318125641658304719350393018537475278503369754165680652067258735', '0.01383525030381675505711753283705031809489417131896036954963744982627869295128813174764504280572980911841888');
    T('-3505042194759758434255338972290034512117930395098910381818797807.88446', '-3902404098859498614003813210221299711513544600259011148097595421079608627612964369831566426492055190022939.50548422319511214', '-3.50504219475975843425533897229003451211793039509891038181879780788446e+63');
    T('-36026.8915685144533733380523666761979285283755516228130824117905334817989501255635498677420902031957643520214809171824', '-114223033898589812722834379611264506788064644828093.94800173309118106933782098399593703341461245', '-36026.8915685144533733380523666761979285283755516228130824117905334817989501255635498677420902031957643520214809171824');
    T('0.00000000000000013809121', '-0.0000000749288', '1.3809121e-16');
    T('20724213487987.4778151388942299169660827860781497232254137576387255648682698796172600059231860766018620789364227232170076071666458413', '0.0000001505314883568650229916354199483681188910572425586579937337120672732036834724306361544492395168511705791', '2.29883655297313793669989172506206203246334456768066197147148446745240375475037698012664723934396524013666458413e-8');
    T('-153138392170770562583816571476981650458239771831947250.84840860593737927903083269', '-308451953716202377192878310778513020451424572722485447176140047813202767698204721821724806119.758161292949455744622007277884667216068789328280721', '-1.5313839217077056258381657147698165045823977183194725084840860593737927903083269e+53');
    T('2024889826013722491642109209599457879536241401674305584888599322154577560286041916004095464239039183545712355073451878243704708180367087', '4683338288486975605179756026626993457497864317101799400353744322277088843093746348285508196719464116323961318584747939876770.2', '4.2624056691905146720562441944677299974218341770933920083702456621928076177796341929265641218876544182677248833016820278781996e+123');
    T('28313589531.63989269287899646520', '-9540641513056039416103997609028907233031199495306430017143', '28313589531.6398926928789964652');
    T('-2641228946549921949803625465.800690017957640611162874431878273597335326201803', '-2.04', '-1.280690017957640611162874431878273597335326201803');
    T('3804757657533490618037113031910761806055921644578987055.96708854321879766867635040692197', '-56283755203464428334670377565843348841905251379123127204289309457333750328700.80439297', '3.80475765753349061803711303191076180605592164457898705596708854321879766867635040692197e+54');
    T('-0.000003122558770454963876212', '-39544839986003369027933892780750841310717452858887832507369587012.160870183482262070063337198049486352931637085710934033181', '-0.000003122558770454963876212');
    T('5392479076929588293587612879284527077531852805129124829184368274349602728517523896911896867945402316135762773529299018121736199918072580', '0.0000000000031117750112617018767807786730379346274843985783', '1.4353640854938664984508258039534714987084307583e-12');
    T('0.0000006215288163619792375122235621598208666024377435574215852804775078406912545206606730739256331954317406302758639949372100097183229', '-1700271804304.2321825527640867380703229974396263910191256790985519859411209446664490975402918158602308456057531026581023238119814318747861781914', '6.215288163619792375122235621598208666024377435574215852804775078406912545206606730739256331954317406302758639949372100097183229e-7');
    T('0.00000000000000000001395090317654918659456545517103197123320734631379609159286124417697908168852487462191684425104983578404131395432', '-36360831023.627373636', '1.395090317654918659456545517103197123320734631379609159286124417697908168852487462191684425104983578404131395432e-20');
    T('-0.029041934347034050874280668604145494973712402916841954749197882673846083921928051487', '-24321172024135194808.395261648243950525857', '-0.029041934347034050874280668604145494973712402916841954749197882673846083921928051487');
    T('-1195623993147803871345536056905699481677978210464192436338258797046728634803018357673228508044459476891363148600.9832229463899180212881047872', '74333560130107705155367279487127775431014050908659963244531.63816885515954178693780861744425312763135160774863427607199163982187', '-3.086071550827133408617073704504470924384848699160039276410221417738588615789646409686448568270317981309079754174890980893975151e+58');
    T('0.00000000000000056280331289271771568763154768933854147024773200443808381650318222961243204491709538', '114.456600080136471439211636731189295907102935969767768173395401795448559059693594476527026886599808770208262292019087718144844542649882', '5.6280331289271771568763154768933854147024773200443808381650318222961243204491709538e-16');
    T('6349098329627676906649327567422334464124358967178664653673220067.12545346036152018429985973661814570758371069143', '-40.149580757418441824336470759561465678877107568894320488314323759826632493055455043642548602102537942593850156261255887938596477', '35.559837216237967922905742415355706498518504880575653814975327971087870426830614164516845532783586654567238760012791188596876952');
    T('0.000000000000000000134958665891757075394771428809225066409494541557306409079645322067754548797099784994774515332106618219339715207891623', '0.014098046208108624476748153262771647868771485742957685480766065052014710323', '1.34958665891757075394771428809225066409494541557306409079645322067754548797099784994774515332106618219339715207891623e-19');
    T('-0.0000000001198616208882375095568849612873993998239584002760230102327127648031323996108632845557417295759919543714234552132382176739713', '268502661662756835424685753368073720149943858868258883021295906122336165047282467800229455912077913155968019665198341299031672675184802671292795982', '-1.198616208882375095568849612873993998239584002760230102327127648031323996108632845557417295759919543714234552132382176739713e-10');
    T('11076417241349251662298800548993053870489927630158', '2688.3', '838.5');
    T('234.1833389564397314620433643408344637353276768649544802303136396105002821774541067155967638799471344828367', '-812930653675251477172818677593163802475335395321516392160988863518282232027.9562556743336062078852192049177044015303006113839518790342145303511416', '234.1833389564397314620433643408344637353276768649544802303136396105002821774541067155967638799471344828367');
    T('-140875446895336688695775538626569168776437615910859.266762102378021102701836180989625107023822491824898835037416036752', '-0.0000000008120648359026855681066672', '-7.04899443282288314693761107023822491824898835037416036752e-10');
    T('47302831592291859921582694268176274322977565414806988738441.7361304674456421666929415117545213713741289186588622962427363296591821124', '-4883810167764887872263063592054042463186129668615153318291940325670910399840788193978235038.40572599417807', '4.73028315922918599215826942681762743229775654148069887384417361304674456421666929415117545213713741289186588622962427363296591821124e+58');
    T('-0.0000013500524235084418996188348105405437586078275799625742804819565981475194354476354686524527', '-0.000000002779302718018358208070594207983495336655239720268299505135366323424005449637210093828893056230701144', '-2.09060526953816870459661966854852033003631563244902049130393128687679237358857314543956772810994516e-9');
    T('-8856430201.81983563385', '-938319623036559525783829785765639.1967490372320401152237017199929134065194059252249435216165450476221132716254629851825940147', '-8856430201.81983563385');
    T('-294598922189601641529872833094268363637995845166.9646336278254278800792178104215750273817481774076459356025057202968', '-10223015027442426717349749487745963093309181008.205638767965256198287559296860180242914602395642001035903820036797933102584301654148', '-8.354501421213693444079847437381397025338776937206748124798254328027557498336528225772881099431616930295544689954673127639553683856e+45');
    T('-134482328774078327.78079185017538184873315143896148192681352250548636020696397', '0.0000000000002450342135144683141905584800341536509151970912600522688818921301', '-1.60073903831321955625426419137488883923201731240764068955671173e-14');
    T('-78800324525137220517451995171180995756206048564118678612521109029482402593085439.179075675835830559536829101701753174835', '0.0000000000019610051403211771404265319419334586289897793595385183097754722977683927786401175145119430883943240234469175280289689345365813902443272222', '-6.535925793221845660690544723959477724568508804990257790953954534740872982749100270224419170325353310184590062864940380043185153774656484e-13');
    T('-0.000000000274926667753556399411968202786585104173511', '50122654291684689961017965995633281037050370088364056805776193660843878710891076787.95089764411489192357442121111434586112155176770186465', '-2.74926667753556399411968202786585104173511e-10');
    T('0.00001541285093466595032153714556336460183444913540837825470619197642409009049424847511805411133860049617440', '7665422149126503228084815387690205422619171304204357008349412728229292.3453547259', '0.0000154128509346659503215371455633646018344491354083782547061919764240900904942484751180541113386004961744');
    T('431221936', '0.000000000000000033002980288810278906842632506499735728904330341685973153145895066915569913336407191052426472565118072610', '9.10099606819992067300761400250765866243445746733753730198731073886381276861851209124916361256120258093e-18');
    T('4666715111789921577904245361334034970447224117169861897028729415807979546253890966745728334297280769367.70886147058269253176521844671243912148148079', '6.8', '3.70886147058269253176521844671243912148148079');
    T('2197002885429890116954900514249548697857546929350020990766722904092684082.2392268693970414838', '0.0000000000000332559964853018317783655876966402252962358315523892307692184125776284852387347864848368445935612207352750309642788316', '9.3491979527670904641879713520022687811716489510692050229377615200828160049260989946844066618421874281834484917990608e-15');
    T('111094585048273140985385584415256560233393427038902518.784369340636556911255874165728', '1132940880188177667933583369443202220027425411297999020483308891037542098', '1.11094585048273140985385584415256560233393427038902518784369340636556911255874165728e+53');
    T('520386', '91455585201495693176033076068679833231426120905022134379404266046062624029800133847471370511643609325721500716912256.984', '520386');
    T('459661201486307760729688778845476517533962920316992893663687352420276986833260305315498074609385953532821599018231099', '-270279027874029833827081796161869449847637992962004968243052096882327994299.79117493308674063254110578511458305133003811803355185433888227224', '2.424027017863735990977800631861728865952035304743598958695126250204835032809271219019609279133635203601969578977452650333362539299232143024e+74');

    T('-4.785068183e+1', '4.100602340813778290214569907944153985840287e+41', '-47.85068183');
    T('2.80464647349124269012895506839600253935327310965e+18', '-9.5524432014496391100798143628e+26', '2804646473491242690.12895506839600253935327310965');
    T('-2.8475390576301982648821864330615e+1', '2.699279786373606e-17', '-2.6651296488681e-17');
    T('-2.9148775309735883444412038961e+12', '-3.7791910283459953859509024618806015827414491747e-14', '-1.2484519780688810034904273898769796515468689534e-14');
    T('4.75952e+1', '-9.2480596298788483952588449013e+15', '47.5952');
    T('-1.059098439e-6', '-2.61519835738114698145e+4', '-0.000001059098439');
    T('2.0737545782540501468649951383811505929864648e-11', '8.001141125055718003273562341771790690597363615833e+48', '2.0737545782540501468649951383811505929864648e-11');
    T('-1.22658750490728083398e+13', '1.8753238083480045539938865768259755398e+8', '-132148191.84975394758545561202438438412');
    T('3.0610455075185277682819215983121128590345078192561e+45', '-7.2132877592078603887799551646099823518259e+16', '61373855855082630.483565489609741494295639');
    T('9.0188012787220251521914339e+21', '7.34972521506799782052e+20', '199131020640427767567.4339');
    T('2.732276e+6', '-2.155e+2', '167');
    T('1.81970803337505025123814446711e+19', '1.552273391587321102352777093263e+8', '121079294.0355602541613892510099');
    T('5.29521849750516603814171596807e-3', '-1.186023062792866863315593132074754530817309278318e-16', '9.65458477943067357182194529851732179008303939488e-17');
    T('4.17590665394570316906941267960925070278431e-5', '9.049524633791428612160450019368774628e+0', '0.0000417590665394570316906941267960925070278431');
    T('-3.349078310428002e+5', '-1.6540638667696404135343644190345e+18', '-334907.8310428002');
    T('3.1992755000743044238501551275241732747e+28', '6.7694639443884902632801069e+19', '58012283694485729642.404216747');
    T('7.824216663065598374539197703051941e+7', '2.8264285749437427237554422632944775049521496e+41', '78242166.63065598374539197703051941');
    T('-1.67058990412026696591650976e+2', '4.22502522584451063700771426002353559984275436807335e+7', '-167.058990412026696591650976');
    T('-2.45635416234991644154081e+10', '1.6511720053714564535061012818217797956053950352564e+3', '-169.9750792296892367202705840388216243464507038608');
    T('-1.234302917437106938892e+6', '-4.66222869142052358935242282170391162075612576838441480514e-11', '-1.16831454856809476137891894092632703280451615639647891166e-11');
    T('1.839710778457895734645309275939324e+23', '-1.16318585777868797619955e+17', '90437897170854441.0401789324');
    T('4.31278525467628823588407602838382746643207760247774704277223e+9', '2.23171038985847514593e+20', '4312785254.67628823588407602838382746643207760247774704277223');
    T('3.0774747e+7', '-1.292178569466e+6', '1054639.902282');
    T('7.1986256721501851444121681387782246892728127232221676165644e+45', '-1.13782811077947907584409056830168328555517006340535538318684e+28', '2.4664369028970742315721904655905118416446174179007597618692e+27');
    T('-5e+0', '1.8187074446258529890089548133661805568989582581e+46', '-5');
    T('2.90713213183891582843410750914399986513758162e-3', '-2.63153627e+1', '0.00290713213183891582843410750914399986513758162');
    T('-1.1994289233986543701822561078984450080807572663172692845e+26', '1.3308098373134e+12', '-1101301973800.58984450080807572663172692845');
    T('3.80222940163e+10', '-1.86439621006147e+8', '175050952.052159');
    T('-1.0589771547255325020757865564001533466983148718e+46', '-4.66653476326811630302573645173380627372e+30', '-1.34743461530630312563356791528734704544e+30');
    T('0e+0', '-5.8555382904168e+10', '0');
    T('-3.877410561846137535676828506580217538851e+39', '1.8546585782329946703671500695022434e+25', '-8.304732800863368666145000987852196e+24');
    T('-1.163627582049e+10', '-1.190310616961783801595291761751e+7', '-6941092.77337225841399948769273');
    T('5.50922178592853292e+8', '2.7726691028626755345614e+1', '9.067016077612284334026');
    T('4.585813032273175774206281699078636679246584e+2', '-1e+0', '0.5813032273175774206281699078636679246584');
    T('2.143209743784799995437859351e+27', '7.89686033593298254046863395059167e-18', '6.81868949928986360863748711628261e-18');
    T('-2.2928677299898057914670255997347455786e+11', '1.43685706448112139571439918598028632e+6', '-306934.405632425577309870670368346');
    T('4.354911010988471845818170482045217459828e-19', '-3.4255381103210061953947764102346444839325208e+5', '4.354911010988471845818170482045217459828e-19');
    T('7.6205756951722652979726396821744395258e-11', '-2.469701682300246385132843673488255945931294e+23', '7.6205756951722652979726396821744395258e-11');
    T('-3.0414336636936289483194714509757754918625515721268383983891e+22', '4.536514951e+9', '-2390201439.714509757754918625515721268383983891');
    T('6.1950756263395220720928988581672084e+12', '5.50299097228515217025542686233486e+6', '994424.9277391452982364908047321');
    T('1.5592703628193685590607028031257876838163995140476313e+52', '4.644158636847e+12', '1438695302628');
    T('-8.321953e-20', '3.425924048971005175376011737e-6', '-8.321953e-20');
    T('2.50545873839057298343115607524742030919655663396773e-12', '-3.81e-9', '2.50545873839057298343115607524742030919655663396773e-12');
    T('-6.626563801610720283429069e+24', '-7.318668911456127669428074219e+27', '-6.626563801610720283429069e+24');
    T('6.579221387782276980734304828884120337616419799251099653496e-1', '-3.8969000319182257446208467342247396396093882352e-15', '1.9767722676183043776377919004479568382127247136e-15');
    T('3.1401513e+2', '1.237032386460703e+15', '314.01513');
    T('4.232794809535764324617667621124324483982653495945584e+6', '7.3809184815598732203484798105535965548268885342e+0', '0.4405677713499586621163276690389136391131296364');
    T('-2.54046333929067768396256156730192176704492639570003e+1', '-1.43509613727037812846035760529266475517733244287446e+5', '-25.4046333929067768396256156730192176704492639570003');
    T('-1.7784812894976825e+5', '1.348176239051319766183648668812555533668836074076e+47', '-177848.12894976825');
    T('-1.34525103103779e+8', '-2.1e+0', '-1.903779');
    T('-7.5e+0', '1.1485396369968399088809663888589e-8', '-2.897466364518558819119797833239e-9');
    T('1.02502826667e+1', '9.3481096028282686300763053917132870455928e-15', '7.7634911550320902212280587730161073680336e-15');
    T('9.56858647594739448303715711e+11', '-4.2315e+2', '168.239448303715711');
    T('-1.121662781899762e+3', '-1.153e+3', '-1121.662781899762');
    T('-1.1987521321e+0', '3.3717546189279471902193720771211135e-6', '-0.0000023276964037193028773035373618806855');
    T('-3.96409663517864928212668914312890035732488673186557035e+16', '-3.503768915124379422490579250903005526551657e+9', '-1073469883.0404370184683678233259100444904567035');
    T('-9.780642443954005196506214589e+15', '-9.0202154557465647565999764323022181914347547218716e+44', '-9780642443954005.196506214589');
    T('6.22723611860453496632948443539098691396413e-10', '-2.77824094902753769648885834726391520861911e+5', '6.22723611860453496632948443539098691396413e-10');
    T('-4.7319718694e+5', '6.8346446241247783161447574947601984306026821486383635e+33', '-473197.18694');
    T('-6.1933379823501920314298624358203814e+30', '-8.089868231074264910103113854481018685411838271163628e+0', '-8.004699925089141256941499632457605509538837084388632');
    T('1.5e-3', '7.82546748299781600669e+20', '0.0015');
    T('-6.7242596508788e-7', '1.3806352e+7', '-6.7242596508788e-7');
    T('1.9762609860647814575863656621674468865989380864741e+45', '6.51277646556899014436272323991705259786529655e-5', '0.000014790203177222374955576884258500785345510175');
    T('7.004000748022736e-8', '4.736649441368895442161035451e+22', '7.004000748022736e-8');
    T('-4.29285701374473103585848390846585847338e-20', '-1.39970996245e+6', '-4.29285701374473103585848390846585847338e-20');
    T('1.44068396723397585225000633824556784092935879966094079042e+14', '-1.85739402953385383572444765551721122270675395703645487708e-6', '2.2082902769721875195705810453565730977529281295245227248e-7');
    T('-1.90763083929612502667113570129e-17', '-2.989745679222607307608195e+24', '-1.90763083929612502667113570129e-17');
    T('-1.8008915784029129140878223332849e+15', '1.2709184544773109938594286324169565032629e-8', '-8.198978038773931537165401098330611286589e-9');
    T('2.5283393571163e+11', '1.42605397244976960657e+16', '252833935711.63');
    T('-1.07482517991266460493961480563252855043997503069929863e+53', '4.0293147259356676513464190395e+2', '-327.97566262501963085789832435');
    T('-1.791459937048480305498333255301e-17', '-3.60140444532360031210882850839206992361061e+32', '-1.791459937048480305498333255301e-17');
    T('-3.7973618905e+4', '2.076660739009108092554128277835978289058948608e+27', '-37973.618905');
    T('4.296835337235213305241997742797979761241859185e+32', '1.016128323816741556885745789299051e+30', '8.773810728563935184150511955984541241859185e+29');
    T('-3.3476803669790089330287396786213536648e-19', '-1.0485228843496121655433179024642877076320529176e-16', '-3.3476803669790089330287396786213536648e-19');
    T('-9.265001828356e-19', '5.82146621596502038608123809e+5', '-9.265001828356e-19');
    T('1.6574237778185417162412521417931606051387220789593e+6', '4.3416420707553748006564234818e+29', '1657423.7778185417162412521417931606051387220789593');
    T('-9.774062277712948833378e-13', '3.080037033054419810654271948e-15', '-1.034488293043803360395792484e-15');
    T('1.0480042083686042910696085478682293620068215e+43', '-9.1636346772043682784439956904897547881091051932e+20', '711021412902451879505.0635467550321309923369716');
    T('-3.40923816647136940940085344632137226188233200061358e+20', '1.6073165168980479523827835495337e+31', '-340923816647136940940.085344632137226188233200061358');
    T('-8.7800373379e+9', '1.589967630656932636460925283862063976207125245919e-11', '-2.20858757786189096197325170019616955392212367465e-12');
    T('-1.508492483290420652523454481016576379245159230227181384539e+43', '9.65407339051e-1', '-0.95207917271339');
    T('1.70797882e-17', '-1.221287649130143636399302725332474299568133811751e+13', '1.70797882e-17');
    T('2.25e+0', '7.2018713275608502122703864334941124435400603003965e+49', '2.25');
    T('3.66e+3', '-2.00125759501079698887197092755e+20', '3660');
    T('1.074410572430091406447031457374002693e+8', '1.14072231468921335177378921904e+16', '107441057.2430091406447031457374002693');
    T('-3.8968391781145045605e+7', '3.823518283e-1', '-0.379345773205');
    T('3.8807293359084454309373e-14', '-6.54951383e-4', '3.8807293359084454309373e-14');
    T('8.3790348726489133341557987289125627922491641304972332e+10', '1.88761931097750519978e+9', '735099043.478904551237987289125627922491641304972332');
    T('1.5282357157991306e+9', '9.951e+0', '4.4051306');
    T('1.1776422045e-12', '1.94520506072334528824768019674726837220814205e+44', '1.1776422045e-12');
    T('-5.738265352165406462762631804597466473267412948e+18', '-1.5172659934372962e+16', '-2999896972426826.762631804597466473267412948');
    T('1.021717777232460732646336675651455853866e-8', '-1.31332207597e+9', '1.021717777232460732646336675651455853866e-8');
    T('6e+0', '9.3047796711618934817610173062034274e+10', '6');
    T('-1.182956037757676026896657463893805186423539855204970266169e-13', '1.7827584304157093780925160931953100051299721649998e-2', '-1.182956037757676026896657463893805186423539855204970266169e-13');
    T('2.2104533461720397849851124115599254191623707092353e-11', '-4.0310943429346438323447892668604172339295221650618858e+41', '2.2104533461720397849851124115599254191623707092353e-11');
    T('1.722426520663101950880778227697e+10', '-2.69592201025681600543464676120992735285696714886632140343386e-2', '0.0223237854099389241141349574091483444628934259089076259401818');
    T('-3.25603413629979799893671467886183127646824550309804207e+34', '1.47161894610216114600651e+17', '-34172500003558300.1070534550309804207');
    T('-1.08739354e+2', '2.9193728838924110750652340949692628787e+16', '-108.739354');
    T('3.206759288064547512180035e+2', '4.35800600237216221853047563599293340753408e+23', '320.6759288064547512180035');
    T('-2.21248e+1', '-2.6325594996226359777509157939720585725219065458496707707e+52', '-22.1248');
    T('7.073189319e+2', '1.08209742786e+6', '707.3189319');
    T('-2.1907210461355111297041e+18', '-9.2745316314605247152343780428919501619175952441700562494e+16', '-57578770899590445.200193050134851462758953093840887062638');
    T('-5.16796251732448951395790039385689407742691059264573e+50', '1.6780101630562e+12', '-1253088706638');
    T('3.51223602606475213080940254052176926846990239224958899e+38', '-1.63965e+2', '137.150239224958899');
    T('8.1882456091960208142365059003084619285549256998568554e+32', '4.64295172738148816415249852304269862921945245047076609476e-12', '1.24381368401600627920725181533134960575834680987278935368e-12');
    T('1.5813114524781473056173591272288745672e+30', '2.42e+0', '1.9745672');
    T('7.454553e+7', '1.538906639e+1', '15.23005577');
    T('1.51240970967848419751948592395604701e+29', '6.5611662e-15', '2.51558e-17');
    T('8.27911469397271464898e+18', '-1.2068203240037786014348e+22', '8279114693972714648.98');
    T('-3.20852252575e-6', '2.775014697501612276189583840612e+24', '-0.00000320852252575');
    T('-1.170515851548909718864331941709405324e+36', '7.57552e+1', '-34.552');
    T('-3.84525210626e-14', '1.010105187954696781e-14', '-8.14936542395909657e-15');
    T('-1.77609228049985890329999e+23', '-6.46964642626693630854488379333298772649377016e+44', '-1.77609228049985890329999e+23');
    T('-2.6073763079e+3', '-1.0248349080124110516237552578873628724235803267839057233638e+47', '-2607.3763079');
    T('-1.3843135851252423514202512138558e+2', '6.264100013e+5', '-138.43135851252423514202512138558');
    T('1.737e+1', '-8.726745986924851889490167717196421297465059646521e-5', '0.00002298524516705360208547066072715688662132777520597');
    T('-1.841251966e+6', '-4.01007093384313393333803996623363e+3', '-629.40736600152459783965549876383');
    T('-7.9035320783720205756630542761451846e+28', '-2.599e-14', '-7.27e-15');
    T('8.04680904556172181303021860819810222422429215449526e-9', '6.067916963498582356994976035938910323855806689699e+7', '8.04680904556172181303021860819810222422429215449526e-9');
    T('-3.2591991380971738720016943747147239739143e+31', '-1.73144320279140892221728899407693684286357446057721685e-18', '-1.27592813736665621853520468633947214694438394987425995e-18');
    T('-1.2588878e-17', '3.261793e+3', '-1.2588878e-17');
    T('5.43e+1', '1.052831202498586189323776187910882192514844872077623859821e+39', '54.3');
    T('4.06387835714e+8', '2.33202324535463287957487622607173811837788707819610667687974e+21', '406387835.714');
    T('5.67752073680296031467842e-19', '-8.601036147246856e-8', '5.67752073680296031467842e-19');
    T('-5.6e+0', '-1.8453950994974064478634206768933065169074111213e-6', '-9.38967160341442620882313109909923108359525446e-7');
    T('-2.401261282811e-19', '2.056364582076044663398637567011867699558230779795276645e-10', '-2.401261282811e-19');
    T('1.0071885115326611960091167358045295888291572049818e+17', '-1.155335154293012676567e+5', '25104.02532384871469245888291572049818');
    T('1.014158574325029197139040004809e+30', '1.232019764151304366892839731605883657742763048324806262665e+25', '9.1852662414944875300513403008082924671691409524768246786e+24');
    T('-1.2960509353603657966595552033959658985645676032863193e+52', '7.312148044790448624282108771e+15', '-3433711470718028.563736068134');
    T('3.01768950813493722706548378704076026752577936470035725e+18', '1.9656153202749223229990334e-3', '0.00073182798214321319862218230035725');
    T('1.138167248709526636888918903478056867722716985003746e+26', '3.6048159266517496763778284439e+18', '719311038898532672.7955886026722716985003746');
    T('1.8330798601350027076470730268735578842175174524571662455e+23', '5.956531185e+5', '15372.61868735578842175174524571662455');
    T('5.64642126873494799157e+20', '-8.4189838723261978274550066411375501139050432727008990287e+35', '564642126873494799157');
    T('-3.35038698584922285256354681261850266025e+11', '-4.971223451368832884824701430128927927628669283992608676e+11', '-335038698584.922285256354681261850266025');
    T('-2.18228628448939641477994931560863e+14', '-1.9848009280011383843320378679218954e+17', '-218228628448939.641477994931560863');
    T('-7.9673369189287490637419160450685121345328702274551959142e+1', '-4.36967584013770925112063732602257274835575300806170773838e+56', '-79.673369189287490637419160450685121345328702274551959142');
    T('-6e+0', '-1.355953074987858129012845374276873617e+9', '-6');
    T('2.8980599713949417129214483614111169203417835e+30', '2.09234393781487031432546596319751546520229578e-7', '3.5199820166059069684596128491376185333182764e-8');
    T('-1.05885215e+2', '6.96134e+3', '-105.885215');
    T('-6.63850464900027698e-11', '1.47441847556286416976794431734798800248343e+1', '-6.63850464900027698e-11');
    T('5.329e+0', '-4.2052296626044402413438748554367560246832050927e+46', '5.329');
    T('-3e+0', '6.310795365619607762092711e+14', '-3');
    T('-1e+0', '-6.151436486161577e+1', '-1');
    T('1.27372286268e+5', '1.4369236059213560786734339762024606028559549e-11', '1.1838867423641287048289062782741685583483082e-11');
    T('-2.47796406858881525393148342132e-19', '-1.114448296870693752476671e+24', '-2.47796406858881525393148342132e-19');
    T('3.31716916602e-3', '2.18973397623066249876504033115990763189329335e-11', '3.5801106985221822189595541951629188768773145e-12');
    T('3.36130377710864393490577917996361199494e+23', '-6.01033888502758381063377894374191325727e+38', '3.36130377710864393490577917996361199494e+23');
    T('-4.05078537570850079118549718e+24', '5.77875486336186078309057e+19', '-51579137737238062500.3271');
    T('-3.882925224099795993538502419426e+9', '1.77e+2', '-114.099795993538502419426');
    T('-3.1151827562342815382088011269e-4', '-9.5939986106878750496332e+22', '-0.00031151827562342815382088011269');
    T('1.263515691650061656757086438088937011975691e-9', '-7.548241773275363671025372541e+26', '1.263515691650061656757086438088937011975691e-9');
    T('-2.54581764865280637563363587278172942730649726409174798929e-16', '9.70709912979e+3', '-2.54581764865280637563363587278172942730649726409174798929e-16');
    T('4.544262038438149962548431721262064539926203e+22', '-3e+0', '0.31721262064539926203');
    T('6.7686482995324e-8', '3.57628817229923120251439846315e+11', '6.7686482995324e-8');
    T('-2.5837243515207675215858826036e+0', '4e+0', '-2.5837243515207675215858826036');
    T('3.5866287777543048262613523108599769647097333e-12', '6e+0', '3.5866287777543048262613523108599769647097333e-12');
    T('-1.12950543165722419512831984028282909551894468294664944607538e+48', '-8.8994740827559322848961144561345767240206011017e+24', '-4.3060230186943786250552209277543855025500782967e+24');
    T('1.32629615572864315471240257652101515250879349726101e+50', '1.24518406684607715300780841979783985e+7', '11819939.0138645251983859235118410325');
    T('-1.790115489391445059426395198670071179664972568459e+32', '-1.6684469764e+8', '-13018319.8379664972568459');
    T('-4.043663364e+4', '-2.201805700480933156346652411e-3', '-0.000764247759663998270288369046');
    T('1e+0', '-1.21869963007789517796039072048232e+19', '1');
    T('2.569643022111077e+3', '7.5897425087682454375918533810051138006394242e+43', '2569.643022111077');
    T('5.462e+2', '1.185649353252424966708806431224964085816087803853753518e+25', '546.2');
    T('1.77779806e+1', '1.884041077778132016302158377e-11', '3.69280262144004372920946142e-12');
    T('-4.30600314463832449294350446141214505790227492e+37', '3.62303831544018299428603870984582744317996855543826e+50', '-4.30600314463832449294350446141214505790227492e+37');
    T('1.46820318075561560819e-20', '-9.2923470300743146049252849193885672e-19', '1.46820318075561560819e-20');
    T('2.62e-8', '-2.272918110884608589603164353380779123924726e+42', '2.62e-8');
    T('-4.946872029105116445758491681281820008627914126e+12', '3.553464565566610158e+4', '-18242.079207968012581281820008627914126');
    T('-5.444799946684106145173105e+19', '3.2264562027032003440966e-1', '-0.29741218915109159338806');
    T('-6.6641862567771859738211631116152852541e-10', '4.53837850928448871996774473572127726597085345e+2', '-6.6641862567771859738211631116152852541e-10');
    T('2.04412473664652568585117378133e+21', '7.17977970071262225892475320830525724040709899422645111e+7', '6850552.6641959495615784496161192519568752280008915477');
    T('1.90389879643445938760898252e+18', '-2.820723572209116115220857118861930149808002989789986560298e+16', '14014003054351590.41100825036250679962863799684070900460034');
    T('3.54399572690074523717477041687706132576531580993088737845e+56', '3.86305546858881436338415083054757481145199924812285238142249e-8', '9.0010818560321987858218342657711149479512082543264309237906e-9');
    T('-2.81021903922014238242334e+23', '-3.81351478552287812572563406e+26', '-2.81021903922014238242334e+23');
    T('-6.6613160898e-13', '-1.35501662654877262254698379956968e+8', '-6.6613160898e-13');
    T('-1.37322505522894140472667261498601533454460065766486158656811e+56', '-6.101994414072054045611858917329e+20', '-111378121206362165144.3203824528');
    T('-7.174927106677644467861669419e+23', '7.3781216744e-6', '-0.0000029266955552');
    T('-2.6550841471735130755928352857461281e-13', '2.29146598195364764153947e+4', '-2.6550841471735130755928352857461281e-13');
    T('-1.98282995527163119617853095482026820489347564940576571365074e+44', '-6.7343972311468478371503508710588269021e+22', '-1.8425585476108166553720676776558276153e+22');
    T('3.45510770293428430743226307247e-10', '-3.453355686854751488683981e-4', '3.45510770293428430743226307247e-10');
    T('3.0940169147998267e+16', '-5.1679827115186675000881679620188097860809e-4', '0.00045494105050079175531229543905152624215823');
    T('-5.683707359160590767482385181054893368911539362771215016167e-10', '8.86164094021739567981e+19', '-5.683707359160590767482385181054893368911539362771215016167e-10');
    T('-5.1599750984803110105e+16', '-3.5042033e+8', '-313986840.105');
    T('-6.648136108552158227395470978468104077135e+30', '-7.670622e+6', '-1963500.104077135');
    T('5.7863814022935592013463113844081501644834124668e+33', '2.927394204321791269473573349413773145813098792e+20', '144279721918792318844.9709640995481667887767448');
    T('1.846283862301720586500752e+20', '-2.76680920710526658074e+14', '37882799751297.269222');
    T('-4.074907e+6', '1.2292e-10', '-1.156e-11');
    T('-2.4670327357021349034013736e+26', '-2.247694648202153e+3', '-1262.063905639966');
    T('4.5429277175861978297034645864160147622314348499084882862362e-18', '2.7386e-2', '4.5429277175861978297034645864160147622314348499084882862362e-18');
    T('2.157162452863075302863915e+18', '-3.60299993558464831757535049083884559e+35', '2157162452863075302.863915');
    T('7.7382289705506563990171491235511002471989281027800113e+22', '2.48970493035763788684e-5', '0.000011085865185482489695400113');
    T('-1.9064913834485914061878309425875120670837105e+5', '-3e+0', '-2.13834485914061878309425875120670837105');
    T('-5.48175104358179142491638230233e+25', '-1.52434523822871140847e-11', '-8.8309288545189098888e-12');
    T('1.07984359784457855e+6', '2.92533631912192887348822954567386e+32', '1079843.59784457855');
    T('-5.343344296409307514661858172266262866671109159598323e+9', '2.3273061846552018803169584402231121660442419923712e+8', '-223270690.167863377964549603775416101373776776381683');

    log('\n ' + passed + ' of ' + total + ' tests passed in ' + (+new Date() - start) + ' ms \n');
    return [passed, total];;
})(this.BigNumber);
if (typeof module !== 'undefined' && module.exports) module.exports = count;