#include "ivgraphicsview.h"

IvGraphicsView::IvGraphicsView(QGraphicsScene *scene,
                               QWidget *parent) : QGraphicsView(parent)
{
    this->setParent(parent);
    this->setScene(scene);

    this->setDragMode(QGraphicsView::ScrollHandDrag);
    this->setTransformationAnchor(QGraphicsView::AnchorUnderMouse);
    this->setResizeAnchor(QGraphicsView::AnchorUnderMouse);

    qDebug() << "IvGraphicsView created";
}

IvGraphicsView::~IvGraphicsView()
{
    qDebug() << "IvGraphicsView destroyed";
}


//////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// PROTECTED ////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


void IvGraphicsView::wheelEvent(QWheelEvent *event)
{
    int angleDelta;
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
    angleDelta = event->angleDelta().y();
#else
    angleDelta = event->delta();
#endif
    if (angleDelta > 0)
    {
        emit zoomInRequested();
    }
    else
    {
        emit zoomOutRequested();
    }

    event->accept();
}
