/* You may find the license in the LICENSE file */

const EXPORTED_SYMBOLS = [
	'prealloc', 'test'
];

const Cc = Components.classes;
const Ci = Components.interfaces;
const Cr = Components.results;
const Cu = Components.utils;
const Exception = Components.Exception;

Cu.import('resource://dta/version.jsm');
if (Version.moz1) {
	Cu.import('resource://dta/manager/preallocator/nsithread.jsm');
}
else {
	Cu.import('resource://dta/manager/preallocator/cothreads.jsm');
}
//var p = {}; Components.utils.import("resource://dta/manager/preallocator.jsm", p); p.test()
function test() {
	let file = Cc["@mozilla.org/file/directory_service;1"]
		.getService(Ci.nsIProperties)
		.get("TmpD", Ci.nsIFile);
	file.append("dta_prealloc_test.tmp");
	prealloc(file, (1<<28), 416, function(result){
		Cu.reportError("Allocating " + (result ? "succeeded!" : "FAILED!"));
		if (result) {
			Cu.reportError("file size: " + file.fileSize + " expected: " + (1<<28) + " diff: " + (file.fileSize - (1<<28)));
		}
		try {
			file.remove(false);
		}
		catch (ex) {}
	});
}
