/* @(#)labstr.c	19.1 (ES0-DMD) 02/25/03 14:07:39 */
/*===========================================================================
  Copyright (C) 1995 European Southern Observatory (ESO)
 
  This program is free software; you can redistribute it and/or 
  modify it under the terms of the GNU General Public License as 
  published by the Free Software Foundation; either version 2 of 
  the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public 
  License along with this program; if not, write to the Free 
  Software Foundation, Inc., 675 Massachusetss Ave, Cambridge, 
  MA 02139, USA.
 
  Corresponding concerning ESO-MIDAS should be addressed as follows:
	Internet e-mail: midas@eso.org
	Postal address: European Southern Observatory
			Data Management Division 
			Karl-Schwarzschild-Strasse 2
			D 85748 Garching bei Muenchen 
			GERMANY
===========================================================================*/

/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
.COPYRIGHT   (c) 1993 European Southern Observatory
.IDENTifer   LABSTR
.AUTHOR      R.M. van Hees IPG-ESO Garching
.KEYWORDS    low level plot routine
.LANGUAGE    C
.PURPOSE     replace special characters by AGL characters
 in/output:  char *string

.COMMENTS    none
.ENVIRONment MIDAS
             #include <midas_def.h>      Prototypes for MIDAS interfaces

.VERSION     1.0     15-Jun-1993   FORTRAN --> ANSI-C    RvH
------------------------------------------------------------*/
/*
 * Define _POSIX_SOURCE to indicate
 * that this is a POSIX program
 */
#define _POSIX_SOURCE 1

/*
 * definition of the used functions
*/
#include <stdio.h>
#include <string.h>

#include <midas_def.h>

/*
 * here start the code of the function
 */
void LABSTR( string )
char * string;

{
char *pntr, *pntc;

char *bcksld = "\\!d",
     *bcksl1 = "\\_",
     *bckslu = "\\!u",
     *bcksl2 = "\\^",
     *strnul = "  ";

/*
 * if LABEL is empty EXIT
 */
if ( strlen( string ) == 0 ) return;

/*
 * substitude \d with \_
 */
while ( ( pntc = pntr = strstrs( string, bcksld )) != NULL ) 
      { (void) strcpy( pntr, bcksl1 );
        (void) strcat( string, pntc+3 );
     }
/*
 * substitude \u with \^
 */
while ( ( pntc = pntr = strstrs( string, bckslu )) != NULL )
      { (void) strcpy( pntr, bcksl2 );
        (void) strcat( string, pntc+3 );
     }
/*
 * remove dubble spaces
 */
while ( ( pntr = strstr( string, strnul )) != NULL )
      (void) strcat( strcpy( pntr+1, ""), pntr+2 );

/*
 * remove occurences of "( <no text> )"
 */
while ( ( pntr = strstrs( string, "(  " )) != NULL )
      (void) strcat( strcpy( pntr+1, ""), pntr+2 );

while ( ( pntr = strstrs( string, "  )" )) != NULL )
      (void) strcat( strcpy( pntr, ""), pntr+1 );

while ( ( pntr = strstrs( string, "()" )) != NULL )    
      (void) strcat( strcpy( pntr, ""), pntr+2 );

/*
 * remove leading " " 
 */
if (( pntr = strstr( string, " ")) == &string[0])
   (void) strcpy( pntr, pntr+1);
   
}
