/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggframeobjectcontrols.h"


#include "istring.h"
#include "iviewsubject.h"

#include "iggframeattachposition.h"
#include "iggframeposition.h"
#include "iggframepushcontrols.h"
#include "iggwidgetkeyslider.h"
#include "iggwidgetkeytrackball.h"
#include "iggwidgetotherbutton.h"


using namespace iParameter;


iggFrameObjectControls::iggFrameObjectControls(const iString &name, const iObjectKey& poskey, const iObjectKey& dirkey, const iObjectKey& sizkey, iggFrame *parent) : iggFrame(parent,2)
{
	iString ws;

	if(name.IsEmpty()) ws = "Position"; else ws = name+" position";
	mOP = new iggFramePosition(ws,poskey,this);

	if(name.IsEmpty()) ws = "Direction"; else ws = name+" direction";
	mOD = new iggFrame(ws,this);
	mOD->AddLine(new iggWidgetKeyTrackBall(dirkey,false,RenderMode::UseGlobal,mOD));
	this->AddLine(mOP,mOD);

	if(name.IsEmpty()) ws = "Size"; else ws = name+" size";
	mOS = new iggFrame(ws,this,2);
	iggWidgetKeySizeSlider *s = new iggWidgetKeySizeSlider(1.0e-4,5,"",sizkey,RenderMode::UseGlobal,mOS);
	mOS->AddLine(new iggWidgetAdjustSizeSliderButton(s,false,mOS),s);
	mPO = new iggFramePushControls(mOP,"Push "+name.Lower(),dirkey,poskey,this);
	this->AddLine(mOS,mPO);
	this->AddSpace(5);

	const iObjectKey *p = iObjectKeyRegistry::FindKey(iViewSubject::KeyAttachToMarker().RetypedKey(poskey.Type()));
	if(p != 0)
	{
		this->AddLine(new iggFrameAttachPosition(mOP,*p,name.Lower(),this,true));
	}

	this->SetColStretch(0,5);
}


void iggFrameObjectControls::EnablePosition(bool s)
{
	mOP->Enable(s);
}


void iggFrameObjectControls::EnableDirection(bool s)
{
	mOD->Enable(s);
	mPO->Enable(s);
}


void iggFrameObjectControls::EnableSize(bool s)
{
	mOS->Enable(s);
}

#endif
