/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "addressbook_page.h"
#include "administrator_page.h"
#include "distributionlist_page.h"
#include "maintainer_page.h"
#include "service_page.h"
#include "sharedfolder_page.h"
#include "user_page.h"

#include "pagemanager.h"

PageManager* PageManager::mSelf = 0;

PageManager::PageManager()
{
}

PageManager::~PageManager()
{
  qDeleteAll( mMap );
}

QStringList PageManager::pageNames() const
{
  static QStringList list;
  if ( list.isEmpty() ) {
    list.append( "user" );
    list.append( "addressbook" );
    list.append( "sharedfolder" );
    list.append( "distributionlist" );
    list.append( "administrator" );
    list.append( "maintainer" );
    list.append( "service" );
  }

  return list;
}

Page* PageManager::page( const QString &pageName )
{
  if ( !mMap.contains( pageName ) ) {
    Page *page = 0;
    if ( pageName == "addressbook" ) {
      page = new AddressBookPage;
    } else if ( pageName == "administrator" ) {
      page = new AdministratorPage;
    } else if ( pageName == "distributionlist" ) {
      page = new DistributionListPage;
    } else if ( pageName == "maintainer" ) {
      page = new MaintainerPage;
    } else if ( pageName == "service" ) {
      page = new ServicePage;
    } else if ( pageName == "sharedfolder" ) {
      page = new SharedFolderPage;
    } else if ( pageName == "user" ) {
      page = new UserPage;
    }

    if ( page ) {
      mMap.insert( pageName, page );
      return page;
    } else {
      return 0;
    }
  } else {
    return mMap[ pageName ];
  }
}

PageManager* PageManager::self()
{
  if ( !mSelf )
    mSelf = new PageManager();

  return mSelf;
}

