/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package api

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg6_fields "k8s.io/kubernetes/pkg/fields"
	pkg5_labels "k8s.io/kubernetes/pkg/labels"
	pkg7_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg1_types "k8s.io/kubernetes/pkg/types"
	pkg4_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_unversioned.Time
		var v2 pkg6_fields.Selector
		var v3 pkg5_labels.Selector
		var v4 pkg7_runtime.Object
		var v5 pkg1_types.UID
		var v6 pkg4_intstr.IntOrString
		var v7 time.Time
		_, _, _, _, _, _, _, _ = v0, v1, v2, v3, v4, v5, v6, v7
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [15]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			yyq2[12] = len(x.OwnerReferences) != 0
			yyq2[13] = len(x.Finalizers) != 0
			yyq2[14] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(15)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							h.encSliceOwnerReference(([]OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym51 := z.EncBinary()
					_ = yym51
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym52 := z.DecBinary()
	_ = yym52
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct53 := r.ContainerType()
		if yyct53 == codecSelferValueTypeMap1234 {
			yyl53 := r.ReadMapStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl53, d)
			}
		} else if yyct53 == codecSelferValueTypeArray1234 {
			yyl53 := r.ReadArrayStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl53, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys54Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys54Slc
	var yyhl54 bool = l >= 0
	for yyj54 := 0; ; yyj54++ {
		if yyhl54 {
			if yyj54 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys54Slc = r.DecodeBytes(yys54Slc, true, true)
		yys54 := string(yys54Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys54 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				x.GenerateName = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				x.SelfLink = string(r.DecodeString())
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				x.UID = pkg1_types.UID(r.DecodeString())
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				x.ResourceVersion = string(r.DecodeString())
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				x.Generation = int64(r.DecodeInt(64))
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_unversioned.Time{}
			} else {
				yyv62 := &x.CreationTimestamp
				yym63 := z.DecBinary()
				_ = yym63
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv62) {
				} else if yym63 {
					z.DecBinaryUnmarshal(yyv62)
				} else if !yym63 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv62)
				} else {
					z.DecFallback(yyv62, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_unversioned.Time)
				}
				yym65 := z.DecBinary()
				_ = yym65
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym65 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym65 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym67 := z.DecBinary()
				_ = yym67
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv68 := &x.Labels
				yym69 := z.DecBinary()
				_ = yym69
				if false {
				} else {
					z.F.DecMapStringStringX(yyv68, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv70 := &x.Annotations
				yym71 := z.DecBinary()
				_ = yym71
				if false {
				} else {
					z.F.DecMapStringStringX(yyv70, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv72 := &x.OwnerReferences
				yym73 := z.DecBinary()
				_ = yym73
				if false {
				} else {
					h.decSliceOwnerReference((*[]OwnerReference)(yyv72), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv74 := &x.Finalizers
				yym75 := z.DecBinary()
				_ = yym75
				if false {
				} else {
					z.F.DecSliceStringX(yyv74, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				x.ClusterName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys54)
		} // end switch yys54
	} // end for yyj54
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj77 int
	var yyb77 bool
	var yyhl77 bool = l >= 0
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		x.GenerateName = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		x.SelfLink = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		x.UID = pkg1_types.UID(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		x.ResourceVersion = string(r.DecodeString())
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		x.Generation = int64(r.DecodeInt(64))
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_unversioned.Time{}
	} else {
		yyv85 := &x.CreationTimestamp
		yym86 := z.DecBinary()
		_ = yym86
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv85) {
		} else if yym86 {
			z.DecBinaryUnmarshal(yyv85)
		} else if !yym86 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv85)
		} else {
			z.DecFallback(yyv85, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_unversioned.Time)
		}
		yym88 := z.DecBinary()
		_ = yym88
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym88 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym88 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym90 := z.DecBinary()
		_ = yym90
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv91 := &x.Labels
		yym92 := z.DecBinary()
		_ = yym92
		if false {
		} else {
			z.F.DecMapStringStringX(yyv91, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv93 := &x.Annotations
		yym94 := z.DecBinary()
		_ = yym94
		if false {
		} else {
			z.F.DecMapStringStringX(yyv93, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv95 := &x.OwnerReferences
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else {
			h.decSliceOwnerReference((*[]OwnerReference)(yyv95), d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv97 := &x.Finalizers
		yym98 := z.DecBinary()
		_ = yym98
		if false {
		} else {
			z.F.DecSliceStringX(yyv97, false, d)
		}
	}
	yyj77++
	if yyhl77 {
		yyb77 = yyj77 > l
	} else {
		yyb77 = r.CheckBreak()
	}
	if yyb77 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		x.ClusterName = string(r.DecodeString())
	}
	for {
		yyj77++
		if yyhl77 {
			yyb77 = yyj77 > l
		} else {
			yyb77 = r.CheckBreak()
		}
		if yyb77 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj77-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym100 := z.EncBinary()
		_ = yym100
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep101 := !z.EncBinary()
			yy2arr101 := z.EncBasicHandle().StructToArray
			var yyq101 [24]bool
			_, _, _ = yysep101, yyq101, yy2arr101
			const yyr101 bool = false
			yyq101[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq101[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq101[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq101[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq101[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq101[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq101[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq101[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq101[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq101[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq101[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq101[12] = x.VolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq101[13] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq101[14] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq101[15] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq101[16] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq101[17] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq101[18] = x.VolumeSource.FC != nil && x.FC != nil
			yyq101[19] = x.VolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq101[20] = x.VolumeSource.ConfigMap != nil && x.ConfigMap != nil
			yyq101[21] = x.VolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq101[22] = x.VolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq101[23] = x.VolumeSource.PhotonPersistentDisk != nil && x.PhotonPersistentDisk != nil
			var yynn101 int
			if yyr101 || yy2arr101 {
				r.EncodeArrayStart(24)
			} else {
				yynn101 = 1
				for _, b := range yyq101 {
					if b {
						yynn101++
					}
				}
				r.EncodeMapStart(yynn101)
				yynn101 = 0
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym103 := z.EncBinary()
				_ = yym103
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym104 := z.EncBinary()
				_ = yym104
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn105 bool
			if x.VolumeSource.HostPath == nil {
				yyn105 = true
				goto LABEL105
			}
		LABEL105:
			if yyr101 || yy2arr101 {
				if yyn105 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn105 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn106 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn106 = true
				goto LABEL106
			}
		LABEL106:
			if yyr101 || yy2arr101 {
				if yyn106 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn106 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn107 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn107 = true
				goto LABEL107
			}
		LABEL107:
			if yyr101 || yy2arr101 {
				if yyn107 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn107 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn108 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn108 = true
				goto LABEL108
			}
		LABEL108:
			if yyr101 || yy2arr101 {
				if yyn108 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn108 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn109 bool
			if x.VolumeSource.GitRepo == nil {
				yyn109 = true
				goto LABEL109
			}
		LABEL109:
			if yyr101 || yy2arr101 {
				if yyn109 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn109 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn110 bool
			if x.VolumeSource.Secret == nil {
				yyn110 = true
				goto LABEL110
			}
		LABEL110:
			if yyr101 || yy2arr101 {
				if yyn110 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn110 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn111 bool
			if x.VolumeSource.NFS == nil {
				yyn111 = true
				goto LABEL111
			}
		LABEL111:
			if yyr101 || yy2arr101 {
				if yyn111 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn111 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn112 bool
			if x.VolumeSource.ISCSI == nil {
				yyn112 = true
				goto LABEL112
			}
		LABEL112:
			if yyr101 || yy2arr101 {
				if yyn112 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn112 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn113 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn113 = true
				goto LABEL113
			}
		LABEL113:
			if yyr101 || yy2arr101 {
				if yyn113 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn113 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn114 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn114 = true
				goto LABEL114
			}
		LABEL114:
			if yyr101 || yy2arr101 {
				if yyn114 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn114 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn115 bool
			if x.VolumeSource.RBD == nil {
				yyn115 = true
				goto LABEL115
			}
		LABEL115:
			if yyr101 || yy2arr101 {
				if yyn115 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn115 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn116 bool
			if x.VolumeSource.Quobyte == nil {
				yyn116 = true
				goto LABEL116
			}
		LABEL116:
			if yyr101 || yy2arr101 {
				if yyn116 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[12] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn116 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn117 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn117 = true
				goto LABEL117
			}
		LABEL117:
			if yyr101 || yy2arr101 {
				if yyn117 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[13] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn117 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn118 bool
			if x.VolumeSource.Cinder == nil {
				yyn118 = true
				goto LABEL118
			}
		LABEL118:
			if yyr101 || yy2arr101 {
				if yyn118 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[14] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn118 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn119 bool
			if x.VolumeSource.CephFS == nil {
				yyn119 = true
				goto LABEL119
			}
		LABEL119:
			if yyr101 || yy2arr101 {
				if yyn119 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[15] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn119 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn120 bool
			if x.VolumeSource.Flocker == nil {
				yyn120 = true
				goto LABEL120
			}
		LABEL120:
			if yyr101 || yy2arr101 {
				if yyn120 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[16] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn120 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn121 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn121 = true
				goto LABEL121
			}
		LABEL121:
			if yyr101 || yy2arr101 {
				if yyn121 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[17] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn121 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn122 bool
			if x.VolumeSource.FC == nil {
				yyn122 = true
				goto LABEL122
			}
		LABEL122:
			if yyr101 || yy2arr101 {
				if yyn122 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[18] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn122 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn123 bool
			if x.VolumeSource.AzureFile == nil {
				yyn123 = true
				goto LABEL123
			}
		LABEL123:
			if yyr101 || yy2arr101 {
				if yyn123 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[19] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn123 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn124 bool
			if x.VolumeSource.ConfigMap == nil {
				yyn124 = true
				goto LABEL124
			}
		LABEL124:
			if yyr101 || yy2arr101 {
				if yyn124 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[20] {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn124 {
						r.EncodeNil()
					} else {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn125 bool
			if x.VolumeSource.VsphereVolume == nil {
				yyn125 = true
				goto LABEL125
			}
		LABEL125:
			if yyr101 || yy2arr101 {
				if yyn125 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[21] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn125 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn126 bool
			if x.VolumeSource.AzureDisk == nil {
				yyn126 = true
				goto LABEL126
			}
		LABEL126:
			if yyr101 || yy2arr101 {
				if yyn126 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[22] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn126 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn127 bool
			if x.VolumeSource.PhotonPersistentDisk == nil {
				yyn127 = true
				goto LABEL127
			}
		LABEL127:
			if yyr101 || yy2arr101 {
				if yyn127 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq101[23] {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq101[23] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn127 {
						r.EncodeNil()
					} else {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr101 || yy2arr101 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym128 := z.DecBinary()
	_ = yym128
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct129 := r.ContainerType()
		if yyct129 == codecSelferValueTypeMap1234 {
			yyl129 := r.ReadMapStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl129, d)
			}
		} else if yyct129 == codecSelferValueTypeArray1234 {
			yyl129 := r.ReadArrayStart()
			if yyl129 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl129, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys130Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys130Slc
	var yyhl130 bool = l >= 0
	for yyj130 := 0; ; yyj130++ {
		if yyhl130 {
			if yyj130 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys130Slc = r.DecodeBytes(yys130Slc, true, true)
		yys130 := string(yys130Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys130 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.VolumeSource.Quobyte == nil {
				x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.VolumeSource.AzureFile == nil {
				x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if x.VolumeSource.ConfigMap == nil {
				x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.VolumeSource.VsphereVolume == nil {
				x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.VolumeSource.AzureDisk == nil {
				x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if x.VolumeSource.PhotonPersistentDisk == nil {
				x.VolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys130)
		} // end switch yys130
	} // end for yyj130
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj155 int
	var yyb155 bool
	var yyhl155 bool = l >= 0
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Quobyte == nil {
		x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureFile == nil {
		x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ConfigMap == nil {
		x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	if x.VolumeSource.VsphereVolume == nil {
		x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureDisk == nil {
		x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PhotonPersistentDisk == nil {
		x.VolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
	}
	yyj155++
	if yyhl155 {
		yyb155 = yyj155 > l
	} else {
		yyb155 = r.CheckBreak()
	}
	if yyb155 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	for {
		yyj155++
		if yyhl155 {
			yyb155 = yyj155 > l
		} else {
			yyb155 = r.CheckBreak()
		}
		if yyb155 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj155-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym180 := z.EncBinary()
		_ = yym180
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep181 := !z.EncBinary()
			yy2arr181 := z.EncBasicHandle().StructToArray
			var yyq181 [23]bool
			_, _, _ = yysep181, yyq181, yy2arr181
			const yyr181 bool = false
			yyq181[0] = x.HostPath != nil
			yyq181[1] = x.EmptyDir != nil
			yyq181[2] = x.GCEPersistentDisk != nil
			yyq181[3] = x.AWSElasticBlockStore != nil
			yyq181[4] = x.GitRepo != nil
			yyq181[5] = x.Secret != nil
			yyq181[6] = x.NFS != nil
			yyq181[7] = x.ISCSI != nil
			yyq181[8] = x.Glusterfs != nil
			yyq181[9] = x.PersistentVolumeClaim != nil
			yyq181[10] = x.RBD != nil
			yyq181[11] = x.Quobyte != nil
			yyq181[12] = x.FlexVolume != nil
			yyq181[13] = x.Cinder != nil
			yyq181[14] = x.CephFS != nil
			yyq181[15] = x.Flocker != nil
			yyq181[16] = x.DownwardAPI != nil
			yyq181[17] = x.FC != nil
			yyq181[18] = x.AzureFile != nil
			yyq181[19] = x.ConfigMap != nil
			yyq181[20] = x.VsphereVolume != nil
			yyq181[21] = x.AzureDisk != nil
			yyq181[22] = x.PhotonPersistentDisk != nil
			var yynn181 int
			if yyr181 || yy2arr181 {
				r.EncodeArrayStart(23)
			} else {
				yynn181 = 0
				for _, b := range yyq181 {
					if b {
						yynn181++
					}
				}
				r.EncodeMapStart(yynn181)
				yynn181 = 0
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[11] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[12] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[13] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[14] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[15] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[16] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[17] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[18] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[19] {
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[20] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[21] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq181[22] {
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq181[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr181 || yy2arr181 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym205 := z.DecBinary()
	_ = yym205
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct206 := r.ContainerType()
		if yyct206 == codecSelferValueTypeMap1234 {
			yyl206 := r.ReadMapStart()
			if yyl206 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl206, d)
			}
		} else if yyct206 == codecSelferValueTypeArray1234 {
			yyl206 := r.ReadArrayStart()
			if yyl206 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl206, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys207Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys207Slc
	var yyhl207 bool = l >= 0
	for yyj207 := 0; ; yyj207++ {
		if yyhl207 {
			if yyj207 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys207Slc = r.DecodeBytes(yys207Slc, true, true)
		yys207 := string(yys207Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys207 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys207)
		} // end switch yys207
	} // end for yyj207
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj231 int
	var yyb231 bool
	var yyhl231 bool = l >= 0
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj231++
	if yyhl231 {
		yyb231 = yyj231 > l
	} else {
		yyb231 = r.CheckBreak()
	}
	if yyb231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	for {
		yyj231++
		if yyhl231 {
			yyb231 = yyj231 > l
		} else {
			yyb231 = r.CheckBreak()
		}
		if yyb231 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj231-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym255 := z.EncBinary()
		_ = yym255
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep256 := !z.EncBinary()
			yy2arr256 := z.EncBasicHandle().StructToArray
			var yyq256 [17]bool
			_, _, _ = yysep256, yyq256, yy2arr256
			const yyr256 bool = false
			yyq256[0] = x.GCEPersistentDisk != nil
			yyq256[1] = x.AWSElasticBlockStore != nil
			yyq256[2] = x.HostPath != nil
			yyq256[3] = x.Glusterfs != nil
			yyq256[4] = x.NFS != nil
			yyq256[5] = x.RBD != nil
			yyq256[6] = x.Quobyte != nil
			yyq256[7] = x.ISCSI != nil
			yyq256[8] = x.FlexVolume != nil
			yyq256[9] = x.Cinder != nil
			yyq256[10] = x.CephFS != nil
			yyq256[11] = x.FC != nil
			yyq256[12] = x.Flocker != nil
			yyq256[13] = x.AzureFile != nil
			yyq256[14] = x.VsphereVolume != nil
			yyq256[15] = x.AzureDisk != nil
			yyq256[16] = x.PhotonPersistentDisk != nil
			var yynn256 int
			if yyr256 || yy2arr256 {
				r.EncodeArrayStart(17)
			} else {
				yynn256 = 0
				for _, b := range yyq256 {
					if b {
						yynn256++
					}
				}
				r.EncodeMapStart(yynn256)
				yynn256 = 0
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[6] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[8] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[9] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[10] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[11] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[12] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[13] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[14] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[15] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq256[16] {
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq256[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr256 || yy2arr256 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym274 := z.DecBinary()
	_ = yym274
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct275 := r.ContainerType()
		if yyct275 == codecSelferValueTypeMap1234 {
			yyl275 := r.ReadMapStart()
			if yyl275 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl275, d)
			}
		} else if yyct275 == codecSelferValueTypeArray1234 {
			yyl275 := r.ReadArrayStart()
			if yyl275 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl275, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys276Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys276Slc
	var yyhl276 bool = l >= 0
	for yyj276 := 0; ; yyj276++ {
		if yyhl276 {
			if yyj276 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys276Slc = r.DecodeBytes(yys276Slc, true, true)
		yys276 := string(yys276Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys276 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys276)
		} // end switch yys276
	} // end for yyj276
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj294 int
	var yyb294 bool
	var yyhl294 bool = l >= 0
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj294++
	if yyhl294 {
		yyb294 = yyj294 > l
	} else {
		yyb294 = r.CheckBreak()
	}
	if yyb294 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	for {
		yyj294++
		if yyhl294 {
			yyb294 = yyj294 > l
		} else {
			yyb294 = r.CheckBreak()
		}
		if yyb294 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj294-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym312 := z.EncBinary()
		_ = yym312
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep313 := !z.EncBinary()
			yy2arr313 := z.EncBasicHandle().StructToArray
			var yyq313 [2]bool
			_, _, _ = yysep313, yyq313, yy2arr313
			const yyr313 bool = false
			yyq313[1] = x.ReadOnly != false
			var yynn313 int
			if yyr313 || yy2arr313 {
				r.EncodeArrayStart(2)
			} else {
				yynn313 = 1
				for _, b := range yyq313 {
					if b {
						yynn313++
					}
				}
				r.EncodeMapStart(yynn313)
				yynn313 = 0
			}
			if yyr313 || yy2arr313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym315 := z.EncBinary()
				_ = yym315
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym316 := z.EncBinary()
				_ = yym316
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr313 || yy2arr313 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq313[1] {
					yym318 := z.EncBinary()
					_ = yym318
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq313[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym319 := z.EncBinary()
					_ = yym319
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr313 || yy2arr313 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym320 := z.DecBinary()
	_ = yym320
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct321 := r.ContainerType()
		if yyct321 == codecSelferValueTypeMap1234 {
			yyl321 := r.ReadMapStart()
			if yyl321 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl321, d)
			}
		} else if yyct321 == codecSelferValueTypeArray1234 {
			yyl321 := r.ReadArrayStart()
			if yyl321 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl321, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys322Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys322Slc
	var yyhl322 bool = l >= 0
	for yyj322 := 0; ; yyj322++ {
		if yyhl322 {
			if yyj322 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys322Slc = r.DecodeBytes(yys322Slc, true, true)
		yys322 := string(yys322Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys322 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				x.ClaimName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys322)
		} // end switch yys322
	} // end for yyj322
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj325 int
	var yyb325 bool
	var yyhl325 bool = l >= 0
	yyj325++
	if yyhl325 {
		yyb325 = yyj325 > l
	} else {
		yyb325 = r.CheckBreak()
	}
	if yyb325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		x.ClaimName = string(r.DecodeString())
	}
	yyj325++
	if yyhl325 {
		yyb325 = yyj325 > l
	} else {
		yyb325 = r.CheckBreak()
	}
	if yyb325 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj325++
		if yyhl325 {
			yyb325 = yyj325 > l
		} else {
			yyb325 = r.CheckBreak()
		}
		if yyb325 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj325-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym328 := z.EncBinary()
		_ = yym328
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep329 := !z.EncBinary()
			yy2arr329 := z.EncBasicHandle().StructToArray
			var yyq329 [5]bool
			_, _, _ = yysep329, yyq329, yy2arr329
			const yyr329 bool = false
			yyq329[0] = x.Kind != ""
			yyq329[1] = x.APIVersion != ""
			yyq329[2] = true
			yyq329[3] = true
			yyq329[4] = true
			var yynn329 int
			if yyr329 || yy2arr329 {
				r.EncodeArrayStart(5)
			} else {
				yynn329 = 0
				for _, b := range yyq329 {
					if b {
						yynn329++
					}
				}
				r.EncodeMapStart(yynn329)
				yynn329 = 0
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[0] {
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq329[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym332 := z.EncBinary()
					_ = yym332
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[1] {
					yym334 := z.EncBinary()
					_ = yym334
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq329[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym335 := z.EncBinary()
					_ = yym335
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[2] {
					yy337 := &x.ObjectMeta
					yy337.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy338 := &x.ObjectMeta
					yy338.CodecEncodeSelf(e)
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[3] {
					yy340 := &x.Spec
					yy340.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy341 := &x.Spec
					yy341.CodecEncodeSelf(e)
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq329[4] {
					yy343 := &x.Status
					yy343.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq329[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy344 := &x.Status
					yy344.CodecEncodeSelf(e)
				}
			}
			if yyr329 || yy2arr329 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym345 := z.DecBinary()
	_ = yym345
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct346 := r.ContainerType()
		if yyct346 == codecSelferValueTypeMap1234 {
			yyl346 := r.ReadMapStart()
			if yyl346 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl346, d)
			}
		} else if yyct346 == codecSelferValueTypeArray1234 {
			yyl346 := r.ReadArrayStart()
			if yyl346 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl346, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys347Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys347Slc
	var yyhl347 bool = l >= 0
	for yyj347 := 0; ; yyj347++ {
		if yyhl347 {
			if yyj347 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys347Slc = r.DecodeBytes(yys347Slc, true, true)
		yys347 := string(yys347Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys347 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv350 := &x.ObjectMeta
				yyv350.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv351 := &x.Spec
				yyv351.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv352 := &x.Status
				yyv352.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys347)
		} // end switch yys347
	} // end for yyj347
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj353 int
	var yyb353 bool
	var yyhl353 bool = l >= 0
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv356 := &x.ObjectMeta
		yyv356.CodecDecodeSelf(d)
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv357 := &x.Spec
		yyv357.CodecDecodeSelf(d)
	}
	yyj353++
	if yyhl353 {
		yyb353 = yyj353 > l
	} else {
		yyb353 = r.CheckBreak()
	}
	if yyb353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv358 := &x.Status
		yyv358.CodecDecodeSelf(d)
	}
	for {
		yyj353++
		if yyhl353 {
			yyb353 = yyj353 > l
		} else {
			yyb353 = r.CheckBreak()
		}
		if yyb353 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj353-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym359 := z.EncBinary()
		_ = yym359
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep360 := !z.EncBinary()
			yy2arr360 := z.EncBasicHandle().StructToArray
			var yyq360 [21]bool
			_, _, _ = yysep360, yyq360, yy2arr360
			const yyr360 bool = false
			yyq360[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq360[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq360[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq360[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq360[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq360[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq360[7] = x.PersistentVolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq360[8] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq360[9] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq360[10] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq360[11] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq360[12] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq360[13] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq360[14] = x.PersistentVolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq360[15] = x.PersistentVolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq360[16] = x.PersistentVolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq360[17] = x.PersistentVolumeSource.PhotonPersistentDisk != nil && x.PhotonPersistentDisk != nil
			yyq360[18] = len(x.AccessModes) != 0
			yyq360[19] = x.ClaimRef != nil
			yyq360[20] = x.PersistentVolumeReclaimPolicy != ""
			var yynn360 int
			if yyr360 || yy2arr360 {
				r.EncodeArrayStart(21)
			} else {
				yynn360 = 1
				for _, b := range yyq360 {
					if b {
						yynn360++
					}
				}
				r.EncodeMapStart(yynn360)
				yynn360 = 0
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Capacity == nil {
					r.EncodeNil()
				} else {
					x.Capacity.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("capacity"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Capacity == nil {
					r.EncodeNil()
				} else {
					x.Capacity.CodecEncodeSelf(e)
				}
			}
			var yyn362 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn362 = true
				goto LABEL362
			}
		LABEL362:
			if yyr360 || yy2arr360 {
				if yyn362 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn362 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn363 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn363 = true
				goto LABEL363
			}
		LABEL363:
			if yyr360 || yy2arr360 {
				if yyn363 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn363 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn364 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn364 = true
				goto LABEL364
			}
		LABEL364:
			if yyr360 || yy2arr360 {
				if yyn364 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn364 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn365 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn365 = true
				goto LABEL365
			}
		LABEL365:
			if yyr360 || yy2arr360 {
				if yyn365 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn365 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn366 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn366 = true
				goto LABEL366
			}
		LABEL366:
			if yyr360 || yy2arr360 {
				if yyn366 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn366 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn367 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn367 = true
				goto LABEL367
			}
		LABEL367:
			if yyr360 || yy2arr360 {
				if yyn367 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn367 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn368 bool
			if x.PersistentVolumeSource.Quobyte == nil {
				yyn368 = true
				goto LABEL368
			}
		LABEL368:
			if yyr360 || yy2arr360 {
				if yyn368 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[7] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn368 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn369 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn369 = true
				goto LABEL369
			}
		LABEL369:
			if yyr360 || yy2arr360 {
				if yyn369 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn369 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn370 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn370 = true
				goto LABEL370
			}
		LABEL370:
			if yyr360 || yy2arr360 {
				if yyn370 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[9] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn370 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn371 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn371 = true
				goto LABEL371
			}
		LABEL371:
			if yyr360 || yy2arr360 {
				if yyn371 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[10] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn371 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn372 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn372 = true
				goto LABEL372
			}
		LABEL372:
			if yyr360 || yy2arr360 {
				if yyn372 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[11] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn372 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn373 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn373 = true
				goto LABEL373
			}
		LABEL373:
			if yyr360 || yy2arr360 {
				if yyn373 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[12] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn373 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn374 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn374 = true
				goto LABEL374
			}
		LABEL374:
			if yyr360 || yy2arr360 {
				if yyn374 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[13] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn374 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn375 bool
			if x.PersistentVolumeSource.AzureFile == nil {
				yyn375 = true
				goto LABEL375
			}
		LABEL375:
			if yyr360 || yy2arr360 {
				if yyn375 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[14] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn375 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn376 bool
			if x.PersistentVolumeSource.VsphereVolume == nil {
				yyn376 = true
				goto LABEL376
			}
		LABEL376:
			if yyr360 || yy2arr360 {
				if yyn376 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[15] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn376 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn377 bool
			if x.PersistentVolumeSource.AzureDisk == nil {
				yyn377 = true
				goto LABEL377
			}
		LABEL377:
			if yyr360 || yy2arr360 {
				if yyn377 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[16] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn377 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn378 bool
			if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
				yyn378 = true
				goto LABEL378
			}
		LABEL378:
			if yyr360 || yy2arr360 {
				if yyn378 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq360[17] {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq360[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn378 {
						r.EncodeNil()
					} else {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[18] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym380 := z.EncBinary()
						_ = yym380
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq360[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym381 := z.EncBinary()
						_ = yym381
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[19] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq360[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq360[20] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq360[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr360 || yy2arr360 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym384 := z.DecBinary()
	_ = yym384
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct385 := r.ContainerType()
		if yyct385 == codecSelferValueTypeMap1234 {
			yyl385 := r.ReadMapStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl385, d)
			}
		} else if yyct385 == codecSelferValueTypeArray1234 {
			yyl385 := r.ReadArrayStart()
			if yyl385 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl385, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys386Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys386Slc
	var yyhl386 bool = l >= 0
	for yyj386 := 0; ; yyj386++ {
		if yyhl386 {
			if yyj386 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys386Slc = r.DecodeBytes(yys386Slc, true, true)
		yys386 := string(yys386Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys386 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv387 := &x.Capacity
				yyv387.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.PersistentVolumeSource.Quobyte == nil {
				x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.PersistentVolumeSource.AzureFile == nil {
				x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.PersistentVolumeSource.VsphereVolume == nil {
				x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.PersistentVolumeSource.AzureDisk == nil {
				x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
				x.PersistentVolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv405 := &x.AccessModes
				yym406 := z.DecBinary()
				_ = yym406
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv405), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys386)
		} // end switch yys386
	} // end for yyj386
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj409 int
	var yyb409 bool
	var yyhl409 bool = l >= 0
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv410 := &x.Capacity
		yyv410.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Quobyte == nil {
		x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureFile == nil {
		x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.VsphereVolume == nil {
		x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureDisk == nil {
		x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
		x.PersistentVolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv428 := &x.AccessModes
		yym429 := z.DecBinary()
		_ = yym429
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv428), d)
		}
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj409++
	if yyhl409 {
		yyb409 = yyj409 > l
	} else {
		yyb409 = r.CheckBreak()
	}
	if yyb409 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		x.PersistentVolumeReclaimPolicy = PersistentVolumeReclaimPolicy(r.DecodeString())
	}
	for {
		yyj409++
		if yyhl409 {
			yyb409 = yyj409 > l
		} else {
			yyb409 = r.CheckBreak()
		}
		if yyb409 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj409-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym432 := z.EncBinary()
	_ = yym432
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym433 := z.DecBinary()
	_ = yym433
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym434 := z.EncBinary()
		_ = yym434
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep435 := !z.EncBinary()
			yy2arr435 := z.EncBasicHandle().StructToArray
			var yyq435 [3]bool
			_, _, _ = yysep435, yyq435, yy2arr435
			const yyr435 bool = false
			yyq435[0] = x.Phase != ""
			yyq435[1] = x.Message != ""
			yyq435[2] = x.Reason != ""
			var yynn435 int
			if yyr435 || yy2arr435 {
				r.EncodeArrayStart(3)
			} else {
				yynn435 = 0
				for _, b := range yyq435 {
					if b {
						yynn435++
					}
				}
				r.EncodeMapStart(yynn435)
				yynn435 = 0
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq435[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq435[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq435[1] {
					yym438 := z.EncBinary()
					_ = yym438
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq435[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym439 := z.EncBinary()
					_ = yym439
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq435[2] {
					yym441 := z.EncBinary()
					_ = yym441
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq435[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym442 := z.EncBinary()
					_ = yym442
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr435 || yy2arr435 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym443 := z.DecBinary()
	_ = yym443
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct444 := r.ContainerType()
		if yyct444 == codecSelferValueTypeMap1234 {
			yyl444 := r.ReadMapStart()
			if yyl444 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl444, d)
			}
		} else if yyct444 == codecSelferValueTypeArray1234 {
			yyl444 := r.ReadArrayStart()
			if yyl444 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl444, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys445Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys445Slc
	var yyhl445 bool = l >= 0
	for yyj445 := 0; ; yyj445++ {
		if yyhl445 {
			if yyj445 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys445Slc = r.DecodeBytes(yys445Slc, true, true)
		yys445 := string(yys445Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys445 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumePhase(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys445)
		} // end switch yys445
	} // end for yyj445
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj449 int
	var yyb449 bool
	var yyhl449 bool = l >= 0
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumePhase(r.DecodeString())
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	for {
		yyj449++
		if yyhl449 {
			yyb449 = yyj449 > l
		} else {
			yyb449 = r.CheckBreak()
		}
		if yyb449 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj449-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym453 := z.EncBinary()
		_ = yym453
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep454 := !z.EncBinary()
			yy2arr454 := z.EncBasicHandle().StructToArray
			var yyq454 [4]bool
			_, _, _ = yysep454, yyq454, yy2arr454
			const yyr454 bool = false
			yyq454[0] = x.Kind != ""
			yyq454[1] = x.APIVersion != ""
			yyq454[2] = true
			var yynn454 int
			if yyr454 || yy2arr454 {
				r.EncodeArrayStart(4)
			} else {
				yynn454 = 1
				for _, b := range yyq454 {
					if b {
						yynn454++
					}
				}
				r.EncodeMapStart(yynn454)
				yynn454 = 0
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq454[0] {
					yym456 := z.EncBinary()
					_ = yym456
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq454[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym457 := z.EncBinary()
					_ = yym457
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq454[1] {
					yym459 := z.EncBinary()
					_ = yym459
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq454[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym460 := z.EncBinary()
					_ = yym460
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq454[2] {
					yy462 := &x.ListMeta
					yym463 := z.EncBinary()
					_ = yym463
					if false {
					} else if z.HasExtensions() && z.EncExt(yy462) {
					} else {
						z.EncFallback(yy462)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq454[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy464 := &x.ListMeta
					yym465 := z.EncBinary()
					_ = yym465
					if false {
					} else if z.HasExtensions() && z.EncExt(yy464) {
					} else {
						z.EncFallback(yy464)
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym467 := z.EncBinary()
					_ = yym467
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym468 := z.EncBinary()
					_ = yym468
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr454 || yy2arr454 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym469 := z.DecBinary()
	_ = yym469
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct470 := r.ContainerType()
		if yyct470 == codecSelferValueTypeMap1234 {
			yyl470 := r.ReadMapStart()
			if yyl470 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl470, d)
			}
		} else if yyct470 == codecSelferValueTypeArray1234 {
			yyl470 := r.ReadArrayStart()
			if yyl470 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl470, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys471Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys471Slc
	var yyhl471 bool = l >= 0
	for yyj471 := 0; ; yyj471++ {
		if yyhl471 {
			if yyj471 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys471Slc = r.DecodeBytes(yys471Slc, true, true)
		yys471 := string(yys471Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys471 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv474 := &x.ListMeta
				yym475 := z.DecBinary()
				_ = yym475
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv474) {
				} else {
					z.DecFallback(yyv474, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv476 := &x.Items
				yym477 := z.DecBinary()
				_ = yym477
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv476), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys471)
		} // end switch yys471
	} // end for yyj471
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj478 int
	var yyb478 bool
	var yyhl478 bool = l >= 0
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv481 := &x.ListMeta
		yym482 := z.DecBinary()
		_ = yym482
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv481) {
		} else {
			z.DecFallback(yyv481, false)
		}
	}
	yyj478++
	if yyhl478 {
		yyb478 = yyj478 > l
	} else {
		yyb478 = r.CheckBreak()
	}
	if yyb478 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv483 := &x.Items
		yym484 := z.DecBinary()
		_ = yym484
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv483), d)
		}
	}
	for {
		yyj478++
		if yyhl478 {
			yyb478 = yyj478 > l
		} else {
			yyb478 = r.CheckBreak()
		}
		if yyb478 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj478-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym485 := z.EncBinary()
		_ = yym485
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep486 := !z.EncBinary()
			yy2arr486 := z.EncBasicHandle().StructToArray
			var yyq486 [5]bool
			_, _, _ = yysep486, yyq486, yy2arr486
			const yyr486 bool = false
			yyq486[0] = x.Kind != ""
			yyq486[1] = x.APIVersion != ""
			yyq486[2] = true
			yyq486[3] = true
			yyq486[4] = true
			var yynn486 int
			if yyr486 || yy2arr486 {
				r.EncodeArrayStart(5)
			} else {
				yynn486 = 0
				for _, b := range yyq486 {
					if b {
						yynn486++
					}
				}
				r.EncodeMapStart(yynn486)
				yynn486 = 0
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[0] {
					yym488 := z.EncBinary()
					_ = yym488
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq486[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym489 := z.EncBinary()
					_ = yym489
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[1] {
					yym491 := z.EncBinary()
					_ = yym491
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq486[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym492 := z.EncBinary()
					_ = yym492
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[2] {
					yy494 := &x.ObjectMeta
					yy494.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq486[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy495 := &x.ObjectMeta
					yy495.CodecEncodeSelf(e)
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[3] {
					yy497 := &x.Spec
					yy497.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq486[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy498 := &x.Spec
					yy498.CodecEncodeSelf(e)
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq486[4] {
					yy500 := &x.Status
					yy500.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq486[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy501 := &x.Status
					yy501.CodecEncodeSelf(e)
				}
			}
			if yyr486 || yy2arr486 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym502 := z.DecBinary()
	_ = yym502
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct503 := r.ContainerType()
		if yyct503 == codecSelferValueTypeMap1234 {
			yyl503 := r.ReadMapStart()
			if yyl503 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl503, d)
			}
		} else if yyct503 == codecSelferValueTypeArray1234 {
			yyl503 := r.ReadArrayStart()
			if yyl503 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl503, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys504Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys504Slc
	var yyhl504 bool = l >= 0
	for yyj504 := 0; ; yyj504++ {
		if yyhl504 {
			if yyj504 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys504Slc = r.DecodeBytes(yys504Slc, true, true)
		yys504 := string(yys504Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys504 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv507 := &x.ObjectMeta
				yyv507.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv508 := &x.Spec
				yyv508.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv509 := &x.Status
				yyv509.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys504)
		} // end switch yys504
	} // end for yyj504
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj510 int
	var yyb510 bool
	var yyhl510 bool = l >= 0
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv513 := &x.ObjectMeta
		yyv513.CodecDecodeSelf(d)
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv514 := &x.Spec
		yyv514.CodecDecodeSelf(d)
	}
	yyj510++
	if yyhl510 {
		yyb510 = yyj510 > l
	} else {
		yyb510 = r.CheckBreak()
	}
	if yyb510 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv515 := &x.Status
		yyv515.CodecDecodeSelf(d)
	}
	for {
		yyj510++
		if yyhl510 {
			yyb510 = yyj510 > l
		} else {
			yyb510 = r.CheckBreak()
		}
		if yyb510 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj510-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym516 := z.EncBinary()
		_ = yym516
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep517 := !z.EncBinary()
			yy2arr517 := z.EncBasicHandle().StructToArray
			var yyq517 [4]bool
			_, _, _ = yysep517, yyq517, yy2arr517
			const yyr517 bool = false
			yyq517[0] = x.Kind != ""
			yyq517[1] = x.APIVersion != ""
			yyq517[2] = true
			var yynn517 int
			if yyr517 || yy2arr517 {
				r.EncodeArrayStart(4)
			} else {
				yynn517 = 1
				for _, b := range yyq517 {
					if b {
						yynn517++
					}
				}
				r.EncodeMapStart(yynn517)
				yynn517 = 0
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq517[0] {
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq517[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym520 := z.EncBinary()
					_ = yym520
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq517[1] {
					yym522 := z.EncBinary()
					_ = yym522
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq517[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym523 := z.EncBinary()
					_ = yym523
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq517[2] {
					yy525 := &x.ListMeta
					yym526 := z.EncBinary()
					_ = yym526
					if false {
					} else if z.HasExtensions() && z.EncExt(yy525) {
					} else {
						z.EncFallback(yy525)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq517[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy527 := &x.ListMeta
					yym528 := z.EncBinary()
					_ = yym528
					if false {
					} else if z.HasExtensions() && z.EncExt(yy527) {
					} else {
						z.EncFallback(yy527)
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym530 := z.EncBinary()
					_ = yym530
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym531 := z.EncBinary()
					_ = yym531
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr517 || yy2arr517 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym532 := z.DecBinary()
	_ = yym532
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct533 := r.ContainerType()
		if yyct533 == codecSelferValueTypeMap1234 {
			yyl533 := r.ReadMapStart()
			if yyl533 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl533, d)
			}
		} else if yyct533 == codecSelferValueTypeArray1234 {
			yyl533 := r.ReadArrayStart()
			if yyl533 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl533, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys534Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys534Slc
	var yyhl534 bool = l >= 0
	for yyj534 := 0; ; yyj534++ {
		if yyhl534 {
			if yyj534 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys534Slc = r.DecodeBytes(yys534Slc, true, true)
		yys534 := string(yys534Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys534 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv537 := &x.ListMeta
				yym538 := z.DecBinary()
				_ = yym538
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv537) {
				} else {
					z.DecFallback(yyv537, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv539 := &x.Items
				yym540 := z.DecBinary()
				_ = yym540
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv539), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys534)
		} // end switch yys534
	} // end for yyj534
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj541 int
	var yyb541 bool
	var yyhl541 bool = l >= 0
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv544 := &x.ListMeta
		yym545 := z.DecBinary()
		_ = yym545
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv544) {
		} else {
			z.DecFallback(yyv544, false)
		}
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv546 := &x.Items
		yym547 := z.DecBinary()
		_ = yym547
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv546), d)
		}
	}
	for {
		yyj541++
		if yyhl541 {
			yyb541 = yyj541 > l
		} else {
			yyb541 = r.CheckBreak()
		}
		if yyb541 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj541-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym548 := z.EncBinary()
		_ = yym548
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep549 := !z.EncBinary()
			yy2arr549 := z.EncBasicHandle().StructToArray
			var yyq549 [4]bool
			_, _, _ = yysep549, yyq549, yy2arr549
			const yyr549 bool = false
			yyq549[0] = len(x.AccessModes) != 0
			yyq549[1] = x.Selector != nil
			yyq549[2] = true
			yyq549[3] = x.VolumeName != ""
			var yynn549 int
			if yyr549 || yy2arr549 {
				r.EncodeArrayStart(4)
			} else {
				yynn549 = 0
				for _, b := range yyq549 {
					if b {
						yynn549++
					}
				}
				r.EncodeMapStart(yynn549)
				yynn549 = 0
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym551 := z.EncBinary()
						_ = yym551
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq549[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym552 := z.EncBinary()
						_ = yym552
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym554 := z.EncBinary()
						_ = yym554
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq549[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym555 := z.EncBinary()
						_ = yym555
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[2] {
					yy557 := &x.Resources
					yy557.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq549[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy558 := &x.Resources
					yy558.CodecEncodeSelf(e)
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[3] {
					yym560 := z.EncBinary()
					_ = yym560
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq549[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym561 := z.EncBinary()
					_ = yym561
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym562 := z.DecBinary()
	_ = yym562
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct563 := r.ContainerType()
		if yyct563 == codecSelferValueTypeMap1234 {
			yyl563 := r.ReadMapStart()
			if yyl563 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl563, d)
			}
		} else if yyct563 == codecSelferValueTypeArray1234 {
			yyl563 := r.ReadArrayStart()
			if yyl563 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl563, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys564Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys564Slc
	var yyhl564 bool = l >= 0
	for yyj564 := 0; ; yyj564++ {
		if yyhl564 {
			if yyj564 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys564Slc = r.DecodeBytes(yys564Slc, true, true)
		yys564 := string(yys564Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys564 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv565 := &x.AccessModes
				yym566 := z.DecBinary()
				_ = yym566
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv565), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg2_unversioned.LabelSelector)
				}
				yym568 := z.DecBinary()
				_ = yym568
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv569 := &x.Resources
				yyv569.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				x.VolumeName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys564)
		} // end switch yys564
	} // end for yyj564
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj571 int
	var yyb571 bool
	var yyhl571 bool = l >= 0
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv572 := &x.AccessModes
		yym573 := z.DecBinary()
		_ = yym573
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv572), d)
		}
	}
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg2_unversioned.LabelSelector)
		}
		yym575 := z.DecBinary()
		_ = yym575
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv576 := &x.Resources
		yyv576.CodecDecodeSelf(d)
	}
	yyj571++
	if yyhl571 {
		yyb571 = yyj571 > l
	} else {
		yyb571 = r.CheckBreak()
	}
	if yyb571 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		x.VolumeName = string(r.DecodeString())
	}
	for {
		yyj571++
		if yyhl571 {
			yyb571 = yyj571 > l
		} else {
			yyb571 = r.CheckBreak()
		}
		if yyb571 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj571-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym578 := z.EncBinary()
		_ = yym578
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep579 := !z.EncBinary()
			yy2arr579 := z.EncBasicHandle().StructToArray
			var yyq579 [3]bool
			_, _, _ = yysep579, yyq579, yy2arr579
			const yyr579 bool = false
			yyq579[0] = x.Phase != ""
			yyq579[1] = len(x.AccessModes) != 0
			yyq579[2] = len(x.Capacity) != 0
			var yynn579 int
			if yyr579 || yy2arr579 {
				r.EncodeArrayStart(3)
			} else {
				yynn579 = 0
				for _, b := range yyq579 {
					if b {
						yynn579++
					}
				}
				r.EncodeMapStart(yynn579)
				yynn579 = 0
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq579[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym582 := z.EncBinary()
						_ = yym582
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq579[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym583 := z.EncBinary()
						_ = yym583
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq579[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq579[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr579 || yy2arr579 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym585 := z.DecBinary()
	_ = yym585
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct586 := r.ContainerType()
		if yyct586 == codecSelferValueTypeMap1234 {
			yyl586 := r.ReadMapStart()
			if yyl586 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl586, d)
			}
		} else if yyct586 == codecSelferValueTypeArray1234 {
			yyl586 := r.ReadArrayStart()
			if yyl586 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl586, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys587Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys587Slc
	var yyhl587 bool = l >= 0
	for yyj587 := 0; ; yyj587++ {
		if yyhl587 {
			if yyj587 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys587Slc = r.DecodeBytes(yys587Slc, true, true)
		yys587 := string(yys587Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys587 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv589 := &x.AccessModes
				yym590 := z.DecBinary()
				_ = yym590
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv589), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv591 := &x.Capacity
				yyv591.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys587)
		} // end switch yys587
	} // end for yyj587
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj592 int
	var yyb592 bool
	var yyhl592 bool = l >= 0
	yyj592++
	if yyhl592 {
		yyb592 = yyj592 > l
	} else {
		yyb592 = r.CheckBreak()
	}
	if yyb592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PersistentVolumeClaimPhase(r.DecodeString())
	}
	yyj592++
	if yyhl592 {
		yyb592 = yyj592 > l
	} else {
		yyb592 = r.CheckBreak()
	}
	if yyb592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv594 := &x.AccessModes
		yym595 := z.DecBinary()
		_ = yym595
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv594), d)
		}
	}
	yyj592++
	if yyhl592 {
		yyb592 = yyj592 > l
	} else {
		yyb592 = r.CheckBreak()
	}
	if yyb592 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv596 := &x.Capacity
		yyv596.CodecDecodeSelf(d)
	}
	for {
		yyj592++
		if yyhl592 {
			yyb592 = yyj592 > l
		} else {
			yyb592 = r.CheckBreak()
		}
		if yyb592 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj592-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym597 := z.EncBinary()
	_ = yym597
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym598 := z.DecBinary()
	_ = yym598
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym599 := z.EncBinary()
	_ = yym599
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym600 := z.DecBinary()
	_ = yym600
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym601 := z.EncBinary()
	_ = yym601
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym602 := z.DecBinary()
	_ = yym602
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym603 := z.EncBinary()
		_ = yym603
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep604 := !z.EncBinary()
			yy2arr604 := z.EncBasicHandle().StructToArray
			var yyq604 [1]bool
			_, _, _ = yysep604, yyq604, yy2arr604
			const yyr604 bool = false
			var yynn604 int
			if yyr604 || yy2arr604 {
				r.EncodeArrayStart(1)
			} else {
				yynn604 = 1
				for _, b := range yyq604 {
					if b {
						yynn604++
					}
				}
				r.EncodeMapStart(yynn604)
				yynn604 = 0
			}
			if yyr604 || yy2arr604 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym606 := z.EncBinary()
				_ = yym606
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym607 := z.EncBinary()
				_ = yym607
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr604 || yy2arr604 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym608 := z.DecBinary()
	_ = yym608
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct609 := r.ContainerType()
		if yyct609 == codecSelferValueTypeMap1234 {
			yyl609 := r.ReadMapStart()
			if yyl609 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl609, d)
			}
		} else if yyct609 == codecSelferValueTypeArray1234 {
			yyl609 := r.ReadArrayStart()
			if yyl609 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl609, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys610Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys610Slc
	var yyhl610 bool = l >= 0
	for yyj610 := 0; ; yyj610++ {
		if yyhl610 {
			if yyj610 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys610Slc = r.DecodeBytes(yys610Slc, true, true)
		yys610 := string(yys610Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys610 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys610)
		} // end switch yys610
	} // end for yyj610
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj612 int
	var yyb612 bool
	var yyhl612 bool = l >= 0
	yyj612++
	if yyhl612 {
		yyb612 = yyj612 > l
	} else {
		yyb612 = r.CheckBreak()
	}
	if yyb612 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	for {
		yyj612++
		if yyhl612 {
			yyb612 = yyj612 > l
		} else {
			yyb612 = r.CheckBreak()
		}
		if yyb612 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj612-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym614 := z.EncBinary()
		_ = yym614
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep615 := !z.EncBinary()
			yy2arr615 := z.EncBasicHandle().StructToArray
			var yyq615 [1]bool
			_, _, _ = yysep615, yyq615, yy2arr615
			const yyr615 bool = false
			yyq615[0] = x.Medium != ""
			var yynn615 int
			if yyr615 || yy2arr615 {
				r.EncodeArrayStart(1)
			} else {
				yynn615 = 0
				for _, b := range yyq615 {
					if b {
						yynn615++
					}
				}
				r.EncodeMapStart(yynn615)
				yynn615 = 0
			}
			if yyr615 || yy2arr615 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq615[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq615[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr615 || yy2arr615 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym617 := z.DecBinary()
	_ = yym617
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct618 := r.ContainerType()
		if yyct618 == codecSelferValueTypeMap1234 {
			yyl618 := r.ReadMapStart()
			if yyl618 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl618, d)
			}
		} else if yyct618 == codecSelferValueTypeArray1234 {
			yyl618 := r.ReadArrayStart()
			if yyl618 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl618, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys619Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys619Slc
	var yyhl619 bool = l >= 0
	for yyj619 := 0; ; yyj619++ {
		if yyhl619 {
			if yyj619 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys619Slc = r.DecodeBytes(yys619Slc, true, true)
		yys619 := string(yys619Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys619 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				x.Medium = StorageMedium(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys619)
		} // end switch yys619
	} // end for yyj619
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj621 int
	var yyb621 bool
	var yyhl621 bool = l >= 0
	yyj621++
	if yyhl621 {
		yyb621 = yyj621 > l
	} else {
		yyb621 = r.CheckBreak()
	}
	if yyb621 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		x.Medium = StorageMedium(r.DecodeString())
	}
	for {
		yyj621++
		if yyhl621 {
			yyb621 = yyj621 > l
		} else {
			yyb621 = r.CheckBreak()
		}
		if yyb621 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj621-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym623 := z.EncBinary()
	_ = yym623
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym624 := z.DecBinary()
	_ = yym624
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym625 := z.EncBinary()
	_ = yym625
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym626 := z.DecBinary()
	_ = yym626
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym627 := z.EncBinary()
		_ = yym627
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep628 := !z.EncBinary()
			yy2arr628 := z.EncBasicHandle().StructToArray
			var yyq628 [4]bool
			_, _, _ = yysep628, yyq628, yy2arr628
			const yyr628 bool = false
			yyq628[1] = x.FSType != ""
			yyq628[2] = x.Partition != 0
			yyq628[3] = x.ReadOnly != false
			var yynn628 int
			if yyr628 || yy2arr628 {
				r.EncodeArrayStart(4)
			} else {
				yynn628 = 1
				for _, b := range yyq628 {
					if b {
						yynn628++
					}
				}
				r.EncodeMapStart(yynn628)
				yynn628 = 0
			}
			if yyr628 || yy2arr628 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym630 := z.EncBinary()
				_ = yym630
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym631 := z.EncBinary()
				_ = yym631
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr628 || yy2arr628 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq628[1] {
					yym633 := z.EncBinary()
					_ = yym633
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq628[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym634 := z.EncBinary()
					_ = yym634
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr628 || yy2arr628 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq628[2] {
					yym636 := z.EncBinary()
					_ = yym636
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq628[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym637 := z.EncBinary()
					_ = yym637
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr628 || yy2arr628 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq628[3] {
					yym639 := z.EncBinary()
					_ = yym639
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq628[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym640 := z.EncBinary()
					_ = yym640
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr628 || yy2arr628 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym641 := z.DecBinary()
	_ = yym641
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct642 := r.ContainerType()
		if yyct642 == codecSelferValueTypeMap1234 {
			yyl642 := r.ReadMapStart()
			if yyl642 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl642, d)
			}
		} else if yyct642 == codecSelferValueTypeArray1234 {
			yyl642 := r.ReadArrayStart()
			if yyl642 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl642, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys643Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys643Slc
	var yyhl643 bool = l >= 0
	for yyj643 := 0; ; yyj643++ {
		if yyhl643 {
			if yyj643 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys643Slc = r.DecodeBytes(yys643Slc, true, true)
		yys643 := string(yys643Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys643 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				x.PDName = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys643)
		} // end switch yys643
	} // end for yyj643
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj648 int
	var yyb648 bool
	var yyhl648 bool = l >= 0
	yyj648++
	if yyhl648 {
		yyb648 = yyj648 > l
	} else {
		yyb648 = r.CheckBreak()
	}
	if yyb648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		x.PDName = string(r.DecodeString())
	}
	yyj648++
	if yyhl648 {
		yyb648 = yyj648 > l
	} else {
		yyb648 = r.CheckBreak()
	}
	if yyb648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj648++
	if yyhl648 {
		yyb648 = yyj648 > l
	} else {
		yyb648 = r.CheckBreak()
	}
	if yyb648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj648++
	if yyhl648 {
		yyb648 = yyj648 > l
	} else {
		yyb648 = r.CheckBreak()
	}
	if yyb648 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj648++
		if yyhl648 {
			yyb648 = yyj648 > l
		} else {
			yyb648 = r.CheckBreak()
		}
		if yyb648 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj648-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym653 := z.EncBinary()
		_ = yym653
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep654 := !z.EncBinary()
			yy2arr654 := z.EncBasicHandle().StructToArray
			var yyq654 [6]bool
			_, _, _ = yysep654, yyq654, yy2arr654
			const yyr654 bool = false
			yyq654[0] = x.TargetPortal != ""
			yyq654[1] = x.IQN != ""
			yyq654[2] = x.Lun != 0
			yyq654[3] = x.ISCSIInterface != ""
			yyq654[4] = x.FSType != ""
			yyq654[5] = x.ReadOnly != false
			var yynn654 int
			if yyr654 || yy2arr654 {
				r.EncodeArrayStart(6)
			} else {
				yynn654 = 0
				for _, b := range yyq654 {
					if b {
						yynn654++
					}
				}
				r.EncodeMapStart(yynn654)
				yynn654 = 0
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq654[0] {
					yym656 := z.EncBinary()
					_ = yym656
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq654[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym657 := z.EncBinary()
					_ = yym657
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
					}
				}
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq654[1] {
					yym659 := z.EncBinary()
					_ = yym659
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq654[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iqn"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym660 := z.EncBinary()
					_ = yym660
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
					}
				}
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq654[2] {
					yym662 := z.EncBinary()
					_ = yym662
					if false {
					} else {
						r.EncodeInt(int64(x.Lun))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq654[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lun"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym663 := z.EncBinary()
					_ = yym663
					if false {
					} else {
						r.EncodeInt(int64(x.Lun))
					}
				}
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq654[3] {
					yym665 := z.EncBinary()
					_ = yym665
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq654[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym666 := z.EncBinary()
					_ = yym666
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq654[4] {
					yym668 := z.EncBinary()
					_ = yym668
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq654[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym669 := z.EncBinary()
					_ = yym669
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq654[5] {
					yym671 := z.EncBinary()
					_ = yym671
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq654[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym672 := z.EncBinary()
					_ = yym672
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr654 || yy2arr654 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym673 := z.DecBinary()
	_ = yym673
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct674 := r.ContainerType()
		if yyct674 == codecSelferValueTypeMap1234 {
			yyl674 := r.ReadMapStart()
			if yyl674 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl674, d)
			}
		} else if yyct674 == codecSelferValueTypeArray1234 {
			yyl674 := r.ReadArrayStart()
			if yyl674 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl674, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys675Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys675Slc
	var yyhl675 bool = l >= 0
	for yyj675 := 0; ; yyj675++ {
		if yyhl675 {
			if yyj675 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys675Slc = r.DecodeBytes(yys675Slc, true, true)
		yys675 := string(yys675Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys675 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				x.TargetPortal = string(r.DecodeString())
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				x.IQN = string(r.DecodeString())
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				x.Lun = int32(r.DecodeInt(32))
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				x.ISCSIInterface = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys675)
		} // end switch yys675
	} // end for yyj675
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj682 int
	var yyb682 bool
	var yyhl682 bool = l >= 0
	yyj682++
	if yyhl682 {
		yyb682 = yyj682 > l
	} else {
		yyb682 = r.CheckBreak()
	}
	if yyb682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		x.TargetPortal = string(r.DecodeString())
	}
	yyj682++
	if yyhl682 {
		yyb682 = yyj682 > l
	} else {
		yyb682 = r.CheckBreak()
	}
	if yyb682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		x.IQN = string(r.DecodeString())
	}
	yyj682++
	if yyhl682 {
		yyb682 = yyj682 > l
	} else {
		yyb682 = r.CheckBreak()
	}
	if yyb682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		x.Lun = int32(r.DecodeInt(32))
	}
	yyj682++
	if yyhl682 {
		yyb682 = yyj682 > l
	} else {
		yyb682 = r.CheckBreak()
	}
	if yyb682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		x.ISCSIInterface = string(r.DecodeString())
	}
	yyj682++
	if yyhl682 {
		yyb682 = yyj682 > l
	} else {
		yyb682 = r.CheckBreak()
	}
	if yyb682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj682++
	if yyhl682 {
		yyb682 = yyj682 > l
	} else {
		yyb682 = r.CheckBreak()
	}
	if yyb682 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj682++
		if yyhl682 {
			yyb682 = yyj682 > l
		} else {
			yyb682 = r.CheckBreak()
		}
		if yyb682 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj682-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym689 := z.EncBinary()
		_ = yym689
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep690 := !z.EncBinary()
			yy2arr690 := z.EncBasicHandle().StructToArray
			var yyq690 [4]bool
			_, _, _ = yysep690, yyq690, yy2arr690
			const yyr690 bool = false
			yyq690[2] = x.FSType != ""
			yyq690[3] = x.ReadOnly != false
			var yynn690 int
			if yyr690 || yy2arr690 {
				r.EncodeArrayStart(4)
			} else {
				yynn690 = 2
				for _, b := range yyq690 {
					if b {
						yynn690++
					}
				}
				r.EncodeMapStart(yynn690)
				yynn690 = 0
			}
			if yyr690 || yy2arr690 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym692 := z.EncBinary()
					_ = yym692
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym693 := z.EncBinary()
					_ = yym693
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr690 || yy2arr690 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy695 := *x.Lun
					yym696 := z.EncBinary()
					_ = yym696
					if false {
					} else {
						r.EncodeInt(int64(yy695))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy697 := *x.Lun
					yym698 := z.EncBinary()
					_ = yym698
					if false {
					} else {
						r.EncodeInt(int64(yy697))
					}
				}
			}
			if yyr690 || yy2arr690 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq690[2] {
					yym700 := z.EncBinary()
					_ = yym700
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq690[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym701 := z.EncBinary()
					_ = yym701
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr690 || yy2arr690 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq690[3] {
					yym703 := z.EncBinary()
					_ = yym703
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq690[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym704 := z.EncBinary()
					_ = yym704
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr690 || yy2arr690 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym705 := z.DecBinary()
	_ = yym705
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct706 := r.ContainerType()
		if yyct706 == codecSelferValueTypeMap1234 {
			yyl706 := r.ReadMapStart()
			if yyl706 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl706, d)
			}
		} else if yyct706 == codecSelferValueTypeArray1234 {
			yyl706 := r.ReadArrayStart()
			if yyl706 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl706, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys707Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys707Slc
	var yyhl707 bool = l >= 0
	for yyj707 := 0; ; yyj707++ {
		if yyhl707 {
			if yyj707 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys707Slc = r.DecodeBytes(yys707Slc, true, true)
		yys707 := string(yys707Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys707 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv708 := &x.TargetWWNs
				yym709 := z.DecBinary()
				_ = yym709
				if false {
				} else {
					z.F.DecSliceStringX(yyv708, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int32)
				}
				yym711 := z.DecBinary()
				_ = yym711
				if false {
				} else {
					*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys707)
		} // end switch yys707
	} // end for yyj707
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj714 int
	var yyb714 bool
	var yyhl714 bool = l >= 0
	yyj714++
	if yyhl714 {
		yyb714 = yyj714 > l
	} else {
		yyb714 = r.CheckBreak()
	}
	if yyb714 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv715 := &x.TargetWWNs
		yym716 := z.DecBinary()
		_ = yym716
		if false {
		} else {
			z.F.DecSliceStringX(yyv715, false, d)
		}
	}
	yyj714++
	if yyhl714 {
		yyb714 = yyj714 > l
	} else {
		yyb714 = r.CheckBreak()
	}
	if yyb714 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int32)
		}
		yym718 := z.DecBinary()
		_ = yym718
		if false {
		} else {
			*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
		}
	}
	yyj714++
	if yyhl714 {
		yyb714 = yyj714 > l
	} else {
		yyb714 = r.CheckBreak()
	}
	if yyb714 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj714++
	if yyhl714 {
		yyb714 = yyj714 > l
	} else {
		yyb714 = r.CheckBreak()
	}
	if yyb714 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj714++
		if yyhl714 {
			yyb714 = yyj714 > l
		} else {
			yyb714 = r.CheckBreak()
		}
		if yyb714 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj714-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym721 := z.EncBinary()
		_ = yym721
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep722 := !z.EncBinary()
			yy2arr722 := z.EncBasicHandle().StructToArray
			var yyq722 [5]bool
			_, _, _ = yysep722, yyq722, yy2arr722
			const yyr722 bool = false
			yyq722[1] = x.FSType != ""
			yyq722[2] = x.SecretRef != nil
			yyq722[3] = x.ReadOnly != false
			yyq722[4] = len(x.Options) != 0
			var yynn722 int
			if yyr722 || yy2arr722 {
				r.EncodeArrayStart(5)
			} else {
				yynn722 = 1
				for _, b := range yyq722 {
					if b {
						yynn722++
					}
				}
				r.EncodeMapStart(yynn722)
				yynn722 = 0
			}
			if yyr722 || yy2arr722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym724 := z.EncBinary()
				_ = yym724
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym725 := z.EncBinary()
				_ = yym725
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr722 || yy2arr722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq722[1] {
					yym727 := z.EncBinary()
					_ = yym727
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq722[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym728 := z.EncBinary()
					_ = yym728
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr722 || yy2arr722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq722[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq722[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr722 || yy2arr722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq722[3] {
					yym731 := z.EncBinary()
					_ = yym731
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq722[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym732 := z.EncBinary()
					_ = yym732
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr722 || yy2arr722 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq722[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym734 := z.EncBinary()
						_ = yym734
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq722[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym735 := z.EncBinary()
						_ = yym735
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr722 || yy2arr722 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym736 := z.DecBinary()
	_ = yym736
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct737 := r.ContainerType()
		if yyct737 == codecSelferValueTypeMap1234 {
			yyl737 := r.ReadMapStart()
			if yyl737 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl737, d)
			}
		} else if yyct737 == codecSelferValueTypeArray1234 {
			yyl737 := r.ReadArrayStart()
			if yyl737 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl737, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys738Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys738Slc
	var yyhl738 bool = l >= 0
	for yyj738 := 0; ; yyj738++ {
		if yyhl738 {
			if yyj738 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys738Slc = r.DecodeBytes(yys738Slc, true, true)
		yys738 := string(yys738Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys738 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				x.Driver = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv743 := &x.Options
				yym744 := z.DecBinary()
				_ = yym744
				if false {
				} else {
					z.F.DecMapStringStringX(yyv743, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys738)
		} // end switch yys738
	} // end for yyj738
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj745 int
	var yyb745 bool
	var yyhl745 bool = l >= 0
	yyj745++
	if yyhl745 {
		yyb745 = yyj745 > l
	} else {
		yyb745 = r.CheckBreak()
	}
	if yyb745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		x.Driver = string(r.DecodeString())
	}
	yyj745++
	if yyhl745 {
		yyb745 = yyj745 > l
	} else {
		yyb745 = r.CheckBreak()
	}
	if yyb745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj745++
	if yyhl745 {
		yyb745 = yyj745 > l
	} else {
		yyb745 = r.CheckBreak()
	}
	if yyb745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj745++
	if yyhl745 {
		yyb745 = yyj745 > l
	} else {
		yyb745 = r.CheckBreak()
	}
	if yyb745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj745++
	if yyhl745 {
		yyb745 = yyj745 > l
	} else {
		yyb745 = r.CheckBreak()
	}
	if yyb745 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv750 := &x.Options
		yym751 := z.DecBinary()
		_ = yym751
		if false {
		} else {
			z.F.DecMapStringStringX(yyv750, false, d)
		}
	}
	for {
		yyj745++
		if yyhl745 {
			yyb745 = yyj745 > l
		} else {
			yyb745 = r.CheckBreak()
		}
		if yyb745 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj745-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym752 := z.EncBinary()
		_ = yym752
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep753 := !z.EncBinary()
			yy2arr753 := z.EncBasicHandle().StructToArray
			var yyq753 [4]bool
			_, _, _ = yysep753, yyq753, yy2arr753
			const yyr753 bool = false
			yyq753[1] = x.FSType != ""
			yyq753[2] = x.Partition != 0
			yyq753[3] = x.ReadOnly != false
			var yynn753 int
			if yyr753 || yy2arr753 {
				r.EncodeArrayStart(4)
			} else {
				yynn753 = 1
				for _, b := range yyq753 {
					if b {
						yynn753++
					}
				}
				r.EncodeMapStart(yynn753)
				yynn753 = 0
			}
			if yyr753 || yy2arr753 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym755 := z.EncBinary()
				_ = yym755
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym756 := z.EncBinary()
				_ = yym756
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr753 || yy2arr753 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq753[1] {
					yym758 := z.EncBinary()
					_ = yym758
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq753[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym759 := z.EncBinary()
					_ = yym759
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr753 || yy2arr753 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq753[2] {
					yym761 := z.EncBinary()
					_ = yym761
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq753[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym762 := z.EncBinary()
					_ = yym762
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr753 || yy2arr753 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq753[3] {
					yym764 := z.EncBinary()
					_ = yym764
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq753[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym765 := z.EncBinary()
					_ = yym765
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr753 || yy2arr753 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym766 := z.DecBinary()
	_ = yym766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct767 := r.ContainerType()
		if yyct767 == codecSelferValueTypeMap1234 {
			yyl767 := r.ReadMapStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl767, d)
			}
		} else if yyct767 == codecSelferValueTypeArray1234 {
			yyl767 := r.ReadArrayStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl767, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys768Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys768Slc
	var yyhl768 bool = l >= 0
	for yyj768 := 0; ; yyj768++ {
		if yyhl768 {
			if yyj768 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys768Slc = r.DecodeBytes(yys768Slc, true, true)
		yys768 := string(yys768Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys768 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				x.Partition = int32(r.DecodeInt(32))
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys768)
		} // end switch yys768
	} // end for yyj768
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj773 int
	var yyb773 bool
	var yyhl773 bool = l >= 0
	yyj773++
	if yyhl773 {
		yyb773 = yyj773 > l
	} else {
		yyb773 = r.CheckBreak()
	}
	if yyb773 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj773++
	if yyhl773 {
		yyb773 = yyj773 > l
	} else {
		yyb773 = r.CheckBreak()
	}
	if yyb773 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj773++
	if yyhl773 {
		yyb773 = yyj773 > l
	} else {
		yyb773 = r.CheckBreak()
	}
	if yyb773 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		x.Partition = int32(r.DecodeInt(32))
	}
	yyj773++
	if yyhl773 {
		yyb773 = yyj773 > l
	} else {
		yyb773 = r.CheckBreak()
	}
	if yyb773 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj773++
		if yyhl773 {
			yyb773 = yyj773 > l
		} else {
			yyb773 = r.CheckBreak()
		}
		if yyb773 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj773-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym778 := z.EncBinary()
		_ = yym778
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep779 := !z.EncBinary()
			yy2arr779 := z.EncBasicHandle().StructToArray
			var yyq779 [3]bool
			_, _, _ = yysep779, yyq779, yy2arr779
			const yyr779 bool = false
			yyq779[1] = x.Revision != ""
			yyq779[2] = x.Directory != ""
			var yynn779 int
			if yyr779 || yy2arr779 {
				r.EncodeArrayStart(3)
			} else {
				yynn779 = 1
				for _, b := range yyq779 {
					if b {
						yynn779++
					}
				}
				r.EncodeMapStart(yynn779)
				yynn779 = 0
			}
			if yyr779 || yy2arr779 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym781 := z.EncBinary()
				_ = yym781
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym782 := z.EncBinary()
				_ = yym782
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr779 || yy2arr779 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq779[1] {
					yym784 := z.EncBinary()
					_ = yym784
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq779[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym785 := z.EncBinary()
					_ = yym785
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr779 || yy2arr779 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq779[2] {
					yym787 := z.EncBinary()
					_ = yym787
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq779[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym788 := z.EncBinary()
					_ = yym788
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr779 || yy2arr779 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym789 := z.DecBinary()
	_ = yym789
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct790 := r.ContainerType()
		if yyct790 == codecSelferValueTypeMap1234 {
			yyl790 := r.ReadMapStart()
			if yyl790 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl790, d)
			}
		} else if yyct790 == codecSelferValueTypeArray1234 {
			yyl790 := r.ReadArrayStart()
			if yyl790 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl790, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys791Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys791Slc
	var yyhl791 bool = l >= 0
	for yyj791 := 0; ; yyj791++ {
		if yyhl791 {
			if yyj791 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys791Slc = r.DecodeBytes(yys791Slc, true, true)
		yys791 := string(yys791Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys791 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				x.Repository = string(r.DecodeString())
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				x.Revision = string(r.DecodeString())
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				x.Directory = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys791)
		} // end switch yys791
	} // end for yyj791
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj795 int
	var yyb795 bool
	var yyhl795 bool = l >= 0
	yyj795++
	if yyhl795 {
		yyb795 = yyj795 > l
	} else {
		yyb795 = r.CheckBreak()
	}
	if yyb795 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		x.Repository = string(r.DecodeString())
	}
	yyj795++
	if yyhl795 {
		yyb795 = yyj795 > l
	} else {
		yyb795 = r.CheckBreak()
	}
	if yyb795 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		x.Revision = string(r.DecodeString())
	}
	yyj795++
	if yyhl795 {
		yyb795 = yyj795 > l
	} else {
		yyb795 = r.CheckBreak()
	}
	if yyb795 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		x.Directory = string(r.DecodeString())
	}
	for {
		yyj795++
		if yyhl795 {
			yyb795 = yyj795 > l
		} else {
			yyb795 = r.CheckBreak()
		}
		if yyb795 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj795-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym799 := z.EncBinary()
		_ = yym799
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep800 := !z.EncBinary()
			yy2arr800 := z.EncBasicHandle().StructToArray
			var yyq800 [3]bool
			_, _, _ = yysep800, yyq800, yy2arr800
			const yyr800 bool = false
			yyq800[0] = x.SecretName != ""
			yyq800[1] = len(x.Items) != 0
			yyq800[2] = x.DefaultMode != nil
			var yynn800 int
			if yyr800 || yy2arr800 {
				r.EncodeArrayStart(3)
			} else {
				yynn800 = 0
				for _, b := range yyq800 {
					if b {
						yynn800++
					}
				}
				r.EncodeMapStart(yynn800)
				yynn800 = 0
			}
			if yyr800 || yy2arr800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq800[0] {
					yym802 := z.EncBinary()
					_ = yym802
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq800[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym803 := z.EncBinary()
					_ = yym803
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr800 || yy2arr800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq800[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym805 := z.EncBinary()
						_ = yym805
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq800[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym806 := z.EncBinary()
						_ = yym806
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr800 || yy2arr800 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq800[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy808 := *x.DefaultMode
						yym809 := z.EncBinary()
						_ = yym809
						if false {
						} else {
							r.EncodeInt(int64(yy808))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq800[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy810 := *x.DefaultMode
						yym811 := z.EncBinary()
						_ = yym811
						if false {
						} else {
							r.EncodeInt(int64(yy810))
						}
					}
				}
			}
			if yyr800 || yy2arr800 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym812 := z.DecBinary()
	_ = yym812
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct813 := r.ContainerType()
		if yyct813 == codecSelferValueTypeMap1234 {
			yyl813 := r.ReadMapStart()
			if yyl813 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl813, d)
			}
		} else if yyct813 == codecSelferValueTypeArray1234 {
			yyl813 := r.ReadArrayStart()
			if yyl813 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl813, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys814Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys814Slc
	var yyhl814 bool = l >= 0
	for yyj814 := 0; ; yyj814++ {
		if yyhl814 {
			if yyj814 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys814Slc = r.DecodeBytes(yys814Slc, true, true)
		yys814 := string(yys814Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys814 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv816 := &x.Items
				yym817 := z.DecBinary()
				_ = yym817
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv816), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym819 := z.DecBinary()
				_ = yym819
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys814)
		} // end switch yys814
	} // end for yyj814
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj820 int
	var yyb820 bool
	var yyhl820 bool = l >= 0
	yyj820++
	if yyhl820 {
		yyb820 = yyj820 > l
	} else {
		yyb820 = r.CheckBreak()
	}
	if yyb820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj820++
	if yyhl820 {
		yyb820 = yyj820 > l
	} else {
		yyb820 = r.CheckBreak()
	}
	if yyb820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv822 := &x.Items
		yym823 := z.DecBinary()
		_ = yym823
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv822), d)
		}
	}
	yyj820++
	if yyhl820 {
		yyb820 = yyj820 > l
	} else {
		yyb820 = r.CheckBreak()
	}
	if yyb820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym825 := z.DecBinary()
		_ = yym825
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj820++
		if yyhl820 {
			yyb820 = yyj820 > l
		} else {
			yyb820 = r.CheckBreak()
		}
		if yyb820 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj820-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym826 := z.EncBinary()
		_ = yym826
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep827 := !z.EncBinary()
			yy2arr827 := z.EncBasicHandle().StructToArray
			var yyq827 [3]bool
			_, _, _ = yysep827, yyq827, yy2arr827
			const yyr827 bool = false
			yyq827[2] = x.ReadOnly != false
			var yynn827 int
			if yyr827 || yy2arr827 {
				r.EncodeArrayStart(3)
			} else {
				yynn827 = 2
				for _, b := range yyq827 {
					if b {
						yynn827++
					}
				}
				r.EncodeMapStart(yynn827)
				yynn827 = 0
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym829 := z.EncBinary()
				_ = yym829
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym830 := z.EncBinary()
				_ = yym830
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym832 := z.EncBinary()
				_ = yym832
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym833 := z.EncBinary()
				_ = yym833
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq827[2] {
					yym835 := z.EncBinary()
					_ = yym835
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq827[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym836 := z.EncBinary()
					_ = yym836
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr827 || yy2arr827 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym837 := z.DecBinary()
	_ = yym837
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct838 := r.ContainerType()
		if yyct838 == codecSelferValueTypeMap1234 {
			yyl838 := r.ReadMapStart()
			if yyl838 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl838, d)
			}
		} else if yyct838 == codecSelferValueTypeArray1234 {
			yyl838 := r.ReadArrayStart()
			if yyl838 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl838, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys839Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys839Slc
	var yyhl839 bool = l >= 0
	for yyj839 := 0; ; yyj839++ {
		if yyhl839 {
			if yyj839 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys839Slc = r.DecodeBytes(yys839Slc, true, true)
		yys839 := string(yys839Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys839 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				x.Server = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys839)
		} // end switch yys839
	} // end for yyj839
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj843 int
	var yyb843 bool
	var yyhl843 bool = l >= 0
	yyj843++
	if yyhl843 {
		yyb843 = yyj843 > l
	} else {
		yyb843 = r.CheckBreak()
	}
	if yyb843 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		x.Server = string(r.DecodeString())
	}
	yyj843++
	if yyhl843 {
		yyb843 = yyj843 > l
	} else {
		yyb843 = r.CheckBreak()
	}
	if yyb843 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj843++
	if yyhl843 {
		yyb843 = yyj843 > l
	} else {
		yyb843 = r.CheckBreak()
	}
	if yyb843 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj843++
		if yyhl843 {
			yyb843 = yyj843 > l
		} else {
			yyb843 = r.CheckBreak()
		}
		if yyb843 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj843-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *QuobyteVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym847 := z.EncBinary()
		_ = yym847
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep848 := !z.EncBinary()
			yy2arr848 := z.EncBasicHandle().StructToArray
			var yyq848 [5]bool
			_, _, _ = yysep848, yyq848, yy2arr848
			const yyr848 bool = false
			yyq848[2] = x.ReadOnly != false
			yyq848[3] = x.User != ""
			yyq848[4] = x.Group != ""
			var yynn848 int
			if yyr848 || yy2arr848 {
				r.EncodeArrayStart(5)
			} else {
				yynn848 = 2
				for _, b := range yyq848 {
					if b {
						yynn848++
					}
				}
				r.EncodeMapStart(yynn848)
				yynn848 = 0
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym850 := z.EncBinary()
				_ = yym850
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym851 := z.EncBinary()
				_ = yym851
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym853 := z.EncBinary()
				_ = yym853
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volume"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym854 := z.EncBinary()
				_ = yym854
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq848[2] {
					yym856 := z.EncBinary()
					_ = yym856
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq848[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym857 := z.EncBinary()
					_ = yym857
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq848[3] {
					yym859 := z.EncBinary()
					_ = yym859
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq848[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym860 := z.EncBinary()
					_ = yym860
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq848[4] {
					yym862 := z.EncBinary()
					_ = yym862
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq848[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym863 := z.EncBinary()
					_ = yym863
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				}
			}
			if yyr848 || yy2arr848 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *QuobyteVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym864 := z.DecBinary()
	_ = yym864
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct865 := r.ContainerType()
		if yyct865 == codecSelferValueTypeMap1234 {
			yyl865 := r.ReadMapStart()
			if yyl865 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl865, d)
			}
		} else if yyct865 == codecSelferValueTypeArray1234 {
			yyl865 := r.ReadArrayStart()
			if yyl865 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl865, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys866Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys866Slc
	var yyhl866 bool = l >= 0
	for yyj866 := 0; ; yyj866++ {
		if yyhl866 {
			if yyj866 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys866Slc = r.DecodeBytes(yys866Slc, true, true)
		yys866 := string(yys866Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys866 {
		case "registry":
			if r.TryDecodeAsNil() {
				x.Registry = ""
			} else {
				x.Registry = string(r.DecodeString())
			}
		case "volume":
			if r.TryDecodeAsNil() {
				x.Volume = ""
			} else {
				x.Volume = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				x.Group = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys866)
		} // end switch yys866
	} // end for yyj866
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj872 int
	var yyb872 bool
	var yyhl872 bool = l >= 0
	yyj872++
	if yyhl872 {
		yyb872 = yyj872 > l
	} else {
		yyb872 = r.CheckBreak()
	}
	if yyb872 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Registry = ""
	} else {
		x.Registry = string(r.DecodeString())
	}
	yyj872++
	if yyhl872 {
		yyb872 = yyj872 > l
	} else {
		yyb872 = r.CheckBreak()
	}
	if yyb872 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volume = ""
	} else {
		x.Volume = string(r.DecodeString())
	}
	yyj872++
	if yyhl872 {
		yyb872 = yyj872 > l
	} else {
		yyb872 = r.CheckBreak()
	}
	if yyb872 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj872++
	if yyhl872 {
		yyb872 = yyj872 > l
	} else {
		yyb872 = r.CheckBreak()
	}
	if yyb872 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj872++
	if yyhl872 {
		yyb872 = yyj872 > l
	} else {
		yyb872 = r.CheckBreak()
	}
	if yyb872 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		x.Group = string(r.DecodeString())
	}
	for {
		yyj872++
		if yyhl872 {
			yyb872 = yyj872 > l
		} else {
			yyb872 = r.CheckBreak()
		}
		if yyb872 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj872-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym878 := z.EncBinary()
		_ = yym878
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep879 := !z.EncBinary()
			yy2arr879 := z.EncBasicHandle().StructToArray
			var yyq879 [3]bool
			_, _, _ = yysep879, yyq879, yy2arr879
			const yyr879 bool = false
			yyq879[2] = x.ReadOnly != false
			var yynn879 int
			if yyr879 || yy2arr879 {
				r.EncodeArrayStart(3)
			} else {
				yynn879 = 2
				for _, b := range yyq879 {
					if b {
						yynn879++
					}
				}
				r.EncodeMapStart(yynn879)
				yynn879 = 0
			}
			if yyr879 || yy2arr879 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym881 := z.EncBinary()
				_ = yym881
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym882 := z.EncBinary()
				_ = yym882
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr879 || yy2arr879 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym884 := z.EncBinary()
				_ = yym884
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym885 := z.EncBinary()
				_ = yym885
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr879 || yy2arr879 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq879[2] {
					yym887 := z.EncBinary()
					_ = yym887
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq879[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym888 := z.EncBinary()
					_ = yym888
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr879 || yy2arr879 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym889 := z.DecBinary()
	_ = yym889
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct890 := r.ContainerType()
		if yyct890 == codecSelferValueTypeMap1234 {
			yyl890 := r.ReadMapStart()
			if yyl890 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl890, d)
			}
		} else if yyct890 == codecSelferValueTypeArray1234 {
			yyl890 := r.ReadArrayStart()
			if yyl890 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl890, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys891Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys891Slc
	var yyhl891 bool = l >= 0
	for yyj891 := 0; ; yyj891++ {
		if yyhl891 {
			if yyj891 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys891Slc = r.DecodeBytes(yys891Slc, true, true)
		yys891 := string(yys891Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys891 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				x.EndpointsName = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys891)
		} // end switch yys891
	} // end for yyj891
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj895 int
	var yyb895 bool
	var yyhl895 bool = l >= 0
	yyj895++
	if yyhl895 {
		yyb895 = yyj895 > l
	} else {
		yyb895 = r.CheckBreak()
	}
	if yyb895 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		x.EndpointsName = string(r.DecodeString())
	}
	yyj895++
	if yyhl895 {
		yyb895 = yyj895 > l
	} else {
		yyb895 = r.CheckBreak()
	}
	if yyb895 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj895++
	if yyhl895 {
		yyb895 = yyj895 > l
	} else {
		yyb895 = r.CheckBreak()
	}
	if yyb895 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj895++
		if yyhl895 {
			yyb895 = yyj895 > l
		} else {
			yyb895 = r.CheckBreak()
		}
		if yyb895 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj895-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym899 := z.EncBinary()
		_ = yym899
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep900 := !z.EncBinary()
			yy2arr900 := z.EncBasicHandle().StructToArray
			var yyq900 [8]bool
			_, _, _ = yysep900, yyq900, yy2arr900
			const yyr900 bool = false
			yyq900[2] = x.FSType != ""
			yyq900[3] = x.RBDPool != ""
			yyq900[4] = x.RadosUser != ""
			yyq900[5] = x.Keyring != ""
			yyq900[6] = x.SecretRef != nil
			yyq900[7] = x.ReadOnly != false
			var yynn900 int
			if yyr900 || yy2arr900 {
				r.EncodeArrayStart(8)
			} else {
				yynn900 = 2
				for _, b := range yyq900 {
					if b {
						yynn900++
					}
				}
				r.EncodeMapStart(yynn900)
				yynn900 = 0
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym902 := z.EncBinary()
					_ = yym902
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym903 := z.EncBinary()
					_ = yym903
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym905 := z.EncBinary()
				_ = yym905
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym906 := z.EncBinary()
				_ = yym906
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq900[2] {
					yym908 := z.EncBinary()
					_ = yym908
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq900[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym909 := z.EncBinary()
					_ = yym909
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq900[3] {
					yym911 := z.EncBinary()
					_ = yym911
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq900[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("pool"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym912 := z.EncBinary()
					_ = yym912
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq900[4] {
					yym914 := z.EncBinary()
					_ = yym914
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq900[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym915 := z.EncBinary()
					_ = yym915
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq900[5] {
					yym917 := z.EncBinary()
					_ = yym917
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq900[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("keyring"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym918 := z.EncBinary()
					_ = yym918
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq900[6] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq900[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq900[7] {
					yym921 := z.EncBinary()
					_ = yym921
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq900[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym922 := z.EncBinary()
					_ = yym922
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr900 || yy2arr900 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym923 := z.DecBinary()
	_ = yym923
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct924 := r.ContainerType()
		if yyct924 == codecSelferValueTypeMap1234 {
			yyl924 := r.ReadMapStart()
			if yyl924 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl924, d)
			}
		} else if yyct924 == codecSelferValueTypeArray1234 {
			yyl924 := r.ReadArrayStart()
			if yyl924 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl924, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys925Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys925Slc
	var yyhl925 bool = l >= 0
	for yyj925 := 0; ; yyj925++ {
		if yyhl925 {
			if yyj925 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys925Slc = r.DecodeBytes(yys925Slc, true, true)
		yys925 := string(yys925Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys925 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv926 := &x.CephMonitors
				yym927 := z.DecBinary()
				_ = yym927
				if false {
				} else {
					z.F.DecSliceStringX(yyv926, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				x.RBDImage = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				x.RBDPool = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				x.RadosUser = string(r.DecodeString())
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				x.Keyring = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys925)
		} // end switch yys925
	} // end for yyj925
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj935 int
	var yyb935 bool
	var yyhl935 bool = l >= 0
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv936 := &x.CephMonitors
		yym937 := z.DecBinary()
		_ = yym937
		if false {
		} else {
			z.F.DecSliceStringX(yyv936, false, d)
		}
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		x.RBDImage = string(r.DecodeString())
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		x.RBDPool = string(r.DecodeString())
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		x.RadosUser = string(r.DecodeString())
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		x.Keyring = string(r.DecodeString())
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj935++
	if yyhl935 {
		yyb935 = yyj935 > l
	} else {
		yyb935 = r.CheckBreak()
	}
	if yyb935 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj935++
		if yyhl935 {
			yyb935 = yyj935 > l
		} else {
			yyb935 = r.CheckBreak()
		}
		if yyb935 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj935-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym945 := z.EncBinary()
		_ = yym945
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep946 := !z.EncBinary()
			yy2arr946 := z.EncBasicHandle().StructToArray
			var yyq946 [3]bool
			_, _, _ = yysep946, yyq946, yy2arr946
			const yyr946 bool = false
			yyq946[1] = x.FSType != ""
			yyq946[2] = x.ReadOnly != false
			var yynn946 int
			if yyr946 || yy2arr946 {
				r.EncodeArrayStart(3)
			} else {
				yynn946 = 1
				for _, b := range yyq946 {
					if b {
						yynn946++
					}
				}
				r.EncodeMapStart(yynn946)
				yynn946 = 0
			}
			if yyr946 || yy2arr946 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym948 := z.EncBinary()
				_ = yym948
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym949 := z.EncBinary()
				_ = yym949
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr946 || yy2arr946 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq946[1] {
					yym951 := z.EncBinary()
					_ = yym951
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq946[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym952 := z.EncBinary()
					_ = yym952
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr946 || yy2arr946 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq946[2] {
					yym954 := z.EncBinary()
					_ = yym954
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq946[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym955 := z.EncBinary()
					_ = yym955
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr946 || yy2arr946 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym956 := z.DecBinary()
	_ = yym956
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct957 := r.ContainerType()
		if yyct957 == codecSelferValueTypeMap1234 {
			yyl957 := r.ReadMapStart()
			if yyl957 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl957, d)
			}
		} else if yyct957 == codecSelferValueTypeArray1234 {
			yyl957 := r.ReadArrayStart()
			if yyl957 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl957, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys958Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys958Slc
	var yyhl958 bool = l >= 0
	for yyj958 := 0; ; yyj958++ {
		if yyhl958 {
			if yyj958 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys958Slc = r.DecodeBytes(yys958Slc, true, true)
		yys958 := string(yys958Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys958 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				x.VolumeID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys958)
		} // end switch yys958
	} // end for yyj958
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj962 int
	var yyb962 bool
	var yyhl962 bool = l >= 0
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		x.VolumeID = string(r.DecodeString())
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	yyj962++
	if yyhl962 {
		yyb962 = yyj962 > l
	} else {
		yyb962 = r.CheckBreak()
	}
	if yyb962 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj962++
		if yyhl962 {
			yyb962 = yyj962 > l
		} else {
			yyb962 = r.CheckBreak()
		}
		if yyb962 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj962-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym966 := z.EncBinary()
		_ = yym966
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep967 := !z.EncBinary()
			yy2arr967 := z.EncBasicHandle().StructToArray
			var yyq967 [6]bool
			_, _, _ = yysep967, yyq967, yy2arr967
			const yyr967 bool = false
			yyq967[1] = x.Path != ""
			yyq967[2] = x.User != ""
			yyq967[3] = x.SecretFile != ""
			yyq967[4] = x.SecretRef != nil
			yyq967[5] = x.ReadOnly != false
			var yynn967 int
			if yyr967 || yy2arr967 {
				r.EncodeArrayStart(6)
			} else {
				yynn967 = 1
				for _, b := range yyq967 {
					if b {
						yynn967++
					}
				}
				r.EncodeMapStart(yynn967)
				yynn967 = 0
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym969 := z.EncBinary()
					_ = yym969
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym970 := z.EncBinary()
					_ = yym970
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq967[1] {
					yym972 := z.EncBinary()
					_ = yym972
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq967[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym973 := z.EncBinary()
					_ = yym973
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq967[2] {
					yym975 := z.EncBinary()
					_ = yym975
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq967[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym976 := z.EncBinary()
					_ = yym976
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq967[3] {
					yym978 := z.EncBinary()
					_ = yym978
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq967[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym979 := z.EncBinary()
					_ = yym979
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq967[4] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq967[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq967[5] {
					yym982 := z.EncBinary()
					_ = yym982
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq967[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym983 := z.EncBinary()
					_ = yym983
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr967 || yy2arr967 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym984 := z.DecBinary()
	_ = yym984
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct985 := r.ContainerType()
		if yyct985 == codecSelferValueTypeMap1234 {
			yyl985 := r.ReadMapStart()
			if yyl985 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl985, d)
			}
		} else if yyct985 == codecSelferValueTypeArray1234 {
			yyl985 := r.ReadArrayStart()
			if yyl985 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl985, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys986Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys986Slc
	var yyhl986 bool = l >= 0
	for yyj986 := 0; ; yyj986++ {
		if yyhl986 {
			if yyj986 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys986Slc = r.DecodeBytes(yys986Slc, true, true)
		yys986 := string(yys986Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys986 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv987 := &x.Monitors
				yym988 := z.DecBinary()
				_ = yym988
				if false {
				} else {
					z.F.DecSliceStringX(yyv987, false, d)
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				x.User = string(r.DecodeString())
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				x.SecretFile = string(r.DecodeString())
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys986)
		} // end switch yys986
	} // end for yyj986
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj994 int
	var yyb994 bool
	var yyhl994 bool = l >= 0
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv995 := &x.Monitors
		yym996 := z.DecBinary()
		_ = yym996
		if false {
		} else {
			z.F.DecSliceStringX(yyv995, false, d)
		}
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		x.User = string(r.DecodeString())
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		x.SecretFile = string(r.DecodeString())
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj994++
	if yyhl994 {
		yyb994 = yyj994 > l
	} else {
		yyb994 = r.CheckBreak()
	}
	if yyb994 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj994++
		if yyhl994 {
			yyb994 = yyj994 > l
		} else {
			yyb994 = r.CheckBreak()
		}
		if yyb994 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj994-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1002 := z.EncBinary()
		_ = yym1002
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1003 := !z.EncBinary()
			yy2arr1003 := z.EncBasicHandle().StructToArray
			var yyq1003 [2]bool
			_, _, _ = yysep1003, yyq1003, yy2arr1003
			const yyr1003 bool = false
			yyq1003[0] = x.DatasetName != ""
			yyq1003[1] = x.DatasetUUID != ""
			var yynn1003 int
			if yyr1003 || yy2arr1003 {
				r.EncodeArrayStart(2)
			} else {
				yynn1003 = 0
				for _, b := range yyq1003 {
					if b {
						yynn1003++
					}
				}
				r.EncodeMapStart(yynn1003)
				yynn1003 = 0
			}
			if yyr1003 || yy2arr1003 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1003[0] {
					yym1005 := z.EncBinary()
					_ = yym1005
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1003[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1006 := z.EncBinary()
					_ = yym1006
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
					}
				}
			}
			if yyr1003 || yy2arr1003 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1003[1] {
					yym1008 := z.EncBinary()
					_ = yym1008
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetUUID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1003[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("datasetUUID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1009 := z.EncBinary()
					_ = yym1009
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetUUID))
					}
				}
			}
			if yyr1003 || yy2arr1003 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1010 := z.DecBinary()
	_ = yym1010
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1011 := r.ContainerType()
		if yyct1011 == codecSelferValueTypeMap1234 {
			yyl1011 := r.ReadMapStart()
			if yyl1011 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1011, d)
			}
		} else if yyct1011 == codecSelferValueTypeArray1234 {
			yyl1011 := r.ReadArrayStart()
			if yyl1011 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1011, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1012Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1012Slc
	var yyhl1012 bool = l >= 0
	for yyj1012 := 0; ; yyj1012++ {
		if yyhl1012 {
			if yyj1012 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1012Slc = r.DecodeBytes(yys1012Slc, true, true)
		yys1012 := string(yys1012Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1012 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				x.DatasetName = string(r.DecodeString())
			}
		case "datasetUUID":
			if r.TryDecodeAsNil() {
				x.DatasetUUID = ""
			} else {
				x.DatasetUUID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1012)
		} // end switch yys1012
	} // end for yyj1012
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1015 int
	var yyb1015 bool
	var yyhl1015 bool = l >= 0
	yyj1015++
	if yyhl1015 {
		yyb1015 = yyj1015 > l
	} else {
		yyb1015 = r.CheckBreak()
	}
	if yyb1015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		x.DatasetName = string(r.DecodeString())
	}
	yyj1015++
	if yyhl1015 {
		yyb1015 = yyj1015 > l
	} else {
		yyb1015 = r.CheckBreak()
	}
	if yyb1015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetUUID = ""
	} else {
		x.DatasetUUID = string(r.DecodeString())
	}
	for {
		yyj1015++
		if yyhl1015 {
			yyb1015 = yyj1015 > l
		} else {
			yyb1015 = r.CheckBreak()
		}
		if yyb1015 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1015-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DownwardAPIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1018 := z.EncBinary()
		_ = yym1018
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1019 := !z.EncBinary()
			yy2arr1019 := z.EncBasicHandle().StructToArray
			var yyq1019 [2]bool
			_, _, _ = yysep1019, yyq1019, yy2arr1019
			const yyr1019 bool = false
			yyq1019[0] = len(x.Items) != 0
			yyq1019[1] = x.DefaultMode != nil
			var yynn1019 int
			if yyr1019 || yy2arr1019 {
				r.EncodeArrayStart(2)
			} else {
				yynn1019 = 0
				for _, b := range yyq1019 {
					if b {
						yynn1019++
					}
				}
				r.EncodeMapStart(yynn1019)
				yynn1019 = 0
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1019[0] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1021 := z.EncBinary()
						_ = yym1021
						if false {
						} else {
							h.encSliceDownwardAPIVolumeFile(([]DownwardAPIVolumeFile)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1019[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1022 := z.EncBinary()
						_ = yym1022
						if false {
						} else {
							h.encSliceDownwardAPIVolumeFile(([]DownwardAPIVolumeFile)(x.Items), e)
						}
					}
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1019[1] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1024 := *x.DefaultMode
						yym1025 := z.EncBinary()
						_ = yym1025
						if false {
						} else {
							r.EncodeInt(int64(yy1024))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1019[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1026 := *x.DefaultMode
						yym1027 := z.EncBinary()
						_ = yym1027
						if false {
						} else {
							r.EncodeInt(int64(yy1026))
						}
					}
				}
			}
			if yyr1019 || yy2arr1019 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DownwardAPIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1028 := z.DecBinary()
	_ = yym1028
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1029 := r.ContainerType()
		if yyct1029 == codecSelferValueTypeMap1234 {
			yyl1029 := r.ReadMapStart()
			if yyl1029 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1029, d)
			}
		} else if yyct1029 == codecSelferValueTypeArray1234 {
			yyl1029 := r.ReadArrayStart()
			if yyl1029 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1029, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DownwardAPIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1030Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1030Slc
	var yyhl1030 bool = l >= 0
	for yyj1030 := 0; ; yyj1030++ {
		if yyhl1030 {
			if yyj1030 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1030Slc = r.DecodeBytes(yys1030Slc, true, true)
		yys1030 := string(yys1030Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1030 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1031 := &x.Items
				yym1032 := z.DecBinary()
				_ = yym1032
				if false {
				} else {
					h.decSliceDownwardAPIVolumeFile((*[]DownwardAPIVolumeFile)(yyv1031), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym1034 := z.DecBinary()
				_ = yym1034
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1030)
		} // end switch yys1030
	} // end for yyj1030
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DownwardAPIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1035 int
	var yyb1035 bool
	var yyhl1035 bool = l >= 0
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1036 := &x.Items
		yym1037 := z.DecBinary()
		_ = yym1037
		if false {
		} else {
			h.decSliceDownwardAPIVolumeFile((*[]DownwardAPIVolumeFile)(yyv1036), d)
		}
	}
	yyj1035++
	if yyhl1035 {
		yyb1035 = yyj1035 > l
	} else {
		yyb1035 = r.CheckBreak()
	}
	if yyb1035 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym1039 := z.DecBinary()
		_ = yym1039
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1035++
		if yyhl1035 {
			yyb1035 = yyj1035 > l
		} else {
			yyb1035 = r.CheckBreak()
		}
		if yyb1035 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1035-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DownwardAPIVolumeFile) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1040 := z.EncBinary()
		_ = yym1040
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1041 := !z.EncBinary()
			yy2arr1041 := z.EncBasicHandle().StructToArray
			var yyq1041 [4]bool
			_, _, _ = yysep1041, yyq1041, yy2arr1041
			const yyr1041 bool = false
			yyq1041[1] = x.FieldRef != nil
			yyq1041[2] = x.ResourceFieldRef != nil
			yyq1041[3] = x.Mode != nil
			var yynn1041 int
			if yyr1041 || yy2arr1041 {
				r.EncodeArrayStart(4)
			} else {
				yynn1041 = 1
				for _, b := range yyq1041 {
					if b {
						yynn1041++
					}
				}
				r.EncodeMapStart(yynn1041)
				yynn1041 = 0
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1043 := z.EncBinary()
				_ = yym1043
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1044 := z.EncBinary()
				_ = yym1044
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1041[1] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1041[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1041[2] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1041[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1041[3] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1048 := *x.Mode
						yym1049 := z.EncBinary()
						_ = yym1049
						if false {
						} else {
							r.EncodeInt(int64(yy1048))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1041[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1050 := *x.Mode
						yym1051 := z.EncBinary()
						_ = yym1051
						if false {
						} else {
							r.EncodeInt(int64(yy1050))
						}
					}
				}
			}
			if yyr1041 || yy2arr1041 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DownwardAPIVolumeFile) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1052 := z.DecBinary()
	_ = yym1052
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1053 := r.ContainerType()
		if yyct1053 == codecSelferValueTypeMap1234 {
			yyl1053 := r.ReadMapStart()
			if yyl1053 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1053, d)
			}
		} else if yyct1053 == codecSelferValueTypeArray1234 {
			yyl1053 := r.ReadArrayStart()
			if yyl1053 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1053, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DownwardAPIVolumeFile) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1054Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1054Slc
	var yyhl1054 bool = l >= 0
	for yyj1054 := 0; ; yyj1054++ {
		if yyhl1054 {
			if yyj1054 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1054Slc = r.DecodeBytes(yys1054Slc, true, true)
		yys1054 := string(yys1054Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1054 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym1059 := z.DecBinary()
				_ = yym1059
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1054)
		} // end switch yys1054
	} // end for yyj1054
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DownwardAPIVolumeFile) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1060 int
	var yyb1060 bool
	var yyhl1060 bool = l >= 0
	yyj1060++
	if yyhl1060 {
		yyb1060 = yyj1060 > l
	} else {
		yyb1060 = r.CheckBreak()
	}
	if yyb1060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1060++
	if yyhl1060 {
		yyb1060 = yyj1060 > l
	} else {
		yyb1060 = r.CheckBreak()
	}
	if yyb1060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj1060++
	if yyhl1060 {
		yyb1060 = yyj1060 > l
	} else {
		yyb1060 = r.CheckBreak()
	}
	if yyb1060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj1060++
	if yyhl1060 {
		yyb1060 = yyj1060 > l
	} else {
		yyb1060 = r.CheckBreak()
	}
	if yyb1060 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym1065 := z.DecBinary()
		_ = yym1065
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1060++
		if yyhl1060 {
			yyb1060 = yyj1060 > l
		} else {
			yyb1060 = r.CheckBreak()
		}
		if yyb1060 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1060-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AzureFileVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1066 := z.EncBinary()
		_ = yym1066
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1067 := !z.EncBinary()
			yy2arr1067 := z.EncBasicHandle().StructToArray
			var yyq1067 [3]bool
			_, _, _ = yysep1067, yyq1067, yy2arr1067
			const yyr1067 bool = false
			yyq1067[2] = x.ReadOnly != false
			var yynn1067 int
			if yyr1067 || yy2arr1067 {
				r.EncodeArrayStart(3)
			} else {
				yynn1067 = 2
				for _, b := range yyq1067 {
					if b {
						yynn1067++
					}
				}
				r.EncodeMapStart(yynn1067)
				yynn1067 = 0
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1069 := z.EncBinary()
				_ = yym1069
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1070 := z.EncBinary()
				_ = yym1070
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1072 := z.EncBinary()
				_ = yym1072
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("shareName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1073 := z.EncBinary()
				_ = yym1073
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1067[2] {
					yym1075 := z.EncBinary()
					_ = yym1075
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1067[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1076 := z.EncBinary()
					_ = yym1076
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1067 || yy2arr1067 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureFileVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1077 := z.DecBinary()
	_ = yym1077
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1078 := r.ContainerType()
		if yyct1078 == codecSelferValueTypeMap1234 {
			yyl1078 := r.ReadMapStart()
			if yyl1078 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1078, d)
			}
		} else if yyct1078 == codecSelferValueTypeArray1234 {
			yyl1078 := r.ReadArrayStart()
			if yyl1078 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1078, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1079Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1079Slc
	var yyhl1079 bool = l >= 0
	for yyj1079 := 0; ; yyj1079++ {
		if yyhl1079 {
			if yyj1079 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1079Slc = r.DecodeBytes(yys1079Slc, true, true)
		yys1079 := string(yys1079Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1079 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		case "shareName":
			if r.TryDecodeAsNil() {
				x.ShareName = ""
			} else {
				x.ShareName = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1079)
		} // end switch yys1079
	} // end for yyj1079
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1083 int
	var yyb1083 bool
	var yyhl1083 bool = l >= 0
	yyj1083++
	if yyhl1083 {
		yyb1083 = yyj1083 > l
	} else {
		yyb1083 = r.CheckBreak()
	}
	if yyb1083 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	yyj1083++
	if yyhl1083 {
		yyb1083 = yyj1083 > l
	} else {
		yyb1083 = r.CheckBreak()
	}
	if yyb1083 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ShareName = ""
	} else {
		x.ShareName = string(r.DecodeString())
	}
	yyj1083++
	if yyhl1083 {
		yyb1083 = yyj1083 > l
	} else {
		yyb1083 = r.CheckBreak()
	}
	if yyb1083 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	for {
		yyj1083++
		if yyhl1083 {
			yyb1083 = yyj1083 > l
		} else {
			yyb1083 = r.CheckBreak()
		}
		if yyb1083 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1083-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1087 := z.EncBinary()
		_ = yym1087
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1088 := !z.EncBinary()
			yy2arr1088 := z.EncBasicHandle().StructToArray
			var yyq1088 [2]bool
			_, _, _ = yysep1088, yyq1088, yy2arr1088
			const yyr1088 bool = false
			yyq1088[1] = x.FSType != ""
			var yynn1088 int
			if yyr1088 || yy2arr1088 {
				r.EncodeArrayStart(2)
			} else {
				yynn1088 = 1
				for _, b := range yyq1088 {
					if b {
						yynn1088++
					}
				}
				r.EncodeMapStart(yynn1088)
				yynn1088 = 0
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1090 := z.EncBinary()
				_ = yym1090
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1091 := z.EncBinary()
				_ = yym1091
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1088[1] {
					yym1093 := z.EncBinary()
					_ = yym1093
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1088[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1094 := z.EncBinary()
					_ = yym1094
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr1088 || yy2arr1088 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1095 := z.DecBinary()
	_ = yym1095
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1096 := r.ContainerType()
		if yyct1096 == codecSelferValueTypeMap1234 {
			yyl1096 := r.ReadMapStart()
			if yyl1096 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1096, d)
			}
		} else if yyct1096 == codecSelferValueTypeArray1234 {
			yyl1096 := r.ReadArrayStart()
			if yyl1096 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1096, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1097Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1097Slc
	var yyhl1097 bool = l >= 0
	for yyj1097 := 0; ; yyj1097++ {
		if yyhl1097 {
			if yyj1097 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1097Slc = r.DecodeBytes(yys1097Slc, true, true)
		yys1097 := string(yys1097Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1097 {
		case "volumePath":
			if r.TryDecodeAsNil() {
				x.VolumePath = ""
			} else {
				x.VolumePath = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1097)
		} // end switch yys1097
	} // end for yyj1097
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1100 int
	var yyb1100 bool
	var yyhl1100 bool = l >= 0
	yyj1100++
	if yyhl1100 {
		yyb1100 = yyj1100 > l
	} else {
		yyb1100 = r.CheckBreak()
	}
	if yyb1100 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePath = ""
	} else {
		x.VolumePath = string(r.DecodeString())
	}
	yyj1100++
	if yyhl1100 {
		yyb1100 = yyj1100 > l
	} else {
		yyb1100 = r.CheckBreak()
	}
	if yyb1100 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	for {
		yyj1100++
		if yyhl1100 {
			yyb1100 = yyj1100 > l
		} else {
			yyb1100 = r.CheckBreak()
		}
		if yyb1100 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1100-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PhotonPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1103 := z.EncBinary()
		_ = yym1103
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1104 := !z.EncBinary()
			yy2arr1104 := z.EncBasicHandle().StructToArray
			var yyq1104 [2]bool
			_, _, _ = yysep1104, yyq1104, yy2arr1104
			const yyr1104 bool = false
			yyq1104[1] = x.FSType != ""
			var yynn1104 int
			if yyr1104 || yy2arr1104 {
				r.EncodeArrayStart(2)
			} else {
				yynn1104 = 1
				for _, b := range yyq1104 {
					if b {
						yynn1104++
					}
				}
				r.EncodeMapStart(yynn1104)
				yynn1104 = 0
			}
			if yyr1104 || yy2arr1104 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1106 := z.EncBinary()
				_ = yym1106
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PdID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1107 := z.EncBinary()
				_ = yym1107
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PdID))
				}
			}
			if yyr1104 || yy2arr1104 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1104[1] {
					yym1109 := z.EncBinary()
					_ = yym1109
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1104[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1110 := z.EncBinary()
					_ = yym1110
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr1104 || yy2arr1104 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PhotonPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1111 := z.DecBinary()
	_ = yym1111
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1112 := r.ContainerType()
		if yyct1112 == codecSelferValueTypeMap1234 {
			yyl1112 := r.ReadMapStart()
			if yyl1112 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1112, d)
			}
		} else if yyct1112 == codecSelferValueTypeArray1234 {
			yyl1112 := r.ReadArrayStart()
			if yyl1112 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1112, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PhotonPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1113Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1113Slc
	var yyhl1113 bool = l >= 0
	for yyj1113 := 0; ; yyj1113++ {
		if yyhl1113 {
			if yyj1113 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1113Slc = r.DecodeBytes(yys1113Slc, true, true)
		yys1113 := string(yys1113Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1113 {
		case "pdID":
			if r.TryDecodeAsNil() {
				x.PdID = ""
			} else {
				x.PdID = string(r.DecodeString())
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				x.FSType = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1113)
		} // end switch yys1113
	} // end for yyj1113
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PhotonPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1116 int
	var yyb1116 bool
	var yyhl1116 bool = l >= 0
	yyj1116++
	if yyhl1116 {
		yyb1116 = yyj1116 > l
	} else {
		yyb1116 = r.CheckBreak()
	}
	if yyb1116 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PdID = ""
	} else {
		x.PdID = string(r.DecodeString())
	}
	yyj1116++
	if yyhl1116 {
		yyb1116 = yyj1116 > l
	} else {
		yyb1116 = r.CheckBreak()
	}
	if yyb1116 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		x.FSType = string(r.DecodeString())
	}
	for {
		yyj1116++
		if yyhl1116 {
			yyb1116 = yyj1116 > l
		} else {
			yyb1116 = r.CheckBreak()
		}
		if yyb1116 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1116-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x AzureDataDiskCachingMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1119 := z.EncBinary()
	_ = yym1119
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *AzureDataDiskCachingMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1120 := z.DecBinary()
	_ = yym1120
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AzureDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1121 := z.EncBinary()
		_ = yym1121
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1122 := !z.EncBinary()
			yy2arr1122 := z.EncBasicHandle().StructToArray
			var yyq1122 [5]bool
			_, _, _ = yysep1122, yyq1122, yy2arr1122
			const yyr1122 bool = false
			yyq1122[2] = x.CachingMode != nil
			yyq1122[3] = x.FSType != nil
			yyq1122[4] = x.ReadOnly != nil
			var yynn1122 int
			if yyr1122 || yy2arr1122 {
				r.EncodeArrayStart(5)
			} else {
				yynn1122 = 2
				for _, b := range yyq1122 {
					if b {
						yynn1122++
					}
				}
				r.EncodeMapStart(yynn1122)
				yynn1122 = 0
			}
			if yyr1122 || yy2arr1122 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1124 := z.EncBinary()
				_ = yym1124
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1125 := z.EncBinary()
				_ = yym1125
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			}
			if yyr1122 || yy2arr1122 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1127 := z.EncBinary()
				_ = yym1127
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskURI"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1128 := z.EncBinary()
				_ = yym1128
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			}
			if yyr1122 || yy2arr1122 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1122[2] {
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1130 := *x.CachingMode
						yy1130.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1122[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cachingMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy1131 := *x.CachingMode
						yy1131.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1122 || yy2arr1122 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1122[3] {
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1133 := *x.FSType
						yym1134 := z.EncBinary()
						_ = yym1134
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1133))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1122[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy1135 := *x.FSType
						yym1136 := z.EncBinary()
						_ = yym1136
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1135))
						}
					}
				}
			}
			if yyr1122 || yy2arr1122 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1122[4] {
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1138 := *x.ReadOnly
						yym1139 := z.EncBinary()
						_ = yym1139
						if false {
						} else {
							r.EncodeBool(bool(yy1138))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1122[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy1140 := *x.ReadOnly
						yym1141 := z.EncBinary()
						_ = yym1141
						if false {
						} else {
							r.EncodeBool(bool(yy1140))
						}
					}
				}
			}
			if yyr1122 || yy2arr1122 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1142 := z.DecBinary()
	_ = yym1142
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1143 := r.ContainerType()
		if yyct1143 == codecSelferValueTypeMap1234 {
			yyl1143 := r.ReadMapStart()
			if yyl1143 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1143, d)
			}
		} else if yyct1143 == codecSelferValueTypeArray1234 {
			yyl1143 := r.ReadArrayStart()
			if yyl1143 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1143, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1144Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1144Slc
	var yyhl1144 bool = l >= 0
	for yyj1144 := 0; ; yyj1144++ {
		if yyhl1144 {
			if yyj1144 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1144Slc = r.DecodeBytes(yys1144Slc, true, true)
		yys1144 := string(yys1144Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1144 {
		case "diskName":
			if r.TryDecodeAsNil() {
				x.DiskName = ""
			} else {
				x.DiskName = string(r.DecodeString())
			}
		case "diskURI":
			if r.TryDecodeAsNil() {
				x.DataDiskURI = ""
			} else {
				x.DataDiskURI = string(r.DecodeString())
			}
		case "cachingMode":
			if r.TryDecodeAsNil() {
				if x.CachingMode != nil {
					x.CachingMode = nil
				}
			} else {
				if x.CachingMode == nil {
					x.CachingMode = new(AzureDataDiskCachingMode)
				}
				x.CachingMode.CodecDecodeSelf(d)
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				if x.FSType != nil {
					x.FSType = nil
				}
			} else {
				if x.FSType == nil {
					x.FSType = new(string)
				}
				yym1149 := z.DecBinary()
				_ = yym1149
				if false {
				} else {
					*((*string)(x.FSType)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				if x.ReadOnly != nil {
					x.ReadOnly = nil
				}
			} else {
				if x.ReadOnly == nil {
					x.ReadOnly = new(bool)
				}
				yym1151 := z.DecBinary()
				_ = yym1151
				if false {
				} else {
					*((*bool)(x.ReadOnly)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1144)
		} // end switch yys1144
	} // end for yyj1144
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1152 int
	var yyb1152 bool
	var yyhl1152 bool = l >= 0
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DiskName = ""
	} else {
		x.DiskName = string(r.DecodeString())
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DataDiskURI = ""
	} else {
		x.DataDiskURI = string(r.DecodeString())
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CachingMode != nil {
			x.CachingMode = nil
		}
	} else {
		if x.CachingMode == nil {
			x.CachingMode = new(AzureDataDiskCachingMode)
		}
		x.CachingMode.CodecDecodeSelf(d)
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSType != nil {
			x.FSType = nil
		}
	} else {
		if x.FSType == nil {
			x.FSType = new(string)
		}
		yym1157 := z.DecBinary()
		_ = yym1157
		if false {
		} else {
			*((*string)(x.FSType)) = r.DecodeString()
		}
	}
	yyj1152++
	if yyhl1152 {
		yyb1152 = yyj1152 > l
	} else {
		yyb1152 = r.CheckBreak()
	}
	if yyb1152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadOnly != nil {
			x.ReadOnly = nil
		}
	} else {
		if x.ReadOnly == nil {
			x.ReadOnly = new(bool)
		}
		yym1159 := z.DecBinary()
		_ = yym1159
		if false {
		} else {
			*((*bool)(x.ReadOnly)) = r.DecodeBool()
		}
	}
	for {
		yyj1152++
		if yyhl1152 {
			yyb1152 = yyj1152 > l
		} else {
			yyb1152 = r.CheckBreak()
		}
		if yyb1152 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1152-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1160 := z.EncBinary()
		_ = yym1160
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1161 := !z.EncBinary()
			yy2arr1161 := z.EncBasicHandle().StructToArray
			var yyq1161 [3]bool
			_, _, _ = yysep1161, yyq1161, yy2arr1161
			const yyr1161 bool = false
			yyq1161[1] = len(x.Items) != 0
			yyq1161[2] = x.DefaultMode != nil
			var yynn1161 int
			if yyr1161 || yy2arr1161 {
				r.EncodeArrayStart(3)
			} else {
				yynn1161 = 1
				for _, b := range yyq1161 {
					if b {
						yynn1161++
					}
				}
				r.EncodeMapStart(yynn1161)
				yynn1161 = 0
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1163 := z.EncBinary()
				_ = yym1163
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1164 := z.EncBinary()
				_ = yym1164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1161[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1166 := z.EncBinary()
						_ = yym1166
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1161[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym1167 := z.EncBinary()
						_ = yym1167
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1161[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1169 := *x.DefaultMode
						yym1170 := z.EncBinary()
						_ = yym1170
						if false {
						} else {
							r.EncodeInt(int64(yy1169))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1161[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy1171 := *x.DefaultMode
						yym1172 := z.EncBinary()
						_ = yym1172
						if false {
						} else {
							r.EncodeInt(int64(yy1171))
						}
					}
				}
			}
			if yyr1161 || yy2arr1161 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1173 := z.DecBinary()
	_ = yym1173
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1174 := r.ContainerType()
		if yyct1174 == codecSelferValueTypeMap1234 {
			yyl1174 := r.ReadMapStart()
			if yyl1174 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1174, d)
			}
		} else if yyct1174 == codecSelferValueTypeArray1234 {
			yyl1174 := r.ReadArrayStart()
			if yyl1174 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1174, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1175Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1175Slc
	var yyhl1175 bool = l >= 0
	for yyj1175 := 0; ; yyj1175++ {
		if yyhl1175 {
			if yyj1175 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1175Slc = r.DecodeBytes(yys1175Slc, true, true)
		yys1175 := string(yys1175Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1175 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1177 := &x.Items
				yym1178 := z.DecBinary()
				_ = yym1178
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv1177), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym1180 := z.DecBinary()
				_ = yym1180
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1175)
		} // end switch yys1175
	} // end for yyj1175
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1181 int
	var yyb1181 bool
	var yyhl1181 bool = l >= 0
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1183 := &x.Items
		yym1184 := z.DecBinary()
		_ = yym1184
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv1183), d)
		}
	}
	yyj1181++
	if yyhl1181 {
		yyb1181 = yyj1181 > l
	} else {
		yyb1181 = r.CheckBreak()
	}
	if yyb1181 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym1186 := z.DecBinary()
		_ = yym1186
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1181++
		if yyhl1181 {
			yyb1181 = yyj1181 > l
		} else {
			yyb1181 = r.CheckBreak()
		}
		if yyb1181 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1181-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KeyToPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1187 := z.EncBinary()
		_ = yym1187
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1188 := !z.EncBinary()
			yy2arr1188 := z.EncBasicHandle().StructToArray
			var yyq1188 [3]bool
			_, _, _ = yysep1188, yyq1188, yy2arr1188
			const yyr1188 bool = false
			yyq1188[2] = x.Mode != nil
			var yynn1188 int
			if yyr1188 || yy2arr1188 {
				r.EncodeArrayStart(3)
			} else {
				yynn1188 = 2
				for _, b := range yyq1188 {
					if b {
						yynn1188++
					}
				}
				r.EncodeMapStart(yynn1188)
				yynn1188 = 0
			}
			if yyr1188 || yy2arr1188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1190 := z.EncBinary()
				_ = yym1190
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1191 := z.EncBinary()
				_ = yym1191
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1188 || yy2arr1188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1193 := z.EncBinary()
				_ = yym1193
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1194 := z.EncBinary()
				_ = yym1194
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr1188 || yy2arr1188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1188[2] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1196 := *x.Mode
						yym1197 := z.EncBinary()
						_ = yym1197
						if false {
						} else {
							r.EncodeInt(int64(yy1196))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1188[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy1198 := *x.Mode
						yym1199 := z.EncBinary()
						_ = yym1199
						if false {
						} else {
							r.EncodeInt(int64(yy1198))
						}
					}
				}
			}
			if yyr1188 || yy2arr1188 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KeyToPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1200 := z.DecBinary()
	_ = yym1200
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1201 := r.ContainerType()
		if yyct1201 == codecSelferValueTypeMap1234 {
			yyl1201 := r.ReadMapStart()
			if yyl1201 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1201, d)
			}
		} else if yyct1201 == codecSelferValueTypeArray1234 {
			yyl1201 := r.ReadArrayStart()
			if yyl1201 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1201, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KeyToPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1202Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1202Slc
	var yyhl1202 bool = l >= 0
	for yyj1202 := 0; ; yyj1202++ {
		if yyhl1202 {
			if yyj1202 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1202Slc = r.DecodeBytes(yys1202Slc, true, true)
		yys1202 := string(yys1202Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1202 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym1206 := z.DecBinary()
				_ = yym1206
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1202)
		} // end switch yys1202
	} // end for yyj1202
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KeyToPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1207 int
	var yyb1207 bool
	var yyhl1207 bool = l >= 0
	yyj1207++
	if yyhl1207 {
		yyb1207 = yyj1207 > l
	} else {
		yyb1207 = r.CheckBreak()
	}
	if yyb1207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1207++
	if yyhl1207 {
		yyb1207 = yyj1207 > l
	} else {
		yyb1207 = r.CheckBreak()
	}
	if yyb1207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1207++
	if yyhl1207 {
		yyb1207 = yyj1207 > l
	} else {
		yyb1207 = r.CheckBreak()
	}
	if yyb1207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym1211 := z.DecBinary()
		_ = yym1211
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj1207++
		if yyhl1207 {
			yyb1207 = yyj1207 > l
		} else {
			yyb1207 = r.CheckBreak()
		}
		if yyb1207 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1207-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1212 := z.EncBinary()
		_ = yym1212
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1213 := !z.EncBinary()
			yy2arr1213 := z.EncBasicHandle().StructToArray
			var yyq1213 [5]bool
			_, _, _ = yysep1213, yyq1213, yy2arr1213
			const yyr1213 bool = false
			yyq1213[0] = x.Name != ""
			yyq1213[1] = x.HostPort != 0
			yyq1213[3] = x.Protocol != ""
			yyq1213[4] = x.HostIP != ""
			var yynn1213 int
			if yyr1213 || yy2arr1213 {
				r.EncodeArrayStart(5)
			} else {
				yynn1213 = 1
				for _, b := range yyq1213 {
					if b {
						yynn1213++
					}
				}
				r.EncodeMapStart(yynn1213)
				yynn1213 = 0
			}
			if yyr1213 || yy2arr1213 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1213[0] {
					yym1215 := z.EncBinary()
					_ = yym1215
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1213[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1216 := z.EncBinary()
					_ = yym1216
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr1213 || yy2arr1213 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1213[1] {
					yym1218 := z.EncBinary()
					_ = yym1218
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1213[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1219 := z.EncBinary()
					_ = yym1219
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr1213 || yy2arr1213 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1221 := z.EncBinary()
				_ = yym1221
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1222 := z.EncBinary()
				_ = yym1222
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr1213 || yy2arr1213 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1213[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1213[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr1213 || yy2arr1213 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1213[4] {
					yym1225 := z.EncBinary()
					_ = yym1225
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1213[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1226 := z.EncBinary()
					_ = yym1226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr1213 || yy2arr1213 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1227 := z.DecBinary()
	_ = yym1227
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1228 := r.ContainerType()
		if yyct1228 == codecSelferValueTypeMap1234 {
			yyl1228 := r.ReadMapStart()
			if yyl1228 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1228, d)
			}
		} else if yyct1228 == codecSelferValueTypeArray1234 {
			yyl1228 := r.ReadArrayStart()
			if yyl1228 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1228, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1229Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1229Slc
	var yyhl1229 bool = l >= 0
	for yyj1229 := 0; ; yyj1229++ {
		if yyhl1229 {
			if yyj1229 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1229Slc = r.DecodeBytes(yys1229Slc, true, true)
		yys1229 := string(yys1229Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1229 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				x.HostPort = int32(r.DecodeInt(32))
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				x.ContainerPort = int32(r.DecodeInt(32))
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1229)
		} // end switch yys1229
	} // end for yyj1229
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1235 int
	var yyb1235 bool
	var yyhl1235 bool = l >= 0
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		x.HostPort = int32(r.DecodeInt(32))
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		x.ContainerPort = int32(r.DecodeInt(32))
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj1235++
	if yyhl1235 {
		yyb1235 = yyj1235 > l
	} else {
		yyb1235 = r.CheckBreak()
	}
	if yyb1235 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	for {
		yyj1235++
		if yyhl1235 {
			yyb1235 = yyj1235 > l
		} else {
			yyb1235 = r.CheckBreak()
		}
		if yyb1235 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1235-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1241 := z.EncBinary()
		_ = yym1241
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1242 := !z.EncBinary()
			yy2arr1242 := z.EncBasicHandle().StructToArray
			var yyq1242 [4]bool
			_, _, _ = yysep1242, yyq1242, yy2arr1242
			const yyr1242 bool = false
			yyq1242[1] = x.ReadOnly != false
			yyq1242[3] = x.SubPath != ""
			var yynn1242 int
			if yyr1242 || yy2arr1242 {
				r.EncodeArrayStart(4)
			} else {
				yynn1242 = 2
				for _, b := range yyq1242 {
					if b {
						yynn1242++
					}
				}
				r.EncodeMapStart(yynn1242)
				yynn1242 = 0
			}
			if yyr1242 || yy2arr1242 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1244 := z.EncBinary()
				_ = yym1244
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1245 := z.EncBinary()
				_ = yym1245
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1242 || yy2arr1242 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1242[1] {
					yym1247 := z.EncBinary()
					_ = yym1247
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1242[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1248 := z.EncBinary()
					_ = yym1248
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr1242 || yy2arr1242 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1250 := z.EncBinary()
				_ = yym1250
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1251 := z.EncBinary()
				_ = yym1251
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr1242 || yy2arr1242 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1242[3] {
					yym1253 := z.EncBinary()
					_ = yym1253
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1242[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1254 := z.EncBinary()
					_ = yym1254
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				}
			}
			if yyr1242 || yy2arr1242 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1255 := z.DecBinary()
	_ = yym1255
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1256 := r.ContainerType()
		if yyct1256 == codecSelferValueTypeMap1234 {
			yyl1256 := r.ReadMapStart()
			if yyl1256 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1256, d)
			}
		} else if yyct1256 == codecSelferValueTypeArray1234 {
			yyl1256 := r.ReadArrayStart()
			if yyl1256 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1256, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1257Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1257Slc
	var yyhl1257 bool = l >= 0
	for yyj1257 := 0; ; yyj1257++ {
		if yyhl1257 {
			if yyj1257 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1257Slc = r.DecodeBytes(yys1257Slc, true, true)
		yys1257 := string(yys1257Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1257 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				x.ReadOnly = bool(r.DecodeBool())
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				x.MountPath = string(r.DecodeString())
			}
		case "subPath":
			if r.TryDecodeAsNil() {
				x.SubPath = ""
			} else {
				x.SubPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1257)
		} // end switch yys1257
	} // end for yyj1257
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1262 int
	var yyb1262 bool
	var yyhl1262 bool = l >= 0
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		x.ReadOnly = bool(r.DecodeBool())
	}
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		x.MountPath = string(r.DecodeString())
	}
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SubPath = ""
	} else {
		x.SubPath = string(r.DecodeString())
	}
	for {
		yyj1262++
		if yyhl1262 {
			yyb1262 = yyj1262 > l
		} else {
			yyb1262 = r.CheckBreak()
		}
		if yyb1262 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1262-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1267 := z.EncBinary()
		_ = yym1267
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1268 := !z.EncBinary()
			yy2arr1268 := z.EncBasicHandle().StructToArray
			var yyq1268 [3]bool
			_, _, _ = yysep1268, yyq1268, yy2arr1268
			const yyr1268 bool = false
			yyq1268[1] = x.Value != ""
			yyq1268[2] = x.ValueFrom != nil
			var yynn1268 int
			if yyr1268 || yy2arr1268 {
				r.EncodeArrayStart(3)
			} else {
				yynn1268 = 1
				for _, b := range yyq1268 {
					if b {
						yynn1268++
					}
				}
				r.EncodeMapStart(yynn1268)
				yynn1268 = 0
			}
			if yyr1268 || yy2arr1268 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1270 := z.EncBinary()
				_ = yym1270
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1271 := z.EncBinary()
				_ = yym1271
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1268 || yy2arr1268 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1268[1] {
					yym1273 := z.EncBinary()
					_ = yym1273
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1268[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1274 := z.EncBinary()
					_ = yym1274
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr1268 || yy2arr1268 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1268[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1268[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1268 || yy2arr1268 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1276 := z.DecBinary()
	_ = yym1276
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1277 := r.ContainerType()
		if yyct1277 == codecSelferValueTypeMap1234 {
			yyl1277 := r.ReadMapStart()
			if yyl1277 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1277, d)
			}
		} else if yyct1277 == codecSelferValueTypeArray1234 {
			yyl1277 := r.ReadArrayStart()
			if yyl1277 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1277, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1278Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1278Slc
	var yyhl1278 bool = l >= 0
	for yyj1278 := 0; ; yyj1278++ {
		if yyhl1278 {
			if yyj1278 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1278Slc = r.DecodeBytes(yys1278Slc, true, true)
		yys1278 := string(yys1278Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1278 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1278)
		} // end switch yys1278
	} // end for yyj1278
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1282 int
	var yyb1282 bool
	var yyhl1282 bool = l >= 0
	yyj1282++
	if yyhl1282 {
		yyb1282 = yyj1282 > l
	} else {
		yyb1282 = r.CheckBreak()
	}
	if yyb1282 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1282++
	if yyhl1282 {
		yyb1282 = yyj1282 > l
	} else {
		yyb1282 = r.CheckBreak()
	}
	if yyb1282 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj1282++
	if yyhl1282 {
		yyb1282 = yyj1282 > l
	} else {
		yyb1282 = r.CheckBreak()
	}
	if yyb1282 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj1282++
		if yyhl1282 {
			yyb1282 = yyj1282 > l
		} else {
			yyb1282 = r.CheckBreak()
		}
		if yyb1282 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1282-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1286 := z.EncBinary()
		_ = yym1286
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1287 := !z.EncBinary()
			yy2arr1287 := z.EncBasicHandle().StructToArray
			var yyq1287 [4]bool
			_, _, _ = yysep1287, yyq1287, yy2arr1287
			const yyr1287 bool = false
			yyq1287[0] = x.FieldRef != nil
			yyq1287[1] = x.ResourceFieldRef != nil
			yyq1287[2] = x.ConfigMapKeyRef != nil
			yyq1287[3] = x.SecretKeyRef != nil
			var yynn1287 int
			if yyr1287 || yy2arr1287 {
				r.EncodeArrayStart(4)
			} else {
				yynn1287 = 0
				for _, b := range yyq1287 {
					if b {
						yynn1287++
					}
				}
				r.EncodeMapStart(yynn1287)
				yynn1287 = 0
			}
			if yyr1287 || yy2arr1287 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1287[0] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1287[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1287 || yy2arr1287 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1287[1] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1287[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1287 || yy2arr1287 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1287[2] {
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1287[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMapKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1287 || yy2arr1287 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1287[3] {
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1287[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1287 || yy2arr1287 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1292 := z.DecBinary()
	_ = yym1292
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1293 := r.ContainerType()
		if yyct1293 == codecSelferValueTypeMap1234 {
			yyl1293 := r.ReadMapStart()
			if yyl1293 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1293, d)
			}
		} else if yyct1293 == codecSelferValueTypeArray1234 {
			yyl1293 := r.ReadArrayStart()
			if yyl1293 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1293, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1294Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1294Slc
	var yyhl1294 bool = l >= 0
	for yyj1294 := 0; ; yyj1294++ {
		if yyhl1294 {
			if yyj1294 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1294Slc = r.DecodeBytes(yys1294Slc, true, true)
		yys1294 := string(yys1294Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1294 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "configMapKeyRef":
			if r.TryDecodeAsNil() {
				if x.ConfigMapKeyRef != nil {
					x.ConfigMapKeyRef = nil
				}
			} else {
				if x.ConfigMapKeyRef == nil {
					x.ConfigMapKeyRef = new(ConfigMapKeySelector)
				}
				x.ConfigMapKeyRef.CodecDecodeSelf(d)
			}
		case "secretKeyRef":
			if r.TryDecodeAsNil() {
				if x.SecretKeyRef != nil {
					x.SecretKeyRef = nil
				}
			} else {
				if x.SecretKeyRef == nil {
					x.SecretKeyRef = new(SecretKeySelector)
				}
				x.SecretKeyRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1294)
		} // end switch yys1294
	} // end for yyj1294
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1299 int
	var yyb1299 bool
	var yyhl1299 bool = l >= 0
	yyj1299++
	if yyhl1299 {
		yyb1299 = yyj1299 > l
	} else {
		yyb1299 = r.CheckBreak()
	}
	if yyb1299 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj1299++
	if yyhl1299 {
		yyb1299 = yyj1299 > l
	} else {
		yyb1299 = r.CheckBreak()
	}
	if yyb1299 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj1299++
	if yyhl1299 {
		yyb1299 = yyj1299 > l
	} else {
		yyb1299 = r.CheckBreak()
	}
	if yyb1299 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMapKeyRef != nil {
			x.ConfigMapKeyRef = nil
		}
	} else {
		if x.ConfigMapKeyRef == nil {
			x.ConfigMapKeyRef = new(ConfigMapKeySelector)
		}
		x.ConfigMapKeyRef.CodecDecodeSelf(d)
	}
	yyj1299++
	if yyhl1299 {
		yyb1299 = yyj1299 > l
	} else {
		yyb1299 = r.CheckBreak()
	}
	if yyb1299 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretKeyRef != nil {
			x.SecretKeyRef = nil
		}
	} else {
		if x.SecretKeyRef == nil {
			x.SecretKeyRef = new(SecretKeySelector)
		}
		x.SecretKeyRef.CodecDecodeSelf(d)
	}
	for {
		yyj1299++
		if yyhl1299 {
			yyb1299 = yyj1299 > l
		} else {
			yyb1299 = r.CheckBreak()
		}
		if yyb1299 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1299-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1304 := z.EncBinary()
		_ = yym1304
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1305 := !z.EncBinary()
			yy2arr1305 := z.EncBasicHandle().StructToArray
			var yyq1305 [2]bool
			_, _, _ = yysep1305, yyq1305, yy2arr1305
			const yyr1305 bool = false
			var yynn1305 int
			if yyr1305 || yy2arr1305 {
				r.EncodeArrayStart(2)
			} else {
				yynn1305 = 2
				for _, b := range yyq1305 {
					if b {
						yynn1305++
					}
				}
				r.EncodeMapStart(yynn1305)
				yynn1305 = 0
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1307 := z.EncBinary()
				_ = yym1307
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1308 := z.EncBinary()
				_ = yym1308
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
				}
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1310 := z.EncBinary()
				_ = yym1310
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1311 := z.EncBinary()
				_ = yym1311
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr1305 || yy2arr1305 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1312 := z.DecBinary()
	_ = yym1312
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1313 := r.ContainerType()
		if yyct1313 == codecSelferValueTypeMap1234 {
			yyl1313 := r.ReadMapStart()
			if yyl1313 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1313, d)
			}
		} else if yyct1313 == codecSelferValueTypeArray1234 {
			yyl1313 := r.ReadArrayStart()
			if yyl1313 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1313, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1314Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1314Slc
	var yyhl1314 bool = l >= 0
	for yyj1314 := 0; ; yyj1314++ {
		if yyhl1314 {
			if yyj1314 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1314Slc = r.DecodeBytes(yys1314Slc, true, true)
		yys1314 := string(yys1314Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1314 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				x.FieldPath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1314)
		} // end switch yys1314
	} // end for yyj1314
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1317 int
	var yyb1317 bool
	var yyhl1317 bool = l >= 0
	yyj1317++
	if yyhl1317 {
		yyb1317 = yyj1317 > l
	} else {
		yyb1317 = r.CheckBreak()
	}
	if yyb1317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1317++
	if yyhl1317 {
		yyb1317 = yyj1317 > l
	} else {
		yyb1317 = r.CheckBreak()
	}
	if yyb1317 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		x.FieldPath = string(r.DecodeString())
	}
	for {
		yyj1317++
		if yyhl1317 {
			yyb1317 = yyj1317 > l
		} else {
			yyb1317 = r.CheckBreak()
		}
		if yyb1317 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1317-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1320 := z.EncBinary()
		_ = yym1320
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1321 := !z.EncBinary()
			yy2arr1321 := z.EncBasicHandle().StructToArray
			var yyq1321 [3]bool
			_, _, _ = yysep1321, yyq1321, yy2arr1321
			const yyr1321 bool = false
			yyq1321[0] = x.ContainerName != ""
			yyq1321[2] = true
			var yynn1321 int
			if yyr1321 || yy2arr1321 {
				r.EncodeArrayStart(3)
			} else {
				yynn1321 = 1
				for _, b := range yyq1321 {
					if b {
						yynn1321++
					}
				}
				r.EncodeMapStart(yynn1321)
				yynn1321 = 0
			}
			if yyr1321 || yy2arr1321 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1321[0] {
					yym1323 := z.EncBinary()
					_ = yym1323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1321[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1324 := z.EncBinary()
					_ = yym1324
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				}
			}
			if yyr1321 || yy2arr1321 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1326 := z.EncBinary()
				_ = yym1326
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1327 := z.EncBinary()
				_ = yym1327
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			}
			if yyr1321 || yy2arr1321 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1321[2] {
					yy1329 := &x.Divisor
					yym1330 := z.EncBinary()
					_ = yym1330
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1329) {
					} else if !yym1330 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1329)
					} else {
						z.EncFallback(yy1329)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1321[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("divisor"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1331 := &x.Divisor
					yym1332 := z.EncBinary()
					_ = yym1332
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1331) {
					} else if !yym1332 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1331)
					} else {
						z.EncFallback(yy1331)
					}
				}
			}
			if yyr1321 || yy2arr1321 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1333 := z.DecBinary()
	_ = yym1333
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1334 := r.ContainerType()
		if yyct1334 == codecSelferValueTypeMap1234 {
			yyl1334 := r.ReadMapStart()
			if yyl1334 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1334, d)
			}
		} else if yyct1334 == codecSelferValueTypeArray1234 {
			yyl1334 := r.ReadArrayStart()
			if yyl1334 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1334, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1335Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1335Slc
	var yyhl1335 bool = l >= 0
	for yyj1335 := 0; ; yyj1335++ {
		if yyhl1335 {
			if yyj1335 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1335Slc = r.DecodeBytes(yys1335Slc, true, true)
		yys1335 := string(yys1335Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1335 {
		case "containerName":
			if r.TryDecodeAsNil() {
				x.ContainerName = ""
			} else {
				x.ContainerName = string(r.DecodeString())
			}
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				x.Resource = string(r.DecodeString())
			}
		case "divisor":
			if r.TryDecodeAsNil() {
				x.Divisor = pkg3_resource.Quantity{}
			} else {
				yyv1338 := &x.Divisor
				yym1339 := z.DecBinary()
				_ = yym1339
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1338) {
				} else if !yym1339 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1338)
				} else {
					z.DecFallback(yyv1338, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1335)
		} // end switch yys1335
	} // end for yyj1335
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1340 int
	var yyb1340 bool
	var yyhl1340 bool = l >= 0
	yyj1340++
	if yyhl1340 {
		yyb1340 = yyj1340 > l
	} else {
		yyb1340 = r.CheckBreak()
	}
	if yyb1340 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerName = ""
	} else {
		x.ContainerName = string(r.DecodeString())
	}
	yyj1340++
	if yyhl1340 {
		yyb1340 = yyj1340 > l
	} else {
		yyb1340 = r.CheckBreak()
	}
	if yyb1340 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		x.Resource = string(r.DecodeString())
	}
	yyj1340++
	if yyhl1340 {
		yyb1340 = yyj1340 > l
	} else {
		yyb1340 = r.CheckBreak()
	}
	if yyb1340 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Divisor = pkg3_resource.Quantity{}
	} else {
		yyv1343 := &x.Divisor
		yym1344 := z.DecBinary()
		_ = yym1344
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1343) {
		} else if !yym1344 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1343)
		} else {
			z.DecFallback(yyv1343, false)
		}
	}
	for {
		yyj1340++
		if yyhl1340 {
			yyb1340 = yyj1340 > l
		} else {
			yyb1340 = r.CheckBreak()
		}
		if yyb1340 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1340-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1345 := z.EncBinary()
		_ = yym1345
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1346 := !z.EncBinary()
			yy2arr1346 := z.EncBasicHandle().StructToArray
			var yyq1346 [2]bool
			_, _, _ = yysep1346, yyq1346, yy2arr1346
			const yyr1346 bool = false
			var yynn1346 int
			if yyr1346 || yy2arr1346 {
				r.EncodeArrayStart(2)
			} else {
				yynn1346 = 2
				for _, b := range yyq1346 {
					if b {
						yynn1346++
					}
				}
				r.EncodeMapStart(yynn1346)
				yynn1346 = 0
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1348 := z.EncBinary()
				_ = yym1348
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1349 := z.EncBinary()
				_ = yym1349
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1351 := z.EncBinary()
				_ = yym1351
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1352 := z.EncBinary()
				_ = yym1352
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1346 || yy2arr1346 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1353 := z.DecBinary()
	_ = yym1353
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1354 := r.ContainerType()
		if yyct1354 == codecSelferValueTypeMap1234 {
			yyl1354 := r.ReadMapStart()
			if yyl1354 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1354, d)
			}
		} else if yyct1354 == codecSelferValueTypeArray1234 {
			yyl1354 := r.ReadArrayStart()
			if yyl1354 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1354, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1355Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1355Slc
	var yyhl1355 bool = l >= 0
	for yyj1355 := 0; ; yyj1355++ {
		if yyhl1355 {
			if yyj1355 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1355Slc = r.DecodeBytes(yys1355Slc, true, true)
		yys1355 := string(yys1355Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1355 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1355)
		} // end switch yys1355
	} // end for yyj1355
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1358 int
	var yyb1358 bool
	var yyhl1358 bool = l >= 0
	yyj1358++
	if yyhl1358 {
		yyb1358 = yyj1358 > l
	} else {
		yyb1358 = r.CheckBreak()
	}
	if yyb1358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1358++
	if yyhl1358 {
		yyb1358 = yyj1358 > l
	} else {
		yyb1358 = r.CheckBreak()
	}
	if yyb1358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1358++
		if yyhl1358 {
			yyb1358 = yyj1358 > l
		} else {
			yyb1358 = r.CheckBreak()
		}
		if yyb1358 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1358-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1361 := z.EncBinary()
		_ = yym1361
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1362 := !z.EncBinary()
			yy2arr1362 := z.EncBasicHandle().StructToArray
			var yyq1362 [2]bool
			_, _, _ = yysep1362, yyq1362, yy2arr1362
			const yyr1362 bool = false
			var yynn1362 int
			if yyr1362 || yy2arr1362 {
				r.EncodeArrayStart(2)
			} else {
				yynn1362 = 2
				for _, b := range yyq1362 {
					if b {
						yynn1362++
					}
				}
				r.EncodeMapStart(yynn1362)
				yynn1362 = 0
			}
			if yyr1362 || yy2arr1362 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1364 := z.EncBinary()
				_ = yym1364
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1365 := z.EncBinary()
				_ = yym1365
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1362 || yy2arr1362 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1367 := z.EncBinary()
				_ = yym1367
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1368 := z.EncBinary()
				_ = yym1368
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1362 || yy2arr1362 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1369 := z.DecBinary()
	_ = yym1369
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1370 := r.ContainerType()
		if yyct1370 == codecSelferValueTypeMap1234 {
			yyl1370 := r.ReadMapStart()
			if yyl1370 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1370, d)
			}
		} else if yyct1370 == codecSelferValueTypeArray1234 {
			yyl1370 := r.ReadArrayStart()
			if yyl1370 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1370, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1371Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1371Slc
	var yyhl1371 bool = l >= 0
	for yyj1371 := 0; ; yyj1371++ {
		if yyhl1371 {
			if yyj1371 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1371Slc = r.DecodeBytes(yys1371Slc, true, true)
		yys1371 := string(yys1371Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1371 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1371)
		} // end switch yys1371
	} // end for yyj1371
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1374 int
	var yyb1374 bool
	var yyhl1374 bool = l >= 0
	yyj1374++
	if yyhl1374 {
		yyb1374 = yyj1374 > l
	} else {
		yyb1374 = r.CheckBreak()
	}
	if yyb1374 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1374++
	if yyhl1374 {
		yyb1374 = yyj1374 > l
	} else {
		yyb1374 = r.CheckBreak()
	}
	if yyb1374 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	for {
		yyj1374++
		if yyhl1374 {
			yyb1374 = yyj1374 > l
		} else {
			yyb1374 = r.CheckBreak()
		}
		if yyb1374 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1374-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPHeader) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1377 := z.EncBinary()
		_ = yym1377
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1378 := !z.EncBinary()
			yy2arr1378 := z.EncBasicHandle().StructToArray
			var yyq1378 [2]bool
			_, _, _ = yysep1378, yyq1378, yy2arr1378
			const yyr1378 bool = false
			var yynn1378 int
			if yyr1378 || yy2arr1378 {
				r.EncodeArrayStart(2)
			} else {
				yynn1378 = 2
				for _, b := range yyq1378 {
					if b {
						yynn1378++
					}
				}
				r.EncodeMapStart(yynn1378)
				yynn1378 = 0
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1380 := z.EncBinary()
				_ = yym1380
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1381 := z.EncBinary()
				_ = yym1381
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1383 := z.EncBinary()
				_ = yym1383
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1384 := z.EncBinary()
				_ = yym1384
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPHeader) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1385 := z.DecBinary()
	_ = yym1385
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1386 := r.ContainerType()
		if yyct1386 == codecSelferValueTypeMap1234 {
			yyl1386 := r.ReadMapStart()
			if yyl1386 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1386, d)
			}
		} else if yyct1386 == codecSelferValueTypeArray1234 {
			yyl1386 := r.ReadArrayStart()
			if yyl1386 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1386, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPHeader) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1387Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1387Slc
	var yyhl1387 bool = l >= 0
	for yyj1387 := 0; ; yyj1387++ {
		if yyhl1387 {
			if yyj1387 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1387Slc = r.DecodeBytes(yys1387Slc, true, true)
		yys1387 := string(yys1387Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1387 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1387)
		} // end switch yys1387
	} // end for yyj1387
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPHeader) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1390 int
	var yyb1390 bool
	var yyhl1390 bool = l >= 0
	yyj1390++
	if yyhl1390 {
		yyb1390 = yyj1390 > l
	} else {
		yyb1390 = r.CheckBreak()
	}
	if yyb1390 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1390++
	if yyhl1390 {
		yyb1390 = yyj1390 > l
	} else {
		yyb1390 = r.CheckBreak()
	}
	if yyb1390 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	for {
		yyj1390++
		if yyhl1390 {
			yyb1390 = yyj1390 > l
		} else {
			yyb1390 = r.CheckBreak()
		}
		if yyb1390 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1390-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1393 := z.EncBinary()
		_ = yym1393
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1394 := !z.EncBinary()
			yy2arr1394 := z.EncBasicHandle().StructToArray
			var yyq1394 [5]bool
			_, _, _ = yysep1394, yyq1394, yy2arr1394
			const yyr1394 bool = false
			yyq1394[0] = x.Path != ""
			yyq1394[1] = true
			yyq1394[2] = x.Host != ""
			yyq1394[3] = x.Scheme != ""
			yyq1394[4] = len(x.HTTPHeaders) != 0
			var yynn1394 int
			if yyr1394 || yy2arr1394 {
				r.EncodeArrayStart(5)
			} else {
				yynn1394 = 0
				for _, b := range yyq1394 {
					if b {
						yynn1394++
					}
				}
				r.EncodeMapStart(yynn1394)
				yynn1394 = 0
			}
			if yyr1394 || yy2arr1394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1394[0] {
					yym1396 := z.EncBinary()
					_ = yym1396
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1394[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1397 := z.EncBinary()
					_ = yym1397
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr1394 || yy2arr1394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1394[1] {
					yy1399 := &x.Port
					yym1400 := z.EncBinary()
					_ = yym1400
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1399) {
					} else if !yym1400 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1399)
					} else {
						z.EncFallback(yy1399)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1394[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1401 := &x.Port
					yym1402 := z.EncBinary()
					_ = yym1402
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1401) {
					} else if !yym1402 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1401)
					} else {
						z.EncFallback(yy1401)
					}
				}
			}
			if yyr1394 || yy2arr1394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1394[2] {
					yym1404 := z.EncBinary()
					_ = yym1404
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1394[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1405 := z.EncBinary()
					_ = yym1405
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr1394 || yy2arr1394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1394[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1394[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr1394 || yy2arr1394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1394[4] {
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1408 := z.EncBinary()
						_ = yym1408
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1394[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpHeaders"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym1409 := z.EncBinary()
						_ = yym1409
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				}
			}
			if yyr1394 || yy2arr1394 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1410 := z.DecBinary()
	_ = yym1410
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1411 := r.ContainerType()
		if yyct1411 == codecSelferValueTypeMap1234 {
			yyl1411 := r.ReadMapStart()
			if yyl1411 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1411, d)
			}
		} else if yyct1411 == codecSelferValueTypeArray1234 {
			yyl1411 := r.ReadArrayStart()
			if yyl1411 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1411, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1412Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1412Slc
	var yyhl1412 bool = l >= 0
	for yyj1412 := 0; ; yyj1412++ {
		if yyhl1412 {
			if yyj1412 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1412Slc = r.DecodeBytes(yys1412Slc, true, true)
		yys1412 := string(yys1412Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1412 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1414 := &x.Port
				yym1415 := z.DecBinary()
				_ = yym1415
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1414) {
				} else if !yym1415 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1414)
				} else {
					z.DecFallback(yyv1414, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				x.Scheme = URIScheme(r.DecodeString())
			}
		case "httpHeaders":
			if r.TryDecodeAsNil() {
				x.HTTPHeaders = nil
			} else {
				yyv1418 := &x.HTTPHeaders
				yym1419 := z.DecBinary()
				_ = yym1419
				if false {
				} else {
					h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1418), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1412)
		} // end switch yys1412
	} // end for yyj1412
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1420 int
	var yyb1420 bool
	var yyhl1420 bool = l >= 0
	yyj1420++
	if yyhl1420 {
		yyb1420 = yyj1420 > l
	} else {
		yyb1420 = r.CheckBreak()
	}
	if yyb1420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1420++
	if yyhl1420 {
		yyb1420 = yyj1420 > l
	} else {
		yyb1420 = r.CheckBreak()
	}
	if yyb1420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1422 := &x.Port
		yym1423 := z.DecBinary()
		_ = yym1423
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1422) {
		} else if !yym1423 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1422)
		} else {
			z.DecFallback(yyv1422, false)
		}
	}
	yyj1420++
	if yyhl1420 {
		yyb1420 = yyj1420 > l
	} else {
		yyb1420 = r.CheckBreak()
	}
	if yyb1420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	yyj1420++
	if yyhl1420 {
		yyb1420 = yyj1420 > l
	} else {
		yyb1420 = r.CheckBreak()
	}
	if yyb1420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		x.Scheme = URIScheme(r.DecodeString())
	}
	yyj1420++
	if yyhl1420 {
		yyb1420 = yyj1420 > l
	} else {
		yyb1420 = r.CheckBreak()
	}
	if yyb1420 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPHeaders = nil
	} else {
		yyv1426 := &x.HTTPHeaders
		yym1427 := z.DecBinary()
		_ = yym1427
		if false {
		} else {
			h.decSliceHTTPHeader((*[]HTTPHeader)(yyv1426), d)
		}
	}
	for {
		yyj1420++
		if yyhl1420 {
			yyb1420 = yyj1420 > l
		} else {
			yyb1420 = r.CheckBreak()
		}
		if yyb1420 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1420-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1428 := z.EncBinary()
	_ = yym1428
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1429 := z.DecBinary()
	_ = yym1429
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1430 := z.EncBinary()
		_ = yym1430
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1431 := !z.EncBinary()
			yy2arr1431 := z.EncBasicHandle().StructToArray
			var yyq1431 [1]bool
			_, _, _ = yysep1431, yyq1431, yy2arr1431
			const yyr1431 bool = false
			yyq1431[0] = true
			var yynn1431 int
			if yyr1431 || yy2arr1431 {
				r.EncodeArrayStart(1)
			} else {
				yynn1431 = 0
				for _, b := range yyq1431 {
					if b {
						yynn1431++
					}
				}
				r.EncodeMapStart(yynn1431)
				yynn1431 = 0
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1431[0] {
					yy1433 := &x.Port
					yym1434 := z.EncBinary()
					_ = yym1434
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1433) {
					} else if !yym1434 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1433)
					} else {
						z.EncFallback(yy1433)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1431[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1435 := &x.Port
					yym1436 := z.EncBinary()
					_ = yym1436
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1435) {
					} else if !yym1436 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1435)
					} else {
						z.EncFallback(yy1435)
					}
				}
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1437 := z.DecBinary()
	_ = yym1437
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1438 := r.ContainerType()
		if yyct1438 == codecSelferValueTypeMap1234 {
			yyl1438 := r.ReadMapStart()
			if yyl1438 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1438, d)
			}
		} else if yyct1438 == codecSelferValueTypeArray1234 {
			yyl1438 := r.ReadArrayStart()
			if yyl1438 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1438, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1439Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1439Slc
	var yyhl1439 bool = l >= 0
	for yyj1439 := 0; ; yyj1439++ {
		if yyhl1439 {
			if yyj1439 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1439Slc = r.DecodeBytes(yys1439Slc, true, true)
		yys1439 := string(yys1439Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1439 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv1440 := &x.Port
				yym1441 := z.DecBinary()
				_ = yym1441
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1440) {
				} else if !yym1441 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1440)
				} else {
					z.DecFallback(yyv1440, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1439)
		} // end switch yys1439
	} // end for yyj1439
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1442 int
	var yyb1442 bool
	var yyhl1442 bool = l >= 0
	yyj1442++
	if yyhl1442 {
		yyb1442 = yyj1442 > l
	} else {
		yyb1442 = r.CheckBreak()
	}
	if yyb1442 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv1443 := &x.Port
		yym1444 := z.DecBinary()
		_ = yym1444
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1443) {
		} else if !yym1444 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1443)
		} else {
			z.DecFallback(yyv1443, false)
		}
	}
	for {
		yyj1442++
		if yyhl1442 {
			yyb1442 = yyj1442 > l
		} else {
			yyb1442 = r.CheckBreak()
		}
		if yyb1442 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1442-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1445 := z.EncBinary()
		_ = yym1445
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1446 := !z.EncBinary()
			yy2arr1446 := z.EncBasicHandle().StructToArray
			var yyq1446 [1]bool
			_, _, _ = yysep1446, yyq1446, yy2arr1446
			const yyr1446 bool = false
			yyq1446[0] = len(x.Command) != 0
			var yynn1446 int
			if yyr1446 || yy2arr1446 {
				r.EncodeArrayStart(1)
			} else {
				yynn1446 = 0
				for _, b := range yyq1446 {
					if b {
						yynn1446++
					}
				}
				r.EncodeMapStart(yynn1446)
				yynn1446 = 0
			}
			if yyr1446 || yy2arr1446 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1446[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1448 := z.EncBinary()
						_ = yym1448
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1446[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1449 := z.EncBinary()
						_ = yym1449
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1446 || yy2arr1446 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1450 := z.DecBinary()
	_ = yym1450
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1451 := r.ContainerType()
		if yyct1451 == codecSelferValueTypeMap1234 {
			yyl1451 := r.ReadMapStart()
			if yyl1451 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1451, d)
			}
		} else if yyct1451 == codecSelferValueTypeArray1234 {
			yyl1451 := r.ReadArrayStart()
			if yyl1451 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1451, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1452Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1452Slc
	var yyhl1452 bool = l >= 0
	for yyj1452 := 0; ; yyj1452++ {
		if yyhl1452 {
			if yyj1452 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1452Slc = r.DecodeBytes(yys1452Slc, true, true)
		yys1452 := string(yys1452Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1452 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1453 := &x.Command
				yym1454 := z.DecBinary()
				_ = yym1454
				if false {
				} else {
					z.F.DecSliceStringX(yyv1453, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1452)
		} // end switch yys1452
	} // end for yyj1452
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1455 int
	var yyb1455 bool
	var yyhl1455 bool = l >= 0
	yyj1455++
	if yyhl1455 {
		yyb1455 = yyj1455 > l
	} else {
		yyb1455 = r.CheckBreak()
	}
	if yyb1455 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1456 := &x.Command
		yym1457 := z.DecBinary()
		_ = yym1457
		if false {
		} else {
			z.F.DecSliceStringX(yyv1456, false, d)
		}
	}
	for {
		yyj1455++
		if yyhl1455 {
			yyb1455 = yyj1455 > l
		} else {
			yyb1455 = r.CheckBreak()
		}
		if yyb1455 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1455-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1458 := z.EncBinary()
		_ = yym1458
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1459 := !z.EncBinary()
			yy2arr1459 := z.EncBasicHandle().StructToArray
			var yyq1459 [8]bool
			_, _, _ = yysep1459, yyq1459, yy2arr1459
			const yyr1459 bool = false
			yyq1459[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq1459[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq1459[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq1459[3] = x.InitialDelaySeconds != 0
			yyq1459[4] = x.TimeoutSeconds != 0
			yyq1459[5] = x.PeriodSeconds != 0
			yyq1459[6] = x.SuccessThreshold != 0
			yyq1459[7] = x.FailureThreshold != 0
			var yynn1459 int
			if yyr1459 || yy2arr1459 {
				r.EncodeArrayStart(8)
			} else {
				yynn1459 = 0
				for _, b := range yyq1459 {
					if b {
						yynn1459++
					}
				}
				r.EncodeMapStart(yynn1459)
				yynn1459 = 0
			}
			var yyn1460 bool
			if x.Handler.Exec == nil {
				yyn1460 = true
				goto LABEL1460
			}
		LABEL1460:
			if yyr1459 || yy2arr1459 {
				if yyn1460 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1459[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1459[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1460 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1461 bool
			if x.Handler.HTTPGet == nil {
				yyn1461 = true
				goto LABEL1461
			}
		LABEL1461:
			if yyr1459 || yy2arr1459 {
				if yyn1461 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1459[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1459[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1461 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn1462 bool
			if x.Handler.TCPSocket == nil {
				yyn1462 = true
				goto LABEL1462
			}
		LABEL1462:
			if yyr1459 || yy2arr1459 {
				if yyn1462 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1459[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1459[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1462 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1459 || yy2arr1459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1459[3] {
					yym1464 := z.EncBinary()
					_ = yym1464
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1459[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1465 := z.EncBinary()
					_ = yym1465
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr1459 || yy2arr1459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1459[4] {
					yym1467 := z.EncBinary()
					_ = yym1467
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1459[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1468 := z.EncBinary()
					_ = yym1468
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr1459 || yy2arr1459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1459[5] {
					yym1470 := z.EncBinary()
					_ = yym1470
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1459[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1471 := z.EncBinary()
					_ = yym1471
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr1459 || yy2arr1459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1459[6] {
					yym1473 := z.EncBinary()
					_ = yym1473
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1459[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1474 := z.EncBinary()
					_ = yym1474
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr1459 || yy2arr1459 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1459[7] {
					yym1476 := z.EncBinary()
					_ = yym1476
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1459[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1477 := z.EncBinary()
					_ = yym1477
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr1459 || yy2arr1459 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1478 := z.DecBinary()
	_ = yym1478
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1479 := r.ContainerType()
		if yyct1479 == codecSelferValueTypeMap1234 {
			yyl1479 := r.ReadMapStart()
			if yyl1479 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1479, d)
			}
		} else if yyct1479 == codecSelferValueTypeArray1234 {
			yyl1479 := r.ReadArrayStart()
			if yyl1479 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1479, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1480Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1480Slc
	var yyhl1480 bool = l >= 0
	for yyj1480 := 0; ; yyj1480++ {
		if yyhl1480 {
			if yyj1480 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1480Slc = r.DecodeBytes(yys1480Slc, true, true)
		yys1480 := string(yys1480Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1480 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				x.InitialDelaySeconds = int32(r.DecodeInt(32))
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				x.TimeoutSeconds = int32(r.DecodeInt(32))
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				x.PeriodSeconds = int32(r.DecodeInt(32))
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				x.SuccessThreshold = int32(r.DecodeInt(32))
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				x.FailureThreshold = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1480)
		} // end switch yys1480
	} // end for yyj1480
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1489 int
	var yyb1489 bool
	var yyhl1489 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		x.InitialDelaySeconds = int32(r.DecodeInt(32))
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		x.TimeoutSeconds = int32(r.DecodeInt(32))
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		x.PeriodSeconds = int32(r.DecodeInt(32))
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		x.SuccessThreshold = int32(r.DecodeInt(32))
	}
	yyj1489++
	if yyhl1489 {
		yyb1489 = yyj1489 > l
	} else {
		yyb1489 = r.CheckBreak()
	}
	if yyb1489 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		x.FailureThreshold = int32(r.DecodeInt(32))
	}
	for {
		yyj1489++
		if yyhl1489 {
			yyb1489 = yyj1489 > l
		} else {
			yyb1489 = r.CheckBreak()
		}
		if yyb1489 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1489-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1498 := z.EncBinary()
	_ = yym1498
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1499 := z.DecBinary()
	_ = yym1499
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1500 := z.EncBinary()
	_ = yym1500
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1501 := z.DecBinary()
	_ = yym1501
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1502 := z.EncBinary()
		_ = yym1502
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1503 := !z.EncBinary()
			yy2arr1503 := z.EncBasicHandle().StructToArray
			var yyq1503 [2]bool
			_, _, _ = yysep1503, yyq1503, yy2arr1503
			const yyr1503 bool = false
			yyq1503[0] = len(x.Add) != 0
			yyq1503[1] = len(x.Drop) != 0
			var yynn1503 int
			if yyr1503 || yy2arr1503 {
				r.EncodeArrayStart(2)
			} else {
				yynn1503 = 0
				for _, b := range yyq1503 {
					if b {
						yynn1503++
					}
				}
				r.EncodeMapStart(yynn1503)
				yynn1503 = 0
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1505 := z.EncBinary()
						_ = yym1505
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym1506 := z.EncBinary()
						_ = yym1506
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1503[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1508 := z.EncBinary()
						_ = yym1508
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1503[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym1509 := z.EncBinary()
						_ = yym1509
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr1503 || yy2arr1503 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1510 := z.DecBinary()
	_ = yym1510
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1511 := r.ContainerType()
		if yyct1511 == codecSelferValueTypeMap1234 {
			yyl1511 := r.ReadMapStart()
			if yyl1511 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1511, d)
			}
		} else if yyct1511 == codecSelferValueTypeArray1234 {
			yyl1511 := r.ReadArrayStart()
			if yyl1511 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1511, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1512Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1512Slc
	var yyhl1512 bool = l >= 0
	for yyj1512 := 0; ; yyj1512++ {
		if yyhl1512 {
			if yyj1512 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1512Slc = r.DecodeBytes(yys1512Slc, true, true)
		yys1512 := string(yys1512Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1512 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv1513 := &x.Add
				yym1514 := z.DecBinary()
				_ = yym1514
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1513), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv1515 := &x.Drop
				yym1516 := z.DecBinary()
				_ = yym1516
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv1515), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1512)
		} // end switch yys1512
	} // end for yyj1512
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1517 int
	var yyb1517 bool
	var yyhl1517 bool = l >= 0
	yyj1517++
	if yyhl1517 {
		yyb1517 = yyj1517 > l
	} else {
		yyb1517 = r.CheckBreak()
	}
	if yyb1517 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv1518 := &x.Add
		yym1519 := z.DecBinary()
		_ = yym1519
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1518), d)
		}
	}
	yyj1517++
	if yyhl1517 {
		yyb1517 = yyj1517 > l
	} else {
		yyb1517 = r.CheckBreak()
	}
	if yyb1517 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv1520 := &x.Drop
		yym1521 := z.DecBinary()
		_ = yym1521
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv1520), d)
		}
	}
	for {
		yyj1517++
		if yyhl1517 {
			yyb1517 = yyj1517 > l
		} else {
			yyb1517 = r.CheckBreak()
		}
		if yyb1517 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1517-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1522 := z.EncBinary()
		_ = yym1522
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1523 := !z.EncBinary()
			yy2arr1523 := z.EncBasicHandle().StructToArray
			var yyq1523 [2]bool
			_, _, _ = yysep1523, yyq1523, yy2arr1523
			const yyr1523 bool = false
			yyq1523[0] = len(x.Limits) != 0
			yyq1523[1] = len(x.Requests) != 0
			var yynn1523 int
			if yyr1523 || yy2arr1523 {
				r.EncodeArrayStart(2)
			} else {
				yynn1523 = 0
				for _, b := range yyq1523 {
					if b {
						yynn1523++
					}
				}
				r.EncodeMapStart(yynn1523)
				yynn1523 = 0
			}
			if yyr1523 || yy2arr1523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1523[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1523[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1523 || yy2arr1523 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1523[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1523[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1523 || yy2arr1523 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1526 := z.DecBinary()
	_ = yym1526
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1527 := r.ContainerType()
		if yyct1527 == codecSelferValueTypeMap1234 {
			yyl1527 := r.ReadMapStart()
			if yyl1527 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1527, d)
			}
		} else if yyct1527 == codecSelferValueTypeArray1234 {
			yyl1527 := r.ReadArrayStart()
			if yyl1527 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1527, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1528Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1528Slc
	var yyhl1528 bool = l >= 0
	for yyj1528 := 0; ; yyj1528++ {
		if yyhl1528 {
			if yyj1528 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1528Slc = r.DecodeBytes(yys1528Slc, true, true)
		yys1528 := string(yys1528Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1528 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv1529 := &x.Limits
				yyv1529.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv1530 := &x.Requests
				yyv1530.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1528)
		} // end switch yys1528
	} // end for yyj1528
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1531 int
	var yyb1531 bool
	var yyhl1531 bool = l >= 0
	yyj1531++
	if yyhl1531 {
		yyb1531 = yyj1531 > l
	} else {
		yyb1531 = r.CheckBreak()
	}
	if yyb1531 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv1532 := &x.Limits
		yyv1532.CodecDecodeSelf(d)
	}
	yyj1531++
	if yyhl1531 {
		yyb1531 = yyj1531 > l
	} else {
		yyb1531 = r.CheckBreak()
	}
	if yyb1531 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv1533 := &x.Requests
		yyv1533.CodecDecodeSelf(d)
	}
	for {
		yyj1531++
		if yyhl1531 {
			yyb1531 = yyj1531 > l
		} else {
			yyb1531 = r.CheckBreak()
		}
		if yyb1531 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1531-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1534 := z.EncBinary()
		_ = yym1534
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1535 := !z.EncBinary()
			yy2arr1535 := z.EncBasicHandle().StructToArray
			var yyq1535 [18]bool
			_, _, _ = yysep1535, yyq1535, yy2arr1535
			const yyr1535 bool = false
			yyq1535[2] = len(x.Command) != 0
			yyq1535[3] = len(x.Args) != 0
			yyq1535[4] = x.WorkingDir != ""
			yyq1535[5] = len(x.Ports) != 0
			yyq1535[6] = len(x.Env) != 0
			yyq1535[7] = true
			yyq1535[8] = len(x.VolumeMounts) != 0
			yyq1535[9] = x.LivenessProbe != nil
			yyq1535[10] = x.ReadinessProbe != nil
			yyq1535[11] = x.Lifecycle != nil
			yyq1535[12] = x.TerminationMessagePath != ""
			yyq1535[14] = x.SecurityContext != nil
			yyq1535[15] = x.Stdin != false
			yyq1535[16] = x.StdinOnce != false
			yyq1535[17] = x.TTY != false
			var yynn1535 int
			if yyr1535 || yy2arr1535 {
				r.EncodeArrayStart(18)
			} else {
				yynn1535 = 3
				for _, b := range yyq1535 {
					if b {
						yynn1535++
					}
				}
				r.EncodeMapStart(yynn1535)
				yynn1535 = 0
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1537 := z.EncBinary()
				_ = yym1537
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1538 := z.EncBinary()
				_ = yym1538
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1540 := z.EncBinary()
				_ = yym1540
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1541 := z.EncBinary()
				_ = yym1541
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1543 := z.EncBinary()
						_ = yym1543
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym1544 := z.EncBinary()
						_ = yym1544
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1546 := z.EncBinary()
						_ = yym1546
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym1547 := z.EncBinary()
						_ = yym1547
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[4] {
					yym1549 := z.EncBinary()
					_ = yym1549
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1535[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1550 := z.EncBinary()
					_ = yym1550
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1552 := z.EncBinary()
						_ = yym1552
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1553 := z.EncBinary()
						_ = yym1553
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[6] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1555 := z.EncBinary()
						_ = yym1555
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym1556 := z.EncBinary()
						_ = yym1556
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[7] {
					yy1558 := &x.Resources
					yy1558.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1559 := &x.Resources
					yy1559.CodecEncodeSelf(e)
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[8] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1561 := z.EncBinary()
						_ = yym1561
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym1562 := z.EncBinary()
						_ = yym1562
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[9] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[10] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[11] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[12] {
					yym1567 := z.EncBinary()
					_ = yym1567
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1535[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1568 := z.EncBinary()
					_ = yym1568
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.ImagePullPolicy.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.ImagePullPolicy.CodecEncodeSelf(e)
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[14] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1535[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[15] {
					yym1572 := z.EncBinary()
					_ = yym1572
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1535[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1573 := z.EncBinary()
					_ = yym1573
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[16] {
					yym1575 := z.EncBinary()
					_ = yym1575
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1535[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1576 := z.EncBinary()
					_ = yym1576
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1535[17] {
					yym1578 := z.EncBinary()
					_ = yym1578
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1535[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1579 := z.EncBinary()
					_ = yym1579
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr1535 || yy2arr1535 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1580 := z.DecBinary()
	_ = yym1580
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1581 := r.ContainerType()
		if yyct1581 == codecSelferValueTypeMap1234 {
			yyl1581 := r.ReadMapStart()
			if yyl1581 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1581, d)
			}
		} else if yyct1581 == codecSelferValueTypeArray1234 {
			yyl1581 := r.ReadArrayStart()
			if yyl1581 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1581, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1582Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1582Slc
	var yyhl1582 bool = l >= 0
	for yyj1582 := 0; ; yyj1582++ {
		if yyhl1582 {
			if yyj1582 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1582Slc = r.DecodeBytes(yys1582Slc, true, true)
		yys1582 := string(yys1582Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1582 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv1585 := &x.Command
				yym1586 := z.DecBinary()
				_ = yym1586
				if false {
				} else {
					z.F.DecSliceStringX(yyv1585, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv1587 := &x.Args
				yym1588 := z.DecBinary()
				_ = yym1588
				if false {
				} else {
					z.F.DecSliceStringX(yyv1587, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				x.WorkingDir = string(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1590 := &x.Ports
				yym1591 := z.DecBinary()
				_ = yym1591
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv1590), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv1592 := &x.Env
				yym1593 := z.DecBinary()
				_ = yym1593
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv1592), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv1594 := &x.Resources
				yyv1594.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv1595 := &x.VolumeMounts
				yym1596 := z.DecBinary()
				_ = yym1596
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv1595), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				x.TerminationMessagePath = string(r.DecodeString())
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				x.ImagePullPolicy = PullPolicy(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				x.Stdin = bool(r.DecodeBool())
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				x.StdinOnce = bool(r.DecodeBool())
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				x.TTY = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1582)
		} // end switch yys1582
	} // end for yyj1582
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1606 int
	var yyb1606 bool
	var yyhl1606 bool = l >= 0
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv1609 := &x.Command
		yym1610 := z.DecBinary()
		_ = yym1610
		if false {
		} else {
			z.F.DecSliceStringX(yyv1609, false, d)
		}
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv1611 := &x.Args
		yym1612 := z.DecBinary()
		_ = yym1612
		if false {
		} else {
			z.F.DecSliceStringX(yyv1611, false, d)
		}
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		x.WorkingDir = string(r.DecodeString())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1614 := &x.Ports
		yym1615 := z.DecBinary()
		_ = yym1615
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv1614), d)
		}
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv1616 := &x.Env
		yym1617 := z.DecBinary()
		_ = yym1617
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv1616), d)
		}
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv1618 := &x.Resources
		yyv1618.CodecDecodeSelf(d)
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv1619 := &x.VolumeMounts
		yym1620 := z.DecBinary()
		_ = yym1620
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv1619), d)
		}
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		x.TerminationMessagePath = string(r.DecodeString())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		x.ImagePullPolicy = PullPolicy(r.DecodeString())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		x.Stdin = bool(r.DecodeBool())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		x.StdinOnce = bool(r.DecodeBool())
	}
	yyj1606++
	if yyhl1606 {
		yyb1606 = yyj1606 > l
	} else {
		yyb1606 = r.CheckBreak()
	}
	if yyb1606 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		x.TTY = bool(r.DecodeBool())
	}
	for {
		yyj1606++
		if yyhl1606 {
			yyb1606 = yyj1606 > l
		} else {
			yyb1606 = r.CheckBreak()
		}
		if yyb1606 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1606-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1630 := z.EncBinary()
		_ = yym1630
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1631 := !z.EncBinary()
			yy2arr1631 := z.EncBasicHandle().StructToArray
			var yyq1631 [3]bool
			_, _, _ = yysep1631, yyq1631, yy2arr1631
			const yyr1631 bool = false
			yyq1631[0] = x.Exec != nil
			yyq1631[1] = x.HTTPGet != nil
			yyq1631[2] = x.TCPSocket != nil
			var yynn1631 int
			if yyr1631 || yy2arr1631 {
				r.EncodeArrayStart(3)
			} else {
				yynn1631 = 0
				for _, b := range yyq1631 {
					if b {
						yynn1631++
					}
				}
				r.EncodeMapStart(yynn1631)
				yynn1631 = 0
			}
			if yyr1631 || yy2arr1631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1631[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1631[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1631 || yy2arr1631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1631[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1631[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1631 || yy2arr1631 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1631[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1631[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1631 || yy2arr1631 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1635 := z.DecBinary()
	_ = yym1635
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1636 := r.ContainerType()
		if yyct1636 == codecSelferValueTypeMap1234 {
			yyl1636 := r.ReadMapStart()
			if yyl1636 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1636, d)
			}
		} else if yyct1636 == codecSelferValueTypeArray1234 {
			yyl1636 := r.ReadArrayStart()
			if yyl1636 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1636, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1637Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1637Slc
	var yyhl1637 bool = l >= 0
	for yyj1637 := 0; ; yyj1637++ {
		if yyhl1637 {
			if yyj1637 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1637Slc = r.DecodeBytes(yys1637Slc, true, true)
		yys1637 := string(yys1637Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1637 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1637)
		} // end switch yys1637
	} // end for yyj1637
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1641 int
	var yyb1641 bool
	var yyhl1641 bool = l >= 0
	yyj1641++
	if yyhl1641 {
		yyb1641 = yyj1641 > l
	} else {
		yyb1641 = r.CheckBreak()
	}
	if yyb1641 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj1641++
	if yyhl1641 {
		yyb1641 = yyj1641 > l
	} else {
		yyb1641 = r.CheckBreak()
	}
	if yyb1641 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj1641++
	if yyhl1641 {
		yyb1641 = yyj1641 > l
	} else {
		yyb1641 = r.CheckBreak()
	}
	if yyb1641 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj1641++
		if yyhl1641 {
			yyb1641 = yyj1641 > l
		} else {
			yyb1641 = r.CheckBreak()
		}
		if yyb1641 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1641-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1645 := z.EncBinary()
		_ = yym1645
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1646 := !z.EncBinary()
			yy2arr1646 := z.EncBasicHandle().StructToArray
			var yyq1646 [2]bool
			_, _, _ = yysep1646, yyq1646, yy2arr1646
			const yyr1646 bool = false
			yyq1646[0] = x.PostStart != nil
			yyq1646[1] = x.PreStop != nil
			var yynn1646 int
			if yyr1646 || yy2arr1646 {
				r.EncodeArrayStart(2)
			} else {
				yynn1646 = 0
				for _, b := range yyq1646 {
					if b {
						yynn1646++
					}
				}
				r.EncodeMapStart(yynn1646)
				yynn1646 = 0
			}
			if yyr1646 || yy2arr1646 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1646[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1646[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1646 || yy2arr1646 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1646[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1646[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1646 || yy2arr1646 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1649 := z.DecBinary()
	_ = yym1649
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1650 := r.ContainerType()
		if yyct1650 == codecSelferValueTypeMap1234 {
			yyl1650 := r.ReadMapStart()
			if yyl1650 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1650, d)
			}
		} else if yyct1650 == codecSelferValueTypeArray1234 {
			yyl1650 := r.ReadArrayStart()
			if yyl1650 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1650, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1651Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1651Slc
	var yyhl1651 bool = l >= 0
	for yyj1651 := 0; ; yyj1651++ {
		if yyhl1651 {
			if yyj1651 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1651Slc = r.DecodeBytes(yys1651Slc, true, true)
		yys1651 := string(yys1651Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1651 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1651)
		} // end switch yys1651
	} // end for yyj1651
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1654 int
	var yyb1654 bool
	var yyhl1654 bool = l >= 0
	yyj1654++
	if yyhl1654 {
		yyb1654 = yyj1654 > l
	} else {
		yyb1654 = r.CheckBreak()
	}
	if yyb1654 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj1654++
	if yyhl1654 {
		yyb1654 = yyj1654 > l
	} else {
		yyb1654 = r.CheckBreak()
	}
	if yyb1654 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj1654++
		if yyhl1654 {
			yyb1654 = yyj1654 > l
		} else {
			yyb1654 = r.CheckBreak()
		}
		if yyb1654 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1654-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1657 := z.EncBinary()
	_ = yym1657
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1658 := z.DecBinary()
	_ = yym1658
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1659 := z.EncBinary()
		_ = yym1659
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1660 := !z.EncBinary()
			yy2arr1660 := z.EncBasicHandle().StructToArray
			var yyq1660 [2]bool
			_, _, _ = yysep1660, yyq1660, yy2arr1660
			const yyr1660 bool = false
			yyq1660[0] = x.Reason != ""
			yyq1660[1] = x.Message != ""
			var yynn1660 int
			if yyr1660 || yy2arr1660 {
				r.EncodeArrayStart(2)
			} else {
				yynn1660 = 0
				for _, b := range yyq1660 {
					if b {
						yynn1660++
					}
				}
				r.EncodeMapStart(yynn1660)
				yynn1660 = 0
			}
			if yyr1660 || yy2arr1660 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1660[0] {
					yym1662 := z.EncBinary()
					_ = yym1662
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1660[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1663 := z.EncBinary()
					_ = yym1663
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1660 || yy2arr1660 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1660[1] {
					yym1665 := z.EncBinary()
					_ = yym1665
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1660[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1666 := z.EncBinary()
					_ = yym1666
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1660 || yy2arr1660 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1667 := z.DecBinary()
	_ = yym1667
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1668 := r.ContainerType()
		if yyct1668 == codecSelferValueTypeMap1234 {
			yyl1668 := r.ReadMapStart()
			if yyl1668 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1668, d)
			}
		} else if yyct1668 == codecSelferValueTypeArray1234 {
			yyl1668 := r.ReadArrayStart()
			if yyl1668 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1668, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1669Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1669Slc
	var yyhl1669 bool = l >= 0
	for yyj1669 := 0; ; yyj1669++ {
		if yyhl1669 {
			if yyj1669 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1669Slc = r.DecodeBytes(yys1669Slc, true, true)
		yys1669 := string(yys1669Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1669 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1669)
		} // end switch yys1669
	} // end for yyj1669
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1672 int
	var yyb1672 bool
	var yyhl1672 bool = l >= 0
	yyj1672++
	if yyhl1672 {
		yyb1672 = yyj1672 > l
	} else {
		yyb1672 = r.CheckBreak()
	}
	if yyb1672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1672++
	if yyhl1672 {
		yyb1672 = yyj1672 > l
	} else {
		yyb1672 = r.CheckBreak()
	}
	if yyb1672 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1672++
		if yyhl1672 {
			yyb1672 = yyj1672 > l
		} else {
			yyb1672 = r.CheckBreak()
		}
		if yyb1672 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1672-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1675 := z.EncBinary()
		_ = yym1675
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1676 := !z.EncBinary()
			yy2arr1676 := z.EncBasicHandle().StructToArray
			var yyq1676 [1]bool
			_, _, _ = yysep1676, yyq1676, yy2arr1676
			const yyr1676 bool = false
			yyq1676[0] = true
			var yynn1676 int
			if yyr1676 || yy2arr1676 {
				r.EncodeArrayStart(1)
			} else {
				yynn1676 = 0
				for _, b := range yyq1676 {
					if b {
						yynn1676++
					}
				}
				r.EncodeMapStart(yynn1676)
				yynn1676 = 0
			}
			if yyr1676 || yy2arr1676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1676[0] {
					yy1678 := &x.StartedAt
					yym1679 := z.EncBinary()
					_ = yym1679
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1678) {
					} else if yym1679 {
						z.EncBinaryMarshal(yy1678)
					} else if !yym1679 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1678)
					} else {
						z.EncFallback(yy1678)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1676[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1680 := &x.StartedAt
					yym1681 := z.EncBinary()
					_ = yym1681
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1680) {
					} else if yym1681 {
						z.EncBinaryMarshal(yy1680)
					} else if !yym1681 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1680)
					} else {
						z.EncFallback(yy1680)
					}
				}
			}
			if yyr1676 || yy2arr1676 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1682 := z.DecBinary()
	_ = yym1682
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1683 := r.ContainerType()
		if yyct1683 == codecSelferValueTypeMap1234 {
			yyl1683 := r.ReadMapStart()
			if yyl1683 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1683, d)
			}
		} else if yyct1683 == codecSelferValueTypeArray1234 {
			yyl1683 := r.ReadArrayStart()
			if yyl1683 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1683, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1684Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1684Slc
	var yyhl1684 bool = l >= 0
	for yyj1684 := 0; ; yyj1684++ {
		if yyhl1684 {
			if yyj1684 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1684Slc = r.DecodeBytes(yys1684Slc, true, true)
		yys1684 := string(yys1684Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1684 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1685 := &x.StartedAt
				yym1686 := z.DecBinary()
				_ = yym1686
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1685) {
				} else if yym1686 {
					z.DecBinaryUnmarshal(yyv1685)
				} else if !yym1686 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1685)
				} else {
					z.DecFallback(yyv1685, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1684)
		} // end switch yys1684
	} // end for yyj1684
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1687 int
	var yyb1687 bool
	var yyhl1687 bool = l >= 0
	yyj1687++
	if yyhl1687 {
		yyb1687 = yyj1687 > l
	} else {
		yyb1687 = r.CheckBreak()
	}
	if yyb1687 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1688 := &x.StartedAt
		yym1689 := z.DecBinary()
		_ = yym1689
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1688) {
		} else if yym1689 {
			z.DecBinaryUnmarshal(yyv1688)
		} else if !yym1689 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1688)
		} else {
			z.DecFallback(yyv1688, false)
		}
	}
	for {
		yyj1687++
		if yyhl1687 {
			yyb1687 = yyj1687 > l
		} else {
			yyb1687 = r.CheckBreak()
		}
		if yyb1687 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1687-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1690 := z.EncBinary()
		_ = yym1690
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1691 := !z.EncBinary()
			yy2arr1691 := z.EncBasicHandle().StructToArray
			var yyq1691 [7]bool
			_, _, _ = yysep1691, yyq1691, yy2arr1691
			const yyr1691 bool = false
			yyq1691[1] = x.Signal != 0
			yyq1691[2] = x.Reason != ""
			yyq1691[3] = x.Message != ""
			yyq1691[4] = true
			yyq1691[5] = true
			yyq1691[6] = x.ContainerID != ""
			var yynn1691 int
			if yyr1691 || yy2arr1691 {
				r.EncodeArrayStart(7)
			} else {
				yynn1691 = 1
				for _, b := range yyq1691 {
					if b {
						yynn1691++
					}
				}
				r.EncodeMapStart(yynn1691)
				yynn1691 = 0
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1693 := z.EncBinary()
				_ = yym1693
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1694 := z.EncBinary()
				_ = yym1694
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1691[1] {
					yym1696 := z.EncBinary()
					_ = yym1696
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1691[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1697 := z.EncBinary()
					_ = yym1697
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1691[2] {
					yym1699 := z.EncBinary()
					_ = yym1699
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1691[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1700 := z.EncBinary()
					_ = yym1700
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1691[3] {
					yym1702 := z.EncBinary()
					_ = yym1702
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1691[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1703 := z.EncBinary()
					_ = yym1703
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1691[4] {
					yy1705 := &x.StartedAt
					yym1706 := z.EncBinary()
					_ = yym1706
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1705) {
					} else if yym1706 {
						z.EncBinaryMarshal(yy1705)
					} else if !yym1706 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1705)
					} else {
						z.EncFallback(yy1705)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1691[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1707 := &x.StartedAt
					yym1708 := z.EncBinary()
					_ = yym1708
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1707) {
					} else if yym1708 {
						z.EncBinaryMarshal(yy1707)
					} else if !yym1708 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1707)
					} else {
						z.EncFallback(yy1707)
					}
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1691[5] {
					yy1710 := &x.FinishedAt
					yym1711 := z.EncBinary()
					_ = yym1711
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1710) {
					} else if yym1711 {
						z.EncBinaryMarshal(yy1710)
					} else if !yym1711 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1710)
					} else {
						z.EncFallback(yy1710)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1691[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1712 := &x.FinishedAt
					yym1713 := z.EncBinary()
					_ = yym1713
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1712) {
					} else if yym1713 {
						z.EncBinaryMarshal(yy1712)
					} else if !yym1713 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1712)
					} else {
						z.EncFallback(yy1712)
					}
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1691[6] {
					yym1715 := z.EncBinary()
					_ = yym1715
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1691[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1716 := z.EncBinary()
					_ = yym1716
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1691 || yy2arr1691 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1717 := z.DecBinary()
	_ = yym1717
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1718 := r.ContainerType()
		if yyct1718 == codecSelferValueTypeMap1234 {
			yyl1718 := r.ReadMapStart()
			if yyl1718 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1718, d)
			}
		} else if yyct1718 == codecSelferValueTypeArray1234 {
			yyl1718 := r.ReadArrayStart()
			if yyl1718 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1718, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1719Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1719Slc
	var yyhl1719 bool = l >= 0
	for yyj1719 := 0; ; yyj1719++ {
		if yyhl1719 {
			if yyj1719 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1719Slc = r.DecodeBytes(yys1719Slc, true, true)
		yys1719 := string(yys1719Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1719 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				x.ExitCode = int32(r.DecodeInt(32))
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				x.Signal = int32(r.DecodeInt(32))
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_unversioned.Time{}
			} else {
				yyv1724 := &x.StartedAt
				yym1725 := z.DecBinary()
				_ = yym1725
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1724) {
				} else if yym1725 {
					z.DecBinaryUnmarshal(yyv1724)
				} else if !yym1725 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1724)
				} else {
					z.DecFallback(yyv1724, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_unversioned.Time{}
			} else {
				yyv1726 := &x.FinishedAt
				yym1727 := z.DecBinary()
				_ = yym1727
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1726) {
				} else if yym1727 {
					z.DecBinaryUnmarshal(yyv1726)
				} else if !yym1727 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1726)
				} else {
					z.DecFallback(yyv1726, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1719)
		} // end switch yys1719
	} // end for yyj1719
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1729 int
	var yyb1729 bool
	var yyhl1729 bool = l >= 0
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		x.ExitCode = int32(r.DecodeInt(32))
	}
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		x.Signal = int32(r.DecodeInt(32))
	}
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_unversioned.Time{}
	} else {
		yyv1734 := &x.StartedAt
		yym1735 := z.DecBinary()
		_ = yym1735
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1734) {
		} else if yym1735 {
			z.DecBinaryUnmarshal(yyv1734)
		} else if !yym1735 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1734)
		} else {
			z.DecFallback(yyv1734, false)
		}
	}
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_unversioned.Time{}
	} else {
		yyv1736 := &x.FinishedAt
		yym1737 := z.DecBinary()
		_ = yym1737
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1736) {
		} else if yym1737 {
			z.DecBinaryUnmarshal(yyv1736)
		} else if !yym1737 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1736)
		} else {
			z.DecFallback(yyv1736, false)
		}
	}
	yyj1729++
	if yyhl1729 {
		yyb1729 = yyj1729 > l
	} else {
		yyb1729 = r.CheckBreak()
	}
	if yyb1729 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1729++
		if yyhl1729 {
			yyb1729 = yyj1729 > l
		} else {
			yyb1729 = r.CheckBreak()
		}
		if yyb1729 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1729-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1739 := z.EncBinary()
		_ = yym1739
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1740 := !z.EncBinary()
			yy2arr1740 := z.EncBasicHandle().StructToArray
			var yyq1740 [3]bool
			_, _, _ = yysep1740, yyq1740, yy2arr1740
			const yyr1740 bool = false
			yyq1740[0] = x.Waiting != nil
			yyq1740[1] = x.Running != nil
			yyq1740[2] = x.Terminated != nil
			var yynn1740 int
			if yyr1740 || yy2arr1740 {
				r.EncodeArrayStart(3)
			} else {
				yynn1740 = 0
				for _, b := range yyq1740 {
					if b {
						yynn1740++
					}
				}
				r.EncodeMapStart(yynn1740)
				yynn1740 = 0
			}
			if yyr1740 || yy2arr1740 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1740[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1740[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1740 || yy2arr1740 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1740[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1740[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1740 || yy2arr1740 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1740[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1740[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1740 || yy2arr1740 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1744 := z.DecBinary()
	_ = yym1744
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1745 := r.ContainerType()
		if yyct1745 == codecSelferValueTypeMap1234 {
			yyl1745 := r.ReadMapStart()
			if yyl1745 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1745, d)
			}
		} else if yyct1745 == codecSelferValueTypeArray1234 {
			yyl1745 := r.ReadArrayStart()
			if yyl1745 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1745, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1746Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1746Slc
	var yyhl1746 bool = l >= 0
	for yyj1746 := 0; ; yyj1746++ {
		if yyhl1746 {
			if yyj1746 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1746Slc = r.DecodeBytes(yys1746Slc, true, true)
		yys1746 := string(yys1746Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1746 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1746)
		} // end switch yys1746
	} // end for yyj1746
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1750 int
	var yyb1750 bool
	var yyhl1750 bool = l >= 0
	yyj1750++
	if yyhl1750 {
		yyb1750 = yyj1750 > l
	} else {
		yyb1750 = r.CheckBreak()
	}
	if yyb1750 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj1750++
	if yyhl1750 {
		yyb1750 = yyj1750 > l
	} else {
		yyb1750 = r.CheckBreak()
	}
	if yyb1750 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj1750++
	if yyhl1750 {
		yyb1750 = yyj1750 > l
	} else {
		yyb1750 = r.CheckBreak()
	}
	if yyb1750 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj1750++
		if yyhl1750 {
			yyb1750 = yyj1750 > l
		} else {
			yyb1750 = r.CheckBreak()
		}
		if yyb1750 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1750-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1754 := z.EncBinary()
		_ = yym1754
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1755 := !z.EncBinary()
			yy2arr1755 := z.EncBasicHandle().StructToArray
			var yyq1755 [8]bool
			_, _, _ = yysep1755, yyq1755, yy2arr1755
			const yyr1755 bool = false
			yyq1755[1] = true
			yyq1755[2] = true
			yyq1755[7] = x.ContainerID != ""
			var yynn1755 int
			if yyr1755 || yy2arr1755 {
				r.EncodeArrayStart(8)
			} else {
				yynn1755 = 5
				for _, b := range yyq1755 {
					if b {
						yynn1755++
					}
				}
				r.EncodeMapStart(yynn1755)
				yynn1755 = 0
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1757 := z.EncBinary()
				_ = yym1757
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1758 := z.EncBinary()
				_ = yym1758
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1755[1] {
					yy1760 := &x.State
					yy1760.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1755[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1761 := &x.State
					yy1761.CodecEncodeSelf(e)
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1755[2] {
					yy1763 := &x.LastTerminationState
					yy1763.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1755[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1764 := &x.LastTerminationState
					yy1764.CodecEncodeSelf(e)
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1766 := z.EncBinary()
				_ = yym1766
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1767 := z.EncBinary()
				_ = yym1767
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1769 := z.EncBinary()
				_ = yym1769
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1770 := z.EncBinary()
				_ = yym1770
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1772 := z.EncBinary()
				_ = yym1772
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1773 := z.EncBinary()
				_ = yym1773
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1775 := z.EncBinary()
				_ = yym1775
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1776 := z.EncBinary()
				_ = yym1776
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1755[7] {
					yym1778 := z.EncBinary()
					_ = yym1778
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1755[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1779 := z.EncBinary()
					_ = yym1779
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr1755 || yy2arr1755 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1780 := z.DecBinary()
	_ = yym1780
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1781 := r.ContainerType()
		if yyct1781 == codecSelferValueTypeMap1234 {
			yyl1781 := r.ReadMapStart()
			if yyl1781 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1781, d)
			}
		} else if yyct1781 == codecSelferValueTypeArray1234 {
			yyl1781 := r.ReadArrayStart()
			if yyl1781 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1781, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1782Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1782Slc
	var yyhl1782 bool = l >= 0
	for yyj1782 := 0; ; yyj1782++ {
		if yyhl1782 {
			if yyj1782 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1782Slc = r.DecodeBytes(yys1782Slc, true, true)
		yys1782 := string(yys1782Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1782 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv1784 := &x.State
				yyv1784.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv1785 := &x.LastTerminationState
				yyv1785.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				x.Ready = bool(r.DecodeBool())
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				x.RestartCount = int32(r.DecodeInt(32))
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				x.Image = string(r.DecodeString())
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				x.ImageID = string(r.DecodeString())
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				x.ContainerID = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1782)
		} // end switch yys1782
	} // end for yyj1782
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1791 int
	var yyb1791 bool
	var yyhl1791 bool = l >= 0
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv1793 := &x.State
		yyv1793.CodecDecodeSelf(d)
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv1794 := &x.LastTerminationState
		yyv1794.CodecDecodeSelf(d)
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		x.Ready = bool(r.DecodeBool())
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		x.RestartCount = int32(r.DecodeInt(32))
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		x.Image = string(r.DecodeString())
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		x.ImageID = string(r.DecodeString())
	}
	yyj1791++
	if yyhl1791 {
		yyb1791 = yyj1791 > l
	} else {
		yyb1791 = r.CheckBreak()
	}
	if yyb1791 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		x.ContainerID = string(r.DecodeString())
	}
	for {
		yyj1791++
		if yyhl1791 {
			yyb1791 = yyj1791 > l
		} else {
			yyb1791 = r.CheckBreak()
		}
		if yyb1791 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1791-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1800 := z.EncBinary()
	_ = yym1800
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1801 := z.DecBinary()
	_ = yym1801
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1802 := z.EncBinary()
	_ = yym1802
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1803 := z.DecBinary()
	_ = yym1803
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1804 := z.EncBinary()
		_ = yym1804
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1805 := !z.EncBinary()
			yy2arr1805 := z.EncBasicHandle().StructToArray
			var yyq1805 [6]bool
			_, _, _ = yysep1805, yyq1805, yy2arr1805
			const yyr1805 bool = false
			yyq1805[2] = true
			yyq1805[3] = true
			yyq1805[4] = x.Reason != ""
			yyq1805[5] = x.Message != ""
			var yynn1805 int
			if yyr1805 || yy2arr1805 {
				r.EncodeArrayStart(6)
			} else {
				yynn1805 = 2
				for _, b := range yyq1805 {
					if b {
						yynn1805++
					}
				}
				r.EncodeMapStart(yynn1805)
				yynn1805 = 0
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1805[2] {
					yy1809 := &x.LastProbeTime
					yym1810 := z.EncBinary()
					_ = yym1810
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1809) {
					} else if yym1810 {
						z.EncBinaryMarshal(yy1809)
					} else if !yym1810 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1809)
					} else {
						z.EncFallback(yy1809)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1805[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1811 := &x.LastProbeTime
					yym1812 := z.EncBinary()
					_ = yym1812
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1811) {
					} else if yym1812 {
						z.EncBinaryMarshal(yy1811)
					} else if !yym1812 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1811)
					} else {
						z.EncFallback(yy1811)
					}
				}
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1805[3] {
					yy1814 := &x.LastTransitionTime
					yym1815 := z.EncBinary()
					_ = yym1815
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1814) {
					} else if yym1815 {
						z.EncBinaryMarshal(yy1814)
					} else if !yym1815 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1814)
					} else {
						z.EncFallback(yy1814)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1805[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1816 := &x.LastTransitionTime
					yym1817 := z.EncBinary()
					_ = yym1817
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1816) {
					} else if yym1817 {
						z.EncBinaryMarshal(yy1816)
					} else if !yym1817 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1816)
					} else {
						z.EncFallback(yy1816)
					}
				}
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1805[4] {
					yym1819 := z.EncBinary()
					_ = yym1819
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1805[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1820 := z.EncBinary()
					_ = yym1820
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1805[5] {
					yym1822 := z.EncBinary()
					_ = yym1822
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1805[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1823 := z.EncBinary()
					_ = yym1823
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1805 || yy2arr1805 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1824 := z.DecBinary()
	_ = yym1824
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1825 := r.ContainerType()
		if yyct1825 == codecSelferValueTypeMap1234 {
			yyl1825 := r.ReadMapStart()
			if yyl1825 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1825, d)
			}
		} else if yyct1825 == codecSelferValueTypeArray1234 {
			yyl1825 := r.ReadArrayStart()
			if yyl1825 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1825, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1826Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1826Slc
	var yyhl1826 bool = l >= 0
	for yyj1826 := 0; ; yyj1826++ {
		if yyhl1826 {
			if yyj1826 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1826Slc = r.DecodeBytes(yys1826Slc, true, true)
		yys1826 := string(yys1826Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1826 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = PodConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_unversioned.Time{}
			} else {
				yyv1829 := &x.LastProbeTime
				yym1830 := z.DecBinary()
				_ = yym1830
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1829) {
				} else if yym1830 {
					z.DecBinaryUnmarshal(yyv1829)
				} else if !yym1830 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1829)
				} else {
					z.DecFallback(yyv1829, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv1831 := &x.LastTransitionTime
				yym1832 := z.DecBinary()
				_ = yym1832
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1831) {
				} else if yym1832 {
					z.DecBinaryUnmarshal(yyv1831)
				} else if !yym1832 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1831)
				} else {
					z.DecFallback(yyv1831, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1826)
		} // end switch yys1826
	} // end for yyj1826
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1835 int
	var yyb1835 bool
	var yyhl1835 bool = l >= 0
	yyj1835++
	if yyhl1835 {
		yyb1835 = yyj1835 > l
	} else {
		yyb1835 = r.CheckBreak()
	}
	if yyb1835 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = PodConditionType(r.DecodeString())
	}
	yyj1835++
	if yyhl1835 {
		yyb1835 = yyj1835 > l
	} else {
		yyb1835 = r.CheckBreak()
	}
	if yyb1835 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj1835++
	if yyhl1835 {
		yyb1835 = yyj1835 > l
	} else {
		yyb1835 = r.CheckBreak()
	}
	if yyb1835 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_unversioned.Time{}
	} else {
		yyv1838 := &x.LastProbeTime
		yym1839 := z.DecBinary()
		_ = yym1839
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1838) {
		} else if yym1839 {
			z.DecBinaryUnmarshal(yyv1838)
		} else if !yym1839 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1838)
		} else {
			z.DecFallback(yyv1838, false)
		}
	}
	yyj1835++
	if yyhl1835 {
		yyb1835 = yyj1835 > l
	} else {
		yyb1835 = r.CheckBreak()
	}
	if yyb1835 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv1840 := &x.LastTransitionTime
		yym1841 := z.DecBinary()
		_ = yym1841
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1840) {
		} else if yym1841 {
			z.DecBinaryUnmarshal(yyv1840)
		} else if !yym1841 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1840)
		} else {
			z.DecFallback(yyv1840, false)
		}
	}
	yyj1835++
	if yyhl1835 {
		yyb1835 = yyj1835 > l
	} else {
		yyb1835 = r.CheckBreak()
	}
	if yyb1835 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1835++
	if yyhl1835 {
		yyb1835 = yyj1835 > l
	} else {
		yyb1835 = r.CheckBreak()
	}
	if yyb1835 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1835++
		if yyhl1835 {
			yyb1835 = yyj1835 > l
		} else {
			yyb1835 = r.CheckBreak()
		}
		if yyb1835 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1835-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1844 := z.EncBinary()
	_ = yym1844
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1845 := z.DecBinary()
	_ = yym1845
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1846 := z.EncBinary()
		_ = yym1846
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1847 := !z.EncBinary()
			yy2arr1847 := z.EncBasicHandle().StructToArray
			var yyq1847 [4]bool
			_, _, _ = yysep1847, yyq1847, yy2arr1847
			const yyr1847 bool = false
			yyq1847[0] = x.Kind != ""
			yyq1847[1] = x.APIVersion != ""
			yyq1847[2] = true
			var yynn1847 int
			if yyr1847 || yy2arr1847 {
				r.EncodeArrayStart(4)
			} else {
				yynn1847 = 1
				for _, b := range yyq1847 {
					if b {
						yynn1847++
					}
				}
				r.EncodeMapStart(yynn1847)
				yynn1847 = 0
			}
			if yyr1847 || yy2arr1847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1847[0] {
					yym1849 := z.EncBinary()
					_ = yym1849
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1847[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1850 := z.EncBinary()
					_ = yym1850
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1847 || yy2arr1847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1847[1] {
					yym1852 := z.EncBinary()
					_ = yym1852
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1847[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1853 := z.EncBinary()
					_ = yym1853
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1847 || yy2arr1847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1847[2] {
					yy1855 := &x.ListMeta
					yym1856 := z.EncBinary()
					_ = yym1856
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1855) {
					} else {
						z.EncFallback(yy1855)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1847[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1857 := &x.ListMeta
					yym1858 := z.EncBinary()
					_ = yym1858
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1857) {
					} else {
						z.EncFallback(yy1857)
					}
				}
			}
			if yyr1847 || yy2arr1847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1860 := z.EncBinary()
					_ = yym1860
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1861 := z.EncBinary()
					_ = yym1861
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr1847 || yy2arr1847 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1862 := z.DecBinary()
	_ = yym1862
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1863 := r.ContainerType()
		if yyct1863 == codecSelferValueTypeMap1234 {
			yyl1863 := r.ReadMapStart()
			if yyl1863 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1863, d)
			}
		} else if yyct1863 == codecSelferValueTypeArray1234 {
			yyl1863 := r.ReadArrayStart()
			if yyl1863 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1863, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1864Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1864Slc
	var yyhl1864 bool = l >= 0
	for yyj1864 := 0; ; yyj1864++ {
		if yyhl1864 {
			if yyj1864 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1864Slc = r.DecodeBytes(yys1864Slc, true, true)
		yys1864 := string(yys1864Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1864 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv1867 := &x.ListMeta
				yym1868 := z.DecBinary()
				_ = yym1868
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1867) {
				} else {
					z.DecFallback(yyv1867, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1869 := &x.Items
				yym1870 := z.DecBinary()
				_ = yym1870
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv1869), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1864)
		} // end switch yys1864
	} // end for yyj1864
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1871 int
	var yyb1871 bool
	var yyhl1871 bool = l >= 0
	yyj1871++
	if yyhl1871 {
		yyb1871 = yyj1871 > l
	} else {
		yyb1871 = r.CheckBreak()
	}
	if yyb1871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1871++
	if yyhl1871 {
		yyb1871 = yyj1871 > l
	} else {
		yyb1871 = r.CheckBreak()
	}
	if yyb1871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1871++
	if yyhl1871 {
		yyb1871 = yyj1871 > l
	} else {
		yyb1871 = r.CheckBreak()
	}
	if yyb1871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv1874 := &x.ListMeta
		yym1875 := z.DecBinary()
		_ = yym1875
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1874) {
		} else {
			z.DecFallback(yyv1874, false)
		}
	}
	yyj1871++
	if yyhl1871 {
		yyb1871 = yyj1871 > l
	} else {
		yyb1871 = r.CheckBreak()
	}
	if yyb1871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1876 := &x.Items
		yym1877 := z.DecBinary()
		_ = yym1877
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv1876), d)
		}
	}
	for {
		yyj1871++
		if yyhl1871 {
			yyb1871 = yyj1871 > l
		} else {
			yyb1871 = r.CheckBreak()
		}
		if yyb1871 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1871-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1878 := z.EncBinary()
	_ = yym1878
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1879 := z.DecBinary()
	_ = yym1879
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1880 := z.EncBinary()
		_ = yym1880
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1881 := !z.EncBinary()
			yy2arr1881 := z.EncBasicHandle().StructToArray
			var yyq1881 [1]bool
			_, _, _ = yysep1881, yyq1881, yy2arr1881
			const yyr1881 bool = false
			var yynn1881 int
			if yyr1881 || yy2arr1881 {
				r.EncodeArrayStart(1)
			} else {
				yynn1881 = 1
				for _, b := range yyq1881 {
					if b {
						yynn1881++
					}
				}
				r.EncodeMapStart(yynn1881)
				yynn1881 = 0
			}
			if yyr1881 || yy2arr1881 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1883 := z.EncBinary()
					_ = yym1883
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSelectorTerms"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym1884 := z.EncBinary()
					_ = yym1884
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			}
			if yyr1881 || yy2arr1881 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1885 := z.DecBinary()
	_ = yym1885
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1886 := r.ContainerType()
		if yyct1886 == codecSelferValueTypeMap1234 {
			yyl1886 := r.ReadMapStart()
			if yyl1886 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1886, d)
			}
		} else if yyct1886 == codecSelferValueTypeArray1234 {
			yyl1886 := r.ReadArrayStart()
			if yyl1886 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1886, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1887Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1887Slc
	var yyhl1887 bool = l >= 0
	for yyj1887 := 0; ; yyj1887++ {
		if yyhl1887 {
			if yyj1887 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1887Slc = r.DecodeBytes(yys1887Slc, true, true)
		yys1887 := string(yys1887Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1887 {
		case "nodeSelectorTerms":
			if r.TryDecodeAsNil() {
				x.NodeSelectorTerms = nil
			} else {
				yyv1888 := &x.NodeSelectorTerms
				yym1889 := z.DecBinary()
				_ = yym1889
				if false {
				} else {
					h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1888), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1887)
		} // end switch yys1887
	} // end for yyj1887
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1890 int
	var yyb1890 bool
	var yyhl1890 bool = l >= 0
	yyj1890++
	if yyhl1890 {
		yyb1890 = yyj1890 > l
	} else {
		yyb1890 = r.CheckBreak()
	}
	if yyb1890 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelectorTerms = nil
	} else {
		yyv1891 := &x.NodeSelectorTerms
		yym1892 := z.DecBinary()
		_ = yym1892
		if false {
		} else {
			h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv1891), d)
		}
	}
	for {
		yyj1890++
		if yyhl1890 {
			yyb1890 = yyj1890 > l
		} else {
			yyb1890 = r.CheckBreak()
		}
		if yyb1890 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1890-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1893 := z.EncBinary()
		_ = yym1893
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1894 := !z.EncBinary()
			yy2arr1894 := z.EncBasicHandle().StructToArray
			var yyq1894 [1]bool
			_, _, _ = yysep1894, yyq1894, yy2arr1894
			const yyr1894 bool = false
			var yynn1894 int
			if yyr1894 || yy2arr1894 {
				r.EncodeArrayStart(1)
			} else {
				yynn1894 = 1
				for _, b := range yyq1894 {
					if b {
						yynn1894++
					}
				}
				r.EncodeMapStart(yynn1894)
				yynn1894 = 0
			}
			if yyr1894 || yy2arr1894 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1896 := z.EncBinary()
					_ = yym1896
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym1897 := z.EncBinary()
					_ = yym1897
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			}
			if yyr1894 || yy2arr1894 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1898 := z.DecBinary()
	_ = yym1898
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1899 := r.ContainerType()
		if yyct1899 == codecSelferValueTypeMap1234 {
			yyl1899 := r.ReadMapStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1899, d)
			}
		} else if yyct1899 == codecSelferValueTypeArray1234 {
			yyl1899 := r.ReadArrayStart()
			if yyl1899 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1899, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1900Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1900Slc
	var yyhl1900 bool = l >= 0
	for yyj1900 := 0; ; yyj1900++ {
		if yyhl1900 {
			if yyj1900 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1900Slc = r.DecodeBytes(yys1900Slc, true, true)
		yys1900 := string(yys1900Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1900 {
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv1901 := &x.MatchExpressions
				yym1902 := z.DecBinary()
				_ = yym1902
				if false {
				} else {
					h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1901), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1900)
		} // end switch yys1900
	} // end for yyj1900
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1903 int
	var yyb1903 bool
	var yyhl1903 bool = l >= 0
	yyj1903++
	if yyhl1903 {
		yyb1903 = yyj1903 > l
	} else {
		yyb1903 = r.CheckBreak()
	}
	if yyb1903 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv1904 := &x.MatchExpressions
		yym1905 := z.DecBinary()
		_ = yym1905
		if false {
		} else {
			h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv1904), d)
		}
	}
	for {
		yyj1903++
		if yyhl1903 {
			yyb1903 = yyj1903 > l
		} else {
			yyb1903 = r.CheckBreak()
		}
		if yyb1903 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1903-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1906 := z.EncBinary()
		_ = yym1906
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1907 := !z.EncBinary()
			yy2arr1907 := z.EncBasicHandle().StructToArray
			var yyq1907 [3]bool
			_, _, _ = yysep1907, yyq1907, yy2arr1907
			const yyr1907 bool = false
			yyq1907[2] = len(x.Values) != 0
			var yynn1907 int
			if yyr1907 || yy2arr1907 {
				r.EncodeArrayStart(3)
			} else {
				yynn1907 = 2
				for _, b := range yyq1907 {
					if b {
						yynn1907++
					}
				}
				r.EncodeMapStart(yynn1907)
				yynn1907 = 0
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1909 := z.EncBinary()
				_ = yym1909
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1910 := z.EncBinary()
				_ = yym1910
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1907[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1913 := z.EncBinary()
						_ = yym1913
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1907[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym1914 := z.EncBinary()
						_ = yym1914
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr1907 || yy2arr1907 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1915 := z.DecBinary()
	_ = yym1915
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1916 := r.ContainerType()
		if yyct1916 == codecSelferValueTypeMap1234 {
			yyl1916 := r.ReadMapStart()
			if yyl1916 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1916, d)
			}
		} else if yyct1916 == codecSelferValueTypeArray1234 {
			yyl1916 := r.ReadArrayStart()
			if yyl1916 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1916, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1917Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1917Slc
	var yyhl1917 bool = l >= 0
	for yyj1917 := 0; ; yyj1917++ {
		if yyhl1917 {
			if yyj1917 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1917Slc = r.DecodeBytes(yys1917Slc, true, true)
		yys1917 := string(yys1917Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1917 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = NodeSelectorOperator(r.DecodeString())
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv1920 := &x.Values
				yym1921 := z.DecBinary()
				_ = yym1921
				if false {
				} else {
					z.F.DecSliceStringX(yyv1920, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1917)
		} // end switch yys1917
	} // end for yyj1917
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1922 int
	var yyb1922 bool
	var yyhl1922 bool = l >= 0
	yyj1922++
	if yyhl1922 {
		yyb1922 = yyj1922 > l
	} else {
		yyb1922 = r.CheckBreak()
	}
	if yyb1922 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj1922++
	if yyhl1922 {
		yyb1922 = yyj1922 > l
	} else {
		yyb1922 = r.CheckBreak()
	}
	if yyb1922 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = NodeSelectorOperator(r.DecodeString())
	}
	yyj1922++
	if yyhl1922 {
		yyb1922 = yyj1922 > l
	} else {
		yyb1922 = r.CheckBreak()
	}
	if yyb1922 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv1925 := &x.Values
		yym1926 := z.DecBinary()
		_ = yym1926
		if false {
		} else {
			z.F.DecSliceStringX(yyv1925, false, d)
		}
	}
	for {
		yyj1922++
		if yyhl1922 {
			yyb1922 = yyj1922 > l
		} else {
			yyb1922 = r.CheckBreak()
		}
		if yyb1922 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1922-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1927 := z.EncBinary()
	_ = yym1927
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1928 := z.DecBinary()
	_ = yym1928
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Affinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1929 := z.EncBinary()
		_ = yym1929
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1930 := !z.EncBinary()
			yy2arr1930 := z.EncBasicHandle().StructToArray
			var yyq1930 [3]bool
			_, _, _ = yysep1930, yyq1930, yy2arr1930
			const yyr1930 bool = false
			yyq1930[0] = x.NodeAffinity != nil
			yyq1930[1] = x.PodAffinity != nil
			yyq1930[2] = x.PodAntiAffinity != nil
			var yynn1930 int
			if yyr1930 || yy2arr1930 {
				r.EncodeArrayStart(3)
			} else {
				yynn1930 = 0
				for _, b := range yyq1930 {
					if b {
						yynn1930++
					}
				}
				r.EncodeMapStart(yynn1930)
				yynn1930 = 0
			}
			if yyr1930 || yy2arr1930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1930[0] {
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1930[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1930 || yy2arr1930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1930[1] {
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1930[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1930 || yy2arr1930 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1930[2] {
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1930[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAntiAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1930 || yy2arr1930 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Affinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1934 := z.DecBinary()
	_ = yym1934
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1935 := r.ContainerType()
		if yyct1935 == codecSelferValueTypeMap1234 {
			yyl1935 := r.ReadMapStart()
			if yyl1935 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1935, d)
			}
		} else if yyct1935 == codecSelferValueTypeArray1234 {
			yyl1935 := r.ReadArrayStart()
			if yyl1935 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1935, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Affinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1936Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1936Slc
	var yyhl1936 bool = l >= 0
	for yyj1936 := 0; ; yyj1936++ {
		if yyhl1936 {
			if yyj1936 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1936Slc = r.DecodeBytes(yys1936Slc, true, true)
		yys1936 := string(yys1936Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1936 {
		case "nodeAffinity":
			if r.TryDecodeAsNil() {
				if x.NodeAffinity != nil {
					x.NodeAffinity = nil
				}
			} else {
				if x.NodeAffinity == nil {
					x.NodeAffinity = new(NodeAffinity)
				}
				x.NodeAffinity.CodecDecodeSelf(d)
			}
		case "podAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAffinity != nil {
					x.PodAffinity = nil
				}
			} else {
				if x.PodAffinity == nil {
					x.PodAffinity = new(PodAffinity)
				}
				x.PodAffinity.CodecDecodeSelf(d)
			}
		case "podAntiAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAntiAffinity != nil {
					x.PodAntiAffinity = nil
				}
			} else {
				if x.PodAntiAffinity == nil {
					x.PodAntiAffinity = new(PodAntiAffinity)
				}
				x.PodAntiAffinity.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1936)
		} // end switch yys1936
	} // end for yyj1936
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Affinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1940 int
	var yyb1940 bool
	var yyhl1940 bool = l >= 0
	yyj1940++
	if yyhl1940 {
		yyb1940 = yyj1940 > l
	} else {
		yyb1940 = r.CheckBreak()
	}
	if yyb1940 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeAffinity != nil {
			x.NodeAffinity = nil
		}
	} else {
		if x.NodeAffinity == nil {
			x.NodeAffinity = new(NodeAffinity)
		}
		x.NodeAffinity.CodecDecodeSelf(d)
	}
	yyj1940++
	if yyhl1940 {
		yyb1940 = yyj1940 > l
	} else {
		yyb1940 = r.CheckBreak()
	}
	if yyb1940 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAffinity != nil {
			x.PodAffinity = nil
		}
	} else {
		if x.PodAffinity == nil {
			x.PodAffinity = new(PodAffinity)
		}
		x.PodAffinity.CodecDecodeSelf(d)
	}
	yyj1940++
	if yyhl1940 {
		yyb1940 = yyj1940 > l
	} else {
		yyb1940 = r.CheckBreak()
	}
	if yyb1940 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAntiAffinity != nil {
			x.PodAntiAffinity = nil
		}
	} else {
		if x.PodAntiAffinity == nil {
			x.PodAntiAffinity = new(PodAntiAffinity)
		}
		x.PodAntiAffinity.CodecDecodeSelf(d)
	}
	for {
		yyj1940++
		if yyhl1940 {
			yyb1940 = yyj1940 > l
		} else {
			yyb1940 = r.CheckBreak()
		}
		if yyb1940 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1940-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1944 := z.EncBinary()
		_ = yym1944
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1945 := !z.EncBinary()
			yy2arr1945 := z.EncBasicHandle().StructToArray
			var yyq1945 [2]bool
			_, _, _ = yysep1945, yyq1945, yy2arr1945
			const yyr1945 bool = false
			yyq1945[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1945[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1945 int
			if yyr1945 || yy2arr1945 {
				r.EncodeArrayStart(2)
			} else {
				yynn1945 = 0
				for _, b := range yyq1945 {
					if b {
						yynn1945++
					}
				}
				r.EncodeMapStart(yynn1945)
				yynn1945 = 0
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1945[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1947 := z.EncBinary()
						_ = yym1947
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1945[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1948 := z.EncBinary()
						_ = yym1948
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1945[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1950 := z.EncBinary()
						_ = yym1950
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1945[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1951 := z.EncBinary()
						_ = yym1951
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1945 || yy2arr1945 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1952 := z.DecBinary()
	_ = yym1952
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1953 := r.ContainerType()
		if yyct1953 == codecSelferValueTypeMap1234 {
			yyl1953 := r.ReadMapStart()
			if yyl1953 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1953, d)
			}
		} else if yyct1953 == codecSelferValueTypeArray1234 {
			yyl1953 := r.ReadArrayStart()
			if yyl1953 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1953, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1954Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1954Slc
	var yyhl1954 bool = l >= 0
	for yyj1954 := 0; ; yyj1954++ {
		if yyhl1954 {
			if yyj1954 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1954Slc = r.DecodeBytes(yys1954Slc, true, true)
		yys1954 := string(yys1954Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1954 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1955 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1956 := z.DecBinary()
				_ = yym1956
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1955), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1957 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1958 := z.DecBinary()
				_ = yym1958
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1957), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1954)
		} // end switch yys1954
	} // end for yyj1954
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1959 int
	var yyb1959 bool
	var yyhl1959 bool = l >= 0
	yyj1959++
	if yyhl1959 {
		yyb1959 = yyj1959 > l
	} else {
		yyb1959 = r.CheckBreak()
	}
	if yyb1959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1960 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1961 := z.DecBinary()
		_ = yym1961
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1960), d)
		}
	}
	yyj1959++
	if yyhl1959 {
		yyb1959 = yyj1959 > l
	} else {
		yyb1959 = r.CheckBreak()
	}
	if yyb1959 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1962 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1963 := z.DecBinary()
		_ = yym1963
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1962), d)
		}
	}
	for {
		yyj1959++
		if yyhl1959 {
			yyb1959 = yyj1959 > l
		} else {
			yyb1959 = r.CheckBreak()
		}
		if yyb1959 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1959-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAntiAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1964 := z.EncBinary()
		_ = yym1964
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1965 := !z.EncBinary()
			yy2arr1965 := z.EncBasicHandle().StructToArray
			var yyq1965 [2]bool
			_, _, _ = yysep1965, yyq1965, yy2arr1965
			const yyr1965 bool = false
			yyq1965[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq1965[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn1965 int
			if yyr1965 || yy2arr1965 {
				r.EncodeArrayStart(2)
			} else {
				yynn1965 = 0
				for _, b := range yyq1965 {
					if b {
						yynn1965++
					}
				}
				r.EncodeMapStart(yynn1965)
				yynn1965 = 0
			}
			if yyr1965 || yy2arr1965 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1965[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1967 := z.EncBinary()
						_ = yym1967
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1965[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1968 := z.EncBinary()
						_ = yym1968
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1965 || yy2arr1965 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1965[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1970 := z.EncBinary()
						_ = yym1970
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1965[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym1971 := z.EncBinary()
						_ = yym1971
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr1965 || yy2arr1965 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAntiAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1972 := z.DecBinary()
	_ = yym1972
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1973 := r.ContainerType()
		if yyct1973 == codecSelferValueTypeMap1234 {
			yyl1973 := r.ReadMapStart()
			if yyl1973 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1973, d)
			}
		} else if yyct1973 == codecSelferValueTypeArray1234 {
			yyl1973 := r.ReadArrayStart()
			if yyl1973 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1973, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAntiAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1974Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1974Slc
	var yyhl1974 bool = l >= 0
	for yyj1974 := 0; ; yyj1974++ {
		if yyhl1974 {
			if yyj1974 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1974Slc = r.DecodeBytes(yys1974Slc, true, true)
		yys1974 := string(yys1974Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1974 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1975 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym1976 := z.DecBinary()
				_ = yym1976
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1975), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv1977 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym1978 := z.DecBinary()
				_ = yym1978
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1977), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1974)
		} // end switch yys1974
	} // end for yyj1974
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAntiAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1979 int
	var yyb1979 bool
	var yyhl1979 bool = l >= 0
	yyj1979++
	if yyhl1979 {
		yyb1979 = yyj1979 > l
	} else {
		yyb1979 = r.CheckBreak()
	}
	if yyb1979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1980 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym1981 := z.DecBinary()
		_ = yym1981
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv1980), d)
		}
	}
	yyj1979++
	if yyhl1979 {
		yyb1979 = yyj1979 > l
	} else {
		yyb1979 = r.CheckBreak()
	}
	if yyb1979 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv1982 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym1983 := z.DecBinary()
		_ = yym1983
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv1982), d)
		}
	}
	for {
		yyj1979++
		if yyhl1979 {
			yyb1979 = yyj1979 > l
		} else {
			yyb1979 = r.CheckBreak()
		}
		if yyb1979 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1979-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *WeightedPodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1984 := z.EncBinary()
		_ = yym1984
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1985 := !z.EncBinary()
			yy2arr1985 := z.EncBasicHandle().StructToArray
			var yyq1985 [2]bool
			_, _, _ = yysep1985, yyq1985, yy2arr1985
			const yyr1985 bool = false
			var yynn1985 int
			if yyr1985 || yy2arr1985 {
				r.EncodeArrayStart(2)
			} else {
				yynn1985 = 2
				for _, b := range yyq1985 {
					if b {
						yynn1985++
					}
				}
				r.EncodeMapStart(yynn1985)
				yynn1985 = 0
			}
			if yyr1985 || yy2arr1985 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1987 := z.EncBinary()
				_ = yym1987
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1988 := z.EncBinary()
				_ = yym1988
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr1985 || yy2arr1985 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1990 := &x.PodAffinityTerm
				yy1990.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podAffinityTerm"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1991 := &x.PodAffinityTerm
				yy1991.CodecEncodeSelf(e)
			}
			if yyr1985 || yy2arr1985 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *WeightedPodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1992 := z.DecBinary()
	_ = yym1992
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1993 := r.ContainerType()
		if yyct1993 == codecSelferValueTypeMap1234 {
			yyl1993 := r.ReadMapStart()
			if yyl1993 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1993, d)
			}
		} else if yyct1993 == codecSelferValueTypeArray1234 {
			yyl1993 := r.ReadArrayStart()
			if yyl1993 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1993, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1994Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1994Slc
	var yyhl1994 bool = l >= 0
	for yyj1994 := 0; ; yyj1994++ {
		if yyhl1994 {
			if yyj1994 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1994Slc = r.DecodeBytes(yys1994Slc, true, true)
		yys1994 := string(yys1994Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1994 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "podAffinityTerm":
			if r.TryDecodeAsNil() {
				x.PodAffinityTerm = PodAffinityTerm{}
			} else {
				yyv1996 := &x.PodAffinityTerm
				yyv1996.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1994)
		} // end switch yys1994
	} // end for yyj1994
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1997 int
	var yyb1997 bool
	var yyhl1997 bool = l >= 0
	yyj1997++
	if yyhl1997 {
		yyb1997 = yyj1997 > l
	} else {
		yyb1997 = r.CheckBreak()
	}
	if yyb1997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj1997++
	if yyhl1997 {
		yyb1997 = yyj1997 > l
	} else {
		yyb1997 = r.CheckBreak()
	}
	if yyb1997 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodAffinityTerm = PodAffinityTerm{}
	} else {
		yyv1999 := &x.PodAffinityTerm
		yyv1999.CodecDecodeSelf(d)
	}
	for {
		yyj1997++
		if yyhl1997 {
			yyb1997 = yyj1997 > l
		} else {
			yyb1997 = r.CheckBreak()
		}
		if yyb1997 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1997-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2000 := z.EncBinary()
		_ = yym2000
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2001 := !z.EncBinary()
			yy2arr2001 := z.EncBasicHandle().StructToArray
			var yyq2001 [3]bool
			_, _, _ = yysep2001, yyq2001, yy2arr2001
			const yyr2001 bool = false
			yyq2001[0] = x.LabelSelector != nil
			yyq2001[2] = x.TopologyKey != ""
			var yynn2001 int
			if yyr2001 || yy2arr2001 {
				r.EncodeArrayStart(3)
			} else {
				yynn2001 = 1
				for _, b := range yyq2001 {
					if b {
						yynn2001++
					}
				}
				r.EncodeMapStart(yynn2001)
				yynn2001 = 0
			}
			if yyr2001 || yy2arr2001 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2001[0] {
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym2003 := z.EncBinary()
						_ = yym2003
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2001[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym2004 := z.EncBinary()
						_ = yym2004
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				}
			}
			if yyr2001 || yy2arr2001 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym2006 := z.EncBinary()
					_ = yym2006
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("namespaces"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Namespaces == nil {
					r.EncodeNil()
				} else {
					yym2007 := z.EncBinary()
					_ = yym2007
					if false {
					} else {
						z.F.EncSliceStringV(x.Namespaces, false, e)
					}
				}
			}
			if yyr2001 || yy2arr2001 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2001[2] {
					yym2009 := z.EncBinary()
					_ = yym2009
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2001[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("topologyKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2010 := z.EncBinary()
					_ = yym2010
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				}
			}
			if yyr2001 || yy2arr2001 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2011 := z.DecBinary()
	_ = yym2011
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2012 := r.ContainerType()
		if yyct2012 == codecSelferValueTypeMap1234 {
			yyl2012 := r.ReadMapStart()
			if yyl2012 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2012, d)
			}
		} else if yyct2012 == codecSelferValueTypeArray1234 {
			yyl2012 := r.ReadArrayStart()
			if yyl2012 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2012, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2013Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2013Slc
	var yyhl2013 bool = l >= 0
	for yyj2013 := 0; ; yyj2013++ {
		if yyhl2013 {
			if yyj2013 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2013Slc = r.DecodeBytes(yys2013Slc, true, true)
		yys2013 := string(yys2013Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2013 {
		case "labelSelector":
			if r.TryDecodeAsNil() {
				if x.LabelSelector != nil {
					x.LabelSelector = nil
				}
			} else {
				if x.LabelSelector == nil {
					x.LabelSelector = new(pkg2_unversioned.LabelSelector)
				}
				yym2015 := z.DecBinary()
				_ = yym2015
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
				} else {
					z.DecFallback(x.LabelSelector, false)
				}
			}
		case "namespaces":
			if r.TryDecodeAsNil() {
				x.Namespaces = nil
			} else {
				yyv2016 := &x.Namespaces
				yym2017 := z.DecBinary()
				_ = yym2017
				if false {
				} else {
					z.F.DecSliceStringX(yyv2016, false, d)
				}
			}
		case "topologyKey":
			if r.TryDecodeAsNil() {
				x.TopologyKey = ""
			} else {
				x.TopologyKey = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2013)
		} // end switch yys2013
	} // end for yyj2013
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2019 int
	var yyb2019 bool
	var yyhl2019 bool = l >= 0
	yyj2019++
	if yyhl2019 {
		yyb2019 = yyj2019 > l
	} else {
		yyb2019 = r.CheckBreak()
	}
	if yyb2019 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LabelSelector != nil {
			x.LabelSelector = nil
		}
	} else {
		if x.LabelSelector == nil {
			x.LabelSelector = new(pkg2_unversioned.LabelSelector)
		}
		yym2021 := z.DecBinary()
		_ = yym2021
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
		} else {
			z.DecFallback(x.LabelSelector, false)
		}
	}
	yyj2019++
	if yyhl2019 {
		yyb2019 = yyj2019 > l
	} else {
		yyb2019 = r.CheckBreak()
	}
	if yyb2019 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespaces = nil
	} else {
		yyv2022 := &x.Namespaces
		yym2023 := z.DecBinary()
		_ = yym2023
		if false {
		} else {
			z.F.DecSliceStringX(yyv2022, false, d)
		}
	}
	yyj2019++
	if yyhl2019 {
		yyb2019 = yyj2019 > l
	} else {
		yyb2019 = r.CheckBreak()
	}
	if yyb2019 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TopologyKey = ""
	} else {
		x.TopologyKey = string(r.DecodeString())
	}
	for {
		yyj2019++
		if yyhl2019 {
			yyb2019 = yyj2019 > l
		} else {
			yyb2019 = r.CheckBreak()
		}
		if yyb2019 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2019-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2025 := z.EncBinary()
		_ = yym2025
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2026 := !z.EncBinary()
			yy2arr2026 := z.EncBasicHandle().StructToArray
			var yyq2026 [2]bool
			_, _, _ = yysep2026, yyq2026, yy2arr2026
			const yyr2026 bool = false
			yyq2026[0] = x.RequiredDuringSchedulingIgnoredDuringExecution != nil
			yyq2026[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn2026 int
			if yyr2026 || yy2arr2026 {
				r.EncodeArrayStart(2)
			} else {
				yynn2026 = 0
				for _, b := range yyq2026 {
					if b {
						yynn2026++
					}
				}
				r.EncodeMapStart(yynn2026)
				yynn2026 = 0
			}
			if yyr2026 || yy2arr2026 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2026[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2026[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2026 || yy2arr2026 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2026[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym2029 := z.EncBinary()
						_ = yym2029
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2026[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym2030 := z.EncBinary()
						_ = yym2030
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr2026 || yy2arr2026 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2031 := z.DecBinary()
	_ = yym2031
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2032 := r.ContainerType()
		if yyct2032 == codecSelferValueTypeMap1234 {
			yyl2032 := r.ReadMapStart()
			if yyl2032 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2032, d)
			}
		} else if yyct2032 == codecSelferValueTypeArray1234 {
			yyl2032 := r.ReadArrayStart()
			if yyl2032 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2032, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2033Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2033Slc
	var yyhl2033 bool = l >= 0
	for yyj2033 := 0; ; yyj2033++ {
		if yyhl2033 {
			if yyj2033 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2033Slc = r.DecodeBytes(yys2033Slc, true, true)
		yys2033 := string(yys2033Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2033 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = nil
				}
			} else {
				if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
				}
				x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv2035 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym2036 := z.DecBinary()
				_ = yym2036
				if false {
				} else {
					h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv2035), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2033)
		} // end switch yys2033
	} // end for yyj2033
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2037 int
	var yyb2037 bool
	var yyhl2037 bool = l >= 0
	yyj2037++
	if yyhl2037 {
		yyb2037 = yyj2037 > l
	} else {
		yyb2037 = r.CheckBreak()
	}
	if yyb2037 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
	} else {
		if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
		}
		x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
	}
	yyj2037++
	if yyhl2037 {
		yyb2037 = yyj2037 > l
	} else {
		yyb2037 = r.CheckBreak()
	}
	if yyb2037 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv2039 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym2040 := z.DecBinary()
		_ = yym2040
		if false {
		} else {
			h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv2039), d)
		}
	}
	for {
		yyj2037++
		if yyhl2037 {
			yyb2037 = yyj2037 > l
		} else {
			yyb2037 = r.CheckBreak()
		}
		if yyb2037 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2037-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferredSchedulingTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2041 := z.EncBinary()
		_ = yym2041
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2042 := !z.EncBinary()
			yy2arr2042 := z.EncBasicHandle().StructToArray
			var yyq2042 [2]bool
			_, _, _ = yysep2042, yyq2042, yy2arr2042
			const yyr2042 bool = false
			var yynn2042 int
			if yyr2042 || yy2arr2042 {
				r.EncodeArrayStart(2)
			} else {
				yynn2042 = 2
				for _, b := range yyq2042 {
					if b {
						yynn2042++
					}
				}
				r.EncodeMapStart(yynn2042)
				yynn2042 = 0
			}
			if yyr2042 || yy2arr2042 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2044 := z.EncBinary()
				_ = yym2044
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2045 := z.EncBinary()
				_ = yym2045
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr2042 || yy2arr2042 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2047 := &x.Preference
				yy2047.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("preference"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2048 := &x.Preference
				yy2048.CodecEncodeSelf(e)
			}
			if yyr2042 || yy2arr2042 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferredSchedulingTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2049 := z.DecBinary()
	_ = yym2049
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2050 := r.ContainerType()
		if yyct2050 == codecSelferValueTypeMap1234 {
			yyl2050 := r.ReadMapStart()
			if yyl2050 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2050, d)
			}
		} else if yyct2050 == codecSelferValueTypeArray1234 {
			yyl2050 := r.ReadArrayStart()
			if yyl2050 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2050, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2051Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2051Slc
	var yyhl2051 bool = l >= 0
	for yyj2051 := 0; ; yyj2051++ {
		if yyhl2051 {
			if yyj2051 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2051Slc = r.DecodeBytes(yys2051Slc, true, true)
		yys2051 := string(yys2051Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2051 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				x.Weight = int32(r.DecodeInt(32))
			}
		case "preference":
			if r.TryDecodeAsNil() {
				x.Preference = NodeSelectorTerm{}
			} else {
				yyv2053 := &x.Preference
				yyv2053.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2051)
		} // end switch yys2051
	} // end for yyj2051
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2054 int
	var yyb2054 bool
	var yyhl2054 bool = l >= 0
	yyj2054++
	if yyhl2054 {
		yyb2054 = yyj2054 > l
	} else {
		yyb2054 = r.CheckBreak()
	}
	if yyb2054 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		x.Weight = int32(r.DecodeInt(32))
	}
	yyj2054++
	if yyhl2054 {
		yyb2054 = yyj2054 > l
	} else {
		yyb2054 = r.CheckBreak()
	}
	if yyb2054 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Preference = NodeSelectorTerm{}
	} else {
		yyv2056 := &x.Preference
		yyv2056.CodecDecodeSelf(d)
	}
	for {
		yyj2054++
		if yyhl2054 {
			yyb2054 = yyj2054 > l
		} else {
			yyb2054 = r.CheckBreak()
		}
		if yyb2054 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2054-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Taint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2057 := z.EncBinary()
		_ = yym2057
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2058 := !z.EncBinary()
			yy2arr2058 := z.EncBasicHandle().StructToArray
			var yyq2058 [3]bool
			_, _, _ = yysep2058, yyq2058, yy2arr2058
			const yyr2058 bool = false
			yyq2058[1] = x.Value != ""
			var yynn2058 int
			if yyr2058 || yy2arr2058 {
				r.EncodeArrayStart(3)
			} else {
				yynn2058 = 2
				for _, b := range yyq2058 {
					if b {
						yynn2058++
					}
				}
				r.EncodeMapStart(yynn2058)
				yynn2058 = 0
			}
			if yyr2058 || yy2arr2058 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2060 := z.EncBinary()
				_ = yym2060
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2061 := z.EncBinary()
				_ = yym2061
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2058 || yy2arr2058 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2058[1] {
					yym2063 := z.EncBinary()
					_ = yym2063
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2058[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2064 := z.EncBinary()
					_ = yym2064
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2058 || yy2arr2058 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Effect.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("effect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Effect.CodecEncodeSelf(e)
			}
			if yyr2058 || yy2arr2058 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Taint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2066 := z.DecBinary()
	_ = yym2066
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2067 := r.ContainerType()
		if yyct2067 == codecSelferValueTypeMap1234 {
			yyl2067 := r.ReadMapStart()
			if yyl2067 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2067, d)
			}
		} else if yyct2067 == codecSelferValueTypeArray1234 {
			yyl2067 := r.ReadArrayStart()
			if yyl2067 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2067, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Taint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2068Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2068Slc
	var yyhl2068 bool = l >= 0
	for yyj2068 := 0; ; yyj2068++ {
		if yyhl2068 {
			if yyj2068 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2068Slc = r.DecodeBytes(yys2068Slc, true, true)
		yys2068 := string(yys2068Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2068 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2068)
		} // end switch yys2068
	} // end for yyj2068
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Taint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2072 int
	var yyb2072 bool
	var yyhl2072 bool = l >= 0
	yyj2072++
	if yyhl2072 {
		yyb2072 = yyj2072 > l
	} else {
		yyb2072 = r.CheckBreak()
	}
	if yyb2072 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj2072++
	if yyhl2072 {
		yyb2072 = yyj2072 > l
	} else {
		yyb2072 = r.CheckBreak()
	}
	if yyb2072 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj2072++
	if yyhl2072 {
		yyb2072 = yyj2072 > l
	} else {
		yyb2072 = r.CheckBreak()
	}
	if yyb2072 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj2072++
		if yyhl2072 {
			yyb2072 = yyj2072 > l
		} else {
			yyb2072 = r.CheckBreak()
		}
		if yyb2072 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2072-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TaintEffect) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2076 := z.EncBinary()
	_ = yym2076
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TaintEffect) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2077 := z.DecBinary()
	_ = yym2077
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Toleration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2078 := z.EncBinary()
		_ = yym2078
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2079 := !z.EncBinary()
			yy2arr2079 := z.EncBasicHandle().StructToArray
			var yyq2079 [4]bool
			_, _, _ = yysep2079, yyq2079, yy2arr2079
			const yyr2079 bool = false
			yyq2079[0] = x.Key != ""
			yyq2079[1] = x.Operator != ""
			yyq2079[2] = x.Value != ""
			yyq2079[3] = x.Effect != ""
			var yynn2079 int
			if yyr2079 || yy2arr2079 {
				r.EncodeArrayStart(4)
			} else {
				yynn2079 = 0
				for _, b := range yyq2079 {
					if b {
						yynn2079++
					}
				}
				r.EncodeMapStart(yynn2079)
				yynn2079 = 0
			}
			if yyr2079 || yy2arr2079 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2079[0] {
					yym2081 := z.EncBinary()
					_ = yym2081
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2079[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("key"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2082 := z.EncBinary()
					_ = yym2082
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				}
			}
			if yyr2079 || yy2arr2079 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2079[1] {
					x.Operator.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2079[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("operator"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Operator.CodecEncodeSelf(e)
				}
			}
			if yyr2079 || yy2arr2079 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2079[2] {
					yym2085 := z.EncBinary()
					_ = yym2085
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2079[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2086 := z.EncBinary()
					_ = yym2086
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2079 || yy2arr2079 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2079[3] {
					x.Effect.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2079[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("effect"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Effect.CodecEncodeSelf(e)
				}
			}
			if yyr2079 || yy2arr2079 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Toleration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2088 := z.DecBinary()
	_ = yym2088
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2089 := r.ContainerType()
		if yyct2089 == codecSelferValueTypeMap1234 {
			yyl2089 := r.ReadMapStart()
			if yyl2089 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2089, d)
			}
		} else if yyct2089 == codecSelferValueTypeArray1234 {
			yyl2089 := r.ReadArrayStart()
			if yyl2089 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2089, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Toleration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2090Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2090Slc
	var yyhl2090 bool = l >= 0
	for yyj2090 := 0; ; yyj2090++ {
		if yyhl2090 {
			if yyj2090 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2090Slc = r.DecodeBytes(yys2090Slc, true, true)
		yys2090 := string(yys2090Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2090 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				x.Key = string(r.DecodeString())
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				x.Operator = TolerationOperator(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				x.Effect = TaintEffect(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2090)
		} // end switch yys2090
	} // end for yyj2090
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Toleration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2095 int
	var yyb2095 bool
	var yyhl2095 bool = l >= 0
	yyj2095++
	if yyhl2095 {
		yyb2095 = yyj2095 > l
	} else {
		yyb2095 = r.CheckBreak()
	}
	if yyb2095 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		x.Key = string(r.DecodeString())
	}
	yyj2095++
	if yyhl2095 {
		yyb2095 = yyj2095 > l
	} else {
		yyb2095 = r.CheckBreak()
	}
	if yyb2095 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		x.Operator = TolerationOperator(r.DecodeString())
	}
	yyj2095++
	if yyhl2095 {
		yyb2095 = yyj2095 > l
	} else {
		yyb2095 = r.CheckBreak()
	}
	if yyb2095 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	yyj2095++
	if yyhl2095 {
		yyb2095 = yyj2095 > l
	} else {
		yyb2095 = r.CheckBreak()
	}
	if yyb2095 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		x.Effect = TaintEffect(r.DecodeString())
	}
	for {
		yyj2095++
		if yyhl2095 {
			yyb2095 = yyj2095 > l
		} else {
			yyb2095 = r.CheckBreak()
		}
		if yyb2095 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2095-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TolerationOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2100 := z.EncBinary()
	_ = yym2100
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TolerationOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2101 := z.DecBinary()
	_ = yym2101
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2102 := z.EncBinary()
		_ = yym2102
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2103 := !z.EncBinary()
			yy2arr2103 := z.EncBasicHandle().StructToArray
			var yyq2103 [13]bool
			_, _, _ = yysep2103, yyq2103, yy2arr2103
			const yyr2103 bool = false
			yyq2103[2] = x.RestartPolicy != ""
			yyq2103[3] = x.TerminationGracePeriodSeconds != nil
			yyq2103[4] = x.ActiveDeadlineSeconds != nil
			yyq2103[5] = x.DNSPolicy != ""
			yyq2103[6] = len(x.NodeSelector) != 0
			yyq2103[8] = x.NodeName != ""
			yyq2103[9] = x.SecurityContext != nil
			yyq2103[10] = len(x.ImagePullSecrets) != 0
			yyq2103[11] = x.Hostname != ""
			yyq2103[12] = x.Subdomain != ""
			var yynn2103 int
			if yyr2103 || yy2arr2103 {
				r.EncodeArrayStart(13)
			} else {
				yynn2103 = 3
				for _, b := range yyq2103 {
					if b {
						yynn2103++
					}
				}
				r.EncodeMapStart(yynn2103)
				yynn2103 = 0
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Volumes == nil {
					r.EncodeNil()
				} else {
					yym2105 := z.EncBinary()
					_ = yym2105
					if false {
					} else {
						h.encSliceVolume(([]Volume)(x.Volumes), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumes"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Volumes == nil {
					r.EncodeNil()
				} else {
					yym2106 := z.EncBinary()
					_ = yym2106
					if false {
					} else {
						h.encSliceVolume(([]Volume)(x.Volumes), e)
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym2108 := z.EncBinary()
					_ = yym2108
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym2109 := z.EncBinary()
					_ = yym2109
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[2] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2103[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[3] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2112 := *x.TerminationGracePeriodSeconds
						yym2113 := z.EncBinary()
						_ = yym2113
						if false {
						} else {
							r.EncodeInt(int64(yy2112))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2103[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy2114 := *x.TerminationGracePeriodSeconds
						yym2115 := z.EncBinary()
						_ = yym2115
						if false {
						} else {
							r.EncodeInt(int64(yy2114))
						}
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[4] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2117 := *x.ActiveDeadlineSeconds
						yym2118 := z.EncBinary()
						_ = yym2118
						if false {
						} else {
							r.EncodeInt(int64(yy2117))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2103[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy2119 := *x.ActiveDeadlineSeconds
						yym2120 := z.EncBinary()
						_ = yym2120
						if false {
						} else {
							r.EncodeInt(int64(yy2119))
						}
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[5] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2103[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[6] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2123 := z.EncBinary()
						_ = yym2123
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2103[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym2124 := z.EncBinary()
						_ = yym2124
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2126 := z.EncBinary()
				_ = yym2126
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2127 := z.EncBinary()
				_ = yym2127
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[8] {
					yym2129 := z.EncBinary()
					_ = yym2129
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2103[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2130 := z.EncBinary()
					_ = yym2130
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[9] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2103[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[10] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2133 := z.EncBinary()
						_ = yym2133
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2103[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2134 := z.EncBinary()
						_ = yym2134
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[11] {
					yym2136 := z.EncBinary()
					_ = yym2136
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2103[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2137 := z.EncBinary()
					_ = yym2137
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2103[12] {
					yym2139 := z.EncBinary()
					_ = yym2139
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2103[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subdomain"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2140 := z.EncBinary()
					_ = yym2140
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				}
			}
			if yyr2103 || yy2arr2103 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2141 := z.DecBinary()
	_ = yym2141
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2142 := r.ContainerType()
		if yyct2142 == codecSelferValueTypeMap1234 {
			yyl2142 := r.ReadMapStart()
			if yyl2142 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2142, d)
			}
		} else if yyct2142 == codecSelferValueTypeArray1234 {
			yyl2142 := r.ReadArrayStart()
			if yyl2142 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2142, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2143Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2143Slc
	var yyhl2143 bool = l >= 0
	for yyj2143 := 0; ; yyj2143++ {
		if yyhl2143 {
			if yyj2143 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2143Slc = r.DecodeBytes(yys2143Slc, true, true)
		yys2143 := string(yys2143Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2143 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv2144 := &x.Volumes
				yym2145 := z.DecBinary()
				_ = yym2145
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv2144), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv2146 := &x.Containers
				yym2147 := z.DecBinary()
				_ = yym2147
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv2146), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				x.RestartPolicy = RestartPolicy(r.DecodeString())
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym2150 := z.DecBinary()
				_ = yym2150
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym2152 := z.DecBinary()
				_ = yym2152
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				x.DNSPolicy = DNSPolicy(r.DecodeString())
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv2154 := &x.NodeSelector
				yym2155 := z.DecBinary()
				_ = yym2155
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2154, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				x.ServiceAccountName = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				x.NodeName = string(r.DecodeString())
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2159 := &x.ImagePullSecrets
				yym2160 := z.DecBinary()
				_ = yym2160
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2159), d)
				}
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "subdomain":
			if r.TryDecodeAsNil() {
				x.Subdomain = ""
			} else {
				x.Subdomain = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2143)
		} // end switch yys2143
	} // end for yyj2143
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2163 int
	var yyb2163 bool
	var yyhl2163 bool = l >= 0
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv2164 := &x.Volumes
		yym2165 := z.DecBinary()
		_ = yym2165
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv2164), d)
		}
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv2166 := &x.Containers
		yym2167 := z.DecBinary()
		_ = yym2167
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv2166), d)
		}
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		x.RestartPolicy = RestartPolicy(r.DecodeString())
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym2170 := z.DecBinary()
		_ = yym2170
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym2172 := z.DecBinary()
		_ = yym2172
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		x.DNSPolicy = DNSPolicy(r.DecodeString())
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv2174 := &x.NodeSelector
		yym2175 := z.DecBinary()
		_ = yym2175
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2174, false, d)
		}
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		x.ServiceAccountName = string(r.DecodeString())
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		x.NodeName = string(r.DecodeString())
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2179 := &x.ImagePullSecrets
		yym2180 := z.DecBinary()
		_ = yym2180
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2179), d)
		}
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2163++
	if yyhl2163 {
		yyb2163 = yyj2163 > l
	} else {
		yyb2163 = r.CheckBreak()
	}
	if yyb2163 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subdomain = ""
	} else {
		x.Subdomain = string(r.DecodeString())
	}
	for {
		yyj2163++
		if yyhl2163 {
			yyb2163 = yyj2163 > l
		} else {
			yyb2163 = r.CheckBreak()
		}
		if yyb2163 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2163-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Sysctl) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2183 := z.EncBinary()
		_ = yym2183
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2184 := !z.EncBinary()
			yy2arr2184 := z.EncBasicHandle().StructToArray
			var yyq2184 [2]bool
			_, _, _ = yysep2184, yyq2184, yy2arr2184
			const yyr2184 bool = false
			var yynn2184 int
			if yyr2184 || yy2arr2184 {
				r.EncodeArrayStart(2)
			} else {
				yynn2184 = 2
				for _, b := range yyq2184 {
					if b {
						yynn2184++
					}
				}
				r.EncodeMapStart(yynn2184)
				yynn2184 = 0
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2186 := z.EncBinary()
				_ = yym2186
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2187 := z.EncBinary()
				_ = yym2187
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2189 := z.EncBinary()
				_ = yym2189
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2190 := z.EncBinary()
				_ = yym2190
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr2184 || yy2arr2184 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Sysctl) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2191 := z.DecBinary()
	_ = yym2191
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2192 := r.ContainerType()
		if yyct2192 == codecSelferValueTypeMap1234 {
			yyl2192 := r.ReadMapStart()
			if yyl2192 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2192, d)
			}
		} else if yyct2192 == codecSelferValueTypeArray1234 {
			yyl2192 := r.ReadArrayStart()
			if yyl2192 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2192, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Sysctl) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2193Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2193Slc
	var yyhl2193 bool = l >= 0
	for yyj2193 := 0; ; yyj2193++ {
		if yyhl2193 {
			if yyj2193 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2193Slc = r.DecodeBytes(yys2193Slc, true, true)
		yys2193 := string(yys2193Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2193 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				x.Value = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2193)
		} // end switch yys2193
	} // end for yyj2193
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Sysctl) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2196 int
	var yyb2196 bool
	var yyhl2196 bool = l >= 0
	yyj2196++
	if yyhl2196 {
		yyb2196 = yyj2196 > l
	} else {
		yyb2196 = r.CheckBreak()
	}
	if yyb2196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2196++
	if yyhl2196 {
		yyb2196 = yyj2196 > l
	} else {
		yyb2196 = r.CheckBreak()
	}
	if yyb2196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		x.Value = string(r.DecodeString())
	}
	for {
		yyj2196++
		if yyhl2196 {
			yyb2196 = yyj2196 > l
		} else {
			yyb2196 = r.CheckBreak()
		}
		if yyb2196 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2196-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2199 := z.EncBinary()
		_ = yym2199
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2200 := !z.EncBinary()
			yy2arr2200 := z.EncBasicHandle().StructToArray
			var yyq2200 [8]bool
			_, _, _ = yysep2200, yyq2200, yy2arr2200
			const yyr2200 bool = false
			yyq2200[0] = x.HostNetwork != false
			yyq2200[1] = x.HostPID != false
			yyq2200[2] = x.HostIPC != false
			yyq2200[3] = x.SELinuxOptions != nil
			yyq2200[4] = x.RunAsUser != nil
			yyq2200[5] = x.RunAsNonRoot != nil
			yyq2200[6] = len(x.SupplementalGroups) != 0
			yyq2200[7] = x.FSGroup != nil
			var yynn2200 int
			if yyr2200 || yy2arr2200 {
				r.EncodeArrayStart(8)
			} else {
				yynn2200 = 0
				for _, b := range yyq2200 {
					if b {
						yynn2200++
					}
				}
				r.EncodeMapStart(yynn2200)
				yynn2200 = 0
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[0] {
					yym2202 := z.EncBinary()
					_ = yym2202
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2200[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2203 := z.EncBinary()
					_ = yym2203
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[1] {
					yym2205 := z.EncBinary()
					_ = yym2205
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2200[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2206 := z.EncBinary()
					_ = yym2206
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[2] {
					yym2208 := z.EncBinary()
					_ = yym2208
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2200[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2209 := z.EncBinary()
					_ = yym2209
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[3] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2200[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[4] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2212 := *x.RunAsUser
						yym2213 := z.EncBinary()
						_ = yym2213
						if false {
						} else {
							r.EncodeInt(int64(yy2212))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2200[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy2214 := *x.RunAsUser
						yym2215 := z.EncBinary()
						_ = yym2215
						if false {
						} else {
							r.EncodeInt(int64(yy2214))
						}
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[5] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2217 := *x.RunAsNonRoot
						yym2218 := z.EncBinary()
						_ = yym2218
						if false {
						} else {
							r.EncodeBool(bool(yy2217))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2200[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy2219 := *x.RunAsNonRoot
						yym2220 := z.EncBinary()
						_ = yym2220
						if false {
						} else {
							r.EncodeBool(bool(yy2219))
						}
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[6] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2222 := z.EncBinary()
						_ = yym2222
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2200[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym2223 := z.EncBinary()
						_ = yym2223
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2200[7] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2225 := *x.FSGroup
						yym2226 := z.EncBinary()
						_ = yym2226
						if false {
						} else {
							r.EncodeInt(int64(yy2225))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2200[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy2227 := *x.FSGroup
						yym2228 := z.EncBinary()
						_ = yym2228
						if false {
						} else {
							r.EncodeInt(int64(yy2227))
						}
					}
				}
			}
			if yyr2200 || yy2arr2200 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2229 := z.DecBinary()
	_ = yym2229
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2230 := r.ContainerType()
		if yyct2230 == codecSelferValueTypeMap1234 {
			yyl2230 := r.ReadMapStart()
			if yyl2230 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2230, d)
			}
		} else if yyct2230 == codecSelferValueTypeArray1234 {
			yyl2230 := r.ReadArrayStart()
			if yyl2230 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2230, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2231Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2231Slc
	var yyhl2231 bool = l >= 0
	for yyj2231 := 0; ; yyj2231++ {
		if yyhl2231 {
			if yyj2231 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2231Slc = r.DecodeBytes(yys2231Slc, true, true)
		yys2231 := string(yys2231Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2231 {
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym2237 := z.DecBinary()
				_ = yym2237
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym2239 := z.DecBinary()
				_ = yym2239
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv2240 := &x.SupplementalGroups
				yym2241 := z.DecBinary()
				_ = yym2241
				if false {
				} else {
					z.F.DecSliceInt64X(yyv2240, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym2243 := z.DecBinary()
				_ = yym2243
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2231)
		} // end switch yys2231
	} // end for yyj2231
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2244 int
	var yyb2244 bool
	var yyhl2244 bool = l >= 0
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym2250 := z.DecBinary()
		_ = yym2250
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym2252 := z.DecBinary()
		_ = yym2252
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv2253 := &x.SupplementalGroups
		yym2254 := z.DecBinary()
		_ = yym2254
		if false {
		} else {
			z.F.DecSliceInt64X(yyv2253, false, d)
		}
	}
	yyj2244++
	if yyhl2244 {
		yyb2244 = yyj2244 > l
	} else {
		yyb2244 = r.CheckBreak()
	}
	if yyb2244 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym2256 := z.DecBinary()
		_ = yym2256
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj2244++
		if yyhl2244 {
			yyb2244 = yyj2244 > l
		} else {
			yyb2244 = r.CheckBreak()
		}
		if yyb2244 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2244-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2257 := z.EncBinary()
		_ = yym2257
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2258 := !z.EncBinary()
			yy2arr2258 := z.EncBasicHandle().StructToArray
			var yyq2258 [8]bool
			_, _, _ = yysep2258, yyq2258, yy2arr2258
			const yyr2258 bool = false
			yyq2258[0] = x.Phase != ""
			yyq2258[1] = len(x.Conditions) != 0
			yyq2258[2] = x.Message != ""
			yyq2258[3] = x.Reason != ""
			yyq2258[4] = x.HostIP != ""
			yyq2258[5] = x.PodIP != ""
			yyq2258[6] = x.StartTime != nil
			yyq2258[7] = len(x.ContainerStatuses) != 0
			var yynn2258 int
			if yyr2258 || yy2arr2258 {
				r.EncodeArrayStart(8)
			} else {
				yynn2258 = 0
				for _, b := range yyq2258 {
					if b {
						yynn2258++
					}
				}
				r.EncodeMapStart(yynn2258)
				yynn2258 = 0
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2258[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2261 := z.EncBinary()
						_ = yym2261
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2258[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2262 := z.EncBinary()
						_ = yym2262
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[2] {
					yym2264 := z.EncBinary()
					_ = yym2264
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2258[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2265 := z.EncBinary()
					_ = yym2265
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[3] {
					yym2267 := z.EncBinary()
					_ = yym2267
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2258[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2268 := z.EncBinary()
					_ = yym2268
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[4] {
					yym2270 := z.EncBinary()
					_ = yym2270
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2258[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2271 := z.EncBinary()
					_ = yym2271
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[5] {
					yym2273 := z.EncBinary()
					_ = yym2273
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2258[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2274 := z.EncBinary()
					_ = yym2274
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2276 := z.EncBinary()
						_ = yym2276
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2276 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2276 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2258[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym2277 := z.EncBinary()
						_ = yym2277
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym2277 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym2277 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2258[7] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2279 := z.EncBinary()
						_ = yym2279
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2258[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym2280 := z.EncBinary()
						_ = yym2280
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr2258 || yy2arr2258 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2281 := z.DecBinary()
	_ = yym2281
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2282 := r.ContainerType()
		if yyct2282 == codecSelferValueTypeMap1234 {
			yyl2282 := r.ReadMapStart()
			if yyl2282 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2282, d)
			}
		} else if yyct2282 == codecSelferValueTypeArray1234 {
			yyl2282 := r.ReadArrayStart()
			if yyl2282 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2282, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2283Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2283Slc
	var yyhl2283 bool = l >= 0
	for yyj2283 := 0; ; yyj2283++ {
		if yyhl2283 {
			if yyj2283 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2283Slc = r.DecodeBytes(yys2283Slc, true, true)
		yys2283 := string(yys2283Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2283 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = PodPhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2285 := &x.Conditions
				yym2286 := z.DecBinary()
				_ = yym2286
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv2285), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				x.HostIP = string(r.DecodeString())
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				x.PodIP = string(r.DecodeString())
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_unversioned.Time)
				}
				yym2292 := z.DecBinary()
				_ = yym2292
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym2292 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym2292 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv2293 := &x.ContainerStatuses
				yym2294 := z.DecBinary()
				_ = yym2294
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv2293), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2283)
		} // end switch yys2283
	} // end for yyj2283
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2295 int
	var yyb2295 bool
	var yyhl2295 bool = l >= 0
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = PodPhase(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2297 := &x.Conditions
		yym2298 := z.DecBinary()
		_ = yym2298
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv2297), d)
		}
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		x.HostIP = string(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		x.PodIP = string(r.DecodeString())
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_unversioned.Time)
		}
		yym2304 := z.DecBinary()
		_ = yym2304
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym2304 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym2304 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj2295++
	if yyhl2295 {
		yyb2295 = yyj2295 > l
	} else {
		yyb2295 = r.CheckBreak()
	}
	if yyb2295 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv2305 := &x.ContainerStatuses
		yym2306 := z.DecBinary()
		_ = yym2306
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv2305), d)
		}
	}
	for {
		yyj2295++
		if yyhl2295 {
			yyb2295 = yyj2295 > l
		} else {
			yyb2295 = r.CheckBreak()
		}
		if yyb2295 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2295-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2307 := z.EncBinary()
		_ = yym2307
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2308 := !z.EncBinary()
			yy2arr2308 := z.EncBasicHandle().StructToArray
			var yyq2308 [4]bool
			_, _, _ = yysep2308, yyq2308, yy2arr2308
			const yyr2308 bool = false
			yyq2308[0] = x.Kind != ""
			yyq2308[1] = x.APIVersion != ""
			yyq2308[2] = true
			yyq2308[3] = true
			var yynn2308 int
			if yyr2308 || yy2arr2308 {
				r.EncodeArrayStart(4)
			} else {
				yynn2308 = 0
				for _, b := range yyq2308 {
					if b {
						yynn2308++
					}
				}
				r.EncodeMapStart(yynn2308)
				yynn2308 = 0
			}
			if yyr2308 || yy2arr2308 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2308[0] {
					yym2310 := z.EncBinary()
					_ = yym2310
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2308[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2311 := z.EncBinary()
					_ = yym2311
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2308 || yy2arr2308 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2308[1] {
					yym2313 := z.EncBinary()
					_ = yym2313
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2308[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2314 := z.EncBinary()
					_ = yym2314
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2308 || yy2arr2308 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2308[2] {
					yy2316 := &x.ObjectMeta
					yy2316.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2308[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2317 := &x.ObjectMeta
					yy2317.CodecEncodeSelf(e)
				}
			}
			if yyr2308 || yy2arr2308 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2308[3] {
					yy2319 := &x.Status
					yy2319.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2308[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2320 := &x.Status
					yy2320.CodecEncodeSelf(e)
				}
			}
			if yyr2308 || yy2arr2308 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2321 := z.DecBinary()
	_ = yym2321
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2322 := r.ContainerType()
		if yyct2322 == codecSelferValueTypeMap1234 {
			yyl2322 := r.ReadMapStart()
			if yyl2322 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2322, d)
			}
		} else if yyct2322 == codecSelferValueTypeArray1234 {
			yyl2322 := r.ReadArrayStart()
			if yyl2322 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2322, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2323Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2323Slc
	var yyhl2323 bool = l >= 0
	for yyj2323 := 0; ; yyj2323++ {
		if yyhl2323 {
			if yyj2323 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2323Slc = r.DecodeBytes(yys2323Slc, true, true)
		yys2323 := string(yys2323Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2323 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2326 := &x.ObjectMeta
				yyv2326.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2327 := &x.Status
				yyv2327.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2323)
		} // end switch yys2323
	} // end for yyj2323
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2328 int
	var yyb2328 bool
	var yyhl2328 bool = l >= 0
	yyj2328++
	if yyhl2328 {
		yyb2328 = yyj2328 > l
	} else {
		yyb2328 = r.CheckBreak()
	}
	if yyb2328 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2328++
	if yyhl2328 {
		yyb2328 = yyj2328 > l
	} else {
		yyb2328 = r.CheckBreak()
	}
	if yyb2328 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2328++
	if yyhl2328 {
		yyb2328 = yyj2328 > l
	} else {
		yyb2328 = r.CheckBreak()
	}
	if yyb2328 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2331 := &x.ObjectMeta
		yyv2331.CodecDecodeSelf(d)
	}
	yyj2328++
	if yyhl2328 {
		yyb2328 = yyj2328 > l
	} else {
		yyb2328 = r.CheckBreak()
	}
	if yyb2328 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2332 := &x.Status
		yyv2332.CodecDecodeSelf(d)
	}
	for {
		yyj2328++
		if yyhl2328 {
			yyb2328 = yyj2328 > l
		} else {
			yyb2328 = r.CheckBreak()
		}
		if yyb2328 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2328-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2333 := z.EncBinary()
		_ = yym2333
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2334 := !z.EncBinary()
			yy2arr2334 := z.EncBasicHandle().StructToArray
			var yyq2334 [5]bool
			_, _, _ = yysep2334, yyq2334, yy2arr2334
			const yyr2334 bool = false
			yyq2334[0] = x.Kind != ""
			yyq2334[1] = x.APIVersion != ""
			yyq2334[2] = true
			yyq2334[3] = true
			yyq2334[4] = true
			var yynn2334 int
			if yyr2334 || yy2arr2334 {
				r.EncodeArrayStart(5)
			} else {
				yynn2334 = 0
				for _, b := range yyq2334 {
					if b {
						yynn2334++
					}
				}
				r.EncodeMapStart(yynn2334)
				yynn2334 = 0
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[0] {
					yym2336 := z.EncBinary()
					_ = yym2336
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2334[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2337 := z.EncBinary()
					_ = yym2337
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[1] {
					yym2339 := z.EncBinary()
					_ = yym2339
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2334[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2340 := z.EncBinary()
					_ = yym2340
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[2] {
					yy2342 := &x.ObjectMeta
					yy2342.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2343 := &x.ObjectMeta
					yy2343.CodecEncodeSelf(e)
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[3] {
					yy2345 := &x.Spec
					yy2345.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2346 := &x.Spec
					yy2346.CodecEncodeSelf(e)
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2334[4] {
					yy2348 := &x.Status
					yy2348.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2334[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2349 := &x.Status
					yy2349.CodecEncodeSelf(e)
				}
			}
			if yyr2334 || yy2arr2334 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2350 := z.DecBinary()
	_ = yym2350
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2351 := r.ContainerType()
		if yyct2351 == codecSelferValueTypeMap1234 {
			yyl2351 := r.ReadMapStart()
			if yyl2351 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2351, d)
			}
		} else if yyct2351 == codecSelferValueTypeArray1234 {
			yyl2351 := r.ReadArrayStart()
			if yyl2351 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2351, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2352Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2352Slc
	var yyhl2352 bool = l >= 0
	for yyj2352 := 0; ; yyj2352++ {
		if yyhl2352 {
			if yyj2352 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2352Slc = r.DecodeBytes(yys2352Slc, true, true)
		yys2352 := string(yys2352Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2352 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2355 := &x.ObjectMeta
				yyv2355.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2356 := &x.Spec
				yyv2356.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv2357 := &x.Status
				yyv2357.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2352)
		} // end switch yys2352
	} // end for yyj2352
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2358 int
	var yyb2358 bool
	var yyhl2358 bool = l >= 0
	yyj2358++
	if yyhl2358 {
		yyb2358 = yyj2358 > l
	} else {
		yyb2358 = r.CheckBreak()
	}
	if yyb2358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2358++
	if yyhl2358 {
		yyb2358 = yyj2358 > l
	} else {
		yyb2358 = r.CheckBreak()
	}
	if yyb2358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2358++
	if yyhl2358 {
		yyb2358 = yyj2358 > l
	} else {
		yyb2358 = r.CheckBreak()
	}
	if yyb2358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2361 := &x.ObjectMeta
		yyv2361.CodecDecodeSelf(d)
	}
	yyj2358++
	if yyhl2358 {
		yyb2358 = yyj2358 > l
	} else {
		yyb2358 = r.CheckBreak()
	}
	if yyb2358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2362 := &x.Spec
		yyv2362.CodecDecodeSelf(d)
	}
	yyj2358++
	if yyhl2358 {
		yyb2358 = yyj2358 > l
	} else {
		yyb2358 = r.CheckBreak()
	}
	if yyb2358 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv2363 := &x.Status
		yyv2363.CodecDecodeSelf(d)
	}
	for {
		yyj2358++
		if yyhl2358 {
			yyb2358 = yyj2358 > l
		} else {
			yyb2358 = r.CheckBreak()
		}
		if yyb2358 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2358-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2364 := z.EncBinary()
		_ = yym2364
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2365 := !z.EncBinary()
			yy2arr2365 := z.EncBasicHandle().StructToArray
			var yyq2365 [2]bool
			_, _, _ = yysep2365, yyq2365, yy2arr2365
			const yyr2365 bool = false
			yyq2365[0] = true
			yyq2365[1] = true
			var yynn2365 int
			if yyr2365 || yy2arr2365 {
				r.EncodeArrayStart(2)
			} else {
				yynn2365 = 0
				for _, b := range yyq2365 {
					if b {
						yynn2365++
					}
				}
				r.EncodeMapStart(yynn2365)
				yynn2365 = 0
			}
			if yyr2365 || yy2arr2365 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2365[0] {
					yy2367 := &x.ObjectMeta
					yy2367.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2365[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2368 := &x.ObjectMeta
					yy2368.CodecEncodeSelf(e)
				}
			}
			if yyr2365 || yy2arr2365 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2365[1] {
					yy2370 := &x.Spec
					yy2370.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2365[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2371 := &x.Spec
					yy2371.CodecEncodeSelf(e)
				}
			}
			if yyr2365 || yy2arr2365 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2372 := z.DecBinary()
	_ = yym2372
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2373 := r.ContainerType()
		if yyct2373 == codecSelferValueTypeMap1234 {
			yyl2373 := r.ReadMapStart()
			if yyl2373 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2373, d)
			}
		} else if yyct2373 == codecSelferValueTypeArray1234 {
			yyl2373 := r.ReadArrayStart()
			if yyl2373 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2373, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2374Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2374Slc
	var yyhl2374 bool = l >= 0
	for yyj2374 := 0; ; yyj2374++ {
		if yyhl2374 {
			if yyj2374 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2374Slc = r.DecodeBytes(yys2374Slc, true, true)
		yys2374 := string(yys2374Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2374 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2375 := &x.ObjectMeta
				yyv2375.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv2376 := &x.Spec
				yyv2376.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2374)
		} // end switch yys2374
	} // end for yyj2374
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2377 int
	var yyb2377 bool
	var yyhl2377 bool = l >= 0
	yyj2377++
	if yyhl2377 {
		yyb2377 = yyj2377 > l
	} else {
		yyb2377 = r.CheckBreak()
	}
	if yyb2377 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2378 := &x.ObjectMeta
		yyv2378.CodecDecodeSelf(d)
	}
	yyj2377++
	if yyhl2377 {
		yyb2377 = yyj2377 > l
	} else {
		yyb2377 = r.CheckBreak()
	}
	if yyb2377 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv2379 := &x.Spec
		yyv2379.CodecDecodeSelf(d)
	}
	for {
		yyj2377++
		if yyhl2377 {
			yyb2377 = yyj2377 > l
		} else {
			yyb2377 = r.CheckBreak()
		}
		if yyb2377 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2377-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2380 := z.EncBinary()
		_ = yym2380
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2381 := !z.EncBinary()
			yy2arr2381 := z.EncBasicHandle().StructToArray
			var yyq2381 [4]bool
			_, _, _ = yysep2381, yyq2381, yy2arr2381
			const yyr2381 bool = false
			yyq2381[0] = x.Kind != ""
			yyq2381[1] = x.APIVersion != ""
			yyq2381[2] = true
			yyq2381[3] = true
			var yynn2381 int
			if yyr2381 || yy2arr2381 {
				r.EncodeArrayStart(4)
			} else {
				yynn2381 = 0
				for _, b := range yyq2381 {
					if b {
						yynn2381++
					}
				}
				r.EncodeMapStart(yynn2381)
				yynn2381 = 0
			}
			if yyr2381 || yy2arr2381 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2381[0] {
					yym2383 := z.EncBinary()
					_ = yym2383
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2381[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2384 := z.EncBinary()
					_ = yym2384
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2381 || yy2arr2381 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2381[1] {
					yym2386 := z.EncBinary()
					_ = yym2386
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2381[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2387 := z.EncBinary()
					_ = yym2387
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2381 || yy2arr2381 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2381[2] {
					yy2389 := &x.ObjectMeta
					yy2389.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2381[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2390 := &x.ObjectMeta
					yy2390.CodecEncodeSelf(e)
				}
			}
			if yyr2381 || yy2arr2381 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2381[3] {
					yy2392 := &x.Template
					yy2392.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2381[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2393 := &x.Template
					yy2393.CodecEncodeSelf(e)
				}
			}
			if yyr2381 || yy2arr2381 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2394 := z.DecBinary()
	_ = yym2394
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2395 := r.ContainerType()
		if yyct2395 == codecSelferValueTypeMap1234 {
			yyl2395 := r.ReadMapStart()
			if yyl2395 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2395, d)
			}
		} else if yyct2395 == codecSelferValueTypeArray1234 {
			yyl2395 := r.ReadArrayStart()
			if yyl2395 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2395, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2396Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2396Slc
	var yyhl2396 bool = l >= 0
	for yyj2396 := 0; ; yyj2396++ {
		if yyhl2396 {
			if yyj2396 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2396Slc = r.DecodeBytes(yys2396Slc, true, true)
		yys2396 := string(yys2396Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2396 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2399 := &x.ObjectMeta
				yyv2399.CodecDecodeSelf(d)
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv2400 := &x.Template
				yyv2400.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2396)
		} // end switch yys2396
	} // end for yyj2396
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2401 int
	var yyb2401 bool
	var yyhl2401 bool = l >= 0
	yyj2401++
	if yyhl2401 {
		yyb2401 = yyj2401 > l
	} else {
		yyb2401 = r.CheckBreak()
	}
	if yyb2401 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2401++
	if yyhl2401 {
		yyb2401 = yyj2401 > l
	} else {
		yyb2401 = r.CheckBreak()
	}
	if yyb2401 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2401++
	if yyhl2401 {
		yyb2401 = yyj2401 > l
	} else {
		yyb2401 = r.CheckBreak()
	}
	if yyb2401 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2404 := &x.ObjectMeta
		yyv2404.CodecDecodeSelf(d)
	}
	yyj2401++
	if yyhl2401 {
		yyb2401 = yyj2401 > l
	} else {
		yyb2401 = r.CheckBreak()
	}
	if yyb2401 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv2405 := &x.Template
		yyv2405.CodecDecodeSelf(d)
	}
	for {
		yyj2401++
		if yyhl2401 {
			yyb2401 = yyj2401 > l
		} else {
			yyb2401 = r.CheckBreak()
		}
		if yyb2401 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2401-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2406 := z.EncBinary()
		_ = yym2406
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2407 := !z.EncBinary()
			yy2arr2407 := z.EncBasicHandle().StructToArray
			var yyq2407 [4]bool
			_, _, _ = yysep2407, yyq2407, yy2arr2407
			const yyr2407 bool = false
			yyq2407[0] = x.Kind != ""
			yyq2407[1] = x.APIVersion != ""
			yyq2407[2] = true
			var yynn2407 int
			if yyr2407 || yy2arr2407 {
				r.EncodeArrayStart(4)
			} else {
				yynn2407 = 1
				for _, b := range yyq2407 {
					if b {
						yynn2407++
					}
				}
				r.EncodeMapStart(yynn2407)
				yynn2407 = 0
			}
			if yyr2407 || yy2arr2407 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2407[0] {
					yym2409 := z.EncBinary()
					_ = yym2409
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2407[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2410 := z.EncBinary()
					_ = yym2410
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2407 || yy2arr2407 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2407[1] {
					yym2412 := z.EncBinary()
					_ = yym2412
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2407[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2413 := z.EncBinary()
					_ = yym2413
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2407 || yy2arr2407 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2407[2] {
					yy2415 := &x.ListMeta
					yym2416 := z.EncBinary()
					_ = yym2416
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2415) {
					} else {
						z.EncFallback(yy2415)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2407[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2417 := &x.ListMeta
					yym2418 := z.EncBinary()
					_ = yym2418
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2417) {
					} else {
						z.EncFallback(yy2417)
					}
				}
			}
			if yyr2407 || yy2arr2407 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2420 := z.EncBinary()
					_ = yym2420
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2421 := z.EncBinary()
					_ = yym2421
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr2407 || yy2arr2407 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2422 := z.DecBinary()
	_ = yym2422
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2423 := r.ContainerType()
		if yyct2423 == codecSelferValueTypeMap1234 {
			yyl2423 := r.ReadMapStart()
			if yyl2423 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2423, d)
			}
		} else if yyct2423 == codecSelferValueTypeArray1234 {
			yyl2423 := r.ReadArrayStart()
			if yyl2423 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2423, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2424Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2424Slc
	var yyhl2424 bool = l >= 0
	for yyj2424 := 0; ; yyj2424++ {
		if yyhl2424 {
			if yyj2424 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2424Slc = r.DecodeBytes(yys2424Slc, true, true)
		yys2424 := string(yys2424Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2424 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2427 := &x.ListMeta
				yym2428 := z.DecBinary()
				_ = yym2428
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2427) {
				} else {
					z.DecFallback(yyv2427, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2429 := &x.Items
				yym2430 := z.DecBinary()
				_ = yym2430
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv2429), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2424)
		} // end switch yys2424
	} // end for yyj2424
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2431 int
	var yyb2431 bool
	var yyhl2431 bool = l >= 0
	yyj2431++
	if yyhl2431 {
		yyb2431 = yyj2431 > l
	} else {
		yyb2431 = r.CheckBreak()
	}
	if yyb2431 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2431++
	if yyhl2431 {
		yyb2431 = yyj2431 > l
	} else {
		yyb2431 = r.CheckBreak()
	}
	if yyb2431 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2431++
	if yyhl2431 {
		yyb2431 = yyj2431 > l
	} else {
		yyb2431 = r.CheckBreak()
	}
	if yyb2431 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2434 := &x.ListMeta
		yym2435 := z.DecBinary()
		_ = yym2435
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2434) {
		} else {
			z.DecFallback(yyv2434, false)
		}
	}
	yyj2431++
	if yyhl2431 {
		yyb2431 = yyj2431 > l
	} else {
		yyb2431 = r.CheckBreak()
	}
	if yyb2431 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2436 := &x.Items
		yym2437 := z.DecBinary()
		_ = yym2437
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv2436), d)
		}
	}
	for {
		yyj2431++
		if yyhl2431 {
			yyb2431 = yyj2431 > l
		} else {
			yyb2431 = r.CheckBreak()
		}
		if yyb2431 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2431-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2438 := z.EncBinary()
		_ = yym2438
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2439 := !z.EncBinary()
			yy2arr2439 := z.EncBasicHandle().StructToArray
			var yyq2439 [4]bool
			_, _, _ = yysep2439, yyq2439, yy2arr2439
			const yyr2439 bool = false
			yyq2439[1] = x.MinReadySeconds != 0
			yyq2439[3] = x.Template != nil
			var yynn2439 int
			if yyr2439 || yy2arr2439 {
				r.EncodeArrayStart(4)
			} else {
				yynn2439 = 2
				for _, b := range yyq2439 {
					if b {
						yynn2439++
					}
				}
				r.EncodeMapStart(yynn2439)
				yynn2439 = 0
			}
			if yyr2439 || yy2arr2439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2441 := z.EncBinary()
				_ = yym2441
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2442 := z.EncBinary()
				_ = yym2442
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2439 || yy2arr2439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2439[1] {
					yym2444 := z.EncBinary()
					_ = yym2444
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2439[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2445 := z.EncBinary()
					_ = yym2445
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr2439 || yy2arr2439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2447 := z.EncBinary()
					_ = yym2447
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("selector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2448 := z.EncBinary()
					_ = yym2448
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			}
			if yyr2439 || yy2arr2439 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2439[3] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2439[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2439 || yy2arr2439 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2450 := z.DecBinary()
	_ = yym2450
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2451 := r.ContainerType()
		if yyct2451 == codecSelferValueTypeMap1234 {
			yyl2451 := r.ReadMapStart()
			if yyl2451 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2451, d)
			}
		} else if yyct2451 == codecSelferValueTypeArray1234 {
			yyl2451 := r.ReadArrayStart()
			if yyl2451 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2451, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2452Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2452Slc
	var yyhl2452 bool = l >= 0
	for yyj2452 := 0; ; yyj2452++ {
		if yyhl2452 {
			if yyj2452 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2452Slc = r.DecodeBytes(yys2452Slc, true, true)
		yys2452 := string(yys2452Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2452 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2455 := &x.Selector
				yym2456 := z.DecBinary()
				_ = yym2456
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2455, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2452)
		} // end switch yys2452
	} // end for yyj2452
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2458 int
	var yyb2458 bool
	var yyhl2458 bool = l >= 0
	yyj2458++
	if yyhl2458 {
		yyb2458 = yyj2458 > l
	} else {
		yyb2458 = r.CheckBreak()
	}
	if yyb2458 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj2458++
	if yyhl2458 {
		yyb2458 = yyj2458 > l
	} else {
		yyb2458 = r.CheckBreak()
	}
	if yyb2458 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj2458++
	if yyhl2458 {
		yyb2458 = yyj2458 > l
	} else {
		yyb2458 = r.CheckBreak()
	}
	if yyb2458 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2461 := &x.Selector
		yym2462 := z.DecBinary()
		_ = yym2462
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2461, false, d)
		}
	}
	yyj2458++
	if yyhl2458 {
		yyb2458 = yyj2458 > l
	} else {
		yyb2458 = r.CheckBreak()
	}
	if yyb2458 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj2458++
		if yyhl2458 {
			yyb2458 = yyj2458 > l
		} else {
			yyb2458 = r.CheckBreak()
		}
		if yyb2458 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2458-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2464 := z.EncBinary()
		_ = yym2464
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2465 := !z.EncBinary()
			yy2arr2465 := z.EncBasicHandle().StructToArray
			var yyq2465 [6]bool
			_, _, _ = yysep2465, yyq2465, yy2arr2465
			const yyr2465 bool = false
			yyq2465[1] = x.FullyLabeledReplicas != 0
			yyq2465[2] = x.ReadyReplicas != 0
			yyq2465[3] = x.AvailableReplicas != 0
			yyq2465[4] = x.ObservedGeneration != 0
			yyq2465[5] = len(x.Conditions) != 0
			var yynn2465 int
			if yyr2465 || yy2arr2465 {
				r.EncodeArrayStart(6)
			} else {
				yynn2465 = 1
				for _, b := range yyq2465 {
					if b {
						yynn2465++
					}
				}
				r.EncodeMapStart(yynn2465)
				yynn2465 = 0
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2467 := z.EncBinary()
				_ = yym2467
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2468 := z.EncBinary()
				_ = yym2468
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2465[1] {
					yym2470 := z.EncBinary()
					_ = yym2470
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2465[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2471 := z.EncBinary()
					_ = yym2471
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2465[2] {
					yym2473 := z.EncBinary()
					_ = yym2473
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2465[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2474 := z.EncBinary()
					_ = yym2474
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2465[3] {
					yym2476 := z.EncBinary()
					_ = yym2476
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2465[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2477 := z.EncBinary()
					_ = yym2477
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2465[4] {
					yym2479 := z.EncBinary()
					_ = yym2479
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2465[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2480 := z.EncBinary()
					_ = yym2480
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2465[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2482 := z.EncBinary()
						_ = yym2482
						if false {
						} else {
							h.encSliceReplicationControllerCondition(([]ReplicationControllerCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2465[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym2483 := z.EncBinary()
						_ = yym2483
						if false {
						} else {
							h.encSliceReplicationControllerCondition(([]ReplicationControllerCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2465 || yy2arr2465 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2484 := z.DecBinary()
	_ = yym2484
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2485 := r.ContainerType()
		if yyct2485 == codecSelferValueTypeMap1234 {
			yyl2485 := r.ReadMapStart()
			if yyl2485 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2485, d)
			}
		} else if yyct2485 == codecSelferValueTypeArray1234 {
			yyl2485 := r.ReadArrayStart()
			if yyl2485 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2485, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2486Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2486Slc
	var yyhl2486 bool = l >= 0
	for yyj2486 := 0; ; yyj2486++ {
		if yyhl2486 {
			if yyj2486 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2486Slc = r.DecodeBytes(yys2486Slc, true, true)
		yys2486 := string(yys2486Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2486 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv2492 := &x.Conditions
				yym2493 := z.DecBinary()
				_ = yym2493
				if false {
				} else {
					h.decSliceReplicationControllerCondition((*[]ReplicationControllerCondition)(yyv2492), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2486)
		} // end switch yys2486
	} // end for yyj2486
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2494 int
	var yyb2494 bool
	var yyhl2494 bool = l >= 0
	yyj2494++
	if yyhl2494 {
		yyb2494 = yyj2494 > l
	} else {
		yyb2494 = r.CheckBreak()
	}
	if yyb2494 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj2494++
	if yyhl2494 {
		yyb2494 = yyj2494 > l
	} else {
		yyb2494 = r.CheckBreak()
	}
	if yyb2494 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj2494++
	if yyhl2494 {
		yyb2494 = yyj2494 > l
	} else {
		yyb2494 = r.CheckBreak()
	}
	if yyb2494 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj2494++
	if yyhl2494 {
		yyb2494 = yyj2494 > l
	} else {
		yyb2494 = r.CheckBreak()
	}
	if yyb2494 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj2494++
	if yyhl2494 {
		yyb2494 = yyj2494 > l
	} else {
		yyb2494 = r.CheckBreak()
	}
	if yyb2494 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj2494++
	if yyhl2494 {
		yyb2494 = yyj2494 > l
	} else {
		yyb2494 = r.CheckBreak()
	}
	if yyb2494 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv2500 := &x.Conditions
		yym2501 := z.DecBinary()
		_ = yym2501
		if false {
		} else {
			h.decSliceReplicationControllerCondition((*[]ReplicationControllerCondition)(yyv2500), d)
		}
	}
	for {
		yyj2494++
		if yyhl2494 {
			yyb2494 = yyj2494 > l
		} else {
			yyb2494 = r.CheckBreak()
		}
		if yyb2494 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2494-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ReplicationControllerConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2502 := z.EncBinary()
	_ = yym2502
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ReplicationControllerConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2503 := z.DecBinary()
	_ = yym2503
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ReplicationControllerCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2504 := z.EncBinary()
		_ = yym2504
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2505 := !z.EncBinary()
			yy2arr2505 := z.EncBasicHandle().StructToArray
			var yyq2505 [5]bool
			_, _, _ = yysep2505, yyq2505, yy2arr2505
			const yyr2505 bool = false
			yyq2505[2] = true
			yyq2505[3] = x.Reason != ""
			yyq2505[4] = x.Message != ""
			var yynn2505 int
			if yyr2505 || yy2arr2505 {
				r.EncodeArrayStart(5)
			} else {
				yynn2505 = 2
				for _, b := range yyq2505 {
					if b {
						yynn2505++
					}
				}
				r.EncodeMapStart(yynn2505)
				yynn2505 = 0
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[2] {
					yy2509 := &x.LastTransitionTime
					yym2510 := z.EncBinary()
					_ = yym2510
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2509) {
					} else if yym2510 {
						z.EncBinaryMarshal(yy2509)
					} else if !yym2510 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2509)
					} else {
						z.EncFallback(yy2509)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2505[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2511 := &x.LastTransitionTime
					yym2512 := z.EncBinary()
					_ = yym2512
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2511) {
					} else if yym2512 {
						z.EncBinaryMarshal(yy2511)
					} else if !yym2512 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy2511)
					} else {
						z.EncFallback(yy2511)
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[3] {
					yym2514 := z.EncBinary()
					_ = yym2514
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2515 := z.EncBinary()
					_ = yym2515
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2505[4] {
					yym2517 := z.EncBinary()
					_ = yym2517
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2505[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2518 := z.EncBinary()
					_ = yym2518
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2505 || yy2arr2505 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2519 := z.DecBinary()
	_ = yym2519
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2520 := r.ContainerType()
		if yyct2520 == codecSelferValueTypeMap1234 {
			yyl2520 := r.ReadMapStart()
			if yyl2520 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2520, d)
			}
		} else if yyct2520 == codecSelferValueTypeArray1234 {
			yyl2520 := r.ReadArrayStart()
			if yyl2520 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2520, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2521Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2521Slc
	var yyhl2521 bool = l >= 0
	for yyj2521 := 0; ; yyj2521++ {
		if yyhl2521 {
			if yyj2521 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2521Slc = r.DecodeBytes(yys2521Slc, true, true)
		yys2521 := string(yys2521Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2521 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ReplicationControllerConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = ConditionStatus(r.DecodeString())
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_unversioned.Time{}
			} else {
				yyv2524 := &x.LastTransitionTime
				yym2525 := z.DecBinary()
				_ = yym2525
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2524) {
				} else if yym2525 {
					z.DecBinaryUnmarshal(yyv2524)
				} else if !yym2525 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2524)
				} else {
					z.DecFallback(yyv2524, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2521)
		} // end switch yys2521
	} // end for yyj2521
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2528 int
	var yyb2528 bool
	var yyhl2528 bool = l >= 0
	yyj2528++
	if yyhl2528 {
		yyb2528 = yyj2528 > l
	} else {
		yyb2528 = r.CheckBreak()
	}
	if yyb2528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ReplicationControllerConditionType(r.DecodeString())
	}
	yyj2528++
	if yyhl2528 {
		yyb2528 = yyj2528 > l
	} else {
		yyb2528 = r.CheckBreak()
	}
	if yyb2528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = ConditionStatus(r.DecodeString())
	}
	yyj2528++
	if yyhl2528 {
		yyb2528 = yyj2528 > l
	} else {
		yyb2528 = r.CheckBreak()
	}
	if yyb2528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_unversioned.Time{}
	} else {
		yyv2531 := &x.LastTransitionTime
		yym2532 := z.DecBinary()
		_ = yym2532
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2531) {
		} else if yym2532 {
			z.DecBinaryUnmarshal(yyv2531)
		} else if !yym2532 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2531)
		} else {
			z.DecFallback(yyv2531, false)
		}
	}
	yyj2528++
	if yyhl2528 {
		yyb2528 = yyj2528 > l
	} else {
		yyb2528 = r.CheckBreak()
	}
	if yyb2528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj2528++
	if yyhl2528 {
		yyb2528 = yyj2528 > l
	} else {
		yyb2528 = r.CheckBreak()
	}
	if yyb2528 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj2528++
		if yyhl2528 {
			yyb2528 = yyj2528 > l
		} else {
			yyb2528 = r.CheckBreak()
		}
		if yyb2528 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2528-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2535 := z.EncBinary()
		_ = yym2535
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2536 := !z.EncBinary()
			yy2arr2536 := z.EncBasicHandle().StructToArray
			var yyq2536 [5]bool
			_, _, _ = yysep2536, yyq2536, yy2arr2536
			const yyr2536 bool = false
			yyq2536[0] = x.Kind != ""
			yyq2536[1] = x.APIVersion != ""
			yyq2536[2] = true
			yyq2536[3] = true
			yyq2536[4] = true
			var yynn2536 int
			if yyr2536 || yy2arr2536 {
				r.EncodeArrayStart(5)
			} else {
				yynn2536 = 0
				for _, b := range yyq2536 {
					if b {
						yynn2536++
					}
				}
				r.EncodeMapStart(yynn2536)
				yynn2536 = 0
			}
			if yyr2536 || yy2arr2536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2536[0] {
					yym2538 := z.EncBinary()
					_ = yym2538
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2536[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2539 := z.EncBinary()
					_ = yym2539
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2536 || yy2arr2536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2536[1] {
					yym2541 := z.EncBinary()
					_ = yym2541
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2536[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2542 := z.EncBinary()
					_ = yym2542
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2536 || yy2arr2536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2536[2] {
					yy2544 := &x.ObjectMeta
					yy2544.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2536[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2545 := &x.ObjectMeta
					yy2545.CodecEncodeSelf(e)
				}
			}
			if yyr2536 || yy2arr2536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2536[3] {
					yy2547 := &x.Spec
					yy2547.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2536[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2548 := &x.Spec
					yy2548.CodecEncodeSelf(e)
				}
			}
			if yyr2536 || yy2arr2536 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2536[4] {
					yy2550 := &x.Status
					yy2550.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2536[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2551 := &x.Status
					yy2551.CodecEncodeSelf(e)
				}
			}
			if yyr2536 || yy2arr2536 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2552 := z.DecBinary()
	_ = yym2552
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2553 := r.ContainerType()
		if yyct2553 == codecSelferValueTypeMap1234 {
			yyl2553 := r.ReadMapStart()
			if yyl2553 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2553, d)
			}
		} else if yyct2553 == codecSelferValueTypeArray1234 {
			yyl2553 := r.ReadArrayStart()
			if yyl2553 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2553, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2554Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2554Slc
	var yyhl2554 bool = l >= 0
	for yyj2554 := 0; ; yyj2554++ {
		if yyhl2554 {
			if yyj2554 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2554Slc = r.DecodeBytes(yys2554Slc, true, true)
		yys2554 := string(yys2554Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2554 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2557 := &x.ObjectMeta
				yyv2557.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv2558 := &x.Spec
				yyv2558.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv2559 := &x.Status
				yyv2559.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2554)
		} // end switch yys2554
	} // end for yyj2554
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2560 int
	var yyb2560 bool
	var yyhl2560 bool = l >= 0
	yyj2560++
	if yyhl2560 {
		yyb2560 = yyj2560 > l
	} else {
		yyb2560 = r.CheckBreak()
	}
	if yyb2560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2560++
	if yyhl2560 {
		yyb2560 = yyj2560 > l
	} else {
		yyb2560 = r.CheckBreak()
	}
	if yyb2560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2560++
	if yyhl2560 {
		yyb2560 = yyj2560 > l
	} else {
		yyb2560 = r.CheckBreak()
	}
	if yyb2560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2563 := &x.ObjectMeta
		yyv2563.CodecDecodeSelf(d)
	}
	yyj2560++
	if yyhl2560 {
		yyb2560 = yyj2560 > l
	} else {
		yyb2560 = r.CheckBreak()
	}
	if yyb2560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv2564 := &x.Spec
		yyv2564.CodecDecodeSelf(d)
	}
	yyj2560++
	if yyhl2560 {
		yyb2560 = yyj2560 > l
	} else {
		yyb2560 = r.CheckBreak()
	}
	if yyb2560 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv2565 := &x.Status
		yyv2565.CodecDecodeSelf(d)
	}
	for {
		yyj2560++
		if yyhl2560 {
			yyb2560 = yyj2560 > l
		} else {
			yyb2560 = r.CheckBreak()
		}
		if yyb2560 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2560-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2566 := z.EncBinary()
		_ = yym2566
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2567 := !z.EncBinary()
			yy2arr2567 := z.EncBasicHandle().StructToArray
			var yyq2567 [4]bool
			_, _, _ = yysep2567, yyq2567, yy2arr2567
			const yyr2567 bool = false
			yyq2567[0] = x.Kind != ""
			yyq2567[1] = x.APIVersion != ""
			yyq2567[2] = true
			var yynn2567 int
			if yyr2567 || yy2arr2567 {
				r.EncodeArrayStart(4)
			} else {
				yynn2567 = 1
				for _, b := range yyq2567 {
					if b {
						yynn2567++
					}
				}
				r.EncodeMapStart(yynn2567)
				yynn2567 = 0
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[0] {
					yym2569 := z.EncBinary()
					_ = yym2569
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2567[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2570 := z.EncBinary()
					_ = yym2570
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[1] {
					yym2572 := z.EncBinary()
					_ = yym2572
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2567[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2573 := z.EncBinary()
					_ = yym2573
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2567[2] {
					yy2575 := &x.ListMeta
					yym2576 := z.EncBinary()
					_ = yym2576
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2575) {
					} else {
						z.EncFallback(yy2575)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2567[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2577 := &x.ListMeta
					yym2578 := z.EncBinary()
					_ = yym2578
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2577) {
					} else {
						z.EncFallback(yy2577)
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2580 := z.EncBinary()
					_ = yym2580
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2581 := z.EncBinary()
					_ = yym2581
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr2567 || yy2arr2567 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2582 := z.DecBinary()
	_ = yym2582
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2583 := r.ContainerType()
		if yyct2583 == codecSelferValueTypeMap1234 {
			yyl2583 := r.ReadMapStart()
			if yyl2583 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2583, d)
			}
		} else if yyct2583 == codecSelferValueTypeArray1234 {
			yyl2583 := r.ReadArrayStart()
			if yyl2583 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2583, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2584Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2584Slc
	var yyhl2584 bool = l >= 0
	for yyj2584 := 0; ; yyj2584++ {
		if yyhl2584 {
			if yyj2584 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2584Slc = r.DecodeBytes(yys2584Slc, true, true)
		yys2584 := string(yys2584Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2584 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2587 := &x.ListMeta
				yym2588 := z.DecBinary()
				_ = yym2588
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2587) {
				} else {
					z.DecFallback(yyv2587, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2589 := &x.Items
				yym2590 := z.DecBinary()
				_ = yym2590
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv2589), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2584)
		} // end switch yys2584
	} // end for yyj2584
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2591 int
	var yyb2591 bool
	var yyhl2591 bool = l >= 0
	yyj2591++
	if yyhl2591 {
		yyb2591 = yyj2591 > l
	} else {
		yyb2591 = r.CheckBreak()
	}
	if yyb2591 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2591++
	if yyhl2591 {
		yyb2591 = yyj2591 > l
	} else {
		yyb2591 = r.CheckBreak()
	}
	if yyb2591 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2591++
	if yyhl2591 {
		yyb2591 = yyj2591 > l
	} else {
		yyb2591 = r.CheckBreak()
	}
	if yyb2591 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2594 := &x.ListMeta
		yym2595 := z.DecBinary()
		_ = yym2595
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2594) {
		} else {
			z.DecFallback(yyv2594, false)
		}
	}
	yyj2591++
	if yyhl2591 {
		yyb2591 = yyj2591 > l
	} else {
		yyb2591 = r.CheckBreak()
	}
	if yyb2591 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2596 := &x.Items
		yym2597 := z.DecBinary()
		_ = yym2597
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv2596), d)
		}
	}
	for {
		yyj2591++
		if yyhl2591 {
			yyb2591 = yyj2591 > l
		} else {
			yyb2591 = r.CheckBreak()
		}
		if yyb2591 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2591-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2598 := z.EncBinary()
		_ = yym2598
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2599 := !z.EncBinary()
			yy2arr2599 := z.EncBasicHandle().StructToArray
			var yyq2599 [4]bool
			_, _, _ = yysep2599, yyq2599, yy2arr2599
			const yyr2599 bool = false
			yyq2599[0] = x.Kind != ""
			yyq2599[1] = x.APIVersion != ""
			yyq2599[2] = true
			var yynn2599 int
			if yyr2599 || yy2arr2599 {
				r.EncodeArrayStart(4)
			} else {
				yynn2599 = 1
				for _, b := range yyq2599 {
					if b {
						yynn2599++
					}
				}
				r.EncodeMapStart(yynn2599)
				yynn2599 = 0
			}
			if yyr2599 || yy2arr2599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2599[0] {
					yym2601 := z.EncBinary()
					_ = yym2601
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2599[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2602 := z.EncBinary()
					_ = yym2602
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2599 || yy2arr2599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2599[1] {
					yym2604 := z.EncBinary()
					_ = yym2604
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2599[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2605 := z.EncBinary()
					_ = yym2605
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2599 || yy2arr2599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2599[2] {
					yy2607 := &x.ListMeta
					yym2608 := z.EncBinary()
					_ = yym2608
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2607) {
					} else {
						z.EncFallback(yy2607)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2599[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2609 := &x.ListMeta
					yym2610 := z.EncBinary()
					_ = yym2610
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2609) {
					} else {
						z.EncFallback(yy2609)
					}
				}
			}
			if yyr2599 || yy2arr2599 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2612 := z.EncBinary()
					_ = yym2612
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2613 := z.EncBinary()
					_ = yym2613
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr2599 || yy2arr2599 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2614 := z.DecBinary()
	_ = yym2614
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2615 := r.ContainerType()
		if yyct2615 == codecSelferValueTypeMap1234 {
			yyl2615 := r.ReadMapStart()
			if yyl2615 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2615, d)
			}
		} else if yyct2615 == codecSelferValueTypeArray1234 {
			yyl2615 := r.ReadArrayStart()
			if yyl2615 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2615, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2616Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2616Slc
	var yyhl2616 bool = l >= 0
	for yyj2616 := 0; ; yyj2616++ {
		if yyhl2616 {
			if yyj2616 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2616Slc = r.DecodeBytes(yys2616Slc, true, true)
		yys2616 := string(yys2616Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2616 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2619 := &x.ListMeta
				yym2620 := z.DecBinary()
				_ = yym2620
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2619) {
				} else {
					z.DecFallback(yyv2619, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2621 := &x.Items
				yym2622 := z.DecBinary()
				_ = yym2622
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv2621), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2616)
		} // end switch yys2616
	} // end for yyj2616
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2623 int
	var yyb2623 bool
	var yyhl2623 bool = l >= 0
	yyj2623++
	if yyhl2623 {
		yyb2623 = yyj2623 > l
	} else {
		yyb2623 = r.CheckBreak()
	}
	if yyb2623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2623++
	if yyhl2623 {
		yyb2623 = yyj2623 > l
	} else {
		yyb2623 = r.CheckBreak()
	}
	if yyb2623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2623++
	if yyhl2623 {
		yyb2623 = yyj2623 > l
	} else {
		yyb2623 = r.CheckBreak()
	}
	if yyb2623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2626 := &x.ListMeta
		yym2627 := z.DecBinary()
		_ = yym2627
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2626) {
		} else {
			z.DecFallback(yyv2626, false)
		}
	}
	yyj2623++
	if yyhl2623 {
		yyb2623 = yyj2623 > l
	} else {
		yyb2623 = r.CheckBreak()
	}
	if yyb2623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2628 := &x.Items
		yym2629 := z.DecBinary()
		_ = yym2629
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv2628), d)
		}
	}
	for {
		yyj2623++
		if yyhl2623 {
			yyb2623 = yyj2623 > l
		} else {
			yyb2623 = r.CheckBreak()
		}
		if yyb2623 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2623-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2630 := z.EncBinary()
	_ = yym2630
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2631 := z.DecBinary()
	_ = yym2631
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym2632 := z.EncBinary()
	_ = yym2632
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2633 := z.DecBinary()
	_ = yym2633
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2634 := z.EncBinary()
		_ = yym2634
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2635 := !z.EncBinary()
			yy2arr2635 := z.EncBasicHandle().StructToArray
			var yyq2635 [1]bool
			_, _, _ = yysep2635, yyq2635, yy2arr2635
			const yyr2635 bool = false
			yyq2635[0] = true
			var yynn2635 int
			if yyr2635 || yy2arr2635 {
				r.EncodeArrayStart(1)
			} else {
				yynn2635 = 0
				for _, b := range yyq2635 {
					if b {
						yynn2635++
					}
				}
				r.EncodeMapStart(yynn2635)
				yynn2635 = 0
			}
			if yyr2635 || yy2arr2635 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2635[0] {
					yy2637 := &x.LoadBalancer
					yy2637.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2635[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2638 := &x.LoadBalancer
					yy2638.CodecEncodeSelf(e)
				}
			}
			if yyr2635 || yy2arr2635 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2639 := z.DecBinary()
	_ = yym2639
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2640 := r.ContainerType()
		if yyct2640 == codecSelferValueTypeMap1234 {
			yyl2640 := r.ReadMapStart()
			if yyl2640 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2640, d)
			}
		} else if yyct2640 == codecSelferValueTypeArray1234 {
			yyl2640 := r.ReadArrayStart()
			if yyl2640 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2640, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2641Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2641Slc
	var yyhl2641 bool = l >= 0
	for yyj2641 := 0; ; yyj2641++ {
		if yyhl2641 {
			if yyj2641 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2641Slc = r.DecodeBytes(yys2641Slc, true, true)
		yys2641 := string(yys2641Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2641 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv2642 := &x.LoadBalancer
				yyv2642.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2641)
		} // end switch yys2641
	} // end for yyj2641
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2643 int
	var yyb2643 bool
	var yyhl2643 bool = l >= 0
	yyj2643++
	if yyhl2643 {
		yyb2643 = yyj2643 > l
	} else {
		yyb2643 = r.CheckBreak()
	}
	if yyb2643 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv2644 := &x.LoadBalancer
		yyv2644.CodecDecodeSelf(d)
	}
	for {
		yyj2643++
		if yyhl2643 {
			yyb2643 = yyj2643 > l
		} else {
			yyb2643 = r.CheckBreak()
		}
		if yyb2643 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2643-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2645 := z.EncBinary()
		_ = yym2645
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2646 := !z.EncBinary()
			yy2arr2646 := z.EncBasicHandle().StructToArray
			var yyq2646 [1]bool
			_, _, _ = yysep2646, yyq2646, yy2arr2646
			const yyr2646 bool = false
			yyq2646[0] = len(x.Ingress) != 0
			var yynn2646 int
			if yyr2646 || yy2arr2646 {
				r.EncodeArrayStart(1)
			} else {
				yynn2646 = 0
				for _, b := range yyq2646 {
					if b {
						yynn2646++
					}
				}
				r.EncodeMapStart(yynn2646)
				yynn2646 = 0
			}
			if yyr2646 || yy2arr2646 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2646[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2648 := z.EncBinary()
						_ = yym2648
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2646[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym2649 := z.EncBinary()
						_ = yym2649
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr2646 || yy2arr2646 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2650 := z.DecBinary()
	_ = yym2650
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2651 := r.ContainerType()
		if yyct2651 == codecSelferValueTypeMap1234 {
			yyl2651 := r.ReadMapStart()
			if yyl2651 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2651, d)
			}
		} else if yyct2651 == codecSelferValueTypeArray1234 {
			yyl2651 := r.ReadArrayStart()
			if yyl2651 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2651, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2652Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2652Slc
	var yyhl2652 bool = l >= 0
	for yyj2652 := 0; ; yyj2652++ {
		if yyhl2652 {
			if yyj2652 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2652Slc = r.DecodeBytes(yys2652Slc, true, true)
		yys2652 := string(yys2652Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2652 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv2653 := &x.Ingress
				yym2654 := z.DecBinary()
				_ = yym2654
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2653), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2652)
		} // end switch yys2652
	} // end for yyj2652
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2655 int
	var yyb2655 bool
	var yyhl2655 bool = l >= 0
	yyj2655++
	if yyhl2655 {
		yyb2655 = yyj2655 > l
	} else {
		yyb2655 = r.CheckBreak()
	}
	if yyb2655 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv2656 := &x.Ingress
		yym2657 := z.DecBinary()
		_ = yym2657
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv2656), d)
		}
	}
	for {
		yyj2655++
		if yyhl2655 {
			yyb2655 = yyj2655 > l
		} else {
			yyb2655 = r.CheckBreak()
		}
		if yyb2655 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2655-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2658 := z.EncBinary()
		_ = yym2658
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2659 := !z.EncBinary()
			yy2arr2659 := z.EncBasicHandle().StructToArray
			var yyq2659 [2]bool
			_, _, _ = yysep2659, yyq2659, yy2arr2659
			const yyr2659 bool = false
			yyq2659[0] = x.IP != ""
			yyq2659[1] = x.Hostname != ""
			var yynn2659 int
			if yyr2659 || yy2arr2659 {
				r.EncodeArrayStart(2)
			} else {
				yynn2659 = 0
				for _, b := range yyq2659 {
					if b {
						yynn2659++
					}
				}
				r.EncodeMapStart(yynn2659)
				yynn2659 = 0
			}
			if yyr2659 || yy2arr2659 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2659[0] {
					yym2661 := z.EncBinary()
					_ = yym2661
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2659[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2662 := z.EncBinary()
					_ = yym2662
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr2659 || yy2arr2659 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2659[1] {
					yym2664 := z.EncBinary()
					_ = yym2664
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2659[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2665 := z.EncBinary()
					_ = yym2665
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2659 || yy2arr2659 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2666 := z.DecBinary()
	_ = yym2666
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2667 := r.ContainerType()
		if yyct2667 == codecSelferValueTypeMap1234 {
			yyl2667 := r.ReadMapStart()
			if yyl2667 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2667, d)
			}
		} else if yyct2667 == codecSelferValueTypeArray1234 {
			yyl2667 := r.ReadArrayStart()
			if yyl2667 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2667, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2668Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2668Slc
	var yyhl2668 bool = l >= 0
	for yyj2668 := 0; ; yyj2668++ {
		if yyhl2668 {
			if yyj2668 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2668Slc = r.DecodeBytes(yys2668Slc, true, true)
		yys2668 := string(yys2668Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2668 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2668)
		} // end switch yys2668
	} // end for yyj2668
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2671 int
	var yyb2671 bool
	var yyhl2671 bool = l >= 0
	yyj2671++
	if yyhl2671 {
		yyb2671 = yyj2671 > l
	} else {
		yyb2671 = r.CheckBreak()
	}
	if yyb2671 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2671++
	if yyhl2671 {
		yyb2671 = yyj2671 > l
	} else {
		yyb2671 = r.CheckBreak()
	}
	if yyb2671 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	for {
		yyj2671++
		if yyhl2671 {
			yyb2671 = yyj2671 > l
		} else {
			yyb2671 = r.CheckBreak()
		}
		if yyb2671 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2671-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2674 := z.EncBinary()
		_ = yym2674
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2675 := !z.EncBinary()
			yy2arr2675 := z.EncBasicHandle().StructToArray
			var yyq2675 [9]bool
			_, _, _ = yysep2675, yyq2675, yy2arr2675
			const yyr2675 bool = false
			yyq2675[0] = x.Type != ""
			yyq2675[3] = x.ClusterIP != ""
			yyq2675[5] = len(x.ExternalIPs) != 0
			yyq2675[6] = x.LoadBalancerIP != ""
			yyq2675[7] = x.SessionAffinity != ""
			yyq2675[8] = len(x.LoadBalancerSourceRanges) != 0
			var yynn2675 int
			if yyr2675 || yy2arr2675 {
				r.EncodeArrayStart(9)
			} else {
				yynn2675 = 3
				for _, b := range yyq2675 {
					if b {
						yynn2675++
					}
				}
				r.EncodeMapStart(yynn2675)
				yynn2675 = 0
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2675[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2675[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2678 := z.EncBinary()
					_ = yym2678
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2679 := z.EncBinary()
					_ = yym2679
					if false {
					} else {
						h.encSliceServicePort(([]ServicePort)(x.Ports), e)
					}
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2681 := z.EncBinary()
					_ = yym2681
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("selector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Selector == nil {
					r.EncodeNil()
				} else {
					yym2682 := z.EncBinary()
					_ = yym2682
					if false {
					} else {
						z.F.EncMapStringStringV(x.Selector, false, e)
					}
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2675[3] {
					yym2684 := z.EncBinary()
					_ = yym2684
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2675[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2685 := z.EncBinary()
					_ = yym2685
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2687 := z.EncBinary()
				_ = yym2687
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ExternalName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2688 := z.EncBinary()
				_ = yym2688
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2675[5] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2690 := z.EncBinary()
						_ = yym2690
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2675[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym2691 := z.EncBinary()
						_ = yym2691
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2675[6] {
					yym2693 := z.EncBinary()
					_ = yym2693
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2675[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2694 := z.EncBinary()
					_ = yym2694
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2675[7] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2675[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2675[8] {
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2697 := z.EncBinary()
						_ = yym2697
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2675[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerSourceRanges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym2698 := z.EncBinary()
						_ = yym2698
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				}
			}
			if yyr2675 || yy2arr2675 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2699 := z.DecBinary()
	_ = yym2699
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2700 := r.ContainerType()
		if yyct2700 == codecSelferValueTypeMap1234 {
			yyl2700 := r.ReadMapStart()
			if yyl2700 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2700, d)
			}
		} else if yyct2700 == codecSelferValueTypeArray1234 {
			yyl2700 := r.ReadArrayStart()
			if yyl2700 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2700, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2701Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2701Slc
	var yyhl2701 bool = l >= 0
	for yyj2701 := 0; ; yyj2701++ {
		if yyhl2701 {
			if yyj2701 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2701Slc = r.DecodeBytes(yys2701Slc, true, true)
		yys2701 := string(yys2701Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2701 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ServiceType(r.DecodeString())
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2703 := &x.Ports
				yym2704 := z.DecBinary()
				_ = yym2704
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv2703), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv2705 := &x.Selector
				yym2706 := z.DecBinary()
				_ = yym2706
				if false {
				} else {
					z.F.DecMapStringStringX(yyv2705, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				x.ClusterIP = string(r.DecodeString())
			}
		case "ExternalName":
			if r.TryDecodeAsNil() {
				x.ExternalName = ""
			} else {
				x.ExternalName = string(r.DecodeString())
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv2709 := &x.ExternalIPs
				yym2710 := z.DecBinary()
				_ = yym2710
				if false {
				} else {
					z.F.DecSliceStringX(yyv2709, false, d)
				}
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				x.LoadBalancerIP = string(r.DecodeString())
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				x.SessionAffinity = ServiceAffinity(r.DecodeString())
			}
		case "loadBalancerSourceRanges":
			if r.TryDecodeAsNil() {
				x.LoadBalancerSourceRanges = nil
			} else {
				yyv2713 := &x.LoadBalancerSourceRanges
				yym2714 := z.DecBinary()
				_ = yym2714
				if false {
				} else {
					z.F.DecSliceStringX(yyv2713, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2701)
		} // end switch yys2701
	} // end for yyj2701
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2715 int
	var yyb2715 bool
	var yyhl2715 bool = l >= 0
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ServiceType(r.DecodeString())
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2717 := &x.Ports
		yym2718 := z.DecBinary()
		_ = yym2718
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv2717), d)
		}
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv2719 := &x.Selector
		yym2720 := z.DecBinary()
		_ = yym2720
		if false {
		} else {
			z.F.DecMapStringStringX(yyv2719, false, d)
		}
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		x.ClusterIP = string(r.DecodeString())
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalName = ""
	} else {
		x.ExternalName = string(r.DecodeString())
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv2723 := &x.ExternalIPs
		yym2724 := z.DecBinary()
		_ = yym2724
		if false {
		} else {
			z.F.DecSliceStringX(yyv2723, false, d)
		}
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		x.LoadBalancerIP = string(r.DecodeString())
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		x.SessionAffinity = ServiceAffinity(r.DecodeString())
	}
	yyj2715++
	if yyhl2715 {
		yyb2715 = yyj2715 > l
	} else {
		yyb2715 = r.CheckBreak()
	}
	if yyb2715 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerSourceRanges = nil
	} else {
		yyv2727 := &x.LoadBalancerSourceRanges
		yym2728 := z.DecBinary()
		_ = yym2728
		if false {
		} else {
			z.F.DecSliceStringX(yyv2727, false, d)
		}
	}
	for {
		yyj2715++
		if yyhl2715 {
			yyb2715 = yyj2715 > l
		} else {
			yyb2715 = r.CheckBreak()
		}
		if yyb2715 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2715-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2729 := z.EncBinary()
		_ = yym2729
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2730 := !z.EncBinary()
			yy2arr2730 := z.EncBasicHandle().StructToArray
			var yyq2730 [5]bool
			_, _, _ = yysep2730, yyq2730, yy2arr2730
			const yyr2730 bool = false
			var yynn2730 int
			if yyr2730 || yy2arr2730 {
				r.EncodeArrayStart(5)
			} else {
				yynn2730 = 5
				for _, b := range yyq2730 {
					if b {
						yynn2730++
					}
				}
				r.EncodeMapStart(yynn2730)
				yynn2730 = 0
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2732 := z.EncBinary()
				_ = yym2732
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2733 := z.EncBinary()
				_ = yym2733
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Protocol.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("protocol"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Protocol.CodecEncodeSelf(e)
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2736 := z.EncBinary()
				_ = yym2736
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2737 := z.EncBinary()
				_ = yym2737
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy2739 := &x.TargetPort
				yym2740 := z.EncBinary()
				_ = yym2740
				if false {
				} else if z.HasExtensions() && z.EncExt(yy2739) {
				} else if !yym2740 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy2739)
				} else {
					z.EncFallback(yy2739)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy2741 := &x.TargetPort
				yym2742 := z.EncBinary()
				_ = yym2742
				if false {
				} else if z.HasExtensions() && z.EncExt(yy2741) {
				} else if !yym2742 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy2741)
				} else {
					z.EncFallback(yy2741)
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2744 := z.EncBinary()
				_ = yym2744
				if false {
				} else {
					r.EncodeInt(int64(x.NodePort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2745 := z.EncBinary()
				_ = yym2745
				if false {
				} else {
					r.EncodeInt(int64(x.NodePort))
				}
			}
			if yyr2730 || yy2arr2730 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2746 := z.DecBinary()
	_ = yym2746
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2747 := r.ContainerType()
		if yyct2747 == codecSelferValueTypeMap1234 {
			yyl2747 := r.ReadMapStart()
			if yyl2747 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2747, d)
			}
		} else if yyct2747 == codecSelferValueTypeArray1234 {
			yyl2747 := r.ReadArrayStart()
			if yyl2747 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2747, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2748Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2748Slc
	var yyhl2748 bool = l >= 0
	for yyj2748 := 0; ; yyj2748++ {
		if yyhl2748 {
			if yyj2748 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2748Slc = r.DecodeBytes(yys2748Slc, true, true)
		yys2748 := string(yys2748Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2748 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg4_intstr.IntOrString{}
			} else {
				yyv2752 := &x.TargetPort
				yym2753 := z.DecBinary()
				_ = yym2753
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2752) {
				} else if !yym2753 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv2752)
				} else {
					z.DecFallback(yyv2752, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				x.NodePort = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys2748)
		} // end switch yys2748
	} // end for yyj2748
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2755 int
	var yyb2755 bool
	var yyhl2755 bool = l >= 0
	yyj2755++
	if yyhl2755 {
		yyb2755 = yyj2755 > l
	} else {
		yyb2755 = r.CheckBreak()
	}
	if yyb2755 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2755++
	if yyhl2755 {
		yyb2755 = yyj2755 > l
	} else {
		yyb2755 = r.CheckBreak()
	}
	if yyb2755 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	yyj2755++
	if yyhl2755 {
		yyb2755 = yyj2755 > l
	} else {
		yyb2755 = r.CheckBreak()
	}
	if yyb2755 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2755++
	if yyhl2755 {
		yyb2755 = yyj2755 > l
	} else {
		yyb2755 = r.CheckBreak()
	}
	if yyb2755 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg4_intstr.IntOrString{}
	} else {
		yyv2759 := &x.TargetPort
		yym2760 := z.DecBinary()
		_ = yym2760
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2759) {
		} else if !yym2760 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv2759)
		} else {
			z.DecFallback(yyv2759, false)
		}
	}
	yyj2755++
	if yyhl2755 {
		yyb2755 = yyj2755 > l
	} else {
		yyb2755 = r.CheckBreak()
	}
	if yyb2755 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		x.NodePort = int32(r.DecodeInt(32))
	}
	for {
		yyj2755++
		if yyhl2755 {
			yyb2755 = yyj2755 > l
		} else {
			yyb2755 = r.CheckBreak()
		}
		if yyb2755 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2755-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2762 := z.EncBinary()
		_ = yym2762
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2763 := !z.EncBinary()
			yy2arr2763 := z.EncBasicHandle().StructToArray
			var yyq2763 [5]bool
			_, _, _ = yysep2763, yyq2763, yy2arr2763
			const yyr2763 bool = false
			yyq2763[0] = x.Kind != ""
			yyq2763[1] = x.APIVersion != ""
			yyq2763[2] = true
			yyq2763[3] = true
			yyq2763[4] = true
			var yynn2763 int
			if yyr2763 || yy2arr2763 {
				r.EncodeArrayStart(5)
			} else {
				yynn2763 = 0
				for _, b := range yyq2763 {
					if b {
						yynn2763++
					}
				}
				r.EncodeMapStart(yynn2763)
				yynn2763 = 0
			}
			if yyr2763 || yy2arr2763 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2763[0] {
					yym2765 := z.EncBinary()
					_ = yym2765
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2763[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2766 := z.EncBinary()
					_ = yym2766
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2763 || yy2arr2763 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2763[1] {
					yym2768 := z.EncBinary()
					_ = yym2768
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2763[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2769 := z.EncBinary()
					_ = yym2769
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2763 || yy2arr2763 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2763[2] {
					yy2771 := &x.ObjectMeta
					yy2771.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2763[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2772 := &x.ObjectMeta
					yy2772.CodecEncodeSelf(e)
				}
			}
			if yyr2763 || yy2arr2763 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2763[3] {
					yy2774 := &x.Spec
					yy2774.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2763[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2775 := &x.Spec
					yy2775.CodecEncodeSelf(e)
				}
			}
			if yyr2763 || yy2arr2763 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2763[4] {
					yy2777 := &x.Status
					yy2777.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2763[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2778 := &x.Status
					yy2778.CodecEncodeSelf(e)
				}
			}
			if yyr2763 || yy2arr2763 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2779 := z.DecBinary()
	_ = yym2779
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2780 := r.ContainerType()
		if yyct2780 == codecSelferValueTypeMap1234 {
			yyl2780 := r.ReadMapStart()
			if yyl2780 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2780, d)
			}
		} else if yyct2780 == codecSelferValueTypeArray1234 {
			yyl2780 := r.ReadArrayStart()
			if yyl2780 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2780, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2781Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2781Slc
	var yyhl2781 bool = l >= 0
	for yyj2781 := 0; ; yyj2781++ {
		if yyhl2781 {
			if yyj2781 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2781Slc = r.DecodeBytes(yys2781Slc, true, true)
		yys2781 := string(yys2781Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2781 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2784 := &x.ObjectMeta
				yyv2784.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv2785 := &x.Spec
				yyv2785.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv2786 := &x.Status
				yyv2786.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2781)
		} // end switch yys2781
	} // end for yyj2781
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2787 int
	var yyb2787 bool
	var yyhl2787 bool = l >= 0
	yyj2787++
	if yyhl2787 {
		yyb2787 = yyj2787 > l
	} else {
		yyb2787 = r.CheckBreak()
	}
	if yyb2787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2787++
	if yyhl2787 {
		yyb2787 = yyj2787 > l
	} else {
		yyb2787 = r.CheckBreak()
	}
	if yyb2787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2787++
	if yyhl2787 {
		yyb2787 = yyj2787 > l
	} else {
		yyb2787 = r.CheckBreak()
	}
	if yyb2787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2790 := &x.ObjectMeta
		yyv2790.CodecDecodeSelf(d)
	}
	yyj2787++
	if yyhl2787 {
		yyb2787 = yyj2787 > l
	} else {
		yyb2787 = r.CheckBreak()
	}
	if yyb2787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv2791 := &x.Spec
		yyv2791.CodecDecodeSelf(d)
	}
	yyj2787++
	if yyhl2787 {
		yyb2787 = yyj2787 > l
	} else {
		yyb2787 = r.CheckBreak()
	}
	if yyb2787 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv2792 := &x.Status
		yyv2792.CodecDecodeSelf(d)
	}
	for {
		yyj2787++
		if yyhl2787 {
			yyb2787 = yyj2787 > l
		} else {
			yyb2787 = r.CheckBreak()
		}
		if yyb2787 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2787-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2793 := z.EncBinary()
		_ = yym2793
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2794 := !z.EncBinary()
			yy2arr2794 := z.EncBasicHandle().StructToArray
			var yyq2794 [5]bool
			_, _, _ = yysep2794, yyq2794, yy2arr2794
			const yyr2794 bool = false
			yyq2794[0] = x.Kind != ""
			yyq2794[1] = x.APIVersion != ""
			yyq2794[2] = true
			yyq2794[4] = len(x.ImagePullSecrets) != 0
			var yynn2794 int
			if yyr2794 || yy2arr2794 {
				r.EncodeArrayStart(5)
			} else {
				yynn2794 = 1
				for _, b := range yyq2794 {
					if b {
						yynn2794++
					}
				}
				r.EncodeMapStart(yynn2794)
				yynn2794 = 0
			}
			if yyr2794 || yy2arr2794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2794[0] {
					yym2796 := z.EncBinary()
					_ = yym2796
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2794[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2797 := z.EncBinary()
					_ = yym2797
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2794 || yy2arr2794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2794[1] {
					yym2799 := z.EncBinary()
					_ = yym2799
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2794[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2800 := z.EncBinary()
					_ = yym2800
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2794 || yy2arr2794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2794[2] {
					yy2802 := &x.ObjectMeta
					yy2802.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2794[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2803 := &x.ObjectMeta
					yy2803.CodecEncodeSelf(e)
				}
			}
			if yyr2794 || yy2arr2794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Secrets == nil {
					r.EncodeNil()
				} else {
					yym2805 := z.EncBinary()
					_ = yym2805
					if false {
					} else {
						h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secrets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Secrets == nil {
					r.EncodeNil()
				} else {
					yym2806 := z.EncBinary()
					_ = yym2806
					if false {
					} else {
						h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
					}
				}
			}
			if yyr2794 || yy2arr2794 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2794[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2808 := z.EncBinary()
						_ = yym2808
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2794[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym2809 := z.EncBinary()
						_ = yym2809
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2794 || yy2arr2794 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2810 := z.DecBinary()
	_ = yym2810
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2811 := r.ContainerType()
		if yyct2811 == codecSelferValueTypeMap1234 {
			yyl2811 := r.ReadMapStart()
			if yyl2811 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2811, d)
			}
		} else if yyct2811 == codecSelferValueTypeArray1234 {
			yyl2811 := r.ReadArrayStart()
			if yyl2811 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2811, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2812Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2812Slc
	var yyhl2812 bool = l >= 0
	for yyj2812 := 0; ; yyj2812++ {
		if yyhl2812 {
			if yyj2812 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2812Slc = r.DecodeBytes(yys2812Slc, true, true)
		yys2812 := string(yys2812Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2812 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2815 := &x.ObjectMeta
				yyv2815.CodecDecodeSelf(d)
			}
		case "secrets":
			if r.TryDecodeAsNil() {
				x.Secrets = nil
			} else {
				yyv2816 := &x.Secrets
				yym2817 := z.DecBinary()
				_ = yym2817
				if false {
				} else {
					h.decSliceObjectReference((*[]ObjectReference)(yyv2816), d)
				}
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv2818 := &x.ImagePullSecrets
				yym2819 := z.DecBinary()
				_ = yym2819
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2818), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2812)
		} // end switch yys2812
	} // end for yyj2812
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2820 int
	var yyb2820 bool
	var yyhl2820 bool = l >= 0
	yyj2820++
	if yyhl2820 {
		yyb2820 = yyj2820 > l
	} else {
		yyb2820 = r.CheckBreak()
	}
	if yyb2820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2820++
	if yyhl2820 {
		yyb2820 = yyj2820 > l
	} else {
		yyb2820 = r.CheckBreak()
	}
	if yyb2820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2820++
	if yyhl2820 {
		yyb2820 = yyj2820 > l
	} else {
		yyb2820 = r.CheckBreak()
	}
	if yyb2820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2823 := &x.ObjectMeta
		yyv2823.CodecDecodeSelf(d)
	}
	yyj2820++
	if yyhl2820 {
		yyb2820 = yyj2820 > l
	} else {
		yyb2820 = r.CheckBreak()
	}
	if yyb2820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Secrets = nil
	} else {
		yyv2824 := &x.Secrets
		yym2825 := z.DecBinary()
		_ = yym2825
		if false {
		} else {
			h.decSliceObjectReference((*[]ObjectReference)(yyv2824), d)
		}
	}
	yyj2820++
	if yyhl2820 {
		yyb2820 = yyj2820 > l
	} else {
		yyb2820 = r.CheckBreak()
	}
	if yyb2820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv2826 := &x.ImagePullSecrets
		yym2827 := z.DecBinary()
		_ = yym2827
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv2826), d)
		}
	}
	for {
		yyj2820++
		if yyhl2820 {
			yyb2820 = yyj2820 > l
		} else {
			yyb2820 = r.CheckBreak()
		}
		if yyb2820 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2820-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccountList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2828 := z.EncBinary()
		_ = yym2828
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2829 := !z.EncBinary()
			yy2arr2829 := z.EncBasicHandle().StructToArray
			var yyq2829 [4]bool
			_, _, _ = yysep2829, yyq2829, yy2arr2829
			const yyr2829 bool = false
			yyq2829[0] = x.Kind != ""
			yyq2829[1] = x.APIVersion != ""
			yyq2829[2] = true
			var yynn2829 int
			if yyr2829 || yy2arr2829 {
				r.EncodeArrayStart(4)
			} else {
				yynn2829 = 1
				for _, b := range yyq2829 {
					if b {
						yynn2829++
					}
				}
				r.EncodeMapStart(yynn2829)
				yynn2829 = 0
			}
			if yyr2829 || yy2arr2829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2829[0] {
					yym2831 := z.EncBinary()
					_ = yym2831
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2829[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2832 := z.EncBinary()
					_ = yym2832
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2829 || yy2arr2829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2829[1] {
					yym2834 := z.EncBinary()
					_ = yym2834
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2829[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2835 := z.EncBinary()
					_ = yym2835
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2829 || yy2arr2829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2829[2] {
					yy2837 := &x.ListMeta
					yym2838 := z.EncBinary()
					_ = yym2838
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2837) {
					} else {
						z.EncFallback(yy2837)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2829[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2839 := &x.ListMeta
					yym2840 := z.EncBinary()
					_ = yym2840
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2839) {
					} else {
						z.EncFallback(yy2839)
					}
				}
			}
			if yyr2829 || yy2arr2829 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2842 := z.EncBinary()
					_ = yym2842
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2843 := z.EncBinary()
					_ = yym2843
					if false {
					} else {
						h.encSliceServiceAccount(([]ServiceAccount)(x.Items), e)
					}
				}
			}
			if yyr2829 || yy2arr2829 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceAccountList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2844 := z.DecBinary()
	_ = yym2844
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2845 := r.ContainerType()
		if yyct2845 == codecSelferValueTypeMap1234 {
			yyl2845 := r.ReadMapStart()
			if yyl2845 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2845, d)
			}
		} else if yyct2845 == codecSelferValueTypeArray1234 {
			yyl2845 := r.ReadArrayStart()
			if yyl2845 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2845, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceAccountList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2846Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2846Slc
	var yyhl2846 bool = l >= 0
	for yyj2846 := 0; ; yyj2846++ {
		if yyhl2846 {
			if yyj2846 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2846Slc = r.DecodeBytes(yys2846Slc, true, true)
		yys2846 := string(yys2846Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2846 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2849 := &x.ListMeta
				yym2850 := z.DecBinary()
				_ = yym2850
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2849) {
				} else {
					z.DecFallback(yyv2849, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2851 := &x.Items
				yym2852 := z.DecBinary()
				_ = yym2852
				if false {
				} else {
					h.decSliceServiceAccount((*[]ServiceAccount)(yyv2851), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2846)
		} // end switch yys2846
	} // end for yyj2846
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceAccountList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2853 int
	var yyb2853 bool
	var yyhl2853 bool = l >= 0
	yyj2853++
	if yyhl2853 {
		yyb2853 = yyj2853 > l
	} else {
		yyb2853 = r.CheckBreak()
	}
	if yyb2853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2853++
	if yyhl2853 {
		yyb2853 = yyj2853 > l
	} else {
		yyb2853 = r.CheckBreak()
	}
	if yyb2853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2853++
	if yyhl2853 {
		yyb2853 = yyj2853 > l
	} else {
		yyb2853 = r.CheckBreak()
	}
	if yyb2853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2856 := &x.ListMeta
		yym2857 := z.DecBinary()
		_ = yym2857
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2856) {
		} else {
			z.DecFallback(yyv2856, false)
		}
	}
	yyj2853++
	if yyhl2853 {
		yyb2853 = yyj2853 > l
	} else {
		yyb2853 = r.CheckBreak()
	}
	if yyb2853 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2858 := &x.Items
		yym2859 := z.DecBinary()
		_ = yym2859
		if false {
		} else {
			h.decSliceServiceAccount((*[]ServiceAccount)(yyv2858), d)
		}
	}
	for {
		yyj2853++
		if yyhl2853 {
			yyb2853 = yyj2853 > l
		} else {
			yyb2853 = r.CheckBreak()
		}
		if yyb2853 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2853-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Endpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2860 := z.EncBinary()
		_ = yym2860
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2861 := !z.EncBinary()
			yy2arr2861 := z.EncBasicHandle().StructToArray
			var yyq2861 [4]bool
			_, _, _ = yysep2861, yyq2861, yy2arr2861
			const yyr2861 bool = false
			yyq2861[0] = x.Kind != ""
			yyq2861[1] = x.APIVersion != ""
			yyq2861[2] = true
			var yynn2861 int
			if yyr2861 || yy2arr2861 {
				r.EncodeArrayStart(4)
			} else {
				yynn2861 = 1
				for _, b := range yyq2861 {
					if b {
						yynn2861++
					}
				}
				r.EncodeMapStart(yynn2861)
				yynn2861 = 0
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2861[0] {
					yym2863 := z.EncBinary()
					_ = yym2863
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2861[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2864 := z.EncBinary()
					_ = yym2864
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2861[1] {
					yym2866 := z.EncBinary()
					_ = yym2866
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2861[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2867 := z.EncBinary()
					_ = yym2867
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2861[2] {
					yy2869 := &x.ObjectMeta
					yy2869.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2861[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2870 := &x.ObjectMeta
					yy2870.CodecEncodeSelf(e)
				}
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2872 := z.EncBinary()
					_ = yym2872
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Subsets"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subsets == nil {
					r.EncodeNil()
				} else {
					yym2873 := z.EncBinary()
					_ = yym2873
					if false {
					} else {
						h.encSliceEndpointSubset(([]EndpointSubset)(x.Subsets), e)
					}
				}
			}
			if yyr2861 || yy2arr2861 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Endpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2874 := z.DecBinary()
	_ = yym2874
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2875 := r.ContainerType()
		if yyct2875 == codecSelferValueTypeMap1234 {
			yyl2875 := r.ReadMapStart()
			if yyl2875 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2875, d)
			}
		} else if yyct2875 == codecSelferValueTypeArray1234 {
			yyl2875 := r.ReadArrayStart()
			if yyl2875 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2875, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Endpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2876Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2876Slc
	var yyhl2876 bool = l >= 0
	for yyj2876 := 0; ; yyj2876++ {
		if yyhl2876 {
			if yyj2876 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2876Slc = r.DecodeBytes(yys2876Slc, true, true)
		yys2876 := string(yys2876Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2876 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = ObjectMeta{}
			} else {
				yyv2879 := &x.ObjectMeta
				yyv2879.CodecDecodeSelf(d)
			}
		case "Subsets":
			if r.TryDecodeAsNil() {
				x.Subsets = nil
			} else {
				yyv2880 := &x.Subsets
				yym2881 := z.DecBinary()
				_ = yym2881
				if false {
				} else {
					h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2880), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2876)
		} // end switch yys2876
	} // end for yyj2876
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Endpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2882 int
	var yyb2882 bool
	var yyhl2882 bool = l >= 0
	yyj2882++
	if yyhl2882 {
		yyb2882 = yyj2882 > l
	} else {
		yyb2882 = r.CheckBreak()
	}
	if yyb2882 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2882++
	if yyhl2882 {
		yyb2882 = yyj2882 > l
	} else {
		yyb2882 = r.CheckBreak()
	}
	if yyb2882 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2882++
	if yyhl2882 {
		yyb2882 = yyj2882 > l
	} else {
		yyb2882 = r.CheckBreak()
	}
	if yyb2882 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = ObjectMeta{}
	} else {
		yyv2885 := &x.ObjectMeta
		yyv2885.CodecDecodeSelf(d)
	}
	yyj2882++
	if yyhl2882 {
		yyb2882 = yyj2882 > l
	} else {
		yyb2882 = r.CheckBreak()
	}
	if yyb2882 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subsets = nil
	} else {
		yyv2886 := &x.Subsets
		yym2887 := z.DecBinary()
		_ = yym2887
		if false {
		} else {
			h.decSliceEndpointSubset((*[]EndpointSubset)(yyv2886), d)
		}
	}
	for {
		yyj2882++
		if yyhl2882 {
			yyb2882 = yyj2882 > l
		} else {
			yyb2882 = r.CheckBreak()
		}
		if yyb2882 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2882-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointSubset) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2888 := z.EncBinary()
		_ = yym2888
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2889 := !z.EncBinary()
			yy2arr2889 := z.EncBasicHandle().StructToArray
			var yyq2889 [3]bool
			_, _, _ = yysep2889, yyq2889, yy2arr2889
			const yyr2889 bool = false
			var yynn2889 int
			if yyr2889 || yy2arr2889 {
				r.EncodeArrayStart(3)
			} else {
				yynn2889 = 3
				for _, b := range yyq2889 {
					if b {
						yynn2889++
					}
				}
				r.EncodeMapStart(yynn2889)
				yynn2889 = 0
			}
			if yyr2889 || yy2arr2889 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Addresses == nil {
					r.EncodeNil()
				} else {
					yym2891 := z.EncBinary()
					_ = yym2891
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Addresses"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Addresses == nil {
					r.EncodeNil()
				} else {
					yym2892 := z.EncBinary()
					_ = yym2892
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.Addresses), e)
					}
				}
			}
			if yyr2889 || yy2arr2889 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NotReadyAddresses == nil {
					r.EncodeNil()
				} else {
					yym2894 := z.EncBinary()
					_ = yym2894
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("NotReadyAddresses"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NotReadyAddresses == nil {
					r.EncodeNil()
				} else {
					yym2895 := z.EncBinary()
					_ = yym2895
					if false {
					} else {
						h.encSliceEndpointAddress(([]EndpointAddress)(x.NotReadyAddresses), e)
					}
				}
			}
			if yyr2889 || yy2arr2889 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2897 := z.EncBinary()
					_ = yym2897
					if false {
					} else {
						h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Ports"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Ports == nil {
					r.EncodeNil()
				} else {
					yym2898 := z.EncBinary()
					_ = yym2898
					if false {
					} else {
						h.encSliceEndpointPort(([]EndpointPort)(x.Ports), e)
					}
				}
			}
			if yyr2889 || yy2arr2889 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointSubset) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2899 := z.DecBinary()
	_ = yym2899
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2900 := r.ContainerType()
		if yyct2900 == codecSelferValueTypeMap1234 {
			yyl2900 := r.ReadMapStart()
			if yyl2900 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2900, d)
			}
		} else if yyct2900 == codecSelferValueTypeArray1234 {
			yyl2900 := r.ReadArrayStart()
			if yyl2900 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2900, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointSubset) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2901Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2901Slc
	var yyhl2901 bool = l >= 0
	for yyj2901 := 0; ; yyj2901++ {
		if yyhl2901 {
			if yyj2901 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2901Slc = r.DecodeBytes(yys2901Slc, true, true)
		yys2901 := string(yys2901Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2901 {
		case "Addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv2902 := &x.Addresses
				yym2903 := z.DecBinary()
				_ = yym2903
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2902), d)
				}
			}
		case "NotReadyAddresses":
			if r.TryDecodeAsNil() {
				x.NotReadyAddresses = nil
			} else {
				yyv2904 := &x.NotReadyAddresses
				yym2905 := z.DecBinary()
				_ = yym2905
				if false {
				} else {
					h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2904), d)
				}
			}
		case "Ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv2906 := &x.Ports
				yym2907 := z.DecBinary()
				_ = yym2907
				if false {
				} else {
					h.decSliceEndpointPort((*[]EndpointPort)(yyv2906), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2901)
		} // end switch yys2901
	} // end for yyj2901
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointSubset) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2908 int
	var yyb2908 bool
	var yyhl2908 bool = l >= 0
	yyj2908++
	if yyhl2908 {
		yyb2908 = yyj2908 > l
	} else {
		yyb2908 = r.CheckBreak()
	}
	if yyb2908 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv2909 := &x.Addresses
		yym2910 := z.DecBinary()
		_ = yym2910
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2909), d)
		}
	}
	yyj2908++
	if yyhl2908 {
		yyb2908 = yyj2908 > l
	} else {
		yyb2908 = r.CheckBreak()
	}
	if yyb2908 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NotReadyAddresses = nil
	} else {
		yyv2911 := &x.NotReadyAddresses
		yym2912 := z.DecBinary()
		_ = yym2912
		if false {
		} else {
			h.decSliceEndpointAddress((*[]EndpointAddress)(yyv2911), d)
		}
	}
	yyj2908++
	if yyhl2908 {
		yyb2908 = yyj2908 > l
	} else {
		yyb2908 = r.CheckBreak()
	}
	if yyb2908 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv2913 := &x.Ports
		yym2914 := z.DecBinary()
		_ = yym2914
		if false {
		} else {
			h.decSliceEndpointPort((*[]EndpointPort)(yyv2913), d)
		}
	}
	for {
		yyj2908++
		if yyhl2908 {
			yyb2908 = yyj2908 > l
		} else {
			yyb2908 = r.CheckBreak()
		}
		if yyb2908 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2908-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointAddress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2915 := z.EncBinary()
		_ = yym2915
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2916 := !z.EncBinary()
			yy2arr2916 := z.EncBasicHandle().StructToArray
			var yyq2916 [4]bool
			_, _, _ = yysep2916, yyq2916, yy2arr2916
			const yyr2916 bool = false
			yyq2916[1] = x.Hostname != ""
			yyq2916[2] = x.NodeName != nil
			var yynn2916 int
			if yyr2916 || yy2arr2916 {
				r.EncodeArrayStart(4)
			} else {
				yynn2916 = 2
				for _, b := range yyq2916 {
					if b {
						yynn2916++
					}
				}
				r.EncodeMapStart(yynn2916)
				yynn2916 = 0
			}
			if yyr2916 || yy2arr2916 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2918 := z.EncBinary()
				_ = yym2918
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("IP"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2919 := z.EncBinary()
				_ = yym2919
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IP))
				}
			}
			if yyr2916 || yy2arr2916 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2916[1] {
					yym2921 := z.EncBinary()
					_ = yym2921
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2916[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2922 := z.EncBinary()
					_ = yym2922
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2916 || yy2arr2916 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2916[2] {
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2924 := *x.NodeName
						yym2925 := z.EncBinary()
						_ = yym2925
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2924))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2916[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeName == nil {
						r.EncodeNil()
					} else {
						yy2926 := *x.NodeName
						yym2927 := z.EncBinary()
						_ = yym2927
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy2926))
						}
					}
				}
			}
			if yyr2916 || yy2arr2916 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetRef == nil {
					r.EncodeNil()
				} else {
					x.TargetRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("TargetRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetRef == nil {
					r.EncodeNil()
				} else {
					x.TargetRef.CodecEncodeSelf(e)
				}
			}
			if yyr2916 || yy2arr2916 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointAddress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2929 := z.DecBinary()
	_ = yym2929
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2930 := r.ContainerType()
		if yyct2930 == codecSelferValueTypeMap1234 {
			yyl2930 := r.ReadMapStart()
			if yyl2930 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2930, d)
			}
		} else if yyct2930 == codecSelferValueTypeArray1234 {
			yyl2930 := r.ReadArrayStart()
			if yyl2930 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2930, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointAddress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2931Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2931Slc
	var yyhl2931 bool = l >= 0
	for yyj2931 := 0; ; yyj2931++ {
		if yyhl2931 {
			if yyj2931 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2931Slc = r.DecodeBytes(yys2931Slc, true, true)
		yys2931 := string(yys2931Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2931 {
		case "IP":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				x.IP = string(r.DecodeString())
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				x.Hostname = string(r.DecodeString())
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				if x.NodeName != nil {
					x.NodeName = nil
				}
			} else {
				if x.NodeName == nil {
					x.NodeName = new(string)
				}
				yym2935 := z.DecBinary()
				_ = yym2935
				if false {
				} else {
					*((*string)(x.NodeName)) = r.DecodeString()
				}
			}
		case "TargetRef":
			if r.TryDecodeAsNil() {
				if x.TargetRef != nil {
					x.TargetRef = nil
				}
			} else {
				if x.TargetRef == nil {
					x.TargetRef = new(ObjectReference)
				}
				x.TargetRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys2931)
		} // end switch yys2931
	} // end for yyj2931
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointAddress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2937 int
	var yyb2937 bool
	var yyhl2937 bool = l >= 0
	yyj2937++
	if yyhl2937 {
		yyb2937 = yyj2937 > l
	} else {
		yyb2937 = r.CheckBreak()
	}
	if yyb2937 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		x.IP = string(r.DecodeString())
	}
	yyj2937++
	if yyhl2937 {
		yyb2937 = yyj2937 > l
	} else {
		yyb2937 = r.CheckBreak()
	}
	if yyb2937 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		x.Hostname = string(r.DecodeString())
	}
	yyj2937++
	if yyhl2937 {
		yyb2937 = yyj2937 > l
	} else {
		yyb2937 = r.CheckBreak()
	}
	if yyb2937 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeName != nil {
			x.NodeName = nil
		}
	} else {
		if x.NodeName == nil {
			x.NodeName = new(string)
		}
		yym2941 := z.DecBinary()
		_ = yym2941
		if false {
		} else {
			*((*string)(x.NodeName)) = r.DecodeString()
		}
	}
	yyj2937++
	if yyhl2937 {
		yyb2937 = yyj2937 > l
	} else {
		yyb2937 = r.CheckBreak()
	}
	if yyb2937 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetRef != nil {
			x.TargetRef = nil
		}
	} else {
		if x.TargetRef == nil {
			x.TargetRef = new(ObjectReference)
		}
		x.TargetRef.CodecDecodeSelf(d)
	}
	for {
		yyj2937++
		if yyhl2937 {
			yyb2937 = yyj2937 > l
		} else {
			yyb2937 = r.CheckBreak()
		}
		if yyb2937 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2937-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2943 := z.EncBinary()
		_ = yym2943
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2944 := !z.EncBinary()
			yy2arr2944 := z.EncBasicHandle().StructToArray
			var yyq2944 [3]bool
			_, _, _ = yysep2944, yyq2944, yy2arr2944
			const yyr2944 bool = false
			var yynn2944 int
			if yyr2944 || yy2arr2944 {
				r.EncodeArrayStart(3)
			} else {
				yynn2944 = 3
				for _, b := range yyq2944 {
					if b {
						yynn2944++
					}
				}
				r.EncodeMapStart(yynn2944)
				yynn2944 = 0
			}
			if yyr2944 || yy2arr2944 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2946 := z.EncBinary()
				_ = yym2946
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2947 := z.EncBinary()
				_ = yym2947
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2944 || yy2arr2944 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym2949 := z.EncBinary()
				_ = yym2949
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym2950 := z.EncBinary()
				_ = yym2950
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2944 || yy2arr2944 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Protocol.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Protocol"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Protocol.CodecEncodeSelf(e)
			}
			if yyr2944 || yy2arr2944 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2952 := z.DecBinary()
	_ = yym2952
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2953 := r.ContainerType()
		if yyct2953 == codecSelferValueTypeMap1234 {
			yyl2953 := r.ReadMapStart()
			if yyl2953 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2953, d)
			}
		} else if yyct2953 == codecSelferValueTypeArray1234 {
			yyl2953 := r.ReadArrayStart()
			if yyl2953 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2953, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2954Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2954Slc
	var yyhl2954 bool = l >= 0
	for yyj2954 := 0; ; yyj2954++ {
		if yyhl2954 {
			if yyj2954 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2954Slc = r.DecodeBytes(yys2954Slc, true, true)
		yys2954 := string(yys2954Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2954 {
		case "Name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		case "Protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				x.Protocol = Protocol(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys2954)
		} // end switch yys2954
	} // end for yyj2954
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2958 int
	var yyb2958 bool
	var yyhl2958 bool = l >= 0
	yyj2958++
	if yyhl2958 {
		yyb2958 = yyj2958 > l
	} else {
		yyb2958 = r.CheckBreak()
	}
	if yyb2958 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj2958++
	if yyhl2958 {
		yyb2958 = yyj2958 > l
	} else {
		yyb2958 = r.CheckBreak()
	}
	if yyb2958 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	yyj2958++
	if yyhl2958 {
		yyb2958 = yyj2958 > l
	} else {
		yyb2958 = r.CheckBreak()
	}
	if yyb2958 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		x.Protocol = Protocol(r.DecodeString())
	}
	for {
		yyj2958++
		if yyhl2958 {
			yyb2958 = yyj2958 > l
		} else {
			yyb2958 = r.CheckBreak()
		}
		if yyb2958 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2958-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EndpointsList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2962 := z.EncBinary()
		_ = yym2962
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2963 := !z.EncBinary()
			yy2arr2963 := z.EncBasicHandle().StructToArray
			var yyq2963 [4]bool
			_, _, _ = yysep2963, yyq2963, yy2arr2963
			const yyr2963 bool = false
			yyq2963[0] = x.Kind != ""
			yyq2963[1] = x.APIVersion != ""
			yyq2963[2] = true
			var yynn2963 int
			if yyr2963 || yy2arr2963 {
				r.EncodeArrayStart(4)
			} else {
				yynn2963 = 1
				for _, b := range yyq2963 {
					if b {
						yynn2963++
					}
				}
				r.EncodeMapStart(yynn2963)
				yynn2963 = 0
			}
			if yyr2963 || yy2arr2963 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2963[0] {
					yym2965 := z.EncBinary()
					_ = yym2965
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2963[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2966 := z.EncBinary()
					_ = yym2966
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2963 || yy2arr2963 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2963[1] {
					yym2968 := z.EncBinary()
					_ = yym2968
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2963[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2969 := z.EncBinary()
					_ = yym2969
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2963 || yy2arr2963 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2963[2] {
					yy2971 := &x.ListMeta
					yym2972 := z.EncBinary()
					_ = yym2972
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2971) {
					} else {
						z.EncFallback(yy2971)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2963[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy2973 := &x.ListMeta
					yym2974 := z.EncBinary()
					_ = yym2974
					if false {
					} else if z.HasExtensions() && z.EncExt(yy2973) {
					} else {
						z.EncFallback(yy2973)
					}
				}
			}
			if yyr2963 || yy2arr2963 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2976 := z.EncBinary()
					_ = yym2976
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym2977 := z.EncBinary()
					_ = yym2977
					if false {
					} else {
						h.encSliceEndpoints(([]Endpoints)(x.Items), e)
					}
				}
			}
			if yyr2963 || yy2arr2963 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EndpointsList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym2978 := z.DecBinary()
	_ = yym2978
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2979 := r.ContainerType()
		if yyct2979 == codecSelferValueTypeMap1234 {
			yyl2979 := r.ReadMapStart()
			if yyl2979 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2979, d)
			}
		} else if yyct2979 == codecSelferValueTypeArray1234 {
			yyl2979 := r.ReadArrayStart()
			if yyl2979 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2979, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EndpointsList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys2980Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys2980Slc
	var yyhl2980 bool = l >= 0
	for yyj2980 := 0; ; yyj2980++ {
		if yyhl2980 {
			if yyj2980 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys2980Slc = r.DecodeBytes(yys2980Slc, true, true)
		yys2980 := string(yys2980Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys2980 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv2983 := &x.ListMeta
				yym2984 := z.DecBinary()
				_ = yym2984
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv2983) {
				} else {
					z.DecFallback(yyv2983, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv2985 := &x.Items
				yym2986 := z.DecBinary()
				_ = yym2986
				if false {
				} else {
					h.decSliceEndpoints((*[]Endpoints)(yyv2985), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys2980)
		} // end switch yys2980
	} // end for yyj2980
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EndpointsList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj2987 int
	var yyb2987 bool
	var yyhl2987 bool = l >= 0
	yyj2987++
	if yyhl2987 {
		yyb2987 = yyj2987 > l
	} else {
		yyb2987 = r.CheckBreak()
	}
	if yyb2987 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj2987++
	if yyhl2987 {
		yyb2987 = yyj2987 > l
	} else {
		yyb2987 = r.CheckBreak()
	}
	if yyb2987 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj2987++
	if yyhl2987 {
		yyb2987 = yyj2987 > l
	} else {
		yyb2987 = r.CheckBreak()
	}
	if yyb2987 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv2990 := &x.ListMeta
		yym2991 := z.DecBinary()
		_ = yym2991
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv2990) {
		} else {
			z.DecFallback(yyv2990, false)
		}
	}
	yyj2987++
	if yyhl2987 {
		yyb2987 = yyj2987 > l
	} else {
		yyb2987 = r.CheckBreak()
	}
	if yyb2987 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv2992 := &x.Items
		yym2993 := z.DecBinary()
		_ = yym2993
		if false {
		} else {
			h.decSliceEndpoints((*[]Endpoints)(yyv2992), d)
		}
	}
	for {
		yyj2987++
		if yyhl2987 {
			yyb2987 = yyj2987 > l
		} else {
			yyb2987 = r.CheckBreak()
		}
		if yyb2987 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj2987-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym2994 := z.EncBinary()
		_ = yym2994
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2995 := !z.EncBinary()
			yy2arr2995 := z.EncBasicHandle().StructToArray
			var yyq2995 [4]bool
			_, _, _ = yysep2995, yyq2995, yy2arr2995
			const yyr2995 bool = false
			yyq2995[0] = x.PodCIDR != ""
			yyq2995[1] = x.ExternalID != ""
			yyq2995[2] = x.ProviderID != ""
			yyq2995[3] = x.Unschedulable != false
			var yynn2995 int
			if yyr2995 || yy2arr2995 {
				r.EncodeArrayStart(4)
			} else {
				yynn2995 = 0
				for _, b := range yyq2995 {
					if b {
						yynn2995++
					}
				}
				r.EncodeMapStart(yynn2995)
				yynn2995 = 0
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2995[0] {
					yym2997 := z.EncBinary()
					_ = yym2997
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2995[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podCIDR"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym2998 := z.EncBinary()
					_ = yym2998
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodCIDR))
					}
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2995[1] {
					yym3000 := z.EncBinary()
					_ = yym3000
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2995[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3001 := z.EncBinary()
					_ = yym3001
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalID))
					}
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2995[2] {
					yym3003 := z.EncBinary()
					_ = yym3003
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2995[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("providerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3004 := z.EncBinary()
					_ = yym3004
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProviderID))
					}
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2995[3] {
					yym3006 := z.EncBinary()
					_ = yym3006
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2995[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unschedulable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3007 := z.EncBinary()
					_ = yym3007
					if false {
					} else {
						r.EncodeBool(bool(x.Unschedulable))
					}
				}
			}
			if yyr2995 || yy2arr2995 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3008 := z.DecBinary()
	_ = yym3008
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3009 := r.ContainerType()
		if yyct3009 == codecSelferValueTypeMap1234 {
			yyl3009 := r.ReadMapStart()
			if yyl3009 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3009, d)
			}
		} else if yyct3009 == codecSelferValueTypeArray1234 {
			yyl3009 := r.ReadArrayStart()
			if yyl3009 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3009, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3010Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3010Slc
	var yyhl3010 bool = l >= 0
	for yyj3010 := 0; ; yyj3010++ {
		if yyhl3010 {
			if yyj3010 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3010Slc = r.DecodeBytes(yys3010Slc, true, true)
		yys3010 := string(yys3010Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3010 {
		case "podCIDR":
			if r.TryDecodeAsNil() {
				x.PodCIDR = ""
			} else {
				x.PodCIDR = string(r.DecodeString())
			}
		case "externalID":
			if r.TryDecodeAsNil() {
				x.ExternalID = ""
			} else {
				x.ExternalID = string(r.DecodeString())
			}
		case "providerID":
			if r.TryDecodeAsNil() {
				x.ProviderID = ""
			} else {
				x.ProviderID = string(r.DecodeString())
			}
		case "unschedulable":
			if r.TryDecodeAsNil() {
				x.Unschedulable = false
			} else {
				x.Unschedulable = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3010)
		} // end switch yys3010
	} // end for yyj3010
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3015 int
	var yyb3015 bool
	var yyhl3015 bool = l >= 0
	yyj3015++
	if yyhl3015 {
		yyb3015 = yyj3015 > l
	} else {
		yyb3015 = r.CheckBreak()
	}
	if yyb3015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodCIDR = ""
	} else {
		x.PodCIDR = string(r.DecodeString())
	}
	yyj3015++
	if yyhl3015 {
		yyb3015 = yyj3015 > l
	} else {
		yyb3015 = r.CheckBreak()
	}
	if yyb3015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalID = ""
	} else {
		x.ExternalID = string(r.DecodeString())
	}
	yyj3015++
	if yyhl3015 {
		yyb3015 = yyj3015 > l
	} else {
		yyb3015 = r.CheckBreak()
	}
	if yyb3015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProviderID = ""
	} else {
		x.ProviderID = string(r.DecodeString())
	}
	yyj3015++
	if yyhl3015 {
		yyb3015 = yyj3015 > l
	} else {
		yyb3015 = r.CheckBreak()
	}
	if yyb3015 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Unschedulable = false
	} else {
		x.Unschedulable = bool(r.DecodeBool())
	}
	for {
		yyj3015++
		if yyhl3015 {
			yyb3015 = yyj3015 > l
		} else {
			yyb3015 = r.CheckBreak()
		}
		if yyb3015 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3015-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonEndpoint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3020 := z.EncBinary()
		_ = yym3020
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3021 := !z.EncBinary()
			yy2arr3021 := z.EncBasicHandle().StructToArray
			var yyq3021 [1]bool
			_, _, _ = yysep3021, yyq3021, yy2arr3021
			const yyr3021 bool = false
			var yynn3021 int
			if yyr3021 || yy2arr3021 {
				r.EncodeArrayStart(1)
			} else {
				yynn3021 = 1
				for _, b := range yyq3021 {
					if b {
						yynn3021++
					}
				}
				r.EncodeMapStart(yynn3021)
				yynn3021 = 0
			}
			if yyr3021 || yy2arr3021 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3023 := z.EncBinary()
				_ = yym3023
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("Port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3024 := z.EncBinary()
				_ = yym3024
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr3021 || yy2arr3021 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonEndpoint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3025 := z.DecBinary()
	_ = yym3025
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3026 := r.ContainerType()
		if yyct3026 == codecSelferValueTypeMap1234 {
			yyl3026 := r.ReadMapStart()
			if yyl3026 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3026, d)
			}
		} else if yyct3026 == codecSelferValueTypeArray1234 {
			yyl3026 := r.ReadArrayStart()
			if yyl3026 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3026, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonEndpoint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3027Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3027Slc
	var yyhl3027 bool = l >= 0
	for yyj3027 := 0; ; yyj3027++ {
		if yyhl3027 {
			if yyj3027 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3027Slc = r.DecodeBytes(yys3027Slc, true, true)
		yys3027 := string(yys3027Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3027 {
		case "Port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				x.Port = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys3027)
		} // end switch yys3027
	} // end for yyj3027
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonEndpoint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3029 int
	var yyb3029 bool
	var yyhl3029 bool = l >= 0
	yyj3029++
	if yyhl3029 {
		yyb3029 = yyj3029 > l
	} else {
		yyb3029 = r.CheckBreak()
	}
	if yyb3029 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		x.Port = int32(r.DecodeInt(32))
	}
	for {
		yyj3029++
		if yyhl3029 {
			yyb3029 = yyj3029 > l
		} else {
			yyb3029 = r.CheckBreak()
		}
		if yyb3029 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3029-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeDaemonEndpoints) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3031 := z.EncBinary()
		_ = yym3031
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3032 := !z.EncBinary()
			yy2arr3032 := z.EncBasicHandle().StructToArray
			var yyq3032 [1]bool
			_, _, _ = yysep3032, yyq3032, yy2arr3032
			const yyr3032 bool = false
			yyq3032[0] = true
			var yynn3032 int
			if yyr3032 || yy2arr3032 {
				r.EncodeArrayStart(1)
			} else {
				yynn3032 = 0
				for _, b := range yyq3032 {
					if b {
						yynn3032++
					}
				}
				r.EncodeMapStart(yynn3032)
				yynn3032 = 0
			}
			if yyr3032 || yy2arr3032 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3032[0] {
					yy3034 := &x.KubeletEndpoint
					yy3034.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3032[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kubeletEndpoint"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3035 := &x.KubeletEndpoint
					yy3035.CodecEncodeSelf(e)
				}
			}
			if yyr3032 || yy2arr3032 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeDaemonEndpoints) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3036 := z.DecBinary()
	_ = yym3036
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3037 := r.ContainerType()
		if yyct3037 == codecSelferValueTypeMap1234 {
			yyl3037 := r.ReadMapStart()
			if yyl3037 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3037, d)
			}
		} else if yyct3037 == codecSelferValueTypeArray1234 {
			yyl3037 := r.ReadArrayStart()
			if yyl3037 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3037, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3038Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3038Slc
	var yyhl3038 bool = l >= 0
	for yyj3038 := 0; ; yyj3038++ {
		if yyhl3038 {
			if yyj3038 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3038Slc = r.DecodeBytes(yys3038Slc, true, true)
		yys3038 := string(yys3038Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3038 {
		case "kubeletEndpoint":
			if r.TryDecodeAsNil() {
				x.KubeletEndpoint = DaemonEndpoint{}
			} else {
				yyv3039 := &x.KubeletEndpoint
				yyv3039.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3038)
		} // end switch yys3038
	} // end for yyj3038
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeDaemonEndpoints) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3040 int
	var yyb3040 bool
	var yyhl3040 bool = l >= 0
	yyj3040++
	if yyhl3040 {
		yyb3040 = yyj3040 > l
	} else {
		yyb3040 = r.CheckBreak()
	}
	if yyb3040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletEndpoint = DaemonEndpoint{}
	} else {
		yyv3041 := &x.KubeletEndpoint
		yyv3041.CodecDecodeSelf(d)
	}
	for {
		yyj3040++
		if yyhl3040 {
			yyb3040 = yyj3040 > l
		} else {
			yyb3040 = r.CheckBreak()
		}
		if yyb3040 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3040-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSystemInfo) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3042 := z.EncBinary()
		_ = yym3042
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3043 := !z.EncBinary()
			yy2arr3043 := z.EncBasicHandle().StructToArray
			var yyq3043 [10]bool
			_, _, _ = yysep3043, yyq3043, yy2arr3043
			const yyr3043 bool = false
			var yynn3043 int
			if yyr3043 || yy2arr3043 {
				r.EncodeArrayStart(10)
			} else {
				yynn3043 = 10
				for _, b := range yyq3043 {
					if b {
						yynn3043++
					}
				}
				r.EncodeMapStart(yynn3043)
				yynn3043 = 0
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3045 := z.EncBinary()
				_ = yym3045
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("machineID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3046 := z.EncBinary()
				_ = yym3046
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MachineID))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3048 := z.EncBinary()
				_ = yym3048
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("systemUUID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3049 := z.EncBinary()
				_ = yym3049
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SystemUUID))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3051 := z.EncBinary()
				_ = yym3051
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("bootID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3052 := z.EncBinary()
				_ = yym3052
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.BootID))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3054 := z.EncBinary()
				_ = yym3054
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kernelVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3055 := z.EncBinary()
				_ = yym3055
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KernelVersion))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3057 := z.EncBinary()
				_ = yym3057
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("osImage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3058 := z.EncBinary()
				_ = yym3058
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OSImage))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3060 := z.EncBinary()
				_ = yym3060
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerRuntimeVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3061 := z.EncBinary()
				_ = yym3061
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ContainerRuntimeVersion))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3063 := z.EncBinary()
				_ = yym3063
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeletVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3064 := z.EncBinary()
				_ = yym3064
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeletVersion))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3066 := z.EncBinary()
				_ = yym3066
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kubeProxyVersion"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3067 := z.EncBinary()
				_ = yym3067
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.KubeProxyVersion))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3069 := z.EncBinary()
				_ = yym3069
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operatingSystem"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3070 := z.EncBinary()
				_ = yym3070
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.OperatingSystem))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3072 := z.EncBinary()
				_ = yym3072
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("architecture"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3073 := z.EncBinary()
				_ = yym3073
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Architecture))
				}
			}
			if yyr3043 || yy2arr3043 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSystemInfo) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3074 := z.DecBinary()
	_ = yym3074
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3075 := r.ContainerType()
		if yyct3075 == codecSelferValueTypeMap1234 {
			yyl3075 := r.ReadMapStart()
			if yyl3075 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3075, d)
			}
		} else if yyct3075 == codecSelferValueTypeArray1234 {
			yyl3075 := r.ReadArrayStart()
			if yyl3075 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3075, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSystemInfo) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3076Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3076Slc
	var yyhl3076 bool = l >= 0
	for yyj3076 := 0; ; yyj3076++ {
		if yyhl3076 {
			if yyj3076 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3076Slc = r.DecodeBytes(yys3076Slc, true, true)
		yys3076 := string(yys3076Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3076 {
		case "machineID":
			if r.TryDecodeAsNil() {
				x.MachineID = ""
			} else {
				x.MachineID = string(r.DecodeString())
			}
		case "systemUUID":
			if r.TryDecodeAsNil() {
				x.SystemUUID = ""
			} else {
				x.SystemUUID = string(r.DecodeString())
			}
		case "bootID":
			if r.TryDecodeAsNil() {
				x.BootID = ""
			} else {
				x.BootID = string(r.DecodeString())
			}
		case "kernelVersion":
			if r.TryDecodeAsNil() {
				x.KernelVersion = ""
			} else {
				x.KernelVersion = string(r.DecodeString())
			}
		case "osImage":
			if r.TryDecodeAsNil() {
				x.OSImage = ""
			} else {
				x.OSImage = string(r.DecodeString())
			}
		case "containerRuntimeVersion":
			if r.TryDecodeAsNil() {
				x.ContainerRuntimeVersion = ""
			} else {
				x.ContainerRuntimeVersion = string(r.DecodeString())
			}
		case "kubeletVersion":
			if r.TryDecodeAsNil() {
				x.KubeletVersion = ""
			} else {
				x.KubeletVersion = string(r.DecodeString())
			}
		case "kubeProxyVersion":
			if r.TryDecodeAsNil() {
				x.KubeProxyVersion = ""
			} else {
				x.KubeProxyVersion = string(r.DecodeString())
			}
		case "operatingSystem":
			if r.TryDecodeAsNil() {
				x.OperatingSystem = ""
			} else {
				x.OperatingSystem = string(r.DecodeString())
			}
		case "architecture":
			if r.TryDecodeAsNil() {
				x.Architecture = ""
			} else {
				x.Architecture = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3076)
		} // end switch yys3076
	} // end for yyj3076
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSystemInfo) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3087 int
	var yyb3087 bool
	var yyhl3087 bool = l >= 0
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MachineID = ""
	} else {
		x.MachineID = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SystemUUID = ""
	} else {
		x.SystemUUID = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.BootID = ""
	} else {
		x.BootID = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KernelVersion = ""
	} else {
		x.KernelVersion = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OSImage = ""
	} else {
		x.OSImage = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerRuntimeVersion = ""
	} else {
		x.ContainerRuntimeVersion = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeletVersion = ""
	} else {
		x.KubeletVersion = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.KubeProxyVersion = ""
	} else {
		x.KubeProxyVersion = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OperatingSystem = ""
	} else {
		x.OperatingSystem = string(r.DecodeString())
	}
	yyj3087++
	if yyhl3087 {
		yyb3087 = yyj3087 > l
	} else {
		yyb3087 = r.CheckBreak()
	}
	if yyb3087 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Architecture = ""
	} else {
		x.Architecture = string(r.DecodeString())
	}
	for {
		yyj3087++
		if yyhl3087 {
			yyb3087 = yyj3087 > l
		} else {
			yyb3087 = r.CheckBreak()
		}
		if yyb3087 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3087-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3098 := z.EncBinary()
		_ = yym3098
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3099 := !z.EncBinary()
			yy2arr3099 := z.EncBasicHandle().StructToArray
			var yyq3099 [10]bool
			_, _, _ = yysep3099, yyq3099, yy2arr3099
			const yyr3099 bool = false
			yyq3099[0] = len(x.Capacity) != 0
			yyq3099[1] = len(x.Allocatable) != 0
			yyq3099[2] = x.Phase != ""
			yyq3099[3] = len(x.Conditions) != 0
			yyq3099[4] = len(x.Addresses) != 0
			yyq3099[5] = true
			yyq3099[6] = true
			yyq3099[7] = len(x.Images) != 0
			yyq3099[8] = len(x.VolumesInUse) != 0
			yyq3099[9] = len(x.VolumesAttached) != 0
			var yynn3099 int
			if yyr3099 || yy2arr3099 {
				r.EncodeArrayStart(10)
			} else {
				yynn3099 = 0
				for _, b := range yyq3099 {
					if b {
						yynn3099++
					}
				}
				r.EncodeMapStart(yynn3099)
				yynn3099 = 0
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[1] {
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allocatable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Allocatable == nil {
						r.EncodeNil()
					} else {
						x.Allocatable.CodecEncodeSelf(e)
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[2] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3099[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[3] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym3104 := z.EncBinary()
						_ = yym3104
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym3105 := z.EncBinary()
						_ = yym3105
						if false {
						} else {
							h.encSliceNodeCondition(([]NodeCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[4] {
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym3107 := z.EncBinary()
						_ = yym3107
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("addresses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Addresses == nil {
						r.EncodeNil()
					} else {
						yym3108 := z.EncBinary()
						_ = yym3108
						if false {
						} else {
							h.encSliceNodeAddress(([]NodeAddress)(x.Addresses), e)
						}
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[5] {
					yy3110 := &x.DaemonEndpoints
					yy3110.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("daemonEndpoints"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3111 := &x.DaemonEndpoints
					yy3111.CodecEncodeSelf(e)
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[6] {
					yy3113 := &x.NodeInfo
					yy3113.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeInfo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3114 := &x.NodeInfo
					yy3114.CodecEncodeSelf(e)
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[7] {
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym3116 := z.EncBinary()
						_ = yym3116
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("images"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Images == nil {
						r.EncodeNil()
					} else {
						yym3117 := z.EncBinary()
						_ = yym3117
						if false {
						} else {
							h.encSliceContainerImage(([]ContainerImage)(x.Images), e)
						}
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[8] {
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym3119 := z.EncBinary()
						_ = yym3119
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesInUse"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesInUse == nil {
						r.EncodeNil()
					} else {
						yym3120 := z.EncBinary()
						_ = yym3120
						if false {
						} else {
							h.encSliceUniqueVolumeName(([]UniqueVolumeName)(x.VolumesInUse), e)
						}
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3099[9] {
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym3122 := z.EncBinary()
						_ = yym3122
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3099[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumesAttached"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumesAttached == nil {
						r.EncodeNil()
					} else {
						yym3123 := z.EncBinary()
						_ = yym3123
						if false {
						} else {
							h.encSliceAttachedVolume(([]AttachedVolume)(x.VolumesAttached), e)
						}
					}
				}
			}
			if yyr3099 || yy2arr3099 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3124 := z.DecBinary()
	_ = yym3124
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3125 := r.ContainerType()
		if yyct3125 == codecSelferValueTypeMap1234 {
			yyl3125 := r.ReadMapStart()
			if yyl3125 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3125, d)
			}
		} else if yyct3125 == codecSelferValueTypeArray1234 {
			yyl3125 := r.ReadArrayStart()
			if yyl3125 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3125, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3126Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3126Slc
	var yyhl3126 bool = l >= 0
	for yyj3126 := 0; ; yyj3126++ {
		if yyhl3126 {
			if yyj3126 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3126Slc = r.DecodeBytes(yys3126Slc, true, true)
		yys3126 := string(yys3126Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3126 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv3127 := &x.Capacity
				yyv3127.CodecDecodeSelf(d)
			}
		case "allocatable":
			if r.TryDecodeAsNil() {
				x.Allocatable = nil
			} else {
				yyv3128 := &x.Allocatable
				yyv3128.CodecDecodeSelf(d)
			}
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				x.Phase = NodePhase(r.DecodeString())
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv3130 := &x.Conditions
				yym3131 := z.DecBinary()
				_ = yym3131
				if false {
				} else {
					h.decSliceNodeCondition((*[]NodeCondition)(yyv3130), d)
				}
			}
		case "addresses":
			if r.TryDecodeAsNil() {
				x.Addresses = nil
			} else {
				yyv3132 := &x.Addresses
				yym3133 := z.DecBinary()
				_ = yym3133
				if false {
				} else {
					h.decSliceNodeAddress((*[]NodeAddress)(yyv3132), d)
				}
			}
		case "daemonEndpoints":
			if r.TryDecodeAsNil() {
				x.DaemonEndpoints = NodeDaemonEndpoints{}
			} else {
				yyv3134 := &x.DaemonEndpoints
				yyv3134.CodecDecodeSelf(d)
			}
		case "nodeInfo":
			if r.TryDecodeAsNil() {
				x.NodeInfo = NodeSystemInfo{}
			} else {
				yyv3135 := &x.NodeInfo
				yyv3135.CodecDecodeSelf(d)
			}
		case "images":
			if r.TryDecodeAsNil() {
				x.Images = nil
			} else {
				yyv3136 := &x.Images
				yym3137 := z.DecBinary()
				_ = yym3137
				if false {
				} else {
					h.decSliceContainerImage((*[]ContainerImage)(yyv3136), d)
				}
			}
		case "volumesInUse":
			if r.TryDecodeAsNil() {
				x.VolumesInUse = nil
			} else {
				yyv3138 := &x.VolumesInUse
				yym3139 := z.DecBinary()
				_ = yym3139
				if false {
				} else {
					h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3138), d)
				}
			}
		case "volumesAttached":
			if r.TryDecodeAsNil() {
				x.VolumesAttached = nil
			} else {
				yyv3140 := &x.VolumesAttached
				yym3141 := z.DecBinary()
				_ = yym3141
				if false {
				} else {
					h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3140), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3126)
		} // end switch yys3126
	} // end for yyj3126
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3142 int
	var yyb3142 bool
	var yyhl3142 bool = l >= 0
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv3143 := &x.Capacity
		yyv3143.CodecDecodeSelf(d)
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Allocatable = nil
	} else {
		yyv3144 := &x.Allocatable
		yyv3144.CodecDecodeSelf(d)
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		x.Phase = NodePhase(r.DecodeString())
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv3146 := &x.Conditions
		yym3147 := z.DecBinary()
		_ = yym3147
		if false {
		} else {
			h.decSliceNodeCondition((*[]NodeCondition)(yyv3146), d)
		}
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Addresses = nil
	} else {
		yyv3148 := &x.Addresses
		yym3149 := z.DecBinary()
		_ = yym3149
		if false {
		} else {
			h.decSliceNodeAddress((*[]NodeAddress)(yyv3148), d)
		}
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DaemonEndpoints = NodeDaemonEndpoints{}
	} else {
		yyv3150 := &x.DaemonEndpoints
		yyv3150.CodecDecodeSelf(d)
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeInfo = NodeSystemInfo{}
	} else {
		yyv3151 := &x.NodeInfo
		yyv3151.CodecDecodeSelf(d)
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Images = nil
	} else {
		yyv3152 := &x.Images
		yym3153 := z.DecBinary()
		_ = yym3153
		if false {
		} else {
			h.decSliceContainerImage((*[]ContainerImage)(yyv3152), d)
		}
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesInUse = nil
	} else {
		yyv3154 := &x.VolumesInUse
		yym3155 := z.DecBinary()
		_ = yym3155
		if false {
		} else {
			h.decSliceUniqueVolumeName((*[]UniqueVolumeName)(yyv3154), d)
		}
	}
	yyj3142++
	if yyhl3142 {
		yyb3142 = yyj3142 > l
	} else {
		yyb3142 = r.CheckBreak()
	}
	if yyb3142 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumesAttached = nil
	} else {
		yyv3156 := &x.VolumesAttached
		yym3157 := z.DecBinary()
		_ = yym3157
		if false {
		} else {
			h.decSliceAttachedVolume((*[]AttachedVolume)(yyv3156), d)
		}
	}
	for {
		yyj3142++
		if yyhl3142 {
			yyb3142 = yyj3142 > l
		} else {
			yyb3142 = r.CheckBreak()
		}
		if yyb3142 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3142-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x UniqueVolumeName) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym3158 := z.EncBinary()
	_ = yym3158
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *UniqueVolumeName) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3159 := z.DecBinary()
	_ = yym3159
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AttachedVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3160 := z.EncBinary()
		_ = yym3160
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3161 := !z.EncBinary()
			yy2arr3161 := z.EncBasicHandle().StructToArray
			var yyq3161 [2]bool
			_, _, _ = yysep3161, yyq3161, yy2arr3161
			const yyr3161 bool = false
			var yynn3161 int
			if yyr3161 || yy2arr3161 {
				r.EncodeArrayStart(2)
			} else {
				yynn3161 = 2
				for _, b := range yyq3161 {
					if b {
						yynn3161++
					}
				}
				r.EncodeMapStart(yynn3161)
				yynn3161 = 0
			}
			if yyr3161 || yy2arr3161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Name.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Name.CodecEncodeSelf(e)
			}
			if yyr3161 || yy2arr3161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym3164 := z.EncBinary()
				_ = yym3164
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("devicePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym3165 := z.EncBinary()
				_ = yym3165
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DevicePath))
				}
			}
			if yyr3161 || yy2arr3161 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AttachedVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3166 := z.DecBinary()
	_ = yym3166
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3167 := r.ContainerType()
		if yyct3167 == codecSelferValueTypeMap1234 {
			yyl3167 := r.ReadMapStart()
			if yyl3167 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3167, d)
			}
		} else if yyct3167 == codecSelferValueTypeArray1234 {
			yyl3167 := r.ReadArrayStart()
			if yyl3167 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3167, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AttachedVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3168Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3168Slc
	var yyhl3168 bool = l >= 0
	for yyj3168 := 0; ; yyj3168++ {
		if yyhl3168 {
			if yyj3168 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3168Slc = r.DecodeBytes(yys3168Slc, true, true)
		yys3168 := string(yys3168Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3168 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = UniqueVolumeName(r.DecodeString())
			}
		case "devicePath":
			if r.TryDecodeAsNil() {
				x.DevicePath = ""
			} else {
				x.DevicePath = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys3168)
		} // end switch yys3168
	} // end for yyj3168
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AttachedVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3171 int
	var yyb3171 bool
	var yyhl3171 bool = l >= 0
	yyj3171++
	if yyhl3171 {
		yyb3171 = yyj3171 > l
	} else {
		yyb3171 = r.CheckBreak()
	}
	if yyb3171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = UniqueVolumeName(r.DecodeString())
	}
	yyj3171++
	if yyhl3171 {
		yyb3171 = yyj3171 > l
	} else {
		yyb3171 = r.CheckBreak()
	}
	if yyb3171 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DevicePath = ""
	} else {
		x.DevicePath = string(r.DecodeString())
	}
	for {
		yyj3171++
		if yyhl3171 {
			yyb3171 = yyj3171 > l
		} else {
			yyb3171 = r.CheckBreak()
		}
		if yyb3171 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3171-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AvoidPods) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3174 := z.EncBinary()
		_ = yym3174
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3175 := !z.EncBinary()
			yy2arr3175 := z.EncBasicHandle().StructToArray
			var yyq3175 [1]bool
			_, _, _ = yysep3175, yyq3175, yy2arr3175
			const yyr3175 bool = false
			yyq3175[0] = len(x.PreferAvoidPods) != 0
			var yynn3175 int
			if yyr3175 || yy2arr3175 {
				r.EncodeArrayStart(1)
			} else {
				yynn3175 = 0
				for _, b := range yyq3175 {
					if b {
						yynn3175++
					}
				}
				r.EncodeMapStart(yynn3175)
				yynn3175 = 0
			}
			if yyr3175 || yy2arr3175 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3175[0] {
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3177 := z.EncBinary()
						_ = yym3177
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3175[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferAvoidPods"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferAvoidPods == nil {
						r.EncodeNil()
					} else {
						yym3178 := z.EncBinary()
						_ = yym3178
						if false {
						} else {
							h.encSlicePreferAvoidPodsEntry(([]PreferAvoidPodsEntry)(x.PreferAvoidPods), e)
						}
					}
				}
			}
			if yyr3175 || yy2arr3175 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AvoidPods) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym3179 := z.DecBinary()
	_ = yym3179
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct3180 := r.ContainerType()
		if yyct3180 == codecSelferValueTypeMap1234 {
			yyl3180 := r.ReadMapStart()
			if yyl3180 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl3180, d)
			}
		} else if yyct3180 == codecSelferValueTypeArray1234 {
			yyl3180 := r.ReadArrayStart()
			if yyl3180 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl3180, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AvoidPods) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3181Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3181Slc
	var yyhl3181 bool = l >= 0
	for yyj3181 := 0; ; yyj3181++ {
		if yyhl3181 {
			if yyj3181 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3181Slc = r.DecodeBytes(yys3181Slc, true, true)
		yys3181 := string(yys3181Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3181 {
		case "preferAvoidPods":
			if r.TryDecodeAsNil() {
				x.PreferAvoidPods = nil
			} else {
				yyv3182 := &x.PreferAvoidPods
				yym3183 := z.DecBinary()
				_ = yym3183
				if false {
				} else {
					h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3182), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3181)
		} // end switch yys3181
	} // end for yyj3181
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AvoidPods) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj3184 int
	var yyb3184 bool
	var yyhl3184 bool = l >= 0
	yyj3184++
	if yyhl3184 {
		yyb3184 = yyj3184 > l
	} else {
		yyb3184 = r.CheckBreak()
	}
	if yyb3184 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferAvoidPods = nil
	} else {
		yyv3185 := &x.PreferAvoidPods
		yym3186 := z.DecBinary()
		_ = yym3186
		if false {
		} else {
			h.decSlicePreferAvoidPodsEntry((*[]PreferAvoidPodsEntry)(yyv3185), d)
		}
	}
	for {
		yyj3184++
		if yyhl3184 {
			yyb3184 = yyj3184 > l
		} else {
			yyb3184 = r.CheckBreak()
		}
		if yyb3184 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj3184-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferAvoidPodsEntry) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym3187 := z.EncBinary()
		_ = yym3187
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep3188 := !z.EncBinary()
			yy2arr3188 := z.EncBasicHandle().StructToArray
			var yyq3188 [4]bool
			_, _, _ = yysep3188, yyq3188, yy2arr3188
			const yyr3188 bool = false
			yyq3188[1] = true
			yyq3188[2] = x.Reason != ""
			yyq3188[3] = x.Message != ""
			var yynn3188 int
			if yyr3188 || yy2arr3188 {
				r.EncodeArrayStart(4)
			} else {
				yynn3188 = 1
				for _, b := range yyq3188 {
					if b {
						yynn3188++
					}
				}
				r.EncodeMapStart(yynn3188)
				yynn3188 = 0
			}
			if yyr3188 || yy2arr3188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy3190 := &x.PodSignature
				yy3190.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSignature"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy3191 := &x.PodSignature
				yy3191.CodecEncodeSelf(e)
			}
			if yyr3188 || yy2arr3188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3188[1] {
					yy3193 := &x.EvictionTime
					yym3194 := z.EncBinary()
					_ = yym3194
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3193) {
					} else if yym3194 {
						z.EncBinaryMarshal(yy3193)
					} else if !yym3194 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3193)
					} else {
						z.EncFallback(yy3193)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq3188[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("evictionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy3195 := &x.EvictionTime
					yym3196 := z.EncBinary()
					_ = yym3196
					if false {
					} else if z.HasExtensions() && z.EncExt(yy3195) {
					} else if yym3196 {
						z.EncBinaryMarshal(yy3195)
					} else if !yym3196 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy3195)
					} else {
						z.EncFallback(yy3195)
					}
				}
			}
			if yyr3188 || yy2arr3188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3188[2] {
					yym3198 := z.EncBinary()
					_ = yym3198
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3188[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym3199 := z.EncBinary()
					_ = yym3199
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr3188 || yy2arr3188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq3188[3] {
					yym3201 := z.EncBinary()
					_ = yym3201
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq3188[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey12