/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package extensions

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_api "k8s.io/kubernetes/pkg/api"
	pkg4_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg3_types "k8s.io/kubernetes/pkg/types"
	pkg5_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_api.ObjectMeta
		var v1 pkg4_resource.Quantity
		var v2 pkg1_unversioned.LabelSelector
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym6 := z.DecBinary()
	_ = yym6
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct7 := r.ContainerType()
		if yyct7 == codecSelferValueTypeMap1234 {
			yyl7 := r.ReadMapStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl7, d)
			}
		} else if yyct7 == codecSelferValueTypeArray1234 {
			yyl7 := r.ReadArrayStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl7, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys8Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys8Slc
	var yyhl8 bool = l >= 0
	for yyj8 := 0; ; yyj8++ {
		if yyhl8 {
			if yyj8 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys8Slc = r.DecodeBytes(yys8Slc, true, true)
		yys8 := string(yys8Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys8 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys8)
		} // end switch yys8
	} // end for yyj8
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym12 := z.EncBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep13 := !z.EncBinary()
			yy2arr13 := z.EncBasicHandle().StructToArray
			var yyq13 [2]bool
			_, _, _ = yysep13, yyq13, yy2arr13
			const yyr13 bool = false
			yyq13[1] = x.Selector != nil
			var yynn13 int
			if yyr13 || yy2arr13 {
				r.EncodeArrayStart(2)
			} else {
				yynn13 = 1
				for _, b := range yyq13 {
					if b {
						yynn13++
					}
				}
				r.EncodeMapStart(yynn13)
				yynn13 = 0
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq13[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym20 := z.DecBinary()
	_ = yym20
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct21 := r.ContainerType()
		if yyct21 == codecSelferValueTypeMap1234 {
			yyl21 := r.ReadMapStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl21, d)
			}
		} else if yyct21 == codecSelferValueTypeArray1234 {
			yyl21 := r.ReadArrayStart()
			if yyl21 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl21, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys22Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys22Slc
	var yyhl22 bool = l >= 0
	for yyj22 := 0; ; yyj22++ {
		if yyhl22 {
			if yyj22 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys22Slc = r.DecodeBytes(yys22Slc, true, true)
		yys22 := string(yys22Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys22 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys22)
		} // end switch yys22
	} // end for yyj22
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj26 int
	var yyb26 bool
	var yyhl26 bool = l >= 0
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj26++
	if yyhl26 {
		yyb26 = yyj26 > l
	} else {
		yyb26 = r.CheckBreak()
	}
	if yyb26 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym29 := z.DecBinary()
		_ = yym29
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	for {
		yyj26++
		if yyhl26 {
			yyb26 = yyj26 > l
		} else {
			yyb26 = r.CheckBreak()
		}
		if yyb26 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj26-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym30 := z.EncBinary()
		_ = yym30
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep31 := !z.EncBinary()
			yy2arr31 := z.EncBasicHandle().StructToArray
			var yyq31 [5]bool
			_, _, _ = yysep31, yyq31, yy2arr31
			const yyr31 bool = false
			yyq31[0] = x.Kind != ""
			yyq31[1] = x.APIVersion != ""
			yyq31[2] = true
			yyq31[3] = true
			yyq31[4] = true
			var yynn31 int
			if yyr31 || yy2arr31 {
				r.EncodeArrayStart(5)
			} else {
				yynn31 = 0
				for _, b := range yyq31 {
					if b {
						yynn31++
					}
				}
				r.EncodeMapStart(yynn31)
				yynn31 = 0
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[0] {
					yym33 := z.EncBinary()
					_ = yym33
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym34 := z.EncBinary()
					_ = yym34
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[1] {
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq31[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym37 := z.EncBinary()
					_ = yym37
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[2] {
					yy39 := &x.ObjectMeta
					yy39.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy40 := &x.ObjectMeta
					yy40.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[3] {
					yy42 := &x.Spec
					yy42.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy43 := &x.Spec
					yy43.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq31[4] {
					yy45 := &x.Status
					yy45.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq31[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy46 := &x.Status
					yy46.CodecEncodeSelf(e)
				}
			}
			if yyr31 || yy2arr31 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym47 := z.DecBinary()
	_ = yym47
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct48 := r.ContainerType()
		if yyct48 == codecSelferValueTypeMap1234 {
			yyl48 := r.ReadMapStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl48, d)
			}
		} else if yyct48 == codecSelferValueTypeArray1234 {
			yyl48 := r.ReadArrayStart()
			if yyl48 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl48, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys49Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys49Slc
	var yyhl49 bool = l >= 0
	for yyj49 := 0; ; yyj49++ {
		if yyhl49 {
			if yyj49 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys49Slc = r.DecodeBytes(yys49Slc, true, true)
		yys49 := string(yys49Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys49 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv52 := &x.ObjectMeta
				yyv52.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv53 := &x.Spec
				yyv53.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv54 := &x.Status
				yyv54.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys49)
		} // end switch yys49
	} // end for yyj49
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj55 int
	var yyb55 bool
	var yyhl55 bool = l >= 0
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv58 := &x.ObjectMeta
		yyv58.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv59 := &x.Spec
		yyv59.CodecDecodeSelf(d)
	}
	yyj55++
	if yyhl55 {
		yyb55 = yyj55 > l
	} else {
		yyb55 = r.CheckBreak()
	}
	if yyb55 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv60 := &x.Status
		yyv60.CodecDecodeSelf(d)
	}
	for {
		yyj55++
		if yyhl55 {
			yyb55 = yyj55 > l
		} else {
			yyb55 = r.CheckBreak()
		}
		if yyb55 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj55-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerDummy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym61 := z.EncBinary()
		_ = yym61
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep62 := !z.EncBinary()
			yy2arr62 := z.EncBasicHandle().StructToArray
			var yyq62 [2]bool
			_, _, _ = yysep62, yyq62, yy2arr62
			const yyr62 bool = false
			yyq62[0] = x.Kind != ""
			yyq62[1] = x.APIVersion != ""
			var yynn62 int
			if yyr62 || yy2arr62 {
				r.EncodeArrayStart(2)
			} else {
				yynn62 = 0
				for _, b := range yyq62 {
					if b {
						yynn62++
					}
				}
				r.EncodeMapStart(yynn62)
				yynn62 = 0
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[0] {
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq62[1] {
					yym67 := z.EncBinary()
					_ = yym67
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq62[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym68 := z.EncBinary()
					_ = yym68
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr62 || yy2arr62 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerDummy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym69 := z.DecBinary()
	_ = yym69
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct70 := r.ContainerType()
		if yyct70 == codecSelferValueTypeMap1234 {
			yyl70 := r.ReadMapStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl70, d)
			}
		} else if yyct70 == codecSelferValueTypeArray1234 {
			yyl70 := r.ReadArrayStart()
			if yyl70 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl70, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys71Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys71Slc
	var yyhl71 bool = l >= 0
	for yyj71 := 0; ; yyj71++ {
		if yyhl71 {
			if yyj71 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys71Slc = r.DecodeBytes(yys71Slc, true, true)
		yys71 := string(yys71Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys71 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys71)
		} // end switch yys71
	} // end for yyj71
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj74 int
	var yyb74 bool
	var yyhl74 bool = l >= 0
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj74++
	if yyhl74 {
		yyb74 = yyj74 > l
	} else {
		yyb74 = r.CheckBreak()
	}
	if yyb74 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj74++
		if yyhl74 {
			yyb74 = yyj74 > l
		} else {
			yyb74 = r.CheckBreak()
		}
		if yyb74 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj74-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTarget) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym77 := z.EncBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep78 := !z.EncBinary()
			yy2arr78 := z.EncBasicHandle().StructToArray
			var yyq78 [2]bool
			_, _, _ = yysep78, yyq78, yy2arr78
			const yyr78 bool = false
			var yynn78 int
			if yyr78 || yy2arr78 {
				r.EncodeArrayStart(2)
			} else {
				yynn78 = 2
				for _, b := range yyq78 {
					if b {
						yynn78++
					}
				}
				r.EncodeMapStart(yynn78)
				yynn78 = 0
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym80 := z.EncBinary()
				_ = yym80
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy83 := &x.TargetValue
				yym84 := z.EncBinary()
				_ = yym84
				if false {
				} else if z.HasExtensions() && z.EncExt(yy83) {
				} else if !yym84 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy83)
				} else {
					z.EncFallback(yy83)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy85 := &x.TargetValue
				yym86 := z.EncBinary()
				_ = yym86
				if false {
				} else if z.HasExtensions() && z.EncExt(yy85) {
				} else if !yym86 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy85)
				} else {
					z.EncFallback(yy85)
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTarget) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym87 := z.DecBinary()
	_ = yym87
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct88 := r.ContainerType()
		if yyct88 == codecSelferValueTypeMap1234 {
			yyl88 := r.ReadMapStart()
			if yyl88 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl88, d)
			}
		} else if yyct88 == codecSelferValueTypeArray1234 {
			yyl88 := r.ReadArrayStart()
			if yyl88 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl88, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTarget) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys89Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys89Slc
	var yyhl89 bool = l >= 0
	for yyj89 := 0; ; yyj89++ {
		if yyhl89 {
			if yyj89 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys89Slc = r.DecodeBytes(yys89Slc, true, true)
		yys89 := string(yys89Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys89 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.TargetValue = pkg4_resource.Quantity{}
			} else {
				yyv91 := &x.TargetValue
				yym92 := z.DecBinary()
				_ = yym92
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv91) {
				} else if !yym92 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv91)
				} else {
					z.DecFallback(yyv91, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys89)
		} // end switch yys89
	} // end for yyj89
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTarget) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj93 int
	var yyb93 bool
	var yyhl93 bool = l >= 0
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj93++
	if yyhl93 {
		yyb93 = yyj93 > l
	} else {
		yyb93 = r.CheckBreak()
	}
	if yyb93 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetValue = pkg4_resource.Quantity{}
	} else {
		yyv95 := &x.TargetValue
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv95) {
		} else if !yym96 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv95)
		} else {
			z.DecFallback(yyv95, false)
		}
	}
	for {
		yyj93++
		if yyhl93 {
			yyb93 = yyj93 > l
		} else {
			yyb93 = r.CheckBreak()
		}
		if yyb93 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj93-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTargetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym97 := z.EncBinary()
		_ = yym97
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep98 := !z.EncBinary()
			yy2arr98 := z.EncBasicHandle().StructToArray
			var yyq98 [1]bool
			_, _, _ = yysep98, yyq98, yy2arr98
			const yyr98 bool = false
			var yynn98 int
			if yyr98 || yy2arr98 {
				r.EncodeArrayStart(1)
			} else {
				yynn98 = 1
				for _, b := range yyq98 {
					if b {
						yynn98++
					}
				}
				r.EncodeMapStart(yynn98)
				yynn98 = 0
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym100 := z.EncBinary()
					_ = yym100
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym101 := z.EncBinary()
					_ = yym101
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTargetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym102 := z.DecBinary()
	_ = yym102
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct103 := r.ContainerType()
		if yyct103 == codecSelferValueTypeMap1234 {
			yyl103 := r.ReadMapStart()
			if yyl103 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl103, d)
			}
		} else if yyct103 == codecSelferValueTypeArray1234 {
			yyl103 := r.ReadArrayStart()
			if yyl103 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl103, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTargetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys104Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys104Slc
	var yyhl104 bool = l >= 0
	for yyj104 := 0; ; yyj104++ {
		if yyhl104 {
			if yyj104 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys104Slc = r.DecodeBytes(yys104Slc, true, true)
		yys104 := string(yys104Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys104 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv105 := &x.Items
				yym106 := z.DecBinary()
				_ = yym106
				if false {
				} else {
					h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv105), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys104)
		} // end switch yys104
	} // end for yyj104
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTargetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj107 int
	var yyb107 bool
	var yyhl107 bool = l >= 0
	yyj107++
	if yyhl107 {
		yyb107 = yyj107 > l
	} else {
		yyb107 = r.CheckBreak()
	}
	if yyb107 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv108 := &x.Items
		yym109 := z.DecBinary()
		_ = yym109
		if false {
		} else {
			h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv108), d)
		}
	}
	for {
		yyj107++
		if yyhl107 {
			yyb107 = yyj107 > l
		} else {
			yyb107 = r.CheckBreak()
		}
		if yyb107 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj107-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym110 := z.EncBinary()
		_ = yym110
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep111 := !z.EncBinary()
			yy2arr111 := z.EncBasicHandle().StructToArray
			var yyq111 [2]bool
			_, _, _ = yysep111, yyq111, yy2arr111
			const yyr111 bool = false
			var yynn111 int
			if yyr111 || yy2arr111 {
				r.EncodeArrayStart(2)
			} else {
				yynn111 = 2
				for _, b := range yyq111 {
					if b {
						yynn111++
					}
				}
				r.EncodeMapStart(yynn111)
				yynn111 = 0
			}
			if yyr111 || yy2arr111 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym113 := z.EncBinary()
				_ = yym113
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym114 := z.EncBinary()
				_ = yym114
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr111 || yy2arr111 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy116 := &x.CurrentValue
				yym117 := z.EncBinary()
				_ = yym117
				if false {
				} else if z.HasExtensions() && z.EncExt(yy116) {
				} else if !yym117 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy116)
				} else {
					z.EncFallback(yy116)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy118 := &x.CurrentValue
				yym119 := z.EncBinary()
				_ = yym119
				if false {
				} else if z.HasExtensions() && z.EncExt(yy118) {
				} else if !yym119 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy118)
				} else {
					z.EncFallback(yy118)
				}
			}
			if yyr111 || yy2arr111 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym120 := z.DecBinary()
	_ = yym120
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct121 := r.ContainerType()
		if yyct121 == codecSelferValueTypeMap1234 {
			yyl121 := r.ReadMapStart()
			if yyl121 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl121, d)
			}
		} else if yyct121 == codecSelferValueTypeArray1234 {
			yyl121 := r.ReadArrayStart()
			if yyl121 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl121, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys122Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys122Slc
	var yyhl122 bool = l >= 0
	for yyj122 := 0; ; yyj122++ {
		if yyhl122 {
			if yyj122 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys122Slc = r.DecodeBytes(yys122Slc, true, true)
		yys122 := string(yys122Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys122 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.CurrentValue = pkg4_resource.Quantity{}
			} else {
				yyv124 := &x.CurrentValue
				yym125 := z.DecBinary()
				_ = yym125
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv124) {
				} else if !yym125 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv124)
				} else {
					z.DecFallback(yyv124, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys122)
		} // end switch yys122
	} // end for yyj122
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj126 int
	var yyb126 bool
	var yyhl126 bool = l >= 0
	yyj126++
	if yyhl126 {
		yyb126 = yyj126 > l
	} else {
		yyb126 = r.CheckBreak()
	}
	if yyb126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj126++
	if yyhl126 {
		yyb126 = yyj126 > l
	} else {
		yyb126 = r.CheckBreak()
	}
	if yyb126 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentValue = pkg4_resource.Quantity{}
	} else {
		yyv128 := &x.CurrentValue
		yym129 := z.DecBinary()
		_ = yym129
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv128) {
		} else if !yym129 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv128)
		} else {
			z.DecFallback(yyv128, false)
		}
	}
	for {
		yyj126++
		if yyhl126 {
			yyb126 = yyj126 > l
		} else {
			yyb126 = r.CheckBreak()
		}
		if yyb126 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj126-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatusList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym130 := z.EncBinary()
		_ = yym130
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep131 := !z.EncBinary()
			yy2arr131 := z.EncBasicHandle().StructToArray
			var yyq131 [1]bool
			_, _, _ = yysep131, yyq131, yy2arr131
			const yyr131 bool = false
			var yynn131 int
			if yyr131 || yy2arr131 {
				r.EncodeArrayStart(1)
			} else {
				yynn131 = 1
				for _, b := range yyq131 {
					if b {
						yynn131++
					}
				}
				r.EncodeMapStart(yynn131)
				yynn131 = 0
			}
			if yyr131 || yy2arr131 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym134 := z.EncBinary()
					_ = yym134
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			}
			if yyr131 || yy2arr131 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatusList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym135 := z.DecBinary()
	_ = yym135
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct136 := r.ContainerType()
		if yyct136 == codecSelferValueTypeMap1234 {
			yyl136 := r.ReadMapStart()
			if yyl136 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl136, d)
			}
		} else if yyct136 == codecSelferValueTypeArray1234 {
			yyl136 := r.ReadArrayStart()
			if yyl136 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl136, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys137Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys137Slc
	var yyhl137 bool = l >= 0
	for yyj137 := 0; ; yyj137++ {
		if yyhl137 {
			if yyj137 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys137Slc = r.DecodeBytes(yys137Slc, true, true)
		yys137 := string(yys137Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys137 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv138 := &x.Items
				yym139 := z.DecBinary()
				_ = yym139
				if false {
				} else {
					h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv138), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys137)
		} // end switch yys137
	} // end for yyj137
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj140 int
	var yyb140 bool
	var yyhl140 bool = l >= 0
	yyj140++
	if yyhl140 {
		yyb140 = yyj140 > l
	} else {
		yyb140 = r.CheckBreak()
	}
	if yyb140 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv141 := &x.Items
		yym142 := z.DecBinary()
		_ = yym142
		if false {
		} else {
			h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv141), d)
		}
	}
	for {
		yyj140++
		if yyhl140 {
			yyb140 = yyj140 > l
		} else {
			yyb140 = r.CheckBreak()
		}
		if yyb140 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj140-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym143 := z.EncBinary()
		_ = yym143
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep144 := !z.EncBinary()
			yy2arr144 := z.EncBasicHandle().StructToArray
			var yyq144 [5]bool
			_, _, _ = yysep144, yyq144, yy2arr144
			const yyr144 bool = false
			yyq144[0] = x.Kind != ""
			yyq144[1] = x.APIVersion != ""
			yyq144[2] = true
			yyq144[3] = x.Description != ""
			yyq144[4] = len(x.Versions) != 0
			var yynn144 int
			if yyr144 || yy2arr144 {
				r.EncodeArrayStart(5)
			} else {
				yynn144 = 0
				for _, b := range yyq144 {
					if b {
						yynn144++
					}
				}
				r.EncodeMapStart(yynn144)
				yynn144 = 0
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[0] {
					yym146 := z.EncBinary()
					_ = yym146
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq144[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym147 := z.EncBinary()
					_ = yym147
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[1] {
					yym149 := z.EncBinary()
					_ = yym149
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq144[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym150 := z.EncBinary()
					_ = yym150
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[2] {
					yy152 := &x.ObjectMeta
					yy152.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy153 := &x.ObjectMeta
					yy153.CodecEncodeSelf(e)
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[3] {
					yym155 := z.EncBinary()
					_ = yym155
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq144[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("description"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym156 := z.EncBinary()
					_ = yym156
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq144[4] {
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym158 := z.EncBinary()
						_ = yym158
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq144[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("versions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym159 := z.EncBinary()
						_ = yym159
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				}
			}
			if yyr144 || yy2arr144 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym160 := z.DecBinary()
	_ = yym160
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct161 := r.ContainerType()
		if yyct161 == codecSelferValueTypeMap1234 {
			yyl161 := r.ReadMapStart()
			if yyl161 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl161, d)
			}
		} else if yyct161 == codecSelferValueTypeArray1234 {
			yyl161 := r.ReadArrayStart()
			if yyl161 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl161, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys162Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys162Slc
	var yyhl162 bool = l >= 0
	for yyj162 := 0; ; yyj162++ {
		if yyhl162 {
			if yyj162 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys162Slc = r.DecodeBytes(yys162Slc, true, true)
		yys162 := string(yys162Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys162 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv165 := &x.ObjectMeta
				yyv165.CodecDecodeSelf(d)
			}
		case "description":
			if r.TryDecodeAsNil() {
				x.Description = ""
			} else {
				x.Description = string(r.DecodeString())
			}
		case "versions":
			if r.TryDecodeAsNil() {
				x.Versions = nil
			} else {
				yyv167 := &x.Versions
				yym168 := z.DecBinary()
				_ = yym168
				if false {
				} else {
					h.decSliceAPIVersion((*[]APIVersion)(yyv167), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys162)
		} // end switch yys162
	} // end for yyj162
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj169 int
	var yyb169 bool
	var yyhl169 bool = l >= 0
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv172 := &x.ObjectMeta
		yyv172.CodecDecodeSelf(d)
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Description = ""
	} else {
		x.Description = string(r.DecodeString())
	}
	yyj169++
	if yyhl169 {
		yyb169 = yyj169 > l
	} else {
		yyb169 = r.CheckBreak()
	}
	if yyb169 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Versions = nil
	} else {
		yyv174 := &x.Versions
		yym175 := z.DecBinary()
		_ = yym175
		if false {
		} else {
			h.decSliceAPIVersion((*[]APIVersion)(yyv174), d)
		}
	}
	for {
		yyj169++
		if yyhl169 {
			yyb169 = yyj169 > l
		} else {
			yyb169 = r.CheckBreak()
		}
		if yyb169 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj169-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym176 := z.EncBinary()
		_ = yym176
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep177 := !z.EncBinary()
			yy2arr177 := z.EncBasicHandle().StructToArray
			var yyq177 [4]bool
			_, _, _ = yysep177, yyq177, yy2arr177
			const yyr177 bool = false
			yyq177[0] = x.Kind != ""
			yyq177[1] = x.APIVersion != ""
			yyq177[2] = true
			var yynn177 int
			if yyr177 || yy2arr177 {
				r.EncodeArrayStart(4)
			} else {
				yynn177 = 1
				for _, b := range yyq177 {
					if b {
						yynn177++
					}
				}
				r.EncodeMapStart(yynn177)
				yynn177 = 0
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq177[0] {
					yym179 := z.EncBinary()
					_ = yym179
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq177[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym180 := z.EncBinary()
					_ = yym180
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq177[1] {
					yym182 := z.EncBinary()
					_ = yym182
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq177[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym183 := z.EncBinary()
					_ = yym183
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq177[2] {
					yy185 := &x.ListMeta
					yym186 := z.EncBinary()
					_ = yym186
					if false {
					} else if z.HasExtensions() && z.EncExt(yy185) {
					} else {
						z.EncFallback(yy185)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq177[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy187 := &x.ListMeta
					yym188 := z.EncBinary()
					_ = yym188
					if false {
					} else if z.HasExtensions() && z.EncExt(yy187) {
					} else {
						z.EncFallback(yy187)
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym190 := z.EncBinary()
					_ = yym190
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym191 := z.EncBinary()
					_ = yym191
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			}
			if yyr177 || yy2arr177 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym192 := z.DecBinary()
	_ = yym192
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct193 := r.ContainerType()
		if yyct193 == codecSelferValueTypeMap1234 {
			yyl193 := r.ReadMapStart()
			if yyl193 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl193, d)
			}
		} else if yyct193 == codecSelferValueTypeArray1234 {
			yyl193 := r.ReadArrayStart()
			if yyl193 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl193, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys194Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys194Slc
	var yyhl194 bool = l >= 0
	for yyj194 := 0; ; yyj194++ {
		if yyhl194 {
			if yyj194 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys194Slc = r.DecodeBytes(yys194Slc, true, true)
		yys194 := string(yys194Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys194 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv197 := &x.ListMeta
				yym198 := z.DecBinary()
				_ = yym198
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv197) {
				} else {
					z.DecFallback(yyv197, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv199 := &x.Items
				yym200 := z.DecBinary()
				_ = yym200
				if false {
				} else {
					h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv199), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys194)
		} // end switch yys194
	} // end for yyj194
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj201 int
	var yyb201 bool
	var yyhl201 bool = l >= 0
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv204 := &x.ListMeta
		yym205 := z.DecBinary()
		_ = yym205
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv204) {
		} else {
			z.DecFallback(yyv204, false)
		}
	}
	yyj201++
	if yyhl201 {
		yyb201 = yyj201 > l
	} else {
		yyb201 = r.CheckBreak()
	}
	if yyb201 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv206 := &x.Items
		yym207 := z.DecBinary()
		_ = yym207
		if false {
		} else {
			h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv206), d)
		}
	}
	for {
		yyj201++
		if yyhl201 {
			yyb201 = yyj201 > l
		} else {
			yyb201 = r.CheckBreak()
		}
		if yyb201 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj201-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *APIVersion) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym208 := z.EncBinary()
		_ = yym208
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep209 := !z.EncBinary()
			yy2arr209 := z.EncBasicHandle().StructToArray
			var yyq209 [1]bool
			_, _, _ = yysep209, yyq209, yy2arr209
			const yyr209 bool = false
			yyq209[0] = x.Name != ""
			var yynn209 int
			if yyr209 || yy2arr209 {
				r.EncodeArrayStart(1)
			} else {
				yynn209 = 0
				for _, b := range yyq209 {
					if b {
						yynn209++
					}
				}
				r.EncodeMapStart(yynn209)
				yynn209 = 0
			}
			if yyr209 || yy2arr209 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq209[0] {
					yym211 := z.EncBinary()
					_ = yym211
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq209[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym212 := z.EncBinary()
					_ = yym212
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr209 || yy2arr209 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *APIVersion) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym213 := z.DecBinary()
	_ = yym213
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct214 := r.ContainerType()
		if yyct214 == codecSelferValueTypeMap1234 {
			yyl214 := r.ReadMapStart()
			if yyl214 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl214, d)
			}
		} else if yyct214 == codecSelferValueTypeArray1234 {
			yyl214 := r.ReadArrayStart()
			if yyl214 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl214, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *APIVersion) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys215Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys215Slc
	var yyhl215 bool = l >= 0
	for yyj215 := 0; ; yyj215++ {
		if yyhl215 {
			if yyj215 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys215Slc = r.DecodeBytes(yys215Slc, true, true)
		yys215 := string(yys215Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys215 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys215)
		} // end switch yys215
	} // end for yyj215
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *APIVersion) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj217 int
	var yyb217 bool
	var yyhl217 bool = l >= 0
	yyj217++
	if yyhl217 {
		yyb217 = yyj217 > l
	} else {
		yyb217 = r.CheckBreak()
	}
	if yyb217 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj217++
		if yyhl217 {
			yyb217 = yyj217 > l
		} else {
			yyb217 = r.CheckBreak()
		}
		if yyb217 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj217-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceData) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym219 := z.EncBinary()
		_ = yym219
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep220 := !z.EncBinary()
			yy2arr220 := z.EncBasicHandle().StructToArray
			var yyq220 [4]bool
			_, _, _ = yysep220, yyq220, yy2arr220
			const yyr220 bool = false
			yyq220[0] = x.Kind != ""
			yyq220[1] = x.APIVersion != ""
			yyq220[2] = true
			yyq220[3] = len(x.Data) != 0
			var yynn220 int
			if yyr220 || yy2arr220 {
				r.EncodeArrayStart(4)
			} else {
				yynn220 = 0
				for _, b := range yyq220 {
					if b {
						yynn220++
					}
				}
				r.EncodeMapStart(yynn220)
				yynn220 = 0
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[0] {
					yym222 := z.EncBinary()
					_ = yym222
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq220[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym223 := z.EncBinary()
					_ = yym223
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[1] {
					yym225 := z.EncBinary()
					_ = yym225
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq220[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym226 := z.EncBinary()
					_ = yym226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[2] {
					yy228 := &x.ObjectMeta
					yy228.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq220[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy229 := &x.ObjectMeta
					yy229.CodecEncodeSelf(e)
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq220[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym231 := z.EncBinary()
						_ = yym231
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq220[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym232 := z.EncBinary()
						_ = yym232
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				}
			}
			if yyr220 || yy2arr220 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceData) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym233 := z.DecBinary()
	_ = yym233
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct234 := r.ContainerType()
		if yyct234 == codecSelferValueTypeMap1234 {
			yyl234 := r.ReadMapStart()
			if yyl234 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl234, d)
			}
		} else if yyct234 == codecSelferValueTypeArray1234 {
			yyl234 := r.ReadArrayStart()
			if yyl234 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl234, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys235Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys235Slc
	var yyhl235 bool = l >= 0
	for yyj235 := 0; ; yyj235++ {
		if yyhl235 {
			if yyj235 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys235Slc = r.DecodeBytes(yys235Slc, true, true)
		yys235 := string(yys235Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys235 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv238 := &x.ObjectMeta
				yyv238.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv239 := &x.Data
				yym240 := z.DecBinary()
				_ = yym240
				if false {
				} else {
					*yyv239 = r.DecodeBytes(*(*[]byte)(yyv239), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys235)
		} // end switch yys235
	} // end for yyj235
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj241 int
	var yyb241 bool
	var yyhl241 bool = l >= 0
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv244 := &x.ObjectMeta
		yyv244.CodecDecodeSelf(d)
	}
	yyj241++
	if yyhl241 {
		yyb241 = yyj241 > l
	} else {
		yyb241 = r.CheckBreak()
	}
	if yyb241 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv245 := &x.Data
		yym246 := z.DecBinary()
		_ = yym246
		if false {
		} else {
			*yyv245 = r.DecodeBytes(*(*[]byte)(yyv245), false, false)
		}
	}
	for {
		yyj241++
		if yyhl241 {
			yyb241 = yyj241 > l
		} else {
			yyb241 = r.CheckBreak()
		}
		if yyb241 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj241-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Deployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym247 := z.EncBinary()
		_ = yym247
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep248 := !z.EncBinary()
			yy2arr248 := z.EncBasicHandle().StructToArray
			var yyq248 [5]bool
			_, _, _ = yysep248, yyq248, yy2arr248
			const yyr248 bool = false
			yyq248[0] = x.Kind != ""
			yyq248[1] = x.APIVersion != ""
			yyq248[2] = true
			yyq248[3] = true
			yyq248[4] = true
			var yynn248 int
			if yyr248 || yy2arr248 {
				r.EncodeArrayStart(5)
			} else {
				yynn248 = 0
				for _, b := range yyq248 {
					if b {
						yynn248++
					}
				}
				r.EncodeMapStart(yynn248)
				yynn248 = 0
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[0] {
					yym250 := z.EncBinary()
					_ = yym250
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq248[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym251 := z.EncBinary()
					_ = yym251
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[1] {
					yym253 := z.EncBinary()
					_ = yym253
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq248[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym254 := z.EncBinary()
					_ = yym254
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[2] {
					yy256 := &x.ObjectMeta
					yy256.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq248[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy257 := &x.ObjectMeta
					yy257.CodecEncodeSelf(e)
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[3] {
					yy259 := &x.Spec
					yy259.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq248[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy260 := &x.Spec
					yy260.CodecEncodeSelf(e)
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq248[4] {
					yy262 := &x.Status
					yy262.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq248[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy263 := &x.Status
					yy263.CodecEncodeSelf(e)
				}
			}
			if yyr248 || yy2arr248 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Deployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym264 := z.DecBinary()
	_ = yym264
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct265 := r.ContainerType()
		if yyct265 == codecSelferValueTypeMap1234 {
			yyl265 := r.ReadMapStart()
			if yyl265 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl265, d)
			}
		} else if yyct265 == codecSelferValueTypeArray1234 {
			yyl265 := r.ReadArrayStart()
			if yyl265 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl265, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Deployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys266Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys266Slc
	var yyhl266 bool = l >= 0
	for yyj266 := 0; ; yyj266++ {
		if yyhl266 {
			if yyj266 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys266Slc = r.DecodeBytes(yys266Slc, true, true)
		yys266 := string(yys266Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys266 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv269 := &x.ObjectMeta
				yyv269.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DeploymentSpec{}
			} else {
				yyv270 := &x.Spec
				yyv270.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DeploymentStatus{}
			} else {
				yyv271 := &x.Status
				yyv271.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys266)
		} // end switch yys266
	} // end for yyj266
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Deployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj272 int
	var yyb272 bool
	var yyhl272 bool = l >= 0
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv275 := &x.ObjectMeta
		yyv275.CodecDecodeSelf(d)
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DeploymentSpec{}
	} else {
		yyv276 := &x.Spec
		yyv276.CodecDecodeSelf(d)
	}
	yyj272++
	if yyhl272 {
		yyb272 = yyj272 > l
	} else {
		yyb272 = r.CheckBreak()
	}
	if yyb272 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DeploymentStatus{}
	} else {
		yyv277 := &x.Status
		yyv277.CodecDecodeSelf(d)
	}
	for {
		yyj272++
		if yyhl272 {
			yyb272 = yyj272 > l
		} else {
			yyb272 = r.CheckBreak()
		}
		if yyb272 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj272-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym278 := z.EncBinary()
		_ = yym278
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep279 := !z.EncBinary()
			yy2arr279 := z.EncBasicHandle().StructToArray
			var yyq279 [9]bool
			_, _, _ = yysep279, yyq279, yy2arr279
			const yyr279 bool = false
			yyq279[0] = x.Replicas != 0
			yyq279[1] = x.Selector != nil
			yyq279[3] = true
			yyq279[4] = x.MinReadySeconds != 0
			yyq279[5] = x.RevisionHistoryLimit != nil
			yyq279[6] = x.Paused != false
			yyq279[7] = x.RollbackTo != nil
			yyq279[8] = x.ProgressDeadlineSeconds != nil
			var yynn279 int
			if yyr279 || yy2arr279 {
				r.EncodeArrayStart(9)
			} else {
				yynn279 = 1
				for _, b := range yyq279 {
					if b {
						yynn279++
					}
				}
				r.EncodeMapStart(yynn279)
				yynn279 = 0
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[0] {
					yym281 := z.EncBinary()
					_ = yym281
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq279[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym282 := z.EncBinary()
					_ = yym282
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym284 := z.EncBinary()
						_ = yym284
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym285 := z.EncBinary()
						_ = yym285
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy287 := &x.Template
				yy287.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy288 := &x.Template
				yy288.CodecEncodeSelf(e)
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[3] {
					yy290 := &x.Strategy
					yy290.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("strategy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy291 := &x.Strategy
					yy291.CodecEncodeSelf(e)
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[4] {
					yym293 := z.EncBinary()
					_ = yym293
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq279[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym294 := z.EncBinary()
					_ = yym294
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[5] {
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy296 := *x.RevisionHistoryLimit
						yym297 := z.EncBinary()
						_ = yym297
						if false {
						} else {
							r.EncodeInt(int64(yy296))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revisionHistoryLimit"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy298 := *x.RevisionHistoryLimit
						yym299 := z.EncBinary()
						_ = yym299
						if false {
						} else {
							r.EncodeInt(int64(yy298))
						}
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[6] {
					yym301 := z.EncBinary()
					_ = yym301
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq279[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("paused"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym302 := z.EncBinary()
					_ = yym302
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[7] {
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq279[8] {
					if x.ProgressDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy305 := *x.ProgressDeadlineSeconds
						yym306 := z.EncBinary()
						_ = yym306
						if false {
						} else {
							r.EncodeInt(int64(yy305))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq279[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("progressDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ProgressDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy307 := *x.ProgressDeadlineSeconds
						yym308 := z.EncBinary()
						_ = yym308
						if false {
						} else {
							r.EncodeInt(int64(yy307))
						}
					}
				}
			}
			if yyr279 || yy2arr279 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym309 := z.DecBinary()
	_ = yym309
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct310 := r.ContainerType()
		if yyct310 == codecSelferValueTypeMap1234 {
			yyl310 := r.ReadMapStart()
			if yyl310 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl310, d)
			}
		} else if yyct310 == codecSelferValueTypeArray1234 {
			yyl310 := r.ReadArrayStart()
			if yyl310 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl310, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys311Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys311Slc
	var yyhl311 bool = l >= 0
	for yyj311 := 0; ; yyj311++ {
		if yyhl311 {
			if yyj311 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys311Slc = r.DecodeBytes(yys311Slc, true, true)
		yys311 := string(yys311Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys311 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym314 := z.DecBinary()
				_ = yym314
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv315 := &x.Template
				yyv315.CodecDecodeSelf(d)
			}
		case "strategy":
			if r.TryDecodeAsNil() {
				x.Strategy = DeploymentStrategy{}
			} else {
				yyv316 := &x.Strategy
				yyv316.CodecDecodeSelf(d)
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "revisionHistoryLimit":
			if r.TryDecodeAsNil() {
				if x.RevisionHistoryLimit != nil {
					x.RevisionHistoryLimit = nil
				}
			} else {
				if x.RevisionHistoryLimit == nil {
					x.RevisionHistoryLimit = new(int32)
				}
				yym319 := z.DecBinary()
				_ = yym319
				if false {
				} else {
					*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
				}
			}
		case "paused":
			if r.TryDecodeAsNil() {
				x.Paused = false
			} else {
				x.Paused = bool(r.DecodeBool())
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				if x.RollbackTo != nil {
					x.RollbackTo = nil
				}
			} else {
				if x.RollbackTo == nil {
					x.RollbackTo = new(RollbackConfig)
				}
				x.RollbackTo.CodecDecodeSelf(d)
			}
		case "progressDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ProgressDeadlineSeconds != nil {
					x.ProgressDeadlineSeconds = nil
				}
			} else {
				if x.ProgressDeadlineSeconds == nil {
					x.ProgressDeadlineSeconds = new(int32)
				}
				yym323 := z.DecBinary()
				_ = yym323
				if false {
				} else {
					*((*int32)(x.ProgressDeadlineSeconds)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys311)
		} // end switch yys311
	} // end for yyj311
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj324 int
	var yyb324 bool
	var yyhl324 bool = l >= 0
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym327 := z.DecBinary()
		_ = yym327
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv328 := &x.Template
		yyv328.CodecDecodeSelf(d)
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Strategy = DeploymentStrategy{}
	} else {
		yyv329 := &x.Strategy
		yyv329.CodecDecodeSelf(d)
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RevisionHistoryLimit != nil {
			x.RevisionHistoryLimit = nil
		}
	} else {
		if x.RevisionHistoryLimit == nil {
			x.RevisionHistoryLimit = new(int32)
		}
		yym332 := z.DecBinary()
		_ = yym332
		if false {
		} else {
			*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
		}
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paused = false
	} else {
		x.Paused = bool(r.DecodeBool())
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollbackTo != nil {
			x.RollbackTo = nil
		}
	} else {
		if x.RollbackTo == nil {
			x.RollbackTo = new(RollbackConfig)
		}
		x.RollbackTo.CodecDecodeSelf(d)
	}
	yyj324++
	if yyhl324 {
		yyb324 = yyj324 > l
	} else {
		yyb324 = r.CheckBreak()
	}
	if yyb324 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ProgressDeadlineSeconds != nil {
			x.ProgressDeadlineSeconds = nil
		}
	} else {
		if x.ProgressDeadlineSeconds == nil {
			x.ProgressDeadlineSeconds = new(int32)
		}
		yym336 := z.DecBinary()
		_ = yym336
		if false {
		} else {
			*((*int32)(x.ProgressDeadlineSeconds)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj324++
		if yyhl324 {
			yyb324 = yyj324 > l
		} else {
			yyb324 = r.CheckBreak()
		}
		if yyb324 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj324-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentRollback) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym337 := z.EncBinary()
		_ = yym337
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep338 := !z.EncBinary()
			yy2arr338 := z.EncBasicHandle().StructToArray
			var yyq338 [5]bool
			_, _, _ = yysep338, yyq338, yy2arr338
			const yyr338 bool = false
			yyq338[0] = x.Kind != ""
			yyq338[1] = x.APIVersion != ""
			yyq338[3] = len(x.UpdatedAnnotations) != 0
			var yynn338 int
			if yyr338 || yy2arr338 {
				r.EncodeArrayStart(5)
			} else {
				yynn338 = 2
				for _, b := range yyq338 {
					if b {
						yynn338++
					}
				}
				r.EncodeMapStart(yynn338)
				yynn338 = 0
			}
			if yyr338 || yy2arr338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq338[0] {
					yym340 := z.EncBinary()
					_ = yym340
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq338[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym341 := z.EncBinary()
					_ = yym341
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr338 || yy2arr338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq338[1] {
					yym343 := z.EncBinary()
					_ = yym343
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq338[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym344 := z.EncBinary()
					_ = yym344
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr338 || yy2arr338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym346 := z.EncBinary()
				_ = yym346
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym347 := z.EncBinary()
				_ = yym347
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr338 || yy2arr338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq338[3] {
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym349 := z.EncBinary()
						_ = yym349
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq338[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedAnnotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym350 := z.EncBinary()
						_ = yym350
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				}
			}
			if yyr338 || yy2arr338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy352 := &x.RollbackTo
				yy352.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy353 := &x.RollbackTo
				yy353.CodecEncodeSelf(e)
			}
			if yyr338 || yy2arr338 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentRollback) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym354 := z.DecBinary()
	_ = yym354
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct355 := r.ContainerType()
		if yyct355 == codecSelferValueTypeMap1234 {
			yyl355 := r.ReadMapStart()
			if yyl355 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl355, d)
			}
		} else if yyct355 == codecSelferValueTypeArray1234 {
			yyl355 := r.ReadArrayStart()
			if yyl355 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl355, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentRollback) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys356Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys356Slc
	var yyhl356 bool = l >= 0
	for yyj356 := 0; ; yyj356++ {
		if yyhl356 {
			if yyj356 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys356Slc = r.DecodeBytes(yys356Slc, true, true)
		yys356 := string(yys356Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys356 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "updatedAnnotations":
			if r.TryDecodeAsNil() {
				x.UpdatedAnnotations = nil
			} else {
				yyv360 := &x.UpdatedAnnotations
				yym361 := z.DecBinary()
				_ = yym361
				if false {
				} else {
					z.F.DecMapStringStringX(yyv360, false, d)
				}
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				x.RollbackTo = RollbackConfig{}
			} else {
				yyv362 := &x.RollbackTo
				yyv362.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys356)
		} // end switch yys356
	} // end for yyj356
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentRollback) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj363 int
	var yyb363 bool
	var yyhl363 bool = l >= 0
	yyj363++
	if yyhl363 {
		yyb363 = yyj363 > l
	} else {
		yyb363 = r.CheckBreak()
	}
	if yyb363 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj363++
	if yyhl363 {
		yyb363 = yyj363 > l
	} else {
		yyb363 = r.CheckBreak()
	}
	if yyb363 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj363++
	if yyhl363 {
		yyb363 = yyj363 > l
	} else {
		yyb363 = r.CheckBreak()
	}
	if yyb363 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj363++
	if yyhl363 {
		yyb363 = yyj363 > l
	} else {
		yyb363 = r.CheckBreak()
	}
	if yyb363 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedAnnotations = nil
	} else {
		yyv367 := &x.UpdatedAnnotations
		yym368 := z.DecBinary()
		_ = yym368
		if false {
		} else {
			z.F.DecMapStringStringX(yyv367, false, d)
		}
	}
	yyj363++
	if yyhl363 {
		yyb363 = yyj363 > l
	} else {
		yyb363 = r.CheckBreak()
	}
	if yyb363 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RollbackTo = RollbackConfig{}
	} else {
		yyv369 := &x.RollbackTo
		yyv369.CodecDecodeSelf(d)
	}
	for {
		yyj363++
		if yyhl363 {
			yyb363 = yyj363 > l
		} else {
			yyb363 = r.CheckBreak()
		}
		if yyb363 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj363-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RollbackConfig) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym370 := z.EncBinary()
		_ = yym370
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep371 := !z.EncBinary()
			yy2arr371 := z.EncBasicHandle().StructToArray
			var yyq371 [1]bool
			_, _, _ = yysep371, yyq371, yy2arr371
			const yyr371 bool = false
			yyq371[0] = x.Revision != 0
			var yynn371 int
			if yyr371 || yy2arr371 {
				r.EncodeArrayStart(1)
			} else {
				yynn371 = 0
				for _, b := range yyq371 {
					if b {
						yynn371++
					}
				}
				r.EncodeMapStart(yynn371)
				yynn371 = 0
			}
			if yyr371 || yy2arr371 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq371[0] {
					yym373 := z.EncBinary()
					_ = yym373
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq371[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym374 := z.EncBinary()
					_ = yym374
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				}
			}
			if yyr371 || yy2arr371 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollbackConfig) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym375 := z.DecBinary()
	_ = yym375
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct376 := r.ContainerType()
		if yyct376 == codecSelferValueTypeMap1234 {
			yyl376 := r.ReadMapStart()
			if yyl376 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl376, d)
			}
		} else if yyct376 == codecSelferValueTypeArray1234 {
			yyl376 := r.ReadArrayStart()
			if yyl376 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl376, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollbackConfig) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys377Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys377Slc
	var yyhl377 bool = l >= 0
	for yyj377 := 0; ; yyj377++ {
		if yyhl377 {
			if yyj377 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys377Slc = r.DecodeBytes(yys377Slc, true, true)
		yys377 := string(yys377Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys377 {
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = 0
			} else {
				x.Revision = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys377)
		} // end switch yys377
	} // end for yyj377
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollbackConfig) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj379 int
	var yyb379 bool
	var yyhl379 bool = l >= 0
	yyj379++
	if yyhl379 {
		yyb379 = yyj379 > l
	} else {
		yyb379 = r.CheckBreak()
	}
	if yyb379 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = 0
	} else {
		x.Revision = int64(r.DecodeInt(64))
	}
	for {
		yyj379++
		if yyhl379 {
			yyb379 = yyj379 > l
		} else {
			yyb379 = r.CheckBreak()
		}
		if yyb379 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj379-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym381 := z.EncBinary()
		_ = yym381
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep382 := !z.EncBinary()
			yy2arr382 := z.EncBasicHandle().StructToArray
			var yyq382 [2]bool
			_, _, _ = yysep382, yyq382, yy2arr382
			const yyr382 bool = false
			yyq382[0] = x.Type != ""
			yyq382[1] = x.RollingUpdate != nil
			var yynn382 int
			if yyr382 || yy2arr382 {
				r.EncodeArrayStart(2)
			} else {
				yynn382 = 0
				for _, b := range yyq382 {
					if b {
						yynn382++
					}
				}
				r.EncodeMapStart(yynn382)
				yynn382 = 0
			}
			if yyr382 || yy2arr382 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq382[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq382[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr382 || yy2arr382 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq382[1] {
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq382[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollingUpdate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				}
			}
			if yyr382 || yy2arr382 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym385 := z.DecBinary()
	_ = yym385
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct386 := r.ContainerType()
		if yyct386 == codecSelferValueTypeMap1234 {
			yyl386 := r.ReadMapStart()
			if yyl386 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl386, d)
			}
		} else if yyct386 == codecSelferValueTypeArray1234 {
			yyl386 := r.ReadArrayStart()
			if yyl386 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl386, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStrategy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys387Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys387Slc
	var yyhl387 bool = l >= 0
	for yyj387 := 0; ; yyj387++ {
		if yyhl387 {
			if yyj387 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys387Slc = r.DecodeBytes(yys387Slc, true, true)
		yys387 := string(yys387Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys387 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentStrategyType(r.DecodeString())
			}
		case "rollingUpdate":
			if r.TryDecodeAsNil() {
				if x.RollingUpdate != nil {
					x.RollingUpdate = nil
				}
			} else {
				if x.RollingUpdate == nil {
					x.RollingUpdate = new(RollingUpdateDeployment)
				}
				x.RollingUpdate.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys387)
		} // end switch yys387
	} // end for yyj387
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStrategy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj390 int
	var yyb390 bool
	var yyhl390 bool = l >= 0
	yyj390++
	if yyhl390 {
		yyb390 = yyj390 > l
	} else {
		yyb390 = r.CheckBreak()
	}
	if yyb390 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentStrategyType(r.DecodeString())
	}
	yyj390++
	if yyhl390 {
		yyb390 = yyj390 > l
	} else {
		yyb390 = r.CheckBreak()
	}
	if yyb390 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollingUpdate != nil {
			x.RollingUpdate = nil
		}
	} else {
		if x.RollingUpdate == nil {
			x.RollingUpdate = new(RollingUpdateDeployment)
		}
		x.RollingUpdate.CodecDecodeSelf(d)
	}
	for {
		yyj390++
		if yyhl390 {
			yyb390 = yyj390 > l
		} else {
			yyb390 = r.CheckBreak()
		}
		if yyb390 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj390-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym393 := z.EncBinary()
	_ = yym393
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym394 := z.DecBinary()
	_ = yym394
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RollingUpdateDeployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym395 := z.EncBinary()
		_ = yym395
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep396 := !z.EncBinary()
			yy2arr396 := z.EncBasicHandle().StructToArray
			var yyq396 [2]bool
			_, _, _ = yysep396, yyq396, yy2arr396
			const yyr396 bool = false
			yyq396[0] = true
			yyq396[1] = true
			var yynn396 int
			if yyr396 || yy2arr396 {
				r.EncodeArrayStart(2)
			} else {
				yynn396 = 0
				for _, b := range yyq396 {
					if b {
						yynn396++
					}
				}
				r.EncodeMapStart(yynn396)
				yynn396 = 0
			}
			if yyr396 || yy2arr396 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq396[0] {
					yy398 := &x.MaxUnavailable
					yym399 := z.EncBinary()
					_ = yym399
					if false {
					} else if z.HasExtensions() && z.EncExt(yy398) {
					} else if !yym399 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy398)
					} else {
						z.EncFallback(yy398)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq396[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxUnavailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy400 := &x.MaxUnavailable
					yym401 := z.EncBinary()
					_ = yym401
					if false {
					} else if z.HasExtensions() && z.EncExt(yy400) {
					} else if !yym401 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy400)
					} else {
						z.EncFallback(yy400)
					}
				}
			}
			if yyr396 || yy2arr396 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq396[1] {
					yy403 := &x.MaxSurge
					yym404 := z.EncBinary()
					_ = yym404
					if false {
					} else if z.HasExtensions() && z.EncExt(yy403) {
					} else if !yym404 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy403)
					} else {
						z.EncFallback(yy403)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq396[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxSurge"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy405 := &x.MaxSurge
					yym406 := z.EncBinary()
					_ = yym406
					if false {
					} else if z.HasExtensions() && z.EncExt(yy405) {
					} else if !yym406 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy405)
					} else {
						z.EncFallback(yy405)
					}
				}
			}
			if yyr396 || yy2arr396 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollingUpdateDeployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym407 := z.DecBinary()
	_ = yym407
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct408 := r.ContainerType()
		if yyct408 == codecSelferValueTypeMap1234 {
			yyl408 := r.ReadMapStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl408, d)
			}
		} else if yyct408 == codecSelferValueTypeArray1234 {
			yyl408 := r.ReadArrayStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl408, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys409Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys409Slc
	var yyhl409 bool = l >= 0
	for yyj409 := 0; ; yyj409++ {
		if yyhl409 {
			if yyj409 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys409Slc = r.DecodeBytes(yys409Slc, true, true)
		yys409 := string(yys409Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys409 {
		case "maxUnavailable":
			if r.TryDecodeAsNil() {
				x.MaxUnavailable = pkg5_intstr.IntOrString{}
			} else {
				yyv410 := &x.MaxUnavailable
				yym411 := z.DecBinary()
				_ = yym411
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv410) {
				} else if !yym411 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv410)
				} else {
					z.DecFallback(yyv410, false)
				}
			}
		case "maxSurge":
			if r.TryDecodeAsNil() {
				x.MaxSurge = pkg5_intstr.IntOrString{}
			} else {
				yyv412 := &x.MaxSurge
				yym413 := z.DecBinary()
				_ = yym413
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv412) {
				} else if !yym413 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv412)
				} else {
					z.DecFallback(yyv412, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys409)
		} // end switch yys409
	} // end for yyj409
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj414 int
	var yyb414 bool
	var yyhl414 bool = l >= 0
	yyj414++
	if yyhl414 {
		yyb414 = yyj414 > l
	} else {
		yyb414 = r.CheckBreak()
	}
	if yyb414 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxUnavailable = pkg5_intstr.IntOrString{}
	} else {
		yyv415 := &x.MaxUnavailable
		yym416 := z.DecBinary()
		_ = yym416
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv415) {
		} else if !yym416 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv415)
		} else {
			z.DecFallback(yyv415, false)
		}
	}
	yyj414++
	if yyhl414 {
		yyb414 = yyj414 > l
	} else {
		yyb414 = r.CheckBreak()
	}
	if yyb414 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxSurge = pkg5_intstr.IntOrString{}
	} else {
		yyv417 := &x.MaxSurge
		yym418 := z.DecBinary()
		_ = yym418
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv417) {
		} else if !yym418 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv417)
		} else {
			z.DecFallback(yyv417, false)
		}
	}
	for {
		yyj414++
		if yyhl414 {
			yyb414 = yyj414 > l
		} else {
			yyb414 = r.CheckBreak()
		}
		if yyb414 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj414-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym419 := z.EncBinary()
		_ = yym419
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep420 := !z.EncBinary()
			yy2arr420 := z.EncBasicHandle().StructToArray
			var yyq420 [6]bool
			_, _, _ = yysep420, yyq420, yy2arr420
			const yyr420 bool = false
			yyq420[0] = x.ObservedGeneration != 0
			yyq420[1] = x.Replicas != 0
			yyq420[2] = x.UpdatedReplicas != 0
			yyq420[3] = x.AvailableReplicas != 0
			yyq420[4] = x.UnavailableReplicas != 0
			yyq420[5] = len(x.Conditions) != 0
			var yynn420 int
			if yyr420 || yy2arr420 {
				r.EncodeArrayStart(6)
			} else {
				yynn420 = 0
				for _, b := range yyq420 {
					if b {
						yynn420++
					}
				}
				r.EncodeMapStart(yynn420)
				yynn420 = 0
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[0] {
					yym422 := z.EncBinary()
					_ = yym422
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq420[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym423 := z.EncBinary()
					_ = yym423
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[1] {
					yym425 := z.EncBinary()
					_ = yym425
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq420[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym426 := z.EncBinary()
					_ = yym426
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[2] {
					yym428 := z.EncBinary()
					_ = yym428
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq420[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym429 := z.EncBinary()
					_ = yym429
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[3] {
					yym431 := z.EncBinary()
					_ = yym431
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq420[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym432 := z.EncBinary()
					_ = yym432
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[4] {
					yym434 := z.EncBinary()
					_ = yym434
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq420[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unavailableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym435 := z.EncBinary()
					_ = yym435
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq420[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym437 := z.EncBinary()
						_ = yym437
						if false {
						} else {
							h.encSliceDeploymentCondition(([]DeploymentCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq420[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym438 := z.EncBinary()
						_ = yym438
						if false {
						} else {
							h.encSliceDeploymentCondition(([]DeploymentCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr420 || yy2arr420 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym439 := z.DecBinary()
	_ = yym439
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct440 := r.ContainerType()
		if yyct440 == codecSelferValueTypeMap1234 {
			yyl440 := r.ReadMapStart()
			if yyl440 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl440, d)
			}
		} else if yyct440 == codecSelferValueTypeArray1234 {
			yyl440 := r.ReadArrayStart()
			if yyl440 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl440, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys441Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys441Slc
	var yyhl441 bool = l >= 0
	for yyj441 := 0; ; yyj441++ {
		if yyhl441 {
			if yyj441 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys441Slc = r.DecodeBytes(yys441Slc, true, true)
		yys441 := string(yys441Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys441 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "updatedReplicas":
			if r.TryDecodeAsNil() {
				x.UpdatedReplicas = 0
			} else {
				x.UpdatedReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "unavailableReplicas":
			if r.TryDecodeAsNil() {
				x.UnavailableReplicas = 0
			} else {
				x.UnavailableReplicas = int32(r.DecodeInt(32))
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv447 := &x.Conditions
				yym448 := z.DecBinary()
				_ = yym448
				if false {
				} else {
					h.decSliceDeploymentCondition((*[]DeploymentCondition)(yyv447), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys441)
		} // end switch yys441
	} // end for yyj441
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj449 int
	var yyb449 bool
	var yyhl449 bool = l >= 0
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedReplicas = 0
	} else {
		x.UpdatedReplicas = int32(r.DecodeInt(32))
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnavailableReplicas = 0
	} else {
		x.UnavailableReplicas = int32(r.DecodeInt(32))
	}
	yyj449++
	if yyhl449 {
		yyb449 = yyj449 > l
	} else {
		yyb449 = r.CheckBreak()
	}
	if yyb449 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv455 := &x.Conditions
		yym456 := z.DecBinary()
		_ = yym456
		if false {
		} else {
			h.decSliceDeploymentCondition((*[]DeploymentCondition)(yyv455), d)
		}
	}
	for {
		yyj449++
		if yyhl449 {
			yyb449 = yyj449 > l
		} else {
			yyb449 = r.CheckBreak()
		}
		if yyb449 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj449-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym457 := z.EncBinary()
	_ = yym457
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym458 := z.DecBinary()
	_ = yym458
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *DeploymentCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym459 := z.EncBinary()
		_ = yym459
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep460 := !z.EncBinary()
			yy2arr460 := z.EncBasicHandle().StructToArray
			var yyq460 [6]bool
			_, _, _ = yysep460, yyq460, yy2arr460
			const yyr460 bool = false
			yyq460[2] = true
			yyq460[3] = true
			yyq460[4] = x.Reason != ""
			yyq460[5] = x.Message != ""
			var yynn460 int
			if yyr460 || yy2arr460 {
				r.EncodeArrayStart(6)
			} else {
				yynn460 = 2
				for _, b := range yyq460 {
					if b {
						yynn460++
					}
				}
				r.EncodeMapStart(yynn460)
				yynn460 = 0
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym463 := z.EncBinary()
				_ = yym463
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym464 := z.EncBinary()
				_ = yym464
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq460[2] {
					yy466 := &x.LastUpdateTime
					yym467 := z.EncBinary()
					_ = yym467
					if false {
					} else if z.HasExtensions() && z.EncExt(yy466) {
					} else if yym467 {
						z.EncBinaryMarshal(yy466)
					} else if !yym467 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy466)
					} else {
						z.EncFallback(yy466)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq460[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastUpdateTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy468 := &x.LastUpdateTime
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else if z.HasExtensions() && z.EncExt(yy468) {
					} else if yym469 {
						z.EncBinaryMarshal(yy468)
					} else if !yym469 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy468)
					} else {
						z.EncFallback(yy468)
					}
				}
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq460[3] {
					yy471 := &x.LastTransitionTime
					yym472 := z.EncBinary()
					_ = yym472
					if false {
					} else if z.HasExtensions() && z.EncExt(yy471) {
					} else if yym472 {
						z.EncBinaryMarshal(yy471)
					} else if !yym472 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy471)
					} else {
						z.EncFallback(yy471)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq460[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy473 := &x.LastTransitionTime
					yym474 := z.EncBinary()
					_ = yym474
					if false {
					} else if z.HasExtensions() && z.EncExt(yy473) {
					} else if yym474 {
						z.EncBinaryMarshal(yy473)
					} else if !yym474 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy473)
					} else {
						z.EncFallback(yy473)
					}
				}
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq460[4] {
					yym476 := z.EncBinary()
					_ = yym476
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq460[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym477 := z.EncBinary()
					_ = yym477
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq460[5] {
					yym479 := z.EncBinary()
					_ = yym479
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq460[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym480 := z.EncBinary()
					_ = yym480
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr460 || yy2arr460 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym481 := z.DecBinary()
	_ = yym481
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct482 := r.ContainerType()
		if yyct482 == codecSelferValueTypeMap1234 {
			yyl482 := r.ReadMapStart()
			if yyl482 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl482, d)
			}
		} else if yyct482 == codecSelferValueTypeArray1234 {
			yyl482 := r.ReadArrayStart()
			if yyl482 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl482, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys483Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys483Slc
	var yyhl483 bool = l >= 0
	for yyj483 := 0; ; yyj483++ {
		if yyhl483 {
			if yyj483 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys483Slc = r.DecodeBytes(yys483Slc, true, true)
		yys483 := string(yys483Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys483 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_api.ConditionStatus(r.DecodeString())
			}
		case "lastUpdateTime":
			if r.TryDecodeAsNil() {
				x.LastUpdateTime = pkg1_unversioned.Time{}
			} else {
				yyv486 := &x.LastUpdateTime
				yym487 := z.DecBinary()
				_ = yym487
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv486) {
				} else if yym487 {
					z.DecBinaryUnmarshal(yyv486)
				} else if !yym487 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv486)
				} else {
					z.DecFallback(yyv486, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv488 := &x.LastTransitionTime
				yym489 := z.DecBinary()
				_ = yym489
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv488) {
				} else if yym489 {
					z.DecBinaryUnmarshal(yyv488)
				} else if !yym489 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv488)
				} else {
					z.DecFallback(yyv488, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys483)
		} // end switch yys483
	} // end for yyj483
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj492 int
	var yyb492 bool
	var yyhl492 bool = l >= 0
	yyj492++
	if yyhl492 {
		yyb492 = yyj492 > l
	} else {
		yyb492 = r.CheckBreak()
	}
	if yyb492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentConditionType(r.DecodeString())
	}
	yyj492++
	if yyhl492 {
		yyb492 = yyj492 > l
	} else {
		yyb492 = r.CheckBreak()
	}
	if yyb492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_api.ConditionStatus(r.DecodeString())
	}
	yyj492++
	if yyhl492 {
		yyb492 = yyj492 > l
	} else {
		yyb492 = r.CheckBreak()
	}
	if yyb492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastUpdateTime = pkg1_unversioned.Time{}
	} else {
		yyv495 := &x.LastUpdateTime
		yym496 := z.DecBinary()
		_ = yym496
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv495) {
		} else if yym496 {
			z.DecBinaryUnmarshal(yyv495)
		} else if !yym496 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv495)
		} else {
			z.DecFallback(yyv495, false)
		}
	}
	yyj492++
	if yyhl492 {
		yyb492 = yyj492 > l
	} else {
		yyb492 = r.CheckBreak()
	}
	if yyb492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv497 := &x.LastTransitionTime
		yym498 := z.DecBinary()
		_ = yym498
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv497) {
		} else if yym498 {
			z.DecBinaryUnmarshal(yyv497)
		} else if !yym498 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv497)
		} else {
			z.DecFallback(yyv497, false)
		}
	}
	yyj492++
	if yyhl492 {
		yyb492 = yyj492 > l
	} else {
		yyb492 = r.CheckBreak()
	}
	if yyb492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj492++
	if yyhl492 {
		yyb492 = yyj492 > l
	} else {
		yyb492 = r.CheckBreak()
	}
	if yyb492 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj492++
		if yyhl492 {
			yyb492 = yyj492 > l
		} else {
			yyb492 = r.CheckBreak()
		}
		if yyb492 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj492-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym501 := z.EncBinary()
		_ = yym501
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep502 := !z.EncBinary()
			yy2arr502 := z.EncBasicHandle().StructToArray
			var yyq502 [4]bool
			_, _, _ = yysep502, yyq502, yy2arr502
			const yyr502 bool = false
			yyq502[0] = x.Kind != ""
			yyq502[1] = x.APIVersion != ""
			yyq502[2] = true
			var yynn502 int
			if yyr502 || yy2arr502 {
				r.EncodeArrayStart(4)
			} else {
				yynn502 = 1
				for _, b := range yyq502 {
					if b {
						yynn502++
					}
				}
				r.EncodeMapStart(yynn502)
				yynn502 = 0
			}
			if yyr502 || yy2arr502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq502[0] {
					yym504 := z.EncBinary()
					_ = yym504
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq502[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym505 := z.EncBinary()
					_ = yym505
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr502 || yy2arr502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq502[1] {
					yym507 := z.EncBinary()
					_ = yym507
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq502[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym508 := z.EncBinary()
					_ = yym508
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr502 || yy2arr502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq502[2] {
					yy510 := &x.ListMeta
					yym511 := z.EncBinary()
					_ = yym511
					if false {
					} else if z.HasExtensions() && z.EncExt(yy510) {
					} else {
						z.EncFallback(yy510)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq502[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy512 := &x.ListMeta
					yym513 := z.EncBinary()
					_ = yym513
					if false {
					} else if z.HasExtensions() && z.EncExt(yy512) {
					} else {
						z.EncFallback(yy512)
					}
				}
			}
			if yyr502 || yy2arr502 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym515 := z.EncBinary()
					_ = yym515
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym516 := z.EncBinary()
					_ = yym516
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			}
			if yyr502 || yy2arr502 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym517 := z.DecBinary()
	_ = yym517
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct518 := r.ContainerType()
		if yyct518 == codecSelferValueTypeMap1234 {
			yyl518 := r.ReadMapStart()
			if yyl518 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl518, d)
			}
		} else if yyct518 == codecSelferValueTypeArray1234 {
			yyl518 := r.ReadArrayStart()
			if yyl518 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl518, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys519Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys519Slc
	var yyhl519 bool = l >= 0
	for yyj519 := 0; ; yyj519++ {
		if yyhl519 {
			if yyj519 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys519Slc = r.DecodeBytes(yys519Slc, true, true)
		yys519 := string(yys519Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys519 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv522 := &x.ListMeta
				yym523 := z.DecBinary()
				_ = yym523
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv522) {
				} else {
					z.DecFallback(yyv522, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv524 := &x.Items
				yym525 := z.DecBinary()
				_ = yym525
				if false {
				} else {
					h.decSliceDeployment((*[]Deployment)(yyv524), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys519)
		} // end switch yys519
	} // end for yyj519
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj526 int
	var yyb526 bool
	var yyhl526 bool = l >= 0
	yyj526++
	if yyhl526 {
		yyb526 = yyj526 > l
	} else {
		yyb526 = r.CheckBreak()
	}
	if yyb526 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj526++
	if yyhl526 {
		yyb526 = yyj526 > l
	} else {
		yyb526 = r.CheckBreak()
	}
	if yyb526 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj526++
	if yyhl526 {
		yyb526 = yyj526 > l
	} else {
		yyb526 = r.CheckBreak()
	}
	if yyb526 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv529 := &x.ListMeta
		yym530 := z.DecBinary()
		_ = yym530
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv529) {
		} else {
			z.DecFallback(yyv529, false)
		}
	}
	yyj526++
	if yyhl526 {
		yyb526 = yyj526 > l
	} else {
		yyb526 = r.CheckBreak()
	}
	if yyb526 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv531 := &x.Items
		yym532 := z.DecBinary()
		_ = yym532
		if false {
		} else {
			h.decSliceDeployment((*[]Deployment)(yyv531), d)
		}
	}
	for {
		yyj526++
		if yyhl526 {
			yyb526 = yyj526 > l
		} else {
			yyb526 = r.CheckBreak()
		}
		if yyb526 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj526-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym533 := z.EncBinary()
		_ = yym533
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep534 := !z.EncBinary()
			yy2arr534 := z.EncBasicHandle().StructToArray
			var yyq534 [2]bool
			_, _, _ = yysep534, yyq534, yy2arr534
			const yyr534 bool = false
			yyq534[0] = x.Selector != nil
			var yynn534 int
			if yyr534 || yy2arr534 {
				r.EncodeArrayStart(2)
			} else {
				yynn534 = 1
				for _, b := range yyq534 {
					if b {
						yynn534++
					}
				}
				r.EncodeMapStart(yynn534)
				yynn534 = 0
			}
			if yyr534 || yy2arr534 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq534[0] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym536 := z.EncBinary()
						_ = yym536
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq534[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym537 := z.EncBinary()
						_ = yym537
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr534 || yy2arr534 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy539 := &x.Template
				yy539.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy540 := &x.Template
				yy540.CodecEncodeSelf(e)
			}
			if yyr534 || yy2arr534 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym541 := z.DecBinary()
	_ = yym541
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct542 := r.ContainerType()
		if yyct542 == codecSelferValueTypeMap1234 {
			yyl542 := r.ReadMapStart()
			if yyl542 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl542, d)
			}
		} else if yyct542 == codecSelferValueTypeArray1234 {
			yyl542 := r.ReadArrayStart()
			if yyl542 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl542, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys543Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys543Slc
	var yyhl543 bool = l >= 0
	for yyj543 := 0; ; yyj543++ {
		if yyhl543 {
			if yyj543 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys543Slc = r.DecodeBytes(yys543Slc, true, true)
		yys543 := string(yys543Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys543 {
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym545 := z.DecBinary()
				_ = yym545
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv546 := &x.Template
				yyv546.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys543)
		} // end switch yys543
	} // end for yyj543
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj547 int
	var yyb547 bool
	var yyhl547 bool = l >= 0
	yyj547++
	if yyhl547 {
		yyb547 = yyj547 > l
	} else {
		yyb547 = r.CheckBreak()
	}
	if yyb547 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym549 := z.DecBinary()
		_ = yym549
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj547++
	if yyhl547 {
		yyb547 = yyj547 > l
	} else {
		yyb547 = r.CheckBreak()
	}
	if yyb547 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv550 := &x.Template
		yyv550.CodecDecodeSelf(d)
	}
	for {
		yyj547++
		if yyhl547 {
			yyb547 = yyj547 > l
		} else {
			yyb547 = r.CheckBreak()
		}
		if yyb547 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj547-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym551 := z.EncBinary()
		_ = yym551
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep552 := !z.EncBinary()
			yy2arr552 := z.EncBasicHandle().StructToArray
			var yyq552 [4]bool
			_, _, _ = yysep552, yyq552, yy2arr552
			const yyr552 bool = false
			var yynn552 int
			if yyr552 || yy2arr552 {
				r.EncodeArrayStart(4)
			} else {
				yynn552 = 4
				for _, b := range yyq552 {
					if b {
						yynn552++
					}
				}
				r.EncodeMapStart(yynn552)
				yynn552 = 0
			}
			if yyr552 || yy2arr552 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym554 := z.EncBinary()
				_ = yym554
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym555 := z.EncBinary()
				_ = yym555
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			}
			if yyr552 || yy2arr552 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym557 := z.EncBinary()
				_ = yym557
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberMisscheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym558 := z.EncBinary()
				_ = yym558
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			}
			if yyr552 || yy2arr552 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym560 := z.EncBinary()
				_ = yym560
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym561 := z.EncBinary()
				_ = yym561
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			}
			if yyr552 || yy2arr552 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym563 := z.EncBinary()
				_ = yym563
				if false {
				} else {
					r.EncodeInt(int64(x.NumberReady))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberReady"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym564 := z.EncBinary()
				_ = yym564
				if false {
				} else {
					r.EncodeInt(int64(x.NumberReady))
				}
			}
			if yyr552 || yy2arr552 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym565 := z.DecBinary()
	_ = yym565
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct566 := r.ContainerType()
		if yyct566 == codecSelferValueTypeMap1234 {
			yyl566 := r.ReadMapStart()
			if yyl566 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl566, d)
			}
		} else if yyct566 == codecSelferValueTypeArray1234 {
			yyl566 := r.ReadArrayStart()
			if yyl566 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl566, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys567Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys567Slc
	var yyhl567 bool = l >= 0
	for yyj567 := 0; ; yyj567++ {
		if yyhl567 {
			if yyj567 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys567Slc = r.DecodeBytes(yys567Slc, true, true)
		yys567 := string(yys567Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys567 {
		case "currentNumberScheduled":
			if r.TryDecodeAsNil() {
				x.CurrentNumberScheduled = 0
			} else {
				x.CurrentNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberMisscheduled":
			if r.TryDecodeAsNil() {
				x.NumberMisscheduled = 0
			} else {
				x.NumberMisscheduled = int32(r.DecodeInt(32))
			}
		case "desiredNumberScheduled":
			if r.TryDecodeAsNil() {
				x.DesiredNumberScheduled = 0
			} else {
				x.DesiredNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberReady":
			if r.TryDecodeAsNil() {
				x.NumberReady = 0
			} else {
				x.NumberReady = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys567)
		} // end switch yys567
	} // end for yyj567
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj572 int
	var yyb572 bool
	var yyhl572 bool = l >= 0
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentNumberScheduled = 0
	} else {
		x.CurrentNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberMisscheduled = 0
	} else {
		x.NumberMisscheduled = int32(r.DecodeInt(32))
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredNumberScheduled = 0
	} else {
		x.DesiredNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj572++
	if yyhl572 {
		yyb572 = yyj572 > l
	} else {
		yyb572 = r.CheckBreak()
	}
	if yyb572 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberReady = 0
	} else {
		x.NumberReady = int32(r.DecodeInt(32))
	}
	for {
		yyj572++
		if yyhl572 {
			yyb572 = yyj572 > l
		} else {
			yyb572 = r.CheckBreak()
		}
		if yyb572 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj572-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym577 := z.EncBinary()
		_ = yym577
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep578 := !z.EncBinary()
			yy2arr578 := z.EncBasicHandle().StructToArray
			var yyq578 [5]bool
			_, _, _ = yysep578, yyq578, yy2arr578
			const yyr578 bool = false
			yyq578[0] = x.Kind != ""
			yyq578[1] = x.APIVersion != ""
			yyq578[2] = true
			yyq578[3] = true
			yyq578[4] = true
			var yynn578 int
			if yyr578 || yy2arr578 {
				r.EncodeArrayStart(5)
			} else {
				yynn578 = 0
				for _, b := range yyq578 {
					if b {
						yynn578++
					}
				}
				r.EncodeMapStart(yynn578)
				yynn578 = 0
			}
			if yyr578 || yy2arr578 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq578[0] {
					yym580 := z.EncBinary()
					_ = yym580
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq578[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym581 := z.EncBinary()
					_ = yym581
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr578 || yy2arr578 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq578[1] {
					yym583 := z.EncBinary()
					_ = yym583
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq578[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym584 := z.EncBinary()
					_ = yym584
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr578 || yy2arr578 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq578[2] {
					yy586 := &x.ObjectMeta
					yy586.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq578[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy587 := &x.ObjectMeta
					yy587.CodecEncodeSelf(e)
				}
			}
			if yyr578 || yy2arr578 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq578[3] {
					yy589 := &x.Spec
					yy589.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq578[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy590 := &x.Spec
					yy590.CodecEncodeSelf(e)
				}
			}
			if yyr578 || yy2arr578 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq578[4] {
					yy592 := &x.Status
					yy592.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq578[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy593 := &x.Status
					yy593.CodecEncodeSelf(e)
				}
			}
			if yyr578 || yy2arr578 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym594 := z.DecBinary()
	_ = yym594
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct595 := r.ContainerType()
		if yyct595 == codecSelferValueTypeMap1234 {
			yyl595 := r.ReadMapStart()
			if yyl595 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl595, d)
			}
		} else if yyct595 == codecSelferValueTypeArray1234 {
			yyl595 := r.ReadArrayStart()
			if yyl595 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl595, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys596Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys596Slc
	var yyhl596 bool = l >= 0
	for yyj596 := 0; ; yyj596++ {
		if yyhl596 {
			if yyj596 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys596Slc = r.DecodeBytes(yys596Slc, true, true)
		yys596 := string(yys596Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys596 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv599 := &x.ObjectMeta
				yyv599.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DaemonSetSpec{}
			} else {
				yyv600 := &x.Spec
				yyv600.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DaemonSetStatus{}
			} else {
				yyv601 := &x.Status
				yyv601.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys596)
		} // end switch yys596
	} // end for yyj596
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj602 int
	var yyb602 bool
	var yyhl602 bool = l >= 0
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv605 := &x.ObjectMeta
		yyv605.CodecDecodeSelf(d)
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DaemonSetSpec{}
	} else {
		yyv606 := &x.Spec
		yyv606.CodecDecodeSelf(d)
	}
	yyj602++
	if yyhl602 {
		yyb602 = yyj602 > l
	} else {
		yyb602 = r.CheckBreak()
	}
	if yyb602 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DaemonSetStatus{}
	} else {
		yyv607 := &x.Status
		yyv607.CodecDecodeSelf(d)
	}
	for {
		yyj602++
		if yyhl602 {
			yyb602 = yyj602 > l
		} else {
			yyb602 = r.CheckBreak()
		}
		if yyb602 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj602-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym608 := z.EncBinary()
		_ = yym608
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep609 := !z.EncBinary()
			yy2arr609 := z.EncBasicHandle().StructToArray
			var yyq609 [4]bool
			_, _, _ = yysep609, yyq609, yy2arr609
			const yyr609 bool = false
			yyq609[0] = x.Kind != ""
			yyq609[1] = x.APIVersion != ""
			yyq609[2] = true
			var yynn609 int
			if yyr609 || yy2arr609 {
				r.EncodeArrayStart(4)
			} else {
				yynn609 = 1
				for _, b := range yyq609 {
					if b {
						yynn609++
					}
				}
				r.EncodeMapStart(yynn609)
				yynn609 = 0
			}
			if yyr609 || yy2arr609 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq609[0] {
					yym611 := z.EncBinary()
					_ = yym611
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq609[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym612 := z.EncBinary()
					_ = yym612
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr609 || yy2arr609 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq609[1] {
					yym614 := z.EncBinary()
					_ = yym614
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq609[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym615 := z.EncBinary()
					_ = yym615
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr609 || yy2arr609 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq609[2] {
					yy617 := &x.ListMeta
					yym618 := z.EncBinary()
					_ = yym618
					if false {
					} else if z.HasExtensions() && z.EncExt(yy617) {
					} else {
						z.EncFallback(yy617)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq609[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy619 := &x.ListMeta
					yym620 := z.EncBinary()
					_ = yym620
					if false {
					} else if z.HasExtensions() && z.EncExt(yy619) {
					} else {
						z.EncFallback(yy619)
					}
				}
			}
			if yyr609 || yy2arr609 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym622 := z.EncBinary()
					_ = yym622
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym623 := z.EncBinary()
					_ = yym623
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			}
			if yyr609 || yy2arr609 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym624 := z.DecBinary()
	_ = yym624
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct625 := r.ContainerType()
		if yyct625 == codecSelferValueTypeMap1234 {
			yyl625 := r.ReadMapStart()
			if yyl625 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl625, d)
			}
		} else if yyct625 == codecSelferValueTypeArray1234 {
			yyl625 := r.ReadArrayStart()
			if yyl625 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl625, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys626Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys626Slc
	var yyhl626 bool = l >= 0
	for yyj626 := 0; ; yyj626++ {
		if yyhl626 {
			if yyj626 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys626Slc = r.DecodeBytes(yys626Slc, true, true)
		yys626 := string(yys626Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys626 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv629 := &x.ListMeta
				yym630 := z.DecBinary()
				_ = yym630
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv629) {
				} else {
					z.DecFallback(yyv629, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv631 := &x.Items
				yym632 := z.DecBinary()
				_ = yym632
				if false {
				} else {
					h.decSliceDaemonSet((*[]DaemonSet)(yyv631), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys626)
		} // end switch yys626
	} // end for yyj626
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj633 int
	var yyb633 bool
	var yyhl633 bool = l >= 0
	yyj633++
	if yyhl633 {
		yyb633 = yyj633 > l
	} else {
		yyb633 = r.CheckBreak()
	}
	if yyb633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj633++
	if yyhl633 {
		yyb633 = yyj633 > l
	} else {
		yyb633 = r.CheckBreak()
	}
	if yyb633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj633++
	if yyhl633 {
		yyb633 = yyj633 > l
	} else {
		yyb633 = r.CheckBreak()
	}
	if yyb633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv636 := &x.ListMeta
		yym637 := z.DecBinary()
		_ = yym637
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv636) {
		} else {
			z.DecFallback(yyv636, false)
		}
	}
	yyj633++
	if yyhl633 {
		yyb633 = yyj633 > l
	} else {
		yyb633 = r.CheckBreak()
	}
	if yyb633 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv638 := &x.Items
		yym639 := z.DecBinary()
		_ = yym639
		if false {
		} else {
			h.decSliceDaemonSet((*[]DaemonSet)(yyv638), d)
		}
	}
	for {
		yyj633++
		if yyhl633 {
			yyb633 = yyj633 > l
		} else {
			yyb633 = r.CheckBreak()
		}
		if yyb633 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj633-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceDataList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym640 := z.EncBinary()
		_ = yym640
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep641 := !z.EncBinary()
			yy2arr641 := z.EncBasicHandle().StructToArray
			var yyq641 [4]bool
			_, _, _ = yysep641, yyq641, yy2arr641
			const yyr641 bool = false
			yyq641[0] = x.Kind != ""
			yyq641[1] = x.APIVersion != ""
			yyq641[2] = true
			var yynn641 int
			if yyr641 || yy2arr641 {
				r.EncodeArrayStart(4)
			} else {
				yynn641 = 1
				for _, b := range yyq641 {
					if b {
						yynn641++
					}
				}
				r.EncodeMapStart(yynn641)
				yynn641 = 0
			}
			if yyr641 || yy2arr641 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq641[0] {
					yym643 := z.EncBinary()
					_ = yym643
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq641[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym644 := z.EncBinary()
					_ = yym644
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr641 || yy2arr641 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq641[1] {
					yym646 := z.EncBinary()
					_ = yym646
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq641[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym647 := z.EncBinary()
					_ = yym647
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr641 || yy2arr641 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq641[2] {
					yy649 := &x.ListMeta
					yym650 := z.EncBinary()
					_ = yym650
					if false {
					} else if z.HasExtensions() && z.EncExt(yy649) {
					} else {
						z.EncFallback(yy649)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq641[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy651 := &x.ListMeta
					yym652 := z.EncBinary()
					_ = yym652
					if false {
					} else if z.HasExtensions() && z.EncExt(yy651) {
					} else {
						z.EncFallback(yy651)
					}
				}
			}
			if yyr641 || yy2arr641 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym654 := z.EncBinary()
					_ = yym654
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym655 := z.EncBinary()
					_ = yym655
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			}
			if yyr641 || yy2arr641 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceDataList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym656 := z.DecBinary()
	_ = yym656
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct657 := r.ContainerType()
		if yyct657 == codecSelferValueTypeMap1234 {
			yyl657 := r.ReadMapStart()
			if yyl657 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl657, d)
			}
		} else if yyct657 == codecSelferValueTypeArray1234 {
			yyl657 := r.ReadArrayStart()
			if yyl657 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl657, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys658Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys658Slc
	var yyhl658 bool = l >= 0
	for yyj658 := 0; ; yyj658++ {
		if yyhl658 {
			if yyj658 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys658Slc = r.DecodeBytes(yys658Slc, true, true)
		yys658 := string(yys658Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys658 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv661 := &x.ListMeta
				yym662 := z.DecBinary()
				_ = yym662
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv661) {
				} else {
					z.DecFallback(yyv661, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv663 := &x.Items
				yym664 := z.DecBinary()
				_ = yym664
				if false {
				} else {
					h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv663), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys658)
		} // end switch yys658
	} // end for yyj658
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj665 int
	var yyb665 bool
	var yyhl665 bool = l >= 0
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv668 := &x.ListMeta
		yym669 := z.DecBinary()
		_ = yym669
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv668) {
		} else {
			z.DecFallback(yyv668, false)
		}
	}
	yyj665++
	if yyhl665 {
		yyb665 = yyj665 > l
	} else {
		yyb665 = r.CheckBreak()
	}
	if yyb665 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv670 := &x.Items
		yym671 := z.DecBinary()
		_ = yym671
		if false {
		} else {
			h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv670), d)
		}
	}
	for {
		yyj665++
		if yyhl665 {
			yyb665 = yyj665 > l
		} else {
			yyb665 = r.CheckBreak()
		}
		if yyb665 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj665-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Ingress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym672 := z.EncBinary()
		_ = yym672
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep673 := !z.EncBinary()
			yy2arr673 := z.EncBasicHandle().StructToArray
			var yyq673 [5]bool
			_, _, _ = yysep673, yyq673, yy2arr673
			const yyr673 bool = false
			yyq673[0] = x.Kind != ""
			yyq673[1] = x.APIVersion != ""
			yyq673[2] = true
			yyq673[3] = true
			yyq673[4] = true
			var yynn673 int
			if yyr673 || yy2arr673 {
				r.EncodeArrayStart(5)
			} else {
				yynn673 = 0
				for _, b := range yyq673 {
					if b {
						yynn673++
					}
				}
				r.EncodeMapStart(yynn673)
				yynn673 = 0
			}
			if yyr673 || yy2arr673 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq673[0] {
					yym675 := z.EncBinary()
					_ = yym675
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq673[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym676 := z.EncBinary()
					_ = yym676
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr673 || yy2arr673 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq673[1] {
					yym678 := z.EncBinary()
					_ = yym678
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq673[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym679 := z.EncBinary()
					_ = yym679
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr673 || yy2arr673 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq673[2] {
					yy681 := &x.ObjectMeta
					yy681.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq673[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy682 := &x.ObjectMeta
					yy682.CodecEncodeSelf(e)
				}
			}
			if yyr673 || yy2arr673 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq673[3] {
					yy684 := &x.Spec
					yy684.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq673[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy685 := &x.Spec
					yy685.CodecEncodeSelf(e)
				}
			}
			if yyr673 || yy2arr673 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq673[4] {
					yy687 := &x.Status
					yy687.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq673[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy688 := &x.Status
					yy688.CodecEncodeSelf(e)
				}
			}
			if yyr673 || yy2arr673 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Ingress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym689 := z.DecBinary()
	_ = yym689
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct690 := r.ContainerType()
		if yyct690 == codecSelferValueTypeMap1234 {
			yyl690 := r.ReadMapStart()
			if yyl690 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl690, d)
			}
		} else if yyct690 == codecSelferValueTypeArray1234 {
			yyl690 := r.ReadArrayStart()
			if yyl690 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl690, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Ingress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys691Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys691Slc
	var yyhl691 bool = l >= 0
	for yyj691 := 0; ; yyj691++ {
		if yyhl691 {
			if yyj691 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys691Slc = r.DecodeBytes(yys691Slc, true, true)
		yys691 := string(yys691Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys691 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv694 := &x.ObjectMeta
				yyv694.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = IngressSpec{}
			} else {
				yyv695 := &x.Spec
				yyv695.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = IngressStatus{}
			} else {
				yyv696 := &x.Status
				yyv696.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys691)
		} // end switch yys691
	} // end for yyj691
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Ingress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj697 int
	var yyb697 bool
	var yyhl697 bool = l >= 0
	yyj697++
	if yyhl697 {
		yyb697 = yyj697 > l
	} else {
		yyb697 = r.CheckBreak()
	}
	if yyb697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj697++
	if yyhl697 {
		yyb697 = yyj697 > l
	} else {
		yyb697 = r.CheckBreak()
	}
	if yyb697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj697++
	if yyhl697 {
		yyb697 = yyj697 > l
	} else {
		yyb697 = r.CheckBreak()
	}
	if yyb697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv700 := &x.ObjectMeta
		yyv700.CodecDecodeSelf(d)
	}
	yyj697++
	if yyhl697 {
		yyb697 = yyj697 > l
	} else {
		yyb697 = r.CheckBreak()
	}
	if yyb697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = IngressSpec{}
	} else {
		yyv701 := &x.Spec
		yyv701.CodecDecodeSelf(d)
	}
	yyj697++
	if yyhl697 {
		yyb697 = yyj697 > l
	} else {
		yyb697 = r.CheckBreak()
	}
	if yyb697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = IngressStatus{}
	} else {
		yyv702 := &x.Status
		yyv702.CodecDecodeSelf(d)
	}
	for {
		yyj697++
		if yyhl697 {
			yyb697 = yyj697 > l
		} else {
			yyb697 = r.CheckBreak()
		}
		if yyb697 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj697-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym703 := z.EncBinary()
		_ = yym703
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep704 := !z.EncBinary()
			yy2arr704 := z.EncBasicHandle().StructToArray
			var yyq704 [4]bool
			_, _, _ = yysep704, yyq704, yy2arr704
			const yyr704 bool = false
			yyq704[0] = x.Kind != ""
			yyq704[1] = x.APIVersion != ""
			yyq704[2] = true
			var yynn704 int
			if yyr704 || yy2arr704 {
				r.EncodeArrayStart(4)
			} else {
				yynn704 = 1
				for _, b := range yyq704 {
					if b {
						yynn704++
					}
				}
				r.EncodeMapStart(yynn704)
				yynn704 = 0
			}
			if yyr704 || yy2arr704 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq704[0] {
					yym706 := z.EncBinary()
					_ = yym706
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq704[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym707 := z.EncBinary()
					_ = yym707
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr704 || yy2arr704 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq704[1] {
					yym709 := z.EncBinary()
					_ = yym709
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq704[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym710 := z.EncBinary()
					_ = yym710
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr704 || yy2arr704 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq704[2] {
					yy712 := &x.ListMeta
					yym713 := z.EncBinary()
					_ = yym713
					if false {
					} else if z.HasExtensions() && z.EncExt(yy712) {
					} else {
						z.EncFallback(yy712)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq704[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy714 := &x.ListMeta
					yym715 := z.EncBinary()
					_ = yym715
					if false {
					} else if z.HasExtensions() && z.EncExt(yy714) {
					} else {
						z.EncFallback(yy714)
					}
				}
			}
			if yyr704 || yy2arr704 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym717 := z.EncBinary()
					_ = yym717
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym718 := z.EncBinary()
					_ = yym718
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			}
			if yyr704 || yy2arr704 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym719 := z.DecBinary()
	_ = yym719
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct720 := r.ContainerType()
		if yyct720 == codecSelferValueTypeMap1234 {
			yyl720 := r.ReadMapStart()
			if yyl720 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl720, d)
			}
		} else if yyct720 == codecSelferValueTypeArray1234 {
			yyl720 := r.ReadArrayStart()
			if yyl720 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl720, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys721Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys721Slc
	var yyhl721 bool = l >= 0
	for yyj721 := 0; ; yyj721++ {
		if yyhl721 {
			if yyj721 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys721Slc = r.DecodeBytes(yys721Slc, true, true)
		yys721 := string(yys721Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys721 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv724 := &x.ListMeta
				yym725 := z.DecBinary()
				_ = yym725
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv724) {
				} else {
					z.DecFallback(yyv724, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv726 := &x.Items
				yym727 := z.DecBinary()
				_ = yym727
				if false {
				} else {
					h.decSliceIngress((*[]Ingress)(yyv726), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys721)
		} // end switch yys721
	} // end for yyj721
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj728 int
	var yyb728 bool
	var yyhl728 bool = l >= 0
	yyj728++
	if yyhl728 {
		yyb728 = yyj728 > l
	} else {
		yyb728 = r.CheckBreak()
	}
	if yyb728 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj728++
	if yyhl728 {
		yyb728 = yyj728 > l
	} else {
		yyb728 = r.CheckBreak()
	}
	if yyb728 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj728++
	if yyhl728 {
		yyb728 = yyj728 > l
	} else {
		yyb728 = r.CheckBreak()
	}
	if yyb728 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv731 := &x.ListMeta
		yym732 := z.DecBinary()
		_ = yym732
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv731) {
		} else {
			z.DecFallback(yyv731, false)
		}
	}
	yyj728++
	if yyhl728 {
		yyb728 = yyj728 > l
	} else {
		yyb728 = r.CheckBreak()
	}
	if yyb728 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv733 := &x.Items
		yym734 := z.DecBinary()
		_ = yym734
		if false {
		} else {
			h.decSliceIngress((*[]Ingress)(yyv733), d)
		}
	}
	for {
		yyj728++
		if yyhl728 {
			yyb728 = yyj728 > l
		} else {
			yyb728 = r.CheckBreak()
		}
		if yyb728 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj728-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym735 := z.EncBinary()
		_ = yym735
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep736 := !z.EncBinary()
			yy2arr736 := z.EncBasicHandle().StructToArray
			var yyq736 [3]bool
			_, _, _ = yysep736, yyq736, yy2arr736
			const yyr736 bool = false
			yyq736[0] = x.Backend != nil
			yyq736[1] = len(x.TLS) != 0
			yyq736[2] = len(x.Rules) != 0
			var yynn736 int
			if yyr736 || yy2arr736 {
				r.EncodeArrayStart(3)
			} else {
				yynn736 = 0
				for _, b := range yyq736 {
					if b {
						yynn736++
					}
				}
				r.EncodeMapStart(yynn736)
				yynn736 = 0
			}
			if yyr736 || yy2arr736 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq736[0] {
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq736[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("backend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				}
			}
			if yyr736 || yy2arr736 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq736[1] {
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym739 := z.EncBinary()
						_ = yym739
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq736[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym740 := z.EncBinary()
						_ = yym740
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				}
			}
			if yyr736 || yy2arr736 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq736[2] {
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym742 := z.EncBinary()
						_ = yym742
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq736[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rules"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym743 := z.EncBinary()
						_ = yym743
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				}
			}
			if yyr736 || yy2arr736 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym744 := z.DecBinary()
	_ = yym744
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct745 := r.ContainerType()
		if yyct745 == codecSelferValueTypeMap1234 {
			yyl745 := r.ReadMapStart()
			if yyl745 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl745, d)
			}
		} else if yyct745 == codecSelferValueTypeArray1234 {
			yyl745 := r.ReadArrayStart()
			if yyl745 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl745, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys746Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys746Slc
	var yyhl746 bool = l >= 0
	for yyj746 := 0; ; yyj746++ {
		if yyhl746 {
			if yyj746 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys746Slc = r.DecodeBytes(yys746Slc, true, true)
		yys746 := string(yys746Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys746 {
		case "backend":
			if r.TryDecodeAsNil() {
				if x.Backend != nil {
					x.Backend = nil
				}
			} else {
				if x.Backend == nil {
					x.Backend = new(IngressBackend)
				}
				x.Backend.CodecDecodeSelf(d)
			}
		case "tls":
			if r.TryDecodeAsNil() {
				x.TLS = nil
			} else {
				yyv748 := &x.TLS
				yym749 := z.DecBinary()
				_ = yym749
				if false {
				} else {
					h.decSliceIngressTLS((*[]IngressTLS)(yyv748), d)
				}
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv750 := &x.Rules
				yym751 := z.DecBinary()
				_ = yym751
				if false {
				} else {
					h.decSliceIngressRule((*[]IngressRule)(yyv750), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys746)
		} // end switch yys746
	} // end for yyj746
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj752 int
	var yyb752 bool
	var yyhl752 bool = l >= 0
	yyj752++
	if yyhl752 {
		yyb752 = yyj752 > l
	} else {
		yyb752 = r.CheckBreak()
	}
	if yyb752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Backend != nil {
			x.Backend = nil
		}
	} else {
		if x.Backend == nil {
			x.Backend = new(IngressBackend)
		}
		x.Backend.CodecDecodeSelf(d)
	}
	yyj752++
	if yyhl752 {
		yyb752 = yyj752 > l
	} else {
		yyb752 = r.CheckBreak()
	}
	if yyb752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLS = nil
	} else {
		yyv754 := &x.TLS
		yym755 := z.DecBinary()
		_ = yym755
		if false {
		} else {
			h.decSliceIngressTLS((*[]IngressTLS)(yyv754), d)
		}
	}
	yyj752++
	if yyhl752 {
		yyb752 = yyj752 > l
	} else {
		yyb752 = r.CheckBreak()
	}
	if yyb752 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv756 := &x.Rules
		yym757 := z.DecBinary()
		_ = yym757
		if false {
		} else {
			h.decSliceIngressRule((*[]IngressRule)(yyv756), d)
		}
	}
	for {
		yyj752++
		if yyhl752 {
			yyb752 = yyj752 > l
		} else {
			yyb752 = r.CheckBreak()
		}
		if yyb752 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj752-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressTLS) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym758 := z.EncBinary()
		_ = yym758
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep759 := !z.EncBinary()
			yy2arr759 := z.EncBasicHandle().StructToArray
			var yyq759 [2]bool
			_, _, _ = yysep759, yyq759, yy2arr759
			const yyr759 bool = false
			yyq759[0] = len(x.Hosts) != 0
			yyq759[1] = x.SecretName != ""
			var yynn759 int
			if yyr759 || yy2arr759 {
				r.EncodeArrayStart(2)
			} else {
				yynn759 = 0
				for _, b := range yyq759 {
					if b {
						yynn759++
					}
				}
				r.EncodeMapStart(yynn759)
				yynn759 = 0
			}
			if yyr759 || yy2arr759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq759[0] {
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym761 := z.EncBinary()
						_ = yym761
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq759[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hosts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym762 := z.EncBinary()
						_ = yym762
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				}
			}
			if yyr759 || yy2arr759 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq759[1] {
					yym764 := z.EncBinary()
					_ = yym764
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq759[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym765 := z.EncBinary()
					_ = yym765
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr759 || yy2arr759 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressTLS) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym766 := z.DecBinary()
	_ = yym766
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct767 := r.ContainerType()
		if yyct767 == codecSelferValueTypeMap1234 {
			yyl767 := r.ReadMapStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl767, d)
			}
		} else if yyct767 == codecSelferValueTypeArray1234 {
			yyl767 := r.ReadArrayStart()
			if yyl767 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl767, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressTLS) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys768Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys768Slc
	var yyhl768 bool = l >= 0
	for yyj768 := 0; ; yyj768++ {
		if yyhl768 {
			if yyj768 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys768Slc = r.DecodeBytes(yys768Slc, true, true)
		yys768 := string(yys768Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys768 {
		case "hosts":
			if r.TryDecodeAsNil() {
				x.Hosts = nil
			} else {
				yyv769 := &x.Hosts
				yym770 := z.DecBinary()
				_ = yym770
				if false {
				} else {
					z.F.DecSliceStringX(yyv769, false, d)
				}
			}
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys768)
		} // end switch yys768
	} // end for yyj768
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressTLS) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj772 int
	var yyb772 bool
	var yyhl772 bool = l >= 0
	yyj772++
	if yyhl772 {
		yyb772 = yyj772 > l
	} else {
		yyb772 = r.CheckBreak()
	}
	if yyb772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hosts = nil
	} else {
		yyv773 := &x.Hosts
		yym774 := z.DecBinary()
		_ = yym774
		if false {
		} else {
			z.F.DecSliceStringX(yyv773, false, d)
		}
	}
	yyj772++
	if yyhl772 {
		yyb772 = yyj772 > l
	} else {
		yyb772 = r.CheckBreak()
	}
	if yyb772 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	for {
		yyj772++
		if yyhl772 {
			yyb772 = yyj772 > l
		} else {
			yyb772 = r.CheckBreak()
		}
		if yyb772 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj772-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym776 := z.EncBinary()
		_ = yym776
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep777 := !z.EncBinary()
			yy2arr777 := z.EncBasicHandle().StructToArray
			var yyq777 [1]bool
			_, _, _ = yysep777, yyq777, yy2arr777
			const yyr777 bool = false
			yyq777[0] = true
			var yynn777 int
			if yyr777 || yy2arr777 {
				r.EncodeArrayStart(1)
			} else {
				yynn777 = 0
				for _, b := range yyq777 {
					if b {
						yynn777++
					}
				}
				r.EncodeMapStart(yynn777)
				yynn777 = 0
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq777[0] {
					yy779 := &x.LoadBalancer
					yy779.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq777[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy780 := &x.LoadBalancer
					yy780.CodecEncodeSelf(e)
				}
			}
			if yyr777 || yy2arr777 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym781 := z.DecBinary()
	_ = yym781
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct782 := r.ContainerType()
		if yyct782 == codecSelferValueTypeMap1234 {
			yyl782 := r.ReadMapStart()
			if yyl782 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl782, d)
			}
		} else if yyct782 == codecSelferValueTypeArray1234 {
			yyl782 := r.ReadArrayStart()
			if yyl782 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl782, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys783Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys783Slc
	var yyhl783 bool = l >= 0
	for yyj783 := 0; ; yyj783++ {
		if yyhl783 {
			if yyj783 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys783Slc = r.DecodeBytes(yys783Slc, true, true)
		yys783 := string(yys783Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys783 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = pkg2_api.LoadBalancerStatus{}
			} else {
				yyv784 := &x.LoadBalancer
				yyv784.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys783)
		} // end switch yys783
	} // end for yyj783
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj785 int
	var yyb785 bool
	var yyhl785 bool = l >= 0
	yyj785++
	if yyhl785 {
		yyb785 = yyj785 > l
	} else {
		yyb785 = r.CheckBreak()
	}
	if yyb785 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = pkg2_api.LoadBalancerStatus{}
	} else {
		yyv786 := &x.LoadBalancer
		yyv786.CodecDecodeSelf(d)
	}
	for {
		yyj785++
		if yyhl785 {
			yyb785 = yyj785 > l
		} else {
			yyb785 = r.CheckBreak()
		}
		if yyb785 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj785-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym787 := z.EncBinary()
		_ = yym787
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep788 := !z.EncBinary()
			yy2arr788 := z.EncBasicHandle().StructToArray
			var yyq788 [2]bool
			_, _, _ = yysep788, yyq788, yy2arr788
			const yyr788 bool = false
			yyq788[0] = x.Host != ""
			yyq788[1] = x.IngressRuleValue.HTTP != nil && x.HTTP != nil
			var yynn788 int
			if yyr788 || yy2arr788 {
				r.EncodeArrayStart(2)
			} else {
				yynn788 = 0
				for _, b := range yyq788 {
					if b {
						yynn788++
					}
				}
				r.EncodeMapStart(yynn788)
				yynn788 = 0
			}
			if yyr788 || yy2arr788 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq788[0] {
					yym790 := z.EncBinary()
					_ = yym790
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq788[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym791 := z.EncBinary()
					_ = yym791
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			var yyn792 bool
			if x.IngressRuleValue.HTTP == nil {
				yyn792 = true
				goto LABEL792
			}
		LABEL792:
			if yyr788 || yy2arr788 {
				if yyn792 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq788[1] {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq788[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn792 {
						r.EncodeNil()
					} else {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr788 || yy2arr788 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym793 := z.DecBinary()
	_ = yym793
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct794 := r.ContainerType()
		if yyct794 == codecSelferValueTypeMap1234 {
			yyl794 := r.ReadMapStart()
			if yyl794 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl794, d)
			}
		} else if yyct794 == codecSelferValueTypeArray1234 {
			yyl794 := r.ReadArrayStart()
			if yyl794 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl794, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys795Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys795Slc
	var yyhl795 bool = l >= 0
	for yyj795 := 0; ; yyj795++ {
		if yyhl795 {
			if yyj795 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys795Slc = r.DecodeBytes(yys795Slc, true, true)
		yys795 := string(yys795Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys795 {
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "http":
			if x.IngressRuleValue.HTTP == nil {
				x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
			}
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys795)
		} // end switch yys795
	} // end for yyj795
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj798 int
	var yyb798 bool
	var yyhl798 bool = l >= 0
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	if x.IngressRuleValue.HTTP == nil {
		x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
	}
	yyj798++
	if yyhl798 {
		yyb798 = yyj798 > l
	} else {
		yyb798 = r.CheckBreak()
	}
	if yyb798 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj798++
		if yyhl798 {
			yyb798 = yyj798 > l
		} else {
			yyb798 = r.CheckBreak()
		}
		if yyb798 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj798-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym801 := z.EncBinary()
		_ = yym801
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep802 := !z.EncBinary()
			yy2arr802 := z.EncBasicHandle().StructToArray
			var yyq802 [1]bool
			_, _, _ = yysep802, yyq802, yy2arr802
			const yyr802 bool = false
			yyq802[0] = x.HTTP != nil
			var yynn802 int
			if yyr802 || yy2arr802 {
				r.EncodeArrayStart(1)
			} else {
				yynn802 = 0
				for _, b := range yyq802 {
					if b {
						yynn802++
					}
				}
				r.EncodeMapStart(yynn802)
				yynn802 = 0
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq802[0] {
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq802[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				}
			}
			if yyr802 || yy2arr802 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym804 := z.DecBinary()
	_ = yym804
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct805 := r.ContainerType()
		if yyct805 == codecSelferValueTypeMap1234 {
			yyl805 := r.ReadMapStart()
			if yyl805 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl805, d)
			}
		} else if yyct805 == codecSelferValueTypeArray1234 {
			yyl805 := r.ReadArrayStart()
			if yyl805 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl805, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys806Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys806Slc
	var yyhl806 bool = l >= 0
	for yyj806 := 0; ; yyj806++ {
		if yyhl806 {
			if yyj806 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys806Slc = r.DecodeBytes(yys806Slc, true, true)
		yys806 := string(yys806Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys806 {
		case "http":
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys806)
		} // end switch yys806
	} // end for yyj806
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj808 int
	var yyb808 bool
	var yyhl808 bool = l >= 0
	yyj808++
	if yyhl808 {
		yyb808 = yyj808 > l
	} else {
		yyb808 = r.CheckBreak()
	}
	if yyb808 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj808++
		if yyhl808 {
			yyb808 = yyj808 > l
		} else {
			yyb808 = r.CheckBreak()
		}
		if yyb808 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj808-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym810 := z.EncBinary()
		_ = yym810
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep811 := !z.EncBinary()
			yy2arr811 := z.EncBasicHandle().StructToArray
			var yyq811 [1]bool
			_, _, _ = yysep811, yyq811, yy2arr811
			const yyr811 bool = false
			var yynn811 int
			if yyr811 || yy2arr811 {
				r.EncodeArrayStart(1)
			} else {
				yynn811 = 1
				for _, b := range yyq811 {
					if b {
						yynn811++
					}
				}
				r.EncodeMapStart(yynn811)
				yynn811 = 0
			}
			if yyr811 || yy2arr811 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym813 := z.EncBinary()
					_ = yym813
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("paths"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym814 := z.EncBinary()
					_ = yym814
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			}
			if yyr811 || yy2arr811 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym815 := z.DecBinary()
	_ = yym815
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct816 := r.ContainerType()
		if yyct816 == codecSelferValueTypeMap1234 {
			yyl816 := r.ReadMapStart()
			if yyl816 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl816, d)
			}
		} else if yyct816 == codecSelferValueTypeArray1234 {
			yyl816 := r.ReadArrayStart()
			if yyl816 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl816, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys817Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys817Slc
	var yyhl817 bool = l >= 0
	for yyj817 := 0; ; yyj817++ {
		if yyhl817 {
			if yyj817 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys817Slc = r.DecodeBytes(yys817Slc, true, true)
		yys817 := string(yys817Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys817 {
		case "paths":
			if r.TryDecodeAsNil() {
				x.Paths = nil
			} else {
				yyv818 := &x.Paths
				yym819 := z.DecBinary()
				_ = yym819
				if false {
				} else {
					h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv818), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys817)
		} // end switch yys817
	} // end for yyj817
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj820 int
	var yyb820 bool
	var yyhl820 bool = l >= 0
	yyj820++
	if yyhl820 {
		yyb820 = yyj820 > l
	} else {
		yyb820 = r.CheckBreak()
	}
	if yyb820 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paths = nil
	} else {
		yyv821 := &x.Paths
		yym822 := z.DecBinary()
		_ = yym822
		if false {
		} else {
			h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv821), d)
		}
	}
	for {
		yyj820++
		if yyhl820 {
			yyb820 = yyj820 > l
		} else {
			yyb820 = r.CheckBreak()
		}
		if yyb820 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj820-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym823 := z.EncBinary()
		_ = yym823
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep824 := !z.EncBinary()
			yy2arr824 := z.EncBasicHandle().StructToArray
			var yyq824 [2]bool
			_, _, _ = yysep824, yyq824, yy2arr824
			const yyr824 bool = false
			yyq824[0] = x.Path != ""
			var yynn824 int
			if yyr824 || yy2arr824 {
				r.EncodeArrayStart(2)
			} else {
				yynn824 = 1
				for _, b := range yyq824 {
					if b {
						yynn824++
					}
				}
				r.EncodeMapStart(yynn824)
				yynn824 = 0
			}
			if yyr824 || yy2arr824 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq824[0] {
					yym826 := z.EncBinary()
					_ = yym826
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq824[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym827 := z.EncBinary()
					_ = yym827
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr824 || yy2arr824 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy829 := &x.Backend
				yy829.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("backend"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy830 := &x.Backend
				yy830.CodecEncodeSelf(e)
			}
			if yyr824 || yy2arr824 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym831 := z.DecBinary()
	_ = yym831
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct832 := r.ContainerType()
		if yyct832 == codecSelferValueTypeMap1234 {
			yyl832 := r.ReadMapStart()
			if yyl832 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl832, d)
			}
		} else if yyct832 == codecSelferValueTypeArray1234 {
			yyl832 := r.ReadArrayStart()
			if yyl832 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl832, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys833Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys833Slc
	var yyhl833 bool = l >= 0
	for yyj833 := 0; ; yyj833++ {
		if yyhl833 {
			if yyj833 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys833Slc = r.DecodeBytes(yys833Slc, true, true)
		yys833 := string(yys833Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys833 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "backend":
			if r.TryDecodeAsNil() {
				x.Backend = IngressBackend{}
			} else {
				yyv835 := &x.Backend
				yyv835.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys833)
		} // end switch yys833
	} // end for yyj833
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj836 int
	var yyb836 bool
	var yyhl836 bool = l >= 0
	yyj836++
	if yyhl836 {
		yyb836 = yyj836 > l
	} else {
		yyb836 = r.CheckBreak()
	}
	if yyb836 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj836++
	if yyhl836 {
		yyb836 = yyj836 > l
	} else {
		yyb836 = r.CheckBreak()
	}
	if yyb836 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Backend = IngressBackend{}
	} else {
		yyv838 := &x.Backend
		yyv838.CodecDecodeSelf(d)
	}
	for {
		yyj836++
		if yyhl836 {
			yyb836 = yyj836 > l
		} else {
			yyb836 = r.CheckBreak()
		}
		if yyb836 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj836-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressBackend) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym839 := z.EncBinary()
		_ = yym839
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep840 := !z.EncBinary()
			yy2arr840 := z.EncBasicHandle().StructToArray
			var yyq840 [2]bool
			_, _, _ = yysep840, yyq840, yy2arr840
			const yyr840 bool = false
			var yynn840 int
			if yyr840 || yy2arr840 {
				r.EncodeArrayStart(2)
			} else {
				yynn840 = 2
				for _, b := range yyq840 {
					if b {
						yynn840++
					}
				}
				r.EncodeMapStart(yynn840)
				yynn840 = 0
			}
			if yyr840 || yy2arr840 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym842 := z.EncBinary()
				_ = yym842
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym843 := z.EncBinary()
				_ = yym843
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			}
			if yyr840 || yy2arr840 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy845 := &x.ServicePort
				yym846 := z.EncBinary()
				_ = yym846
				if false {
				} else if z.HasExtensions() && z.EncExt(yy845) {
				} else if !yym846 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy845)
				} else {
					z.EncFallback(yy845)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("servicePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy847 := &x.ServicePort
				yym848 := z.EncBinary()
				_ = yym848
				if false {
				} else if z.HasExtensions() && z.EncExt(yy847) {
				} else if !yym848 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy847)
				} else {
					z.EncFallback(yy847)
				}
			}
			if yyr840 || yy2arr840 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressBackend) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym849 := z.DecBinary()
	_ = yym849
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct850 := r.ContainerType()
		if yyct850 == codecSelferValueTypeMap1234 {
			yyl850 := r.ReadMapStart()
			if yyl850 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl850, d)
			}
		} else if yyct850 == codecSelferValueTypeArray1234 {
			yyl850 := r.ReadArrayStart()
			if yyl850 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl850, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressBackend) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys851Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys851Slc
	var yyhl851 bool = l >= 0
	for yyj851 := 0; ; yyj851++ {
		if yyhl851 {
			if yyj851 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys851Slc = r.DecodeBytes(yys851Slc, true, true)
		yys851 := string(yys851Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys851 {
		case "serviceName":
			if r.TryDecodeAsNil() {
				x.ServiceName = ""
			} else {
				x.ServiceName = string(r.DecodeString())
			}
		case "servicePort":
			if r.TryDecodeAsNil() {
				x.ServicePort = pkg5_intstr.IntOrString{}
			} else {
				yyv853 := &x.ServicePort
				yym854 := z.DecBinary()
				_ = yym854
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv853) {
				} else if !yym854 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv853)
				} else {
					z.DecFallback(yyv853, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys851)
		} // end switch yys851
	} // end for yyj851
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressBackend) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj855 int
	var yyb855 bool
	var yyhl855 bool = l >= 0
	yyj855++
	if yyhl855 {
		yyb855 = yyj855 > l
	} else {
		yyb855 = r.CheckBreak()
	}
	if yyb855 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceName = ""
	} else {
		x.ServiceName = string(r.DecodeString())
	}
	yyj855++
	if yyhl855 {
		yyb855 = yyj855 > l
	} else {
		yyb855 = r.CheckBreak()
	}
	if yyb855 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServicePort = pkg5_intstr.IntOrString{}
	} else {
		yyv857 := &x.ServicePort
		yym858 := z.DecBinary()
		_ = yym858
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv857) {
		} else if !yym858 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv857)
		} else {
			z.DecFallback(yyv857, false)
		}
	}
	for {
		yyj855++
		if yyhl855 {
			yyb855 = yyj855 > l
		} else {
			yyb855 = r.CheckBreak()
		}
		if yyb855 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj855-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym859 := z.EncBinary()
		_ = yym859
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep860 := !z.EncBinary()
			yy2arr860 := z.EncBasicHandle().StructToArray
			var yyq860 [5]bool
			_, _, _ = yysep860, yyq860, yy2arr860
			const yyr860 bool = false
			yyq860[0] = x.Kind != ""
			yyq860[1] = x.APIVersion != ""
			yyq860[2] = true
			yyq860[3] = true
			yyq860[4] = true
			var yynn860 int
			if yyr860 || yy2arr860 {
				r.EncodeArrayStart(5)
			} else {
				yynn860 = 0
				for _, b := range yyq860 {
					if b {
						yynn860++
					}
				}
				r.EncodeMapStart(yynn860)
				yynn860 = 0
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[0] {
					yym862 := z.EncBinary()
					_ = yym862
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq860[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym863 := z.EncBinary()
					_ = yym863
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[1] {
					yym865 := z.EncBinary()
					_ = yym865
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq860[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym866 := z.EncBinary()
					_ = yym866
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[2] {
					yy868 := &x.ObjectMeta
					yy868.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq860[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy869 := &x.ObjectMeta
					yy869.CodecEncodeSelf(e)
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[3] {
					yy871 := &x.Spec
					yy871.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq860[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy872 := &x.Spec
					yy872.CodecEncodeSelf(e)
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq860[4] {
					yy874 := &x.Status
					yy874.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq860[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy875 := &x.Status
					yy875.CodecEncodeSelf(e)
				}
			}
			if yyr860 || yy2arr860 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym876 := z.DecBinary()
	_ = yym876
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct877 := r.ContainerType()
		if yyct877 == codecSelferValueTypeMap1234 {
			yyl877 := r.ReadMapStart()
			if yyl877 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl877, d)
			}
		} else if yyct877 == codecSelferValueTypeArray1234 {
			yyl877 := r.ReadArrayStart()
			if yyl877 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl877, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys878Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys878Slc
	var yyhl878 bool = l >= 0
	for yyj878 := 0; ; yyj878++ {
		if yyhl878 {
			if yyj878 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys878Slc = r.DecodeBytes(yys878Slc, true, true)
		yys878 := string(yys878Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys878 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv881 := &x.ObjectMeta
				yyv881.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicaSetSpec{}
			} else {
				yyv882 := &x.Spec
				yyv882.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicaSetStatus{}
			} else {
				yyv883 := &x.Status
				yyv883.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys878)
		} // end switch yys878
	} // end for yyj878
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj884 int
	var yyb884 bool
	var yyhl884 bool = l >= 0
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv887 := &x.ObjectMeta
		yyv887.CodecDecodeSelf(d)
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicaSetSpec{}
	} else {
		yyv888 := &x.Spec
		yyv888.CodecDecodeSelf(d)
	}
	yyj884++
	if yyhl884 {
		yyb884 = yyj884 > l
	} else {
		yyb884 = r.CheckBreak()
	}
	if yyb884 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicaSetStatus{}
	} else {
		yyv889 := &x.Status
		yyv889.CodecDecodeSelf(d)
	}
	for {
		yyj884++
		if yyhl884 {
			yyb884 = yyj884 > l
		} else {
			yyb884 = r.CheckBreak()
		}
		if yyb884 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj884-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym890 := z.EncBinary()
		_ = yym890
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep891 := !z.EncBinary()
			yy2arr891 := z.EncBasicHandle().StructToArray
			var yyq891 [4]bool
			_, _, _ = yysep891, yyq891, yy2arr891
			const yyr891 bool = false
			yyq891[0] = x.Kind != ""
			yyq891[1] = x.APIVersion != ""
			yyq891[2] = true
			var yynn891 int
			if yyr891 || yy2arr891 {
				r.EncodeArrayStart(4)
			} else {
				yynn891 = 1
				for _, b := range yyq891 {
					if b {
						yynn891++
					}
				}
				r.EncodeMapStart(yynn891)
				yynn891 = 0
			}
			if yyr891 || yy2arr891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq891[0] {
					yym893 := z.EncBinary()
					_ = yym893
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq891[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym894 := z.EncBinary()
					_ = yym894
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr891 || yy2arr891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq891[1] {
					yym896 := z.EncBinary()
					_ = yym896
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq891[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym897 := z.EncBinary()
					_ = yym897
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr891 || yy2arr891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq891[2] {
					yy899 := &x.ListMeta
					yym900 := z.EncBinary()
					_ = yym900
					if false {
					} else if z.HasExtensions() && z.EncExt(yy899) {
					} else {
						z.EncFallback(yy899)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq891[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy901 := &x.ListMeta
					yym902 := z.EncBinary()
					_ = yym902
					if false {
					} else if z.HasExtensions() && z.EncExt(yy901) {
					} else {
						z.EncFallback(yy901)
					}
				}
			}
			if yyr891 || yy2arr891 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym904 := z.EncBinary()
					_ = yym904
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym905 := z.EncBinary()
					_ = yym905
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			}
			if yyr891 || yy2arr891 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym906 := z.DecBinary()
	_ = yym906
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct907 := r.ContainerType()
		if yyct907 == codecSelferValueTypeMap1234 {
			yyl907 := r.ReadMapStart()
			if yyl907 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl907, d)
			}
		} else if yyct907 == codecSelferValueTypeArray1234 {
			yyl907 := r.ReadArrayStart()
			if yyl907 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl907, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys908Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys908Slc
	var yyhl908 bool = l >= 0
	for yyj908 := 0; ; yyj908++ {
		if yyhl908 {
			if yyj908 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys908Slc = r.DecodeBytes(yys908Slc, true, true)
		yys908 := string(yys908Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys908 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv911 := &x.ListMeta
				yym912 := z.DecBinary()
				_ = yym912
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv911) {
				} else {
					z.DecFallback(yyv911, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv913 := &x.Items
				yym914 := z.DecBinary()
				_ = yym914
				if false {
				} else {
					h.decSliceReplicaSet((*[]ReplicaSet)(yyv913), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys908)
		} // end switch yys908
	} // end for yyj908
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj915 int
	var yyb915 bool
	var yyhl915 bool = l >= 0
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv918 := &x.ListMeta
		yym919 := z.DecBinary()
		_ = yym919
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv918) {
		} else {
			z.DecFallback(yyv918, false)
		}
	}
	yyj915++
	if yyhl915 {
		yyb915 = yyj915 > l
	} else {
		yyb915 = r.CheckBreak()
	}
	if yyb915 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv920 := &x.Items
		yym921 := z.DecBinary()
		_ = yym921
		if false {
		} else {
			h.decSliceReplicaSet((*[]ReplicaSet)(yyv920), d)
		}
	}
	for {
		yyj915++
		if yyhl915 {
			yyb915 = yyj915 > l
		} else {
			yyb915 = r.CheckBreak()
		}
		if yyb915 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj915-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym922 := z.EncBinary()
		_ = yym922
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep923 := !z.EncBinary()
			yy2arr923 := z.EncBasicHandle().StructToArray
			var yyq923 [4]bool
			_, _, _ = yysep923, yyq923, yy2arr923
			const yyr923 bool = false
			yyq923[1] = x.MinReadySeconds != 0
			yyq923[2] = x.Selector != nil
			yyq923[3] = true
			var yynn923 int
			if yyr923 || yy2arr923 {
				r.EncodeArrayStart(4)
			} else {
				yynn923 = 1
				for _, b := range yyq923 {
					if b {
						yynn923++
					}
				}
				r.EncodeMapStart(yynn923)
				yynn923 = 0
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym925 := z.EncBinary()
				_ = yym925
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym926 := z.EncBinary()
				_ = yym926
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq923[1] {
					yym928 := z.EncBinary()
					_ = yym928
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq923[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym929 := z.EncBinary()
					_ = yym929
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq923[2] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym931 := z.EncBinary()
						_ = yym931
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq923[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym932 := z.EncBinary()
						_ = yym932
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq923[3] {
					yy934 := &x.Template
					yy934.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq923[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy935 := &x.Template
					yy935.CodecEncodeSelf(e)
				}
			}
			if yyr923 || yy2arr923 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym936 := z.DecBinary()
	_ = yym936
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct937 := r.ContainerType()
		if yyct937 == codecSelferValueTypeMap1234 {
			yyl937 := r.ReadMapStart()
			if yyl937 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl937, d)
			}
		} else if yyct937 == codecSelferValueTypeArray1234 {
			yyl937 := r.ReadArrayStart()
			if yyl937 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl937, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys938Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys938Slc
	var yyhl938 bool = l >= 0
	for yyj938 := 0; ; yyj938++ {
		if yyhl938 {
			if yyj938 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys938Slc = r.DecodeBytes(yys938Slc, true, true)
		yys938 := string(yys938Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys938 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym942 := z.DecBinary()
				_ = yym942
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_api.PodTemplateSpec{}
			} else {
				yyv943 := &x.Template
				yyv943.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys938)
		} // end switch yys938
	} // end for yyj938
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj944 int
	var yyb944 bool
	var yyhl944 bool = l >= 0
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym948 := z.DecBinary()
		_ = yym948
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj944++
	if yyhl944 {
		yyb944 = yyj944 > l
	} else {
		yyb944 = r.CheckBreak()
	}
	if yyb944 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_api.PodTemplateSpec{}
	} else {
		yyv949 := &x.Template
		yyv949.CodecDecodeSelf(d)
	}
	for {
		yyj944++
		if yyhl944 {
			yyb944 = yyj944 > l
		} else {
			yyb944 = r.CheckBreak()
		}
		if yyb944 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj944-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym950 := z.EncBinary()
		_ = yym950
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep951 := !z.EncBinary()
			yy2arr951 := z.EncBasicHandle().StructToArray
			var yyq951 [6]bool
			_, _, _ = yysep951, yyq951, yy2arr951
			const yyr951 bool = false
			yyq951[1] = x.FullyLabeledReplicas != 0
			yyq951[2] = x.ReadyReplicas != 0
			yyq951[3] = x.AvailableReplicas != 0
			yyq951[4] = x.ObservedGeneration != 0
			yyq951[5] = len(x.Conditions) != 0
			var yynn951 int
			if yyr951 || yy2arr951 {
				r.EncodeArrayStart(6)
			} else {
				yynn951 = 1
				for _, b := range yyq951 {
					if b {
						yynn951++
					}
				}
				r.EncodeMapStart(yynn951)
				yynn951 = 0
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym953 := z.EncBinary()
				_ = yym953
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym954 := z.EncBinary()
				_ = yym954
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[1] {
					yym956 := z.EncBinary()
					_ = yym956
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq951[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym957 := z.EncBinary()
					_ = yym957
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[2] {
					yym959 := z.EncBinary()
					_ = yym959
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq951[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym960 := z.EncBinary()
					_ = yym960
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[3] {
					yym962 := z.EncBinary()
					_ = yym962
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq951[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym963 := z.EncBinary()
					_ = yym963
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[4] {
					yym965 := z.EncBinary()
					_ = yym965
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq951[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym966 := z.EncBinary()
					_ = yym966
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq951[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym968 := z.EncBinary()
						_ = yym968
						if false {
						} else {
							h.encSliceReplicaSetCondition(([]ReplicaSetCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq951[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym969 := z.EncBinary()
						_ = yym969
						if false {
						} else {
							h.encSliceReplicaSetCondition(([]ReplicaSetCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr951 || yy2arr951 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym970 := z.DecBinary()
	_ = yym970
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct971 := r.ContainerType()
		if yyct971 == codecSelferValueTypeMap1234 {
			yyl971 := r.ReadMapStart()
			if yyl971 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl971, d)
			}
		} else if yyct971 == codecSelferValueTypeArray1234 {
			yyl971 := r.ReadArrayStart()
			if yyl971 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl971, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys972Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys972Slc
	var yyhl972 bool = l >= 0
	for yyj972 := 0; ; yyj972++ {
		if yyhl972 {
			if yyj972 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys972Slc = r.DecodeBytes(yys972Slc, true, true)
		yys972 := string(yys972Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys972 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv978 := &x.Conditions
				yym979 := z.DecBinary()
				_ = yym979
				if false {
				} else {
					h.decSliceReplicaSetCondition((*[]ReplicaSetCondition)(yyv978), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys972)
		} // end switch yys972
	} // end for yyj972
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj980 int
	var yyb980 bool
	var yyhl980 bool = l >= 0
	yyj980++
	if yyhl980 {
		yyb980 = yyj980 > l
	} else {
		yyb980 = r.CheckBreak()
	}
	if yyb980 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj980++
	if yyhl980 {
		yyb980 = yyj980 > l
	} else {
		yyb980 = r.CheckBreak()
	}
	if yyb980 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj980++
	if yyhl980 {
		yyb980 = yyj980 > l
	} else {
		yyb980 = r.CheckBreak()
	}
	if yyb980 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj980++
	if yyhl980 {
		yyb980 = yyj980 > l
	} else {
		yyb980 = r.CheckBreak()
	}
	if yyb980 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj980++
	if yyhl980 {
		yyb980 = yyj980 > l
	} else {
		yyb980 = r.CheckBreak()
	}
	if yyb980 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj980++
	if yyhl980 {
		yyb980 = yyj980 > l
	} else {
		yyb980 = r.CheckBreak()
	}
	if yyb980 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv986 := &x.Conditions
		yym987 := z.DecBinary()
		_ = yym987
		if false {
		} else {
			h.decSliceReplicaSetCondition((*[]ReplicaSetCondition)(yyv986), d)
		}
	}
	for {
		yyj980++
		if yyhl980 {
			yyb980 = yyj980 > l
		} else {
			yyb980 = r.CheckBreak()
		}
		if yyb980 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj980-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ReplicaSetConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym988 := z.EncBinary()
	_ = yym988
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ReplicaSetConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym989 := z.DecBinary()
	_ = yym989
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ReplicaSetCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym990 := z.EncBinary()
		_ = yym990
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep991 := !z.EncBinary()
			yy2arr991 := z.EncBasicHandle().StructToArray
			var yyq991 [5]bool
			_, _, _ = yysep991, yyq991, yy2arr991
			const yyr991 bool = false
			yyq991[2] = true
			yyq991[3] = x.Reason != ""
			yyq991[4] = x.Message != ""
			var yynn991 int
			if yyr991 || yy2arr991 {
				r.EncodeArrayStart(5)
			} else {
				yynn991 = 2
				for _, b := range yyq991 {
					if b {
						yynn991++
					}
				}
				r.EncodeMapStart(yynn991)
				yynn991 = 0
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym994 := z.EncBinary()
				_ = yym994
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym995 := z.EncBinary()
				_ = yym995
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq991[2] {
					yy997 := &x.LastTransitionTime
					yym998 := z.EncBinary()
					_ = yym998
					if false {
					} else if z.HasExtensions() && z.EncExt(yy997) {
					} else if yym998 {
						z.EncBinaryMarshal(yy997)
					} else if !yym998 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy997)
					} else {
						z.EncFallback(yy997)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq991[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy999 := &x.LastTransitionTime
					yym1000 := z.EncBinary()
					_ = yym1000
					if false {
					} else if z.HasExtensions() && z.EncExt(yy999) {
					} else if yym1000 {
						z.EncBinaryMarshal(yy999)
					} else if !yym1000 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy999)
					} else {
						z.EncFallback(yy999)
					}
				}
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq991[3] {
					yym1002 := z.EncBinary()
					_ = yym1002
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq991[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1003 := z.EncBinary()
					_ = yym1003
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq991[4] {
					yym1005 := z.EncBinary()
					_ = yym1005
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq991[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1006 := z.EncBinary()
					_ = yym1006
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr991 || yy2arr991 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1007 := z.DecBinary()
	_ = yym1007
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1008 := r.ContainerType()
		if yyct1008 == codecSelferValueTypeMap1234 {
			yyl1008 := r.ReadMapStart()
			if yyl1008 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1008, d)
			}
		} else if yyct1008 == codecSelferValueTypeArray1234 {
			yyl1008 := r.ReadArrayStart()
			if yyl1008 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1008, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1009Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1009Slc
	var yyhl1009 bool = l >= 0
	for yyj1009 := 0; ; yyj1009++ {
		if yyhl1009 {
			if yyj1009 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1009Slc = r.DecodeBytes(yys1009Slc, true, true)
		yys1009 := string(yys1009Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1009 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ReplicaSetConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_api.ConditionStatus(r.DecodeString())
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv1012 := &x.LastTransitionTime
				yym1013 := z.DecBinary()
				_ = yym1013
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1012) {
				} else if yym1013 {
					z.DecBinaryUnmarshal(yyv1012)
				} else if !yym1013 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1012)
				} else {
					z.DecFallback(yyv1012, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1009)
		} // end switch yys1009
	} // end for yyj1009
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1016 int
	var yyb1016 bool
	var yyhl1016 bool = l >= 0
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ReplicaSetConditionType(r.DecodeString())
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_api.ConditionStatus(r.DecodeString())
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv1019 := &x.LastTransitionTime
		yym1020 := z.DecBinary()
		_ = yym1020
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1019) {
		} else if yym1020 {
			z.DecBinaryUnmarshal(yyv1019)
		} else if !yym1020 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1019)
		} else {
			z.DecFallback(yyv1019, false)
		}
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1016++
	if yyhl1016 {
		yyb1016 = yyj1016 > l
	} else {
		yyb1016 = r.CheckBreak()
	}
	if yyb1016 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1016++
		if yyhl1016 {
			yyb1016 = yyj1016 > l
		} else {
			yyb1016 = r.CheckBreak()
		}
		if yyb1016 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1016-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1023 := z.EncBinary()
		_ = yym1023
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1024 := !z.EncBinary()
			yy2arr1024 := z.EncBasicHandle().StructToArray
			var yyq1024 [4]bool
			_, _, _ = yysep1024, yyq1024, yy2arr1024
			const yyr1024 bool = false
			yyq1024[0] = x.Kind != ""
			yyq1024[1] = x.APIVersion != ""
			yyq1024[2] = true
			yyq1024[3] = true
			var yynn1024 int
			if yyr1024 || yy2arr1024 {
				r.EncodeArrayStart(4)
			} else {
				yynn1024 = 0
				for _, b := range yyq1024 {
					if b {
						yynn1024++
					}
				}
				r.EncodeMapStart(yynn1024)
				yynn1024 = 0
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[0] {
					yym1026 := z.EncBinary()
					_ = yym1026
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1024[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1027 := z.EncBinary()
					_ = yym1027
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[1] {
					yym1029 := z.EncBinary()
					_ = yym1029
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1024[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1030 := z.EncBinary()
					_ = yym1030
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[2] {
					yy1032 := &x.ObjectMeta
					yy1032.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1024[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1033 := &x.ObjectMeta
					yy1033.CodecEncodeSelf(e)
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1024[3] {
					yy1035 := &x.Spec
					yy1035.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1024[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1036 := &x.Spec
					yy1036.CodecEncodeSelf(e)
				}
			}
			if yyr1024 || yy2arr1024 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1037 := z.DecBinary()
	_ = yym1037
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1038 := r.ContainerType()
		if yyct1038 == codecSelferValueTypeMap1234 {
			yyl1038 := r.ReadMapStart()
			if yyl1038 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1038, d)
			}
		} else if yyct1038 == codecSelferValueTypeArray1234 {
			yyl1038 := r.ReadArrayStart()
			if yyl1038 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1038, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1039Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1039Slc
	var yyhl1039 bool = l >= 0
	for yyj1039 := 0; ; yyj1039++ {
		if yyhl1039 {
			if yyj1039 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1039Slc = r.DecodeBytes(yys1039Slc, true, true)
		yys1039 := string(yys1039Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1039 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv1042 := &x.ObjectMeta
				yyv1042.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSecurityPolicySpec{}
			} else {
				yyv1043 := &x.Spec
				yyv1043.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1039)
		} // end switch yys1039
	} // end for yyj1039
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1044 int
	var yyb1044 bool
	var yyhl1044 bool = l >= 0
	yyj1044++
	if yyhl1044 {
		yyb1044 = yyj1044 > l
	} else {
		yyb1044 = r.CheckBreak()
	}
	if yyb1044 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1044++
	if yyhl1044 {
		yyb1044 = yyj1044 > l
	} else {
		yyb1044 = r.CheckBreak()
	}
	if yyb1044 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1044++
	if yyhl1044 {
		yyb1044 = yyj1044 > l
	} else {
		yyb1044 = r.CheckBreak()
	}
	if yyb1044 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv1047 := &x.ObjectMeta
		yyv1047.CodecDecodeSelf(d)
	}
	yyj1044++
	if yyhl1044 {
		yyb1044 = yyj1044 > l
	} else {
		yyb1044 = r.CheckBreak()
	}
	if yyb1044 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSecurityPolicySpec{}
	} else {
		yyv1048 := &x.Spec
		yyv1048.CodecDecodeSelf(d)
	}
	for {
		yyj1044++
		if yyhl1044 {
			yyb1044 = yyj1044 > l
		} else {
			yyb1044 = r.CheckBreak()
		}
		if yyb1044 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1044-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1049 := z.EncBinary()
		_ = yym1049
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1050 := !z.EncBinary()
			yy2arr1050 := z.EncBasicHandle().StructToArray
			var yyq1050 [14]bool
			_, _, _ = yysep1050, yyq1050, yy2arr1050
			const yyr1050 bool = false
			yyq1050[0] = x.Privileged != false
			yyq1050[1] = len(x.DefaultAddCapabilities) != 0
			yyq1050[2] = len(x.RequiredDropCapabilities) != 0
			yyq1050[3] = len(x.AllowedCapabilities) != 0
			yyq1050[4] = len(x.Volumes) != 0
			yyq1050[5] = x.HostNetwork != false
			yyq1050[6] = len(x.HostPorts) != 0
			yyq1050[7] = x.HostPID != false
			yyq1050[8] = x.HostIPC != false
			yyq1050[13] = x.ReadOnlyRootFilesystem != false
			var yynn1050 int
			if yyr1050 || yy2arr1050 {
				r.EncodeArrayStart(14)
			} else {
				yynn1050 = 4
				for _, b := range yyq1050 {
					if b {
						yynn1050++
					}
				}
				r.EncodeMapStart(yynn1050)
				yynn1050 = 0
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[0] {
					yym1052 := z.EncBinary()
					_ = yym1052
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1050[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("privileged"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1053 := z.EncBinary()
					_ = yym1053
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[1] {
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1055 := z.EncBinary()
						_ = yym1055
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultAddCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1056 := z.EncBinary()
						_ = yym1056
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[2] {
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1058 := z.EncBinary()
						_ = yym1058
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDropCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1059 := z.EncBinary()
						_ = yym1059
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[3] {
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1061 := z.EncBinary()
						_ = yym1061
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.AllowedCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allowedCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1062 := z.EncBinary()
						_ = yym1062
						if false {
						} else {
							h.encSliceapi_Capability(([]pkg2_api.Capability)(x.AllowedCapabilities), e)
						}
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[4] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1064 := z.EncBinary()
						_ = yym1064
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1065 := z.EncBinary()
						_ = yym1065
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[5] {
					yym1067 := z.EncBinary()
					_ = yym1067
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1050[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1068 := z.EncBinary()
					_ = yym1068
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[6] {
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym1070 := z.EncBinary()
						_ = yym1070
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPorts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym1071 := z.EncBinary()
						_ = yym1071
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[7] {
					yym1073 := z.EncBinary()
					_ = yym1073
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1050[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1074 := z.EncBinary()
					_ = yym1074
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[8] {
					yym1076 := z.EncBinary()
					_ = yym1076
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1050[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1077 := z.EncBinary()
					_ = yym1077
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1079 := &x.SELinux
				yy1079.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seLinux"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1080 := &x.SELinux
				yy1080.CodecEncodeSelf(e)
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1082 := &x.RunAsUser
				yy1082.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1083 := &x.RunAsUser
				yy1083.CodecEncodeSelf(e)
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1085 := &x.SupplementalGroups
				yy1085.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1086 := &x.SupplementalGroups
				yy1086.CodecEncodeSelf(e)
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1088 := &x.FSGroup
				yy1088.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1089 := &x.FSGroup
				yy1089.CodecEncodeSelf(e)
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[13] {
					yym1091 := z.EncBinary()
					_ = yym1091
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1050[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnlyRootFilesystem"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1092 := z.EncBinary()
					_ = yym1092
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1093 := z.DecBinary()
	_ = yym1093
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1094 := r.ContainerType()
		if yyct1094 == codecSelferValueTypeMap1234 {
			yyl1094 := r.ReadMapStart()
			if yyl1094 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1094, d)
			}
		} else if yyct1094 == codecSelferValueTypeArray1234 {
			yyl1094 := r.ReadArrayStart()
			if yyl1094 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1094, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1095Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1095Slc
	var yyhl1095 bool = l >= 0
	for yyj1095 := 0; ; yyj1095++ {
		if yyhl1095 {
			if yyj1095 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1095Slc = r.DecodeBytes(yys1095Slc, true, true)
		yys1095 := string(yys1095Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1095 {
		case "privileged":
			if r.TryDecodeAsNil() {
				x.Privileged = false
			} else {
				x.Privileged = bool(r.DecodeBool())
			}
		case "defaultAddCapabilities":
			if r.TryDecodeAsNil() {
				x.DefaultAddCapabilities = nil
			} else {
				yyv1097 := &x.DefaultAddCapabilities
				yym1098 := z.DecBinary()
				_ = yym1098
				if false {
				} else {
					h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1097), d)
				}
			}
		case "requiredDropCapabilities":
			if r.TryDecodeAsNil() {
				x.RequiredDropCapabilities = nil
			} else {
				yyv1099 := &x.RequiredDropCapabilities
				yym1100 := z.DecBinary()
				_ = yym1100
				if false {
				} else {
					h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1099), d)
				}
			}
		case "allowedCapabilities":
			if r.TryDecodeAsNil() {
				x.AllowedCapabilities = nil
			} else {
				yyv1101 := &x.AllowedCapabilities
				yym1102 := z.DecBinary()
				_ = yym1102
				if false {
				} else {
					h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1101), d)
				}
			}
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv1103 := &x.Volumes
				yym1104 := z.DecBinary()
				_ = yym1104
				if false {
				} else {
					h.decSliceFSType((*[]FSType)(yyv1103), d)
				}
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPorts":
			if r.TryDecodeAsNil() {
				x.HostPorts = nil
			} else {
				yyv1106 := &x.HostPorts
				yym1107 := z.DecBinary()
				_ = yym1107
				if false {
				} else {
					h.decSliceHostPortRange((*[]HostPortRange)(yyv1106), d)
				}
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinux":
			if r.TryDecodeAsNil() {
				x.SELinux = SELinuxStrategyOptions{}
			} else {
				yyv1110 := &x.SELinux
				yyv1110.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				x.RunAsUser = RunAsUserStrategyOptions{}
			} else {
				yyv1111 := &x.RunAsUser
				yyv1111.CodecDecodeSelf(d)
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
			} else {
				yyv1112 := &x.SupplementalGroups
				yyv1112.CodecDecodeSelf(d)
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				x.FSGroup = FSGroupStrategyOptions{}
			} else {
				yyv1113 := &x.FSGroup
				yyv1113.CodecDecodeSelf(d)
			}
		case "readOnlyRootFilesystem":
			if r.TryDecodeAsNil() {
				x.ReadOnlyRootFilesystem = false
			} else {
				x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1095)
		} // end switch yys1095
	} // end for yyj1095
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1115 int
	var yyb1115 bool
	var yyhl1115 bool = l >= 0
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Privileged = false
	} else {
		x.Privileged = bool(r.DecodeBool())
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DefaultAddCapabilities = nil
	} else {
		yyv1117 := &x.DefaultAddCapabilities
		yym1118 := z.DecBinary()
		_ = yym1118
		if false {
		} else {
			h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1117), d)
		}
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDropCapabilities = nil
	} else {
		yyv1119 := &x.RequiredDropCapabilities
		yym1120 := z.DecBinary()
		_ = yym1120
		if false {
		} else {
			h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1119), d)
		}
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedCapabilities = nil
	} else {
		yyv1121 := &x.AllowedCapabilities
		yym1122 := z.DecBinary()
		_ = yym1122
		if false {
		} else {
			h.decSliceapi_Capability((*[]pkg2_api.Capability)(yyv1121), d)
		}
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv1123 := &x.Volumes
		yym1124 := z.DecBinary()
		_ = yym1124
		if false {
		} else {
			h.decSliceFSType((*[]FSType)(yyv1123), d)
		}
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPorts = nil
	} else {
		yyv1126 := &x.HostPorts
		yym1127 := z.DecBinary()
		_ = yym1127
		if false {
		} else {
			h.decSliceHostPortRange((*[]HostPortRange)(yyv1126), d)
		}
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SELinux = SELinuxStrategyOptions{}
	} else {
		yyv1130 := &x.SELinux
		yyv1130.CodecDecodeSelf(d)
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RunAsUser = RunAsUserStrategyOptions{}
	} else {
		yyv1131 := &x.RunAsUser
		yyv1131.CodecDecodeSelf(d)
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
	} else {
		yyv1132 := &x.SupplementalGroups
		yyv1132.CodecDecodeSelf(d)
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSGroup = FSGroupStrategyOptions{}
	} else {
		yyv1133 := &x.FSGroup
		yyv1133.CodecDecodeSelf(d)
	}
	yyj1115++
	if yyhl1115 {
		yyb1115 = yyj1115 > l
	} else {
		yyb1115 = r.CheckBreak()
	}
	if yyb1115 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyRootFilesystem = false
	} else {
		x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
	}
	for {
		yyj1115++
		if yyhl1115 {
			yyb1115 = yyj1115 > l
		} else {
			yyb1115 = r.CheckBreak()
		}
		if yyb1115 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1115-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HostPortRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1135 := z.EncBinary()
		_ = yym1135
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1136 := !z.EncBinary()
			yy2arr1136 := z.EncBasicHandle().StructToArray
			var yyq1136 [2]bool
			_, _, _ = yysep1136, yyq1136, yy2arr1136
			const yyr1136 bool = false
			var yynn1136 int
			if yyr1136 || yy2arr1136 {
				r.EncodeArrayStart(2)
			} else {
				yynn1136 = 2
				for _, b := range yyq1136 {
					if b {
						yynn1136++
					}
				}
				r.EncodeMapStart(yynn1136)
				yynn1136 = 0
			}
			if yyr1136 || yy2arr1136 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1138 := z.EncBinary()
				_ = yym1138
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1139 := z.EncBinary()
				_ = yym1139
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1136 || yy2arr1136 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1141 := z.EncBinary()
				_ = yym1141
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1142 := z.EncBinary()
				_ = yym1142
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1136 || yy2arr1136 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPortRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1143 := z.DecBinary()
	_ = yym1143
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1144 := r.ContainerType()
		if yyct1144 == codecSelferValueTypeMap1234 {
			yyl1144 := r.ReadMapStart()
			if yyl1144 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1144, d)
			}
		} else if yyct1144 == codecSelferValueTypeArray1234 {
			yyl1144 := r.ReadArrayStart()
			if yyl1144 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1144, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPortRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1145Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1145Slc
	var yyhl1145 bool = l >= 0
	for yyj1145 := 0; ; yyj1145++ {
		if yyhl1145 {
			if yyj1145 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1145Slc = r.DecodeBytes(yys1145Slc, true, true)
		yys1145 := string(yys1145Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1145 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int(r.DecodeInt(codecSelferBitsize1234))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int(r.DecodeInt(codecSelferBitsize1234))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1145)
		} // end switch yys1145
	} // end for yyj1145
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPortRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1148 int
	var yyb1148 bool
	var yyhl1148 bool = l >= 0
	yyj1148++
	if yyhl1148 {
		yyb1148 = yyj1148 > l
	} else {
		yyb1148 = r.CheckBreak()
	}
	if yyb1148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int(r.DecodeInt(codecSelferBitsize1234))
	}
	yyj1148++
	if yyhl1148 {
		yyb1148 = yyj1148 > l
	} else {
		yyb1148 = r.CheckBreak()
	}
	if yyb1148 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int(r.DecodeInt(codecSelferBitsize1234))
	}
	for {
		yyj1148++
		if yyhl1148 {
			yyb1148 = yyj1148 > l
		} else {
			yyb1148 = r.CheckBreak()
		}
		if yyb1148 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1148-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1151 := z.EncBinary()
	_ = yym1151
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1152 := z.DecBinary()
	_ = yym1152
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *SELinuxStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1153 := z.EncBinary()
		_ = yym1153
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1154 := !z.EncBinary()
			yy2arr1154 := z.EncBasicHandle().StructToArray
			var yyq1154 [2]bool
			_, _, _ = yysep1154, yyq1154, yy2arr1154
			const yyr1154 bool = false
			yyq1154[1] = x.SELinuxOptions != nil
			var yynn1154 int
			if yyr1154 || yy2arr1154 {
				r.EncodeArrayStart(2)
			} else {
				yynn1154 = 1
				for _, b := range yyq1154 {
					if b {
						yynn1154++
					}
				}
				r.EncodeMapStart(yynn1154)
				yynn1154 = 0
			}
			if yyr1154 || yy2arr1154 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1154 || yy2arr1154 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1154[1] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1154[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1154 || yy2arr1154 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SELinuxStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1157 := z.DecBinary()
	_ = yym1157
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1158 := r.ContainerType()
		if yyct1158 == codecSelferValueTypeMap1234 {
			yyl1158 := r.ReadMapStart()
			if yyl1158 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1158, d)
			}
		} else if yyct1158 == codecSelferValueTypeArray1234 {
			yyl1158 := r.ReadArrayStart()
			if yyl1158 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1158, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1159Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1159Slc
	var yyhl1159 bool = l >= 0
	for yyj1159 := 0; ; yyj1159++ {
		if yyhl1159 {
			if yyj1159 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1159Slc = r.DecodeBytes(yys1159Slc, true, true)
		yys1159 := string(yys1159Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1159 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SELinuxStrategy(r.DecodeString())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(pkg2_api.SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1159)
		} // end switch yys1159
	} // end for yyj1159
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1162 int
	var yyb1162 bool
	var yyhl1162 bool = l >= 0
	yyj1162++
	if yyhl1162 {
		yyb1162 = yyj1162 > l
	} else {
		yyb1162 = r.CheckBreak()
	}
	if yyb1162 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SELinuxStrategy(r.DecodeString())
	}
	yyj1162++
	if yyhl1162 {
		yyb1162 = yyj1162 > l
	} else {
		yyb1162 = r.CheckBreak()
	}
	if yyb1162 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(pkg2_api.SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	for {
		yyj1162++
		if yyhl1162 {
			yyb1162 = yyj1162 > l
		} else {
			yyb1162 = r.CheckBreak()
		}
		if yyb1162 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1162-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SELinuxStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1165 := z.EncBinary()
	_ = yym1165
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SELinuxStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1166 := z.DecBinary()
	_ = yym1166
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RunAsUserStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1167 := z.EncBinary()
		_ = yym1167
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1168 := !z.EncBinary()
			yy2arr1168 := z.EncBasicHandle().StructToArray
			var yyq1168 [2]bool
			_, _, _ = yysep1168, yyq1168, yy2arr1168
			const yyr1168 bool = false
			yyq1168[1] = len(x.Ranges) != 0
			var yynn1168 int
			if yyr1168 || yy2arr1168 {
				r.EncodeArrayStart(2)
			} else {
				yynn1168 = 1
				for _, b := range yyq1168 {
					if b {
						yynn1168++
					}
				}
				r.EncodeMapStart(yynn1168)
				yynn1168 = 0
			}
			if yyr1168 || yy2arr1168 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1168 || yy2arr1168 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1168[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1171 := z.EncBinary()
						_ = yym1171
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1168[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1172 := z.EncBinary()
						_ = yym1172
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1168 || yy2arr1168 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RunAsUserStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1173 := z.DecBinary()
	_ = yym1173
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1174 := r.ContainerType()
		if yyct1174 == codecSelferValueTypeMap1234 {
			yyl1174 := r.ReadMapStart()
			if yyl1174 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1174, d)
			}
		} else if yyct1174 == codecSelferValueTypeArray1234 {
			yyl1174 := r.ReadArrayStart()
			if yyl1174 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1174, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1175Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1175Slc
	var yyhl1175 bool = l >= 0
	for yyj1175 := 0; ; yyj1175++ {
		if yyhl1175 {
			if yyj1175 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1175Slc = r.DecodeBytes(yys1175Slc, true, true)
		yys1175 := string(yys1175Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1175 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = RunAsUserStrategy(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1177 := &x.Ranges
				yym1178 := z.DecBinary()
				_ = yym1178
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1177), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1175)
		} // end switch yys1175
	} // end for yyj1175
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1179 int
	var yyb1179 bool
	var yyhl1179 bool = l >= 0
	yyj1179++
	if yyhl1179 {
		yyb1179 = yyj1179 > l
	} else {
		yyb1179 = r.CheckBreak()
	}
	if yyb1179 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = RunAsUserStrategy(r.DecodeString())
	}
	yyj1179++
	if yyhl1179 {
		yyb1179 = yyj1179 > l
	} else {
		yyb1179 = r.CheckBreak()
	}
	if yyb1179 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1181 := &x.Ranges
		yym1182 := z.DecBinary()
		_ = yym1182
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1181), d)
		}
	}
	for {
		yyj1179++
		if yyhl1179 {
			yyb1179 = yyj1179 > l
		} else {
			yyb1179 = r.CheckBreak()
		}
		if yyb1179 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1179-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IDRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1183 := z.EncBinary()
		_ = yym1183
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1184 := !z.EncBinary()
			yy2arr1184 := z.EncBasicHandle().StructToArray
			var yyq1184 [2]bool
			_, _, _ = yysep1184, yyq1184, yy2arr1184
			const yyr1184 bool = false
			var yynn1184 int
			if yyr1184 || yy2arr1184 {
				r.EncodeArrayStart(2)
			} else {
				yynn1184 = 2
				for _, b := range yyq1184 {
					if b {
						yynn1184++
					}
				}
				r.EncodeMapStart(yynn1184)
				yynn1184 = 0
			}
			if yyr1184 || yy2arr1184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1186 := z.EncBinary()
				_ = yym1186
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1187 := z.EncBinary()
				_ = yym1187
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1184 || yy2arr1184 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1189 := z.EncBinary()
				_ = yym1189
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1190 := z.EncBinary()
				_ = yym1190
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1184 || yy2arr1184 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IDRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1191 := z.DecBinary()
	_ = yym1191
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1192 := r.ContainerType()
		if yyct1192 == codecSelferValueTypeMap1234 {
			yyl1192 := r.ReadMapStart()
			if yyl1192 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1192, d)
			}
		} else if yyct1192 == codecSelferValueTypeArray1234 {
			yyl1192 := r.ReadArrayStart()
			if yyl1192 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1192, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IDRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1193Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1193Slc
	var yyhl1193 bool = l >= 0
	for yyj1193 := 0; ; yyj1193++ {
		if yyhl1193 {
			if yyj1193 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1193Slc = r.DecodeBytes(yys1193Slc, true, true)
		yys1193 := string(yys1193Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1193 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int64(r.DecodeInt(64))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1193)
		} // end switch yys1193
	} // end for yyj1193
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IDRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1196 int
	var yyb1196 bool
	var yyhl1196 bool = l >= 0
	yyj1196++
	if yyhl1196 {
		yyb1196 = yyj1196 > l
	} else {
		yyb1196 = r.CheckBreak()
	}
	if yyb1196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int64(r.DecodeInt(64))
	}
	yyj1196++
	if yyhl1196 {
		yyb1196 = yyj1196 > l
	} else {
		yyb1196 = r.CheckBreak()
	}
	if yyb1196 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int64(r.DecodeInt(64))
	}
	for {
		yyj1196++
		if yyhl1196 {
			yyb1196 = yyj1196 > l
		} else {
			yyb1196 = r.CheckBreak()
		}
		if yyb1196 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1196-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RunAsUserStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1199 := z.EncBinary()
	_ = yym1199
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RunAsUserStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1200 := z.DecBinary()
	_ = yym1200
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *FSGroupStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1201 := z.EncBinary()
		_ = yym1201
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1202 := !z.EncBinary()
			yy2arr1202 := z.EncBasicHandle().StructToArray
			var yyq1202 [2]bool
			_, _, _ = yysep1202, yyq1202, yy2arr1202
			const yyr1202 bool = false
			yyq1202[0] = x.Rule != ""
			yyq1202[1] = len(x.Ranges) != 0
			var yynn1202 int
			if yyr1202 || yy2arr1202 {
				r.EncodeArrayStart(2)
			} else {
				yynn1202 = 0
				for _, b := range yyq1202 {
					if b {
						yynn1202++
					}
				}
				r.EncodeMapStart(yynn1202)
				yynn1202 = 0
			}
			if yyr1202 || yy2arr1202 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1202[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1202[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1202 || yy2arr1202 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1202[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1205 := z.EncBinary()
						_ = yym1205
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1202[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1206 := z.EncBinary()
						_ = yym1206
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1202 || yy2arr1202 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FSGroupStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1207 := z.DecBinary()
	_ = yym1207
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1208 := r.ContainerType()
		if yyct1208 == codecSelferValueTypeMap1234 {
			yyl1208 := r.ReadMapStart()
			if yyl1208 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1208, d)
			}
		} else if yyct1208 == codecSelferValueTypeArray1234 {
			yyl1208 := r.ReadArrayStart()
			if yyl1208 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1208, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1209Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1209Slc
	var yyhl1209 bool = l >= 0
	for yyj1209 := 0; ; yyj1209++ {
		if yyhl1209 {
			if yyj1209 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1209Slc = r.DecodeBytes(yys1209Slc, true, true)
		yys1209 := string(yys1209Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1209 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = FSGroupStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1211 := &x.Ranges
				yym1212 := z.DecBinary()
				_ = yym1212
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1211), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1209)
		} // end switch yys1209
	} // end for yyj1209
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1213 int
	var yyb1213 bool
	var yyhl1213 bool = l >= 0
	yyj1213++
	if yyhl1213 {
		yyb1213 = yyj1213 > l
	} else {
		yyb1213 = r.CheckBreak()
	}
	if yyb1213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = FSGroupStrategyType(r.DecodeString())
	}
	yyj1213++
	if yyhl1213 {
		yyb1213 = yyj1213 > l
	} else {
		yyb1213 = r.CheckBreak()
	}
	if yyb1213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1215 := &x.Ranges
		yym1216 := z.DecBinary()
		_ = yym1216
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1215), d)
		}
	}
	for {
		yyj1213++
		if yyhl1213 {
			yyb1213 = yyj1213 > l
		} else {
			yyb1213 = r.CheckBreak()
		}
		if yyb1213 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1213-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSGroupStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1217 := z.EncBinary()
	_ = yym1217
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSGroupStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1218 := z.DecBinary()
	_ = yym1218
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1219 := z.EncBinary()
		_ = yym1219
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1220 := !z.EncBinary()
			yy2arr1220 := z.EncBasicHandle().StructToArray
			var yyq1220 [2]bool
			_, _, _ = yysep1220, yyq1220, yy2arr1220
			const yyr1220 bool = false
			yyq1220[0] = x.Rule != ""
			yyq1220[1] = len(x.Ranges) != 0
			var yynn1220 int
			if yyr1220 || yy2arr1220 {
				r.EncodeArrayStart(2)
			} else {
				yynn1220 = 0
				for _, b := range yyq1220 {
					if b {
						yynn1220++
					}
				}
				r.EncodeMapStart(yynn1220)
				yynn1220 = 0
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1220[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1220[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1220[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1223 := z.EncBinary()
						_ = yym1223
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1220[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1224 := z.EncBinary()
						_ = yym1224
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1220 || yy2arr1220 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1225 := z.DecBinary()
	_ = yym1225
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1226 := r.ContainerType()
		if yyct1226 == codecSelferValueTypeMap1234 {
			yyl1226 := r.ReadMapStart()
			if yyl1226 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1226, d)
			}
		} else if yyct1226 == codecSelferValueTypeArray1234 {
			yyl1226 := r.ReadArrayStart()
			if yyl1226 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1226, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1227Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1227Slc
	var yyhl1227 bool = l >= 0
	for yyj1227 := 0; ; yyj1227++ {
		if yyhl1227 {
			if yyj1227 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1227Slc = r.DecodeBytes(yys1227Slc, true, true)
		yys1227 := string(yys1227Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1227 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1229 := &x.Ranges
				yym1230 := z.DecBinary()
				_ = yym1230
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1229), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1227)
		} // end switch yys1227
	} // end for yyj1227
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1231 int
	var yyb1231 bool
	var yyhl1231 bool = l >= 0
	yyj1231++
	if yyhl1231 {
		yyb1231 = yyj1231 > l
	} else {
		yyb1231 = r.CheckBreak()
	}
	if yyb1231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
	}
	yyj1231++
	if yyhl1231 {
		yyb1231 = yyj1231 > l
	} else {
		yyb1231 = r.CheckBreak()
	}
	if yyb1231 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1233 := &x.Ranges
		yym1234 := z.DecBinary()
		_ = yym1234
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1233), d)
		}
	}
	for {
		yyj1231++
		if yyhl1231 {
			yyb1231 = yyj1231 > l
		} else {
			yyb1231 = r.CheckBreak()
		}
		if yyb1231 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1231-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SupplementalGroupsStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1235 := z.EncBinary()
	_ = yym1235
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SupplementalGroupsStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1236 := z.DecBinary()
	_ = yym1236
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSecurityPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1237 := z.EncBinary()
		_ = yym1237
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1238 := !z.EncBinary()
			yy2arr1238 := z.EncBasicHandle().StructToArray
			var yyq1238 [4]bool
			_, _, _ = yysep1238, yyq1238, yy2arr1238
			const yyr1238 bool = false
			yyq1238[0] = x.Kind != ""
			yyq1238[1] = x.APIVersion != ""
			yyq1238[2] = true
			var yynn1238 int
			if yyr1238 || yy2arr1238 {
				r.EncodeArrayStart(4)
			} else {
				yynn1238 = 1
				for _, b := range yyq1238 {
					if b {
						yynn1238++
					}
				}
				r.EncodeMapStart(yynn1238)
				yynn1238 = 0
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1238[0] {
					yym1240 := z.EncBinary()
					_ = yym1240
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1238[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1241 := z.EncBinary()
					_ = yym1241
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1238[1] {
					yym1243 := z.EncBinary()
					_ = yym1243
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1238[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1244 := z.EncBinary()
					_ = yym1244
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1238[2] {
					yy1246 := &x.ListMeta
					yym1247 := z.EncBinary()
					_ = yym1247
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1246) {
					} else {
						z.EncFallback(yy1246)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1238[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1248 := &x.ListMeta
					yym1249 := z.EncBinary()
					_ = yym1249
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1248) {
					} else {
						z.EncFallback(yy1248)
					}
				}
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1251 := z.EncBinary()
					_ = yym1251
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1252 := z.EncBinary()
					_ = yym1252
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			}
			if yyr1238 || yy2arr1238 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1253 := z.DecBinary()
	_ = yym1253
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1254 := r.ContainerType()
		if yyct1254 == codecSelferValueTypeMap1234 {
			yyl1254 := r.ReadMapStart()
			if yyl1254 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1254, d)
			}
		} else if yyct1254 == codecSelferValueTypeArray1234 {
			yyl1254 := r.ReadArrayStart()
			if yyl1254 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1254, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1255Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1255Slc
	var yyhl1255 bool = l >= 0
	for yyj1255 := 0; ; yyj1255++ {
		if yyhl1255 {
			if yyj1255 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1255Slc = r.DecodeBytes(yys1255Slc, true, true)
		yys1255 := string(yys1255Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1255 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1258 := &x.ListMeta
				yym1259 := z.DecBinary()
				_ = yym1259
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1258) {
				} else {
					z.DecFallback(yyv1258, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1260 := &x.Items
				yym1261 := z.DecBinary()
				_ = yym1261
				if false {
				} else {
					h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1260), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1255)
		} // end switch yys1255
	} // end for yyj1255
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1262 int
	var yyb1262 bool
	var yyhl1262 bool = l >= 0
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1265 := &x.ListMeta
		yym1266 := z.DecBinary()
		_ = yym1266
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1265) {
		} else {
			z.DecFallback(yyv1265, false)
		}
	}
	yyj1262++
	if yyhl1262 {
		yyb1262 = yyj1262 > l
	} else {
		yyb1262 = r.CheckBreak()
	}
	if yyb1262 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1267 := &x.Items
		yym1268 := z.DecBinary()
		_ = yym1268
		if false {
		} else {
			h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1267), d)
		}
	}
	for {
		yyj1262++
		if yyhl1262 {
			yyb1262 = yyj1262 > l
		} else {
			yyb1262 = r.CheckBreak()
		}
		if yyb1262 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1262-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1269 := z.EncBinary()
		_ = yym1269
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1270 := !z.EncBinary()
			yy2arr1270 := z.EncBasicHandle().StructToArray
			var yyq1270 [4]bool
			_, _, _ = yysep1270, yyq1270, yy2arr1270
			const yyr1270 bool = false
			yyq1270[0] = x.Kind != ""
			yyq1270[1] = x.APIVersion != ""
			yyq1270[2] = true
			yyq1270[3] = true
			var yynn1270 int
			if yyr1270 || yy2arr1270 {
				r.EncodeArrayStart(4)
			} else {
				yynn1270 = 0
				for _, b := range yyq1270 {
					if b {
						yynn1270++
					}
				}
				r.EncodeMapStart(yynn1270)
				yynn1270 = 0
			}
			if yyr1270 || yy2arr1270 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1270[0] {
					yym1272 := z.EncBinary()
					_ = yym1272
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1270[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1273 := z.EncBinary()
					_ = yym1273
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1270 || yy2arr1270 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1270[1] {
					yym1275 := z.EncBinary()
					_ = yym1275
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1270[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1276 := z.EncBinary()
					_ = yym1276
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1270 || yy2arr1270 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1270[2] {
					yy1278 := &x.ObjectMeta
					yy1278.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1270[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1279 := &x.ObjectMeta
					yy1279.CodecEncodeSelf(e)
				}
			}
			if yyr1270 || yy2arr1270 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1270[3] {
					yy1281 := &x.Spec
					yy1281.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1270[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1282 := &x.Spec
					yy1282.CodecEncodeSelf(e)
				}
			}
			if yyr1270 || yy2arr1270 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1283 := z.DecBinary()
	_ = yym1283
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1284 := r.ContainerType()
		if yyct1284 == codecSelferValueTypeMap1234 {
			yyl1284 := r.ReadMapStart()
			if yyl1284 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1284, d)
			}
		} else if yyct1284 == codecSelferValueTypeArray1234 {
			yyl1284 := r.ReadArrayStart()
			if yyl1284 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1284, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1285Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1285Slc
	var yyhl1285 bool = l >= 0
	for yyj1285 := 0; ; yyj1285++ {
		if yyhl1285 {
			if yyj1285 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1285Slc = r.DecodeBytes(yys1285Slc, true, true)
		yys1285 := string(yys1285Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1285 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_api.ObjectMeta{}
			} else {
				yyv1288 := &x.ObjectMeta
				yyv1288.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NetworkPolicySpec{}
			} else {
				yyv1289 := &x.Spec
				yyv1289.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1285)
		} // end switch yys1285
	} // end for yyj1285
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1290 int
	var yyb1290 bool
	var yyhl1290 bool = l >= 0
	yyj1290++
	if yyhl1290 {
		yyb1290 = yyj1290 > l
	} else {
		yyb1290 = r.CheckBreak()
	}
	if yyb1290 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1290++
	if yyhl1290 {
		yyb1290 = yyj1290 > l
	} else {
		yyb1290 = r.CheckBreak()
	}
	if yyb1290 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1290++
	if yyhl1290 {
		yyb1290 = yyj1290 > l
	} else {
		yyb1290 = r.CheckBreak()
	}
	if yyb1290 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_api.ObjectMeta{}
	} else {
		yyv1293 := &x.ObjectMeta
		yyv1293.CodecDecodeSelf(d)
	}
	yyj1290++
	if yyhl1290 {
		yyb1290 = yyj1290 > l
	} else {
		yyb1290 = r.CheckBreak()
	}
	if yyb1290 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NetworkPolicySpec{}
	} else {
		yyv1294 := &x.Spec
		yyv1294.CodecDecodeSelf(d)
	}
	for {
		yyj1290++
		if yyhl1290 {
			yyb1290 = yyj1290 > l
		} else {
			yyb1290 = r.CheckBreak()
		}
		if yyb1290 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1290-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1295 := z.EncBinary()
		_ = yym1295
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1296 := !z.EncBinary()
			yy2arr1296 := z.EncBasicHandle().StructToArray
			var yyq1296 [2]bool
			_, _, _ = yysep1296, yyq1296, yy2arr1296
			const yyr1296 bool = false
			yyq1296[1] = len(x.Ingress) != 0
			var yynn1296 int
			if yyr1296 || yy2arr1296 {
				r.EncodeArrayStart(2)
			} else {
				yynn1296 = 1
				for _, b := range yyq1296 {
					if b {
						yynn1296++
					}
				}
				r.EncodeMapStart(yynn1296)
				yynn1296 = 0
			}
			if yyr1296 || yy2arr1296 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1298 := &x.PodSelector
				yym1299 := z.EncBinary()
				_ = yym1299
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1298) {
				} else {
					z.EncFallback(yy1298)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1300 := &x.PodSelector
				yym1301 := z.EncBinary()
				_ = yym1301
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1300) {
				} else {
					z.EncFallback(yy1300)
				}
			}
			if yyr1296 || yy2arr1296 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1296[1] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1303 := z.EncBinary()
						_ = yym1303
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1296[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1304 := z.EncBinary()
						_ = yym1304
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				}
			}
			if yyr1296 || yy2arr1296 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1305 := z.DecBinary()
	_ = yym1305
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1306 := r.ContainerType()
		if yyct1306 == codecSelferValueTypeMap1234 {
			yyl1306 := r.ReadMapStart()
			if yyl1306 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1306, d)
			}
		} else if yyct1306 == codecSelferValueTypeArray1234 {
			yyl1306 := r.ReadArrayStart()
			if yyl1306 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1306, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1307Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1307Slc
	var yyhl1307 bool = l >= 0
	for yyj1307 := 0; ; yyj1307++ {
		if yyhl1307 {
			if yyj1307 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1307Slc = r.DecodeBytes(yys1307Slc, true, true)
		yys1307 := string(yys1307Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1307 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				x.PodSelector = pkg1_unversioned.LabelSelector{}
			} else {
				yyv1308 := &x.PodSelector
				yym1309 := z.DecBinary()
				_ = yym1309
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1308) {
				} else {
					z.DecFallback(yyv1308, false)
				}
			}
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv1310 := &x.Ingress
				yym1311 := z.DecBinary()
				_ = yym1311
				if false {
				} else {
					h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1310), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1307)
		} // end switch yys1307
	} // end for yyj1307
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1312 int
	var yyb1312 bool
	var yyhl1312 bool = l >= 0
	yyj1312++
	if yyhl1312 {
		yyb1312 = yyj1312 > l
	} else {
		yyb1312 = r.CheckBreak()
	}
	if yyb1312 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSelector = pkg1_unversioned.LabelSelector{}
	} else {
		yyv1313 := &x.PodSelector
		yym1314 := z.DecBinary()
		_ = yym1314
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1313) {
		} else {
			z.DecFallback(yyv1313, false)
		}
	}
	yyj1312++
	if yyhl1312 {
		yyb1312 = yyj1312 > l
	} else {
		yyb1312 = r.CheckBreak()
	}
	if yyb1312 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv1315 := &x.Ingress
		yym1316 := z.DecBinary()
		_ = yym1316
		if false {
		} else {
			h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1315), d)
		}
	}
	for {
		yyj1312++
		if yyhl1312 {
			yyb1312 = yyj1312 > l
		} else {
			yyb1312 = r.CheckBreak()
		}
		if yyb1312 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1312-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyIngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1317 := z.EncBinary()
		_ = yym1317
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1318 := !z.EncBinary()
			yy2arr1318 := z.EncBasicHandle().StructToArray
			var yyq1318 [2]bool
			_, _, _ = yysep1318, yyq1318, yy2arr1318
			const yyr1318 bool = false
			yyq1318[0] = len(x.Ports) != 0
			yyq1318[1] = len(x.From) != 0
			var yynn1318 int
			if yyr1318 || yy2arr1318 {
				r.EncodeArrayStart(2)
			} else {
				yynn1318 = 0
				for _, b := range yyq1318 {
					if b {
						yynn1318++
					}
				}
				r.EncodeMapStart(yynn1318)
				yynn1318 = 0
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1318[0] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1320 := z.EncBinary()
						_ = yym1320
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1318[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1321 := z.EncBinary()
						_ = yym1321
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1318[1] {
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1323 := z.EncBinary()
						_ = yym1323
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1318[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("from"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1324 := z.EncBinary()
						_ = yym1324
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				}
			}
			if yyr1318 || yy2arr1318 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyIngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1325 := z.DecBinary()
	_ = yym1325
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1326 := r.ContainerType()
		if yyct1326 == codecSelferValueTypeMap1234 {
			yyl1326 := r.ReadMapStart()
			if yyl1326 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1326, d)
			}
		} else if yyct1326 == codecSelferValueTypeArray1234 {
			yyl1326 := r.ReadArrayStart()
			if yyl1326 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1326, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1327Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1327Slc
	var yyhl1327 bool = l >= 0
	for yyj1327 := 0; ; yyj1327++ {
		if yyhl1327 {
			if yyj1327 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1327Slc = r.DecodeBytes(yys1327Slc, true, true)
		yys1327 := string(yys1327Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1327 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1328 := &x.Ports
				yym1329 := z.DecBinary()
				_ = yym1329
				if false {
				} else {
					h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1328), d)
				}
			}
		case "from":
			if r.TryDecodeAsNil() {
				x.From = nil
			} else {
				yyv1330 := &x.From
				yym1331 := z.DecBinary()
				_ = yym1331
				if false {
				} else {
					h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1330), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1327)
		} // end switch yys1327
	} // end for yyj1327
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1332 int
	var yyb1332 bool
	var yyhl1332 bool = l >= 0
	yyj1332++
	if yyhl1332 {
		yyb1332 = yyj1332 > l
	} else {
		yyb1332 = r.CheckBreak()
	}
	if yyb1332 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1333 := &x.Ports
		yym1334 := z.DecBinary()
		_ = yym1334
		if false {
		} else {
			h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1333), d)
		}
	}
	yyj1332++
	if yyhl1332 {
		yyb1332 = yyj1332 > l
	} else {
		yyb1332 = r.CheckBreak()
	}
	if yyb1332 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.From = nil
	} else {
		yyv1335 := &x.From
		yym1336 := z.DecBinary()
		_ = yym1336
		if false {
		} else {
			h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1335), d)
		}
	}
	for {
		yyj1332++
		if yyhl1332 {
			yyb1332 = yyj1332 > l
		} else {
			yyb1332 = r.CheckBreak()
		}
		if yyb1332 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1332-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1337 := z.EncBinary()
		_ = yym1337
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1338 := !z.EncBinary()
			yy2arr1338 := z.EncBasicHandle().StructToArray
			var yyq1338 [2]bool
			_, _, _ = yysep1338, yyq1338, yy2arr1338
			const yyr1338 bool = false
			yyq1338[0] = x.Protocol != nil
			yyq1338[1] = x.Port != nil
			var yynn1338 int
			if yyr1338 || yy2arr1338 {
				r.EncodeArrayStart(2)
			} else {
				yynn1338 = 0
				for _, b := range yyq1338 {
					if b {
						yynn1338++
					}
				}
				r.EncodeMapStart(yynn1338)
				yynn1338 = 0
			}
			if yyr1338 || yy2arr1338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1338[0] {
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1340 := *x.Protocol
						yym1341 := z.EncBinary()
						_ = yym1341
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1340) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1340))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1338[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1342 := *x.Protocol
						yym1343 := z.EncBinary()
						_ = yym1343
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1342) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1342))
						}
					}
				}
			}
			if yyr1338 || yy2arr1338 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1338[1] {
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1345 := z.EncBinary()
						_ = yym1345
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1345 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1338[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1346 := z.EncBinary()
						_ = yym1346
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1346 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				}
			}
			if yyr1338 || yy2arr1338 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1347 := z.DecBinary()
	_ = yym1347
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1348 := r.ContainerType()
		if yyct1348 == codecSelferValueTypeMap1234 {
			yyl1348 := r.ReadMapStart()
			if yyl1348 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1348, d)
			}
		} else if yyct1348 == codecSelferValueTypeArray1234 {
			yyl1348 := r.ReadArrayStart()
			if yyl1348 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1348, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1349Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1349Slc
	var yyhl1349 bool = l >= 0
	for yyj1349 := 0; ; yyj1349++ {
		if yyhl1349 {
			if yyj1349 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1349Slc = r.DecodeBytes(yys1349Slc, true, true)
		yys1349 := string(yys1349Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1349 {
		case "protocol":
			if r.TryDecodeAsNil() {
				if x.Protocol != nil {
					x.Protocol = nil
				}
			} else {
				if x.Protocol == nil {
					x.Protocol = new(pkg2_api.Protocol)
				}
				x.Protocol.CodecDecodeSelf(d)
			}
		case "port":
			if r.TryDecodeAsNil() {
				if x.Port != nil {
					x.Port = nil
				}
			} else {
				if x.Port == nil {
					x.Port = new(pkg5_intstr.IntOrString)
				}
				yym1352 := z.DecBinary()
				_ = yym1352
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Port) {
				} else if !yym1352 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Port)
				} else {
					z.DecFallback(x.Port, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1349)
		} // end switch yys1349
	} // end for yyj1349
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1353 int
	var yyb1353 bool
	var yyhl1353 bool = l >= 0
	yyj1353++
	if yyhl1353 {
		yyb1353 = yyj1353 > l
	} else {
		yyb1353 = r.CheckBreak()
	}
	if yyb1353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Protocol != nil {
			x.Protocol = nil
		}
	} else {
		if x.Protocol == nil {
			x.Protocol = new(pkg2_api.Protocol)
		}
		x.Protocol.CodecDecodeSelf(d)
	}
	yyj1353++
	if yyhl1353 {
		yyb1353 = yyj1353 > l
	} else {
		yyb1353 = r.CheckBreak()
	}
	if yyb1353 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Port != nil {
			x.Port = nil
		}
	} else {
		if x.Port == nil {
			x.Port = new(pkg5_intstr.IntOrString)
		}
		yym1356 := z.DecBinary()
		_ = yym1356
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Port) {
		} else if !yym1356 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Port)
		} else {
			z.DecFallback(x.Port, false)
		}
	}
	for {
		yyj1353++
		if yyhl1353 {
			yyb1353 = yyj1353 > l
		} else {
			yyb1353 = r.CheckBreak()
		}
		if yyb1353 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1353-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPeer) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1357 := z.EncBinary()
		_ = yym1357
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1358 := !z.EncBinary()
			yy2arr1358 := z.EncBasicHandle().StructToArray
			var yyq1358 [2]bool
			_, _, _ = yysep1358, yyq1358, yy2arr1358
			const yyr1358 bool = false
			yyq1358[0] = x.PodSelector != nil
			yyq1358[1] = x.NamespaceSelector != nil
			var yynn1358 int
			if yyr1358 || yy2arr1358 {
				r.EncodeArrayStart(2)
			} else {
				yynn1358 = 0
				for _, b := range yyq1358 {
					if b {
						yynn1358++
					}
				}
				r.EncodeMapStart(yynn1358)
				yynn1358 = 0
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[0] {
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						yym1360 := z.EncBinary()
						_ = yym1360
						if false {
						} else if z.HasExtensions() && z.EncExt(x.PodSelector) {
						} else {
							z.EncFallback(x.PodSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1358[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						yym1361 := z.EncBinary()
						_ = yym1361
						if false {
						} else if z.HasExtensions() && z.EncExt(x.PodSelector) {
						} else {
							z.EncFallback(x.PodSelector)
						}
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[1] {
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						yym1363 := z.EncBinary()
						_ = yym1363
						if false {
						} else if z.HasExtensions() && z.EncExt(x.NamespaceSelector) {
						} else {
							z.EncFallback(x.NamespaceSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1358[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespaceSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						yym1364 := z.EncBinary()
						_ = yym1364
						if false {
						} else if z.HasExtensions() && z.EncExt(x.NamespaceSelector) {
						} else {
							z.EncFallback(x.NamespaceSelector)
						}
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPeer) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1365 := z.DecBinary()
	_ = yym1365
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1366 := r.ContainerType()
		if yyct1366 == codecSelferValueTypeMap1234 {
			yyl1366 := r.ReadMapStart()
			if yyl1366 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1366, d)
			}
		} else if yyct1366 == codecSelferValueTypeArray1234 {
			yyl1366 := r.ReadArrayStart()
			if yyl1366 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1366, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1367Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1367Slc
	var yyhl1367 bool = l >= 0
	for yyj1367 := 0; ; yyj1367++ {
		if yyhl1367 {
			if yyj1367 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1367Slc = r.DecodeBytes(yys1367Slc, true, true)
		yys1367 := string(yys1367Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1367 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				if x.PodSelector != nil {
					x.PodSelector = nil
				}
			} else {
				if x.PodSelector == nil {
					x.PodSelector = new(pkg1_unversioned.LabelSelector)
				}
				yym1369 := z.DecBinary()
				_ = yym1369
				if false {
				} else if z.HasExtensions() && z.DecExt(x.PodSelector) {
				} else {
					z.DecFallback(x.PodSelector, false)
				}
			}
		case "namespaceSelector":
			if r.TryDecodeAsNil() {
				if x.NamespaceSelector != nil {
					x.NamespaceSelector = nil
				}
			} else {
				if x.NamespaceSelector == nil {
					x.NamespaceSelector = new(pkg1_unversioned.LabelSelector)
				}
				yym1371 := z.DecBinary()
				_ = yym1371
				if false {
				} else if z.HasExtensions() && z.DecExt(x.NamespaceSelector) {
				} else {
					z.DecFallback(x.NamespaceSelector, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1367)
		} // end switch yys1367
	} // end for yyj1367
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1372 int
	var yyb1372 bool
	var yyhl1372 bool = l >= 0
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodSelector != nil {
			x.PodSelector = nil
		}
	} else {
		if x.PodSelector == nil {
			x.PodSelector = new(pkg1_unversioned.LabelSelector)
		}
		yym1374 := z.DecBinary()
		_ = yym1374
		if false {
		} else if z.HasExtensions() && z.DecExt(x.PodSelector) {
		} else {
			z.DecFallback(x.PodSelector, false)
		}
	}
	yyj1372++
	if yyhl1372 {
		yyb1372 = yyj1372 > l
	} else {
		yyb1372 = r.CheckBreak()
	}
	if yyb1372 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NamespaceSelector != nil {
			x.NamespaceSelector = nil
		}
	} else {
		if x.NamespaceSelector == nil {
			x.NamespaceSelector = new(pkg1_unversioned.LabelSelector)
		}
		yym1376 := z.DecBinary()
		_ = yym1376
		if false {
		} else if z.HasExtensions() && z.DecExt(x.NamespaceSelector) {
		} else {
			z.DecFallback(x.NamespaceSelector, false)
		}
	}
	for {
		yyj1372++
		if yyhl1372 {
			yyb1372 = yyj1372 > l
		} else {
			yyb1372 = r.CheckBreak()
		}
		if yyb1372 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1372-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1377 := z.EncBinary()
		_ = yym1377
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1378 := !z.EncBinary()
			yy2arr1378 := z.EncBasicHandle().StructToArray
			var yyq1378 [4]bool
			_, _, _ = yysep1378, yyq1378, yy2arr1378
			const yyr1378 bool = false
			yyq1378[0] = x.Kind != ""
			yyq1378[1] = x.APIVersion != ""
			yyq1378[2] = true
			var yynn1378 int
			if yyr1378 || yy2arr1378 {
				r.EncodeArrayStart(4)
			} else {
				yynn1378 = 1
				for _, b := range yyq1378 {
					if b {
						yynn1378++
					}
				}
				r.EncodeMapStart(yynn1378)
				yynn1378 = 0
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[0] {
					yym1380 := z.EncBinary()
					_ = yym1380
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1378[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1381 := z.EncBinary()
					_ = yym1381
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[1] {
					yym1383 := z.EncBinary()
					_ = yym1383
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1378[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1384 := z.EncBinary()
					_ = yym1384
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1378[2] {
					yy1386 := &x.ListMeta
					yym1387 := z.EncBinary()
					_ = yym1387
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1386) {
					} else {
						z.EncFallback(yy1386)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1378[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1388 := &x.ListMeta
					yym1389 := z.EncBinary()
					_ = yym1389
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1388) {
					} else {
						z.EncFallback(yy1388)
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1391 := z.EncBinary()
					_ = yym1391
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1392 := z.EncBinary()
					_ = yym1392
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			}
			if yyr1378 || yy2arr1378 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1393 := z.DecBinary()
	_ = yym1393
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1394 := r.ContainerType()
		if yyct1394 == codecSelferValueTypeMap1234 {
			yyl1394 := r.ReadMapStart()
			if yyl1394 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1394, d)
			}
		} else if yyct1394 == codecSelferValueTypeArray1234 {
			yyl1394 := r.ReadArrayStart()
			if yyl1394 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1394, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1395Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1395Slc
	var yyhl1395 bool = l >= 0
	for yyj1395 := 0; ; yyj1395++ {
		if yyhl1395 {
			if yyj1395 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1395Slc = r.DecodeBytes(yys1395Slc, true, true)
		yys1395 := string(yys1395Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1395 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1398 := &x.ListMeta
				yym1399 := z.DecBinary()
				_ = yym1399
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1398) {
				} else {
					z.DecFallback(yyv1398, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1400 := &x.Items
				yym1401 := z.DecBinary()
				_ = yym1401
				if false {
				} else {
					h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1400), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1395)
		} // end switch yys1395
	} // end for yyj1395
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1402 int
	var yyb1402 bool
	var yyhl1402 bool = l >= 0
	yyj1402++
	if yyhl1402 {
		yyb1402 = yyj1402 > l
	} else {
		yyb1402 = r.CheckBreak()
	}
	if yyb1402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1402++
	if yyhl1402 {
		yyb1402 = yyj1402 > l
	} else {
		yyb1402 = r.CheckBreak()
	}
	if yyb1402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1402++
	if yyhl1402 {
		yyb1402 = yyj1402 > l
	} else {
		yyb1402 = r.CheckBreak()
	}
	if yyb1402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1405 := &x.ListMeta
		yym1406 := z.DecBinary()
		_ = yym1406
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1405) {
		} else {
			z.DecFallback(yyv1405, false)
		}
	}
	yyj1402++
	if yyhl1402 {
		yyb1402 = yyj1402 > l
	} else {
		yyb1402 = r.CheckBreak()
	}
	if yyb1402 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1407 := &x.Items
		yym1408 := z.DecBinary()
		_ = yym1408
		if false {
		} else {
			h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1407), d)
		}
	}
	for {
		yyj1402++
		if yyhl1402 {
			yyb1402 = yyj1402 > l
		} else {
			yyb1402 = r.CheckBreak()
		}
		if yyb1402 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1402-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceCustomMetricTarget(v []CustomMetricTarget, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1409 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1410 := &yyv1409
		yy1410.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricTarget(v *[]CustomMetricTarget, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1411 := *v
	yyh1411, yyl1411 := z.DecSliceHelperStart()
	var yyc1411 bool
	if yyl1411 == 0 {
		if yyv1411 == nil {
			yyv1411 = []CustomMetricTarget{}
			yyc1411 = true
		} else if len(yyv1411) != 0 {
			yyv1411 = yyv1411[:0]
			yyc1411 = true
		}
	} else if yyl1411 > 0 {
		var yyrr1411, yyrl1411 int
		var yyrt1411 bool
		if yyl1411 > cap(yyv1411) {

			yyrg1411 := len(yyv1411) > 0
			yyv21411 := yyv1411
			yyrl1411, yyrt1411 = z.DecInferLen(yyl1411, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1411 {
				if yyrl1411 <= cap(yyv1411) {
					yyv1411 = yyv1411[:yyrl1411]
				} else {
					yyv1411 = make([]CustomMetricTarget, yyrl1411)
				}
			} else {
				yyv1411 = make([]CustomMetricTarget, yyrl1411)
			}
			yyc1411 = true
			yyrr1411 = len(yyv1411)
			if yyrg1411 {
				copy(yyv1411, yyv21411)
			}
		} else if yyl1411 != len(yyv1411) {
			yyv1411 = yyv1411[:yyl1411]
			yyc1411 = true
		}
		yyj1411 := 0
		for ; yyj1411 < yyrr1411; yyj1411++ {
			yyh1411.ElemContainerState(yyj1411)
			if r.TryDecodeAsNil() {
				yyv1411[yyj1411] = CustomMetricTarget{}
			} else {
				yyv1412 := &yyv1411[yyj1411]
				yyv1412.CodecDecodeSelf(d)
			}

		}
		if yyrt1411 {
			for ; yyj1411 < yyl1411; yyj1411++ {
				yyv1411 = append(yyv1411, CustomMetricTarget{})
				yyh1411.ElemContainerState(yyj1411)
				if r.TryDecodeAsNil() {
					yyv1411[yyj1411] = CustomMetricTarget{}
				} else {
					yyv1413 := &yyv1411[yyj1411]
					yyv1413.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1411 := 0
		for ; !r.CheckBreak(); yyj1411++ {

			if yyj1411 >= len(yyv1411) {
				yyv1411 = append(yyv1411, CustomMetricTarget{}) // var yyz1411 CustomMetricTarget
				yyc1411 = true
			}
			yyh1411.ElemContainerState(yyj1411)
			if yyj1411 < len(yyv1411) {
				if r.TryDecodeAsNil() {
					yyv1411[yyj1411] = CustomMetricTarget{}
				} else {
					yyv1414 := &yyv1411[yyj1411]
					yyv1414.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1411 < len(yyv1411) {
			yyv1411 = yyv1411[:yyj1411]
			yyc1411 = true
		} else if yyj1411 == 0 && yyv1411 == nil {
			yyv1411 = []CustomMetricTarget{}
			yyc1411 = true
		}
	}
	yyh1411.End()
	if yyc1411 {
		*v = yyv1411
	}
}

func (x codecSelfer1234) encSliceCustomMetricCurrentStatus(v []CustomMetricCurrentStatus, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1415 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1416 := &yyv1415
		yy1416.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricCurrentStatus(v *[]CustomMetricCurrentStatus, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1417 := *v
	yyh1417, yyl1417 := z.DecSliceHelperStart()
	var yyc1417 bool
	if yyl1417 == 0 {
		if yyv1417 == nil {
			yyv1417 = []CustomMetricCurrentStatus{}
			yyc1417 = true
		} else if len(yyv1417) != 0 {
			yyv1417 = yyv1417[:0]
			yyc1417 = true
		}
	} else if yyl1417 > 0 {
		var yyrr1417, yyrl1417 int
		var yyrt1417 bool
		if yyl1417 > cap(yyv1417) {

			yyrg1417 := len(yyv1417) > 0
			yyv21417 := yyv1417
			yyrl1417, yyrt1417 = z.DecInferLen(yyl1417, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1417 {
				if yyrl1417 <= cap(yyv1417) {
					yyv1417 = yyv1417[:yyrl1417]
				} else {
					yyv1417 = make([]CustomMetricCurrentStatus, yyrl1417)
				}
			} else {
				yyv1417 = make([]CustomMetricCurrentStatus, yyrl1417)
			}
			yyc1417 = true
			yyrr1417 = len(yyv1417)
			if yyrg1417 {
				copy(yyv1417, yyv21417)
			}
		} else if yyl1417 != len(yyv1417) {
			yyv1417 = yyv1417[:yyl1417]
			yyc1417 = true
		}
		yyj1417 := 0
		for ; yyj1417 < yyrr1417; yyj1417++ {
			yyh1417.ElemContainerState(yyj1417)
			if r.TryDecodeAsNil() {
				yyv1417[yyj1417] = CustomMetricCurrentStatus{}
			} else {
				yyv1418 := &yyv1417[yyj1417]
				yyv1418.CodecDecodeSelf(d)
			}

		}
		if yyrt1417 {
			for ; yyj1417 < yyl1417; yyj1417++ {
				yyv1417 = append(yyv1417, CustomMetricCurrentStatus{})
				yyh1417.ElemContainerState(yyj1417)
				if r.TryDecodeAsNil() {
					yyv1417[yyj1417] = CustomMetricCurrentStatus{}
				} else {
					yyv1419 := &yyv1417[yyj1417]
					yyv1419.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1417 := 0
		for ; !r.CheckBreak(); yyj1417++ {

			if yyj1417 >= len(yyv1417) {
				yyv1417 = append(yyv1417, CustomMetricCurrentStatus{}) // var yyz1417 CustomMetricCurrentStatus
				yyc1417 = true
			}
			yyh1417.ElemContainerState(yyj1417)
			if yyj1417 < len(yyv1417) {
				if r.TryDecodeAsNil() {
					yyv1417[yyj1417] = CustomMetricCurrentStatus{}
				} else {
					yyv1420 := &yyv1417[yyj1417]
					yyv1420.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1417 < len(yyv1417) {
			yyv1417 = yyv1417[:yyj1417]
			yyc1417 = true
		} else if yyj1417 == 0 && yyv1417 == nil {
			yyv1417 = []CustomMetricCurrentStatus{}
			yyc1417 = true
		}
	}
	yyh1417.End()
	if yyc1417 {
		*v = yyv1417
	}
}

func (x codecSelfer1234) encSliceAPIVersion(v []APIVersion, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1421 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1422 := &yyv1421
		yy1422.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceAPIVersion(v *[]APIVersion, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1423 := *v
	yyh1423, yyl1423 := z.DecSliceHelperStart()
	var yyc1423 bool
	if yyl1423 == 0 {
		if yyv1423 == nil {
			yyv1423 = []APIVersion{}
			yyc1423 = true
		} else if len(yyv1423) != 0 {
			yyv1423 = yyv1423[:0]
			yyc1423 = true
		}
	} else if yyl1423 > 0 {
		var yyrr1423, yyrl1423 int
		var yyrt1423 bool
		if yyl1423 > cap(yyv1423) {

			yyrg1423 := len(yyv1423) > 0
			yyv21423 := yyv1423
			yyrl1423, yyrt1423 = z.DecInferLen(yyl1423, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1423 {
				if yyrl1423 <= cap(yyv1423) {
					yyv1423 = yyv1423[:yyrl1423]
				} else {
					yyv1423 = make([]APIVersion, yyrl1423)
				}
			} else {
				yyv1423 = make([]APIVersion, yyrl1423)
			}
			yyc1423 = true
			yyrr1423 = len(yyv1423)
			if yyrg1423 {
				copy(yyv1423, yyv21423)
			}
		} else if yyl1423 != len(yyv1423) {
			yyv1423 = yyv1423[:yyl1423]
			yyc1423 = true
		}
		yyj1423 := 0
		for ; yyj1423 < yyrr1423; yyj1423++ {
			yyh1423.ElemContainerState(yyj1423)
			if r.TryDecodeAsNil() {
				yyv1423[yyj1423] = APIVersion{}
			} else {
				yyv1424 := &yyv1423[yyj1423]
				yyv1424.CodecDecodeSelf(d)
			}

		}
		if yyrt1423 {
			for ; yyj1423 < yyl1423; yyj1423++ {
				yyv1423 = append(yyv1423, APIVersion{})
				yyh1423.ElemContainerState(yyj1423)
				if r.TryDecodeAsNil() {
					yyv1423[yyj1423] = APIVersion{}
				} else {
					yyv1425 := &yyv1423[yyj1423]
					yyv1425.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1423 := 0
		for ; !r.CheckBreak(); yyj1423++ {

			if yyj1423 >= len(yyv1423) {
				yyv1423 = append(yyv1423, APIVersion{}) // var yyz1423 APIVersion
				yyc1423 = true
			}
			yyh1423.ElemContainerState(yyj1423)
			if yyj1423 < len(yyv1423) {
				if r.TryDecodeAsNil() {
					yyv1423[yyj1423] = APIVersion{}
				} else {
					yyv1426 := &yyv1423[yyj1423]
					yyv1426.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1423 < len(yyv1423) {
			yyv1423 = yyv1423[:yyj1423]
			yyc1423 = true
		} else if yyj1423 == 0 && yyv1423 == nil {
			yyv1423 = []APIVersion{}
			yyc1423 = true
		}
	}
	yyh1423.End()
	if yyc1423 {
		*v = yyv1423
	}
}

func (x codecSelfer1234) encSliceThirdPartyResource(v []ThirdPartyResource, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1427 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1428 := &yyv1427
		yy1428.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResource(v *[]ThirdPartyResource, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1429 := *v
	yyh1429, yyl1429 := z.DecSliceHelperStart()
	var yyc1429 bool
	if yyl1429 == 0 {
		if yyv1429 == nil {
			yyv1429 = []ThirdPartyResource{}
			yyc1429 = true
		} else if len(yyv1429) != 0 {
			yyv1429 = yyv1429[:0]
			yyc1429 = true
		}
	} else if yyl1429 > 0 {
		var yyrr1429, yyrl1429 int
		var yyrt1429 bool
		if yyl1429 > cap(yyv1429) {

			yyrg1429 := len(yyv1429) > 0
			yyv21429 := yyv1429
			yyrl1429, yyrt1429 = z.DecInferLen(yyl1429, z.DecBasicHandle().MaxInitLen, 296)
			if yyrt1429 {
				if yyrl1429 <= cap(yyv1429) {
					yyv1429 = yyv1429[:yyrl1429]
				} else {
					yyv1429 = make([]ThirdPartyResource, yyrl1429)
				}
			} else {
				yyv1429 = make([]ThirdPartyResource, yyrl1429)
			}
			yyc1429 = true
			yyrr1429 = len(yyv1429)
			if yyrg1429 {
				copy(yyv1429, yyv21429)
			}
		} else if yyl1429 != len(yyv1429) {
			yyv1429 = yyv1429[:yyl1429]
			yyc1429 = true
		}
		yyj1429 := 0
		for ; yyj1429 < yyrr1429; yyj1429++ {
			yyh1429.ElemContainerState(yyj1429)
			if r.TryDecodeAsNil() {
				yyv1429[yyj1429] = ThirdPartyResource{}
			} else {
				yyv1430 := &yyv1429[yyj1429]
				yyv1430.CodecDecodeSelf(d)
			}

		}
		if yyrt1429 {
			for ; yyj1429 < yyl1429; yyj1429++ {
				yyv1429 = append(yyv1429, ThirdPartyResource{})
				yyh1429.ElemContainerState(yyj1429)
				if r.TryDecodeAsNil() {
					yyv1429[yyj1429] = ThirdPartyResource{}
				} else {
					yyv1431 := &yyv1429[yyj1429]
					yyv1431.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1429 := 0
		for ; !r.CheckBreak(); yyj1429++ {

			if yyj1429 >= len(yyv1429) {
				yyv1429 = append(yyv1429, ThirdPartyResource{}) // var yyz1429 ThirdPartyResource
				yyc1429 = true
			}
			yyh1429.ElemContainerState(yyj1429)
			if yyj1429 < len(yyv1429) {
				if r.TryDecodeAsNil() {
					yyv1429[yyj1429] = ThirdPartyResource{}
				} else {
					yyv1432 := &yyv1429[yyj1429]
					yyv1432.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1429 < len(yyv1429) {
			yyv1429 = yyv1429[:yyj1429]
			yyc1429 = true
		} else if yyj1429 == 0 && yyv1429 == nil {
			yyv1429 = []ThirdPartyResource{}
			yyc1429 = true
		}
	}
	yyh1429.End()
	if yyc1429 {
		*v = yyv1429
	}
}

func (x codecSelfer1234) encSliceDeploymentCondition(v []DeploymentCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1433 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1434 := &yyv1433
		yy1434.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeploymentCondition(v *[]DeploymentCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1435 := *v
	yyh1435, yyl1435 := z.DecSliceHelperStart()
	var yyc1435 bool
	if yyl1435 == 0 {
		if yyv1435 == nil {
			yyv1435 = []DeploymentCondition{}
			yyc1435 = true
		} else if len(yyv1435) != 0 {
			yyv1435 = yyv1435[:0]
			yyc1435 = true
		}
	} else if yyl1435 > 0 {
		var yyrr1435, yyrl1435 int
		var yyrt1435 bool
		if yyl1435 > cap(yyv1435) {

			yyrg1435 := len(yyv1435) > 0
			yyv21435 := yyv1435
			yyrl1435, yyrt1435 = z.DecInferLen(yyl1435, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt1435 {
				if yyrl1435 <= cap(yyv1435) {
					yyv1435 = yyv1435[:yyrl1435]
				} else {
					yyv1435 = make([]DeploymentCondition, yyrl1435)
				}
			} else {
				yyv1435 = make([]DeploymentCondition, yyrl1435)
			}
			yyc1435 = true
			yyrr1435 = len(yyv1435)
			if yyrg1435 {
				copy(yyv1435, yyv21435)
			}
		} else if yyl1435 != len(yyv1435) {
			yyv1435 = yyv1435[:yyl1435]
			yyc1435 = true
		}
		yyj1435 := 0
		for ; yyj1435 < yyrr1435; yyj1435++ {
			yyh1435.ElemContainerState(yyj1435)
			if r.TryDecodeAsNil() {
				yyv1435[yyj1435] = DeploymentCondition{}
			} else {
				yyv1436 := &yyv1435[yyj1435]
				yyv1436.CodecDecodeSelf(d)
			}

		}
		if yyrt1435 {
			for ; yyj1435 < yyl1435; yyj1435++ {
				yyv1435 = append(yyv1435, DeploymentCondition{})
				yyh1435.ElemContainerState(yyj1435)
				if r.TryDecodeAsNil() {
					yyv1435[yyj1435] = DeploymentCondition{}
				} else {
					yyv1437 := &yyv1435[yyj1435]
					yyv1437.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1435 := 0
		for ; !r.CheckBreak(); yyj1435++ {

			if yyj1435 >= len(yyv1435) {
				yyv1435 = append(yyv1435, DeploymentCondition{}) // var yyz1435 DeploymentCondition
				yyc1435 = true
			}
			yyh1435.ElemContainerState(yyj1435)
			if yyj1435 < len(yyv1435) {
				if r.TryDecodeAsNil() {
					yyv1435[yyj1435] = DeploymentCondition{}
				} else {
					yyv1438 := &yyv1435[yyj1435]
					yyv1438.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1435 < len(yyv1435) {
			yyv1435 = yyv1435[:yyj1435]
			yyc1435 = true
		} else if yyj1435 == 0 && yyv1435 == nil {
			yyv1435 = []DeploymentCondition{}
			yyc1435 = true
		}
	}
	yyh1435.End()
	if yyc1435 {
		*v = yyv1435
	}
}

func (x codecSelfer1234) encSliceDeployment(v []Deployment, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1439 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1440 := &yyv1439
		yy1440.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeployment(v *[]Deployment, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1441 := *v
	yyh1441, yyl1441 := z.DecSliceHelperStart()
	var yyc1441 bool
	if yyl1441 == 0 {
		if yyv1441 == nil {
			yyv1441 = []Deployment{}
			yyc1441 = true
		} else if len(yyv1441) != 0 {
			yyv1441 = yyv1441[:0]
			yyc1441 = true
		}
	} else if yyl1441 > 0 {
		var yyrr1441, yyrl1441 int
		var yyrt1441 bool
		if yyl1441 > cap(yyv1441) {

			yyrg1441 := len(yyv1441) > 0
			yyv21441 := yyv1441
			yyrl1441, yyrt1441 = z.DecInferLen(yyl1441, z.DecBasicHandle().MaxInitLen, 832)
			if yyrt1441 {
				if yyrl1441 <= cap(yyv1441) {
					yyv1441 = yyv1441[:yyrl1441]
				} else {
					yyv1441 = make([]Deployment, yyrl1441)
				}
			} else {
				yyv1441 = make([]Deployment, yyrl1441)
			}
			yyc1441 = true
			yyrr1441 = len(yyv1441)
			if yyrg1441 {
				copy(yyv1441, yyv21441)
			}
		} else if yyl1441 != len(yyv1441) {
			yyv1441 = yyv1441[:yyl1441]
			yyc1441 = true
		}
		yyj1441 := 0
		for ; yyj1441 < yyrr1441; yyj1441++ {
			yyh1441.ElemContainerState(yyj1441)
			if r.TryDecodeAsNil() {
				yyv1441[yyj1441] = Deployment{}
			} else {
				yyv1442 := &yyv1441[yyj1441]
				yyv1442.CodecDecodeSelf(d)
			}

		}
		if yyrt1441 {
			for ; yyj1441 < yyl1441; yyj1441++ {
				yyv1441 = append(yyv1441, Deployment{})
				yyh1441.ElemContainerState(yyj1441)
				if r.TryDecodeAsNil() {
					yyv1441[yyj1441] = Deployment{}
				} else {
					yyv1443 := &yyv1441[yyj1441]
					yyv1443.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1441 := 0
		for ; !r.CheckBreak(); yyj1441++ {

			if yyj1441 >= len(yyv1441) {
				yyv1441 = append(yyv1441, Deployment{}) // var yyz1441 Deployment
				yyc1441 = true
			}
			yyh1441.ElemContainerState(yyj1441)
			if yyj1441 < len(yyv1441) {
				if r.TryDecodeAsNil() {
					yyv1441[yyj1441] = Deployment{}
				} else {
					yyv1444 := &yyv1441[yyj1441]
					yyv1444.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1441 < len(yyv1441) {
			yyv1441 = yyv1441[:yyj1441]
			yyc1441 = true
		} else if yyj1441 == 0 && yyv1441 == nil {
			yyv1441 = []Deployment{}
			yyc1441 = true
		}
	}
	yyh1441.End()
	if yyc1441 {
		*v = yyv1441
	}
}

func (x codecSelfer1234) encSliceDaemonSet(v []DaemonSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1445 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1446 := &yyv1445
		yy1446.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDaemonSet(v *[]DaemonSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1447 := *v
	yyh1447, yyl1447 := z.DecSliceHelperStart()
	var yyc1447 bool
	if yyl1447 == 0 {
		if yyv1447 == nil {
			yyv1447 = []DaemonSet{}
			yyc1447 = true
		} else if len(yyv1447) != 0 {
			yyv1447 = yyv1447[:0]
			yyc1447 = true
		}
	} else if yyl1447 > 0 {
		var yyrr1447, yyrl1447 int
		var yyrt1447 bool
		if yyl1447 > cap(yyv1447) {

			yyrg1447 := len(yyv1447) > 0
			yyv21447 := yyv1447
			yyrl1447, yyrt1447 = z.DecInferLen(yyl1447, z.DecBasicHandle().MaxInitLen, 728)
			if yyrt1447 {
				if yyrl1447 <= cap(yyv1447) {
					yyv1447 = yyv1447[:yyrl1447]
				} else {
					yyv1447 = make([]DaemonSet, yyrl1447)
				}
			} else {
				yyv1447 = make([]DaemonSet, yyrl1447)
			}
			yyc1447 = true
			yyrr1447 = len(yyv1447)
			if yyrg1447 {
				copy(yyv1447, yyv21447)
			}
		} else if yyl1447 != len(yyv1447) {
			yyv1447 = yyv1447[:yyl1447]
			yyc1447 = true
		}
		yyj1447 := 0
		for ; yyj1447 < yyrr1447; yyj1447++ {
			yyh1447.ElemContainerState(yyj1447)
			if r.TryDecodeAsNil() {
				yyv1447[yyj1447] = DaemonSet{}
			} else {
				yyv1448 := &yyv1447[yyj1447]
				yyv1448.CodecDecodeSelf(d)
			}

		}
		if yyrt1447 {
			for ; yyj1447 < yyl1447; yyj1447++ {
				yyv1447 = append(yyv1447, DaemonSet{})
				yyh1447.ElemContainerState(yyj1447)
				if r.TryDecodeAsNil() {
					yyv1447[yyj1447] = DaemonSet{}
				} else {
					yyv1449 := &yyv1447[yyj1447]
					yyv1449.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1447 := 0
		for ; !r.CheckBreak(); yyj1447++ {

			if yyj1447 >= len(yyv1447) {
				yyv1447 = append(yyv1447, DaemonSet{}) // var yyz1447 DaemonSet
				yyc1447 = true
			}
			yyh1447.ElemContainerState(yyj1447)
			if yyj1447 < len(yyv1447) {
				if r.TryDecodeAsNil() {
					yyv1447[yyj1447] = DaemonSet{}
				} else {
					yyv1450 := &yyv1447[yyj1447]
					yyv1450.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1447 < len(yyv1447) {
			yyv1447 = yyv1447[:yyj1447]
			yyc1447 = true
		} else if yyj1447 == 0 && yyv1447 == nil {
			yyv1447 = []DaemonSet{}
			yyc1447 = true
		}
	}
	yyh1447.End()
	if yyc1447 {
		*v = yyv1447
	}
}

func (x codecSelfer1234) encSliceThirdPartyResourceData(v []ThirdPartyResourceData, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1451 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1452 := &yyv1451
		yy1452.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResourceData(v *[]ThirdPartyResourceData, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1453 := *v
	yyh1453, yyl1453 := z.DecSliceHelperStart()
	var yyc1453 bool
	if yyl1453 == 0 {
		if yyv1453 == nil {
			yyv1453 = []ThirdPartyResourceData{}
			yyc1453 = true
		} else if len(yyv1453) != 0 {
			yyv1453 = yyv1453[:0]
			yyc1453 = true
		}
	} else if yyl1453 > 0 {
		var yyrr1453, yyrl1453 int
		var yyrt1453 bool
		if yyl1453 > cap(yyv1453) {

			yyrg1453 := len(yyv1453) > 0
			yyv21453 := yyv1453
			yyrl1453, yyrt1453 = z.DecInferLen(yyl1453, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt1453 {
				if yyrl1453 <= cap(yyv1453) {
					yyv1453 = yyv1453[:yyrl1453]
				} else {
					yyv1453 = make([]ThirdPartyResourceData, yyrl1453)
				}
			} else {
				yyv1453 = make([]ThirdPartyResourceData, yyrl1453)
			}
			yyc1453 = true
			yyrr1453 = len(yyv1453)
			if yyrg1453 {
				copy(yyv1453, yyv21453)
			}
		} else if yyl1453 != len(yyv1453) {
			yyv1453 = yyv1453[:yyl1453]
			yyc1453 = true
		}
		yyj1453 := 0
		for ; yyj1453 < yyrr1453; yyj1453++ {
			yyh1453.ElemContainerState(yyj1453)
			if r.TryDecodeAsNil() {
				yyv1453[yyj1453] = ThirdPartyResourceData{}
			} else {
				yyv1454 := &yyv1453[yyj1453]
				yyv1454.CodecDecodeSelf(d)
			}

		}
		if yyrt1453 {
			for ; yyj1453 < yyl1453; yyj1453++ {
				yyv1453 = append(yyv1453, ThirdPartyResourceData{})
				yyh1453.ElemContainerState(yyj1453)
				if r.TryDecodeAsNil() {
					yyv1453[yyj1453] = ThirdPartyResourceData{}
				} else {
					yyv1455 := &yyv1453[yyj1453]
					yyv1455.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1453 := 0
		for ; !r.CheckBreak(); yyj1453++ {

			if yyj1453 >= len(yyv1453) {
				yyv1453 = append(yyv1453, ThirdPartyResourceData{}) // var yyz1453 ThirdPartyResourceData
				yyc1453 = true
			}
			yyh1453.ElemContainerState(yyj1453)
			if yyj1453 < len(yyv1453) {
				if r.TryDecodeAsNil() {
					yyv1453[yyj1453] = ThirdPartyResourceData{}
				} else {
					yyv1456 := &yyv1453[yyj1453]
					yyv1456.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1453 < len(yyv1453) {
			yyv1453 = yyv1453[:yyj1453]
			yyc1453 = true
		} else if yyj1453 == 0 && yyv1453 == nil {
			yyv1453 = []ThirdPartyResourceData{}
			yyc1453 = true
		}
	}
	yyh1453.End()
	if yyc1453 {
		*v = yyv1453
	}
}

func (x codecSelfer1234) encSliceIngress(v []Ingress, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1457 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1458 := &yyv1457
		yy1458.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngress(v *[]Ingress, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1459 := *v
	yyh1459, yyl1459 := z.DecSliceHelperStart()
	var yyc1459 bool
	if yyl1459 == 0 {
		if yyv1459 == nil {
			yyv1459 = []Ingress{}
			yyc1459 = true
		} else if len(yyv1459) != 0 {
			yyv1459 = yyv1459[:0]
			yyc1459 = true
		}
	} else if yyl1459 > 0 {
		var yyrr1459, yyrl1459 int
		var yyrt1459 bool
		if yyl1459 > cap(yyv1459) {

			yyrg1459 := len(yyv1459) > 0
			yyv21459 := yyv1459
			yyrl1459, yyrt1459 = z.DecInferLen(yyl1459, z.DecBasicHandle().MaxInitLen, 336)
			if yyrt1459 {
				if yyrl1459 <= cap(yyv1459) {
					yyv1459 = yyv1459[:yyrl1459]
				} else {
					yyv1459 = make([]Ingress, yyrl1459)
				}
			} else {
				yyv1459 = make([]Ingress, yyrl1459)
			}
			yyc1459 = true
			yyrr1459 = len(yyv1459)
			if yyrg1459 {
				copy(yyv1459, yyv21459)
			}
		} else if yyl1459 != len(yyv1459) {
			yyv1459 = yyv1459[:yyl1459]
			yyc1459 = true
		}
		yyj1459 := 0
		for ; yyj1459 < yyrr1459; yyj1459++ {
			yyh1459.ElemContainerState(yyj1459)
			if r.TryDecodeAsNil() {
				yyv1459[yyj1459] = Ingress{}
			} else {
				yyv1460 := &yyv1459[yyj1459]
				yyv1460.CodecDecodeSelf(d)
			}

		}
		if yyrt1459 {
			for ; yyj1459 < yyl1459; yyj1459++ {
				yyv1459 = append(yyv1459, Ingress{})
				yyh1459.ElemContainerState(yyj1459)
				if r.TryDecodeAsNil() {
					yyv1459[yyj1459] = Ingress{}
				} else {
					yyv1461 := &yyv1459[yyj1459]
					yyv1461.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1459 := 0
		for ; !r.CheckBreak(); yyj1459++ {

			if yyj1459 >= len(yyv1459) {
				yyv1459 = append(yyv1459, Ingress{}) // var yyz1459 Ingress
				yyc1459 = true
			}
			yyh1459.ElemContainerState(yyj1459)
			if yyj1459 < len(yyv1459) {
				if r.TryDecodeAsNil() {
					yyv1459[yyj1459] = Ingress{}
				} else {
					yyv1462 := &yyv1459[yyj1459]
					yyv1462.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1459 < len(yyv1459) {
			yyv1459 = yyv1459[:yyj1459]
			yyc1459 = true
		} else if yyj1459 == 0 && yyv1459 == nil {
			yyv1459 = []Ingress{}
			yyc1459 = true
		}
	}
	yyh1459.End()
	if yyc1459 {
		*v = yyv1459
	}
}

func (x codecSelfer1234) encSliceIngressTLS(v []IngressTLS, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1463 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1464 := &yyv1463
		yy1464.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressTLS(v *[]IngressTLS, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1465 := *v
	yyh1465, yyl1465 := z.DecSliceHelperStart()
	var yyc1465 bool
	if yyl1465 == 0 {
		if yyv1465 == nil {
			yyv1465 = []IngressTLS{}
			yyc1465 = true
		} else if len(yyv1465) != 0 {
			yyv1465 = yyv1465[:0]
			yyc1465 = true
		}
	} else if yyl1465 > 0 {
		var yyrr1465, yyrl1465 int
		var yyrt1465 bool
		if yyl1465 > cap(yyv1465) {

			yyrg1465 := len(yyv1465) > 0
			yyv21465 := yyv1465
			yyrl1465, yyrt1465 = z.DecInferLen(yyl1465, z.DecBasicHandle().MaxInitLen, 40)
			if yyrt1465 {
				if yyrl1465 <= cap(yyv1465) {
					yyv1465 = yyv1465[:yyrl1465]
				} else {
					yyv1465 = make([]IngressTLS, yyrl1465)
				}
			} else {
				yyv1465 = make([]IngressTLS, yyrl1465)
			}
			yyc1465 = true
			yyrr1465 = len(yyv1465)
			if yyrg1465 {
				copy(yyv1465, yyv21465)
			}
		} else if yyl1465 != len(yyv1465) {
			yyv1465 = yyv1465[:yyl1465]
			yyc1465 = true
		}
		yyj1465 := 0
		for ; yyj1465 < yyrr1465; yyj1465++ {
			yyh1465.ElemContainerState(yyj1465)
			if r.TryDecodeAsNil() {
				yyv1465[yyj1465] = IngressTLS{}
			} else {
				yyv1466 := &yyv1465[yyj1465]
				yyv1466.CodecDecodeSelf(d)
			}

		}
		if yyrt1465 {
			for ; yyj1465 < yyl1465; yyj1465++ {
				yyv1465 = append(yyv1465, IngressTLS{})
				yyh1465.ElemContainerState(yyj1465)
				if r.TryDecodeAsNil() {
					yyv1465[yyj1465] = IngressTLS{}
				} else {
					yyv1467 := &yyv1465[yyj1465]
					yyv1467.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1465 := 0
		for ; !r.CheckBreak(); yyj1465++ {

			if yyj1465 >= len(yyv1465) {
				yyv1465 = append(yyv1465, IngressTLS{}) // var yyz1465 IngressTLS
				yyc1465 = true
			}
			yyh1465.ElemContainerState(yyj1465)
			if yyj1465 < len(yyv1465) {
				if r.TryDecodeAsNil() {
					yyv1465[yyj1465] = IngressTLS{}
				} else {
					yyv1468 := &yyv1465[yyj1465]
					yyv1468.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1465 < len(yyv1465) {
			yyv1465 = yyv1465[:yyj1465]
			yyc1465 = true
		} else if yyj1465 == 0 && yyv1465 == nil {
			yyv1465 = []IngressTLS{}
			yyc1465 = true
		}
	}
	yyh1465.End()
	if yyc1465 {
		*v = yyv1465
	}
}

func (x codecSelfer1234) encSliceIngressRule(v []IngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1469 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1470 := &yyv1469
		yy1470.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressRule(v *[]IngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1471 := *v
	yyh1471, yyl1471 := z.DecSliceHelperStart()
	var yyc1471 bool
	if yyl1471 == 0 {
		if yyv1471 == nil {
			yyv1471 = []IngressRule{}
			yyc1471 = true
		} else if len(yyv1471) != 0 {
			yyv1471 = yyv1471[:0]
			yyc1471 = true
		}
	} else if yyl1471 > 0 {
		var yyrr1471, yyrl1471 int
		var yyrt1471 bool
		if yyl1471 > cap(yyv1471) {

			yyrg1471 := len(yyv1471) > 0
			yyv21471 := yyv1471
			yyrl1471, yyrt1471 = z.DecInferLen(yyl1471, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1471 {
				if yyrl1471 <= cap(yyv1471) {
					yyv1471 = yyv1471[:yyrl1471]
				} else {
					yyv1471 = make([]IngressRule, yyrl1471)
				}
			} else {
				yyv1471 = make([]IngressRule, yyrl1471)
			}
			yyc1471 = true
			yyrr1471 = len(yyv1471)
			if yyrg1471 {
				copy(yyv1471, yyv21471)
			}
		} else if yyl1471 != len(yyv1471) {
			yyv1471 = yyv1471[:yyl1471]
			yyc1471 = true
		}
		yyj1471 := 0
		for ; yyj1471 < yyrr1471; yyj1471++ {
			yyh1471.ElemContainerState(yyj1471)
			if r.TryDecodeAsNil() {
				yyv1471[yyj1471] = IngressRule{}
			} else {
				yyv1472 := &yyv1471[yyj1471]
				yyv1472.CodecDecodeSelf(d)
			}

		}
		if yyrt1471 {
			for ; yyj1471 < yyl1471; yyj1471++ {
				yyv1471 = append(yyv1471, IngressRule{})
				yyh1471.ElemContainerState(yyj1471)
				if r.TryDecodeAsNil() {
					yyv1471[yyj1471] = IngressRule{}
				} else {
					yyv1473 := &yyv1471[yyj1471]
					yyv1473.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1471 := 0
		for ; !r.CheckBreak(); yyj1471++ {

			if yyj1471 >= len(yyv1471) {
				yyv1471 = append(yyv1471, IngressRule{}) // var yyz1471 IngressRule
				yyc1471 = true
			}
			yyh1471.ElemContainerState(yyj1471)
			if yyj1471 < len(yyv1471) {
				if r.TryDecodeAsNil() {
					yyv1471[yyj1471] = IngressRule{}
				} else {
					yyv1474 := &yyv1471[yyj1471]
					yyv1474.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1471 < len(yyv1471) {
			yyv1471 = yyv1471[:yyj1471]
			yyc1471 = true
		} else if yyj1471 == 0 && yyv1471 == nil {
			yyv1471 = []IngressRule{}
			yyc1471 = true
		}
	}
	yyh1471.End()
	if yyc1471 {
		*v = yyv1471
	}
}

func (x codecSelfer1234) encSliceHTTPIngressPath(v []HTTPIngressPath, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1475 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1476 := &yyv1475
		yy1476.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHTTPIngressPath(v *[]HTTPIngressPath, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1477 := *v
	yyh1477, yyl1477 := z.DecSliceHelperStart()
	var yyc1477 bool
	if yyl1477 == 0 {
		if yyv1477 == nil {
			yyv1477 = []HTTPIngressPath{}
			yyc1477 = true
		} else if len(yyv1477) != 0 {
			yyv1477 = yyv1477[:0]
			yyc1477 = true
		}
	} else if yyl1477 > 0 {
		var yyrr1477, yyrl1477 int
		var yyrt1477 bool
		if yyl1477 > cap(yyv1477) {

			yyrg1477 := len(yyv1477) > 0
			yyv21477 := yyv1477
			yyrl1477, yyrt1477 = z.DecInferLen(yyl1477, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt1477 {
				if yyrl1477 <= cap(yyv1477) {
					yyv1477 = yyv1477[:yyrl1477]
				} else {
					yyv1477 = make([]HTTPIngressPath, yyrl1477)
				}
			} else {
				yyv1477 = make([]HTTPIngressPath, yyrl1477)
			}
			yyc1477 = true
			yyrr1477 = len(yyv1477)
			if yyrg1477 {
				copy(yyv1477, yyv21477)
			}
		} else if yyl1477 != len(yyv1477) {
			yyv1477 = yyv1477[:yyl1477]
			yyc1477 = true
		}
		yyj1477 := 0
		for ; yyj1477 < yyrr1477; yyj1477++ {
			yyh1477.ElemContainerState(yyj1477)
			if r.TryDecodeAsNil() {
				yyv1477[yyj1477] = HTTPIngressPath{}
			} else {
				yyv1478 := &yyv1477[yyj1477]
				yyv1478.CodecDecodeSelf(d)
			}

		}
		if yyrt1477 {
			for ; yyj1477 < yyl1477; yyj1477++ {
				yyv1477 = append(yyv1477, HTTPIngressPath{})
				yyh1477.ElemContainerState(yyj1477)
				if r.TryDecodeAsNil() {
					yyv1477[yyj1477] = HTTPIngressPath{}
				} else {
					yyv1479 := &yyv1477[yyj1477]
					yyv1479.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1477 := 0
		for ; !r.CheckBreak(); yyj1477++ {

			if yyj1477 >= len(yyv1477) {
				yyv1477 = append(yyv1477, HTTPIngressPath{}) // var yyz1477 HTTPIngressPath
				yyc1477 = true
			}
			yyh1477.ElemContainerState(yyj1477)
			if yyj1477 < len(yyv1477) {
				if r.TryDecodeAsNil() {
					yyv1477[yyj1477] = HTTPIngressPath{}
				} else {
					yyv1480 := &yyv1477[yyj1477]
					yyv1480.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1477 < len(yyv1477) {
			yyv1477 = yyv1477[:yyj1477]
			yyc1477 = true
		} else if yyj1477 == 0 && yyv1477 == nil {
			yyv1477 = []HTTPIngressPath{}
			yyc1477 = true
		}
	}
	yyh1477.End()
	if yyc1477 {
		*v = yyv1477
	}
}

func (x codecSelfer1234) encSliceReplicaSet(v []ReplicaSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1481 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1482 := &yyv1481
		yy1482.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceReplicaSet(v *[]ReplicaSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1483 := *v
	yyh1483, yyl1483 := z.DecSliceHelperStart()
	var yyc1483 bool
	if yyl1483 == 0 {
		if yyv1483 == nil {
			yyv1483 = []ReplicaSet{}
			yyc1483 = true
		} else if len(yyv1483) != 0 {
			yyv1483 = yyv1483[:0]
			yyc1483 = true
		}
	} else if yyl1483 > 0 {
		var yyrr1483, yyrl1483 int
		var yyrt1483 bool
		if yyl1483 > cap(yyv1483) {

			yyrg1483 := len(yyv1483) > 0
			yyv21483 := yyv1483
			yyrl1483, yyrt1483 = z.DecInferLen(yyl1483, z.DecBasicHandle().MaxInitLen, 768)
			if yyrt1483 {
				if yyrl1483 <= cap(yyv1483) {
					yyv1483 = yyv1483[:yyrl1483]
				} else {
					yyv1483 = make([]ReplicaSet, yyrl1483)
				}
			} else {
				yyv1483 = make([]ReplicaSet, yyrl1483)
			}
			yyc1483 = true
			yyrr1483 = len(yyv1483)
			if yyrg1483 {
				copy(yyv1483, yyv21483)
			}
		} else if yyl1483 != len(yyv1483) {
			yyv1483 = yyv1483[:yyl1483]
			yyc1483 = true
		}
		yyj1483 := 0
		for ; yyj1483 < yyrr1483; yyj1483++ {
			yyh1483.ElemContainerState(yyj1483)
			if r.TryDecodeAsNil() {
				yyv1483[yyj1483] = ReplicaSet{}
			} else {
				yyv1484 := &yyv1483[yyj1483]
				yyv1484.CodecDecodeSelf(d)
			}

		}
		if yyrt1483 {
			for ; yyj1483 < yyl1483; yyj1483++ {
				yyv1483 = append(yyv1483, ReplicaSet{})
				yyh1483.ElemContainerState(yyj1483)
				if r.TryDecodeAsNil() {
					yyv1483[yyj1483] = ReplicaSet{}
				} else {
					yyv1485 := &yyv1483[yyj1483]
					yyv1485.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1483 := 0
		for ; !r.CheckBreak(); yyj1483++ {

			if yyj1483 >= len(yyv1483) {
				yyv1483 = append(yyv1483, ReplicaSet{}) // var yyz1483 ReplicaSet
				yyc1483 = true
			}
			yyh1483.ElemContainerState(yyj1483)
			if yyj1483 < len(yyv1483) {
				if r.TryDecodeAsNil() {
					yyv1483[yyj1483] = ReplicaSet{}
				} else {
					yyv1486 := &yyv1483[yyj1483]
					yyv1486.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1483 < len(yyv1483) {
			yyv1483 = yyv1483[:yyj1483]
			yyc1483 = true
		} else if yyj1483 == 0 && yyv1483 == nil {
			yyv1483 = []ReplicaSet{}
			yyc1483 = true
		}
	}
	yyh1483.End()
	if yyc1483 {
		*v = yyv1483
	}
}

func (x codecSelfer1234) encSliceReplicaSetCondition(v []ReplicaSetCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1487 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1488 := &yyv1487
		yy1488.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceReplicaSetCondition(v *[]ReplicaSetCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1489 := *v
	yyh1489, yyl1489 := z.DecSliceHelperStart()
	var yyc1489 bool
	if yyl1489 == 0 {
		if yyv1489 == nil {
			yyv1489 = []ReplicaSetCondition{}
			yyc1489 = true
		} else if len(yyv1489) != 0 {
			yyv1489 = yyv1489[:0]
			yyc1489 = true
		}
	} else if yyl1489 > 0 {
		var yyrr1489, yyrl1489 int
		var yyrt1489 bool
		if yyl1489 > cap(yyv1489) {

			yyrg1489 := len(yyv1489) > 0
			yyv21489 := yyv1489
			yyrl1489, yyrt1489 = z.DecInferLen(yyl1489, z.DecBasicHandle().MaxInitLen, 88)
			if yyrt1489 {
				if yyrl1489 <= cap(yyv1489) {
					yyv1489 = yyv1489[:yyrl1489]
				} else {
					yyv1489 = make([]ReplicaSetCondition, yyrl1489)
				}
			} else {
				yyv1489 = make([]ReplicaSetCondition, yyrl1489)
			}
			yyc1489 = true
			yyrr1489 = len(yyv1489)
			if yyrg1489 {
				copy(yyv1489, yyv21489)
			}
		} else if yyl1489 != len(yyv1489) {
			yyv1489 = yyv1489[:yyl1489]
			yyc1489 = true
		}
		yyj1489 := 0
		for ; yyj1489 < yyrr1489; yyj1489++ {
			yyh1489.ElemContainerState(yyj1489)
			if r.TryDecodeAsNil() {
				yyv1489[yyj1489] = ReplicaSetCondition{}
			} else {
				yyv1490 := &yyv1489[yyj1489]
				yyv1490.CodecDecodeSelf(d)
			}

		}
		if yyrt1489 {
			for ; yyj1489 < yyl1489; yyj1489++ {
				yyv1489 = append(yyv1489, ReplicaSetCondition{})
				yyh1489.ElemContainerState(yyj1489)
				if r.TryDecodeAsNil() {
					yyv1489[yyj1489] = ReplicaSetCondition{}
				} else {
					yyv1491 := &yyv1489[yyj1489]
					yyv1491.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1489 := 0
		for ; !r.CheckBreak(); yyj1489++ {

			if yyj1489 >= len(yyv1489) {
				yyv1489 = append(yyv1489, ReplicaSetCondition{}) // var yyz1489 ReplicaSetCondition
				yyc1489 = true
			}
			yyh1489.ElemContainerState(yyj1489)
			if yyj1489 < len(yyv1489) {
				if r.TryDecodeAsNil() {
					yyv1489[yyj1489] = ReplicaSetCondition{}
				} else {
					yyv1492 := &yyv1489[yyj1489]
					yyv1492.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1489 < len(yyv1489) {
			yyv1489 = yyv1489[:yyj1489]
			yyc1489 = true
		} else if yyj1489 == 0 && yyv1489 == nil {
			yyv1489 = []ReplicaSetCondition{}
			yyc1489 = true
		}
	}
	yyh1489.End()
	if yyc1489 {
		*v = yyv1489
	}
}

func (x codecSelfer1234) encSliceapi_Capability(v []pkg2_api.Capability, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1493 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym1494 := z.EncBinary()
		_ = yym1494
		if false {
		} else if z.HasExtensions() && z.EncExt(yyv1493) {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1493))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceapi_Capability(v *[]pkg2_api.Capability, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1495 := *v
	yyh1495, yyl1495 := z.DecSliceHelperStart()
	var yyc1495 bool
	if yyl1495 == 0 {
		if yyv1495 == nil {
			yyv1495 = []pkg2_api.Capability{}
			yyc1495 = true
		} else if len(yyv1495) != 0 {
			yyv1495 = yyv1495[:0]
			yyc1495 = true
		}
	} else if yyl1495 > 0 {
		var yyrr1495, yyrl1495 int
		var yyrt1495 bool
		if yyl1495 > cap(yyv1495) {

			yyrl1495, yyrt1495 = z.DecInferLen(yyl1495, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1495 {
				if yyrl1495 <= cap(yyv1495) {
					yyv1495 = yyv1495[:yyrl1495]
				} else {
					yyv1495 = make([]pkg2_api.Capability, yyrl1495)
				}
			} else {
				yyv1495 = make([]pkg2_api.Capability, yyrl1495)
			}
			yyc1495 = true
			yyrr1495 = len(yyv1495)
		} else if yyl1495 != len(yyv1495) {
			yyv1495 = yyv1495[:yyl1495]
			yyc1495 = true
		}
		yyj1495 := 0
		for ; yyj1495 < yyrr1495; yyj1495++ {
			yyh1495.ElemContainerState(yyj1495)
			if r.TryDecodeAsNil() {
				yyv1495[yyj1495] = ""
			} else {
				yyv1495[yyj1495] = pkg2_api.Capability(r.DecodeString())
			}

		}
		if yyrt1495 {
			for ; yyj1495 < yyl1495; yyj1495++ {
				yyv1495 = append(yyv1495, "")
				yyh1495.ElemContainerState(yyj1495)
				if r.TryDecodeAsNil() {
					yyv1495[yyj1495] = ""
				} else {
					yyv1495[yyj1495] = pkg2_api.Capability(r.DecodeString())
				}

			}
		}

	} else {
		yyj1495 := 0
		for ; !r.CheckBreak(); yyj1495++ {

			if yyj1495 >= len(yyv1495) {
				yyv1495 = append(yyv1495, "") // var yyz1495 pkg2_api.Capability
				yyc1495 = true
			}
			yyh1495.ElemContainerState(yyj1495)
			if yyj1495 < len(yyv1495) {
				if r.TryDecodeAsNil() {
					yyv1495[yyj1495] = ""
				} else {
					yyv1495[yyj1495] = pkg2_api.Capability(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1495 < len(yyv1495) {
			yyv1495 = yyv1495[:yyj1495]
			yyc1495 = true
		} else if yyj1495 == 0 && yyv1495 == nil {
			yyv1495 = []pkg2_api.Capability{}
			yyc1495 = true
		}
	}
	yyh1495.End()
	if yyc1495 {
		*v = yyv1495
	}
}

func (x codecSelfer1234) encSliceFSType(v []FSType, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1499 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yyv1499.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceFSType(v *[]FSType, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1500 := *v
	yyh1500, yyl1500 := z.DecSliceHelperStart()
	var yyc1500 bool
	if yyl1500 == 0 {
		if yyv1500 == nil {
			yyv1500 = []FSType{}
			yyc1500 = true
		} else if len(yyv1500) != 0 {
			yyv1500 = yyv1500[:0]
			yyc1500 = true
		}
	} else if yyl1500 > 0 {
		var yyrr1500, yyrl1500 int
		var yyrt1500 bool
		if yyl1500 > cap(yyv1500) {

			yyrl1500, yyrt1500 = z.DecInferLen(yyl1500, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1500 {
				if yyrl1500 <= cap(yyv1500) {
					yyv1500 = yyv1500[:yyrl1500]
				} else {
					yyv1500 = make([]FSType, yyrl1500)
				}
			} else {
				yyv1500 = make([]FSType, yyrl1500)
			}
			yyc1500 = true
			yyrr1500 = len(yyv1500)
		} else if yyl1500 != len(yyv1500) {
			yyv1500 = yyv1500[:yyl1500]
			yyc1500 = true
		}
		yyj1500 := 0
		for ; yyj1500 < yyrr1500; yyj1500++ {
			yyh1500.ElemContainerState(yyj1500)
			if r.TryDecodeAsNil() {
				yyv1500[yyj1500] = ""
			} else {
				yyv1500[yyj1500] = FSType(r.DecodeString())
			}

		}
		if yyrt1500 {
			for ; yyj1500 < yyl1500; yyj1500++ {
				yyv1500 = append(yyv1500, "")
				yyh1500.ElemContainerState(yyj1500)
				if r.TryDecodeAsNil() {
					yyv1500[yyj1500] = ""
				} else {
					yyv1500[yyj1500] = FSType(r.DecodeString())
				}

			}
		}

	} else {
		yyj1500 := 0
		for ; !r.CheckBreak(); yyj1500++ {

			if yyj1500 >= len(yyv1500) {
				yyv1500 = append(yyv1500, "") // var yyz1500 FSType
				yyc1500 = true
			}
			yyh1500.ElemContainerState(yyj1500)
			if yyj1500 < len(yyv1500) {
				if r.TryDecodeAsNil() {
					yyv1500[yyj1500] = ""
				} else {
					yyv1500[yyj1500] = FSType(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1500 < len(yyv1500) {
			yyv1500 = yyv1500[:yyj1500]
			yyc1500 = true
		} else if yyj1500 == 0 && yyv1500 == nil {
			yyv1500 = []FSType{}
			yyc1500 = true
		}
	}
	yyh1500.End()
	if yyc1500 {
		*v = yyv1500
	}
}

func (x codecSelfer1234) encSliceHostPortRange(v []HostPortRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1504 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1505 := &yyv1504
		yy1505.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHostPortRange(v *[]HostPortRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1506 := *v
	yyh1506, yyl1506 := z.DecSliceHelperStart()
	var yyc1506 bool
	if yyl1506 == 0 {
		if yyv1506 == nil {
			yyv1506 = []HostPortRange{}
			yyc1506 = true
		} else if len(yyv1506) != 0 {
			yyv1506 = yyv1506[:0]
			yyc1506 = true
		}
	} else if yyl1506 > 0 {
		var yyrr1506, yyrl1506 int
		var yyrt1506 bool
		if yyl1506 > cap(yyv1506) {

			yyrg1506 := len(yyv1506) > 0
			yyv21506 := yyv1506
			yyrl1506, yyrt1506 = z.DecInferLen(yyl1506, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1506 {
				if yyrl1506 <= cap(yyv1506) {
					yyv1506 = yyv1506[:yyrl1506]
				} else {
					yyv1506 = make([]HostPortRange, yyrl1506)
				}
			} else {
				yyv1506 = make([]HostPortRange, yyrl1506)
			}
			yyc1506 = true
			yyrr1506 = len(yyv1506)
			if yyrg1506 {
				copy(yyv1506, yyv21506)
			}
		} else if yyl1506 != len(yyv1506) {
			yyv1506 = yyv1506[:yyl1506]
			yyc1506 = true
		}
		yyj1506 := 0
		for ; yyj1506 < yyrr1506; yyj1506++ {
			yyh1506.ElemContainerState(yyj1506)
			if r.TryDecodeAsNil() {
				yyv1506[yyj1506] = HostPortRange{}
			} else {
				yyv1507 := &yyv1506[yyj1506]
				yyv1507.CodecDecodeSelf(d)
			}

		}
		if yyrt1506 {
			for ; yyj1506 < yyl1506; yyj1506++ {
				yyv1506 = append(yyv1506, HostPortRange{})
				yyh1506.ElemContainerState(yyj1506)
				if r.TryDecodeAsNil() {
					yyv1506[yyj1506] = HostPortRange{}
				} else {
					yyv1508 := &yyv1506[yyj1506]
					yyv1508.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1506 := 0
		for ; !r.CheckBreak(); yyj1506++ {

			if yyj1506 >= len(yyv1506) {
				yyv1506 = append(yyv1506, HostPortRange{}) // var yyz1506 HostPortRange
				yyc1506 = true
			}
			yyh1506.ElemContainerState(yyj1506)
			if yyj1506 < len(yyv1506) {
				if r.TryDecodeAsNil() {
					yyv1506[yyj1506] = HostPortRange{}
				} else {
					yyv1509 := &yyv1506[yyj1506]
					yyv1509.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1506 < len(yyv1506) {
			yyv1506 = yyv1506[:yyj1506]
			yyc1506 = true
		} else if yyj1506 == 0 && yyv1506 == nil {
			yyv1506 = []HostPortRange{}
			yyc1506 = true
		}
	}
	yyh1506.End()
	if yyc1506 {
		*v = yyv1506
	}
}

func (x codecSelfer1234) encSliceIDRange(v []IDRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1510 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1511 := &yyv1510
		yy1511.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIDRange(v *[]IDRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1512 := *v
	yyh1512, yyl1512 := z.DecSliceHelperStart()
	var yyc1512 bool
	if yyl1512 == 0 {
		if yyv1512 == nil {
			yyv1512 = []IDRange{}
			yyc1512 = true
		} else if len(yyv1512) != 0 {
			yyv1512 = yyv1512[:0]
			yyc1512 = true
		}
	} else if yyl1512 > 0 {
		var yyrr1512, yyrl1512 int
		var yyrt1512 bool
		if yyl1512 > cap(yyv1512) {

			yyrg1512 := len(yyv1512) > 0
			yyv21512 := yyv1512
			yyrl1512, yyrt1512 = z.DecInferLen(yyl1512, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1512 {
				if yyrl1512 <= cap(yyv1512) {
					yyv1512 = yyv1512[:yyrl1512]
				} else {
					yyv1512 = make([]IDRange, yyrl1512)
				}
			} else {
				yyv1512 = make([]IDRange, yyrl1512)
			}
			yyc1512 = true
			yyrr1512 = len(yyv1512)
			if yyrg1512 {
				copy(yyv1512, yyv21512)
			}
		} else if yyl1512 != len(yyv1512) {
			yyv1512 = yyv1512[:yyl1512]
			yyc1512 = true
		}
		yyj1512 := 0
		for ; yyj1512 < yyrr1512; yyj1512++ {
			yyh1512.ElemContainerState(yyj1512)
			if r.TryDecodeAsNil() {
				yyv1512[yyj1512] = IDRange{}
			} else {
				yyv1513 := &yyv1512[yyj1512]
				yyv1513.CodecDecodeSelf(d)
			}

		}
		if yyrt1512 {
			for ; yyj1512 < yyl1512; yyj1512++ {
				yyv1512 = append(yyv1512, IDRange{})
				yyh1512.ElemContainerState(yyj1512)
				if r.TryDecodeAsNil() {
					yyv1512[yyj1512] = IDRange{}
				} else {
					yyv1514 := &yyv1512[yyj1512]
					yyv1514.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1512 := 0
		for ; !r.CheckBreak(); yyj1512++ {

			if yyj1512 >= len(yyv1512) {
				yyv1512 = append(yyv1512, IDRange{}) // var yyz1512 IDRange
				yyc1512 = true
			}
			yyh1512.ElemContainerState(yyj1512)
			if yyj1512 < len(yyv1512) {
				if r.TryDecodeAsNil() {
					yyv1512[yyj1512] = IDRange{}
				} else {
					yyv1515 := &yyv1512[yyj1512]
					yyv1515.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1512 < len(yyv1512) {
			yyv1512 = yyv1512[:yyj1512]
			yyc1512 = true
		} else if yyj1512 == 0 && yyv1512 == nil {
			yyv1512 = []IDRange{}
			yyc1512 = true
		}
	}
	yyh1512.End()
	if yyc1512 {
		*v = yyv1512
	}
}

func (x codecSelfer1234) encSlicePodSecurityPolicy(v []PodSecurityPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1516 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1517 := &yyv1516
		yy1517.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePodSecurityPolicy(v *[]PodSecurityPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1518 := *v
	yyh1518, yyl1518 := z.DecSliceHelperStart()
	var yyc1518 bool
	if yyl1518 == 0 {
		if yyv1518 == nil {
			yyv1518 = []PodSecurityPolicy{}
			yyc1518 = true
		} else if len(yyv1518) != 0 {
			yyv1518 = yyv1518[:0]
			yyc1518 = true
		}
	} else if yyl1518 > 0 {
		var yyrr1518, yyrl1518 int
		var yyrt1518 bool
		if yyl1518 > cap(yyv1518) {

			yyrg1518 := len(yyv1518) > 0
			yyv21518 := yyv1518
			yyrl1518, yyrt1518 = z.DecInferLen(yyl1518, z.DecBasicHandle().MaxInitLen, 552)
			if yyrt1518 {
				if yyrl1518 <= cap(yyv1518) {
					yyv1518 = yyv1518[:yyrl1518]
				} else {
					yyv1518 = make([]PodSecurityPolicy, yyrl1518)
				}
			} else {
				yyv1518 = make([]PodSecurityPolicy, yyrl1518)
			}
			yyc1518 = true
			yyrr1518 = len(yyv1518)
			if yyrg1518 {
				copy(yyv1518, yyv21518)
			}
		} else if yyl1518 != len(yyv1518) {
			yyv1518 = yyv1518[:yyl1518]
			yyc1518 = true
		}
		yyj1518 := 0
		for ; yyj1518 < yyrr1518; yyj1518++ {
			yyh1518.ElemContainerState(yyj1518)
			if r.TryDecodeAsNil() {
				yyv1518[yyj1518] = PodSecurityPolicy{}
			} else {
				yyv1519 := &yyv1518[yyj1518]
				yyv1519.CodecDecodeSelf(d)
			}

		}
		if yyrt1518 {
			for ; yyj1518 < yyl1518; yyj1518++ {
				yyv1518 = append(yyv1518, PodSecurityPolicy{})
				yyh1518.ElemContainerState(yyj1518)
				if r.TryDecodeAsNil() {
					yyv1518[yyj1518] = PodSecurityPolicy{}
				} else {
					yyv1520 := &yyv1518[yyj1518]
					yyv1520.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1518 := 0
		for ; !r.CheckBreak(); yyj1518++ {

			if yyj1518 >= len(yyv1518) {
				yyv1518 = append(yyv1518, PodSecurityPolicy{}) // var yyz1518 PodSecurityPolicy
				yyc1518 = true
			}
			yyh1518.ElemContainerState(yyj1518)
			if yyj1518 < len(yyv1518) {
				if r.TryDecodeAsNil() {
					yyv1518[yyj1518] = PodSecurityPolicy{}
				} else {
					yyv1521 := &yyv1518[yyj1518]
					yyv1521.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1518 < len(yyv1518) {
			yyv1518 = yyv1518[:yyj1518]
			yyc1518 = true
		} else if yyj1518 == 0 && yyv1518 == nil {
			yyv1518 = []PodSecurityPolicy{}
			yyc1518 = true
		}
	}
	yyh1518.End()
	if yyc1518 {
		*v = yyv1518
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyIngressRule(v []NetworkPolicyIngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1522 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1523 := &yyv1522
		yy1523.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyIngressRule(v *[]NetworkPolicyIngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1524 := *v
	yyh1524, yyl1524 := z.DecSliceHelperStart()
	var yyc1524 bool
	if yyl1524 == 0 {
		if yyv1524 == nil {
			yyv1524 = []NetworkPolicyIngressRule{}
			yyc1524 = true
		} else if len(yyv1524) != 0 {
			yyv1524 = yyv1524[:0]
			yyc1524 = true
		}
	} else if yyl1524 > 0 {
		var yyrr1524, yyrl1524 int
		var yyrt1524 bool
		if yyl1524 > cap(yyv1524) {

			yyrg1524 := len(yyv1524) > 0
			yyv21524 := yyv1524
			yyrl1524, yyrt1524 = z.DecInferLen(yyl1524, z.DecBasicHandle().MaxInitLen, 48)
			if yyrt1524 {
				if yyrl1524 <= cap(yyv1524) {
					yyv1524 = yyv1524[:yyrl1524]
				} else {
					yyv1524 = make([]NetworkPolicyIngressRule, yyrl1524)
				}
			} else {
				yyv1524 = make([]NetworkPolicyIngressRule, yyrl1524)
			}
			yyc1524 = true
			yyrr1524 = len(yyv1524)
			if yyrg1524 {
				copy(yyv1524, yyv21524)
			}
		} else if yyl1524 != len(yyv1524) {
			yyv1524 = yyv1524[:yyl1524]
			yyc1524 = true
		}
		yyj1524 := 0
		for ; yyj1524 < yyrr1524; yyj1524++ {
			yyh1524.ElemContainerState(yyj1524)
			if r.TryDecodeAsNil() {
				yyv1524[yyj1524] = NetworkPolicyIngressRule{}
			} else {
				yyv1525 := &yyv1524[yyj1524]
				yyv1525.CodecDecodeSelf(d)
			}

		}
		if yyrt1524 {
			for ; yyj1524 < yyl1524; yyj1524++ {
				yyv1524 = append(yyv1524, NetworkPolicyIngressRule{})
				yyh1524.ElemContainerState(yyj1524)
				if r.TryDecodeAsNil() {
					yyv1524[yyj1524] = NetworkPolicyIngressRule{}
				} else {
					yyv1526 := &yyv1524[yyj1524]
					yyv1526.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1524 := 0
		for ; !r.CheckBreak(); yyj1524++ {

			if yyj1524 >= len(yyv1524) {
				yyv1524 = append(yyv1524, NetworkPolicyIngressRule{}) // var yyz1524 NetworkPolicyIngressRule
				yyc1524 = true
			}
			yyh1524.ElemContainerState(yyj1524)
			if yyj1524 < len(yyv1524) {
				if r.TryDecodeAsNil() {
					yyv1524[yyj1524] = NetworkPolicyIngressRule{}
				} else {
					yyv1527 := &yyv1524[yyj1524]
					yyv1527.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1524 < len(yyv1524) {
			yyv1524 = yyv1524[:yyj1524]
			yyc1524 = true
		} else if yyj1524 == 0 && yyv1524 == nil {
			yyv1524 = []NetworkPolicyIngressRule{}
			yyc1524 = true
		}
	}
	yyh1524.End()
	if yyc1524 {
		*v = yyv1524
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPort(v []NetworkPolicyPort, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1528 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1529 := &yyv1528
		yy1529.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPort(v *[]NetworkPolicyPort, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1530 := *v
	yyh1530, yyl1530 := z.DecSliceHelperStart()
	var yyc1530 bool
	if yyl1530 == 0 {
		if yyv1530 == nil {
			yyv1530 = []NetworkPolicyPort{}
			yyc1530 = true
		} else if len(yyv1530) != 0 {
			yyv1530 = yyv1530[:0]
			yyc1530 = true
		}
	} else if yyl1530 > 0 {
		var yyrr1530, yyrl1530 int
		var yyrt1530 bool
		if yyl1530 > cap(yyv1530) {

			yyrg1530 := len(yyv1530) > 0
			yyv21530 := yyv1530
			yyrl1530, yyrt1530 = z.DecInferLen(yyl1530, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1530 {
				if yyrl1530 <= cap(yyv1530) {
					yyv1530 = yyv1530[:yyrl1530]
				} else {
					yyv1530 = make([]NetworkPolicyPort, yyrl1530)
				}
			} else {
				yyv1530 = make([]NetworkPolicyPort, yyrl1530)
			}
			yyc1530 = true
			yyrr1530 = len(yyv1530)
			if yyrg1530 {
				copy(yyv1530, yyv21530)
			}
		} else if yyl1530 != len(yyv1530) {
			yyv1530 = yyv1530[:yyl1530]
			yyc1530 = true
		}
		yyj1530 := 0
		for ; yyj1530 < yyrr1530; yyj1530++ {
			yyh1530.ElemContainerState(yyj1530)
			if r.TryDecodeAsNil() {
				yyv1530[yyj1530] = NetworkPolicyPort{}
			} else {
				yyv1531 := &yyv1530[yyj1530]
				yyv1531.CodecDecodeSelf(d)
			}

		}
		if yyrt1530 {
			for ; yyj1530 < yyl1530; yyj1530++ {
				yyv1530 = append(yyv1530, NetworkPolicyPort{})
				yyh1530.ElemContainerState(yyj1530)
				if r.TryDecodeAsNil() {
					yyv1530[yyj1530] = NetworkPolicyPort{}
				} else {
					yyv1532 := &yyv1530[yyj1530]
					yyv1532.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1530 := 0
		for ; !r.CheckBreak(); yyj1530++ {

			if yyj1530 >= len(yyv1530) {
				yyv1530 = append(yyv1530, NetworkPolicyPort{}) // var yyz1530 NetworkPolicyPort
				yyc1530 = true
			}
			yyh1530.ElemContainerState(yyj1530)
			if yyj1530 < len(yyv1530) {
				if r.TryDecodeAsNil() {
					yyv1530[yyj1530] = NetworkPolicyPort{}
				} else {
					yyv1533 := &yyv1530[yyj1530]
					yyv1533.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1530 < len(yyv1530) {
			yyv1530 = yyv1530[:yyj1530]
			yyc1530 = true
		} else if yyj1530 == 0 && yyv1530 == nil {
			yyv1530 = []NetworkPolicyPort{}
			yyc1530 = true
		}
	}
	yyh1530.End()
	if yyc1530 {
		*v = yyv1530
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPeer(v []NetworkPolicyPeer, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1534 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1535 := &yyv1534
		yy1535.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPeer(v *[]NetworkPolicyPeer, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1536 := *v
	yyh1536, yyl1536 := z.DecSliceHelperStart()
	var yyc1536 bool
	if yyl1536 == 0 {
		if yyv1536 == nil {
			yyv1536 = []NetworkPolicyPeer{}
			yyc1536 = true
		} else if len(yyv1536) != 0 {
			yyv1536 = yyv1536[:0]
			yyc1536 = true
		}
	} else if yyl1536 > 0 {
		var yyrr1536, yyrl1536 int
		var yyrt1536 bool
		if yyl1536 > cap(yyv1536) {

			yyrg1536 := len(yyv1536) > 0
			yyv21536 := yyv1536
			yyrl1536, yyrt1536 = z.DecInferLen(yyl1536, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1536 {
				if yyrl1536 <= cap(yyv1536) {
					yyv1536 = yyv1536[:yyrl1536]
				} else {
					yyv1536 = make([]NetworkPolicyPeer, yyrl1536)
				}
			} else {
				yyv1536 = make([]NetworkPolicyPeer, yyrl1536)
			}
			yyc1536 = true
			yyrr1536 = len(yyv1536)
			if yyrg1536 {
				copy(yyv1536, yyv21536)
			}
		} else if yyl1536 != len(yyv1536) {
			yyv1536 = yyv1536[:yyl1536]
			yyc1536 = true
		}
		yyj1536 := 0
		for ; yyj1536 < yyrr1536; yyj1536++ {
			yyh1536.ElemContainerState(yyj1536)
			if r.TryDecodeAsNil() {
				yyv1536[yyj1536] = NetworkPolicyPeer{}
			} else {
				yyv1537 := &yyv1536[yyj1536]
				yyv1537.CodecDecodeSelf(d)
			}

		}
		if yyrt1536 {
			for ; yyj1536 < yyl1536; yyj1536++ {
				yyv1536 = append(yyv1536, NetworkPolicyPeer{})
				yyh1536.ElemContainerState(yyj1536)
				if r.TryDecodeAsNil() {
					yyv1536[yyj1536] = NetworkPolicyPeer{}
				} else {
					yyv1538 := &yyv1536[yyj1536]
					yyv1538.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1536 := 0
		for ; !r.CheckBreak(); yyj1536++ {

			if yyj1536 >= len(yyv1536) {
				yyv1536 = append(yyv1536, NetworkPolicyPeer{}) // var yyz1536 NetworkPolicyPeer
				yyc1536 = true
			}
			yyh1536.ElemContainerState(yyj1536)
			if yyj1536 < len(yyv1536) {
				if r.TryDecodeAsNil() {
					yyv1536[yyj1536] = NetworkPolicyPeer{}
				} else {
					yyv1539 := &yyv1536[yyj1536]
					yyv1539.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1536 < len(yyv1536) {
			yyv1536 = yyv1536[:yyj1536]
			yyc1536 = true
		} else if yyj1536 == 0 && yyv1536 == nil {
			yyv1536 = []NetworkPolicyPeer{}
			yyc1536 = true
		}
	}
	yyh1536.End()
	if yyc1536 {
		*v = yyv1536
	}
}

func (x codecSelfer1234) encSliceNetworkPolicy(v []NetworkPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1540 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1541 := &yyv1540
		yy1541.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicy(v *[]NetworkPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1542 := *v
	yyh1542, yyl1542 := z.DecSliceHelperStart()
	var yyc1542 bool
	if yyl1542 == 0 {
		if yyv1542 == nil {
			yyv1542 = []NetworkPolicy{}
			yyc1542 = true
		} else if len(yyv1542) != 0 {
			yyv1542 = yyv1542[:0]
			yyc1542 = true
		}
	} else if yyl1542 > 0 {
		var yyrr1542, yyrl1542 int
		var yyrt1542 bool
		if yyl1542 > cap(yyv1542) {

			yyrg1542 := len(yyv1542) > 0
			yyv21542 := yyv1542
			yyrl1542, yyrt1542 = z.DecInferLen(yyl1542, z.DecBasicHandle().MaxInitLen, 312)
			if yyrt1542 {
				if yyrl1542 <= cap(yyv1542) {
					yyv1542 = yyv1542[:yyrl1542]
				} else {
					yyv1542 = make([]NetworkPolicy, yyrl1542)
				}
			} else {
				yyv1542 = make([]NetworkPolicy, yyrl1542)
			}
			yyc1542 = true
			yyrr1542 = len(yyv1542)
			if yyrg1542 {
				copy(yyv1542, yyv21542)
			}
		} else if yyl1542 != len(yyv1542) {
			yyv1542 = yyv1542[:yyl1542]
			yyc1542 = true
		}
		yyj1542 := 0
		for ; yyj1542 < yyrr1542; yyj1542++ {
			yyh1542.ElemContainerState(yyj1542)
			if r.TryDecodeAsNil() {
				yyv1542[yyj1542] = NetworkPolicy{}
			} else {
				yyv1543 := &yyv1542[yyj1542]
				yyv1543.CodecDecodeSelf(d)
			}

		}
		if yyrt1542 {
			for ; yyj1542 < yyl1542; yyj1542++ {
				yyv1542 = append(yyv1542, NetworkPolicy{})
				yyh1542.ElemContainerState(yyj1542)
				if r.TryDecodeAsNil() {
					yyv1542[yyj1542] = NetworkPolicy{}
				} else {
					yyv1544 := &yyv1542[yyj1542]
					yyv1544.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1542 := 0
		for ; !r.CheckBreak(); yyj1542++ {

			if yyj1542 >= len(yyv1542) {
				yyv1542 = append(yyv1542, NetworkPolicy{}) // var yyz1542 NetworkPolicy
				yyc1542 = true
			}
			yyh1542.ElemContainerState(yyj1542)
			if yyj1542 < len(yyv1542) {
				if r.TryDecodeAsNil() {
					yyv1542[yyj1542] = NetworkPolicy{}
				} else {
					yyv1545 := &yyv1542[yyj1542]
					yyv1545.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1542 < len(yyv1542) {
			yyv1542 = yyv1542[:yyj1542]
			yyc1542 = true
		} else if yyj1542 == 0 && yyv1542 == nil {
			yyv1542 = []NetworkPolicy{}
			yyc1542 = true
		}
	}
	yyh1542.End()
	if yyc1542 {
		*v = yyv1542
	}
}
