/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1beta1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg4_resource "k8s.io/kubernetes/pkg/api/resource"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg2_v1 "k8s.io/kubernetes/pkg/api/v1"
	pkg3_types "k8s.io/kubernetes/pkg/types"
	pkg5_intstr "k8s.io/kubernetes/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg4_resource.Quantity
		var v1 pkg1_unversioned.TypeMeta
		var v2 pkg2_v1.ObjectMeta
		var v3 pkg3_types.UID
		var v4 pkg5_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym6 := z.DecBinary()
	_ = yym6
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct7 := r.ContainerType()
		if yyct7 == codecSelferValueTypeMap1234 {
			yyl7 := r.ReadMapStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl7, d)
			}
		} else if yyct7 == codecSelferValueTypeArray1234 {
			yyl7 := r.ReadArrayStart()
			if yyl7 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl7, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys8Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys8Slc
	var yyhl8 bool = l >= 0
	for yyj8 := 0; ; yyj8++ {
		if yyhl8 {
			if yyj8 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys8Slc = r.DecodeBytes(yys8Slc, true, true)
		yys8 := string(yys8Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys8 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys8)
		} // end switch yys8
	} // end for yyj8
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym12 := z.EncBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep13 := !z.EncBinary()
			yy2arr13 := z.EncBasicHandle().StructToArray
			var yyq13 [3]bool
			_, _, _ = yysep13, yyq13, yy2arr13
			const yyr13 bool = false
			yyq13[1] = len(x.Selector) != 0
			yyq13[2] = x.TargetSelector != ""
			var yynn13 int
			if yyr13 || yy2arr13 {
				r.EncodeArrayStart(3)
			} else {
				yynn13 = 1
				for _, b := range yyq13 {
					if b {
						yynn13++
					}
				}
				r.EncodeMapStart(yynn13)
				yynn13 = 0
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym15 := z.EncBinary()
				_ = yym15
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym16 := z.EncBinary()
				_ = yym16
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq13[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq13[2] {
					yym21 := z.EncBinary()
					_ = yym21
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetSelector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq13[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TargetSelector))
					}
				}
			}
			if yyr13 || yy2arr13 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym23 := z.DecBinary()
	_ = yym23
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct24 := r.ContainerType()
		if yyct24 == codecSelferValueTypeMap1234 {
			yyl24 := r.ReadMapStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl24, d)
			}
		} else if yyct24 == codecSelferValueTypeArray1234 {
			yyl24 := r.ReadArrayStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl24, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys25Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys25Slc
	var yyhl25 bool = l >= 0
	for yyj25 := 0; ; yyj25++ {
		if yyhl25 {
			if yyj25 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys25Slc = r.DecodeBytes(yys25Slc, true, true)
		yys25 := string(yys25Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys25 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv27 := &x.Selector
				yym28 := z.DecBinary()
				_ = yym28
				if false {
				} else {
					z.F.DecMapStringStringX(yyv27, false, d)
				}
			}
		case "targetSelector":
			if r.TryDecodeAsNil() {
				x.TargetSelector = ""
			} else {
				x.TargetSelector = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys25)
		} // end switch yys25
	} // end for yyj25
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj30 int
	var yyb30 bool
	var yyhl30 bool = l >= 0
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv32 := &x.Selector
		yym33 := z.DecBinary()
		_ = yym33
		if false {
		} else {
			z.F.DecMapStringStringX(yyv32, false, d)
		}
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetSelector = ""
	} else {
		x.TargetSelector = string(r.DecodeString())
	}
	for {
		yyj30++
		if yyhl30 {
			yyb30 = yyj30 > l
		} else {
			yyb30 = r.CheckBreak()
		}
		if yyb30 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj30-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym35 := z.EncBinary()
		_ = yym35
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep36 := !z.EncBinary()
			yy2arr36 := z.EncBasicHandle().StructToArray
			var yyq36 [5]bool
			_, _, _ = yysep36, yyq36, yy2arr36
			const yyr36 bool = false
			yyq36[0] = x.Kind != ""
			yyq36[1] = x.APIVersion != ""
			yyq36[2] = true
			yyq36[3] = true
			yyq36[4] = true
			var yynn36 int
			if yyr36 || yy2arr36 {
				r.EncodeArrayStart(5)
			} else {
				yynn36 = 0
				for _, b := range yyq36 {
					if b {
						yynn36++
					}
				}
				r.EncodeMapStart(yynn36)
				yynn36 = 0
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[0] {
					yym38 := z.EncBinary()
					_ = yym38
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq36[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym39 := z.EncBinary()
					_ = yym39
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[1] {
					yym41 := z.EncBinary()
					_ = yym41
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq36[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym42 := z.EncBinary()
					_ = yym42
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[2] {
					yy44 := &x.ObjectMeta
					yy44.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq36[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy45 := &x.ObjectMeta
					yy45.CodecEncodeSelf(e)
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[3] {
					yy47 := &x.Spec
					yy47.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq36[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy48 := &x.Spec
					yy48.CodecEncodeSelf(e)
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq36[4] {
					yy50 := &x.Status
					yy50.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq36[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy51 := &x.Status
					yy51.CodecEncodeSelf(e)
				}
			}
			if yyr36 || yy2arr36 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym52 := z.DecBinary()
	_ = yym52
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct53 := r.ContainerType()
		if yyct53 == codecSelferValueTypeMap1234 {
			yyl53 := r.ReadMapStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl53, d)
			}
		} else if yyct53 == codecSelferValueTypeArray1234 {
			yyl53 := r.ReadArrayStart()
			if yyl53 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl53, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys54Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys54Slc
	var yyhl54 bool = l >= 0
	for yyj54 := 0; ; yyj54++ {
		if yyhl54 {
			if yyj54 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys54Slc = r.DecodeBytes(yys54Slc, true, true)
		yys54 := string(yys54Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys54 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv57 := &x.ObjectMeta
				yyv57.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv58 := &x.Spec
				yyv58.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv59 := &x.Status
				yyv59.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys54)
		} // end switch yys54
	} // end for yyj54
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj60 int
	var yyb60 bool
	var yyhl60 bool = l >= 0
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv63 := &x.ObjectMeta
		yyv63.CodecDecodeSelf(d)
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv64 := &x.Spec
		yyv64.CodecDecodeSelf(d)
	}
	yyj60++
	if yyhl60 {
		yyb60 = yyj60 > l
	} else {
		yyb60 = r.CheckBreak()
	}
	if yyb60 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv65 := &x.Status
		yyv65.CodecDecodeSelf(d)
	}
	for {
		yyj60++
		if yyhl60 {
			yyb60 = yyj60 > l
		} else {
			yyb60 = r.CheckBreak()
		}
		if yyb60 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj60-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerDummy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym66 := z.EncBinary()
		_ = yym66
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep67 := !z.EncBinary()
			yy2arr67 := z.EncBasicHandle().StructToArray
			var yyq67 [2]bool
			_, _, _ = yysep67, yyq67, yy2arr67
			const yyr67 bool = false
			yyq67[0] = x.Kind != ""
			yyq67[1] = x.APIVersion != ""
			var yynn67 int
			if yyr67 || yy2arr67 {
				r.EncodeArrayStart(2)
			} else {
				yynn67 = 0
				for _, b := range yyq67 {
					if b {
						yynn67++
					}
				}
				r.EncodeMapStart(yynn67)
				yynn67 = 0
			}
			if yyr67 || yy2arr67 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq67[0] {
					yym69 := z.EncBinary()
					_ = yym69
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq67[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym70 := z.EncBinary()
					_ = yym70
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr67 || yy2arr67 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq67[1] {
					yym72 := z.EncBinary()
					_ = yym72
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq67[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym73 := z.EncBinary()
					_ = yym73
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr67 || yy2arr67 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerDummy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym74 := z.DecBinary()
	_ = yym74
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct75 := r.ContainerType()
		if yyct75 == codecSelferValueTypeMap1234 {
			yyl75 := r.ReadMapStart()
			if yyl75 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl75, d)
			}
		} else if yyct75 == codecSelferValueTypeArray1234 {
			yyl75 := r.ReadArrayStart()
			if yyl75 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl75, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys76Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys76Slc
	var yyhl76 bool = l >= 0
	for yyj76 := 0; ; yyj76++ {
		if yyhl76 {
			if yyj76 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys76Slc = r.DecodeBytes(yys76Slc, true, true)
		yys76 := string(yys76Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys76 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys76)
		} // end switch yys76
	} // end for yyj76
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerDummy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj79 int
	var yyb79 bool
	var yyhl79 bool = l >= 0
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj79++
	if yyhl79 {
		yyb79 = yyj79 > l
	} else {
		yyb79 = r.CheckBreak()
	}
	if yyb79 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj79++
		if yyhl79 {
			yyb79 = yyj79 > l
		} else {
			yyb79 = r.CheckBreak()
		}
		if yyb79 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj79-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SubresourceReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym82 := z.EncBinary()
		_ = yym82
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep83 := !z.EncBinary()
			yy2arr83 := z.EncBasicHandle().StructToArray
			var yyq83 [4]bool
			_, _, _ = yysep83, yyq83, yy2arr83
			const yyr83 bool = false
			yyq83[0] = x.Kind != ""
			yyq83[1] = x.Name != ""
			yyq83[2] = x.APIVersion != ""
			yyq83[3] = x.Subresource != ""
			var yynn83 int
			if yyr83 || yy2arr83 {
				r.EncodeArrayStart(4)
			} else {
				yynn83 = 0
				for _, b := range yyq83 {
					if b {
						yynn83++
					}
				}
				r.EncodeMapStart(yynn83)
				yynn83 = 0
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[0] {
					yym85 := z.EncBinary()
					_ = yym85
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym86 := z.EncBinary()
					_ = yym86
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[1] {
					yym88 := z.EncBinary()
					_ = yym88
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym89 := z.EncBinary()
					_ = yym89
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[2] {
					yym91 := z.EncBinary()
					_ = yym91
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym92 := z.EncBinary()
					_ = yym92
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq83[3] {
					yym94 := z.EncBinary()
					_ = yym94
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq83[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subresource"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym95 := z.EncBinary()
					_ = yym95
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subresource))
					}
				}
			}
			if yyr83 || yy2arr83 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SubresourceReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym96 := z.DecBinary()
	_ = yym96
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct97 := r.ContainerType()
		if yyct97 == codecSelferValueTypeMap1234 {
			yyl97 := r.ReadMapStart()
			if yyl97 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl97, d)
			}
		} else if yyct97 == codecSelferValueTypeArray1234 {
			yyl97 := r.ReadArrayStart()
			if yyl97 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl97, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SubresourceReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys98Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys98Slc
	var yyhl98 bool = l >= 0
	for yyj98 := 0; ; yyj98++ {
		if yyhl98 {
			if yyj98 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys98Slc = r.DecodeBytes(yys98Slc, true, true)
		yys98 := string(yys98Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys98 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "subresource":
			if r.TryDecodeAsNil() {
				x.Subresource = ""
			} else {
				x.Subresource = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys98)
		} // end switch yys98
	} // end for yyj98
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SubresourceReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj103 int
	var yyb103 bool
	var yyhl103 bool = l >= 0
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj103++
	if yyhl103 {
		yyb103 = yyj103 > l
	} else {
		yyb103 = r.CheckBreak()
	}
	if yyb103 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subresource = ""
	} else {
		x.Subresource = string(r.DecodeString())
	}
	for {
		yyj103++
		if yyhl103 {
			yyb103 = yyj103 > l
		} else {
			yyb103 = r.CheckBreak()
		}
		if yyb103 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj103-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CPUTargetUtilization) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym108 := z.EncBinary()
		_ = yym108
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep109 := !z.EncBinary()
			yy2arr109 := z.EncBasicHandle().StructToArray
			var yyq109 [1]bool
			_, _, _ = yysep109, yyq109, yy2arr109
			const yyr109 bool = false
			var yynn109 int
			if yyr109 || yy2arr109 {
				r.EncodeArrayStart(1)
			} else {
				yynn109 = 1
				for _, b := range yyq109 {
					if b {
						yynn109++
					}
				}
				r.EncodeMapStart(yynn109)
				yynn109 = 0
			}
			if yyr109 || yy2arr109 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym111 := z.EncBinary()
				_ = yym111
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPercentage"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym112 := z.EncBinary()
				_ = yym112
				if false {
				} else {
					r.EncodeInt(int64(x.TargetPercentage))
				}
			}
			if yyr109 || yy2arr109 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CPUTargetUtilization) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym113 := z.DecBinary()
	_ = yym113
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct114 := r.ContainerType()
		if yyct114 == codecSelferValueTypeMap1234 {
			yyl114 := r.ReadMapStart()
			if yyl114 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl114, d)
			}
		} else if yyct114 == codecSelferValueTypeArray1234 {
			yyl114 := r.ReadArrayStart()
			if yyl114 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl114, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CPUTargetUtilization) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys115Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys115Slc
	var yyhl115 bool = l >= 0
	for yyj115 := 0; ; yyj115++ {
		if yyhl115 {
			if yyj115 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys115Slc = r.DecodeBytes(yys115Slc, true, true)
		yys115 := string(yys115Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys115 {
		case "targetPercentage":
			if r.TryDecodeAsNil() {
				x.TargetPercentage = 0
			} else {
				x.TargetPercentage = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys115)
		} // end switch yys115
	} // end for yyj115
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CPUTargetUtilization) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj117 int
	var yyb117 bool
	var yyhl117 bool = l >= 0
	yyj117++
	if yyhl117 {
		yyb117 = yyj117 > l
	} else {
		yyb117 = r.CheckBreak()
	}
	if yyb117 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPercentage = 0
	} else {
		x.TargetPercentage = int32(r.DecodeInt(32))
	}
	for {
		yyj117++
		if yyhl117 {
			yyb117 = yyj117 > l
		} else {
			yyb117 = r.CheckBreak()
		}
		if yyb117 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj117-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTarget) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym119 := z.EncBinary()
		_ = yym119
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep120 := !z.EncBinary()
			yy2arr120 := z.EncBasicHandle().StructToArray
			var yyq120 [2]bool
			_, _, _ = yysep120, yyq120, yy2arr120
			const yyr120 bool = false
			var yynn120 int
			if yyr120 || yy2arr120 {
				r.EncodeArrayStart(2)
			} else {
				yynn120 = 2
				for _, b := range yyq120 {
					if b {
						yynn120++
					}
				}
				r.EncodeMapStart(yynn120)
				yynn120 = 0
			}
			if yyr120 || yy2arr120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym122 := z.EncBinary()
				_ = yym122
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym123 := z.EncBinary()
				_ = yym123
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr120 || yy2arr120 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy125 := &x.TargetValue
				yym126 := z.EncBinary()
				_ = yym126
				if false {
				} else if z.HasExtensions() && z.EncExt(yy125) {
				} else if !yym126 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy125)
				} else {
					z.EncFallback(yy125)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy127 := &x.TargetValue
				yym128 := z.EncBinary()
				_ = yym128
				if false {
				} else if z.HasExtensions() && z.EncExt(yy127) {
				} else if !yym128 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy127)
				} else {
					z.EncFallback(yy127)
				}
			}
			if yyr120 || yy2arr120 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTarget) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym129 := z.DecBinary()
	_ = yym129
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct130 := r.ContainerType()
		if yyct130 == codecSelferValueTypeMap1234 {
			yyl130 := r.ReadMapStart()
			if yyl130 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl130, d)
			}
		} else if yyct130 == codecSelferValueTypeArray1234 {
			yyl130 := r.ReadArrayStart()
			if yyl130 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl130, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTarget) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys131Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys131Slc
	var yyhl131 bool = l >= 0
	for yyj131 := 0; ; yyj131++ {
		if yyhl131 {
			if yyj131 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys131Slc = r.DecodeBytes(yys131Slc, true, true)
		yys131 := string(yys131Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys131 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.TargetValue = pkg4_resource.Quantity{}
			} else {
				yyv133 := &x.TargetValue
				yym134 := z.DecBinary()
				_ = yym134
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv133) {
				} else if !yym134 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv133)
				} else {
					z.DecFallback(yyv133, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys131)
		} // end switch yys131
	} // end for yyj131
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTarget) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj135 int
	var yyb135 bool
	var yyhl135 bool = l >= 0
	yyj135++
	if yyhl135 {
		yyb135 = yyj135 > l
	} else {
		yyb135 = r.CheckBreak()
	}
	if yyb135 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj135++
	if yyhl135 {
		yyb135 = yyj135 > l
	} else {
		yyb135 = r.CheckBreak()
	}
	if yyb135 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetValue = pkg4_resource.Quantity{}
	} else {
		yyv137 := &x.TargetValue
		yym138 := z.DecBinary()
		_ = yym138
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv137) {
		} else if !yym138 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv137)
		} else {
			z.DecFallback(yyv137, false)
		}
	}
	for {
		yyj135++
		if yyhl135 {
			yyb135 = yyj135 > l
		} else {
			yyb135 = r.CheckBreak()
		}
		if yyb135 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj135-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricTargetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym139 := z.EncBinary()
		_ = yym139
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep140 := !z.EncBinary()
			yy2arr140 := z.EncBasicHandle().StructToArray
			var yyq140 [1]bool
			_, _, _ = yysep140, yyq140, yy2arr140
			const yyr140 bool = false
			var yynn140 int
			if yyr140 || yy2arr140 {
				r.EncodeArrayStart(1)
			} else {
				yynn140 = 1
				for _, b := range yyq140 {
					if b {
						yynn140++
					}
				}
				r.EncodeMapStart(yynn140)
				yynn140 = 0
			}
			if yyr140 || yy2arr140 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym142 := z.EncBinary()
					_ = yym142
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym143 := z.EncBinary()
					_ = yym143
					if false {
					} else {
						h.encSliceCustomMetricTarget(([]CustomMetricTarget)(x.Items), e)
					}
				}
			}
			if yyr140 || yy2arr140 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricTargetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym144 := z.DecBinary()
	_ = yym144
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct145 := r.ContainerType()
		if yyct145 == codecSelferValueTypeMap1234 {
			yyl145 := r.ReadMapStart()
			if yyl145 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl145, d)
			}
		} else if yyct145 == codecSelferValueTypeArray1234 {
			yyl145 := r.ReadArrayStart()
			if yyl145 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl145, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricTargetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys146Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys146Slc
	var yyhl146 bool = l >= 0
	for yyj146 := 0; ; yyj146++ {
		if yyhl146 {
			if yyj146 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys146Slc = r.DecodeBytes(yys146Slc, true, true)
		yys146 := string(yys146Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys146 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv147 := &x.Items
				yym148 := z.DecBinary()
				_ = yym148
				if false {
				} else {
					h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv147), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys146)
		} // end switch yys146
	} // end for yyj146
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricTargetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj149 int
	var yyb149 bool
	var yyhl149 bool = l >= 0
	yyj149++
	if yyhl149 {
		yyb149 = yyj149 > l
	} else {
		yyb149 = r.CheckBreak()
	}
	if yyb149 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv150 := &x.Items
		yym151 := z.DecBinary()
		_ = yym151
		if false {
		} else {
			h.decSliceCustomMetricTarget((*[]CustomMetricTarget)(yyv150), d)
		}
	}
	for {
		yyj149++
		if yyhl149 {
			yyb149 = yyj149 > l
		} else {
			yyb149 = r.CheckBreak()
		}
		if yyb149 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj149-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym152 := z.EncBinary()
		_ = yym152
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep153 := !z.EncBinary()
			yy2arr153 := z.EncBasicHandle().StructToArray
			var yyq153 [2]bool
			_, _, _ = yysep153, yyq153, yy2arr153
			const yyr153 bool = false
			var yynn153 int
			if yyr153 || yy2arr153 {
				r.EncodeArrayStart(2)
			} else {
				yynn153 = 2
				for _, b := range yyq153 {
					if b {
						yynn153++
					}
				}
				r.EncodeMapStart(yynn153)
				yynn153 = 0
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym155 := z.EncBinary()
				_ = yym155
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym156 := z.EncBinary()
				_ = yym156
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy158 := &x.CurrentValue
				yym159 := z.EncBinary()
				_ = yym159
				if false {
				} else if z.HasExtensions() && z.EncExt(yy158) {
				} else if !yym159 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy158)
				} else {
					z.EncFallback(yy158)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy160 := &x.CurrentValue
				yym161 := z.EncBinary()
				_ = yym161
				if false {
				} else if z.HasExtensions() && z.EncExt(yy160) {
				} else if !yym161 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy160)
				} else {
					z.EncFallback(yy160)
				}
			}
			if yyr153 || yy2arr153 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym162 := z.DecBinary()
	_ = yym162
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct163 := r.ContainerType()
		if yyct163 == codecSelferValueTypeMap1234 {
			yyl163 := r.ReadMapStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl163, d)
			}
		} else if yyct163 == codecSelferValueTypeArray1234 {
			yyl163 := r.ReadArrayStart()
			if yyl163 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl163, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys164Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys164Slc
	var yyhl164 bool = l >= 0
	for yyj164 := 0; ; yyj164++ {
		if yyhl164 {
			if yyj164 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys164Slc = r.DecodeBytes(yys164Slc, true, true)
		yys164 := string(yys164Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys164 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.CurrentValue = pkg4_resource.Quantity{}
			} else {
				yyv166 := &x.CurrentValue
				yym167 := z.DecBinary()
				_ = yym167
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv166) {
				} else if !yym167 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv166)
				} else {
					z.DecFallback(yyv166, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys164)
		} // end switch yys164
	} // end for yyj164
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj168 int
	var yyb168 bool
	var yyhl168 bool = l >= 0
	yyj168++
	if yyhl168 {
		yyb168 = yyj168 > l
	} else {
		yyb168 = r.CheckBreak()
	}
	if yyb168 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj168++
	if yyhl168 {
		yyb168 = yyj168 > l
	} else {
		yyb168 = r.CheckBreak()
	}
	if yyb168 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentValue = pkg4_resource.Quantity{}
	} else {
		yyv170 := &x.CurrentValue
		yym171 := z.DecBinary()
		_ = yym171
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv170) {
		} else if !yym171 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv170)
		} else {
			z.DecFallback(yyv170, false)
		}
	}
	for {
		yyj168++
		if yyhl168 {
			yyb168 = yyj168 > l
		} else {
			yyb168 = r.CheckBreak()
		}
		if yyb168 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj168-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CustomMetricCurrentStatusList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym172 := z.EncBinary()
		_ = yym172
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep173 := !z.EncBinary()
			yy2arr173 := z.EncBasicHandle().StructToArray
			var yyq173 [1]bool
			_, _, _ = yysep173, yyq173, yy2arr173
			const yyr173 bool = false
			var yynn173 int
			if yyr173 || yy2arr173 {
				r.EncodeArrayStart(1)
			} else {
				yynn173 = 1
				for _, b := range yyq173 {
					if b {
						yynn173++
					}
				}
				r.EncodeMapStart(yynn173)
				yynn173 = 0
			}
			if yyr173 || yy2arr173 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym175 := z.EncBinary()
					_ = yym175
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym176 := z.EncBinary()
					_ = yym176
					if false {
					} else {
						h.encSliceCustomMetricCurrentStatus(([]CustomMetricCurrentStatus)(x.Items), e)
					}
				}
			}
			if yyr173 || yy2arr173 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CustomMetricCurrentStatusList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym177 := z.DecBinary()
	_ = yym177
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct178 := r.ContainerType()
		if yyct178 == codecSelferValueTypeMap1234 {
			yyl178 := r.ReadMapStart()
			if yyl178 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl178, d)
			}
		} else if yyct178 == codecSelferValueTypeArray1234 {
			yyl178 := r.ReadArrayStart()
			if yyl178 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl178, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys179Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys179Slc
	var yyhl179 bool = l >= 0
	for yyj179 := 0; ; yyj179++ {
		if yyhl179 {
			if yyj179 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys179Slc = r.DecodeBytes(yys179Slc, true, true)
		yys179 := string(yys179Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys179 {
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv180 := &x.Items
				yym181 := z.DecBinary()
				_ = yym181
				if false {
				} else {
					h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv180), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys179)
		} // end switch yys179
	} // end for yyj179
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CustomMetricCurrentStatusList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj182 int
	var yyb182 bool
	var yyhl182 bool = l >= 0
	yyj182++
	if yyhl182 {
		yyb182 = yyj182 > l
	} else {
		yyb182 = r.CheckBreak()
	}
	if yyb182 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv183 := &x.Items
		yym184 := z.DecBinary()
		_ = yym184
		if false {
		} else {
			h.decSliceCustomMetricCurrentStatus((*[]CustomMetricCurrentStatus)(yyv183), d)
		}
	}
	for {
		yyj182++
		if yyhl182 {
			yyb182 = yyj182 > l
		} else {
			yyb182 = r.CheckBreak()
		}
		if yyb182 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj182-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym185 := z.EncBinary()
		_ = yym185
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep186 := !z.EncBinary()
			yy2arr186 := z.EncBasicHandle().StructToArray
			var yyq186 [4]bool
			_, _, _ = yysep186, yyq186, yy2arr186
			const yyr186 bool = false
			yyq186[1] = x.MinReplicas != nil
			yyq186[3] = x.CPUUtilization != nil
			var yynn186 int
			if yyr186 || yy2arr186 {
				r.EncodeArrayStart(4)
			} else {
				yynn186 = 2
				for _, b := range yyq186 {
					if b {
						yynn186++
					}
				}
				r.EncodeMapStart(yynn186)
				yynn186 = 0
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy188 := &x.ScaleRef
				yy188.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("scaleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy189 := &x.ScaleRef
				yy189.CodecEncodeSelf(e)
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq186[1] {
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy191 := *x.MinReplicas
						yym192 := z.EncBinary()
						_ = yym192
						if false {
						} else {
							r.EncodeInt(int64(yy191))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq186[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy193 := *x.MinReplicas
						yym194 := z.EncBinary()
						_ = yym194
						if false {
						} else {
							r.EncodeInt(int64(yy193))
						}
					}
				}
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym196 := z.EncBinary()
				_ = yym196
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym197 := z.EncBinary()
				_ = yym197
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq186[3] {
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq186[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cpuUtilization"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CPUUtilization == nil {
						r.EncodeNil()
					} else {
						x.CPUUtilization.CodecEncodeSelf(e)
					}
				}
			}
			if yyr186 || yy2arr186 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym199 := z.DecBinary()
	_ = yym199
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct200 := r.ContainerType()
		if yyct200 == codecSelferValueTypeMap1234 {
			yyl200 := r.ReadMapStart()
			if yyl200 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl200, d)
			}
		} else if yyct200 == codecSelferValueTypeArray1234 {
			yyl200 := r.ReadArrayStart()
			if yyl200 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl200, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys201Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys201Slc
	var yyhl201 bool = l >= 0
	for yyj201 := 0; ; yyj201++ {
		if yyhl201 {
			if yyj201 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys201Slc = r.DecodeBytes(yys201Slc, true, true)
		yys201 := string(yys201Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys201 {
		case "scaleRef":
			if r.TryDecodeAsNil() {
				x.ScaleRef = SubresourceReference{}
			} else {
				yyv202 := &x.ScaleRef
				yyv202.CodecDecodeSelf(d)
			}
		case "minReplicas":
			if r.TryDecodeAsNil() {
				if x.MinReplicas != nil {
					x.MinReplicas = nil
				}
			} else {
				if x.MinReplicas == nil {
					x.MinReplicas = new(int32)
				}
				yym204 := z.DecBinary()
				_ = yym204
				if false {
				} else {
					*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
				}
			}
		case "maxReplicas":
			if r.TryDecodeAsNil() {
				x.MaxReplicas = 0
			} else {
				x.MaxReplicas = int32(r.DecodeInt(32))
			}
		case "cpuUtilization":
			if r.TryDecodeAsNil() {
				if x.CPUUtilization != nil {
					x.CPUUtilization = nil
				}
			} else {
				if x.CPUUtilization == nil {
					x.CPUUtilization = new(CPUTargetUtilization)
				}
				x.CPUUtilization.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys201)
		} // end switch yys201
	} // end for yyj201
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj207 int
	var yyb207 bool
	var yyhl207 bool = l >= 0
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ScaleRef = SubresourceReference{}
	} else {
		yyv208 := &x.ScaleRef
		yyv208.CodecDecodeSelf(d)
	}
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MinReplicas != nil {
			x.MinReplicas = nil
		}
	} else {
		if x.MinReplicas == nil {
			x.MinReplicas = new(int32)
		}
		yym210 := z.DecBinary()
		_ = yym210
		if false {
		} else {
			*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxReplicas = 0
	} else {
		x.MaxReplicas = int32(r.DecodeInt(32))
	}
	yyj207++
	if yyhl207 {
		yyb207 = yyj207 > l
	} else {
		yyb207 = r.CheckBreak()
	}
	if yyb207 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CPUUtilization != nil {
			x.CPUUtilization = nil
		}
	} else {
		if x.CPUUtilization == nil {
			x.CPUUtilization = new(CPUTargetUtilization)
		}
		x.CPUUtilization.CodecDecodeSelf(d)
	}
	for {
		yyj207++
		if yyhl207 {
			yyb207 = yyj207 > l
		} else {
			yyb207 = r.CheckBreak()
		}
		if yyb207 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj207-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym213 := z.EncBinary()
		_ = yym213
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep214 := !z.EncBinary()
			yy2arr214 := z.EncBasicHandle().StructToArray
			var yyq214 [5]bool
			_, _, _ = yysep214, yyq214, yy2arr214
			const yyr214 bool = false
			yyq214[0] = x.ObservedGeneration != nil
			yyq214[1] = x.LastScaleTime != nil
			yyq214[4] = x.CurrentCPUUtilizationPercentage != nil
			var yynn214 int
			if yyr214 || yy2arr214 {
				r.EncodeArrayStart(5)
			} else {
				yynn214 = 2
				for _, b := range yyq214 {
					if b {
						yynn214++
					}
				}
				r.EncodeMapStart(yynn214)
				yynn214 = 0
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq214[0] {
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy216 := *x.ObservedGeneration
						yym217 := z.EncBinary()
						_ = yym217
						if false {
						} else {
							r.EncodeInt(int64(yy216))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq214[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy218 := *x.ObservedGeneration
						yym219 := z.EncBinary()
						_ = yym219
						if false {
						} else {
							r.EncodeInt(int64(yy218))
						}
					}
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq214[1] {
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym221 := z.EncBinary()
						_ = yym221
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym221 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym221 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq214[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScaleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym222 := z.EncBinary()
						_ = yym222
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym222 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym222 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym224 := z.EncBinary()
				_ = yym224
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym225 := z.EncBinary()
				_ = yym225
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym227 := z.EncBinary()
				_ = yym227
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym228 := z.EncBinary()
				_ = yym228
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq214[4] {
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy230 := *x.CurrentCPUUtilizationPercentage
						yym231 := z.EncBinary()
						_ = yym231
						if false {
						} else {
							r.EncodeInt(int64(yy230))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq214[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("currentCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy232 := *x.CurrentCPUUtilizationPercentage
						yym233 := z.EncBinary()
						_ = yym233
						if false {
						} else {
							r.EncodeInt(int64(yy232))
						}
					}
				}
			}
			if yyr214 || yy2arr214 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym234 := z.DecBinary()
	_ = yym234
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct235 := r.ContainerType()
		if yyct235 == codecSelferValueTypeMap1234 {
			yyl235 := r.ReadMapStart()
			if yyl235 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl235, d)
			}
		} else if yyct235 == codecSelferValueTypeArray1234 {
			yyl235 := r.ReadArrayStart()
			if yyl235 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl235, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys236Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys236Slc
	var yyhl236 bool = l >= 0
	for yyj236 := 0; ; yyj236++ {
		if yyhl236 {
			if yyj236 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys236Slc = r.DecodeBytes(yys236Slc, true, true)
		yys236 := string(yys236Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys236 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				if x.ObservedGeneration != nil {
					x.ObservedGeneration = nil
				}
			} else {
				if x.ObservedGeneration == nil {
					x.ObservedGeneration = new(int64)
				}
				yym238 := z.DecBinary()
				_ = yym238
				if false {
				} else {
					*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
				}
			}
		case "lastScaleTime":
			if r.TryDecodeAsNil() {
				if x.LastScaleTime != nil {
					x.LastScaleTime = nil
				}
			} else {
				if x.LastScaleTime == nil {
					x.LastScaleTime = new(pkg1_unversioned.Time)
				}
				yym240 := z.DecBinary()
				_ = yym240
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
				} else if yym240 {
					z.DecBinaryUnmarshal(x.LastScaleTime)
				} else if !yym240 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScaleTime)
				} else {
					z.DecFallback(x.LastScaleTime, false)
				}
			}
		case "currentReplicas":
			if r.TryDecodeAsNil() {
				x.CurrentReplicas = 0
			} else {
				x.CurrentReplicas = int32(r.DecodeInt(32))
			}
		case "desiredReplicas":
			if r.TryDecodeAsNil() {
				x.DesiredReplicas = 0
			} else {
				x.DesiredReplicas = int32(r.DecodeInt(32))
			}
		case "currentCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.CurrentCPUUtilizationPercentage != nil {
					x.CurrentCPUUtilizationPercentage = nil
				}
			} else {
				if x.CurrentCPUUtilizationPercentage == nil {
					x.CurrentCPUUtilizationPercentage = new(int32)
				}
				yym244 := z.DecBinary()
				_ = yym244
				if false {
				} else {
					*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys236)
		} // end switch yys236
	} // end for yyj236
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj245 int
	var yyb245 bool
	var yyhl245 bool = l >= 0
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ObservedGeneration != nil {
			x.ObservedGeneration = nil
		}
	} else {
		if x.ObservedGeneration == nil {
			x.ObservedGeneration = new(int64)
		}
		yym247 := z.DecBinary()
		_ = yym247
		if false {
		} else {
			*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
		}
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScaleTime != nil {
			x.LastScaleTime = nil
		}
	} else {
		if x.LastScaleTime == nil {
			x.LastScaleTime = new(pkg1_unversioned.Time)
		}
		yym249 := z.DecBinary()
		_ = yym249
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
		} else if yym249 {
			z.DecBinaryUnmarshal(x.LastScaleTime)
		} else if !yym249 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScaleTime)
		} else {
			z.DecFallback(x.LastScaleTime, false)
		}
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentReplicas = 0
	} else {
		x.CurrentReplicas = int32(r.DecodeInt(32))
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredReplicas = 0
	} else {
		x.DesiredReplicas = int32(r.DecodeInt(32))
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CurrentCPUUtilizationPercentage != nil {
			x.CurrentCPUUtilizationPercentage = nil
		}
	} else {
		if x.CurrentCPUUtilizationPercentage == nil {
			x.CurrentCPUUtilizationPercentage = new(int32)
		}
		yym253 := z.DecBinary()
		_ = yym253
		if false {
		} else {
			*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj245++
		if yyhl245 {
			yyb245 = yyj245 > l
		} else {
			yyb245 = r.CheckBreak()
		}
		if yyb245 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj245-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym254 := z.EncBinary()
		_ = yym254
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep255 := !z.EncBinary()
			yy2arr255 := z.EncBasicHandle().StructToArray
			var yyq255 [5]bool
			_, _, _ = yysep255, yyq255, yy2arr255
			const yyr255 bool = false
			yyq255[0] = x.Kind != ""
			yyq255[1] = x.APIVersion != ""
			yyq255[2] = true
			yyq255[3] = true
			yyq255[4] = true
			var yynn255 int
			if yyr255 || yy2arr255 {
				r.EncodeArrayStart(5)
			} else {
				yynn255 = 0
				for _, b := range yyq255 {
					if b {
						yynn255++
					}
				}
				r.EncodeMapStart(yynn255)
				yynn255 = 0
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[0] {
					yym257 := z.EncBinary()
					_ = yym257
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq255[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym258 := z.EncBinary()
					_ = yym258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[1] {
					yym260 := z.EncBinary()
					_ = yym260
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq255[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym261 := z.EncBinary()
					_ = yym261
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[2] {
					yy263 := &x.ObjectMeta
					yy263.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq255[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy264 := &x.ObjectMeta
					yy264.CodecEncodeSelf(e)
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[3] {
					yy266 := &x.Spec
					yy266.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq255[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy267 := &x.Spec
					yy267.CodecEncodeSelf(e)
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq255[4] {
					yy269 := &x.Status
					yy269.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq255[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy270 := &x.Status
					yy270.CodecEncodeSelf(e)
				}
			}
			if yyr255 || yy2arr255 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym271 := z.DecBinary()
	_ = yym271
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct272 := r.ContainerType()
		if yyct272 == codecSelferValueTypeMap1234 {
			yyl272 := r.ReadMapStart()
			if yyl272 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl272, d)
			}
		} else if yyct272 == codecSelferValueTypeArray1234 {
			yyl272 := r.ReadArrayStart()
			if yyl272 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl272, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys273Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys273Slc
	var yyhl273 bool = l >= 0
	for yyj273 := 0; ; yyj273++ {
		if yyhl273 {
			if yyj273 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys273Slc = r.DecodeBytes(yys273Slc, true, true)
		yys273 := string(yys273Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys273 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv276 := &x.ObjectMeta
				yyv276.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = HorizontalPodAutoscalerSpec{}
			} else {
				yyv277 := &x.Spec
				yyv277.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = HorizontalPodAutoscalerStatus{}
			} else {
				yyv278 := &x.Status
				yyv278.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys273)
		} // end switch yys273
	} // end for yyj273
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj279 int
	var yyb279 bool
	var yyhl279 bool = l >= 0
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv282 := &x.ObjectMeta
		yyv282.CodecDecodeSelf(d)
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = HorizontalPodAutoscalerSpec{}
	} else {
		yyv283 := &x.Spec
		yyv283.CodecDecodeSelf(d)
	}
	yyj279++
	if yyhl279 {
		yyb279 = yyj279 > l
	} else {
		yyb279 = r.CheckBreak()
	}
	if yyb279 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = HorizontalPodAutoscalerStatus{}
	} else {
		yyv284 := &x.Status
		yyv284.CodecDecodeSelf(d)
	}
	for {
		yyj279++
		if yyhl279 {
			yyb279 = yyj279 > l
		} else {
			yyb279 = r.CheckBreak()
		}
		if yyb279 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj279-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym285 := z.EncBinary()
		_ = yym285
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep286 := !z.EncBinary()
			yy2arr286 := z.EncBasicHandle().StructToArray
			var yyq286 [4]bool
			_, _, _ = yysep286, yyq286, yy2arr286
			const yyr286 bool = false
			yyq286[0] = x.Kind != ""
			yyq286[1] = x.APIVersion != ""
			yyq286[2] = true
			var yynn286 int
			if yyr286 || yy2arr286 {
				r.EncodeArrayStart(4)
			} else {
				yynn286 = 1
				for _, b := range yyq286 {
					if b {
						yynn286++
					}
				}
				r.EncodeMapStart(yynn286)
				yynn286 = 0
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq286[0] {
					yym288 := z.EncBinary()
					_ = yym288
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq286[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym289 := z.EncBinary()
					_ = yym289
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq286[1] {
					yym291 := z.EncBinary()
					_ = yym291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq286[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym292 := z.EncBinary()
					_ = yym292
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq286[2] {
					yy294 := &x.ListMeta
					yym295 := z.EncBinary()
					_ = yym295
					if false {
					} else if z.HasExtensions() && z.EncExt(yy294) {
					} else {
						z.EncFallback(yy294)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq286[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy296 := &x.ListMeta
					yym297 := z.EncBinary()
					_ = yym297
					if false {
					} else if z.HasExtensions() && z.EncExt(yy296) {
					} else {
						z.EncFallback(yy296)
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym299 := z.EncBinary()
					_ = yym299
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym300 := z.EncBinary()
					_ = yym300
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr286 || yy2arr286 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym301 := z.DecBinary()
	_ = yym301
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct302 := r.ContainerType()
		if yyct302 == codecSelferValueTypeMap1234 {
			yyl302 := r.ReadMapStart()
			if yyl302 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl302, d)
			}
		} else if yyct302 == codecSelferValueTypeArray1234 {
			yyl302 := r.ReadArrayStart()
			if yyl302 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl302, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys303Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys303Slc
	var yyhl303 bool = l >= 0
	for yyj303 := 0; ; yyj303++ {
		if yyhl303 {
			if yyj303 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys303Slc = r.DecodeBytes(yys303Slc, true, true)
		yys303 := string(yys303Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys303 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv306 := &x.ListMeta
				yym307 := z.DecBinary()
				_ = yym307
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv306) {
				} else {
					z.DecFallback(yyv306, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv308 := &x.Items
				yym309 := z.DecBinary()
				_ = yym309
				if false {
				} else {
					h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv308), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys303)
		} // end switch yys303
	} // end for yyj303
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj310 int
	var yyb310 bool
	var yyhl310 bool = l >= 0
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv313 := &x.ListMeta
		yym314 := z.DecBinary()
		_ = yym314
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv313) {
		} else {
			z.DecFallback(yyv313, false)
		}
	}
	yyj310++
	if yyhl310 {
		yyb310 = yyj310 > l
	} else {
		yyb310 = r.CheckBreak()
	}
	if yyb310 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv315 := &x.Items
		yym316 := z.DecBinary()
		_ = yym316
		if false {
		} else {
			h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv315), d)
		}
	}
	for {
		yyj310++
		if yyhl310 {
			yyb310 = yyj310 > l
		} else {
			yyb310 = r.CheckBreak()
		}
		if yyb310 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj310-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym317 := z.EncBinary()
		_ = yym317
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep318 := !z.EncBinary()
			yy2arr318 := z.EncBasicHandle().StructToArray
			var yyq318 [5]bool
			_, _, _ = yysep318, yyq318, yy2arr318
			const yyr318 bool = false
			yyq318[0] = x.Kind != ""
			yyq318[1] = x.APIVersion != ""
			yyq318[2] = true
			yyq318[3] = x.Description != ""
			yyq318[4] = len(x.Versions) != 0
			var yynn318 int
			if yyr318 || yy2arr318 {
				r.EncodeArrayStart(5)
			} else {
				yynn318 = 0
				for _, b := range yyq318 {
					if b {
						yynn318++
					}
				}
				r.EncodeMapStart(yynn318)
				yynn318 = 0
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[0] {
					yym320 := z.EncBinary()
					_ = yym320
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq318[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym321 := z.EncBinary()
					_ = yym321
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[1] {
					yym323 := z.EncBinary()
					_ = yym323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq318[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym324 := z.EncBinary()
					_ = yym324
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[2] {
					yy326 := &x.ObjectMeta
					yy326.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq318[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy327 := &x.ObjectMeta
					yy327.CodecEncodeSelf(e)
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[3] {
					yym329 := z.EncBinary()
					_ = yym329
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq318[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("description"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym330 := z.EncBinary()
					_ = yym330
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Description))
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq318[4] {
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym332 := z.EncBinary()
						_ = yym332
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq318[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("versions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Versions == nil {
						r.EncodeNil()
					} else {
						yym333 := z.EncBinary()
						_ = yym333
						if false {
						} else {
							h.encSliceAPIVersion(([]APIVersion)(x.Versions), e)
						}
					}
				}
			}
			if yyr318 || yy2arr318 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym334 := z.DecBinary()
	_ = yym334
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct335 := r.ContainerType()
		if yyct335 == codecSelferValueTypeMap1234 {
			yyl335 := r.ReadMapStart()
			if yyl335 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl335, d)
			}
		} else if yyct335 == codecSelferValueTypeArray1234 {
			yyl335 := r.ReadArrayStart()
			if yyl335 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl335, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys336Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys336Slc
	var yyhl336 bool = l >= 0
	for yyj336 := 0; ; yyj336++ {
		if yyhl336 {
			if yyj336 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys336Slc = r.DecodeBytes(yys336Slc, true, true)
		yys336 := string(yys336Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys336 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv339 := &x.ObjectMeta
				yyv339.CodecDecodeSelf(d)
			}
		case "description":
			if r.TryDecodeAsNil() {
				x.Description = ""
			} else {
				x.Description = string(r.DecodeString())
			}
		case "versions":
			if r.TryDecodeAsNil() {
				x.Versions = nil
			} else {
				yyv341 := &x.Versions
				yym342 := z.DecBinary()
				_ = yym342
				if false {
				} else {
					h.decSliceAPIVersion((*[]APIVersion)(yyv341), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys336)
		} // end switch yys336
	} // end for yyj336
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj343 int
	var yyb343 bool
	var yyhl343 bool = l >= 0
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv346 := &x.ObjectMeta
		yyv346.CodecDecodeSelf(d)
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Description = ""
	} else {
		x.Description = string(r.DecodeString())
	}
	yyj343++
	if yyhl343 {
		yyb343 = yyj343 > l
	} else {
		yyb343 = r.CheckBreak()
	}
	if yyb343 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Versions = nil
	} else {
		yyv348 := &x.Versions
		yym349 := z.DecBinary()
		_ = yym349
		if false {
		} else {
			h.decSliceAPIVersion((*[]APIVersion)(yyv348), d)
		}
	}
	for {
		yyj343++
		if yyhl343 {
			yyb343 = yyj343 > l
		} else {
			yyb343 = r.CheckBreak()
		}
		if yyb343 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj343-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym350 := z.EncBinary()
		_ = yym350
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep351 := !z.EncBinary()
			yy2arr351 := z.EncBasicHandle().StructToArray
			var yyq351 [4]bool
			_, _, _ = yysep351, yyq351, yy2arr351
			const yyr351 bool = false
			yyq351[0] = x.Kind != ""
			yyq351[1] = x.APIVersion != ""
			yyq351[2] = true
			var yynn351 int
			if yyr351 || yy2arr351 {
				r.EncodeArrayStart(4)
			} else {
				yynn351 = 1
				for _, b := range yyq351 {
					if b {
						yynn351++
					}
				}
				r.EncodeMapStart(yynn351)
				yynn351 = 0
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[0] {
					yym353 := z.EncBinary()
					_ = yym353
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq351[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym354 := z.EncBinary()
					_ = yym354
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[1] {
					yym356 := z.EncBinary()
					_ = yym356
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq351[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym357 := z.EncBinary()
					_ = yym357
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq351[2] {
					yy359 := &x.ListMeta
					yym360 := z.EncBinary()
					_ = yym360
					if false {
					} else if z.HasExtensions() && z.EncExt(yy359) {
					} else {
						z.EncFallback(yy359)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq351[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy361 := &x.ListMeta
					yym362 := z.EncBinary()
					_ = yym362
					if false {
					} else if z.HasExtensions() && z.EncExt(yy361) {
					} else {
						z.EncFallback(yy361)
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym364 := z.EncBinary()
					_ = yym364
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym365 := z.EncBinary()
					_ = yym365
					if false {
					} else {
						h.encSliceThirdPartyResource(([]ThirdPartyResource)(x.Items), e)
					}
				}
			}
			if yyr351 || yy2arr351 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym366 := z.DecBinary()
	_ = yym366
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct367 := r.ContainerType()
		if yyct367 == codecSelferValueTypeMap1234 {
			yyl367 := r.ReadMapStart()
			if yyl367 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl367, d)
			}
		} else if yyct367 == codecSelferValueTypeArray1234 {
			yyl367 := r.ReadArrayStart()
			if yyl367 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl367, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys368Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys368Slc
	var yyhl368 bool = l >= 0
	for yyj368 := 0; ; yyj368++ {
		if yyhl368 {
			if yyj368 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys368Slc = r.DecodeBytes(yys368Slc, true, true)
		yys368 := string(yys368Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys368 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv371 := &x.ListMeta
				yym372 := z.DecBinary()
				_ = yym372
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv371) {
				} else {
					z.DecFallback(yyv371, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv373 := &x.Items
				yym374 := z.DecBinary()
				_ = yym374
				if false {
				} else {
					h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv373), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys368)
		} // end switch yys368
	} // end for yyj368
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj375 int
	var yyb375 bool
	var yyhl375 bool = l >= 0
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv378 := &x.ListMeta
		yym379 := z.DecBinary()
		_ = yym379
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv378) {
		} else {
			z.DecFallback(yyv378, false)
		}
	}
	yyj375++
	if yyhl375 {
		yyb375 = yyj375 > l
	} else {
		yyb375 = r.CheckBreak()
	}
	if yyb375 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv380 := &x.Items
		yym381 := z.DecBinary()
		_ = yym381
		if false {
		} else {
			h.decSliceThirdPartyResource((*[]ThirdPartyResource)(yyv380), d)
		}
	}
	for {
		yyj375++
		if yyhl375 {
			yyb375 = yyj375 > l
		} else {
			yyb375 = r.CheckBreak()
		}
		if yyb375 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj375-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *APIVersion) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym382 := z.EncBinary()
		_ = yym382
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep383 := !z.EncBinary()
			yy2arr383 := z.EncBasicHandle().StructToArray
			var yyq383 [1]bool
			_, _, _ = yysep383, yyq383, yy2arr383
			const yyr383 bool = false
			yyq383[0] = x.Name != ""
			var yynn383 int
			if yyr383 || yy2arr383 {
				r.EncodeArrayStart(1)
			} else {
				yynn383 = 0
				for _, b := range yyq383 {
					if b {
						yynn383++
					}
				}
				r.EncodeMapStart(yynn383)
				yynn383 = 0
			}
			if yyr383 || yy2arr383 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq383[0] {
					yym385 := z.EncBinary()
					_ = yym385
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq383[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym386 := z.EncBinary()
					_ = yym386
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr383 || yy2arr383 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *APIVersion) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym387 := z.DecBinary()
	_ = yym387
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct388 := r.ContainerType()
		if yyct388 == codecSelferValueTypeMap1234 {
			yyl388 := r.ReadMapStart()
			if yyl388 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl388, d)
			}
		} else if yyct388 == codecSelferValueTypeArray1234 {
			yyl388 := r.ReadArrayStart()
			if yyl388 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl388, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *APIVersion) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys389Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys389Slc
	var yyhl389 bool = l >= 0
	for yyj389 := 0; ; yyj389++ {
		if yyhl389 {
			if yyj389 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys389Slc = r.DecodeBytes(yys389Slc, true, true)
		yys389 := string(yys389Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys389 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys389)
		} // end switch yys389
	} // end for yyj389
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *APIVersion) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj391 int
	var yyb391 bool
	var yyhl391 bool = l >= 0
	yyj391++
	if yyhl391 {
		yyb391 = yyj391 > l
	} else {
		yyb391 = r.CheckBreak()
	}
	if yyb391 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj391++
		if yyhl391 {
			yyb391 = yyj391 > l
		} else {
			yyb391 = r.CheckBreak()
		}
		if yyb391 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj391-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceData) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym393 := z.EncBinary()
		_ = yym393
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep394 := !z.EncBinary()
			yy2arr394 := z.EncBasicHandle().StructToArray
			var yyq394 [4]bool
			_, _, _ = yysep394, yyq394, yy2arr394
			const yyr394 bool = false
			yyq394[0] = x.Kind != ""
			yyq394[1] = x.APIVersion != ""
			yyq394[2] = true
			yyq394[3] = len(x.Data) != 0
			var yynn394 int
			if yyr394 || yy2arr394 {
				r.EncodeArrayStart(4)
			} else {
				yynn394 = 0
				for _, b := range yyq394 {
					if b {
						yynn394++
					}
				}
				r.EncodeMapStart(yynn394)
				yynn394 = 0
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[0] {
					yym396 := z.EncBinary()
					_ = yym396
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq394[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym397 := z.EncBinary()
					_ = yym397
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[1] {
					yym399 := z.EncBinary()
					_ = yym399
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq394[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym400 := z.EncBinary()
					_ = yym400
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[2] {
					yy402 := &x.ObjectMeta
					yy402.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq394[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy403 := &x.ObjectMeta
					yy403.CodecEncodeSelf(e)
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq394[3] {
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym405 := z.EncBinary()
						_ = yym405
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq394[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("data"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Data == nil {
						r.EncodeNil()
					} else {
						yym406 := z.EncBinary()
						_ = yym406
						if false {
						} else {
							r.EncodeStringBytes(codecSelferC_RAW1234, []byte(x.Data))
						}
					}
				}
			}
			if yyr394 || yy2arr394 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceData) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym407 := z.DecBinary()
	_ = yym407
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct408 := r.ContainerType()
		if yyct408 == codecSelferValueTypeMap1234 {
			yyl408 := r.ReadMapStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl408, d)
			}
		} else if yyct408 == codecSelferValueTypeArray1234 {
			yyl408 := r.ReadArrayStart()
			if yyl408 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl408, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys409Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys409Slc
	var yyhl409 bool = l >= 0
	for yyj409 := 0; ; yyj409++ {
		if yyhl409 {
			if yyj409 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys409Slc = r.DecodeBytes(yys409Slc, true, true)
		yys409 := string(yys409Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys409 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv412 := &x.ObjectMeta
				yyv412.CodecDecodeSelf(d)
			}
		case "data":
			if r.TryDecodeAsNil() {
				x.Data = nil
			} else {
				yyv413 := &x.Data
				yym414 := z.DecBinary()
				_ = yym414
				if false {
				} else {
					*yyv413 = r.DecodeBytes(*(*[]byte)(yyv413), false, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys409)
		} // end switch yys409
	} // end for yyj409
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceData) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj415 int
	var yyb415 bool
	var yyhl415 bool = l >= 0
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv418 := &x.ObjectMeta
		yyv418.CodecDecodeSelf(d)
	}
	yyj415++
	if yyhl415 {
		yyb415 = yyj415 > l
	} else {
		yyb415 = r.CheckBreak()
	}
	if yyb415 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Data = nil
	} else {
		yyv419 := &x.Data
		yym420 := z.DecBinary()
		_ = yym420
		if false {
		} else {
			*yyv419 = r.DecodeBytes(*(*[]byte)(yyv419), false, false)
		}
	}
	for {
		yyj415++
		if yyhl415 {
			yyb415 = yyj415 > l
		} else {
			yyb415 = r.CheckBreak()
		}
		if yyb415 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj415-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Deployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym421 := z.EncBinary()
		_ = yym421
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep422 := !z.EncBinary()
			yy2arr422 := z.EncBasicHandle().StructToArray
			var yyq422 [5]bool
			_, _, _ = yysep422, yyq422, yy2arr422
			const yyr422 bool = false
			yyq422[0] = x.Kind != ""
			yyq422[1] = x.APIVersion != ""
			yyq422[2] = true
			yyq422[3] = true
			yyq422[4] = true
			var yynn422 int
			if yyr422 || yy2arr422 {
				r.EncodeArrayStart(5)
			} else {
				yynn422 = 0
				for _, b := range yyq422 {
					if b {
						yynn422++
					}
				}
				r.EncodeMapStart(yynn422)
				yynn422 = 0
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[0] {
					yym424 := z.EncBinary()
					_ = yym424
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq422[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym425 := z.EncBinary()
					_ = yym425
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[1] {
					yym427 := z.EncBinary()
					_ = yym427
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq422[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym428 := z.EncBinary()
					_ = yym428
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[2] {
					yy430 := &x.ObjectMeta
					yy430.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq422[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy431 := &x.ObjectMeta
					yy431.CodecEncodeSelf(e)
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[3] {
					yy433 := &x.Spec
					yy433.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq422[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy434 := &x.Spec
					yy434.CodecEncodeSelf(e)
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq422[4] {
					yy436 := &x.Status
					yy436.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq422[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy437 := &x.Status
					yy437.CodecEncodeSelf(e)
				}
			}
			if yyr422 || yy2arr422 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Deployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym438 := z.DecBinary()
	_ = yym438
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct439 := r.ContainerType()
		if yyct439 == codecSelferValueTypeMap1234 {
			yyl439 := r.ReadMapStart()
			if yyl439 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl439, d)
			}
		} else if yyct439 == codecSelferValueTypeArray1234 {
			yyl439 := r.ReadArrayStart()
			if yyl439 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl439, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Deployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys440Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys440Slc
	var yyhl440 bool = l >= 0
	for yyj440 := 0; ; yyj440++ {
		if yyhl440 {
			if yyj440 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys440Slc = r.DecodeBytes(yys440Slc, true, true)
		yys440 := string(yys440Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys440 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv443 := &x.ObjectMeta
				yyv443.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DeploymentSpec{}
			} else {
				yyv444 := &x.Spec
				yyv444.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DeploymentStatus{}
			} else {
				yyv445 := &x.Status
				yyv445.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys440)
		} // end switch yys440
	} // end for yyj440
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Deployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj446 int
	var yyb446 bool
	var yyhl446 bool = l >= 0
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv449 := &x.ObjectMeta
		yyv449.CodecDecodeSelf(d)
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DeploymentSpec{}
	} else {
		yyv450 := &x.Spec
		yyv450.CodecDecodeSelf(d)
	}
	yyj446++
	if yyhl446 {
		yyb446 = yyj446 > l
	} else {
		yyb446 = r.CheckBreak()
	}
	if yyb446 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DeploymentStatus{}
	} else {
		yyv451 := &x.Status
		yyv451.CodecDecodeSelf(d)
	}
	for {
		yyj446++
		if yyhl446 {
			yyb446 = yyj446 > l
		} else {
			yyb446 = r.CheckBreak()
		}
		if yyb446 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj446-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym452 := z.EncBinary()
		_ = yym452
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep453 := !z.EncBinary()
			yy2arr453 := z.EncBasicHandle().StructToArray
			var yyq453 [9]bool
			_, _, _ = yysep453, yyq453, yy2arr453
			const yyr453 bool = false
			yyq453[0] = x.Replicas != nil
			yyq453[1] = x.Selector != nil
			yyq453[3] = true
			yyq453[4] = x.MinReadySeconds != 0
			yyq453[5] = x.RevisionHistoryLimit != nil
			yyq453[6] = x.Paused != false
			yyq453[7] = x.RollbackTo != nil
			yyq453[8] = x.ProgressDeadlineSeconds != nil
			var yynn453 int
			if yyr453 || yy2arr453 {
				r.EncodeArrayStart(9)
			} else {
				yynn453 = 1
				for _, b := range yyq453 {
					if b {
						yynn453++
					}
				}
				r.EncodeMapStart(yynn453)
				yynn453 = 0
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy455 := *x.Replicas
						yym456 := z.EncBinary()
						_ = yym456
						if false {
						} else {
							r.EncodeInt(int64(yy455))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy457 := *x.Replicas
						yym458 := z.EncBinary()
						_ = yym458
						if false {
						} else {
							r.EncodeInt(int64(yy457))
						}
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym460 := z.EncBinary()
						_ = yym460
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym461 := z.EncBinary()
						_ = yym461
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy463 := &x.Template
				yy463.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy464 := &x.Template
				yy464.CodecEncodeSelf(e)
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[3] {
					yy466 := &x.Strategy
					yy466.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("strategy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy467 := &x.Strategy
					yy467.CodecEncodeSelf(e)
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[4] {
					yym469 := z.EncBinary()
					_ = yym469
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq453[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym470 := z.EncBinary()
					_ = yym470
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[5] {
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy472 := *x.RevisionHistoryLimit
						yym473 := z.EncBinary()
						_ = yym473
						if false {
						} else {
							r.EncodeInt(int64(yy472))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revisionHistoryLimit"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RevisionHistoryLimit == nil {
						r.EncodeNil()
					} else {
						yy474 := *x.RevisionHistoryLimit
						yym475 := z.EncBinary()
						_ = yym475
						if false {
						} else {
							r.EncodeInt(int64(yy474))
						}
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[6] {
					yym477 := z.EncBinary()
					_ = yym477
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq453[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("paused"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym478 := z.EncBinary()
					_ = yym478
					if false {
					} else {
						r.EncodeBool(bool(x.Paused))
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[7] {
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollbackTo == nil {
						r.EncodeNil()
					} else {
						x.RollbackTo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq453[8] {
					if x.ProgressDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy481 := *x.ProgressDeadlineSeconds
						yym482 := z.EncBinary()
						_ = yym482
						if false {
						} else {
							r.EncodeInt(int64(yy481))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq453[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("progressDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ProgressDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy483 := *x.ProgressDeadlineSeconds
						yym484 := z.EncBinary()
						_ = yym484
						if false {
						} else {
							r.EncodeInt(int64(yy483))
						}
					}
				}
			}
			if yyr453 || yy2arr453 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym485 := z.DecBinary()
	_ = yym485
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct486 := r.ContainerType()
		if yyct486 == codecSelferValueTypeMap1234 {
			yyl486 := r.ReadMapStart()
			if yyl486 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl486, d)
			}
		} else if yyct486 == codecSelferValueTypeArray1234 {
			yyl486 := r.ReadArrayStart()
			if yyl486 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl486, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys487Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys487Slc
	var yyhl487 bool = l >= 0
	for yyj487 := 0; ; yyj487++ {
		if yyhl487 {
			if yyj487 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys487Slc = r.DecodeBytes(yys487Slc, true, true)
		yys487 := string(yys487Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys487 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym489 := z.DecBinary()
				_ = yym489
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym491 := z.DecBinary()
				_ = yym491
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv492 := &x.Template
				yyv492.CodecDecodeSelf(d)
			}
		case "strategy":
			if r.TryDecodeAsNil() {
				x.Strategy = DeploymentStrategy{}
			} else {
				yyv493 := &x.Strategy
				yyv493.CodecDecodeSelf(d)
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "revisionHistoryLimit":
			if r.TryDecodeAsNil() {
				if x.RevisionHistoryLimit != nil {
					x.RevisionHistoryLimit = nil
				}
			} else {
				if x.RevisionHistoryLimit == nil {
					x.RevisionHistoryLimit = new(int32)
				}
				yym496 := z.DecBinary()
				_ = yym496
				if false {
				} else {
					*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
				}
			}
		case "paused":
			if r.TryDecodeAsNil() {
				x.Paused = false
			} else {
				x.Paused = bool(r.DecodeBool())
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				if x.RollbackTo != nil {
					x.RollbackTo = nil
				}
			} else {
				if x.RollbackTo == nil {
					x.RollbackTo = new(RollbackConfig)
				}
				x.RollbackTo.CodecDecodeSelf(d)
			}
		case "progressDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ProgressDeadlineSeconds != nil {
					x.ProgressDeadlineSeconds = nil
				}
			} else {
				if x.ProgressDeadlineSeconds == nil {
					x.ProgressDeadlineSeconds = new(int32)
				}
				yym500 := z.DecBinary()
				_ = yym500
				if false {
				} else {
					*((*int32)(x.ProgressDeadlineSeconds)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys487)
		} // end switch yys487
	} // end for yyj487
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj501 int
	var yyb501 bool
	var yyhl501 bool = l >= 0
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym503 := z.DecBinary()
		_ = yym503
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym505 := z.DecBinary()
		_ = yym505
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv506 := &x.Template
		yyv506.CodecDecodeSelf(d)
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Strategy = DeploymentStrategy{}
	} else {
		yyv507 := &x.Strategy
		yyv507.CodecDecodeSelf(d)
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RevisionHistoryLimit != nil {
			x.RevisionHistoryLimit = nil
		}
	} else {
		if x.RevisionHistoryLimit == nil {
			x.RevisionHistoryLimit = new(int32)
		}
		yym510 := z.DecBinary()
		_ = yym510
		if false {
		} else {
			*((*int32)(x.RevisionHistoryLimit)) = int32(r.DecodeInt(32))
		}
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paused = false
	} else {
		x.Paused = bool(r.DecodeBool())
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollbackTo != nil {
			x.RollbackTo = nil
		}
	} else {
		if x.RollbackTo == nil {
			x.RollbackTo = new(RollbackConfig)
		}
		x.RollbackTo.CodecDecodeSelf(d)
	}
	yyj501++
	if yyhl501 {
		yyb501 = yyj501 > l
	} else {
		yyb501 = r.CheckBreak()
	}
	if yyb501 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ProgressDeadlineSeconds != nil {
			x.ProgressDeadlineSeconds = nil
		}
	} else {
		if x.ProgressDeadlineSeconds == nil {
			x.ProgressDeadlineSeconds = new(int32)
		}
		yym514 := z.DecBinary()
		_ = yym514
		if false {
		} else {
			*((*int32)(x.ProgressDeadlineSeconds)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj501++
		if yyhl501 {
			yyb501 = yyj501 > l
		} else {
			yyb501 = r.CheckBreak()
		}
		if yyb501 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj501-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentRollback) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym515 := z.EncBinary()
		_ = yym515
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep516 := !z.EncBinary()
			yy2arr516 := z.EncBasicHandle().StructToArray
			var yyq516 [5]bool
			_, _, _ = yysep516, yyq516, yy2arr516
			const yyr516 bool = false
			yyq516[0] = x.Kind != ""
			yyq516[1] = x.APIVersion != ""
			yyq516[3] = len(x.UpdatedAnnotations) != 0
			var yynn516 int
			if yyr516 || yy2arr516 {
				r.EncodeArrayStart(5)
			} else {
				yynn516 = 2
				for _, b := range yyq516 {
					if b {
						yynn516++
					}
				}
				r.EncodeMapStart(yynn516)
				yynn516 = 0
			}
			if yyr516 || yy2arr516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq516[0] {
					yym518 := z.EncBinary()
					_ = yym518
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq516[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym519 := z.EncBinary()
					_ = yym519
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr516 || yy2arr516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq516[1] {
					yym521 := z.EncBinary()
					_ = yym521
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq516[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym522 := z.EncBinary()
					_ = yym522
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr516 || yy2arr516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym524 := z.EncBinary()
				_ = yym524
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym525 := z.EncBinary()
				_ = yym525
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr516 || yy2arr516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq516[3] {
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym527 := z.EncBinary()
						_ = yym527
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq516[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedAnnotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.UpdatedAnnotations == nil {
						r.EncodeNil()
					} else {
						yym528 := z.EncBinary()
						_ = yym528
						if false {
						} else {
							z.F.EncMapStringStringV(x.UpdatedAnnotations, false, e)
						}
					}
				}
			}
			if yyr516 || yy2arr516 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy530 := &x.RollbackTo
				yy530.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rollbackTo"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy531 := &x.RollbackTo
				yy531.CodecEncodeSelf(e)
			}
			if yyr516 || yy2arr516 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentRollback) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym532 := z.DecBinary()
	_ = yym532
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct533 := r.ContainerType()
		if yyct533 == codecSelferValueTypeMap1234 {
			yyl533 := r.ReadMapStart()
			if yyl533 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl533, d)
			}
		} else if yyct533 == codecSelferValueTypeArray1234 {
			yyl533 := r.ReadArrayStart()
			if yyl533 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl533, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentRollback) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys534Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys534Slc
	var yyhl534 bool = l >= 0
	for yyj534 := 0; ; yyj534++ {
		if yyhl534 {
			if yyj534 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys534Slc = r.DecodeBytes(yys534Slc, true, true)
		yys534 := string(yys534Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys534 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "updatedAnnotations":
			if r.TryDecodeAsNil() {
				x.UpdatedAnnotations = nil
			} else {
				yyv538 := &x.UpdatedAnnotations
				yym539 := z.DecBinary()
				_ = yym539
				if false {
				} else {
					z.F.DecMapStringStringX(yyv538, false, d)
				}
			}
		case "rollbackTo":
			if r.TryDecodeAsNil() {
				x.RollbackTo = RollbackConfig{}
			} else {
				yyv540 := &x.RollbackTo
				yyv540.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys534)
		} // end switch yys534
	} // end for yyj534
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentRollback) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj541 int
	var yyb541 bool
	var yyhl541 bool = l >= 0
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedAnnotations = nil
	} else {
		yyv545 := &x.UpdatedAnnotations
		yym546 := z.DecBinary()
		_ = yym546
		if false {
		} else {
			z.F.DecMapStringStringX(yyv545, false, d)
		}
	}
	yyj541++
	if yyhl541 {
		yyb541 = yyj541 > l
	} else {
		yyb541 = r.CheckBreak()
	}
	if yyb541 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RollbackTo = RollbackConfig{}
	} else {
		yyv547 := &x.RollbackTo
		yyv547.CodecDecodeSelf(d)
	}
	for {
		yyj541++
		if yyhl541 {
			yyb541 = yyj541 > l
		} else {
			yyb541 = r.CheckBreak()
		}
		if yyb541 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj541-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RollbackConfig) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym548 := z.EncBinary()
		_ = yym548
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep549 := !z.EncBinary()
			yy2arr549 := z.EncBasicHandle().StructToArray
			var yyq549 [1]bool
			_, _, _ = yysep549, yyq549, yy2arr549
			const yyr549 bool = false
			yyq549[0] = x.Revision != 0
			var yynn549 int
			if yyr549 || yy2arr549 {
				r.EncodeArrayStart(1)
			} else {
				yynn549 = 0
				for _, b := range yyq549 {
					if b {
						yynn549++
					}
				}
				r.EncodeMapStart(yynn549)
				yynn549 = 0
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq549[0] {
					yym551 := z.EncBinary()
					_ = yym551
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq549[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym552 := z.EncBinary()
					_ = yym552
					if false {
					} else {
						r.EncodeInt(int64(x.Revision))
					}
				}
			}
			if yyr549 || yy2arr549 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollbackConfig) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym553 := z.DecBinary()
	_ = yym553
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct554 := r.ContainerType()
		if yyct554 == codecSelferValueTypeMap1234 {
			yyl554 := r.ReadMapStart()
			if yyl554 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl554, d)
			}
		} else if yyct554 == codecSelferValueTypeArray1234 {
			yyl554 := r.ReadArrayStart()
			if yyl554 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl554, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollbackConfig) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys555Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys555Slc
	var yyhl555 bool = l >= 0
	for yyj555 := 0; ; yyj555++ {
		if yyhl555 {
			if yyj555 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys555Slc = r.DecodeBytes(yys555Slc, true, true)
		yys555 := string(yys555Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys555 {
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = 0
			} else {
				x.Revision = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys555)
		} // end switch yys555
	} // end for yyj555
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollbackConfig) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj557 int
	var yyb557 bool
	var yyhl557 bool = l >= 0
	yyj557++
	if yyhl557 {
		yyb557 = yyj557 > l
	} else {
		yyb557 = r.CheckBreak()
	}
	if yyb557 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = 0
	} else {
		x.Revision = int64(r.DecodeInt(64))
	}
	for {
		yyj557++
		if yyhl557 {
			yyb557 = yyj557 > l
		} else {
			yyb557 = r.CheckBreak()
		}
		if yyb557 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj557-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym559 := z.EncBinary()
		_ = yym559
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep560 := !z.EncBinary()
			yy2arr560 := z.EncBasicHandle().StructToArray
			var yyq560 [2]bool
			_, _, _ = yysep560, yyq560, yy2arr560
			const yyr560 bool = false
			yyq560[0] = x.Type != ""
			yyq560[1] = x.RollingUpdate != nil
			var yynn560 int
			if yyr560 || yy2arr560 {
				r.EncodeArrayStart(2)
			} else {
				yynn560 = 0
				for _, b := range yyq560 {
					if b {
						yynn560++
					}
				}
				r.EncodeMapStart(yynn560)
				yynn560 = 0
			}
			if yyr560 || yy2arr560 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq560[0] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq560[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr560 || yy2arr560 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq560[1] {
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq560[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rollingUpdate"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RollingUpdate == nil {
						r.EncodeNil()
					} else {
						x.RollingUpdate.CodecEncodeSelf(e)
					}
				}
			}
			if yyr560 || yy2arr560 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym563 := z.DecBinary()
	_ = yym563
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct564 := r.ContainerType()
		if yyct564 == codecSelferValueTypeMap1234 {
			yyl564 := r.ReadMapStart()
			if yyl564 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl564, d)
			}
		} else if yyct564 == codecSelferValueTypeArray1234 {
			yyl564 := r.ReadArrayStart()
			if yyl564 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl564, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStrategy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys565Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys565Slc
	var yyhl565 bool = l >= 0
	for yyj565 := 0; ; yyj565++ {
		if yyhl565 {
			if yyj565 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys565Slc = r.DecodeBytes(yys565Slc, true, true)
		yys565 := string(yys565Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys565 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentStrategyType(r.DecodeString())
			}
		case "rollingUpdate":
			if r.TryDecodeAsNil() {
				if x.RollingUpdate != nil {
					x.RollingUpdate = nil
				}
			} else {
				if x.RollingUpdate == nil {
					x.RollingUpdate = new(RollingUpdateDeployment)
				}
				x.RollingUpdate.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys565)
		} // end switch yys565
	} // end for yyj565
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStrategy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj568 int
	var yyb568 bool
	var yyhl568 bool = l >= 0
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentStrategyType(r.DecodeString())
	}
	yyj568++
	if yyhl568 {
		yyb568 = yyj568 > l
	} else {
		yyb568 = r.CheckBreak()
	}
	if yyb568 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RollingUpdate != nil {
			x.RollingUpdate = nil
		}
	} else {
		if x.RollingUpdate == nil {
			x.RollingUpdate = new(RollingUpdateDeployment)
		}
		x.RollingUpdate.CodecDecodeSelf(d)
	}
	for {
		yyj568++
		if yyhl568 {
			yyb568 = yyj568 > l
		} else {
			yyb568 = r.CheckBreak()
		}
		if yyb568 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj568-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym571 := z.EncBinary()
	_ = yym571
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym572 := z.DecBinary()
	_ = yym572
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RollingUpdateDeployment) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym573 := z.EncBinary()
		_ = yym573
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep574 := !z.EncBinary()
			yy2arr574 := z.EncBasicHandle().StructToArray
			var yyq574 [2]bool
			_, _, _ = yysep574, yyq574, yy2arr574
			const yyr574 bool = false
			yyq574[0] = x.MaxUnavailable != nil
			yyq574[1] = x.MaxSurge != nil
			var yynn574 int
			if yyr574 || yy2arr574 {
				r.EncodeArrayStart(2)
			} else {
				yynn574 = 0
				for _, b := range yyq574 {
					if b {
						yynn574++
					}
				}
				r.EncodeMapStart(yynn574)
				yynn574 = 0
			}
			if yyr574 || yy2arr574 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq574[0] {
					if x.MaxUnavailable == nil {
						r.EncodeNil()
					} else {
						yym576 := z.EncBinary()
						_ = yym576
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxUnavailable) {
						} else if !yym576 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxUnavailable)
						} else {
							z.EncFallback(x.MaxUnavailable)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq574[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxUnavailable"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxUnavailable == nil {
						r.EncodeNil()
					} else {
						yym577 := z.EncBinary()
						_ = yym577
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxUnavailable) {
						} else if !yym577 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxUnavailable)
						} else {
							z.EncFallback(x.MaxUnavailable)
						}
					}
				}
			}
			if yyr574 || yy2arr574 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq574[1] {
					if x.MaxSurge == nil {
						r.EncodeNil()
					} else {
						yym579 := z.EncBinary()
						_ = yym579
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxSurge) {
						} else if !yym579 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxSurge)
						} else {
							z.EncFallback(x.MaxSurge)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq574[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("maxSurge"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MaxSurge == nil {
						r.EncodeNil()
					} else {
						yym580 := z.EncBinary()
						_ = yym580
						if false {
						} else if z.HasExtensions() && z.EncExt(x.MaxSurge) {
						} else if !yym580 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.MaxSurge)
						} else {
							z.EncFallback(x.MaxSurge)
						}
					}
				}
			}
			if yyr574 || yy2arr574 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RollingUpdateDeployment) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym581 := z.DecBinary()
	_ = yym581
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct582 := r.ContainerType()
		if yyct582 == codecSelferValueTypeMap1234 {
			yyl582 := r.ReadMapStart()
			if yyl582 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl582, d)
			}
		} else if yyct582 == codecSelferValueTypeArray1234 {
			yyl582 := r.ReadArrayStart()
			if yyl582 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl582, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys583Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys583Slc
	var yyhl583 bool = l >= 0
	for yyj583 := 0; ; yyj583++ {
		if yyhl583 {
			if yyj583 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys583Slc = r.DecodeBytes(yys583Slc, true, true)
		yys583 := string(yys583Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys583 {
		case "maxUnavailable":
			if r.TryDecodeAsNil() {
				if x.MaxUnavailable != nil {
					x.MaxUnavailable = nil
				}
			} else {
				if x.MaxUnavailable == nil {
					x.MaxUnavailable = new(pkg5_intstr.IntOrString)
				}
				yym585 := z.DecBinary()
				_ = yym585
				if false {
				} else if z.HasExtensions() && z.DecExt(x.MaxUnavailable) {
				} else if !yym585 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.MaxUnavailable)
				} else {
					z.DecFallback(x.MaxUnavailable, false)
				}
			}
		case "maxSurge":
			if r.TryDecodeAsNil() {
				if x.MaxSurge != nil {
					x.MaxSurge = nil
				}
			} else {
				if x.MaxSurge == nil {
					x.MaxSurge = new(pkg5_intstr.IntOrString)
				}
				yym587 := z.DecBinary()
				_ = yym587
				if false {
				} else if z.HasExtensions() && z.DecExt(x.MaxSurge) {
				} else if !yym587 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.MaxSurge)
				} else {
					z.DecFallback(x.MaxSurge, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys583)
		} // end switch yys583
	} // end for yyj583
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RollingUpdateDeployment) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj588 int
	var yyb588 bool
	var yyhl588 bool = l >= 0
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MaxUnavailable != nil {
			x.MaxUnavailable = nil
		}
	} else {
		if x.MaxUnavailable == nil {
			x.MaxUnavailable = new(pkg5_intstr.IntOrString)
		}
		yym590 := z.DecBinary()
		_ = yym590
		if false {
		} else if z.HasExtensions() && z.DecExt(x.MaxUnavailable) {
		} else if !yym590 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.MaxUnavailable)
		} else {
			z.DecFallback(x.MaxUnavailable, false)
		}
	}
	yyj588++
	if yyhl588 {
		yyb588 = yyj588 > l
	} else {
		yyb588 = r.CheckBreak()
	}
	if yyb588 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MaxSurge != nil {
			x.MaxSurge = nil
		}
	} else {
		if x.MaxSurge == nil {
			x.MaxSurge = new(pkg5_intstr.IntOrString)
		}
		yym592 := z.DecBinary()
		_ = yym592
		if false {
		} else if z.HasExtensions() && z.DecExt(x.MaxSurge) {
		} else if !yym592 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.MaxSurge)
		} else {
			z.DecFallback(x.MaxSurge, false)
		}
	}
	for {
		yyj588++
		if yyhl588 {
			yyb588 = yyj588 > l
		} else {
			yyb588 = r.CheckBreak()
		}
		if yyb588 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj588-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym593 := z.EncBinary()
		_ = yym593
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep594 := !z.EncBinary()
			yy2arr594 := z.EncBasicHandle().StructToArray
			var yyq594 [6]bool
			_, _, _ = yysep594, yyq594, yy2arr594
			const yyr594 bool = false
			yyq594[0] = x.ObservedGeneration != 0
			yyq594[1] = x.Replicas != 0
			yyq594[2] = x.UpdatedReplicas != 0
			yyq594[3] = x.AvailableReplicas != 0
			yyq594[4] = x.UnavailableReplicas != 0
			yyq594[5] = len(x.Conditions) != 0
			var yynn594 int
			if yyr594 || yy2arr594 {
				r.EncodeArrayStart(6)
			} else {
				yynn594 = 0
				for _, b := range yyq594 {
					if b {
						yynn594++
					}
				}
				r.EncodeMapStart(yynn594)
				yynn594 = 0
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq594[0] {
					yym596 := z.EncBinary()
					_ = yym596
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq594[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym597 := z.EncBinary()
					_ = yym597
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq594[1] {
					yym599 := z.EncBinary()
					_ = yym599
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq594[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym600 := z.EncBinary()
					_ = yym600
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq594[2] {
					yym602 := z.EncBinary()
					_ = yym602
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq594[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("updatedReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym603 := z.EncBinary()
					_ = yym603
					if false {
					} else {
						r.EncodeInt(int64(x.UpdatedReplicas))
					}
				}
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq594[3] {
					yym605 := z.EncBinary()
					_ = yym605
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq594[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym606 := z.EncBinary()
					_ = yym606
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq594[4] {
					yym608 := z.EncBinary()
					_ = yym608
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq594[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("unavailableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym609 := z.EncBinary()
					_ = yym609
					if false {
					} else {
						r.EncodeInt(int64(x.UnavailableReplicas))
					}
				}
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq594[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym611 := z.EncBinary()
						_ = yym611
						if false {
						} else {
							h.encSliceDeploymentCondition(([]DeploymentCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq594[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym612 := z.EncBinary()
						_ = yym612
						if false {
						} else {
							h.encSliceDeploymentCondition(([]DeploymentCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr594 || yy2arr594 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym613 := z.DecBinary()
	_ = yym613
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct614 := r.ContainerType()
		if yyct614 == codecSelferValueTypeMap1234 {
			yyl614 := r.ReadMapStart()
			if yyl614 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl614, d)
			}
		} else if yyct614 == codecSelferValueTypeArray1234 {
			yyl614 := r.ReadArrayStart()
			if yyl614 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl614, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys615Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys615Slc
	var yyhl615 bool = l >= 0
	for yyj615 := 0; ; yyj615++ {
		if yyhl615 {
			if yyj615 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys615Slc = r.DecodeBytes(yys615Slc, true, true)
		yys615 := string(yys615Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys615 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "updatedReplicas":
			if r.TryDecodeAsNil() {
				x.UpdatedReplicas = 0
			} else {
				x.UpdatedReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "unavailableReplicas":
			if r.TryDecodeAsNil() {
				x.UnavailableReplicas = 0
			} else {
				x.UnavailableReplicas = int32(r.DecodeInt(32))
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv621 := &x.Conditions
				yym622 := z.DecBinary()
				_ = yym622
				if false {
				} else {
					h.decSliceDeploymentCondition((*[]DeploymentCondition)(yyv621), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys615)
		} // end switch yys615
	} // end for yyj615
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj623 int
	var yyb623 bool
	var yyhl623 bool = l >= 0
	yyj623++
	if yyhl623 {
		yyb623 = yyj623 > l
	} else {
		yyb623 = r.CheckBreak()
	}
	if yyb623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj623++
	if yyhl623 {
		yyb623 = yyj623 > l
	} else {
		yyb623 = r.CheckBreak()
	}
	if yyb623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj623++
	if yyhl623 {
		yyb623 = yyj623 > l
	} else {
		yyb623 = r.CheckBreak()
	}
	if yyb623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UpdatedReplicas = 0
	} else {
		x.UpdatedReplicas = int32(r.DecodeInt(32))
	}
	yyj623++
	if yyhl623 {
		yyb623 = yyj623 > l
	} else {
		yyb623 = r.CheckBreak()
	}
	if yyb623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj623++
	if yyhl623 {
		yyb623 = yyj623 > l
	} else {
		yyb623 = r.CheckBreak()
	}
	if yyb623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UnavailableReplicas = 0
	} else {
		x.UnavailableReplicas = int32(r.DecodeInt(32))
	}
	yyj623++
	if yyhl623 {
		yyb623 = yyj623 > l
	} else {
		yyb623 = r.CheckBreak()
	}
	if yyb623 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv629 := &x.Conditions
		yym630 := z.DecBinary()
		_ = yym630
		if false {
		} else {
			h.decSliceDeploymentCondition((*[]DeploymentCondition)(yyv629), d)
		}
	}
	for {
		yyj623++
		if yyhl623 {
			yyb623 = yyj623 > l
		} else {
			yyb623 = r.CheckBreak()
		}
		if yyb623 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj623-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x DeploymentConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym631 := z.EncBinary()
	_ = yym631
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DeploymentConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym632 := z.DecBinary()
	_ = yym632
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *DeploymentCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym633 := z.EncBinary()
		_ = yym633
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep634 := !z.EncBinary()
			yy2arr634 := z.EncBasicHandle().StructToArray
			var yyq634 [6]bool
			_, _, _ = yysep634, yyq634, yy2arr634
			const yyr634 bool = false
			yyq634[2] = true
			yyq634[3] = true
			yyq634[4] = x.Reason != ""
			yyq634[5] = x.Message != ""
			var yynn634 int
			if yyr634 || yy2arr634 {
				r.EncodeArrayStart(6)
			} else {
				yynn634 = 2
				for _, b := range yyq634 {
					if b {
						yynn634++
					}
				}
				r.EncodeMapStart(yynn634)
				yynn634 = 0
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym637 := z.EncBinary()
				_ = yym637
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym638 := z.EncBinary()
				_ = yym638
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq634[2] {
					yy640 := &x.LastUpdateTime
					yym641 := z.EncBinary()
					_ = yym641
					if false {
					} else if z.HasExtensions() && z.EncExt(yy640) {
					} else if yym641 {
						z.EncBinaryMarshal(yy640)
					} else if !yym641 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy640)
					} else {
						z.EncFallback(yy640)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq634[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastUpdateTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy642 := &x.LastUpdateTime
					yym643 := z.EncBinary()
					_ = yym643
					if false {
					} else if z.HasExtensions() && z.EncExt(yy642) {
					} else if yym643 {
						z.EncBinaryMarshal(yy642)
					} else if !yym643 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy642)
					} else {
						z.EncFallback(yy642)
					}
				}
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq634[3] {
					yy645 := &x.LastTransitionTime
					yym646 := z.EncBinary()
					_ = yym646
					if false {
					} else if z.HasExtensions() && z.EncExt(yy645) {
					} else if yym646 {
						z.EncBinaryMarshal(yy645)
					} else if !yym646 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy645)
					} else {
						z.EncFallback(yy645)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq634[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy647 := &x.LastTransitionTime
					yym648 := z.EncBinary()
					_ = yym648
					if false {
					} else if z.HasExtensions() && z.EncExt(yy647) {
					} else if yym648 {
						z.EncBinaryMarshal(yy647)
					} else if !yym648 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy647)
					} else {
						z.EncFallback(yy647)
					}
				}
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq634[4] {
					yym650 := z.EncBinary()
					_ = yym650
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq634[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym651 := z.EncBinary()
					_ = yym651
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq634[5] {
					yym653 := z.EncBinary()
					_ = yym653
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq634[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym654 := z.EncBinary()
					_ = yym654
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr634 || yy2arr634 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym655 := z.DecBinary()
	_ = yym655
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct656 := r.ContainerType()
		if yyct656 == codecSelferValueTypeMap1234 {
			yyl656 := r.ReadMapStart()
			if yyl656 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl656, d)
			}
		} else if yyct656 == codecSelferValueTypeArray1234 {
			yyl656 := r.ReadArrayStart()
			if yyl656 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl656, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys657Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys657Slc
	var yyhl657 bool = l >= 0
	for yyj657 := 0; ; yyj657++ {
		if yyhl657 {
			if yyj657 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys657Slc = r.DecodeBytes(yys657Slc, true, true)
		yys657 := string(yys657Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys657 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = DeploymentConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastUpdateTime":
			if r.TryDecodeAsNil() {
				x.LastUpdateTime = pkg1_unversioned.Time{}
			} else {
				yyv660 := &x.LastUpdateTime
				yym661 := z.DecBinary()
				_ = yym661
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv660) {
				} else if yym661 {
					z.DecBinaryUnmarshal(yyv660)
				} else if !yym661 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv660)
				} else {
					z.DecFallback(yyv660, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv662 := &x.LastTransitionTime
				yym663 := z.DecBinary()
				_ = yym663
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv662) {
				} else if yym663 {
					z.DecBinaryUnmarshal(yyv662)
				} else if !yym663 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv662)
				} else {
					z.DecFallback(yyv662, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys657)
		} // end switch yys657
	} // end for yyj657
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj666 int
	var yyb666 bool
	var yyhl666 bool = l >= 0
	yyj666++
	if yyhl666 {
		yyb666 = yyj666 > l
	} else {
		yyb666 = r.CheckBreak()
	}
	if yyb666 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = DeploymentConditionType(r.DecodeString())
	}
	yyj666++
	if yyhl666 {
		yyb666 = yyj666 > l
	} else {
		yyb666 = r.CheckBreak()
	}
	if yyb666 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj666++
	if yyhl666 {
		yyb666 = yyj666 > l
	} else {
		yyb666 = r.CheckBreak()
	}
	if yyb666 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastUpdateTime = pkg1_unversioned.Time{}
	} else {
		yyv669 := &x.LastUpdateTime
		yym670 := z.DecBinary()
		_ = yym670
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv669) {
		} else if yym670 {
			z.DecBinaryUnmarshal(yyv669)
		} else if !yym670 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv669)
		} else {
			z.DecFallback(yyv669, false)
		}
	}
	yyj666++
	if yyhl666 {
		yyb666 = yyj666 > l
	} else {
		yyb666 = r.CheckBreak()
	}
	if yyb666 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv671 := &x.LastTransitionTime
		yym672 := z.DecBinary()
		_ = yym672
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv671) {
		} else if yym672 {
			z.DecBinaryUnmarshal(yyv671)
		} else if !yym672 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv671)
		} else {
			z.DecFallback(yyv671, false)
		}
	}
	yyj666++
	if yyhl666 {
		yyb666 = yyj666 > l
	} else {
		yyb666 = r.CheckBreak()
	}
	if yyb666 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj666++
	if yyhl666 {
		yyb666 = yyj666 > l
	} else {
		yyb666 = r.CheckBreak()
	}
	if yyb666 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj666++
		if yyhl666 {
			yyb666 = yyj666 > l
		} else {
			yyb666 = r.CheckBreak()
		}
		if yyb666 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj666-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DeploymentList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym675 := z.EncBinary()
		_ = yym675
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep676 := !z.EncBinary()
			yy2arr676 := z.EncBasicHandle().StructToArray
			var yyq676 [4]bool
			_, _, _ = yysep676, yyq676, yy2arr676
			const yyr676 bool = false
			yyq676[0] = x.Kind != ""
			yyq676[1] = x.APIVersion != ""
			yyq676[2] = true
			var yynn676 int
			if yyr676 || yy2arr676 {
				r.EncodeArrayStart(4)
			} else {
				yynn676 = 1
				for _, b := range yyq676 {
					if b {
						yynn676++
					}
				}
				r.EncodeMapStart(yynn676)
				yynn676 = 0
			}
			if yyr676 || yy2arr676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq676[0] {
					yym678 := z.EncBinary()
					_ = yym678
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq676[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym679 := z.EncBinary()
					_ = yym679
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr676 || yy2arr676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq676[1] {
					yym681 := z.EncBinary()
					_ = yym681
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq676[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym682 := z.EncBinary()
					_ = yym682
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr676 || yy2arr676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq676[2] {
					yy684 := &x.ListMeta
					yym685 := z.EncBinary()
					_ = yym685
					if false {
					} else if z.HasExtensions() && z.EncExt(yy684) {
					} else {
						z.EncFallback(yy684)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq676[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy686 := &x.ListMeta
					yym687 := z.EncBinary()
					_ = yym687
					if false {
					} else if z.HasExtensions() && z.EncExt(yy686) {
					} else {
						z.EncFallback(yy686)
					}
				}
			}
			if yyr676 || yy2arr676 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym689 := z.EncBinary()
					_ = yym689
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym690 := z.EncBinary()
					_ = yym690
					if false {
					} else {
						h.encSliceDeployment(([]Deployment)(x.Items), e)
					}
				}
			}
			if yyr676 || yy2arr676 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DeploymentList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym691 := z.DecBinary()
	_ = yym691
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct692 := r.ContainerType()
		if yyct692 == codecSelferValueTypeMap1234 {
			yyl692 := r.ReadMapStart()
			if yyl692 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl692, d)
			}
		} else if yyct692 == codecSelferValueTypeArray1234 {
			yyl692 := r.ReadArrayStart()
			if yyl692 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl692, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DeploymentList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys693Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys693Slc
	var yyhl693 bool = l >= 0
	for yyj693 := 0; ; yyj693++ {
		if yyhl693 {
			if yyj693 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys693Slc = r.DecodeBytes(yys693Slc, true, true)
		yys693 := string(yys693Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys693 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv696 := &x.ListMeta
				yym697 := z.DecBinary()
				_ = yym697
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv696) {
				} else {
					z.DecFallback(yyv696, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv698 := &x.Items
				yym699 := z.DecBinary()
				_ = yym699
				if false {
				} else {
					h.decSliceDeployment((*[]Deployment)(yyv698), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys693)
		} // end switch yys693
	} // end for yyj693
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DeploymentList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj700 int
	var yyb700 bool
	var yyhl700 bool = l >= 0
	yyj700++
	if yyhl700 {
		yyb700 = yyj700 > l
	} else {
		yyb700 = r.CheckBreak()
	}
	if yyb700 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj700++
	if yyhl700 {
		yyb700 = yyj700 > l
	} else {
		yyb700 = r.CheckBreak()
	}
	if yyb700 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj700++
	if yyhl700 {
		yyb700 = yyj700 > l
	} else {
		yyb700 = r.CheckBreak()
	}
	if yyb700 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv703 := &x.ListMeta
		yym704 := z.DecBinary()
		_ = yym704
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv703) {
		} else {
			z.DecFallback(yyv703, false)
		}
	}
	yyj700++
	if yyhl700 {
		yyb700 = yyj700 > l
	} else {
		yyb700 = r.CheckBreak()
	}
	if yyb700 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv705 := &x.Items
		yym706 := z.DecBinary()
		_ = yym706
		if false {
		} else {
			h.decSliceDeployment((*[]Deployment)(yyv705), d)
		}
	}
	for {
		yyj700++
		if yyhl700 {
			yyb700 = yyj700 > l
		} else {
			yyb700 = r.CheckBreak()
		}
		if yyb700 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj700-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym707 := z.EncBinary()
		_ = yym707
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep708 := !z.EncBinary()
			yy2arr708 := z.EncBasicHandle().StructToArray
			var yyq708 [2]bool
			_, _, _ = yysep708, yyq708, yy2arr708
			const yyr708 bool = false
			yyq708[0] = x.Selector != nil
			var yynn708 int
			if yyr708 || yy2arr708 {
				r.EncodeArrayStart(2)
			} else {
				yynn708 = 1
				for _, b := range yyq708 {
					if b {
						yynn708++
					}
				}
				r.EncodeMapStart(yynn708)
				yynn708 = 0
			}
			if yyr708 || yy2arr708 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq708[0] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym710 := z.EncBinary()
						_ = yym710
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq708[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym711 := z.EncBinary()
						_ = yym711
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr708 || yy2arr708 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy713 := &x.Template
				yy713.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy714 := &x.Template
				yy714.CodecEncodeSelf(e)
			}
			if yyr708 || yy2arr708 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym715 := z.DecBinary()
	_ = yym715
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct716 := r.ContainerType()
		if yyct716 == codecSelferValueTypeMap1234 {
			yyl716 := r.ReadMapStart()
			if yyl716 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl716, d)
			}
		} else if yyct716 == codecSelferValueTypeArray1234 {
			yyl716 := r.ReadArrayStart()
			if yyl716 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl716, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys717Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys717Slc
	var yyhl717 bool = l >= 0
	for yyj717 := 0; ; yyj717++ {
		if yyhl717 {
			if yyj717 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys717Slc = r.DecodeBytes(yys717Slc, true, true)
		yys717 := string(yys717Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys717 {
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym719 := z.DecBinary()
				_ = yym719
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv720 := &x.Template
				yyv720.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys717)
		} // end switch yys717
	} // end for yyj717
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj721 int
	var yyb721 bool
	var yyhl721 bool = l >= 0
	yyj721++
	if yyhl721 {
		yyb721 = yyj721 > l
	} else {
		yyb721 = r.CheckBreak()
	}
	if yyb721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym723 := z.DecBinary()
		_ = yym723
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj721++
	if yyhl721 {
		yyb721 = yyj721 > l
	} else {
		yyb721 = r.CheckBreak()
	}
	if yyb721 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv724 := &x.Template
		yyv724.CodecDecodeSelf(d)
	}
	for {
		yyj721++
		if yyhl721 {
			yyb721 = yyj721 > l
		} else {
			yyb721 = r.CheckBreak()
		}
		if yyb721 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj721-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym725 := z.EncBinary()
		_ = yym725
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep726 := !z.EncBinary()
			yy2arr726 := z.EncBasicHandle().StructToArray
			var yyq726 [4]bool
			_, _, _ = yysep726, yyq726, yy2arr726
			const yyr726 bool = false
			var yynn726 int
			if yyr726 || yy2arr726 {
				r.EncodeArrayStart(4)
			} else {
				yynn726 = 4
				for _, b := range yyq726 {
					if b {
						yynn726++
					}
				}
				r.EncodeMapStart(yynn726)
				yynn726 = 0
			}
			if yyr726 || yy2arr726 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym728 := z.EncBinary()
				_ = yym728
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym729 := z.EncBinary()
				_ = yym729
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentNumberScheduled))
				}
			}
			if yyr726 || yy2arr726 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym731 := z.EncBinary()
				_ = yym731
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberMisscheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym732 := z.EncBinary()
				_ = yym732
				if false {
				} else {
					r.EncodeInt(int64(x.NumberMisscheduled))
				}
			}
			if yyr726 || yy2arr726 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym734 := z.EncBinary()
				_ = yym734
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredNumberScheduled"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym735 := z.EncBinary()
				_ = yym735
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredNumberScheduled))
				}
			}
			if yyr726 || yy2arr726 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym737 := z.EncBinary()
				_ = yym737
				if false {
				} else {
					r.EncodeInt(int64(x.NumberReady))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("numberReady"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym738 := z.EncBinary()
				_ = yym738
				if false {
				} else {
					r.EncodeInt(int64(x.NumberReady))
				}
			}
			if yyr726 || yy2arr726 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym739 := z.DecBinary()
	_ = yym739
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct740 := r.ContainerType()
		if yyct740 == codecSelferValueTypeMap1234 {
			yyl740 := r.ReadMapStart()
			if yyl740 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl740, d)
			}
		} else if yyct740 == codecSelferValueTypeArray1234 {
			yyl740 := r.ReadArrayStart()
			if yyl740 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl740, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys741Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys741Slc
	var yyhl741 bool = l >= 0
	for yyj741 := 0; ; yyj741++ {
		if yyhl741 {
			if yyj741 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys741Slc = r.DecodeBytes(yys741Slc, true, true)
		yys741 := string(yys741Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys741 {
		case "currentNumberScheduled":
			if r.TryDecodeAsNil() {
				x.CurrentNumberScheduled = 0
			} else {
				x.CurrentNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberMisscheduled":
			if r.TryDecodeAsNil() {
				x.NumberMisscheduled = 0
			} else {
				x.NumberMisscheduled = int32(r.DecodeInt(32))
			}
		case "desiredNumberScheduled":
			if r.TryDecodeAsNil() {
				x.DesiredNumberScheduled = 0
			} else {
				x.DesiredNumberScheduled = int32(r.DecodeInt(32))
			}
		case "numberReady":
			if r.TryDecodeAsNil() {
				x.NumberReady = 0
			} else {
				x.NumberReady = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys741)
		} // end switch yys741
	} // end for yyj741
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj746 int
	var yyb746 bool
	var yyhl746 bool = l >= 0
	yyj746++
	if yyhl746 {
		yyb746 = yyj746 > l
	} else {
		yyb746 = r.CheckBreak()
	}
	if yyb746 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentNumberScheduled = 0
	} else {
		x.CurrentNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj746++
	if yyhl746 {
		yyb746 = yyj746 > l
	} else {
		yyb746 = r.CheckBreak()
	}
	if yyb746 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberMisscheduled = 0
	} else {
		x.NumberMisscheduled = int32(r.DecodeInt(32))
	}
	yyj746++
	if yyhl746 {
		yyb746 = yyj746 > l
	} else {
		yyb746 = r.CheckBreak()
	}
	if yyb746 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredNumberScheduled = 0
	} else {
		x.DesiredNumberScheduled = int32(r.DecodeInt(32))
	}
	yyj746++
	if yyhl746 {
		yyb746 = yyj746 > l
	} else {
		yyb746 = r.CheckBreak()
	}
	if yyb746 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NumberReady = 0
	} else {
		x.NumberReady = int32(r.DecodeInt(32))
	}
	for {
		yyj746++
		if yyhl746 {
			yyb746 = yyj746 > l
		} else {
			yyb746 = r.CheckBreak()
		}
		if yyb746 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj746-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym751 := z.EncBinary()
		_ = yym751
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep752 := !z.EncBinary()
			yy2arr752 := z.EncBasicHandle().StructToArray
			var yyq752 [5]bool
			_, _, _ = yysep752, yyq752, yy2arr752
			const yyr752 bool = false
			yyq752[0] = x.Kind != ""
			yyq752[1] = x.APIVersion != ""
			yyq752[2] = true
			yyq752[3] = true
			yyq752[4] = true
			var yynn752 int
			if yyr752 || yy2arr752 {
				r.EncodeArrayStart(5)
			} else {
				yynn752 = 0
				for _, b := range yyq752 {
					if b {
						yynn752++
					}
				}
				r.EncodeMapStart(yynn752)
				yynn752 = 0
			}
			if yyr752 || yy2arr752 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq752[0] {
					yym754 := z.EncBinary()
					_ = yym754
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq752[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym755 := z.EncBinary()
					_ = yym755
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr752 || yy2arr752 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq752[1] {
					yym757 := z.EncBinary()
					_ = yym757
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq752[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym758 := z.EncBinary()
					_ = yym758
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr752 || yy2arr752 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq752[2] {
					yy760 := &x.ObjectMeta
					yy760.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq752[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy761 := &x.ObjectMeta
					yy761.CodecEncodeSelf(e)
				}
			}
			if yyr752 || yy2arr752 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq752[3] {
					yy763 := &x.Spec
					yy763.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq752[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy764 := &x.Spec
					yy764.CodecEncodeSelf(e)
				}
			}
			if yyr752 || yy2arr752 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq752[4] {
					yy766 := &x.Status
					yy766.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq752[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy767 := &x.Status
					yy767.CodecEncodeSelf(e)
				}
			}
			if yyr752 || yy2arr752 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym768 := z.DecBinary()
	_ = yym768
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct769 := r.ContainerType()
		if yyct769 == codecSelferValueTypeMap1234 {
			yyl769 := r.ReadMapStart()
			if yyl769 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl769, d)
			}
		} else if yyct769 == codecSelferValueTypeArray1234 {
			yyl769 := r.ReadArrayStart()
			if yyl769 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl769, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys770Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys770Slc
	var yyhl770 bool = l >= 0
	for yyj770 := 0; ; yyj770++ {
		if yyhl770 {
			if yyj770 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys770Slc = r.DecodeBytes(yys770Slc, true, true)
		yys770 := string(yys770Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys770 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv773 := &x.ObjectMeta
				yyv773.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = DaemonSetSpec{}
			} else {
				yyv774 := &x.Spec
				yyv774.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = DaemonSetStatus{}
			} else {
				yyv775 := &x.Status
				yyv775.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys770)
		} // end switch yys770
	} // end for yyj770
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj776 int
	var yyb776 bool
	var yyhl776 bool = l >= 0
	yyj776++
	if yyhl776 {
		yyb776 = yyj776 > l
	} else {
		yyb776 = r.CheckBreak()
	}
	if yyb776 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj776++
	if yyhl776 {
		yyb776 = yyj776 > l
	} else {
		yyb776 = r.CheckBreak()
	}
	if yyb776 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj776++
	if yyhl776 {
		yyb776 = yyj776 > l
	} else {
		yyb776 = r.CheckBreak()
	}
	if yyb776 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv779 := &x.ObjectMeta
		yyv779.CodecDecodeSelf(d)
	}
	yyj776++
	if yyhl776 {
		yyb776 = yyj776 > l
	} else {
		yyb776 = r.CheckBreak()
	}
	if yyb776 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = DaemonSetSpec{}
	} else {
		yyv780 := &x.Spec
		yyv780.CodecDecodeSelf(d)
	}
	yyj776++
	if yyhl776 {
		yyb776 = yyj776 > l
	} else {
		yyb776 = r.CheckBreak()
	}
	if yyb776 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = DaemonSetStatus{}
	} else {
		yyv781 := &x.Status
		yyv781.CodecDecodeSelf(d)
	}
	for {
		yyj776++
		if yyhl776 {
			yyb776 = yyj776 > l
		} else {
			yyb776 = r.CheckBreak()
		}
		if yyb776 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj776-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *DaemonSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym782 := z.EncBinary()
		_ = yym782
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep783 := !z.EncBinary()
			yy2arr783 := z.EncBasicHandle().StructToArray
			var yyq783 [4]bool
			_, _, _ = yysep783, yyq783, yy2arr783
			const yyr783 bool = false
			yyq783[0] = x.Kind != ""
			yyq783[1] = x.APIVersion != ""
			yyq783[2] = true
			var yynn783 int
			if yyr783 || yy2arr783 {
				r.EncodeArrayStart(4)
			} else {
				yynn783 = 1
				for _, b := range yyq783 {
					if b {
						yynn783++
					}
				}
				r.EncodeMapStart(yynn783)
				yynn783 = 0
			}
			if yyr783 || yy2arr783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq783[0] {
					yym785 := z.EncBinary()
					_ = yym785
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq783[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym786 := z.EncBinary()
					_ = yym786
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr783 || yy2arr783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq783[1] {
					yym788 := z.EncBinary()
					_ = yym788
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq783[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym789 := z.EncBinary()
					_ = yym789
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr783 || yy2arr783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq783[2] {
					yy791 := &x.ListMeta
					yym792 := z.EncBinary()
					_ = yym792
					if false {
					} else if z.HasExtensions() && z.EncExt(yy791) {
					} else {
						z.EncFallback(yy791)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq783[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy793 := &x.ListMeta
					yym794 := z.EncBinary()
					_ = yym794
					if false {
					} else if z.HasExtensions() && z.EncExt(yy793) {
					} else {
						z.EncFallback(yy793)
					}
				}
			}
			if yyr783 || yy2arr783 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym796 := z.EncBinary()
					_ = yym796
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym797 := z.EncBinary()
					_ = yym797
					if false {
					} else {
						h.encSliceDaemonSet(([]DaemonSet)(x.Items), e)
					}
				}
			}
			if yyr783 || yy2arr783 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *DaemonSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym798 := z.DecBinary()
	_ = yym798
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct799 := r.ContainerType()
		if yyct799 == codecSelferValueTypeMap1234 {
			yyl799 := r.ReadMapStart()
			if yyl799 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl799, d)
			}
		} else if yyct799 == codecSelferValueTypeArray1234 {
			yyl799 := r.ReadArrayStart()
			if yyl799 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl799, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *DaemonSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys800Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys800Slc
	var yyhl800 bool = l >= 0
	for yyj800 := 0; ; yyj800++ {
		if yyhl800 {
			if yyj800 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys800Slc = r.DecodeBytes(yys800Slc, true, true)
		yys800 := string(yys800Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys800 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv803 := &x.ListMeta
				yym804 := z.DecBinary()
				_ = yym804
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv803) {
				} else {
					z.DecFallback(yyv803, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv805 := &x.Items
				yym806 := z.DecBinary()
				_ = yym806
				if false {
				} else {
					h.decSliceDaemonSet((*[]DaemonSet)(yyv805), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys800)
		} // end switch yys800
	} // end for yyj800
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *DaemonSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj807 int
	var yyb807 bool
	var yyhl807 bool = l >= 0
	yyj807++
	if yyhl807 {
		yyb807 = yyj807 > l
	} else {
		yyb807 = r.CheckBreak()
	}
	if yyb807 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj807++
	if yyhl807 {
		yyb807 = yyj807 > l
	} else {
		yyb807 = r.CheckBreak()
	}
	if yyb807 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj807++
	if yyhl807 {
		yyb807 = yyj807 > l
	} else {
		yyb807 = r.CheckBreak()
	}
	if yyb807 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv810 := &x.ListMeta
		yym811 := z.DecBinary()
		_ = yym811
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv810) {
		} else {
			z.DecFallback(yyv810, false)
		}
	}
	yyj807++
	if yyhl807 {
		yyb807 = yyj807 > l
	} else {
		yyb807 = r.CheckBreak()
	}
	if yyb807 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv812 := &x.Items
		yym813 := z.DecBinary()
		_ = yym813
		if false {
		} else {
			h.decSliceDaemonSet((*[]DaemonSet)(yyv812), d)
		}
	}
	for {
		yyj807++
		if yyhl807 {
			yyb807 = yyj807 > l
		} else {
			yyb807 = r.CheckBreak()
		}
		if yyb807 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj807-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ThirdPartyResourceDataList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym814 := z.EncBinary()
		_ = yym814
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep815 := !z.EncBinary()
			yy2arr815 := z.EncBasicHandle().StructToArray
			var yyq815 [4]bool
			_, _, _ = yysep815, yyq815, yy2arr815
			const yyr815 bool = false
			yyq815[0] = x.Kind != ""
			yyq815[1] = x.APIVersion != ""
			yyq815[2] = true
			var yynn815 int
			if yyr815 || yy2arr815 {
				r.EncodeArrayStart(4)
			} else {
				yynn815 = 1
				for _, b := range yyq815 {
					if b {
						yynn815++
					}
				}
				r.EncodeMapStart(yynn815)
				yynn815 = 0
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq815[0] {
					yym817 := z.EncBinary()
					_ = yym817
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq815[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym818 := z.EncBinary()
					_ = yym818
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq815[1] {
					yym820 := z.EncBinary()
					_ = yym820
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq815[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym821 := z.EncBinary()
					_ = yym821
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq815[2] {
					yy823 := &x.ListMeta
					yym824 := z.EncBinary()
					_ = yym824
					if false {
					} else if z.HasExtensions() && z.EncExt(yy823) {
					} else {
						z.EncFallback(yy823)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq815[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy825 := &x.ListMeta
					yym826 := z.EncBinary()
					_ = yym826
					if false {
					} else if z.HasExtensions() && z.EncExt(yy825) {
					} else {
						z.EncFallback(yy825)
					}
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym828 := z.EncBinary()
					_ = yym828
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym829 := z.EncBinary()
					_ = yym829
					if false {
					} else {
						h.encSliceThirdPartyResourceData(([]ThirdPartyResourceData)(x.Items), e)
					}
				}
			}
			if yyr815 || yy2arr815 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ThirdPartyResourceDataList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym830 := z.DecBinary()
	_ = yym830
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct831 := r.ContainerType()
		if yyct831 == codecSelferValueTypeMap1234 {
			yyl831 := r.ReadMapStart()
			if yyl831 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl831, d)
			}
		} else if yyct831 == codecSelferValueTypeArray1234 {
			yyl831 := r.ReadArrayStart()
			if yyl831 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl831, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys832Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys832Slc
	var yyhl832 bool = l >= 0
	for yyj832 := 0; ; yyj832++ {
		if yyhl832 {
			if yyj832 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys832Slc = r.DecodeBytes(yys832Slc, true, true)
		yys832 := string(yys832Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys832 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv835 := &x.ListMeta
				yym836 := z.DecBinary()
				_ = yym836
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv835) {
				} else {
					z.DecFallback(yyv835, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv837 := &x.Items
				yym838 := z.DecBinary()
				_ = yym838
				if false {
				} else {
					h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv837), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys832)
		} // end switch yys832
	} // end for yyj832
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ThirdPartyResourceDataList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj839 int
	var yyb839 bool
	var yyhl839 bool = l >= 0
	yyj839++
	if yyhl839 {
		yyb839 = yyj839 > l
	} else {
		yyb839 = r.CheckBreak()
	}
	if yyb839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj839++
	if yyhl839 {
		yyb839 = yyj839 > l
	} else {
		yyb839 = r.CheckBreak()
	}
	if yyb839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj839++
	if yyhl839 {
		yyb839 = yyj839 > l
	} else {
		yyb839 = r.CheckBreak()
	}
	if yyb839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv842 := &x.ListMeta
		yym843 := z.DecBinary()
		_ = yym843
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv842) {
		} else {
			z.DecFallback(yyv842, false)
		}
	}
	yyj839++
	if yyhl839 {
		yyb839 = yyj839 > l
	} else {
		yyb839 = r.CheckBreak()
	}
	if yyb839 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv844 := &x.Items
		yym845 := z.DecBinary()
		_ = yym845
		if false {
		} else {
			h.decSliceThirdPartyResourceData((*[]ThirdPartyResourceData)(yyv844), d)
		}
	}
	for {
		yyj839++
		if yyhl839 {
			yyb839 = yyj839 > l
		} else {
			yyb839 = r.CheckBreak()
		}
		if yyb839 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj839-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Job) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym846 := z.EncBinary()
		_ = yym846
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep847 := !z.EncBinary()
			yy2arr847 := z.EncBasicHandle().StructToArray
			var yyq847 [5]bool
			_, _, _ = yysep847, yyq847, yy2arr847
			const yyr847 bool = false
			yyq847[0] = x.Kind != ""
			yyq847[1] = x.APIVersion != ""
			yyq847[2] = true
			yyq847[3] = true
			yyq847[4] = true
			var yynn847 int
			if yyr847 || yy2arr847 {
				r.EncodeArrayStart(5)
			} else {
				yynn847 = 0
				for _, b := range yyq847 {
					if b {
						yynn847++
					}
				}
				r.EncodeMapStart(yynn847)
				yynn847 = 0
			}
			if yyr847 || yy2arr847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq847[0] {
					yym849 := z.EncBinary()
					_ = yym849
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq847[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym850 := z.EncBinary()
					_ = yym850
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr847 || yy2arr847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq847[1] {
					yym852 := z.EncBinary()
					_ = yym852
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq847[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym853 := z.EncBinary()
					_ = yym853
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr847 || yy2arr847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq847[2] {
					yy855 := &x.ObjectMeta
					yy855.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq847[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy856 := &x.ObjectMeta
					yy856.CodecEncodeSelf(e)
				}
			}
			if yyr847 || yy2arr847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq847[3] {
					yy858 := &x.Spec
					yy858.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq847[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy859 := &x.Spec
					yy859.CodecEncodeSelf(e)
				}
			}
			if yyr847 || yy2arr847 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq847[4] {
					yy861 := &x.Status
					yy861.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq847[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy862 := &x.Status
					yy862.CodecEncodeSelf(e)
				}
			}
			if yyr847 || yy2arr847 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Job) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym863 := z.DecBinary()
	_ = yym863
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct864 := r.ContainerType()
		if yyct864 == codecSelferValueTypeMap1234 {
			yyl864 := r.ReadMapStart()
			if yyl864 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl864, d)
			}
		} else if yyct864 == codecSelferValueTypeArray1234 {
			yyl864 := r.ReadArrayStart()
			if yyl864 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl864, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Job) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys865Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys865Slc
	var yyhl865 bool = l >= 0
	for yyj865 := 0; ; yyj865++ {
		if yyhl865 {
			if yyj865 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys865Slc = r.DecodeBytes(yys865Slc, true, true)
		yys865 := string(yys865Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys865 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv868 := &x.ObjectMeta
				yyv868.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = JobSpec{}
			} else {
				yyv869 := &x.Spec
				yyv869.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = JobStatus{}
			} else {
				yyv870 := &x.Status
				yyv870.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys865)
		} // end switch yys865
	} // end for yyj865
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Job) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj871 int
	var yyb871 bool
	var yyhl871 bool = l >= 0
	yyj871++
	if yyhl871 {
		yyb871 = yyj871 > l
	} else {
		yyb871 = r.CheckBreak()
	}
	if yyb871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj871++
	if yyhl871 {
		yyb871 = yyj871 > l
	} else {
		yyb871 = r.CheckBreak()
	}
	if yyb871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj871++
	if yyhl871 {
		yyb871 = yyj871 > l
	} else {
		yyb871 = r.CheckBreak()
	}
	if yyb871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv874 := &x.ObjectMeta
		yyv874.CodecDecodeSelf(d)
	}
	yyj871++
	if yyhl871 {
		yyb871 = yyj871 > l
	} else {
		yyb871 = r.CheckBreak()
	}
	if yyb871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = JobSpec{}
	} else {
		yyv875 := &x.Spec
		yyv875.CodecDecodeSelf(d)
	}
	yyj871++
	if yyhl871 {
		yyb871 = yyj871 > l
	} else {
		yyb871 = r.CheckBreak()
	}
	if yyb871 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = JobStatus{}
	} else {
		yyv876 := &x.Status
		yyv876.CodecDecodeSelf(d)
	}
	for {
		yyj871++
		if yyhl871 {
			yyb871 = yyj871 > l
		} else {
			yyb871 = r.CheckBreak()
		}
		if yyb871 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj871-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym877 := z.EncBinary()
		_ = yym877
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep878 := !z.EncBinary()
			yy2arr878 := z.EncBasicHandle().StructToArray
			var yyq878 [4]bool
			_, _, _ = yysep878, yyq878, yy2arr878
			const yyr878 bool = false
			yyq878[0] = x.Kind != ""
			yyq878[1] = x.APIVersion != ""
			yyq878[2] = true
			var yynn878 int
			if yyr878 || yy2arr878 {
				r.EncodeArrayStart(4)
			} else {
				yynn878 = 1
				for _, b := range yyq878 {
					if b {
						yynn878++
					}
				}
				r.EncodeMapStart(yynn878)
				yynn878 = 0
			}
			if yyr878 || yy2arr878 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq878[0] {
					yym880 := z.EncBinary()
					_ = yym880
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq878[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym881 := z.EncBinary()
					_ = yym881
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr878 || yy2arr878 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq878[1] {
					yym883 := z.EncBinary()
					_ = yym883
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq878[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym884 := z.EncBinary()
					_ = yym884
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr878 || yy2arr878 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq878[2] {
					yy886 := &x.ListMeta
					yym887 := z.EncBinary()
					_ = yym887
					if false {
					} else if z.HasExtensions() && z.EncExt(yy886) {
					} else {
						z.EncFallback(yy886)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq878[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy888 := &x.ListMeta
					yym889 := z.EncBinary()
					_ = yym889
					if false {
					} else if z.HasExtensions() && z.EncExt(yy888) {
					} else {
						z.EncFallback(yy888)
					}
				}
			}
			if yyr878 || yy2arr878 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym891 := z.EncBinary()
					_ = yym891
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym892 := z.EncBinary()
					_ = yym892
					if false {
					} else {
						h.encSliceJob(([]Job)(x.Items), e)
					}
				}
			}
			if yyr878 || yy2arr878 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym893 := z.DecBinary()
	_ = yym893
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct894 := r.ContainerType()
		if yyct894 == codecSelferValueTypeMap1234 {
			yyl894 := r.ReadMapStart()
			if yyl894 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl894, d)
			}
		} else if yyct894 == codecSelferValueTypeArray1234 {
			yyl894 := r.ReadArrayStart()
			if yyl894 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl894, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys895Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys895Slc
	var yyhl895 bool = l >= 0
	for yyj895 := 0; ; yyj895++ {
		if yyhl895 {
			if yyj895 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys895Slc = r.DecodeBytes(yys895Slc, true, true)
		yys895 := string(yys895Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys895 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv898 := &x.ListMeta
				yym899 := z.DecBinary()
				_ = yym899
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv898) {
				} else {
					z.DecFallback(yyv898, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv900 := &x.Items
				yym901 := z.DecBinary()
				_ = yym901
				if false {
				} else {
					h.decSliceJob((*[]Job)(yyv900), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys895)
		} // end switch yys895
	} // end for yyj895
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj902 int
	var yyb902 bool
	var yyhl902 bool = l >= 0
	yyj902++
	if yyhl902 {
		yyb902 = yyj902 > l
	} else {
		yyb902 = r.CheckBreak()
	}
	if yyb902 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj902++
	if yyhl902 {
		yyb902 = yyj902 > l
	} else {
		yyb902 = r.CheckBreak()
	}
	if yyb902 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj902++
	if yyhl902 {
		yyb902 = yyj902 > l
	} else {
		yyb902 = r.CheckBreak()
	}
	if yyb902 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv905 := &x.ListMeta
		yym906 := z.DecBinary()
		_ = yym906
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv905) {
		} else {
			z.DecFallback(yyv905, false)
		}
	}
	yyj902++
	if yyhl902 {
		yyb902 = yyj902 > l
	} else {
		yyb902 = r.CheckBreak()
	}
	if yyb902 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv907 := &x.Items
		yym908 := z.DecBinary()
		_ = yym908
		if false {
		} else {
			h.decSliceJob((*[]Job)(yyv907), d)
		}
	}
	for {
		yyj902++
		if yyhl902 {
			yyb902 = yyj902 > l
		} else {
			yyb902 = r.CheckBreak()
		}
		if yyb902 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj902-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym909 := z.EncBinary()
		_ = yym909
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep910 := !z.EncBinary()
			yy2arr910 := z.EncBasicHandle().StructToArray
			var yyq910 [6]bool
			_, _, _ = yysep910, yyq910, yy2arr910
			const yyr910 bool = false
			yyq910[0] = x.Parallelism != nil
			yyq910[1] = x.Completions != nil
			yyq910[2] = x.ActiveDeadlineSeconds != nil
			yyq910[3] = x.Selector != nil
			yyq910[4] = x.AutoSelector != nil
			var yynn910 int
			if yyr910 || yy2arr910 {
				r.EncodeArrayStart(6)
			} else {
				yynn910 = 1
				for _, b := range yyq910 {
					if b {
						yynn910++
					}
				}
				r.EncodeMapStart(yynn910)
				yynn910 = 0
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq910[0] {
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy912 := *x.Parallelism
						yym913 := z.EncBinary()
						_ = yym913
						if false {
						} else {
							r.EncodeInt(int64(yy912))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq910[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("parallelism"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Parallelism == nil {
						r.EncodeNil()
					} else {
						yy914 := *x.Parallelism
						yym915 := z.EncBinary()
						_ = yym915
						if false {
						} else {
							r.EncodeInt(int64(yy914))
						}
					}
				}
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq910[1] {
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy917 := *x.Completions
						yym918 := z.EncBinary()
						_ = yym918
						if false {
						} else {
							r.EncodeInt(int64(yy917))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq910[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Completions == nil {
						r.EncodeNil()
					} else {
						yy919 := *x.Completions
						yym920 := z.EncBinary()
						_ = yym920
						if false {
						} else {
							r.EncodeInt(int64(yy919))
						}
					}
				}
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq910[2] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy922 := *x.ActiveDeadlineSeconds
						yym923 := z.EncBinary()
						_ = yym923
						if false {
						} else {
							r.EncodeInt(int64(yy922))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq910[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy924 := *x.ActiveDeadlineSeconds
						yym925 := z.EncBinary()
						_ = yym925
						if false {
						} else {
							r.EncodeInt(int64(yy924))
						}
					}
				}
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq910[3] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym927 := z.EncBinary()
						_ = yym927
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq910[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym928 := z.EncBinary()
						_ = yym928
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq910[4] {
					if x.AutoSelector == nil {
						r.EncodeNil()
					} else {
						yy930 := *x.AutoSelector
						yym931 := z.EncBinary()
						_ = yym931
						if false {
						} else {
							r.EncodeBool(bool(yy930))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq910[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("autoSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AutoSelector == nil {
						r.EncodeNil()
					} else {
						yy932 := *x.AutoSelector
						yym933 := z.EncBinary()
						_ = yym933
						if false {
						} else {
							r.EncodeBool(bool(yy932))
						}
					}
				}
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy935 := &x.Template
				yy935.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("template"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy936 := &x.Template
				yy936.CodecEncodeSelf(e)
			}
			if yyr910 || yy2arr910 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym937 := z.DecBinary()
	_ = yym937
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct938 := r.ContainerType()
		if yyct938 == codecSelferValueTypeMap1234 {
			yyl938 := r.ReadMapStart()
			if yyl938 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl938, d)
			}
		} else if yyct938 == codecSelferValueTypeArray1234 {
			yyl938 := r.ReadArrayStart()
			if yyl938 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl938, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys939Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys939Slc
	var yyhl939 bool = l >= 0
	for yyj939 := 0; ; yyj939++ {
		if yyhl939 {
			if yyj939 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys939Slc = r.DecodeBytes(yys939Slc, true, true)
		yys939 := string(yys939Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys939 {
		case "parallelism":
			if r.TryDecodeAsNil() {
				if x.Parallelism != nil {
					x.Parallelism = nil
				}
			} else {
				if x.Parallelism == nil {
					x.Parallelism = new(int32)
				}
				yym941 := z.DecBinary()
				_ = yym941
				if false {
				} else {
					*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
				}
			}
		case "completions":
			if r.TryDecodeAsNil() {
				if x.Completions != nil {
					x.Completions = nil
				}
			} else {
				if x.Completions == nil {
					x.Completions = new(int32)
				}
				yym943 := z.DecBinary()
				_ = yym943
				if false {
				} else {
					*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym945 := z.DecBinary()
				_ = yym945
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym947 := z.DecBinary()
				_ = yym947
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "autoSelector":
			if r.TryDecodeAsNil() {
				if x.AutoSelector != nil {
					x.AutoSelector = nil
				}
			} else {
				if x.AutoSelector == nil {
					x.AutoSelector = new(bool)
				}
				yym949 := z.DecBinary()
				_ = yym949
				if false {
				} else {
					*((*bool)(x.AutoSelector)) = r.DecodeBool()
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv950 := &x.Template
				yyv950.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys939)
		} // end switch yys939
	} // end for yyj939
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj951 int
	var yyb951 bool
	var yyhl951 bool = l >= 0
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Parallelism != nil {
			x.Parallelism = nil
		}
	} else {
		if x.Parallelism == nil {
			x.Parallelism = new(int32)
		}
		yym953 := z.DecBinary()
		_ = yym953
		if false {
		} else {
			*((*int32)(x.Parallelism)) = int32(r.DecodeInt(32))
		}
	}
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Completions != nil {
			x.Completions = nil
		}
	} else {
		if x.Completions == nil {
			x.Completions = new(int32)
		}
		yym955 := z.DecBinary()
		_ = yym955
		if false {
		} else {
			*((*int32)(x.Completions)) = int32(r.DecodeInt(32))
		}
	}
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym957 := z.DecBinary()
		_ = yym957
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym959 := z.DecBinary()
		_ = yym959
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AutoSelector != nil {
			x.AutoSelector = nil
		}
	} else {
		if x.AutoSelector == nil {
			x.AutoSelector = new(bool)
		}
		yym961 := z.DecBinary()
		_ = yym961
		if false {
		} else {
			*((*bool)(x.AutoSelector)) = r.DecodeBool()
		}
	}
	yyj951++
	if yyhl951 {
		yyb951 = yyj951 > l
	} else {
		yyb951 = r.CheckBreak()
	}
	if yyb951 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv962 := &x.Template
		yyv962.CodecDecodeSelf(d)
	}
	for {
		yyj951++
		if yyhl951 {
			yyb951 = yyj951 > l
		} else {
			yyb951 = r.CheckBreak()
		}
		if yyb951 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj951-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *JobStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym963 := z.EncBinary()
		_ = yym963
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep964 := !z.EncBinary()
			yy2arr964 := z.EncBasicHandle().StructToArray
			var yyq964 [6]bool
			_, _, _ = yysep964, yyq964, yy2arr964
			const yyr964 bool = false
			yyq964[0] = len(x.Conditions) != 0
			yyq964[1] = x.StartTime != nil
			yyq964[2] = x.CompletionTime != nil
			yyq964[3] = x.Active != 0
			yyq964[4] = x.Succeeded != 0
			yyq964[5] = x.Failed != 0
			var yynn964 int
			if yyr964 || yy2arr964 {
				r.EncodeArrayStart(6)
			} else {
				yynn964 = 0
				for _, b := range yyq964 {
					if b {
						yynn964++
					}
				}
				r.EncodeMapStart(yynn964)
				yynn964 = 0
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[0] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym966 := z.EncBinary()
						_ = yym966
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq964[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym967 := z.EncBinary()
						_ = yym967
						if false {
						} else {
							h.encSliceJobCondition(([]JobCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[1] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym969 := z.EncBinary()
						_ = yym969
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym969 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym969 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq964[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym970 := z.EncBinary()
						_ = yym970
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym970 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym970 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[2] {
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym972 := z.EncBinary()
						_ = yym972
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym972 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym972 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq964[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("completionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CompletionTime == nil {
						r.EncodeNil()
					} else {
						yym973 := z.EncBinary()
						_ = yym973
						if false {
						} else if z.HasExtensions() && z.EncExt(x.CompletionTime) {
						} else if yym973 {
							z.EncBinaryMarshal(x.CompletionTime)
						} else if !yym973 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.CompletionTime)
						} else {
							z.EncFallback(x.CompletionTime)
						}
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[3] {
					yym975 := z.EncBinary()
					_ = yym975
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq964[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("active"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym976 := z.EncBinary()
					_ = yym976
					if false {
					} else {
						r.EncodeInt(int64(x.Active))
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[4] {
					yym978 := z.EncBinary()
					_ = yym978
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq964[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("succeeded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym979 := z.EncBinary()
					_ = yym979
					if false {
					} else {
						r.EncodeInt(int64(x.Succeeded))
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq964[5] {
					yym981 := z.EncBinary()
					_ = yym981
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq964[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failed"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym982 := z.EncBinary()
					_ = yym982
					if false {
					} else {
						r.EncodeInt(int64(x.Failed))
					}
				}
			}
			if yyr964 || yy2arr964 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym983 := z.DecBinary()
	_ = yym983
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct984 := r.ContainerType()
		if yyct984 == codecSelferValueTypeMap1234 {
			yyl984 := r.ReadMapStart()
			if yyl984 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl984, d)
			}
		} else if yyct984 == codecSelferValueTypeArray1234 {
			yyl984 := r.ReadArrayStart()
			if yyl984 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl984, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys985Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys985Slc
	var yyhl985 bool = l >= 0
	for yyj985 := 0; ; yyj985++ {
		if yyhl985 {
			if yyj985 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys985Slc = r.DecodeBytes(yys985Slc, true, true)
		yys985 := string(yys985Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys985 {
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv986 := &x.Conditions
				yym987 := z.DecBinary()
				_ = yym987
				if false {
				} else {
					h.decSliceJobCondition((*[]JobCondition)(yyv986), d)
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg1_unversioned.Time)
				}
				yym989 := z.DecBinary()
				_ = yym989
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym989 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym989 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "completionTime":
			if r.TryDecodeAsNil() {
				if x.CompletionTime != nil {
					x.CompletionTime = nil
				}
			} else {
				if x.CompletionTime == nil {
					x.CompletionTime = new(pkg1_unversioned.Time)
				}
				yym991 := z.DecBinary()
				_ = yym991
				if false {
				} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
				} else if yym991 {
					z.DecBinaryUnmarshal(x.CompletionTime)
				} else if !yym991 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.CompletionTime)
				} else {
					z.DecFallback(x.CompletionTime, false)
				}
			}
		case "active":
			if r.TryDecodeAsNil() {
				x.Active = 0
			} else {
				x.Active = int32(r.DecodeInt(32))
			}
		case "succeeded":
			if r.TryDecodeAsNil() {
				x.Succeeded = 0
			} else {
				x.Succeeded = int32(r.DecodeInt(32))
			}
		case "failed":
			if r.TryDecodeAsNil() {
				x.Failed = 0
			} else {
				x.Failed = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys985)
		} // end switch yys985
	} // end for yyj985
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj995 int
	var yyb995 bool
	var yyhl995 bool = l >= 0
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv996 := &x.Conditions
		yym997 := z.DecBinary()
		_ = yym997
		if false {
		} else {
			h.decSliceJobCondition((*[]JobCondition)(yyv996), d)
		}
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg1_unversioned.Time)
		}
		yym999 := z.DecBinary()
		_ = yym999
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym999 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym999 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CompletionTime != nil {
			x.CompletionTime = nil
		}
	} else {
		if x.CompletionTime == nil {
			x.CompletionTime = new(pkg1_unversioned.Time)
		}
		yym1001 := z.DecBinary()
		_ = yym1001
		if false {
		} else if z.HasExtensions() && z.DecExt(x.CompletionTime) {
		} else if yym1001 {
			z.DecBinaryUnmarshal(x.CompletionTime)
		} else if !yym1001 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.CompletionTime)
		} else {
			z.DecFallback(x.CompletionTime, false)
		}
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Active = 0
	} else {
		x.Active = int32(r.DecodeInt(32))
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Succeeded = 0
	} else {
		x.Succeeded = int32(r.DecodeInt(32))
	}
	yyj995++
	if yyhl995 {
		yyb995 = yyj995 > l
	} else {
		yyb995 = r.CheckBreak()
	}
	if yyb995 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Failed = 0
	} else {
		x.Failed = int32(r.DecodeInt(32))
	}
	for {
		yyj995++
		if yyhl995 {
			yyb995 = yyj995 > l
		} else {
			yyb995 = r.CheckBreak()
		}
		if yyb995 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj995-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x JobConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1005 := z.EncBinary()
	_ = yym1005
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *JobConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1006 := z.DecBinary()
	_ = yym1006
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *JobCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1007 := z.EncBinary()
		_ = yym1007
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1008 := !z.EncBinary()
			yy2arr1008 := z.EncBasicHandle().StructToArray
			var yyq1008 [6]bool
			_, _, _ = yysep1008, yyq1008, yy2arr1008
			const yyr1008 bool = false
			yyq1008[2] = true
			yyq1008[3] = true
			yyq1008[4] = x.Reason != ""
			yyq1008[5] = x.Message != ""
			var yynn1008 int
			if yyr1008 || yy2arr1008 {
				r.EncodeArrayStart(6)
			} else {
				yynn1008 = 2
				for _, b := range yyq1008 {
					if b {
						yynn1008++
					}
				}
				r.EncodeMapStart(yynn1008)
				yynn1008 = 0
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1011 := z.EncBinary()
				_ = yym1011
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1012 := z.EncBinary()
				_ = yym1012
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1008[2] {
					yy1014 := &x.LastProbeTime
					yym1015 := z.EncBinary()
					_ = yym1015
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1014) {
					} else if yym1015 {
						z.EncBinaryMarshal(yy1014)
					} else if !yym1015 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1014)
					} else {
						z.EncFallback(yy1014)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1008[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1016 := &x.LastProbeTime
					yym1017 := z.EncBinary()
					_ = yym1017
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1016) {
					} else if yym1017 {
						z.EncBinaryMarshal(yy1016)
					} else if !yym1017 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1016)
					} else {
						z.EncFallback(yy1016)
					}
				}
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1008[3] {
					yy1019 := &x.LastTransitionTime
					yym1020 := z.EncBinary()
					_ = yym1020
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1019) {
					} else if yym1020 {
						z.EncBinaryMarshal(yy1019)
					} else if !yym1020 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1019)
					} else {
						z.EncFallback(yy1019)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1008[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1021 := &x.LastTransitionTime
					yym1022 := z.EncBinary()
					_ = yym1022
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1021) {
					} else if yym1022 {
						z.EncBinaryMarshal(yy1021)
					} else if !yym1022 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1021)
					} else {
						z.EncFallback(yy1021)
					}
				}
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1008[4] {
					yym1024 := z.EncBinary()
					_ = yym1024
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1008[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1025 := z.EncBinary()
					_ = yym1025
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1008[5] {
					yym1027 := z.EncBinary()
					_ = yym1027
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1008[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1028 := z.EncBinary()
					_ = yym1028
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1008 || yy2arr1008 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *JobCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1029 := z.DecBinary()
	_ = yym1029
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1030 := r.ContainerType()
		if yyct1030 == codecSelferValueTypeMap1234 {
			yyl1030 := r.ReadMapStart()
			if yyl1030 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1030, d)
			}
		} else if yyct1030 == codecSelferValueTypeArray1234 {
			yyl1030 := r.ReadArrayStart()
			if yyl1030 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1030, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *JobCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1031Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1031Slc
	var yyhl1031 bool = l >= 0
	for yyj1031 := 0; ; yyj1031++ {
		if yyhl1031 {
			if yyj1031 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1031Slc = r.DecodeBytes(yys1031Slc, true, true)
		yys1031 := string(yys1031Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1031 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = JobConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg1_unversioned.Time{}
			} else {
				yyv1034 := &x.LastProbeTime
				yym1035 := z.DecBinary()
				_ = yym1035
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1034) {
				} else if yym1035 {
					z.DecBinaryUnmarshal(yyv1034)
				} else if !yym1035 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1034)
				} else {
					z.DecFallback(yyv1034, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv1036 := &x.LastTransitionTime
				yym1037 := z.DecBinary()
				_ = yym1037
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1036) {
				} else if yym1037 {
					z.DecBinaryUnmarshal(yyv1036)
				} else if !yym1037 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1036)
				} else {
					z.DecFallback(yyv1036, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1031)
		} // end switch yys1031
	} // end for yyj1031
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *JobCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1040 int
	var yyb1040 bool
	var yyhl1040 bool = l >= 0
	yyj1040++
	if yyhl1040 {
		yyb1040 = yyj1040 > l
	} else {
		yyb1040 = r.CheckBreak()
	}
	if yyb1040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = JobConditionType(r.DecodeString())
	}
	yyj1040++
	if yyhl1040 {
		yyb1040 = yyj1040 > l
	} else {
		yyb1040 = r.CheckBreak()
	}
	if yyb1040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj1040++
	if yyhl1040 {
		yyb1040 = yyj1040 > l
	} else {
		yyb1040 = r.CheckBreak()
	}
	if yyb1040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg1_unversioned.Time{}
	} else {
		yyv1043 := &x.LastProbeTime
		yym1044 := z.DecBinary()
		_ = yym1044
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1043) {
		} else if yym1044 {
			z.DecBinaryUnmarshal(yyv1043)
		} else if !yym1044 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1043)
		} else {
			z.DecFallback(yyv1043, false)
		}
	}
	yyj1040++
	if yyhl1040 {
		yyb1040 = yyj1040 > l
	} else {
		yyb1040 = r.CheckBreak()
	}
	if yyb1040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv1045 := &x.LastTransitionTime
		yym1046 := z.DecBinary()
		_ = yym1046
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1045) {
		} else if yym1046 {
			z.DecBinaryUnmarshal(yyv1045)
		} else if !yym1046 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1045)
		} else {
			z.DecFallback(yyv1045, false)
		}
	}
	yyj1040++
	if yyhl1040 {
		yyb1040 = yyj1040 > l
	} else {
		yyb1040 = r.CheckBreak()
	}
	if yyb1040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1040++
	if yyhl1040 {
		yyb1040 = yyj1040 > l
	} else {
		yyb1040 = r.CheckBreak()
	}
	if yyb1040 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1040++
		if yyhl1040 {
			yyb1040 = yyj1040 > l
		} else {
			yyb1040 = r.CheckBreak()
		}
		if yyb1040 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1040-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Ingress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1049 := z.EncBinary()
		_ = yym1049
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1050 := !z.EncBinary()
			yy2arr1050 := z.EncBasicHandle().StructToArray
			var yyq1050 [5]bool
			_, _, _ = yysep1050, yyq1050, yy2arr1050
			const yyr1050 bool = false
			yyq1050[0] = x.Kind != ""
			yyq1050[1] = x.APIVersion != ""
			yyq1050[2] = true
			yyq1050[3] = true
			yyq1050[4] = true
			var yynn1050 int
			if yyr1050 || yy2arr1050 {
				r.EncodeArrayStart(5)
			} else {
				yynn1050 = 0
				for _, b := range yyq1050 {
					if b {
						yynn1050++
					}
				}
				r.EncodeMapStart(yynn1050)
				yynn1050 = 0
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[0] {
					yym1052 := z.EncBinary()
					_ = yym1052
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1050[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1053 := z.EncBinary()
					_ = yym1053
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[1] {
					yym1055 := z.EncBinary()
					_ = yym1055
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1050[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1056 := z.EncBinary()
					_ = yym1056
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[2] {
					yy1058 := &x.ObjectMeta
					yy1058.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1059 := &x.ObjectMeta
					yy1059.CodecEncodeSelf(e)
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[3] {
					yy1061 := &x.Spec
					yy1061.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1062 := &x.Spec
					yy1062.CodecEncodeSelf(e)
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1050[4] {
					yy1064 := &x.Status
					yy1064.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1050[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1065 := &x.Status
					yy1065.CodecEncodeSelf(e)
				}
			}
			if yyr1050 || yy2arr1050 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Ingress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1066 := z.DecBinary()
	_ = yym1066
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1067 := r.ContainerType()
		if yyct1067 == codecSelferValueTypeMap1234 {
			yyl1067 := r.ReadMapStart()
			if yyl1067 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1067, d)
			}
		} else if yyct1067 == codecSelferValueTypeArray1234 {
			yyl1067 := r.ReadArrayStart()
			if yyl1067 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1067, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Ingress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1068Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1068Slc
	var yyhl1068 bool = l >= 0
	for yyj1068 := 0; ; yyj1068++ {
		if yyhl1068 {
			if yyj1068 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1068Slc = r.DecodeBytes(yys1068Slc, true, true)
		yys1068 := string(yys1068Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1068 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1071 := &x.ObjectMeta
				yyv1071.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = IngressSpec{}
			} else {
				yyv1072 := &x.Spec
				yyv1072.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = IngressStatus{}
			} else {
				yyv1073 := &x.Status
				yyv1073.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1068)
		} // end switch yys1068
	} // end for yyj1068
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Ingress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1074 int
	var yyb1074 bool
	var yyhl1074 bool = l >= 0
	yyj1074++
	if yyhl1074 {
		yyb1074 = yyj1074 > l
	} else {
		yyb1074 = r.CheckBreak()
	}
	if yyb1074 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1074++
	if yyhl1074 {
		yyb1074 = yyj1074 > l
	} else {
		yyb1074 = r.CheckBreak()
	}
	if yyb1074 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1074++
	if yyhl1074 {
		yyb1074 = yyj1074 > l
	} else {
		yyb1074 = r.CheckBreak()
	}
	if yyb1074 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1077 := &x.ObjectMeta
		yyv1077.CodecDecodeSelf(d)
	}
	yyj1074++
	if yyhl1074 {
		yyb1074 = yyj1074 > l
	} else {
		yyb1074 = r.CheckBreak()
	}
	if yyb1074 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = IngressSpec{}
	} else {
		yyv1078 := &x.Spec
		yyv1078.CodecDecodeSelf(d)
	}
	yyj1074++
	if yyhl1074 {
		yyb1074 = yyj1074 > l
	} else {
		yyb1074 = r.CheckBreak()
	}
	if yyb1074 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = IngressStatus{}
	} else {
		yyv1079 := &x.Status
		yyv1079.CodecDecodeSelf(d)
	}
	for {
		yyj1074++
		if yyhl1074 {
			yyb1074 = yyj1074 > l
		} else {
			yyb1074 = r.CheckBreak()
		}
		if yyb1074 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1074-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1080 := z.EncBinary()
		_ = yym1080
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1081 := !z.EncBinary()
			yy2arr1081 := z.EncBasicHandle().StructToArray
			var yyq1081 [4]bool
			_, _, _ = yysep1081, yyq1081, yy2arr1081
			const yyr1081 bool = false
			yyq1081[0] = x.Kind != ""
			yyq1081[1] = x.APIVersion != ""
			yyq1081[2] = true
			var yynn1081 int
			if yyr1081 || yy2arr1081 {
				r.EncodeArrayStart(4)
			} else {
				yynn1081 = 1
				for _, b := range yyq1081 {
					if b {
						yynn1081++
					}
				}
				r.EncodeMapStart(yynn1081)
				yynn1081 = 0
			}
			if yyr1081 || yy2arr1081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1081[0] {
					yym1083 := z.EncBinary()
					_ = yym1083
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1081[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1084 := z.EncBinary()
					_ = yym1084
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1081 || yy2arr1081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1081[1] {
					yym1086 := z.EncBinary()
					_ = yym1086
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1081[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1087 := z.EncBinary()
					_ = yym1087
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1081 || yy2arr1081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1081[2] {
					yy1089 := &x.ListMeta
					yym1090 := z.EncBinary()
					_ = yym1090
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1089) {
					} else {
						z.EncFallback(yy1089)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1081[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1091 := &x.ListMeta
					yym1092 := z.EncBinary()
					_ = yym1092
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1091) {
					} else {
						z.EncFallback(yy1091)
					}
				}
			}
			if yyr1081 || yy2arr1081 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1094 := z.EncBinary()
					_ = yym1094
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1095 := z.EncBinary()
					_ = yym1095
					if false {
					} else {
						h.encSliceIngress(([]Ingress)(x.Items), e)
					}
				}
			}
			if yyr1081 || yy2arr1081 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1096 := z.DecBinary()
	_ = yym1096
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1097 := r.ContainerType()
		if yyct1097 == codecSelferValueTypeMap1234 {
			yyl1097 := r.ReadMapStart()
			if yyl1097 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1097, d)
			}
		} else if yyct1097 == codecSelferValueTypeArray1234 {
			yyl1097 := r.ReadArrayStart()
			if yyl1097 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1097, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1098Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1098Slc
	var yyhl1098 bool = l >= 0
	for yyj1098 := 0; ; yyj1098++ {
		if yyhl1098 {
			if yyj1098 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1098Slc = r.DecodeBytes(yys1098Slc, true, true)
		yys1098 := string(yys1098Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1098 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1101 := &x.ListMeta
				yym1102 := z.DecBinary()
				_ = yym1102
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1101) {
				} else {
					z.DecFallback(yyv1101, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1103 := &x.Items
				yym1104 := z.DecBinary()
				_ = yym1104
				if false {
				} else {
					h.decSliceIngress((*[]Ingress)(yyv1103), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1098)
		} // end switch yys1098
	} // end for yyj1098
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1105 int
	var yyb1105 bool
	var yyhl1105 bool = l >= 0
	yyj1105++
	if yyhl1105 {
		yyb1105 = yyj1105 > l
	} else {
		yyb1105 = r.CheckBreak()
	}
	if yyb1105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1105++
	if yyhl1105 {
		yyb1105 = yyj1105 > l
	} else {
		yyb1105 = r.CheckBreak()
	}
	if yyb1105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1105++
	if yyhl1105 {
		yyb1105 = yyj1105 > l
	} else {
		yyb1105 = r.CheckBreak()
	}
	if yyb1105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1108 := &x.ListMeta
		yym1109 := z.DecBinary()
		_ = yym1109
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1108) {
		} else {
			z.DecFallback(yyv1108, false)
		}
	}
	yyj1105++
	if yyhl1105 {
		yyb1105 = yyj1105 > l
	} else {
		yyb1105 = r.CheckBreak()
	}
	if yyb1105 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1110 := &x.Items
		yym1111 := z.DecBinary()
		_ = yym1111
		if false {
		} else {
			h.decSliceIngress((*[]Ingress)(yyv1110), d)
		}
	}
	for {
		yyj1105++
		if yyhl1105 {
			yyb1105 = yyj1105 > l
		} else {
			yyb1105 = r.CheckBreak()
		}
		if yyb1105 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1105-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1112 := z.EncBinary()
		_ = yym1112
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1113 := !z.EncBinary()
			yy2arr1113 := z.EncBasicHandle().StructToArray
			var yyq1113 [3]bool
			_, _, _ = yysep1113, yyq1113, yy2arr1113
			const yyr1113 bool = false
			yyq1113[0] = x.Backend != nil
			yyq1113[1] = len(x.TLS) != 0
			yyq1113[2] = len(x.Rules) != 0
			var yynn1113 int
			if yyr1113 || yy2arr1113 {
				r.EncodeArrayStart(3)
			} else {
				yynn1113 = 0
				for _, b := range yyq1113 {
					if b {
						yynn1113++
					}
				}
				r.EncodeMapStart(yynn1113)
				yynn1113 = 0
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1113[0] {
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1113[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("backend"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Backend == nil {
						r.EncodeNil()
					} else {
						x.Backend.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1113[1] {
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym1116 := z.EncBinary()
						_ = yym1116
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1113[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tls"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TLS == nil {
						r.EncodeNil()
					} else {
						yym1117 := z.EncBinary()
						_ = yym1117
						if false {
						} else {
							h.encSliceIngressTLS(([]IngressTLS)(x.TLS), e)
						}
					}
				}
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1113[2] {
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym1119 := z.EncBinary()
						_ = yym1119
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1113[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rules"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Rules == nil {
						r.EncodeNil()
					} else {
						yym1120 := z.EncBinary()
						_ = yym1120
						if false {
						} else {
							h.encSliceIngressRule(([]IngressRule)(x.Rules), e)
						}
					}
				}
			}
			if yyr1113 || yy2arr1113 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1121 := z.DecBinary()
	_ = yym1121
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1122 := r.ContainerType()
		if yyct1122 == codecSelferValueTypeMap1234 {
			yyl1122 := r.ReadMapStart()
			if yyl1122 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1122, d)
			}
		} else if yyct1122 == codecSelferValueTypeArray1234 {
			yyl1122 := r.ReadArrayStart()
			if yyl1122 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1122, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1123Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1123Slc
	var yyhl1123 bool = l >= 0
	for yyj1123 := 0; ; yyj1123++ {
		if yyhl1123 {
			if yyj1123 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1123Slc = r.DecodeBytes(yys1123Slc, true, true)
		yys1123 := string(yys1123Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1123 {
		case "backend":
			if r.TryDecodeAsNil() {
				if x.Backend != nil {
					x.Backend = nil
				}
			} else {
				if x.Backend == nil {
					x.Backend = new(IngressBackend)
				}
				x.Backend.CodecDecodeSelf(d)
			}
		case "tls":
			if r.TryDecodeAsNil() {
				x.TLS = nil
			} else {
				yyv1125 := &x.TLS
				yym1126 := z.DecBinary()
				_ = yym1126
				if false {
				} else {
					h.decSliceIngressTLS((*[]IngressTLS)(yyv1125), d)
				}
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv1127 := &x.Rules
				yym1128 := z.DecBinary()
				_ = yym1128
				if false {
				} else {
					h.decSliceIngressRule((*[]IngressRule)(yyv1127), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1123)
		} // end switch yys1123
	} // end for yyj1123
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1129 int
	var yyb1129 bool
	var yyhl1129 bool = l >= 0
	yyj1129++
	if yyhl1129 {
		yyb1129 = yyj1129 > l
	} else {
		yyb1129 = r.CheckBreak()
	}
	if yyb1129 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Backend != nil {
			x.Backend = nil
		}
	} else {
		if x.Backend == nil {
			x.Backend = new(IngressBackend)
		}
		x.Backend.CodecDecodeSelf(d)
	}
	yyj1129++
	if yyhl1129 {
		yyb1129 = yyj1129 > l
	} else {
		yyb1129 = r.CheckBreak()
	}
	if yyb1129 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TLS = nil
	} else {
		yyv1131 := &x.TLS
		yym1132 := z.DecBinary()
		_ = yym1132
		if false {
		} else {
			h.decSliceIngressTLS((*[]IngressTLS)(yyv1131), d)
		}
	}
	yyj1129++
	if yyhl1129 {
		yyb1129 = yyj1129 > l
	} else {
		yyb1129 = r.CheckBreak()
	}
	if yyb1129 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv1133 := &x.Rules
		yym1134 := z.DecBinary()
		_ = yym1134
		if false {
		} else {
			h.decSliceIngressRule((*[]IngressRule)(yyv1133), d)
		}
	}
	for {
		yyj1129++
		if yyhl1129 {
			yyb1129 = yyj1129 > l
		} else {
			yyb1129 = r.CheckBreak()
		}
		if yyb1129 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1129-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressTLS) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1135 := z.EncBinary()
		_ = yym1135
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1136 := !z.EncBinary()
			yy2arr1136 := z.EncBasicHandle().StructToArray
			var yyq1136 [2]bool
			_, _, _ = yysep1136, yyq1136, yy2arr1136
			const yyr1136 bool = false
			yyq1136[0] = len(x.Hosts) != 0
			yyq1136[1] = x.SecretName != ""
			var yynn1136 int
			if yyr1136 || yy2arr1136 {
				r.EncodeArrayStart(2)
			} else {
				yynn1136 = 0
				for _, b := range yyq1136 {
					if b {
						yynn1136++
					}
				}
				r.EncodeMapStart(yynn1136)
				yynn1136 = 0
			}
			if yyr1136 || yy2arr1136 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1136[0] {
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym1138 := z.EncBinary()
						_ = yym1138
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1136[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hosts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Hosts == nil {
						r.EncodeNil()
					} else {
						yym1139 := z.EncBinary()
						_ = yym1139
						if false {
						} else {
							z.F.EncSliceStringV(x.Hosts, false, e)
						}
					}
				}
			}
			if yyr1136 || yy2arr1136 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1136[1] {
					yym1141 := z.EncBinary()
					_ = yym1141
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1136[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1142 := z.EncBinary()
					_ = yym1142
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr1136 || yy2arr1136 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressTLS) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1143 := z.DecBinary()
	_ = yym1143
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1144 := r.ContainerType()
		if yyct1144 == codecSelferValueTypeMap1234 {
			yyl1144 := r.ReadMapStart()
			if yyl1144 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1144, d)
			}
		} else if yyct1144 == codecSelferValueTypeArray1234 {
			yyl1144 := r.ReadArrayStart()
			if yyl1144 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1144, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressTLS) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1145Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1145Slc
	var yyhl1145 bool = l >= 0
	for yyj1145 := 0; ; yyj1145++ {
		if yyhl1145 {
			if yyj1145 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1145Slc = r.DecodeBytes(yys1145Slc, true, true)
		yys1145 := string(yys1145Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1145 {
		case "hosts":
			if r.TryDecodeAsNil() {
				x.Hosts = nil
			} else {
				yyv1146 := &x.Hosts
				yym1147 := z.DecBinary()
				_ = yym1147
				if false {
				} else {
					z.F.DecSliceStringX(yyv1146, false, d)
				}
			}
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				x.SecretName = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1145)
		} // end switch yys1145
	} // end for yyj1145
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressTLS) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1149 int
	var yyb1149 bool
	var yyhl1149 bool = l >= 0
	yyj1149++
	if yyhl1149 {
		yyb1149 = yyj1149 > l
	} else {
		yyb1149 = r.CheckBreak()
	}
	if yyb1149 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hosts = nil
	} else {
		yyv1150 := &x.Hosts
		yym1151 := z.DecBinary()
		_ = yym1151
		if false {
		} else {
			z.F.DecSliceStringX(yyv1150, false, d)
		}
	}
	yyj1149++
	if yyhl1149 {
		yyb1149 = yyj1149 > l
	} else {
		yyb1149 = r.CheckBreak()
	}
	if yyb1149 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		x.SecretName = string(r.DecodeString())
	}
	for {
		yyj1149++
		if yyhl1149 {
			yyb1149 = yyj1149 > l
		} else {
			yyb1149 = r.CheckBreak()
		}
		if yyb1149 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1149-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1153 := z.EncBinary()
		_ = yym1153
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1154 := !z.EncBinary()
			yy2arr1154 := z.EncBasicHandle().StructToArray
			var yyq1154 [1]bool
			_, _, _ = yysep1154, yyq1154, yy2arr1154
			const yyr1154 bool = false
			yyq1154[0] = true
			var yynn1154 int
			if yyr1154 || yy2arr1154 {
				r.EncodeArrayStart(1)
			} else {
				yynn1154 = 0
				for _, b := range yyq1154 {
					if b {
						yynn1154++
					}
				}
				r.EncodeMapStart(yynn1154)
				yynn1154 = 0
			}
			if yyr1154 || yy2arr1154 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1154[0] {
					yy1156 := &x.LoadBalancer
					yy1156.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1154[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1157 := &x.LoadBalancer
					yy1157.CodecEncodeSelf(e)
				}
			}
			if yyr1154 || yy2arr1154 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1158 := z.DecBinary()
	_ = yym1158
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1159 := r.ContainerType()
		if yyct1159 == codecSelferValueTypeMap1234 {
			yyl1159 := r.ReadMapStart()
			if yyl1159 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1159, d)
			}
		} else if yyct1159 == codecSelferValueTypeArray1234 {
			yyl1159 := r.ReadArrayStart()
			if yyl1159 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1159, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1160Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1160Slc
	var yyhl1160 bool = l >= 0
	for yyj1160 := 0; ; yyj1160++ {
		if yyhl1160 {
			if yyj1160 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1160Slc = r.DecodeBytes(yys1160Slc, true, true)
		yys1160 := string(yys1160Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1160 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = pkg2_v1.LoadBalancerStatus{}
			} else {
				yyv1161 := &x.LoadBalancer
				yyv1161.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1160)
		} // end switch yys1160
	} // end for yyj1160
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1162 int
	var yyb1162 bool
	var yyhl1162 bool = l >= 0
	yyj1162++
	if yyhl1162 {
		yyb1162 = yyj1162 > l
	} else {
		yyb1162 = r.CheckBreak()
	}
	if yyb1162 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = pkg2_v1.LoadBalancerStatus{}
	} else {
		yyv1163 := &x.LoadBalancer
		yyv1163.CodecDecodeSelf(d)
	}
	for {
		yyj1162++
		if yyhl1162 {
			yyb1162 = yyj1162 > l
		} else {
			yyb1162 = r.CheckBreak()
		}
		if yyb1162 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1162-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1164 := z.EncBinary()
		_ = yym1164
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1165 := !z.EncBinary()
			yy2arr1165 := z.EncBasicHandle().StructToArray
			var yyq1165 [2]bool
			_, _, _ = yysep1165, yyq1165, yy2arr1165
			const yyr1165 bool = false
			yyq1165[0] = x.Host != ""
			yyq1165[1] = x.IngressRuleValue.HTTP != nil && x.HTTP != nil
			var yynn1165 int
			if yyr1165 || yy2arr1165 {
				r.EncodeArrayStart(2)
			} else {
				yynn1165 = 0
				for _, b := range yyq1165 {
					if b {
						yynn1165++
					}
				}
				r.EncodeMapStart(yynn1165)
				yynn1165 = 0
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1165[0] {
					yym1167 := z.EncBinary()
					_ = yym1167
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1165[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1168 := z.EncBinary()
					_ = yym1168
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			var yyn1169 bool
			if x.IngressRuleValue.HTTP == nil {
				yyn1169 = true
				goto LABEL1169
			}
		LABEL1169:
			if yyr1165 || yy2arr1165 {
				if yyn1169 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq1165[1] {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq1165[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn1169 {
						r.EncodeNil()
					} else {
						if x.HTTP == nil {
							r.EncodeNil()
						} else {
							x.HTTP.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr1165 || yy2arr1165 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1170 := z.DecBinary()
	_ = yym1170
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1171 := r.ContainerType()
		if yyct1171 == codecSelferValueTypeMap1234 {
			yyl1171 := r.ReadMapStart()
			if yyl1171 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1171, d)
			}
		} else if yyct1171 == codecSelferValueTypeArray1234 {
			yyl1171 := r.ReadArrayStart()
			if yyl1171 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1171, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1172Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1172Slc
	var yyhl1172 bool = l >= 0
	for yyj1172 := 0; ; yyj1172++ {
		if yyhl1172 {
			if yyj1172 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1172Slc = r.DecodeBytes(yys1172Slc, true, true)
		yys1172 := string(yys1172Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1172 {
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				x.Host = string(r.DecodeString())
			}
		case "http":
			if x.IngressRuleValue.HTTP == nil {
				x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
			}
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1172)
		} // end switch yys1172
	} // end for yyj1172
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1175 int
	var yyb1175 bool
	var yyhl1175 bool = l >= 0
	yyj1175++
	if yyhl1175 {
		yyb1175 = yyj1175 > l
	} else {
		yyb1175 = r.CheckBreak()
	}
	if yyb1175 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		x.Host = string(r.DecodeString())
	}
	if x.IngressRuleValue.HTTP == nil {
		x.IngressRuleValue.HTTP = new(HTTPIngressRuleValue)
	}
	yyj1175++
	if yyhl1175 {
		yyb1175 = yyj1175 > l
	} else {
		yyb1175 = r.CheckBreak()
	}
	if yyb1175 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj1175++
		if yyhl1175 {
			yyb1175 = yyj1175 > l
		} else {
			yyb1175 = r.CheckBreak()
		}
		if yyb1175 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1175-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1178 := z.EncBinary()
		_ = yym1178
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1179 := !z.EncBinary()
			yy2arr1179 := z.EncBasicHandle().StructToArray
			var yyq1179 [1]bool
			_, _, _ = yysep1179, yyq1179, yy2arr1179
			const yyr1179 bool = false
			yyq1179[0] = x.HTTP != nil
			var yynn1179 int
			if yyr1179 || yy2arr1179 {
				r.EncodeArrayStart(1)
			} else {
				yynn1179 = 0
				for _, b := range yyq1179 {
					if b {
						yynn1179++
					}
				}
				r.EncodeMapStart(yynn1179)
				yynn1179 = 0
			}
			if yyr1179 || yy2arr1179 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1179[0] {
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1179[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("http"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTP == nil {
						r.EncodeNil()
					} else {
						x.HTTP.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1179 || yy2arr1179 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1181 := z.DecBinary()
	_ = yym1181
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1182 := r.ContainerType()
		if yyct1182 == codecSelferValueTypeMap1234 {
			yyl1182 := r.ReadMapStart()
			if yyl1182 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1182, d)
			}
		} else if yyct1182 == codecSelferValueTypeArray1234 {
			yyl1182 := r.ReadArrayStart()
			if yyl1182 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1182, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1183Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1183Slc
	var yyhl1183 bool = l >= 0
	for yyj1183 := 0; ; yyj1183++ {
		if yyhl1183 {
			if yyj1183 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1183Slc = r.DecodeBytes(yys1183Slc, true, true)
		yys1183 := string(yys1183Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1183 {
		case "http":
			if r.TryDecodeAsNil() {
				if x.HTTP != nil {
					x.HTTP = nil
				}
			} else {
				if x.HTTP == nil {
					x.HTTP = new(HTTPIngressRuleValue)
				}
				x.HTTP.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1183)
		} // end switch yys1183
	} // end for yyj1183
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1185 int
	var yyb1185 bool
	var yyhl1185 bool = l >= 0
	yyj1185++
	if yyhl1185 {
		yyb1185 = yyj1185 > l
	} else {
		yyb1185 = r.CheckBreak()
	}
	if yyb1185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTP != nil {
			x.HTTP = nil
		}
	} else {
		if x.HTTP == nil {
			x.HTTP = new(HTTPIngressRuleValue)
		}
		x.HTTP.CodecDecodeSelf(d)
	}
	for {
		yyj1185++
		if yyhl1185 {
			yyb1185 = yyj1185 > l
		} else {
			yyb1185 = r.CheckBreak()
		}
		if yyb1185 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1185-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressRuleValue) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1187 := z.EncBinary()
		_ = yym1187
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1188 := !z.EncBinary()
			yy2arr1188 := z.EncBasicHandle().StructToArray
			var yyq1188 [1]bool
			_, _, _ = yysep1188, yyq1188, yy2arr1188
			const yyr1188 bool = false
			var yynn1188 int
			if yyr1188 || yy2arr1188 {
				r.EncodeArrayStart(1)
			} else {
				yynn1188 = 1
				for _, b := range yyq1188 {
					if b {
						yynn1188++
					}
				}
				r.EncodeMapStart(yynn1188)
				yynn1188 = 0
			}
			if yyr1188 || yy2arr1188 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym1190 := z.EncBinary()
					_ = yym1190
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("paths"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Paths == nil {
					r.EncodeNil()
				} else {
					yym1191 := z.EncBinary()
					_ = yym1191
					if false {
					} else {
						h.encSliceHTTPIngressPath(([]HTTPIngressPath)(x.Paths), e)
					}
				}
			}
			if yyr1188 || yy2arr1188 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressRuleValue) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1192 := z.DecBinary()
	_ = yym1192
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1193 := r.ContainerType()
		if yyct1193 == codecSelferValueTypeMap1234 {
			yyl1193 := r.ReadMapStart()
			if yyl1193 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1193, d)
			}
		} else if yyct1193 == codecSelferValueTypeArray1234 {
			yyl1193 := r.ReadArrayStart()
			if yyl1193 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1193, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1194Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1194Slc
	var yyhl1194 bool = l >= 0
	for yyj1194 := 0; ; yyj1194++ {
		if yyhl1194 {
			if yyj1194 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1194Slc = r.DecodeBytes(yys1194Slc, true, true)
		yys1194 := string(yys1194Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1194 {
		case "paths":
			if r.TryDecodeAsNil() {
				x.Paths = nil
			} else {
				yyv1195 := &x.Paths
				yym1196 := z.DecBinary()
				_ = yym1196
				if false {
				} else {
					h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv1195), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1194)
		} // end switch yys1194
	} // end for yyj1194
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressRuleValue) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1197 int
	var yyb1197 bool
	var yyhl1197 bool = l >= 0
	yyj1197++
	if yyhl1197 {
		yyb1197 = yyj1197 > l
	} else {
		yyb1197 = r.CheckBreak()
	}
	if yyb1197 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Paths = nil
	} else {
		yyv1198 := &x.Paths
		yym1199 := z.DecBinary()
		_ = yym1199
		if false {
		} else {
			h.decSliceHTTPIngressPath((*[]HTTPIngressPath)(yyv1198), d)
		}
	}
	for {
		yyj1197++
		if yyhl1197 {
			yyb1197 = yyj1197 > l
		} else {
			yyb1197 = r.CheckBreak()
		}
		if yyb1197 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1197-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPIngressPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1200 := z.EncBinary()
		_ = yym1200
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1201 := !z.EncBinary()
			yy2arr1201 := z.EncBasicHandle().StructToArray
			var yyq1201 [2]bool
			_, _, _ = yysep1201, yyq1201, yy2arr1201
			const yyr1201 bool = false
			yyq1201[0] = x.Path != ""
			var yynn1201 int
			if yyr1201 || yy2arr1201 {
				r.EncodeArrayStart(2)
			} else {
				yynn1201 = 1
				for _, b := range yyq1201 {
					if b {
						yynn1201++
					}
				}
				r.EncodeMapStart(yynn1201)
				yynn1201 = 0
			}
			if yyr1201 || yy2arr1201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1201[0] {
					yym1203 := z.EncBinary()
					_ = yym1203
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1201[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1204 := z.EncBinary()
					_ = yym1204
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr1201 || yy2arr1201 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1206 := &x.Backend
				yy1206.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("backend"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1207 := &x.Backend
				yy1207.CodecEncodeSelf(e)
			}
			if yyr1201 || yy2arr1201 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPIngressPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1208 := z.DecBinary()
	_ = yym1208
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1209 := r.ContainerType()
		if yyct1209 == codecSelferValueTypeMap1234 {
			yyl1209 := r.ReadMapStart()
			if yyl1209 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1209, d)
			}
		} else if yyct1209 == codecSelferValueTypeArray1234 {
			yyl1209 := r.ReadArrayStart()
			if yyl1209 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1209, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPIngressPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1210Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1210Slc
	var yyhl1210 bool = l >= 0
	for yyj1210 := 0; ; yyj1210++ {
		if yyhl1210 {
			if yyj1210 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1210Slc = r.DecodeBytes(yys1210Slc, true, true)
		yys1210 := string(yys1210Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1210 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				x.Path = string(r.DecodeString())
			}
		case "backend":
			if r.TryDecodeAsNil() {
				x.Backend = IngressBackend{}
			} else {
				yyv1212 := &x.Backend
				yyv1212.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1210)
		} // end switch yys1210
	} // end for yyj1210
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPIngressPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1213 int
	var yyb1213 bool
	var yyhl1213 bool = l >= 0
	yyj1213++
	if yyhl1213 {
		yyb1213 = yyj1213 > l
	} else {
		yyb1213 = r.CheckBreak()
	}
	if yyb1213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		x.Path = string(r.DecodeString())
	}
	yyj1213++
	if yyhl1213 {
		yyb1213 = yyj1213 > l
	} else {
		yyb1213 = r.CheckBreak()
	}
	if yyb1213 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Backend = IngressBackend{}
	} else {
		yyv1215 := &x.Backend
		yyv1215.CodecDecodeSelf(d)
	}
	for {
		yyj1213++
		if yyhl1213 {
			yyb1213 = yyj1213 > l
		} else {
			yyb1213 = r.CheckBreak()
		}
		if yyb1213 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1213-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IngressBackend) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1216 := z.EncBinary()
		_ = yym1216
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1217 := !z.EncBinary()
			yy2arr1217 := z.EncBasicHandle().StructToArray
			var yyq1217 [2]bool
			_, _, _ = yysep1217, yyq1217, yy2arr1217
			const yyr1217 bool = false
			var yynn1217 int
			if yyr1217 || yy2arr1217 {
				r.EncodeArrayStart(2)
			} else {
				yynn1217 = 2
				for _, b := range yyq1217 {
					if b {
						yynn1217++
					}
				}
				r.EncodeMapStart(yynn1217)
				yynn1217 = 0
			}
			if yyr1217 || yy2arr1217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1219 := z.EncBinary()
				_ = yym1219
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("serviceName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1220 := z.EncBinary()
				_ = yym1220
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ServiceName))
				}
			}
			if yyr1217 || yy2arr1217 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1222 := &x.ServicePort
				yym1223 := z.EncBinary()
				_ = yym1223
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1222) {
				} else if !yym1223 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1222)
				} else {
					z.EncFallback(yy1222)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("servicePort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1224 := &x.ServicePort
				yym1225 := z.EncBinary()
				_ = yym1225
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1224) {
				} else if !yym1225 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy1224)
				} else {
					z.EncFallback(yy1224)
				}
			}
			if yyr1217 || yy2arr1217 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IngressBackend) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1226 := z.DecBinary()
	_ = yym1226
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1227 := r.ContainerType()
		if yyct1227 == codecSelferValueTypeMap1234 {
			yyl1227 := r.ReadMapStart()
			if yyl1227 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1227, d)
			}
		} else if yyct1227 == codecSelferValueTypeArray1234 {
			yyl1227 := r.ReadArrayStart()
			if yyl1227 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1227, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IngressBackend) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1228Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1228Slc
	var yyhl1228 bool = l >= 0
	for yyj1228 := 0; ; yyj1228++ {
		if yyhl1228 {
			if yyj1228 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1228Slc = r.DecodeBytes(yys1228Slc, true, true)
		yys1228 := string(yys1228Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1228 {
		case "serviceName":
			if r.TryDecodeAsNil() {
				x.ServiceName = ""
			} else {
				x.ServiceName = string(r.DecodeString())
			}
		case "servicePort":
			if r.TryDecodeAsNil() {
				x.ServicePort = pkg5_intstr.IntOrString{}
			} else {
				yyv1230 := &x.ServicePort
				yym1231 := z.DecBinary()
				_ = yym1231
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1230) {
				} else if !yym1231 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1230)
				} else {
					z.DecFallback(yyv1230, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1228)
		} // end switch yys1228
	} // end for yyj1228
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IngressBackend) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1232 int
	var yyb1232 bool
	var yyhl1232 bool = l >= 0
	yyj1232++
	if yyhl1232 {
		yyb1232 = yyj1232 > l
	} else {
		yyb1232 = r.CheckBreak()
	}
	if yyb1232 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceName = ""
	} else {
		x.ServiceName = string(r.DecodeString())
	}
	yyj1232++
	if yyhl1232 {
		yyb1232 = yyj1232 > l
	} else {
		yyb1232 = r.CheckBreak()
	}
	if yyb1232 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServicePort = pkg5_intstr.IntOrString{}
	} else {
		yyv1234 := &x.ServicePort
		yym1235 := z.DecBinary()
		_ = yym1235
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1234) {
		} else if !yym1235 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1234)
		} else {
			z.DecFallback(yyv1234, false)
		}
	}
	for {
		yyj1232++
		if yyhl1232 {
			yyb1232 = yyj1232 > l
		} else {
			yyb1232 = r.CheckBreak()
		}
		if yyb1232 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1232-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExportOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1236 := z.EncBinary()
		_ = yym1236
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1237 := !z.EncBinary()
			yy2arr1237 := z.EncBasicHandle().StructToArray
			var yyq1237 [4]bool
			_, _, _ = yysep1237, yyq1237, yy2arr1237
			const yyr1237 bool = false
			yyq1237[0] = x.Kind != ""
			yyq1237[1] = x.APIVersion != ""
			var yynn1237 int
			if yyr1237 || yy2arr1237 {
				r.EncodeArrayStart(4)
			} else {
				yynn1237 = 2
				for _, b := range yyq1237 {
					if b {
						yynn1237++
					}
				}
				r.EncodeMapStart(yynn1237)
				yynn1237 = 0
			}
			if yyr1237 || yy2arr1237 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1237[0] {
					yym1239 := z.EncBinary()
					_ = yym1239
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1237[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1240 := z.EncBinary()
					_ = yym1240
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1237 || yy2arr1237 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1237[1] {
					yym1242 := z.EncBinary()
					_ = yym1242
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1237[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1243 := z.EncBinary()
					_ = yym1243
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1237 || yy2arr1237 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1245 := z.EncBinary()
				_ = yym1245
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("export"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1246 := z.EncBinary()
				_ = yym1246
				if false {
				} else {
					r.EncodeBool(bool(x.Export))
				}
			}
			if yyr1237 || yy2arr1237 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1248 := z.EncBinary()
				_ = yym1248
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exact"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1249 := z.EncBinary()
				_ = yym1249
				if false {
				} else {
					r.EncodeBool(bool(x.Exact))
				}
			}
			if yyr1237 || yy2arr1237 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExportOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1250 := z.DecBinary()
	_ = yym1250
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1251 := r.ContainerType()
		if yyct1251 == codecSelferValueTypeMap1234 {
			yyl1251 := r.ReadMapStart()
			if yyl1251 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1251, d)
			}
		} else if yyct1251 == codecSelferValueTypeArray1234 {
			yyl1251 := r.ReadArrayStart()
			if yyl1251 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1251, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExportOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1252Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1252Slc
	var yyhl1252 bool = l >= 0
	for yyj1252 := 0; ; yyj1252++ {
		if yyhl1252 {
			if yyj1252 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1252Slc = r.DecodeBytes(yys1252Slc, true, true)
		yys1252 := string(yys1252Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1252 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "export":
			if r.TryDecodeAsNil() {
				x.Export = false
			} else {
				x.Export = bool(r.DecodeBool())
			}
		case "exact":
			if r.TryDecodeAsNil() {
				x.Exact = false
			} else {
				x.Exact = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1252)
		} // end switch yys1252
	} // end for yyj1252
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExportOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1257 int
	var yyb1257 bool
	var yyhl1257 bool = l >= 0
	yyj1257++
	if yyhl1257 {
		yyb1257 = yyj1257 > l
	} else {
		yyb1257 = r.CheckBreak()
	}
	if yyb1257 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1257++
	if yyhl1257 {
		yyb1257 = yyj1257 > l
	} else {
		yyb1257 = r.CheckBreak()
	}
	if yyb1257 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1257++
	if yyhl1257 {
		yyb1257 = yyj1257 > l
	} else {
		yyb1257 = r.CheckBreak()
	}
	if yyb1257 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Export = false
	} else {
		x.Export = bool(r.DecodeBool())
	}
	yyj1257++
	if yyhl1257 {
		yyb1257 = yyj1257 > l
	} else {
		yyb1257 = r.CheckBreak()
	}
	if yyb1257 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Exact = false
	} else {
		x.Exact = bool(r.DecodeBool())
	}
	for {
		yyj1257++
		if yyhl1257 {
			yyb1257 = yyj1257 > l
		} else {
			yyb1257 = r.CheckBreak()
		}
		if yyb1257 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1257-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSet) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1262 := z.EncBinary()
		_ = yym1262
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1263 := !z.EncBinary()
			yy2arr1263 := z.EncBasicHandle().StructToArray
			var yyq1263 [5]bool
			_, _, _ = yysep1263, yyq1263, yy2arr1263
			const yyr1263 bool = false
			yyq1263[0] = x.Kind != ""
			yyq1263[1] = x.APIVersion != ""
			yyq1263[2] = true
			yyq1263[3] = true
			yyq1263[4] = true
			var yynn1263 int
			if yyr1263 || yy2arr1263 {
				r.EncodeArrayStart(5)
			} else {
				yynn1263 = 0
				for _, b := range yyq1263 {
					if b {
						yynn1263++
					}
				}
				r.EncodeMapStart(yynn1263)
				yynn1263 = 0
			}
			if yyr1263 || yy2arr1263 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1263[0] {
					yym1265 := z.EncBinary()
					_ = yym1265
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1263[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1266 := z.EncBinary()
					_ = yym1266
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1263 || yy2arr1263 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1263[1] {
					yym1268 := z.EncBinary()
					_ = yym1268
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1263[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1269 := z.EncBinary()
					_ = yym1269
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1263 || yy2arr1263 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1263[2] {
					yy1271 := &x.ObjectMeta
					yy1271.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1263[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1272 := &x.ObjectMeta
					yy1272.CodecEncodeSelf(e)
				}
			}
			if yyr1263 || yy2arr1263 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1263[3] {
					yy1274 := &x.Spec
					yy1274.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1263[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1275 := &x.Spec
					yy1275.CodecEncodeSelf(e)
				}
			}
			if yyr1263 || yy2arr1263 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1263[4] {
					yy1277 := &x.Status
					yy1277.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1263[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1278 := &x.Status
					yy1278.CodecEncodeSelf(e)
				}
			}
			if yyr1263 || yy2arr1263 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSet) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1279 := z.DecBinary()
	_ = yym1279
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1280 := r.ContainerType()
		if yyct1280 == codecSelferValueTypeMap1234 {
			yyl1280 := r.ReadMapStart()
			if yyl1280 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1280, d)
			}
		} else if yyct1280 == codecSelferValueTypeArray1234 {
			yyl1280 := r.ReadArrayStart()
			if yyl1280 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1280, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSet) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1281Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1281Slc
	var yyhl1281 bool = l >= 0
	for yyj1281 := 0; ; yyj1281++ {
		if yyhl1281 {
			if yyj1281 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1281Slc = r.DecodeBytes(yys1281Slc, true, true)
		yys1281 := string(yys1281Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1281 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1284 := &x.ObjectMeta
				yyv1284.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicaSetSpec{}
			} else {
				yyv1285 := &x.Spec
				yyv1285.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicaSetStatus{}
			} else {
				yyv1286 := &x.Status
				yyv1286.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1281)
		} // end switch yys1281
	} // end for yyj1281
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSet) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1287 int
	var yyb1287 bool
	var yyhl1287 bool = l >= 0
	yyj1287++
	if yyhl1287 {
		yyb1287 = yyj1287 > l
	} else {
		yyb1287 = r.CheckBreak()
	}
	if yyb1287 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1287++
	if yyhl1287 {
		yyb1287 = yyj1287 > l
	} else {
		yyb1287 = r.CheckBreak()
	}
	if yyb1287 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1287++
	if yyhl1287 {
		yyb1287 = yyj1287 > l
	} else {
		yyb1287 = r.CheckBreak()
	}
	if yyb1287 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1290 := &x.ObjectMeta
		yyv1290.CodecDecodeSelf(d)
	}
	yyj1287++
	if yyhl1287 {
		yyb1287 = yyj1287 > l
	} else {
		yyb1287 = r.CheckBreak()
	}
	if yyb1287 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicaSetSpec{}
	} else {
		yyv1291 := &x.Spec
		yyv1291.CodecDecodeSelf(d)
	}
	yyj1287++
	if yyhl1287 {
		yyb1287 = yyj1287 > l
	} else {
		yyb1287 = r.CheckBreak()
	}
	if yyb1287 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicaSetStatus{}
	} else {
		yyv1292 := &x.Status
		yyv1292.CodecDecodeSelf(d)
	}
	for {
		yyj1287++
		if yyhl1287 {
			yyb1287 = yyj1287 > l
		} else {
			yyb1287 = r.CheckBreak()
		}
		if yyb1287 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1287-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1293 := z.EncBinary()
		_ = yym1293
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1294 := !z.EncBinary()
			yy2arr1294 := z.EncBasicHandle().StructToArray
			var yyq1294 [4]bool
			_, _, _ = yysep1294, yyq1294, yy2arr1294
			const yyr1294 bool = false
			yyq1294[0] = x.Kind != ""
			yyq1294[1] = x.APIVersion != ""
			yyq1294[2] = true
			var yynn1294 int
			if yyr1294 || yy2arr1294 {
				r.EncodeArrayStart(4)
			} else {
				yynn1294 = 1
				for _, b := range yyq1294 {
					if b {
						yynn1294++
					}
				}
				r.EncodeMapStart(yynn1294)
				yynn1294 = 0
			}
			if yyr1294 || yy2arr1294 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1294[0] {
					yym1296 := z.EncBinary()
					_ = yym1296
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1294[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1297 := z.EncBinary()
					_ = yym1297
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1294 || yy2arr1294 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1294[1] {
					yym1299 := z.EncBinary()
					_ = yym1299
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1294[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1300 := z.EncBinary()
					_ = yym1300
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1294 || yy2arr1294 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1294[2] {
					yy1302 := &x.ListMeta
					yym1303 := z.EncBinary()
					_ = yym1303
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1302) {
					} else {
						z.EncFallback(yy1302)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1294[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1304 := &x.ListMeta
					yym1305 := z.EncBinary()
					_ = yym1305
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1304) {
					} else {
						z.EncFallback(yy1304)
					}
				}
			}
			if yyr1294 || yy2arr1294 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1307 := z.EncBinary()
					_ = yym1307
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1308 := z.EncBinary()
					_ = yym1308
					if false {
					} else {
						h.encSliceReplicaSet(([]ReplicaSet)(x.Items), e)
					}
				}
			}
			if yyr1294 || yy2arr1294 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1309 := z.DecBinary()
	_ = yym1309
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1310 := r.ContainerType()
		if yyct1310 == codecSelferValueTypeMap1234 {
			yyl1310 := r.ReadMapStart()
			if yyl1310 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1310, d)
			}
		} else if yyct1310 == codecSelferValueTypeArray1234 {
			yyl1310 := r.ReadArrayStart()
			if yyl1310 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1310, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1311Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1311Slc
	var yyhl1311 bool = l >= 0
	for yyj1311 := 0; ; yyj1311++ {
		if yyhl1311 {
			if yyj1311 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1311Slc = r.DecodeBytes(yys1311Slc, true, true)
		yys1311 := string(yys1311Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1311 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1314 := &x.ListMeta
				yym1315 := z.DecBinary()
				_ = yym1315
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1314) {
				} else {
					z.DecFallback(yyv1314, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1316 := &x.Items
				yym1317 := z.DecBinary()
				_ = yym1317
				if false {
				} else {
					h.decSliceReplicaSet((*[]ReplicaSet)(yyv1316), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1311)
		} // end switch yys1311
	} // end for yyj1311
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1318 int
	var yyb1318 bool
	var yyhl1318 bool = l >= 0
	yyj1318++
	if yyhl1318 {
		yyb1318 = yyj1318 > l
	} else {
		yyb1318 = r.CheckBreak()
	}
	if yyb1318 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1318++
	if yyhl1318 {
		yyb1318 = yyj1318 > l
	} else {
		yyb1318 = r.CheckBreak()
	}
	if yyb1318 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1318++
	if yyhl1318 {
		yyb1318 = yyj1318 > l
	} else {
		yyb1318 = r.CheckBreak()
	}
	if yyb1318 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1321 := &x.ListMeta
		yym1322 := z.DecBinary()
		_ = yym1322
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1321) {
		} else {
			z.DecFallback(yyv1321, false)
		}
	}
	yyj1318++
	if yyhl1318 {
		yyb1318 = yyj1318 > l
	} else {
		yyb1318 = r.CheckBreak()
	}
	if yyb1318 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1323 := &x.Items
		yym1324 := z.DecBinary()
		_ = yym1324
		if false {
		} else {
			h.decSliceReplicaSet((*[]ReplicaSet)(yyv1323), d)
		}
	}
	for {
		yyj1318++
		if yyhl1318 {
			yyb1318 = yyj1318 > l
		} else {
			yyb1318 = r.CheckBreak()
		}
		if yyb1318 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1318-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1325 := z.EncBinary()
		_ = yym1325
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1326 := !z.EncBinary()
			yy2arr1326 := z.EncBasicHandle().StructToArray
			var yyq1326 [4]bool
			_, _, _ = yysep1326, yyq1326, yy2arr1326
			const yyr1326 bool = false
			yyq1326[0] = x.Replicas != nil
			yyq1326[1] = x.MinReadySeconds != 0
			yyq1326[2] = x.Selector != nil
			yyq1326[3] = true
			var yynn1326 int
			if yyr1326 || yy2arr1326 {
				r.EncodeArrayStart(4)
			} else {
				yynn1326 = 0
				for _, b := range yyq1326 {
					if b {
						yynn1326++
					}
				}
				r.EncodeMapStart(yynn1326)
				yynn1326 = 0
			}
			if yyr1326 || yy2arr1326 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1326[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy1328 := *x.Replicas
						yym1329 := z.EncBinary()
						_ = yym1329
						if false {
						} else {
							r.EncodeInt(int64(yy1328))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1326[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy1330 := *x.Replicas
						yym1331 := z.EncBinary()
						_ = yym1331
						if false {
						} else {
							r.EncodeInt(int64(yy1330))
						}
					}
				}
			}
			if yyr1326 || yy2arr1326 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1326[1] {
					yym1333 := z.EncBinary()
					_ = yym1333
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1326[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1334 := z.EncBinary()
					_ = yym1334
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr1326 || yy2arr1326 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1326[2] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym1336 := z.EncBinary()
						_ = yym1336
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1326[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym1337 := z.EncBinary()
						_ = yym1337
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr1326 || yy2arr1326 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1326[3] {
					yy1339 := &x.Template
					yy1339.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1326[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1340 := &x.Template
					yy1340.CodecEncodeSelf(e)
				}
			}
			if yyr1326 || yy2arr1326 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1341 := z.DecBinary()
	_ = yym1341
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1342 := r.ContainerType()
		if yyct1342 == codecSelferValueTypeMap1234 {
			yyl1342 := r.ReadMapStart()
			if yyl1342 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1342, d)
			}
		} else if yyct1342 == codecSelferValueTypeArray1234 {
			yyl1342 := r.ReadArrayStart()
			if yyl1342 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1342, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1343Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1343Slc
	var yyhl1343 bool = l >= 0
	for yyj1343 := 0; ; yyj1343++ {
		if yyhl1343 {
			if yyj1343 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1343Slc = r.DecodeBytes(yys1343Slc, true, true)
		yys1343 := string(yys1343Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1343 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym1345 := z.DecBinary()
				_ = yym1345
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				x.MinReadySeconds = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg1_unversioned.LabelSelector)
				}
				yym1348 := z.DecBinary()
				_ = yym1348
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = pkg2_v1.PodTemplateSpec{}
			} else {
				yyv1349 := &x.Template
				yyv1349.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1343)
		} // end switch yys1343
	} // end for yyj1343
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1350 int
	var yyb1350 bool
	var yyhl1350 bool = l >= 0
	yyj1350++
	if yyhl1350 {
		yyb1350 = yyj1350 > l
	} else {
		yyb1350 = r.CheckBreak()
	}
	if yyb1350 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym1352 := z.DecBinary()
		_ = yym1352
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj1350++
	if yyhl1350 {
		yyb1350 = yyj1350 > l
	} else {
		yyb1350 = r.CheckBreak()
	}
	if yyb1350 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		x.MinReadySeconds = int32(r.DecodeInt(32))
	}
	yyj1350++
	if yyhl1350 {
		yyb1350 = yyj1350 > l
	} else {
		yyb1350 = r.CheckBreak()
	}
	if yyb1350 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg1_unversioned.LabelSelector)
		}
		yym1355 := z.DecBinary()
		_ = yym1355
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj1350++
	if yyhl1350 {
		yyb1350 = yyj1350 > l
	} else {
		yyb1350 = r.CheckBreak()
	}
	if yyb1350 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = pkg2_v1.PodTemplateSpec{}
	} else {
		yyv1356 := &x.Template
		yyv1356.CodecDecodeSelf(d)
	}
	for {
		yyj1350++
		if yyhl1350 {
			yyb1350 = yyj1350 > l
		} else {
			yyb1350 = r.CheckBreak()
		}
		if yyb1350 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1350-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicaSetStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1357 := z.EncBinary()
		_ = yym1357
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1358 := !z.EncBinary()
			yy2arr1358 := z.EncBasicHandle().StructToArray
			var yyq1358 [6]bool
			_, _, _ = yysep1358, yyq1358, yy2arr1358
			const yyr1358 bool = false
			yyq1358[1] = x.FullyLabeledReplicas != 0
			yyq1358[2] = x.ReadyReplicas != 0
			yyq1358[3] = x.AvailableReplicas != 0
			yyq1358[4] = x.ObservedGeneration != 0
			yyq1358[5] = len(x.Conditions) != 0
			var yynn1358 int
			if yyr1358 || yy2arr1358 {
				r.EncodeArrayStart(6)
			} else {
				yynn1358 = 1
				for _, b := range yyq1358 {
					if b {
						yynn1358++
					}
				}
				r.EncodeMapStart(yynn1358)
				yynn1358 = 0
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1360 := z.EncBinary()
				_ = yym1360
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1361 := z.EncBinary()
				_ = yym1361
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[1] {
					yym1363 := z.EncBinary()
					_ = yym1363
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1358[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1364 := z.EncBinary()
					_ = yym1364
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[2] {
					yym1366 := z.EncBinary()
					_ = yym1366
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1358[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1367 := z.EncBinary()
					_ = yym1367
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[3] {
					yym1369 := z.EncBinary()
					_ = yym1369
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1358[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1370 := z.EncBinary()
					_ = yym1370
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[4] {
					yym1372 := z.EncBinary()
					_ = yym1372
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq1358[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1373 := z.EncBinary()
					_ = yym1373
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1358[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym1375 := z.EncBinary()
						_ = yym1375
						if false {
						} else {
							h.encSliceReplicaSetCondition(([]ReplicaSetCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1358[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym1376 := z.EncBinary()
						_ = yym1376
						if false {
						} else {
							h.encSliceReplicaSetCondition(([]ReplicaSetCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr1358 || yy2arr1358 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1377 := z.DecBinary()
	_ = yym1377
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1378 := r.ContainerType()
		if yyct1378 == codecSelferValueTypeMap1234 {
			yyl1378 := r.ReadMapStart()
			if yyl1378 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1378, d)
			}
		} else if yyct1378 == codecSelferValueTypeArray1234 {
			yyl1378 := r.ReadArrayStart()
			if yyl1378 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1378, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1379Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1379Slc
	var yyhl1379 bool = l >= 0
	for yyj1379 := 0; ; yyj1379++ {
		if yyhl1379 {
			if yyj1379 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1379Slc = r.DecodeBytes(yys1379Slc, true, true)
		yys1379 := string(yys1379Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1379 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				x.FullyLabeledReplicas = int32(r.DecodeInt(32))
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				x.ReadyReplicas = int32(r.DecodeInt(32))
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				x.AvailableReplicas = int32(r.DecodeInt(32))
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				x.ObservedGeneration = int64(r.DecodeInt(64))
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv1385 := &x.Conditions
				yym1386 := z.DecBinary()
				_ = yym1386
				if false {
				} else {
					h.decSliceReplicaSetCondition((*[]ReplicaSetCondition)(yyv1385), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1379)
		} // end switch yys1379
	} // end for yyj1379
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1387 int
	var yyb1387 bool
	var yyhl1387 bool = l >= 0
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		x.FullyLabeledReplicas = int32(r.DecodeInt(32))
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		x.ReadyReplicas = int32(r.DecodeInt(32))
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		x.AvailableReplicas = int32(r.DecodeInt(32))
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		x.ObservedGeneration = int64(r.DecodeInt(64))
	}
	yyj1387++
	if yyhl1387 {
		yyb1387 = yyj1387 > l
	} else {
		yyb1387 = r.CheckBreak()
	}
	if yyb1387 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv1393 := &x.Conditions
		yym1394 := z.DecBinary()
		_ = yym1394
		if false {
		} else {
			h.decSliceReplicaSetCondition((*[]ReplicaSetCondition)(yyv1393), d)
		}
	}
	for {
		yyj1387++
		if yyhl1387 {
			yyb1387 = yyj1387 > l
		} else {
			yyb1387 = r.CheckBreak()
		}
		if yyb1387 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1387-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ReplicaSetConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1395 := z.EncBinary()
	_ = yym1395
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ReplicaSetConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1396 := z.DecBinary()
	_ = yym1396
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ReplicaSetCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1397 := z.EncBinary()
		_ = yym1397
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1398 := !z.EncBinary()
			yy2arr1398 := z.EncBasicHandle().StructToArray
			var yyq1398 [5]bool
			_, _, _ = yysep1398, yyq1398, yy2arr1398
			const yyr1398 bool = false
			yyq1398[2] = true
			yyq1398[3] = x.Reason != ""
			yyq1398[4] = x.Message != ""
			var yynn1398 int
			if yyr1398 || yy2arr1398 {
				r.EncodeArrayStart(5)
			} else {
				yynn1398 = 2
				for _, b := range yyq1398 {
					if b {
						yynn1398++
					}
				}
				r.EncodeMapStart(yynn1398)
				yynn1398 = 0
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1401 := z.EncBinary()
				_ = yym1401
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1402 := z.EncBinary()
				_ = yym1402
				if false {
				} else if z.HasExtensions() && z.EncExt(x.Status) {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Status))
				}
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1398[2] {
					yy1404 := &x.LastTransitionTime
					yym1405 := z.EncBinary()
					_ = yym1405
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1404) {
					} else if yym1405 {
						z.EncBinaryMarshal(yy1404)
					} else if !yym1405 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1404)
					} else {
						z.EncFallback(yy1404)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1398[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1406 := &x.LastTransitionTime
					yym1407 := z.EncBinary()
					_ = yym1407
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1406) {
					} else if yym1407 {
						z.EncBinaryMarshal(yy1406)
					} else if !yym1407 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy1406)
					} else {
						z.EncFallback(yy1406)
					}
				}
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1398[3] {
					yym1409 := z.EncBinary()
					_ = yym1409
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1398[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1410 := z.EncBinary()
					_ = yym1410
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1398[4] {
					yym1412 := z.EncBinary()
					_ = yym1412
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1398[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1413 := z.EncBinary()
					_ = yym1413
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr1398 || yy2arr1398 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicaSetCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1414 := z.DecBinary()
	_ = yym1414
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1415 := r.ContainerType()
		if yyct1415 == codecSelferValueTypeMap1234 {
			yyl1415 := r.ReadMapStart()
			if yyl1415 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1415, d)
			}
		} else if yyct1415 == codecSelferValueTypeArray1234 {
			yyl1415 := r.ReadArrayStart()
			if yyl1415 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1415, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicaSetCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1416Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1416Slc
	var yyhl1416 bool = l >= 0
	for yyj1416 := 0; ; yyj1416++ {
		if yyhl1416 {
			if yyj1416 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1416Slc = r.DecodeBytes(yys1416Slc, true, true)
		yys1416 := string(yys1416Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1416 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				x.Type = ReplicaSetConditionType(r.DecodeString())
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg1_unversioned.Time{}
			} else {
				yyv1419 := &x.LastTransitionTime
				yym1420 := z.DecBinary()
				_ = yym1420
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1419) {
				} else if yym1420 {
					z.DecBinaryUnmarshal(yyv1419)
				} else if !yym1420 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv1419)
				} else {
					z.DecFallback(yyv1419, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				x.Reason = string(r.DecodeString())
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				x.Message = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1416)
		} // end switch yys1416
	} // end for yyj1416
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicaSetCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1423 int
	var yyb1423 bool
	var yyhl1423 bool = l >= 0
	yyj1423++
	if yyhl1423 {
		yyb1423 = yyj1423 > l
	} else {
		yyb1423 = r.CheckBreak()
	}
	if yyb1423 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		x.Type = ReplicaSetConditionType(r.DecodeString())
	}
	yyj1423++
	if yyhl1423 {
		yyb1423 = yyj1423 > l
	} else {
		yyb1423 = r.CheckBreak()
	}
	if yyb1423 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		x.Status = pkg2_v1.ConditionStatus(r.DecodeString())
	}
	yyj1423++
	if yyhl1423 {
		yyb1423 = yyj1423 > l
	} else {
		yyb1423 = r.CheckBreak()
	}
	if yyb1423 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg1_unversioned.Time{}
	} else {
		yyv1426 := &x.LastTransitionTime
		yym1427 := z.DecBinary()
		_ = yym1427
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1426) {
		} else if yym1427 {
			z.DecBinaryUnmarshal(yyv1426)
		} else if !yym1427 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv1426)
		} else {
			z.DecFallback(yyv1426, false)
		}
	}
	yyj1423++
	if yyhl1423 {
		yyb1423 = yyj1423 > l
	} else {
		yyb1423 = r.CheckBreak()
	}
	if yyb1423 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		x.Reason = string(r.DecodeString())
	}
	yyj1423++
	if yyhl1423 {
		yyb1423 = yyj1423 > l
	} else {
		yyb1423 = r.CheckBreak()
	}
	if yyb1423 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		x.Message = string(r.DecodeString())
	}
	for {
		yyj1423++
		if yyhl1423 {
			yyb1423 = yyj1423 > l
		} else {
			yyb1423 = r.CheckBreak()
		}
		if yyb1423 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1423-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1430 := z.EncBinary()
		_ = yym1430
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1431 := !z.EncBinary()
			yy2arr1431 := z.EncBasicHandle().StructToArray
			var yyq1431 [4]bool
			_, _, _ = yysep1431, yyq1431, yy2arr1431
			const yyr1431 bool = false
			yyq1431[0] = x.Kind != ""
			yyq1431[1] = x.APIVersion != ""
			yyq1431[2] = true
			yyq1431[3] = true
			var yynn1431 int
			if yyr1431 || yy2arr1431 {
				r.EncodeArrayStart(4)
			} else {
				yynn1431 = 0
				for _, b := range yyq1431 {
					if b {
						yynn1431++
					}
				}
				r.EncodeMapStart(yynn1431)
				yynn1431 = 0
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1431[0] {
					yym1433 := z.EncBinary()
					_ = yym1433
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1431[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1434 := z.EncBinary()
					_ = yym1434
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1431[1] {
					yym1436 := z.EncBinary()
					_ = yym1436
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1431[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1437 := z.EncBinary()
					_ = yym1437
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1431[2] {
					yy1439 := &x.ObjectMeta
					yy1439.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1431[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1440 := &x.ObjectMeta
					yy1440.CodecEncodeSelf(e)
				}
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1431[3] {
					yy1442 := &x.Spec
					yy1442.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1431[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1443 := &x.Spec
					yy1443.CodecEncodeSelf(e)
				}
			}
			if yyr1431 || yy2arr1431 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1444 := z.DecBinary()
	_ = yym1444
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1445 := r.ContainerType()
		if yyct1445 == codecSelferValueTypeMap1234 {
			yyl1445 := r.ReadMapStart()
			if yyl1445 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1445, d)
			}
		} else if yyct1445 == codecSelferValueTypeArray1234 {
			yyl1445 := r.ReadArrayStart()
			if yyl1445 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1445, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1446Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1446Slc
	var yyhl1446 bool = l >= 0
	for yyj1446 := 0; ; yyj1446++ {
		if yyhl1446 {
			if yyj1446 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1446Slc = r.DecodeBytes(yys1446Slc, true, true)
		yys1446 := string(yys1446Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1446 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1449 := &x.ObjectMeta
				yyv1449.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSecurityPolicySpec{}
			} else {
				yyv1450 := &x.Spec
				yyv1450.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1446)
		} // end switch yys1446
	} // end for yyj1446
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1451 int
	var yyb1451 bool
	var yyhl1451 bool = l >= 0
	yyj1451++
	if yyhl1451 {
		yyb1451 = yyj1451 > l
	} else {
		yyb1451 = r.CheckBreak()
	}
	if yyb1451 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1451++
	if yyhl1451 {
		yyb1451 = yyj1451 > l
	} else {
		yyb1451 = r.CheckBreak()
	}
	if yyb1451 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1451++
	if yyhl1451 {
		yyb1451 = yyj1451 > l
	} else {
		yyb1451 = r.CheckBreak()
	}
	if yyb1451 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1454 := &x.ObjectMeta
		yyv1454.CodecDecodeSelf(d)
	}
	yyj1451++
	if yyhl1451 {
		yyb1451 = yyj1451 > l
	} else {
		yyb1451 = r.CheckBreak()
	}
	if yyb1451 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSecurityPolicySpec{}
	} else {
		yyv1455 := &x.Spec
		yyv1455.CodecDecodeSelf(d)
	}
	for {
		yyj1451++
		if yyhl1451 {
			yyb1451 = yyj1451 > l
		} else {
			yyb1451 = r.CheckBreak()
		}
		if yyb1451 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1451-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1456 := z.EncBinary()
		_ = yym1456
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1457 := !z.EncBinary()
			yy2arr1457 := z.EncBasicHandle().StructToArray
			var yyq1457 [14]bool
			_, _, _ = yysep1457, yyq1457, yy2arr1457
			const yyr1457 bool = false
			yyq1457[0] = x.Privileged != false
			yyq1457[1] = len(x.DefaultAddCapabilities) != 0
			yyq1457[2] = len(x.RequiredDropCapabilities) != 0
			yyq1457[3] = len(x.AllowedCapabilities) != 0
			yyq1457[4] = len(x.Volumes) != 0
			yyq1457[5] = x.HostNetwork != false
			yyq1457[6] = len(x.HostPorts) != 0
			yyq1457[7] = x.HostPID != false
			yyq1457[8] = x.HostIPC != false
			yyq1457[13] = x.ReadOnlyRootFilesystem != false
			var yynn1457 int
			if yyr1457 || yy2arr1457 {
				r.EncodeArrayStart(14)
			} else {
				yynn1457 = 4
				for _, b := range yyq1457 {
					if b {
						yynn1457++
					}
				}
				r.EncodeMapStart(yynn1457)
				yynn1457 = 0
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[0] {
					yym1459 := z.EncBinary()
					_ = yym1459
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1457[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("privileged"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1460 := z.EncBinary()
					_ = yym1460
					if false {
					} else {
						r.EncodeBool(bool(x.Privileged))
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[1] {
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1462 := z.EncBinary()
						_ = yym1462
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1457[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultAddCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultAddCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1463 := z.EncBinary()
						_ = yym1463
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.DefaultAddCapabilities), e)
						}
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[2] {
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1465 := z.EncBinary()
						_ = yym1465
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1457[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDropCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDropCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1466 := z.EncBinary()
						_ = yym1466
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.RequiredDropCapabilities), e)
						}
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[3] {
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1468 := z.EncBinary()
						_ = yym1468
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.AllowedCapabilities), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1457[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("allowedCapabilities"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AllowedCapabilities == nil {
						r.EncodeNil()
					} else {
						yym1469 := z.EncBinary()
						_ = yym1469
						if false {
						} else {
							h.encSlicev1_Capability(([]pkg2_v1.Capability)(x.AllowedCapabilities), e)
						}
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[4] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1471 := z.EncBinary()
						_ = yym1471
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1457[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym1472 := z.EncBinary()
						_ = yym1472
						if false {
						} else {
							h.encSliceFSType(([]FSType)(x.Volumes), e)
						}
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[5] {
					yym1474 := z.EncBinary()
					_ = yym1474
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1457[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1475 := z.EncBinary()
					_ = yym1475
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[6] {
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym1477 := z.EncBinary()
						_ = yym1477
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1457[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPorts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPorts == nil {
						r.EncodeNil()
					} else {
						yym1478 := z.EncBinary()
						_ = yym1478
						if false {
						} else {
							h.encSliceHostPortRange(([]HostPortRange)(x.HostPorts), e)
						}
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[7] {
					yym1480 := z.EncBinary()
					_ = yym1480
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1457[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1481 := z.EncBinary()
					_ = yym1481
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[8] {
					yym1483 := z.EncBinary()
					_ = yym1483
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1457[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1484 := z.EncBinary()
					_ = yym1484
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1486 := &x.SELinux
				yy1486.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("seLinux"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1487 := &x.SELinux
				yy1487.CodecEncodeSelf(e)
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1489 := &x.RunAsUser
				yy1489.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1490 := &x.RunAsUser
				yy1490.CodecEncodeSelf(e)
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1492 := &x.SupplementalGroups
				yy1492.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1493 := &x.SupplementalGroups
				yy1493.CodecEncodeSelf(e)
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1495 := &x.FSGroup
				yy1495.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1496 := &x.FSGroup
				yy1496.CodecEncodeSelf(e)
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1457[13] {
					yym1498 := z.EncBinary()
					_ = yym1498
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq1457[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnlyRootFilesystem"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1499 := z.EncBinary()
					_ = yym1499
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnlyRootFilesystem))
					}
				}
			}
			if yyr1457 || yy2arr1457 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1500 := z.DecBinary()
	_ = yym1500
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1501 := r.ContainerType()
		if yyct1501 == codecSelferValueTypeMap1234 {
			yyl1501 := r.ReadMapStart()
			if yyl1501 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1501, d)
			}
		} else if yyct1501 == codecSelferValueTypeArray1234 {
			yyl1501 := r.ReadArrayStart()
			if yyl1501 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1501, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1502Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1502Slc
	var yyhl1502 bool = l >= 0
	for yyj1502 := 0; ; yyj1502++ {
		if yyhl1502 {
			if yyj1502 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1502Slc = r.DecodeBytes(yys1502Slc, true, true)
		yys1502 := string(yys1502Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1502 {
		case "privileged":
			if r.TryDecodeAsNil() {
				x.Privileged = false
			} else {
				x.Privileged = bool(r.DecodeBool())
			}
		case "defaultAddCapabilities":
			if r.TryDecodeAsNil() {
				x.DefaultAddCapabilities = nil
			} else {
				yyv1504 := &x.DefaultAddCapabilities
				yym1505 := z.DecBinary()
				_ = yym1505
				if false {
				} else {
					h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1504), d)
				}
			}
		case "requiredDropCapabilities":
			if r.TryDecodeAsNil() {
				x.RequiredDropCapabilities = nil
			} else {
				yyv1506 := &x.RequiredDropCapabilities
				yym1507 := z.DecBinary()
				_ = yym1507
				if false {
				} else {
					h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1506), d)
				}
			}
		case "allowedCapabilities":
			if r.TryDecodeAsNil() {
				x.AllowedCapabilities = nil
			} else {
				yyv1508 := &x.AllowedCapabilities
				yym1509 := z.DecBinary()
				_ = yym1509
				if false {
				} else {
					h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1508), d)
				}
			}
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv1510 := &x.Volumes
				yym1511 := z.DecBinary()
				_ = yym1511
				if false {
				} else {
					h.decSliceFSType((*[]FSType)(yyv1510), d)
				}
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				x.HostNetwork = bool(r.DecodeBool())
			}
		case "hostPorts":
			if r.TryDecodeAsNil() {
				x.HostPorts = nil
			} else {
				yyv1513 := &x.HostPorts
				yym1514 := z.DecBinary()
				_ = yym1514
				if false {
				} else {
					h.decSliceHostPortRange((*[]HostPortRange)(yyv1513), d)
				}
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				x.HostPID = bool(r.DecodeBool())
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				x.HostIPC = bool(r.DecodeBool())
			}
		case "seLinux":
			if r.TryDecodeAsNil() {
				x.SELinux = SELinuxStrategyOptions{}
			} else {
				yyv1517 := &x.SELinux
				yyv1517.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				x.RunAsUser = RunAsUserStrategyOptions{}
			} else {
				yyv1518 := &x.RunAsUser
				yyv1518.CodecDecodeSelf(d)
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
			} else {
				yyv1519 := &x.SupplementalGroups
				yyv1519.CodecDecodeSelf(d)
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				x.FSGroup = FSGroupStrategyOptions{}
			} else {
				yyv1520 := &x.FSGroup
				yyv1520.CodecDecodeSelf(d)
			}
		case "readOnlyRootFilesystem":
			if r.TryDecodeAsNil() {
				x.ReadOnlyRootFilesystem = false
			} else {
				x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
			}
		default:
			z.DecStructFieldNotFound(-1, yys1502)
		} // end switch yys1502
	} // end for yyj1502
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1522 int
	var yyb1522 bool
	var yyhl1522 bool = l >= 0
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Privileged = false
	} else {
		x.Privileged = bool(r.DecodeBool())
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DefaultAddCapabilities = nil
	} else {
		yyv1524 := &x.DefaultAddCapabilities
		yym1525 := z.DecBinary()
		_ = yym1525
		if false {
		} else {
			h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1524), d)
		}
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDropCapabilities = nil
	} else {
		yyv1526 := &x.RequiredDropCapabilities
		yym1527 := z.DecBinary()
		_ = yym1527
		if false {
		} else {
			h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1526), d)
		}
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AllowedCapabilities = nil
	} else {
		yyv1528 := &x.AllowedCapabilities
		yym1529 := z.DecBinary()
		_ = yym1529
		if false {
		} else {
			h.decSlicev1_Capability((*[]pkg2_v1.Capability)(yyv1528), d)
		}
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv1530 := &x.Volumes
		yym1531 := z.DecBinary()
		_ = yym1531
		if false {
		} else {
			h.decSliceFSType((*[]FSType)(yyv1530), d)
		}
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		x.HostNetwork = bool(r.DecodeBool())
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPorts = nil
	} else {
		yyv1533 := &x.HostPorts
		yym1534 := z.DecBinary()
		_ = yym1534
		if false {
		} else {
			h.decSliceHostPortRange((*[]HostPortRange)(yyv1533), d)
		}
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		x.HostPID = bool(r.DecodeBool())
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		x.HostIPC = bool(r.DecodeBool())
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SELinux = SELinuxStrategyOptions{}
	} else {
		yyv1537 := &x.SELinux
		yyv1537.CodecDecodeSelf(d)
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RunAsUser = RunAsUserStrategyOptions{}
	} else {
		yyv1538 := &x.RunAsUser
		yyv1538.CodecDecodeSelf(d)
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = SupplementalGroupsStrategyOptions{}
	} else {
		yyv1539 := &x.SupplementalGroups
		yyv1539.CodecDecodeSelf(d)
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSGroup = FSGroupStrategyOptions{}
	} else {
		yyv1540 := &x.FSGroup
		yyv1540.CodecDecodeSelf(d)
	}
	yyj1522++
	if yyhl1522 {
		yyb1522 = yyj1522 > l
	} else {
		yyb1522 = r.CheckBreak()
	}
	if yyb1522 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnlyRootFilesystem = false
	} else {
		x.ReadOnlyRootFilesystem = bool(r.DecodeBool())
	}
	for {
		yyj1522++
		if yyhl1522 {
			yyb1522 = yyj1522 > l
		} else {
			yyb1522 = r.CheckBreak()
		}
		if yyb1522 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1522-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1542 := z.EncBinary()
	_ = yym1542
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1543 := z.DecBinary()
	_ = yym1543
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPortRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1544 := z.EncBinary()
		_ = yym1544
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1545 := !z.EncBinary()
			yy2arr1545 := z.EncBasicHandle().StructToArray
			var yyq1545 [2]bool
			_, _, _ = yysep1545, yyq1545, yy2arr1545
			const yyr1545 bool = false
			var yynn1545 int
			if yyr1545 || yy2arr1545 {
				r.EncodeArrayStart(2)
			} else {
				yynn1545 = 2
				for _, b := range yyq1545 {
					if b {
						yynn1545++
					}
				}
				r.EncodeMapStart(yynn1545)
				yynn1545 = 0
			}
			if yyr1545 || yy2arr1545 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1547 := z.EncBinary()
				_ = yym1547
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1548 := z.EncBinary()
				_ = yym1548
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1545 || yy2arr1545 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1550 := z.EncBinary()
				_ = yym1550
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1551 := z.EncBinary()
				_ = yym1551
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1545 || yy2arr1545 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPortRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1552 := z.DecBinary()
	_ = yym1552
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1553 := r.ContainerType()
		if yyct1553 == codecSelferValueTypeMap1234 {
			yyl1553 := r.ReadMapStart()
			if yyl1553 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1553, d)
			}
		} else if yyct1553 == codecSelferValueTypeArray1234 {
			yyl1553 := r.ReadArrayStart()
			if yyl1553 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1553, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPortRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1554Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1554Slc
	var yyhl1554 bool = l >= 0
	for yyj1554 := 0; ; yyj1554++ {
		if yyhl1554 {
			if yyj1554 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1554Slc = r.DecodeBytes(yys1554Slc, true, true)
		yys1554 := string(yys1554Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1554 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int32(r.DecodeInt(32))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1554)
		} // end switch yys1554
	} // end for yyj1554
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPortRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1557 int
	var yyb1557 bool
	var yyhl1557 bool = l >= 0
	yyj1557++
	if yyhl1557 {
		yyb1557 = yyj1557 > l
	} else {
		yyb1557 = r.CheckBreak()
	}
	if yyb1557 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int32(r.DecodeInt(32))
	}
	yyj1557++
	if yyhl1557 {
		yyb1557 = yyj1557 > l
	} else {
		yyb1557 = r.CheckBreak()
	}
	if yyb1557 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int32(r.DecodeInt(32))
	}
	for {
		yyj1557++
		if yyhl1557 {
			yyb1557 = yyj1557 > l
		} else {
			yyb1557 = r.CheckBreak()
		}
		if yyb1557 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1557-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SELinuxStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1560 := z.EncBinary()
		_ = yym1560
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1561 := !z.EncBinary()
			yy2arr1561 := z.EncBasicHandle().StructToArray
			var yyq1561 [2]bool
			_, _, _ = yysep1561, yyq1561, yy2arr1561
			const yyr1561 bool = false
			yyq1561[1] = x.SELinuxOptions != nil
			var yynn1561 int
			if yyr1561 || yy2arr1561 {
				r.EncodeArrayStart(2)
			} else {
				yynn1561 = 1
				for _, b := range yyq1561 {
					if b {
						yynn1561++
					}
				}
				r.EncodeMapStart(yynn1561)
				yynn1561 = 0
			}
			if yyr1561 || yy2arr1561 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1561 || yy2arr1561 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1561[1] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1561[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr1561 || yy2arr1561 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SELinuxStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1564 := z.DecBinary()
	_ = yym1564
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1565 := r.ContainerType()
		if yyct1565 == codecSelferValueTypeMap1234 {
			yyl1565 := r.ReadMapStart()
			if yyl1565 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1565, d)
			}
		} else if yyct1565 == codecSelferValueTypeArray1234 {
			yyl1565 := r.ReadArrayStart()
			if yyl1565 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1565, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1566Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1566Slc
	var yyhl1566 bool = l >= 0
	for yyj1566 := 0; ; yyj1566++ {
		if yyhl1566 {
			if yyj1566 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1566Slc = r.DecodeBytes(yys1566Slc, true, true)
		yys1566 := string(yys1566Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1566 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SELinuxStrategy(r.DecodeString())
			}
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(pkg2_v1.SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1566)
		} // end switch yys1566
	} // end for yyj1566
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SELinuxStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1569 int
	var yyb1569 bool
	var yyhl1569 bool = l >= 0
	yyj1569++
	if yyhl1569 {
		yyb1569 = yyj1569 > l
	} else {
		yyb1569 = r.CheckBreak()
	}
	if yyb1569 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SELinuxStrategy(r.DecodeString())
	}
	yyj1569++
	if yyhl1569 {
		yyb1569 = yyj1569 > l
	} else {
		yyb1569 = r.CheckBreak()
	}
	if yyb1569 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(pkg2_v1.SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	for {
		yyj1569++
		if yyhl1569 {
			yyb1569 = yyj1569 > l
		} else {
			yyb1569 = r.CheckBreak()
		}
		if yyb1569 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1569-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SELinuxStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1572 := z.EncBinary()
	_ = yym1572
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SELinuxStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1573 := z.DecBinary()
	_ = yym1573
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *RunAsUserStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1574 := z.EncBinary()
		_ = yym1574
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1575 := !z.EncBinary()
			yy2arr1575 := z.EncBasicHandle().StructToArray
			var yyq1575 [2]bool
			_, _, _ = yysep1575, yyq1575, yy2arr1575
			const yyr1575 bool = false
			yyq1575[1] = len(x.Ranges) != 0
			var yynn1575 int
			if yyr1575 || yy2arr1575 {
				r.EncodeArrayStart(2)
			} else {
				yynn1575 = 1
				for _, b := range yyq1575 {
					if b {
						yynn1575++
					}
				}
				r.EncodeMapStart(yynn1575)
				yynn1575 = 0
			}
			if yyr1575 || yy2arr1575 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Rule.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rule"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Rule.CodecEncodeSelf(e)
			}
			if yyr1575 || yy2arr1575 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1575[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1578 := z.EncBinary()
						_ = yym1578
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1575[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1579 := z.EncBinary()
						_ = yym1579
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1575 || yy2arr1575 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RunAsUserStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1580 := z.DecBinary()
	_ = yym1580
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1581 := r.ContainerType()
		if yyct1581 == codecSelferValueTypeMap1234 {
			yyl1581 := r.ReadMapStart()
			if yyl1581 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1581, d)
			}
		} else if yyct1581 == codecSelferValueTypeArray1234 {
			yyl1581 := r.ReadArrayStart()
			if yyl1581 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1581, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1582Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1582Slc
	var yyhl1582 bool = l >= 0
	for yyj1582 := 0; ; yyj1582++ {
		if yyhl1582 {
			if yyj1582 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1582Slc = r.DecodeBytes(yys1582Slc, true, true)
		yys1582 := string(yys1582Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1582 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = RunAsUserStrategy(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1584 := &x.Ranges
				yym1585 := z.DecBinary()
				_ = yym1585
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1584), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1582)
		} // end switch yys1582
	} // end for yyj1582
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RunAsUserStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1586 int
	var yyb1586 bool
	var yyhl1586 bool = l >= 0
	yyj1586++
	if yyhl1586 {
		yyb1586 = yyj1586 > l
	} else {
		yyb1586 = r.CheckBreak()
	}
	if yyb1586 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = RunAsUserStrategy(r.DecodeString())
	}
	yyj1586++
	if yyhl1586 {
		yyb1586 = yyj1586 > l
	} else {
		yyb1586 = r.CheckBreak()
	}
	if yyb1586 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1588 := &x.Ranges
		yym1589 := z.DecBinary()
		_ = yym1589
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1588), d)
		}
	}
	for {
		yyj1586++
		if yyhl1586 {
			yyb1586 = yyj1586 > l
		} else {
			yyb1586 = r.CheckBreak()
		}
		if yyb1586 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1586-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *IDRange) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1590 := z.EncBinary()
		_ = yym1590
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1591 := !z.EncBinary()
			yy2arr1591 := z.EncBasicHandle().StructToArray
			var yyq1591 [2]bool
			_, _, _ = yysep1591, yyq1591, yy2arr1591
			const yyr1591 bool = false
			var yynn1591 int
			if yyr1591 || yy2arr1591 {
				r.EncodeArrayStart(2)
			} else {
				yynn1591 = 2
				for _, b := range yyq1591 {
					if b {
						yynn1591++
					}
				}
				r.EncodeMapStart(yynn1591)
				yynn1591 = 0
			}
			if yyr1591 || yy2arr1591 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1593 := z.EncBinary()
				_ = yym1593
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("min"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1594 := z.EncBinary()
				_ = yym1594
				if false {
				} else {
					r.EncodeInt(int64(x.Min))
				}
			}
			if yyr1591 || yy2arr1591 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym1596 := z.EncBinary()
				_ = yym1596
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("max"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym1597 := z.EncBinary()
				_ = yym1597
				if false {
				} else {
					r.EncodeInt(int64(x.Max))
				}
			}
			if yyr1591 || yy2arr1591 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *IDRange) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1598 := z.DecBinary()
	_ = yym1598
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1599 := r.ContainerType()
		if yyct1599 == codecSelferValueTypeMap1234 {
			yyl1599 := r.ReadMapStart()
			if yyl1599 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1599, d)
			}
		} else if yyct1599 == codecSelferValueTypeArray1234 {
			yyl1599 := r.ReadArrayStart()
			if yyl1599 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1599, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *IDRange) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1600Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1600Slc
	var yyhl1600 bool = l >= 0
	for yyj1600 := 0; ; yyj1600++ {
		if yyhl1600 {
			if yyj1600 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1600Slc = r.DecodeBytes(yys1600Slc, true, true)
		yys1600 := string(yys1600Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1600 {
		case "min":
			if r.TryDecodeAsNil() {
				x.Min = 0
			} else {
				x.Min = int64(r.DecodeInt(64))
			}
		case "max":
			if r.TryDecodeAsNil() {
				x.Max = 0
			} else {
				x.Max = int64(r.DecodeInt(64))
			}
		default:
			z.DecStructFieldNotFound(-1, yys1600)
		} // end switch yys1600
	} // end for yyj1600
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *IDRange) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1603 int
	var yyb1603 bool
	var yyhl1603 bool = l >= 0
	yyj1603++
	if yyhl1603 {
		yyb1603 = yyj1603 > l
	} else {
		yyb1603 = r.CheckBreak()
	}
	if yyb1603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Min = 0
	} else {
		x.Min = int64(r.DecodeInt(64))
	}
	yyj1603++
	if yyhl1603 {
		yyb1603 = yyj1603 > l
	} else {
		yyb1603 = r.CheckBreak()
	}
	if yyb1603 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Max = 0
	} else {
		x.Max = int64(r.DecodeInt(64))
	}
	for {
		yyj1603++
		if yyhl1603 {
			yyb1603 = yyj1603 > l
		} else {
			yyb1603 = r.CheckBreak()
		}
		if yyb1603 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1603-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RunAsUserStrategy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1606 := z.EncBinary()
	_ = yym1606
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RunAsUserStrategy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1607 := z.DecBinary()
	_ = yym1607
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *FSGroupStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1608 := z.EncBinary()
		_ = yym1608
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1609 := !z.EncBinary()
			yy2arr1609 := z.EncBasicHandle().StructToArray
			var yyq1609 [2]bool
			_, _, _ = yysep1609, yyq1609, yy2arr1609
			const yyr1609 bool = false
			yyq1609[0] = x.Rule != ""
			yyq1609[1] = len(x.Ranges) != 0
			var yynn1609 int
			if yyr1609 || yy2arr1609 {
				r.EncodeArrayStart(2)
			} else {
				yynn1609 = 0
				for _, b := range yyq1609 {
					if b {
						yynn1609++
					}
				}
				r.EncodeMapStart(yynn1609)
				yynn1609 = 0
			}
			if yyr1609 || yy2arr1609 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1609[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1609[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1609 || yy2arr1609 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1609[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1612 := z.EncBinary()
						_ = yym1612
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1609[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1613 := z.EncBinary()
						_ = yym1613
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1609 || yy2arr1609 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FSGroupStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1614 := z.DecBinary()
	_ = yym1614
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1615 := r.ContainerType()
		if yyct1615 == codecSelferValueTypeMap1234 {
			yyl1615 := r.ReadMapStart()
			if yyl1615 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1615, d)
			}
		} else if yyct1615 == codecSelferValueTypeArray1234 {
			yyl1615 := r.ReadArrayStart()
			if yyl1615 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1615, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1616Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1616Slc
	var yyhl1616 bool = l >= 0
	for yyj1616 := 0; ; yyj1616++ {
		if yyhl1616 {
			if yyj1616 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1616Slc = r.DecodeBytes(yys1616Slc, true, true)
		yys1616 := string(yys1616Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1616 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = FSGroupStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1618 := &x.Ranges
				yym1619 := z.DecBinary()
				_ = yym1619
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1618), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1616)
		} // end switch yys1616
	} // end for yyj1616
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FSGroupStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1620 int
	var yyb1620 bool
	var yyhl1620 bool = l >= 0
	yyj1620++
	if yyhl1620 {
		yyb1620 = yyj1620 > l
	} else {
		yyb1620 = r.CheckBreak()
	}
	if yyb1620 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = FSGroupStrategyType(r.DecodeString())
	}
	yyj1620++
	if yyhl1620 {
		yyb1620 = yyj1620 > l
	} else {
		yyb1620 = r.CheckBreak()
	}
	if yyb1620 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1622 := &x.Ranges
		yym1623 := z.DecBinary()
		_ = yym1623
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1622), d)
		}
	}
	for {
		yyj1620++
		if yyhl1620 {
			yyb1620 = yyj1620 > l
		} else {
			yyb1620 = r.CheckBreak()
		}
		if yyb1620 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1620-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x FSGroupStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1624 := z.EncBinary()
	_ = yym1624
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *FSGroupStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1625 := z.DecBinary()
	_ = yym1625
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1626 := z.EncBinary()
		_ = yym1626
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1627 := !z.EncBinary()
			yy2arr1627 := z.EncBasicHandle().StructToArray
			var yyq1627 [2]bool
			_, _, _ = yysep1627, yyq1627, yy2arr1627
			const yyr1627 bool = false
			yyq1627[0] = x.Rule != ""
			yyq1627[1] = len(x.Ranges) != 0
			var yynn1627 int
			if yyr1627 || yy2arr1627 {
				r.EncodeArrayStart(2)
			} else {
				yynn1627 = 0
				for _, b := range yyq1627 {
					if b {
						yynn1627++
					}
				}
				r.EncodeMapStart(yynn1627)
				yynn1627 = 0
			}
			if yyr1627 || yy2arr1627 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1627[0] {
					x.Rule.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1627[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rule"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Rule.CodecEncodeSelf(e)
				}
			}
			if yyr1627 || yy2arr1627 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1627[1] {
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1630 := z.EncBinary()
						_ = yym1630
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1627[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ranges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ranges == nil {
						r.EncodeNil()
					} else {
						yym1631 := z.EncBinary()
						_ = yym1631
						if false {
						} else {
							h.encSliceIDRange(([]IDRange)(x.Ranges), e)
						}
					}
				}
			}
			if yyr1627 || yy2arr1627 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1632 := z.DecBinary()
	_ = yym1632
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1633 := r.ContainerType()
		if yyct1633 == codecSelferValueTypeMap1234 {
			yyl1633 := r.ReadMapStart()
			if yyl1633 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1633, d)
			}
		} else if yyct1633 == codecSelferValueTypeArray1234 {
			yyl1633 := r.ReadArrayStart()
			if yyl1633 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1633, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1634Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1634Slc
	var yyhl1634 bool = l >= 0
	for yyj1634 := 0; ; yyj1634++ {
		if yyhl1634 {
			if yyj1634 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1634Slc = r.DecodeBytes(yys1634Slc, true, true)
		yys1634 := string(yys1634Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1634 {
		case "rule":
			if r.TryDecodeAsNil() {
				x.Rule = ""
			} else {
				x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
			}
		case "ranges":
			if r.TryDecodeAsNil() {
				x.Ranges = nil
			} else {
				yyv1636 := &x.Ranges
				yym1637 := z.DecBinary()
				_ = yym1637
				if false {
				} else {
					h.decSliceIDRange((*[]IDRange)(yyv1636), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1634)
		} // end switch yys1634
	} // end for yyj1634
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SupplementalGroupsStrategyOptions) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1638 int
	var yyb1638 bool
	var yyhl1638 bool = l >= 0
	yyj1638++
	if yyhl1638 {
		yyb1638 = yyj1638 > l
	} else {
		yyb1638 = r.CheckBreak()
	}
	if yyb1638 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rule = ""
	} else {
		x.Rule = SupplementalGroupsStrategyType(r.DecodeString())
	}
	yyj1638++
	if yyhl1638 {
		yyb1638 = yyj1638 > l
	} else {
		yyb1638 = r.CheckBreak()
	}
	if yyb1638 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ranges = nil
	} else {
		yyv1640 := &x.Ranges
		yym1641 := z.DecBinary()
		_ = yym1641
		if false {
		} else {
			h.decSliceIDRange((*[]IDRange)(yyv1640), d)
		}
	}
	for {
		yyj1638++
		if yyhl1638 {
			yyb1638 = yyj1638 > l
		} else {
			yyb1638 = r.CheckBreak()
		}
		if yyb1638 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1638-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x SupplementalGroupsStrategyType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1642 := z.EncBinary()
	_ = yym1642
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *SupplementalGroupsStrategyType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1643 := z.DecBinary()
	_ = yym1643
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSecurityPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1644 := z.EncBinary()
		_ = yym1644
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1645 := !z.EncBinary()
			yy2arr1645 := z.EncBasicHandle().StructToArray
			var yyq1645 [4]bool
			_, _, _ = yysep1645, yyq1645, yy2arr1645
			const yyr1645 bool = false
			yyq1645[0] = x.Kind != ""
			yyq1645[1] = x.APIVersion != ""
			yyq1645[2] = true
			var yynn1645 int
			if yyr1645 || yy2arr1645 {
				r.EncodeArrayStart(4)
			} else {
				yynn1645 = 1
				for _, b := range yyq1645 {
					if b {
						yynn1645++
					}
				}
				r.EncodeMapStart(yynn1645)
				yynn1645 = 0
			}
			if yyr1645 || yy2arr1645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1645[0] {
					yym1647 := z.EncBinary()
					_ = yym1647
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1645[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1648 := z.EncBinary()
					_ = yym1648
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1645 || yy2arr1645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1645[1] {
					yym1650 := z.EncBinary()
					_ = yym1650
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1645[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1651 := z.EncBinary()
					_ = yym1651
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1645 || yy2arr1645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1645[2] {
					yy1653 := &x.ListMeta
					yym1654 := z.EncBinary()
					_ = yym1654
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1653) {
					} else {
						z.EncFallback(yy1653)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1645[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1655 := &x.ListMeta
					yym1656 := z.EncBinary()
					_ = yym1656
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1655) {
					} else {
						z.EncFallback(yy1655)
					}
				}
			}
			if yyr1645 || yy2arr1645 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1658 := z.EncBinary()
					_ = yym1658
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1659 := z.EncBinary()
					_ = yym1659
					if false {
					} else {
						h.encSlicePodSecurityPolicy(([]PodSecurityPolicy)(x.Items), e)
					}
				}
			}
			if yyr1645 || yy2arr1645 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1660 := z.DecBinary()
	_ = yym1660
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1661 := r.ContainerType()
		if yyct1661 == codecSelferValueTypeMap1234 {
			yyl1661 := r.ReadMapStart()
			if yyl1661 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1661, d)
			}
		} else if yyct1661 == codecSelferValueTypeArray1234 {
			yyl1661 := r.ReadArrayStart()
			if yyl1661 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1661, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1662Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1662Slc
	var yyhl1662 bool = l >= 0
	for yyj1662 := 0; ; yyj1662++ {
		if yyhl1662 {
			if yyj1662 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1662Slc = r.DecodeBytes(yys1662Slc, true, true)
		yys1662 := string(yys1662Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1662 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1665 := &x.ListMeta
				yym1666 := z.DecBinary()
				_ = yym1666
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1665) {
				} else {
					z.DecFallback(yyv1665, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1667 := &x.Items
				yym1668 := z.DecBinary()
				_ = yym1668
				if false {
				} else {
					h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1667), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1662)
		} // end switch yys1662
	} // end for yyj1662
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1669 int
	var yyb1669 bool
	var yyhl1669 bool = l >= 0
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1672 := &x.ListMeta
		yym1673 := z.DecBinary()
		_ = yym1673
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1672) {
		} else {
			z.DecFallback(yyv1672, false)
		}
	}
	yyj1669++
	if yyhl1669 {
		yyb1669 = yyj1669 > l
	} else {
		yyb1669 = r.CheckBreak()
	}
	if yyb1669 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1674 := &x.Items
		yym1675 := z.DecBinary()
		_ = yym1675
		if false {
		} else {
			h.decSlicePodSecurityPolicy((*[]PodSecurityPolicy)(yyv1674), d)
		}
	}
	for {
		yyj1669++
		if yyhl1669 {
			yyb1669 = yyj1669 > l
		} else {
			yyb1669 = r.CheckBreak()
		}
		if yyb1669 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1669-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1676 := z.EncBinary()
		_ = yym1676
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1677 := !z.EncBinary()
			yy2arr1677 := z.EncBasicHandle().StructToArray
			var yyq1677 [4]bool
			_, _, _ = yysep1677, yyq1677, yy2arr1677
			const yyr1677 bool = false
			yyq1677[0] = x.Kind != ""
			yyq1677[1] = x.APIVersion != ""
			yyq1677[2] = true
			yyq1677[3] = true
			var yynn1677 int
			if yyr1677 || yy2arr1677 {
				r.EncodeArrayStart(4)
			} else {
				yynn1677 = 0
				for _, b := range yyq1677 {
					if b {
						yynn1677++
					}
				}
				r.EncodeMapStart(yynn1677)
				yynn1677 = 0
			}
			if yyr1677 || yy2arr1677 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1677[0] {
					yym1679 := z.EncBinary()
					_ = yym1679
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1677[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1680 := z.EncBinary()
					_ = yym1680
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1677 || yy2arr1677 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1677[1] {
					yym1682 := z.EncBinary()
					_ = yym1682
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1677[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1683 := z.EncBinary()
					_ = yym1683
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1677 || yy2arr1677 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1677[2] {
					yy1685 := &x.ObjectMeta
					yy1685.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1677[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1686 := &x.ObjectMeta
					yy1686.CodecEncodeSelf(e)
				}
			}
			if yyr1677 || yy2arr1677 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1677[3] {
					yy1688 := &x.Spec
					yy1688.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1677[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1689 := &x.Spec
					yy1689.CodecEncodeSelf(e)
				}
			}
			if yyr1677 || yy2arr1677 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1690 := z.DecBinary()
	_ = yym1690
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1691 := r.ContainerType()
		if yyct1691 == codecSelferValueTypeMap1234 {
			yyl1691 := r.ReadMapStart()
			if yyl1691 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1691, d)
			}
		} else if yyct1691 == codecSelferValueTypeArray1234 {
			yyl1691 := r.ReadArrayStart()
			if yyl1691 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1691, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicy) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1692Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1692Slc
	var yyhl1692 bool = l >= 0
	for yyj1692 := 0; ; yyj1692++ {
		if yyhl1692 {
			if yyj1692 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1692Slc = r.DecodeBytes(yys1692Slc, true, true)
		yys1692 := string(yys1692Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1692 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv1695 := &x.ObjectMeta
				yyv1695.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = NetworkPolicySpec{}
			} else {
				yyv1696 := &x.Spec
				yyv1696.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys1692)
		} // end switch yys1692
	} // end for yyj1692
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicy) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1697 int
	var yyb1697 bool
	var yyhl1697 bool = l >= 0
	yyj1697++
	if yyhl1697 {
		yyb1697 = yyj1697 > l
	} else {
		yyb1697 = r.CheckBreak()
	}
	if yyb1697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1697++
	if yyhl1697 {
		yyb1697 = yyj1697 > l
	} else {
		yyb1697 = r.CheckBreak()
	}
	if yyb1697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1697++
	if yyhl1697 {
		yyb1697 = yyj1697 > l
	} else {
		yyb1697 = r.CheckBreak()
	}
	if yyb1697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv1700 := &x.ObjectMeta
		yyv1700.CodecDecodeSelf(d)
	}
	yyj1697++
	if yyhl1697 {
		yyb1697 = yyj1697 > l
	} else {
		yyb1697 = r.CheckBreak()
	}
	if yyb1697 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = NetworkPolicySpec{}
	} else {
		yyv1701 := &x.Spec
		yyv1701.CodecDecodeSelf(d)
	}
	for {
		yyj1697++
		if yyhl1697 {
			yyb1697 = yyj1697 > l
		} else {
			yyb1697 = r.CheckBreak()
		}
		if yyb1697 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1697-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicySpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1702 := z.EncBinary()
		_ = yym1702
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1703 := !z.EncBinary()
			yy2arr1703 := z.EncBasicHandle().StructToArray
			var yyq1703 [2]bool
			_, _, _ = yysep1703, yyq1703, yy2arr1703
			const yyr1703 bool = false
			yyq1703[1] = len(x.Ingress) != 0
			var yynn1703 int
			if yyr1703 || yy2arr1703 {
				r.EncodeArrayStart(2)
			} else {
				yynn1703 = 1
				for _, b := range yyq1703 {
					if b {
						yynn1703++
					}
				}
				r.EncodeMapStart(yynn1703)
				yynn1703 = 0
			}
			if yyr1703 || yy2arr1703 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy1705 := &x.PodSelector
				yym1706 := z.EncBinary()
				_ = yym1706
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1705) {
				} else {
					z.EncFallback(yy1705)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy1707 := &x.PodSelector
				yym1708 := z.EncBinary()
				_ = yym1708
				if false {
				} else if z.HasExtensions() && z.EncExt(yy1707) {
				} else {
					z.EncFallback(yy1707)
				}
			}
			if yyr1703 || yy2arr1703 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1703[1] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1710 := z.EncBinary()
						_ = yym1710
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1703[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym1711 := z.EncBinary()
						_ = yym1711
						if false {
						} else {
							h.encSliceNetworkPolicyIngressRule(([]NetworkPolicyIngressRule)(x.Ingress), e)
						}
					}
				}
			}
			if yyr1703 || yy2arr1703 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicySpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1712 := z.DecBinary()
	_ = yym1712
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1713 := r.ContainerType()
		if yyct1713 == codecSelferValueTypeMap1234 {
			yyl1713 := r.ReadMapStart()
			if yyl1713 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1713, d)
			}
		} else if yyct1713 == codecSelferValueTypeArray1234 {
			yyl1713 := r.ReadArrayStart()
			if yyl1713 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1713, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicySpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1714Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1714Slc
	var yyhl1714 bool = l >= 0
	for yyj1714 := 0; ; yyj1714++ {
		if yyhl1714 {
			if yyj1714 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1714Slc = r.DecodeBytes(yys1714Slc, true, true)
		yys1714 := string(yys1714Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1714 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				x.PodSelector = pkg1_unversioned.LabelSelector{}
			} else {
				yyv1715 := &x.PodSelector
				yym1716 := z.DecBinary()
				_ = yym1716
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1715) {
				} else {
					z.DecFallback(yyv1715, false)
				}
			}
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv1717 := &x.Ingress
				yym1718 := z.DecBinary()
				_ = yym1718
				if false {
				} else {
					h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1717), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1714)
		} // end switch yys1714
	} // end for yyj1714
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicySpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1719 int
	var yyb1719 bool
	var yyhl1719 bool = l >= 0
	yyj1719++
	if yyhl1719 {
		yyb1719 = yyj1719 > l
	} else {
		yyb1719 = r.CheckBreak()
	}
	if yyb1719 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodSelector = pkg1_unversioned.LabelSelector{}
	} else {
		yyv1720 := &x.PodSelector
		yym1721 := z.DecBinary()
		_ = yym1721
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1720) {
		} else {
			z.DecFallback(yyv1720, false)
		}
	}
	yyj1719++
	if yyhl1719 {
		yyb1719 = yyj1719 > l
	} else {
		yyb1719 = r.CheckBreak()
	}
	if yyb1719 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv1722 := &x.Ingress
		yym1723 := z.DecBinary()
		_ = yym1723
		if false {
		} else {
			h.decSliceNetworkPolicyIngressRule((*[]NetworkPolicyIngressRule)(yyv1722), d)
		}
	}
	for {
		yyj1719++
		if yyhl1719 {
			yyb1719 = yyj1719 > l
		} else {
			yyb1719 = r.CheckBreak()
		}
		if yyb1719 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1719-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyIngressRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1724 := z.EncBinary()
		_ = yym1724
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1725 := !z.EncBinary()
			yy2arr1725 := z.EncBasicHandle().StructToArray
			var yyq1725 [2]bool
			_, _, _ = yysep1725, yyq1725, yy2arr1725
			const yyr1725 bool = false
			yyq1725[0] = len(x.Ports) != 0
			yyq1725[1] = len(x.From) != 0
			var yynn1725 int
			if yyr1725 || yy2arr1725 {
				r.EncodeArrayStart(2)
			} else {
				yynn1725 = 0
				for _, b := range yyq1725 {
					if b {
						yynn1725++
					}
				}
				r.EncodeMapStart(yynn1725)
				yynn1725 = 0
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1725[0] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1727 := z.EncBinary()
						_ = yym1727
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1725[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym1728 := z.EncBinary()
						_ = yym1728
						if false {
						} else {
							h.encSliceNetworkPolicyPort(([]NetworkPolicyPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1725[1] {
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1730 := z.EncBinary()
						_ = yym1730
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1725[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("from"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.From == nil {
						r.EncodeNil()
					} else {
						yym1731 := z.EncBinary()
						_ = yym1731
						if false {
						} else {
							h.encSliceNetworkPolicyPeer(([]NetworkPolicyPeer)(x.From), e)
						}
					}
				}
			}
			if yyr1725 || yy2arr1725 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyIngressRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1732 := z.DecBinary()
	_ = yym1732
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1733 := r.ContainerType()
		if yyct1733 == codecSelferValueTypeMap1234 {
			yyl1733 := r.ReadMapStart()
			if yyl1733 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1733, d)
			}
		} else if yyct1733 == codecSelferValueTypeArray1234 {
			yyl1733 := r.ReadArrayStart()
			if yyl1733 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1733, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1734Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1734Slc
	var yyhl1734 bool = l >= 0
	for yyj1734 := 0; ; yyj1734++ {
		if yyhl1734 {
			if yyj1734 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1734Slc = r.DecodeBytes(yys1734Slc, true, true)
		yys1734 := string(yys1734Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1734 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv1735 := &x.Ports
				yym1736 := z.DecBinary()
				_ = yym1736
				if false {
				} else {
					h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1735), d)
				}
			}
		case "from":
			if r.TryDecodeAsNil() {
				x.From = nil
			} else {
				yyv1737 := &x.From
				yym1738 := z.DecBinary()
				_ = yym1738
				if false {
				} else {
					h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1737), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1734)
		} // end switch yys1734
	} // end for yyj1734
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyIngressRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1739 int
	var yyb1739 bool
	var yyhl1739 bool = l >= 0
	yyj1739++
	if yyhl1739 {
		yyb1739 = yyj1739 > l
	} else {
		yyb1739 = r.CheckBreak()
	}
	if yyb1739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv1740 := &x.Ports
		yym1741 := z.DecBinary()
		_ = yym1741
		if false {
		} else {
			h.decSliceNetworkPolicyPort((*[]NetworkPolicyPort)(yyv1740), d)
		}
	}
	yyj1739++
	if yyhl1739 {
		yyb1739 = yyj1739 > l
	} else {
		yyb1739 = r.CheckBreak()
	}
	if yyb1739 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.From = nil
	} else {
		yyv1742 := &x.From
		yym1743 := z.DecBinary()
		_ = yym1743
		if false {
		} else {
			h.decSliceNetworkPolicyPeer((*[]NetworkPolicyPeer)(yyv1742), d)
		}
	}
	for {
		yyj1739++
		if yyhl1739 {
			yyb1739 = yyj1739 > l
		} else {
			yyb1739 = r.CheckBreak()
		}
		if yyb1739 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1739-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1744 := z.EncBinary()
		_ = yym1744
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1745 := !z.EncBinary()
			yy2arr1745 := z.EncBasicHandle().StructToArray
			var yyq1745 [2]bool
			_, _, _ = yysep1745, yyq1745, yy2arr1745
			const yyr1745 bool = false
			yyq1745[0] = x.Protocol != nil
			yyq1745[1] = x.Port != nil
			var yynn1745 int
			if yyr1745 || yy2arr1745 {
				r.EncodeArrayStart(2)
			} else {
				yynn1745 = 0
				for _, b := range yyq1745 {
					if b {
						yynn1745++
					}
				}
				r.EncodeMapStart(yynn1745)
				yynn1745 = 0
			}
			if yyr1745 || yy2arr1745 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1745[0] {
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1747 := *x.Protocol
						yym1748 := z.EncBinary()
						_ = yym1748
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1747) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1747))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1745[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Protocol == nil {
						r.EncodeNil()
					} else {
						yy1749 := *x.Protocol
						yym1750 := z.EncBinary()
						_ = yym1750
						if false {
						} else if z.HasExtensions() && z.EncExt(yy1749) {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy1749))
						}
					}
				}
			}
			if yyr1745 || yy2arr1745 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1745[1] {
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1752 := z.EncBinary()
						_ = yym1752
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1752 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1745[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("port"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Port == nil {
						r.EncodeNil()
					} else {
						yym1753 := z.EncBinary()
						_ = yym1753
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Port) {
						} else if !yym1753 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.Port)
						} else {
							z.EncFallback(x.Port)
						}
					}
				}
			}
			if yyr1745 || yy2arr1745 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1754 := z.DecBinary()
	_ = yym1754
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1755 := r.ContainerType()
		if yyct1755 == codecSelferValueTypeMap1234 {
			yyl1755 := r.ReadMapStart()
			if yyl1755 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1755, d)
			}
		} else if yyct1755 == codecSelferValueTypeArray1234 {
			yyl1755 := r.ReadArrayStart()
			if yyl1755 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1755, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1756Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1756Slc
	var yyhl1756 bool = l >= 0
	for yyj1756 := 0; ; yyj1756++ {
		if yyhl1756 {
			if yyj1756 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1756Slc = r.DecodeBytes(yys1756Slc, true, true)
		yys1756 := string(yys1756Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1756 {
		case "protocol":
			if r.TryDecodeAsNil() {
				if x.Protocol != nil {
					x.Protocol = nil
				}
			} else {
				if x.Protocol == nil {
					x.Protocol = new(pkg2_v1.Protocol)
				}
				x.Protocol.CodecDecodeSelf(d)
			}
		case "port":
			if r.TryDecodeAsNil() {
				if x.Port != nil {
					x.Port = nil
				}
			} else {
				if x.Port == nil {
					x.Port = new(pkg5_intstr.IntOrString)
				}
				yym1759 := z.DecBinary()
				_ = yym1759
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Port) {
				} else if !yym1759 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.Port)
				} else {
					z.DecFallback(x.Port, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1756)
		} // end switch yys1756
	} // end for yyj1756
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1760 int
	var yyb1760 bool
	var yyhl1760 bool = l >= 0
	yyj1760++
	if yyhl1760 {
		yyb1760 = yyj1760 > l
	} else {
		yyb1760 = r.CheckBreak()
	}
	if yyb1760 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Protocol != nil {
			x.Protocol = nil
		}
	} else {
		if x.Protocol == nil {
			x.Protocol = new(pkg2_v1.Protocol)
		}
		x.Protocol.CodecDecodeSelf(d)
	}
	yyj1760++
	if yyhl1760 {
		yyb1760 = yyj1760 > l
	} else {
		yyb1760 = r.CheckBreak()
	}
	if yyb1760 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Port != nil {
			x.Port = nil
		}
	} else {
		if x.Port == nil {
			x.Port = new(pkg5_intstr.IntOrString)
		}
		yym1763 := z.DecBinary()
		_ = yym1763
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Port) {
		} else if !yym1763 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.Port)
		} else {
			z.DecFallback(x.Port, false)
		}
	}
	for {
		yyj1760++
		if yyhl1760 {
			yyb1760 = yyj1760 > l
		} else {
			yyb1760 = r.CheckBreak()
		}
		if yyb1760 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1760-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyPeer) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1764 := z.EncBinary()
		_ = yym1764
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1765 := !z.EncBinary()
			yy2arr1765 := z.EncBasicHandle().StructToArray
			var yyq1765 [2]bool
			_, _, _ = yysep1765, yyq1765, yy2arr1765
			const yyr1765 bool = false
			yyq1765[0] = x.PodSelector != nil
			yyq1765[1] = x.NamespaceSelector != nil
			var yynn1765 int
			if yyr1765 || yy2arr1765 {
				r.EncodeArrayStart(2)
			} else {
				yynn1765 = 0
				for _, b := range yyq1765 {
					if b {
						yynn1765++
					}
				}
				r.EncodeMapStart(yynn1765)
				yynn1765 = 0
			}
			if yyr1765 || yy2arr1765 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1765[0] {
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						yym1767 := z.EncBinary()
						_ = yym1767
						if false {
						} else if z.HasExtensions() && z.EncExt(x.PodSelector) {
						} else {
							z.EncFallback(x.PodSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1765[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodSelector == nil {
						r.EncodeNil()
					} else {
						yym1768 := z.EncBinary()
						_ = yym1768
						if false {
						} else if z.HasExtensions() && z.EncExt(x.PodSelector) {
						} else {
							z.EncFallback(x.PodSelector)
						}
					}
				}
			}
			if yyr1765 || yy2arr1765 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1765[1] {
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						yym1770 := z.EncBinary()
						_ = yym1770
						if false {
						} else if z.HasExtensions() && z.EncExt(x.NamespaceSelector) {
						} else {
							z.EncFallback(x.NamespaceSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1765[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespaceSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NamespaceSelector == nil {
						r.EncodeNil()
					} else {
						yym1771 := z.EncBinary()
						_ = yym1771
						if false {
						} else if z.HasExtensions() && z.EncExt(x.NamespaceSelector) {
						} else {
							z.EncFallback(x.NamespaceSelector)
						}
					}
				}
			}
			if yyr1765 || yy2arr1765 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyPeer) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1772 := z.DecBinary()
	_ = yym1772
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1773 := r.ContainerType()
		if yyct1773 == codecSelferValueTypeMap1234 {
			yyl1773 := r.ReadMapStart()
			if yyl1773 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1773, d)
			}
		} else if yyct1773 == codecSelferValueTypeArray1234 {
			yyl1773 := r.ReadArrayStart()
			if yyl1773 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1773, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1774Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1774Slc
	var yyhl1774 bool = l >= 0
	for yyj1774 := 0; ; yyj1774++ {
		if yyhl1774 {
			if yyj1774 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1774Slc = r.DecodeBytes(yys1774Slc, true, true)
		yys1774 := string(yys1774Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1774 {
		case "podSelector":
			if r.TryDecodeAsNil() {
				if x.PodSelector != nil {
					x.PodSelector = nil
				}
			} else {
				if x.PodSelector == nil {
					x.PodSelector = new(pkg1_unversioned.LabelSelector)
				}
				yym1776 := z.DecBinary()
				_ = yym1776
				if false {
				} else if z.HasExtensions() && z.DecExt(x.PodSelector) {
				} else {
					z.DecFallback(x.PodSelector, false)
				}
			}
		case "namespaceSelector":
			if r.TryDecodeAsNil() {
				if x.NamespaceSelector != nil {
					x.NamespaceSelector = nil
				}
			} else {
				if x.NamespaceSelector == nil {
					x.NamespaceSelector = new(pkg1_unversioned.LabelSelector)
				}
				yym1778 := z.DecBinary()
				_ = yym1778
				if false {
				} else if z.HasExtensions() && z.DecExt(x.NamespaceSelector) {
				} else {
					z.DecFallback(x.NamespaceSelector, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1774)
		} // end switch yys1774
	} // end for yyj1774
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyPeer) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1779 int
	var yyb1779 bool
	var yyhl1779 bool = l >= 0
	yyj1779++
	if yyhl1779 {
		yyb1779 = yyj1779 > l
	} else {
		yyb1779 = r.CheckBreak()
	}
	if yyb1779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodSelector != nil {
			x.PodSelector = nil
		}
	} else {
		if x.PodSelector == nil {
			x.PodSelector = new(pkg1_unversioned.LabelSelector)
		}
		yym1781 := z.DecBinary()
		_ = yym1781
		if false {
		} else if z.HasExtensions() && z.DecExt(x.PodSelector) {
		} else {
			z.DecFallback(x.PodSelector, false)
		}
	}
	yyj1779++
	if yyhl1779 {
		yyb1779 = yyj1779 > l
	} else {
		yyb1779 = r.CheckBreak()
	}
	if yyb1779 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NamespaceSelector != nil {
			x.NamespaceSelector = nil
		}
	} else {
		if x.NamespaceSelector == nil {
			x.NamespaceSelector = new(pkg1_unversioned.LabelSelector)
		}
		yym1783 := z.DecBinary()
		_ = yym1783
		if false {
		} else if z.HasExtensions() && z.DecExt(x.NamespaceSelector) {
		} else {
			z.DecFallback(x.NamespaceSelector, false)
		}
	}
	for {
		yyj1779++
		if yyhl1779 {
			yyb1779 = yyj1779 > l
		} else {
			yyb1779 = r.CheckBreak()
		}
		if yyb1779 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1779-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NetworkPolicyList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1784 := z.EncBinary()
		_ = yym1784
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep1785 := !z.EncBinary()
			yy2arr1785 := z.EncBasicHandle().StructToArray
			var yyq1785 [4]bool
			_, _, _ = yysep1785, yyq1785, yy2arr1785
			const yyr1785 bool = false
			yyq1785[0] = x.Kind != ""
			yyq1785[1] = x.APIVersion != ""
			yyq1785[2] = true
			var yynn1785 int
			if yyr1785 || yy2arr1785 {
				r.EncodeArrayStart(4)
			} else {
				yynn1785 = 1
				for _, b := range yyq1785 {
					if b {
						yynn1785++
					}
				}
				r.EncodeMapStart(yynn1785)
				yynn1785 = 0
			}
			if yyr1785 || yy2arr1785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1785[0] {
					yym1787 := z.EncBinary()
					_ = yym1787
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1785[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1788 := z.EncBinary()
					_ = yym1788
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr1785 || yy2arr1785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1785[1] {
					yym1790 := z.EncBinary()
					_ = yym1790
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq1785[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym1791 := z.EncBinary()
					_ = yym1791
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr1785 || yy2arr1785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq1785[2] {
					yy1793 := &x.ListMeta
					yym1794 := z.EncBinary()
					_ = yym1794
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1793) {
					} else {
						z.EncFallback(yy1793)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq1785[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy1795 := &x.ListMeta
					yym1796 := z.EncBinary()
					_ = yym1796
					if false {
					} else if z.HasExtensions() && z.EncExt(yy1795) {
					} else {
						z.EncFallback(yy1795)
					}
				}
			}
			if yyr1785 || yy2arr1785 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1798 := z.EncBinary()
					_ = yym1798
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym1799 := z.EncBinary()
					_ = yym1799
					if false {
					} else {
						h.encSliceNetworkPolicy(([]NetworkPolicy)(x.Items), e)
					}
				}
			}
			if yyr1785 || yy2arr1785 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NetworkPolicyList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1800 := z.DecBinary()
	_ = yym1800
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct1801 := r.ContainerType()
		if yyct1801 == codecSelferValueTypeMap1234 {
			yyl1801 := r.ReadMapStart()
			if yyl1801 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl1801, d)
			}
		} else if yyct1801 == codecSelferValueTypeArray1234 {
			yyl1801 := r.ReadArrayStart()
			if yyl1801 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl1801, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NetworkPolicyList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys1802Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys1802Slc
	var yyhl1802 bool = l >= 0
	for yyj1802 := 0; ; yyj1802++ {
		if yyhl1802 {
			if yyj1802 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys1802Slc = r.DecodeBytes(yys1802Slc, true, true)
		yys1802 := string(yys1802Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys1802 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv1805 := &x.ListMeta
				yym1806 := z.DecBinary()
				_ = yym1806
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv1805) {
				} else {
					z.DecFallback(yyv1805, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv1807 := &x.Items
				yym1808 := z.DecBinary()
				_ = yym1808
				if false {
				} else {
					h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1807), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys1802)
		} // end switch yys1802
	} // end for yyj1802
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NetworkPolicyList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj1809 int
	var yyb1809 bool
	var yyhl1809 bool = l >= 0
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv1812 := &x.ListMeta
		yym1813 := z.DecBinary()
		_ = yym1813
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv1812) {
		} else {
			z.DecFallback(yyv1812, false)
		}
	}
	yyj1809++
	if yyhl1809 {
		yyb1809 = yyj1809 > l
	} else {
		yyb1809 = r.CheckBreak()
	}
	if yyb1809 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv1814 := &x.Items
		yym1815 := z.DecBinary()
		_ = yym1815
		if false {
		} else {
			h.decSliceNetworkPolicy((*[]NetworkPolicy)(yyv1814), d)
		}
	}
	for {
		yyj1809++
		if yyhl1809 {
			yyb1809 = yyj1809 > l
		} else {
			yyb1809 = r.CheckBreak()
		}
		if yyb1809 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj1809-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceCustomMetricTarget(v []CustomMetricTarget, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1816 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1817 := &yyv1816
		yy1817.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricTarget(v *[]CustomMetricTarget, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1818 := *v
	yyh1818, yyl1818 := z.DecSliceHelperStart()
	var yyc1818 bool
	if yyl1818 == 0 {
		if yyv1818 == nil {
			yyv1818 = []CustomMetricTarget{}
			yyc1818 = true
		} else if len(yyv1818) != 0 {
			yyv1818 = yyv1818[:0]
			yyc1818 = true
		}
	} else if yyl1818 > 0 {
		var yyrr1818, yyrl1818 int
		var yyrt1818 bool
		if yyl1818 > cap(yyv1818) {

			yyrg1818 := len(yyv1818) > 0
			yyv21818 := yyv1818
			yyrl1818, yyrt1818 = z.DecInferLen(yyl1818, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1818 {
				if yyrl1818 <= cap(yyv1818) {
					yyv1818 = yyv1818[:yyrl1818]
				} else {
					yyv1818 = make([]CustomMetricTarget, yyrl1818)
				}
			} else {
				yyv1818 = make([]CustomMetricTarget, yyrl1818)
			}
			yyc1818 = true
			yyrr1818 = len(yyv1818)
			if yyrg1818 {
				copy(yyv1818, yyv21818)
			}
		} else if yyl1818 != len(yyv1818) {
			yyv1818 = yyv1818[:yyl1818]
			yyc1818 = true
		}
		yyj1818 := 0
		for ; yyj1818 < yyrr1818; yyj1818++ {
			yyh1818.ElemContainerState(yyj1818)
			if r.TryDecodeAsNil() {
				yyv1818[yyj1818] = CustomMetricTarget{}
			} else {
				yyv1819 := &yyv1818[yyj1818]
				yyv1819.CodecDecodeSelf(d)
			}

		}
		if yyrt1818 {
			for ; yyj1818 < yyl1818; yyj1818++ {
				yyv1818 = append(yyv1818, CustomMetricTarget{})
				yyh1818.ElemContainerState(yyj1818)
				if r.TryDecodeAsNil() {
					yyv1818[yyj1818] = CustomMetricTarget{}
				} else {
					yyv1820 := &yyv1818[yyj1818]
					yyv1820.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1818 := 0
		for ; !r.CheckBreak(); yyj1818++ {

			if yyj1818 >= len(yyv1818) {
				yyv1818 = append(yyv1818, CustomMetricTarget{}) // var yyz1818 CustomMetricTarget
				yyc1818 = true
			}
			yyh1818.ElemContainerState(yyj1818)
			if yyj1818 < len(yyv1818) {
				if r.TryDecodeAsNil() {
					yyv1818[yyj1818] = CustomMetricTarget{}
				} else {
					yyv1821 := &yyv1818[yyj1818]
					yyv1821.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1818 < len(yyv1818) {
			yyv1818 = yyv1818[:yyj1818]
			yyc1818 = true
		} else if yyj1818 == 0 && yyv1818 == nil {
			yyv1818 = []CustomMetricTarget{}
			yyc1818 = true
		}
	}
	yyh1818.End()
	if yyc1818 {
		*v = yyv1818
	}
}

func (x codecSelfer1234) encSliceCustomMetricCurrentStatus(v []CustomMetricCurrentStatus, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1822 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1823 := &yyv1822
		yy1823.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceCustomMetricCurrentStatus(v *[]CustomMetricCurrentStatus, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1824 := *v
	yyh1824, yyl1824 := z.DecSliceHelperStart()
	var yyc1824 bool
	if yyl1824 == 0 {
		if yyv1824 == nil {
			yyv1824 = []CustomMetricCurrentStatus{}
			yyc1824 = true
		} else if len(yyv1824) != 0 {
			yyv1824 = yyv1824[:0]
			yyc1824 = true
		}
	} else if yyl1824 > 0 {
		var yyrr1824, yyrl1824 int
		var yyrt1824 bool
		if yyl1824 > cap(yyv1824) {

			yyrg1824 := len(yyv1824) > 0
			yyv21824 := yyv1824
			yyrl1824, yyrt1824 = z.DecInferLen(yyl1824, z.DecBasicHandle().MaxInitLen, 72)
			if yyrt1824 {
				if yyrl1824 <= cap(yyv1824) {
					yyv1824 = yyv1824[:yyrl1824]
				} else {
					yyv1824 = make([]CustomMetricCurrentStatus, yyrl1824)
				}
			} else {
				yyv1824 = make([]CustomMetricCurrentStatus, yyrl1824)
			}
			yyc1824 = true
			yyrr1824 = len(yyv1824)
			if yyrg1824 {
				copy(yyv1824, yyv21824)
			}
		} else if yyl1824 != len(yyv1824) {
			yyv1824 = yyv1824[:yyl1824]
			yyc1824 = true
		}
		yyj1824 := 0
		for ; yyj1824 < yyrr1824; yyj1824++ {
			yyh1824.ElemContainerState(yyj1824)
			if r.TryDecodeAsNil() {
				yyv1824[yyj1824] = CustomMetricCurrentStatus{}
			} else {
				yyv1825 := &yyv1824[yyj1824]
				yyv1825.CodecDecodeSelf(d)
			}

		}
		if yyrt1824 {
			for ; yyj1824 < yyl1824; yyj1824++ {
				yyv1824 = append(yyv1824, CustomMetricCurrentStatus{})
				yyh1824.ElemContainerState(yyj1824)
				if r.TryDecodeAsNil() {
					yyv1824[yyj1824] = CustomMetricCurrentStatus{}
				} else {
					yyv1826 := &yyv1824[yyj1824]
					yyv1826.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1824 := 0
		for ; !r.CheckBreak(); yyj1824++ {

			if yyj1824 >= len(yyv1824) {
				yyv1824 = append(yyv1824, CustomMetricCurrentStatus{}) // var yyz1824 CustomMetricCurrentStatus
				yyc1824 = true
			}
			yyh1824.ElemContainerState(yyj1824)
			if yyj1824 < len(yyv1824) {
				if r.TryDecodeAsNil() {
					yyv1824[yyj1824] = CustomMetricCurrentStatus{}
				} else {
					yyv1827 := &yyv1824[yyj1824]
					yyv1827.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1824 < len(yyv1824) {
			yyv1824 = yyv1824[:yyj1824]
			yyc1824 = true
		} else if yyj1824 == 0 && yyv1824 == nil {
			yyv1824 = []CustomMetricCurrentStatus{}
			yyc1824 = true
		}
	}
	yyh1824.End()
	if yyc1824 {
		*v = yyv1824
	}
}

func (x codecSelfer1234) encSliceHorizontalPodAutoscaler(v []HorizontalPodAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1828 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1829 := &yyv1828
		yy1829.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHorizontalPodAutoscaler(v *[]HorizontalPodAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1830 := *v
	yyh1830, yyl1830 := z.DecSliceHelperStart()
	var yyc1830 bool
	if yyl1830 == 0 {
		if yyv1830 == nil {
			yyv1830 = []HorizontalPodAutoscaler{}
			yyc1830 = true
		} else if len(yyv1830) != 0 {
			yyv1830 = yyv1830[:0]
			yyc1830 = true
		}
	} else if yyl1830 > 0 {
		var yyrr1830, yyrl1830 int
		var yyrt1830 bool
		if yyl1830 > cap(yyv1830) {

			yyrg1830 := len(yyv1830) > 0
			yyv21830 := yyv1830
			yyrl1830, yyrt1830 = z.DecInferLen(yyl1830, z.DecBasicHandle().MaxInitLen, 376)
			if yyrt1830 {
				if yyrl1830 <= cap(yyv1830) {
					yyv1830 = yyv1830[:yyrl1830]
				} else {
					yyv1830 = make([]HorizontalPodAutoscaler, yyrl1830)
				}
			} else {
				yyv1830 = make([]HorizontalPodAutoscaler, yyrl1830)
			}
			yyc1830 = true
			yyrr1830 = len(yyv1830)
			if yyrg1830 {
				copy(yyv1830, yyv21830)
			}
		} else if yyl1830 != len(yyv1830) {
			yyv1830 = yyv1830[:yyl1830]
			yyc1830 = true
		}
		yyj1830 := 0
		for ; yyj1830 < yyrr1830; yyj1830++ {
			yyh1830.ElemContainerState(yyj1830)
			if r.TryDecodeAsNil() {
				yyv1830[yyj1830] = HorizontalPodAutoscaler{}
			} else {
				yyv1831 := &yyv1830[yyj1830]
				yyv1831.CodecDecodeSelf(d)
			}

		}
		if yyrt1830 {
			for ; yyj1830 < yyl1830; yyj1830++ {
				yyv1830 = append(yyv1830, HorizontalPodAutoscaler{})
				yyh1830.ElemContainerState(yyj1830)
				if r.TryDecodeAsNil() {
					yyv1830[yyj1830] = HorizontalPodAutoscaler{}
				} else {
					yyv1832 := &yyv1830[yyj1830]
					yyv1832.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1830 := 0
		for ; !r.CheckBreak(); yyj1830++ {

			if yyj1830 >= len(yyv1830) {
				yyv1830 = append(yyv1830, HorizontalPodAutoscaler{}) // var yyz1830 HorizontalPodAutoscaler
				yyc1830 = true
			}
			yyh1830.ElemContainerState(yyj1830)
			if yyj1830 < len(yyv1830) {
				if r.TryDecodeAsNil() {
					yyv1830[yyj1830] = HorizontalPodAutoscaler{}
				} else {
					yyv1833 := &yyv1830[yyj1830]
					yyv1833.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1830 < len(yyv1830) {
			yyv1830 = yyv1830[:yyj1830]
			yyc1830 = true
		} else if yyj1830 == 0 && yyv1830 == nil {
			yyv1830 = []HorizontalPodAutoscaler{}
			yyc1830 = true
		}
	}
	yyh1830.End()
	if yyc1830 {
		*v = yyv1830
	}
}

func (x codecSelfer1234) encSliceAPIVersion(v []APIVersion, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1834 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1835 := &yyv1834
		yy1835.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceAPIVersion(v *[]APIVersion, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1836 := *v
	yyh1836, yyl1836 := z.DecSliceHelperStart()
	var yyc1836 bool
	if yyl1836 == 0 {
		if yyv1836 == nil {
			yyv1836 = []APIVersion{}
			yyc1836 = true
		} else if len(yyv1836) != 0 {
			yyv1836 = yyv1836[:0]
			yyc1836 = true
		}
	} else if yyl1836 > 0 {
		var yyrr1836, yyrl1836 int
		var yyrt1836 bool
		if yyl1836 > cap(yyv1836) {

			yyrg1836 := len(yyv1836) > 0
			yyv21836 := yyv1836
			yyrl1836, yyrt1836 = z.DecInferLen(yyl1836, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1836 {
				if yyrl1836 <= cap(yyv1836) {
					yyv1836 = yyv1836[:yyrl1836]
				} else {
					yyv1836 = make([]APIVersion, yyrl1836)
				}
			} else {
				yyv1836 = make([]APIVersion, yyrl1836)
			}
			yyc1836 = true
			yyrr1836 = len(yyv1836)
			if yyrg1836 {
				copy(yyv1836, yyv21836)
			}
		} else if yyl1836 != len(yyv1836) {
			yyv1836 = yyv1836[:yyl1836]
			yyc1836 = true
		}
		yyj1836 := 0
		for ; yyj1836 < yyrr1836; yyj1836++ {
			yyh1836.ElemContainerState(yyj1836)
			if r.TryDecodeAsNil() {
				yyv1836[yyj1836] = APIVersion{}
			} else {
				yyv1837 := &yyv1836[yyj1836]
				yyv1837.CodecDecodeSelf(d)
			}

		}
		if yyrt1836 {
			for ; yyj1836 < yyl1836; yyj1836++ {
				yyv1836 = append(yyv1836, APIVersion{})
				yyh1836.ElemContainerState(yyj1836)
				if r.TryDecodeAsNil() {
					yyv1836[yyj1836] = APIVersion{}
				} else {
					yyv1838 := &yyv1836[yyj1836]
					yyv1838.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1836 := 0
		for ; !r.CheckBreak(); yyj1836++ {

			if yyj1836 >= len(yyv1836) {
				yyv1836 = append(yyv1836, APIVersion{}) // var yyz1836 APIVersion
				yyc1836 = true
			}
			yyh1836.ElemContainerState(yyj1836)
			if yyj1836 < len(yyv1836) {
				if r.TryDecodeAsNil() {
					yyv1836[yyj1836] = APIVersion{}
				} else {
					yyv1839 := &yyv1836[yyj1836]
					yyv1839.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1836 < len(yyv1836) {
			yyv1836 = yyv1836[:yyj1836]
			yyc1836 = true
		} else if yyj1836 == 0 && yyv1836 == nil {
			yyv1836 = []APIVersion{}
			yyc1836 = true
		}
	}
	yyh1836.End()
	if yyc1836 {
		*v = yyv1836
	}
}

func (x codecSelfer1234) encSliceThirdPartyResource(v []ThirdPartyResource, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1840 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1841 := &yyv1840
		yy1841.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResource(v *[]ThirdPartyResource, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1842 := *v
	yyh1842, yyl1842 := z.DecSliceHelperStart()
	var yyc1842 bool
	if yyl1842 == 0 {
		if yyv1842 == nil {
			yyv1842 = []ThirdPartyResource{}
			yyc1842 = true
		} else if len(yyv1842) != 0 {
			yyv1842 = yyv1842[:0]
			yyc1842 = true
		}
	} else if yyl1842 > 0 {
		var yyrr1842, yyrl1842 int
		var yyrt1842 bool
		if yyl1842 > cap(yyv1842) {

			yyrg1842 := len(yyv1842) > 0
			yyv21842 := yyv1842
			yyrl1842, yyrt1842 = z.DecInferLen(yyl1842, z.DecBasicHandle().MaxInitLen, 296)
			if yyrt1842 {
				if yyrl1842 <= cap(yyv1842) {
					yyv1842 = yyv1842[:yyrl1842]
				} else {
					yyv1842 = make([]ThirdPartyResource, yyrl1842)
				}
			} else {
				yyv1842 = make([]ThirdPartyResource, yyrl1842)
			}
			yyc1842 = true
			yyrr1842 = len(yyv1842)
			if yyrg1842 {
				copy(yyv1842, yyv21842)
			}
		} else if yyl1842 != len(yyv1842) {
			yyv1842 = yyv1842[:yyl1842]
			yyc1842 = true
		}
		yyj1842 := 0
		for ; yyj1842 < yyrr1842; yyj1842++ {
			yyh1842.ElemContainerState(yyj1842)
			if r.TryDecodeAsNil() {
				yyv1842[yyj1842] = ThirdPartyResource{}
			} else {
				yyv1843 := &yyv1842[yyj1842]
				yyv1843.CodecDecodeSelf(d)
			}

		}
		if yyrt1842 {
			for ; yyj1842 < yyl1842; yyj1842++ {
				yyv1842 = append(yyv1842, ThirdPartyResource{})
				yyh1842.ElemContainerState(yyj1842)
				if r.TryDecodeAsNil() {
					yyv1842[yyj1842] = ThirdPartyResource{}
				} else {
					yyv1844 := &yyv1842[yyj1842]
					yyv1844.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1842 := 0
		for ; !r.CheckBreak(); yyj1842++ {

			if yyj1842 >= len(yyv1842) {
				yyv1842 = append(yyv1842, ThirdPartyResource{}) // var yyz1842 ThirdPartyResource
				yyc1842 = true
			}
			yyh1842.ElemContainerState(yyj1842)
			if yyj1842 < len(yyv1842) {
				if r.TryDecodeAsNil() {
					yyv1842[yyj1842] = ThirdPartyResource{}
				} else {
					yyv1845 := &yyv1842[yyj1842]
					yyv1845.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1842 < len(yyv1842) {
			yyv1842 = yyv1842[:yyj1842]
			yyc1842 = true
		} else if yyj1842 == 0 && yyv1842 == nil {
			yyv1842 = []ThirdPartyResource{}
			yyc1842 = true
		}
	}
	yyh1842.End()
	if yyc1842 {
		*v = yyv1842
	}
}

func (x codecSelfer1234) encSliceDeploymentCondition(v []DeploymentCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1846 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1847 := &yyv1846
		yy1847.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeploymentCondition(v *[]DeploymentCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1848 := *v
	yyh1848, yyl1848 := z.DecSliceHelperStart()
	var yyc1848 bool
	if yyl1848 == 0 {
		if yyv1848 == nil {
			yyv1848 = []DeploymentCondition{}
			yyc1848 = true
		} else if len(yyv1848) != 0 {
			yyv1848 = yyv1848[:0]
			yyc1848 = true
		}
	} else if yyl1848 > 0 {
		var yyrr1848, yyrl1848 int
		var yyrt1848 bool
		if yyl1848 > cap(yyv1848) {

			yyrg1848 := len(yyv1848) > 0
			yyv21848 := yyv1848
			yyrl1848, yyrt1848 = z.DecInferLen(yyl1848, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt1848 {
				if yyrl1848 <= cap(yyv1848) {
					yyv1848 = yyv1848[:yyrl1848]
				} else {
					yyv1848 = make([]DeploymentCondition, yyrl1848)
				}
			} else {
				yyv1848 = make([]DeploymentCondition, yyrl1848)
			}
			yyc1848 = true
			yyrr1848 = len(yyv1848)
			if yyrg1848 {
				copy(yyv1848, yyv21848)
			}
		} else if yyl1848 != len(yyv1848) {
			yyv1848 = yyv1848[:yyl1848]
			yyc1848 = true
		}
		yyj1848 := 0
		for ; yyj1848 < yyrr1848; yyj1848++ {
			yyh1848.ElemContainerState(yyj1848)
			if r.TryDecodeAsNil() {
				yyv1848[yyj1848] = DeploymentCondition{}
			} else {
				yyv1849 := &yyv1848[yyj1848]
				yyv1849.CodecDecodeSelf(d)
			}

		}
		if yyrt1848 {
			for ; yyj1848 < yyl1848; yyj1848++ {
				yyv1848 = append(yyv1848, DeploymentCondition{})
				yyh1848.ElemContainerState(yyj1848)
				if r.TryDecodeAsNil() {
					yyv1848[yyj1848] = DeploymentCondition{}
				} else {
					yyv1850 := &yyv1848[yyj1848]
					yyv1850.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1848 := 0
		for ; !r.CheckBreak(); yyj1848++ {

			if yyj1848 >= len(yyv1848) {
				yyv1848 = append(yyv1848, DeploymentCondition{}) // var yyz1848 DeploymentCondition
				yyc1848 = true
			}
			yyh1848.ElemContainerState(yyj1848)
			if yyj1848 < len(yyv1848) {
				if r.TryDecodeAsNil() {
					yyv1848[yyj1848] = DeploymentCondition{}
				} else {
					yyv1851 := &yyv1848[yyj1848]
					yyv1851.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1848 < len(yyv1848) {
			yyv1848 = yyv1848[:yyj1848]
			yyc1848 = true
		} else if yyj1848 == 0 && yyv1848 == nil {
			yyv1848 = []DeploymentCondition{}
			yyc1848 = true
		}
	}
	yyh1848.End()
	if yyc1848 {
		*v = yyv1848
	}
}

func (x codecSelfer1234) encSliceDeployment(v []Deployment, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1852 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1853 := &yyv1852
		yy1853.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDeployment(v *[]Deployment, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1854 := *v
	yyh1854, yyl1854 := z.DecSliceHelperStart()
	var yyc1854 bool
	if yyl1854 == 0 {
		if yyv1854 == nil {
			yyv1854 = []Deployment{}
			yyc1854 = true
		} else if len(yyv1854) != 0 {
			yyv1854 = yyv1854[:0]
			yyc1854 = true
		}
	} else if yyl1854 > 0 {
		var yyrr1854, yyrl1854 int
		var yyrt1854 bool
		if yyl1854 > cap(yyv1854) {

			yyrg1854 := len(yyv1854) > 0
			yyv21854 := yyv1854
			yyrl1854, yyrt1854 = z.DecInferLen(yyl1854, z.DecBasicHandle().MaxInitLen, 856)
			if yyrt1854 {
				if yyrl1854 <= cap(yyv1854) {
					yyv1854 = yyv1854[:yyrl1854]
				} else {
					yyv1854 = make([]Deployment, yyrl1854)
				}
			} else {
				yyv1854 = make([]Deployment, yyrl1854)
			}
			yyc1854 = true
			yyrr1854 = len(yyv1854)
			if yyrg1854 {
				copy(yyv1854, yyv21854)
			}
		} else if yyl1854 != len(yyv1854) {
			yyv1854 = yyv1854[:yyl1854]
			yyc1854 = true
		}
		yyj1854 := 0
		for ; yyj1854 < yyrr1854; yyj1854++ {
			yyh1854.ElemContainerState(yyj1854)
			if r.TryDecodeAsNil() {
				yyv1854[yyj1854] = Deployment{}
			} else {
				yyv1855 := &yyv1854[yyj1854]
				yyv1855.CodecDecodeSelf(d)
			}

		}
		if yyrt1854 {
			for ; yyj1854 < yyl1854; yyj1854++ {
				yyv1854 = append(yyv1854, Deployment{})
				yyh1854.ElemContainerState(yyj1854)
				if r.TryDecodeAsNil() {
					yyv1854[yyj1854] = Deployment{}
				} else {
					yyv1856 := &yyv1854[yyj1854]
					yyv1856.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1854 := 0
		for ; !r.CheckBreak(); yyj1854++ {

			if yyj1854 >= len(yyv1854) {
				yyv1854 = append(yyv1854, Deployment{}) // var yyz1854 Deployment
				yyc1854 = true
			}
			yyh1854.ElemContainerState(yyj1854)
			if yyj1854 < len(yyv1854) {
				if r.TryDecodeAsNil() {
					yyv1854[yyj1854] = Deployment{}
				} else {
					yyv1857 := &yyv1854[yyj1854]
					yyv1857.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1854 < len(yyv1854) {
			yyv1854 = yyv1854[:yyj1854]
			yyc1854 = true
		} else if yyj1854 == 0 && yyv1854 == nil {
			yyv1854 = []Deployment{}
			yyc1854 = true
		}
	}
	yyh1854.End()
	if yyc1854 {
		*v = yyv1854
	}
}

func (x codecSelfer1234) encSliceDaemonSet(v []DaemonSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1858 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1859 := &yyv1858
		yy1859.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceDaemonSet(v *[]DaemonSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1860 := *v
	yyh1860, yyl1860 := z.DecSliceHelperStart()
	var yyc1860 bool
	if yyl1860 == 0 {
		if yyv1860 == nil {
			yyv1860 = []DaemonSet{}
			yyc1860 = true
		} else if len(yyv1860) != 0 {
			yyv1860 = yyv1860[:0]
			yyc1860 = true
		}
	} else if yyl1860 > 0 {
		var yyrr1860, yyrl1860 int
		var yyrt1860 bool
		if yyl1860 > cap(yyv1860) {

			yyrg1860 := len(yyv1860) > 0
			yyv21860 := yyv1860
			yyrl1860, yyrt1860 = z.DecInferLen(yyl1860, z.DecBasicHandle().MaxInitLen, 752)
			if yyrt1860 {
				if yyrl1860 <= cap(yyv1860) {
					yyv1860 = yyv1860[:yyrl1860]
				} else {
					yyv1860 = make([]DaemonSet, yyrl1860)
				}
			} else {
				yyv1860 = make([]DaemonSet, yyrl1860)
			}
			yyc1860 = true
			yyrr1860 = len(yyv1860)
			if yyrg1860 {
				copy(yyv1860, yyv21860)
			}
		} else if yyl1860 != len(yyv1860) {
			yyv1860 = yyv1860[:yyl1860]
			yyc1860 = true
		}
		yyj1860 := 0
		for ; yyj1860 < yyrr1860; yyj1860++ {
			yyh1860.ElemContainerState(yyj1860)
			if r.TryDecodeAsNil() {
				yyv1860[yyj1860] = DaemonSet{}
			} else {
				yyv1861 := &yyv1860[yyj1860]
				yyv1861.CodecDecodeSelf(d)
			}

		}
		if yyrt1860 {
			for ; yyj1860 < yyl1860; yyj1860++ {
				yyv1860 = append(yyv1860, DaemonSet{})
				yyh1860.ElemContainerState(yyj1860)
				if r.TryDecodeAsNil() {
					yyv1860[yyj1860] = DaemonSet{}
				} else {
					yyv1862 := &yyv1860[yyj1860]
					yyv1862.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1860 := 0
		for ; !r.CheckBreak(); yyj1860++ {

			if yyj1860 >= len(yyv1860) {
				yyv1860 = append(yyv1860, DaemonSet{}) // var yyz1860 DaemonSet
				yyc1860 = true
			}
			yyh1860.ElemContainerState(yyj1860)
			if yyj1860 < len(yyv1860) {
				if r.TryDecodeAsNil() {
					yyv1860[yyj1860] = DaemonSet{}
				} else {
					yyv1863 := &yyv1860[yyj1860]
					yyv1863.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1860 < len(yyv1860) {
			yyv1860 = yyv1860[:yyj1860]
			yyc1860 = true
		} else if yyj1860 == 0 && yyv1860 == nil {
			yyv1860 = []DaemonSet{}
			yyc1860 = true
		}
	}
	yyh1860.End()
	if yyc1860 {
		*v = yyv1860
	}
}

func (x codecSelfer1234) encSliceThirdPartyResourceData(v []ThirdPartyResourceData, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1864 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1865 := &yyv1864
		yy1865.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceThirdPartyResourceData(v *[]ThirdPartyResourceData, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1866 := *v
	yyh1866, yyl1866 := z.DecSliceHelperStart()
	var yyc1866 bool
	if yyl1866 == 0 {
		if yyv1866 == nil {
			yyv1866 = []ThirdPartyResourceData{}
			yyc1866 = true
		} else if len(yyv1866) != 0 {
			yyv1866 = yyv1866[:0]
			yyc1866 = true
		}
	} else if yyl1866 > 0 {
		var yyrr1866, yyrl1866 int
		var yyrt1866 bool
		if yyl1866 > cap(yyv1866) {

			yyrg1866 := len(yyv1866) > 0
			yyv21866 := yyv1866
			yyrl1866, yyrt1866 = z.DecInferLen(yyl1866, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt1866 {
				if yyrl1866 <= cap(yyv1866) {
					yyv1866 = yyv1866[:yyrl1866]
				} else {
					yyv1866 = make([]ThirdPartyResourceData, yyrl1866)
				}
			} else {
				yyv1866 = make([]ThirdPartyResourceData, yyrl1866)
			}
			yyc1866 = true
			yyrr1866 = len(yyv1866)
			if yyrg1866 {
				copy(yyv1866, yyv21866)
			}
		} else if yyl1866 != len(yyv1866) {
			yyv1866 = yyv1866[:yyl1866]
			yyc1866 = true
		}
		yyj1866 := 0
		for ; yyj1866 < yyrr1866; yyj1866++ {
			yyh1866.ElemContainerState(yyj1866)
			if r.TryDecodeAsNil() {
				yyv1866[yyj1866] = ThirdPartyResourceData{}
			} else {
				yyv1867 := &yyv1866[yyj1866]
				yyv1867.CodecDecodeSelf(d)
			}

		}
		if yyrt1866 {
			for ; yyj1866 < yyl1866; yyj1866++ {
				yyv1866 = append(yyv1866, ThirdPartyResourceData{})
				yyh1866.ElemContainerState(yyj1866)
				if r.TryDecodeAsNil() {
					yyv1866[yyj1866] = ThirdPartyResourceData{}
				} else {
					yyv1868 := &yyv1866[yyj1866]
					yyv1868.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1866 := 0
		for ; !r.CheckBreak(); yyj1866++ {

			if yyj1866 >= len(yyv1866) {
				yyv1866 = append(yyv1866, ThirdPartyResourceData{}) // var yyz1866 ThirdPartyResourceData
				yyc1866 = true
			}
			yyh1866.ElemContainerState(yyj1866)
			if yyj1866 < len(yyv1866) {
				if r.TryDecodeAsNil() {
					yyv1866[yyj1866] = ThirdPartyResourceData{}
				} else {
					yyv1869 := &yyv1866[yyj1866]
					yyv1869.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1866 < len(yyv1866) {
			yyv1866 = yyv1866[:yyj1866]
			yyc1866 = true
		} else if yyj1866 == 0 && yyv1866 == nil {
			yyv1866 = []ThirdPartyResourceData{}
			yyc1866 = true
		}
	}
	yyh1866.End()
	if yyc1866 {
		*v = yyv1866
	}
}

func (x codecSelfer1234) encSliceJob(v []Job, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1870 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1871 := &yyv1870
		yy1871.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJob(v *[]Job, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1872 := *v
	yyh1872, yyl1872 := z.DecSliceHelperStart()
	var yyc1872 bool
	if yyl1872 == 0 {
		if yyv1872 == nil {
			yyv1872 = []Job{}
			yyc1872 = true
		} else if len(yyv1872) != 0 {
			yyv1872 = yyv1872[:0]
			yyc1872 = true
		}
	} else if yyl1872 > 0 {
		var yyrr1872, yyrl1872 int
		var yyrt1872 bool
		if yyl1872 > cap(yyv1872) {

			yyrg1872 := len(yyv1872) > 0
			yyv21872 := yyv1872
			yyrl1872, yyrt1872 = z.DecInferLen(yyl1872, z.DecBasicHandle().MaxInitLen, 824)
			if yyrt1872 {
				if yyrl1872 <= cap(yyv1872) {
					yyv1872 = yyv1872[:yyrl1872]
				} else {
					yyv1872 = make([]Job, yyrl1872)
				}
			} else {
				yyv1872 = make([]Job, yyrl1872)
			}
			yyc1872 = true
			yyrr1872 = len(yyv1872)
			if yyrg1872 {
				copy(yyv1872, yyv21872)
			}
		} else if yyl1872 != len(yyv1872) {
			yyv1872 = yyv1872[:yyl1872]
			yyc1872 = true
		}
		yyj1872 := 0
		for ; yyj1872 < yyrr1872; yyj1872++ {
			yyh1872.ElemContainerState(yyj1872)
			if r.TryDecodeAsNil() {
				yyv1872[yyj1872] = Job{}
			} else {
				yyv1873 := &yyv1872[yyj1872]
				yyv1873.CodecDecodeSelf(d)
			}

		}
		if yyrt1872 {
			for ; yyj1872 < yyl1872; yyj1872++ {
				yyv1872 = append(yyv1872, Job{})
				yyh1872.ElemContainerState(yyj1872)
				if r.TryDecodeAsNil() {
					yyv1872[yyj1872] = Job{}
				} else {
					yyv1874 := &yyv1872[yyj1872]
					yyv1874.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1872 := 0
		for ; !r.CheckBreak(); yyj1872++ {

			if yyj1872 >= len(yyv1872) {
				yyv1872 = append(yyv1872, Job{}) // var yyz1872 Job
				yyc1872 = true
			}
			yyh1872.ElemContainerState(yyj1872)
			if yyj1872 < len(yyv1872) {
				if r.TryDecodeAsNil() {
					yyv1872[yyj1872] = Job{}
				} else {
					yyv1875 := &yyv1872[yyj1872]
					yyv1875.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1872 < len(yyv1872) {
			yyv1872 = yyv1872[:yyj1872]
			yyc1872 = true
		} else if yyj1872 == 0 && yyv1872 == nil {
			yyv1872 = []Job{}
			yyc1872 = true
		}
	}
	yyh1872.End()
	if yyc1872 {
		*v = yyv1872
	}
}

func (x codecSelfer1234) encSliceJobCondition(v []JobCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1876 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1877 := &yyv1876
		yy1877.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceJobCondition(v *[]JobCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1878 := *v
	yyh1878, yyl1878 := z.DecSliceHelperStart()
	var yyc1878 bool
	if yyl1878 == 0 {
		if yyv1878 == nil {
			yyv1878 = []JobCondition{}
			yyc1878 = true
		} else if len(yyv1878) != 0 {
			yyv1878 = yyv1878[:0]
			yyc1878 = true
		}
	} else if yyl1878 > 0 {
		var yyrr1878, yyrl1878 int
		var yyrt1878 bool
		if yyl1878 > cap(yyv1878) {

			yyrg1878 := len(yyv1878) > 0
			yyv21878 := yyv1878
			yyrl1878, yyrt1878 = z.DecInferLen(yyl1878, z.DecBasicHandle().MaxInitLen, 112)
			if yyrt1878 {
				if yyrl1878 <= cap(yyv1878) {
					yyv1878 = yyv1878[:yyrl1878]
				} else {
					yyv1878 = make([]JobCondition, yyrl1878)
				}
			} else {
				yyv1878 = make([]JobCondition, yyrl1878)
			}
			yyc1878 = true
			yyrr1878 = len(yyv1878)
			if yyrg1878 {
				copy(yyv1878, yyv21878)
			}
		} else if yyl1878 != len(yyv1878) {
			yyv1878 = yyv1878[:yyl1878]
			yyc1878 = true
		}
		yyj1878 := 0
		for ; yyj1878 < yyrr1878; yyj1878++ {
			yyh1878.ElemContainerState(yyj1878)
			if r.TryDecodeAsNil() {
				yyv1878[yyj1878] = JobCondition{}
			} else {
				yyv1879 := &yyv1878[yyj1878]
				yyv1879.CodecDecodeSelf(d)
			}

		}
		if yyrt1878 {
			for ; yyj1878 < yyl1878; yyj1878++ {
				yyv1878 = append(yyv1878, JobCondition{})
				yyh1878.ElemContainerState(yyj1878)
				if r.TryDecodeAsNil() {
					yyv1878[yyj1878] = JobCondition{}
				} else {
					yyv1880 := &yyv1878[yyj1878]
					yyv1880.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1878 := 0
		for ; !r.CheckBreak(); yyj1878++ {

			if yyj1878 >= len(yyv1878) {
				yyv1878 = append(yyv1878, JobCondition{}) // var yyz1878 JobCondition
				yyc1878 = true
			}
			yyh1878.ElemContainerState(yyj1878)
			if yyj1878 < len(yyv1878) {
				if r.TryDecodeAsNil() {
					yyv1878[yyj1878] = JobCondition{}
				} else {
					yyv1881 := &yyv1878[yyj1878]
					yyv1881.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1878 < len(yyv1878) {
			yyv1878 = yyv1878[:yyj1878]
			yyc1878 = true
		} else if yyj1878 == 0 && yyv1878 == nil {
			yyv1878 = []JobCondition{}
			yyc1878 = true
		}
	}
	yyh1878.End()
	if yyc1878 {
		*v = yyv1878
	}
}

func (x codecSelfer1234) encSliceIngress(v []Ingress, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1882 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1883 := &yyv1882
		yy1883.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngress(v *[]Ingress, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1884 := *v
	yyh1884, yyl1884 := z.DecSliceHelperStart()
	var yyc1884 bool
	if yyl1884 == 0 {
		if yyv1884 == nil {
			yyv1884 = []Ingress{}
			yyc1884 = true
		} else if len(yyv1884) != 0 {
			yyv1884 = yyv1884[:0]
			yyc1884 = true
		}
	} else if yyl1884 > 0 {
		var yyrr1884, yyrl1884 int
		var yyrt1884 bool
		if yyl1884 > cap(yyv1884) {

			yyrg1884 := len(yyv1884) > 0
			yyv21884 := yyv1884
			yyrl1884, yyrt1884 = z.DecInferLen(yyl1884, z.DecBasicHandle().MaxInitLen, 336)
			if yyrt1884 {
				if yyrl1884 <= cap(yyv1884) {
					yyv1884 = yyv1884[:yyrl1884]
				} else {
					yyv1884 = make([]Ingress, yyrl1884)
				}
			} else {
				yyv1884 = make([]Ingress, yyrl1884)
			}
			yyc1884 = true
			yyrr1884 = len(yyv1884)
			if yyrg1884 {
				copy(yyv1884, yyv21884)
			}
		} else if yyl1884 != len(yyv1884) {
			yyv1884 = yyv1884[:yyl1884]
			yyc1884 = true
		}
		yyj1884 := 0
		for ; yyj1884 < yyrr1884; yyj1884++ {
			yyh1884.ElemContainerState(yyj1884)
			if r.TryDecodeAsNil() {
				yyv1884[yyj1884] = Ingress{}
			} else {
				yyv1885 := &yyv1884[yyj1884]
				yyv1885.CodecDecodeSelf(d)
			}

		}
		if yyrt1884 {
			for ; yyj1884 < yyl1884; yyj1884++ {
				yyv1884 = append(yyv1884, Ingress{})
				yyh1884.ElemContainerState(yyj1884)
				if r.TryDecodeAsNil() {
					yyv1884[yyj1884] = Ingress{}
				} else {
					yyv1886 := &yyv1884[yyj1884]
					yyv1886.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1884 := 0
		for ; !r.CheckBreak(); yyj1884++ {

			if yyj1884 >= len(yyv1884) {
				yyv1884 = append(yyv1884, Ingress{}) // var yyz1884 Ingress
				yyc1884 = true
			}
			yyh1884.ElemContainerState(yyj1884)
			if yyj1884 < len(yyv1884) {
				if r.TryDecodeAsNil() {
					yyv1884[yyj1884] = Ingress{}
				} else {
					yyv1887 := &yyv1884[yyj1884]
					yyv1887.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1884 < len(yyv1884) {
			yyv1884 = yyv1884[:yyj1884]
			yyc1884 = true
		} else if yyj1884 == 0 && yyv1884 == nil {
			yyv1884 = []Ingress{}
			yyc1884 = true
		}
	}
	yyh1884.End()
	if yyc1884 {
		*v = yyv1884
	}
}

func (x codecSelfer1234) encSliceIngressTLS(v []IngressTLS, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1888 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1889 := &yyv1888
		yy1889.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressTLS(v *[]IngressTLS, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1890 := *v
	yyh1890, yyl1890 := z.DecSliceHelperStart()
	var yyc1890 bool
	if yyl1890 == 0 {
		if yyv1890 == nil {
			yyv1890 = []IngressTLS{}
			yyc1890 = true
		} else if len(yyv1890) != 0 {
			yyv1890 = yyv1890[:0]
			yyc1890 = true
		}
	} else if yyl1890 > 0 {
		var yyrr1890, yyrl1890 int
		var yyrt1890 bool
		if yyl1890 > cap(yyv1890) {

			yyrg1890 := len(yyv1890) > 0
			yyv21890 := yyv1890
			yyrl1890, yyrt1890 = z.DecInferLen(yyl1890, z.DecBasicHandle().MaxInitLen, 40)
			if yyrt1890 {
				if yyrl1890 <= cap(yyv1890) {
					yyv1890 = yyv1890[:yyrl1890]
				} else {
					yyv1890 = make([]IngressTLS, yyrl1890)
				}
			} else {
				yyv1890 = make([]IngressTLS, yyrl1890)
			}
			yyc1890 = true
			yyrr1890 = len(yyv1890)
			if yyrg1890 {
				copy(yyv1890, yyv21890)
			}
		} else if yyl1890 != len(yyv1890) {
			yyv1890 = yyv1890[:yyl1890]
			yyc1890 = true
		}
		yyj1890 := 0
		for ; yyj1890 < yyrr1890; yyj1890++ {
			yyh1890.ElemContainerState(yyj1890)
			if r.TryDecodeAsNil() {
				yyv1890[yyj1890] = IngressTLS{}
			} else {
				yyv1891 := &yyv1890[yyj1890]
				yyv1891.CodecDecodeSelf(d)
			}

		}
		if yyrt1890 {
			for ; yyj1890 < yyl1890; yyj1890++ {
				yyv1890 = append(yyv1890, IngressTLS{})
				yyh1890.ElemContainerState(yyj1890)
				if r.TryDecodeAsNil() {
					yyv1890[yyj1890] = IngressTLS{}
				} else {
					yyv1892 := &yyv1890[yyj1890]
					yyv1892.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1890 := 0
		for ; !r.CheckBreak(); yyj1890++ {

			if yyj1890 >= len(yyv1890) {
				yyv1890 = append(yyv1890, IngressTLS{}) // var yyz1890 IngressTLS
				yyc1890 = true
			}
			yyh1890.ElemContainerState(yyj1890)
			if yyj1890 < len(yyv1890) {
				if r.TryDecodeAsNil() {
					yyv1890[yyj1890] = IngressTLS{}
				} else {
					yyv1893 := &yyv1890[yyj1890]
					yyv1893.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1890 < len(yyv1890) {
			yyv1890 = yyv1890[:yyj1890]
			yyc1890 = true
		} else if yyj1890 == 0 && yyv1890 == nil {
			yyv1890 = []IngressTLS{}
			yyc1890 = true
		}
	}
	yyh1890.End()
	if yyc1890 {
		*v = yyv1890
	}
}

func (x codecSelfer1234) encSliceIngressRule(v []IngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1894 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1895 := &yyv1894
		yy1895.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIngressRule(v *[]IngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1896 := *v
	yyh1896, yyl1896 := z.DecSliceHelperStart()
	var yyc1896 bool
	if yyl1896 == 0 {
		if yyv1896 == nil {
			yyv1896 = []IngressRule{}
			yyc1896 = true
		} else if len(yyv1896) != 0 {
			yyv1896 = yyv1896[:0]
			yyc1896 = true
		}
	} else if yyl1896 > 0 {
		var yyrr1896, yyrl1896 int
		var yyrt1896 bool
		if yyl1896 > cap(yyv1896) {

			yyrg1896 := len(yyv1896) > 0
			yyv21896 := yyv1896
			yyrl1896, yyrt1896 = z.DecInferLen(yyl1896, z.DecBasicHandle().MaxInitLen, 24)
			if yyrt1896 {
				if yyrl1896 <= cap(yyv1896) {
					yyv1896 = yyv1896[:yyrl1896]
				} else {
					yyv1896 = make([]IngressRule, yyrl1896)
				}
			} else {
				yyv1896 = make([]IngressRule, yyrl1896)
			}
			yyc1896 = true
			yyrr1896 = len(yyv1896)
			if yyrg1896 {
				copy(yyv1896, yyv21896)
			}
		} else if yyl1896 != len(yyv1896) {
			yyv1896 = yyv1896[:yyl1896]
			yyc1896 = true
		}
		yyj1896 := 0
		for ; yyj1896 < yyrr1896; yyj1896++ {
			yyh1896.ElemContainerState(yyj1896)
			if r.TryDecodeAsNil() {
				yyv1896[yyj1896] = IngressRule{}
			} else {
				yyv1897 := &yyv1896[yyj1896]
				yyv1897.CodecDecodeSelf(d)
			}

		}
		if yyrt1896 {
			for ; yyj1896 < yyl1896; yyj1896++ {
				yyv1896 = append(yyv1896, IngressRule{})
				yyh1896.ElemContainerState(yyj1896)
				if r.TryDecodeAsNil() {
					yyv1896[yyj1896] = IngressRule{}
				} else {
					yyv1898 := &yyv1896[yyj1896]
					yyv1898.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1896 := 0
		for ; !r.CheckBreak(); yyj1896++ {

			if yyj1896 >= len(yyv1896) {
				yyv1896 = append(yyv1896, IngressRule{}) // var yyz1896 IngressRule
				yyc1896 = true
			}
			yyh1896.ElemContainerState(yyj1896)
			if yyj1896 < len(yyv1896) {
				if r.TryDecodeAsNil() {
					yyv1896[yyj1896] = IngressRule{}
				} else {
					yyv1899 := &yyv1896[yyj1896]
					yyv1899.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1896 < len(yyv1896) {
			yyv1896 = yyv1896[:yyj1896]
			yyc1896 = true
		} else if yyj1896 == 0 && yyv1896 == nil {
			yyv1896 = []IngressRule{}
			yyc1896 = true
		}
	}
	yyh1896.End()
	if yyc1896 {
		*v = yyv1896
	}
}

func (x codecSelfer1234) encSliceHTTPIngressPath(v []HTTPIngressPath, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1900 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1901 := &yyv1900
		yy1901.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHTTPIngressPath(v *[]HTTPIngressPath, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1902 := *v
	yyh1902, yyl1902 := z.DecSliceHelperStart()
	var yyc1902 bool
	if yyl1902 == 0 {
		if yyv1902 == nil {
			yyv1902 = []HTTPIngressPath{}
			yyc1902 = true
		} else if len(yyv1902) != 0 {
			yyv1902 = yyv1902[:0]
			yyc1902 = true
		}
	} else if yyl1902 > 0 {
		var yyrr1902, yyrl1902 int
		var yyrt1902 bool
		if yyl1902 > cap(yyv1902) {

			yyrg1902 := len(yyv1902) > 0
			yyv21902 := yyv1902
			yyrl1902, yyrt1902 = z.DecInferLen(yyl1902, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt1902 {
				if yyrl1902 <= cap(yyv1902) {
					yyv1902 = yyv1902[:yyrl1902]
				} else {
					yyv1902 = make([]HTTPIngressPath, yyrl1902)
				}
			} else {
				yyv1902 = make([]HTTPIngressPath, yyrl1902)
			}
			yyc1902 = true
			yyrr1902 = len(yyv1902)
			if yyrg1902 {
				copy(yyv1902, yyv21902)
			}
		} else if yyl1902 != len(yyv1902) {
			yyv1902 = yyv1902[:yyl1902]
			yyc1902 = true
		}
		yyj1902 := 0
		for ; yyj1902 < yyrr1902; yyj1902++ {
			yyh1902.ElemContainerState(yyj1902)
			if r.TryDecodeAsNil() {
				yyv1902[yyj1902] = HTTPIngressPath{}
			} else {
				yyv1903 := &yyv1902[yyj1902]
				yyv1903.CodecDecodeSelf(d)
			}

		}
		if yyrt1902 {
			for ; yyj1902 < yyl1902; yyj1902++ {
				yyv1902 = append(yyv1902, HTTPIngressPath{})
				yyh1902.ElemContainerState(yyj1902)
				if r.TryDecodeAsNil() {
					yyv1902[yyj1902] = HTTPIngressPath{}
				} else {
					yyv1904 := &yyv1902[yyj1902]
					yyv1904.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1902 := 0
		for ; !r.CheckBreak(); yyj1902++ {

			if yyj1902 >= len(yyv1902) {
				yyv1902 = append(yyv1902, HTTPIngressPath{}) // var yyz1902 HTTPIngressPath
				yyc1902 = true
			}
			yyh1902.ElemContainerState(yyj1902)
			if yyj1902 < len(yyv1902) {
				if r.TryDecodeAsNil() {
					yyv1902[yyj1902] = HTTPIngressPath{}
				} else {
					yyv1905 := &yyv1902[yyj1902]
					yyv1905.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1902 < len(yyv1902) {
			yyv1902 = yyv1902[:yyj1902]
			yyc1902 = true
		} else if yyj1902 == 0 && yyv1902 == nil {
			yyv1902 = []HTTPIngressPath{}
			yyc1902 = true
		}
	}
	yyh1902.End()
	if yyc1902 {
		*v = yyv1902
	}
}

func (x codecSelfer1234) encSliceReplicaSet(v []ReplicaSet, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1906 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1907 := &yyv1906
		yy1907.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceReplicaSet(v *[]ReplicaSet, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1908 := *v
	yyh1908, yyl1908 := z.DecSliceHelperStart()
	var yyc1908 bool
	if yyl1908 == 0 {
		if yyv1908 == nil {
			yyv1908 = []ReplicaSet{}
			yyc1908 = true
		} else if len(yyv1908) != 0 {
			yyv1908 = yyv1908[:0]
			yyc1908 = true
		}
	} else if yyl1908 > 0 {
		var yyrr1908, yyrl1908 int
		var yyrt1908 bool
		if yyl1908 > cap(yyv1908) {

			yyrg1908 := len(yyv1908) > 0
			yyv21908 := yyv1908
			yyrl1908, yyrt1908 = z.DecInferLen(yyl1908, z.DecBasicHandle().MaxInitLen, 800)
			if yyrt1908 {
				if yyrl1908 <= cap(yyv1908) {
					yyv1908 = yyv1908[:yyrl1908]
				} else {
					yyv1908 = make([]ReplicaSet, yyrl1908)
				}
			} else {
				yyv1908 = make([]ReplicaSet, yyrl1908)
			}
			yyc1908 = true
			yyrr1908 = len(yyv1908)
			if yyrg1908 {
				copy(yyv1908, yyv21908)
			}
		} else if yyl1908 != len(yyv1908) {
			yyv1908 = yyv1908[:yyl1908]
			yyc1908 = true
		}
		yyj1908 := 0
		for ; yyj1908 < yyrr1908; yyj1908++ {
			yyh1908.ElemContainerState(yyj1908)
			if r.TryDecodeAsNil() {
				yyv1908[yyj1908] = ReplicaSet{}
			} else {
				yyv1909 := &yyv1908[yyj1908]
				yyv1909.CodecDecodeSelf(d)
			}

		}
		if yyrt1908 {
			for ; yyj1908 < yyl1908; yyj1908++ {
				yyv1908 = append(yyv1908, ReplicaSet{})
				yyh1908.ElemContainerState(yyj1908)
				if r.TryDecodeAsNil() {
					yyv1908[yyj1908] = ReplicaSet{}
				} else {
					yyv1910 := &yyv1908[yyj1908]
					yyv1910.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1908 := 0
		for ; !r.CheckBreak(); yyj1908++ {

			if yyj1908 >= len(yyv1908) {
				yyv1908 = append(yyv1908, ReplicaSet{}) // var yyz1908 ReplicaSet
				yyc1908 = true
			}
			yyh1908.ElemContainerState(yyj1908)
			if yyj1908 < len(yyv1908) {
				if r.TryDecodeAsNil() {
					yyv1908[yyj1908] = ReplicaSet{}
				} else {
					yyv1911 := &yyv1908[yyj1908]
					yyv1911.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1908 < len(yyv1908) {
			yyv1908 = yyv1908[:yyj1908]
			yyc1908 = true
		} else if yyj1908 == 0 && yyv1908 == nil {
			yyv1908 = []ReplicaSet{}
			yyc1908 = true
		}
	}
	yyh1908.End()
	if yyc1908 {
		*v = yyv1908
	}
}

func (x codecSelfer1234) encSliceReplicaSetCondition(v []ReplicaSetCondition, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1912 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1913 := &yyv1912
		yy1913.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceReplicaSetCondition(v *[]ReplicaSetCondition, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1914 := *v
	yyh1914, yyl1914 := z.DecSliceHelperStart()
	var yyc1914 bool
	if yyl1914 == 0 {
		if yyv1914 == nil {
			yyv1914 = []ReplicaSetCondition{}
			yyc1914 = true
		} else if len(yyv1914) != 0 {
			yyv1914 = yyv1914[:0]
			yyc1914 = true
		}
	} else if yyl1914 > 0 {
		var yyrr1914, yyrl1914 int
		var yyrt1914 bool
		if yyl1914 > cap(yyv1914) {

			yyrg1914 := len(yyv1914) > 0
			yyv21914 := yyv1914
			yyrl1914, yyrt1914 = z.DecInferLen(yyl1914, z.DecBasicHandle().MaxInitLen, 88)
			if yyrt1914 {
				if yyrl1914 <= cap(yyv1914) {
					yyv1914 = yyv1914[:yyrl1914]
				} else {
					yyv1914 = make([]ReplicaSetCondition, yyrl1914)
				}
			} else {
				yyv1914 = make([]ReplicaSetCondition, yyrl1914)
			}
			yyc1914 = true
			yyrr1914 = len(yyv1914)
			if yyrg1914 {
				copy(yyv1914, yyv21914)
			}
		} else if yyl1914 != len(yyv1914) {
			yyv1914 = yyv1914[:yyl1914]
			yyc1914 = true
		}
		yyj1914 := 0
		for ; yyj1914 < yyrr1914; yyj1914++ {
			yyh1914.ElemContainerState(yyj1914)
			if r.TryDecodeAsNil() {
				yyv1914[yyj1914] = ReplicaSetCondition{}
			} else {
				yyv1915 := &yyv1914[yyj1914]
				yyv1915.CodecDecodeSelf(d)
			}

		}
		if yyrt1914 {
			for ; yyj1914 < yyl1914; yyj1914++ {
				yyv1914 = append(yyv1914, ReplicaSetCondition{})
				yyh1914.ElemContainerState(yyj1914)
				if r.TryDecodeAsNil() {
					yyv1914[yyj1914] = ReplicaSetCondition{}
				} else {
					yyv1916 := &yyv1914[yyj1914]
					yyv1916.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1914 := 0
		for ; !r.CheckBreak(); yyj1914++ {

			if yyj1914 >= len(yyv1914) {
				yyv1914 = append(yyv1914, ReplicaSetCondition{}) // var yyz1914 ReplicaSetCondition
				yyc1914 = true
			}
			yyh1914.ElemContainerState(yyj1914)
			if yyj1914 < len(yyv1914) {
				if r.TryDecodeAsNil() {
					yyv1914[yyj1914] = ReplicaSetCondition{}
				} else {
					yyv1917 := &yyv1914[yyj1914]
					yyv1917.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1914 < len(yyv1914) {
			yyv1914 = yyv1914[:yyj1914]
			yyc1914 = true
		} else if yyj1914 == 0 && yyv1914 == nil {
			yyv1914 = []ReplicaSetCondition{}
			yyc1914 = true
		}
	}
	yyh1914.End()
	if yyc1914 {
		*v = yyv1914
	}
}

func (x codecSelfer1234) encSlicev1_Capability(v []pkg2_v1.Capability, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1918 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yym1919 := z.EncBinary()
		_ = yym1919
		if false {
		} else if z.HasExtensions() && z.EncExt(yyv1918) {
		} else {
			r.EncodeString(codecSelferC_UTF81234, string(yyv1918))
		}
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicev1_Capability(v *[]pkg2_v1.Capability, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1920 := *v
	yyh1920, yyl1920 := z.DecSliceHelperStart()
	var yyc1920 bool
	if yyl1920 == 0 {
		if yyv1920 == nil {
			yyv1920 = []pkg2_v1.Capability{}
			yyc1920 = true
		} else if len(yyv1920) != 0 {
			yyv1920 = yyv1920[:0]
			yyc1920 = true
		}
	} else if yyl1920 > 0 {
		var yyrr1920, yyrl1920 int
		var yyrt1920 bool
		if yyl1920 > cap(yyv1920) {

			yyrl1920, yyrt1920 = z.DecInferLen(yyl1920, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1920 {
				if yyrl1920 <= cap(yyv1920) {
					yyv1920 = yyv1920[:yyrl1920]
				} else {
					yyv1920 = make([]pkg2_v1.Capability, yyrl1920)
				}
			} else {
				yyv1920 = make([]pkg2_v1.Capability, yyrl1920)
			}
			yyc1920 = true
			yyrr1920 = len(yyv1920)
		} else if yyl1920 != len(yyv1920) {
			yyv1920 = yyv1920[:yyl1920]
			yyc1920 = true
		}
		yyj1920 := 0
		for ; yyj1920 < yyrr1920; yyj1920++ {
			yyh1920.ElemContainerState(yyj1920)
			if r.TryDecodeAsNil() {
				yyv1920[yyj1920] = ""
			} else {
				yyv1920[yyj1920] = pkg2_v1.Capability(r.DecodeString())
			}

		}
		if yyrt1920 {
			for ; yyj1920 < yyl1920; yyj1920++ {
				yyv1920 = append(yyv1920, "")
				yyh1920.ElemContainerState(yyj1920)
				if r.TryDecodeAsNil() {
					yyv1920[yyj1920] = ""
				} else {
					yyv1920[yyj1920] = pkg2_v1.Capability(r.DecodeString())
				}

			}
		}

	} else {
		yyj1920 := 0
		for ; !r.CheckBreak(); yyj1920++ {

			if yyj1920 >= len(yyv1920) {
				yyv1920 = append(yyv1920, "") // var yyz1920 pkg2_v1.Capability
				yyc1920 = true
			}
			yyh1920.ElemContainerState(yyj1920)
			if yyj1920 < len(yyv1920) {
				if r.TryDecodeAsNil() {
					yyv1920[yyj1920] = ""
				} else {
					yyv1920[yyj1920] = pkg2_v1.Capability(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1920 < len(yyv1920) {
			yyv1920 = yyv1920[:yyj1920]
			yyc1920 = true
		} else if yyj1920 == 0 && yyv1920 == nil {
			yyv1920 = []pkg2_v1.Capability{}
			yyc1920 = true
		}
	}
	yyh1920.End()
	if yyc1920 {
		*v = yyv1920
	}
}

func (x codecSelfer1234) encSliceFSType(v []FSType, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1924 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yyv1924.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceFSType(v *[]FSType, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1925 := *v
	yyh1925, yyl1925 := z.DecSliceHelperStart()
	var yyc1925 bool
	if yyl1925 == 0 {
		if yyv1925 == nil {
			yyv1925 = []FSType{}
			yyc1925 = true
		} else if len(yyv1925) != 0 {
			yyv1925 = yyv1925[:0]
			yyc1925 = true
		}
	} else if yyl1925 > 0 {
		var yyrr1925, yyrl1925 int
		var yyrt1925 bool
		if yyl1925 > cap(yyv1925) {

			yyrl1925, yyrt1925 = z.DecInferLen(yyl1925, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1925 {
				if yyrl1925 <= cap(yyv1925) {
					yyv1925 = yyv1925[:yyrl1925]
				} else {
					yyv1925 = make([]FSType, yyrl1925)
				}
			} else {
				yyv1925 = make([]FSType, yyrl1925)
			}
			yyc1925 = true
			yyrr1925 = len(yyv1925)
		} else if yyl1925 != len(yyv1925) {
			yyv1925 = yyv1925[:yyl1925]
			yyc1925 = true
		}
		yyj1925 := 0
		for ; yyj1925 < yyrr1925; yyj1925++ {
			yyh1925.ElemContainerState(yyj1925)
			if r.TryDecodeAsNil() {
				yyv1925[yyj1925] = ""
			} else {
				yyv1925[yyj1925] = FSType(r.DecodeString())
			}

		}
		if yyrt1925 {
			for ; yyj1925 < yyl1925; yyj1925++ {
				yyv1925 = append(yyv1925, "")
				yyh1925.ElemContainerState(yyj1925)
				if r.TryDecodeAsNil() {
					yyv1925[yyj1925] = ""
				} else {
					yyv1925[yyj1925] = FSType(r.DecodeString())
				}

			}
		}

	} else {
		yyj1925 := 0
		for ; !r.CheckBreak(); yyj1925++ {

			if yyj1925 >= len(yyv1925) {
				yyv1925 = append(yyv1925, "") // var yyz1925 FSType
				yyc1925 = true
			}
			yyh1925.ElemContainerState(yyj1925)
			if yyj1925 < len(yyv1925) {
				if r.TryDecodeAsNil() {
					yyv1925[yyj1925] = ""
				} else {
					yyv1925[yyj1925] = FSType(r.DecodeString())
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1925 < len(yyv1925) {
			yyv1925 = yyv1925[:yyj1925]
			yyc1925 = true
		} else if yyj1925 == 0 && yyv1925 == nil {
			yyv1925 = []FSType{}
			yyc1925 = true
		}
	}
	yyh1925.End()
	if yyc1925 {
		*v = yyv1925
	}
}

func (x codecSelfer1234) encSliceHostPortRange(v []HostPortRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1929 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1930 := &yyv1929
		yy1930.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHostPortRange(v *[]HostPortRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1931 := *v
	yyh1931, yyl1931 := z.DecSliceHelperStart()
	var yyc1931 bool
	if yyl1931 == 0 {
		if yyv1931 == nil {
			yyv1931 = []HostPortRange{}
			yyc1931 = true
		} else if len(yyv1931) != 0 {
			yyv1931 = yyv1931[:0]
			yyc1931 = true
		}
	} else if yyl1931 > 0 {
		var yyrr1931, yyrl1931 int
		var yyrt1931 bool
		if yyl1931 > cap(yyv1931) {

			yyrg1931 := len(yyv1931) > 0
			yyv21931 := yyv1931
			yyrl1931, yyrt1931 = z.DecInferLen(yyl1931, z.DecBasicHandle().MaxInitLen, 8)
			if yyrt1931 {
				if yyrl1931 <= cap(yyv1931) {
					yyv1931 = yyv1931[:yyrl1931]
				} else {
					yyv1931 = make([]HostPortRange, yyrl1931)
				}
			} else {
				yyv1931 = make([]HostPortRange, yyrl1931)
			}
			yyc1931 = true
			yyrr1931 = len(yyv1931)
			if yyrg1931 {
				copy(yyv1931, yyv21931)
			}
		} else if yyl1931 != len(yyv1931) {
			yyv1931 = yyv1931[:yyl1931]
			yyc1931 = true
		}
		yyj1931 := 0
		for ; yyj1931 < yyrr1931; yyj1931++ {
			yyh1931.ElemContainerState(yyj1931)
			if r.TryDecodeAsNil() {
				yyv1931[yyj1931] = HostPortRange{}
			} else {
				yyv1932 := &yyv1931[yyj1931]
				yyv1932.CodecDecodeSelf(d)
			}

		}
		if yyrt1931 {
			for ; yyj1931 < yyl1931; yyj1931++ {
				yyv1931 = append(yyv1931, HostPortRange{})
				yyh1931.ElemContainerState(yyj1931)
				if r.TryDecodeAsNil() {
					yyv1931[yyj1931] = HostPortRange{}
				} else {
					yyv1933 := &yyv1931[yyj1931]
					yyv1933.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1931 := 0
		for ; !r.CheckBreak(); yyj1931++ {

			if yyj1931 >= len(yyv1931) {
				yyv1931 = append(yyv1931, HostPortRange{}) // var yyz1931 HostPortRange
				yyc1931 = true
			}
			yyh1931.ElemContainerState(yyj1931)
			if yyj1931 < len(yyv1931) {
				if r.TryDecodeAsNil() {
					yyv1931[yyj1931] = HostPortRange{}
				} else {
					yyv1934 := &yyv1931[yyj1931]
					yyv1934.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1931 < len(yyv1931) {
			yyv1931 = yyv1931[:yyj1931]
			yyc1931 = true
		} else if yyj1931 == 0 && yyv1931 == nil {
			yyv1931 = []HostPortRange{}
			yyc1931 = true
		}
	}
	yyh1931.End()
	if yyc1931 {
		*v = yyv1931
	}
}

func (x codecSelfer1234) encSliceIDRange(v []IDRange, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1935 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1936 := &yyv1935
		yy1936.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceIDRange(v *[]IDRange, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1937 := *v
	yyh1937, yyl1937 := z.DecSliceHelperStart()
	var yyc1937 bool
	if yyl1937 == 0 {
		if yyv1937 == nil {
			yyv1937 = []IDRange{}
			yyc1937 = true
		} else if len(yyv1937) != 0 {
			yyv1937 = yyv1937[:0]
			yyc1937 = true
		}
	} else if yyl1937 > 0 {
		var yyrr1937, yyrl1937 int
		var yyrt1937 bool
		if yyl1937 > cap(yyv1937) {

			yyrg1937 := len(yyv1937) > 0
			yyv21937 := yyv1937
			yyrl1937, yyrt1937 = z.DecInferLen(yyl1937, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1937 {
				if yyrl1937 <= cap(yyv1937) {
					yyv1937 = yyv1937[:yyrl1937]
				} else {
					yyv1937 = make([]IDRange, yyrl1937)
				}
			} else {
				yyv1937 = make([]IDRange, yyrl1937)
			}
			yyc1937 = true
			yyrr1937 = len(yyv1937)
			if yyrg1937 {
				copy(yyv1937, yyv21937)
			}
		} else if yyl1937 != len(yyv1937) {
			yyv1937 = yyv1937[:yyl1937]
			yyc1937 = true
		}
		yyj1937 := 0
		for ; yyj1937 < yyrr1937; yyj1937++ {
			yyh1937.ElemContainerState(yyj1937)
			if r.TryDecodeAsNil() {
				yyv1937[yyj1937] = IDRange{}
			} else {
				yyv1938 := &yyv1937[yyj1937]
				yyv1938.CodecDecodeSelf(d)
			}

		}
		if yyrt1937 {
			for ; yyj1937 < yyl1937; yyj1937++ {
				yyv1937 = append(yyv1937, IDRange{})
				yyh1937.ElemContainerState(yyj1937)
				if r.TryDecodeAsNil() {
					yyv1937[yyj1937] = IDRange{}
				} else {
					yyv1939 := &yyv1937[yyj1937]
					yyv1939.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1937 := 0
		for ; !r.CheckBreak(); yyj1937++ {

			if yyj1937 >= len(yyv1937) {
				yyv1937 = append(yyv1937, IDRange{}) // var yyz1937 IDRange
				yyc1937 = true
			}
			yyh1937.ElemContainerState(yyj1937)
			if yyj1937 < len(yyv1937) {
				if r.TryDecodeAsNil() {
					yyv1937[yyj1937] = IDRange{}
				} else {
					yyv1940 := &yyv1937[yyj1937]
					yyv1940.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1937 < len(yyv1937) {
			yyv1937 = yyv1937[:yyj1937]
			yyc1937 = true
		} else if yyj1937 == 0 && yyv1937 == nil {
			yyv1937 = []IDRange{}
			yyc1937 = true
		}
	}
	yyh1937.End()
	if yyc1937 {
		*v = yyv1937
	}
}

func (x codecSelfer1234) encSlicePodSecurityPolicy(v []PodSecurityPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1941 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1942 := &yyv1941
		yy1942.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePodSecurityPolicy(v *[]PodSecurityPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1943 := *v
	yyh1943, yyl1943 := z.DecSliceHelperStart()
	var yyc1943 bool
	if yyl1943 == 0 {
		if yyv1943 == nil {
			yyv1943 = []PodSecurityPolicy{}
			yyc1943 = true
		} else if len(yyv1943) != 0 {
			yyv1943 = yyv1943[:0]
			yyc1943 = true
		}
	} else if yyl1943 > 0 {
		var yyrr1943, yyrl1943 int
		var yyrt1943 bool
		if yyl1943 > cap(yyv1943) {

			yyrg1943 := len(yyv1943) > 0
			yyv21943 := yyv1943
			yyrl1943, yyrt1943 = z.DecInferLen(yyl1943, z.DecBasicHandle().MaxInitLen, 552)
			if yyrt1943 {
				if yyrl1943 <= cap(yyv1943) {
					yyv1943 = yyv1943[:yyrl1943]
				} else {
					yyv1943 = make([]PodSecurityPolicy, yyrl1943)
				}
			} else {
				yyv1943 = make([]PodSecurityPolicy, yyrl1943)
			}
			yyc1943 = true
			yyrr1943 = len(yyv1943)
			if yyrg1943 {
				copy(yyv1943, yyv21943)
			}
		} else if yyl1943 != len(yyv1943) {
			yyv1943 = yyv1943[:yyl1943]
			yyc1943 = true
		}
		yyj1943 := 0
		for ; yyj1943 < yyrr1943; yyj1943++ {
			yyh1943.ElemContainerState(yyj1943)
			if r.TryDecodeAsNil() {
				yyv1943[yyj1943] = PodSecurityPolicy{}
			} else {
				yyv1944 := &yyv1943[yyj1943]
				yyv1944.CodecDecodeSelf(d)
			}

		}
		if yyrt1943 {
			for ; yyj1943 < yyl1943; yyj1943++ {
				yyv1943 = append(yyv1943, PodSecurityPolicy{})
				yyh1943.ElemContainerState(yyj1943)
				if r.TryDecodeAsNil() {
					yyv1943[yyj1943] = PodSecurityPolicy{}
				} else {
					yyv1945 := &yyv1943[yyj1943]
					yyv1945.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1943 := 0
		for ; !r.CheckBreak(); yyj1943++ {

			if yyj1943 >= len(yyv1943) {
				yyv1943 = append(yyv1943, PodSecurityPolicy{}) // var yyz1943 PodSecurityPolicy
				yyc1943 = true
			}
			yyh1943.ElemContainerState(yyj1943)
			if yyj1943 < len(yyv1943) {
				if r.TryDecodeAsNil() {
					yyv1943[yyj1943] = PodSecurityPolicy{}
				} else {
					yyv1946 := &yyv1943[yyj1943]
					yyv1946.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1943 < len(yyv1943) {
			yyv1943 = yyv1943[:yyj1943]
			yyc1943 = true
		} else if yyj1943 == 0 && yyv1943 == nil {
			yyv1943 = []PodSecurityPolicy{}
			yyc1943 = true
		}
	}
	yyh1943.End()
	if yyc1943 {
		*v = yyv1943
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyIngressRule(v []NetworkPolicyIngressRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1947 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1948 := &yyv1947
		yy1948.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyIngressRule(v *[]NetworkPolicyIngressRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1949 := *v
	yyh1949, yyl1949 := z.DecSliceHelperStart()
	var yyc1949 bool
	if yyl1949 == 0 {
		if yyv1949 == nil {
			yyv1949 = []NetworkPolicyIngressRule{}
			yyc1949 = true
		} else if len(yyv1949) != 0 {
			yyv1949 = yyv1949[:0]
			yyc1949 = true
		}
	} else if yyl1949 > 0 {
		var yyrr1949, yyrl1949 int
		var yyrt1949 bool
		if yyl1949 > cap(yyv1949) {

			yyrg1949 := len(yyv1949) > 0
			yyv21949 := yyv1949
			yyrl1949, yyrt1949 = z.DecInferLen(yyl1949, z.DecBasicHandle().MaxInitLen, 48)
			if yyrt1949 {
				if yyrl1949 <= cap(yyv1949) {
					yyv1949 = yyv1949[:yyrl1949]
				} else {
					yyv1949 = make([]NetworkPolicyIngressRule, yyrl1949)
				}
			} else {
				yyv1949 = make([]NetworkPolicyIngressRule, yyrl1949)
			}
			yyc1949 = true
			yyrr1949 = len(yyv1949)
			if yyrg1949 {
				copy(yyv1949, yyv21949)
			}
		} else if yyl1949 != len(yyv1949) {
			yyv1949 = yyv1949[:yyl1949]
			yyc1949 = true
		}
		yyj1949 := 0
		for ; yyj1949 < yyrr1949; yyj1949++ {
			yyh1949.ElemContainerState(yyj1949)
			if r.TryDecodeAsNil() {
				yyv1949[yyj1949] = NetworkPolicyIngressRule{}
			} else {
				yyv1950 := &yyv1949[yyj1949]
				yyv1950.CodecDecodeSelf(d)
			}

		}
		if yyrt1949 {
			for ; yyj1949 < yyl1949; yyj1949++ {
				yyv1949 = append(yyv1949, NetworkPolicyIngressRule{})
				yyh1949.ElemContainerState(yyj1949)
				if r.TryDecodeAsNil() {
					yyv1949[yyj1949] = NetworkPolicyIngressRule{}
				} else {
					yyv1951 := &yyv1949[yyj1949]
					yyv1951.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1949 := 0
		for ; !r.CheckBreak(); yyj1949++ {

			if yyj1949 >= len(yyv1949) {
				yyv1949 = append(yyv1949, NetworkPolicyIngressRule{}) // var yyz1949 NetworkPolicyIngressRule
				yyc1949 = true
			}
			yyh1949.ElemContainerState(yyj1949)
			if yyj1949 < len(yyv1949) {
				if r.TryDecodeAsNil() {
					yyv1949[yyj1949] = NetworkPolicyIngressRule{}
				} else {
					yyv1952 := &yyv1949[yyj1949]
					yyv1952.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1949 < len(yyv1949) {
			yyv1949 = yyv1949[:yyj1949]
			yyc1949 = true
		} else if yyj1949 == 0 && yyv1949 == nil {
			yyv1949 = []NetworkPolicyIngressRule{}
			yyc1949 = true
		}
	}
	yyh1949.End()
	if yyc1949 {
		*v = yyv1949
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPort(v []NetworkPolicyPort, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1953 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1954 := &yyv1953
		yy1954.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPort(v *[]NetworkPolicyPort, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1955 := *v
	yyh1955, yyl1955 := z.DecSliceHelperStart()
	var yyc1955 bool
	if yyl1955 == 0 {
		if yyv1955 == nil {
			yyv1955 = []NetworkPolicyPort{}
			yyc1955 = true
		} else if len(yyv1955) != 0 {
			yyv1955 = yyv1955[:0]
			yyc1955 = true
		}
	} else if yyl1955 > 0 {
		var yyrr1955, yyrl1955 int
		var yyrt1955 bool
		if yyl1955 > cap(yyv1955) {

			yyrg1955 := len(yyv1955) > 0
			yyv21955 := yyv1955
			yyrl1955, yyrt1955 = z.DecInferLen(yyl1955, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1955 {
				if yyrl1955 <= cap(yyv1955) {
					yyv1955 = yyv1955[:yyrl1955]
				} else {
					yyv1955 = make([]NetworkPolicyPort, yyrl1955)
				}
			} else {
				yyv1955 = make([]NetworkPolicyPort, yyrl1955)
			}
			yyc1955 = true
			yyrr1955 = len(yyv1955)
			if yyrg1955 {
				copy(yyv1955, yyv21955)
			}
		} else if yyl1955 != len(yyv1955) {
			yyv1955 = yyv1955[:yyl1955]
			yyc1955 = true
		}
		yyj1955 := 0
		for ; yyj1955 < yyrr1955; yyj1955++ {
			yyh1955.ElemContainerState(yyj1955)
			if r.TryDecodeAsNil() {
				yyv1955[yyj1955] = NetworkPolicyPort{}
			} else {
				yyv1956 := &yyv1955[yyj1955]
				yyv1956.CodecDecodeSelf(d)
			}

		}
		if yyrt1955 {
			for ; yyj1955 < yyl1955; yyj1955++ {
				yyv1955 = append(yyv1955, NetworkPolicyPort{})
				yyh1955.ElemContainerState(yyj1955)
				if r.TryDecodeAsNil() {
					yyv1955[yyj1955] = NetworkPolicyPort{}
				} else {
					yyv1957 := &yyv1955[yyj1955]
					yyv1957.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1955 := 0
		for ; !r.CheckBreak(); yyj1955++ {

			if yyj1955 >= len(yyv1955) {
				yyv1955 = append(yyv1955, NetworkPolicyPort{}) // var yyz1955 NetworkPolicyPort
				yyc1955 = true
			}
			yyh1955.ElemContainerState(yyj1955)
			if yyj1955 < len(yyv1955) {
				if r.TryDecodeAsNil() {
					yyv1955[yyj1955] = NetworkPolicyPort{}
				} else {
					yyv1958 := &yyv1955[yyj1955]
					yyv1958.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1955 < len(yyv1955) {
			yyv1955 = yyv1955[:yyj1955]
			yyc1955 = true
		} else if yyj1955 == 0 && yyv1955 == nil {
			yyv1955 = []NetworkPolicyPort{}
			yyc1955 = true
		}
	}
	yyh1955.End()
	if yyc1955 {
		*v = yyv1955
	}
}

func (x codecSelfer1234) encSliceNetworkPolicyPeer(v []NetworkPolicyPeer, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1959 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1960 := &yyv1959
		yy1960.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicyPeer(v *[]NetworkPolicyPeer, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1961 := *v
	yyh1961, yyl1961 := z.DecSliceHelperStart()
	var yyc1961 bool
	if yyl1961 == 0 {
		if yyv1961 == nil {
			yyv1961 = []NetworkPolicyPeer{}
			yyc1961 = true
		} else if len(yyv1961) != 0 {
			yyv1961 = yyv1961[:0]
			yyc1961 = true
		}
	} else if yyl1961 > 0 {
		var yyrr1961, yyrl1961 int
		var yyrt1961 bool
		if yyl1961 > cap(yyv1961) {

			yyrg1961 := len(yyv1961) > 0
			yyv21961 := yyv1961
			yyrl1961, yyrt1961 = z.DecInferLen(yyl1961, z.DecBasicHandle().MaxInitLen, 16)
			if yyrt1961 {
				if yyrl1961 <= cap(yyv1961) {
					yyv1961 = yyv1961[:yyrl1961]
				} else {
					yyv1961 = make([]NetworkPolicyPeer, yyrl1961)
				}
			} else {
				yyv1961 = make([]NetworkPolicyPeer, yyrl1961)
			}
			yyc1961 = true
			yyrr1961 = len(yyv1961)
			if yyrg1961 {
				copy(yyv1961, yyv21961)
			}
		} else if yyl1961 != len(yyv1961) {
			yyv1961 = yyv1961[:yyl1961]
			yyc1961 = true
		}
		yyj1961 := 0
		for ; yyj1961 < yyrr1961; yyj1961++ {
			yyh1961.ElemContainerState(yyj1961)
			if r.TryDecodeAsNil() {
				yyv1961[yyj1961] = NetworkPolicyPeer{}
			} else {
				yyv1962 := &yyv1961[yyj1961]
				yyv1962.CodecDecodeSelf(d)
			}

		}
		if yyrt1961 {
			for ; yyj1961 < yyl1961; yyj1961++ {
				yyv1961 = append(yyv1961, NetworkPolicyPeer{})
				yyh1961.ElemContainerState(yyj1961)
				if r.TryDecodeAsNil() {
					yyv1961[yyj1961] = NetworkPolicyPeer{}
				} else {
					yyv1963 := &yyv1961[yyj1961]
					yyv1963.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1961 := 0
		for ; !r.CheckBreak(); yyj1961++ {

			if yyj1961 >= len(yyv1961) {
				yyv1961 = append(yyv1961, NetworkPolicyPeer{}) // var yyz1961 NetworkPolicyPeer
				yyc1961 = true
			}
			yyh1961.ElemContainerState(yyj1961)
			if yyj1961 < len(yyv1961) {
				if r.TryDecodeAsNil() {
					yyv1961[yyj1961] = NetworkPolicyPeer{}
				} else {
					yyv1964 := &yyv1961[yyj1961]
					yyv1964.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1961 < len(yyv1961) {
			yyv1961 = yyv1961[:yyj1961]
			yyc1961 = true
		} else if yyj1961 == 0 && yyv1961 == nil {
			yyv1961 = []NetworkPolicyPeer{}
			yyc1961 = true
		}
	}
	yyh1961.End()
	if yyc1961 {
		*v = yyv1961
	}
}

func (x codecSelfer1234) encSliceNetworkPolicy(v []NetworkPolicy, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv1965 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy1966 := &yyv1965
		yy1966.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceNetworkPolicy(v *[]NetworkPolicy, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv1967 := *v
	yyh1967, yyl1967 := z.DecSliceHelperStart()
	var yyc1967 bool
	if yyl1967 == 0 {
		if yyv1967 == nil {
			yyv1967 = []NetworkPolicy{}
			yyc1967 = true
		} else if len(yyv1967) != 0 {
			yyv1967 = yyv1967[:0]
			yyc1967 = true
		}
	} else if yyl1967 > 0 {
		var yyrr1967, yyrl1967 int
		var yyrt1967 bool
		if yyl1967 > cap(yyv1967) {

			yyrg1967 := len(yyv1967) > 0
			yyv21967 := yyv1967
			yyrl1967, yyrt1967 = z.DecInferLen(yyl1967, z.DecBasicHandle().MaxInitLen, 312)
			if yyrt1967 {
				if yyrl1967 <= cap(yyv1967) {
					yyv1967 = yyv1967[:yyrl1967]
				} else {
					yyv1967 = make([]NetworkPolicy, yyrl1967)
				}
			} else {
				yyv1967 = make([]NetworkPolicy, yyrl1967)
			}
			yyc1967 = true
			yyrr1967 = len(yyv1967)
			if yyrg1967 {
				copy(yyv1967, yyv21967)
			}
		} else if yyl1967 != len(yyv1967) {
			yyv1967 = yyv1967[:yyl1967]
			yyc1967 = true
		}
		yyj1967 := 0
		for ; yyj1967 < yyrr1967; yyj1967++ {
			yyh1967.ElemContainerState(yyj1967)
			if r.TryDecodeAsNil() {
				yyv1967[yyj1967] = NetworkPolicy{}
			} else {
				yyv1968 := &yyv1967[yyj1967]
				yyv1968.CodecDecodeSelf(d)
			}

		}
		if yyrt1967 {
			for ; yyj1967 < yyl1967; yyj1967++ {
				yyv1967 = append(yyv1967, NetworkPolicy{})
				yyh1967.ElemContainerState(yyj1967)
				if r.TryDecodeAsNil() {
					yyv1967[yyj1967] = NetworkPolicy{}
				} else {
					yyv1969 := &yyv1967[yyj1967]
					yyv1969.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj1967 := 0
		for ; !r.CheckBreak(); yyj1967++ {

			if yyj1967 >= len(yyv1967) {
				yyv1967 = append(yyv1967, NetworkPolicy{}) // var yyz1967 NetworkPolicy
				yyc1967 = true
			}
			yyh1967.ElemContainerState(yyj1967)
			if yyj1967 < len(yyv1967) {
				if r.TryDecodeAsNil() {
					yyv1967[yyj1967] = NetworkPolicy{}
				} else {
					yyv1970 := &yyv1967[yyj1967]
					yyv1970.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj1967 < len(yyv1967) {
			yyv1967 = yyv1967[:yyj1967]
			yyc1967 = true
		} else if yyj1967 == 0 && yyv1967 == nil {
			yyv1967 = []NetworkPolicy{}
			yyc1967 = true
		}
	}
	yyh1967.End()
	if yyc1967 {
		*v = yyv1967
	}
}
