/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1alpha1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg2_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg3_v1 "k8s.io/kubernetes/pkg/api/v1"
	pkg1_runtime "k8s.io/kubernetes/pkg/runtime"
	pkg4_types "k8s.io/kubernetes/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg2_unversioned.TypeMeta
		var v1 pkg3_v1.ObjectMeta
		var v2 pkg1_runtime.RawExtension
		var v3 pkg4_types.UID
		var v4 time.Time
		_, _, _, _, _ = v0, v1, v2, v3, v4
	}
}

func (x *PolicyRule) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [6]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = true
			yyq2[2] = len(x.APIGroups) != 0
			yyq2[3] = len(x.Resources) != 0
			yyq2[4] = len(x.ResourceNames) != 0
			yyq2[5] = len(x.NonResourceURLs) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(6)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Verbs == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						z.F.EncSliceStringV(x.Verbs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("verbs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Verbs == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						z.F.EncSliceStringV(x.Verbs, false, e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yy7 := &x.AttributeRestrictions
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else if z.HasExtensions() && z.EncExt(yy7) {
					} else if !yym8 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy7)
					} else {
						z.EncFallback(yy7)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("attributeRestrictions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy9 := &x.AttributeRestrictions
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else if z.HasExtensions() && z.EncExt(yy9) {
					} else if !yym10 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy9)
					} else {
						z.EncFallback(yy9)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.APIGroups == nil {
						r.EncodeNil()
					} else {
						yym12 := z.EncBinary()
						_ = yym12
						if false {
						} else {
							z.F.EncSliceStringV(x.APIGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.APIGroups == nil {
						r.EncodeNil()
					} else {
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							z.F.EncSliceStringV(x.APIGroups, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Resources == nil {
						r.EncodeNil()
					} else {
						yym15 := z.EncBinary()
						_ = yym15
						if false {
						} else {
							z.F.EncSliceStringV(x.Resources, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Resources == nil {
						r.EncodeNil()
					} else {
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							z.F.EncSliceStringV(x.Resources, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.ResourceNames == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncSliceStringV(x.ResourceNames, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceNames"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceNames == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncSliceStringV(x.ResourceNames, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.NonResourceURLs == nil {
						r.EncodeNil()
					} else {
						yym21 := z.EncBinary()
						_ = yym21
						if false {
						} else {
							z.F.EncSliceStringV(x.NonResourceURLs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nonResourceURLs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NonResourceURLs == nil {
						r.EncodeNil()
					} else {
						yym22 := z.EncBinary()
						_ = yym22
						if false {
						} else {
							z.F.EncSliceStringV(x.NonResourceURLs, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PolicyRule) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym23 := z.DecBinary()
	_ = yym23
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct24 := r.ContainerType()
		if yyct24 == codecSelferValueTypeMap1234 {
			yyl24 := r.ReadMapStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl24, d)
			}
		} else if yyct24 == codecSelferValueTypeArray1234 {
			yyl24 := r.ReadArrayStart()
			if yyl24 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl24, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PolicyRule) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys25Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys25Slc
	var yyhl25 bool = l >= 0
	for yyj25 := 0; ; yyj25++ {
		if yyhl25 {
			if yyj25 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys25Slc = r.DecodeBytes(yys25Slc, true, true)
		yys25 := string(yys25Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys25 {
		case "verbs":
			if r.TryDecodeAsNil() {
				x.Verbs = nil
			} else {
				yyv26 := &x.Verbs
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					z.F.DecSliceStringX(yyv26, false, d)
				}
			}
		case "attributeRestrictions":
			if r.TryDecodeAsNil() {
				x.AttributeRestrictions = pkg1_runtime.RawExtension{}
			} else {
				yyv28 := &x.AttributeRestrictions
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv28) {
				} else if !yym29 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv28)
				} else {
					z.DecFallback(yyv28, false)
				}
			}
		case "apiGroups":
			if r.TryDecodeAsNil() {
				x.APIGroups = nil
			} else {
				yyv30 := &x.APIGroups
				yym31 := z.DecBinary()
				_ = yym31
				if false {
				} else {
					z.F.DecSliceStringX(yyv30, false, d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = nil
			} else {
				yyv32 := &x.Resources
				yym33 := z.DecBinary()
				_ = yym33
				if false {
				} else {
					z.F.DecSliceStringX(yyv32, false, d)
				}
			}
		case "resourceNames":
			if r.TryDecodeAsNil() {
				x.ResourceNames = nil
			} else {
				yyv34 := &x.ResourceNames
				yym35 := z.DecBinary()
				_ = yym35
				if false {
				} else {
					z.F.DecSliceStringX(yyv34, false, d)
				}
			}
		case "nonResourceURLs":
			if r.TryDecodeAsNil() {
				x.NonResourceURLs = nil
			} else {
				yyv36 := &x.NonResourceURLs
				yym37 := z.DecBinary()
				_ = yym37
				if false {
				} else {
					z.F.DecSliceStringX(yyv36, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys25)
		} // end switch yys25
	} // end for yyj25
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PolicyRule) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj38 int
	var yyb38 bool
	var yyhl38 bool = l >= 0
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Verbs = nil
	} else {
		yyv39 := &x.Verbs
		yym40 := z.DecBinary()
		_ = yym40
		if false {
		} else {
			z.F.DecSliceStringX(yyv39, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AttributeRestrictions = pkg1_runtime.RawExtension{}
	} else {
		yyv41 := &x.AttributeRestrictions
		yym42 := z.DecBinary()
		_ = yym42
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv41) {
		} else if !yym42 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv41)
		} else {
			z.DecFallback(yyv41, false)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIGroups = nil
	} else {
		yyv43 := &x.APIGroups
		yym44 := z.DecBinary()
		_ = yym44
		if false {
		} else {
			z.F.DecSliceStringX(yyv43, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = nil
	} else {
		yyv45 := &x.Resources
		yym46 := z.DecBinary()
		_ = yym46
		if false {
		} else {
			z.F.DecSliceStringX(yyv45, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceNames = nil
	} else {
		yyv47 := &x.ResourceNames
		yym48 := z.DecBinary()
		_ = yym48
		if false {
		} else {
			z.F.DecSliceStringX(yyv47, false, d)
		}
	}
	yyj38++
	if yyhl38 {
		yyb38 = yyj38 > l
	} else {
		yyb38 = r.CheckBreak()
	}
	if yyb38 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NonResourceURLs = nil
	} else {
		yyv49 := &x.NonResourceURLs
		yym50 := z.DecBinary()
		_ = yym50
		if false {
		} else {
			z.F.DecSliceStringX(yyv49, false, d)
		}
	}
	for {
		yyj38++
		if yyhl38 {
			yyb38 = yyj38 > l
		} else {
			yyb38 = r.CheckBreak()
		}
		if yyb38 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj38-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Subject) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym51 := z.EncBinary()
		_ = yym51
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep52 := !z.EncBinary()
			yy2arr52 := z.EncBasicHandle().StructToArray
			var yyq52 [4]bool
			_, _, _ = yysep52, yyq52, yy2arr52
			const yyr52 bool = false
			yyq52[1] = x.APIVersion != ""
			yyq52[3] = x.Namespace != ""
			var yynn52 int
			if yyr52 || yy2arr52 {
				r.EncodeArrayStart(4)
			} else {
				yynn52 = 2
				for _, b := range yyq52 {
					if b {
						yynn52++
					}
				}
				r.EncodeMapStart(yynn52)
				yynn52 = 0
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym54 := z.EncBinary()
				_ = yym54
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kind"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym55 := z.EncBinary()
				_ = yym55
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq52[1] {
					yym57 := z.EncBinary()
					_ = yym57
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq52[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym58 := z.EncBinary()
					_ = yym58
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym60 := z.EncBinary()
				_ = yym60
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym61 := z.EncBinary()
				_ = yym61
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq52[3] {
					yym63 := z.EncBinary()
					_ = yym63
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq52[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr52 || yy2arr52 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Subject) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym65 := z.DecBinary()
	_ = yym65
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct66 := r.ContainerType()
		if yyct66 == codecSelferValueTypeMap1234 {
			yyl66 := r.ReadMapStart()
			if yyl66 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl66, d)
			}
		} else if yyct66 == codecSelferValueTypeArray1234 {
			yyl66 := r.ReadArrayStart()
			if yyl66 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl66, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Subject) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys67Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys67Slc
	var yyhl67 bool = l >= 0
	for yyj67 := 0; ; yyj67++ {
		if yyhl67 {
			if yyj67 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys67Slc = r.DecodeBytes(yys67Slc, true, true)
		yys67 := string(yys67Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys67 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				x.Namespace = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys67)
		} // end switch yys67
	} // end for yyj67
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Subject) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj72 int
	var yyb72 bool
	var yyhl72 bool = l >= 0
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj72++
	if yyhl72 {
		yyb72 = yyj72 > l
	} else {
		yyb72 = r.CheckBreak()
	}
	if yyb72 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		x.Namespace = string(r.DecodeString())
	}
	for {
		yyj72++
		if yyhl72 {
			yyb72 = yyj72 > l
		} else {
			yyb72 = r.CheckBreak()
		}
		if yyb72 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj72-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleRef) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym77 := z.EncBinary()
		_ = yym77
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep78 := !z.EncBinary()
			yy2arr78 := z.EncBasicHandle().StructToArray
			var yyq78 [3]bool
			_, _, _ = yysep78, yyq78, yy2arr78
			const yyr78 bool = false
			var yynn78 int
			if yyr78 || yy2arr78 {
				r.EncodeArrayStart(3)
			} else {
				yynn78 = 3
				for _, b := range yyq78 {
					if b {
						yynn78++
					}
				}
				r.EncodeMapStart(yynn78)
				yynn78 = 0
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym80 := z.EncBinary()
				_ = yym80
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIGroup))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("apiGroup"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym81 := z.EncBinary()
				_ = yym81
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.APIGroup))
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym83 := z.EncBinary()
				_ = yym83
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kind"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym84 := z.EncBinary()
				_ = yym84
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym86 := z.EncBinary()
				_ = yym86
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym87 := z.EncBinary()
				_ = yym87
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr78 || yy2arr78 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleRef) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym88 := z.DecBinary()
	_ = yym88
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct89 := r.ContainerType()
		if yyct89 == codecSelferValueTypeMap1234 {
			yyl89 := r.ReadMapStart()
			if yyl89 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl89, d)
			}
		} else if yyct89 == codecSelferValueTypeArray1234 {
			yyl89 := r.ReadArrayStart()
			if yyl89 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl89, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleRef) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys90Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys90Slc
	var yyhl90 bool = l >= 0
	for yyj90 := 0; ; yyj90++ {
		if yyhl90 {
			if yyj90 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys90Slc = r.DecodeBytes(yys90Slc, true, true)
		yys90 := string(yys90Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys90 {
		case "apiGroup":
			if r.TryDecodeAsNil() {
				x.APIGroup = ""
			} else {
				x.APIGroup = string(r.DecodeString())
			}
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys90)
		} // end switch yys90
	} // end for yyj90
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleRef) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj94 int
	var yyb94 bool
	var yyhl94 bool = l >= 0
	yyj94++
	if yyhl94 {
		yyb94 = yyj94 > l
	} else {
		yyb94 = r.CheckBreak()
	}
	if yyb94 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIGroup = ""
	} else {
		x.APIGroup = string(r.DecodeString())
	}
	yyj94++
	if yyhl94 {
		yyb94 = yyj94 > l
	} else {
		yyb94 = r.CheckBreak()
	}
	if yyb94 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj94++
	if yyhl94 {
		yyb94 = yyj94 > l
	} else {
		yyb94 = r.CheckBreak()
	}
	if yyb94 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	for {
		yyj94++
		if yyhl94 {
			yyb94 = yyj94 > l
		} else {
			yyb94 = r.CheckBreak()
		}
		if yyb94 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj94-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Role) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym98 := z.EncBinary()
		_ = yym98
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep99 := !z.EncBinary()
			yy2arr99 := z.EncBasicHandle().StructToArray
			var yyq99 [4]bool
			_, _, _ = yysep99, yyq99, yy2arr99
			const yyr99 bool = false
			yyq99[0] = x.Kind != ""
			yyq99[1] = x.APIVersion != ""
			yyq99[2] = true
			var yynn99 int
			if yyr99 || yy2arr99 {
				r.EncodeArrayStart(4)
			} else {
				yynn99 = 1
				for _, b := range yyq99 {
					if b {
						yynn99++
					}
				}
				r.EncodeMapStart(yynn99)
				yynn99 = 0
			}
			if yyr99 || yy2arr99 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq99[0] {
					yym101 := z.EncBinary()
					_ = yym101
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq99[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym102 := z.EncBinary()
					_ = yym102
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr99 || yy2arr99 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq99[1] {
					yym104 := z.EncBinary()
					_ = yym104
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq99[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym105 := z.EncBinary()
					_ = yym105
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr99 || yy2arr99 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq99[2] {
					yy107 := &x.ObjectMeta
					yy107.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq99[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy108 := &x.ObjectMeta
					yy108.CodecEncodeSelf(e)
				}
			}
			if yyr99 || yy2arr99 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym110 := z.EncBinary()
					_ = yym110
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rules"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym111 := z.EncBinary()
					_ = yym111
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			}
			if yyr99 || yy2arr99 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Role) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym112 := z.DecBinary()
	_ = yym112
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct113 := r.ContainerType()
		if yyct113 == codecSelferValueTypeMap1234 {
			yyl113 := r.ReadMapStart()
			if yyl113 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl113, d)
			}
		} else if yyct113 == codecSelferValueTypeArray1234 {
			yyl113 := r.ReadArrayStart()
			if yyl113 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl113, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Role) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys114Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys114Slc
	var yyhl114 bool = l >= 0
	for yyj114 := 0; ; yyj114++ {
		if yyhl114 {
			if yyj114 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys114Slc = r.DecodeBytes(yys114Slc, true, true)
		yys114 := string(yys114Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys114 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv117 := &x.ObjectMeta
				yyv117.CodecDecodeSelf(d)
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv118 := &x.Rules
				yym119 := z.DecBinary()
				_ = yym119
				if false {
				} else {
					h.decSlicePolicyRule((*[]PolicyRule)(yyv118), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys114)
		} // end switch yys114
	} // end for yyj114
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Role) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj120 int
	var yyb120 bool
	var yyhl120 bool = l >= 0
	yyj120++
	if yyhl120 {
		yyb120 = yyj120 > l
	} else {
		yyb120 = r.CheckBreak()
	}
	if yyb120 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj120++
	if yyhl120 {
		yyb120 = yyj120 > l
	} else {
		yyb120 = r.CheckBreak()
	}
	if yyb120 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj120++
	if yyhl120 {
		yyb120 = yyj120 > l
	} else {
		yyb120 = r.CheckBreak()
	}
	if yyb120 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv123 := &x.ObjectMeta
		yyv123.CodecDecodeSelf(d)
	}
	yyj120++
	if yyhl120 {
		yyb120 = yyj120 > l
	} else {
		yyb120 = r.CheckBreak()
	}
	if yyb120 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv124 := &x.Rules
		yym125 := z.DecBinary()
		_ = yym125
		if false {
		} else {
			h.decSlicePolicyRule((*[]PolicyRule)(yyv124), d)
		}
	}
	for {
		yyj120++
		if yyhl120 {
			yyb120 = yyj120 > l
		} else {
			yyb120 = r.CheckBreak()
		}
		if yyb120 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj120-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleBinding) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym126 := z.EncBinary()
		_ = yym126
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep127 := !z.EncBinary()
			yy2arr127 := z.EncBasicHandle().StructToArray
			var yyq127 [5]bool
			_, _, _ = yysep127, yyq127, yy2arr127
			const yyr127 bool = false
			yyq127[0] = x.Kind != ""
			yyq127[1] = x.APIVersion != ""
			yyq127[2] = true
			var yynn127 int
			if yyr127 || yy2arr127 {
				r.EncodeArrayStart(5)
			} else {
				yynn127 = 2
				for _, b := range yyq127 {
					if b {
						yynn127++
					}
				}
				r.EncodeMapStart(yynn127)
				yynn127 = 0
			}
			if yyr127 || yy2arr127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq127[0] {
					yym129 := z.EncBinary()
					_ = yym129
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq127[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym130 := z.EncBinary()
					_ = yym130
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr127 || yy2arr127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq127[1] {
					yym132 := z.EncBinary()
					_ = yym132
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq127[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym133 := z.EncBinary()
					_ = yym133
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr127 || yy2arr127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq127[2] {
					yy135 := &x.ObjectMeta
					yy135.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq127[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy136 := &x.ObjectMeta
					yy136.CodecEncodeSelf(e)
				}
			}
			if yyr127 || yy2arr127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym138 := z.EncBinary()
					_ = yym138
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subjects"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym139 := z.EncBinary()
					_ = yym139
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			}
			if yyr127 || yy2arr127 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy141 := &x.RoleRef
				yy141.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("roleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy142 := &x.RoleRef
				yy142.CodecEncodeSelf(e)
			}
			if yyr127 || yy2arr127 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleBinding) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym143 := z.DecBinary()
	_ = yym143
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct144 := r.ContainerType()
		if yyct144 == codecSelferValueTypeMap1234 {
			yyl144 := r.ReadMapStart()
			if yyl144 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl144, d)
			}
		} else if yyct144 == codecSelferValueTypeArray1234 {
			yyl144 := r.ReadArrayStart()
			if yyl144 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl144, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleBinding) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys145Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys145Slc
	var yyhl145 bool = l >= 0
	for yyj145 := 0; ; yyj145++ {
		if yyhl145 {
			if yyj145 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys145Slc = r.DecodeBytes(yys145Slc, true, true)
		yys145 := string(yys145Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys145 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv148 := &x.ObjectMeta
				yyv148.CodecDecodeSelf(d)
			}
		case "subjects":
			if r.TryDecodeAsNil() {
				x.Subjects = nil
			} else {
				yyv149 := &x.Subjects
				yym150 := z.DecBinary()
				_ = yym150
				if false {
				} else {
					h.decSliceSubject((*[]Subject)(yyv149), d)
				}
			}
		case "roleRef":
			if r.TryDecodeAsNil() {
				x.RoleRef = RoleRef{}
			} else {
				yyv151 := &x.RoleRef
				yyv151.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys145)
		} // end switch yys145
	} // end for yyj145
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleBinding) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj152 int
	var yyb152 bool
	var yyhl152 bool = l >= 0
	yyj152++
	if yyhl152 {
		yyb152 = yyj152 > l
	} else {
		yyb152 = r.CheckBreak()
	}
	if yyb152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj152++
	if yyhl152 {
		yyb152 = yyj152 > l
	} else {
		yyb152 = r.CheckBreak()
	}
	if yyb152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj152++
	if yyhl152 {
		yyb152 = yyj152 > l
	} else {
		yyb152 = r.CheckBreak()
	}
	if yyb152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv155 := &x.ObjectMeta
		yyv155.CodecDecodeSelf(d)
	}
	yyj152++
	if yyhl152 {
		yyb152 = yyj152 > l
	} else {
		yyb152 = r.CheckBreak()
	}
	if yyb152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subjects = nil
	} else {
		yyv156 := &x.Subjects
		yym157 := z.DecBinary()
		_ = yym157
		if false {
		} else {
			h.decSliceSubject((*[]Subject)(yyv156), d)
		}
	}
	yyj152++
	if yyhl152 {
		yyb152 = yyj152 > l
	} else {
		yyb152 = r.CheckBreak()
	}
	if yyb152 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RoleRef = RoleRef{}
	} else {
		yyv158 := &x.RoleRef
		yyv158.CodecDecodeSelf(d)
	}
	for {
		yyj152++
		if yyhl152 {
			yyb152 = yyj152 > l
		} else {
			yyb152 = r.CheckBreak()
		}
		if yyb152 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj152-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleBindingList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym159 := z.EncBinary()
		_ = yym159
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep160 := !z.EncBinary()
			yy2arr160 := z.EncBasicHandle().StructToArray
			var yyq160 [4]bool
			_, _, _ = yysep160, yyq160, yy2arr160
			const yyr160 bool = false
			yyq160[0] = x.Kind != ""
			yyq160[1] = x.APIVersion != ""
			yyq160[2] = true
			var yynn160 int
			if yyr160 || yy2arr160 {
				r.EncodeArrayStart(4)
			} else {
				yynn160 = 1
				for _, b := range yyq160 {
					if b {
						yynn160++
					}
				}
				r.EncodeMapStart(yynn160)
				yynn160 = 0
			}
			if yyr160 || yy2arr160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq160[0] {
					yym162 := z.EncBinary()
					_ = yym162
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq160[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym163 := z.EncBinary()
					_ = yym163
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr160 || yy2arr160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq160[1] {
					yym165 := z.EncBinary()
					_ = yym165
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq160[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym166 := z.EncBinary()
					_ = yym166
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr160 || yy2arr160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq160[2] {
					yy168 := &x.ListMeta
					yym169 := z.EncBinary()
					_ = yym169
					if false {
					} else if z.HasExtensions() && z.EncExt(yy168) {
					} else {
						z.EncFallback(yy168)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq160[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy170 := &x.ListMeta
					yym171 := z.EncBinary()
					_ = yym171
					if false {
					} else if z.HasExtensions() && z.EncExt(yy170) {
					} else {
						z.EncFallback(yy170)
					}
				}
			}
			if yyr160 || yy2arr160 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym173 := z.EncBinary()
					_ = yym173
					if false {
					} else {
						h.encSliceRoleBinding(([]RoleBinding)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym174 := z.EncBinary()
					_ = yym174
					if false {
					} else {
						h.encSliceRoleBinding(([]RoleBinding)(x.Items), e)
					}
				}
			}
			if yyr160 || yy2arr160 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleBindingList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym175 := z.DecBinary()
	_ = yym175
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct176 := r.ContainerType()
		if yyct176 == codecSelferValueTypeMap1234 {
			yyl176 := r.ReadMapStart()
			if yyl176 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl176, d)
			}
		} else if yyct176 == codecSelferValueTypeArray1234 {
			yyl176 := r.ReadArrayStart()
			if yyl176 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl176, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleBindingList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys177Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys177Slc
	var yyhl177 bool = l >= 0
	for yyj177 := 0; ; yyj177++ {
		if yyhl177 {
			if yyj177 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys177Slc = r.DecodeBytes(yys177Slc, true, true)
		yys177 := string(yys177Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys177 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv180 := &x.ListMeta
				yym181 := z.DecBinary()
				_ = yym181
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv180) {
				} else {
					z.DecFallback(yyv180, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv182 := &x.Items
				yym183 := z.DecBinary()
				_ = yym183
				if false {
				} else {
					h.decSliceRoleBinding((*[]RoleBinding)(yyv182), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys177)
		} // end switch yys177
	} // end for yyj177
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleBindingList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj184 int
	var yyb184 bool
	var yyhl184 bool = l >= 0
	yyj184++
	if yyhl184 {
		yyb184 = yyj184 > l
	} else {
		yyb184 = r.CheckBreak()
	}
	if yyb184 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj184++
	if yyhl184 {
		yyb184 = yyj184 > l
	} else {
		yyb184 = r.CheckBreak()
	}
	if yyb184 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj184++
	if yyhl184 {
		yyb184 = yyj184 > l
	} else {
		yyb184 = r.CheckBreak()
	}
	if yyb184 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv187 := &x.ListMeta
		yym188 := z.DecBinary()
		_ = yym188
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv187) {
		} else {
			z.DecFallback(yyv187, false)
		}
	}
	yyj184++
	if yyhl184 {
		yyb184 = yyj184 > l
	} else {
		yyb184 = r.CheckBreak()
	}
	if yyb184 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv189 := &x.Items
		yym190 := z.DecBinary()
		_ = yym190
		if false {
		} else {
			h.decSliceRoleBinding((*[]RoleBinding)(yyv189), d)
		}
	}
	for {
		yyj184++
		if yyhl184 {
			yyb184 = yyj184 > l
		} else {
			yyb184 = r.CheckBreak()
		}
		if yyb184 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj184-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RoleList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym191 := z.EncBinary()
		_ = yym191
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep192 := !z.EncBinary()
			yy2arr192 := z.EncBasicHandle().StructToArray
			var yyq192 [4]bool
			_, _, _ = yysep192, yyq192, yy2arr192
			const yyr192 bool = false
			yyq192[0] = x.Kind != ""
			yyq192[1] = x.APIVersion != ""
			yyq192[2] = true
			var yynn192 int
			if yyr192 || yy2arr192 {
				r.EncodeArrayStart(4)
			} else {
				yynn192 = 1
				for _, b := range yyq192 {
					if b {
						yynn192++
					}
				}
				r.EncodeMapStart(yynn192)
				yynn192 = 0
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq192[0] {
					yym194 := z.EncBinary()
					_ = yym194
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq192[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym195 := z.EncBinary()
					_ = yym195
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq192[1] {
					yym197 := z.EncBinary()
					_ = yym197
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq192[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym198 := z.EncBinary()
					_ = yym198
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq192[2] {
					yy200 := &x.ListMeta
					yym201 := z.EncBinary()
					_ = yym201
					if false {
					} else if z.HasExtensions() && z.EncExt(yy200) {
					} else {
						z.EncFallback(yy200)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq192[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy202 := &x.ListMeta
					yym203 := z.EncBinary()
					_ = yym203
					if false {
					} else if z.HasExtensions() && z.EncExt(yy202) {
					} else {
						z.EncFallback(yy202)
					}
				}
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym205 := z.EncBinary()
					_ = yym205
					if false {
					} else {
						h.encSliceRole(([]Role)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym206 := z.EncBinary()
					_ = yym206
					if false {
					} else {
						h.encSliceRole(([]Role)(x.Items), e)
					}
				}
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RoleList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym207 := z.DecBinary()
	_ = yym207
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct208 := r.ContainerType()
		if yyct208 == codecSelferValueTypeMap1234 {
			yyl208 := r.ReadMapStart()
			if yyl208 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl208, d)
			}
		} else if yyct208 == codecSelferValueTypeArray1234 {
			yyl208 := r.ReadArrayStart()
			if yyl208 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl208, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RoleList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys209Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys209Slc
	var yyhl209 bool = l >= 0
	for yyj209 := 0; ; yyj209++ {
		if yyhl209 {
			if yyj209 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys209Slc = r.DecodeBytes(yys209Slc, true, true)
		yys209 := string(yys209Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys209 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv212 := &x.ListMeta
				yym213 := z.DecBinary()
				_ = yym213
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv212) {
				} else {
					z.DecFallback(yyv212, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv214 := &x.Items
				yym215 := z.DecBinary()
				_ = yym215
				if false {
				} else {
					h.decSliceRole((*[]Role)(yyv214), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys209)
		} // end switch yys209
	} // end for yyj209
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RoleList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj216 int
	var yyb216 bool
	var yyhl216 bool = l >= 0
	yyj216++
	if yyhl216 {
		yyb216 = yyj216 > l
	} else {
		yyb216 = r.CheckBreak()
	}
	if yyb216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj216++
	if yyhl216 {
		yyb216 = yyj216 > l
	} else {
		yyb216 = r.CheckBreak()
	}
	if yyb216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj216++
	if yyhl216 {
		yyb216 = yyj216 > l
	} else {
		yyb216 = r.CheckBreak()
	}
	if yyb216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv219 := &x.ListMeta
		yym220 := z.DecBinary()
		_ = yym220
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv219) {
		} else {
			z.DecFallback(yyv219, false)
		}
	}
	yyj216++
	if yyhl216 {
		yyb216 = yyj216 > l
	} else {
		yyb216 = r.CheckBreak()
	}
	if yyb216 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv221 := &x.Items
		yym222 := z.DecBinary()
		_ = yym222
		if false {
		} else {
			h.decSliceRole((*[]Role)(yyv221), d)
		}
	}
	for {
		yyj216++
		if yyhl216 {
			yyb216 = yyj216 > l
		} else {
			yyb216 = r.CheckBreak()
		}
		if yyb216 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj216-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRole) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym223 := z.EncBinary()
		_ = yym223
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep224 := !z.EncBinary()
			yy2arr224 := z.EncBasicHandle().StructToArray
			var yyq224 [4]bool
			_, _, _ = yysep224, yyq224, yy2arr224
			const yyr224 bool = false
			yyq224[0] = x.Kind != ""
			yyq224[1] = x.APIVersion != ""
			yyq224[2] = true
			var yynn224 int
			if yyr224 || yy2arr224 {
				r.EncodeArrayStart(4)
			} else {
				yynn224 = 1
				for _, b := range yyq224 {
					if b {
						yynn224++
					}
				}
				r.EncodeMapStart(yynn224)
				yynn224 = 0
			}
			if yyr224 || yy2arr224 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq224[0] {
					yym226 := z.EncBinary()
					_ = yym226
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq224[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym227 := z.EncBinary()
					_ = yym227
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr224 || yy2arr224 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq224[1] {
					yym229 := z.EncBinary()
					_ = yym229
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq224[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym230 := z.EncBinary()
					_ = yym230
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr224 || yy2arr224 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq224[2] {
					yy232 := &x.ObjectMeta
					yy232.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq224[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy233 := &x.ObjectMeta
					yy233.CodecEncodeSelf(e)
				}
			}
			if yyr224 || yy2arr224 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym235 := z.EncBinary()
					_ = yym235
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("rules"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Rules == nil {
					r.EncodeNil()
				} else {
					yym236 := z.EncBinary()
					_ = yym236
					if false {
					} else {
						h.encSlicePolicyRule(([]PolicyRule)(x.Rules), e)
					}
				}
			}
			if yyr224 || yy2arr224 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRole) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym237 := z.DecBinary()
	_ = yym237
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct238 := r.ContainerType()
		if yyct238 == codecSelferValueTypeMap1234 {
			yyl238 := r.ReadMapStart()
			if yyl238 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl238, d)
			}
		} else if yyct238 == codecSelferValueTypeArray1234 {
			yyl238 := r.ReadArrayStart()
			if yyl238 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl238, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRole) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys239Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys239Slc
	var yyhl239 bool = l >= 0
	for yyj239 := 0; ; yyj239++ {
		if yyhl239 {
			if yyj239 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys239Slc = r.DecodeBytes(yys239Slc, true, true)
		yys239 := string(yys239Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys239 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv242 := &x.ObjectMeta
				yyv242.CodecDecodeSelf(d)
			}
		case "rules":
			if r.TryDecodeAsNil() {
				x.Rules = nil
			} else {
				yyv243 := &x.Rules
				yym244 := z.DecBinary()
				_ = yym244
				if false {
				} else {
					h.decSlicePolicyRule((*[]PolicyRule)(yyv243), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys239)
		} // end switch yys239
	} // end for yyj239
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRole) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj245 int
	var yyb245 bool
	var yyhl245 bool = l >= 0
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv248 := &x.ObjectMeta
		yyv248.CodecDecodeSelf(d)
	}
	yyj245++
	if yyhl245 {
		yyb245 = yyj245 > l
	} else {
		yyb245 = r.CheckBreak()
	}
	if yyb245 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Rules = nil
	} else {
		yyv249 := &x.Rules
		yym250 := z.DecBinary()
		_ = yym250
		if false {
		} else {
			h.decSlicePolicyRule((*[]PolicyRule)(yyv249), d)
		}
	}
	for {
		yyj245++
		if yyhl245 {
			yyb245 = yyj245 > l
		} else {
			yyb245 = r.CheckBreak()
		}
		if yyb245 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj245-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRoleBinding) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym251 := z.EncBinary()
		_ = yym251
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep252 := !z.EncBinary()
			yy2arr252 := z.EncBasicHandle().StructToArray
			var yyq252 [5]bool
			_, _, _ = yysep252, yyq252, yy2arr252
			const yyr252 bool = false
			yyq252[0] = x.Kind != ""
			yyq252[1] = x.APIVersion != ""
			yyq252[2] = true
			var yynn252 int
			if yyr252 || yy2arr252 {
				r.EncodeArrayStart(5)
			} else {
				yynn252 = 2
				for _, b := range yyq252 {
					if b {
						yynn252++
					}
				}
				r.EncodeMapStart(yynn252)
				yynn252 = 0
			}
			if yyr252 || yy2arr252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq252[0] {
					yym254 := z.EncBinary()
					_ = yym254
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq252[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym255 := z.EncBinary()
					_ = yym255
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr252 || yy2arr252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq252[1] {
					yym257 := z.EncBinary()
					_ = yym257
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq252[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym258 := z.EncBinary()
					_ = yym258
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr252 || yy2arr252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq252[2] {
					yy260 := &x.ObjectMeta
					yy260.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq252[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy261 := &x.ObjectMeta
					yy261.CodecEncodeSelf(e)
				}
			}
			if yyr252 || yy2arr252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym263 := z.EncBinary()
					_ = yym263
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("subjects"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Subjects == nil {
					r.EncodeNil()
				} else {
					yym264 := z.EncBinary()
					_ = yym264
					if false {
					} else {
						h.encSliceSubject(([]Subject)(x.Subjects), e)
					}
				}
			}
			if yyr252 || yy2arr252 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy266 := &x.RoleRef
				yy266.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("roleRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy267 := &x.RoleRef
				yy267.CodecEncodeSelf(e)
			}
			if yyr252 || yy2arr252 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRoleBinding) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym268 := z.DecBinary()
	_ = yym268
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct269 := r.ContainerType()
		if yyct269 == codecSelferValueTypeMap1234 {
			yyl269 := r.ReadMapStart()
			if yyl269 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl269, d)
			}
		} else if yyct269 == codecSelferValueTypeArray1234 {
			yyl269 := r.ReadArrayStart()
			if yyl269 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl269, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRoleBinding) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys270Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys270Slc
	var yyhl270 bool = l >= 0
	for yyj270 := 0; ; yyj270++ {
		if yyhl270 {
			if yyj270 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys270Slc = r.DecodeBytes(yys270Slc, true, true)
		yys270 := string(yys270Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys270 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg3_v1.ObjectMeta{}
			} else {
				yyv273 := &x.ObjectMeta
				yyv273.CodecDecodeSelf(d)
			}
		case "subjects":
			if r.TryDecodeAsNil() {
				x.Subjects = nil
			} else {
				yyv274 := &x.Subjects
				yym275 := z.DecBinary()
				_ = yym275
				if false {
				} else {
					h.decSliceSubject((*[]Subject)(yyv274), d)
				}
			}
		case "roleRef":
			if r.TryDecodeAsNil() {
				x.RoleRef = RoleRef{}
			} else {
				yyv276 := &x.RoleRef
				yyv276.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys270)
		} // end switch yys270
	} // end for yyj270
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRoleBinding) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj277 int
	var yyb277 bool
	var yyhl277 bool = l >= 0
	yyj277++
	if yyhl277 {
		yyb277 = yyj277 > l
	} else {
		yyb277 = r.CheckBreak()
	}
	if yyb277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj277++
	if yyhl277 {
		yyb277 = yyj277 > l
	} else {
		yyb277 = r.CheckBreak()
	}
	if yyb277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj277++
	if yyhl277 {
		yyb277 = yyj277 > l
	} else {
		yyb277 = r.CheckBreak()
	}
	if yyb277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg3_v1.ObjectMeta{}
	} else {
		yyv280 := &x.ObjectMeta
		yyv280.CodecDecodeSelf(d)
	}
	yyj277++
	if yyhl277 {
		yyb277 = yyj277 > l
	} else {
		yyb277 = r.CheckBreak()
	}
	if yyb277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subjects = nil
	} else {
		yyv281 := &x.Subjects
		yym282 := z.DecBinary()
		_ = yym282
		if false {
		} else {
			h.decSliceSubject((*[]Subject)(yyv281), d)
		}
	}
	yyj277++
	if yyhl277 {
		yyb277 = yyj277 > l
	} else {
		yyb277 = r.CheckBreak()
	}
	if yyb277 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RoleRef = RoleRef{}
	} else {
		yyv283 := &x.RoleRef
		yyv283.CodecDecodeSelf(d)
	}
	for {
		yyj277++
		if yyhl277 {
			yyb277 = yyj277 > l
		} else {
			yyb277 = r.CheckBreak()
		}
		if yyb277 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj277-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRoleBindingList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym284 := z.EncBinary()
		_ = yym284
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep285 := !z.EncBinary()
			yy2arr285 := z.EncBasicHandle().StructToArray
			var yyq285 [4]bool
			_, _, _ = yysep285, yyq285, yy2arr285
			const yyr285 bool = false
			yyq285[0] = x.Kind != ""
			yyq285[1] = x.APIVersion != ""
			yyq285[2] = true
			var yynn285 int
			if yyr285 || yy2arr285 {
				r.EncodeArrayStart(4)
			} else {
				yynn285 = 1
				for _, b := range yyq285 {
					if b {
						yynn285++
					}
				}
				r.EncodeMapStart(yynn285)
				yynn285 = 0
			}
			if yyr285 || yy2arr285 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq285[0] {
					yym287 := z.EncBinary()
					_ = yym287
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq285[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym288 := z.EncBinary()
					_ = yym288
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr285 || yy2arr285 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq285[1] {
					yym290 := z.EncBinary()
					_ = yym290
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq285[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym291 := z.EncBinary()
					_ = yym291
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr285 || yy2arr285 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq285[2] {
					yy293 := &x.ListMeta
					yym294 := z.EncBinary()
					_ = yym294
					if false {
					} else if z.HasExtensions() && z.EncExt(yy293) {
					} else {
						z.EncFallback(yy293)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq285[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy295 := &x.ListMeta
					yym296 := z.EncBinary()
					_ = yym296
					if false {
					} else if z.HasExtensions() && z.EncExt(yy295) {
					} else {
						z.EncFallback(yy295)
					}
				}
			}
			if yyr285 || yy2arr285 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym298 := z.EncBinary()
					_ = yym298
					if false {
					} else {
						h.encSliceClusterRoleBinding(([]ClusterRoleBinding)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym299 := z.EncBinary()
					_ = yym299
					if false {
					} else {
						h.encSliceClusterRoleBinding(([]ClusterRoleBinding)(x.Items), e)
					}
				}
			}
			if yyr285 || yy2arr285 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRoleBindingList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym300 := z.DecBinary()
	_ = yym300
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct301 := r.ContainerType()
		if yyct301 == codecSelferValueTypeMap1234 {
			yyl301 := r.ReadMapStart()
			if yyl301 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl301, d)
			}
		} else if yyct301 == codecSelferValueTypeArray1234 {
			yyl301 := r.ReadArrayStart()
			if yyl301 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl301, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRoleBindingList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys302Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys302Slc
	var yyhl302 bool = l >= 0
	for yyj302 := 0; ; yyj302++ {
		if yyhl302 {
			if yyj302 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys302Slc = r.DecodeBytes(yys302Slc, true, true)
		yys302 := string(yys302Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys302 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv305 := &x.ListMeta
				yym306 := z.DecBinary()
				_ = yym306
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv305) {
				} else {
					z.DecFallback(yyv305, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv307 := &x.Items
				yym308 := z.DecBinary()
				_ = yym308
				if false {
				} else {
					h.decSliceClusterRoleBinding((*[]ClusterRoleBinding)(yyv307), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys302)
		} // end switch yys302
	} // end for yyj302
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRoleBindingList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj309 int
	var yyb309 bool
	var yyhl309 bool = l >= 0
	yyj309++
	if yyhl309 {
		yyb309 = yyj309 > l
	} else {
		yyb309 = r.CheckBreak()
	}
	if yyb309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj309++
	if yyhl309 {
		yyb309 = yyj309 > l
	} else {
		yyb309 = r.CheckBreak()
	}
	if yyb309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj309++
	if yyhl309 {
		yyb309 = yyj309 > l
	} else {
		yyb309 = r.CheckBreak()
	}
	if yyb309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv312 := &x.ListMeta
		yym313 := z.DecBinary()
		_ = yym313
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv312) {
		} else {
			z.DecFallback(yyv312, false)
		}
	}
	yyj309++
	if yyhl309 {
		yyb309 = yyj309 > l
	} else {
		yyb309 = r.CheckBreak()
	}
	if yyb309 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv314 := &x.Items
		yym315 := z.DecBinary()
		_ = yym315
		if false {
		} else {
			h.decSliceClusterRoleBinding((*[]ClusterRoleBinding)(yyv314), d)
		}
	}
	for {
		yyj309++
		if yyhl309 {
			yyb309 = yyj309 > l
		} else {
			yyb309 = r.CheckBreak()
		}
		if yyb309 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj309-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ClusterRoleList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym316 := z.EncBinary()
		_ = yym316
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep317 := !z.EncBinary()
			yy2arr317 := z.EncBasicHandle().StructToArray
			var yyq317 [4]bool
			_, _, _ = yysep317, yyq317, yy2arr317
			const yyr317 bool = false
			yyq317[0] = x.Kind != ""
			yyq317[1] = x.APIVersion != ""
			yyq317[2] = true
			var yynn317 int
			if yyr317 || yy2arr317 {
				r.EncodeArrayStart(4)
			} else {
				yynn317 = 1
				for _, b := range yyq317 {
					if b {
						yynn317++
					}
				}
				r.EncodeMapStart(yynn317)
				yynn317 = 0
			}
			if yyr317 || yy2arr317 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq317[0] {
					yym319 := z.EncBinary()
					_ = yym319
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq317[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym320 := z.EncBinary()
					_ = yym320
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr317 || yy2arr317 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq317[1] {
					yym322 := z.EncBinary()
					_ = yym322
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq317[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym323 := z.EncBinary()
					_ = yym323
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr317 || yy2arr317 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq317[2] {
					yy325 := &x.ListMeta
					yym326 := z.EncBinary()
					_ = yym326
					if false {
					} else if z.HasExtensions() && z.EncExt(yy325) {
					} else {
						z.EncFallback(yy325)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq317[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy327 := &x.ListMeta
					yym328 := z.EncBinary()
					_ = yym328
					if false {
					} else if z.HasExtensions() && z.EncExt(yy327) {
					} else {
						z.EncFallback(yy327)
					}
				}
			}
			if yyr317 || yy2arr317 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym330 := z.EncBinary()
					_ = yym330
					if false {
					} else {
						h.encSliceClusterRole(([]ClusterRole)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym331 := z.EncBinary()
					_ = yym331
					if false {
					} else {
						h.encSliceClusterRole(([]ClusterRole)(x.Items), e)
					}
				}
			}
			if yyr317 || yy2arr317 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ClusterRoleList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym332 := z.DecBinary()
	_ = yym332
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct333 := r.ContainerType()
		if yyct333 == codecSelferValueTypeMap1234 {
			yyl333 := r.ReadMapStart()
			if yyl333 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl333, d)
			}
		} else if yyct333 == codecSelferValueTypeArray1234 {
			yyl333 := r.ReadArrayStart()
			if yyl333 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl333, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ClusterRoleList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys334Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys334Slc
	var yyhl334 bool = l >= 0
	for yyj334 := 0; ; yyj334++ {
		if yyhl334 {
			if yyj334 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys334Slc = r.DecodeBytes(yys334Slc, true, true)
		yys334 := string(yys334Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys334 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_unversioned.ListMeta{}
			} else {
				yyv337 := &x.ListMeta
				yym338 := z.DecBinary()
				_ = yym338
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv337) {
				} else {
					z.DecFallback(yyv337, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv339 := &x.Items
				yym340 := z.DecBinary()
				_ = yym340
				if false {
				} else {
					h.decSliceClusterRole((*[]ClusterRole)(yyv339), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys334)
		} // end switch yys334
	} // end for yyj334
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ClusterRoleList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj341 int
	var yyb341 bool
	var yyhl341 bool = l >= 0
	yyj341++
	if yyhl341 {
		yyb341 = yyj341 > l
	} else {
		yyb341 = r.CheckBreak()
	}
	if yyb341 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj341++
	if yyhl341 {
		yyb341 = yyj341 > l
	} else {
		yyb341 = r.CheckBreak()
	}
	if yyb341 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj341++
	if yyhl341 {
		yyb341 = yyj341 > l
	} else {
		yyb341 = r.CheckBreak()
	}
	if yyb341 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_unversioned.ListMeta{}
	} else {
		yyv344 := &x.ListMeta
		yym345 := z.DecBinary()
		_ = yym345
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv344) {
		} else {
			z.DecFallback(yyv344, false)
		}
	}
	yyj341++
	if yyhl341 {
		yyb341 = yyj341 > l
	} else {
		yyb341 = r.CheckBreak()
	}
	if yyb341 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv346 := &x.Items
		yym347 := z.DecBinary()
		_ = yym347
		if false {
		} else {
			h.decSliceClusterRole((*[]ClusterRole)(yyv346), d)
		}
	}
	for {
		yyj341++
		if yyhl341 {
			yyb341 = yyj341 > l
		} else {
			yyb341 = r.CheckBreak()
		}
		if yyb341 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj341-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSlicePolicyRule(v []PolicyRule, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv348 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy349 := &yyv348
		yy349.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSlicePolicyRule(v *[]PolicyRule, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv350 := *v
	yyh350, yyl350 := z.DecSliceHelperStart()
	var yyc350 bool
	if yyl350 == 0 {
		if yyv350 == nil {
			yyv350 = []PolicyRule{}
			yyc350 = true
		} else if len(yyv350) != 0 {
			yyv350 = yyv350[:0]
			yyc350 = true
		}
	} else if yyl350 > 0 {
		var yyrr350, yyrl350 int
		var yyrt350 bool
		if yyl350 > cap(yyv350) {

			yyrg350 := len(yyv350) > 0
			yyv2350 := yyv350
			yyrl350, yyrt350 = z.DecInferLen(yyl350, z.DecBasicHandle().MaxInitLen, 160)
			if yyrt350 {
				if yyrl350 <= cap(yyv350) {
					yyv350 = yyv350[:yyrl350]
				} else {
					yyv350 = make([]PolicyRule, yyrl350)
				}
			} else {
				yyv350 = make([]PolicyRule, yyrl350)
			}
			yyc350 = true
			yyrr350 = len(yyv350)
			if yyrg350 {
				copy(yyv350, yyv2350)
			}
		} else if yyl350 != len(yyv350) {
			yyv350 = yyv350[:yyl350]
			yyc350 = true
		}
		yyj350 := 0
		for ; yyj350 < yyrr350; yyj350++ {
			yyh350.ElemContainerState(yyj350)
			if r.TryDecodeAsNil() {
				yyv350[yyj350] = PolicyRule{}
			} else {
				yyv351 := &yyv350[yyj350]
				yyv351.CodecDecodeSelf(d)
			}

		}
		if yyrt350 {
			for ; yyj350 < yyl350; yyj350++ {
				yyv350 = append(yyv350, PolicyRule{})
				yyh350.ElemContainerState(yyj350)
				if r.TryDecodeAsNil() {
					yyv350[yyj350] = PolicyRule{}
				} else {
					yyv352 := &yyv350[yyj350]
					yyv352.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj350 := 0
		for ; !r.CheckBreak(); yyj350++ {

			if yyj350 >= len(yyv350) {
				yyv350 = append(yyv350, PolicyRule{}) // var yyz350 PolicyRule
				yyc350 = true
			}
			yyh350.ElemContainerState(yyj350)
			if yyj350 < len(yyv350) {
				if r.TryDecodeAsNil() {
					yyv350[yyj350] = PolicyRule{}
				} else {
					yyv353 := &yyv350[yyj350]
					yyv353.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj350 < len(yyv350) {
			yyv350 = yyv350[:yyj350]
			yyc350 = true
		} else if yyj350 == 0 && yyv350 == nil {
			yyv350 = []PolicyRule{}
			yyc350 = true
		}
	}
	yyh350.End()
	if yyc350 {
		*v = yyv350
	}
}

func (x codecSelfer1234) encSliceSubject(v []Subject, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv354 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy355 := &yyv354
		yy355.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceSubject(v *[]Subject, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv356 := *v
	yyh356, yyl356 := z.DecSliceHelperStart()
	var yyc356 bool
	if yyl356 == 0 {
		if yyv356 == nil {
			yyv356 = []Subject{}
			yyc356 = true
		} else if len(yyv356) != 0 {
			yyv356 = yyv356[:0]
			yyc356 = true
		}
	} else if yyl356 > 0 {
		var yyrr356, yyrl356 int
		var yyrt356 bool
		if yyl356 > cap(yyv356) {

			yyrg356 := len(yyv356) > 0
			yyv2356 := yyv356
			yyrl356, yyrt356 = z.DecInferLen(yyl356, z.DecBasicHandle().MaxInitLen, 64)
			if yyrt356 {
				if yyrl356 <= cap(yyv356) {
					yyv356 = yyv356[:yyrl356]
				} else {
					yyv356 = make([]Subject, yyrl356)
				}
			} else {
				yyv356 = make([]Subject, yyrl356)
			}
			yyc356 = true
			yyrr356 = len(yyv356)
			if yyrg356 {
				copy(yyv356, yyv2356)
			}
		} else if yyl356 != len(yyv356) {
			yyv356 = yyv356[:yyl356]
			yyc356 = true
		}
		yyj356 := 0
		for ; yyj356 < yyrr356; yyj356++ {
			yyh356.ElemContainerState(yyj356)
			if r.TryDecodeAsNil() {
				yyv356[yyj356] = Subject{}
			} else {
				yyv357 := &yyv356[yyj356]
				yyv357.CodecDecodeSelf(d)
			}

		}
		if yyrt356 {
			for ; yyj356 < yyl356; yyj356++ {
				yyv356 = append(yyv356, Subject{})
				yyh356.ElemContainerState(yyj356)
				if r.TryDecodeAsNil() {
					yyv356[yyj356] = Subject{}
				} else {
					yyv358 := &yyv356[yyj356]
					yyv358.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj356 := 0
		for ; !r.CheckBreak(); yyj356++ {

			if yyj356 >= len(yyv356) {
				yyv356 = append(yyv356, Subject{}) // var yyz356 Subject
				yyc356 = true
			}
			yyh356.ElemContainerState(yyj356)
			if yyj356 < len(yyv356) {
				if r.TryDecodeAsNil() {
					yyv356[yyj356] = Subject{}
				} else {
					yyv359 := &yyv356[yyj356]
					yyv359.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj356 < len(yyv356) {
			yyv356 = yyv356[:yyj356]
			yyc356 = true
		} else if yyj356 == 0 && yyv356 == nil {
			yyv356 = []Subject{}
			yyc356 = true
		}
	}
	yyh356.End()
	if yyc356 {
		*v = yyv356
	}
}

func (x codecSelfer1234) encSliceRoleBinding(v []RoleBinding, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv360 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy361 := &yyv360
		yy361.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceRoleBinding(v *[]RoleBinding, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv362 := *v
	yyh362, yyl362 := z.DecSliceHelperStart()
	var yyc362 bool
	if yyl362 == 0 {
		if yyv362 == nil {
			yyv362 = []RoleBinding{}
			yyc362 = true
		} else if len(yyv362) != 0 {
			yyv362 = yyv362[:0]
			yyc362 = true
		}
	} else if yyl362 > 0 {
		var yyrr362, yyrl362 int
		var yyrt362 bool
		if yyl362 > cap(yyv362) {

			yyrg362 := len(yyv362) > 0
			yyv2362 := yyv362
			yyrl362, yyrt362 = z.DecInferLen(yyl362, z.DecBasicHandle().MaxInitLen, 328)
			if yyrt362 {
				if yyrl362 <= cap(yyv362) {
					yyv362 = yyv362[:yyrl362]
				} else {
					yyv362 = make([]RoleBinding, yyrl362)
				}
			} else {
				yyv362 = make([]RoleBinding, yyrl362)
			}
			yyc362 = true
			yyrr362 = len(yyv362)
			if yyrg362 {
				copy(yyv362, yyv2362)
			}
		} else if yyl362 != len(yyv362) {
			yyv362 = yyv362[:yyl362]
			yyc362 = true
		}
		yyj362 := 0
		for ; yyj362 < yyrr362; yyj362++ {
			yyh362.ElemContainerState(yyj362)
			if r.TryDecodeAsNil() {
				yyv362[yyj362] = RoleBinding{}
			} else {
				yyv363 := &yyv362[yyj362]
				yyv363.CodecDecodeSelf(d)
			}

		}
		if yyrt362 {
			for ; yyj362 < yyl362; yyj362++ {
				yyv362 = append(yyv362, RoleBinding{})
				yyh362.ElemContainerState(yyj362)
				if r.TryDecodeAsNil() {
					yyv362[yyj362] = RoleBinding{}
				} else {
					yyv364 := &yyv362[yyj362]
					yyv364.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj362 := 0
		for ; !r.CheckBreak(); yyj362++ {

			if yyj362 >= len(yyv362) {
				yyv362 = append(yyv362, RoleBinding{}) // var yyz362 RoleBinding
				yyc362 = true
			}
			yyh362.ElemContainerState(yyj362)
			if yyj362 < len(yyv362) {
				if r.TryDecodeAsNil() {
					yyv362[yyj362] = RoleBinding{}
				} else {
					yyv365 := &yyv362[yyj362]
					yyv365.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj362 < len(yyv362) {
			yyv362 = yyv362[:yyj362]
			yyc362 = true
		} else if yyj362 == 0 && yyv362 == nil {
			yyv362 = []RoleBinding{}
			yyc362 = true
		}
	}
	yyh362.End()
	if yyc362 {
		*v = yyv362
	}
}

func (x codecSelfer1234) encSliceRole(v []Role, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv366 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy367 := &yyv366
		yy367.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceRole(v *[]Role, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv368 := *v
	yyh368, yyl368 := z.DecSliceHelperStart()
	var yyc368 bool
	if yyl368 == 0 {
		if yyv368 == nil {
			yyv368 = []Role{}
			yyc368 = true
		} else if len(yyv368) != 0 {
			yyv368 = yyv368[:0]
			yyc368 = true
		}
	} else if yyl368 > 0 {
		var yyrr368, yyrl368 int
		var yyrt368 bool
		if yyl368 > cap(yyv368) {

			yyrg368 := len(yyv368) > 0
			yyv2368 := yyv368
			yyrl368, yyrt368 = z.DecInferLen(yyl368, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt368 {
				if yyrl368 <= cap(yyv368) {
					yyv368 = yyv368[:yyrl368]
				} else {
					yyv368 = make([]Role, yyrl368)
				}
			} else {
				yyv368 = make([]Role, yyrl368)
			}
			yyc368 = true
			yyrr368 = len(yyv368)
			if yyrg368 {
				copy(yyv368, yyv2368)
			}
		} else if yyl368 != len(yyv368) {
			yyv368 = yyv368[:yyl368]
			yyc368 = true
		}
		yyj368 := 0
		for ; yyj368 < yyrr368; yyj368++ {
			yyh368.ElemContainerState(yyj368)
			if r.TryDecodeAsNil() {
				yyv368[yyj368] = Role{}
			} else {
				yyv369 := &yyv368[yyj368]
				yyv369.CodecDecodeSelf(d)
			}

		}
		if yyrt368 {
			for ; yyj368 < yyl368; yyj368++ {
				yyv368 = append(yyv368, Role{})
				yyh368.ElemContainerState(yyj368)
				if r.TryDecodeAsNil() {
					yyv368[yyj368] = Role{}
				} else {
					yyv370 := &yyv368[yyj368]
					yyv370.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj368 := 0
		for ; !r.CheckBreak(); yyj368++ {

			if yyj368 >= len(yyv368) {
				yyv368 = append(yyv368, Role{}) // var yyz368 Role
				yyc368 = true
			}
			yyh368.ElemContainerState(yyj368)
			if yyj368 < len(yyv368) {
				if r.TryDecodeAsNil() {
					yyv368[yyj368] = Role{}
				} else {
					yyv371 := &yyv368[yyj368]
					yyv371.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj368 < len(yyv368) {
			yyv368 = yyv368[:yyj368]
			yyc368 = true
		} else if yyj368 == 0 && yyv368 == nil {
			yyv368 = []Role{}
			yyc368 = true
		}
	}
	yyh368.End()
	if yyc368 {
		*v = yyv368
	}
}

func (x codecSelfer1234) encSliceClusterRoleBinding(v []ClusterRoleBinding, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv372 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy373 := &yyv372
		yy373.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceClusterRoleBinding(v *[]ClusterRoleBinding, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv374 := *v
	yyh374, yyl374 := z.DecSliceHelperStart()
	var yyc374 bool
	if yyl374 == 0 {
		if yyv374 == nil {
			yyv374 = []ClusterRoleBinding{}
			yyc374 = true
		} else if len(yyv374) != 0 {
			yyv374 = yyv374[:0]
			yyc374 = true
		}
	} else if yyl374 > 0 {
		var yyrr374, yyrl374 int
		var yyrt374 bool
		if yyl374 > cap(yyv374) {

			yyrg374 := len(yyv374) > 0
			yyv2374 := yyv374
			yyrl374, yyrt374 = z.DecInferLen(yyl374, z.DecBasicHandle().MaxInitLen, 328)
			if yyrt374 {
				if yyrl374 <= cap(yyv374) {
					yyv374 = yyv374[:yyrl374]
				} else {
					yyv374 = make([]ClusterRoleBinding, yyrl374)
				}
			} else {
				yyv374 = make([]ClusterRoleBinding, yyrl374)
			}
			yyc374 = true
			yyrr374 = len(yyv374)
			if yyrg374 {
				copy(yyv374, yyv2374)
			}
		} else if yyl374 != len(yyv374) {
			yyv374 = yyv374[:yyl374]
			yyc374 = true
		}
		yyj374 := 0
		for ; yyj374 < yyrr374; yyj374++ {
			yyh374.ElemContainerState(yyj374)
			if r.TryDecodeAsNil() {
				yyv374[yyj374] = ClusterRoleBinding{}
			} else {
				yyv375 := &yyv374[yyj374]
				yyv375.CodecDecodeSelf(d)
			}

		}
		if yyrt374 {
			for ; yyj374 < yyl374; yyj374++ {
				yyv374 = append(yyv374, ClusterRoleBinding{})
				yyh374.ElemContainerState(yyj374)
				if r.TryDecodeAsNil() {
					yyv374[yyj374] = ClusterRoleBinding{}
				} else {
					yyv376 := &yyv374[yyj374]
					yyv376.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj374 := 0
		for ; !r.CheckBreak(); yyj374++ {

			if yyj374 >= len(yyv374) {
				yyv374 = append(yyv374, ClusterRoleBinding{}) // var yyz374 ClusterRoleBinding
				yyc374 = true
			}
			yyh374.ElemContainerState(yyj374)
			if yyj374 < len(yyv374) {
				if r.TryDecodeAsNil() {
					yyv374[yyj374] = ClusterRoleBinding{}
				} else {
					yyv377 := &yyv374[yyj374]
					yyv377.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj374 < len(yyv374) {
			yyv374 = yyv374[:yyj374]
			yyc374 = true
		} else if yyj374 == 0 && yyv374 == nil {
			yyv374 = []ClusterRoleBinding{}
			yyc374 = true
		}
	}
	yyh374.End()
	if yyc374 {
		*v = yyv374
	}
}

func (x codecSelfer1234) encSliceClusterRole(v []ClusterRole, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv378 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy379 := &yyv378
		yy379.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceClusterRole(v *[]ClusterRole, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv380 := *v
	yyh380, yyl380 := z.DecSliceHelperStart()
	var yyc380 bool
	if yyl380 == 0 {
		if yyv380 == nil {
			yyv380 = []ClusterRole{}
			yyc380 = true
		} else if len(yyv380) != 0 {
			yyv380 = yyv380[:0]
			yyc380 = true
		}
	} else if yyl380 > 0 {
		var yyrr380, yyrl380 int
		var yyrt380 bool
		if yyl380 > cap(yyv380) {

			yyrg380 := len(yyv380) > 0
			yyv2380 := yyv380
			yyrl380, yyrt380 = z.DecInferLen(yyl380, z.DecBasicHandle().MaxInitLen, 280)
			if yyrt380 {
				if yyrl380 <= cap(yyv380) {
					yyv380 = yyv380[:yyrl380]
				} else {
					yyv380 = make([]ClusterRole, yyrl380)
				}
			} else {
				yyv380 = make([]ClusterRole, yyrl380)
			}
			yyc380 = true
			yyrr380 = len(yyv380)
			if yyrg380 {
				copy(yyv380, yyv2380)
			}
		} else if yyl380 != len(yyv380) {
			yyv380 = yyv380[:yyl380]
			yyc380 = true
		}
		yyj380 := 0
		for ; yyj380 < yyrr380; yyj380++ {
			yyh380.ElemContainerState(yyj380)
			if r.TryDecodeAsNil() {
				yyv380[yyj380] = ClusterRole{}
			} else {
				yyv381 := &yyv380[yyj380]
				yyv381.CodecDecodeSelf(d)
			}

		}
		if yyrt380 {
			for ; yyj380 < yyl380; yyj380++ {
				yyv380 = append(yyv380, ClusterRole{})
				yyh380.ElemContainerState(yyj380)
				if r.TryDecodeAsNil() {
					yyv380[yyj380] = ClusterRole{}
				} else {
					yyv382 := &yyv380[yyj380]
					yyv382.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj380 := 0
		for ; !r.CheckBreak(); yyj380++ {

			if yyj380 >= len(yyv380) {
				yyv380 = append(yyv380, ClusterRole{}) // var yyz380 ClusterRole
				yyc380 = true
			}
			yyh380.ElemContainerState(yyj380)
			if yyj380 < len(yyv380) {
				if r.TryDecodeAsNil() {
					yyv380[yyj380] = ClusterRole{}
				} else {
					yyv383 := &yyv380[yyj380]
					yyv383.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj380 < len(yyv380) {
			yyv380 = yyv380[:yyj380]
			yyc380 = true
		} else if yyj380 == 0 && yyv380 == nil {
			yyv380 = []ClusterRole{}
			yyc380 = true
		}
	}
	yyh380.End()
	if yyc380 {
		*v = yyv380
	}
}
