// Code generated by protoc-gen-go.
// source: api/api.proto
// DO NOT EDIT!

package api

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "go.pedge.io/pb/go/google/protobuf"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Status int32

const (
	Status_STATUS_NONE                  Status = 0
	Status_STATUS_INIT                  Status = 1
	Status_STATUS_OK                    Status = 2
	Status_STATUS_OFFLINE               Status = 3
	Status_STATUS_ERROR                 Status = 4
	Status_STATUS_NOT_IN_QUORUM         Status = 5
	Status_STATUS_DECOMMISSION          Status = 6
	Status_STATUS_MAINTENANCE           Status = 7
	Status_STATUS_STORAGE_DOWN          Status = 8
	Status_STATUS_STORAGE_DEGRADED      Status = 9
	Status_STATUS_NEEDS_REBOOT          Status = 10
	Status_STATUS_STORAGE_REBALANCE     Status = 11
	Status_STATUS_STORAGE_DRIVE_REPLACE Status = 12
	// Add statuses before MAX and update the number for MAX
	Status_STATUS_MAX Status = 13
)

var Status_name = map[int32]string{
	0:  "STATUS_NONE",
	1:  "STATUS_INIT",
	2:  "STATUS_OK",
	3:  "STATUS_OFFLINE",
	4:  "STATUS_ERROR",
	5:  "STATUS_NOT_IN_QUORUM",
	6:  "STATUS_DECOMMISSION",
	7:  "STATUS_MAINTENANCE",
	8:  "STATUS_STORAGE_DOWN",
	9:  "STATUS_STORAGE_DEGRADED",
	10: "STATUS_NEEDS_REBOOT",
	11: "STATUS_STORAGE_REBALANCE",
	12: "STATUS_STORAGE_DRIVE_REPLACE",
	13: "STATUS_MAX",
}
var Status_value = map[string]int32{
	"STATUS_NONE":                  0,
	"STATUS_INIT":                  1,
	"STATUS_OK":                    2,
	"STATUS_OFFLINE":               3,
	"STATUS_ERROR":                 4,
	"STATUS_NOT_IN_QUORUM":         5,
	"STATUS_DECOMMISSION":          6,
	"STATUS_MAINTENANCE":           7,
	"STATUS_STORAGE_DOWN":          8,
	"STATUS_STORAGE_DEGRADED":      9,
	"STATUS_NEEDS_REBOOT":          10,
	"STATUS_STORAGE_REBALANCE":     11,
	"STATUS_STORAGE_DRIVE_REPLACE": 12,
	"STATUS_MAX":                   13,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type DriverType int32

const (
	DriverType_DRIVER_TYPE_NONE      DriverType = 0
	DriverType_DRIVER_TYPE_FILE      DriverType = 1
	DriverType_DRIVER_TYPE_BLOCK     DriverType = 2
	DriverType_DRIVER_TYPE_OBJECT    DriverType = 3
	DriverType_DRIVER_TYPE_CLUSTERED DriverType = 4
	DriverType_DRIVER_TYPE_GRAPH     DriverType = 5
)

var DriverType_name = map[int32]string{
	0: "DRIVER_TYPE_NONE",
	1: "DRIVER_TYPE_FILE",
	2: "DRIVER_TYPE_BLOCK",
	3: "DRIVER_TYPE_OBJECT",
	4: "DRIVER_TYPE_CLUSTERED",
	5: "DRIVER_TYPE_GRAPH",
}
var DriverType_value = map[string]int32{
	"DRIVER_TYPE_NONE":      0,
	"DRIVER_TYPE_FILE":      1,
	"DRIVER_TYPE_BLOCK":     2,
	"DRIVER_TYPE_OBJECT":    3,
	"DRIVER_TYPE_CLUSTERED": 4,
	"DRIVER_TYPE_GRAPH":     5,
}

func (x DriverType) String() string {
	return proto.EnumName(DriverType_name, int32(x))
}
func (DriverType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type FSType int32

const (
	FSType_FS_TYPE_NONE  FSType = 0
	FSType_FS_TYPE_BTRFS FSType = 1
	FSType_FS_TYPE_EXT4  FSType = 2
	FSType_FS_TYPE_FUSE  FSType = 3
	FSType_FS_TYPE_NFS   FSType = 4
	FSType_FS_TYPE_VFS   FSType = 5
	FSType_FS_TYPE_XFS   FSType = 6
	FSType_FS_TYPE_ZFS   FSType = 7
)

var FSType_name = map[int32]string{
	0: "FS_TYPE_NONE",
	1: "FS_TYPE_BTRFS",
	2: "FS_TYPE_EXT4",
	3: "FS_TYPE_FUSE",
	4: "FS_TYPE_NFS",
	5: "FS_TYPE_VFS",
	6: "FS_TYPE_XFS",
	7: "FS_TYPE_ZFS",
}
var FSType_value = map[string]int32{
	"FS_TYPE_NONE":  0,
	"FS_TYPE_BTRFS": 1,
	"FS_TYPE_EXT4":  2,
	"FS_TYPE_FUSE":  3,
	"FS_TYPE_NFS":   4,
	"FS_TYPE_VFS":   5,
	"FS_TYPE_XFS":   6,
	"FS_TYPE_ZFS":   7,
}

func (x FSType) String() string {
	return proto.EnumName(FSType_name, int32(x))
}
func (FSType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type GraphDriverChangeType int32

const (
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_NONE     GraphDriverChangeType = 0
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_MODIFIED GraphDriverChangeType = 1
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_ADDED    GraphDriverChangeType = 2
	GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_DELETED  GraphDriverChangeType = 3
)

var GraphDriverChangeType_name = map[int32]string{
	0: "GRAPH_DRIVER_CHANGE_TYPE_NONE",
	1: "GRAPH_DRIVER_CHANGE_TYPE_MODIFIED",
	2: "GRAPH_DRIVER_CHANGE_TYPE_ADDED",
	3: "GRAPH_DRIVER_CHANGE_TYPE_DELETED",
}
var GraphDriverChangeType_value = map[string]int32{
	"GRAPH_DRIVER_CHANGE_TYPE_NONE":     0,
	"GRAPH_DRIVER_CHANGE_TYPE_MODIFIED": 1,
	"GRAPH_DRIVER_CHANGE_TYPE_ADDED":    2,
	"GRAPH_DRIVER_CHANGE_TYPE_DELETED":  3,
}

func (x GraphDriverChangeType) String() string {
	return proto.EnumName(GraphDriverChangeType_name, int32(x))
}
func (GraphDriverChangeType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type SeverityType int32

const (
	SeverityType_SEVERITY_TYPE_NONE    SeverityType = 0
	SeverityType_SEVERITY_TYPE_ALARM   SeverityType = 1
	SeverityType_SEVERITY_TYPE_WARNING SeverityType = 2
	SeverityType_SEVERITY_TYPE_NOTIFY  SeverityType = 3
)

var SeverityType_name = map[int32]string{
	0: "SEVERITY_TYPE_NONE",
	1: "SEVERITY_TYPE_ALARM",
	2: "SEVERITY_TYPE_WARNING",
	3: "SEVERITY_TYPE_NOTIFY",
}
var SeverityType_value = map[string]int32{
	"SEVERITY_TYPE_NONE":    0,
	"SEVERITY_TYPE_ALARM":   1,
	"SEVERITY_TYPE_WARNING": 2,
	"SEVERITY_TYPE_NOTIFY":  3,
}

func (x SeverityType) String() string {
	return proto.EnumName(SeverityType_name, int32(x))
}
func (SeverityType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type ResourceType int32

const (
	ResourceType_RESOURCE_TYPE_NONE    ResourceType = 0
	ResourceType_RESOURCE_TYPE_VOLUME  ResourceType = 1
	ResourceType_RESOURCE_TYPE_NODE    ResourceType = 2
	ResourceType_RESOURCE_TYPE_CLUSTER ResourceType = 3
	ResourceType_RESOURCE_TYPE_DRIVE   ResourceType = 4
)

var ResourceType_name = map[int32]string{
	0: "RESOURCE_TYPE_NONE",
	1: "RESOURCE_TYPE_VOLUME",
	2: "RESOURCE_TYPE_NODE",
	3: "RESOURCE_TYPE_CLUSTER",
	4: "RESOURCE_TYPE_DRIVE",
}
var ResourceType_value = map[string]int32{
	"RESOURCE_TYPE_NONE":    0,
	"RESOURCE_TYPE_VOLUME":  1,
	"RESOURCE_TYPE_NODE":    2,
	"RESOURCE_TYPE_CLUSTER": 3,
	"RESOURCE_TYPE_DRIVE":   4,
}

func (x ResourceType) String() string {
	return proto.EnumName(ResourceType_name, int32(x))
}
func (ResourceType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type AlertActionType int32

const (
	AlertActionType_ALERT_ACTION_TYPE_NONE   AlertActionType = 0
	AlertActionType_ALERT_ACTION_TYPE_DELETE AlertActionType = 1
	AlertActionType_ALERT_ACTION_TYPE_CREATE AlertActionType = 2
	AlertActionType_ALERT_ACTION_TYPE_UPDATE AlertActionType = 3
)

var AlertActionType_name = map[int32]string{
	0: "ALERT_ACTION_TYPE_NONE",
	1: "ALERT_ACTION_TYPE_DELETE",
	2: "ALERT_ACTION_TYPE_CREATE",
	3: "ALERT_ACTION_TYPE_UPDATE",
}
var AlertActionType_value = map[string]int32{
	"ALERT_ACTION_TYPE_NONE":   0,
	"ALERT_ACTION_TYPE_DELETE": 1,
	"ALERT_ACTION_TYPE_CREATE": 2,
	"ALERT_ACTION_TYPE_UPDATE": 3,
}

func (x AlertActionType) String() string {
	return proto.EnumName(AlertActionType_name, int32(x))
}
func (AlertActionType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type VolumeActionParam int32

const (
	VolumeActionParam_VOLUME_ACTION_PARAM_NONE VolumeActionParam = 0
	// Maps to the boolean value false
	VolumeActionParam_VOLUME_ACTION_PARAM_OFF VolumeActionParam = 1
	// Maps to the boolean value true.
	VolumeActionParam_VOLUME_ACTION_PARAM_ON VolumeActionParam = 2
)

var VolumeActionParam_name = map[int32]string{
	0: "VOLUME_ACTION_PARAM_NONE",
	1: "VOLUME_ACTION_PARAM_OFF",
	2: "VOLUME_ACTION_PARAM_ON",
}
var VolumeActionParam_value = map[string]int32{
	"VOLUME_ACTION_PARAM_NONE": 0,
	"VOLUME_ACTION_PARAM_OFF":  1,
	"VOLUME_ACTION_PARAM_ON":   2,
}

func (x VolumeActionParam) String() string {
	return proto.EnumName(VolumeActionParam_name, int32(x))
}
func (VolumeActionParam) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type CosType int32

const (
	CosType_NONE   CosType = 0
	CosType_LOW    CosType = 1
	CosType_MEDIUM CosType = 2
	CosType_HIGH   CosType = 3
)

var CosType_name = map[int32]string{
	0: "NONE",
	1: "LOW",
	2: "MEDIUM",
	3: "HIGH",
}
var CosType_value = map[string]int32{
	"NONE":   0,
	"LOW":    1,
	"MEDIUM": 2,
	"HIGH":   3,
}

func (x CosType) String() string {
	return proto.EnumName(CosType_name, int32(x))
}
func (CosType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// VolumeState represents the state of a volume.
type VolumeState int32

const (
	VolumeState_VOLUME_STATE_NONE VolumeState = 0
	// Volume is transitioning to new state
	VolumeState_VOLUME_STATE_PENDING VolumeState = 1
	// Volume is ready to be assigned to a container
	VolumeState_VOLUME_STATE_AVAILABLE VolumeState = 2
	// Volume is attached to container
	VolumeState_VOLUME_STATE_ATTACHED VolumeState = 3
	// Volume is detached but associated with a container
	VolumeState_VOLUME_STATE_DETACHED VolumeState = 4
	// Volume detach is in progress
	VolumeState_VOLUME_STATE_DETATCHING VolumeState = 5
	// Volume is in error state
	VolumeState_VOLUME_STATE_ERROR VolumeState = 6
	// Volume is deleted, it will remain in this state
	// while resources are asynchronously reclaimed
	VolumeState_VOLUME_STATE_DELETED VolumeState = 7
)

var VolumeState_name = map[int32]string{
	0: "VOLUME_STATE_NONE",
	1: "VOLUME_STATE_PENDING",
	2: "VOLUME_STATE_AVAILABLE",
	3: "VOLUME_STATE_ATTACHED",
	4: "VOLUME_STATE_DETACHED",
	5: "VOLUME_STATE_DETATCHING",
	6: "VOLUME_STATE_ERROR",
	7: "VOLUME_STATE_DELETED",
}
var VolumeState_value = map[string]int32{
	"VOLUME_STATE_NONE":       0,
	"VOLUME_STATE_PENDING":    1,
	"VOLUME_STATE_AVAILABLE":  2,
	"VOLUME_STATE_ATTACHED":   3,
	"VOLUME_STATE_DETACHED":   4,
	"VOLUME_STATE_DETATCHING": 5,
	"VOLUME_STATE_ERROR":      6,
	"VOLUME_STATE_DELETED":    7,
}

func (x VolumeState) String() string {
	return proto.EnumName(VolumeState_name, int32(x))
}
func (VolumeState) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// VolumeStatus represents a health status for a volume.
type VolumeStatus int32

const (
	VolumeStatus_VOLUME_STATUS_NONE VolumeStatus = 0
	// Volume is not present
	VolumeStatus_VOLUME_STATUS_NOT_PRESENT VolumeStatus = 1
	// Volume is healthy
	VolumeStatus_VOLUME_STATUS_UP VolumeStatus = 2
	// Volume is in fail mode
	VolumeStatus_VOLUME_STATUS_DOWN VolumeStatus = 3
	// Volume is up but with degraded performance
	// In a RAID group, this may indicate a problem with one or more drives
	VolumeStatus_VOLUME_STATUS_DEGRADED VolumeStatus = 4
)

var VolumeStatus_name = map[int32]string{
	0: "VOLUME_STATUS_NONE",
	1: "VOLUME_STATUS_NOT_PRESENT",
	2: "VOLUME_STATUS_UP",
	3: "VOLUME_STATUS_DOWN",
	4: "VOLUME_STATUS_DEGRADED",
}
var VolumeStatus_value = map[string]int32{
	"VOLUME_STATUS_NONE":        0,
	"VOLUME_STATUS_NOT_PRESENT": 1,
	"VOLUME_STATUS_UP":          2,
	"VOLUME_STATUS_DOWN":        3,
	"VOLUME_STATUS_DEGRADED":    4,
}

func (x VolumeStatus) String() string {
	return proto.EnumName(VolumeStatus_name, int32(x))
}
func (VolumeStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type StorageMedium int32

const (
	// Magnetic spinning disk.
	StorageMedium_STORAGE_MEDIUM_MAGNETIC StorageMedium = 0
	// SSD disk
	StorageMedium_STORAGE_MEDIUM_SSD StorageMedium = 1
	// NVME disk
	StorageMedium_STORAGE_MEDIUM_NVME StorageMedium = 2
)

var StorageMedium_name = map[int32]string{
	0: "STORAGE_MEDIUM_MAGNETIC",
	1: "STORAGE_MEDIUM_SSD",
	2: "STORAGE_MEDIUM_NVME",
}
var StorageMedium_value = map[string]int32{
	"STORAGE_MEDIUM_MAGNETIC": 0,
	"STORAGE_MEDIUM_SSD":      1,
	"STORAGE_MEDIUM_NVME":     2,
}

func (x StorageMedium) String() string {
	return proto.EnumName(StorageMedium_name, int32(x))
}
func (StorageMedium) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type ClusterNotify int32

const (
	// Node is down
	ClusterNotify_CLUSTER_NOTIFY_DOWN ClusterNotify = 0
)

var ClusterNotify_name = map[int32]string{
	0: "CLUSTER_NOTIFY_DOWN",
}
var ClusterNotify_value = map[string]int32{
	"CLUSTER_NOTIFY_DOWN": 0,
}

func (x ClusterNotify) String() string {
	return proto.EnumName(ClusterNotify_name, int32(x))
}
func (ClusterNotify) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// StorageResource groups properties of a storage device.
type StorageResource struct {
	// Id is the LUN identifier.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Path device path for this storage resource.
	Path string `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	// Storage medium.
	Medium StorageMedium `protobuf:"varint,3,opt,name=medium,enum=openstorage.api.StorageMedium" json:"medium,omitempty"`
	// True if this device is online.
	Online bool `protobuf:"varint,4,opt,name=online" json:"online,omitempty"`
	// IOPS
	Iops uint64 `protobuf:"varint,5,opt,name=iops" json:"iops,omitempty"`
	// SeqWrite
	SeqWrite float64 `protobuf:"fixed64,6,opt,name=seq_write,json=seqWrite" json:"seq_write,omitempty"`
	// SeqRead
	SeqRead float64 `protobuf:"fixed64,7,opt,name=seq_read,json=seqRead" json:"seq_read,omitempty"`
	// RandRW
	RandRW float64 `protobuf:"fixed64,8,opt,name=randRW" json:"randRW,omitempty"`
	// Total size in bytes.
	Size uint64 `protobuf:"varint,9,opt,name=size" json:"size,omitempty"`
	// Physical Bytes used.
	Used uint64 `protobuf:"varint,10,opt,name=used" json:"used,omitempty"`
	// True if this device is rotational.
	RotationSpeed string `protobuf:"bytes,11,opt,name=rotation_speed,json=rotationSpeed" json:"rotation_speed,omitempty"`
	// Timestamp of last time this device was scanned.
	LastScan *google_protobuf.Timestamp `protobuf:"bytes,12,opt,name=last_scan,json=lastScan" json:"last_scan,omitempty"`
}

func (m *StorageResource) Reset()                    { *m = StorageResource{} }
func (m *StorageResource) String() string            { return proto.CompactTextString(m) }
func (*StorageResource) ProtoMessage()               {}
func (*StorageResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *StorageResource) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StorageResource) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *StorageResource) GetMedium() StorageMedium {
	if m != nil {
		return m.Medium
	}
	return StorageMedium_STORAGE_MEDIUM_MAGNETIC
}

func (m *StorageResource) GetOnline() bool {
	if m != nil {
		return m.Online
	}
	return false
}

func (m *StorageResource) GetIops() uint64 {
	if m != nil {
		return m.Iops
	}
	return 0
}

func (m *StorageResource) GetSeqWrite() float64 {
	if m != nil {
		return m.SeqWrite
	}
	return 0
}

func (m *StorageResource) GetSeqRead() float64 {
	if m != nil {
		return m.SeqRead
	}
	return 0
}

func (m *StorageResource) GetRandRW() float64 {
	if m != nil {
		return m.RandRW
	}
	return 0
}

func (m *StorageResource) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *StorageResource) GetUsed() uint64 {
	if m != nil {
		return m.Used
	}
	return 0
}

func (m *StorageResource) GetRotationSpeed() string {
	if m != nil {
		return m.RotationSpeed
	}
	return ""
}

func (m *StorageResource) GetLastScan() *google_protobuf.Timestamp {
	if m != nil {
		return m.LastScan
	}
	return nil
}

// VolumeLocator is a structure that is attached to a volume
// and is used to carry opaque metadata.
type VolumeLocator struct {
	// User friendly identifier
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A set of name-value pairs that acts as search filters
	VolumeLabels map[string]string `protobuf:"bytes,2,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VolumeLocator) Reset()                    { *m = VolumeLocator{} }
func (m *VolumeLocator) String() string            { return proto.CompactTextString(m) }
func (*VolumeLocator) ProtoMessage()               {}
func (*VolumeLocator) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *VolumeLocator) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VolumeLocator) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

type Source struct {
	// A volume id, if specified will create a clone of the parent.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Seed will seed the volume from the specified URI
	// Any additional config for the source comes from the labels in the spec
	Seed string `protobuf:"bytes,2,opt,name=seed" json:"seed,omitempty"`
}

func (m *Source) Reset()                    { *m = Source{} }
func (m *Source) String() string            { return proto.CompactTextString(m) }
func (*Source) ProtoMessage()               {}
func (*Source) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Source) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Source) GetSeed() string {
	if m != nil {
		return m.Seed
	}
	return ""
}

// VolumeSpec has the properties needed to create a volume.
type VolumeSpec struct {
	// Ephemeral storage
	Ephemeral bool `protobuf:"varint,1,opt,name=ephemeral" json:"ephemeral,omitempty"`
	// Thin provisioned volume size in bytes
	Size uint64 `protobuf:"varint,2,opt,name=size" json:"size,omitempty"`
	// Format disk with this FSType
	Format FSType `protobuf:"varint,3,opt,name=format,enum=openstorage.api.FSType" json:"format,omitempty"`
	// Block size for filesystem
	BlockSize int64 `protobuf:"varint,4,opt,name=block_size,json=blockSize" json:"block_size,omitempty"`
	// Specifies the number of nodes that are
	// allowed to fail, and yet data is available
	// A value of 0 implies that data is not erasure coded,
	// a failure of a node will lead to data loss
	HaLevel int64 `protobuf:"varint,5,opt,name=ha_level,json=haLevel" json:"ha_level,omitempty"`
	// The COS, 1 to 9
	Cos CosType `protobuf:"varint,6,opt,name=cos,enum=openstorage.api.CosType" json:"cos,omitempty"`
	// Perform dedupe on this disk
	Dedupe bool `protobuf:"varint,7,opt,name=dedupe" json:"dedupe,omitempty"`
	// SnapshotInterval in minutes, set to 0 to disable snapshots
	SnapshotInterval uint32 `protobuf:"varint,8,opt,name=snapshot_interval,json=snapshotInterval" json:"snapshot_interval,omitempty"`
	// Volume configuration labels
	VolumeLabels map[string]string `protobuf:"bytes,9,rep,name=volume_labels,json=volumeLabels" json:"volume_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Shared is true if this volume can be remotely accessed.
	Shared bool `protobuf:"varint,10,opt,name=shared" json:"shared,omitempty"`
	// ReplicaSet is the desired replicaSet the volume want to be placed.
	ReplicaSet *ReplicaSet `protobuf:"bytes,11,opt,name=replica_set,json=replicaSet" json:"replica_set,omitempty"`
	// Specifies the number of parts the volume can be aggregated from.
	AggregationLevel uint32 `protobuf:"varint,12,opt,name=aggregation_level,json=aggregationLevel" json:"aggregation_level,omitempty"`
	// Encrypted is true if this volume will be cryptographically secured.
	Encrypted bool `protobuf:"varint,13,opt,name=encrypted" json:"encrypted,omitempty"`
	// User passphrase if this is an encrypted volume
	Passphrase string `protobuf:"bytes,14,opt,name=passphrase" json:"passphrase,omitempty"`
	// SnapshotSchedule
	SnapshotSchedule string `protobuf:"bytes,15,opt,name=snapshot_schedule,json=snapshotSchedule" json:"snapshot_schedule,omitempty"`
	// Scale allows autocreation of volumes.
	Scale uint32 `protobuf:"varint,16,opt,name=scale" json:"scale,omitempty"`
}

func (m *VolumeSpec) Reset()                    { *m = VolumeSpec{} }
func (m *VolumeSpec) String() string            { return proto.CompactTextString(m) }
func (*VolumeSpec) ProtoMessage()               {}
func (*VolumeSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *VolumeSpec) GetEphemeral() bool {
	if m != nil {
		return m.Ephemeral
	}
	return false
}

func (m *VolumeSpec) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *VolumeSpec) GetFormat() FSType {
	if m != nil {
		return m.Format
	}
	return FSType_FS_TYPE_NONE
}

func (m *VolumeSpec) GetBlockSize() int64 {
	if m != nil {
		return m.BlockSize
	}
	return 0
}

func (m *VolumeSpec) GetHaLevel() int64 {
	if m != nil {
		return m.HaLevel
	}
	return 0
}

func (m *VolumeSpec) GetCos() CosType {
	if m != nil {
		return m.Cos
	}
	return CosType_NONE
}

func (m *VolumeSpec) GetDedupe() bool {
	if m != nil {
		return m.Dedupe
	}
	return false
}

func (m *VolumeSpec) GetSnapshotInterval() uint32 {
	if m != nil {
		return m.SnapshotInterval
	}
	return 0
}

func (m *VolumeSpec) GetVolumeLabels() map[string]string {
	if m != nil {
		return m.VolumeLabels
	}
	return nil
}

func (m *VolumeSpec) GetShared() bool {
	if m != nil {
		return m.Shared
	}
	return false
}

func (m *VolumeSpec) GetReplicaSet() *ReplicaSet {
	if m != nil {
		return m.ReplicaSet
	}
	return nil
}

func (m *VolumeSpec) GetAggregationLevel() uint32 {
	if m != nil {
		return m.AggregationLevel
	}
	return 0
}

func (m *VolumeSpec) GetEncrypted() bool {
	if m != nil {
		return m.Encrypted
	}
	return false
}

func (m *VolumeSpec) GetPassphrase() string {
	if m != nil {
		return m.Passphrase
	}
	return ""
}

func (m *VolumeSpec) GetSnapshotSchedule() string {
	if m != nil {
		return m.SnapshotSchedule
	}
	return ""
}

func (m *VolumeSpec) GetScale() uint32 {
	if m != nil {
		return m.Scale
	}
	return 0
}

// Set of machine IDs (nodes) to which part of this volume is erasure coded - for clustered storage arrays
type ReplicaSet struct {
	Nodes []string `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
}

func (m *ReplicaSet) Reset()                    { *m = ReplicaSet{} }
func (m *ReplicaSet) String() string            { return proto.CompactTextString(m) }
func (*ReplicaSet) ProtoMessage()               {}
func (*ReplicaSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ReplicaSet) GetNodes() []string {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// List of name value mapping of driver specific runtime information.
type RuntimeStateMap struct {
	RuntimeState map[string]string `protobuf:"bytes,1,rep,name=runtime_state,json=runtimeState" json:"runtime_state,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RuntimeStateMap) Reset()                    { *m = RuntimeStateMap{} }
func (m *RuntimeStateMap) String() string            { return proto.CompactTextString(m) }
func (*RuntimeStateMap) ProtoMessage()               {}
func (*RuntimeStateMap) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *RuntimeStateMap) GetRuntimeState() map[string]string {
	if m != nil {
		return m.RuntimeState
	}
	return nil
}

// Volume represents a live, created volume.
type Volume struct {
	// Self referential volume ID
	Id       string  `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Source   *Source `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
	Readonly bool    `protobuf:"varint,3,opt,name=readonly" json:"readonly,omitempty"`
	// User specified locator
	Locator *VolumeLocator `protobuf:"bytes,4,opt,name=locator" json:"locator,omitempty"`
	// Volume creation time
	Ctime *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=ctime" json:"ctime,omitempty"`
	// User specified VolumeSpec
	Spec *VolumeSpec `protobuf:"bytes,6,opt,name=spec" json:"spec,omitempty"`
	// Volume usage
	Usage uint64 `protobuf:"varint,7,opt,name=usage" json:"usage,omitempty"`
	// Time when an integrity check for run
	LastScan *google_protobuf.Timestamp `protobuf:"bytes,8,opt,name=last_scan,json=lastScan" json:"last_scan,omitempty"`
	// Format FSType type if any
	Format FSType       `protobuf:"varint,9,opt,name=format,enum=openstorage.api.FSType" json:"format,omitempty"`
	Status VolumeStatus `protobuf:"varint,10,opt,name=status,enum=openstorage.api.VolumeStatus" json:"status,omitempty"`
	State  VolumeState  `protobuf:"varint,11,opt,name=state,enum=openstorage.api.VolumeState" json:"state,omitempty"`
	// Machine ID (node) on which this volume is attached
	// Machine ID is a node instance identifier for clustered systems.
	AttachedOn string   `protobuf:"bytes,12,opt,name=attached_on,json=attachedOn" json:"attached_on,omitempty"`
	DevicePath string   `protobuf:"bytes,14,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
	AttachPath []string `protobuf:"bytes,15,rep,name=attach_path,json=attachPath" json:"attach_path,omitempty"`
	// List of ReplicaSets which provide storage for this volume, for clustered storage arrays
	ReplicaSets []*ReplicaSet `protobuf:"bytes,16,rep,name=replica_sets,json=replicaSets" json:"replica_sets,omitempty"`
	// Last recorded error
	Error string `protobuf:"bytes,17,opt,name=error" json:"error,omitempty"`
	// List of name value mapping of driver specific runtime information.
	RuntimeState     []*RuntimeStateMap `protobuf:"bytes,18,rep,name=runtime_state,json=runtimeState" json:"runtime_state,omitempty"`
	SecureDevicePath string             `protobuf:"bytes,19,opt,name=secure_device_path,json=secureDevicePath" json:"secure_device_path,omitempty"`
	// BackgroundProcessing is true if volume is attached but not by the user
	BackgroundProcessing bool `protobuf:"varint,20,opt,name=background_processing,json=backgroundProcessing" json:"background_processing,omitempty"`
}

func (m *Volume) Reset()                    { *m = Volume{} }
func (m *Volume) String() string            { return proto.CompactTextString(m) }
func (*Volume) ProtoMessage()               {}
func (*Volume) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Volume) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Volume) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Volume) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

func (m *Volume) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *Volume) GetCtime() *google_protobuf.Timestamp {
	if m != nil {
		return m.Ctime
	}
	return nil
}

func (m *Volume) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Volume) GetUsage() uint64 {
	if m != nil {
		return m.Usage
	}
	return 0
}

func (m *Volume) GetLastScan() *google_protobuf.Timestamp {
	if m != nil {
		return m.LastScan
	}
	return nil
}

func (m *Volume) GetFormat() FSType {
	if m != nil {
		return m.Format
	}
	return FSType_FS_TYPE_NONE
}

func (m *Volume) GetStatus() VolumeStatus {
	if m != nil {
		return m.Status
	}
	return VolumeStatus_VOLUME_STATUS_NONE
}

func (m *Volume) GetState() VolumeState {
	if m != nil {
		return m.State
	}
	return VolumeState_VOLUME_STATE_NONE
}

func (m *Volume) GetAttachedOn() string {
	if m != nil {
		return m.AttachedOn
	}
	return ""
}

func (m *Volume) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

func (m *Volume) GetAttachPath() []string {
	if m != nil {
		return m.AttachPath
	}
	return nil
}

func (m *Volume) GetReplicaSets() []*ReplicaSet {
	if m != nil {
		return m.ReplicaSets
	}
	return nil
}

func (m *Volume) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *Volume) GetRuntimeState() []*RuntimeStateMap {
	if m != nil {
		return m.RuntimeState
	}
	return nil
}

func (m *Volume) GetSecureDevicePath() string {
	if m != nil {
		return m.SecureDevicePath
	}
	return ""
}

func (m *Volume) GetBackgroundProcessing() bool {
	if m != nil {
		return m.BackgroundProcessing
	}
	return false
}

type Stats struct {
	// Reads completed successfully
	Reads uint64 `protobuf:"varint,1,opt,name=reads" json:"reads,omitempty"`
	// Time spent in reads in ms
	ReadMs    uint64 `protobuf:"varint,2,opt,name=read_ms,json=readMs" json:"read_ms,omitempty"`
	ReadBytes uint64 `protobuf:"varint,3,opt,name=read_bytes,json=readBytes" json:"read_bytes,omitempty"`
	// Writes completed successfully
	Writes uint64 `protobuf:"varint,4,opt,name=writes" json:"writes,omitempty"`
	// Time spent in writes in ms
	WriteMs    uint64 `protobuf:"varint,5,opt,name=write_ms,json=writeMs" json:"write_ms,omitempty"`
	WriteBytes uint64 `protobuf:"varint,6,opt,name=write_bytes,json=writeBytes" json:"write_bytes,omitempty"`
	// IOs curently in progress
	IoProgress uint64 `protobuf:"varint,7,opt,name=io_progress,json=ioProgress" json:"io_progress,omitempty"`
	// Time spent doing IOs ms
	IoMs uint64 `protobuf:"varint,8,opt,name=io_ms,json=ioMs" json:"io_ms,omitempty"`
	// BytesUsed
	BytesUsed uint64 `protobuf:"varint,9,opt,name=bytes_used,json=bytesUsed" json:"bytes_used,omitempty"`
	// Interval in ms during which stats were collected
	IntervalMs uint64 `protobuf:"varint,10,opt,name=interval_ms,json=intervalMs" json:"interval_ms,omitempty"`
}

func (m *Stats) Reset()                    { *m = Stats{} }
func (m *Stats) String() string            { return proto.CompactTextString(m) }
func (*Stats) ProtoMessage()               {}
func (*Stats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *Stats) GetReads() uint64 {
	if m != nil {
		return m.Reads
	}
	return 0
}

func (m *Stats) GetReadMs() uint64 {
	if m != nil {
		return m.ReadMs
	}
	return 0
}

func (m *Stats) GetReadBytes() uint64 {
	if m != nil {
		return m.ReadBytes
	}
	return 0
}

func (m *Stats) GetWrites() uint64 {
	if m != nil {
		return m.Writes
	}
	return 0
}

func (m *Stats) GetWriteMs() uint64 {
	if m != nil {
		return m.WriteMs
	}
	return 0
}

func (m *Stats) GetWriteBytes() uint64 {
	if m != nil {
		return m.WriteBytes
	}
	return 0
}

func (m *Stats) GetIoProgress() uint64 {
	if m != nil {
		return m.IoProgress
	}
	return 0
}

func (m *Stats) GetIoMs() uint64 {
	if m != nil {
		return m.IoMs
	}
	return 0
}

func (m *Stats) GetBytesUsed() uint64 {
	if m != nil {
		return m.BytesUsed
	}
	return 0
}

func (m *Stats) GetIntervalMs() uint64 {
	if m != nil {
		return m.IntervalMs
	}
	return 0
}

type Alert struct {
	// Id for Alert
	Id int64 `protobuf:"varint,1,opt,name=id" json:"id,omitempty"`
	// Severity of the Alert
	Severity SeverityType `protobuf:"varint,2,opt,name=severity,enum=openstorage.api.SeverityType" json:"severity,omitempty"`
	// AlertType user defined alert type
	AlertType int64 `protobuf:"varint,3,opt,name=alert_type,json=alertType" json:"alert_type,omitempty"`
	// Message describing the Alert
	Message string `protobuf:"bytes,4,opt,name=message" json:"message,omitempty"`
	// Timestamp when Alert occured
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,5,opt,name=timestamp" json:"timestamp,omitempty"`
	// ResourceId where Alert occured
	ResourceId string `protobuf:"bytes,6,opt,name=resource_id,json=resourceId" json:"resource_id,omitempty"`
	// Resource where Alert occured
	Resource ResourceType `protobuf:"varint,7,opt,name=resource,enum=openstorage.api.ResourceType" json:"resource,omitempty"`
	// Cleared Flag
	Cleared bool `protobuf:"varint,8,opt,name=cleared" json:"cleared,omitempty"`
	// TTL in seconds for this Alert
	Ttl uint64 `protobuf:"varint,9,opt,name=ttl" json:"ttl,omitempty"`
}

func (m *Alert) Reset()                    { *m = Alert{} }
func (m *Alert) String() string            { return proto.CompactTextString(m) }
func (*Alert) ProtoMessage()               {}
func (*Alert) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Alert) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *Alert) GetSeverity() SeverityType {
	if m != nil {
		return m.Severity
	}
	return SeverityType_SEVERITY_TYPE_NONE
}

func (m *Alert) GetAlertType() int64 {
	if m != nil {
		return m.AlertType
	}
	return 0
}

func (m *Alert) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *Alert) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *Alert) GetResourceId() string {
	if m != nil {
		return m.ResourceId
	}
	return ""
}

func (m *Alert) GetResource() ResourceType {
	if m != nil {
		return m.Resource
	}
	return ResourceType_RESOURCE_TYPE_NONE
}

func (m *Alert) GetCleared() bool {
	if m != nil {
		return m.Cleared
	}
	return false
}

func (m *Alert) GetTtl() uint64 {
	if m != nil {
		return m.Ttl
	}
	return 0
}

type Alerts struct {
	Alert []*Alert `protobuf:"bytes,1,rep,name=alert" json:"alert,omitempty"`
}

func (m *Alerts) Reset()                    { *m = Alerts{} }
func (m *Alerts) String() string            { return proto.CompactTextString(m) }
func (*Alerts) ProtoMessage()               {}
func (*Alerts) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Alerts) GetAlert() []*Alert {
	if m != nil {
		return m.Alert
	}
	return nil
}

type VolumeCreateRequest struct {
	// User specified volume name and labels
	Locator *VolumeLocator `protobuf:"bytes,1,opt,name=locator" json:"locator,omitempty"`
	// Source to create volume
	Source *Source `protobuf:"bytes,2,opt,name=source" json:"source,omitempty"`
	// The storage spec for the volume
	Spec *VolumeSpec `protobuf:"bytes,3,opt,name=spec" json:"spec,omitempty"`
}

func (m *VolumeCreateRequest) Reset()                    { *m = VolumeCreateRequest{} }
func (m *VolumeCreateRequest) String() string            { return proto.CompactTextString(m) }
func (*VolumeCreateRequest) ProtoMessage()               {}
func (*VolumeCreateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *VolumeCreateRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *VolumeCreateRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *VolumeCreateRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

type VolumeResponse struct {
	Error string `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *VolumeResponse) Reset()                    { *m = VolumeResponse{} }
func (m *VolumeResponse) String() string            { return proto.CompactTextString(m) }
func (*VolumeResponse) ProtoMessage()               {}
func (*VolumeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *VolumeResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type VolumeCreateResponse struct {
	// ID of the newly created volume
	Id             string          `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	VolumeResponse *VolumeResponse `protobuf:"bytes,2,opt,name=volume_response,json=volumeResponse" json:"volume_response,omitempty"`
}

func (m *VolumeCreateResponse) Reset()                    { *m = VolumeCreateResponse{} }
func (m *VolumeCreateResponse) String() string            { return proto.CompactTextString(m) }
func (*VolumeCreateResponse) ProtoMessage()               {}
func (*VolumeCreateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *VolumeCreateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VolumeCreateResponse) GetVolumeResponse() *VolumeResponse {
	if m != nil {
		return m.VolumeResponse
	}
	return nil
}

// VolumeStateAction specifies desired actions.
type VolumeStateAction struct {
	// Attach or Detach volume
	Attach VolumeActionParam `protobuf:"varint,1,opt,name=attach,enum=openstorage.api.VolumeActionParam" json:"attach,omitempty"`
	// Mount or unmount volume
	Mount     VolumeActionParam `protobuf:"varint,2,opt,name=mount,enum=openstorage.api.VolumeActionParam" json:"mount,omitempty"`
	MountPath string            `protobuf:"bytes,3,opt,name=mount_path,json=mountPath" json:"mount_path,omitempty"`
	// Device path returned in attach
	DevicePath string `protobuf:"bytes,4,opt,name=device_path,json=devicePath" json:"device_path,omitempty"`
}

func (m *VolumeStateAction) Reset()                    { *m = VolumeStateAction{} }
func (m *VolumeStateAction) String() string            { return proto.CompactTextString(m) }
func (*VolumeStateAction) ProtoMessage()               {}
func (*VolumeStateAction) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *VolumeStateAction) GetAttach() VolumeActionParam {
	if m != nil {
		return m.Attach
	}
	return VolumeActionParam_VOLUME_ACTION_PARAM_NONE
}

func (m *VolumeStateAction) GetMount() VolumeActionParam {
	if m != nil {
		return m.Mount
	}
	return VolumeActionParam_VOLUME_ACTION_PARAM_NONE
}

func (m *VolumeStateAction) GetMountPath() string {
	if m != nil {
		return m.MountPath
	}
	return ""
}

func (m *VolumeStateAction) GetDevicePath() string {
	if m != nil {
		return m.DevicePath
	}
	return ""
}

type VolumeSetRequest struct {
	// User specified volume name and labels
	Locator *VolumeLocator `protobuf:"bytes,1,opt,name=locator" json:"locator,omitempty"`
	// The storage spec for the volume
	Spec *VolumeSpec `protobuf:"bytes,2,opt,name=spec" json:"spec,omitempty"`
	// State modification on this volume.
	Action *VolumeStateAction `protobuf:"bytes,3,opt,name=action" json:"action,omitempty"`
}

func (m *VolumeSetRequest) Reset()                    { *m = VolumeSetRequest{} }
func (m *VolumeSetRequest) String() string            { return proto.CompactTextString(m) }
func (*VolumeSetRequest) ProtoMessage()               {}
func (*VolumeSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *VolumeSetRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *VolumeSetRequest) GetSpec() *VolumeSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *VolumeSetRequest) GetAction() *VolumeStateAction {
	if m != nil {
		return m.Action
	}
	return nil
}

type VolumeSetResponse struct {
	Volume         *Volume         `protobuf:"bytes,1,opt,name=volume" json:"volume,omitempty"`
	VolumeResponse *VolumeResponse `protobuf:"bytes,2,opt,name=volume_response,json=volumeResponse" json:"volume_response,omitempty"`
}

func (m *VolumeSetResponse) Reset()                    { *m = VolumeSetResponse{} }
func (m *VolumeSetResponse) String() string            { return proto.CompactTextString(m) }
func (*VolumeSetResponse) ProtoMessage()               {}
func (*VolumeSetResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *VolumeSetResponse) GetVolume() *Volume {
	if m != nil {
		return m.Volume
	}
	return nil
}

func (m *VolumeSetResponse) GetVolumeResponse() *VolumeResponse {
	if m != nil {
		return m.VolumeResponse
	}
	return nil
}

type SnapCreateRequest struct {
	// volume id
	Id       string         `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Locator  *VolumeLocator `protobuf:"bytes,2,opt,name=locator" json:"locator,omitempty"`
	Readonly bool           `protobuf:"varint,3,opt,name=readonly" json:"readonly,omitempty"`
}

func (m *SnapCreateRequest) Reset()                    { *m = SnapCreateRequest{} }
func (m *SnapCreateRequest) String() string            { return proto.CompactTextString(m) }
func (*SnapCreateRequest) ProtoMessage()               {}
func (*SnapCreateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *SnapCreateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SnapCreateRequest) GetLocator() *VolumeLocator {
	if m != nil {
		return m.Locator
	}
	return nil
}

func (m *SnapCreateRequest) GetReadonly() bool {
	if m != nil {
		return m.Readonly
	}
	return false
}

type SnapCreateResponse struct {
	VolumeCreateResponse *VolumeCreateResponse `protobuf:"bytes,1,opt,name=volume_create_response,json=volumeCreateResponse" json:"volume_create_response,omitempty"`
}

func (m *SnapCreateResponse) Reset()                    { *m = SnapCreateResponse{} }
func (m *SnapCreateResponse) String() string            { return proto.CompactTextString(m) }
func (*SnapCreateResponse) ProtoMessage()               {}
func (*SnapCreateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *SnapCreateResponse) GetVolumeCreateResponse() *VolumeCreateResponse {
	if m != nil {
		return m.VolumeCreateResponse
	}
	return nil
}

type VolumeInfo struct {
	VolumeId string      `protobuf:"bytes,1,opt,name=volume_id,json=volumeId" json:"volume_id,omitempty"`
	Path     string      `protobuf:"bytes,2,opt,name=path" json:"path,omitempty"`
	Storage  *VolumeSpec `protobuf:"bytes,3,opt,name=storage" json:"storage,omitempty"`
}

func (m *VolumeInfo) Reset()                    { *m = VolumeInfo{} }
func (m *VolumeInfo) String() string            { return proto.CompactTextString(m) }
func (*VolumeInfo) ProtoMessage()               {}
func (*VolumeInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *VolumeInfo) GetVolumeId() string {
	if m != nil {
		return m.VolumeId
	}
	return ""
}

func (m *VolumeInfo) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *VolumeInfo) GetStorage() *VolumeSpec {
	if m != nil {
		return m.Storage
	}
	return nil
}

// GraphDriverChanges represent a list of changes between the filesystem layers
// specified by the ID and Parent.  // Parent may be an empty string, in which
// case there is no parent.
// Where the Path is the filesystem path within the layered filesystem
type GraphDriverChanges struct {
	Path string                `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Kind GraphDriverChangeType `protobuf:"varint,2,opt,name=kind,enum=openstorage.api.GraphDriverChangeType" json:"kind,omitempty"`
}

func (m *GraphDriverChanges) Reset()                    { *m = GraphDriverChanges{} }
func (m *GraphDriverChanges) String() string            { return proto.CompactTextString(m) }
func (*GraphDriverChanges) ProtoMessage()               {}
func (*GraphDriverChanges) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *GraphDriverChanges) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *GraphDriverChanges) GetKind() GraphDriverChangeType {
	if m != nil {
		return m.Kind
	}
	return GraphDriverChangeType_GRAPH_DRIVER_CHANGE_TYPE_NONE
}

type ClusterResponse struct {
	Error string `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *ClusterResponse) Reset()                    { *m = ClusterResponse{} }
func (m *ClusterResponse) String() string            { return proto.CompactTextString(m) }
func (*ClusterResponse) ProtoMessage()               {}
func (*ClusterResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ClusterResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type ActiveRequest struct {
	ReqestKV map[int64]string `protobuf:"bytes,1,rep,name=ReqestKV,json=reqestKV" json:"ReqestKV,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ActiveRequest) Reset()                    { *m = ActiveRequest{} }
func (m *ActiveRequest) String() string            { return proto.CompactTextString(m) }
func (*ActiveRequest) ProtoMessage()               {}
func (*ActiveRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ActiveRequest) GetReqestKV() map[int64]string {
	if m != nil {
		return m.ReqestKV
	}
	return nil
}

type ActiveRequests struct {
	RequestCount  int64            `protobuf:"varint,1,opt,name=RequestCount,json=requestCount" json:"RequestCount,omitempty"`
	ActiveRequest []*ActiveRequest `protobuf:"bytes,2,rep,name=ActiveRequest,json=activeRequest" json:"ActiveRequest,omitempty"`
}

func (m *ActiveRequests) Reset()                    { *m = ActiveRequests{} }
func (m *ActiveRequests) String() string            { return proto.CompactTextString(m) }
func (*ActiveRequests) ProtoMessage()               {}
func (*ActiveRequests) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *ActiveRequests) GetRequestCount() int64 {
	if m != nil {
		return m.RequestCount
	}
	return 0
}

func (m *ActiveRequests) GetActiveRequest() []*ActiveRequest {
	if m != nil {
		return m.ActiveRequest
	}
	return nil
}

func init() {
	proto.RegisterType((*StorageResource)(nil), "openstorage.api.StorageResource")
	proto.RegisterType((*VolumeLocator)(nil), "openstorage.api.VolumeLocator")
	proto.RegisterType((*Source)(nil), "openstorage.api.Source")
	proto.RegisterType((*VolumeSpec)(nil), "openstorage.api.VolumeSpec")
	proto.RegisterType((*ReplicaSet)(nil), "openstorage.api.ReplicaSet")
	proto.RegisterType((*RuntimeStateMap)(nil), "openstorage.api.RuntimeStateMap")
	proto.RegisterType((*Volume)(nil), "openstorage.api.Volume")
	proto.RegisterType((*Stats)(nil), "openstorage.api.Stats")
	proto.RegisterType((*Alert)(nil), "openstorage.api.Alert")
	proto.RegisterType((*Alerts)(nil), "openstorage.api.Alerts")
	proto.RegisterType((*VolumeCreateRequest)(nil), "openstorage.api.VolumeCreateRequest")
	proto.RegisterType((*VolumeResponse)(nil), "openstorage.api.VolumeResponse")
	proto.RegisterType((*VolumeCreateResponse)(nil), "openstorage.api.VolumeCreateResponse")
	proto.RegisterType((*VolumeStateAction)(nil), "openstorage.api.VolumeStateAction")
	proto.RegisterType((*VolumeSetRequest)(nil), "openstorage.api.VolumeSetRequest")
	proto.RegisterType((*VolumeSetResponse)(nil), "openstorage.api.VolumeSetResponse")
	proto.RegisterType((*SnapCreateRequest)(nil), "openstorage.api.SnapCreateRequest")
	proto.RegisterType((*SnapCreateResponse)(nil), "openstorage.api.SnapCreateResponse")
	proto.RegisterType((*VolumeInfo)(nil), "openstorage.api.VolumeInfo")
	proto.RegisterType((*GraphDriverChanges)(nil), "openstorage.api.GraphDriverChanges")
	proto.RegisterType((*ClusterResponse)(nil), "openstorage.api.ClusterResponse")
	proto.RegisterType((*ActiveRequest)(nil), "openstorage.api.ActiveRequest")
	proto.RegisterType((*ActiveRequests)(nil), "openstorage.api.ActiveRequests")
	proto.RegisterEnum("openstorage.api.Status", Status_name, Status_value)
	proto.RegisterEnum("openstorage.api.DriverType", DriverType_name, DriverType_value)
	proto.RegisterEnum("openstorage.api.FSType", FSType_name, FSType_value)
	proto.RegisterEnum("openstorage.api.GraphDriverChangeType", GraphDriverChangeType_name, GraphDriverChangeType_value)
	proto.RegisterEnum("openstorage.api.SeverityType", SeverityType_name, SeverityType_value)
	proto.RegisterEnum("openstorage.api.ResourceType", ResourceType_name, ResourceType_value)
	proto.RegisterEnum("openstorage.api.AlertActionType", AlertActionType_name, AlertActionType_value)
	proto.RegisterEnum("openstorage.api.VolumeActionParam", VolumeActionParam_name, VolumeActionParam_value)
	proto.RegisterEnum("openstorage.api.CosType", CosType_name, CosType_value)
	proto.RegisterEnum("openstorage.api.VolumeState", VolumeState_name, VolumeState_value)
	proto.RegisterEnum("openstorage.api.VolumeStatus", VolumeStatus_name, VolumeStatus_value)
	proto.RegisterEnum("openstorage.api.StorageMedium", StorageMedium_name, StorageMedium_value)
	proto.RegisterEnum("openstorage.api.ClusterNotify", ClusterNotify_name, ClusterNotify_value)
}

func init() { proto.RegisterFile("api/api.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2538 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x59, 0xdd, 0x72, 0xe3, 0x48,
	0x15, 0x5e, 0xf9, 0xdf, 0xc7, 0xb1, 0xa3, 0xe9, 0xc9, 0x64, 0x34, 0xff, 0x59, 0x17, 0xbb, 0xa4,
	0xcc, 0x92, 0x6c, 0x65, 0x7f, 0x18, 0x16, 0x0a, 0x4a, 0xb1, 0xe5, 0xc4, 0xac, 0xff, 0x68, 0xc9,
	0x99, 0xdd, 0xa5, 0x28, 0x95, 0xc6, 0xee, 0x49, 0xc4, 0xd8, 0x92, 0x46, 0x2d, 0x87, 0xca, 0xbe,
	0x00, 0x37, 0x14, 0x5c, 0x41, 0x15, 0x57, 0x3c, 0xc0, 0x5e, 0x51, 0x5c, 0x51, 0x3c, 0xc1, 0x5e,
	0x50, 0xc5, 0x1b, 0xf0, 0x0c, 0xbc, 0x01, 0xd5, 0x3f, 0xb2, 0x25, 0xdb, 0x99, 0xc9, 0x14, 0x7b,
	0xa7, 0xf3, 0x9d, 0xd3, 0xa7, 0xfb, 0xfc, 0x9f, 0x38, 0x50, 0x75, 0x02, 0xf7, 0xd0, 0x09, 0xdc,
	0x83, 0x20, 0xf4, 0x23, 0x1f, 0x6d, 0xfb, 0x01, 0xf1, 0x68, 0xe4, 0x87, 0xce, 0x39, 0x39, 0x70,
	0x02, 0xf7, 0xfe, 0x93, 0x73, 0xdf, 0x3f, 0x9f, 0x92, 0x43, 0xce, 0x7e, 0x3e, 0x7f, 0x71, 0x18,
	0xb9, 0x33, 0x42, 0x23, 0x67, 0x16, 0x88, 0x13, 0xf5, 0xff, 0x66, 0x60, 0xdb, 0x14, 0x07, 0x30,
	0xa1, 0xfe, 0x3c, 0x1c, 0x13, 0x54, 0x83, 0x8c, 0x3b, 0xd1, 0x94, 0x3d, 0x65, 0xbf, 0x8c, 0x33,
	0xee, 0x04, 0x21, 0xc8, 0x05, 0x4e, 0x74, 0xa1, 0x65, 0x38, 0xc2, 0xbf, 0xd1, 0xa7, 0x50, 0x98,
	0x91, 0x89, 0x3b, 0x9f, 0x69, 0xd9, 0x3d, 0x65, 0xbf, 0x76, 0xf4, 0xf8, 0x60, 0xe5, 0xea, 0x03,
	0xa9, 0xb5, 0xc7, 0xa5, 0xb0, 0x94, 0x46, 0xbb, 0x50, 0xf0, 0xbd, 0xa9, 0xeb, 0x11, 0x2d, 0xb7,
	0xa7, 0xec, 0x97, 0xb0, 0xa4, 0xd8, 0x1d, 0xae, 0x1f, 0x50, 0x2d, 0xbf, 0xa7, 0xec, 0xe7, 0x30,
	0xff, 0x46, 0x0f, 0xa0, 0x4c, 0xc9, 0x2b, 0xfb, 0xb7, 0xa1, 0x1b, 0x11, 0xad, 0xb0, 0xa7, 0xec,
	0x2b, 0xb8, 0x44, 0xc9, 0xab, 0x67, 0x8c, 0x46, 0xf7, 0x80, 0x7d, 0xdb, 0x21, 0x71, 0x26, 0x5a,
	0x91, 0xf3, 0x8a, 0x94, 0xbc, 0xc2, 0xc4, 0x99, 0xb0, 0x3b, 0x42, 0xc7, 0x9b, 0xe0, 0x67, 0x5a,
	0x89, 0x33, 0x24, 0xc5, 0xee, 0xa0, 0xee, 0xd7, 0x44, 0x2b, 0x8b, 0x3b, 0xd8, 0x37, 0xc3, 0xe6,
	0x94, 0x4c, 0x34, 0x10, 0x18, 0xfb, 0x46, 0xef, 0x41, 0x2d, 0xf4, 0x23, 0x27, 0x72, 0x7d, 0xcf,
	0xa6, 0x01, 0x21, 0x13, 0xad, 0xc2, 0x2d, 0xaf, 0xc6, 0xa8, 0xc9, 0x40, 0xf4, 0x23, 0x28, 0x4f,
	0x1d, 0x1a, 0xd9, 0x74, 0xec, 0x78, 0xda, 0xd6, 0x9e, 0xb2, 0x5f, 0x39, 0xba, 0x7f, 0x20, 0xfc,
	0x7d, 0x10, 0xfb, 0xfb, 0xc0, 0x8a, 0xfd, 0x8d, 0x4b, 0x4c, 0xd8, 0x1c, 0x3b, 0x5e, 0xfd, 0x9f,
	0x0a, 0x54, 0xcf, 0xfc, 0xe9, 0x7c, 0x46, 0xba, 0xfe, 0xd8, 0x89, 0xfc, 0x90, 0xbd, 0xc2, 0x73,
	0x66, 0x44, 0xfa, 0x9c, 0x7f, 0xa3, 0x11, 0x54, 0x2f, 0xb9, 0x90, 0x3d, 0x75, 0x9e, 0x93, 0x29,
	0xd5, 0x32, 0x7b, 0xd9, 0xfd, 0xca, 0xd1, 0x87, 0x6b, 0x8e, 0x4e, 0xa9, 0x8a, 0x29, 0x7e, 0xc4,
	0xf0, 0xa2, 0xf0, 0x0a, 0x6f, 0x5d, 0x26, 0xa0, 0xfb, 0x3f, 0x87, 0x5b, 0x6b, 0x22, 0x48, 0x85,
	0xec, 0x4b, 0x72, 0x25, 0xaf, 0x67, 0x9f, 0x68, 0x07, 0xf2, 0x97, 0xce, 0x74, 0x4e, 0x64, 0xd0,
	0x05, 0xf1, 0x59, 0xe6, 0xa9, 0x52, 0xff, 0x18, 0x0a, 0xa6, 0xc8, 0x93, 0x5d, 0x28, 0x04, 0x4e,
	0x48, 0xbc, 0x48, 0x1e, 0x94, 0x14, 0xf7, 0x33, 0xf3, 0x9a, 0xcc, 0x17, 0xf6, 0x5d, 0xff, 0x7b,
	0x1e, 0x40, 0xdc, 0x6b, 0x06, 0x64, 0x8c, 0x1e, 0x42, 0x99, 0x04, 0x17, 0x64, 0x46, 0x42, 0x67,
	0xca, 0x4f, 0x97, 0xf0, 0x12, 0x58, 0x04, 0x2a, 0x93, 0x08, 0xd4, 0x21, 0x14, 0x5e, 0xf8, 0xe1,
	0xcc, 0x89, 0x64, 0xc2, 0xdd, 0x5d, 0xf3, 0x43, 0xdb, 0xb4, 0xae, 0x02, 0x82, 0xa5, 0x18, 0x7a,
	0x04, 0xf0, 0x7c, 0xea, 0x8f, 0x5f, 0xda, 0x5c, 0x15, 0xcb, 0xb6, 0x2c, 0x2e, 0x73, 0xc4, 0x64,
	0xfa, 0xee, 0x41, 0xe9, 0xc2, 0xb1, 0xa7, 0xe4, 0x92, 0x4c, 0x79, 0xd2, 0x65, 0x71, 0xf1, 0xc2,
	0xe9, 0x32, 0x12, 0x35, 0x20, 0x3b, 0xf6, 0x29, 0xcf, 0xb8, 0xda, 0x91, 0xb6, 0x76, 0x4f, 0xd3,
	0xa7, 0xfc, 0x22, 0x26, 0xc4, 0x7c, 0x30, 0x21, 0x93, 0x79, 0x40, 0x78, 0x12, 0x96, 0xb0, 0xa4,
	0xd0, 0x0f, 0xe0, 0x16, 0xf5, 0x9c, 0x80, 0x5e, 0xf8, 0x91, 0xed, 0x7a, 0x11, 0x09, 0x2f, 0x9d,
	0x29, 0x4f, 0xc7, 0x2a, 0x56, 0x63, 0x46, 0x47, 0xe2, 0x08, 0xaf, 0x86, 0xba, 0xcc, 0x43, 0xfd,
	0xc3, 0x6b, 0x42, 0xcd, 0x3c, 0xf8, 0xa6, 0x38, 0xb3, 0x87, 0xd1, 0x0b, 0x27, 0x94, 0xa9, 0x5d,
	0xc2, 0x92, 0x42, 0x3f, 0x85, 0x4a, 0x48, 0x82, 0xa9, 0x3b, 0x76, 0x6c, 0x4a, 0x22, 0x9e, 0xd9,
	0x95, 0xa3, 0x07, 0x6b, 0x37, 0x61, 0x21, 0x63, 0x92, 0x08, 0x43, 0xb8, 0xf8, 0x66, 0x66, 0x39,
	0xe7, 0xe7, 0x21, 0x39, 0x17, 0xd5, 0x21, 0xdc, 0xb7, 0x25, 0xcc, 0x4a, 0x30, 0x84, 0x1f, 0x59,
	0x90, 0xbd, 0x71, 0x78, 0x15, 0x44, 0x64, 0xa2, 0x55, 0x65, 0x90, 0x63, 0x00, 0x3d, 0x06, 0x08,
	0x1c, 0x4a, 0x83, 0x8b, 0xd0, 0xa1, 0x44, 0xab, 0xf1, 0x5c, 0x49, 0x20, 0x29, 0x0f, 0xd2, 0xf1,
	0x05, 0x99, 0xcc, 0xa7, 0x44, 0xdb, 0xe6, 0x62, 0x0b, 0x0f, 0x9a, 0x12, 0x67, 0xe9, 0x4a, 0xc7,
	0xce, 0x94, 0x68, 0x2a, 0x7f, 0x8b, 0x20, 0xfe, 0xff, 0x5c, 0xaf, 0x03, 0x2c, 0x1d, 0xc1, 0xe4,
	0x3c, 0x7f, 0x42, 0xa8, 0xa6, 0xec, 0x65, 0x99, 0x1c, 0x27, 0xea, 0xdf, 0x28, 0xb0, 0x8d, 0xe7,
	0x1e, 0x6b, 0xac, 0x66, 0xe4, 0x44, 0xa4, 0xe7, 0x04, 0xe8, 0x19, 0x54, 0x43, 0x01, 0xd9, 0x94,
	0x61, 0xfc, 0x44, 0xe5, 0xe8, 0x68, 0xdd, 0xcd, 0xe9, 0x83, 0x29, 0x5a, 0x46, 0x35, 0x4c, 0x40,
	0xcc, 0xa2, 0x35, 0x91, 0xb7, 0xb2, 0xe8, 0xdf, 0x05, 0x28, 0x08, 0x9f, 0xac, 0xb5, 0xf9, 0x43,
	0x28, 0x88, 0x01, 0xc0, 0x4f, 0x55, 0x36, 0x54, 0x98, 0xa8, 0x7b, 0x2c, 0xc5, 0xd0, 0x7d, 0x28,
	0xb1, 0xf6, 0xeb, 0x7b, 0xd3, 0x2b, 0x5e, 0x94, 0x25, 0xbc, 0xa0, 0xd1, 0x53, 0x28, 0x4e, 0x45,
	0x47, 0xe2, 0xa5, 0x57, 0xd9, 0x30, 0x20, 0x52, 0x7d, 0x0b, 0xc7, 0xe2, 0xe8, 0x43, 0xc8, 0x8f,
	0x99, 0x81, 0xbc, 0x2a, 0x5f, 0xdf, 0x52, 0x85, 0x20, 0x3a, 0x84, 0x1c, 0x0d, 0xc8, 0x98, 0x17,
	0xec, 0xa6, 0x5c, 0x5e, 0x56, 0x0d, 0xe6, 0x82, 0xcc, 0x3d, 0x73, 0xea, 0x9c, 0x8b, 0x9a, 0xcd,
	0x61, 0x41, 0xa4, 0xfb, 0x79, 0xe9, 0xe6, 0xfd, 0x3c, 0xd1, 0x9a, 0xca, 0x37, 0x6b, 0x4d, 0x9f,
	0x40, 0x81, 0xa5, 0xc5, 0x9c, 0xf2, 0xda, 0xac, 0x1d, 0x3d, 0xba, 0xee, 0xc9, 0x5c, 0x08, 0x4b,
	0x61, 0x74, 0x04, 0x79, 0x91, 0x4d, 0x15, 0x7e, 0xea, 0xe1, 0x6b, 0x4e, 0x11, 0x2c, 0x44, 0xd1,
	0x13, 0xa8, 0x38, 0x51, 0xe4, 0xb0, 0x3a, 0xb1, 0x7d, 0x31, 0xa6, 0xca, 0x18, 0x62, 0x68, 0xe0,
	0x31, 0x81, 0x09, 0xb9, 0x74, 0xc7, 0xc4, 0xe6, 0x33, 0x5e, 0xd6, 0xa1, 0x80, 0x86, 0x6c, 0xd2,
	0x2f, 0x34, 0x08, 0x81, 0x6d, 0x9e, 0xfb, 0x52, 0x03, 0x17, 0xf8, 0x19, 0x6c, 0x25, 0x3a, 0x0a,
	0xd5, 0x54, 0x9e, 0xeb, 0xaf, 0x6d, 0x29, 0x95, 0x65, 0x4b, 0xa1, 0x2c, 0x1a, 0x24, 0x0c, 0xfd,
	0x50, 0xbb, 0x25, 0x92, 0x95, 0x13, 0xc8, 0x58, 0x2d, 0x21, 0xc4, 0xd5, 0xee, 0xbd, 0xa9, 0x84,
	0xd2, 0x05, 0x83, 0x3e, 0x00, 0x44, 0xc9, 0x78, 0x1e, 0x12, 0x3b, 0x69, 0xe5, 0x6d, 0xd9, 0x46,
	0x38, 0xa7, 0xb5, 0xb4, 0xf5, 0x23, 0xb8, 0xf3, 0xdc, 0x19, 0xbf, 0x3c, 0x0f, 0xfd, 0xb9, 0x37,
	0xb1, 0x83, 0xd0, 0x1f, 0x13, 0x4a, 0x5d, 0xef, 0x5c, 0xdb, 0xe1, 0xe9, 0xbd, 0xb3, 0x64, 0x0e,
	0x17, 0xbc, 0xfa, 0x5f, 0x33, 0x90, 0x67, 0x97, 0x71, 0x4b, 0x58, 0x01, 0x50, 0x5e, 0x54, 0x39,
	0x2c, 0x08, 0x74, 0x17, 0x8a, 0xec, 0xc3, 0x9e, 0x51, 0x39, 0xd0, 0x0a, 0x8c, 0xec, 0x51, 0x36,
	0xa1, 0x38, 0xe3, 0xf9, 0x55, 0x44, 0x28, 0xaf, 0xa0, 0x1c, 0x2e, 0x33, 0xe4, 0x98, 0x01, 0xac,
	0x83, 0xf3, 0xd5, 0x87, 0xf2, 0x0a, 0xca, 0x61, 0x49, 0xb1, 0xc9, 0xc5, 0xbf, 0x98, 0x42, 0xb1,
	0x2e, 0x15, 0x39, 0xdd, 0xa3, 0x2c, 0x56, 0x82, 0x25, 0x54, 0x16, 0x38, 0x17, 0x38, 0x24, 0x74,
	0x3e, 0x81, 0x8a, 0xeb, 0x33, 0xc3, 0xce, 0x43, 0x42, 0xa9, 0xcc, 0x7f, 0x70, 0xfd, 0xa1, 0x44,
	0xd0, 0x6d, 0xc8, 0xbb, 0x3e, 0xd3, 0x5c, 0x8a, 0x17, 0x31, 0xf1, 0x50, 0xae, 0xd0, 0xe6, 0xab,
	0x92, 0x58, 0x9f, 0xca, 0x1c, 0x19, 0xb1, 0x7d, 0x89, 0x29, 0x95, 0xa3, 0x8c, 0x9d, 0x04, 0xa9,
	0x54, 0x42, 0x3d, 0x5a, 0xff, 0x57, 0x06, 0xf2, 0xfa, 0x94, 0x84, 0x51, 0xa2, 0xe7, 0x64, 0x79,
	0xcf, 0xf9, 0x31, 0xdb, 0xe2, 0x2e, 0x49, 0xe8, 0x46, 0x57, 0xdc, 0x39, 0x9b, 0x6a, 0xc1, 0x94,
	0x02, 0xbc, 0x84, 0x16, 0xe2, 0xec, 0x51, 0x0e, 0xd3, 0x69, 0x47, 0x57, 0x01, 0xe1, 0xde, 0xcb,
	0xe2, 0x32, 0x47, 0x98, 0x20, 0xd2, 0xa0, 0x38, 0x23, 0x94, 0x57, 0x79, 0x8e, 0x47, 0x3b, 0x26,
	0xd1, 0x53, 0x28, 0x2f, 0xb6, 0xe0, 0x1b, 0x34, 0x99, 0xa5, 0x30, 0x33, 0x34, 0x94, 0x4b, 0xb2,
	0xed, 0x4e, 0xb8, 0x7b, 0xcb, 0x6c, 0x3c, 0x0a, 0xa8, 0xc3, 0xcd, 0x89, 0x29, 0xee, 0xdb, 0x4d,
	0xe6, 0xc4, 0x6b, 0xb6, 0x30, 0x27, 0x16, 0x67, 0xef, 0x1d, 0x4f, 0x09, 0x1f, 0xd8, 0x25, 0x9e,
	0x6c, 0x31, 0xc9, 0xda, 0x7b, 0x14, 0x4d, 0xa5, 0xdb, 0xd9, 0x67, 0xfd, 0x53, 0x28, 0x70, 0x77,
	0x52, 0xf4, 0x01, 0xe4, 0xb9, 0xc9, 0x72, 0xc0, 0xec, 0xae, 0xdd, 0xc6, 0xe5, 0xb0, 0x10, 0xaa,
	0xff, 0x4d, 0x81, 0xdb, 0xa2, 0x47, 0x34, 0x43, 0xc2, 0x9a, 0x04, 0x79, 0x35, 0x27, 0x34, 0x4a,
	0x36, 0x6b, 0xe5, 0xed, 0x9a, 0xf5, 0x5b, 0xcf, 0x8c, 0xb8, 0x57, 0x67, 0x6f, 0xd8, 0xab, 0xeb,
	0xef, 0x43, 0x4d, 0x60, 0x98, 0xd0, 0xc0, 0xf7, 0x28, 0x59, 0xf6, 0x0b, 0x25, 0xd1, 0x2f, 0xea,
	0x01, 0xec, 0xa4, 0x4d, 0x93, 0xd2, 0xab, 0x53, 0xee, 0x14, 0xb6, 0xe5, 0xae, 0x15, 0x4a, 0x11,
	0xf9, 0xf4, 0x27, 0xd7, 0xbc, 0x25, 0xd6, 0x84, 0x6b, 0x97, 0x29, 0xba, 0xfe, 0xad, 0x12, 0xaf,
	0x17, 0xbc, 0xd5, 0xe8, 0x63, 0xb6, 0xf9, 0xa0, 0xcf, 0xa0, 0x20, 0x7a, 0x23, 0xbf, 0xb3, 0x76,
	0x54, 0xbf, 0x46, 0xad, 0x10, 0x1f, 0x3a, 0xa1, 0x33, 0xc3, 0xf2, 0x04, 0x7a, 0x0a, 0xf9, 0x99,
	0x3f, 0xf7, 0x22, 0x59, 0x0a, 0x37, 0x39, 0x2a, 0x0e, 0xb0, 0x62, 0xe0, 0x1f, 0xa2, 0xbd, 0x65,
	0xb9, 0xb5, 0x65, 0x8e, 0xc4, 0x3d, 0x3c, 0xd9, 0xfe, 0x72, 0xab, 0x4d, 0xbe, 0xfe, 0x0f, 0x05,
	0x54, 0x69, 0x0b, 0x89, 0xbe, 0x8b, 0xb4, 0x10, 0x51, 0xce, 0xdc, 0x74, 0x22, 0x33, 0xaf, 0x71,
	0xab, 0x64, 0x62, 0xd4, 0x5f, 0x37, 0xdb, 0x84, 0xfd, 0x58, 0x9e, 0xa8, 0xff, 0x61, 0x19, 0x07,
	0xf6, 0x76, 0x19, 0xf7, 0x43, 0x28, 0x88, 0x78, 0xc9, 0xb7, 0xdf, 0xbd, 0x2e, 0xbc, 0x52, 0xec,
	0x3b, 0x4c, 0x8c, 0x2b, 0xb8, 0x65, 0x7a, 0x4e, 0x90, 0xae, 0xb1, 0xd5, 0x3c, 0x4c, 0x38, 0x37,
	0xf3, 0x76, 0xce, 0x7d, 0xcd, 0xda, 0x55, 0x7f, 0x05, 0x28, 0x79, 0xb5, 0xf4, 0xc5, 0xaf, 0x60,
	0x57, 0x9a, 0x36, 0xe6, 0x8c, 0xa5, 0x85, 0xc2, 0x37, 0xef, 0x5d, 0x73, 0x75, 0x5a, 0x0d, 0xde,
	0xb9, 0xdc, 0x80, 0xd6, 0xa3, 0xf8, 0x0f, 0xbb, 0x8e, 0xf7, 0xc2, 0x67, 0x7f, 0xb3, 0xcb, 0xab,
	0x16, 0xd6, 0x96, 0x04, 0xd0, 0xd9, 0xfc, 0x43, 0xc2, 0x27, 0x50, 0x94, 0x17, 0xdf, 0xa4, 0x27,
	0xc4, 0xb2, 0xf5, 0x09, 0xa0, 0x93, 0xd0, 0x09, 0x2e, 0x5a, 0xa1, 0x7b, 0x49, 0xc2, 0xe6, 0x85,
	0xe3, 0x9d, 0x13, 0xba, 0xb8, 0x40, 0x49, 0x5c, 0xf0, 0x19, 0xe4, 0x5e, 0xba, 0xde, 0x44, 0xd6,
	0xd4, 0xfb, 0x6b, 0xda, 0xd7, 0xd4, 0xf0, 0xc6, 0xcc, 0xcf, 0xd4, 0xbf, 0x0f, 0xdb, 0xcd, 0xe9,
	0x9c, 0x46, 0x24, 0x7c, 0x43, 0xf7, 0xf9, 0xb3, 0x02, 0x55, 0x96, 0x96, 0x97, 0x8b, 0x78, 0x9f,
	0x42, 0x09, 0x93, 0x57, 0x84, 0x46, 0x9f, 0x9f, 0xc9, 0xe6, 0xfc, 0xc1, 0x7a, 0x73, 0x4e, 0x9e,
	0x38, 0x88, 0xc5, 0xc5, 0xde, 0x5f, 0x0a, 0x25, 0x79, 0xff, 0x27, 0x50, 0x4d, 0xb1, 0x92, 0xfb,
	0x7e, 0xf6, 0x4d, 0xfb, 0xfe, 0xd7, 0x50, 0x4b, 0xdd, 0x42, 0x51, 0x1d, 0xb6, 0xe4, 0x77, 0x93,
	0xf7, 0x1a, 0xa1, 0x66, 0x2b, 0x4c, 0x60, 0xa8, 0xb5, 0x62, 0x8d, 0xfc, 0xed, 0xe1, 0xf1, 0xeb,
	0x2d, 0xc0, 0x55, 0x27, 0x49, 0x36, 0xbe, 0xcd, 0x40, 0x41, 0xac, 0xb0, 0x68, 0x1b, 0x2a, 0xa6,
	0xa5, 0x5b, 0x23, 0xd3, 0xee, 0x0f, 0xfa, 0x86, 0xfa, 0x4e, 0x02, 0xe8, 0xf4, 0x3b, 0x96, 0xaa,
	0xa0, 0x2a, 0x94, 0x25, 0x30, 0xf8, 0x5c, 0xcd, 0x20, 0x04, 0xb5, 0x98, 0x6c, 0xb7, 0xbb, 0x9d,
	0xbe, 0xa1, 0x66, 0x91, 0x0a, 0x5b, 0x12, 0x33, 0x30, 0x1e, 0x60, 0x35, 0x87, 0x34, 0xd8, 0x59,
	0xa8, 0xb5, 0xec, 0x4e, 0xdf, 0xfe, 0xe5, 0x68, 0x80, 0x47, 0x3d, 0x35, 0x8f, 0xee, 0xc2, 0x6d,
	0xc9, 0x69, 0x19, 0xcd, 0x41, 0xaf, 0xd7, 0x31, 0xcd, 0xce, 0xa0, 0xaf, 0x16, 0xd0, 0x2e, 0x20,
	0xc9, 0xe8, 0xe9, 0x9d, 0xbe, 0x65, 0xf4, 0xf5, 0x7e, 0xd3, 0x50, 0x8b, 0x89, 0x03, 0xa6, 0x35,
	0xc0, 0xfa, 0x89, 0x61, 0xb7, 0x06, 0xcf, 0xfa, 0x6a, 0x09, 0x3d, 0x80, 0xbb, 0xab, 0x0c, 0xe3,
	0x04, 0xeb, 0x2d, 0xa3, 0xa5, 0x96, 0x13, 0xa7, 0xfa, 0x86, 0xd1, 0x32, 0x6d, 0x6c, 0x1c, 0x0f,
	0x06, 0x96, 0x0a, 0xe8, 0x21, 0x68, 0x2b, 0xa7, 0xb0, 0x71, 0xac, 0x77, 0xf9, 0x65, 0x15, 0xb4,
	0x07, 0x0f, 0x57, 0x75, 0xe2, 0xce, 0x19, 0x93, 0x19, 0x76, 0xf5, 0xa6, 0xa1, 0x6e, 0xa1, 0x1a,
	0xc0, 0xe2, 0x99, 0x5f, 0xa8, 0xd5, 0xc6, 0x5f, 0x14, 0x00, 0x91, 0xa4, 0x7c, 0xbb, 0xd9, 0x01,
	0x95, 0x9f, 0xc0, 0xb6, 0xf5, 0xe5, 0xd0, 0x88, 0x9d, 0xba, 0x82, 0xb6, 0x3b, 0x5d, 0x43, 0x55,
	0xd0, 0x1d, 0xb8, 0x95, 0x44, 0x8f, 0xbb, 0x83, 0x26, 0xf3, 0xf0, 0x2e, 0xa0, 0x24, 0x3c, 0x38,
	0xfe, 0x85, 0xd1, 0xb4, 0xd4, 0x2c, 0xba, 0x07, 0x77, 0x92, 0x78, 0xb3, 0x3b, 0x32, 0x2d, 0x03,
	0x1b, 0x2d, 0x35, 0xb7, 0xaa, 0xe9, 0x04, 0xeb, 0xc3, 0x53, 0x35, 0xdf, 0xf8, 0x93, 0x02, 0x05,
	0xf1, 0x17, 0x0e, 0x0b, 0x51, 0xdb, 0x4c, 0xbd, 0xe9, 0x16, 0x54, 0x63, 0xe4, 0xd8, 0xc2, 0x6d,
	0x53, 0x55, 0x92, 0x42, 0xc6, 0x17, 0xd6, 0xc7, 0x6a, 0x26, 0x89, 0xb4, 0x47, 0x26, 0x8b, 0xf5,
	0x36, 0x54, 0x16, 0x8a, 0xda, 0xa6, 0x9a, 0x4b, 0x02, 0x67, 0x6d, 0x53, 0xcd, 0x27, 0x81, 0x2f,
	0xda, 0xa6, 0x5a, 0x48, 0x02, 0x5f, 0xb5, 0x4d, 0xb5, 0xd8, 0xf8, 0x46, 0x81, 0x3b, 0x1b, 0xab,
	0x1b, 0xbd, 0x0b, 0x8f, 0xf8, 0xe3, 0x6d, 0x69, 0x4e, 0xf3, 0x54, 0xef, 0x9f, 0x18, 0xa9, 0x77,
	0xbf, 0x07, 0xef, 0x5e, 0x2b, 0xd2, 0x1b, 0xb4, 0x3a, 0xed, 0x8e, 0xd1, 0x52, 0x15, 0x54, 0x87,
	0xc7, 0xd7, 0x8a, 0xe9, 0x2d, 0x96, 0x24, 0x19, 0xf4, 0x3d, 0xd8, 0xbb, 0x56, 0xa6, 0x65, 0x74,
	0x0d, 0xcb, 0x68, 0xa9, 0xd9, 0x46, 0x04, 0x5b, 0xc9, 0x4d, 0x97, 0x27, 0xaa, 0x71, 0x66, 0xe0,
	0x8e, 0xf5, 0x65, 0xea, 0x61, 0x2c, 0xe5, 0x52, 0xb8, 0xde, 0xd5, 0x71, 0x4f, 0x55, 0x58, 0xe0,
	0xd2, 0x8c, 0x67, 0x3a, 0xee, 0x77, 0xfa, 0x27, 0x6a, 0x86, 0xd7, 0xc9, 0x8a, 0x2e, 0xab, 0xd3,
	0xfe, 0x52, 0xcd, 0x36, 0x7e, 0xaf, 0xb0, 0x76, 0xb0, 0xdc, 0x48, 0xd9, 0xb5, 0xd8, 0x30, 0x07,
	0x23, 0xdc, 0x4c, 0xfb, 0x43, 0x83, 0x9d, 0x34, 0x7e, 0x36, 0xe8, 0x8e, 0x7a, 0x2c, 0xbf, 0x36,
	0x9c, 0x68, 0x19, 0x6a, 0x86, 0xbd, 0x27, 0x8d, 0xcb, 0x54, 0x52, 0xb3, 0xcc, 0x86, 0x34, 0x8b,
	0x7b, 0x46, 0xcd, 0x35, 0x7e, 0xa7, 0xc0, 0x36, 0x5f, 0x59, 0xc5, 0x8c, 0xe7, 0x2f, 0xba, 0x0f,
	0xbb, 0x7a, 0xd7, 0xc0, 0x96, 0xad, 0x37, 0xad, 0xce, 0xa0, 0x9f, 0x7a, 0xd5, 0x43, 0xd0, 0xd6,
	0x79, 0xc2, 0xa7, 0xaa, 0xb2, 0x99, 0xdb, 0xc4, 0x86, 0x6e, 0xb1, 0xf7, 0x6d, 0xe4, 0x8e, 0x86,
	0x2d, 0xc6, 0xcd, 0x36, 0x7e, 0x13, 0x2f, 0x15, 0x89, 0x6d, 0x8b, 0x1d, 0x11, 0x66, 0xc7, 0x67,
	0x86, 0x3a, 0xd6, 0x7b, 0xf1, 0x63, 0x1e, 0xc0, 0xdd, 0x4d, 0xdc, 0x41, 0xbb, 0xad, 0x2a, 0xcc,
	0x8a, 0x8d, 0xcc, 0xbe, 0x9a, 0x69, 0x1c, 0x41, 0x51, 0xfe, 0xa8, 0x88, 0x4a, 0x90, 0x93, 0xda,
	0x8a, 0x90, 0xed, 0x0e, 0x9e, 0xa9, 0x0a, 0x02, 0x28, 0xf4, 0x8c, 0x56, 0x67, 0xd4, 0x53, 0x33,
	0x8c, 0x7d, 0xda, 0x39, 0x39, 0x55, 0xb3, 0x8d, 0xff, 0x28, 0x50, 0x49, 0xec, 0x44, 0xac, 0x36,
	0xa5, 0x7e, 0xd6, 0x37, 0x92, 0x61, 0x4b, 0xc1, 0x43, 0xa3, 0xdf, 0x62, 0x39, 0x91, 0x7c, 0x90,
	0xe0, 0xe8, 0x67, 0x7a, 0xa7, 0xab, 0x1f, 0x77, 0x65, 0xe8, 0xd2, 0x3c, 0xcb, 0xd2, 0x9b, 0xa7,
	0x2c, 0x4d, 0xd7, 0x58, 0x2d, 0x43, 0xb2, 0x72, 0x09, 0xfb, 0x97, 0x2c, 0xab, 0x79, 0xca, 0xae,
	0xcb, 0xb3, 0x2c, 0x49, 0x31, 0x45, 0x0b, 0x2f, 0xac, 0x3d, 0x30, 0x2e, 0x88, 0x62, 0xe3, 0x8f,
	0x0a, 0x6c, 0x25, 0x7f, 0x07, 0x59, 0x51, 0xb1, 0x9c, 0x25, 0x8f, 0xe0, 0xde, 0x2a, 0x6e, 0xd9,
	0x43, 0x6c, 0x98, 0x46, 0x9f, 0x4d, 0x96, 0x1d, 0x50, 0xd3, 0xec, 0xd1, 0x50, 0xb4, 0xbf, 0x34,
	0xca, 0xdb, 0x7d, 0x76, 0xc5, 0x2d, 0x7c, 0x7e, 0xc8, 0x6e, 0x9f, 0x6b, 0xfc, 0x1a, 0xaa, 0xa9,
	0xff, 0x6a, 0x88, 0xd9, 0x20, 0x1a, 0xb8, 0x08, 0x91, 0xdd, 0xd3, 0x4f, 0xfa, 0x86, 0xd5, 0x69,
	0xaa, 0xef, 0x88, 0x49, 0x93, 0x62, 0x9a, 0x26, 0x6b, 0x19, 0x7c, 0x66, 0xa4, 0xf0, 0xfe, 0x59,
	0xcf, 0x50, 0x33, 0x8d, 0x7d, 0xa8, 0xca, 0x6d, 0xa3, 0xef, 0x47, 0xee, 0x8b, 0x2b, 0x26, 0x29,
	0x6b, 0x46, 0x16, 0xac, 0x78, 0xe4, 0x3b, 0xc7, 0x0f, 0xe1, 0xf6, 0xd8, 0x9f, 0xad, 0x4e, 0xe3,
	0xa1, 0xf2, 0x55, 0xd6, 0x09, 0xdc, 0xe7, 0x05, 0xfe, 0x57, 0xec, 0x47, 0xff, 0x0b, 0x00, 0x00,
	0xff, 0xff, 0x90, 0x7c, 0x3c, 0xe7, 0x1d, 0x1a, 0x00, 0x00,
}
