// Code generated by protoc-gen-go.
// source: google/protobuf/api.proto
// DO NOT EDIT!

package google_protobuf

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Api is a light-weight descriptor for a protocol buffer service.
type Api struct {
	// The fully qualified name of this api, including package name
	// followed by the api's simple name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The methods of this api, in unspecified order.
	Methods []*Method `protobuf:"bytes,2,rep,name=methods" json:"methods,omitempty"`
	// Any metadata attached to the API.
	Options []*Option `protobuf:"bytes,3,rep,name=options" json:"options,omitempty"`
	// A version string for this api. If specified, must have the form
	// `major-version.minor-version`, as in `1.10`. If the minor version
	// is omitted, it defaults to zero. If the entire version field is
	// empty, the major version is derived from the package name, as
	// outlined below. If the field is not empty, the version in the
	// package name will be verified to be consistent with what is
	// provided here.
	//
	// The versioning schema uses [semantic
	// versioning](http://semver.org) where the major version number
	// indicates a breaking change and the minor version an additive,
	// non-breaking change. Both version numbers are signals to users
	// what to expect from different versions, and should be carefully
	// chosen based on the product plan.
	//
	// The major version is also reflected in the package name of the
	// API, which must end in `v<major-version>`, as in
	// `google.feature.v1`. For major versions 0 and 1, the suffix can
	// be omitted. Zero major versions must only be used for
	// experimental, none-GA apis.
	//
	//
	Version string `protobuf:"bytes,4,opt,name=version" json:"version,omitempty"`
	// Source context for the protocol buffer service represented by this
	// message.
	SourceContext *SourceContext `protobuf:"bytes,5,opt,name=source_context,json=sourceContext" json:"source_context,omitempty"`
	// Included APIs. See [Mixin][].
	Mixins []*Mixin `protobuf:"bytes,6,rep,name=mixins" json:"mixins,omitempty"`
	// The source syntax of the service.
	Syntax Syntax `protobuf:"varint,7,opt,name=syntax,enum=google.protobuf.Syntax" json:"syntax,omitempty"`
}

func (m *Api) Reset()                    { *m = Api{} }
func (m *Api) String() string            { return proto.CompactTextString(m) }
func (*Api) ProtoMessage()               {}
func (*Api) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *Api) GetMethods() []*Method {
	if m != nil {
		return m.Methods
	}
	return nil
}

func (m *Api) GetOptions() []*Option {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Api) GetSourceContext() *SourceContext {
	if m != nil {
		return m.SourceContext
	}
	return nil
}

func (m *Api) GetMixins() []*Mixin {
	if m != nil {
		return m.Mixins
	}
	return nil
}

// Method represents a method of an api.
type Method struct {
	// The simple name of this method.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A URL of the input message type.
	RequestTypeUrl string `protobuf:"bytes,2,opt,name=request_type_url,json=requestTypeUrl" json:"request_type_url,omitempty"`
	// If true, the request is streamed.
	RequestStreaming bool `protobuf:"varint,3,opt,name=request_streaming,json=requestStreaming" json:"request_streaming,omitempty"`
	// The URL of the output message type.
	ResponseTypeUrl string `protobuf:"bytes,4,opt,name=response_type_url,json=responseTypeUrl" json:"response_type_url,omitempty"`
	// If true, the response is streamed.
	ResponseStreaming bool `protobuf:"varint,5,opt,name=response_streaming,json=responseStreaming" json:"response_streaming,omitempty"`
	// Any metadata attached to the method.
	Options []*Option `protobuf:"bytes,6,rep,name=options" json:"options,omitempty"`
	// The source syntax of this method.
	Syntax Syntax `protobuf:"varint,7,opt,name=syntax,enum=google.protobuf.Syntax" json:"syntax,omitempty"`
}

func (m *Method) Reset()                    { *m = Method{} }
func (m *Method) String() string            { return proto.CompactTextString(m) }
func (*Method) ProtoMessage()               {}
func (*Method) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Method) GetOptions() []*Option {
	if m != nil {
		return m.Options
	}
	return nil
}

// Declares an API to be included in this API. The including API must
// redeclare all the methods from the included API, but documentation
// and options are inherited as follows:
//
// - If after comment and whitespace stripping, the documentation
//   string of the redeclared method is empty, it will be inherited
//   from the original method.
//
// - Each annotation belonging to the service config (http,
//   visibility) which is not set in the redeclared method will be
//   inherited.
//
// - If an http annotation is inherited, the path pattern will be
//   modified as follows. Any version prefix will be replaced by the
//   version of the including API plus the [root][] path if specified.
//
// Example of a simple mixin:
//
//     package google.acl.v1;
//     service AccessControl {
//       // Get the underlying ACL object.
//       rpc GetAcl(GetAclRequest) returns (Acl) {
//         option (google.api.http).get = "/v1/{resource=**}:getAcl";
//       }
//     }
//
//     package google.storage.v2;
//     service Storage {
//       rpc GetAcl(GetAclRequest) returns (Acl);
//
//       // Get a data record.
//       rpc GetData(GetDataRequest) returns (Data) {
//         option (google.api.http).get = "/v2/{resource=**}";
//       }
//     }
//
// Example of a mixin configuration:
//
//     apis:
//     - name: google.storage.v2.Storage
//       mixins:
//       - name: google.acl.v1.AccessControl
//
// The mixin construct implies that all methods in `AccessControl` are
// also declared with same name and request/response types in
// `Storage`. A documentation generator or annotation processor will
// see the effective `Storage.GetAcl` method after inherting
// documentation and annotations as follows:
//
//     service Storage {
//       // Get the underlying ACL object.
//       rpc GetAcl(GetAclRequest) returns (Acl) {
//         option (google.api.http).get = "/v2/{resource=**}:getAcl";
//       }
//       ...
//     }
//
// Note how the version in the path pattern changed from `v1` to `v2`.
//
// If the `root` field in the mixin is specified, it should be a
// relative path under which inherited HTTP paths are placed. Example:
//
//     apis:
//     - name: google.storage.v2.Storage
//       mixins:
//       - name: google.acl.v1.AccessControl
//         root: acls
//
// This implies the following inherited HTTP annotation:
//
//     service Storage {
//       // Get the underlying ACL object.
//       rpc GetAcl(GetAclRequest) returns (Acl) {
//         option (google.api.http).get = "/v2/acls/{resource=**}:getAcl";
//       }
//       ...
//     }
type Mixin struct {
	// The fully qualified name of the API which is included.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// If non-empty specifies a path under which inherited HTTP paths
	// are rooted.
	Root string `protobuf:"bytes,2,opt,name=root" json:"root,omitempty"`
}

func (m *Mixin) Reset()                    { *m = Mixin{} }
func (m *Mixin) String() string            { return proto.CompactTextString(m) }
func (*Mixin) ProtoMessage()               {}
func (*Mixin) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func init() {
	proto.RegisterType((*Api)(nil), "google.protobuf.Api")
	proto.RegisterType((*Method)(nil), "google.protobuf.Method")
	proto.RegisterType((*Mixin)(nil), "google.protobuf.Mixin")
}

func init() { proto.RegisterFile("google/protobuf/api.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 408 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x92, 0xd1, 0x4e, 0xc2, 0x30,
	0x14, 0x86, 0xb3, 0x0d, 0x06, 0x96, 0x08, 0x5a, 0x13, 0x9d, 0x5c, 0x10, 0x42, 0xbc, 0x58, 0x34,
	0x6e, 0x11, 0x9f, 0x40, 0x8c, 0xe1, 0x82, 0x18, 0x97, 0xa1, 0xf1, 0x92, 0x0c, 0xac, 0xb8, 0x64,
	0x5b, 0x67, 0xdb, 0x29, 0xbc, 0x8d, 0xf1, 0xd2, 0x4b, 0xdf, 0xc0, 0x37, 0xb3, 0xeb, 0x56, 0xc0,
	0x81, 0x89, 0xde, 0xf5, 0x9c, 0xff, 0xeb, 0xdf, 0x73, 0xfe, 0x0d, 0x1c, 0x4e, 0x31, 0x9e, 0x06,
	0xc8, 0x8e, 0x09, 0x66, 0x78, 0x9c, 0x3c, 0xda, 0x5e, 0xec, 0x5b, 0xa2, 0x80, 0x8d, 0x4c, 0xb2,
	0xa4, 0xd4, 0x3c, 0x2a, 0xb2, 0x14, 0x27, 0x64, 0x82, 0x46, 0x13, 0x1c, 0x31, 0x34, 0x63, 0x19,
	0xd8, 0x6c, 0x16, 0x29, 0x36, 0x8f, 0x73, 0x93, 0xce, 0x97, 0x0a, 0xb4, 0x8b, 0xd8, 0x87, 0x10,
	0x94, 0x22, 0x2f, 0x44, 0x86, 0xd2, 0x56, 0xcc, 0x2d, 0x57, 0x9c, 0xe1, 0x19, 0xa8, 0x84, 0x88,
	0x3d, 0xe1, 0x07, 0x6a, 0xa8, 0x6d, 0xcd, 0xac, 0x75, 0x0f, 0xac, 0xc2, 0x00, 0xd6, 0xb5, 0xd0,
	0x5d, 0xc9, 0xa5, 0x57, 0x70, 0xcc, 0x7c, 0x1c, 0x51, 0x43, 0xfb, 0xe5, 0xca, 0x8d, 0xd0, 0x5d,
	0xc9, 0x41, 0x03, 0x54, 0x5e, 0x10, 0xa1, 0xfc, 0x6c, 0x94, 0xc4, 0xe3, 0xb2, 0x84, 0x57, 0xa0,
	0xfe, 0x73, 0x1f, 0xa3, 0xcc, 0x81, 0x5a, 0xb7, 0xb5, 0xe6, 0x39, 0x14, 0xd8, 0x65, 0x46, 0xb9,
	0xdb, 0x74, 0xb5, 0x84, 0x16, 0xd0, 0x43, 0x7f, 0xe6, 0xf3, 0x91, 0x74, 0x31, 0xd2, 0xfe, 0xfa,
	0x16, 0xa9, 0xec, 0xe6, 0x14, 0xb4, 0x81, 0x4e, 0xe7, 0x11, 0xf3, 0x66, 0x46, 0x85, 0x3f, 0x57,
	0xdf, 0xb0, 0xc2, 0x50, 0xc8, 0x6e, 0x8e, 0x75, 0x3e, 0x55, 0xa0, 0x67, 0x41, 0x6c, 0x8c, 0xd1,
	0x04, 0x3b, 0x04, 0x3d, 0x27, 0x88, 0xb2, 0x51, 0x1a, 0xfc, 0x28, 0x21, 0x01, 0xcf, 0x33, 0xd5,
	0xeb, 0x79, 0xff, 0x96, 0xb7, 0xef, 0x48, 0x00, 0x4f, 0xc0, 0xae, 0x24, 0x29, 0x23, 0xc8, 0x0b,
	0xfd, 0x68, 0xca, 0x73, 0x54, 0xcc, 0xaa, 0x2b, 0x2d, 0x86, 0xb2, 0x0f, 0x8f, 0x53, 0x98, 0xc6,
	0x3c, 0x42, 0xb4, 0xf4, 0xcd, 0x12, 0x6c, 0x48, 0x41, 0x1a, 0x9f, 0x02, 0xb8, 0x60, 0x97, 0xce,
	0x65, 0xe1, 0xbc, 0x70, 0x59, 0x5a, 0xaf, 0x7c, 0x45, 0xfd, 0x8f, 0x5f, 0xf1, 0xdf, 0xa1, 0xd9,
	0xa0, 0x2c, 0x62, 0xdf, 0x18, 0x19, 0xef, 0x11, 0x8c, 0x59, 0x1e, 0x93, 0x38, 0xf7, 0x06, 0x60,
	0x6f, 0x82, 0xc3, 0xa2, 0x6d, 0xaf, 0xca, 0xff, 0x5e, 0x27, 0x2d, 0x1c, 0xe5, 0x4d, 0x51, 0xde,
	0x55, 0xad, 0xef, 0xf4, 0x3e, 0xd4, 0x56, 0x3f, 0xc3, 0x1c, 0xf9, 0xfa, 0x3d, 0x0a, 0x82, 0x41,
	0x84, 0x5f, 0xa3, 0x34, 0x12, 0x3a, 0xd6, 0xc5, 0xfd, 0xf3, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xa4, 0x45, 0xd6, 0xc6, 0x6d, 0x03, 0x00, 0x00,
}
