package latexDraw.ui.dialog;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.AkinPoints;
import latexDraw.figures.Figure;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.DrawPanel;
import latexDraw.ui.components.LaTeXDrawComboBox;


/** 
 * This class defines the frame which allows to change the parameters of polygons.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParametersAkinPointsFrame extends AbstractParametersFrame
{
	private static final long serialVersionUID = 1L;

	public static final String NAME_INTERVAL_FIELD = "interField";//$NON-NLS-1$
	
	public static final String ACTION_CMD_OPENCB = "openCB";//$NON-NLS-1$
	
	protected JSpinner intervalField;
	
	protected LaTeXDrawComboBox typeChoice;
	
	protected JCheckBox openCB;
	
	
	/**
	 * The constructor by default.
	 */
	public ParametersAkinPointsFrame(Frame parent, DrawPanel p, boolean attachToMainFrame)
	{
		super(parent, p, attachToMainFrame);
		try
		{
	  		JTabbedPane tabbedPane = new JTabbedPane();
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		JPanel pButton  = createButtonsPanel(this);
	  		GridBagConstraints constraint = new GridBagConstraints();
	    	constraint.gridx = 0;
	     	constraint.gridy = 0;
	     	constraint.gridwidth = 1;
	     	constraint.gridheight = 1;
	     	constraint.weightx = 0.1;
	     	constraint.weighty = 0.1;
	     	constraint.fill = GridBagConstraints.NONE;
	     	constraint.anchor = GridBagConstraints.WEST;

	     	JPanel akinP = new JPanel(new GridBagLayout());
	     	constraint.gridx = 0;
	     	constraint.gridy = 0;
	     	akinP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersAkinPointsFrame.0")), constraint); //$NON-NLS-1$
	     	constraint.gridx++;
	     	SpinnerModel model = new SpinnerNumberModel(AkinPoints.DEFAULT_INTERVAL, 1, 1000,1);
	     	intervalField = new JSpinner(model);
	     	intervalField.setName(NAME_INTERVAL_FIELD);
	     	intervalField.setEditor(new JSpinner.NumberEditor(intervalField, "0"));//$NON-NLS-1$
	     	intervalField.addChangeListener(this);
	     	akinP.add(intervalField, constraint);
	     	constraint.gridx++;
	     	openCB = new JCheckBox(LaTeXDrawLang.getString1_9("ParametersAkinPointsFrame.1")); //$NON-NLS-1$
	     	openCB.setActionCommand(ACTION_CMD_OPENCB);
	     	openCB.setName(ACTION_CMD_OPENCB);
	     	openCB.addActionListener(this);
	     	akinP.add(openCB, constraint);
	     	
	     	constraint.gridx = 0;
	     	constraint.gridy++;
	     	akinP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersAkinPointsFrame.2")), constraint); //$NON-NLS-1$
	     	constraint.gridx++;
	     	typeChoice = AkinPoints.createTypeChoice(); 
	     	typeChoice.addItemListener(this);
	     	akinP.add(typeChoice, constraint);
	     	
	     	createRotationField();
	     	constraint.gridx++;
	     	akinP.add(new JLabel(LABEL_ROTATION), constraint);
	     	constraint.gridx++;
	     	akinP.add(rotationField, constraint);
	     	
	     	akinP.setBorder(new CompoundBorder( new TitledBorder(null, LaTeXDrawLang.getString1_9("ParametersAkinPointsFrame.3"),  //$NON-NLS-1$
					  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	
	     	JPanel pGeneral = new JPanel();
	     	pGeneral.setLayout(new BoxLayout(pGeneral, BoxLayout.Y_AXIS));
	     	pGeneral.add(akinP);
	     	pGeneral.add(createBordersPanel(false));
	     	pGeneral.add(createFillPanel());
	     	pGeneral.add(createHatchingPanel());
	     	
	     	JPanel pOthers = new JPanel();
	     	pOthers.setLayout(new BoxLayout(pOthers, BoxLayout.Y_AXIS));
	     	pOthers.add(createShadowPanel());
	     	pOthers.add(createGradientPanel());
	     	
	     	tabbedPane.addTab(TITLE_TABBED_PANE_GENERAL, pGeneral);
	     	tabbedPane.addTab(TITLE_TABBED_PANE_OTHERS, pOthers);
	     	BoxLayout bl = new BoxLayout(getContentPane(), BoxLayout.Y_AXIS);
	     	getContentPane().setLayout(bl);
	     	getContentPane().add(glimpsePanelZoom);
	     	getContentPane().add(tabbedPane);
			getContentPane().add(pButton);
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);
	  		
		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	
	
	
	
	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof AkinPoints))
				throw new ClassCastException();

			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}
	
	

	
	@Override
	public void setFigureFrameField() 
	{
		AkinPoints ak = (AkinPoints)figure;
		int nbPts = ak.getNbPoints();

		typeChoice.setSelectedItem(String.valueOf(ak.getType()));
		intervalField.setValue(ak.getInterval());
		intervalField.removeChangeListener(this);
		intervalField.setModel(new SpinnerNumberModel(ak.getInterval(),1,nbPts-1,1));
		intervalField.addChangeListener(this);
		openCB.setSelected(ak.isOpen());
	}
	
	
	

	@Override
	public void itemStateChanged(ItemEvent e) 
	{
		super.itemStateChanged(e);
		
		try
		{
			Object o = e.getSource();
			AkinPoints ak = (AkinPoints)glimpsePanel.getGlimpseFigure();

			if(o instanceof LaTeXDrawComboBox)
			{
				String ac = ((LaTeXDrawComboBox)o).getActionCommand();
				
				if(ac.equals(AkinPoints.LABEL_TYPE_CHOICE))
				{
					setModified(true);
					ak.setType(Integer.valueOf(((JLabel)typeChoice.getSelectedItem()).getText()).intValue());
					glimpsePanel.repaint();
					return ;
				}
				
				return ;
			}
			
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
	}



	@Override
	public void setDefaultsValues()
	{
		super.setDefaultsValues();
		
		AkinPoints ak = (AkinPoints)figure;
		
		typeChoice.setSelectedItem(String.valueOf(AkinPoints.DEFAULT_TYPE));
		intervalField.setValue(AkinPoints.DEFAULT_INTERVAL);
		ak.setOpen(AkinPoints.DEFAULT_OPEN);
		openCB.setSelected(AkinPoints.DEFAULT_OPEN);
	}




	@Override
	public void stateChanged(ChangeEvent e)
	{
		super.stateChanged(e);
		
		try
		{
			Object o = e.getSource();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				AkinPoints ak = (AkinPoints)glimpsePanel.getGlimpseFigure();
				
				if(name.equals(NAME_INTERVAL_FIELD))
				{
					setModified(true);
					ak.setInterval(Double.valueOf(((JSpinner)o).getValue().toString()).intValue());
					glimpsePanel.repaint();
					return ;
				}
				
				return ;
			}
			
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
	}



	@Override
	public void saveParameters()
	{
		super.saveParameters();
		AkinPoints ak = (AkinPoints)figure;
		
		ak.setInterval(Float.valueOf(intervalField.getValue().toString()).intValue());
		ak.setType(Float.valueOf(((JLabel)typeChoice.getSelectedItem()).getText()).intValue());
		ak.setOpen(openCB.isSelected());
		
		drawPanel.getDraw().updateBorders();
		drawPanel.updateDraw(true);
	}




	@Override
	public void actionPerformed(ActionEvent e)
	{
		super.actionPerformed(e);
		
		try
		{
			Object o = e.getSource();
			AkinPoints ak = (AkinPoints)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JCheckBox)
			{
				String label = ((JCheckBox)o).getActionCommand();
				
				if(label.equals(ACTION_CMD_OPENCB))
				{
					setModified(true);
					ak.setOpen(openCB.isSelected());
					glimpsePanel.repaint();
					
					return ;
				}
				return ;
			}
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
	}
}
