; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define i32 @eq(i32 %a, i32 %b){
; MIPS32-LABEL: eq:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $5
; MIPS32-NEXT:    sltiu $1, $1, 1
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp eq i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @ne(i32 %a, i32 %b) {
; MIPS32-LABEL: ne:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    xor $1, $4, $5
; MIPS32-NEXT:    sltu $1, $zero, $1
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ne i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @sgt(i32 %a, i32 %b) {
; MIPS32-LABEL: sgt:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $5, $4
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sgt i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @sge(i32 %a, i32 %b) {
; MIPS32-LABEL: sge:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $4, $5
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sge i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @slt(i32 %a, i32 %b) {
; MIPS32-LABEL: slt:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $4, $5
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp slt i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @sle(i32 %a, i32 %b) {
; MIPS32-LABEL: sle:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    slt $1, $5, $4
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp sle i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @ugt(i32 %a, i32 %b) {
; MIPS32-LABEL: ugt:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $5, $4
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ugt i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @uge(i32 %a, i32 %b) {
; MIPS32-LABEL: uge:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $4, $5
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp uge i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @ult(i32 %a, i32 %b) {
; MIPS32-LABEL: ult:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $4, $5
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ult i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}

define i32 @ule(i32 %a, i32 %b) {
; MIPS32-LABEL: ule:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    sltu $1, $5, $4
; MIPS32-NEXT:    xori $1, $1, 1
; MIPS32-NEXT:    ori $2, $zero, 1
; MIPS32-NEXT:    and $2, $1, $2
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %cmp = icmp ule i32 %a, %b
  %conv = zext i1 %cmp to i32
  ret i32 %conv
}
