; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32 %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64 %s

define void @test1(float* %a, float* %b) {
; RV32-LABEL: test1:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    lw a1, 0(a1)
; RV32-NEXT:    lui a2, 524288
; RV32-NEXT:    xor a1, a1, a2
; RV32-NEXT:    sw a1, 0(a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: test1:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    addi a2, zero, 1
; RV64-NEXT:    slli a2, a2, 31
; RV64-NEXT:    lw a1, 0(a1)
; RV64-NEXT:    xor a1, a1, a2
; RV64-NEXT:    sw a1, 0(a0)
; RV64-NEXT:    ret
entry:
  %0 = load float, float* %b
  %neg = fneg float %0
  store float %neg, float* %a
  ret void
}

define void @test2(double* %a, double* %b) {
; RV32-LABEL: test2:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    lw a2, 4(a1)
; RV32-NEXT:    lw a1, 0(a1)
; RV32-NEXT:    sw a1, 0(a0)
; RV32-NEXT:    lui a1, 524288
; RV32-NEXT:    xor a1, a2, a1
; RV32-NEXT:    sw a1, 4(a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: test2:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    addi a2, zero, -1
; RV64-NEXT:    slli a2, a2, 63
; RV64-NEXT:    ld a1, 0(a1)
; RV64-NEXT:    xor a1, a1, a2
; RV64-NEXT:    sd a1, 0(a0)
; RV64-NEXT:    ret
entry:
  %0 = load double, double* %b
  %neg = fneg double %0
  store double %neg, double* %a
  ret void
}

define void @test3(fp128* %a, fp128* %b) {
; RV32-LABEL: test3:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    lw a2, 12(a1)
; RV32-NEXT:    lw a3, 4(a1)
; RV32-NEXT:    lw a4, 0(a1)
; RV32-NEXT:    lw a1, 8(a1)
; RV32-NEXT:    sw a1, 8(a0)
; RV32-NEXT:    sw a4, 0(a0)
; RV32-NEXT:    sw a3, 4(a0)
; RV32-NEXT:    lui a1, 524288
; RV32-NEXT:    xor a1, a2, a1
; RV32-NEXT:    sw a1, 12(a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: test3:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    ld a2, 8(a1)
; RV64-NEXT:    ld a1, 0(a1)
; RV64-NEXT:    sd a1, 0(a0)
; RV64-NEXT:    addi a1, zero, -1
; RV64-NEXT:    slli a1, a1, 63
; RV64-NEXT:    xor a1, a2, a1
; RV64-NEXT:    sd a1, 8(a0)
; RV64-NEXT:    ret
entry:
  %0 = load fp128, fp128* %b
  %neg = fneg fp128 %0
  store fp128 %neg, fp128* %a
  ret void
}
