; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s --check-prefixes=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=haswell                                  | FileCheck %s --check-prefixes=X64-OPT,X64-HSW
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=btver2                                   | FileCheck %s --check-prefixes=X64-OPT,X64-JAG
; RUN: llc < %s -mtriple=i686-unknown -mul-constant-optimization=false                 | FileCheck %s --check-prefix=X86-NOOPT
; RUN: llc < %s -mtriple=x86_64-unknown -mul-constant-optimization=false -mcpu=haswell | FileCheck %s --check-prefixes=X64-NOOPT,HSW-NOOPT
; RUN: llc < %s -mtriple=x86_64-unknown -mul-constant-optimization=false -mcpu=btver2  | FileCheck %s --check-prefixes=X64-NOOPT,JAG-NOOPT
; RUN: llc < %s -mtriple=x86_64-unknown -mcpu=slm                                      | FileCheck %s --check-prefixes=X64-OPT,X64-SLM
; RUN: llc < %s -mtriple=x86_64-unknown -mul-constant-optimization=false -mcpu=slm     | FileCheck %s --check-prefixes=X64-NOOPT,SLM-NOOPT

define i64 @test_mul_by_1(i64 %x) nounwind {
; X86-LABEL: test_mul_by_1:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_1:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_1:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_1:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    movq %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 1
  ret i64 %mul
}

define i64 @test_mul_by_2(i64 %x) {
; X86-LABEL: test_mul_by_2:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $1, %eax, %edx
; X86-NEXT:    addl %eax, %eax
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_2:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_2:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOOPT-NEXT:    shldl $1, %eax, %edx
; X86-NOOPT-NEXT:    addl %eax, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_2:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    leaq (%rdi,%rdi), %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 2
  ret i64 %mul
}

define i64 @test_mul_by_3(i64 %x) {
; X86-LABEL: test_mul_by_3:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    movl $3, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_3:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_3:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $3, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $3, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_3:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 3
  ret i64 %mul
}

define i64 @test_mul_by_4(i64 %x) {
; X86-LABEL: test_mul_by_4:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $2, %eax, %edx
; X86-NEXT:    shll $2, %eax
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_4:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (,%rdi,4), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_4:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOOPT-NEXT:    shldl $2, %eax, %edx
; X86-NOOPT-NEXT:    shll $2, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_4:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    leaq (,%rdi,4), %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 4
  ret i64 %mul
}

define i64 @test_mul_by_5(i64 %x) {
; X86-LABEL: test_mul_by_5:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    movl $5, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_5:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_5:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $5, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $5, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_5:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 5
  ret i64 %mul
}

define i64 @test_mul_by_6(i64 %x) {
; X86-LABEL: test_mul_by_6:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    movl $6, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%edx,%ecx,2), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_6:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    addq %rdi, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_6:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $6, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $6, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_6:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $6, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 6
  ret i64 %mul
}

define i64 @test_mul_by_7(i64 %x) {
; X86-LABEL: test_mul_by_7:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (,%eax,8), %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    movl $7, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_7:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (,%rdi,8), %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_7:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $7, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $7, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_7:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $7, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 7
  ret i64 %mul
}

define i64 @test_mul_by_8(i64 %x) {
; X86-LABEL: test_mul_by_8:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $3, %eax, %edx
; X86-NEXT:    shll $3, %eax
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_8:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (,%rdi,8), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_8:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOOPT-NEXT:    shldl $3, %eax, %edx
; X86-NOOPT-NEXT:    shll $3, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_8:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    leaq (,%rdi,8), %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 8
  ret i64 %mul
}

define i64 @test_mul_by_9(i64 %x) {
; X86-LABEL: test_mul_by_9:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    movl $9, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_9:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_9:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $9, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $9, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_9:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 9
  ret i64 %mul
}

define i64 @test_mul_by_10(i64 %x) {
; X86-LABEL: test_mul_by_10:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    movl $10, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%edx,%ecx,2), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_10:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    addq %rdi, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_10:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $10, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $10, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_10:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $10, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 10
  ret i64 %mul
}

define i64 @test_mul_by_11(i64 %x) {
; X86-LABEL: test_mul_by_11:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,2), %ecx
; X86-NEXT:    movl $11, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_11:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,2), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_11:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,2), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_11:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $11, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $11, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_11:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $11, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_11:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $11, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 11
  ret i64 %mul
}

define i64 @test_mul_by_12(i64 %x) {
; X86-LABEL: test_mul_by_12:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    movl $12, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%edx,%ecx,4), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_12:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    shlq $2, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_12:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $12, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $12, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_12:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $12, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 12
  ret i64 %mul
}

define i64 @test_mul_by_13(i64 %x) {
; X86-LABEL: test_mul_by_13:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %ecx
; X86-NEXT:    movl $13, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_13:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_13:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_13:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $13, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $13, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_13:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $13, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_13:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $13, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 13
  ret i64 %mul
}

define i64 @test_mul_by_14(i64 %x) {
; X86-LABEL: test_mul_by_14:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    movl $14, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_14:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    shlq $4, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_14:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $14, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $14, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_14:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $14, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 14
  ret i64 %mul
}

define i64 @test_mul_by_15(i64 %x) {
; X86-LABEL: test_mul_by_15:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $15, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%ecx,%ecx,4), %ecx
; X86-NEXT:    leal (%ecx,%ecx,2), %ecx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_15:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-OPT-NEXT:    leaq (%rax,%rax,2), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_15:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $15, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $15, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_15:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $15, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 15
  ret i64 %mul
}

define i64 @test_mul_by_16(i64 %x) {
; X86-LABEL: test_mul_by_16:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $4, %eax, %edx
; X86-NEXT:    shll $4, %eax
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_16:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    shlq $4, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_16:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOOPT-NEXT:    shldl $4, %eax, %edx
; X86-NOOPT-NEXT:    shll $4, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_16:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    movq %rdi, %rax
; X64-NOOPT-NEXT:    shlq $4, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 16
  ret i64 %mul
}

define i64 @test_mul_by_17(i64 %x) {
; X86-LABEL: test_mul_by_17:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl $17, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_17:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    movq %rdi, %rax
; X64-HSW-NEXT:    shlq $4, %rax
; X64-HSW-NEXT:    leaq (%rax,%rdi), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_17:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    movq %rdi, %rax
; X64-JAG-NEXT:    shlq $4, %rax
; X64-JAG-NEXT:    leaq (%rax,%rdi), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_17:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $17, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $17, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_17:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $17, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_17:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    movq %rdi, %rax
; X64-SLM-NEXT:    shlq $4, %rax
; X64-SLM-NEXT:    addq %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 17
  ret i64 %mul
}

define i64 @test_mul_by_18(i64 %x) {
; X86-LABEL: test_mul_by_18:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    movl $18, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%edx,%ecx,2), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_18:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    addq %rdi, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_18:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $18, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $18, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_18:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $18, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 18
  ret i64 %mul
}

define i64 @test_mul_by_19(i64 %x) {
; X86-LABEL: test_mul_by_19:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%eax,%ecx,2), %ecx
; X86-NEXT:    movl $19, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_19:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,2), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_19:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,2), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_19:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $19, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $19, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_19:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $19, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_19:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $19, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 19
  ret i64 %mul
}

define i64 @test_mul_by_20(i64 %x) {
; X86-LABEL: test_mul_by_20:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    movl $20, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%edx,%ecx,4), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_20:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    shlq $2, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_20:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $20, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $20, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_20:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $20, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 20
  ret i64 %mul
}

define i64 @test_mul_by_21(i64 %x) {
; X86-LABEL: test_mul_by_21:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %ecx
; X86-NEXT:    movl $21, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_21:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_21:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_21:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $21, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $21, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_21:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $21, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_21:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $21, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 21
  ret i64 %mul
}

define i64 @test_mul_by_22(i64 %x) {
; X86-LABEL: test_mul_by_22:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %ecx
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl $22, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_22:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-HSW-NEXT:    addq %rdi, %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_22:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-JAG-NEXT:    addq %rdi, %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_22:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $22, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $22, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_22:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $22, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_22:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $22, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 22
  ret i64 %mul
}

define i64 @test_mul_by_23(i64 %x) {
; X86-LABEL: test_mul_by_23:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    shll $3, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    movl $23, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_23:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-HSW-NEXT:    shlq $3, %rax
; X64-HSW-NEXT:    subq %rdi, %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_23:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-JAG-NEXT:    shlq $3, %rax
; X64-JAG-NEXT:    subq %rdi, %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_23:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $23, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $23, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_23:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $23, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_23:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $23, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 23
  ret i64 %mul
}

define i64 @test_mul_by_24(i64 %x) {
; X86-LABEL: test_mul_by_24:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,2), %ecx
; X86-NEXT:    movl $24, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%edx,%ecx,8), %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_24:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    shlq $3, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,2), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_24:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $24, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $24, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_24:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $24, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 24
  ret i64 %mul
}

define i64 @test_mul_by_25(i64 %x) {
; X86-LABEL: test_mul_by_25:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $25, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%ecx,%ecx,4), %ecx
; X86-NEXT:    leal (%ecx,%ecx,4), %ecx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_25:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-OPT-NEXT:    leaq (%rax,%rax,4), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_25:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $25, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $25, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_25:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $25, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 25
  ret i64 %mul
}

define i64 @test_mul_by_26(i64 %x) {
; X86-LABEL: test_mul_by_26:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%ecx,%ecx,4), %ecx
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl $26, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_26:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-HSW-NEXT:    leaq (%rax,%rax,4), %rax
; X64-HSW-NEXT:    addq %rdi, %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_26:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-JAG-NEXT:    leaq (%rax,%rax,4), %rax
; X64-JAG-NEXT:    addq %rdi, %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_26:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $26, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $26, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_26:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $26, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_26:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $26, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 26
  ret i64 %mul
}

define i64 @test_mul_by_27(i64 %x) {
; X86-LABEL: test_mul_by_27:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl $27, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    leal (%ecx,%ecx,8), %ecx
; X86-NEXT:    leal (%ecx,%ecx,2), %ecx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_27:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-OPT-NEXT:    leaq (%rax,%rax,2), %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_27:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $27, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $27, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_27:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $27, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 27
  ret i64 %mul
}

define i64 @test_mul_by_28(i64 %x) {
; X86-LABEL: test_mul_by_28:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%ecx,%ecx,2), %ecx
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl $28, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_28:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-HSW-NEXT:    leaq (%rax,%rax,2), %rax
; X64-HSW-NEXT:    addq %rdi, %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_28:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-JAG-NEXT:    leaq (%rax,%rax,2), %rax
; X64-JAG-NEXT:    addq %rdi, %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_28:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $28, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $28, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_28:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $28, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_28:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $28, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 28
  ret i64 %mul
}

define i64 @test_mul_by_29(i64 %x) {
; X86-LABEL: test_mul_by_29:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%ecx,%ecx,2), %ecx
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    addl %eax, %ecx
; X86-NEXT:    movl $29, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_29:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-HSW-NEXT:    leaq (%rax,%rax,2), %rax
; X64-HSW-NEXT:    addq %rdi, %rax
; X64-HSW-NEXT:    addq %rdi, %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_29:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-JAG-NEXT:    leaq (%rax,%rax,2), %rax
; X64-JAG-NEXT:    addq %rdi, %rax
; X64-JAG-NEXT:    addq %rdi, %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_29:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $29, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $29, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_29:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $29, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_29:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $29, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 29
  ret i64 %mul
}

define i64 @test_mul_by_30(i64 %x) {
; X86-LABEL: test_mul_by_30:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $5, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    movl $30, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_30:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    shlq $5, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_30:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $30, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $30, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_30:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $30, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 30
  ret i64 %mul
}

define i64 @test_mul_by_31(i64 %x) {
; X86-LABEL: test_mul_by_31:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $5, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    movl $31, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_31:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    shlq $5, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_31:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $31, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $31, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_31:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $31, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 31
  ret i64 %mul
}

define i64 @test_mul_by_32(i64 %x) {
; X86-LABEL: test_mul_by_32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    shldl $5, %eax, %edx
; X86-NEXT:    shll $5, %eax
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_32:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    shlq $5, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_32:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOOPT-NEXT:    shldl $5, %eax, %edx
; X86-NOOPT-NEXT:    shll $5, %eax
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_32:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    movq %rdi, %rax
; X64-NOOPT-NEXT:    shlq $5, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 32
  ret i64 %mul
}

define i64 @test_mul_by_37(i64 %x) {
; X86-LABEL: test_mul_by_37:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%eax,%ecx,4), %ecx
; X86-NEXT:    movl $37, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_37:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_37:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,4), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_37:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $37, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $37, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_37:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $37, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_37:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $37, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 37
  ret i64 %mul
}

define i64 @test_mul_by_41(i64 %x) {
; X86-LABEL: test_mul_by_41:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,4), %ecx
; X86-NEXT:    leal (%eax,%ecx,8), %ecx
; X86-NEXT:    movl $41, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_41:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,8), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_41:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,8), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_41:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $41, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $41, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_41:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $41, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_41:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $41, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 41
  ret i64 %mul
}

define i64 @test_mul_by_62(i64 %x) {
; X86-LABEL: test_mul_by_62:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $6, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    subl %eax, %ecx
; X86-NEXT:    movl $62, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_62:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    movq %rdi, %rax
; X64-OPT-NEXT:    shlq $6, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    subq %rdi, %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_62:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $62, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $62, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_62:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $62, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 62
  ret i64 %mul
}

define i64 @test_mul_by_66(i64 %x) {
; X86-LABEL: test_mul_by_66:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $6, %ecx
; X86-NEXT:    leal (%ecx,%eax,2), %ecx
; X86-NEXT:    movl $66, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_66:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    movq %rdi, %rax
; X64-HSW-NEXT:    shlq $6, %rax
; X64-HSW-NEXT:    leaq (%rax,%rdi,2), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_66:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    movq %rdi, %rax
; X64-JAG-NEXT:    shlq $6, %rax
; X64-JAG-NEXT:    leaq (%rax,%rdi,2), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_66:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $66, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $66, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_66:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $66, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_66:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    movq %rdi, %rax
; X64-SLM-NEXT:    shlq $6, %rax
; X64-SLM-NEXT:    addq %rdi, %rax
; X64-SLM-NEXT:    addq %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 66
  ret i64 %mul
}

define i64 @test_mul_by_73(i64 %x) {
; X86-LABEL: test_mul_by_73:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    leal (%eax,%eax,8), %ecx
; X86-NEXT:    leal (%eax,%ecx,8), %ecx
; X86-NEXT:    movl $73, %eax
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_73:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-HSW-NEXT:    leaq (%rdi,%rax,8), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_73:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-JAG-NEXT:    leaq (%rdi,%rax,8), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_73:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $73, %eax
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $73, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_73:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $73, %rdi, %rax
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_73:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $73, %rdi, %rax
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 73
  ret i64 %mul
}

define i64 @test_mul_by_520(i64 %x) {
; X86-LABEL: test_mul_by_520:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shll $9, %ecx
; X86-NEXT:    leal (%ecx,%eax,8), %ecx
; X86-NEXT:    movl $520, %eax # imm = 0x208
; X86-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_by_520:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    movq %rdi, %rax
; X64-HSW-NEXT:    shlq $9, %rax
; X64-HSW-NEXT:    leaq (%rax,%rdi,8), %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_by_520:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    movq %rdi, %rax
; X64-JAG-NEXT:    shlq $9, %rax
; X64-JAG-NEXT:    leaq (%rax,%rdi,8), %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_520:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl $520, %eax # imm = 0x208
; X86-NOOPT-NEXT:    mull {{[0-9]+}}(%esp)
; X86-NOOPT-NEXT:    imull $520, {{[0-9]+}}(%esp), %ecx # imm = 0x208
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_520:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $520, %rdi, %rax # imm = 0x208
; X64-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_by_520:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    imulq $520, %rdi, %rax # imm = 0x208
; X64-SLM-NEXT:    retq
  %mul = mul nsw i64 %x, 520
  ret i64 %mul
}

define i64 @test_mul_by_neg10(i64 %x) {
; X86-LABEL: test_mul_by_neg10:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl $-10, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edx
; X86-NEXT:    subl %ecx, %edx
; X86-NEXT:    addl %esi, %esi
; X86-NEXT:    leal (%esi,%esi,4), %ecx
; X86-NEXT:    subl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_neg10:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    addq %rdi, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-OPT-NEXT:    negq %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_neg10:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    movl $-10, %edx
; X86-NOOPT-NEXT:    movl %ecx, %eax
; X86-NOOPT-NEXT:    mull %edx
; X86-NOOPT-NEXT:    subl %ecx, %edx
; X86-NOOPT-NEXT:    imull $-10, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_neg10:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $-10, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, -10
  ret i64 %mul
}

define i64 @test_mul_by_neg36(i64 %x) {
; X86-LABEL: test_mul_by_neg36:
; X86:       # %bb.0:
; X86-NEXT:    pushl %esi
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    .cfi_offset %esi, -8
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl $-36, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edx
; X86-NEXT:    subl %ecx, %edx
; X86-NEXT:    shll $2, %esi
; X86-NEXT:    leal (%esi,%esi,8), %ecx
; X86-NEXT:    subl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; X64-OPT-LABEL: test_mul_by_neg36:
; X64-OPT:       # %bb.0:
; X64-OPT-NEXT:    shlq $2, %rdi
; X64-OPT-NEXT:    leaq (%rdi,%rdi,8), %rax
; X64-OPT-NEXT:    negq %rax
; X64-OPT-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_by_neg36:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    movl $-36, %edx
; X86-NOOPT-NEXT:    movl %ecx, %eax
; X86-NOOPT-NEXT:    mull %edx
; X86-NOOPT-NEXT:    subl %ecx, %edx
; X86-NOOPT-NEXT:    imull $-36, {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    retl
;
; X64-NOOPT-LABEL: test_mul_by_neg36:
; X64-NOOPT:       # %bb.0:
; X64-NOOPT-NEXT:    imulq $-36, %rdi, %rax
; X64-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, -36
  ret i64 %mul
}

; (x*9+42)*(x*5+2)
define i64 @test_mul_spec(i64 %x) nounwind {
; X86-LABEL: test_mul_spec:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl $9, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edx
; X86-NEXT:    movl %eax, %esi
; X86-NEXT:    leal (%edi,%edi,8), %ebx
; X86-NEXT:    addl $42, %esi
; X86-NEXT:    adcl %edx, %ebx
; X86-NEXT:    movl $5, %edx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    mull %edx
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    leal (%edi,%edi,4), %edi
; X86-NEXT:    addl $2, %ecx
; X86-NEXT:    adcl %edx, %edi
; X86-NEXT:    movl %esi, %eax
; X86-NEXT:    mull %ecx
; X86-NEXT:    imull %esi, %edi
; X86-NEXT:    addl %edi, %edx
; X86-NEXT:    imull %ebx, %ecx
; X86-NEXT:    addl %ecx, %edx
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    retl
;
; X64-HSW-LABEL: test_mul_spec:
; X64-HSW:       # %bb.0:
; X64-HSW-NEXT:    leaq (%rdi,%rdi,8), %rcx
; X64-HSW-NEXT:    addq $42, %rcx
; X64-HSW-NEXT:    leaq (%rdi,%rdi,4), %rax
; X64-HSW-NEXT:    addq $2, %rax
; X64-HSW-NEXT:    imulq %rcx, %rax
; X64-HSW-NEXT:    retq
;
; X64-JAG-LABEL: test_mul_spec:
; X64-JAG:       # %bb.0:
; X64-JAG-NEXT:    leaq 42(%rdi,%rdi,8), %rcx
; X64-JAG-NEXT:    leaq 2(%rdi,%rdi,4), %rax
; X64-JAG-NEXT:    imulq %rcx, %rax
; X64-JAG-NEXT:    retq
;
; X86-NOOPT-LABEL: test_mul_spec:
; X86-NOOPT:       # %bb.0:
; X86-NOOPT-NEXT:    pushl %ebx
; X86-NOOPT-NEXT:    pushl %edi
; X86-NOOPT-NEXT:    pushl %esi
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NOOPT-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NOOPT-NEXT:    movl $9, %edx
; X86-NOOPT-NEXT:    movl %ecx, %eax
; X86-NOOPT-NEXT:    mull %edx
; X86-NOOPT-NEXT:    movl %eax, %esi
; X86-NOOPT-NEXT:    leal (%edi,%edi,8), %ebx
; X86-NOOPT-NEXT:    addl $42, %esi
; X86-NOOPT-NEXT:    adcl %edx, %ebx
; X86-NOOPT-NEXT:    movl $5, %edx
; X86-NOOPT-NEXT:    movl %ecx, %eax
; X86-NOOPT-NEXT:    mull %edx
; X86-NOOPT-NEXT:    movl %eax, %ecx
; X86-NOOPT-NEXT:    leal (%edi,%edi,4), %edi
; X86-NOOPT-NEXT:    addl $2, %ecx
; X86-NOOPT-NEXT:    adcl %edx, %edi
; X86-NOOPT-NEXT:    movl %esi, %eax
; X86-NOOPT-NEXT:    mull %ecx
; X86-NOOPT-NEXT:    imull %esi, %edi
; X86-NOOPT-NEXT:    addl %edi, %edx
; X86-NOOPT-NEXT:    imull %ebx, %ecx
; X86-NOOPT-NEXT:    addl %ecx, %edx
; X86-NOOPT-NEXT:    popl %esi
; X86-NOOPT-NEXT:    popl %edi
; X86-NOOPT-NEXT:    popl %ebx
; X86-NOOPT-NEXT:    retl
;
; HSW-NOOPT-LABEL: test_mul_spec:
; HSW-NOOPT:       # %bb.0:
; HSW-NOOPT-NEXT:    leaq (%rdi,%rdi,8), %rcx
; HSW-NOOPT-NEXT:    addq $42, %rcx
; HSW-NOOPT-NEXT:    leaq (%rdi,%rdi,4), %rax
; HSW-NOOPT-NEXT:    addq $2, %rax
; HSW-NOOPT-NEXT:    imulq %rcx, %rax
; HSW-NOOPT-NEXT:    retq
;
; JAG-NOOPT-LABEL: test_mul_spec:
; JAG-NOOPT:       # %bb.0:
; JAG-NOOPT-NEXT:    leaq 42(%rdi,%rdi,8), %rcx
; JAG-NOOPT-NEXT:    leaq 2(%rdi,%rdi,4), %rax
; JAG-NOOPT-NEXT:    imulq %rcx, %rax
; JAG-NOOPT-NEXT:    retq
;
; X64-SLM-LABEL: test_mul_spec:
; X64-SLM:       # %bb.0:
; X64-SLM-NEXT:    leaq 42(%rdi,%rdi,8), %rcx
; X64-SLM-NEXT:    leaq 2(%rdi,%rdi,4), %rax
; X64-SLM-NEXT:    imulq %rcx, %rax
; X64-SLM-NEXT:    retq
;
; SLM-NOOPT-LABEL: test_mul_spec:
; SLM-NOOPT:       # %bb.0:
; SLM-NOOPT-NEXT:    leaq 42(%rdi,%rdi,8), %rcx
; SLM-NOOPT-NEXT:    leaq 2(%rdi,%rdi,4), %rax
; SLM-NOOPT-NEXT:    imulq %rcx, %rax
; SLM-NOOPT-NEXT:    retq
  %mul = mul nsw i64 %x, 9
  %add = add nsw i64 %mul, 42
  %mul2 = mul nsw i64 %x, 5
  %add2 = add nsw i64 %mul2, 2
  %mul3 = mul nsw i64 %add, %add2
  ret i64 %mul3
}
