; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512bw,+avx512vl,+fast-variable-shuffle | FileCheck %s --check-prefixes=AVX,AVX512

declare <1 x i8> @llvm.uadd.sat.v1i8(<1 x i8>, <1 x i8>)
declare <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8>, <2 x i8>)
declare <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8>, <4 x i8>)
declare <8 x i8> @llvm.uadd.sat.v8i8(<8 x i8>, <8 x i8>)
declare <12 x i8> @llvm.uadd.sat.v12i8(<12 x i8>, <12 x i8>)
declare <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8>, <64 x i8>)

declare <1 x i16> @llvm.uadd.sat.v1i16(<1 x i16>, <1 x i16>)
declare <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16>, <2 x i16>)
declare <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16>, <8 x i16>)
declare <12 x i16> @llvm.uadd.sat.v12i16(<12 x i16>, <12 x i16>)
declare <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16>, <32 x i16>)

declare <16 x i1> @llvm.uadd.sat.v16i1(<16 x i1>, <16 x i1>)
declare <16 x i4> @llvm.uadd.sat.v16i4(<16 x i4>, <16 x i4>)

declare <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32>, <16 x i32>)
declare <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64>, <8 x i64>)

declare <4 x i24> @llvm.uadd.sat.v4i24(<4 x i24>, <4 x i24>)
declare <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128>, <2 x i128>)

; Legal types, depending on architecture.

define <16 x i8> @v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> %x, <16 x i8> %y)
  ret <16 x i8> %z
}

define <32 x i8> @v32i8(<32 x i8> %x, <32 x i8> %y) nounwind {
; SSE-LABEL: v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddusb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> %x, <32 x i8> %y)
  ret <32 x i8> %z
}

define <64 x i8> @v64i8(<64 x i8> %x, <64 x i8> %y) nounwind {
; SSE-LABEL: v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm4, %xmm0
; SSE-NEXT:    paddusb %xmm5, %xmm1
; SSE-NEXT:    paddusb %xmm6, %xmm2
; SSE-NEXT:    paddusb %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddusb %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddusb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddusb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddusb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> %x, <64 x i8> %y)
  ret <64 x i8> %z
}

define <8 x i16> @v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> %x, <8 x i16> %y)
  ret <8 x i16> %z
}

define <16 x i16> @v16i16(<16 x i16> %x, <16 x i16> %y) nounwind {
; SSE-LABEL: v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm2, %xmm0
; SSE-NEXT:    paddusw %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpaddusw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> %x, <16 x i16> %y)
  ret <16 x i16> %z
}

define <32 x i16> @v32i16(<32 x i16> %x, <32 x i16> %y) nounwind {
; SSE-LABEL: v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusw %xmm4, %xmm0
; SSE-NEXT:    paddusw %xmm5, %xmm1
; SSE-NEXT:    paddusw %xmm6, %xmm2
; SSE-NEXT:    paddusw %xmm7, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpaddusw %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpaddusw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddusw %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpaddusw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddusw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddusw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddusw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> %x, <32 x i16> %y)
  ret <32 x i16> %z
}

; Too narrow vectors, legalized by widening.

define void @v8i8(<8 x i8>* %px, <8 x i8>* %py, <8 x i8>* %pz) nounwind {
; SSE-LABEL: v8i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddusb %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v8i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512-NEXT:    vpmovwb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <8 x i8>, <8 x i8>* %px
  %y = load <8 x i8>, <8 x i8>* %py
  %z = call <8 x i8> @llvm.uadd.sat.v8i8(<8 x i8> %x, <8 x i8> %y)
  store <8 x i8> %z, <8 x i8>* %pz
  ret void
}

define void @v4i8(<4 x i8>* %px, <4 x i8>* %py, <4 x i8>* %pz) nounwind {
; SSE-LABEL: v4i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddusb %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; AVX512-NEXT:    vpmovdb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i8>, <4 x i8>* %px
  %y = load <4 x i8>, <4 x i8>* %py
  %z = call <4 x i8> @llvm.uadd.sat.v4i8(<4 x i8> %x, <4 x i8> %y)
  store <4 x i8> %z, <4 x i8>* %pz
  ret void
}

define void @v2i8(<2 x i8>* %px, <2 x i8>* %py, <2 x i8>* %pz) nounwind {
; SSE2-LABEL: v2i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movzwl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm0
; SSE2-NEXT:    movzwl (%rsi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    paddusb %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    movw %ax, (%rdx)
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i8:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movzwl (%rdi), %eax
; SSSE3-NEXT:    movd %eax, %xmm0
; SSSE3-NEXT:    movzwl (%rsi), %eax
; SSSE3-NEXT:    movd %eax, %xmm1
; SSSE3-NEXT:    paddusb %xmm0, %xmm1
; SSSE3-NEXT:    movd %xmm1, %eax
; SSSE3-NEXT:    movw %ax, (%rdx)
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movzwl (%rdi), %eax
; SSE41-NEXT:    movd %eax, %xmm0
; SSE41-NEXT:    movzwl (%rsi), %eax
; SSE41-NEXT:    movd %eax, %xmm1
; SSE41-NEXT:    paddusb %xmm0, %xmm1
; SSE41-NEXT:    pextrw $0, %xmm1, (%rdx)
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    movzwl (%rdi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm0
; AVX1-NEXT:    movzwl (%rsi), %eax
; AVX1-NEXT:    vmovd %eax, %xmm1
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movzwl (%rdi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm0
; AVX2-NEXT:    movzwl (%rsi), %eax
; AVX2-NEXT:    vmovd %eax, %xmm1
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpextrw $0, %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movzwl (%rdi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm0
; AVX512-NEXT:    movzwl (%rsi), %eax
; AVX512-NEXT:    vmovd %eax, %xmm1
; AVX512-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxbq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,zero,zero,zero,zero,xmm0[1],zero,zero,zero,zero,zero,zero,zero
; AVX512-NEXT:    vpmovqb %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i8>, <2 x i8>* %px
  %y = load <2 x i8>, <2 x i8>* %py
  %z = call <2 x i8> @llvm.uadd.sat.v2i8(<2 x i8> %x, <2 x i8> %y)
  store <2 x i8> %z, <2 x i8>* %pz
  ret void
}

define void @v4i16(<4 x i16>* %px, <4 x i16>* %py, <4 x i16>* %pz) nounwind {
; SSE-LABEL: v4i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    paddusw %xmm0, %xmm1
; SSE-NEXT:    movq %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v4i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX1-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX1-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX2-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX2-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; AVX512-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX512-NEXT:    vpmovdw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <4 x i16>, <4 x i16>* %px
  %y = load <4 x i16>, <4 x i16>* %py
  %z = call <4 x i16> @llvm.uadd.sat.v4i16(<4 x i16> %x, <4 x i16> %y)
  store <4 x i16> %z, <4 x i16>* %pz
  ret void
}

define void @v2i16(<2 x i16>* %px, <2 x i16>* %py, <2 x i16>* %pz) nounwind {
; SSE-LABEL: v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    paddusw %xmm0, %xmm1
; SSE-NEXT:    movd %xmm1, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX1-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vmovd %xmm0, (%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX2-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovd %xmm0, (%rdx)
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512-NEXT:    vpaddusw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; AVX512-NEXT:    vpmovqw %xmm0, (%rdx)
; AVX512-NEXT:    retq
  %x = load <2 x i16>, <2 x i16>* %px
  %y = load <2 x i16>, <2 x i16>* %py
  %z = call <2 x i16> @llvm.uadd.sat.v2i16(<2 x i16> %x, <2 x i16> %y)
  store <2 x i16> %z, <2 x i16>* %pz
  ret void
}

define <12 x i8> @v12i8(<12 x i8> %x, <12 x i8> %y) nounwind {
; SSE-LABEL: v12i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v12i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <12 x i8> @llvm.uadd.sat.v12i8(<12 x i8> %x, <12 x i8> %y)
  ret <12 x i8> %z
}

define void @v12i16(<12 x i16>* %px, <12 x i16>* %py, <12 x i16>* %pz) nounwind {
; SSE-LABEL: v12i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    paddusw (%rsi), %xmm0
; SSE-NEXT:    paddusw 16(%rsi), %xmm1
; SSE-NEXT:    movq %xmm1, 16(%rdx)
; SSE-NEXT:    movdqa %xmm0, (%rdx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: v12i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vpaddusw 16(%rsi), %xmm1, %xmm1
; AVX1-NEXT:    vpaddusw (%rsi), %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX1-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v12i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vpaddusw (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX2-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v12i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vpaddusw (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vmovq %xmm1, 16(%rdx)
; AVX512-NEXT:    vmovdqa %xmm0, (%rdx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %x = load <12 x i16>, <12 x i16>* %px
  %y = load <12 x i16>, <12 x i16>* %py
  %z = call <12 x i16> @llvm.uadd.sat.v12i16(<12 x i16> %x, <12 x i16> %y)
  store <12 x i16> %z, <12 x i16>* %pz
  ret void
}

; Scalarization

define void @v1i8(<1 x i8>* %px, <1 x i8>* %py, <1 x i8>* %pz) nounwind {
; SSE-LABEL: v1i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movb (%rdi), %al
; SSE-NEXT:    addb (%rsi), %al
; SSE-NEXT:    movzbl %al, %eax
; SSE-NEXT:    movl $255, %ecx
; SSE-NEXT:    cmovael %eax, %ecx
; SSE-NEXT:    movb %cl, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i8:
; AVX:       # %bb.0:
; AVX-NEXT:    movb (%rdi), %al
; AVX-NEXT:    addb (%rsi), %al
; AVX-NEXT:    movzbl %al, %eax
; AVX-NEXT:    movl $255, %ecx
; AVX-NEXT:    cmovael %eax, %ecx
; AVX-NEXT:    movb %cl, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i8>, <1 x i8>* %px
  %y = load <1 x i8>, <1 x i8>* %py
  %z = call <1 x i8> @llvm.uadd.sat.v1i8(<1 x i8> %x, <1 x i8> %y)
  store <1 x i8> %z, <1 x i8>* %pz
  ret void
}

define void @v1i16(<1 x i16>* %px, <1 x i16>* %py, <1 x i16>* %pz) nounwind {
; SSE-LABEL: v1i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movzwl (%rdi), %eax
; SSE-NEXT:    addw (%rsi), %ax
; SSE-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; SSE-NEXT:    cmovael %eax, %ecx
; SSE-NEXT:    movw %cx, (%rdx)
; SSE-NEXT:    retq
;
; AVX-LABEL: v1i16:
; AVX:       # %bb.0:
; AVX-NEXT:    movzwl (%rdi), %eax
; AVX-NEXT:    addw (%rsi), %ax
; AVX-NEXT:    movl $65535, %ecx # imm = 0xFFFF
; AVX-NEXT:    cmovael %eax, %ecx
; AVX-NEXT:    movw %cx, (%rdx)
; AVX-NEXT:    retq
  %x = load <1 x i16>, <1 x i16>* %px
  %y = load <1 x i16>, <1 x i16>* %py
  %z = call <1 x i16> @llvm.uadd.sat.v1i16(<1 x i16> %x, <1 x i16> %y)
  store <1 x i16> %z, <1 x i16>* %pz
  ret void
}

; Promotion

define <16 x i4> @v16i4(<16 x i4> %x, <16 x i4> %y) nounwind {
; SSE-LABEL: v16i4:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $4, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $4, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    psrlw $4, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: v16i4:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsllw $4, %xmm1, %xmm1
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = [240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240]
; AVX-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrlw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    retq
  %z = call <16 x i4> @llvm.uadd.sat.v16i4(<16 x i4> %x, <16 x i4> %y)
  ret <16 x i4> %z
}

define <16 x i1> @v16i1(<16 x i1> %x, <16 x i1> %y) nounwind {
; SSE-LABEL: v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    psllw $7, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    psllw $7, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddusb %xmm1, %xmm0
; SSE-NEXT:    psrlw $7, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX1-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128]
; AVX2-NEXT:    vpand %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddusb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlw $7, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $7, %xmm1, %xmm1
; AVX512-NEXT:    vpmovb2m %xmm1, %k0
; AVX512-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512-NEXT:    vpmovb2m %xmm0, %k1
; AVX512-NEXT:    korw %k0, %k1, %k0
; AVX512-NEXT:    vpmovm2b %k0, %xmm0
; AVX512-NEXT:    retq
  %z = call <16 x i1> @llvm.uadd.sat.v16i1(<16 x i1> %x, <16 x i1> %y)
  ret <16 x i1> %z
}

; Expanded

define <2 x i32> @v2i32(<2 x i32> %x, <2 x i32> %y) nounwind {
; SSE2-LABEL: v2i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllq $32, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    psllq $32, %xmm1
; SSE2-NEXT:    paddq %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,2,2]
; SSE2-NEXT:    pand %xmm2, %xmm3
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    psrlq $32, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    psllq $32, %xmm0
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSSE3-NEXT:    psllq $32, %xmm1
; SSSE3-NEXT:    paddq %xmm0, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm0
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,2,2]
; SSSE3-NEXT:    pand %xmm2, %xmm3
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    por %xmm3, %xmm0
; SSSE3-NEXT:    psrlq $32, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    psllq $32, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    psllq $32, %xmm1
; SSE41-NEXT:    paddq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pand %xmm4, %xmm2
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    psrlq $32, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; AVX2-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm1
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllq $32, %xmm0, %xmm0
; AVX512-NEXT:    vpsllq $32, %xmm1, %xmm1
; AVX512-NEXT:    vmovdqa %xmm1, %xmm2
; AVX512-NEXT:    vpternlogq $15, %xmm1, %xmm1, %xmm2
; AVX512-NEXT:    vpminuq %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpsrlq $32, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %z = call <2 x i32> @llvm.uadd.sat.v2i32(<2 x i32> %x, <2 x i32> %y)
  ret <2 x i32> %z
}

define <4 x i32> @v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE2-LABEL: v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    paddd %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    paddd %xmm0, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm0
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    pminud %xmm2, %xmm0
; SSE41-NEXT:    paddd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm2, %xmm1, %xmm2
; AVX1-NEXT:    vpminud %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpxor %xmm2, %xmm1, %xmm2
; AVX2-NEXT:    vpminud %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa %xmm1, %xmm2
; AVX512-NEXT:    vpternlogq $15, %xmm1, %xmm1, %xmm2
; AVX512-NEXT:    vpminud %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %z = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> %x, <4 x i32> %y)
  ret <4 x i32> %z
}

define <8 x i32> @v8i32(<8 x i32> %x, <8 x i32> %y) nounwind {
; SSE2-LABEL: v8i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    paddd %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    paddd %xmm1, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v8i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    paddd %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm0
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    paddd %xmm1, %xmm3
; SSSE3-NEXT:    pxor %xmm4, %xmm1
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm1
; SSSE3-NEXT:    por %xmm3, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v8i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm4, %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm5
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    pminud %xmm5, %xmm0
; SSE41-NEXT:    paddd %xmm2, %xmm0
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    pminud %xmm4, %xmm1
; SSE41-NEXT:    paddd %xmm3, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vcmptrueps %ymm2, %ymm2, %ymm2
; AVX1-NEXT:    vxorps %ymm2, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpminud %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpaddd %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpminud %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpminud %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512-NEXT:    vpternlogq $15, %ymm1, %ymm1, %ymm2
; AVX512-NEXT:    vpminud %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> %x, <8 x i32> %y)
  ret <8 x i32> %z
}

define <16 x i32> @v16i32(<16 x i32> %x, <16 x i32> %y) nounwind {
; SSE2-LABEL: v16i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [2147483648,2147483648,2147483648,2147483648]
; SSE2-NEXT:    paddd %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm0
; SSE2-NEXT:    movdqa %xmm4, %xmm9
; SSE2-NEXT:    pxor %xmm8, %xmm9
; SSE2-NEXT:    pcmpgtd %xmm9, %xmm0
; SSE2-NEXT:    por %xmm4, %xmm0
; SSE2-NEXT:    paddd %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm1
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    paddd %xmm2, %xmm6
; SSE2-NEXT:    pxor %xmm8, %xmm2
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE2-NEXT:    por %xmm6, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm7
; SSE2-NEXT:    pxor %xmm8, %xmm3
; SSE2-NEXT:    pxor %xmm7, %xmm8
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm3
; SSE2-NEXT:    por %xmm7, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v16i32:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm8 = [2147483648,2147483648,2147483648,2147483648]
; SSSE3-NEXT:    paddd %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm0
; SSSE3-NEXT:    movdqa %xmm4, %xmm9
; SSSE3-NEXT:    pxor %xmm8, %xmm9
; SSSE3-NEXT:    pcmpgtd %xmm9, %xmm0
; SSSE3-NEXT:    por %xmm4, %xmm0
; SSSE3-NEXT:    paddd %xmm1, %xmm5
; SSSE3-NEXT:    pxor %xmm8, %xmm1
; SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm1
; SSSE3-NEXT:    por %xmm5, %xmm1
; SSSE3-NEXT:    paddd %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm8, %xmm2
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm2
; SSSE3-NEXT:    por %xmm6, %xmm2
; SSSE3-NEXT:    paddd %xmm3, %xmm7
; SSSE3-NEXT:    pxor %xmm8, %xmm3
; SSSE3-NEXT:    pxor %xmm7, %xmm8
; SSSE3-NEXT:    pcmpgtd %xmm8, %xmm3
; SSSE3-NEXT:    por %xmm7, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v16i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm8, %xmm8
; SSE41-NEXT:    movdqa %xmm4, %xmm9
; SSE41-NEXT:    pxor %xmm8, %xmm9
; SSE41-NEXT:    pminud %xmm9, %xmm0
; SSE41-NEXT:    paddd %xmm4, %xmm0
; SSE41-NEXT:    movdqa %xmm5, %xmm4
; SSE41-NEXT:    pxor %xmm8, %xmm4
; SSE41-NEXT:    pminud %xmm4, %xmm1
; SSE41-NEXT:    paddd %xmm5, %xmm1
; SSE41-NEXT:    movdqa %xmm6, %xmm4
; SSE41-NEXT:    pxor %xmm8, %xmm4
; SSE41-NEXT:    pminud %xmm4, %xmm2
; SSE41-NEXT:    paddd %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm7, %xmm8
; SSE41-NEXT:    pminud %xmm8, %xmm3
; SSE41-NEXT:    paddd %xmm7, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vcmptrueps %ymm4, %ymm4, %ymm4
; AVX1-NEXT:    vxorps %ymm4, %ymm2, %ymm5
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vpminud %xmm6, %xmm7, %xmm6
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm7
; AVX1-NEXT:    vpaddd %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vpminud %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm4, %ymm3, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpminud %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vpaddd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpminud %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm2, %ymm5
; AVX2-NEXT:    vpminud %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm2
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-NEXT:    vpternlogq $15, %zmm1, %zmm1, %zmm2
; AVX512-NEXT:    vpminud %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> %x, <16 x i32> %y)
  ret <16 x i32> %z
}

define <2 x i64> @v2i64(<2 x i64> %x, <2 x i64> %y) nounwind {
; SSE2-LABEL: v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    paddq %xmm0, %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,3,3]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v2i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSSE3-NEXT:    paddq %xmm0, %xmm1
; SSSE3-NEXT:    pxor %xmm2, %xmm0
; SSSE3-NEXT:    pxor %xmm1, %xmm2
; SSSE3-NEXT:    movdqa %xmm0, %xmm3
; SSSE3-NEXT:    pcmpgtd %xmm2, %xmm3
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm0, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSSE3-NEXT:    pand %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,3,3]
; SSSE3-NEXT:    por %xmm1, %xmm0
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    paddq %xmm0, %xmm1
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pxor %xmm2, %xmm3
; SSE41-NEXT:    pxor %xmm1, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm2, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE41-NEXT:    pand %xmm4, %xmm2
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE41-NEXT:    blendvpd %xmm0, %xmm2, %xmm1
; SSE41-NEXT:    movapd %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm2, %xmm0, %xmm1
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm3
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm3, %xmm1
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa %xmm1, %xmm2
; AVX512-NEXT:    vpternlogq $15, %xmm1, %xmm1, %xmm2
; AVX512-NEXT:    vpminuq %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %z = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> %x, <2 x i64> %y)
  ret <2 x i64> %z
}

define <4 x i64> @v4i64(<4 x i64> %x, <4 x i64> %y) nounwind {
; SSE2-LABEL: v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    paddq %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pxor %xmm4, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE2-NEXT:    pand %xmm7, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    paddq %xmm1, %xmm3
; SSE2-NEXT:    pxor %xmm4, %xmm1
; SSE2-NEXT:    pxor %xmm3, %xmm4
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-NEXT:    por %xmm3, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v4i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; SSSE3-NEXT:    paddq %xmm0, %xmm2
; SSSE3-NEXT:    pxor %xmm4, %xmm0
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pxor %xmm4, %xmm5
; SSSE3-NEXT:    movdqa %xmm0, %xmm6
; SSSE3-NEXT:    pcmpgtd %xmm5, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm0, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSSE3-NEXT:    pand %xmm7, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSSE3-NEXT:    por %xmm2, %xmm0
; SSSE3-NEXT:    por %xmm5, %xmm0
; SSSE3-NEXT:    paddq %xmm1, %xmm3
; SSSE3-NEXT:    pxor %xmm4, %xmm1
; SSSE3-NEXT:    pxor %xmm3, %xmm4
; SSSE3-NEXT:    movdqa %xmm1, %xmm2
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm2
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm2[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSSE3-NEXT:    por %xmm3, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v4i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    paddq %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm0, %xmm5
; SSE41-NEXT:    pxor %xmm4, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm6
; SSE41-NEXT:    pxor %xmm4, %xmm6
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE41-NEXT:    pand %xmm7, %xmm5
; SSE41-NEXT:    por %xmm5, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm5, %xmm5
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm2
; SSE41-NEXT:    paddq %xmm1, %xmm3
; SSE41-NEXT:    pxor %xmm4, %xmm1
; SSE41-NEXT:    pxor %xmm3, %xmm4
; SSE41-NEXT:    movdqa %xmm1, %xmm6
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE41-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE41-NEXT:    pand %xmm7, %xmm0
; SSE41-NEXT:    por %xmm6, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm5, %xmm3
; SSE41-NEXT:    movapd %xmm2, %xmm0
; SSE41-NEXT:    movapd %xmm3, %xmm1
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vcmptrueps %ymm4, %ymm4, %ymm4
; AVX1-NEXT:    vxorps %ymm4, %ymm1, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpxor %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm0, %xmm5
; AVX1-NEXT:    vxorps %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vblendvpd %ymm2, %ymm0, %ymm4, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm3, %ymm3
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm3, %ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa %ymm1, %ymm2
; AVX512-NEXT:    vpternlogq $15, %ymm1, %ymm1, %ymm2
; AVX512-NEXT:    vpminuq %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %z = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> %x, <4 x i64> %y)
  ret <4 x i64> %z
}

define <8 x i64> @v8i64(<8 x i64> %x, <8 x i64> %y) nounwind {
; SSE2-LABEL: v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [9223372039002259456,9223372039002259456]
; SSE2-NEXT:    paddq %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm0
; SSE2-NEXT:    movdqa %xmm4, %xmm9
; SSE2-NEXT:    pxor %xmm8, %xmm9
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    pcmpgtd %xmm9, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[1,1,3,3]
; SSE2-NEXT:    pand %xmm11, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[1,1,3,3]
; SSE2-NEXT:    por %xmm4, %xmm0
; SSE2-NEXT:    por %xmm9, %xmm0
; SSE2-NEXT:    paddq %xmm1, %xmm5
; SSE2-NEXT:    pxor %xmm8, %xmm1
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm4
; SSE2-NEXT:    movdqa %xmm1, %xmm9
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm10, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[1,1,3,3]
; SSE2-NEXT:    por %xmm5, %xmm1
; SSE2-NEXT:    por %xmm4, %xmm1
; SSE2-NEXT:    paddq %xmm2, %xmm6
; SSE2-NEXT:    pxor %xmm8, %xmm2
; SSE2-NEXT:    movdqa %xmm6, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm4
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pand %xmm9, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE2-NEXT:    por %xmm6, %xmm2
; SSE2-NEXT:    por %xmm4, %xmm2
; SSE2-NEXT:    paddq %xmm3, %xmm7
; SSE2-NEXT:    pxor %xmm8, %xmm3
; SSE2-NEXT:    pxor %xmm7, %xmm8
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pcmpgtd %xmm8, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[1,1,3,3]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE2-NEXT:    por %xmm7, %xmm3
; SSE2-NEXT:    por %xmm6, %xmm3
; SSE2-NEXT:    retq
;
; SSSE3-LABEL: v8i64:
; SSSE3:       # %bb.0:
; SSSE3-NEXT:    movdqa {{.*#+}} xmm8 = [9223372039002259456,9223372039002259456]
; SSSE3-NEXT:    paddq %xmm0, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm0
; SSSE3-NEXT:    movdqa %xmm4, %xmm9
; SSSE3-NEXT:    pxor %xmm8, %xmm9
; SSSE3-NEXT:    movdqa %xmm0, %xmm10
; SSSE3-NEXT:    pcmpgtd %xmm9, %xmm10
; SSSE3-NEXT:    pshufd {{.*#+}} xmm11 = xmm10[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm0, %xmm9
; SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[1,1,3,3]
; SSSE3-NEXT:    pand %xmm11, %xmm9
; SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm10[1,1,3,3]
; SSSE3-NEXT:    por %xmm4, %xmm0
; SSSE3-NEXT:    por %xmm9, %xmm0
; SSSE3-NEXT:    paddq %xmm1, %xmm5
; SSSE3-NEXT:    pxor %xmm8, %xmm1
; SSSE3-NEXT:    movdqa %xmm5, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm4
; SSSE3-NEXT:    movdqa %xmm1, %xmm9
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm9
; SSSE3-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm1, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm10, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm1 = xmm9[1,1,3,3]
; SSSE3-NEXT:    por %xmm5, %xmm1
; SSSE3-NEXT:    por %xmm4, %xmm1
; SSSE3-NEXT:    paddq %xmm2, %xmm6
; SSSE3-NEXT:    pxor %xmm8, %xmm2
; SSSE3-NEXT:    movdqa %xmm6, %xmm4
; SSSE3-NEXT:    pxor %xmm8, %xmm4
; SSSE3-NEXT:    movdqa %xmm2, %xmm5
; SSSE3-NEXT:    pcmpgtd %xmm4, %xmm5
; SSSE3-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm2, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSSE3-NEXT:    pand %xmm9, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSSE3-NEXT:    por %xmm6, %xmm2
; SSSE3-NEXT:    por %xmm4, %xmm2
; SSSE3-NEXT:    paddq %xmm3, %xmm7
; SSSE3-NEXT:    pxor %xmm8, %xmm3
; SSSE3-NEXT:    pxor %xmm7, %xmm8
; SSSE3-NEXT:    movdqa %xmm3, %xmm4
; SSSE3-NEXT:    pcmpgtd %xmm8, %xmm4
; SSSE3-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSSE3-NEXT:    pcmpeqd %xmm3, %xmm8
; SSSE3-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[1,1,3,3]
; SSSE3-NEXT:    pand %xmm5, %xmm6
; SSSE3-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSSE3-NEXT:    por %xmm7, %xmm3
; SSSE3-NEXT:    por %xmm6, %xmm3
; SSSE3-NEXT:    retq
;
; SSE41-LABEL: v8i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm7, %xmm8
; SSE41-NEXT:    movdqa %xmm6, %xmm10
; SSE41-NEXT:    movdqa %xmm5, %xmm11
; SSE41-NEXT:    movdqa %xmm4, %xmm12
; SSE41-NEXT:    movdqa {{.*#+}} xmm7 = [9223372039002259456,9223372039002259456]
; SSE41-NEXT:    paddq %xmm0, %xmm12
; SSE41-NEXT:    movdqa %xmm0, %xmm6
; SSE41-NEXT:    pxor %xmm7, %xmm6
; SSE41-NEXT:    movdqa %xmm12, %xmm4
; SSE41-NEXT:    pxor %xmm7, %xmm4
; SSE41-NEXT:    movdqa %xmm6, %xmm0
; SSE41-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm4
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm9, %xmm9
; SSE41-NEXT:    blendvpd %xmm0, %xmm9, %xmm12
; SSE41-NEXT:    paddq %xmm1, %xmm11
; SSE41-NEXT:    pxor %xmm7, %xmm1
; SSE41-NEXT:    movdqa %xmm11, %xmm0
; SSE41-NEXT:    pxor %xmm7, %xmm0
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm5, %xmm0
; SSE41-NEXT:    por %xmm4, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm9, %xmm11
; SSE41-NEXT:    paddq %xmm2, %xmm10
; SSE41-NEXT:    pxor %xmm7, %xmm2
; SSE41-NEXT:    movdqa %xmm10, %xmm0
; SSE41-NEXT:    pxor %xmm7, %xmm0
; SSE41-NEXT:    movdqa %xmm2, %xmm1
; SSE41-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; SSE41-NEXT:    pand %xmm4, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm9, %xmm10
; SSE41-NEXT:    paddq %xmm3, %xmm8
; SSE41-NEXT:    pxor %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm8, %xmm7
; SSE41-NEXT:    movdqa %xmm3, %xmm1
; SSE41-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[0,0,2,2]
; SSE41-NEXT:    pcmpeqd %xmm3, %xmm7
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm7[1,1,3,3]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm9, %xmm8
; SSE41-NEXT:    movapd %xmm12, %xmm0
; SSE41-NEXT:    movapd %xmm11, %xmm1
; SSE41-NEXT:    movapd %xmm10, %xmm2
; SSE41-NEXT:    movapd %xmm8, %xmm3
; SSE41-NEXT:    retq
;
; AVX1-LABEL: v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; AVX1-NEXT:    vpxor %xmm4, %xmm5, %xmm5
; AVX1-NEXT:    vxorps %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vcmptrueps %ymm6, %ymm6, %ymm8
; AVX1-NEXT:    vxorps %ymm8, %ymm2, %ymm7
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm6
; AVX1-NEXT:    vpxor %xmm4, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm9
; AVX1-NEXT:    vpxor %xmm4, %xmm0, %xmm6
; AVX1-NEXT:    vxorps %xmm4, %xmm7, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm9, %ymm5, %ymm5
; AVX1-NEXT:    vblendvpd %ymm5, %ymm0, %ymm7, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vpaddq %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vxorps %ymm8, %ymm3, %ymm5
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm6
; AVX1-NEXT:    vpxor %xmm4, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpxor %xmm4, %xmm1, %xmm6
; AVX1-NEXT:    vxorps %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpcmpgtq %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm2
; AVX1-NEXT:    vblendvpd %ymm2, %ymm1, %ymm5, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpaddq %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm4, %ymm0, %ymm5
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm6 = [9223372036854775807,9223372036854775807,9223372036854775807,9223372036854775807]
; AVX2-NEXT:    vpxor %ymm6, %ymm2, %ymm7
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm7, %ymm5
; AVX2-NEXT:    vpcmpeqd %ymm7, %ymm7, %ymm7
; AVX2-NEXT:    vpxor %ymm7, %ymm2, %ymm8
; AVX2-NEXT:    vblendvpd %ymm5, %ymm0, %ymm8, %ymm0
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm4, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm6, %ymm3, %ymm4
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm7, %ymm3, %ymm4
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm4, %ymm1
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-NEXT:    vpternlogq $15, %zmm1, %zmm1, %zmm2
; AVX512-NEXT:    vpminuq %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %z = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> %x, <8 x i64> %y)
  ret <8 x i64> %z
}

define <2 x i128> @v2i128(<2 x i128> %x, <2 x i128> %y) nounwind {
; SSE-LABEL: v2i128:
; SSE:       # %bb.0:
; SSE-NEXT:    movq %rdi, %rax
; SSE-NEXT:    addq %r9, %rsi
; SSE-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; SSE-NEXT:    movq $-1, %rdi
; SSE-NEXT:    cmovbq %rdi, %rsi
; SSE-NEXT:    cmovbq %rdi, %rdx
; SSE-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; SSE-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; SSE-NEXT:    cmovbq %rdi, %r8
; SSE-NEXT:    cmovbq %rdi, %rcx
; SSE-NEXT:    movq %r8, 24(%rax)
; SSE-NEXT:    movq %rcx, 16(%rax)
; SSE-NEXT:    movq %rdx, 8(%rax)
; SSE-NEXT:    movq %rsi, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: v2i128:
; AVX:       # %bb.0:
; AVX-NEXT:    movq %rdi, %rax
; AVX-NEXT:    addq %r9, %rsi
; AVX-NEXT:    adcq {{[0-9]+}}(%rsp), %rdx
; AVX-NEXT:    movq $-1, %rdi
; AVX-NEXT:    cmovbq %rdi, %rsi
; AVX-NEXT:    cmovbq %rdi, %rdx
; AVX-NEXT:    addq {{[0-9]+}}(%rsp), %rcx
; AVX-NEXT:    adcq {{[0-9]+}}(%rsp), %r8
; AVX-NEXT:    cmovbq %rdi, %r8
; AVX-NEXT:    cmovbq %rdi, %rcx
; AVX-NEXT:    movq %r8, 24(%rax)
; AVX-NEXT:    movq %rcx, 16(%rax)
; AVX-NEXT:    movq %rdx, 8(%rax)
; AVX-NEXT:    movq %rsi, (%rax)
; AVX-NEXT:    retq
  %z = call <2 x i128> @llvm.uadd.sat.v2i128(<2 x i128> %x, <2 x i128> %y)
  ret <2 x i128> %z
}
