// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: addpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
addpd 485498096, %xmm6

// CHECK: addpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0x74,0x82,0xc0]
addpd -64(%rdx,%rax,4), %xmm6

// CHECK: addpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0x74,0x82,0x40]
addpd 64(%rdx,%rax,4), %xmm6

// CHECK: addpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0x74,0x02,0x40]
addpd 64(%rdx,%rax), %xmm6

// CHECK: addpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0x72,0x40]
addpd 64(%rdx), %xmm6

// CHECK: addpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0x32]
addpd (%rdx), %xmm6

// CHECK: addpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x58,0xf6]
addpd %xmm6, %xmm6

// CHECK: addsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
addsd 485498096, %xmm6

// CHECK: addsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0x74,0x82,0xc0]
addsd -64(%rdx,%rax,4), %xmm6

// CHECK: addsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0x74,0x82,0x40]
addsd 64(%rdx,%rax,4), %xmm6

// CHECK: addsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0x74,0x02,0x40]
addsd 64(%rdx,%rax), %xmm6

// CHECK: addsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0x72,0x40]
addsd 64(%rdx), %xmm6

// CHECK: addsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0x32]
addsd (%rdx), %xmm6

// CHECK: addsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x58,0xf6]
addsd %xmm6, %xmm6

// CHECK: andnpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
andnpd 485498096, %xmm6

// CHECK: andnpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0x74,0x82,0xc0]
andnpd -64(%rdx,%rax,4), %xmm6

// CHECK: andnpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0x74,0x82,0x40]
andnpd 64(%rdx,%rax,4), %xmm6

// CHECK: andnpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0x74,0x02,0x40]
andnpd 64(%rdx,%rax), %xmm6

// CHECK: andnpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0x72,0x40]
andnpd 64(%rdx), %xmm6

// CHECK: andnpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0x32]
andnpd (%rdx), %xmm6

// CHECK: andnpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x55,0xf6]
andnpd %xmm6, %xmm6

// CHECK: andpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
andpd 485498096, %xmm6

// CHECK: andpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0x74,0x82,0xc0]
andpd -64(%rdx,%rax,4), %xmm6

// CHECK: andpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0x74,0x82,0x40]
andpd 64(%rdx,%rax,4), %xmm6

// CHECK: andpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0x74,0x02,0x40]
andpd 64(%rdx,%rax), %xmm6

// CHECK: andpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0x72,0x40]
andpd 64(%rdx), %xmm6

// CHECK: andpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0x32]
andpd (%rdx), %xmm6

// CHECK: andpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x54,0xf6]
andpd %xmm6, %xmm6

// CHECK: cmpeqpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqpd 485498096, %xmm6

// CHECK: cmpeqpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0x74,0x82,0xc0,0x00]
cmpeqpd -64(%rdx,%rax,4), %xmm6

// CHECK: cmpeqpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0x74,0x82,0x40,0x00]
cmpeqpd 64(%rdx,%rax,4), %xmm6

// CHECK: cmpeqpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0x74,0x02,0x40,0x00]
cmpeqpd 64(%rdx,%rax), %xmm6

// CHECK: cmpeqpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0x72,0x40,0x00]
cmpeqpd 64(%rdx), %xmm6

// CHECK: cmpeqpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0x32,0x00]
cmpeqpd (%rdx), %xmm6

// CHECK: cmpeqpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xc2,0xf6,0x00]
cmpeqpd %xmm6, %xmm6

// CHECK: cmpeqsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
cmpeqsd 485498096, %xmm6

// CHECK: cmpeqsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0x74,0x82,0xc0,0x00]
cmpeqsd -64(%rdx,%rax,4), %xmm6

// CHECK: cmpeqsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0x74,0x82,0x40,0x00]
cmpeqsd 64(%rdx,%rax,4), %xmm6

// CHECK: cmpeqsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0x74,0x02,0x40,0x00]
cmpeqsd 64(%rdx,%rax), %xmm6

// CHECK: cmpeqsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0x72,0x40,0x00]
cmpeqsd 64(%rdx), %xmm6

// CHECK: cmpeqsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0x32,0x00]
cmpeqsd (%rdx), %xmm6

// CHECK: cmpeqsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0xc2,0xf6,0x00]
cmpeqsd %xmm6, %xmm6

// CHECK: comisd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
comisd 485498096, %xmm6

// CHECK: comisd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0x74,0x82,0xc0]
comisd -64(%rdx,%rax,4), %xmm6

// CHECK: comisd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0x74,0x82,0x40]
comisd 64(%rdx,%rax,4), %xmm6

// CHECK: comisd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0x74,0x02,0x40]
comisd 64(%rdx,%rax), %xmm6

// CHECK: comisd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0x72,0x40]
comisd 64(%rdx), %xmm6

// CHECK: comisd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0x32]
comisd (%rdx), %xmm6

// CHECK: comisd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x2f,0xf6]
comisd %xmm6, %xmm6

// CHECK: cvtdq2pd 485498096, %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtdq2pd 485498096, %xmm6

// CHECK: cvtdq2pd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0x74,0x82,0xc0]
cvtdq2pd -64(%rdx,%rax,4), %xmm6

// CHECK: cvtdq2pd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0x74,0x82,0x40]
cvtdq2pd 64(%rdx,%rax,4), %xmm6

// CHECK: cvtdq2pd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0x74,0x02,0x40]
cvtdq2pd 64(%rdx,%rax), %xmm6

// CHECK: cvtdq2pd 64(%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0x72,0x40]
cvtdq2pd 64(%rdx), %xmm6

// CHECK: cvtdq2pd (%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0x32]
cvtdq2pd (%rdx), %xmm6

// CHECK: cvtdq2pd %xmm6, %xmm6
// CHECK: encoding: [0xf3,0x0f,0xe6,0xf6]
cvtdq2pd %xmm6, %xmm6

// CHECK: cvtdq2ps 485498096, %xmm6
// CHECK: encoding: [0x0f,0x5b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtdq2ps 485498096, %xmm6

// CHECK: cvtdq2ps -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x0f,0x5b,0x74,0x82,0xc0]
cvtdq2ps -64(%rdx,%rax,4), %xmm6

// CHECK: cvtdq2ps 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x0f,0x5b,0x74,0x82,0x40]
cvtdq2ps 64(%rdx,%rax,4), %xmm6

// CHECK: cvtdq2ps 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x0f,0x5b,0x74,0x02,0x40]
cvtdq2ps 64(%rdx,%rax), %xmm6

// CHECK: cvtdq2ps 64(%rdx), %xmm6
// CHECK: encoding: [0x0f,0x5b,0x72,0x40]
cvtdq2ps 64(%rdx), %xmm6

// CHECK: cvtdq2ps (%rdx), %xmm6
// CHECK: encoding: [0x0f,0x5b,0x32]
cvtdq2ps (%rdx), %xmm6

// CHECK: cvtdq2ps %xmm6, %xmm6
// CHECK: encoding: [0x0f,0x5b,0xf6]
cvtdq2ps %xmm6, %xmm6

// CHECK: cvtpd2dq 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtpd2dq 485498096, %xmm6

// CHECK: cvtpd2dq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0x74,0x82,0xc0]
cvtpd2dq -64(%rdx,%rax,4), %xmm6

// CHECK: cvtpd2dq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0x74,0x82,0x40]
cvtpd2dq 64(%rdx,%rax,4), %xmm6

// CHECK: cvtpd2dq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0x74,0x02,0x40]
cvtpd2dq 64(%rdx,%rax), %xmm6

// CHECK: cvtpd2dq 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0x72,0x40]
cvtpd2dq 64(%rdx), %xmm6

// CHECK: cvtpd2dq (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0x32]
cvtpd2dq (%rdx), %xmm6

// CHECK: cvtpd2dq %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0xe6,0xf6]
cvtpd2dq %xmm6, %xmm6

// CHECK: cvtpd2pi 485498096, %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
cvtpd2pi 485498096, %mm4

// CHECK: cvtpd2pi 64(%rdx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x62,0x40]
cvtpd2pi 64(%rdx), %mm4

// CHECK: cvtpd2pi -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x64,0x82,0xc0]
cvtpd2pi -64(%rdx,%rax,4), %mm4

// CHECK: cvtpd2pi 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x64,0x82,0x40]
cvtpd2pi 64(%rdx,%rax,4), %mm4

// CHECK: cvtpd2pi 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x64,0x02,0x40]
cvtpd2pi 64(%rdx,%rax), %mm4

// CHECK: cvtpd2pi (%rdx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0x22]
cvtpd2pi (%rdx), %mm4

// CHECK: cvtpd2pi %xmm6, %mm4
// CHECK: encoding: [0x66,0x0f,0x2d,0xe6]
cvtpd2pi %xmm6, %mm4

// CHECK: cvtpd2ps 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtpd2ps 485498096, %xmm6

// CHECK: cvtpd2ps -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0x74,0x82,0xc0]
cvtpd2ps -64(%rdx,%rax,4), %xmm6

// CHECK: cvtpd2ps 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0x74,0x82,0x40]
cvtpd2ps 64(%rdx,%rax,4), %xmm6

// CHECK: cvtpd2ps 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0x74,0x02,0x40]
cvtpd2ps 64(%rdx,%rax), %xmm6

// CHECK: cvtpd2ps 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0x72,0x40]
cvtpd2ps 64(%rdx), %xmm6

// CHECK: cvtpd2ps (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0x32]
cvtpd2ps (%rdx), %xmm6

// CHECK: cvtpd2ps %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5a,0xf6]
cvtpd2ps %xmm6, %xmm6

// CHECK: cvtpi2pd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtpi2pd 485498096, %xmm6

// CHECK: cvtpi2pd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0x74,0x82,0xc0]
cvtpi2pd -64(%rdx,%rax,4), %xmm6

// CHECK: cvtpi2pd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0x74,0x82,0x40]
cvtpi2pd 64(%rdx,%rax,4), %xmm6

// CHECK: cvtpi2pd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0x74,0x02,0x40]
cvtpi2pd 64(%rdx,%rax), %xmm6

// CHECK: cvtpi2pd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0x72,0x40]
cvtpi2pd 64(%rdx), %xmm6

// CHECK: cvtpi2pd %mm4, %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0xf4]
cvtpi2pd %mm4, %xmm6

// CHECK: cvtpi2pd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2a,0x32]
cvtpi2pd (%rdx), %xmm6

// CHECK: cvtps2dq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtps2dq 485498096, %xmm6

// CHECK: cvtps2dq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0x74,0x82,0xc0]
cvtps2dq -64(%rdx,%rax,4), %xmm6

// CHECK: cvtps2dq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0x74,0x82,0x40]
cvtps2dq 64(%rdx,%rax,4), %xmm6

// CHECK: cvtps2dq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0x74,0x02,0x40]
cvtps2dq 64(%rdx,%rax), %xmm6

// CHECK: cvtps2dq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0x72,0x40]
cvtps2dq 64(%rdx), %xmm6

// CHECK: cvtps2dq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0x32]
cvtps2dq (%rdx), %xmm6

// CHECK: cvtps2dq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5b,0xf6]
cvtps2dq %xmm6, %xmm6

// CHECK: cvtps2pd 485498096, %xmm6
// CHECK: encoding: [0x0f,0x5a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtps2pd 485498096, %xmm6

// CHECK: cvtps2pd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x0f,0x5a,0x74,0x82,0xc0]
cvtps2pd -64(%rdx,%rax,4), %xmm6

// CHECK: cvtps2pd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x0f,0x5a,0x74,0x82,0x40]
cvtps2pd 64(%rdx,%rax,4), %xmm6

// CHECK: cvtps2pd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x0f,0x5a,0x74,0x02,0x40]
cvtps2pd 64(%rdx,%rax), %xmm6

// CHECK: cvtps2pd 64(%rdx), %xmm6
// CHECK: encoding: [0x0f,0x5a,0x72,0x40]
cvtps2pd 64(%rdx), %xmm6

// CHECK: cvtps2pd (%rdx), %xmm6
// CHECK: encoding: [0x0f,0x5a,0x32]
cvtps2pd (%rdx), %xmm6

// CHECK: cvtps2pd %xmm6, %xmm6
// CHECK: encoding: [0x0f,0x5a,0xf6]
cvtps2pd %xmm6, %xmm6

// CHECK: cvtsd2si 485498096, %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0x2c,0x25,0xf0,0x1c,0xf0,0x1c]
cvtsd2si 485498096, %r13d

// CHECK: cvtsd2si 485498096, %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
cvtsd2si 485498096, %r15

// CHECK: cvtsd2si 64(%rdx), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0x6a,0x40]
cvtsd2si 64(%rdx), %r13d

// CHECK: cvtsd2si 64(%rdx), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0x7a,0x40]
cvtsd2si 64(%rdx), %r15

// CHECK: cvtsd2si -64(%rdx,%rax,4), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0x6c,0x82,0xc0]
cvtsd2si -64(%rdx,%rax,4), %r13d

// CHECK: cvtsd2si 64(%rdx,%rax,4), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0x6c,0x82,0x40]
cvtsd2si 64(%rdx,%rax,4), %r13d

// CHECK: cvtsd2si -64(%rdx,%rax,4), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0x7c,0x82,0xc0]
cvtsd2si -64(%rdx,%rax,4), %r15

// CHECK: cvtsd2si 64(%rdx,%rax,4), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0x7c,0x82,0x40]
cvtsd2si 64(%rdx,%rax,4), %r15

// CHECK: cvtsd2si 64(%rdx,%rax), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0x6c,0x02,0x40]
cvtsd2si 64(%rdx,%rax), %r13d

// CHECK: cvtsd2si 64(%rdx,%rax), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0x7c,0x02,0x40]
cvtsd2si 64(%rdx,%rax), %r15

// CHECK: cvtsd2si (%rdx), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0x2a]
cvtsd2si (%rdx), %r13d

// CHECK: cvtsd2si (%rdx), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0x3a]
cvtsd2si (%rdx), %r15

// CHECK: cvtsd2si %xmm6, %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2d,0xee]
cvtsd2si %xmm6, %r13d

// CHECK: cvtsd2si %xmm6, %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2d,0xfe]
cvtsd2si %xmm6, %r15

// CHECK: cvtsd2ss 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtsd2ss 485498096, %xmm6

// CHECK: cvtsd2ss -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0x74,0x82,0xc0]
cvtsd2ss -64(%rdx,%rax,4), %xmm6

// CHECK: cvtsd2ss 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0x74,0x82,0x40]
cvtsd2ss 64(%rdx,%rax,4), %xmm6

// CHECK: cvtsd2ss 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0x74,0x02,0x40]
cvtsd2ss 64(%rdx,%rax), %xmm6

// CHECK: cvtsd2ss 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0x72,0x40]
cvtsd2ss 64(%rdx), %xmm6

// CHECK: cvtsd2ss (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0x32]
cvtsd2ss (%rdx), %xmm6

// CHECK: cvtsd2ss %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5a,0xf6]
cvtsd2ss %xmm6, %xmm6

// CHECK: cvtsi2sdl 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x2a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtsi2sdl 485498096, %xmm6

// CHECK: cvtsi2sdl -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x2a,0x74,0x82,0xc0]
cvtsi2sdl -64(%rdx,%rax,4), %xmm6

// CHECK: cvtsi2sdl 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x2a,0x74,0x82,0x40]
cvtsi2sdl 64(%rdx,%rax,4), %xmm6

// CHECK: cvtsi2sdl 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x2a,0x74,0x02,0x40]
cvtsi2sdl 64(%rdx,%rax), %xmm6

// CHECK: cvtsi2sdl 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x2a,0x72,0x40]
cvtsi2sdl 64(%rdx), %xmm6

// CHECK: cvtsi2sdl %r13d, %xmm6
// CHECK: encoding: [0xf2,0x41,0x0f,0x2a,0xf5]
cvtsi2sdl %r13d, %xmm6

// CHECK: cvtsi2sdl (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x2a,0x32]
cvtsi2sdl (%rdx), %xmm6

// CHECK: cvtsi2sdq 485498096, %xmm6
// CHECK: encoding: [0xf2,0x48,0x0f,0x2a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtsi2sdq 485498096, %xmm6

// CHECK: cvtsi2sdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x48,0x0f,0x2a,0x74,0x82,0xc0]
cvtsi2sdq -64(%rdx,%rax,4), %xmm6

// CHECK: cvtsi2sdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x48,0x0f,0x2a,0x74,0x82,0x40]
cvtsi2sdq 64(%rdx,%rax,4), %xmm6

// CHECK: cvtsi2sdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x48,0x0f,0x2a,0x74,0x02,0x40]
cvtsi2sdq 64(%rdx,%rax), %xmm6

// CHECK: cvtsi2sdq 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x48,0x0f,0x2a,0x72,0x40]
cvtsi2sdq 64(%rdx), %xmm6

// CHECK: cvtsi2sdq %r15, %xmm6
// CHECK: encoding: [0xf2,0x49,0x0f,0x2a,0xf7]
cvtsi2sdq %r15, %xmm6

// CHECK: cvtsi2sdq (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x48,0x0f,0x2a,0x32]
cvtsi2sdq (%rdx), %xmm6

// CHECK: cvtss2sd 485498096, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvtss2sd 485498096, %xmm6

// CHECK: cvtss2sd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0x74,0x82,0xc0]
cvtss2sd -64(%rdx,%rax,4), %xmm6

// CHECK: cvtss2sd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0x74,0x82,0x40]
cvtss2sd 64(%rdx,%rax,4), %xmm6

// CHECK: cvtss2sd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0x74,0x02,0x40]
cvtss2sd 64(%rdx,%rax), %xmm6

// CHECK: cvtss2sd 64(%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0x72,0x40]
cvtss2sd 64(%rdx), %xmm6

// CHECK: cvtss2sd (%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0x32]
cvtss2sd (%rdx), %xmm6

// CHECK: cvtss2sd %xmm6, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5a,0xf6]
cvtss2sd %xmm6, %xmm6

// CHECK: cvttpd2dq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvttpd2dq 485498096, %xmm6

// CHECK: cvttpd2dq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0x74,0x82,0xc0]
cvttpd2dq -64(%rdx,%rax,4), %xmm6

// CHECK: cvttpd2dq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0x74,0x82,0x40]
cvttpd2dq 64(%rdx,%rax,4), %xmm6

// CHECK: cvttpd2dq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0x74,0x02,0x40]
cvttpd2dq 64(%rdx,%rax), %xmm6

// CHECK: cvttpd2dq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0x72,0x40]
cvttpd2dq 64(%rdx), %xmm6

// CHECK: cvttpd2dq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0x32]
cvttpd2dq (%rdx), %xmm6

// CHECK: cvttpd2dq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe6,0xf6]
cvttpd2dq %xmm6, %xmm6

// CHECK: cvttpd2pi 485498096, %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
cvttpd2pi 485498096, %mm4

// CHECK: cvttpd2pi 64(%rdx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x62,0x40]
cvttpd2pi 64(%rdx), %mm4

// CHECK: cvttpd2pi -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x64,0x82,0xc0]
cvttpd2pi -64(%rdx,%rax,4), %mm4

// CHECK: cvttpd2pi 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x64,0x82,0x40]
cvttpd2pi 64(%rdx,%rax,4), %mm4

// CHECK: cvttpd2pi 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x64,0x02,0x40]
cvttpd2pi 64(%rdx,%rax), %mm4

// CHECK: cvttpd2pi (%rdx), %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0x22]
cvttpd2pi (%rdx), %mm4

// CHECK: cvttpd2pi %xmm6, %mm4
// CHECK: encoding: [0x66,0x0f,0x2c,0xe6]
cvttpd2pi %xmm6, %mm4

// CHECK: cvttps2dq 485498096, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
cvttps2dq 485498096, %xmm6

// CHECK: cvttps2dq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0x74,0x82,0xc0]
cvttps2dq -64(%rdx,%rax,4), %xmm6

// CHECK: cvttps2dq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0x74,0x82,0x40]
cvttps2dq 64(%rdx,%rax,4), %xmm6

// CHECK: cvttps2dq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0x74,0x02,0x40]
cvttps2dq 64(%rdx,%rax), %xmm6

// CHECK: cvttps2dq 64(%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0x72,0x40]
cvttps2dq 64(%rdx), %xmm6

// CHECK: cvttps2dq (%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0x32]
cvttps2dq (%rdx), %xmm6

// CHECK: cvttps2dq %xmm6, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x5b,0xf6]
cvttps2dq %xmm6, %xmm6

// CHECK: cvttsd2si 485498096, %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0x2c,0x25,0xf0,0x1c,0xf0,0x1c]
cvttsd2si 485498096, %r13d

// CHECK: cvttsd2si 485498096, %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
cvttsd2si 485498096, %r15

// CHECK: cvttsd2si 64(%rdx), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0x6a,0x40]
cvttsd2si 64(%rdx), %r13d

// CHECK: cvttsd2si 64(%rdx), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0x7a,0x40]
cvttsd2si 64(%rdx), %r15

// CHECK: cvttsd2si -64(%rdx,%rax,4), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0x6c,0x82,0xc0]
cvttsd2si -64(%rdx,%rax,4), %r13d

// CHECK: cvttsd2si 64(%rdx,%rax,4), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0x6c,0x82,0x40]
cvttsd2si 64(%rdx,%rax,4), %r13d

// CHECK: cvttsd2si -64(%rdx,%rax,4), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0x7c,0x82,0xc0]
cvttsd2si -64(%rdx,%rax,4), %r15

// CHECK: cvttsd2si 64(%rdx,%rax,4), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0x7c,0x82,0x40]
cvttsd2si 64(%rdx,%rax,4), %r15

// CHECK: cvttsd2si 64(%rdx,%rax), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0x6c,0x02,0x40]
cvttsd2si 64(%rdx,%rax), %r13d

// CHECK: cvttsd2si 64(%rdx,%rax), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0x7c,0x02,0x40]
cvttsd2si 64(%rdx,%rax), %r15

// CHECK: cvttsd2si (%rdx), %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0x2a]
cvttsd2si (%rdx), %r13d

// CHECK: cvttsd2si (%rdx), %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0x3a]
cvttsd2si (%rdx), %r15

// CHECK: cvttsd2si %xmm6, %r13d
// CHECK: encoding: [0xf2,0x44,0x0f,0x2c,0xee]
cvttsd2si %xmm6, %r13d

// CHECK: cvttsd2si %xmm6, %r15
// CHECK: encoding: [0xf2,0x4c,0x0f,0x2c,0xfe]
cvttsd2si %xmm6, %r15

// CHECK: divpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
divpd 485498096, %xmm6

// CHECK: divpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0x74,0x82,0xc0]
divpd -64(%rdx,%rax,4), %xmm6

// CHECK: divpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0x74,0x82,0x40]
divpd 64(%rdx,%rax,4), %xmm6

// CHECK: divpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0x74,0x02,0x40]
divpd 64(%rdx,%rax), %xmm6

// CHECK: divpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0x72,0x40]
divpd 64(%rdx), %xmm6

// CHECK: divpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0x32]
divpd (%rdx), %xmm6

// CHECK: divpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5e,0xf6]
divpd %xmm6, %xmm6

// CHECK: divsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
divsd 485498096, %xmm6

// CHECK: divsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0x74,0x82,0xc0]
divsd -64(%rdx,%rax,4), %xmm6

// CHECK: divsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0x74,0x82,0x40]
divsd 64(%rdx,%rax,4), %xmm6

// CHECK: divsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0x74,0x02,0x40]
divsd 64(%rdx,%rax), %xmm6

// CHECK: divsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0x72,0x40]
divsd 64(%rdx), %xmm6

// CHECK: divsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0x32]
divsd (%rdx), %xmm6

// CHECK: divsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5e,0xf6]
divsd %xmm6, %xmm6

// CHECK: lfence
// CHECK: encoding: [0x0f,0xae,0xe8]
lfence

// CHECK: maskmovdqu %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf7,0xf6]
maskmovdqu %xmm6, %xmm6

// CHECK: maxpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
maxpd 485498096, %xmm6

// CHECK: maxpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0x74,0x82,0xc0]
maxpd -64(%rdx,%rax,4), %xmm6

// CHECK: maxpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0x74,0x82,0x40]
maxpd 64(%rdx,%rax,4), %xmm6

// CHECK: maxpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0x74,0x02,0x40]
maxpd 64(%rdx,%rax), %xmm6

// CHECK: maxpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0x72,0x40]
maxpd 64(%rdx), %xmm6

// CHECK: maxpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0x32]
maxpd (%rdx), %xmm6

// CHECK: maxpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5f,0xf6]
maxpd %xmm6, %xmm6

// CHECK: maxsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
maxsd 485498096, %xmm6

// CHECK: maxsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0x74,0x82,0xc0]
maxsd -64(%rdx,%rax,4), %xmm6

// CHECK: maxsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0x74,0x82,0x40]
maxsd 64(%rdx,%rax,4), %xmm6

// CHECK: maxsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0x74,0x02,0x40]
maxsd 64(%rdx,%rax), %xmm6

// CHECK: maxsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0x72,0x40]
maxsd 64(%rdx), %xmm6

// CHECK: maxsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0x32]
maxsd (%rdx), %xmm6

// CHECK: maxsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5f,0xf6]
maxsd %xmm6, %xmm6

// CHECK: mfence
// CHECK: encoding: [0x0f,0xae,0xf0]
mfence

// CHECK: minpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
minpd 485498096, %xmm6

// CHECK: minpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0x74,0x82,0xc0]
minpd -64(%rdx,%rax,4), %xmm6

// CHECK: minpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0x74,0x82,0x40]
minpd 64(%rdx,%rax,4), %xmm6

// CHECK: minpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0x74,0x02,0x40]
minpd 64(%rdx,%rax), %xmm6

// CHECK: minpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0x72,0x40]
minpd 64(%rdx), %xmm6

// CHECK: minpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0x32]
minpd (%rdx), %xmm6

// CHECK: minpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5d,0xf6]
minpd %xmm6, %xmm6

// CHECK: minsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
minsd 485498096, %xmm6

// CHECK: minsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0x74,0x82,0xc0]
minsd -64(%rdx,%rax,4), %xmm6

// CHECK: minsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0x74,0x82,0x40]
minsd 64(%rdx,%rax,4), %xmm6

// CHECK: minsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0x74,0x02,0x40]
minsd 64(%rdx,%rax), %xmm6

// CHECK: minsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0x72,0x40]
minsd 64(%rdx), %xmm6

// CHECK: minsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0x32]
minsd (%rdx), %xmm6

// CHECK: minsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5d,0xf6]
minsd %xmm6, %xmm6

// CHECK: movapd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movapd 485498096, %xmm6

// CHECK: movapd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0x74,0x82,0xc0]
movapd -64(%rdx,%rax,4), %xmm6

// CHECK: movapd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0x74,0x82,0x40]
movapd 64(%rdx,%rax,4), %xmm6

// CHECK: movapd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0x74,0x02,0x40]
movapd 64(%rdx,%rax), %xmm6

// CHECK: movapd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0x72,0x40]
movapd 64(%rdx), %xmm6

// CHECK: movapd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0x32]
movapd (%rdx), %xmm6

// CHECK: movapd %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x29,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movapd %xmm6, 485498096

// CHECK: movapd %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x29,0x72,0x40]
movapd %xmm6, 64(%rdx)

// CHECK: movapd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x29,0x74,0x02,0x40]
movapd %xmm6, 64(%rdx,%rax)

// CHECK: movapd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x29,0x74,0x82,0xc0]
movapd %xmm6, -64(%rdx,%rax,4)

// CHECK: movapd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x29,0x74,0x82,0x40]
movapd %xmm6, 64(%rdx,%rax,4)

// CHECK: movapd %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x29,0x32]
movapd %xmm6, (%rdx)

// CHECK: movapd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x28,0xf6]
movapd %xmm6, %xmm6

// CHECK: movd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movd 485498096, %xmm6

// CHECK: movd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6e,0x74,0x82,0xc0]
movd -64(%rdx,%rax,4), %xmm6

// CHECK: movd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6e,0x74,0x82,0x40]
movd 64(%rdx,%rax,4), %xmm6

// CHECK: movd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6e,0x74,0x02,0x40]
movd 64(%rdx,%rax), %xmm6

// CHECK: movd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6e,0x72,0x40]
movd 64(%rdx), %xmm6

// CHECK: movdq2q %xmm6, %mm4
// CHECK: encoding: [0xf2,0x0f,0xd6,0xe6]
movdq2q %xmm6, %mm4

// CHECK: movdqa 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movdqa 485498096, %xmm6

// CHECK: movdqa -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0x74,0x82,0xc0]
movdqa -64(%rdx,%rax,4), %xmm6

// CHECK: movdqa 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0x74,0x82,0x40]
movdqa 64(%rdx,%rax,4), %xmm6

// CHECK: movdqa 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0x74,0x02,0x40]
movdqa 64(%rdx,%rax), %xmm6

// CHECK: movdqa 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0x72,0x40]
movdqa 64(%rdx), %xmm6

// CHECK: movdqa (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0x32]
movdqa (%rdx), %xmm6

// CHECK: movdqa %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x7f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movdqa %xmm6, 485498096

// CHECK: movdqa %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x7f,0x72,0x40]
movdqa %xmm6, 64(%rdx)

// CHECK: movdqa %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x7f,0x74,0x02,0x40]
movdqa %xmm6, 64(%rdx,%rax)

// CHECK: movdqa %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x7f,0x74,0x82,0xc0]
movdqa %xmm6, -64(%rdx,%rax,4)

// CHECK: movdqa %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x7f,0x74,0x82,0x40]
movdqa %xmm6, 64(%rdx,%rax,4)

// CHECK: movdqa %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x7f,0x32]
movdqa %xmm6, (%rdx)

// CHECK: movdqa %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6f,0xf6]
movdqa %xmm6, %xmm6

// CHECK: movdqu 485498096, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movdqu 485498096, %xmm6

// CHECK: movdqu -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0x74,0x82,0xc0]
movdqu -64(%rdx,%rax,4), %xmm6

// CHECK: movdqu 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0x74,0x82,0x40]
movdqu 64(%rdx,%rax,4), %xmm6

// CHECK: movdqu 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0x74,0x02,0x40]
movdqu 64(%rdx,%rax), %xmm6

// CHECK: movdqu 64(%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0x72,0x40]
movdqu 64(%rdx), %xmm6

// CHECK: movdqu (%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0x32]
movdqu (%rdx), %xmm6

// CHECK: movdqu %xmm6, 485498096
// CHECK: encoding: [0xf3,0x0f,0x7f,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movdqu %xmm6, 485498096

// CHECK: movdqu %xmm6, 64(%rdx)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x72,0x40]
movdqu %xmm6, 64(%rdx)

// CHECK: movdqu %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x74,0x02,0x40]
movdqu %xmm6, 64(%rdx,%rax)

// CHECK: movdqu %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x74,0x82,0xc0]
movdqu %xmm6, -64(%rdx,%rax,4)

// CHECK: movdqu %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x74,0x82,0x40]
movdqu %xmm6, 64(%rdx,%rax,4)

// CHECK: movdqu %xmm6, (%rdx)
// CHECK: encoding: [0xf3,0x0f,0x7f,0x32]
movdqu %xmm6, (%rdx)

// CHECK: movdqu %xmm6, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x6f,0xf6]
movdqu %xmm6, %xmm6

// CHECK: movd %r13d, %xmm6
// CHECK: encoding: [0x66,0x41,0x0f,0x6e,0xf5]
movd %r13d, %xmm6

// CHECK: movd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6e,0x32]
movd (%rdx), %xmm6

// CHECK: movd %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x7e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movd %xmm6, 485498096

// CHECK: movd %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x7e,0x72,0x40]
movd %xmm6, 64(%rdx)

// CHECK: movd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x7e,0x74,0x02,0x40]
movd %xmm6, 64(%rdx,%rax)

// CHECK: movd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x7e,0x74,0x82,0xc0]
movd %xmm6, -64(%rdx,%rax,4)

// CHECK: movd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x7e,0x74,0x82,0x40]
movd %xmm6, 64(%rdx,%rax,4)

// CHECK: movd %xmm6, %r13d
// CHECK: encoding: [0x66,0x41,0x0f,0x7e,0xf5]
movd %xmm6, %r13d

// CHECK: movd %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x7e,0x32]
movd %xmm6, (%rdx)

// CHECK: movhpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x16,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movhpd 485498096, %xmm6

// CHECK: movhpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x16,0x74,0x82,0xc0]
movhpd -64(%rdx,%rax,4), %xmm6

// CHECK: movhpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x16,0x74,0x82,0x40]
movhpd 64(%rdx,%rax,4), %xmm6

// CHECK: movhpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x16,0x74,0x02,0x40]
movhpd 64(%rdx,%rax), %xmm6

// CHECK: movhpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x16,0x72,0x40]
movhpd 64(%rdx), %xmm6

// CHECK: movhpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x16,0x32]
movhpd (%rdx), %xmm6

// CHECK: movhpd %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x17,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movhpd %xmm6, 485498096

// CHECK: movhpd %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x17,0x72,0x40]
movhpd %xmm6, 64(%rdx)

// CHECK: movhpd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x17,0x74,0x02,0x40]
movhpd %xmm6, 64(%rdx,%rax)

// CHECK: movhpd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x17,0x74,0x82,0xc0]
movhpd %xmm6, -64(%rdx,%rax,4)

// CHECK: movhpd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x17,0x74,0x82,0x40]
movhpd %xmm6, 64(%rdx,%rax,4)

// CHECK: movhpd %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x17,0x32]
movhpd %xmm6, (%rdx)

// CHECK: movlpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x12,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movlpd 485498096, %xmm6

// CHECK: movlpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x12,0x74,0x82,0xc0]
movlpd -64(%rdx,%rax,4), %xmm6

// CHECK: movlpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x12,0x74,0x82,0x40]
movlpd 64(%rdx,%rax,4), %xmm6

// CHECK: movlpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x12,0x74,0x02,0x40]
movlpd 64(%rdx,%rax), %xmm6

// CHECK: movlpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x12,0x72,0x40]
movlpd 64(%rdx), %xmm6

// CHECK: movlpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x12,0x32]
movlpd (%rdx), %xmm6

// CHECK: movlpd %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x13,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movlpd %xmm6, 485498096

// CHECK: movlpd %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x13,0x72,0x40]
movlpd %xmm6, 64(%rdx)

// CHECK: movlpd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x13,0x74,0x02,0x40]
movlpd %xmm6, 64(%rdx,%rax)

// CHECK: movlpd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x13,0x74,0x82,0xc0]
movlpd %xmm6, -64(%rdx,%rax,4)

// CHECK: movlpd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x13,0x74,0x82,0x40]
movlpd %xmm6, 64(%rdx,%rax,4)

// CHECK: movlpd %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x13,0x32]
movlpd %xmm6, (%rdx)

// CHECK: movmskpd %xmm6, %r13d
// CHECK: encoding: [0x66,0x44,0x0f,0x50,0xee]
movmskpd %xmm6, %r13d

// CHECK: movntdq %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0xe7,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movntdq %xmm6, 485498096

// CHECK: movntdq %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0xe7,0x72,0x40]
movntdq %xmm6, 64(%rdx)

// CHECK: movntdq %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0xe7,0x74,0x02,0x40]
movntdq %xmm6, 64(%rdx,%rax)

// CHECK: movntdq %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0xe7,0x74,0x82,0xc0]
movntdq %xmm6, -64(%rdx,%rax,4)

// CHECK: movntdq %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0xe7,0x74,0x82,0x40]
movntdq %xmm6, 64(%rdx,%rax,4)

// CHECK: movntdq %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0xe7,0x32]
movntdq %xmm6, (%rdx)

// CHECK: movntil %r13d, 485498096
// CHECK: encoding: [0x44,0x0f,0xc3,0x2c,0x25,0xf0,0x1c,0xf0,0x1c]
movntil %r13d, 485498096

// CHECK: movntil %r13d, 64(%rdx)
// CHECK: encoding: [0x44,0x0f,0xc3,0x6a,0x40]
movntil %r13d, 64(%rdx)

// CHECK: movntil %r13d, 64(%rdx,%rax)
// CHECK: encoding: [0x44,0x0f,0xc3,0x6c,0x02,0x40]
movntil %r13d, 64(%rdx,%rax)

// CHECK: movntil %r13d, -64(%rdx,%rax,4)
// CHECK: encoding: [0x44,0x0f,0xc3,0x6c,0x82,0xc0]
movntil %r13d, -64(%rdx,%rax,4)

// CHECK: movntil %r13d, 64(%rdx,%rax,4)
// CHECK: encoding: [0x44,0x0f,0xc3,0x6c,0x82,0x40]
movntil %r13d, 64(%rdx,%rax,4)

// CHECK: movntil %r13d, (%rdx)
// CHECK: encoding: [0x44,0x0f,0xc3,0x2a]
movntil %r13d, (%rdx)

// CHECK: movntpd %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x2b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movntpd %xmm6, 485498096

// CHECK: movntpd %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x2b,0x72,0x40]
movntpd %xmm6, 64(%rdx)

// CHECK: movntpd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x2b,0x74,0x02,0x40]
movntpd %xmm6, 64(%rdx,%rax)

// CHECK: movntpd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x2b,0x74,0x82,0xc0]
movntpd %xmm6, -64(%rdx,%rax,4)

// CHECK: movntpd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x2b,0x74,0x82,0x40]
movntpd %xmm6, 64(%rdx,%rax,4)

// CHECK: movntpd %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x2b,0x32]
movntpd %xmm6, (%rdx)

// CHECK: movq2dq %mm4, %xmm6
// CHECK: encoding: [0xf3,0x0f,0xd6,0xf4]
movq2dq %mm4, %xmm6

// CHECK: movq 485498096, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movq 485498096, %xmm6

// CHECK: movq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0x74,0x82,0xc0]
movq -64(%rdx,%rax,4), %xmm6

// CHECK: movq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0x74,0x82,0x40]
movq 64(%rdx,%rax,4), %xmm6

// CHECK: movq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0x74,0x02,0x40]
movq 64(%rdx,%rax), %xmm6

// CHECK: movq 64(%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0x72,0x40]
movq 64(%rdx), %xmm6

// CHECK: movq %r15, %xmm6
// CHECK: encoding: [0x66,0x49,0x0f,0x6e,0xf7]
movq %r15, %xmm6

// CHECK: movq (%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0x32]
movq (%rdx), %xmm6

// CHECK: movq %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0xd6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movq %xmm6, 485498096

// CHECK: movq %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0xd6,0x72,0x40]
movq %xmm6, 64(%rdx)

// CHECK: movq %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0xd6,0x74,0x02,0x40]
movq %xmm6, 64(%rdx,%rax)

// CHECK: movq %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0xd6,0x74,0x82,0xc0]
movq %xmm6, -64(%rdx,%rax,4)

// CHECK: movq %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0xd6,0x74,0x82,0x40]
movq %xmm6, 64(%rdx,%rax,4)

// CHECK: movq %xmm6, %r15
// CHECK: encoding: [0x66,0x49,0x0f,0x7e,0xf7]
movq %xmm6, %r15

// CHECK: movq %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0xd6,0x32]
movq %xmm6, (%rdx)

// CHECK: movq %xmm6, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x7e,0xf6]
movq %xmm6, %xmm6

// CHECK: movsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movsd 485498096, %xmm6

// CHECK: movsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0x74,0x82,0xc0]
movsd -64(%rdx,%rax,4), %xmm6

// CHECK: movsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0x74,0x82,0x40]
movsd 64(%rdx,%rax,4), %xmm6

// CHECK: movsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0x74,0x02,0x40]
movsd 64(%rdx,%rax), %xmm6

// CHECK: movsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0x72,0x40]
movsd 64(%rdx), %xmm6

// CHECK: movsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0x32]
movsd (%rdx), %xmm6

// CHECK: movsd %xmm6, 485498096
// CHECK: encoding: [0xf2,0x0f,0x11,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movsd %xmm6, 485498096

// CHECK: movsd %xmm6, 64(%rdx)
// CHECK: encoding: [0xf2,0x0f,0x11,0x72,0x40]
movsd %xmm6, 64(%rdx)

// CHECK: movsd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0xf2,0x0f,0x11,0x74,0x02,0x40]
movsd %xmm6, 64(%rdx,%rax)

// CHECK: movsd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0xf2,0x0f,0x11,0x74,0x82,0xc0]
movsd %xmm6, -64(%rdx,%rax,4)

// CHECK: movsd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0xf2,0x0f,0x11,0x74,0x82,0x40]
movsd %xmm6, 64(%rdx,%rax,4)

// CHECK: movsd %xmm6, (%rdx)
// CHECK: encoding: [0xf2,0x0f,0x11,0x32]
movsd %xmm6, (%rdx)

// CHECK: movsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x10,0xf6]
movsd %xmm6, %xmm6

// CHECK: movupd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movupd 485498096, %xmm6

// CHECK: movupd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0x74,0x82,0xc0]
movupd -64(%rdx,%rax,4), %xmm6

// CHECK: movupd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0x74,0x82,0x40]
movupd 64(%rdx,%rax,4), %xmm6

// CHECK: movupd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0x74,0x02,0x40]
movupd 64(%rdx,%rax), %xmm6

// CHECK: movupd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0x72,0x40]
movupd 64(%rdx), %xmm6

// CHECK: movupd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0x32]
movupd (%rdx), %xmm6

// CHECK: movupd %xmm6, 485498096
// CHECK: encoding: [0x66,0x0f,0x11,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
movupd %xmm6, 485498096

// CHECK: movupd %xmm6, 64(%rdx)
// CHECK: encoding: [0x66,0x0f,0x11,0x72,0x40]
movupd %xmm6, 64(%rdx)

// CHECK: movupd %xmm6, 64(%rdx,%rax)
// CHECK: encoding: [0x66,0x0f,0x11,0x74,0x02,0x40]
movupd %xmm6, 64(%rdx,%rax)

// CHECK: movupd %xmm6, -64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x11,0x74,0x82,0xc0]
movupd %xmm6, -64(%rdx,%rax,4)

// CHECK: movupd %xmm6, 64(%rdx,%rax,4)
// CHECK: encoding: [0x66,0x0f,0x11,0x74,0x82,0x40]
movupd %xmm6, 64(%rdx,%rax,4)

// CHECK: movupd %xmm6, (%rdx)
// CHECK: encoding: [0x66,0x0f,0x11,0x32]
movupd %xmm6, (%rdx)

// CHECK: movupd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x10,0xf6]
movupd %xmm6, %xmm6

// CHECK: mulpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
mulpd 485498096, %xmm6

// CHECK: mulpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0x74,0x82,0xc0]
mulpd -64(%rdx,%rax,4), %xmm6

// CHECK: mulpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0x74,0x82,0x40]
mulpd 64(%rdx,%rax,4), %xmm6

// CHECK: mulpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0x74,0x02,0x40]
mulpd 64(%rdx,%rax), %xmm6

// CHECK: mulpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0x72,0x40]
mulpd 64(%rdx), %xmm6

// CHECK: mulpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0x32]
mulpd (%rdx), %xmm6

// CHECK: mulpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x59,0xf6]
mulpd %xmm6, %xmm6

// CHECK: mulsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
mulsd 485498096, %xmm6

// CHECK: mulsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0x74,0x82,0xc0]
mulsd -64(%rdx,%rax,4), %xmm6

// CHECK: mulsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0x74,0x82,0x40]
mulsd 64(%rdx,%rax,4), %xmm6

// CHECK: mulsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0x74,0x02,0x40]
mulsd 64(%rdx,%rax), %xmm6

// CHECK: mulsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0x72,0x40]
mulsd 64(%rdx), %xmm6

// CHECK: mulsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0x32]
mulsd (%rdx), %xmm6

// CHECK: mulsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x59,0xf6]
mulsd %xmm6, %xmm6

// CHECK: orpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
orpd 485498096, %xmm6

// CHECK: orpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0x74,0x82,0xc0]
orpd -64(%rdx,%rax,4), %xmm6

// CHECK: orpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0x74,0x82,0x40]
orpd 64(%rdx,%rax,4), %xmm6

// CHECK: orpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0x74,0x02,0x40]
orpd 64(%rdx,%rax), %xmm6

// CHECK: orpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0x72,0x40]
orpd 64(%rdx), %xmm6

// CHECK: orpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0x32]
orpd (%rdx), %xmm6

// CHECK: orpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x56,0xf6]
orpd %xmm6, %xmm6

// CHECK: packssdw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
packssdw 485498096, %xmm6

// CHECK: packssdw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0x74,0x82,0xc0]
packssdw -64(%rdx,%rax,4), %xmm6

// CHECK: packssdw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0x74,0x82,0x40]
packssdw 64(%rdx,%rax,4), %xmm6

// CHECK: packssdw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0x74,0x02,0x40]
packssdw 64(%rdx,%rax), %xmm6

// CHECK: packssdw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0x72,0x40]
packssdw 64(%rdx), %xmm6

// CHECK: packssdw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0x32]
packssdw (%rdx), %xmm6

// CHECK: packssdw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6b,0xf6]
packssdw %xmm6, %xmm6

// CHECK: packsswb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
packsswb 485498096, %xmm6

// CHECK: packsswb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0x74,0x82,0xc0]
packsswb -64(%rdx,%rax,4), %xmm6

// CHECK: packsswb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0x74,0x82,0x40]
packsswb 64(%rdx,%rax,4), %xmm6

// CHECK: packsswb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0x74,0x02,0x40]
packsswb 64(%rdx,%rax), %xmm6

// CHECK: packsswb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0x72,0x40]
packsswb 64(%rdx), %xmm6

// CHECK: packsswb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0x32]
packsswb (%rdx), %xmm6

// CHECK: packsswb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x63,0xf6]
packsswb %xmm6, %xmm6

// CHECK: packuswb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
packuswb 485498096, %xmm6

// CHECK: packuswb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0x74,0x82,0xc0]
packuswb -64(%rdx,%rax,4), %xmm6

// CHECK: packuswb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0x74,0x82,0x40]
packuswb 64(%rdx,%rax,4), %xmm6

// CHECK: packuswb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0x74,0x02,0x40]
packuswb 64(%rdx,%rax), %xmm6

// CHECK: packuswb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0x72,0x40]
packuswb 64(%rdx), %xmm6

// CHECK: packuswb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0x32]
packuswb (%rdx), %xmm6

// CHECK: packuswb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x67,0xf6]
packuswb %xmm6, %xmm6

// CHECK: paddb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddb 485498096, %xmm6

// CHECK: paddb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0x74,0x82,0xc0]
paddb -64(%rdx,%rax,4), %xmm6

// CHECK: paddb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0x74,0x82,0x40]
paddb 64(%rdx,%rax,4), %xmm6

// CHECK: paddb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0x74,0x02,0x40]
paddb 64(%rdx,%rax), %xmm6

// CHECK: paddb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0x72,0x40]
paddb 64(%rdx), %xmm6

// CHECK: paddb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0x32]
paddb (%rdx), %xmm6

// CHECK: paddb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfc,0xf6]
paddb %xmm6, %xmm6

// CHECK: paddd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddd 485498096, %xmm6

// CHECK: paddd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0x74,0x82,0xc0]
paddd -64(%rdx,%rax,4), %xmm6

// CHECK: paddd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0x74,0x82,0x40]
paddd 64(%rdx,%rax,4), %xmm6

// CHECK: paddd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0x74,0x02,0x40]
paddd 64(%rdx,%rax), %xmm6

// CHECK: paddd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0x72,0x40]
paddd 64(%rdx), %xmm6

// CHECK: paddd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0x32]
paddd (%rdx), %xmm6

// CHECK: paddd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfe,0xf6]
paddd %xmm6, %xmm6

// CHECK: paddq 485498096, %mm4
// CHECK: encoding: [0x0f,0xd4,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
paddq 485498096, %mm4

// CHECK: paddq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddq 485498096, %xmm6

// CHECK: paddq 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0xd4,0x62,0x40]
paddq 64(%rdx), %mm4

// CHECK: paddq -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0xd4,0x64,0x82,0xc0]
paddq -64(%rdx,%rax,4), %mm4

// CHECK: paddq 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0xd4,0x64,0x82,0x40]
paddq 64(%rdx,%rax,4), %mm4

// CHECK: paddq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0x74,0x82,0xc0]
paddq -64(%rdx,%rax,4), %xmm6

// CHECK: paddq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0x74,0x82,0x40]
paddq 64(%rdx,%rax,4), %xmm6

// CHECK: paddq 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0xd4,0x64,0x02,0x40]
paddq 64(%rdx,%rax), %mm4

// CHECK: paddq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0x74,0x02,0x40]
paddq 64(%rdx,%rax), %xmm6

// CHECK: paddq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0x72,0x40]
paddq 64(%rdx), %xmm6

// CHECK: paddq %mm4, %mm4
// CHECK: encoding: [0x0f,0xd4,0xe4]
paddq %mm4, %mm4

// CHECK: paddq (%rdx), %mm4
// CHECK: encoding: [0x0f,0xd4,0x22]
paddq (%rdx), %mm4

// CHECK: paddq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0x32]
paddq (%rdx), %xmm6

// CHECK: paddq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd4,0xf6]
paddq %xmm6, %xmm6

// CHECK: paddsb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddsb 485498096, %xmm6

// CHECK: paddsb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0x74,0x82,0xc0]
paddsb -64(%rdx,%rax,4), %xmm6

// CHECK: paddsb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0x74,0x82,0x40]
paddsb 64(%rdx,%rax,4), %xmm6

// CHECK: paddsb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0x74,0x02,0x40]
paddsb 64(%rdx,%rax), %xmm6

// CHECK: paddsb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0x72,0x40]
paddsb 64(%rdx), %xmm6

// CHECK: paddsb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0x32]
paddsb (%rdx), %xmm6

// CHECK: paddsb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xec,0xf6]
paddsb %xmm6, %xmm6

// CHECK: paddsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddsw 485498096, %xmm6

// CHECK: paddsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0x74,0x82,0xc0]
paddsw -64(%rdx,%rax,4), %xmm6

// CHECK: paddsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0x74,0x82,0x40]
paddsw 64(%rdx,%rax,4), %xmm6

// CHECK: paddsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0x74,0x02,0x40]
paddsw 64(%rdx,%rax), %xmm6

// CHECK: paddsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0x72,0x40]
paddsw 64(%rdx), %xmm6

// CHECK: paddsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0x32]
paddsw (%rdx), %xmm6

// CHECK: paddsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xed,0xf6]
paddsw %xmm6, %xmm6

// CHECK: paddusb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddusb 485498096, %xmm6

// CHECK: paddusb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0x74,0x82,0xc0]
paddusb -64(%rdx,%rax,4), %xmm6

// CHECK: paddusb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0x74,0x82,0x40]
paddusb 64(%rdx,%rax,4), %xmm6

// CHECK: paddusb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0x74,0x02,0x40]
paddusb 64(%rdx,%rax), %xmm6

// CHECK: paddusb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0x72,0x40]
paddusb 64(%rdx), %xmm6

// CHECK: paddusb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0x32]
paddusb (%rdx), %xmm6

// CHECK: paddusb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdc,0xf6]
paddusb %xmm6, %xmm6

// CHECK: paddusw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddusw 485498096, %xmm6

// CHECK: paddusw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0x74,0x82,0xc0]
paddusw -64(%rdx,%rax,4), %xmm6

// CHECK: paddusw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0x74,0x82,0x40]
paddusw 64(%rdx,%rax,4), %xmm6

// CHECK: paddusw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0x74,0x02,0x40]
paddusw 64(%rdx,%rax), %xmm6

// CHECK: paddusw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0x72,0x40]
paddusw 64(%rdx), %xmm6

// CHECK: paddusw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0x32]
paddusw (%rdx), %xmm6

// CHECK: paddusw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdd,0xf6]
paddusw %xmm6, %xmm6

// CHECK: paddw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
paddw 485498096, %xmm6

// CHECK: paddw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0x74,0x82,0xc0]
paddw -64(%rdx,%rax,4), %xmm6

// CHECK: paddw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0x74,0x82,0x40]
paddw 64(%rdx,%rax,4), %xmm6

// CHECK: paddw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0x74,0x02,0x40]
paddw 64(%rdx,%rax), %xmm6

// CHECK: paddw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0x72,0x40]
paddw 64(%rdx), %xmm6

// CHECK: paddw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0x32]
paddw (%rdx), %xmm6

// CHECK: paddw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfd,0xf6]
paddw %xmm6, %xmm6

// CHECK: pand 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pand 485498096, %xmm6

// CHECK: pand -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0x74,0x82,0xc0]
pand -64(%rdx,%rax,4), %xmm6

// CHECK: pand 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0x74,0x82,0x40]
pand 64(%rdx,%rax,4), %xmm6

// CHECK: pand 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0x74,0x02,0x40]
pand 64(%rdx,%rax), %xmm6

// CHECK: pand 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0x72,0x40]
pand 64(%rdx), %xmm6

// CHECK: pandn 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pandn 485498096, %xmm6

// CHECK: pandn -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0x74,0x82,0xc0]
pandn -64(%rdx,%rax,4), %xmm6

// CHECK: pandn 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0x74,0x82,0x40]
pandn 64(%rdx,%rax,4), %xmm6

// CHECK: pandn 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0x74,0x02,0x40]
pandn 64(%rdx,%rax), %xmm6

// CHECK: pandn 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0x72,0x40]
pandn 64(%rdx), %xmm6

// CHECK: pandn (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0x32]
pandn (%rdx), %xmm6

// CHECK: pandn %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdf,0xf6]
pandn %xmm6, %xmm6

// CHECK: pand (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0x32]
pand (%rdx), %xmm6

// CHECK: pand %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xdb,0xf6]
pand %xmm6, %xmm6

// CHECK: pavgb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pavgb 485498096, %xmm6

// CHECK: pavgb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0x74,0x82,0xc0]
pavgb -64(%rdx,%rax,4), %xmm6

// CHECK: pavgb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0x74,0x82,0x40]
pavgb 64(%rdx,%rax,4), %xmm6

// CHECK: pavgb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0x74,0x02,0x40]
pavgb 64(%rdx,%rax), %xmm6

// CHECK: pavgb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0x72,0x40]
pavgb 64(%rdx), %xmm6

// CHECK: pavgb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0x32]
pavgb (%rdx), %xmm6

// CHECK: pavgb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe0,0xf6]
pavgb %xmm6, %xmm6

// CHECK: pavgw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pavgw 485498096, %xmm6

// CHECK: pavgw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0x74,0x82,0xc0]
pavgw -64(%rdx,%rax,4), %xmm6

// CHECK: pavgw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0x74,0x82,0x40]
pavgw 64(%rdx,%rax,4), %xmm6

// CHECK: pavgw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0x74,0x02,0x40]
pavgw 64(%rdx,%rax), %xmm6

// CHECK: pavgw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0x72,0x40]
pavgw 64(%rdx), %xmm6

// CHECK: pavgw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0x32]
pavgw (%rdx), %xmm6

// CHECK: pavgw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe3,0xf6]
pavgw %xmm6, %xmm6

// CHECK: pcmpeqb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpeqb 485498096, %xmm6

// CHECK: pcmpeqb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0x74,0x82,0xc0]
pcmpeqb -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0x74,0x82,0x40]
pcmpeqb 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0x74,0x02,0x40]
pcmpeqb 64(%rdx,%rax), %xmm6

// CHECK: pcmpeqb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0x72,0x40]
pcmpeqb 64(%rdx), %xmm6

// CHECK: pcmpeqb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0x32]
pcmpeqb (%rdx), %xmm6

// CHECK: pcmpeqb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x74,0xf6]
pcmpeqb %xmm6, %xmm6

// CHECK: pcmpeqd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpeqd 485498096, %xmm6

// CHECK: pcmpeqd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0x74,0x82,0xc0]
pcmpeqd -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0x74,0x82,0x40]
pcmpeqd 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0x74,0x02,0x40]
pcmpeqd 64(%rdx,%rax), %xmm6

// CHECK: pcmpeqd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0x72,0x40]
pcmpeqd 64(%rdx), %xmm6

// CHECK: pcmpeqd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0x32]
pcmpeqd (%rdx), %xmm6

// CHECK: pcmpeqd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x76,0xf6]
pcmpeqd %xmm6, %xmm6

// CHECK: pcmpeqw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpeqw 485498096, %xmm6

// CHECK: pcmpeqw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0x74,0x82,0xc0]
pcmpeqw -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0x74,0x82,0x40]
pcmpeqw 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpeqw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0x74,0x02,0x40]
pcmpeqw 64(%rdx,%rax), %xmm6

// CHECK: pcmpeqw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0x72,0x40]
pcmpeqw 64(%rdx), %xmm6

// CHECK: pcmpeqw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0x32]
pcmpeqw (%rdx), %xmm6

// CHECK: pcmpeqw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x75,0xf6]
pcmpeqw %xmm6, %xmm6

// CHECK: pcmpgtb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpgtb 485498096, %xmm6

// CHECK: pcmpgtb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0x74,0x82,0xc0]
pcmpgtb -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpgtb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0x74,0x82,0x40]
pcmpgtb 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpgtb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0x74,0x02,0x40]
pcmpgtb 64(%rdx,%rax), %xmm6

// CHECK: pcmpgtb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0x72,0x40]
pcmpgtb 64(%rdx), %xmm6

// CHECK: pcmpgtb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0x32]
pcmpgtb (%rdx), %xmm6

// CHECK: pcmpgtb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x64,0xf6]
pcmpgtb %xmm6, %xmm6

// CHECK: pcmpgtd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpgtd 485498096, %xmm6

// CHECK: pcmpgtd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0x74,0x82,0xc0]
pcmpgtd -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpgtd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0x74,0x82,0x40]
pcmpgtd 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpgtd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0x74,0x02,0x40]
pcmpgtd 64(%rdx,%rax), %xmm6

// CHECK: pcmpgtd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0x72,0x40]
pcmpgtd 64(%rdx), %xmm6

// CHECK: pcmpgtd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0x32]
pcmpgtd (%rdx), %xmm6

// CHECK: pcmpgtd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x66,0xf6]
pcmpgtd %xmm6, %xmm6

// CHECK: pcmpgtw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pcmpgtw 485498096, %xmm6

// CHECK: pcmpgtw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0x74,0x82,0xc0]
pcmpgtw -64(%rdx,%rax,4), %xmm6

// CHECK: pcmpgtw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0x74,0x82,0x40]
pcmpgtw 64(%rdx,%rax,4), %xmm6

// CHECK: pcmpgtw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0x74,0x02,0x40]
pcmpgtw 64(%rdx,%rax), %xmm6

// CHECK: pcmpgtw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0x72,0x40]
pcmpgtw 64(%rdx), %xmm6

// CHECK: pcmpgtw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0x32]
pcmpgtw (%rdx), %xmm6

// CHECK: pcmpgtw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x65,0xf6]
pcmpgtw %xmm6, %xmm6

// CHECK: pextrw $0, %xmm6, %r13d
// CHECK: encoding: [0x66,0x44,0x0f,0xc5,0xee,0x00]
pextrw $0, %xmm6, %r13d

// CHECK: pinsrw $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xc4,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pinsrw $0, 485498096, %xmm6

// CHECK: pinsrw $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc4,0x74,0x82,0xc0,0x00]
pinsrw $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pinsrw $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc4,0x74,0x82,0x40,0x00]
pinsrw $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pinsrw $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc4,0x74,0x02,0x40,0x00]
pinsrw $0, 64(%rdx,%rax), %xmm6

// CHECK: pinsrw $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc4,0x72,0x40,0x00]
pinsrw $0, 64(%rdx), %xmm6

// CHECK: pinsrw $0, %r13d, %xmm6
// CHECK: encoding: [0x66,0x41,0x0f,0xc4,0xf5,0x00]
pinsrw $0, %r13d, %xmm6

// CHECK: pinsrw $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc4,0x32,0x00]
pinsrw $0, (%rdx), %xmm6

// CHECK: pmaddwd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaddwd 485498096, %xmm6

// CHECK: pmaddwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0x74,0x82,0xc0]
pmaddwd -64(%rdx,%rax,4), %xmm6

// CHECK: pmaddwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0x74,0x82,0x40]
pmaddwd 64(%rdx,%rax,4), %xmm6

// CHECK: pmaddwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0x74,0x02,0x40]
pmaddwd 64(%rdx,%rax), %xmm6

// CHECK: pmaddwd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0x72,0x40]
pmaddwd 64(%rdx), %xmm6

// CHECK: pmaddwd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0x32]
pmaddwd (%rdx), %xmm6

// CHECK: pmaddwd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf5,0xf6]
pmaddwd %xmm6, %xmm6

// CHECK: pmaxsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaxsw 485498096, %xmm6

// CHECK: pmaxsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0x74,0x82,0xc0]
pmaxsw -64(%rdx,%rax,4), %xmm6

// CHECK: pmaxsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0x74,0x82,0x40]
pmaxsw 64(%rdx,%rax,4), %xmm6

// CHECK: pmaxsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0x74,0x02,0x40]
pmaxsw 64(%rdx,%rax), %xmm6

// CHECK: pmaxsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0x72,0x40]
pmaxsw 64(%rdx), %xmm6

// CHECK: pmaxsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0x32]
pmaxsw (%rdx), %xmm6

// CHECK: pmaxsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xee,0xf6]
pmaxsw %xmm6, %xmm6

// CHECK: pmaxub 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmaxub 485498096, %xmm6

// CHECK: pmaxub -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0x74,0x82,0xc0]
pmaxub -64(%rdx,%rax,4), %xmm6

// CHECK: pmaxub 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0x74,0x82,0x40]
pmaxub 64(%rdx,%rax,4), %xmm6

// CHECK: pmaxub 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0x74,0x02,0x40]
pmaxub 64(%rdx,%rax), %xmm6

// CHECK: pmaxub 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0x72,0x40]
pmaxub 64(%rdx), %xmm6

// CHECK: pmaxub (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0x32]
pmaxub (%rdx), %xmm6

// CHECK: pmaxub %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xde,0xf6]
pmaxub %xmm6, %xmm6

// CHECK: pminsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pminsw 485498096, %xmm6

// CHECK: pminsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0x74,0x82,0xc0]
pminsw -64(%rdx,%rax,4), %xmm6

// CHECK: pminsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0x74,0x82,0x40]
pminsw 64(%rdx,%rax,4), %xmm6

// CHECK: pminsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0x74,0x02,0x40]
pminsw 64(%rdx,%rax), %xmm6

// CHECK: pminsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0x72,0x40]
pminsw 64(%rdx), %xmm6

// CHECK: pminsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0x32]
pminsw (%rdx), %xmm6

// CHECK: pminsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xea,0xf6]
pminsw %xmm6, %xmm6

// CHECK: pminub 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pminub 485498096, %xmm6

// CHECK: pminub -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0x74,0x82,0xc0]
pminub -64(%rdx,%rax,4), %xmm6

// CHECK: pminub 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0x74,0x82,0x40]
pminub 64(%rdx,%rax,4), %xmm6

// CHECK: pminub 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0x74,0x02,0x40]
pminub 64(%rdx,%rax), %xmm6

// CHECK: pminub 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0x72,0x40]
pminub 64(%rdx), %xmm6

// CHECK: pminub (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0x32]
pminub (%rdx), %xmm6

// CHECK: pminub %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xda,0xf6]
pminub %xmm6, %xmm6

// CHECK: pmovmskb %xmm6, %r13d
// CHECK: encoding: [0x66,0x44,0x0f,0xd7,0xee]
pmovmskb %xmm6, %r13d

// CHECK: pmulhuw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmulhuw 485498096, %xmm6

// CHECK: pmulhuw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0x74,0x82,0xc0]
pmulhuw -64(%rdx,%rax,4), %xmm6

// CHECK: pmulhuw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0x74,0x82,0x40]
pmulhuw 64(%rdx,%rax,4), %xmm6

// CHECK: pmulhuw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0x74,0x02,0x40]
pmulhuw 64(%rdx,%rax), %xmm6

// CHECK: pmulhuw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0x72,0x40]
pmulhuw 64(%rdx), %xmm6

// CHECK: pmulhuw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0x32]
pmulhuw (%rdx), %xmm6

// CHECK: pmulhuw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe4,0xf6]
pmulhuw %xmm6, %xmm6

// CHECK: pmulhw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmulhw 485498096, %xmm6

// CHECK: pmulhw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0x74,0x82,0xc0]
pmulhw -64(%rdx,%rax,4), %xmm6

// CHECK: pmulhw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0x74,0x82,0x40]
pmulhw 64(%rdx,%rax,4), %xmm6

// CHECK: pmulhw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0x74,0x02,0x40]
pmulhw 64(%rdx,%rax), %xmm6

// CHECK: pmulhw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0x72,0x40]
pmulhw 64(%rdx), %xmm6

// CHECK: pmulhw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0x32]
pmulhw (%rdx), %xmm6

// CHECK: pmulhw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe5,0xf6]
pmulhw %xmm6, %xmm6

// CHECK: pmullw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmullw 485498096, %xmm6

// CHECK: pmullw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0x74,0x82,0xc0]
pmullw -64(%rdx,%rax,4), %xmm6

// CHECK: pmullw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0x74,0x82,0x40]
pmullw 64(%rdx,%rax,4), %xmm6

// CHECK: pmullw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0x74,0x02,0x40]
pmullw 64(%rdx,%rax), %xmm6

// CHECK: pmullw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0x72,0x40]
pmullw 64(%rdx), %xmm6

// CHECK: pmullw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0x32]
pmullw (%rdx), %xmm6

// CHECK: pmullw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd5,0xf6]
pmullw %xmm6, %xmm6

// CHECK: pmuludq 485498096, %mm4
// CHECK: encoding: [0x0f,0xf4,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096, %mm4

// CHECK: pmuludq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pmuludq 485498096, %xmm6

// CHECK: pmuludq 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0xf4,0x62,0x40]
pmuludq 64(%rdx), %mm4

// CHECK: pmuludq -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0xf4,0x64,0x82,0xc0]
pmuludq -64(%rdx,%rax,4), %mm4

// CHECK: pmuludq 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0xf4,0x64,0x82,0x40]
pmuludq 64(%rdx,%rax,4), %mm4

// CHECK: pmuludq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0x74,0x82,0xc0]
pmuludq -64(%rdx,%rax,4), %xmm6

// CHECK: pmuludq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0x74,0x82,0x40]
pmuludq 64(%rdx,%rax,4), %xmm6

// CHECK: pmuludq 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0xf4,0x64,0x02,0x40]
pmuludq 64(%rdx,%rax), %mm4

// CHECK: pmuludq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0x74,0x02,0x40]
pmuludq 64(%rdx,%rax), %xmm6

// CHECK: pmuludq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0x72,0x40]
pmuludq 64(%rdx), %xmm6

// CHECK: pmuludq %mm4, %mm4
// CHECK: encoding: [0x0f,0xf4,0xe4]
pmuludq %mm4, %mm4

// CHECK: pmuludq (%rdx), %mm4
// CHECK: encoding: [0x0f,0xf4,0x22]
pmuludq (%rdx), %mm4

// CHECK: pmuludq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0x32]
pmuludq (%rdx), %xmm6

// CHECK: pmuludq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf4,0xf6]
pmuludq %xmm6, %xmm6

// CHECK: por 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
por 485498096, %xmm6

// CHECK: por -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0x74,0x82,0xc0]
por -64(%rdx,%rax,4), %xmm6

// CHECK: por 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0x74,0x82,0x40]
por 64(%rdx,%rax,4), %xmm6

// CHECK: por 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0x74,0x02,0x40]
por 64(%rdx,%rax), %xmm6

// CHECK: por 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0x72,0x40]
por 64(%rdx), %xmm6

// CHECK: por (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0x32]
por (%rdx), %xmm6

// CHECK: por %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xeb,0xf6]
por %xmm6, %xmm6

// CHECK: psadbw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psadbw 485498096, %xmm6

// CHECK: psadbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0x74,0x82,0xc0]
psadbw -64(%rdx,%rax,4), %xmm6

// CHECK: psadbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0x74,0x82,0x40]
psadbw 64(%rdx,%rax,4), %xmm6

// CHECK: psadbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0x74,0x02,0x40]
psadbw 64(%rdx,%rax), %xmm6

// CHECK: psadbw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0x72,0x40]
psadbw 64(%rdx), %xmm6

// CHECK: psadbw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0x32]
psadbw (%rdx), %xmm6

// CHECK: psadbw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf6,0xf6]
psadbw %xmm6, %xmm6

// CHECK: pshufd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pshufd $0, 485498096, %xmm6

// CHECK: pshufd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0x74,0x82,0xc0,0x00]
pshufd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pshufd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0x74,0x82,0x40,0x00]
pshufd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pshufd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0x74,0x02,0x40,0x00]
pshufd $0, 64(%rdx,%rax), %xmm6

// CHECK: pshufd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0x72,0x40,0x00]
pshufd $0, 64(%rdx), %xmm6

// CHECK: pshufd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0x32,0x00]
pshufd $0, (%rdx), %xmm6

// CHECK: pshufd $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x70,0xf6,0x00]
pshufd $0, %xmm6, %xmm6

// CHECK: pshufhw $0, 485498096, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pshufhw $0, 485498096, %xmm6

// CHECK: pshufhw $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0x74,0x82,0xc0,0x00]
pshufhw $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pshufhw $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0x74,0x82,0x40,0x00]
pshufhw $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pshufhw $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0x74,0x02,0x40,0x00]
pshufhw $0, 64(%rdx,%rax), %xmm6

// CHECK: pshufhw $0, 64(%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0x72,0x40,0x00]
pshufhw $0, 64(%rdx), %xmm6

// CHECK: pshufhw $0, (%rdx), %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0x32,0x00]
pshufhw $0, (%rdx), %xmm6

// CHECK: pshufhw $0, %xmm6, %xmm6
// CHECK: encoding: [0xf3,0x0f,0x70,0xf6,0x00]
pshufhw $0, %xmm6, %xmm6

// CHECK: pshuflw $0, 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
pshuflw $0, 485498096, %xmm6

// CHECK: pshuflw $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0x74,0x82,0xc0,0x00]
pshuflw $0, -64(%rdx,%rax,4), %xmm6

// CHECK: pshuflw $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0x74,0x82,0x40,0x00]
pshuflw $0, 64(%rdx,%rax,4), %xmm6

// CHECK: pshuflw $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0x74,0x02,0x40,0x00]
pshuflw $0, 64(%rdx,%rax), %xmm6

// CHECK: pshuflw $0, 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0x72,0x40,0x00]
pshuflw $0, 64(%rdx), %xmm6

// CHECK: pshuflw $0, (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0x32,0x00]
pshuflw $0, (%rdx), %xmm6

// CHECK: pshuflw $0, %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x70,0xf6,0x00]
pshuflw $0, %xmm6, %xmm6

// CHECK: pslld $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x72,0xf6,0x00]
pslld $0, %xmm6

// CHECK: pslld 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pslld 485498096, %xmm6

// CHECK: pslld -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0x74,0x82,0xc0]
pslld -64(%rdx,%rax,4), %xmm6

// CHECK: pslld 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0x74,0x82,0x40]
pslld 64(%rdx,%rax,4), %xmm6

// CHECK: pslld 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0x74,0x02,0x40]
pslld 64(%rdx,%rax), %xmm6

// CHECK: pslld 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0x72,0x40]
pslld 64(%rdx), %xmm6

// CHECK: pslldq $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x73,0xfe,0x00]
pslldq $0, %xmm6

// CHECK: pslld (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0x32]
pslld (%rdx), %xmm6

// CHECK: pslld %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf2,0xf6]
pslld %xmm6, %xmm6

// CHECK: psllq $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x73,0xf6,0x00]
psllq $0, %xmm6

// CHECK: psllq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psllq 485498096, %xmm6

// CHECK: psllq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0x74,0x82,0xc0]
psllq -64(%rdx,%rax,4), %xmm6

// CHECK: psllq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0x74,0x82,0x40]
psllq 64(%rdx,%rax,4), %xmm6

// CHECK: psllq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0x74,0x02,0x40]
psllq 64(%rdx,%rax), %xmm6

// CHECK: psllq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0x72,0x40]
psllq 64(%rdx), %xmm6

// CHECK: psllq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0x32]
psllq (%rdx), %xmm6

// CHECK: psllq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf3,0xf6]
psllq %xmm6, %xmm6

// CHECK: psllw $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x71,0xf6,0x00]
psllw $0, %xmm6

// CHECK: psllw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psllw 485498096, %xmm6

// CHECK: psllw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0x74,0x82,0xc0]
psllw -64(%rdx,%rax,4), %xmm6

// CHECK: psllw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0x74,0x82,0x40]
psllw 64(%rdx,%rax,4), %xmm6

// CHECK: psllw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0x74,0x02,0x40]
psllw 64(%rdx,%rax), %xmm6

// CHECK: psllw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0x72,0x40]
psllw 64(%rdx), %xmm6

// CHECK: psllw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0x32]
psllw (%rdx), %xmm6

// CHECK: psllw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf1,0xf6]
psllw %xmm6, %xmm6

// CHECK: psrad $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x72,0xe6,0x00]
psrad $0, %xmm6

// CHECK: psrad 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psrad 485498096, %xmm6

// CHECK: psrad -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0x74,0x82,0xc0]
psrad -64(%rdx,%rax,4), %xmm6

// CHECK: psrad 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0x74,0x82,0x40]
psrad 64(%rdx,%rax,4), %xmm6

// CHECK: psrad 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0x74,0x02,0x40]
psrad 64(%rdx,%rax), %xmm6

// CHECK: psrad 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0x72,0x40]
psrad 64(%rdx), %xmm6

// CHECK: psrad (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0x32]
psrad (%rdx), %xmm6

// CHECK: psrad %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe2,0xf6]
psrad %xmm6, %xmm6

// CHECK: psraw $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x71,0xe6,0x00]
psraw $0, %xmm6

// CHECK: psraw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psraw 485498096, %xmm6

// CHECK: psraw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0x74,0x82,0xc0]
psraw -64(%rdx,%rax,4), %xmm6

// CHECK: psraw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0x74,0x82,0x40]
psraw 64(%rdx,%rax,4), %xmm6

// CHECK: psraw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0x74,0x02,0x40]
psraw 64(%rdx,%rax), %xmm6

// CHECK: psraw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0x72,0x40]
psraw 64(%rdx), %xmm6

// CHECK: psraw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0x32]
psraw (%rdx), %xmm6

// CHECK: psraw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe1,0xf6]
psraw %xmm6, %xmm6

// CHECK: psrld $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x72,0xd6,0x00]
psrld $0, %xmm6

// CHECK: psrld 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psrld 485498096, %xmm6

// CHECK: psrld -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0x74,0x82,0xc0]
psrld -64(%rdx,%rax,4), %xmm6

// CHECK: psrld 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0x74,0x82,0x40]
psrld 64(%rdx,%rax,4), %xmm6

// CHECK: psrld 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0x74,0x02,0x40]
psrld 64(%rdx,%rax), %xmm6

// CHECK: psrld 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0x72,0x40]
psrld 64(%rdx), %xmm6

// CHECK: psrldq $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x73,0xde,0x00]
psrldq $0, %xmm6

// CHECK: psrld (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0x32]
psrld (%rdx), %xmm6

// CHECK: psrld %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd2,0xf6]
psrld %xmm6, %xmm6

// CHECK: psrlq $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x73,0xd6,0x00]
psrlq $0, %xmm6

// CHECK: psrlq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psrlq 485498096, %xmm6

// CHECK: psrlq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0x74,0x82,0xc0]
psrlq -64(%rdx,%rax,4), %xmm6

// CHECK: psrlq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0x74,0x82,0x40]
psrlq 64(%rdx,%rax,4), %xmm6

// CHECK: psrlq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0x74,0x02,0x40]
psrlq 64(%rdx,%rax), %xmm6

// CHECK: psrlq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0x72,0x40]
psrlq 64(%rdx), %xmm6

// CHECK: psrlq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0x32]
psrlq (%rdx), %xmm6

// CHECK: psrlq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd3,0xf6]
psrlq %xmm6, %xmm6

// CHECK: psrlw $0, %xmm6
// CHECK: encoding: [0x66,0x0f,0x71,0xd6,0x00]
psrlw $0, %xmm6

// CHECK: psrlw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psrlw 485498096, %xmm6

// CHECK: psrlw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0x74,0x82,0xc0]
psrlw -64(%rdx,%rax,4), %xmm6

// CHECK: psrlw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0x74,0x82,0x40]
psrlw 64(%rdx,%rax,4), %xmm6

// CHECK: psrlw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0x74,0x02,0x40]
psrlw 64(%rdx,%rax), %xmm6

// CHECK: psrlw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0x72,0x40]
psrlw 64(%rdx), %xmm6

// CHECK: psrlw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0x32]
psrlw (%rdx), %xmm6

// CHECK: psrlw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd1,0xf6]
psrlw %xmm6, %xmm6

// CHECK: psubb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubb 485498096, %xmm6

// CHECK: psubb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0x74,0x82,0xc0]
psubb -64(%rdx,%rax,4), %xmm6

// CHECK: psubb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0x74,0x82,0x40]
psubb 64(%rdx,%rax,4), %xmm6

// CHECK: psubb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0x74,0x02,0x40]
psubb 64(%rdx,%rax), %xmm6

// CHECK: psubb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0x72,0x40]
psubb 64(%rdx), %xmm6

// CHECK: psubb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0x32]
psubb (%rdx), %xmm6

// CHECK: psubb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf8,0xf6]
psubb %xmm6, %xmm6

// CHECK: psubd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubd 485498096, %xmm6

// CHECK: psubd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0x74,0x82,0xc0]
psubd -64(%rdx,%rax,4), %xmm6

// CHECK: psubd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0x74,0x82,0x40]
psubd 64(%rdx,%rax,4), %xmm6

// CHECK: psubd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0x74,0x02,0x40]
psubd 64(%rdx,%rax), %xmm6

// CHECK: psubd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0x72,0x40]
psubd 64(%rdx), %xmm6

// CHECK: psubd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0x32]
psubd (%rdx), %xmm6

// CHECK: psubd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfa,0xf6]
psubd %xmm6, %xmm6

// CHECK: psubq 485498096, %mm4
// CHECK: encoding: [0x0f,0xfb,0x24,0x25,0xf0,0x1c,0xf0,0x1c]
psubq 485498096, %mm4

// CHECK: psubq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubq 485498096, %xmm6

// CHECK: psubq 64(%rdx), %mm4
// CHECK: encoding: [0x0f,0xfb,0x62,0x40]
psubq 64(%rdx), %mm4

// CHECK: psubq -64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0xfb,0x64,0x82,0xc0]
psubq -64(%rdx,%rax,4), %mm4

// CHECK: psubq 64(%rdx,%rax,4), %mm4
// CHECK: encoding: [0x0f,0xfb,0x64,0x82,0x40]
psubq 64(%rdx,%rax,4), %mm4

// CHECK: psubq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0x74,0x82,0xc0]
psubq -64(%rdx,%rax,4), %xmm6

// CHECK: psubq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0x74,0x82,0x40]
psubq 64(%rdx,%rax,4), %xmm6

// CHECK: psubq 64(%rdx,%rax), %mm4
// CHECK: encoding: [0x0f,0xfb,0x64,0x02,0x40]
psubq 64(%rdx,%rax), %mm4

// CHECK: psubq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0x74,0x02,0x40]
psubq 64(%rdx,%rax), %xmm6

// CHECK: psubq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0x72,0x40]
psubq 64(%rdx), %xmm6

// CHECK: psubq %mm4, %mm4
// CHECK: encoding: [0x0f,0xfb,0xe4]
psubq %mm4, %mm4

// CHECK: psubq (%rdx), %mm4
// CHECK: encoding: [0x0f,0xfb,0x22]
psubq (%rdx), %mm4

// CHECK: psubq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0x32]
psubq (%rdx), %xmm6

// CHECK: psubq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xfb,0xf6]
psubq %xmm6, %xmm6

// CHECK: psubsb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubsb 485498096, %xmm6

// CHECK: psubsb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0x74,0x82,0xc0]
psubsb -64(%rdx,%rax,4), %xmm6

// CHECK: psubsb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0x74,0x82,0x40]
psubsb 64(%rdx,%rax,4), %xmm6

// CHECK: psubsb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0x74,0x02,0x40]
psubsb 64(%rdx,%rax), %xmm6

// CHECK: psubsb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0x72,0x40]
psubsb 64(%rdx), %xmm6

// CHECK: psubsb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0x32]
psubsb (%rdx), %xmm6

// CHECK: psubsb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe8,0xf6]
psubsb %xmm6, %xmm6

// CHECK: psubsw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubsw 485498096, %xmm6

// CHECK: psubsw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0x74,0x82,0xc0]
psubsw -64(%rdx,%rax,4), %xmm6

// CHECK: psubsw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0x74,0x82,0x40]
psubsw 64(%rdx,%rax,4), %xmm6

// CHECK: psubsw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0x74,0x02,0x40]
psubsw 64(%rdx,%rax), %xmm6

// CHECK: psubsw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0x72,0x40]
psubsw 64(%rdx), %xmm6

// CHECK: psubsw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0x32]
psubsw (%rdx), %xmm6

// CHECK: psubsw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xe9,0xf6]
psubsw %xmm6, %xmm6

// CHECK: psubusb 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubusb 485498096, %xmm6

// CHECK: psubusb -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0x74,0x82,0xc0]
psubusb -64(%rdx,%rax,4), %xmm6

// CHECK: psubusb 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0x74,0x82,0x40]
psubusb 64(%rdx,%rax,4), %xmm6

// CHECK: psubusb 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0x74,0x02,0x40]
psubusb 64(%rdx,%rax), %xmm6

// CHECK: psubusb 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0x72,0x40]
psubusb 64(%rdx), %xmm6

// CHECK: psubusb (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0x32]
psubusb (%rdx), %xmm6

// CHECK: psubusb %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd8,0xf6]
psubusb %xmm6, %xmm6

// CHECK: psubusw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubusw 485498096, %xmm6

// CHECK: psubusw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0x74,0x82,0xc0]
psubusw -64(%rdx,%rax,4), %xmm6

// CHECK: psubusw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0x74,0x82,0x40]
psubusw 64(%rdx,%rax,4), %xmm6

// CHECK: psubusw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0x74,0x02,0x40]
psubusw 64(%rdx,%rax), %xmm6

// CHECK: psubusw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0x72,0x40]
psubusw 64(%rdx), %xmm6

// CHECK: psubusw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0x32]
psubusw (%rdx), %xmm6

// CHECK: psubusw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xd9,0xf6]
psubusw %xmm6, %xmm6

// CHECK: psubw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
psubw 485498096, %xmm6

// CHECK: psubw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0x74,0x82,0xc0]
psubw -64(%rdx,%rax,4), %xmm6

// CHECK: psubw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0x74,0x82,0x40]
psubw 64(%rdx,%rax,4), %xmm6

// CHECK: psubw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0x74,0x02,0x40]
psubw 64(%rdx,%rax), %xmm6

// CHECK: psubw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0x72,0x40]
psubw 64(%rdx), %xmm6

// CHECK: psubw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0x32]
psubw (%rdx), %xmm6

// CHECK: psubw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xf9,0xf6]
psubw %xmm6, %xmm6

// CHECK: punpckhbw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpckhbw 485498096, %xmm6

// CHECK: punpckhbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0x74,0x82,0xc0]
punpckhbw -64(%rdx,%rax,4), %xmm6

// CHECK: punpckhbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0x74,0x82,0x40]
punpckhbw 64(%rdx,%rax,4), %xmm6

// CHECK: punpckhbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0x74,0x02,0x40]
punpckhbw 64(%rdx,%rax), %xmm6

// CHECK: punpckhbw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0x72,0x40]
punpckhbw 64(%rdx), %xmm6

// CHECK: punpckhbw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0x32]
punpckhbw (%rdx), %xmm6

// CHECK: punpckhbw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x68,0xf6]
punpckhbw %xmm6, %xmm6

// CHECK: punpckhdq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpckhdq 485498096, %xmm6

// CHECK: punpckhdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0x74,0x82,0xc0]
punpckhdq -64(%rdx,%rax,4), %xmm6

// CHECK: punpckhdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0x74,0x82,0x40]
punpckhdq 64(%rdx,%rax,4), %xmm6

// CHECK: punpckhdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0x74,0x02,0x40]
punpckhdq 64(%rdx,%rax), %xmm6

// CHECK: punpckhdq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0x72,0x40]
punpckhdq 64(%rdx), %xmm6

// CHECK: punpckhdq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0x32]
punpckhdq (%rdx), %xmm6

// CHECK: punpckhdq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6a,0xf6]
punpckhdq %xmm6, %xmm6

// CHECK: punpckhqdq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpckhqdq 485498096, %xmm6

// CHECK: punpckhqdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0x74,0x82,0xc0]
punpckhqdq -64(%rdx,%rax,4), %xmm6

// CHECK: punpckhqdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0x74,0x82,0x40]
punpckhqdq 64(%rdx,%rax,4), %xmm6

// CHECK: punpckhqdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0x74,0x02,0x40]
punpckhqdq 64(%rdx,%rax), %xmm6

// CHECK: punpckhqdq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0x72,0x40]
punpckhqdq 64(%rdx), %xmm6

// CHECK: punpckhqdq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0x32]
punpckhqdq (%rdx), %xmm6

// CHECK: punpckhqdq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6d,0xf6]
punpckhqdq %xmm6, %xmm6

// CHECK: punpckhwd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpckhwd 485498096, %xmm6

// CHECK: punpckhwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0x74,0x82,0xc0]
punpckhwd -64(%rdx,%rax,4), %xmm6

// CHECK: punpckhwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0x74,0x82,0x40]
punpckhwd 64(%rdx,%rax,4), %xmm6

// CHECK: punpckhwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0x74,0x02,0x40]
punpckhwd 64(%rdx,%rax), %xmm6

// CHECK: punpckhwd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0x72,0x40]
punpckhwd 64(%rdx), %xmm6

// CHECK: punpckhwd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0x32]
punpckhwd (%rdx), %xmm6

// CHECK: punpckhwd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x69,0xf6]
punpckhwd %xmm6, %xmm6

// CHECK: punpcklbw 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpcklbw 485498096, %xmm6

// CHECK: punpcklbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0x74,0x82,0xc0]
punpcklbw -64(%rdx,%rax,4), %xmm6

// CHECK: punpcklbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0x74,0x82,0x40]
punpcklbw 64(%rdx,%rax,4), %xmm6

// CHECK: punpcklbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0x74,0x02,0x40]
punpcklbw 64(%rdx,%rax), %xmm6

// CHECK: punpcklbw 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0x72,0x40]
punpcklbw 64(%rdx), %xmm6

// CHECK: punpcklbw (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0x32]
punpcklbw (%rdx), %xmm6

// CHECK: punpcklbw %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x60,0xf6]
punpcklbw %xmm6, %xmm6

// CHECK: punpckldq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpckldq 485498096, %xmm6

// CHECK: punpckldq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0x74,0x82,0xc0]
punpckldq -64(%rdx,%rax,4), %xmm6

// CHECK: punpckldq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0x74,0x82,0x40]
punpckldq 64(%rdx,%rax,4), %xmm6

// CHECK: punpckldq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0x74,0x02,0x40]
punpckldq 64(%rdx,%rax), %xmm6

// CHECK: punpckldq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0x72,0x40]
punpckldq 64(%rdx), %xmm6

// CHECK: punpckldq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0x32]
punpckldq (%rdx), %xmm6

// CHECK: punpckldq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x62,0xf6]
punpckldq %xmm6, %xmm6

// CHECK: punpcklqdq 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpcklqdq 485498096, %xmm6

// CHECK: punpcklqdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0x74,0x82,0xc0]
punpcklqdq -64(%rdx,%rax,4), %xmm6

// CHECK: punpcklqdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0x74,0x82,0x40]
punpcklqdq 64(%rdx,%rax,4), %xmm6

// CHECK: punpcklqdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0x74,0x02,0x40]
punpcklqdq 64(%rdx,%rax), %xmm6

// CHECK: punpcklqdq 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0x72,0x40]
punpcklqdq 64(%rdx), %xmm6

// CHECK: punpcklqdq (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0x32]
punpcklqdq (%rdx), %xmm6

// CHECK: punpcklqdq %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x6c,0xf6]
punpcklqdq %xmm6, %xmm6

// CHECK: punpcklwd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
punpcklwd 485498096, %xmm6

// CHECK: punpcklwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0x74,0x82,0xc0]
punpcklwd -64(%rdx,%rax,4), %xmm6

// CHECK: punpcklwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0x74,0x82,0x40]
punpcklwd 64(%rdx,%rax,4), %xmm6

// CHECK: punpcklwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0x74,0x02,0x40]
punpcklwd 64(%rdx,%rax), %xmm6

// CHECK: punpcklwd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0x72,0x40]
punpcklwd 64(%rdx), %xmm6

// CHECK: punpcklwd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0x32]
punpcklwd (%rdx), %xmm6

// CHECK: punpcklwd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x61,0xf6]
punpcklwd %xmm6, %xmm6

// CHECK: pxor 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
pxor 485498096, %xmm6

// CHECK: pxor -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0x74,0x82,0xc0]
pxor -64(%rdx,%rax,4), %xmm6

// CHECK: pxor 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0x74,0x82,0x40]
pxor 64(%rdx,%rax,4), %xmm6

// CHECK: pxor 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0x74,0x02,0x40]
pxor 64(%rdx,%rax), %xmm6

// CHECK: pxor 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0x72,0x40]
pxor 64(%rdx), %xmm6

// CHECK: pxor (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0x32]
pxor (%rdx), %xmm6

// CHECK: pxor %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xef,0xf6]
pxor %xmm6, %xmm6

// CHECK: shufpd $0, 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
shufpd $0, 485498096, %xmm6

// CHECK: shufpd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0x74,0x82,0xc0,0x00]
shufpd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: shufpd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0x74,0x82,0x40,0x00]
shufpd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: shufpd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0x74,0x02,0x40,0x00]
shufpd $0, 64(%rdx,%rax), %xmm6

// CHECK: shufpd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0x72,0x40,0x00]
shufpd $0, 64(%rdx), %xmm6

// CHECK: shufpd $0, (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0x32,0x00]
shufpd $0, (%rdx), %xmm6

// CHECK: shufpd $0, %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0xc6,0xf6,0x00]
shufpd $0, %xmm6, %xmm6

// CHECK: sqrtpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
sqrtpd 485498096, %xmm6

// CHECK: sqrtpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0x74,0x82,0xc0]
sqrtpd -64(%rdx,%rax,4), %xmm6

// CHECK: sqrtpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0x74,0x82,0x40]
sqrtpd 64(%rdx,%rax,4), %xmm6

// CHECK: sqrtpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0x74,0x02,0x40]
sqrtpd 64(%rdx,%rax), %xmm6

// CHECK: sqrtpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0x72,0x40]
sqrtpd 64(%rdx), %xmm6

// CHECK: sqrtpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0x32]
sqrtpd (%rdx), %xmm6

// CHECK: sqrtpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x51,0xf6]
sqrtpd %xmm6, %xmm6

// CHECK: sqrtsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
sqrtsd 485498096, %xmm6

// CHECK: sqrtsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0x74,0x82,0xc0]
sqrtsd -64(%rdx,%rax,4), %xmm6

// CHECK: sqrtsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0x74,0x82,0x40]
sqrtsd 64(%rdx,%rax,4), %xmm6

// CHECK: sqrtsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0x74,0x02,0x40]
sqrtsd 64(%rdx,%rax), %xmm6

// CHECK: sqrtsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0x72,0x40]
sqrtsd 64(%rdx), %xmm6

// CHECK: sqrtsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0x32]
sqrtsd (%rdx), %xmm6

// CHECK: sqrtsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x51,0xf6]
sqrtsd %xmm6, %xmm6

// CHECK: subpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
subpd 485498096, %xmm6

// CHECK: subpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0x74,0x82,0xc0]
subpd -64(%rdx,%rax,4), %xmm6

// CHECK: subpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0x74,0x82,0x40]
subpd 64(%rdx,%rax,4), %xmm6

// CHECK: subpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0x74,0x02,0x40]
subpd 64(%rdx,%rax), %xmm6

// CHECK: subpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0x72,0x40]
subpd 64(%rdx), %xmm6

// CHECK: subpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0x32]
subpd (%rdx), %xmm6

// CHECK: subpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x5c,0xf6]
subpd %xmm6, %xmm6

// CHECK: subsd 485498096, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
subsd 485498096, %xmm6

// CHECK: subsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0x74,0x82,0xc0]
subsd -64(%rdx,%rax,4), %xmm6

// CHECK: subsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0x74,0x82,0x40]
subsd 64(%rdx,%rax,4), %xmm6

// CHECK: subsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0x74,0x02,0x40]
subsd 64(%rdx,%rax), %xmm6

// CHECK: subsd 64(%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0x72,0x40]
subsd 64(%rdx), %xmm6

// CHECK: subsd (%rdx), %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0x32]
subsd (%rdx), %xmm6

// CHECK: subsd %xmm6, %xmm6
// CHECK: encoding: [0xf2,0x0f,0x5c,0xf6]
subsd %xmm6, %xmm6

// CHECK: ucomisd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
ucomisd 485498096, %xmm6

// CHECK: ucomisd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0x74,0x82,0xc0]
ucomisd -64(%rdx,%rax,4), %xmm6

// CHECK: ucomisd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0x74,0x82,0x40]
ucomisd 64(%rdx,%rax,4), %xmm6

// CHECK: ucomisd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0x74,0x02,0x40]
ucomisd 64(%rdx,%rax), %xmm6

// CHECK: ucomisd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0x72,0x40]
ucomisd 64(%rdx), %xmm6

// CHECK: ucomisd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0x32]
ucomisd (%rdx), %xmm6

// CHECK: ucomisd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x2e,0xf6]
ucomisd %xmm6, %xmm6

// CHECK: unpckhpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
unpckhpd 485498096, %xmm6

// CHECK: unpckhpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0x74,0x82,0xc0]
unpckhpd -64(%rdx,%rax,4), %xmm6

// CHECK: unpckhpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0x74,0x82,0x40]
unpckhpd 64(%rdx,%rax,4), %xmm6

// CHECK: unpckhpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0x74,0x02,0x40]
unpckhpd 64(%rdx,%rax), %xmm6

// CHECK: unpckhpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0x72,0x40]
unpckhpd 64(%rdx), %xmm6

// CHECK: unpckhpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0x32]
unpckhpd (%rdx), %xmm6

// CHECK: unpckhpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x15,0xf6]
unpckhpd %xmm6, %xmm6

// CHECK: unpcklpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
unpcklpd 485498096, %xmm6

// CHECK: unpcklpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0x74,0x82,0xc0]
unpcklpd -64(%rdx,%rax,4), %xmm6

// CHECK: unpcklpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0x74,0x82,0x40]
unpcklpd 64(%rdx,%rax,4), %xmm6

// CHECK: unpcklpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0x74,0x02,0x40]
unpcklpd 64(%rdx,%rax), %xmm6

// CHECK: unpcklpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0x72,0x40]
unpcklpd 64(%rdx), %xmm6

// CHECK: unpcklpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0x32]
unpcklpd (%rdx), %xmm6

// CHECK: unpcklpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x14,0xf6]
unpcklpd %xmm6, %xmm6

// CHECK: xorpd 485498096, %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
xorpd 485498096, %xmm6

// CHECK: xorpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0x74,0x82,0xc0]
xorpd -64(%rdx,%rax,4), %xmm6

// CHECK: xorpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0x74,0x82,0x40]
xorpd 64(%rdx,%rax,4), %xmm6

// CHECK: xorpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0x74,0x02,0x40]
xorpd 64(%rdx,%rax), %xmm6

// CHECK: xorpd 64(%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0x72,0x40]
xorpd 64(%rdx), %xmm6

// CHECK: xorpd (%rdx), %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0x32]
xorpd (%rdx), %xmm6

// CHECK: xorpd %xmm6, %xmm6
// CHECK: encoding: [0x66,0x0f,0x57,0xf6]
xorpd %xmm6, %xmm6

