; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -slp-vectorizer -S < %s -mtriple=x86_64-unknown-linux-gnu -mcpu=bdver2 | FileCheck %s

define float @jacobi(float* %p, float %x, float %y, float %z) {
; CHECK-LABEL: @jacobi(
; CHECK-NEXT:    [[GEP1:%.*]] = getelementptr float, float* [[P:%.*]], i64 1
; CHECK-NEXT:    [[GEP2:%.*]] = getelementptr float, float* [[P]], i64 2
; CHECK-NEXT:    [[P1:%.*]] = load float, float* [[GEP1]]
; CHECK-NEXT:    [[P2:%.*]] = load float, float* [[GEP2]]
; CHECK-NEXT:    [[MUL1:%.*]] = fmul float [[P1]], [[X:%.*]]
; CHECK-NEXT:    [[MUL2:%.*]] = fmul float [[P2]], [[Y:%.*]]
; CHECK-NEXT:    [[ADD1:%.*]] = fadd float [[MUL1]], [[Z:%.*]]
; CHECK-NEXT:    [[ADD2:%.*]] = fadd float [[MUL2]], [[ADD1]]
; CHECK-NEXT:    ret float [[ADD2]]
;
  %gep1 = getelementptr float, float* %p, i64 1
  %gep2 = getelementptr float, float* %p, i64 2
  %p1 = load float, float* %gep1
  %p2 = load float, float* %gep2
  %mul1 = fmul float %p1, %x
  %mul2 = fmul float %p2, %y
  %add1 = fadd float %mul1, %z
  %add2 = fadd float %mul2, %add1
  ret float %add2
}
