; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-arm-none-eabi -mattr=+mve,+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-MVE
; RUN: llc -mtriple=thumbv8.1m.main-arm-none-eabi -mattr=+mve.fp -verify-machineinstrs %s -o - | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-MVEFP

define arm_aapcs_vfpcc <4 x float> @sqrt_float32_t(<4 x float> %src) {
; CHECK-LABEL: sqrt_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vsqrt.f32 s7, s3
; CHECK-NEXT:    vsqrt.f32 s6, s2
; CHECK-NEXT:    vsqrt.f32 s5, s1
; CHECK-NEXT:    vsqrt.f32 s4, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call fast <4 x float> @llvm.sqrt.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @sqrt_float16_t(<8 x half> %src) {
; CHECK-LABEL: sqrt_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u16 r0, q0[0]
; CHECK-NEXT:    vmov.u16 r1, q0[1]
; CHECK-NEXT:    vmov s4, r0
; CHECK-NEXT:    vsqrt.f16 s4, s4
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov s4, r1
; CHECK-NEXT:    vsqrt.f16 s4, s4
; CHECK-NEXT:    vmov r1, s4
; CHECK-NEXT:    vmov.16 q1[0], r0
; CHECK-NEXT:    vmov.u16 r0, q0[2]
; CHECK-NEXT:    vmov.16 q1[1], r1
; CHECK-NEXT:    vmov s8, r0
; CHECK-NEXT:    vsqrt.f16 s8, s8
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q1[2], r0
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    vmov s8, r0
; CHECK-NEXT:    vsqrt.f16 s8, s8
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q1[3], r0
; CHECK-NEXT:    vmov.u16 r0, q0[4]
; CHECK-NEXT:    vmov s8, r0
; CHECK-NEXT:    vsqrt.f16 s8, s8
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q1[4], r0
; CHECK-NEXT:    vmov.u16 r0, q0[5]
; CHECK-NEXT:    vmov s8, r0
; CHECK-NEXT:    vsqrt.f16 s8, s8
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q1[5], r0
; CHECK-NEXT:    vmov.u16 r0, q0[6]
; CHECK-NEXT:    vmov s8, r0
; CHECK-NEXT:    vsqrt.f16 s8, s8
; CHECK-NEXT:    vmov r0, s8
; CHECK-NEXT:    vmov.16 q1[6], r0
; CHECK-NEXT:    vmov.u16 r0, q0[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vsqrt.f16 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q1[7], r0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call fast <8 x half> @llvm.sqrt.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @cos_float32_t(<4 x float> %src) {
; CHECK-LABEL: cos_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.cos.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @cos_float16_t(<8 x half> %src) {
; CHECK-LABEL: cos_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl cosf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.cos.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @sin_float32_t(<4 x float> %src) {
; CHECK-LABEL: sin_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.sin.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @sin_float16_t(<8 x half> %src) {
; CHECK-LABEL: sin_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl sinf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.sin.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @exp_float32_t(<4 x float> %src) {
; CHECK-LABEL: exp_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.exp.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @exp_float16_t(<8 x half> %src) {
; CHECK-LABEL: exp_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl expf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.exp.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @exp2_float32_t(<4 x float> %src) {
; CHECK-LABEL: exp2_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.exp2.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @exp2_float16_t(<8 x half> %src) {
; CHECK-LABEL: exp2_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl exp2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.exp2.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @log_float32_t(<4 x float> %src) {
; CHECK-LABEL: log_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.log.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @log_float16_t(<8 x half> %src) {
; CHECK-LABEL: log_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl logf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.log.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @log2_float32_t(<4 x float> %src) {
; CHECK-LABEL: log2_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.log2.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @log2_float16_t(<8 x half> %src) {
; CHECK-LABEL: log2_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl log2f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.log2.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @log10_float32_t(<4 x float> %src) {
; CHECK-LABEL: log10_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, #16
; CHECK-NEXT:    vstmia sp, {s0, s1, s2, s3}
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    mov r4, r0
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    ldrd r5, r1, [sp]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    mov r0, r1
; CHECK-NEXT:    vmov s18, r4
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r5
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #16
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r7, pc}
entry:
  %0 = call fast <4 x float> @llvm.log10.v4f32(<4 x float> %src)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @log10_float16_t(<8 x half> %src) {
; CHECK-LABEL: log10_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #24]
; CHECK-NEXT:    ldr r0, [sp, #24]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldr r0, [sp, #28]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[0], r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q5[1], r4
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldr r0, [sp, #20]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[2], r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #16]
; CHECK-NEXT:    ldr r0, [sp, #16]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[3], r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldr r0, [sp, #12]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[4], r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #8]
; CHECK-NEXT:    ldr r0, [sp, #8]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[5], r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldr r0, [sp, #4]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[6], r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r0, [sp]
; CHECK-NEXT:    bl log10f
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q5[7], r0
; CHECK-NEXT:    vmov q0, q5
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.log10.v8f16(<8 x half> %src)
  ret <8 x half> %0
}

define arm_aapcs_vfpcc <4 x float> @pow_float32_t(<4 x float> %src1, <4 x float> %src2) {
; CHECK-LABEL: pow_float32_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, r5, r6, lr}
; CHECK-NEXT:    push {r4, r5, r6, lr}
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    vstr s0, [sp]
; CHECK-NEXT:    ldr r4, [sp]
; CHECK-NEXT:    vstr s2, [sp, #16]
; CHECK-NEXT:    vstr s6, [sp, #20]
; CHECK-NEXT:    vstr s3, [sp, #24]
; CHECK-NEXT:    vstr s7, [sp, #28]
; CHECK-NEXT:    vstr s4, [sp, #4]
; CHECK-NEXT:    vstr s1, [sp, #8]
; CHECK-NEXT:    vstr s5, [sp, #12]
; CHECK-NEXT:    ldrd r0, r1, [sp, #16]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    mov r5, r0
; CHECK-NEXT:    ldrd r0, r1, [sp, #24]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    ldr r1, [sp, #12]
; CHECK-NEXT:    vmov s19, r0
; CHECK-NEXT:    ldrd r6, r2, [sp, #4]
; CHECK-NEXT:    vmov s18, r5
; CHECK-NEXT:    mov r0, r2
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s17, r0
; CHECK-NEXT:    mov r0, r4
; CHECK-NEXT:    mov r1, r6
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s16, r0
; CHECK-NEXT:    vmov q0, q4
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    pop {r4, r5, r6, pc}
entry:
  %0 = call fast <4 x float> @llvm.pow.v4f32(<4 x float> %src1, <4 x float> %src2)
  ret <4 x float> %0
}

define arm_aapcs_vfpcc <8 x half> @pow_float16_t(<8 x half> %src1, <8 x half> %src2) {
; CHECK-LABEL: pow_float16_t:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    .pad #64
; CHECK-NEXT:    sub sp, #64
; CHECK-NEXT:    vmov q5, q1
; CHECK-NEXT:    vmov q4, q0
; CHECK-NEXT:    vmov.u16 r0, q1[0]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[0]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #56]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #60]
; CHECK-NEXT:    ldrd r0, r1, [sp, #56]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q5[1]
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r4, s0
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[1]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #48]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #52]
; CHECK-NEXT:    ldrd r0, r1, [sp, #48]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.16 q6[0], r4
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[1], r0
; CHECK-NEXT:    vmov.u16 r0, q5[2]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[2]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #40]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #44]
; CHECK-NEXT:    ldrd r0, r1, [sp, #40]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[2], r0
; CHECK-NEXT:    vmov.u16 r0, q5[3]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[3]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #32]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #36]
; CHECK-NEXT:    ldrd r0, r1, [sp, #32]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[3], r0
; CHECK-NEXT:    vmov.u16 r0, q5[4]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[4]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #24]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #28]
; CHECK-NEXT:    ldrd r0, r1, [sp, #24]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[4], r0
; CHECK-NEXT:    vmov.u16 r0, q5[5]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[5]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #16]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #20]
; CHECK-NEXT:    ldrd r0, r1, [sp, #16]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[5], r0
; CHECK-NEXT:    vmov.u16 r0, q5[6]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[6]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp, #8]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #12]
; CHECK-NEXT:    ldrd r0, r1, [sp, #8]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[6], r0
; CHECK-NEXT:    vmov.u16 r0, q5[7]
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vmov.u16 r0, q4[7]
; CHECK-NEXT:    vmov s2, r0
; CHECK-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-NEXT:    vstr s2, [sp]
; CHECK-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-NEXT:    vstr s0, [sp, #4]
; CHECK-NEXT:    ldrd r0, r1, [sp]
; CHECK-NEXT:    bl powf
; CHECK-NEXT:    vmov s0, r0
; CHECK-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    vmov.16 q6[7], r0
; CHECK-NEXT:    vmov q0, q6
; CHECK-NEXT:    add sp, #64
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    pop {r4, pc}
entry:
  %0 = call fast <8 x half> @llvm.pow.v8f16(<8 x half> %src1, <8 x half> %src2)
  ret <8 x half> %0
}

declare <4 x float> @llvm.sqrt.v4f32(<4 x float>)
declare <4 x float> @llvm.cos.v4f32(<4 x float>)
declare <4 x float> @llvm.sin.v4f32(<4 x float>)
declare <4 x float> @llvm.exp.v4f32(<4 x float>)
declare <4 x float> @llvm.exp2.v4f32(<4 x float>)
declare <4 x float> @llvm.log.v4f32(<4 x float>)
declare <4 x float> @llvm.log2.v4f32(<4 x float>)
declare <4 x float> @llvm.log10.v4f32(<4 x float>)
declare <4 x float> @llvm.pow.v4f32(<4 x float>, <4 x float>)
declare <8 x half> @llvm.sqrt.v8f16(<8 x half>)
declare <8 x half> @llvm.cos.v8f16(<8 x half>)
declare <8 x half> @llvm.sin.v8f16(<8 x half>)
declare <8 x half> @llvm.exp.v8f16(<8 x half>)
declare <8 x half> @llvm.exp2.v8f16(<8 x half>)
declare <8 x half> @llvm.log.v8f16(<8 x half>)
declare <8 x half> @llvm.log2.v8f16(<8 x half>)
declare <8 x half> @llvm.log10.v8f16(<8 x half>)
declare <8 x half> @llvm.pow.v8f16(<8 x half>, <8 x half>)

