; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=sse2    | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=sse4.2  | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx     | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx2    | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512dq,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL,AVX512VLDQ
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512bw,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL,AVX512VLBW

;
; vXf64
;

define <2 x double> @expandload_v2f64_v2i64(double* %base, <2 x double> %src0, <2 x i64> %trigger) {
; SSE2-LABEL: expandload_v2f64_v2i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE2-NEXT:  LBB0_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v2f64_v2i64:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqq %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_2: ## %else
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE42-NEXT:  LBB0_4: ## %else2
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v2f64_v2i64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.load
; AVX1OR2-NEXT:    vmovlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_2: ## %else
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.load1
; AVX1OR2-NEXT:    vmovhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX1OR2-NEXT:  LBB0_4: ## %else2
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v2f64_v2i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vexpandpd (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: expandload_v2f64_v2i64:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestnmq %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vexpandpd (%rdi), %xmm0 {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <2 x i64> %trigger, zeroinitializer
  %res = call <2 x double> @llvm.masked.expandload.v2f64(double* %base, <2 x i1> %mask, <2 x double> %src0)
  ret <2 x double>%res
}

define <4 x double> @expandload_v4f64_v4i64(double* %base, <4 x double> %src0, <4 x i64> %trigger) {
; SSE2-LABEL: expandload_v4f64_v4i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,0,3,2]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pextrw $0, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_6: ## %else6
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:  LBB1_8: ## %else10
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v4f64_v4i64:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm4
; SSE42-NEXT:    pextrb $0, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_2: ## %else
; SSE42-NEXT:    pextrb $8, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm3
; SSE42-NEXT:    pextrb $0, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_6: ## %else6
; SSE42-NEXT:    pextrb $8, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE42-NEXT:  LBB1_8: ## %else10
; SSE42-NEXT:    retq
;
; AVX1-LABEL: expandload_v4f64_v4i64:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpextrb $0, %xmm3, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB1_2
; AVX1-NEXT:  ## %bb.1: ## %cond.load
; AVX1-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3,4,5,6,7]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB1_2: ## %else
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm2
; AVX1-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB1_4
; AVX1-NEXT:  ## %bb.3: ## %cond.load1
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm2 = xmm0[0],mem[0]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB1_4: ## %else2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB1_6
; AVX1-NEXT:  ## %bb.5: ## %cond.load5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vmovlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB1_6: ## %else6
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB1_8
; AVX1-NEXT:  ## %bb.7: ## %cond.load9
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:  LBB1_8: ## %else10
; AVX1-NEXT:    retq
;
; AVX2-LABEL: expandload_v4f64_v4i64:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm3
; AVX2-NEXT:    vpextrb $0, %xmm3, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB1_2
; AVX2-NEXT:  ## %bb.1: ## %cond.load
; AVX2-NEXT:    vmovq {{.*#+}} xmm3 = mem[0],zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3,4,5,6,7]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB1_2: ## %else
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm2
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB1_4
; AVX2-NEXT:  ## %bb.3: ## %cond.load1
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm2 = xmm0[0],mem[0]
; AVX2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB1_4: ## %else2
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB1_6
; AVX2-NEXT:  ## %bb.5: ## %cond.load5
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vmovlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB1_6: ## %else6
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB1_8
; AVX2-NEXT:  ## %bb.7: ## %cond.load9
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:  LBB1_8: ## %else10
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v4f64_v4i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vexpandpd (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: expandload_v4f64_v4i64:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestnmq %ymm1, %ymm1, %k1
; AVX512VL-NEXT:    vexpandpd (%rdi), %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <4 x i64> %trigger, zeroinitializer
  %res = call <4 x double> @llvm.masked.expandload.v4f64(double* %base, <4 x i1> %mask, <4 x double> %src0)
  ret <4 x double>%res
}

define <8 x double> @expandload_v8f64_v8i1(double* %base, <8 x double> %src0, <8 x i1> %mask) {
; SSE2-LABEL: expandload_v8f64_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_6: ## %else6
; SSE2-NEXT:    pextrw $3, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_8: ## %else10
; SSE2-NEXT:    pextrw $4, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load13
; SSE2-NEXT:    movlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_10: ## %else14
; SSE2-NEXT:    pextrw $5, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load17
; SSE2-NEXT:    movhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_12: ## %else18
; SSE2-NEXT:    pextrw $6, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load21
; SSE2-NEXT:    movlpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB2_14: ## %else22
; SSE2-NEXT:    pextrw $7, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load25
; SSE2-NEXT:    movhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; SSE2-NEXT:  LBB2_16: ## %else26
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v8f64_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_6: ## %else6
; SSE42-NEXT:    pextrb $6, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_8: ## %else10
; SSE42-NEXT:    pextrb $8, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load13
; SSE42-NEXT:    movlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_10: ## %else14
; SSE42-NEXT:    pextrb $10, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load17
; SSE42-NEXT:    movhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_12: ## %else18
; SSE42-NEXT:    pextrb $12, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load21
; SSE42-NEXT:    movlpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB2_14: ## %else22
; SSE42-NEXT:    pextrb $14, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load25
; SSE42-NEXT:    movhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; SSE42-NEXT:  LBB2_16: ## %else26
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v8f64_v8i1:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.load
; AVX1OR2-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX1OR2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0],ymm0[1,2,3]
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_2: ## %else
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.load1
; AVX1OR2-NEXT:    vmovhpd {{.*#+}} xmm3 = xmm0[0],mem[0]
; AVX1OR2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm3[0,1],ymm0[2,3]
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_4: ## %else2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.load5
; AVX1OR2-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1OR2-NEXT:    vmovlpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_6: ## %else6
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.load9
; AVX1OR2-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1OR2-NEXT:    vmovhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_8: ## %else10
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.load13
; AVX1OR2-NEXT:    vmovsd {{.*#+}} xmm3 = mem[0],zero
; AVX1OR2-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0],ymm1[1,2,3]
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_10: ## %else14
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.load17
; AVX1OR2-NEXT:    vmovhpd {{.*#+}} xmm3 = xmm1[0],mem[0]
; AVX1OR2-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3]
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_12: ## %else18
; AVX1OR2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.load21
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1OR2-NEXT:    vmovlpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB2_14: ## %else22
; AVX1OR2-NEXT:    vpextrb $14, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB2_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.load25
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1OR2-NEXT:    vmovhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1OR2-NEXT:  LBB2_16: ## %else26
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v8f64_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vpsllq $63, %zmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vexpandpd (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v8f64_v8i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512VLDQ-NEXT:    vpslld $31, %ymm1, %ymm1
; AVX512VLDQ-NEXT:    vpmovd2m %ymm1, %k1
; AVX512VLDQ-NEXT:    vexpandpd (%rdi), %zmm0 {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v8f64_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpmovw2m %xmm1, %k1
; AVX512VLBW-NEXT:    vexpandpd (%rdi), %zmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x double> @llvm.masked.expandload.v8f64(double* %base, <8 x i1> %mask, <8 x double> %src0)
  ret <8 x double>%res
}

define <16 x double> @expandload_v16f64_v16i32(double* %base, <16 x double> %src0, <16 x i32> %trigger) {
; SSE2-LABEL: expandload_v16f64_v16i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movq %rdi, %rax
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_4: ## %else2
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_6: ## %else6
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_8: ## %else10
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    movd %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load13
; SSE2-NEXT:    movlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_10: ## %else14
; SSE2-NEXT:    pextrw $2, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load17
; SSE2-NEXT:    movhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_12: ## %else18
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load21
; SSE2-NEXT:    movlpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_14: ## %else22
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load25
; SSE2-NEXT:    movhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_16: ## %else26
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_18
; SSE2-NEXT:  ## %bb.17: ## %cond.load29
; SSE2-NEXT:    movlpd {{.*#+}} xmm4 = mem[0],xmm4[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_18: ## %else30
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_20
; SSE2-NEXT:  ## %bb.19: ## %cond.load33
; SSE2-NEXT:    movhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_20: ## %else34
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_22
; SSE2-NEXT:  ## %bb.21: ## %cond.load37
; SSE2-NEXT:    movlpd {{.*#+}} xmm5 = mem[0],xmm5[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_22: ## %else38
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_24
; SSE2-NEXT:  ## %bb.23: ## %cond.load41
; SSE2-NEXT:    movhpd {{.*#+}} xmm5 = xmm5[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_24: ## %else42
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    movd %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_26
; SSE2-NEXT:  ## %bb.25: ## %cond.load45
; SSE2-NEXT:    movlpd {{.*#+}} xmm6 = mem[0],xmm6[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_26: ## %else46
; SSE2-NEXT:    pextrw $2, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_28
; SSE2-NEXT:  ## %bb.27: ## %cond.load49
; SSE2-NEXT:    movhpd {{.*#+}} xmm6 = xmm6[0],mem[0]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_28: ## %else50
; SSE2-NEXT:    pxor %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_30
; SSE2-NEXT:  ## %bb.29: ## %cond.load53
; SSE2-NEXT:    movlpd {{.*#+}} xmm7 = mem[0],xmm7[1]
; SSE2-NEXT:    addq $8, %rsi
; SSE2-NEXT:  LBB3_30: ## %else54
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB3_32
; SSE2-NEXT:  ## %bb.31: ## %cond.load57
; SSE2-NEXT:    movhpd {{.*#+}} xmm7 = xmm7[0],mem[0]
; SSE2-NEXT:  LBB3_32: ## %else58
; SSE2-NEXT:    movapd %xmm0, (%rax)
; SSE2-NEXT:    movapd %xmm1, 16(%rax)
; SSE2-NEXT:    movapd %xmm2, 32(%rax)
; SSE2-NEXT:    movapd %xmm3, 48(%rax)
; SSE2-NEXT:    movapd %xmm4, 64(%rax)
; SSE2-NEXT:    movapd %xmm5, 80(%rax)
; SSE2-NEXT:    movapd %xmm6, 96(%rax)
; SSE2-NEXT:    movapd %xmm7, 112(%rax)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v16f64_v16i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movq %rdi, %rax
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_4: ## %else2
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_6: ## %else6
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_8: ## %else10
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $0, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load13
; SSE42-NEXT:    movlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_10: ## %else14
; SSE42-NEXT:    pextrb $4, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load17
; SSE42-NEXT:    movhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_12: ## %else18
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load21
; SSE42-NEXT:    movlpd {{.*#+}} xmm3 = mem[0],xmm3[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_14: ## %else22
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pextrb $12, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load25
; SSE42-NEXT:    movhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_16: ## %else26
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_18
; SSE42-NEXT:  ## %bb.17: ## %cond.load29
; SSE42-NEXT:    movlpd {{.*#+}} xmm4 = mem[0],xmm4[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_18: ## %else30
; SSE42-NEXT:    pextrb $4, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_20
; SSE42-NEXT:  ## %bb.19: ## %cond.load33
; SSE42-NEXT:    movhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_20: ## %else34
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_22
; SSE42-NEXT:  ## %bb.21: ## %cond.load37
; SSE42-NEXT:    movlpd {{.*#+}} xmm5 = mem[0],xmm5[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_22: ## %else38
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_24
; SSE42-NEXT:  ## %bb.23: ## %cond.load41
; SSE42-NEXT:    movhpd {{.*#+}} xmm5 = xmm5[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_24: ## %else42
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $0, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_26
; SSE42-NEXT:  ## %bb.25: ## %cond.load45
; SSE42-NEXT:    movlpd {{.*#+}} xmm6 = mem[0],xmm6[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_26: ## %else46
; SSE42-NEXT:    pextrb $4, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_28
; SSE42-NEXT:  ## %bb.27: ## %cond.load49
; SSE42-NEXT:    movhpd {{.*#+}} xmm6 = xmm6[0],mem[0]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_28: ## %else50
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_30
; SSE42-NEXT:  ## %bb.29: ## %cond.load53
; SSE42-NEXT:    movlpd {{.*#+}} xmm7 = mem[0],xmm7[1]
; SSE42-NEXT:    addq $8, %rsi
; SSE42-NEXT:  LBB3_30: ## %else54
; SSE42-NEXT:    pextrb $12, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB3_32
; SSE42-NEXT:  ## %bb.31: ## %cond.load57
; SSE42-NEXT:    movhpd {{.*#+}} xmm7 = xmm7[0],mem[0]
; SSE42-NEXT:  LBB3_32: ## %else58
; SSE42-NEXT:    movapd %xmm0, (%rax)
; SSE42-NEXT:    movapd %xmm1, 16(%rax)
; SSE42-NEXT:    movapd %xmm2, 32(%rax)
; SSE42-NEXT:    movapd %xmm3, 48(%rax)
; SSE42-NEXT:    movapd %xmm4, 64(%rax)
; SSE42-NEXT:    movapd %xmm5, 80(%rax)
; SSE42-NEXT:    movapd %xmm6, 96(%rax)
; SSE42-NEXT:    movapd %xmm7, 112(%rax)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: expandload_v16f64_v16i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpackssdw %xmm0, %xmm7, %xmm7
; AVX1-NEXT:    vpacksswb %xmm0, %xmm7, %xmm7
; AVX1-NEXT:    vpextrb $0, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_2
; AVX1-NEXT:  ## %bb.1: ## %cond.load
; AVX1-NEXT:    vmovsd {{.*#+}} xmm7 = mem[0],zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm7[0,1],ymm0[2,3,4,5,6,7]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_2: ## %else
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpextrb $1, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_4
; AVX1-NEXT:  ## %bb.3: ## %cond.load1
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm6 = xmm0[0],mem[0]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1],ymm0[2,3]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_4: ## %else2
; AVX1-NEXT:    vxorpd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm7
; AVX1-NEXT:    vpackssdw %xmm0, %xmm7, %xmm7
; AVX1-NEXT:    vpacksswb %xmm0, %xmm7, %xmm7
; AVX1-NEXT:    vpextrb $2, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_6
; AVX1-NEXT:  ## %bb.5: ## %cond.load5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX1-NEXT:    vmovlpd {{.*#+}} xmm7 = mem[0],xmm7[1]
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_6: ## %else6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpextrb $3, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_8
; AVX1-NEXT:  ## %bb.7: ## %cond.load9
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_8: ## %else10
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm4
; AVX1-NEXT:    vxorpd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm6
; AVX1-NEXT:    vpackssdw %xmm6, %xmm0, %xmm7
; AVX1-NEXT:    vpacksswb %xmm0, %xmm7, %xmm7
; AVX1-NEXT:    vpextrb $4, %xmm7, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_10
; AVX1-NEXT:  ## %bb.9: ## %cond.load13
; AVX1-NEXT:    vmovsd {{.*#+}} xmm7 = mem[0],zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,3,4,5,6,7]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_10: ## %else14
; AVX1-NEXT:    vpackssdw %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpextrb $5, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_12
; AVX1-NEXT:  ## %bb.11: ## %cond.load17
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm6 = xmm1[0],mem[0]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm1 = ymm6[0,1],ymm1[2,3]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_12: ## %else18
; AVX1-NEXT:    vxorpd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm6
; AVX1-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpextrb $6, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_14
; AVX1-NEXT:  ## %bb.13: ## %cond.load21
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm6
; AVX1-NEXT:    vmovlpd {{.*#+}} xmm6 = mem[0],xmm6[1]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_14: ## %else22
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $7, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_16
; AVX1-NEXT:  ## %bb.15: ## %cond.load25
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_16: ## %else26
; AVX1-NEXT:    vxorpd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm6
; AVX1-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpextrb $8, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_18
; AVX1-NEXT:  ## %bb.17: ## %cond.load29
; AVX1-NEXT:    vmovsd {{.*#+}} xmm6 = mem[0],zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3,4,5,6,7]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_18: ## %else30
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $9, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_20
; AVX1-NEXT:  ## %bb.19: ## %cond.load33
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm2[0],mem[0]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_20: ## %else34
; AVX1-NEXT:    vxorpd %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm6
; AVX1-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpextrb $10, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_22
; AVX1-NEXT:  ## %bb.21: ## %cond.load37
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX1-NEXT:    vmovlpd {{.*#+}} xmm6 = mem[0],xmm6[1]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm2
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_22: ## %else38
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $11, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_24
; AVX1-NEXT:  ## %bb.23: ## %cond.load41
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_24: ## %else42
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm6
; AVX1-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpextrb $12, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_26
; AVX1-NEXT:  ## %bb.25: ## %cond.load45
; AVX1-NEXT:    vmovsd {{.*#+}} xmm6 = mem[0],zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3,4,5,6,7]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_26: ## %else46
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $13, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_28
; AVX1-NEXT:  ## %bb.27: ## %cond.load49
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm5 = xmm3[0],mem[0]
; AVX1-NEXT:    vblendpd {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3]
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_28: ## %else50
; AVX1-NEXT:    vxorpd %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $14, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_30
; AVX1-NEXT:  ## %bb.29: ## %cond.load53
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vmovlpd {{.*#+}} xmm5 = mem[0],xmm5[1]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB3_30: ## %else54
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $15, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB3_32
; AVX1-NEXT:  ## %bb.31: ## %cond.load57
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:  LBB3_32: ## %else58
; AVX1-NEXT:    retq
;
; AVX2-LABEL: expandload_v16f64_v16i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm7
; AVX2-NEXT:    vpackssdw %xmm0, %xmm7, %xmm7
; AVX2-NEXT:    vpacksswb %xmm0, %xmm7, %xmm7
; AVX2-NEXT:    vpextrb $0, %xmm7, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_2
; AVX2-NEXT:  ## %bb.1: ## %cond.load
; AVX2-NEXT:    vmovq {{.*#+}} xmm7 = mem[0],zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm7[0,1],ymm0[2,3,4,5,6,7]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_2: ## %else
; AVX2-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm6
; AVX2-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpextrb $1, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_4
; AVX2-NEXT:  ## %bb.3: ## %cond.load1
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm6 = xmm0[0],mem[0]
; AVX2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm6[0,1],ymm0[2,3]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_4: ## %else2
; AVX2-NEXT:    vxorpd %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm7
; AVX2-NEXT:    vpackssdw %xmm0, %xmm7, %xmm7
; AVX2-NEXT:    vpacksswb %xmm0, %xmm7, %xmm7
; AVX2-NEXT:    vpextrb $2, %xmm7, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_6
; AVX2-NEXT:  ## %bb.5: ## %cond.load5
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm7
; AVX2-NEXT:    vmovlpd {{.*#+}} xmm7 = mem[0],xmm7[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm0, %ymm0
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_6: ## %else6
; AVX2-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm6
; AVX2-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpextrb $3, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_8
; AVX2-NEXT:  ## %bb.7: ## %cond.load9
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm6
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm0
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_8: ## %else10
; AVX2-NEXT:    vextracti128 $1, %ymm4, %xmm4
; AVX2-NEXT:    vxorpd %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm6
; AVX2-NEXT:    vpackssdw %xmm6, %xmm0, %xmm7
; AVX2-NEXT:    vpacksswb %xmm0, %xmm7, %xmm7
; AVX2-NEXT:    vpextrb $4, %xmm7, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_10
; AVX2-NEXT:  ## %bb.9: ## %cond.load13
; AVX2-NEXT:    vmovq {{.*#+}} xmm7 = mem[0],zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,3,4,5,6,7]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_10: ## %else14
; AVX2-NEXT:    vpackssdw %xmm6, %xmm0, %xmm6
; AVX2-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpextrb $5, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_12
; AVX2-NEXT:  ## %bb.11: ## %cond.load17
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm6 = xmm1[0],mem[0]
; AVX2-NEXT:    vblendpd {{.*#+}} ymm1 = ymm6[0,1],ymm1[2,3]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_12: ## %else18
; AVX2-NEXT:    vxorpd %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpcmpeqd %xmm6, %xmm4, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm6
; AVX2-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpextrb $6, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_14
; AVX2-NEXT:  ## %bb.13: ## %cond.load21
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm6
; AVX2-NEXT:    vmovlpd {{.*#+}} xmm6 = mem[0],xmm6[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm1, %ymm1
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_14: ## %else22
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $7, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_16
; AVX2-NEXT:  ## %bb.15: ## %cond.load25
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_16: ## %else26
; AVX2-NEXT:    vxorpd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm6
; AVX2-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX2-NEXT:    vpextrb $8, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_18
; AVX2-NEXT:  ## %bb.17: ## %cond.load29
; AVX2-NEXT:    vmovq {{.*#+}} xmm6 = mem[0],zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm6[0,1],ymm2[2,3,4,5,6,7]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_18: ## %else30
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $9, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_20
; AVX2-NEXT:  ## %bb.19: ## %cond.load33
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm2[0],mem[0]
; AVX2-NEXT:    vblendpd {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_20: ## %else34
; AVX2-NEXT:    vxorpd %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm6
; AVX2-NEXT:    vpackssdw %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX2-NEXT:    vpextrb $10, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_22
; AVX2-NEXT:  ## %bb.21: ## %cond.load37
; AVX2-NEXT:    vextractf128 $1, %ymm2, %xmm6
; AVX2-NEXT:    vmovlpd {{.*#+}} xmm6 = mem[0],xmm6[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm2, %ymm2
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_22: ## %else38
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $11, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_24
; AVX2-NEXT:  ## %bb.23: ## %cond.load41
; AVX2-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_24: ## %else42
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm4
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm6
; AVX2-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX2-NEXT:    vpextrb $12, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_26
; AVX2-NEXT:  ## %bb.25: ## %cond.load45
; AVX2-NEXT:    vmovq {{.*#+}} xmm6 = mem[0],zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm6[0,1],ymm3[2,3,4,5,6,7]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_26: ## %else46
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $13, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_28
; AVX2-NEXT:  ## %bb.27: ## %cond.load49
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm5 = xmm3[0],mem[0]
; AVX2-NEXT:    vblendpd {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3]
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_28: ## %else50
; AVX2-NEXT:    vxorpd %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $14, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_30
; AVX2-NEXT:  ## %bb.29: ## %cond.load53
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX2-NEXT:    vmovlpd {{.*#+}} xmm5 = mem[0],xmm5[1]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB3_30: ## %else54
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $15, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB3_32
; AVX2-NEXT:  ## %bb.31: ## %cond.load57
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX2-NEXT:    vmovhpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX2-NEXT:  LBB3_32: ## %else58
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v16f64_v16i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm2, %ymm3
; AVX512F-NEXT:    vptestnmd %zmm3, %zmm3, %k1
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k2
; AVX512F-NEXT:    vexpandpd (%rdi), %zmm0 {%k2}
; AVX512F-NEXT:    kmovw %k2, %eax
; AVX512F-NEXT:    movzbl %al, %eax
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    shrl %ecx
; AVX512F-NEXT:    andl $-43, %ecx
; AVX512F-NEXT:    subl %ecx, %eax
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512F-NEXT:    shrl $2, %eax
; AVX512F-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512F-NEXT:    addl %ecx, %eax
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    shrl $4, %ecx
; AVX512F-NEXT:    addl %eax, %ecx
; AVX512F-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512F-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512F-NEXT:    shrl $24, %eax
; AVX512F-NEXT:    vexpandpd (%rdi,%rax,8), %zmm1 {%k1}
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v16f64_v16i32:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vextracti64x4 $1, %zmm2, %ymm3
; AVX512VLDQ-NEXT:    vptestnmd %ymm3, %ymm3, %k1
; AVX512VLDQ-NEXT:    vptestnmd %ymm2, %ymm2, %k2
; AVX512VLDQ-NEXT:    kmovb %k2, %eax
; AVX512VLDQ-NEXT:    movl %eax, %ecx
; AVX512VLDQ-NEXT:    shrl %ecx
; AVX512VLDQ-NEXT:    andl $-43, %ecx
; AVX512VLDQ-NEXT:    subl %ecx, %eax
; AVX512VLDQ-NEXT:    movl %eax, %ecx
; AVX512VLDQ-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512VLDQ-NEXT:    shrl $2, %eax
; AVX512VLDQ-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512VLDQ-NEXT:    addl %ecx, %eax
; AVX512VLDQ-NEXT:    movl %eax, %ecx
; AVX512VLDQ-NEXT:    shrl $4, %ecx
; AVX512VLDQ-NEXT:    addl %eax, %ecx
; AVX512VLDQ-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512VLDQ-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512VLDQ-NEXT:    shrl $24, %eax
; AVX512VLDQ-NEXT:    vexpandpd (%rdi,%rax,8), %zmm1 {%k1}
; AVX512VLDQ-NEXT:    vexpandpd (%rdi), %zmm0 {%k2}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v16f64_v16i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vextracti64x4 $1, %zmm2, %ymm3
; AVX512VLBW-NEXT:    vptestnmd %ymm3, %ymm3, %k1
; AVX512VLBW-NEXT:    vptestnmd %ymm2, %ymm2, %k2
; AVX512VLBW-NEXT:    vexpandpd (%rdi), %zmm0 {%k2}
; AVX512VLBW-NEXT:    kmovd %k2, %eax
; AVX512VLBW-NEXT:    movzbl %al, %eax
; AVX512VLBW-NEXT:    movl %eax, %ecx
; AVX512VLBW-NEXT:    shrl %ecx
; AVX512VLBW-NEXT:    andl $-43, %ecx
; AVX512VLBW-NEXT:    subl %ecx, %eax
; AVX512VLBW-NEXT:    movl %eax, %ecx
; AVX512VLBW-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512VLBW-NEXT:    shrl $2, %eax
; AVX512VLBW-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512VLBW-NEXT:    addl %ecx, %eax
; AVX512VLBW-NEXT:    movl %eax, %ecx
; AVX512VLBW-NEXT:    shrl $4, %ecx
; AVX512VLBW-NEXT:    addl %eax, %ecx
; AVX512VLBW-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512VLBW-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512VLBW-NEXT:    shrl $24, %eax
; AVX512VLBW-NEXT:    vexpandpd (%rdi,%rax,8), %zmm1 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <16 x i32> %trigger, zeroinitializer
  %res = call <16 x double> @llvm.masked.expandload.v16f64(double* %base, <16 x i1> %mask, <16 x double> %src0)
  ret <16 x double> %res
}

;
; vXf32
;

define <2 x float> @expandload_v2f32_v2i1(float* %base, <2 x float> %src0, <2 x i32> %trigger) {
; SSE2-LABEL: expandload_v2f32_v2i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:  LBB4_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v2f32_v2i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm1
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm2[0,1],xmm0[2,3,4,5,6,7]
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_2: ## %else
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; SSE42-NEXT:  LBB4_4: ## %else2
; SSE42-NEXT:    retq
;
; AVX1-LABEL: expandload_v2f32_v2i1:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB4_2
; AVX1-NEXT:  ## %bb.1: ## %cond.load
; AVX1-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm2[0,1],xmm0[2,3,4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB4_2: ## %else
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB4_4
; AVX1-NEXT:  ## %bb.3: ## %cond.load1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; AVX1-NEXT:  LBB4_4: ## %else2
; AVX1-NEXT:    retq
;
; AVX2-LABEL: expandload_v2f32_v2i1:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB4_2
; AVX2-NEXT:  ## %bb.1: ## %cond.load
; AVX2-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB4_2: ## %else
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB4_4
; AVX2-NEXT:  ## %bb.3: ## %cond.load1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; AVX2-NEXT:  LBB4_4: ## %else2
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v2f32_v2i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512F-NEXT:    vptestnmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vexpandps (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: expandload_v2f32_v2i1:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512VL-NEXT:    vptestnmq %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vexpandps (%rdi), %xmm0 {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x float> @llvm.masked.expandload.v2f32(float* %base, <2 x i1> %mask, <2 x float> %src0)
  ret <2 x float> %res
}

define <4 x float> @expandload_v4f32_const(float* %base, <4 x float> %src0) {
; SSE2-LABEL: expandload_v4f32_const:
; SSE2:       ## %bb.0: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm2[0,0]
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm2[0,2]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v4f32_const:
; SSE42:       ## %bb.0: ## %cond.load
; SSE42-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v4f32_const:
; AVX1OR2:       ## %bb.0: ## %cond.load
; AVX1OR2-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX1OR2-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v4f32_const:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    movw $7, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vexpandps (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v4f32_const:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    movb $7, %al
; AVX512VLDQ-NEXT:    kmovw %eax, %k1
; AVX512VLDQ-NEXT:    vexpandps (%rdi), %xmm0 {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v4f32_const:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $7, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vexpandps (%rdi), %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x float> @llvm.masked.expandload.v4f32(float* %base, <4 x i1> <i1 true, i1 true, i1 true, i1 false>, <4 x float> %src0)
  ret <4 x float>%res
}

define <16 x float> @expandload_v16f32_const(float* %base, <16 x float> %src0) {
; SSE2-LABEL: expandload_v16f32_const:
; SSE2:       ## %bb.0: ## %cond.load
; SSE2-NEXT:    movups (%rdi), %xmm0
; SSE2-NEXT:    movups 16(%rdi), %xmm1
; SSE2-NEXT:    movss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,0],xmm5[0,0]
; SSE2-NEXT:    movss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,0],xmm2[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm5[0,2]
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,0],xmm2[0,0]
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm3[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[2,0],xmm2[0,2]
; SSE2-NEXT:    movaps %xmm4, %xmm2
; SSE2-NEXT:    movaps %xmm5, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v16f32_const:
; SSE42:       ## %bb.0: ## %cond.load
; SSE42-NEXT:    movups (%rdi), %xmm0
; SSE42-NEXT:    movups 16(%rdi), %xmm1
; SSE42-NEXT:    movss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm2 = xmm4[0],xmm2[1,2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; SSE42-NEXT:    movss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm3 = xmm4[0],xmm3[1,2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],mem[0],xmm3[2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],mem[0],xmm3[3]
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v16f32_const:
; AVX1OR2:       ## %bb.0: ## %cond.load
; AVX1OR2-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0],ymm0[1,2,3,4,5,6,7]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm0[0],mem[0],xmm0[2,3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1,2,3],ymm0[4,5,6,7]
; AVX1OR2-NEXT:    vmovsd {{.*#+}} xmm2 = mem[0],zero
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1OR2-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0],ymm1[1,2,3,4,5,6,7]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm1[0],mem[0],xmm1[2,3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX1OR2-NEXT:    vmovss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1OR2-NEXT:    vblendps {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],mem[0],xmm1[3]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v16f32_const:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movw $30719, %ax ## imm = 0x77FF
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vexpandps (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v16f32_const:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    movw $30719, %ax ## imm = 0x77FF
; AVX512VLDQ-NEXT:    kmovw %eax, %k1
; AVX512VLDQ-NEXT:    vexpandps (%rdi), %zmm0 {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v16f32_const:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movw $30719, %ax ## imm = 0x77FF
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vexpandps (%rdi), %zmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <16 x float> @llvm.masked.expandload.v16f32(float* %base, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 false, i1 true, i1 true, i1 true, i1 false>, <16 x float> %src0)
  ret <16 x float>%res
}

define <16 x float> @expandload_v16f32_const_undef(float* %base) {
; SSE2-LABEL: expandload_v16f32_const_undef:
; SSE2:       ## %bb.0: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE2-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm0[0]
; SSE2-NEXT:    movups (%rdi), %xmm0
; SSE2-NEXT:    movups 16(%rdi), %xmm1
; SSE2-NEXT:    movups 44(%rdi), %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v16f32_const_undef:
; SSE42:       ## %bb.0: ## %cond.load
; SSE42-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; SSE42-NEXT:    movups (%rdi), %xmm0
; SSE42-NEXT:    movups 16(%rdi), %xmm1
; SSE42-NEXT:    movups 44(%rdi), %xmm3
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v16f32_const_undef:
; AVX1OR2:       ## %bb.0: ## %cond.load
; AVX1OR2-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX1OR2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX1OR2-NEXT:    vinsertf128 $1, 44(%rdi), %ymm0, %ymm1
; AVX1OR2-NEXT:    vmovups (%rdi), %ymm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v16f32_const_undef:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movw $-2049, %ax ## imm = 0xF7FF
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vexpandps (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v16f32_const_undef:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    movw $-2049, %ax ## imm = 0xF7FF
; AVX512VLDQ-NEXT:    kmovw %eax, %k1
; AVX512VLDQ-NEXT:    vexpandps (%rdi), %zmm0 {%k1} {z}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v16f32_const_undef:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movw $-2049, %ax ## imm = 0xF7FF
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vexpandps (%rdi), %zmm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %res = call <16 x float> @llvm.masked.expandload.v16f32(float* %base, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 false, i1 true, i1 true, i1 true, i1 true>, <16 x float> undef)
  ret <16 x float>%res
}


define <32 x float> @expandload_v32f32_v32i32(float* %base, <32 x float> %src0, <32 x i32> %trigger) {
; SSE2-LABEL: expandload_v32f32_v32i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movq %rdi, %rax
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm10[0],xmm0[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm0[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm8, %xmm0
; SSE2-NEXT:  LBB8_4: ## %else2
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm8[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_6: ## %else6
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm0[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm9[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_8: ## %else10
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    movd %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load13
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm10[0],xmm1[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_10: ## %else14
; SSE2-NEXT:    pextrw $2, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load17
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm1[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm9, %xmm1
; SSE2-NEXT:  LBB8_12: ## %else18
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load21
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm9[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_14: ## %else22
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load25
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm8[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_16: ## %else26
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_18
; SSE2-NEXT:  ## %bb.17: ## %cond.load29
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = xmm10[0],xmm2[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_18: ## %else30
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_20
; SSE2-NEXT:  ## %bb.19: ## %cond.load33
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm2[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm2[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm8, %xmm2
; SSE2-NEXT:  LBB8_20: ## %else34
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_22
; SSE2-NEXT:  ## %bb.21: ## %cond.load37
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm2[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm8[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_22: ## %else38
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_24
; SSE2-NEXT:  ## %bb.23: ## %cond.load41
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm2[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm9[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_24: ## %else42
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    movd %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_26
; SSE2-NEXT:  ## %bb.25: ## %cond.load45
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm3 = xmm10[0],xmm3[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_26: ## %else46
; SSE2-NEXT:    pextrw $2, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_28
; SSE2-NEXT:  ## %bb.27: ## %cond.load49
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm3[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm3[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm9, %xmm3
; SSE2-NEXT:  LBB8_28: ## %else50
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_30
; SSE2-NEXT:  ## %bb.29: ## %cond.load53
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm3[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm9[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_30: ## %else54
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_32
; SSE2-NEXT:  ## %bb.31: ## %cond.load57
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm3[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm8[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_32: ## %else58
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_34
; SSE2-NEXT:  ## %bb.33: ## %cond.load61
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm4 = xmm10[0],xmm4[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_34: ## %else62
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_36
; SSE2-NEXT:  ## %bb.35: ## %cond.load65
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm4[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm4[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm8, %xmm4
; SSE2-NEXT:  LBB8_36: ## %else66
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_38
; SSE2-NEXT:  ## %bb.37: ## %cond.load69
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm4[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm8[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_38: ## %else70
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_40
; SSE2-NEXT:  ## %bb.39: ## %cond.load73
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm4[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,1],xmm9[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_40: ## %else74
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    movd %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_42
; SSE2-NEXT:  ## %bb.41: ## %cond.load77
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm5 = xmm10[0],xmm5[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_42: ## %else78
; SSE2-NEXT:    pextrw $2, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_44
; SSE2-NEXT:  ## %bb.43: ## %cond.load81
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm5[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm5[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm9, %xmm5
; SSE2-NEXT:  LBB8_44: ## %else82
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_46
; SSE2-NEXT:  ## %bb.45: ## %cond.load85
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm5[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm9[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_46: ## %else86
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_48
; SSE2-NEXT:  ## %bb.47: ## %cond.load89
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm5[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[0,1],xmm8[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_48: ## %else90
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_50
; SSE2-NEXT:  ## %bb.49: ## %cond.load93
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm6 = xmm10[0],xmm6[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_50: ## %else94
; SSE2-NEXT:    pextrw $2, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_52
; SSE2-NEXT:  ## %bb.51: ## %cond.load97
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm6[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[2,0],xmm6[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm8, %xmm6
; SSE2-NEXT:  LBB8_52: ## %else98
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_54
; SSE2-NEXT:  ## %bb.53: ## %cond.load101
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm6[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm8[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_54: ## %else102
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_56
; SSE2-NEXT:  ## %bb.55: ## %cond.load105
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm6[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm6 = xmm6[0,1],xmm9[2,0]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_56: ## %else106
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    movd %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_58
; SSE2-NEXT:  ## %bb.57: ## %cond.load109
; SSE2-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm7 = xmm10[0],xmm7[1,2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_58: ## %else110
; SSE2-NEXT:    pextrw $2, %xmm9, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_60
; SSE2-NEXT:  ## %bb.59: ## %cond.load113
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm7[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[2,0],xmm7[2,3]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:    movaps %xmm9, %xmm7
; SSE2-NEXT:  LBB8_60: ## %else114
; SSE2-NEXT:    xorps %xmm9, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_62
; SSE2-NEXT:  ## %bb.61: ## %cond.load117
; SSE2-NEXT:    movss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm9 = xmm9[0,0],xmm7[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm9[0,2]
; SSE2-NEXT:    addq $4, %rsi
; SSE2-NEXT:  LBB8_62: ## %else118
; SSE2-NEXT:    pextrw $6, %xmm8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB8_64
; SSE2-NEXT:  ## %bb.63: ## %cond.load121
; SSE2-NEXT:    movss {{.*#+}} xmm8 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[0,0],xmm7[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[0,1],xmm8[2,0]
; SSE2-NEXT:  LBB8_64: ## %else122
; SSE2-NEXT:    movaps %xmm0, (%rax)
; SSE2-NEXT:    movaps %xmm1, 16(%rax)
; SSE2-NEXT:    movaps %xmm2, 32(%rax)
; SSE2-NEXT:    movaps %xmm3, 48(%rax)
; SSE2-NEXT:    movaps %xmm4, 64(%rax)
; SSE2-NEXT:    movaps %xmm5, 80(%rax)
; SSE2-NEXT:    movaps %xmm6, 96(%rax)
; SSE2-NEXT:    movaps %xmm7, 112(%rax)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v32f32_v32i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movq %rdi, %rax
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm0 = xmm10[0],xmm0[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_4: ## %else2
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_6: ## %else6
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_8: ## %else10
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $0, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load13
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm1 = xmm10[0],xmm1[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_10: ## %else14
; SSE42-NEXT:    pextrb $4, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load17
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_12: ## %else18
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load21
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1],mem[0],xmm1[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_14: ## %else22
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pextrb $12, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load25
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_16: ## %else26
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_18
; SSE42-NEXT:  ## %bb.17: ## %cond.load29
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm2 = xmm10[0],xmm2[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_18: ## %else30
; SSE42-NEXT:    pextrb $4, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_20
; SSE42-NEXT:  ## %bb.19: ## %cond.load33
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_20: ## %else34
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_22
; SSE42-NEXT:  ## %bb.21: ## %cond.load37
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_22: ## %else38
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_24
; SSE42-NEXT:  ## %bb.23: ## %cond.load41
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_24: ## %else42
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $0, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_26
; SSE42-NEXT:  ## %bb.25: ## %cond.load45
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm3 = xmm10[0],xmm3[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_26: ## %else46
; SSE42-NEXT:    pextrb $4, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_28
; SSE42-NEXT:  ## %bb.27: ## %cond.load49
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],mem[0],xmm3[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_28: ## %else50
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_30
; SSE42-NEXT:  ## %bb.29: ## %cond.load53
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],mem[0],xmm3[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_30: ## %else54
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pextrb $12, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_32
; SSE42-NEXT:  ## %bb.31: ## %cond.load57
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_32: ## %else58
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_34
; SSE42-NEXT:  ## %bb.33: ## %cond.load61
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm4 = xmm10[0],xmm4[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_34: ## %else62
; SSE42-NEXT:    pextrb $4, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_36
; SSE42-NEXT:  ## %bb.35: ## %cond.load65
; SSE42-NEXT:    insertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_36: ## %else66
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_38
; SSE42-NEXT:  ## %bb.37: ## %cond.load69
; SSE42-NEXT:    insertps {{.*#+}} xmm4 = xmm4[0,1],mem[0],xmm4[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_38: ## %else70
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_40
; SSE42-NEXT:  ## %bb.39: ## %cond.load73
; SSE42-NEXT:    insertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_40: ## %else74
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $0, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_42
; SSE42-NEXT:  ## %bb.41: ## %cond.load77
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm5 = xmm10[0],xmm5[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_42: ## %else78
; SSE42-NEXT:    pextrb $4, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_44
; SSE42-NEXT:  ## %bb.43: ## %cond.load81
; SSE42-NEXT:    insertps {{.*#+}} xmm5 = xmm5[0],mem[0],xmm5[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_44: ## %else82
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_46
; SSE42-NEXT:  ## %bb.45: ## %cond.load85
; SSE42-NEXT:    insertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_46: ## %else86
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pextrb $12, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_48
; SSE42-NEXT:  ## %bb.47: ## %cond.load89
; SSE42-NEXT:    insertps {{.*#+}} xmm5 = xmm5[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_48: ## %else90
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_50
; SSE42-NEXT:  ## %bb.49: ## %cond.load93
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm6 = xmm10[0],xmm6[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_50: ## %else94
; SSE42-NEXT:    pextrb $4, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_52
; SSE42-NEXT:  ## %bb.51: ## %cond.load97
; SSE42-NEXT:    insertps {{.*#+}} xmm6 = xmm6[0],mem[0],xmm6[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_52: ## %else98
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_54
; SSE42-NEXT:  ## %bb.53: ## %cond.load101
; SSE42-NEXT:    insertps {{.*#+}} xmm6 = xmm6[0,1],mem[0],xmm6[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_54: ## %else102
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_56
; SSE42-NEXT:  ## %bb.55: ## %cond.load105
; SSE42-NEXT:    insertps {{.*#+}} xmm6 = xmm6[0,1,2],mem[0]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_56: ## %else106
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $0, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_58
; SSE42-NEXT:  ## %bb.57: ## %cond.load109
; SSE42-NEXT:    movss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm7 = xmm10[0],xmm7[1,2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_58: ## %else110
; SSE42-NEXT:    pextrb $4, %xmm9, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_60
; SSE42-NEXT:  ## %bb.59: ## %cond.load113
; SSE42-NEXT:    insertps {{.*#+}} xmm7 = xmm7[0],mem[0],xmm7[2,3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_60: ## %else114
; SSE42-NEXT:    pxor %xmm9, %xmm9
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_62
; SSE42-NEXT:  ## %bb.61: ## %cond.load117
; SSE42-NEXT:    insertps {{.*#+}} xmm7 = xmm7[0,1],mem[0],xmm7[3]
; SSE42-NEXT:    addq $4, %rsi
; SSE42-NEXT:  LBB8_62: ## %else118
; SSE42-NEXT:    pextrb $12, %xmm8, %ecx
; SSE42-NEXT:    testb $1, %cl
; SSE42-NEXT:    je LBB8_64
; SSE42-NEXT:  ## %bb.63: ## %cond.load121
; SSE42-NEXT:    insertps {{.*#+}} xmm7 = xmm7[0,1,2],mem[0]
; SSE42-NEXT:  LBB8_64: ## %else122
; SSE42-NEXT:    movaps %xmm0, (%rax)
; SSE42-NEXT:    movaps %xmm1, 16(%rax)
; SSE42-NEXT:    movaps %xmm2, 32(%rax)
; SSE42-NEXT:    movaps %xmm3, 48(%rax)
; SSE42-NEXT:    movaps %xmm4, 64(%rax)
; SSE42-NEXT:    movaps %xmm5, 80(%rax)
; SSE42-NEXT:    movaps %xmm6, 96(%rax)
; SSE42-NEXT:    movaps %xmm7, 112(%rax)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: expandload_v32f32_v32i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX1-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpextrb $0, %xmm9, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_2
; AVX1-NEXT:  ## %bb.1: ## %cond.load
; AVX1-NEXT:    vmovss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0],ymm0[1,2,3,4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_2: ## %else
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX1-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpextrb $1, %xmm8, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_4
; AVX1-NEXT:  ## %bb.3: ## %cond.load1
; AVX1-NEXT:    vinsertps {{.*#+}} xmm8 = xmm0[0],mem[0],xmm0[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm0[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_4: ## %else2
; AVX1-NEXT:    vxorps %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX1-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpextrb $2, %xmm9, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_6
; AVX1-NEXT:  ## %bb.5: ## %cond.load5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm9 = xmm0[0,1],mem[0],xmm0[3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_6: ## %else6
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX1-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpextrb $3, %xmm8, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_8
; AVX1-NEXT:  ## %bb.7: ## %cond.load9
; AVX1-NEXT:    vinsertps {{.*#+}} xmm8 = xmm0[0,1,2],mem[0]
; AVX1-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm0[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_8: ## %else10
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm8
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm9
; AVX1-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $4, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_10
; AVX1-NEXT:  ## %bb.9: ## %cond.load13
; AVX1-NEXT:    vmovd {{.*#+}} xmm10 = mem[0],zero,zero,zero
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm10[0,1],xmm4[2,3,4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_10: ## %else14
; AVX1-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $5, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_12
; AVX1-NEXT:  ## %bb.11: ## %cond.load17
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_12: ## %else18
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm8
; AVX1-NEXT:    vpackssdw %xmm8, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $6, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_14
; AVX1-NEXT:  ## %bb.13: ## %cond.load21
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1],mem[0],xmm4[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_14: ## %else22
; AVX1-NEXT:    vpackssdw %xmm8, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $7, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_16
; AVX1-NEXT:  ## %bb.15: ## %cond.load25
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_16: ## %else26
; AVX1-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $8, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_18
; AVX1-NEXT:  ## %bb.17: ## %cond.load29
; AVX1-NEXT:    vmovss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0],ymm1[1,2,3,4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_18: ## %else30
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $9, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_20
; AVX1-NEXT:  ## %bb.19: ## %cond.load33
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm1[0],mem[0],xmm1[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_20: ## %else34
; AVX1-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $10, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_22
; AVX1-NEXT:  ## %bb.21: ## %cond.load37
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm1[0,1],mem[0],xmm1[3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_22: ## %else38
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $11, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_24
; AVX1-NEXT:  ## %bb.23: ## %cond.load41
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm1[0,1,2],mem[0]
; AVX1-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_24: ## %else42
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm8
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm8, %xmm5
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $12, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_26
; AVX1-NEXT:  ## %bb.25: ## %cond.load45
; AVX1-NEXT:    vmovd {{.*#+}} xmm9 = mem[0],zero,zero,zero
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm9[0,1],xmm4[2,3,4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_26: ## %else46
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $13, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_28
; AVX1-NEXT:  ## %bb.27: ## %cond.load49
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_28: ## %else50
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $14, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_30
; AVX1-NEXT:  ## %bb.29: ## %cond.load53
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_30: ## %else54
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $15, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_32
; AVX1-NEXT:  ## %bb.31: ## %cond.load57
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_32: ## %else58
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm5
; AVX1-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpacksswb %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpextrb $0, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_34
; AVX1-NEXT:  ## %bb.33: ## %cond.load61
; AVX1-NEXT:    vmovss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3,4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_34: ## %else62
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $1, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_36
; AVX1-NEXT:  ## %bb.35: ## %cond.load65
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm2[0],mem[0],xmm2[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_36: ## %else66
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm5
; AVX1-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpacksswb %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpextrb $2, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_38
; AVX1-NEXT:  ## %bb.37: ## %cond.load69
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm2[0,1],mem[0],xmm2[3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_38: ## %else70
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $3, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_40
; AVX1-NEXT:  ## %bb.39: ## %cond.load73
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm2[0,1,2],mem[0]
; AVX1-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_40: ## %else74
; AVX1-NEXT:    vextractf128 $1, %ymm6, %xmm8
; AVX1-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm8, %xmm5
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm6
; AVX1-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX1-NEXT:    vpextrb $4, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_42
; AVX1-NEXT:  ## %bb.41: ## %cond.load77
; AVX1-NEXT:    vmovss {{.*#+}} xmm6 = mem[0],zero,zero,zero
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vblendps {{.*#+}} xmm4 = xmm6[0],xmm4[1,2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_42: ## %else78
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $5, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_44
; AVX1-NEXT:  ## %bb.43: ## %cond.load81
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_44: ## %else82
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpextrb $6, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_46
; AVX1-NEXT:  ## %bb.45: ## %cond.load85
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm2, %ymm2
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_46: ## %else86
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $7, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_48
; AVX1-NEXT:  ## %bb.47: ## %cond.load89
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_48: ## %else90
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm5
; AVX1-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $8, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_50
; AVX1-NEXT:  ## %bb.49: ## %cond.load93
; AVX1-NEXT:    vmovss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0],ymm3[1,2,3,4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_50: ## %else94
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $9, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_52
; AVX1-NEXT:  ## %bb.51: ## %cond.load97
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm3[0],mem[0],xmm3[2,3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_52: ## %else98
; AVX1-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm5
; AVX1-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $10, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_54
; AVX1-NEXT:  ## %bb.53: ## %cond.load101
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm3[0,1],mem[0],xmm3[3]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_54: ## %else102
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $11, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_56
; AVX1-NEXT:  ## %bb.55: ## %cond.load105
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm3[0,1,2],mem[0]
; AVX1-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_56: ## %else106
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm4
; AVX1-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm5
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm6
; AVX1-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpextrb $12, %xmm6, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_58
; AVX1-NEXT:  ## %bb.57: ## %cond.load109
; AVX1-NEXT:    vmovd {{.*#+}} xmm6 = mem[0],zero,zero,zero
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm7
; AVX1-NEXT:    vpblendw {{.*#+}} xmm6 = xmm6[0,1],xmm7[2,3,4,5,6,7]
; AVX1-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm3
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_58: ## %else110
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $13, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_60
; AVX1-NEXT:  ## %bb.59: ## %cond.load113
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0],mem[0],xmm5[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_60: ## %else114
; AVX1-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vpextrb $14, %xmm5, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_62
; AVX1-NEXT:  ## %bb.61: ## %cond.load117
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX1-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB8_62: ## %else118
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $15, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_64
; AVX1-NEXT:  ## %bb.63: ## %cond.load121
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX1-NEXT:  LBB8_64: ## %else122
; AVX1-NEXT:    retq
;
; AVX2-LABEL: expandload_v32f32_v32i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX2-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpextrb $0, %xmm9, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_2
; AVX2-NEXT:  ## %bb.1: ## %cond.load
; AVX2-NEXT:    vmovd {{.*#+}} xmm9 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm0 = ymm9[0],ymm0[1,2,3,4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_2: ## %else
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX2-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpextrb $1, %xmm8, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_4
; AVX2-NEXT:  ## %bb.3: ## %cond.load1
; AVX2-NEXT:    vinsertps {{.*#+}} xmm8 = xmm0[0],mem[0],xmm0[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_4: ## %else2
; AVX2-NEXT:    vxorps %xmm8, %xmm8, %xmm8
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX2-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpextrb $2, %xmm9, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_6
; AVX2-NEXT:  ## %bb.5: ## %cond.load5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm9 = xmm0[0,1],mem[0],xmm0[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm9[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_6: ## %else6
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX2-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpextrb $3, %xmm8, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_8
; AVX2-NEXT:  ## %bb.7: ## %cond.load9
; AVX2-NEXT:    vinsertps {{.*#+}} xmm8 = xmm0[0,1,2],mem[0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm8[0,1,2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_8: ## %else10
; AVX2-NEXT:    vextracti128 $1, %ymm4, %xmm8
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm9
; AVX2-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $4, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_10
; AVX2-NEXT:  ## %bb.9: ## %cond.load13
; AVX2-NEXT:    vmovss {{.*#+}} xmm10 = mem[0],zero,zero,zero
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vblendps {{.*#+}} xmm4 = xmm10[0],xmm4[1,2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_10: ## %else14
; AVX2-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $5, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_12
; AVX2-NEXT:  ## %bb.11: ## %cond.load17
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_12: ## %else18
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm8
; AVX2-NEXT:    vpackssdw %xmm8, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $6, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_14
; AVX2-NEXT:  ## %bb.13: ## %cond.load21
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1],mem[0],xmm4[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_14: ## %else22
; AVX2-NEXT:    vpackssdw %xmm8, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $7, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_16
; AVX2-NEXT:  ## %bb.15: ## %cond.load25
; AVX2-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm0
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_16: ## %else26
; AVX2-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $8, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_18
; AVX2-NEXT:  ## %bb.17: ## %cond.load29
; AVX2-NEXT:    vmovd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm1 = ymm4[0],ymm1[1,2,3,4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_18: ## %else30
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $9, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_20
; AVX2-NEXT:  ## %bb.19: ## %cond.load33
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm1[0],mem[0],xmm1[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_20: ## %else34
; AVX2-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $10, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_22
; AVX2-NEXT:  ## %bb.21: ## %cond.load37
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm1[0,1],mem[0],xmm1[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_22: ## %else38
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $11, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_24
; AVX2-NEXT:  ## %bb.23: ## %cond.load41
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm1[0,1,2],mem[0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm4[0,1,2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_24: ## %else42
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm8
; AVX2-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm8, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $12, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_26
; AVX2-NEXT:  ## %bb.25: ## %cond.load45
; AVX2-NEXT:    vmovss {{.*#+}} xmm9 = mem[0],zero,zero,zero
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX2-NEXT:    vblendps {{.*#+}} xmm4 = xmm9[0],xmm4[1,2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_26: ## %else46
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $13, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_28
; AVX2-NEXT:  ## %bb.27: ## %cond.load49
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_28: ## %else50
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $14, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_30
; AVX2-NEXT:  ## %bb.29: ## %cond.load53
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm1, %ymm1
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_30: ## %else54
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $15, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_32
; AVX2-NEXT:  ## %bb.31: ## %cond.load57
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm1
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_32: ## %else58
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm5
; AVX2-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpacksswb %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpextrb $0, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_34
; AVX2-NEXT:  ## %bb.33: ## %cond.load61
; AVX2-NEXT:    vmovd {{.*#+}} xmm5 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm5[0],ymm2[1,2,3,4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_34: ## %else62
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $1, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_36
; AVX2-NEXT:  ## %bb.35: ## %cond.load65
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm2[0],mem[0],xmm2[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_36: ## %else66
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm5
; AVX2-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpacksswb %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpextrb $2, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_38
; AVX2-NEXT:  ## %bb.37: ## %cond.load69
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm2[0,1],mem[0],xmm2[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm5[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_38: ## %else70
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm6, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $3, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_40
; AVX2-NEXT:  ## %bb.39: ## %cond.load73
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm2[0,1,2],mem[0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_40: ## %else74
; AVX2-NEXT:    vextracti128 $1, %ymm6, %xmm8
; AVX2-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm8, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm6
; AVX2-NEXT:    vpacksswb %xmm0, %xmm6, %xmm6
; AVX2-NEXT:    vpextrb $4, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_42
; AVX2-NEXT:  ## %bb.41: ## %cond.load77
; AVX2-NEXT:    vmovss {{.*#+}} xmm6 = mem[0],zero,zero,zero
; AVX2-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX2-NEXT:    vblendps {{.*#+}} xmm4 = xmm6[0],xmm4[1,2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_42: ## %else78
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $5, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_44
; AVX2-NEXT:  ## %bb.43: ## %cond.load81
; AVX2-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0],mem[0],xmm4[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_44: ## %else82
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX2-NEXT:    vpacksswb %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpextrb $6, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_46
; AVX2-NEXT:  ## %bb.45: ## %cond.load85
; AVX2-NEXT:    vextractf128 $1, %ymm2, %xmm5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm2, %ymm2
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_46: ## %else86
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $7, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_48
; AVX2-NEXT:  ## %bb.47: ## %cond.load89
; AVX2-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_48: ## %else90
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm5
; AVX2-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $8, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_50
; AVX2-NEXT:  ## %bb.49: ## %cond.load93
; AVX2-NEXT:    vmovd {{.*#+}} xmm5 = mem[0],zero,zero,zero
; AVX2-NEXT:    vpblendd {{.*#+}} ymm3 = ymm5[0],ymm3[1,2,3,4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_50: ## %else94
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $9, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_52
; AVX2-NEXT:  ## %bb.51: ## %cond.load97
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm3[0],mem[0],xmm3[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_52: ## %else98
; AVX2-NEXT:    vxorps %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm5
; AVX2-NEXT:    vpackssdw %xmm0, %xmm5, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $10, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_54
; AVX2-NEXT:  ## %bb.53: ## %cond.load101
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm3[0,1],mem[0],xmm3[3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm5[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_54: ## %else102
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm7, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $11, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_56
; AVX2-NEXT:  ## %bb.55: ## %cond.load105
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm3[0,1,2],mem[0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm4[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_56: ## %else106
; AVX2-NEXT:    vextracti128 $1, %ymm7, %xmm4
; AVX2-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm6
; AVX2-NEXT:    vpacksswb %xmm6, %xmm0, %xmm6
; AVX2-NEXT:    vpextrb $12, %xmm6, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_58
; AVX2-NEXT:  ## %bb.57: ## %cond.load109
; AVX2-NEXT:    vmovss {{.*#+}} xmm6 = mem[0],zero,zero,zero
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm7
; AVX2-NEXT:    vblendps {{.*#+}} xmm6 = xmm6[0],xmm7[1,2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm3, %ymm3
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_58: ## %else110
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $13, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_60
; AVX2-NEXT:  ## %bb.59: ## %cond.load113
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0],mem[0],xmm5[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_60: ## %else114
; AVX2-NEXT:    vxorps %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm5
; AVX2-NEXT:    vpacksswb %xmm5, %xmm0, %xmm5
; AVX2-NEXT:    vpextrb $14, %xmm5, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_62
; AVX2-NEXT:  ## %bb.61: ## %cond.load117
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm5
; AVX2-NEXT:    vinsertps {{.*#+}} xmm5 = xmm5[0,1],mem[0],xmm5[3]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm3
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB8_62: ## %else118
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $15, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_64
; AVX2-NEXT:  ## %bb.63: ## %cond.load121
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX2-NEXT:    vinsertps {{.*#+}} xmm4 = xmm4[0,1,2],mem[0]
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm3, %ymm3
; AVX2-NEXT:  LBB8_64: ## %else122
; AVX2-NEXT:    retq
;
; AVX512-LABEL: expandload_v32f32_v32i32:
; AVX512:       ## %bb.0:
; AVX512-NEXT:    vptestnmd %zmm3, %zmm3, %k2
; AVX512-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512-NEXT:    kmovw %k1, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    shrl %ecx
; AVX512-NEXT:    andl $21845, %ecx ## imm = 0x5555
; AVX512-NEXT:    subl %ecx, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512-NEXT:    shrl $2, %eax
; AVX512-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512-NEXT:    addl %ecx, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    shrl $4, %ecx
; AVX512-NEXT:    addl %eax, %ecx
; AVX512-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512-NEXT:    shrl $24, %eax
; AVX512-NEXT:    vexpandps (%rdi,%rax,4), %zmm1 {%k2}
; AVX512-NEXT:    vexpandps (%rdi), %zmm0 {%k1}
; AVX512-NEXT:    retq
  %mask = icmp eq <32 x i32> %trigger, zeroinitializer
  %res = call <32 x float> @llvm.masked.expandload.v32f32(float* %base, <32 x i1> %mask, <32 x float> %src0)
  ret <32 x float> %res
}

;
; vXi64
;

define <2 x i64> @expandload_v2i64_const(i64* %base, <2 x i64> %src0) {
; SSE2-LABEL: expandload_v2i64_const:
; SSE2:       ## %bb.0: ## %else
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v2i64_const:
; SSE42:       ## %bb.0: ## %else
; SSE42-NEXT:    pinsrq $1, (%rdi), %xmm0
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v2i64_const:
; AVX1OR2:       ## %bb.0: ## %else
; AVX1OR2-NEXT:    vpinsrq $1, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v2i64_const:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    movb $2, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vpexpandq (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v2i64_const:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    movb $2, %al
; AVX512VLDQ-NEXT:    kmovw %eax, %k1
; AVX512VLDQ-NEXT:    vpexpandq (%rdi), %xmm0 {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v2i64_const:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $2, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vpexpandq (%rdi), %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <2 x i64> @llvm.masked.expandload.v2i64(i64* %base, <2 x i1> <i1 false, i1 true>, <2 x i64> %src0)
  ret <2 x i64>%res
}

;
; vXi32
;

define <4 x i32> @expandload_v4i32_v4i32(i32* %base, <4 x i32> %src0, <4 x i32> %trigger) {
; SSE2-LABEL: expandload_v4i32_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm3[0],xmm0[1,2,3]
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB10_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm0[2,3]
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:  LBB10_4: ## %else2
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[0,2]
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB10_6: ## %else6
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,0]
; SSE2-NEXT:  LBB10_8: ## %else10
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v4i32_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    pinsrd $0, (%rdi), %xmm0
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB10_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    pinsrd $1, (%rdi), %xmm0
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB10_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    pinsrd $2, (%rdi), %xmm0
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB10_6: ## %else6
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    pinsrd $3, (%rdi), %xmm0
; SSE42-NEXT:  LBB10_8: ## %else10
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v4i32_v4i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.load
; AVX1OR2-NEXT:    vpinsrd $0, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB10_2: ## %else
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.load1
; AVX1OR2-NEXT:    vpinsrd $1, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB10_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.load5
; AVX1OR2-NEXT:    vpinsrd $2, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB10_6: ## %else6
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.load9
; AVX1OR2-NEXT:    vpinsrd $3, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:  LBB10_8: ## %else10
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v4i32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vpexpandd (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: expandload_v4i32_v4i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestnmd %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vpexpandd (%rdi), %xmm0 {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x i32> @llvm.masked.expandload.v4i32(i32* %base, <4 x i1> %mask, <4 x i32> %src0)
  ret <4 x i32>%res
}

;
; vXi16
;

define <8 x i16> @expandload_v8i16_v8i16(i16* %base, <8 x i16> %src0, <8 x i16> %trigger) {
; SSE2-LABEL: expandload_v8i16_v8i16:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    pinsrw $0, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    pinsrw $1, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    pinsrw $2, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_6: ## %else6
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    pinsrw $3, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_8: ## %else10
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load13
; SSE2-NEXT:    pinsrw $4, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_10: ## %else14
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load17
; SSE2-NEXT:    pinsrw $5, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_12: ## %else18
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load21
; SSE2-NEXT:    pinsrw $6, (%rdi), %xmm0
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_14: ## %else22
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load25
; SSE2-NEXT:    pinsrw $7, (%rdi), %xmm0
; SSE2-NEXT:  LBB11_16: ## %else26
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v8i16_v8i16:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    pinsrw $0, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    pinsrw $1, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    pinsrw $2, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_6: ## %else6
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    pinsrw $3, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_8: ## %else10
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load13
; SSE42-NEXT:    pinsrw $4, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_10: ## %else14
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load17
; SSE42-NEXT:    pinsrw $5, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_12: ## %else18
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load21
; SSE42-NEXT:    pinsrw $6, (%rdi), %xmm0
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_14: ## %else22
; SSE42-NEXT:    pextrb $14, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load25
; SSE42-NEXT:    pinsrw $7, (%rdi), %xmm0
; SSE42-NEXT:  LBB11_16: ## %else26
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v8i16_v8i16:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.load
; AVX1OR2-NEXT:    vpinsrw $0, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_2: ## %else
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.load1
; AVX1OR2-NEXT:    vpinsrw $1, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.load5
; AVX1OR2-NEXT:    vpinsrw $2, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_6: ## %else6
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.load9
; AVX1OR2-NEXT:    vpinsrw $3, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_8: ## %else10
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.load13
; AVX1OR2-NEXT:    vpinsrw $4, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_10: ## %else14
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.load17
; AVX1OR2-NEXT:    vpinsrw $5, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_12: ## %else18
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.load21
; AVX1OR2-NEXT:    vpinsrw $6, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_14: ## %else22
; AVX1OR2-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.load25
; AVX1OR2-NEXT:    vpinsrw $7, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:  LBB11_16: ## %else26
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v8i16_v8i16:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.load
; AVX512F-NEXT:    vpinsrw $0, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.load1
; AVX512F-NEXT:    vpinsrw $1, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.load5
; AVX512F-NEXT:    vpinsrw $2, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_6: ## %else6
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.load9
; AVX512F-NEXT:    vpinsrw $3, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_8: ## %else10
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.load13
; AVX512F-NEXT:    vpinsrw $4, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_10: ## %else14
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.load17
; AVX512F-NEXT:    vpinsrw $5, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_12: ## %else18
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.load21
; AVX512F-NEXT:    vpinsrw $6, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_14: ## %else22
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.load25
; AVX512F-NEXT:    vpinsrw $7, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:  LBB11_16: ## %else26
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v8i16_v8i16:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.load
; AVX512VLDQ-NEXT:    vpinsrw $0, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrb $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.load1
; AVX512VLDQ-NEXT:    vpinsrw $1, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kshiftrb $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.load5
; AVX512VLDQ-NEXT:    vpinsrw $2, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_6: ## %else6
; AVX512VLDQ-NEXT:    kshiftrb $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.load9
; AVX512VLDQ-NEXT:    vpinsrw $3, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_8: ## %else10
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kshiftrb $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.load13
; AVX512VLDQ-NEXT:    vpinsrw $4, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_10: ## %else14
; AVX512VLDQ-NEXT:    kshiftrb $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.load17
; AVX512VLDQ-NEXT:    vpinsrw $5, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_12: ## %else18
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512VLDQ-NEXT:    vpmovd2m %ymm1, %k0
; AVX512VLDQ-NEXT:    kshiftrb $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.load21
; AVX512VLDQ-NEXT:    vpinsrw $6, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_14: ## %else22
; AVX512VLDQ-NEXT:    kshiftrb $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.load25
; AVX512VLDQ-NEXT:    vpinsrw $7, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:  LBB11_16: ## %else26
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v8i16_v8i16:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmw %xmm1, %xmm1, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_2
; AVX512VLBW-NEXT:  ## %bb.1: ## %cond.load
; AVX512VLBW-NEXT:    vpinsrw $0, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_2: ## %else
; AVX512VLBW-NEXT:    kshiftrw $1, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_4
; AVX512VLBW-NEXT:  ## %bb.3: ## %cond.load1
; AVX512VLBW-NEXT:    vpinsrw $1, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_4: ## %else2
; AVX512VLBW-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_6
; AVX512VLBW-NEXT:  ## %bb.5: ## %cond.load5
; AVX512VLBW-NEXT:    vpinsrw $2, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_6: ## %else6
; AVX512VLBW-NEXT:    kshiftrw $3, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_8
; AVX512VLBW-NEXT:  ## %bb.7: ## %cond.load9
; AVX512VLBW-NEXT:    vpinsrw $3, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_8: ## %else10
; AVX512VLBW-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_10
; AVX512VLBW-NEXT:  ## %bb.9: ## %cond.load13
; AVX512VLBW-NEXT:    vpinsrw $4, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_10: ## %else14
; AVX512VLBW-NEXT:    kshiftrw $5, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_12
; AVX512VLBW-NEXT:  ## %bb.11: ## %cond.load17
; AVX512VLBW-NEXT:    vpinsrw $5, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_12: ## %else18
; AVX512VLBW-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_14
; AVX512VLBW-NEXT:  ## %bb.13: ## %cond.load21
; AVX512VLBW-NEXT:    vpinsrw $6, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_14: ## %else22
; AVX512VLBW-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_16
; AVX512VLBW-NEXT:  ## %bb.15: ## %cond.load25
; AVX512VLBW-NEXT:    vpinsrw $7, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:  LBB11_16: ## %else26
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <8 x i16> %trigger, zeroinitializer
  %res = call <8 x i16> @llvm.masked.expandload.v8i16(i16* %base, <8 x i1> %mask, <8 x i16> %src0)
  ret <8 x i16>%res
}

;
; vXi8
;

define <16 x i8> @expandload_v16i8_v16i8(i8* %base, <16 x i8> %src0, <16 x i8> %trigger) {
; SSE2-LABEL: expandload_v16i8_v16i8:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_2: ## %else
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    psllw $8, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shrl $16, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load5
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pslld $16, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_6: ## %else6
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load9
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    pslld $24, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_8: ## %else10
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load13
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,1,1]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_10: ## %else14
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load17
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    psllq $40, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_12: ## %else18
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load21
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    psllq $48, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_14: ## %else22
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load25
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    psllq $56, %xmm3
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_16: ## %else26
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_18
; SSE2-NEXT:  ## %bb.17: ## %cond.load29
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,0,1]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_18: ## %else30
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_20
; SSE2-NEXT:  ## %bb.19: ## %cond.load33
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1,2,3,4,5,6]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_20: ## %else34
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_22
; SSE2-NEXT:  ## %bb.21: ## %cond.load37
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1,2,3,4,5]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_22: ## %else38
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_24
; SSE2-NEXT:  ## %bb.23: ## %cond.load41
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,255,255,0,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1,2,3,4]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_24: ## %else42
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_26
; SSE2-NEXT:  ## %bb.25: ## %cond.load45
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,255,255,255,0,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_26: ## %else46
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_28
; SSE2-NEXT:  ## %bb.27: ## %cond.load49
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,255,255,255,255,0,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm3
; SSE2-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1,2]
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_28: ## %else50
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_30
; SSE2-NEXT:  ## %bb.29: ## %cond.load53
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,255]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    movzbl (%rdi), %ecx
; SSE2-NEXT:    movd %ecx, %xmm2
; SSE2-NEXT:    pslldq {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm2[0,1]
; SSE2-NEXT:    pandn %xmm2, %xmm1
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_30: ## %else54
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_32
; SSE2-NEXT:  ## %bb.31: ## %cond.load57
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    movzbl (%rdi), %eax
; SSE2-NEXT:    movd %eax, %xmm1
; SSE2-NEXT:    pslldq {{.*#+}} xmm1 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm1[0]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:  LBB12_32: ## %else58
; SSE2-NEXT:    retq
;
; SSE42-LABEL: expandload_v16i8_v16i8:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    pinsrb $0, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_2: ## %else
; SSE42-NEXT:    pextrb $1, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    pinsrb $1, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load5
; SSE42-NEXT:    pinsrb $2, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_6: ## %else6
; SSE42-NEXT:    pextrb $3, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load9
; SSE42-NEXT:    pinsrb $3, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_8: ## %else10
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load13
; SSE42-NEXT:    pinsrb $4, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_10: ## %else14
; SSE42-NEXT:    pextrb $5, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load17
; SSE42-NEXT:    pinsrb $5, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_12: ## %else18
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load21
; SSE42-NEXT:    pinsrb $6, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_14: ## %else22
; SSE42-NEXT:    pextrb $7, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load25
; SSE42-NEXT:    pinsrb $7, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_16: ## %else26
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_18
; SSE42-NEXT:  ## %bb.17: ## %cond.load29
; SSE42-NEXT:    pinsrb $8, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_18: ## %else30
; SSE42-NEXT:    pextrb $9, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_20
; SSE42-NEXT:  ## %bb.19: ## %cond.load33
; SSE42-NEXT:    pinsrb $9, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_20: ## %else34
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_22
; SSE42-NEXT:  ## %bb.21: ## %cond.load37
; SSE42-NEXT:    pinsrb $10, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_22: ## %else38
; SSE42-NEXT:    pextrb $11, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_24
; SSE42-NEXT:  ## %bb.23: ## %cond.load41
; SSE42-NEXT:    pinsrb $11, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_24: ## %else42
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_26
; SSE42-NEXT:  ## %bb.25: ## %cond.load45
; SSE42-NEXT:    pinsrb $12, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_26: ## %else46
; SSE42-NEXT:    pextrb $13, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_28
; SSE42-NEXT:  ## %bb.27: ## %cond.load49
; SSE42-NEXT:    pinsrb $13, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_28: ## %else50
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE42-NEXT:    pextrb $14, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_30
; SSE42-NEXT:  ## %bb.29: ## %cond.load53
; SSE42-NEXT:    pinsrb $14, (%rdi), %xmm0
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_30: ## %else54
; SSE42-NEXT:    pextrb $15, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_32
; SSE42-NEXT:  ## %bb.31: ## %cond.load57
; SSE42-NEXT:    pinsrb $15, (%rdi), %xmm0
; SSE42-NEXT:  LBB12_32: ## %else58
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: expandload_v16i8_v16i8:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.load
; AVX1OR2-NEXT:    vpinsrb $0, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_2: ## %else
; AVX1OR2-NEXT:    vpextrb $1, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.load1
; AVX1OR2-NEXT:    vpinsrb $1, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.load5
; AVX1OR2-NEXT:    vpinsrb $2, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_6: ## %else6
; AVX1OR2-NEXT:    vpextrb $3, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.load9
; AVX1OR2-NEXT:    vpinsrb $3, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_8: ## %else10
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.load13
; AVX1OR2-NEXT:    vpinsrb $4, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_10: ## %else14
; AVX1OR2-NEXT:    vpextrb $5, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.load17
; AVX1OR2-NEXT:    vpinsrb $5, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_12: ## %else18
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.load21
; AVX1OR2-NEXT:    vpinsrb $6, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_14: ## %else22
; AVX1OR2-NEXT:    vpextrb $7, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.load25
; AVX1OR2-NEXT:    vpinsrb $7, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_16: ## %else26
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_18
; AVX1OR2-NEXT:  ## %bb.17: ## %cond.load29
; AVX1OR2-NEXT:    vpinsrb $8, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_18: ## %else30
; AVX1OR2-NEXT:    vpextrb $9, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_20
; AVX1OR2-NEXT:  ## %bb.19: ## %cond.load33
; AVX1OR2-NEXT:    vpinsrb $9, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_20: ## %else34
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_22
; AVX1OR2-NEXT:  ## %bb.21: ## %cond.load37
; AVX1OR2-NEXT:    vpinsrb $10, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_22: ## %else38
; AVX1OR2-NEXT:    vpextrb $11, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_24
; AVX1OR2-NEXT:  ## %bb.23: ## %cond.load41
; AVX1OR2-NEXT:    vpinsrb $11, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_24: ## %else42
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_26
; AVX1OR2-NEXT:  ## %bb.25: ## %cond.load45
; AVX1OR2-NEXT:    vpinsrb $12, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_26: ## %else46
; AVX1OR2-NEXT:    vpextrb $13, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_28
; AVX1OR2-NEXT:  ## %bb.27: ## %cond.load49
; AVX1OR2-NEXT:    vpinsrb $13, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_28: ## %else50
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_30
; AVX1OR2-NEXT:  ## %bb.29: ## %cond.load53
; AVX1OR2-NEXT:    vpinsrb $14, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_30: ## %else54
; AVX1OR2-NEXT:    vpextrb $15, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_32
; AVX1OR2-NEXT:  ## %bb.31: ## %cond.load57
; AVX1OR2-NEXT:    vpinsrb $15, (%rdi), %xmm0, %xmm0
; AVX1OR2-NEXT:  LBB12_32: ## %else58
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: expandload_v16i8_v16i8:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.load
; AVX512F-NEXT:    vpinsrb $0, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.load1
; AVX512F-NEXT:    vpinsrb $1, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.load5
; AVX512F-NEXT:    vpinsrb $2, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_6: ## %else6
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.load9
; AVX512F-NEXT:    vpinsrb $3, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_8: ## %else10
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.load13
; AVX512F-NEXT:    vpinsrb $4, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_10: ## %else14
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.load17
; AVX512F-NEXT:    vpinsrb $5, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_12: ## %else18
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.load21
; AVX512F-NEXT:    vpinsrb $6, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_14: ## %else22
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.load25
; AVX512F-NEXT:    vpinsrb $7, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_16: ## %else26
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_18
; AVX512F-NEXT:  ## %bb.17: ## %cond.load29
; AVX512F-NEXT:    vpinsrb $8, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_18: ## %else30
; AVX512F-NEXT:    kshiftrw $9, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_20
; AVX512F-NEXT:  ## %bb.19: ## %cond.load33
; AVX512F-NEXT:    vpinsrb $9, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_20: ## %else34
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $10, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_22
; AVX512F-NEXT:  ## %bb.21: ## %cond.load37
; AVX512F-NEXT:    vpinsrb $10, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_22: ## %else38
; AVX512F-NEXT:    kshiftrw $11, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_24
; AVX512F-NEXT:  ## %bb.23: ## %cond.load41
; AVX512F-NEXT:    vpinsrb $11, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_24: ## %else42
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_26
; AVX512F-NEXT:  ## %bb.25: ## %cond.load45
; AVX512F-NEXT:    vpinsrb $12, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_26: ## %else46
; AVX512F-NEXT:    kshiftrw $13, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_28
; AVX512F-NEXT:  ## %bb.27: ## %cond.load49
; AVX512F-NEXT:    vpinsrb $13, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_28: ## %else50
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpmovsxbd %xmm1, %zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_30
; AVX512F-NEXT:  ## %bb.29: ## %cond.load53
; AVX512F-NEXT:    vpinsrb $14, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_30: ## %else54
; AVX512F-NEXT:    kshiftrw $15, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_32
; AVX512F-NEXT:  ## %bb.31: ## %cond.load57
; AVX512F-NEXT:    vpinsrb $15, (%rdi), %xmm0, %xmm0
; AVX512F-NEXT:  LBB12_32: ## %else58
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: expandload_v16i8_v16i8:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.load
; AVX512VLDQ-NEXT:    vpinsrb $0, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrw $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.load1
; AVX512VLDQ-NEXT:    vpinsrb $1, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.load5
; AVX512VLDQ-NEXT:    vpinsrb $2, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_6: ## %else6
; AVX512VLDQ-NEXT:    kshiftrw $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.load9
; AVX512VLDQ-NEXT:    vpinsrb $3, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_8: ## %else10
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.load13
; AVX512VLDQ-NEXT:    vpinsrb $4, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_10: ## %else14
; AVX512VLDQ-NEXT:    kshiftrw $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.load17
; AVX512VLDQ-NEXT:    vpinsrb $5, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_12: ## %else18
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.load21
; AVX512VLDQ-NEXT:    vpinsrb $6, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_14: ## %else22
; AVX512VLDQ-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.load25
; AVX512VLDQ-NEXT:    vpinsrb $7, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_16: ## %else26
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_18
; AVX512VLDQ-NEXT:  ## %bb.17: ## %cond.load29
; AVX512VLDQ-NEXT:    vpinsrb $8, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_18: ## %else30
; AVX512VLDQ-NEXT:    kshiftrw $9, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_20
; AVX512VLDQ-NEXT:  ## %bb.19: ## %cond.load33
; AVX512VLDQ-NEXT:    vpinsrb $9, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_20: ## %else34
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_22
; AVX512VLDQ-NEXT:  ## %bb.21: ## %cond.load37
; AVX512VLDQ-NEXT:    vpinsrb $10, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_22: ## %else38
; AVX512VLDQ-NEXT:    kshiftrw $11, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_24
; AVX512VLDQ-NEXT:  ## %bb.23: ## %cond.load41
; AVX512VLDQ-NEXT:    vpinsrb $11, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_24: ## %else42
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_26
; AVX512VLDQ-NEXT:  ## %bb.25: ## %cond.load45
; AVX512VLDQ-NEXT:    vpinsrb $12, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_26: ## %else46
; AVX512VLDQ-NEXT:    kshiftrw $13, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_28
; AVX512VLDQ-NEXT:  ## %bb.27: ## %cond.load49
; AVX512VLDQ-NEXT:    vpinsrb $13, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_28: ## %else50
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm1, %zmm1
; AVX512VLDQ-NEXT:    vpmovd2m %zmm1, %k0
; AVX512VLDQ-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_30
; AVX512VLDQ-NEXT:  ## %bb.29: ## %cond.load53
; AVX512VLDQ-NEXT:    vpinsrb $14, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_30: ## %else54
; AVX512VLDQ-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_32
; AVX512VLDQ-NEXT:  ## %bb.31: ## %cond.load57
; AVX512VLDQ-NEXT:    vpinsrb $15, (%rdi), %xmm0, %xmm0
; AVX512VLDQ-NEXT:  LBB12_32: ## %else58
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: expandload_v16i8_v16i8:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmb %xmm1, %xmm1, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_2
; AVX512VLBW-NEXT:  ## %bb.1: ## %cond.load
; AVX512VLBW-NEXT:    vpinsrb $0, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_2: ## %else
; AVX512VLBW-NEXT:    kshiftrw $1, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_4
; AVX512VLBW-NEXT:  ## %bb.3: ## %cond.load1
; AVX512VLBW-NEXT:    vpinsrb $1, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_4: ## %else2
; AVX512VLBW-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_6
; AVX512VLBW-NEXT:  ## %bb.5: ## %cond.load5
; AVX512VLBW-NEXT:    vpinsrb $2, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_6: ## %else6
; AVX512VLBW-NEXT:    kshiftrw $3, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_8
; AVX512VLBW-NEXT:  ## %bb.7: ## %cond.load9
; AVX512VLBW-NEXT:    vpinsrb $3, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_8: ## %else10
; AVX512VLBW-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_10
; AVX512VLBW-NEXT:  ## %bb.9: ## %cond.load13
; AVX512VLBW-NEXT:    vpinsrb $4, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_10: ## %else14
; AVX512VLBW-NEXT:    kshiftrw $5, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_12
; AVX512VLBW-NEXT:  ## %bb.11: ## %cond.load17
; AVX512VLBW-NEXT:    vpinsrb $5, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_12: ## %else18
; AVX512VLBW-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_14
; AVX512VLBW-NEXT:  ## %bb.13: ## %cond.load21
; AVX512VLBW-NEXT:    vpinsrb $6, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_14: ## %else22
; AVX512VLBW-NEXT:    kshiftrw $7, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_16
; AVX512VLBW-NEXT:  ## %bb.15: ## %cond.load25
; AVX512VLBW-NEXT:    vpinsrb $7, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_16: ## %else26
; AVX512VLBW-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_18
; AVX512VLBW-NEXT:  ## %bb.17: ## %cond.load29
; AVX512VLBW-NEXT:    vpinsrb $8, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_18: ## %else30
; AVX512VLBW-NEXT:    kshiftrw $9, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_20
; AVX512VLBW-NEXT:  ## %bb.19: ## %cond.load33
; AVX512VLBW-NEXT:    vpinsrb $9, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_20: ## %else34
; AVX512VLBW-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_22
; AVX512VLBW-NEXT:  ## %bb.21: ## %cond.load37
; AVX512VLBW-NEXT:    vpinsrb $10, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_22: ## %else38
; AVX512VLBW-NEXT:    kshiftrw $11, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_24
; AVX512VLBW-NEXT:  ## %bb.23: ## %cond.load41
; AVX512VLBW-NEXT:    vpinsrb $11, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_24: ## %else42
; AVX512VLBW-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_26
; AVX512VLBW-NEXT:  ## %bb.25: ## %cond.load45
; AVX512VLBW-NEXT:    vpinsrb $12, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_26: ## %else46
; AVX512VLBW-NEXT:    kshiftrw $13, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_28
; AVX512VLBW-NEXT:  ## %bb.27: ## %cond.load49
; AVX512VLBW-NEXT:    vpinsrb $13, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_28: ## %else50
; AVX512VLBW-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_30
; AVX512VLBW-NEXT:  ## %bb.29: ## %cond.load53
; AVX512VLBW-NEXT:    vpinsrb $14, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_30: ## %else54
; AVX512VLBW-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_32
; AVX512VLBW-NEXT:  ## %bb.31: ## %cond.load57
; AVX512VLBW-NEXT:    vpinsrb $15, (%rdi), %xmm0, %xmm0
; AVX512VLBW-NEXT:  LBB12_32: ## %else58
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <16 x i8> %trigger, zeroinitializer
  %res = call <16 x i8> @llvm.masked.expandload.v16i8(i8* %base, <16 x i1> %mask, <16 x i8> %src0)
  ret <16 x i8>%res
}

declare <16 x double> @llvm.masked.expandload.v16f64(double*, <16 x i1>, <16 x double>)
declare <8 x double> @llvm.masked.expandload.v8f64(double*, <8 x i1>, <8 x double>)
declare <4 x double> @llvm.masked.expandload.v4f64(double*, <4 x i1>, <4 x double>)
declare <2 x double> @llvm.masked.expandload.v2f64(double*, <2 x i1>, <2 x double>)
declare <1 x double> @llvm.masked.expandload.v1f64(double*, <1 x i1>, <1 x double>)

declare <32 x float> @llvm.masked.expandload.v32f32(float*, <32 x i1>, <32 x float>)
declare <16 x float> @llvm.masked.expandload.v16f32(float*, <16 x i1>, <16 x float>)
declare <8 x float> @llvm.masked.expandload.v8f32(float*, <8 x i1>, <8 x float>)
declare <4 x float> @llvm.masked.expandload.v4f32(float*, <4 x i1>, <4 x float>)
declare <2 x float> @llvm.masked.expandload.v2f32(float*, <2 x i1>, <2 x float>)

declare <8 x i64> @llvm.masked.expandload.v8i64(i64*, <8 x i1>, <8 x i64>)
declare <4 x i64> @llvm.masked.expandload.v4i64(i64*, <4 x i1>, <4 x i64>)
declare <2 x i64> @llvm.masked.expandload.v2i64(i64*, <2 x i1>, <2 x i64>)
declare <1 x i64> @llvm.masked.expandload.v1i64(i64*, <1 x i1>, <1 x i64>)

declare <16 x i32> @llvm.masked.expandload.v16i32(i32*, <16 x i1>, <16 x i32>)
declare <8 x i32> @llvm.masked.expandload.v8i32(i32*, <8 x i1>, <8 x i32>)
declare <4 x i32> @llvm.masked.expandload.v4i32(i32*, <4 x i1>, <4 x i32>)
declare <2 x i32> @llvm.masked.expandload.v2i32(i32*, <2 x i1>, <2 x i32>)

declare <32 x i16> @llvm.masked.expandload.v32i16(i16*, <32 x i1>, <32 x i16>)
declare <16 x i16> @llvm.masked.expandload.v16i16(i16*, <16 x i1>, <16 x i16>)
declare <8 x i16> @llvm.masked.expandload.v8i16(i16*, <8 x i1>, <8 x i16>)
declare <4 x i16> @llvm.masked.expandload.v4i16(i16*, <4 x i1>, <4 x i16>)

declare <64 x i8> @llvm.masked.expandload.v64i8(i8*, <64 x i1>, <64 x i8>)
declare <32 x i8> @llvm.masked.expandload.v32i8(i8*, <32 x i1>, <32 x i8>)
declare <16 x i8> @llvm.masked.expandload.v16i8(i8*, <16 x i1>, <16 x i8>)
declare <8 x i8> @llvm.masked.expandload.v8i8(i8*, <8 x i1>, <8 x i8>)
