// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+WavefrontSize32,-WavefrontSize64 -show-encoding %s | FileCheck --check-prefixes=GFX10,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-WavefrontSize32,+WavefrontSize64 -show-encoding %s | FileCheck --check-prefixes=GFX10,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=+WavefrontSize32,-WavefrontSize64 -show-encoding %s 2>&1 | FileCheck --check-prefixes=GFX10-ERR,W32-ERR %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1010 -mattr=-WavefrontSize32,+WavefrontSize64 -show-encoding %s 2>&1 | FileCheck --check-prefixes=GFX10-ERR,W64-ERR %s

//===----------------------------------------------------------------------===//
// ENC_DS.
//===----------------------------------------------------------------------===//

ds_add_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x00,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x00,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x00,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x00,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x02,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x02,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x02,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x02,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x02,0xd8,0xff,0x01,0x00,0x00]

ds_add_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xd8,0x00,0x01,0x00,0x00]

ds_add_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xd8,0xff,0xfe,0x00,0x00]

ds_add_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xd8,0x00,0xfe,0x00,0x00]

ds_add_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x04,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x04,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x04,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x04,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x06,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x06,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x06,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x06,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x06,0xd8,0xff,0x01,0x00,0x00]

ds_sub_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xd8,0x00,0x01,0x00,0x00]

ds_sub_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xd8,0xff,0xfe,0x00,0x00]

ds_sub_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xd8,0x00,0xfe,0x00,0x00]

ds_sub_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x08,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x08,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x08,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x08,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0a,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0a,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0a,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0a,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0a,0xd8,0xff,0x01,0x00,0x00]

ds_rsub_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xd8,0x00,0x01,0x00,0x00]

ds_rsub_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xd8,0xff,0xfe,0x00,0x00]

ds_rsub_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xd8,0x00,0xfe,0x00,0x00]

ds_rsub_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x0c,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x0c,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x0c,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x0c,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x0e,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0e,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0e,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0e,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x0e,0xd8,0xff,0x01,0x00,0x00]

ds_inc_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xd8,0x00,0x01,0x00,0x00]

ds_inc_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xd8,0xff,0xfe,0x00,0x00]

ds_inc_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xd8,0x00,0xfe,0x00,0x00]

ds_inc_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x10,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x10,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x10,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x10,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x12,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x12,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x12,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x12,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x12,0xd8,0xff,0x01,0x00,0x00]

ds_dec_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xd8,0x00,0x01,0x00,0x00]

ds_dec_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xd8,0xff,0xfe,0x00,0x00]

ds_dec_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xd8,0x00,0xfe,0x00,0x00]

ds_dec_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x14,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x14,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x14,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x14,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x16,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x16,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x16,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x16,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x16,0xd8,0xff,0x01,0x00,0x00]

ds_min_i32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xd8,0x00,0x01,0x00,0x00]

ds_min_i32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xd8,0xff,0xfe,0x00,0x00]

ds_min_i32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xd8,0x00,0xfe,0x00,0x00]

ds_min_i32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x18,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x18,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x18,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x18,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1a,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1a,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1a,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1a,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1a,0xd8,0xff,0x01,0x00,0x00]

ds_max_i32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xd8,0x00,0x01,0x00,0x00]

ds_max_i32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xd8,0xff,0xfe,0x00,0x00]

ds_max_i32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xd8,0x00,0xfe,0x00,0x00]

ds_max_i32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x1c,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x1c,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x1c,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x1c,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x1e,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1e,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1e,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1e,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x1e,0xd8,0xff,0x01,0x00,0x00]

ds_min_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xd8,0x00,0x01,0x00,0x00]

ds_min_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xd8,0xff,0xfe,0x00,0x00]

ds_min_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xd8,0x00,0xfe,0x00,0x00]

ds_min_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x20,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x20,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x20,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x20,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x22,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x22,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x22,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x22,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x22,0xd8,0xff,0x01,0x00,0x00]

ds_max_u32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xd8,0x00,0x01,0x00,0x00]

ds_max_u32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xd8,0xff,0xfe,0x00,0x00]

ds_max_u32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xd8,0x00,0xfe,0x00,0x00]

ds_max_u32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x24,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x24,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x24,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x24,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x26,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x26,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x26,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x26,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x26,0xd8,0xff,0x01,0x00,0x00]

ds_and_b32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xd8,0x00,0x01,0x00,0x00]

ds_and_b32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xd8,0xff,0xfe,0x00,0x00]

ds_and_b32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xd8,0x00,0xfe,0x00,0x00]

ds_and_b32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x28,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x28,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x28,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x28,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2a,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2a,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2a,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2a,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2a,0xd8,0xff,0x01,0x00,0x00]

ds_or_b32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xd8,0x00,0x01,0x00,0x00]

ds_or_b32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xd8,0xff,0xfe,0x00,0x00]

ds_or_b32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xd8,0x00,0xfe,0x00,0x00]

ds_or_b32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x2c,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x2c,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x2c,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x2c,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x2e,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2e,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2e,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2e,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x2e,0xd8,0xff,0x01,0x00,0x00]

ds_xor_b32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xd8,0x00,0x01,0x00,0x00]

ds_xor_b32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xd8,0xff,0xfe,0x00,0x00]

ds_xor_b32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xd8,0x00,0xfe,0x00,0x00]

ds_xor_b32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xd8,0xff,0x01,0x00,0x00]

ds_mskor_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x30,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x30,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x30,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x30,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x30,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x30,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x32,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x32,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x32,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x32,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x32,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x32,0xd8,0xff,0xfe,0x02,0x00]

ds_mskor_b32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x32,0xd8,0x00,0x01,0x02,0x00]

ds_mskor_b32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x32,0xd8,0xff,0xfe,0xfd,0x00]

ds_mskor_b32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x32,0xd8,0x00,0xfe,0xfd,0x00]

ds_mskor_b32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x32,0xd8,0xff,0x01,0xfd,0x00]

ds_mskor_b32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x32,0xd8,0xff,0xfe,0x02,0x00]

ds_write_b32 v0, v1
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x34,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x34,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x34,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x34,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x36,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x36,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x36,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x36,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x36,0xd8,0xff,0x01,0x00,0x00]

ds_write_b32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xd8,0x00,0x01,0x00,0x00]

ds_write_b32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xd8,0xff,0x01,0x00,0x00]

ds_write2_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x38,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2_b32 v0, v1, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0x00,0x01,0x02,0x00]

ds_write2_b32 v255, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2_b32 v0, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2_b32 v255, v1, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0xff,0x01,0xfd,0x00]

ds_write2_b32 v255, v254, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3a,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:0 offset1:123
// GFX10: encoding: [0x00,0x7b,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:123 offset1:0
// GFX10: encoding: [0x7b,0x00,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:64 offset1:123
// GFX10: encoding: [0x40,0x7b,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:123 offset1:64
// GFX10: encoding: [0x7b,0x40,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:64 offset1:255
// GFX10: encoding: [0x40,0xff,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:255 offset1:64
// GFX10: encoding: [0xff,0x40,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:255 offset1:255
// GFX10: encoding: [0xff,0xff,0x3c,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:0 offset1:123 gds
// GFX10: encoding: [0x00,0x7b,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:123 offset1:0 gds
// GFX10: encoding: [0x7b,0x00,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:64 offset1:123 gds
// GFX10: encoding: [0x40,0x7b,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:123 offset1:64 gds
// GFX10: encoding: [0x7b,0x40,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:64 offset1:255 gds
// GFX10: encoding: [0x40,0xff,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:255 offset1:64 gds
// GFX10: encoding: [0xff,0x40,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_write2st64_b32 v0, v1, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0x00,0x01,0x02,0x00]

ds_write2st64_b32 v255, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0xff,0xfe,0xfd,0x00]

ds_write2st64_b32 v0, v254, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0x00,0xfe,0xfd,0x00]

ds_write2st64_b32 v255, v1, v253 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0xff,0x01,0xfd,0x00]

ds_write2st64_b32 v255, v254, v2 offset0:255 offset1:255 gds
// GFX10: encoding: [0xff,0xff,0x3e,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x40,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x40,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x40,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x40,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x40,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x40,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x42,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x42,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x42,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x42,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x42,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x42,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_b32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x42,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_b32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x42,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_b32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x42,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_b32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x42,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_b32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x42,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x44,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x44,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x44,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x44,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x44,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x44,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x46,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x46,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x46,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x46,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x46,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x46,0xd8,0xff,0xfe,0x02,0x00]

ds_cmpst_f32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x46,0xd8,0x00,0x01,0x02,0x00]

ds_cmpst_f32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x46,0xd8,0xff,0xfe,0xfd,0x00]

ds_cmpst_f32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x46,0xd8,0x00,0xfe,0xfd,0x00]

ds_cmpst_f32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x46,0xd8,0xff,0x01,0xfd,0x00]

ds_cmpst_f32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x46,0xd8,0xff,0xfe,0x02,0x00]

ds_min_f32 v0, v1
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x48,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x48,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x48,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x48,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4a,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4a,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4a,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4a,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4a,0xd8,0xff,0x01,0x00,0x00]

ds_min_f32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xd8,0x00,0x01,0x00,0x00]

ds_min_f32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xd8,0xff,0xfe,0x00,0x00]

ds_min_f32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xd8,0x00,0xfe,0x00,0x00]

ds_min_f32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x4c,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x4c,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x4c,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x4c,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x4e,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4e,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4e,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4e,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x4e,0xd8,0xff,0x01,0x00,0x00]

ds_max_f32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xd8,0x00,0x01,0x00,0x00]

ds_max_f32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xd8,0xff,0xfe,0x00,0x00]

ds_max_f32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xd8,0x00,0xfe,0x00,0x00]

ds_max_f32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xd8,0xff,0x01,0x00,0x00]

ds_nop
// GFX10: encoding: [0x00,0x00,0x50,0xd8,0x00,0x00,0x00,0x00]

ds_add_f32 v0, v1
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd8,0xff,0x01,0x00,0x00]

ds_add_f32 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd8,0x00,0x01,0x00,0x00]

ds_add_f32 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd8,0xff,0xfe,0x00,0x00]

ds_add_f32 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd8,0x00,0xfe,0x00,0x00]

ds_add_f32 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd8,0xff,0x01,0x00,0x00]

ds_gws_sema_release_all gds
// GFX10: encoding: [0x00,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:0 gds
// GFX10: encoding: [0x00,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v0 gds
// GFX10: encoding: [0x00,0x00,0x66,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v255 gds
// GFX10: encoding: [0x00,0x00,0x66,0xd8,0x00,0xff,0x00,0x00]

ds_gws_init v0 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x66,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v255 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x66,0xd8,0x00,0xff,0x00,0x00]

ds_gws_init v0 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x66,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v255 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x66,0xd8,0x00,0xff,0x00,0x00]

ds_gws_init v0 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x66,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v255 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x66,0xd8,0x00,0xff,0x00,0x00]

ds_gws_sema_v gds
// GFX10: encoding: [0x00,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:0 gds
// GFX10: encoding: [0x00,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v0 gds
// GFX10: encoding: [0x00,0x00,0x6e,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v255 gds
// GFX10: encoding: [0x00,0x00,0x6e,0xd8,0x00,0xff,0x00,0x00]

ds_gws_sema_br v0 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x6e,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v255 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x6e,0xd8,0x00,0xff,0x00,0x00]

ds_gws_sema_br v0 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x6e,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v255 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x6e,0xd8,0x00,0xff,0x00,0x00]

ds_gws_sema_br v0 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x6e,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v255 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x6e,0xd8,0x00,0xff,0x00,0x00]

ds_gws_sema_p gds
// GFX10: encoding: [0x00,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:0 gds
// GFX10: encoding: [0x00,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v0 gds
// GFX10: encoding: [0x00,0x00,0x76,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v255 gds
// GFX10: encoding: [0x00,0x00,0x76,0xd8,0x00,0xff,0x00,0x00]

ds_gws_barrier v0 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x76,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v255 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x76,0xd8,0x00,0xff,0x00,0x00]

ds_gws_barrier v0 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x76,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v255 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x76,0xd8,0x00,0xff,0x00,0x00]

ds_gws_barrier v0 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x76,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v255 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x76,0xd8,0x00,0xff,0x00,0x00]

ds_write_b8 v0, v1
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x78,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x78,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x78,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x78,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x78,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7a,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7a,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7a,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7a,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7a,0xd8,0xff,0x01,0x00,0x00]

ds_write_b8 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7a,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7a,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b8 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7a,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b8 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7a,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 offset:0
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x7c,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x7c,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x7c,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 offset:4660
// GFX10: encoding: [0x34,0x12,0x7c,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 offset:4660
// GFX10: encoding: [0x34,0x12,0x7c,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x7e,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7e,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7e,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7e,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x7e,0xd8,0xff,0x01,0x00,0x00]

ds_write_b16 v0, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7e,0xd8,0x00,0x01,0x00,0x00]

ds_write_b16 v255, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7e,0xd8,0xff,0xfe,0x00,0x00]

ds_write_b16 v0, v254 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7e,0xd8,0x00,0xfe,0x00,0x00]

ds_write_b16 v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7e,0xd8,0xff,0x01,0x00,0x00]

ds_add_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x80,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x80,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x80,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x80,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x80,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x82,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x82,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x82,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x82,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x82,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x82,0xd8,0xfe,0x02,0x00,0xff]

ds_add_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xd8,0xfe,0xfd,0x00,0xff]

ds_add_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xd8,0xfe,0xfd,0x00,0x00]

ds_add_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xd8,0x01,0xfd,0x00,0xff]

ds_add_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x84,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x84,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x84,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x84,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x84,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x86,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x86,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x86,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x86,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x86,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x86,0xd8,0xfe,0x02,0x00,0xff]

ds_sub_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xd8,0x01,0x02,0x00,0x00]

ds_sub_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xd8,0xfe,0xfd,0x00,0xff]

ds_sub_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xd8,0xfe,0xfd,0x00,0x00]

ds_sub_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xd8,0x01,0xfd,0x00,0xff]

ds_sub_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x88,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x88,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x88,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x88,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x88,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8a,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8a,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8a,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8a,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8a,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8a,0xd8,0xfe,0x02,0x00,0xff]

ds_rsub_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xd8,0xfe,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xd8,0xfe,0xfd,0x00,0x00]

ds_rsub_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xd8,0x01,0xfd,0x00,0xff]

ds_rsub_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x8c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x8c,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x8c,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x8c,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x8c,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x8e,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8e,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8e,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8e,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8e,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x8e,0xd8,0xfe,0x02,0x00,0xff]

ds_inc_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xd8,0x01,0x02,0x00,0x00]

ds_inc_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xd8,0xfe,0xfd,0x00,0xff]

ds_inc_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xd8,0xfe,0xfd,0x00,0x00]

ds_inc_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xd8,0x01,0xfd,0x00,0xff]

ds_inc_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x90,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x90,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x90,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x90,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x90,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x92,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x92,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x92,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x92,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x92,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x92,0xd8,0xfe,0x02,0x00,0xff]

ds_dec_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xd8,0x01,0x02,0x00,0x00]

ds_dec_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xd8,0xfe,0xfd,0x00,0xff]

ds_dec_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xd8,0xfe,0xfd,0x00,0x00]

ds_dec_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xd8,0x01,0xfd,0x00,0xff]

ds_dec_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x94,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x94,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x94,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x94,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x94,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x96,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x96,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x96,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x96,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x96,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x96,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_i32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_i32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_i32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_i32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_i32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x98,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x98,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x98,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x98,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x98,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9a,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9a,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9a,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9a,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9a,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9a,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_i32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_i32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_i32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_i32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_i32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x9c,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x9c,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x9c,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x9c,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x9c,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x9e,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9e,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9e,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9e,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9e,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x9e,0xd8,0xfe,0x02,0x00,0xff]

ds_min_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xd8,0x01,0x02,0x00,0x00]

ds_min_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xd8,0xfe,0xfd,0x00,0xff]

ds_min_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xd8,0xfe,0xfd,0x00,0x00]

ds_min_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xd8,0x01,0xfd,0x00,0xff]

ds_min_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xa0,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xa0,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa0,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa0,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa0,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xa0,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa2,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa2,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa2,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa2,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa2,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa2,0xd8,0xfe,0x02,0x00,0xff]

ds_max_rtn_u32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa2,0xd8,0x01,0x02,0x00,0x00]

ds_max_rtn_u32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa2,0xd8,0xfe,0xfd,0x00,0xff]

ds_max_rtn_u32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa2,0xd8,0xfe,0xfd,0x00,0x00]

ds_max_rtn_u32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa2,0xd8,0x01,0xfd,0x00,0xff]

ds_max_rtn_u32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa2,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xa4,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xa4,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa4,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa4,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa4,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xa4,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xa6,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa6,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa6,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa6,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa6,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xa6,0xd8,0xfe,0x02,0x00,0xff]

ds_and_rtn_b32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa6,0xd8,0x01,0x02,0x00,0x00]

ds_and_rtn_b32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa6,0xd8,0xfe,0xfd,0x00,0xff]

ds_and_rtn_b32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa6,0xd8,0xfe,0xfd,0x00,0x00]

ds_and_rtn_b32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa6,0xd8,0x01,0xfd,0x00,0xff]

ds_and_rtn_b32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa6,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xa8,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xa8,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa8,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa8,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xa8,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xa8,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xaa,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xaa,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xaa,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xaa,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xaa,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xaa,0xd8,0xfe,0x02,0x00,0xff]

ds_or_rtn_b32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xaa,0xd8,0x01,0x02,0x00,0x00]

ds_or_rtn_b32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xaa,0xd8,0xfe,0xfd,0x00,0xff]

ds_or_rtn_b32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xaa,0xd8,0xfe,0xfd,0x00,0x00]

ds_or_rtn_b32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xaa,0xd8,0x01,0xfd,0x00,0xff]

ds_or_rtn_b32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xaa,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xac,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xac,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xac,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xac,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xac,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xac,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xae,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xae,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xae,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xae,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xae,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xae,0xd8,0xfe,0x02,0x00,0xff]

ds_xor_rtn_b32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xae,0xd8,0x01,0x02,0x00,0x00]

ds_xor_rtn_b32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xae,0xd8,0xfe,0xfd,0x00,0xff]

ds_xor_rtn_b32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xae,0xd8,0xfe,0xfd,0x00,0x00]

ds_xor_rtn_b32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xae,0xd8,0x01,0xfd,0x00,0xff]

ds_xor_rtn_b32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xae,0xd8,0xfe,0x02,0x00,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 offset:4660
// GFX10: encoding: [0x34,0x12,0xb0,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 offset:4660
// GFX10: encoding: [0x34,0x12,0xb0,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 offset:4660
// GFX10: encoding: [0x34,0x12,0xb0,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 offset:4660
// GFX10: encoding: [0x34,0x12,0xb0,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 offset:4660
// GFX10: encoding: [0x34,0x12,0xb0,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 offset:4660
// GFX10: encoding: [0x34,0x12,0xb0,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb2,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb2,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb2,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb2,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb2,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb2,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb2,0xd8,0xfe,0xfd,0x03,0xff]

ds_mskor_rtn_b32 v0, v1, v2, v3 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_rtn_b32 v255, v254, v253, v252 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd8,0xfe,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v0, v254, v253, v252 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd8,0xfe,0xfd,0xfc,0x00]

ds_mskor_rtn_b32 v255, v1, v253, v252 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd8,0x01,0xfd,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v2, v252 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd8,0xfe,0x02,0xfc,0xff]

ds_mskor_rtn_b32 v255, v254, v253, v3 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd8,0xfe,0xfd,0x03,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xb4,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xb4,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xb4,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xb4,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xb4,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xb4,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xb6,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb6,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb6,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb6,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb6,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0xb6,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb6,0xd8,0x01,0x02,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb6,0xd8,0xfe,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb6,0xd8,0xfe,0xfd,0x00,0x00]

ds_wrxchg_rtn_b32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb6,0xd8,0x01,0xfd,0x00,0xff]

ds_wrxchg_rtn_b32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb6,0xd8,0xfe,0x02,0x00,0xff]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2_rtn_b32 v[5:6], v255, v2, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd8,0xff,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v255, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd8,0x01,0xff,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v255 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0xff,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset1:255
// GFX10: encoding: [0x00,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127
// GFX10: encoding: [0x7f,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xba,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2st64_rtn_b32 v[5:6], v255, v2, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd8,0xff,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v255, v3 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd8,0x01,0xff,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v255 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0xff,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset1:255
// GFX10: encoding: [0x00,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127
// GFX10: encoding: [0x7f,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xbe,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v255, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0xff]

ds_cmpst_rtn_b32 v5, v255, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd8,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v255, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd8,0x01,0xff,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd8,0x01,0x02,0xff,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3
// GFX10: encoding: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:0
// GFX10: encoding: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:4
// GFX10: encoding: [0x04,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xc2,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v255, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd8,0x01,0x02,0x03,0xff]

ds_cmpst_rtn_f32 v5, v255, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd8,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v255, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd8,0x01,0xff,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd8,0x01,0x02,0xff,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3
// GFX10: encoding: [0x00,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:0
// GFX10: encoding: [0x00,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:4
// GFX10: encoding: [0x04,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xc6,0xd8,0x01,0x02,0x03,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v255, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_f32 v5, v255, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2
// GFX10: encoding: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:4
// GFX10: encoding: [0x04,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xca,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v255, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_f32 v5, v255, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2
// GFX10: encoding: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:4
// GFX10: encoding: [0x04,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xce,0xd8,0x01,0x02,0x00,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v255, v1, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xd0,0xd8,0x01,0x02,0x03,0xff]

ds_wrap_rtn_b32 v5, v255, v2, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xd0,0xd8,0xff,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v255, v3 offset:65535
// GFX10: encoding: [0xff,0xff,0xd0,0xd8,0x01,0xff,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xd0,0xd8,0x01,0x02,0xff,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3
// GFX10: encoding: [0x00,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:0
// GFX10: encoding: [0x00,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:4
// GFX10: encoding: [0x04,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xd2,0xd8,0x01,0x02,0x03,0x05]

ds_swizzle_b32 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xd4,0xd8,0x01,0x00,0x00,0xff]

ds_swizzle_b32 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xd4,0xd8,0xff,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1
// GFX10: encoding: [0x00,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xd6,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0xff]

ds_read_b32 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xd8,0xd8,0xff,0x00,0x00,0x05]

ds_read_b32 v5, v1
// GFX10: encoding: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xda,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[254:255], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0xfe]

ds_read2_b32 v[5:6], v255 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xdc,0xd8,0xff,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset1:255
// GFX10: encoding: [0x00,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127
// GFX10: encoding: [0x7f,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xde,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[254:255], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0xfe]

ds_read2st64_b32 v[5:6], v255 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xe0,0xd8,0xff,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset1:255
// GFX10: encoding: [0x00,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127
// GFX10: encoding: [0x7f,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xe2,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0xff]

ds_read_i8 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xe4,0xd8,0xff,0x00,0x00,0x05]

ds_read_i8 v5, v1
// GFX10: encoding: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xe6,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0xff]

ds_read_u8 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xe8,0xd8,0xff,0x00,0x00,0x05]

ds_read_u8 v5, v1
// GFX10: encoding: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xea,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0xff]

ds_read_i16 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xec,0xd8,0xff,0x00,0x00,0x05]

ds_read_i16 v5, v1
// GFX10: encoding: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xee,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0xff]

ds_read_u16 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xf0,0xd8,0xff,0x00,0x00,0x05]

ds_read_u16 v5, v1
// GFX10: encoding: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xf2,0xd8,0x01,0x00,0x00,0x05]

ds_consume v5 offset:65535
// GFX10: encoding: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0xff]

ds_consume v5
// GFX10: encoding: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:0
// GFX10: encoding: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:4
// GFX10: encoding: [0x04,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xf6,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0xff]

ds_append v5
// GFX10: encoding: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:0
// GFX10: encoding: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:4
// GFX10: encoding: [0x04,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfa,0xd8,0x00,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v255, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfe,0xd8,0x01,0x00,0x00,0xff]

ds_ordered_count v5, v255 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfe,0xd8,0xff,0x00,0x00,0x05]

ds_ordered_count v5, v1 gds
// GFX10: encoding: [0x00,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:0 gds
// GFX10: encoding: [0x00,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:4 gds
// GFX10: encoding: [0x04,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_add_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd9,0xff,0x02,0x00,0x00]

ds_add_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xd9,0x01,0xfe,0x00,0x00]

ds_add_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd9,0xff,0x02,0x00,0x00]

ds_sub_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xd9,0x01,0xfe,0x00,0x00]

ds_sub_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd9,0xff,0x02,0x00,0x00]

ds_rsub_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xd9,0x01,0xfe,0x00,0x00]

ds_rsub_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd9,0xff,0x02,0x00,0x00]

ds_inc_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xd9,0x01,0xfe,0x00,0x00]

ds_inc_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd9,0xff,0x02,0x00,0x00]

ds_dec_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xd9,0x01,0xfe,0x00,0x00]

ds_dec_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd9,0xff,0x02,0x00,0x00]

ds_min_i64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xd9,0x01,0xfe,0x00,0x00]

ds_min_i64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd9,0xff,0x02,0x00,0x00]

ds_max_i64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xd9,0x01,0xfe,0x00,0x00]

ds_max_i64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd9,0xff,0x02,0x00,0x00]

ds_min_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xd9,0x01,0xfe,0x00,0x00]

ds_min_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd9,0xff,0x02,0x00,0x00]

ds_max_u64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xd9,0x01,0xfe,0x00,0x00]

ds_max_u64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd9,0xff,0x02,0x00,0x00]

ds_and_b64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xd9,0x01,0xfe,0x00,0x00]

ds_and_b64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd9,0xff,0x02,0x00,0x00]

ds_or_b64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xd9,0x01,0xfe,0x00,0x00]

ds_or_b64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd9,0xff,0x02,0x00,0x00]

ds_xor_b64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xd9,0x01,0xfe,0x00,0x00]

ds_xor_b64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xd9,0x01,0x02,0x00,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v255, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd9,0xff,0x02,0x03,0x00]

ds_mskor_b64 v1, v[254:255], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd9,0x01,0xfe,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x30,0xd9,0x01,0x02,0xfe,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4]
// GFX10: encoding: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:0
// GFX10: encoding: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:4
// GFX10: encoding: [0x04,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x32,0xd9,0x01,0x02,0x03,0x00]

ds_write_b64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd9,0xff,0x02,0x00,0x00]

ds_write_b64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xd9,0x01,0xfe,0x00,0x00]

ds_write_b64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xd9,0x01,0x02,0x00,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v255, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x38,0xd9,0xff,0x02,0x03,0x00]

ds_write2_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x38,0xd9,0x01,0xfe,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[254:255] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x38,0xd9,0x01,0x02,0xfe,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset1:255
// GFX10: encoding: [0x00,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127
// GFX10: encoding: [0x7f,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0x3a,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v255, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x3c,0xd9,0xff,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x3c,0xd9,0x01,0xfe,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[254:255] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0xfe,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset1:255
// GFX10: encoding: [0x00,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127
// GFX10: encoding: [0x7f,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0x3e,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v255, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd9,0xff,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[254:255], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd9,0x01,0xfe,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x40,0xd9,0x01,0x02,0xfe,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4]
// GFX10: encoding: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:0
// GFX10: encoding: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:4
// GFX10: encoding: [0x04,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x42,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v255, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd9,0xff,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[254:255], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd9,0x01,0xfe,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x44,0xd9,0x01,0x02,0xfe,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4]
// GFX10: encoding: [0x00,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:0
// GFX10: encoding: [0x00,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:4
// GFX10: encoding: [0x04,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x46,0xd9,0x01,0x02,0x03,0x00]

ds_min_f64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd9,0xff,0x02,0x00,0x00]

ds_min_f64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xd9,0x01,0xfe,0x00,0x00]

ds_min_f64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd9,0xff,0x02,0x00,0x00]

ds_max_f64 v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xd9,0x01,0xfe,0x00,0x00]

ds_max_f64 v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0x54,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 offset:0 gds
// GFX10: encoding: [0x00,0x00,0x56,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 offset:4660 gds
// GFX10: encoding: [0x34,0x12,0x56,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_f32 v0, v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_f32 v255, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd9,0xfe,0xfd,0x00,0xff]

ds_add_rtn_f32 v0, v254, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd9,0xfe,0xfd,0x00,0x00]

ds_add_rtn_f32 v255, v1, v253 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd9,0x01,0xfd,0x00,0xff]

ds_add_rtn_f32 v255, v254, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xd9,0xfe,0x02,0x00,0xff]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0xfe]

ds_add_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd9,0xff,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xd9,0x01,0xfe,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0xfe]

ds_sub_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd9,0xff,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xd9,0x01,0xfe,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0xfe]

ds_rsub_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd9,0xff,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xd9,0x01,0xfe,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0xfe]

ds_inc_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd9,0xff,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xd9,0x01,0xfe,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0xfe]

ds_dec_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd9,0xff,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xd9,0x01,0xfe,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_i64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_i64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xa0,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa2,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0xfe]

ds_and_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd9,0xff,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xa4,0xd9,0x01,0xfe,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xa6,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0xfe]

ds_or_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd9,0xff,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xa8,0xd9,0x01,0xfe,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xaa,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0xfe]

ds_xor_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd9,0xff,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xac,0xd9,0x01,0xfe,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xae,0xd9,0x01,0x02,0x00,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0xfe]

ds_mskor_rtn_b64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd9,0xff,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd9,0x01,0xfe,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xb0,0xd9,0x01,0x02,0xfe,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// GFX10: encoding: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// GFX10: encoding: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:4
// GFX10: encoding: [0x04,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb2,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0xfe]

ds_wrxchg_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd9,0xff,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xb4,0xd9,0x01,0xfe,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xb6,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2_rtn_b64 v[5:8], v255, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd9,0xff,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[254:255], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd9,0x01,0xfe,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[254:255] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0xfe,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset1:255
// GFX10: encoding: [0x00,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127
// GFX10: encoding: [0x7f,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xba,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2st64_rtn_b64 v[5:8], v255, v[2:3], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd9,0xff,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[254:255], v[3:4] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd9,0x01,0xfe,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[254:255] offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0xfe,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset1:255
// GFX10: encoding: [0x00,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127
// GFX10: encoding: [0x7f,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xbe,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0xfe]

ds_cmpst_rtn_b64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd9,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd9,0x01,0xfe,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xd9,0x01,0x02,0xfe,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// GFX10: encoding: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// GFX10: encoding: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:4
// GFX10: encoding: [0x04,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xc2,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd9,0x01,0x02,0x03,0xfe]

ds_cmpst_rtn_f64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd9,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd9,0x01,0xfe,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xd9,0x01,0x02,0xfe,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4]
// GFX10: encoding: [0x00,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:0
// GFX10: encoding: [0x00,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:4
// GFX10: encoding: [0x04,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xc6,0xd9,0x01,0x02,0x03,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_f64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xca,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_f64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xce,0xd9,0x01,0x02,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[254:255], v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0xfe]

ds_read_b64 v[5:6], v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xd8,0xd9,0xff,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1
// GFX10: encoding: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:0
// GFX10: encoding: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:4
// GFX10: encoding: [0x04,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xda,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[252:255], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0xfc]

ds_read2_b64 v[5:8], v255 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xdc,0xd9,0xff,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset1:255
// GFX10: encoding: [0x00,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127
// GFX10: encoding: [0x7f,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xde,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[252:255], v1 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0xfc]

ds_read2st64_b64 v[5:8], v255 offset0:127 offset1:255
// GFX10: encoding: [0x7f,0xff,0xe0,0xd9,0xff,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset1:255
// GFX10: encoding: [0x00,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:0 offset1:255
// GFX10: encoding: [0x00,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:16 offset1:255
// GFX10: encoding: [0x10,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127
// GFX10: encoding: [0x7f,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:0
// GFX10: encoding: [0x7f,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:1
// GFX10: encoding: [0x7f,0x01,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255 gds
// GFX10: encoding: [0x7f,0xff,0xe2,0xd9,0x01,0x00,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0xfe]

ds_condxchg32_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xd9,0xff,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xd9,0x01,0xfe,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3]
// GFX10: encoding: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:0
// GFX10: encoding: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:4
// GFX10: encoding: [0x04,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfa,0xd9,0x01,0x02,0x00,0x05]

ds_add_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xda,0xff,0x00,0x00,0x00]

ds_add_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xda,0xff,0x00,0x00,0x00]

ds_sub_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xda,0xff,0x00,0x00,0x00]

ds_rsub_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xda,0xff,0x00,0x00,0x00]

ds_inc_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xda,0xff,0x00,0x00,0x00]

ds_dec_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_i32 v1
// GFX10: encoding: [0x00,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_i32 v1
// GFX10: encoding: [0x00,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_u32 v1
// GFX10: encoding: [0x00,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xda,0xff,0x00,0x00,0x00]

ds_and_src2_b32 v1
// GFX10: encoding: [0x00,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xda,0xff,0x00,0x00,0x00]

ds_or_src2_b32 v1
// GFX10: encoding: [0x00,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xda,0xff,0x00,0x00,0x00]

ds_xor_src2_b32 v1
// GFX10: encoding: [0x00,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xda,0xff,0x00,0x00,0x00]

ds_write_src2_b32 v1
// GFX10: encoding: [0x00,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_f32 v1
// GFX10: encoding: [0x00,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_f32 v1
// GFX10: encoding: [0x00,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_f32 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_f32 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x54,0xda,0xff,0x00,0x00,0x00]

ds_add_src2_f32 v1
// GFX10: encoding: [0x00,0x00,0x54,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_f32 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x54,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_f32 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x54,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_f32 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x56,0xda,0x01,0x00,0x00,0x00]

ds_write_b8_d16_hi v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v255, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xda,0xff,0x02,0x00,0x00]

ds_write_b8_d16_hi v1, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x80,0xda,0x01,0xff,0x00,0x00]

ds_write_b8_d16_hi v1, v2
// GFX10: encoding: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v1, v2 offset:4
// GFX10: encoding: [0x04,0x00,0x80,0xda,0x01,0x02,0x00,0x00]

ds_write_b8_d16_hi v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x82,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v255, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xda,0xff,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x84,0xda,0x01,0xff,0x00,0x00]

ds_write_b16_d16_hi v1, v2
// GFX10: encoding: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2 offset:4
// GFX10: encoding: [0x04,0x00,0x84,0xda,0x01,0x02,0x00,0x00]

ds_write_b16_d16_hi v1, v2 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x86,0xda,0x01,0x02,0x00,0x00]

ds_read_u8_d16 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xda,0x01,0x00,0x00,0xff]

ds_read_u8_d16 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x88,0xda,0xff,0x00,0x00,0x05]

ds_read_u8_d16 v5, v1
// GFX10: encoding: [0x00,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0x88,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8a,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xda,0x01,0x00,0x00,0xff]

ds_read_u8_d16_hi v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x8c,0xda,0xff,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1
// GFX10: encoding: [0x00,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0x8c,0xda,0x01,0x00,0x00,0x05]

ds_read_u8_d16_hi v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x8e,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xda,0x01,0x00,0x00,0xff]

ds_read_i8_d16 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x90,0xda,0xff,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1
// GFX10: encoding: [0x00,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0x90,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x92,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xda,0x01,0x00,0x00,0xff]

ds_read_i8_d16_hi v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x94,0xda,0xff,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1
// GFX10: encoding: [0x00,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0x94,0xda,0x01,0x00,0x00,0x05]

ds_read_i8_d16_hi v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x96,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xda,0x01,0x00,0x00,0xff]

ds_read_u16_d16 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x98,0xda,0xff,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1
// GFX10: encoding: [0x00,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0x98,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9a,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xda,0x01,0x00,0x00,0xff]

ds_read_u16_d16_hi v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x9c,0xda,0xff,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1
// GFX10: encoding: [0x00,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0x9c,0xda,0x01,0x00,0x00,0x05]

ds_read_u16_d16_hi v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x9e,0xda,0x01,0x00,0x00,0x05]

ds_write_addtid_b32 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xda,0x05,0x01,0x00,0x00]

ds_write_addtid_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xda,0xff,0x01,0x00,0x00]

ds_write_addtid_b32 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xc0,0xda,0x05,0xff,0x00,0x00]

ds_write_addtid_b32 v5, v1
// GFX10: encoding: [0x00,0x00,0xc0,0xda,0x05,0x01,0x00,0x00]

ds_write_addtid_b32 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xc0,0xda,0x05,0x01,0x00,0x00]

ds_write_addtid_b32 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xc0,0xda,0x05,0x01,0x00,0x00]

ds_write_addtid_b32 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xc2,0xda,0x05,0x01,0x00,0x00]

ds_read_addtid_b32 v5, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xda,0x01,0x00,0x00,0x05]

ds_read_addtid_b32 v255, v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xda,0x01,0x00,0x00,0xff]

ds_read_addtid_b32 v5, v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xc4,0xda,0xff,0x00,0x00,0x05]

ds_read_addtid_b32 v5, v1
// GFX10: encoding: [0x00,0x00,0xc4,0xda,0x01,0x00,0x00,0x05]

ds_read_addtid_b32 v5, v1 offset:0
// GFX10: encoding: [0x00,0x00,0xc4,0xda,0x01,0x00,0x00,0x05]

ds_read_addtid_b32 v5, v1 offset:4
// GFX10: encoding: [0x04,0x00,0xc4,0xda,0x01,0x00,0x00,0x05]

ds_read_addtid_b32 v5, v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xc6,0xda,0x01,0x00,0x00,0x05]

ds_permute_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0x01,0x02,0x00,0x00]

ds_permute_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0xfe,0xfd,0x00,0xff]

ds_permute_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0xfe,0xfd,0x00,0x00]

ds_permute_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0x01,0xfd,0x00,0xff]

ds_permute_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0xfe,0x02,0x00,0xff]

ds_permute_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0x01,0x02,0x00,0x00]

ds_permute_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0xfe,0xfd,0x00,0xff]

ds_permute_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0xfe,0xfd,0x00,0x00]

ds_permute_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0x01,0xfd,0x00,0xff]

ds_permute_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xc8,0xda,0xfe,0x02,0x00,0xff]

ds_permute_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xc8,0xda,0x01,0x02,0x00,0x00]

ds_permute_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xc8,0xda,0xfe,0xfd,0x00,0xff]

ds_permute_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xc8,0xda,0xfe,0xfd,0x00,0x00]

ds_permute_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xc8,0xda,0x01,0xfd,0x00,0xff]

ds_permute_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xc8,0xda,0xfe,0x02,0x00,0xff]

ds_permute_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xda,0x01,0x02,0x00,0x00]

ds_permute_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xda,0xfe,0xfd,0x00,0xff]

ds_permute_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xda,0xfe,0xfd,0x00,0x00]

ds_permute_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xda,0x01,0xfd,0x00,0xff]

ds_permute_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xc8,0xda,0xfe,0x02,0x00,0xff]

ds_bpermute_b32 v0, v1, v2
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0x01,0x02,0x00,0x00]

ds_bpermute_b32 v255, v254, v253
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0xfe,0xfd,0x00,0xff]

ds_bpermute_b32 v0, v254, v253
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0xfe,0xfd,0x00,0x00]

ds_bpermute_b32 v255, v1, v253
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0x01,0xfd,0x00,0xff]

ds_bpermute_b32 v255, v254, v2
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0xfe,0x02,0x00,0xff]

ds_bpermute_b32 v0, v1, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0x01,0x02,0x00,0x00]

ds_bpermute_b32 v255, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0xfe,0xfd,0x00,0xff]

ds_bpermute_b32 v0, v254, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0xfe,0xfd,0x00,0x00]

ds_bpermute_b32 v255, v1, v253 offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0x01,0xfd,0x00,0xff]

ds_bpermute_b32 v255, v254, v2 offset:0
// GFX10: encoding: [0x00,0x00,0xcc,0xda,0xfe,0x02,0x00,0xff]

ds_bpermute_b32 v0, v1, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xcc,0xda,0x01,0x02,0x00,0x00]

ds_bpermute_b32 v255, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xcc,0xda,0xfe,0xfd,0x00,0xff]

ds_bpermute_b32 v0, v254, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xcc,0xda,0xfe,0xfd,0x00,0x00]

ds_bpermute_b32 v255, v1, v253 offset:4660
// GFX10: encoding: [0x34,0x12,0xcc,0xda,0x01,0xfd,0x00,0xff]

ds_bpermute_b32 v255, v254, v2 offset:4660
// GFX10: encoding: [0x34,0x12,0xcc,0xda,0xfe,0x02,0x00,0xff]

ds_bpermute_b32 v0, v1, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xda,0x01,0x02,0x00,0x00]

ds_bpermute_b32 v255, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xda,0xfe,0xfd,0x00,0xff]

ds_bpermute_b32 v0, v254, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xda,0xfe,0xfd,0x00,0x00]

ds_bpermute_b32 v255, v1, v253 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xda,0x01,0xfd,0x00,0xff]

ds_bpermute_b32 v255, v254, v2 offset:65535
// GFX10: encoding: [0xff,0xff,0xcc,0xda,0xfe,0x02,0x00,0xff]

ds_add_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x00,0xdb,0xff,0x00,0x00,0x00]

ds_add_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x02,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x04,0xdb,0xff,0x00,0x00,0x00]

ds_sub_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x06,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x08,0xdb,0xff,0x00,0x00,0x00]

ds_rsub_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0a,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x0c,0xdb,0xff,0x00,0x00,0x00]

ds_inc_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x0e,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x10,0xdb,0xff,0x00,0x00,0x00]

ds_dec_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x12,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x14,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_i64 v1
// GFX10: encoding: [0x00,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x16,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x18,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_i64 v1
// GFX10: encoding: [0x00,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1a,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x1c,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x1e,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x20,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_u64 v1
// GFX10: encoding: [0x00,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x22,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x24,0xdb,0xff,0x00,0x00,0x00]

ds_and_src2_b64 v1
// GFX10: encoding: [0x00,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x26,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x28,0xdb,0xff,0x00,0x00,0x00]

ds_or_src2_b64 v1
// GFX10: encoding: [0x00,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2a,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x2c,0xdb,0xff,0x00,0x00,0x00]

ds_xor_src2_b64 v1
// GFX10: encoding: [0x00,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x2e,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x34,0xdb,0xff,0x00,0x00,0x00]

ds_write_src2_b64 v1
// GFX10: encoding: [0x00,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x36,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x48,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_f64 v1
// GFX10: encoding: [0x00,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4a,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v255 offset:65535
// GFX10: encoding: [0xff,0xff,0x4c,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_f64 v1
// GFX10: encoding: [0x00,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:0
// GFX10: encoding: [0x00,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:4
// GFX10: encoding: [0x04,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x4e,0xdb,0x01,0x00,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v255, v[2:4] offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xdb,0xff,0x02,0x00,0x00]

ds_write_b96 v1, v[253:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x78,0xdb,0x01,0xfd,0x00,0x00]

ds_write_b96 v1, v[2:4]
// GFX10: encoding: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:0
// GFX10: encoding: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:4
// GFX10: encoding: [0x04,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7a,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v255, v[2:5] offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xdb,0xff,0x02,0x00,0x00]

ds_write_b128 v1, v[252:255] offset:65535
// GFX10: encoding: [0xff,0xff,0x7c,0xdb,0x01,0xfc,0x00,0x00]

ds_write_b128 v1, v[2:5]
// GFX10: encoding: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:0
// GFX10: encoding: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:4
// GFX10: encoding: [0x04,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535 gds
// GFX10: encoding: [0xff,0xff,0x7e,0xdb,0x01,0x02,0x00,0x00]

ds_read_b96 v[5:7], v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[253:255], v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0xfd]

ds_read_b96 v[5:7], v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xf8,0xdb,0xff,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1
// GFX10: encoding: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:0
// GFX10: encoding: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:4
// GFX10: encoding: [0x04,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfa,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[252:255], v1 offset:65535
// GFX10: encoding: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0xfc]

ds_read_b128 v[5:8], v255 offset:65535
// GFX10: encoding: [0xff,0xff,0xfc,0xdb,0xff,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1
// GFX10: encoding: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:0
// GFX10: encoding: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:4
// GFX10: encoding: [0x04,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535 gds
// GFX10: encoding: [0xff,0xff,0xfe,0xdb,0x01,0x00,0x00,0x05]

//===----------------------------------------------------------------------===//
// ENC_FLAT.
//===----------------------------------------------------------------------===//

flat_load_ubyte v5, v[1:2]
// GFX10: encoding: [0x00,0x00,0x20,0xdc,0x01,0x00,0x7d,0x05]

flat_load_sbyte v5, v[1:2]
// GFX10: encoding: [0x00,0x00,0x24,0xdc,0x01,0x00,0x7d,0x05]

flat_load_ushort v5, v[1:2]
// GFX10: encoding: [0x00,0x00,0x28,0xdc,0x01,0x00,0x7d,0x05]

flat_load_sshort v5, v[1:2]
// GFX10: encoding: [0x00,0x00,0x2c,0xdc,0x01,0x00,0x7d,0x05]

flat_load_dword v5, v[1:2]
// GFX10: encoding: [0x00,0x00,0x30,0xdc,0x01,0x00,0x7d,0x05]

flat_load_dwordx2 v[5:6], v[1:2]
// GFX10: encoding: [0x00,0x00,0x34,0xdc,0x01,0x00,0x7d,0x05]

flat_load_dwordx3 v[5:7], v[1:2]
// GFX10: encoding: [0x00,0x00,0x3c,0xdc,0x01,0x00,0x7d,0x05]

flat_load_dwordx4 v[5:8], v[1:2]
// GFX10: encoding: [0x00,0x00,0x38,0xdc,0x01,0x00,0x7d,0x05]

flat_store_byte v[1:2], v2
// GFX10: encoding: [0x00,0x00,0x60,0xdc,0x01,0x02,0x7d,0x00]

flat_store_short v[1:2], v2
// GFX10: encoding: [0x00,0x00,0x68,0xdc,0x01,0x02,0x7d,0x00]

flat_store_dword v[1:2], v2
// GFX10: encoding: [0x00,0x00,0x70,0xdc,0x01,0x02,0x7d,0x00]

flat_store_dwordx2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x74,0xdc,0x01,0x02,0x7d,0x00]

flat_store_dwordx3 v[1:2], v[2:4]
// GFX10: encoding: [0x00,0x00,0x7c,0xdc,0x01,0x02,0x7d,0x00]

flat_store_dwordx4 v[1:2], v[2:5]
// GFX10: encoding: [0x00,0x00,0x78,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_swap v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xc0,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_cmpswap v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0xc4,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_add v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xc8,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_sub v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xcc,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_smin v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xd4,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_umin v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xd8,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_smax v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xdc,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_umax v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xe0,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_and v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xe4,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_or v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xe8,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_xor v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xec,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_inc v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xf0,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_dec v[1:2], v2
// GFX10: encoding: [0x00,0x00,0xf4,0xdc,0x01,0x02,0x7d,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x40,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5]
// GFX10: encoding: [0x00,0x00,0x44,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_add_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x48,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x4c,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x54,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x58,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x5c,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x60,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_and_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x64,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_or_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x68,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x6c,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x70,0xdd,0x01,0x02,0x7d,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3]
// GFX10: encoding: [0x00,0x00,0x74,0xdd,0x01,0x02,0x7d,0x00]

// Also see flat-gfx10.s, flat-global.s, flat-scratch-instructions.s.

//===----------------------------------------------------------------------===//
// ENC_MUBUF.
//===----------------------------------------------------------------------===//

buffer_load_format_x v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_x v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_x v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_x v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_x v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_x v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_x v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_x v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_x v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_x v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x00,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xy v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xy v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xy v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xy v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x04,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyz v[5:7], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x08,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyzw v[5:8], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x0c,0xe0,0x00,0x05,0x42,0x03]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_x v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_x v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_x v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_x v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_x v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_x v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_x v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_x v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_x v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x10,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[254:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xy v[1:2], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xy v[1:2], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xy v[1:2], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xy v[1:2], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x14,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyz v[1:3], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x18,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyzw v[1:4], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x1c,0xe0,0x00,0x01,0x43,0x04]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ubyte v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ubyte v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ubyte v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sbyte v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sbyte v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sbyte v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ushort v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ushort v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x18,0x03]

buffer_load_ushort v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x65]

buffer_load_ushort v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ushort v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ushort v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ushort v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ushort v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ushort v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sshort v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sshort v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_sshort v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_sshort v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sshort v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sshort v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sshort v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sshort v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sshort v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0xff,0x02,0x03]

buffer_load_dword v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dword v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dword v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dword v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dword v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dword v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dword v5, off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dword v5, off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dword v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x30,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx2 v[5:6], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x34,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[253:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx3 v[5:7], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx3 v[5:7], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx3 v[5:7], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx3 v[5:7], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x3c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[252:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx4 v[5:8], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x18,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x65]

buffer_load_dwordx4 v[5:8], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx4 v[5:8], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx4 v[5:8], off, s[8:11], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x38,0xe0,0x00,0x05,0x42,0x03]

buffer_store_byte v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0xff,0x03,0x04]

buffer_store_byte v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x04,0x04]

buffer_store_byte v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x18,0x04]

buffer_store_byte v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x65]

buffer_store_byte v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_byte v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x80]

buffer_store_byte v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_byte v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_byte v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_byte v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0xff,0x03,0x04]

buffer_store_short v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x04,0x04]

buffer_store_short v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x18,0x04]

buffer_store_short v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x65]

buffer_store_short v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_short v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x80]

buffer_store_short v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_short v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_short v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_short v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v255, off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0xff,0x03,0x04]

buffer_store_dword v1, off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dword v1, off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dword v1, off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dword v1, off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dword v1, off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dword v1, off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dword v1, off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dword v1, off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dword v1, v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[254:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx2 v[1:2], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx2 v[1:2], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx2 v[1:2], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx2 v[1:2], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[253:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx3 v[1:3], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx3 v[1:3], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx3 v[1:3], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx3 v[1:3], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x7c,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[252:255], off, s[12:15], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[16:19], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx4 v[1:4], off, s[96:99], s4 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x18,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x65]

buffer_store_dwordx4 v[1:4], off, s[12:15], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx4 v[1:4], off, s[12:15], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0.5 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx4 v[1:4], off, s[12:15], -4.0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
// GFX10: encoding: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:7
// GFX10: encoding: [0x07,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 dlc
// GFX10: encoding: [0xff,0x8f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc slc dlc
// GFX10: encoding: [0xff,0xcf,0x78,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_swap v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_swap v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_swap v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_swap v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_swap v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_swap v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_swap v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xc0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_swap v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xc0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0xfe,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_cmpswap v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xc4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xc4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_add v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_add v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_add v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_add v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_add v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_add v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_add v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xc8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_add v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xc8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_sub v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_sub v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_sub v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_sub v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_sub v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_sub v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_sub v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xcc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_sub v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xcc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_smin v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_smin v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_smin v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_smin v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_smin v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_smin v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_smin v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xd4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smin v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xd4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_umin v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_umin v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_umin v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_umin v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_umin v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_umin v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_umin v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xd8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umin v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xd8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_smax v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_smax v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_smax v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_smax v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_smax v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_smax v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_smax v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xdc,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_smax v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xdc,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_umax v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_umax v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_umax v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_umax v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_umax v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_umax v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_umax v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xe0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_umax v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xe0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_and v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_and v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_and v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_and v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_and v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_and v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_and v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xe4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_and v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xe4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_or v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_or v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_or v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_or v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_or v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_or v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_or v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xe8,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_or v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xe8,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_xor v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_xor v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_xor v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_xor v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_xor v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_xor v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_xor v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xec,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_xor v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xec,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_inc v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_inc v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_inc v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_inc v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_inc v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_inc v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_inc v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xf0,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_inc v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xf0,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v255, off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0xff,0x02,0x03]

buffer_atomic_dec v5, off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x03,0x03]

buffer_atomic_dec v5, off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x18,0x03]

buffer_atomic_dec v5, off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x65]

buffer_atomic_dec v5, off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x7c]

buffer_atomic_dec v5, off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0x80]

buffer_atomic_dec v5, off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x02,0xc1]

buffer_atomic_dec v5, v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0xf4,0xe0,0x00,0x05,0x02,0x03]

buffer_atomic_dec v5, off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0xf4,0xe0,0x00,0x05,0x42,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x40,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_swap_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x40,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[252:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0xfc,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x44,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_cmpswap_x2 v[5:8], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x44,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_add_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_add_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_add_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_add_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x48,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_add_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x48,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x4c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_sub_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x4c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x54,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x54,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x58,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umin_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x58,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x5c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_smax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x5c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x60,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_umax_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x60,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_and_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_and_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_and_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_and_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x64,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_and_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x64,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_or_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_or_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_or_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_or_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x68,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_or_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x68,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x6c,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_xor_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x6c,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x70,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_inc_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x70,0xe1,0x00,0x05,0x42,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[254:255], off, s[8:11], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0xfe,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[12:15], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x03,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[96:99], s3 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x18,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s101 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x65]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], m0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x7c]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], 0 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0x80]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], -1 offset:4095
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x02,0xc1]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// GFX10: encoding: [0xff,0x2f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], v0, s[8:11], s3 offen offset:4095
// GFX10: encoding: [0xff,0x1f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3
// GFX10: encoding: [0x00,0x00,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:7
// GFX10: encoding: [0x07,0x00,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 glc
// GFX10: encoding: [0xff,0x4f,0x74,0xe1,0x00,0x05,0x02,0x03]

buffer_atomic_dec_x2 v[5:6], off, s[8:11], s3 offset:4095 slc
// GFX10: encoding: [0xff,0x0f,0x74,0xe1,0x00,0x05,0x42,0x03]

buffer_gl0_inv
// GFX10: encoding: [0x00,0x00,0xc4,0xe1,0x00,0x00,0x00,0x00]

buffer_gl1_inv
// GFX10: encoding: [0x00,0x00,0xc8,0xe1,0x00,0x00,0x00,0x00]

//===----------------------------------------------------------------------===//
// ENC_SMEM.
//===----------------------------------------------------------------------===//

s_load_dword s5, s[2:3], s0
// GFX10: encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s101, s[2:3], s0
// GFX10: encoding: [0x41,0x19,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword vcc_lo, s[2:3], s0
// GFX10: encoding: [0x81,0x1a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword vcc_hi, s[2:3], s0
// GFX10: encoding: [0xc1,0x1a,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[4:5], s0
// GFX10: encoding: [0x42,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[100:101], s0
// GFX10: encoding: [0x72,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, vcc, s0
// GFX10: encoding: [0x75,0x01,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xca]

s_load_dword s5, s[2:3], vcc_lo
// GFX10: encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xd4]

s_load_dword s5, s[2:3], vcc_hi
// GFX10: encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xd6]

s_load_dword s5, s[2:3], m0
// GFX10: encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xf8]

s_load_dword s5, s[2:3], 0x0
// GFX10: encoding: [0x41,0x01,0x00,0xf4,0x00,0x00,0x00,0xfa]

s_load_dword s5, s[2:3], s0 glc
// GFX10: encoding: [0x41,0x01,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s0 dlc
// GFX10: encoding: [0x41,0x41,0x00,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s0 glc dlc
// GFX10: encoding: [0x41,0x41,0x01,0xf4,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], 0x1234 glc dlc
// GFX10: encoding: [0x41,0x41,0x01,0xf4,0x34,0x12,0x00,0xfa]

s_load_dwordx2 s[10:11], s[2:3], s0
// GFX10: encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[12:13], s[2:3], s0
// GFX10: encoding: [0x01,0x03,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[100:101], s[2:3], s0
// GFX10: encoding: [0x01,0x19,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 vcc, s[2:3], s0
// GFX10: encoding: [0x81,0x1a,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[4:5], s0
// GFX10: encoding: [0x82,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[100:101], s0
// GFX10: encoding: [0xb2,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], vcc, s0
// GFX10: encoding: [0xb5,0x02,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s101
// GFX10: encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx2 s[10:11], s[2:3], vcc_lo
// GFX10: encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx2 s[10:11], s[2:3], vcc_hi
// GFX10: encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx2 s[10:11], s[2:3], m0
// GFX10: encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx2 s[10:11], s[2:3], 0x0
// GFX10: encoding: [0x81,0x02,0x04,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx2 s[10:11], s[2:3], s0 glc
// GFX10: encoding: [0x81,0x02,0x05,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0 dlc
// GFX10: encoding: [0x81,0x42,0x04,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], s0 glc dlc
// GFX10: encoding: [0x81,0x42,0x05,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx2 s[10:11], s[2:3], 0x1234 glc dlc
// GFX10: encoding: [0x81,0x42,0x05,0xf4,0x34,0x12,0x00,0xfa]

s_load_dwordx4 s[20:23], s[2:3], s0
// GFX10: encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[24:27], s[2:3], s0
// GFX10: encoding: [0x01,0x06,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[96:99], s[2:3], s0
// GFX10: encoding: [0x01,0x18,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[4:5], s0
// GFX10: encoding: [0x02,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[100:101], s0
// GFX10: encoding: [0x32,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], vcc, s0
// GFX10: encoding: [0x35,0x05,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s101
// GFX10: encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx4 s[20:23], s[2:3], vcc_lo
// GFX10: encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx4 s[20:23], s[2:3], vcc_hi
// GFX10: encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx4 s[20:23], s[2:3], m0
// GFX10: encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx4 s[20:23], s[2:3], 0x0
// GFX10: encoding: [0x01,0x05,0x08,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx4 s[20:23], s[2:3], s0 glc
// GFX10: encoding: [0x01,0x05,0x09,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0 dlc
// GFX10: encoding: [0x01,0x45,0x08,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], s0 glc dlc
// GFX10: encoding: [0x01,0x45,0x09,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx4 s[20:23], s[2:3], 0x1234 glc dlc
// GFX10: encoding: [0x01,0x45,0x09,0xf4,0x34,0x12,0x00,0xfa]

s_load_dwordx8 s[20:27], s[2:3], s0
// GFX10: encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[24:31], s[2:3], s0
// GFX10: encoding: [0x01,0x06,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[92:99], s[2:3], s0
// GFX10: encoding: [0x01,0x17,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[4:5], s0
// GFX10: encoding: [0x02,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[100:101], s0
// GFX10: encoding: [0x32,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], vcc, s0
// GFX10: encoding: [0x35,0x05,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s101
// GFX10: encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx8 s[20:27], s[2:3], vcc_lo
// GFX10: encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx8 s[20:27], s[2:3], vcc_hi
// GFX10: encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx8 s[20:27], s[2:3], m0
// GFX10: encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx8 s[20:27], s[2:3], 0x0
// GFX10: encoding: [0x01,0x05,0x0c,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx8 s[20:27], s[2:3], s0 glc
// GFX10: encoding: [0x01,0x05,0x0d,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0 dlc
// GFX10: encoding: [0x01,0x45,0x0c,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], s0 glc dlc
// GFX10: encoding: [0x01,0x45,0x0d,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx8 s[20:27], s[2:3], 0x1234 glc dlc
// GFX10: encoding: [0x01,0x45,0x0d,0xf4,0x34,0x12,0x00,0xfa]

s_load_dwordx16 s[20:35], s[2:3], s0
// GFX10: encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[24:39], s[2:3], s0
// GFX10: encoding: [0x01,0x06,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[84:99], s[2:3], s0
// GFX10: encoding: [0x01,0x15,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[4:5], s0
// GFX10: encoding: [0x02,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[100:101], s0
// GFX10: encoding: [0x32,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], vcc, s0
// GFX10: encoding: [0x35,0x05,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s101
// GFX10: encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xca]

s_load_dwordx16 s[20:35], s[2:3], vcc_lo
// GFX10: encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xd4]

s_load_dwordx16 s[20:35], s[2:3], vcc_hi
// GFX10: encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xd6]

s_load_dwordx16 s[20:35], s[2:3], m0
// GFX10: encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xf8]

s_load_dwordx16 s[20:35], s[2:3], 0x0
// GFX10: encoding: [0x01,0x05,0x10,0xf4,0x00,0x00,0x00,0xfa]

s_load_dwordx16 s[20:35], s[2:3], s0 glc
// GFX10: encoding: [0x01,0x05,0x11,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0 dlc
// GFX10: encoding: [0x01,0x45,0x10,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], s0 glc dlc
// GFX10: encoding: [0x01,0x45,0x11,0xf4,0x00,0x00,0x00,0x00]

s_load_dwordx16 s[20:35], s[2:3], 0x1234 glc dlc
// GFX10: encoding: [0x01,0x45,0x11,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_load_dword s5, s[4:7], s0
// GFX10: encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s101, s[4:7], s0
// GFX10: encoding: [0x42,0x19,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword vcc_lo, s[4:7], s0
// GFX10: encoding: [0x82,0x1a,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword vcc_hi, s[4:7], s0
// GFX10: encoding: [0xc2,0x1a,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[8:11], s0
// GFX10: encoding: [0x44,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[96:99], s0
// GFX10: encoding: [0x70,0x01,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s101
// GFX10: encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dword s5, s[4:7], vcc_lo
// GFX10: encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dword s5, s[4:7], vcc_hi
// GFX10: encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dword s5, s[4:7], m0
// GFX10: encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dword s5, s[4:7], 0x0
// GFX10: encoding: [0x42,0x01,0x20,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dword s5, s[4:7], s0 glc
// GFX10: encoding: [0x42,0x01,0x21,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s0 dlc
// GFX10: encoding: [0x42,0x41,0x20,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], s0 glc dlc
// GFX10: encoding: [0x42,0x41,0x21,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dword s5, s[4:7], 0x1234 glc dlc
// GFX10: encoding: [0x42,0x41,0x21,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0
// GFX10: encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[12:13], s[4:7], s0
// GFX10: encoding: [0x02,0x03,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[100:101], s[4:7], s0
// GFX10: encoding: [0x02,0x19,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 vcc, s[4:7], s0
// GFX10: encoding: [0x82,0x1a,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[8:11], s0
// GFX10: encoding: [0x84,0x02,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[96:99], s0
// GFX10: encoding: [0xb0,0x02,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s101
// GFX10: encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_lo
// GFX10: encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_hi
// GFX10: encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx2 s[10:11], s[4:7], m0
// GFX10: encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x0
// GFX10: encoding: [0x82,0x02,0x24,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 glc
// GFX10: encoding: [0x82,0x02,0x25,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 dlc
// GFX10: encoding: [0x82,0x42,0x24,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], s0 glc dlc
// GFX10: encoding: [0x82,0x42,0x25,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x1234 glc dlc
// GFX10: encoding: [0x82,0x42,0x25,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0
// GFX10: encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[24:27], s[4:7], s0
// GFX10: encoding: [0x02,0x06,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[96:99], s[4:7], s0
// GFX10: encoding: [0x02,0x18,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[8:11], s0
// GFX10: encoding: [0x04,0x05,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[96:99], s0
// GFX10: encoding: [0x30,0x05,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s101
// GFX10: encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_lo
// GFX10: encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_hi
// GFX10: encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx4 s[20:23], s[4:7], m0
// GFX10: encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x0
// GFX10: encoding: [0x02,0x05,0x28,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 glc
// GFX10: encoding: [0x02,0x05,0x29,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 dlc
// GFX10: encoding: [0x02,0x45,0x28,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], s0 glc dlc
// GFX10: encoding: [0x02,0x45,0x29,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x1234 glc dlc
// GFX10: encoding: [0x02,0x45,0x29,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0
// GFX10: encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[24:31], s[4:7], s0
// GFX10: encoding: [0x02,0x06,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[92:99], s[4:7], s0
// GFX10: encoding: [0x02,0x17,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[8:11], s0
// GFX10: encoding: [0x04,0x05,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[96:99], s0
// GFX10: encoding: [0x30,0x05,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s101
// GFX10: encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_lo
// GFX10: encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_hi
// GFX10: encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx8 s[20:27], s[4:7], m0
// GFX10: encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x0
// GFX10: encoding: [0x02,0x05,0x2c,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 glc
// GFX10: encoding: [0x02,0x05,0x2d,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 dlc
// GFX10: encoding: [0x02,0x45,0x2c,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], s0 glc dlc
// GFX10: encoding: [0x02,0x45,0x2d,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x1234 glc dlc
// GFX10: encoding: [0x02,0x45,0x2d,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0
// GFX10: encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[24:39], s[4:7], s0
// GFX10: encoding: [0x02,0x06,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[84:99], s[4:7], s0
// GFX10: encoding: [0x02,0x15,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[8:11], s0
// GFX10: encoding: [0x04,0x05,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[96:99], s0
// GFX10: encoding: [0x30,0x05,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s101
// GFX10: encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xca]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_lo
// GFX10: encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_hi
// GFX10: encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_load_dwordx16 s[20:35], s[4:7], m0
// GFX10: encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x0
// GFX10: encoding: [0x02,0x05,0x30,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 glc
// GFX10: encoding: [0x02,0x05,0x31,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 dlc
// GFX10: encoding: [0x02,0x45,0x30,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], s0 glc dlc
// GFX10: encoding: [0x02,0x45,0x31,0xf4,0x00,0x00,0x00,0x00]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x1234 glc dlc
// GFX10: encoding: [0x02,0x45,0x31,0xf4,0x34,0x12,0x00,0xfa]

s_store_dword s1, s[4:5], s0
// GFX10: encoding: [0x42,0x00,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s101, s[4:5], s0
// GFX10: encoding: [0x42,0x19,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword vcc_lo, s[4:5], s0
// GFX10: encoding: [0x82,0x1a,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword vcc_hi, s[4:5], s0
// GFX10: encoding: [0xc2,0x1a,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, s[6:7], s0
// GFX10: encoding: [0x43,0x00,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, s[100:101], s0
// GFX10: encoding: [0x72,0x00,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, vcc, s0
// GFX10: encoding: [0x75,0x00,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], s101
// GFX10: encoding: [0x42,0x00,0x40,0xf4,0x00,0x00,0x00,0xca]

s_store_dword s1, s[4:5], vcc_lo
// GFX10: encoding: [0x42,0x00,0x40,0xf4,0x00,0x00,0x00,0xd4]

s_store_dword s1, s[4:5], vcc_hi
// GFX10: encoding: [0x42,0x00,0x40,0xf4,0x00,0x00,0x00,0xd6]

s_store_dword s1, s[4:5], m0
// GFX10: encoding: [0x42,0x00,0x40,0xf4,0x00,0x00,0x00,0xf8]

s_store_dword s1, s[4:5], 0x0
// GFX10: encoding: [0x42,0x00,0x40,0xf4,0x00,0x00,0x00,0xfa]

s_store_dword s1, s[4:5], s0 glc
// GFX10: encoding: [0x42,0x00,0x41,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], s0 dlc
// GFX10: encoding: [0x42,0x40,0x40,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], s0 glc dlc
// GFX10: encoding: [0x42,0x40,0x41,0xf4,0x00,0x00,0x00,0x00]

s_store_dword s1, s[4:5], 0x1234 glc dlc
// GFX10: encoding: [0x42,0x40,0x41,0xf4,0x34,0x12,0x00,0xfa]

s_store_dwordx2 s[2:3], s[4:5], s0
// GFX10: encoding: [0x82,0x00,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[4:5], s[4:5], s0
// GFX10: encoding: [0x02,0x01,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[100:101], s[4:5], s0
// GFX10: encoding: [0x02,0x19,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 vcc, s[4:5], s0
// GFX10: encoding: [0x82,0x1a,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[6:7], s0
// GFX10: encoding: [0x83,0x00,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[100:101], s0
// GFX10: encoding: [0xb2,0x00,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], vcc, s0
// GFX10: encoding: [0xb5,0x00,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], s101
// GFX10: encoding: [0x82,0x00,0x44,0xf4,0x00,0x00,0x00,0xca]

s_store_dwordx2 s[2:3], s[4:5], vcc_lo
// GFX10: encoding: [0x82,0x00,0x44,0xf4,0x00,0x00,0x00,0xd4]

s_store_dwordx2 s[2:3], s[4:5], vcc_hi
// GFX10: encoding: [0x82,0x00,0x44,0xf4,0x00,0x00,0x00,0xd6]

s_store_dwordx2 s[2:3], s[4:5], m0
// GFX10: encoding: [0x82,0x00,0x44,0xf4,0x00,0x00,0x00,0xf8]

s_store_dwordx2 s[2:3], s[4:5], 0x0
// GFX10: encoding: [0x82,0x00,0x44,0xf4,0x00,0x00,0x00,0xfa]

s_store_dwordx2 s[2:3], s[4:5], s0 glc
// GFX10: encoding: [0x82,0x00,0x45,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], s0 dlc
// GFX10: encoding: [0x82,0x40,0x44,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], s0 glc dlc
// GFX10: encoding: [0x82,0x40,0x45,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx2 s[2:3], s[4:5], 0x1234 glc dlc
// GFX10: encoding: [0x82,0x40,0x45,0xf4,0x34,0x12,0x00,0xfa]

s_store_dwordx4 s[4:7], s[4:5], s0
// GFX10: encoding: [0x02,0x01,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[8:11], s[4:5], s0
// GFX10: encoding: [0x02,0x02,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[96:99], s[4:5], s0
// GFX10: encoding: [0x02,0x18,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[6:7], s0
// GFX10: encoding: [0x03,0x01,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[100:101], s0
// GFX10: encoding: [0x32,0x01,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], vcc, s0
// GFX10: encoding: [0x35,0x01,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], s101
// GFX10: encoding: [0x02,0x01,0x48,0xf4,0x00,0x00,0x00,0xca]

s_store_dwordx4 s[4:7], s[4:5], vcc_lo
// GFX10: encoding: [0x02,0x01,0x48,0xf4,0x00,0x00,0x00,0xd4]

s_store_dwordx4 s[4:7], s[4:5], vcc_hi
// GFX10: encoding: [0x02,0x01,0x48,0xf4,0x00,0x00,0x00,0xd6]

s_store_dwordx4 s[4:7], s[4:5], m0
// GFX10: encoding: [0x02,0x01,0x48,0xf4,0x00,0x00,0x00,0xf8]

s_store_dwordx4 s[4:7], s[4:5], 0x0
// GFX10: encoding: [0x02,0x01,0x48,0xf4,0x00,0x00,0x00,0xfa]

s_store_dwordx4 s[4:7], s[4:5], s0 glc
// GFX10: encoding: [0x02,0x01,0x49,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], s0 dlc
// GFX10: encoding: [0x02,0x41,0x48,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], s0 glc dlc
// GFX10: encoding: [0x02,0x41,0x49,0xf4,0x00,0x00,0x00,0x00]

s_store_dwordx4 s[4:7], s[4:5], 0x1234 glc dlc
// GFX10: encoding: [0x02,0x41,0x49,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_store_dword s1, s[8:11], s0
// GFX10: encoding: [0x44,0x00,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s101, s[8:11], s0
// GFX10: encoding: [0x44,0x19,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword vcc_lo, s[8:11], s0
// GFX10: encoding: [0x84,0x1a,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword vcc_hi, s[8:11], s0
// GFX10: encoding: [0xc4,0x1a,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[12:15], s0
// GFX10: encoding: [0x46,0x00,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[96:99], s0
// GFX10: encoding: [0x70,0x00,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], s101
// GFX10: encoding: [0x44,0x00,0x60,0xf4,0x00,0x00,0x00,0xca]

s_buffer_store_dword s1, s[8:11], vcc_lo
// GFX10: encoding: [0x44,0x00,0x60,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_store_dword s1, s[8:11], vcc_hi
// GFX10: encoding: [0x44,0x00,0x60,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_store_dword s1, s[8:11], m0
// GFX10: encoding: [0x44,0x00,0x60,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_store_dword s1, s[8:11], 0x0
// GFX10: encoding: [0x44,0x00,0x60,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_store_dword s1, s[8:11], s0 glc
// GFX10: encoding: [0x44,0x00,0x61,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], s0 dlc
// GFX10: encoding: [0x44,0x40,0x60,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], s0 glc dlc
// GFX10: encoding: [0x44,0x40,0x61,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dword s1, s[8:11], 0x1234 glc dlc
// GFX10: encoding: [0x44,0x40,0x61,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_store_dwordx2 s[2:3], s[8:11], s0
// GFX10: encoding: [0x84,0x00,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[4:5], s[8:11], s0
// GFX10: encoding: [0x04,0x01,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[100:101], s[8:11], s0
// GFX10: encoding: [0x04,0x19,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 vcc, s[8:11], s0
// GFX10: encoding: [0x84,0x1a,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[12:15], s0
// GFX10: encoding: [0x86,0x00,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[96:99], s0
// GFX10: encoding: [0xb0,0x00,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], s101
// GFX10: encoding: [0x84,0x00,0x64,0xf4,0x00,0x00,0x00,0xca]

s_buffer_store_dwordx2 s[2:3], s[8:11], vcc_lo
// GFX10: encoding: [0x84,0x00,0x64,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_store_dwordx2 s[2:3], s[8:11], vcc_hi
// GFX10: encoding: [0x84,0x00,0x64,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_store_dwordx2 s[2:3], s[8:11], m0
// GFX10: encoding: [0x84,0x00,0x64,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_store_dwordx2 s[2:3], s[8:11], 0x0
// GFX10: encoding: [0x84,0x00,0x64,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_store_dwordx2 s[2:3], s[8:11], s0 glc
// GFX10: encoding: [0x84,0x00,0x65,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], s0 dlc
// GFX10: encoding: [0x84,0x40,0x64,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], s0 glc dlc
// GFX10: encoding: [0x84,0x40,0x65,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx2 s[2:3], s[8:11], 0x1234 glc dlc
// GFX10: encoding: [0x84,0x40,0x65,0xf4,0x34,0x12,0x00,0xfa]

s_buffer_store_dwordx4 s[4:7], s[8:11], s0
// GFX10: encoding: [0x04,0x01,0x68,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[8:11], s[8:11], s0
// GFX10: encoding: [0x04,0x02,0x68,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[96:99], s[8:11], s0
// GFX10: encoding: [0x04,0x18,0x68,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[12:15], s0
// GFX10: encoding: [0x06,0x01,0x68,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[96:99], s0
// GFX10: encoding: [0x30,0x01,0x68,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], s101
// GFX10: encoding: [0x04,0x01,0x68,0xf4,0x00,0x00,0x00,0xca]

s_buffer_store_dwordx4 s[4:7], s[8:11], vcc_lo
// GFX10: encoding: [0x04,0x01,0x68,0xf4,0x00,0x00,0x00,0xd4]

s_buffer_store_dwordx4 s[4:7], s[8:11], vcc_hi
// GFX10: encoding: [0x04,0x01,0x68,0xf4,0x00,0x00,0x00,0xd6]

s_buffer_store_dwordx4 s[4:7], s[8:11], m0
// GFX10: encoding: [0x04,0x01,0x68,0xf4,0x00,0x00,0x00,0xf8]

s_buffer_store_dwordx4 s[4:7], s[8:11], 0x0
// GFX10: encoding: [0x04,0x01,0x68,0xf4,0x00,0x00,0x00,0xfa]

s_buffer_store_dwordx4 s[4:7], s[8:11], s0 glc
// GFX10: encoding: [0x04,0x01,0x69,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], s0 dlc
// GFX10: encoding: [0x04,0x41,0x68,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], s0 glc dlc
// GFX10: encoding: [0x04,0x41,0x69,0xf4,0x00,0x00,0x00,0x00]

s_buffer_store_dwordx4 s[4:7], s[8:11], 0x1234 glc dlc
// GFX10: encoding: [0x04,0x41,0x69,0xf4,0x34,0x12,0x00,0xfa]

s_memrealtime s[10:11]
// GFX10: encoding: [0x80,0x02,0x94,0xf4,0x00,0x00,0x00,0x00]

s_memrealtime s[12:13]
// GFX10: encoding: [0x00,0x03,0x94,0xf4,0x00,0x00,0x00,0x00]

s_memrealtime s[100:101]
// GFX10: encoding: [0x00,0x19,0x94,0xf4,0x00,0x00,0x00,0x00]

s_memrealtime vcc
// GFX10: encoding: [0x80,0x1a,0x94,0xf4,0x00,0x00,0x00,0x00]

s_memtime s[10:11]
// GFX10: encoding: [0x80,0x02,0x90,0xf4,0x00,0x00,0x00,0x00]

s_memtime s[12:13]
// GFX10: encoding: [0x00,0x03,0x90,0xf4,0x00,0x00,0x00,0x00]

s_memtime s[100:101]
// GFX10: encoding: [0x00,0x19,0x90,0xf4,0x00,0x00,0x00,0x00]

s_memtime vcc
// GFX10: encoding: [0x80,0x1a,0x90,0xf4,0x00,0x00,0x00,0x00]

s_dcache_inv
// GFX10: encoding: [0x00,0x00,0x80,0xf4,0x00,0x00,0x00,0x00]

s_gl1_inv
// GFX10: encoding: [0x00,0x00,0x7c,0xf4,0x00,0x00,0x00,0x00]

s_dcache_wb
// GFX10: encoding: [0x00,0x00,0x84,0xf4,0x00,0x00,0x00,0x00]

s_get_waveid_in_workgroup s0
// GFX10: encoding: [0x00,0x00,0xa8,0xf4,0x00,0x00,0x00,0x00]

s_get_waveid_in_workgroup vcc_lo
// GFX10: encoding: [0x80,0x1a,0xa8,0xf4,0x00,0x00,0x00,0x00]

s_scratch_load_dword s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x14,0xf4,0x00,0x00,0x00,0xca]

s_scratch_load_dword s5, s[2:3], s0 glc
// GFX10: encoding: [0x41,0x01,0x15,0xf4,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[100:101], s[2:3], s0
// GFX10: encoding: [0x01,0x19,0x18,0xf4,0x00,0x00,0x00,0x00]

s_scratch_load_dwordx2 s[10:11], s[2:3], 0x1 glc
// GFX10: encoding: [0x81,0x02,0x19,0xf4,0x01,0x00,0x00,0xfa]

s_scratch_load_dwordx4 s[20:23], s[4:5], s0
// GFX10: encoding: [0x02,0x05,0x1c,0xf4,0x00,0x00,0x00,0x00]

s_scratch_store_dword s101, s[4:5], s0
// GFX10: encoding: [0x42,0x19,0x54,0xf4,0x00,0x00,0x00,0x00]

s_scratch_store_dword s1, s[4:5], 0x123 glc
// GFX10: encoding: [0x42,0x00,0x55,0xf4,0x23,0x01,0x00,0xfa]

s_scratch_store_dwordx2 s[2:3], s[4:5], s101 glc
// GFX10: encoding: [0x82,0x00,0x59,0xf4,0x00,0x00,0x00,0xca]

s_scratch_store_dwordx4 s[4:7], s[4:5], s0 glc
// GFX10: encoding: [0x02,0x01,0x5d,0xf4,0x00,0x00,0x00,0x00]

s_atc_probe 0x7, s[4:5], s2
// GFX10: s_atc_probe 7, s[4:5], s2 ; encoding: [0xc2,0x01,0x98,0xf4,0x00,0x00,0x00,0x04]

s_atc_probe 0x7, s[4:5], 100
// GFX10: s_atc_probe 7, s[4:5], 0x64 ; encoding: [0xc2,0x01,0x98,0xf4,0x64,0x00,0x00,0xfa]

s_atc_probe_buffer 0x7, s[8:11], s2
// GFX10: s_atc_probe_buffer 7, s[8:11], s2 ; encoding: [0xc4,0x01,0x9c,0xf4,0x00,0x00,0x00,0x04]

s_atc_probe_buffer 0x7, s[8:11], 100
// GFX10: s_atc_probe_buffer 7, s[8:11], 0x64 ; encoding: [0xc4,0x01,0x9c,0xf4,0x64,0x00,0x00,0xfa]

s_dcache_discard s[2:3], s2
// GFX10: s_dcache_discard s[2:3], s2 ; encoding: [0x01,0x00,0xa0,0xf4,0x00,0x00,0x00,0x04]

s_dcache_discard s[2:3], 100
// GFX10: s_dcache_discard s[2:3], 0x64 ; encoding: [0x01,0x00,0xa0,0xf4,0x64,0x00,0x00,0xfa]

s_dcache_discard_x2 s[2:3], s2
// GFX10: s_dcache_discard_x2 s[2:3], s2 ; encoding: [0x01,0x00,0xa4,0xf4,0x00,0x00,0x00,0x04]

s_dcache_discard_x2 s[2:3], 100
// GFX10: s_dcache_discard_x2 s[2:3], 0x64 ; encoding: [0x01,0x00,0xa4,0xf4,0x64,0x00,0x00,0xfa]

s_atomic_add s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x08,0xf6,0x00,0x00,0x00,0xca]

s_atomic_add s5, s[2:3], 0x64
// GFX10: encoding: [0x41,0x01,0x08,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_add_x2 s[10:11], s[2:3], s101
// GFX10: encoding: [0x81,0x02,0x88,0xf6,0x00,0x00,0x00,0xca]

s_atomic_and s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x20,0xf6,0x00,0x00,0x00,0xca]

s_atomic_and_x2 s[10:11], s[2:3], 0x64
// GFX10: encoding: [0x81,0x02,0xa0,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_cmpswap s[10:11], s[2:3], s101
// GFX10: encoding: [0x81,0x02,0x04,0xf6,0x00,0x00,0x00,0xca]

s_atomic_cmpswap s[10:11], s[2:3], 0x64
// GFX10: encoding: [0x81,0x02,0x04,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_cmpswap_x2 s[20:23], s[2:3], s101
// GFX10: encoding: [0x01,0x05,0x84,0xf6,0x00,0x00,0x00,0xca]

s_atomic_cmpswap_x2 s[20:23], s[2:3], 0x64
// GFX10: encoding: [0x01,0x05,0x84,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_dec_x2 s[10:11], s[2:3], s101
// GFX10: encoding: [0x81,0x02,0xb0,0xf6,0x00,0x00,0x00,0xca]

s_atomic_inc_x2 s[10:11], s[2:3], s101
// GFX10: encoding: [0x81,0x02,0xac,0xf6,0x00,0x00,0x00,0xca]

s_atomic_or s5, s[2:3], 0x64
// GFX10: encoding: [0x41,0x01,0x24,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_smax s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x18,0xf6,0x00,0x00,0x00,0xca]

s_atomic_smin s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x10,0xf6,0x00,0x00,0x00,0xca]

s_atomic_sub s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x0c,0xf6,0x00,0x00,0x00,0xca]

s_atomic_swap s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x00,0xf6,0x00,0x00,0x00,0xca]

s_atomic_umax_x2 s[10:11], s[2:3], s101
// GFX10: encoding: [0x81,0x02,0x9c,0xf6,0x00,0x00,0x00,0xca]

s_atomic_umin s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x14,0xf6,0x00,0x00,0x00,0xca]

s_atomic_xor s5, s[2:3], s101
// GFX10: encoding: [0x41,0x01,0x28,0xf6,0x00,0x00,0x00,0xca]

s_buffer_atomic_add s5, s[4:7], s101
// GFX10: encoding: [0x42,0x01,0x08,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_add s5, s[4:7], 0x64
// GFX10: encoding: [0x42,0x01,0x08,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_add_x2 s[10:11], s[4:7], s2
// GFX10: encoding: [0x82,0x02,0x88,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_and s101, s[4:7], s2
// GFX10: encoding: [0x42,0x19,0x20,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_and_x2 s[10:11], s[8:11], s2
// GFX10: encoding: [0x84,0x02,0xa0,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_cmpswap s[10:11], s[4:7], s2
// GFX10: encoding: [0x82,0x02,0x04,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_cmpswap s[10:11], s[4:7], 0x64
// GFX10: encoding: [0x82,0x02,0x04,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], s101
// GFX10: encoding: [0x02,0x05,0x84,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], 0x64
// GFX10: encoding: [0x02,0x05,0x84,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_dec s5, s[4:7], s2
// GFX10: encoding: [0x42,0x01,0x30,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_inc s101, s[4:7], s2
// GFX10: encoding: [0x42,0x19,0x2c,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], 0x64
// GFX10: encoding: [0x82,0x02,0xac,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_or s5, s[8:11], s2
// GFX10: encoding: [0x44,0x01,0x24,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_or_x2 s[10:11], s[96:99], s2
// GFX10: encoding: [0xb0,0x02,0xa4,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_smax s5, s[4:7], s101
// GFX10: encoding: [0x42,0x01,0x18,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_smax_x2 s[100:101], s[4:7], s2
// GFX10: encoding: [0x02,0x19,0x98,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_smin s5, s[4:7], 0x64
// GFX10: encoding: [0x42,0x01,0x10,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_smin_x2 s[12:13], s[4:7], s2
// GFX10: encoding: [0x02,0x03,0x90,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], s2
// GFX10: encoding: [0x82,0x02,0x8c,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_swap s5, s[4:7], s2
// GFX10: encoding: [0x42,0x01,0x00,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_umax s5, s[4:7], s2
// GFX10: encoding: [0x42,0x01,0x1c,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_umin s5, s[4:7], s2
// GFX10: encoding: [0x42,0x01,0x14,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_xor s5, s[4:7], s2
// GFX10: encoding: [0x42,0x01,0x28,0xf5,0x00,0x00,0x00,0x04]

s_atomic_add s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x09,0xf6,0x00,0x00,0x00,0xca]

s_atomic_add s5, s[2:3], 0x64 glc
// GFX10: encoding: [0x41,0x01,0x09,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_add_x2 s[10:11], s[2:3], s101 glc
// GFX10: encoding: [0x81,0x02,0x89,0xf6,0x00,0x00,0x00,0xca]

s_atomic_and s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x21,0xf6,0x00,0x00,0x00,0xca]

s_atomic_and_x2 s[10:11], s[2:3], 0x64 glc
// GFX10: encoding: [0x81,0x02,0xa1,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_cmpswap s[10:11], s[2:3], s101 glc
// GFX10: encoding: [0x81,0x02,0x05,0xf6,0x00,0x00,0x00,0xca]

s_atomic_cmpswap s[10:11], s[2:3], 0x64 glc
// GFX10: encoding: [0x81,0x02,0x05,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_cmpswap_x2 s[20:23], s[2:3], s101 glc
// GFX10: encoding: [0x01,0x05,0x85,0xf6,0x00,0x00,0x00,0xca]

s_atomic_cmpswap_x2 s[20:23], s[2:3], 0x64 glc
// GFX10: encoding: [0x01,0x05,0x85,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_dec_x2 s[10:11], s[2:3], s101 glc
// GFX10: encoding: [0x81,0x02,0xb1,0xf6,0x00,0x00,0x00,0xca]

s_atomic_inc_x2 s[10:11], s[2:3], s101 glc
// GFX10: encoding: [0x81,0x02,0xad,0xf6,0x00,0x00,0x00,0xca]

s_atomic_or s5, s[2:3], 0x64 glc
// GFX10: encoding: [0x41,0x01,0x25,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_smax s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x19,0xf6,0x00,0x00,0x00,0xca]

s_atomic_smin s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x11,0xf6,0x00,0x00,0x00,0xca]

s_atomic_sub s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x0d,0xf6,0x00,0x00,0x00,0xca]

s_atomic_swap s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x01,0xf6,0x00,0x00,0x00,0xca]

s_atomic_umax_x2 s[10:11], s[2:3], s101 glc
// GFX10: encoding: [0x81,0x02,0x9d,0xf6,0x00,0x00,0x00,0xca]

s_atomic_umin s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x15,0xf6,0x00,0x00,0x00,0xca]

s_atomic_xor s5, s[2:3], s101 glc
// GFX10: encoding: [0x41,0x01,0x29,0xf6,0x00,0x00,0x00,0xca]

s_buffer_atomic_add s5, s[4:7], s101 glc
// GFX10: encoding: [0x42,0x01,0x09,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_add s5, s[4:7], 0x64 glc
// GFX10: encoding: [0x42,0x01,0x09,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_add_x2 s[10:11], s[4:7], s2 glc
// GFX10: encoding: [0x82,0x02,0x89,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_and s101, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x19,0x21,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_and_x2 s[10:11], s[8:11], s2 glc
// GFX10: encoding: [0x84,0x02,0xa1,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_cmpswap s[10:11], s[4:7], s2 glc
// GFX10: encoding: [0x82,0x02,0x05,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_cmpswap s[10:11], s[4:7], 0x64 glc
// GFX10: encoding: [0x82,0x02,0x05,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], s101 glc
// GFX10: encoding: [0x02,0x05,0x85,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], 0x64 glc
// GFX10: encoding: [0x02,0x05,0x85,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_dec s5, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x01,0x31,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_inc s101, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x19,0x2d,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], 0x64 glc
// GFX10: encoding: [0x82,0x02,0xad,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_or s5, s[8:11], s2 glc
// GFX10: encoding: [0x44,0x01,0x25,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_or_x2 s[10:11], s[96:99], s2 glc
// GFX10: encoding: [0xb0,0x02,0xa5,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_smax s5, s[4:7], s101 glc
// GFX10: encoding: [0x42,0x01,0x19,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_smax_x2 s[100:101], s[4:7], s2 glc
// GFX10: encoding: [0x02,0x19,0x99,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_smin s5, s[4:7], 0x64 glc
// GFX10: encoding: [0x42,0x01,0x11,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_smin_x2 s[12:13], s[4:7], s2 glc
// GFX10: encoding: [0x02,0x03,0x91,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], s2 glc
// GFX10: encoding: [0x82,0x02,0x8d,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_swap s5, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x01,0x01,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_umax s5, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x01,0x1d,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_umin s5, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x01,0x15,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_xor s5, s[4:7], s2 glc
// GFX10: encoding: [0x42,0x01,0x29,0xf5,0x00,0x00,0x00,0x04]

s_atomic_add s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x08,0xf6,0x00,0x00,0x00,0xca]

s_atomic_add s5, s[2:3], 0x64 dlc
// GFX10: encoding: [0x41,0x41,0x08,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_add_x2 s[10:11], s[2:3], s101 dlc
// GFX10: encoding: [0x81,0x42,0x88,0xf6,0x00,0x00,0x00,0xca]

s_atomic_and s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x20,0xf6,0x00,0x00,0x00,0xca]

s_atomic_and_x2 s[10:11], s[2:3], 0x64 dlc
// GFX10: encoding: [0x81,0x42,0xa0,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_cmpswap s[10:11], s[2:3], s101 dlc
// GFX10: encoding: [0x81,0x42,0x04,0xf6,0x00,0x00,0x00,0xca]

s_atomic_cmpswap s[10:11], s[2:3], 0x64 dlc
// GFX10: encoding: [0x81,0x42,0x04,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_cmpswap_x2 s[20:23], s[2:3], s101 dlc
// GFX10: encoding: [0x01,0x45,0x84,0xf6,0x00,0x00,0x00,0xca]

s_atomic_cmpswap_x2 s[20:23], s[2:3], 0x64 dlc
// GFX10: encoding: [0x01,0x45,0x84,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_dec_x2 s[10:11], s[2:3], s101 dlc
// GFX10: encoding: [0x81,0x42,0xb0,0xf6,0x00,0x00,0x00,0xca]

s_atomic_inc_x2 s[10:11], s[2:3], s101 dlc
// GFX10: encoding: [0x81,0x42,0xac,0xf6,0x00,0x00,0x00,0xca]

s_atomic_or s5, s[2:3], 0x64 dlc
// GFX10: encoding: [0x41,0x41,0x24,0xf6,0x64,0x00,0x00,0xfa]

s_atomic_smax s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x18,0xf6,0x00,0x00,0x00,0xca]

s_atomic_smin s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x10,0xf6,0x00,0x00,0x00,0xca]

s_atomic_sub s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x0c,0xf6,0x00,0x00,0x00,0xca]

s_atomic_swap s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x00,0xf6,0x00,0x00,0x00,0xca]

s_atomic_umax_x2 s[10:11], s[2:3], s101 dlc
// GFX10: encoding: [0x81,0x42,0x9c,0xf6,0x00,0x00,0x00,0xca]

s_atomic_umin s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x14,0xf6,0x00,0x00,0x00,0xca]

s_atomic_xor s5, s[2:3], s101 dlc
// GFX10: encoding: [0x41,0x41,0x28,0xf6,0x00,0x00,0x00,0xca]

s_buffer_atomic_add s5, s[4:7], s101 dlc
// GFX10: encoding: [0x42,0x41,0x08,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_add s5, s[4:7], 0x64 dlc
// GFX10: encoding: [0x42,0x41,0x08,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_add_x2 s[10:11], s[4:7], s2 dlc
// GFX10: encoding: [0x82,0x42,0x88,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_and s101, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x59,0x20,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_and_x2 s[10:11], s[8:11], s2 dlc
// GFX10: encoding: [0x84,0x42,0xa0,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_cmpswap s[10:11], s[4:7], s2 dlc
// GFX10: encoding: [0x82,0x42,0x04,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_cmpswap s[10:11], s[4:7], 0x64 dlc
// GFX10: encoding: [0x82,0x42,0x04,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], s101 dlc
// GFX10: encoding: [0x02,0x45,0x84,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_cmpswap_x2 s[20:23], s[4:7], 0x64 dlc
// GFX10: encoding: [0x02,0x45,0x84,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_dec s5, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x41,0x30,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_inc s101, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x59,0x2c,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_inc_x2 s[10:11], s[4:7], 0x64 dlc
// GFX10: encoding: [0x82,0x42,0xac,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_or s5, s[8:11], s2 dlc
// GFX10: encoding: [0x44,0x41,0x24,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_or_x2 s[10:11], s[96:99], s2 dlc
// GFX10: encoding: [0xb0,0x42,0xa4,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_smax s5, s[4:7], s101 dlc
// GFX10: encoding: [0x42,0x41,0x18,0xf5,0x00,0x00,0x00,0xca]

s_buffer_atomic_smax_x2 s[100:101], s[4:7], s2 dlc
// GFX10: encoding: [0x02,0x59,0x98,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_smin s5, s[4:7], 0x64 dlc
// GFX10: encoding: [0x42,0x41,0x10,0xf5,0x64,0x00,0x00,0xfa]

s_buffer_atomic_smin_x2 s[12:13], s[4:7], s2 dlc
// GFX10: encoding: [0x02,0x43,0x90,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_sub_x2 s[10:11], s[4:7], s2 dlc
// GFX10: encoding: [0x82,0x42,0x8c,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_swap s5, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x41,0x00,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_umax s5, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x41,0x1c,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_umin s5, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x41,0x14,0xf5,0x00,0x00,0x00,0x04]

s_buffer_atomic_xor s5, s[4:7], s2 dlc
// GFX10: encoding: [0x42,0x41,0x28,0xf5,0x00,0x00,0x00,0x04]

//===----------------------------------------------------------------------===//
// ENC_SOP1.
//===----------------------------------------------------------------------===//

s_mov_b32 s0, s1
// GFX10: encoding: [0x01,0x03,0x80,0xbe]

s_mov_b32 s105, s104
// GFX10: encoding: [0x68,0x03,0xe9,0xbe]

s_mov_b32 s0, s104
// GFX10: encoding: [0x68,0x03,0x80,0xbe]

s_mov_b32 s105, s1
// GFX10: encoding: [0x01,0x03,0xe9,0xbe]

s_mov_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x03,0xfe,0xbe]

s_mov_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x03,0xff,0xbe]

s_mov_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x03,0xea,0xbe]

s_mov_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x03,0xeb,0xbe]

s_mov_b32 m0, s1
// GFX10: encoding: [0x01,0x03,0xfc,0xbe]

s_mov_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x03,0x80,0xbe]

s_mov_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x03,0x80,0xbe]

s_mov_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x03,0x80,0xbe]

s_mov_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x03,0x80,0xbe]

s_mov_b32 s0, m0
// GFX10: encoding: [0x7c,0x03,0x80,0xbe]

s_mov_b32 s0, 0
// GFX10: encoding: [0x80,0x03,0x80,0xbe]

s_mov_b32 s0, -1
// GFX10: encoding: [0xc1,0x03,0x80,0xbe]

s_mov_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x03,0x80,0xbe]

s_mov_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x03,0x80,0xbe]

s_mov_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x03,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x03,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x04,0x80,0xbe]

s_mov_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x04,0xe8,0xbe]

s_mov_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x04,0x80,0xbe]

s_mov_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x04,0xe8,0xbe]

s_mov_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x04,0xfe,0xbe]

s_mov_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x04,0xea,0xbe]

s_mov_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x04,0x80,0xbe]

s_mov_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x04,0x80,0xbe]

s_mov_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x04,0x80,0xbe]

s_mov_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x04,0x80,0xbe]

s_mov_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x04,0x80,0xbe]

s_mov_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x04,0x80,0xbe]

s_mov_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x04,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x04,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b32 s0, s1
// GFX10: encoding: [0x01,0x05,0x80,0xbe]

s_cmov_b32 s105, s104
// GFX10: encoding: [0x68,0x05,0xe9,0xbe]

s_cmov_b32 s0, s104
// GFX10: encoding: [0x68,0x05,0x80,0xbe]

s_cmov_b32 s105, s1
// GFX10: encoding: [0x01,0x05,0xe9,0xbe]

s_cmov_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x05,0xfe,0xbe]

s_cmov_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x05,0xff,0xbe]

s_cmov_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x05,0xea,0xbe]

s_cmov_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x05,0xeb,0xbe]

s_cmov_b32 m0, s1
// GFX10: encoding: [0x01,0x05,0xfc,0xbe]

s_cmov_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x05,0x80,0xbe]

s_cmov_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x05,0x80,0xbe]

s_cmov_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x05,0x80,0xbe]

s_cmov_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x05,0x80,0xbe]

s_cmov_b32 s0, m0
// GFX10: encoding: [0x7c,0x05,0x80,0xbe]

s_cmov_b32 s0, 0
// GFX10: encoding: [0x80,0x05,0x80,0xbe]

s_cmov_b32 s0, -1
// GFX10: encoding: [0xc1,0x05,0x80,0xbe]

s_cmov_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x05,0x80,0xbe]

s_cmov_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x05,0x80,0xbe]

s_cmov_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x05,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x05,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x06,0x80,0xbe]

s_cmov_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x06,0xe8,0xbe]

s_cmov_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x06,0x80,0xbe]

s_cmov_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x06,0xe8,0xbe]

s_cmov_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x06,0xfe,0xbe]

s_cmov_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x06,0xea,0xbe]

s_cmov_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x06,0x80,0xbe]

s_cmov_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x06,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x06,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_not_b32 s0, s1
// GFX10: encoding: [0x01,0x07,0x80,0xbe]

s_not_b32 s105, s104
// GFX10: encoding: [0x68,0x07,0xe9,0xbe]

s_not_b32 s0, s104
// GFX10: encoding: [0x68,0x07,0x80,0xbe]

s_not_b32 s105, s1
// GFX10: encoding: [0x01,0x07,0xe9,0xbe]

s_not_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x07,0xfe,0xbe]

s_not_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x07,0xff,0xbe]

s_not_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x07,0xea,0xbe]

s_not_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x07,0xeb,0xbe]

s_not_b32 m0, s1
// GFX10: encoding: [0x01,0x07,0xfc,0xbe]

s_not_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x07,0x80,0xbe]

s_not_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x07,0x80,0xbe]

s_not_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x07,0x80,0xbe]

s_not_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x07,0x80,0xbe]

s_not_b32 s0, m0
// GFX10: encoding: [0x7c,0x07,0x80,0xbe]

s_not_b32 s0, 0
// GFX10: encoding: [0x80,0x07,0x80,0xbe]

s_not_b32 s0, -1
// GFX10: encoding: [0xc1,0x07,0x80,0xbe]

s_not_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x07,0x80,0xbe]

s_not_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x07,0x80,0xbe]

s_not_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x07,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_not_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x07,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_not_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x08,0x80,0xbe]

s_not_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x08,0xe8,0xbe]

s_not_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x08,0x80,0xbe]

s_not_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x08,0xe8,0xbe]

s_not_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x08,0xfe,0xbe]

s_not_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x08,0xea,0xbe]

s_not_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x08,0x80,0xbe]

s_not_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x08,0x80,0xbe]

s_not_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x08,0x80,0xbe]

s_not_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x08,0x80,0xbe]

s_not_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x08,0x80,0xbe]

s_not_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x08,0x80,0xbe]

s_not_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x08,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_not_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x08,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b32 s0, s1
// GFX10: encoding: [0x01,0x09,0x80,0xbe]

s_wqm_b32 s105, s104
// GFX10: encoding: [0x68,0x09,0xe9,0xbe]

s_wqm_b32 s0, s104
// GFX10: encoding: [0x68,0x09,0x80,0xbe]

s_wqm_b32 s105, s1
// GFX10: encoding: [0x01,0x09,0xe9,0xbe]

s_wqm_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x09,0xfe,0xbe]

s_wqm_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x09,0xff,0xbe]

s_wqm_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x09,0xea,0xbe]

s_wqm_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x09,0xeb,0xbe]

s_wqm_b32 m0, s1
// GFX10: encoding: [0x01,0x09,0xfc,0xbe]

s_wqm_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x09,0x80,0xbe]

s_wqm_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x09,0x80,0xbe]

s_wqm_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x09,0x80,0xbe]

s_wqm_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x09,0x80,0xbe]

s_wqm_b32 s0, m0
// GFX10: encoding: [0x7c,0x09,0x80,0xbe]

s_wqm_b32 s0, 0
// GFX10: encoding: [0x80,0x09,0x80,0xbe]

s_wqm_b32 s0, -1
// GFX10: encoding: [0xc1,0x09,0x80,0xbe]

s_wqm_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x09,0x80,0xbe]

s_wqm_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x09,0x80,0xbe]

s_wqm_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x09,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x09,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x0a,0x80,0xbe]

s_wqm_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x0a,0xe8,0xbe]

s_wqm_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x0a,0x80,0xbe]

s_wqm_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x0a,0xe8,0xbe]

s_wqm_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x0a,0xfe,0xbe]

s_wqm_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x0a,0xea,0xbe]

s_wqm_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x0a,0x80,0xbe]

s_wqm_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x0a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x0a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b32 s0, s1
// GFX10: encoding: [0x01,0x0b,0x80,0xbe]

s_brev_b32 s105, s104
// GFX10: encoding: [0x68,0x0b,0xe9,0xbe]

s_brev_b32 s0, s104
// GFX10: encoding: [0x68,0x0b,0x80,0xbe]

s_brev_b32 s105, s1
// GFX10: encoding: [0x01,0x0b,0xe9,0xbe]

s_brev_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x0b,0xfe,0xbe]

s_brev_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x0b,0xff,0xbe]

s_brev_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x0b,0xea,0xbe]

s_brev_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x0b,0xeb,0xbe]

s_brev_b32 m0, s1
// GFX10: encoding: [0x01,0x0b,0xfc,0xbe]

s_brev_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x0b,0x80,0xbe]

s_brev_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x0b,0x80,0xbe]

s_brev_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x0b,0x80,0xbe]

s_brev_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x0b,0x80,0xbe]

s_brev_b32 s0, m0
// GFX10: encoding: [0x7c,0x0b,0x80,0xbe]

s_brev_b32 s0, 0
// GFX10: encoding: [0x80,0x0b,0x80,0xbe]

s_brev_b32 s0, -1
// GFX10: encoding: [0xc1,0x0b,0x80,0xbe]

s_brev_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x0b,0x80,0xbe]

s_brev_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x0b,0x80,0xbe]

s_brev_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x0c,0x80,0xbe]

s_brev_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x0c,0xe8,0xbe]

s_brev_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x0c,0x80,0xbe]

s_brev_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x0c,0xe8,0xbe]

s_brev_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x0c,0xfe,0xbe]

s_brev_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x0c,0xea,0xbe]

s_brev_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x0c,0x80,0xbe]

s_brev_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x0c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x0c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x0d,0xe9,0xbe]

s_bcnt0_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x0d,0xe9,0xbe]

s_bcnt0_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x0d,0xfe,0xbe]

s_bcnt0_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x0d,0xff,0xbe]

s_bcnt0_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x0d,0xea,0xbe]

s_bcnt0_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x0d,0xeb,0xbe]

s_bcnt0_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x0d,0xfc,0xbe]

s_bcnt0_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x0d,0x80,0xbe]

s_bcnt0_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x0e,0xe9,0xbe]

s_bcnt0_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xe9,0xbe]

s_bcnt0_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xfe,0xbe]

s_bcnt0_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xff,0xbe]

s_bcnt0_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xea,0xbe]

s_bcnt0_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xeb,0xbe]

s_bcnt0_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x0e,0xfc,0xbe]

s_bcnt0_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x0e,0x80,0xbe]

s_bcnt0_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x0f,0xe9,0xbe]

s_bcnt1_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x0f,0xe9,0xbe]

s_bcnt1_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x0f,0xfe,0xbe]

s_bcnt1_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x0f,0xff,0xbe]

s_bcnt1_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x0f,0xea,0xbe]

s_bcnt1_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x0f,0xeb,0xbe]

s_bcnt1_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x0f,0xfc,0xbe]

s_bcnt1_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x0f,0x80,0xbe]

s_bcnt1_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x0f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x0f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x10,0xe9,0xbe]

s_bcnt1_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x10,0xe9,0xbe]

s_bcnt1_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x10,0xfe,0xbe]

s_bcnt1_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x10,0xff,0xbe]

s_bcnt1_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x10,0xea,0xbe]

s_bcnt1_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x10,0xeb,0xbe]

s_bcnt1_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x10,0xfc,0xbe]

s_bcnt1_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x10,0x80,0xbe]

s_bcnt1_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x10,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x10,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x11,0x80,0xbe]

s_ff0_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x11,0xe9,0xbe]

s_ff0_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x11,0x80,0xbe]

s_ff0_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x11,0xe9,0xbe]

s_ff0_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x11,0xfe,0xbe]

s_ff0_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x11,0xff,0xbe]

s_ff0_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x11,0xea,0xbe]

s_ff0_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x11,0xeb,0xbe]

s_ff0_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x11,0xfc,0xbe]

s_ff0_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x11,0x80,0xbe]

s_ff0_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x11,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x11,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x12,0x80,0xbe]

s_ff0_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x12,0xe9,0xbe]

s_ff0_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x12,0x80,0xbe]

s_ff0_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x12,0xe9,0xbe]

s_ff0_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x12,0xfe,0xbe]

s_ff0_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x12,0xff,0xbe]

s_ff0_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x12,0xea,0xbe]

s_ff0_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x12,0xeb,0xbe]

s_ff0_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x12,0xfc,0xbe]

s_ff0_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x12,0x80,0xbe]

s_ff0_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x12,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x12,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x13,0x80,0xbe]

s_ff1_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x13,0xe9,0xbe]

s_ff1_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x13,0x80,0xbe]

s_ff1_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x13,0xe9,0xbe]

s_ff1_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x13,0xfe,0xbe]

s_ff1_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x13,0xff,0xbe]

s_ff1_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x13,0xea,0xbe]

s_ff1_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x13,0xeb,0xbe]

s_ff1_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x13,0xfc,0xbe]

s_ff1_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x13,0x80,0xbe]

s_ff1_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x13,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x13,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x14,0x80,0xbe]

s_ff1_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x14,0xe9,0xbe]

s_ff1_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x14,0x80,0xbe]

s_ff1_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x14,0xe9,0xbe]

s_ff1_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x14,0xfe,0xbe]

s_ff1_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x14,0xff,0xbe]

s_ff1_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x14,0xea,0xbe]

s_ff1_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x14,0xeb,0xbe]

s_ff1_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x14,0xfc,0xbe]

s_ff1_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x14,0x80,0xbe]

s_ff1_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x14,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x14,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b32 s0, s1
// GFX10: encoding: [0x01,0x15,0x80,0xbe]

s_flbit_i32_b32 s105, s104
// GFX10: encoding: [0x68,0x15,0xe9,0xbe]

s_flbit_i32_b32 s0, s104
// GFX10: encoding: [0x68,0x15,0x80,0xbe]

s_flbit_i32_b32 s105, s1
// GFX10: encoding: [0x01,0x15,0xe9,0xbe]

s_flbit_i32_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x15,0xfe,0xbe]

s_flbit_i32_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x15,0xff,0xbe]

s_flbit_i32_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x15,0xea,0xbe]

s_flbit_i32_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x15,0xeb,0xbe]

s_flbit_i32_b32 m0, s1
// GFX10: encoding: [0x01,0x15,0xfc,0xbe]

s_flbit_i32_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, m0
// GFX10: encoding: [0x7c,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, 0
// GFX10: encoding: [0x80,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, -1
// GFX10: encoding: [0xc1,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x15,0x80,0xbe]

s_flbit_i32_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x15,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x15,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b64 s0, s[2:3]
// GFX10: encoding: [0x02,0x16,0x80,0xbe]

s_flbit_i32_b64 s105, s[102:103]
// GFX10: encoding: [0x66,0x16,0xe9,0xbe]

s_flbit_i32_b64 s0, s[102:103]
// GFX10: encoding: [0x66,0x16,0x80,0xbe]

s_flbit_i32_b64 s105, s[2:3]
// GFX10: encoding: [0x02,0x16,0xe9,0xbe]

s_flbit_i32_b64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x16,0xfe,0xbe]

s_flbit_i32_b64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x16,0xff,0xbe]

s_flbit_i32_b64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x16,0xea,0xbe]

s_flbit_i32_b64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x16,0xeb,0xbe]

s_flbit_i32_b64 m0, s[2:3]
// GFX10: encoding: [0x02,0x16,0xfc,0xbe]

s_flbit_i32_b64 s0, exec
// GFX10: encoding: [0x7e,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, vcc
// GFX10: encoding: [0x6a,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, 0
// GFX10: encoding: [0x80,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, -1
// GFX10: encoding: [0xc1,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, 0.5
// GFX10: encoding: [0xf0,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, -4.0
// GFX10: encoding: [0xf7,0x16,0x80,0xbe]

s_flbit_i32_b64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x16,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x16,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32 s0, s1
// GFX10: encoding: [0x01,0x17,0x80,0xbe]

s_flbit_i32 s105, s104
// GFX10: encoding: [0x68,0x17,0xe9,0xbe]

s_flbit_i32 s0, s104
// GFX10: encoding: [0x68,0x17,0x80,0xbe]

s_flbit_i32 s105, s1
// GFX10: encoding: [0x01,0x17,0xe9,0xbe]

s_flbit_i32 exec_lo, s1
// GFX10: encoding: [0x01,0x17,0xfe,0xbe]

s_flbit_i32 exec_hi, s1
// GFX10: encoding: [0x01,0x17,0xff,0xbe]

s_flbit_i32 vcc_lo, s1
// GFX10: encoding: [0x01,0x17,0xea,0xbe]

s_flbit_i32 vcc_hi, s1
// GFX10: encoding: [0x01,0x17,0xeb,0xbe]

s_flbit_i32 m0, s1
// GFX10: encoding: [0x01,0x17,0xfc,0xbe]

s_flbit_i32 s0, exec_lo
// GFX10: encoding: [0x7e,0x17,0x80,0xbe]

s_flbit_i32 s0, exec_hi
// GFX10: encoding: [0x7f,0x17,0x80,0xbe]

s_flbit_i32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x17,0x80,0xbe]

s_flbit_i32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x17,0x80,0xbe]

s_flbit_i32 s0, m0
// GFX10: encoding: [0x7c,0x17,0x80,0xbe]

s_flbit_i32 s0, 0
// GFX10: encoding: [0x80,0x17,0x80,0xbe]

s_flbit_i32 s0, -1
// GFX10: encoding: [0xc1,0x17,0x80,0xbe]

s_flbit_i32 s0, 0.5
// GFX10: encoding: [0xf0,0x17,0x80,0xbe]

s_flbit_i32 s0, -4.0
// GFX10: encoding: [0xf7,0x17,0x80,0xbe]

s_flbit_i32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x17,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x17,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_i64 s0, s[2:3]
// GFX10: encoding: [0x02,0x18,0x80,0xbe]

s_flbit_i32_i64 s105, s[102:103]
// GFX10: encoding: [0x66,0x18,0xe9,0xbe]

s_flbit_i32_i64 s0, s[102:103]
// GFX10: encoding: [0x66,0x18,0x80,0xbe]

s_flbit_i32_i64 s105, s[2:3]
// GFX10: encoding: [0x02,0x18,0xe9,0xbe]

s_flbit_i32_i64 exec_lo, s[2:3]
// GFX10: encoding: [0x02,0x18,0xfe,0xbe]

s_flbit_i32_i64 exec_hi, s[2:3]
// GFX10: encoding: [0x02,0x18,0xff,0xbe]

s_flbit_i32_i64 vcc_lo, s[2:3]
// GFX10: encoding: [0x02,0x18,0xea,0xbe]

s_flbit_i32_i64 vcc_hi, s[2:3]
// GFX10: encoding: [0x02,0x18,0xeb,0xbe]

s_flbit_i32_i64 m0, s[2:3]
// GFX10: encoding: [0x02,0x18,0xfc,0xbe]

s_flbit_i32_i64 s0, exec
// GFX10: encoding: [0x7e,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, vcc
// GFX10: encoding: [0x6a,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, 0
// GFX10: encoding: [0x80,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, -1
// GFX10: encoding: [0xc1,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, 0.5
// GFX10: encoding: [0xf0,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, -4.0
// GFX10: encoding: [0xf7,0x18,0x80,0xbe]

s_flbit_i32_i64 s0, 0x3f717273
// GFX10: encoding: [0xff,0x18,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_i64 s0, 0xaf123456
// GFX10: encoding: [0xff,0x18,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_sext_i32_i8 s0, s1
// GFX10: encoding: [0x01,0x19,0x80,0xbe]

s_sext_i32_i8 s105, s104
// GFX10: encoding: [0x68,0x19,0xe9,0xbe]

s_sext_i32_i8 s0, s104
// GFX10: encoding: [0x68,0x19,0x80,0xbe]

s_sext_i32_i8 s105, s1
// GFX10: encoding: [0x01,0x19,0xe9,0xbe]

s_sext_i32_i8 exec_lo, s1
// GFX10: encoding: [0x01,0x19,0xfe,0xbe]

s_sext_i32_i8 exec_hi, s1
// GFX10: encoding: [0x01,0x19,0xff,0xbe]

s_sext_i32_i8 vcc_lo, s1
// GFX10: encoding: [0x01,0x19,0xea,0xbe]

s_sext_i32_i8 vcc_hi, s1
// GFX10: encoding: [0x01,0x19,0xeb,0xbe]

s_sext_i32_i8 m0, s1
// GFX10: encoding: [0x01,0x19,0xfc,0xbe]

s_sext_i32_i8 s0, exec_lo
// GFX10: encoding: [0x7e,0x19,0x80,0xbe]

s_sext_i32_i8 s0, exec_hi
// GFX10: encoding: [0x7f,0x19,0x80,0xbe]

s_sext_i32_i8 s0, vcc_lo
// GFX10: encoding: [0x6a,0x19,0x80,0xbe]

s_sext_i32_i8 s0, vcc_hi
// GFX10: encoding: [0x6b,0x19,0x80,0xbe]

s_sext_i32_i8 s0, m0
// GFX10: encoding: [0x7c,0x19,0x80,0xbe]

s_sext_i32_i8 s0, 0
// GFX10: encoding: [0x80,0x19,0x80,0xbe]

s_sext_i32_i8 s0, -1
// GFX10: encoding: [0xc1,0x19,0x80,0xbe]

s_sext_i32_i8 s0, 0.5
// GFX10: encoding: [0xf0,0x19,0x80,0xbe]

s_sext_i32_i8 s0, -4.0
// GFX10: encoding: [0xf7,0x19,0x80,0xbe]

s_sext_i32_i8 s0, 0x3f717273
// GFX10: encoding: [0xff,0x19,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i8 s0, 0xaf123456
// GFX10: encoding: [0xff,0x19,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_sext_i32_i16 s0, s1
// GFX10: encoding: [0x01,0x1a,0x80,0xbe]

s_sext_i32_i16 s105, s104
// GFX10: encoding: [0x68,0x1a,0xe9,0xbe]

s_sext_i32_i16 s0, s104
// GFX10: encoding: [0x68,0x1a,0x80,0xbe]

s_sext_i32_i16 s105, s1
// GFX10: encoding: [0x01,0x1a,0xe9,0xbe]

s_sext_i32_i16 exec_lo, s1
// GFX10: encoding: [0x01,0x1a,0xfe,0xbe]

s_sext_i32_i16 exec_hi, s1
// GFX10: encoding: [0x01,0x1a,0xff,0xbe]

s_sext_i32_i16 vcc_lo, s1
// GFX10: encoding: [0x01,0x1a,0xea,0xbe]

s_sext_i32_i16 vcc_hi, s1
// GFX10: encoding: [0x01,0x1a,0xeb,0xbe]

s_sext_i32_i16 m0, s1
// GFX10: encoding: [0x01,0x1a,0xfc,0xbe]

s_sext_i32_i16 s0, exec_lo
// GFX10: encoding: [0x7e,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, exec_hi
// GFX10: encoding: [0x7f,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, vcc_lo
// GFX10: encoding: [0x6a,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, vcc_hi
// GFX10: encoding: [0x6b,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, m0
// GFX10: encoding: [0x7c,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, 0
// GFX10: encoding: [0x80,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, -1
// GFX10: encoding: [0xc1,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, 0.5
// GFX10: encoding: [0xf0,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, -4.0
// GFX10: encoding: [0xf7,0x1a,0x80,0xbe]

s_sext_i32_i16 s0, 0x3f717273
// GFX10: encoding: [0xff,0x1a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i16 s0, 0xaf123456
// GFX10: encoding: [0xff,0x1a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b32 s0, s1
// GFX10: encoding: [0x01,0x1b,0x80,0xbe]

s_bitset0_b32 s105, s104
// GFX10: encoding: [0x68,0x1b,0xe9,0xbe]

s_bitset0_b32 s0, s104
// GFX10: encoding: [0x68,0x1b,0x80,0xbe]

s_bitset0_b32 s105, s1
// GFX10: encoding: [0x01,0x1b,0xe9,0xbe]

s_bitset0_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x1b,0xfe,0xbe]

s_bitset0_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x1b,0xff,0xbe]

s_bitset0_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x1b,0xea,0xbe]

s_bitset0_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x1b,0xeb,0xbe]

s_bitset0_b32 m0, s1
// GFX10: encoding: [0x01,0x1b,0xfc,0xbe]

s_bitset0_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x1b,0x80,0xbe]

s_bitset0_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x1b,0x80,0xbe]

s_bitset0_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x1b,0x80,0xbe]

s_bitset0_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x1b,0x80,0xbe]

s_bitset0_b32 s0, m0
// GFX10: encoding: [0x7c,0x1b,0x80,0xbe]

s_bitset0_b32 s0, 0
// GFX10: encoding: [0x80,0x1b,0x80,0xbe]

s_bitset0_b32 s0, -1
// GFX10: encoding: [0xc1,0x1b,0x80,0xbe]

s_bitset0_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x1b,0x80,0xbe]

s_bitset0_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x1b,0x80,0xbe]

s_bitset0_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x1b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x1b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b64 s[0:1], s2
// GFX10: encoding: [0x02,0x1c,0x80,0xbe]

s_bitset0_b64 s[104:105], s102
// GFX10: encoding: [0x66,0x1c,0xe8,0xbe]

s_bitset0_b64 s[0:1], s102
// GFX10: encoding: [0x66,0x1c,0x80,0xbe]

s_bitset0_b64 s[104:105], s2
// GFX10: encoding: [0x02,0x1c,0xe8,0xbe]

s_bitset0_b64 exec, s2
// GFX10: encoding: [0x02,0x1c,0xfe,0xbe]

s_bitset0_b64 vcc, s2
// GFX10: encoding: [0x02,0x1c,0xea,0xbe]

s_bitset0_b64 s[0:1], exec_lo
// GFX10: encoding: [0x7e,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], exec_hi
// GFX10: encoding: [0x7f,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x6a,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x6b,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], m0
// GFX10: encoding: [0x7c,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x1c,0x80,0xbe]

s_bitset0_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x1c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x1c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b32 s0, s1
// GFX10: encoding: [0x01,0x1d,0x80,0xbe]

s_bitset1_b32 s105, s104
// GFX10: encoding: [0x68,0x1d,0xe9,0xbe]

s_bitset1_b32 s0, s104
// GFX10: encoding: [0x68,0x1d,0x80,0xbe]

s_bitset1_b32 s105, s1
// GFX10: encoding: [0x01,0x1d,0xe9,0xbe]

s_bitset1_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x1d,0xfe,0xbe]

s_bitset1_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x1d,0xff,0xbe]

s_bitset1_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x1d,0xea,0xbe]

s_bitset1_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x1d,0xeb,0xbe]

s_bitset1_b32 m0, s1
// GFX10: encoding: [0x01,0x1d,0xfc,0xbe]

s_bitset1_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x1d,0x80,0xbe]

s_bitset1_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x1d,0x80,0xbe]

s_bitset1_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x1d,0x80,0xbe]

s_bitset1_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x1d,0x80,0xbe]

s_bitset1_b32 s0, m0
// GFX10: encoding: [0x7c,0x1d,0x80,0xbe]

s_bitset1_b32 s0, 0
// GFX10: encoding: [0x80,0x1d,0x80,0xbe]

s_bitset1_b32 s0, -1
// GFX10: encoding: [0xc1,0x1d,0x80,0xbe]

s_bitset1_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x1d,0x80,0xbe]

s_bitset1_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x1d,0x80,0xbe]

s_bitset1_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x1d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x1d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b64 s[0:1], s2
// GFX10: encoding: [0x02,0x1e,0x80,0xbe]

s_bitset1_b64 s[104:105], s102
// GFX10: encoding: [0x66,0x1e,0xe8,0xbe]

s_bitset1_b64 s[0:1], s102
// GFX10: encoding: [0x66,0x1e,0x80,0xbe]

s_bitset1_b64 s[104:105], s2
// GFX10: encoding: [0x02,0x1e,0xe8,0xbe]

s_bitset1_b64 exec, s2
// GFX10: encoding: [0x02,0x1e,0xfe,0xbe]

s_bitset1_b64 vcc, s2
// GFX10: encoding: [0x02,0x1e,0xea,0xbe]

s_bitset1_b64 s[0:1], exec_lo
// GFX10: encoding: [0x7e,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], exec_hi
// GFX10: encoding: [0x7f,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x6a,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x6b,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], m0
// GFX10: encoding: [0x7c,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x1e,0x80,0xbe]

s_bitset1_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x1e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x1e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_getpc_b64 s[0:1]
// GFX10: encoding: [0x00,0x1f,0x80,0xbe]

s_getpc_b64 s[104:105]
// GFX10: encoding: [0x00,0x1f,0xe8,0xbe]

s_getpc_b64 exec
// GFX10: encoding: [0x00,0x1f,0xfe,0xbe]

s_getpc_b64 vcc
// GFX10: encoding: [0x00,0x1f,0xea,0xbe]

s_setpc_b64 s[0:1]
// GFX10: encoding: [0x00,0x20,0x80,0xbe]

s_setpc_b64 s[104:105]
// GFX10: encoding: [0x68,0x20,0x80,0xbe]

s_setpc_b64 vcc
// GFX10: encoding: [0x6a,0x20,0x80,0xbe]

s_swappc_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x21,0x80,0xbe]

s_swappc_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x21,0xe8,0xbe]

s_swappc_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x21,0x80,0xbe]

s_swappc_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x21,0xe8,0xbe]

s_swappc_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x21,0xea,0xbe]

s_swappc_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x21,0x80,0xbe]

s_rfe_b64 s[0:1]
// GFX10: encoding: [0x00,0x22,0x80,0xbe]

s_rfe_b64 s[104:105]
// GFX10: encoding: [0x68,0x22,0x80,0xbe]

s_rfe_b64 vcc
// GFX10: encoding: [0x6a,0x22,0x80,0xbe]

s_and_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x24,0x80,0xbe]

s_and_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x24,0xe8,0xbe]

s_and_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x24,0x80,0xbe]

s_and_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x24,0xe8,0xbe]

s_and_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x24,0xfe,0xbe]

s_and_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x24,0xea,0xbe]

s_and_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x24,0x80,0xbe]

s_and_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x24,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_and_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x24,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x25,0x80,0xbe]

s_or_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x25,0xe8,0xbe]

s_or_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x25,0x80,0xbe]

s_or_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x25,0xe8,0xbe]

s_or_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x25,0xfe,0xbe]

s_or_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x25,0xea,0xbe]

s_or_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x25,0x80,0xbe]

s_or_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x25,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x25,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x26,0xe8,0xbe]

s_xor_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x26,0xe8,0xbe]

s_xor_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x26,0xfe,0xbe]

s_xor_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x26,0xea,0xbe]

s_xor_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x26,0x80,0xbe]

s_xor_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x26,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x26,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x27,0xe8,0xbe]

s_andn2_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x27,0xe8,0xbe]

s_andn2_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x27,0xfe,0xbe]

s_andn2_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x27,0xea,0xbe]

s_andn2_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x27,0x80,0xbe]

s_andn2_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x27,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x27,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x28,0xe8,0xbe]

s_orn2_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x28,0xe8,0xbe]

s_orn2_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x28,0xfe,0xbe]

s_orn2_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x28,0xea,0xbe]

s_orn2_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x28,0x80,0xbe]

s_orn2_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x28,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x28,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x29,0xe8,0xbe]

s_nand_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x29,0xe8,0xbe]

s_nand_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x29,0xfe,0xbe]

s_nand_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x29,0xea,0xbe]

s_nand_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x29,0x80,0xbe]

s_nand_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x29,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x29,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2a,0xe8,0xbe]

s_nor_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2a,0xe8,0xbe]

s_nor_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2a,0xfe,0xbe]

s_nor_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2a,0xea,0xbe]

s_nor_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x2a,0x80,0xbe]

s_nor_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x2a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x2a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2b,0xfe,0xbe]

s_xnor_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2b,0xea,0xbe]

s_xnor_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x2b,0x80,0xbe]

s_xnor_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x2b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x2b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b32 s0, s1
// GFX10: encoding: [0x01,0x2c,0x80,0xbe]

s_quadmask_b32 s105, s104
// GFX10: encoding: [0x68,0x2c,0xe9,0xbe]

s_quadmask_b32 s0, s104
// GFX10: encoding: [0x68,0x2c,0x80,0xbe]

s_quadmask_b32 s105, s1
// GFX10: encoding: [0x01,0x2c,0xe9,0xbe]

s_quadmask_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x2c,0xfe,0xbe]

s_quadmask_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x2c,0xff,0xbe]

s_quadmask_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x2c,0xea,0xbe]

s_quadmask_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x2c,0xeb,0xbe]

s_quadmask_b32 m0, s1
// GFX10: encoding: [0x01,0x2c,0xfc,0xbe]

s_quadmask_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x2c,0x80,0xbe]

s_quadmask_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x2c,0x80,0xbe]

s_quadmask_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x2c,0x80,0xbe]

s_quadmask_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x2c,0x80,0xbe]

s_quadmask_b32 s0, m0
// GFX10: encoding: [0x7c,0x2c,0x80,0xbe]

s_quadmask_b32 s0, 0
// GFX10: encoding: [0x80,0x2c,0x80,0xbe]

s_quadmask_b32 s0, -1
// GFX10: encoding: [0xc1,0x2c,0x80,0xbe]

s_quadmask_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x2c,0x80,0xbe]

s_quadmask_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x2c,0x80,0xbe]

s_quadmask_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x2c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x2c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2d,0x80,0xbe]

s_quadmask_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2d,0xe8,0xbe]

s_quadmask_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2d,0x80,0xbe]

s_quadmask_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2d,0xe8,0xbe]

s_quadmask_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2d,0xfe,0xbe]

s_quadmask_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2d,0xea,0xbe]

s_quadmask_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x2d,0x80,0xbe]

s_quadmask_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x2d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x2d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movrels_b32 s0, s1
// GFX10: encoding: [0x01,0x2e,0x80,0xbe]

s_movrels_b32 s105, s104
// GFX10: encoding: [0x68,0x2e,0xe9,0xbe]

s_movrels_b32 s0, s104
// GFX10: encoding: [0x68,0x2e,0x80,0xbe]

s_movrels_b32 s105, s1
// GFX10: encoding: [0x01,0x2e,0xe9,0xbe]

s_movrels_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x2e,0xfe,0xbe]

s_movrels_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x2e,0xff,0xbe]

s_movrels_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x2e,0xea,0xbe]

s_movrels_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x2e,0xeb,0xbe]

s_movrels_b32 m0, s1
// GFX10: encoding: [0x01,0x2e,0xfc,0xbe]

s_movrels_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x2e,0x80,0xbe]

s_movrels_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x2e,0x80,0xbe]

s_movrels_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x2f,0x80,0xbe]

s_movrels_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x2f,0xe8,0xbe]

s_movrels_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x2f,0x80,0xbe]

s_movrels_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x2f,0xe8,0xbe]

s_movrels_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x2f,0xfe,0xbe]

s_movrels_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x2f,0xea,0xbe]

s_movrels_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x2f,0x80,0xbe]

s_movreld_b32 s0, s1
// GFX10: encoding: [0x01,0x30,0x80,0xbe]

s_movreld_b32 s105, s104
// GFX10: encoding: [0x68,0x30,0xe9,0xbe]

s_movreld_b32 s0, s104
// GFX10: encoding: [0x68,0x30,0x80,0xbe]

s_movreld_b32 s105, s1
// GFX10: encoding: [0x01,0x30,0xe9,0xbe]

s_movreld_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x30,0xea,0xbe]

s_movreld_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x30,0xeb,0xbe]

s_movreld_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x30,0x80,0xbe]

s_movreld_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x30,0x80,0xbe]

s_movreld_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x30,0x80,0xbe]

s_movreld_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x30,0x80,0xbe]

s_movreld_b32 s0, m0
// GFX10: encoding: [0x7c,0x30,0x80,0xbe]

s_movreld_b32 s0, 0
// GFX10: encoding: [0x80,0x30,0x80,0xbe]

s_movreld_b32 s0, -1
// GFX10: encoding: [0xc1,0x30,0x80,0xbe]

s_movreld_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x30,0x80,0xbe]

s_movreld_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x30,0x80,0xbe]

s_movreld_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x30,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x30,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x31,0x80,0xbe]

s_movreld_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x31,0xe8,0xbe]

s_movreld_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x31,0x80,0xbe]

s_movreld_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x31,0xe8,0xbe]

s_movreld_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x31,0xea,0xbe]

s_movreld_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x31,0x80,0xbe]

s_movreld_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x31,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x31,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_abs_i32 s0, s1
// GFX10: encoding: [0x01,0x34,0x80,0xbe]

s_abs_i32 s105, s104
// GFX10: encoding: [0x68,0x34,0xe9,0xbe]

s_abs_i32 s0, s104
// GFX10: encoding: [0x68,0x34,0x80,0xbe]

s_abs_i32 s105, s1
// GFX10: encoding: [0x01,0x34,0xe9,0xbe]

s_abs_i32 exec_lo, s1
// GFX10: encoding: [0x01,0x34,0xfe,0xbe]

s_abs_i32 exec_hi, s1
// GFX10: encoding: [0x01,0x34,0xff,0xbe]

s_abs_i32 vcc_lo, s1
// GFX10: encoding: [0x01,0x34,0xea,0xbe]

s_abs_i32 vcc_hi, s1
// GFX10: encoding: [0x01,0x34,0xeb,0xbe]

s_abs_i32 m0, s1
// GFX10: encoding: [0x01,0x34,0xfc,0xbe]

s_abs_i32 s0, exec_lo
// GFX10: encoding: [0x7e,0x34,0x80,0xbe]

s_abs_i32 s0, exec_hi
// GFX10: encoding: [0x7f,0x34,0x80,0xbe]

s_abs_i32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x34,0x80,0xbe]

s_abs_i32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x34,0x80,0xbe]

s_abs_i32 s0, m0
// GFX10: encoding: [0x7c,0x34,0x80,0xbe]

s_abs_i32 s0, 0
// GFX10: encoding: [0x80,0x34,0x80,0xbe]

s_abs_i32 s0, -1
// GFX10: encoding: [0xc1,0x34,0x80,0xbe]

s_abs_i32 s0, 0.5
// GFX10: encoding: [0xf0,0x34,0x80,0xbe]

s_abs_i32 s0, -4.0
// GFX10: encoding: [0xf7,0x34,0x80,0xbe]

s_abs_i32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x34,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_abs_i32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x34,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_mov_fed_b32 s0, s1
// GFX10: encoding: [0x01,0x35,0x80,0xbe]

s_mov_fed_b32 s105, s104
// GFX10: encoding: [0x68,0x35,0xe9,0xbe]

s_mov_fed_b32 s0, s104
// GFX10: encoding: [0x68,0x35,0x80,0xbe]

s_mov_fed_b32 s105, s1
// GFX10: encoding: [0x01,0x35,0xe9,0xbe]

s_mov_fed_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x35,0xfe,0xbe]

s_mov_fed_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x35,0xff,0xbe]

s_mov_fed_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x35,0xea,0xbe]

s_mov_fed_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x35,0xeb,0xbe]

s_mov_fed_b32 m0, s1
// GFX10: encoding: [0x01,0x35,0xfc,0xbe]

s_mov_fed_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x35,0x80,0xbe]

s_mov_fed_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x35,0x80,0xbe]

s_mov_fed_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x35,0x80,0xbe]

s_mov_fed_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x35,0x80,0xbe]

s_mov_fed_b32 s0, m0
// GFX10: encoding: [0x7c,0x35,0x80,0xbe]

s_mov_fed_b32 s0, 0
// GFX10: encoding: [0x80,0x35,0x80,0xbe]

s_mov_fed_b32 s0, -1
// GFX10: encoding: [0xc1,0x35,0x80,0xbe]

s_mov_fed_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x35,0x80,0xbe]

s_mov_fed_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x35,0x80,0xbe]

s_mov_fed_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x35,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_mov_fed_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x35,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x37,0xe8,0xbe]

s_andn1_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x37,0xe8,0xbe]

s_andn1_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x37,0xfe,0xbe]

s_andn1_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x37,0xea,0xbe]

s_andn1_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x37,0x80,0xbe]

s_andn1_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x37,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x37,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x38,0xe8,0xbe]

s_orn1_saveexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x38,0xe8,0xbe]

s_orn1_saveexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x38,0xfe,0xbe]

s_orn1_saveexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x38,0xea,0xbe]

s_orn1_saveexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x38,0x80,0xbe]

s_orn1_saveexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x38,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x38,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x39,0xe8,0xbe]

s_andn1_wrexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x39,0xe8,0xbe]

s_andn1_wrexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x39,0xfe,0xbe]

s_andn1_wrexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x39,0xea,0xbe]

s_andn1_wrexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x39,0x80,0xbe]

s_andn1_wrexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x39,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x39,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b64 s[0:1], s[2:3]
// GFX10: encoding: [0x02,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[104:105], s[102:103]
// GFX10: encoding: [0x66,0x3a,0xe8,0xbe]

s_andn2_wrexec_b64 s[0:1], s[102:103]
// GFX10: encoding: [0x66,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[104:105], s[2:3]
// GFX10: encoding: [0x02,0x3a,0xe8,0xbe]

s_andn2_wrexec_b64 exec, s[2:3]
// GFX10: encoding: [0x02,0x3a,0xfe,0xbe]

s_andn2_wrexec_b64 vcc, s[2:3]
// GFX10: encoding: [0x02,0x3a,0xea,0xbe]

s_andn2_wrexec_b64 s[0:1], exec
// GFX10: encoding: [0x7e,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], vcc
// GFX10: encoding: [0x6a,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0
// GFX10: encoding: [0x80,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], -1
// GFX10: encoding: [0xc1,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x3a,0x80,0xbe]

s_andn2_wrexec_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x3a,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x3a,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_bitreplicate_b64_b32 s[0:1], s2
// GFX10: encoding: [0x02,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[104:105], s102
// GFX10: encoding: [0x66,0x3b,0xe8,0xbe]

s_bitreplicate_b64_b32 s[0:1], s102
// GFX10: encoding: [0x66,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[104:105], s2
// GFX10: encoding: [0x02,0x3b,0xe8,0xbe]

s_bitreplicate_b64_b32 exec, s2
// GFX10: encoding: [0x02,0x3b,0xfe,0xbe]

s_bitreplicate_b64_b32 vcc, s2
// GFX10: encoding: [0x02,0x3b,0xea,0xbe]

s_bitreplicate_b64_b32 s[0:1], exec_lo
// GFX10: encoding: [0x7e,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], exec_hi
// GFX10: encoding: [0x7f,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], vcc_lo
// GFX10: encoding: [0x6a,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], vcc_hi
// GFX10: encoding: [0x6b,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], m0
// GFX10: encoding: [0x7c,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0
// GFX10: encoding: [0x80,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], -1
// GFX10: encoding: [0xc1,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0.5
// GFX10: encoding: [0xf0,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], -4.0
// GFX10: encoding: [0xf7,0x3b,0x80,0xbe]

s_bitreplicate_b64_b32 s[0:1], 0x3f717273
// GFX10: encoding: [0xff,0x3b,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_bitreplicate_b64_b32 s[0:1], 0xaf123456
// GFX10: encoding: [0xff,0x3b,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_and_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3c,0x80,0xbe]

s_and_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3c,0xe9,0xbe]

s_and_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3c,0x80,0xbe]

s_and_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3c,0xe9,0xbe]

s_and_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3c,0xfe,0xbe]

s_and_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3c,0xff,0xbe]

s_and_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3c,0xea,0xbe]

s_and_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3c,0xeb,0xbe]

s_and_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3c,0xfc,0xbe]

s_and_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3c,0x80,0xbe]

s_and_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3c,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_and_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3c,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3d,0x80,0xbe]

s_or_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3d,0xe9,0xbe]

s_or_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3d,0x80,0xbe]

s_or_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3d,0xe9,0xbe]

s_or_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3d,0xfe,0xbe]

s_or_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3d,0xff,0xbe]

s_or_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3d,0xea,0xbe]

s_or_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3d,0xeb,0xbe]

s_or_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3d,0xfc,0xbe]

s_or_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3d,0x80,0xbe]

s_or_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3d,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3d,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3e,0xe9,0xbe]

s_xor_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3e,0xe9,0xbe]

s_xor_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3e,0xfe,0xbe]

s_xor_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3e,0xff,0xbe]

s_xor_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3e,0xea,0xbe]

s_xor_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3e,0xeb,0xbe]

s_xor_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3e,0xfc,0xbe]

s_xor_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3e,0x80,0xbe]

s_xor_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3e,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3e,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x3f,0xe9,0xbe]

s_andn2_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x3f,0xe9,0xbe]

s_andn2_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x3f,0xfe,0xbe]

s_andn2_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x3f,0xff,0xbe]

s_andn2_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x3f,0xea,0xbe]

s_andn2_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x3f,0xeb,0xbe]

s_andn2_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x3f,0xfc,0xbe]

s_andn2_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x3f,0x80,0xbe]

s_andn2_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x3f,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x3f,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x40,0xe9,0xbe]

s_orn2_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x40,0xe9,0xbe]

s_orn2_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x40,0xfe,0xbe]

s_orn2_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x40,0xff,0xbe]

s_orn2_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x40,0xea,0xbe]

s_orn2_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x40,0xeb,0xbe]

s_orn2_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x40,0xfc,0xbe]

s_orn2_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x40,0x80,0xbe]

s_orn2_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x40,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x40,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x41,0x80,0xbe]

s_nand_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x41,0xe9,0xbe]

s_nand_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x41,0x80,0xbe]

s_nand_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x41,0xe9,0xbe]

s_nand_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x41,0xfe,0xbe]

s_nand_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x41,0xff,0xbe]

s_nand_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x41,0xea,0xbe]

s_nand_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x41,0xeb,0xbe]

s_nand_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x41,0xfc,0xbe]

s_nand_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x41,0x80,0xbe]

s_nand_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x41,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x41,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x42,0x80,0xbe]

s_nor_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x42,0xe9,0xbe]

s_nor_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x42,0x80,0xbe]

s_nor_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x42,0xe9,0xbe]

s_nor_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x42,0xfe,0xbe]

s_nor_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x42,0xff,0xbe]

s_nor_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x42,0xea,0xbe]

s_nor_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x42,0xeb,0xbe]

s_nor_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x42,0xfc,0xbe]

s_nor_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x42,0x80,0xbe]

s_nor_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x42,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x42,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x43,0xe9,0xbe]

s_xnor_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x43,0xe9,0xbe]

s_xnor_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x43,0xfe,0xbe]

s_xnor_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x43,0xff,0xbe]

s_xnor_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x43,0xea,0xbe]

s_xnor_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x43,0xeb,0xbe]

s_xnor_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x43,0xfc,0xbe]

s_xnor_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x43,0x80,0xbe]

s_xnor_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x43,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x43,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x44,0xe9,0xbe]

s_andn1_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x44,0xe9,0xbe]

s_andn1_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x44,0xfe,0xbe]

s_andn1_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x44,0xff,0xbe]

s_andn1_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x44,0xea,0xbe]

s_andn1_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x44,0xeb,0xbe]

s_andn1_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x44,0xfc,0xbe]

s_andn1_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x44,0x80,0xbe]

s_andn1_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x44,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x44,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_orn1_saveexec_b32 s0, s1
// GFX10: encoding: [0x01,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s105, s104
// GFX10: encoding: [0x68,0x45,0xe9,0xbe]

s_orn1_saveexec_b32 s0, s104
// GFX10: encoding: [0x68,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s105, s1
// GFX10: encoding: [0x01,0x45,0xe9,0xbe]

s_orn1_saveexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x45,0xfe,0xbe]

s_orn1_saveexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x45,0xff,0xbe]

s_orn1_saveexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x45,0xea,0xbe]

s_orn1_saveexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x45,0xeb,0xbe]

s_orn1_saveexec_b32 m0, s1
// GFX10: encoding: [0x01,0x45,0xfc,0xbe]

s_orn1_saveexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0
// GFX10: encoding: [0x80,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x45,0x80,0xbe]

s_orn1_saveexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x45,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_orn1_saveexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x45,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn1_wrexec_b32 s0, s1
// GFX10: encoding: [0x01,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s105, s104
// GFX10: encoding: [0x68,0x46,0xe9,0xbe]

s_andn1_wrexec_b32 s0, s104
// GFX10: encoding: [0x68,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s105, s1
// GFX10: encoding: [0x01,0x46,0xe9,0xbe]

s_andn1_wrexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x46,0xfe,0xbe]

s_andn1_wrexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x46,0xff,0xbe]

s_andn1_wrexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x46,0xea,0xbe]

s_andn1_wrexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x46,0xeb,0xbe]

s_andn1_wrexec_b32 m0, s1
// GFX10: encoding: [0x01,0x46,0xfc,0xbe]

s_andn1_wrexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0
// GFX10: encoding: [0x80,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x46,0x80,0xbe]

s_andn1_wrexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x46,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn1_wrexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x46,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_wrexec_b32 s0, s1
// GFX10: encoding: [0x01,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s105, s104
// GFX10: encoding: [0x68,0x47,0xe9,0xbe]

s_andn2_wrexec_b32 s0, s104
// GFX10: encoding: [0x68,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s105, s1
// GFX10: encoding: [0x01,0x47,0xe9,0xbe]

s_andn2_wrexec_b32 exec_lo, s1
// GFX10: encoding: [0x01,0x47,0xfe,0xbe]

s_andn2_wrexec_b32 exec_hi, s1
// GFX10: encoding: [0x01,0x47,0xff,0xbe]

s_andn2_wrexec_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x47,0xea,0xbe]

s_andn2_wrexec_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x47,0xeb,0xbe]

s_andn2_wrexec_b32 m0, s1
// GFX10: encoding: [0x01,0x47,0xfc,0xbe]

s_andn2_wrexec_b32 s0, exec_lo
// GFX10: encoding: [0x7e,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, exec_hi
// GFX10: encoding: [0x7f,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, m0
// GFX10: encoding: [0x7c,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0
// GFX10: encoding: [0x80,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, -1
// GFX10: encoding: [0xc1,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0.5
// GFX10: encoding: [0xf0,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, -4.0
// GFX10: encoding: [0xf7,0x47,0x80,0xbe]

s_andn2_wrexec_b32 s0, 0x3f717273
// GFX10: encoding: [0xff,0x47,0x80,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_wrexec_b32 s0, 0xaf123456
// GFX10: encoding: [0xff,0x47,0x80,0xbe,0x56,0x34,0x12,0xaf]

s_movrelsd_2_b32 s0, s1
// GFX10: encoding: [0x01,0x49,0x80,0xbe]

s_movrelsd_2_b32 s105, s104
// GFX10: encoding: [0x68,0x49,0xe9,0xbe]

s_movrelsd_2_b32 s0, s104
// GFX10: encoding: [0x68,0x49,0x80,0xbe]

s_movrelsd_2_b32 s105, s1
// GFX10: encoding: [0x01,0x49,0xe9,0xbe]

s_movrelsd_2_b32 vcc_lo, s1
// GFX10: encoding: [0x01,0x49,0xea,0xbe]

s_movrelsd_2_b32 vcc_hi, s1
// GFX10: encoding: [0x01,0x49,0xeb,0xbe]

s_movrelsd_2_b32 s0, vcc_lo
// GFX10: encoding: [0x6a,0x49,0x80,0xbe]

s_movrelsd_2_b32 s0, vcc_hi
// GFX10: encoding: [0x6b,0x49,0x80,0xbe]

//===----------------------------------------------------------------------===//
// ENC_SOP2.
//===----------------------------------------------------------------------===//

s_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x80]

s_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x80]

s_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x80]

s_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x80]

s_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x80]

s_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x80]

s_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x80]

s_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x80]

s_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x80]

s_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x80]

s_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x80]

s_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x80]

s_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x80]

s_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x80]

s_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x80]

s_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x80]

s_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x80]

s_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x80]

s_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x80]

s_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x80]

s_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x80]

s_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x80]

s_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x80,0x73,0x72,0x71,0x3f]

s_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x80,0x56,0x34,0x12,0xaf]

s_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x80]

s_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x80]

s_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x80]

s_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x80]

s_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x80]

s_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x80]

s_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x80]

s_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x80]

s_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x80]

s_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x80,0x73,0x72,0x71,0x3f]

s_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x80]

s_sub_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x80]

s_sub_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x80]

s_sub_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x80]

s_sub_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x80]

s_sub_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x80]

s_sub_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x80]

s_sub_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x80]

s_sub_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x80]

s_sub_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x80]

s_sub_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x80]

s_sub_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x80]

s_sub_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x80]

s_sub_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x80]

s_sub_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x80]

s_sub_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x80]

s_sub_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x80]

s_sub_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x80]

s_sub_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x80]

s_sub_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x80]

s_sub_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x80]

s_sub_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x80]

s_sub_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x80]

s_sub_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x80]

s_sub_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x80]

s_sub_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x80]

s_sub_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x80]

s_sub_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x80]

s_sub_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x80]

s_sub_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x80]

s_sub_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x80]

s_sub_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x80,0x56,0x34,0x12,0xaf]

s_add_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x81]

s_add_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x81]

s_add_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x81]

s_add_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x81]

s_add_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x81]

s_add_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x81]

s_add_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x81]

s_add_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x81]

s_add_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x81]

s_add_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x81]

s_add_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x81]

s_add_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x81]

s_add_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x81]

s_add_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x81]

s_add_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x81]

s_add_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x81]

s_add_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x81]

s_add_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x81]

s_add_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x81]

s_add_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x81]

s_add_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x81]

s_add_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x81]

s_add_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x81,0x73,0x72,0x71,0x3f]

s_add_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x81,0x56,0x34,0x12,0xaf]

s_add_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x81]

s_add_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x81]

s_add_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x81]

s_add_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x81]

s_add_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x81]

s_add_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x81]

s_add_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x81]

s_add_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x81]

s_add_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x81]

s_add_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x81,0x73,0x72,0x71,0x3f]

s_add_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x81]

s_sub_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x81]

s_sub_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x81]

s_sub_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x81]

s_sub_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x81]

s_sub_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x81]

s_sub_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x81]

s_sub_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x81]

s_sub_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x81]

s_sub_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x81]

s_sub_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x81]

s_sub_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x81]

s_sub_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x81]

s_sub_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x81]

s_sub_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x81]

s_sub_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x81]

s_sub_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x81]

s_sub_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x81]

s_sub_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x81]

s_sub_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x81]

s_sub_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x81]

s_sub_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x81]

s_sub_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x81]

s_sub_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x81]

s_sub_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x81]

s_sub_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x81]

s_sub_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x81]

s_sub_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x81]

s_sub_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x81]

s_sub_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x81]

s_sub_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x81]

s_sub_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x81,0x56,0x34,0x12,0xaf]

s_addc_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x82]

s_addc_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x82]

s_addc_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x82]

s_addc_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x82]

s_addc_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x82]

s_addc_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x82]

s_addc_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x82]

s_addc_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x82]

s_addc_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x82]

s_addc_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x82]

s_addc_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x82]

s_addc_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x82]

s_addc_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x82]

s_addc_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x82]

s_addc_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x82]

s_addc_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x82]

s_addc_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x82]

s_addc_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x82]

s_addc_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x82]

s_addc_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x82]

s_addc_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x82]

s_addc_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x82]

s_addc_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x82,0x73,0x72,0x71,0x3f]

s_addc_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x82,0x56,0x34,0x12,0xaf]

s_addc_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x82]

s_addc_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x82]

s_addc_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x82]

s_addc_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x82]

s_addc_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x82]

s_addc_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x82]

s_addc_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x82]

s_addc_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x82]

s_addc_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x82]

s_addc_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x82,0x73,0x72,0x71,0x3f]

s_addc_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x82]

s_subb_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x82]

s_subb_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x82]

s_subb_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x82]

s_subb_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x82]

s_subb_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x82]

s_subb_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x82]

s_subb_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x82]

s_subb_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x82]

s_subb_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x82]

s_subb_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x82]

s_subb_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x82]

s_subb_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x82]

s_subb_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x82]

s_subb_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x82]

s_subb_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x82]

s_subb_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x82]

s_subb_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x82]

s_subb_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x82]

s_subb_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x82]

s_subb_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x82]

s_subb_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x82]

s_subb_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x82]

s_subb_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x82]

s_subb_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x82]

s_subb_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x82]

s_subb_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x82]

s_subb_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x82]

s_subb_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x82]

s_subb_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x82]

s_subb_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x82]

s_subb_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x82,0x56,0x34,0x12,0xaf]

s_min_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x83]

s_min_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x83]

s_min_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x83]

s_min_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x83]

s_min_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x83]

s_min_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x83]

s_min_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x83]

s_min_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x83]

s_min_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x83]

s_min_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x83]

s_min_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x83]

s_min_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x83]

s_min_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x83]

s_min_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x83]

s_min_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x83]

s_min_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x83]

s_min_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x83]

s_min_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x83]

s_min_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x83]

s_min_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x83]

s_min_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x83]

s_min_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x83]

s_min_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x83,0x73,0x72,0x71,0x3f]

s_min_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x83,0x56,0x34,0x12,0xaf]

s_min_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x83]

s_min_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x83]

s_min_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x83]

s_min_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x83]

s_min_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x83]

s_min_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x83]

s_min_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x83]

s_min_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x83]

s_min_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x83]

s_min_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x83,0x73,0x72,0x71,0x3f]

s_min_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x83]

s_min_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x83]

s_min_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x83]

s_min_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x83]

s_min_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x83]

s_min_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x83]

s_min_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x83]

s_min_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x83]

s_min_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x83]

s_min_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x83]

s_min_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x83]

s_min_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x83]

s_min_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x83]

s_min_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x83]

s_min_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x83]

s_min_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x83]

s_min_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x83]

s_min_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x83]

s_min_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x83]

s_min_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x83]

s_min_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x83]

s_min_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x83]

s_min_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x83]

s_min_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x83]

s_min_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x83]

s_min_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x83]

s_min_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x83]

s_min_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x83]

s_min_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x83]

s_min_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x83]

s_min_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x83]

s_min_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x83,0x56,0x34,0x12,0xaf]

s_max_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x84]

s_max_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x84]

s_max_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x84]

s_max_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x84]

s_max_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x84]

s_max_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x84]

s_max_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x84]

s_max_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x84]

s_max_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x84]

s_max_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x84]

s_max_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x84]

s_max_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x84]

s_max_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x84]

s_max_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x84]

s_max_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x84]

s_max_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x84]

s_max_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x84]

s_max_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x84]

s_max_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x84]

s_max_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x84]

s_max_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x84]

s_max_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x84]

s_max_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x84,0x73,0x72,0x71,0x3f]

s_max_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x84,0x56,0x34,0x12,0xaf]

s_max_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x84]

s_max_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x84]

s_max_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x84]

s_max_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x84]

s_max_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x84]

s_max_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x84]

s_max_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x84]

s_max_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x84]

s_max_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x84]

s_max_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x84,0x73,0x72,0x71,0x3f]

s_max_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x84]

s_max_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x84]

s_max_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x84]

s_max_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x84]

s_max_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x84]

s_max_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x84]

s_max_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x84]

s_max_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x84]

s_max_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x84]

s_max_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x84]

s_max_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x84]

s_max_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x84]

s_max_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x84]

s_max_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x84]

s_max_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x84]

s_max_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x84]

s_max_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x84]

s_max_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x84]

s_max_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x84]

s_max_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x84]

s_max_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x84]

s_max_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x84]

s_max_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x84]

s_max_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x84]

s_max_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x84]

s_max_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x84]

s_max_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x84]

s_max_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x84]

s_max_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x84]

s_max_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x84]

s_max_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x84]

s_max_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x84,0x56,0x34,0x12,0xaf]

s_cselect_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x85]

s_cselect_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x85]

s_cselect_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x85]

s_cselect_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x85]

s_cselect_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x85]

s_cselect_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x85]

s_cselect_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x85]

s_cselect_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x85]

s_cselect_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x85]

s_cselect_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x85]

s_cselect_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x85]

s_cselect_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x85]

s_cselect_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x85]

s_cselect_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x85]

s_cselect_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x85]

s_cselect_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x85]

s_cselect_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x85]

s_cselect_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x85]

s_cselect_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x85]

s_cselect_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x85]

s_cselect_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x85]

s_cselect_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x85]

s_cselect_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x85]

s_cselect_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x85]

s_cselect_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x85]

s_cselect_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x85]

s_cselect_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x85]

s_cselect_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x85]

s_cselect_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x85]

s_cselect_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x85]

s_cselect_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x85]

s_cselect_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x85]

s_cselect_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x85]

s_cselect_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x85]

s_cselect_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x85]

s_cselect_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x85]

s_cselect_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x85]

s_cselect_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x85]

s_cselect_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x85]

s_cselect_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x85]

s_cselect_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x85]

s_cselect_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x85]

s_cselect_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x85]

s_cselect_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x85]

s_cselect_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x85]

s_cselect_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x85]

s_cselect_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x85]

s_cselect_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x85,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x87]

s_and_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x87]

s_and_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x87]

s_and_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x87]

s_and_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x87]

s_and_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x87]

s_and_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x87]

s_and_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x87]

s_and_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x87]

s_and_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x87]

s_and_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x87]

s_and_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x87]

s_and_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x87]

s_and_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x87]

s_and_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x87]

s_and_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x87]

s_and_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x87]

s_and_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x87]

s_and_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x87]

s_and_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x87]

s_and_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x87]

s_and_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x87]

s_and_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x87,0x73,0x72,0x71,0x3f]

s_and_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x87,0x56,0x34,0x12,0xaf]

s_and_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x87]

s_and_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x87]

s_and_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x87]

s_and_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x87]

s_and_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x87]

s_and_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x87]

s_and_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x87]

s_and_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x87]

s_and_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x87]

s_and_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x87,0x73,0x72,0x71,0x3f]

s_and_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x87,0x56,0x34,0x12,0xaf]

s_and_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x87]

s_and_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x87]

s_and_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x87]

s_and_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x87]

s_and_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x87]

s_and_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x87]

s_and_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x87]

s_and_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x87]

s_and_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x87]

s_and_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x87]

s_and_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x87]

s_and_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x87]

s_and_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x87]

s_and_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x87]

s_and_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x87]

s_and_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x87]

s_and_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x87,0x73,0x72,0x71,0x3f]

s_and_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x87,0x56,0x34,0x12,0xaf]

s_and_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x87]

s_and_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x87]

s_and_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x87]

s_and_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x87]

s_and_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x87]

s_and_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x87]

s_and_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x87,0x73,0x72,0x71,0x3f]

s_and_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x87,0x56,0x34,0x12,0xaf]

s_or_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x88]

s_or_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x88]

s_or_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x88]

s_or_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x88]

s_or_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x88]

s_or_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x88]

s_or_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x88]

s_or_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x88]

s_or_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x88]

s_or_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x88]

s_or_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x88]

s_or_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x88]

s_or_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x88]

s_or_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x88]

s_or_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x88]

s_or_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x88]

s_or_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x88]

s_or_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x88]

s_or_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x88]

s_or_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x88]

s_or_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x88]

s_or_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x88]

s_or_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x88,0x73,0x72,0x71,0x3f]

s_or_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x88,0x56,0x34,0x12,0xaf]

s_or_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x88]

s_or_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x88]

s_or_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x88]

s_or_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x88]

s_or_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x88]

s_or_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x88]

s_or_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x88]

s_or_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x88]

s_or_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x88]

s_or_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x88,0x73,0x72,0x71,0x3f]

s_or_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x88,0x56,0x34,0x12,0xaf]

s_or_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x88]

s_or_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x88]

s_or_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x88]

s_or_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x88]

s_or_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x88]

s_or_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x88]

s_or_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x88]

s_or_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x88]

s_or_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x88]

s_or_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x88]

s_or_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x88]

s_or_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x88]

s_or_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x88]

s_or_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x88]

s_or_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x88]

s_or_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x88]

s_or_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x88,0x73,0x72,0x71,0x3f]

s_or_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x88,0x56,0x34,0x12,0xaf]

s_or_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x88]

s_or_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x88]

s_or_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x88]

s_or_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x88]

s_or_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x88]

s_or_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x88]

s_or_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x88,0x73,0x72,0x71,0x3f]

s_or_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x88,0x56,0x34,0x12,0xaf]

s_xor_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x89]

s_xor_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x89]

s_xor_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x89]

s_xor_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x89]

s_xor_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x89]

s_xor_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x89]

s_xor_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x89]

s_xor_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x89]

s_xor_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x89]

s_xor_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x89]

s_xor_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x89]

s_xor_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x89]

s_xor_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x89]

s_xor_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x89]

s_xor_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x89]

s_xor_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x89]

s_xor_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x89]

s_xor_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x89]

s_xor_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x89]

s_xor_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x89]

s_xor_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x89]

s_xor_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x89]

s_xor_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x89,0x73,0x72,0x71,0x3f]

s_xor_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x89,0x56,0x34,0x12,0xaf]

s_xor_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x89]

s_xor_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x89]

s_xor_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x89]

s_xor_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x89]

s_xor_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x89]

s_xor_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x89]

s_xor_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x89]

s_xor_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x89]

s_xor_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x89]

s_xor_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x89,0x73,0x72,0x71,0x3f]

s_xor_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x89,0x56,0x34,0x12,0xaf]

s_xor_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x89]

s_xor_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x89]

s_xor_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x89]

s_xor_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x89]

s_xor_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x89]

s_xor_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x89]

s_xor_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x89]

s_xor_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x89]

s_xor_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x89]

s_xor_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x89]

s_xor_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x89]

s_xor_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x89]

s_xor_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x89]

s_xor_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x89]

s_xor_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x89]

s_xor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x89,0x73,0x72,0x71,0x3f]

s_xor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x89,0x56,0x34,0x12,0xaf]

s_xor_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x89]

s_xor_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x89,0x73,0x72,0x71,0x3f]

s_xor_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x89,0x56,0x34,0x12,0xaf]

s_andn2_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8a]

s_andn2_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8a]

s_andn2_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8a]

s_andn2_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8a]

s_andn2_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8a]

s_andn2_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8a]

s_andn2_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8a]

s_andn2_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8a]

s_andn2_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8a]

s_andn2_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8a]

s_andn2_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8a]

s_andn2_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8a]

s_andn2_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8a]

s_andn2_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8a]

s_andn2_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8a]

s_andn2_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8a]

s_andn2_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8a]

s_andn2_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8a]

s_andn2_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8a]

s_andn2_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8a]

s_andn2_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8a]

s_andn2_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8a]

s_andn2_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8a]

s_andn2_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8a]

s_andn2_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8a]

s_andn2_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8a]

s_andn2_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8a]

s_andn2_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8a]

s_andn2_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8a]

s_andn2_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8a]

s_andn2_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8a]

s_andn2_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8a]

s_andn2_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8a]

s_andn2_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8a]

s_andn2_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8a]

s_andn2_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8a]

s_andn2_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8a]

s_andn2_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8a]

s_andn2_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8a]

s_andn2_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8a]

s_andn2_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8a]

s_andn2_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8a]

s_andn2_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8a,0x56,0x34,0x12,0xaf]

s_orn2_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8b]

s_orn2_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8b]

s_orn2_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8b]

s_orn2_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8b]

s_orn2_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8b]

s_orn2_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8b]

s_orn2_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8b]

s_orn2_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8b]

s_orn2_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8b]

s_orn2_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8b]

s_orn2_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8b]

s_orn2_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8b]

s_orn2_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8b]

s_orn2_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8b]

s_orn2_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8b]

s_orn2_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8b]

s_orn2_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8b]

s_orn2_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8b]

s_orn2_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8b]

s_orn2_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8b]

s_orn2_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8b]

s_orn2_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8b]

s_orn2_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8b]

s_orn2_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8b]

s_orn2_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8b]

s_orn2_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8b]

s_orn2_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8b]

s_orn2_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8b]

s_orn2_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8b]

s_orn2_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8b]

s_orn2_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8b]

s_orn2_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8b]

s_orn2_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8b]

s_orn2_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8b]

s_orn2_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8b]

s_orn2_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8b]

s_orn2_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8b]

s_orn2_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8b]

s_orn2_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8b]

s_orn2_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8b]

s_orn2_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8b]

s_orn2_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8b]

s_orn2_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8b,0x56,0x34,0x12,0xaf]

s_nand_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8c]

s_nand_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8c]

s_nand_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8c]

s_nand_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8c]

s_nand_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8c]

s_nand_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8c]

s_nand_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8c]

s_nand_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8c]

s_nand_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8c]

s_nand_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8c]

s_nand_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8c]

s_nand_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8c]

s_nand_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8c]

s_nand_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8c]

s_nand_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8c]

s_nand_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8c]

s_nand_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8c]

s_nand_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8c]

s_nand_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8c]

s_nand_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8c]

s_nand_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8c]

s_nand_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8c]

s_nand_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8c]

s_nand_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8c]

s_nand_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8c]

s_nand_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8c]

s_nand_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8c]

s_nand_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8c]

s_nand_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8c]

s_nand_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8c]

s_nand_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8c]

s_nand_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8c]

s_nand_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8c]

s_nand_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8c]

s_nand_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8c]

s_nand_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8c]

s_nand_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8c]

s_nand_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8c]

s_nand_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8c]

s_nand_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8c]

s_nand_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8c]

s_nand_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8c]

s_nand_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8c]

s_nand_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8c]

s_nand_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8c]

s_nand_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8c]

s_nand_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8c]

s_nand_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8c,0x56,0x34,0x12,0xaf]

s_nor_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8d]

s_nor_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8d]

s_nor_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8d]

s_nor_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8d]

s_nor_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8d]

s_nor_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8d]

s_nor_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8d]

s_nor_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8d]

s_nor_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8d]

s_nor_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8d]

s_nor_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8d]

s_nor_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8d]

s_nor_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8d]

s_nor_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8d]

s_nor_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8d]

s_nor_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8d]

s_nor_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8d]

s_nor_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8d]

s_nor_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8d]

s_nor_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8d]

s_nor_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8d]

s_nor_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8d]

s_nor_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8d]

s_nor_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8d]

s_nor_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8d]

s_nor_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8d]

s_nor_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8d]

s_nor_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8d]

s_nor_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8d]

s_nor_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8d]

s_nor_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8d]

s_nor_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8d]

s_nor_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8d]

s_nor_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8d]

s_nor_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8d]

s_nor_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8d]

s_nor_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8d]

s_nor_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8d]

s_nor_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8d]

s_nor_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8d]

s_nor_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8d]

s_nor_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8d]

s_nor_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8d]

s_nor_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8d]

s_nor_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8d]

s_nor_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8d]

s_nor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8d]

s_nor_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8d,0x56,0x34,0x12,0xaf]

s_xnor_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8e]

s_xnor_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8e]

s_xnor_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8e]

s_xnor_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8e]

s_xnor_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8e]

s_xnor_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8e]

s_xnor_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8e]

s_xnor_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8e]

s_xnor_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8e]

s_xnor_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8e]

s_xnor_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8e]

s_xnor_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8e]

s_xnor_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8e]

s_xnor_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8e]

s_xnor_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8e]

s_xnor_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8e]

s_xnor_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8e]

s_xnor_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8e]

s_xnor_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8e]

s_xnor_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8e]

s_xnor_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8e]

s_xnor_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8e]

s_xnor_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8e]

s_xnor_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8e]

s_xnor_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8e]

s_xnor_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8e]

s_xnor_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8e]

s_xnor_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8e]

s_xnor_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8e]

s_xnor_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8e]

s_xnor_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8e]

s_xnor_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[0:1], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0x80,0x8e]

s_xnor_b64 s[104:105], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0xe8,0x8e]

s_xnor_b64 s[0:1], s[102:103], s[100:101]
// GFX10: encoding: [0x66,0x64,0x80,0x8e]

s_xnor_b64 s[104:105], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0xe8,0x8e]

s_xnor_b64 s[104:105], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0xe8,0x8e]

s_xnor_b64 s[104:105], s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xe8,0x8e]

s_xnor_b64 s[0:1], s[102:103], s[4:5]
// GFX10: encoding: [0x66,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], s[100:101]
// GFX10: encoding: [0x02,0x64,0x80,0x8e]

s_xnor_b64 exec, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xfe,0x8e]

s_xnor_b64 vcc, s[2:3], s[4:5]
// GFX10: encoding: [0x02,0x04,0xea,0x8e]

s_xnor_b64 s[0:1], exec, s[4:5]
// GFX10: encoding: [0x7e,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], vcc, s[4:5]
// GFX10: encoding: [0x6a,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], 0, s[4:5]
// GFX10: encoding: [0x80,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], -1, s[4:5]
// GFX10: encoding: [0xc1,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], 0.5, s[4:5]
// GFX10: encoding: [0xf0,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], -4.0, s[4:5]
// GFX10: encoding: [0xf7,0x04,0x80,0x8e]

s_xnor_b64 s[0:1], 0x3f717273, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[0:1], 0xaf123456, s[4:5]
// GFX10: encoding: [0xff,0x04,0x80,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[0:1], s[2:3], exec
// GFX10: encoding: [0x02,0x7e,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], vcc
// GFX10: encoding: [0x02,0x6a,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8e]

s_xnor_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8e,0x56,0x34,0x12,0xaf]

s_lshl_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x8f]

s_lshl_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x8f]

s_lshl_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x8f]

s_lshl_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x8f]

s_lshl_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x8f]

s_lshl_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x8f]

s_lshl_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x8f]

s_lshl_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x8f]

s_lshl_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x8f]

s_lshl_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x8f]

s_lshl_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x8f]

s_lshl_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x8f]

s_lshl_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x8f]

s_lshl_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x8f]

s_lshl_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x8f]

s_lshl_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x8f]

s_lshl_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x8f]

s_lshl_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x8f]

s_lshl_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x8f]

s_lshl_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x8f]

s_lshl_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x8f]

s_lshl_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x8f]

s_lshl_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x8f]

s_lshl_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x8f]

s_lshl_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x8f]

s_lshl_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x8f]

s_lshl_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x8f]

s_lshl_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x8f]

s_lshl_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x8f]

s_lshl_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x8f]

s_lshl_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x8f]

s_lshl_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x8f]

s_lshl_b64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x8f]

s_lshl_b64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x8f]

s_lshl_b64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x8f]

s_lshl_b64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x8f]

s_lshl_b64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x8f]

s_lshl_b64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x8f]

s_lshl_b64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x8f]

s_lshl_b64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x8f]

s_lshl_b64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x8f]

s_lshl_b64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x8f]

s_lshl_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x8f,0x56,0x34,0x12,0xaf]

s_lshr_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x90]

s_lshr_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x90]

s_lshr_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x90]

s_lshr_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x90]

s_lshr_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x90]

s_lshr_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x90]

s_lshr_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x90]

s_lshr_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x90]

s_lshr_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x90]

s_lshr_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x90]

s_lshr_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x90]

s_lshr_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x90]

s_lshr_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x90]

s_lshr_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x90]

s_lshr_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x90]

s_lshr_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x90]

s_lshr_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x90]

s_lshr_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x90]

s_lshr_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x90]

s_lshr_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x90]

s_lshr_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x90]

s_lshr_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x90]

s_lshr_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x90]

s_lshr_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x90]

s_lshr_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x90]

s_lshr_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x90]

s_lshr_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x90]

s_lshr_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x90]

s_lshr_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x90]

s_lshr_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x90]

s_lshr_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x90]

s_lshr_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x90]

s_lshr_b64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x90]

s_lshr_b64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x90]

s_lshr_b64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x90]

s_lshr_b64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x90]

s_lshr_b64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x90]

s_lshr_b64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x90]

s_lshr_b64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x90]

s_lshr_b64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x90]

s_lshr_b64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x90]

s_lshr_b64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x90]

s_lshr_b64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x90]

s_lshr_b64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x90]

s_lshr_b64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x90]

s_lshr_b64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x90]

s_lshr_b64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x90]

s_lshr_b64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x90,0x56,0x34,0x12,0xaf]

s_ashr_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x91]

s_ashr_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x91]

s_ashr_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x91]

s_ashr_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x91]

s_ashr_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x91]

s_ashr_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x91]

s_ashr_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x91]

s_ashr_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x91]

s_ashr_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x91]

s_ashr_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x91]

s_ashr_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x91]

s_ashr_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x91]

s_ashr_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x91]

s_ashr_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x91]

s_ashr_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x91]

s_ashr_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x91]

s_ashr_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x91]

s_ashr_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x91]

s_ashr_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x91]

s_ashr_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x91]

s_ashr_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x91]

s_ashr_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x91]

s_ashr_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x91]

s_ashr_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x91]

s_ashr_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x91]

s_ashr_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x91]

s_ashr_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x91]

s_ashr_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x91]

s_ashr_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x91]

s_ashr_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x91]

s_ashr_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x91]

s_ashr_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x91]

s_ashr_i64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x91]

s_ashr_i64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x91]

s_ashr_i64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x91]

s_ashr_i64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x91]

s_ashr_i64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x91]

s_ashr_i64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x91]

s_ashr_i64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x91]

s_ashr_i64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x91]

s_ashr_i64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x91]

s_ashr_i64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x91]

s_ashr_i64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x91]

s_ashr_i64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x91]

s_ashr_i64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x91]

s_ashr_i64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x91]

s_ashr_i64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x91]

s_ashr_i64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x91,0x56,0x34,0x12,0xaf]

s_bfm_b32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x92]

s_bfm_b32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x92]

s_bfm_b32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x92]

s_bfm_b32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x92]

s_bfm_b32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x92]

s_bfm_b32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x92]

s_bfm_b32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x92]

s_bfm_b32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x92]

s_bfm_b32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x92]

s_bfm_b32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x92]

s_bfm_b32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x92]

s_bfm_b32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x92]

s_bfm_b32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x92]

s_bfm_b32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x92]

s_bfm_b32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x92]

s_bfm_b32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x92]

s_bfm_b32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x92]

s_bfm_b32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x92]

s_bfm_b32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x92]

s_bfm_b32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x92]

s_bfm_b32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x92]

s_bfm_b32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x92]

s_bfm_b32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x92]

s_bfm_b32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x92]

s_bfm_b32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x92]

s_bfm_b32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x92]

s_bfm_b32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x92]

s_bfm_b32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x92]

s_bfm_b32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x92]

s_bfm_b32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x92]

s_bfm_b32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x92]

s_bfm_b32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[0:1], s2, s3
// GFX10: encoding: [0x02,0x03,0x80,0x92]

s_bfm_b64 s[104:105], s103, s102
// GFX10: encoding: [0x67,0x66,0xe8,0x92]

s_bfm_b64 s[0:1], s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x92]

s_bfm_b64 s[104:105], s2, s103
// GFX10: encoding: [0x02,0x67,0xe8,0x92]

s_bfm_b64 s[104:105], s104, s3
// GFX10: encoding: [0x68,0x03,0xe8,0x92]

s_bfm_b64 s[104:105], s2, s3
// GFX10: encoding: [0x02,0x03,0xe8,0x92]

s_bfm_b64 s[0:1], s104, s3
// GFX10: encoding: [0x68,0x03,0x80,0x92]

s_bfm_b64 s[0:1], s2, s103
// GFX10: encoding: [0x02,0x67,0x80,0x92]

s_bfm_b64 exec, s2, s3
// GFX10: encoding: [0x02,0x03,0xfe,0x92]

s_bfm_b64 vcc, s2, s3
// GFX10: encoding: [0x02,0x03,0xea,0x92]

s_bfm_b64 s[0:1], exec_lo, s3
// GFX10: encoding: [0x7e,0x03,0x80,0x92]

s_bfm_b64 s[0:1], exec_hi, s3
// GFX10: encoding: [0x7f,0x03,0x80,0x92]

s_bfm_b64 s[0:1], vcc_lo, s3
// GFX10: encoding: [0x6a,0x03,0x80,0x92]

s_bfm_b64 s[0:1], vcc_hi, s3
// GFX10: encoding: [0x6b,0x03,0x80,0x92]

s_bfm_b64 s[0:1], m0, s3
// GFX10: encoding: [0x7c,0x03,0x80,0x92]

s_bfm_b64 s[0:1], 0, s3
// GFX10: encoding: [0x80,0x03,0x80,0x92]

s_bfm_b64 s[0:1], -1, s3
// GFX10: encoding: [0xc1,0x03,0x80,0x92]

s_bfm_b64 s[0:1], 0.5, s3
// GFX10: encoding: [0xf0,0x03,0x80,0x92]

s_bfm_b64 s[0:1], -4.0, s3
// GFX10: encoding: [0xf7,0x03,0x80,0x92]

s_bfm_b64 s[0:1], 0x3f717273, s3
// GFX10: encoding: [0xff,0x03,0x80,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[0:1], 0xaf123456, s3
// GFX10: encoding: [0xff,0x03,0x80,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[0:1], s2, exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x92]

s_bfm_b64 s[0:1], s2, exec_hi
// GFX10: encoding: [0x02,0x7f,0x80,0x92]

s_bfm_b64 s[0:1], s2, vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x92]

s_bfm_b64 s[0:1], s2, vcc_hi
// GFX10: encoding: [0x02,0x6b,0x80,0x92]

s_bfm_b64 s[0:1], s2, m0
// GFX10: encoding: [0x02,0x7c,0x80,0x92]

s_bfm_b64 s[0:1], s2, 0
// GFX10: encoding: [0x02,0x80,0x80,0x92]

s_bfm_b64 s[0:1], s2, -1
// GFX10: encoding: [0x02,0xc1,0x80,0x92]

s_bfm_b64 s[0:1], s2, 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x92]

s_bfm_b64 s[0:1], s2, -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x92]

s_bfm_b64 s[0:1], s2, 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[0:1], s2, 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x92,0x56,0x34,0x12,0xaf]

s_mul_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x93]

s_mul_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x93]

s_mul_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x93]

s_mul_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x93]

s_mul_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x93]

s_mul_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x93]

s_mul_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x93]

s_mul_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x93]

s_mul_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x93]

s_mul_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x93]

s_mul_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x93]

s_mul_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x93]

s_mul_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x93]

s_mul_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x93]

s_mul_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x93]

s_mul_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x93]

s_mul_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x93]

s_mul_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x93]

s_mul_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x93]

s_mul_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x93]

s_mul_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x93]

s_mul_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x93]

s_mul_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x93,0x73,0x72,0x71,0x3f]

s_mul_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x93,0x56,0x34,0x12,0xaf]

s_mul_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x93]

s_mul_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x93]

s_mul_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x93]

s_mul_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x93]

s_mul_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x93]

s_mul_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x93]

s_mul_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x93]

s_mul_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x93]

s_mul_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x93]

s_mul_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x93,0x73,0x72,0x71,0x3f]

s_mul_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x93]

s_bfe_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x93]

s_bfe_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x93]

s_bfe_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x93]

s_bfe_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x93]

s_bfe_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x93]

s_bfe_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x93]

s_bfe_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x93]

s_bfe_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x93]

s_bfe_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x93]

s_bfe_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x93]

s_bfe_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x93]

s_bfe_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x93]

s_bfe_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x93]

s_bfe_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x93]

s_bfe_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x93]

s_bfe_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x93]

s_bfe_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x93]

s_bfe_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x93]

s_bfe_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x93]

s_bfe_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x93]

s_bfe_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x93]

s_bfe_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x93]

s_bfe_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x93]

s_bfe_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x93]

s_bfe_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x93]

s_bfe_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x93]

s_bfe_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x93]

s_bfe_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x93]

s_bfe_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x93]

s_bfe_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x93]

s_bfe_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x93,0x56,0x34,0x12,0xaf]

s_bfe_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x94]

s_bfe_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x94]

s_bfe_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x94]

s_bfe_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x94]

s_bfe_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x94]

s_bfe_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x94]

s_bfe_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x94]

s_bfe_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x94]

s_bfe_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x94]

s_bfe_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x94]

s_bfe_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x94]

s_bfe_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x94]

s_bfe_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x94]

s_bfe_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x94]

s_bfe_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x94]

s_bfe_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x94]

s_bfe_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x94]

s_bfe_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x94]

s_bfe_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x94]

s_bfe_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x94]

s_bfe_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x94]

s_bfe_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x94]

s_bfe_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x94]

s_bfe_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x94]

s_bfe_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x94]

s_bfe_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x94]

s_bfe_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x94]

s_bfe_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x94]

s_bfe_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x94]

s_bfe_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x94]

s_bfe_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x94]

s_bfe_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x80,0x94]

s_bfe_u64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0xe8,0x94]

s_bfe_u64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x80,0x94]

s_bfe_u64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0xe8,0x94]

s_bfe_u64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0xe8,0x94]

s_bfe_u64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xe8,0x94]

s_bfe_u64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x80,0x94]

s_bfe_u64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xfe,0x94]

s_bfe_u64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0xea,0x94]

s_bfe_u64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x80,0x94]

s_bfe_u64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x80,0x94]

s_bfe_u64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x80,0x94]

s_bfe_u64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x80,0x94]

s_bfe_u64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x80,0x94]

s_bfe_u64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x80,0x94]

s_bfe_u64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x80,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x80,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x80,0x94]

s_bfe_u64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x80,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x80,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[0:1], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x00,0x95]

s_bfe_i64 s[104:105], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x68,0x95]

s_bfe_i64 s[0:1], s[102:103], s100
// GFX10: encoding: [0x66,0x64,0x00,0x95]

s_bfe_i64 s[104:105], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x68,0x95]

s_bfe_i64 s[104:105], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x68,0x95]

s_bfe_i64 s[104:105], s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x68,0x95]

s_bfe_i64 s[0:1], s[102:103], s4
// GFX10: encoding: [0x66,0x04,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], s100
// GFX10: encoding: [0x02,0x64,0x00,0x95]

s_bfe_i64 exec, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x7e,0x95]

s_bfe_i64 vcc, s[2:3], s4
// GFX10: encoding: [0x02,0x04,0x6a,0x95]

s_bfe_i64 s[0:1], exec, s4
// GFX10: encoding: [0x7e,0x04,0x00,0x95]

s_bfe_i64 s[0:1], vcc, s4
// GFX10: encoding: [0x6a,0x04,0x00,0x95]

s_bfe_i64 s[0:1], 0, s4
// GFX10: encoding: [0x80,0x04,0x00,0x95]

s_bfe_i64 s[0:1], -1, s4
// GFX10: encoding: [0xc1,0x04,0x00,0x95]

s_bfe_i64 s[0:1], 0.5, s4
// GFX10: encoding: [0xf0,0x04,0x00,0x95]

s_bfe_i64 s[0:1], -4.0, s4
// GFX10: encoding: [0xf7,0x04,0x00,0x95]

s_bfe_i64 s[0:1], 0x3f717273, s4
// GFX10: encoding: [0xff,0x04,0x00,0x95,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[0:1], 0xaf123456, s4
// GFX10: encoding: [0xff,0x04,0x00,0x95,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[0:1], s[2:3], exec_lo
// GFX10: encoding: [0x02,0x7e,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], vcc_lo
// GFX10: encoding: [0x02,0x6a,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], 0
// GFX10: encoding: [0x02,0x80,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], -1
// GFX10: encoding: [0x02,0xc1,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], 0.5
// GFX10: encoding: [0x02,0xf0,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], -4.0
// GFX10: encoding: [0x02,0xf7,0x00,0x95]

s_bfe_i64 s[0:1], s[2:3], 0x3f717273
// GFX10: encoding: [0x02,0xff,0x00,0x95,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[0:1], s[2:3], 0xaf123456
// GFX10: encoding: [0x02,0xff,0x00,0x95,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x96]

s_absdiff_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x96]

s_absdiff_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x96]

s_absdiff_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x96]

s_absdiff_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x96]

s_absdiff_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x96]

s_absdiff_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x96]

s_absdiff_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x96]

s_absdiff_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x96]

s_absdiff_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x96]

s_absdiff_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x96]

s_absdiff_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x96]

s_absdiff_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x96]

s_absdiff_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x96]

s_absdiff_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x96]

s_absdiff_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x96]

s_absdiff_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x96]

s_absdiff_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x96]

s_absdiff_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x96]

s_absdiff_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x96]

s_absdiff_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x96]

s_absdiff_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x96]

s_absdiff_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x96,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x96,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x96]

s_absdiff_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x96]

s_absdiff_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x96]

s_absdiff_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x96]

s_absdiff_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x96]

s_absdiff_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x96]

s_absdiff_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x96]

s_absdiff_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x96]

s_absdiff_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x96]

s_absdiff_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x96,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x96,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x97]

s_lshl1_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x97]

s_lshl1_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x97]

s_lshl1_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x97]

s_lshl1_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x97]

s_lshl1_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x97]

s_lshl1_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x97]

s_lshl1_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x97]

s_lshl1_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x97]

s_lshl1_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x97]

s_lshl1_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x97]

s_lshl1_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x97]

s_lshl1_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x97]

s_lshl1_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x97]

s_lshl1_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x97]

s_lshl1_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x97]

s_lshl1_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x97]

s_lshl1_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x97]

s_lshl1_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x97]

s_lshl1_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x97]

s_lshl1_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x97]

s_lshl1_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x97]

s_lshl1_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x97,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x97,0x56,0x34,0x12,0xaf]

s_lshl1_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x97]

s_lshl1_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x97]

s_lshl1_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x97]

s_lshl1_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x97]

s_lshl1_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x97]

s_lshl1_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x97]

s_lshl1_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x97]

s_lshl1_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x97]

s_lshl1_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x97]

s_lshl1_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x97,0x73,0x72,0x71,0x3f]

s_lshl1_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x97,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x97]

s_lshl2_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x97]

s_lshl2_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x97]

s_lshl2_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x97]

s_lshl2_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x97]

s_lshl2_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x97]

s_lshl2_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x97]

s_lshl2_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x97]

s_lshl2_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x97]

s_lshl2_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x97]

s_lshl2_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x97]

s_lshl2_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x97]

s_lshl2_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x97]

s_lshl2_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x97]

s_lshl2_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x97]

s_lshl2_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x97]

s_lshl2_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x97]

s_lshl2_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x97]

s_lshl2_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x97]

s_lshl2_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x97]

s_lshl2_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x97]

s_lshl2_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x97]

s_lshl2_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x97,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x97,0x56,0x34,0x12,0xaf]

s_lshl2_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x97]

s_lshl2_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x97]

s_lshl2_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x97]

s_lshl2_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x97]

s_lshl2_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x97]

s_lshl2_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x97]

s_lshl2_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x97]

s_lshl2_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x97]

s_lshl2_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x97]

s_lshl2_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x97,0x73,0x72,0x71,0x3f]

s_lshl2_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x97,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x98]

s_lshl3_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x98]

s_lshl3_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x98]

s_lshl3_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x98]

s_lshl3_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x98]

s_lshl3_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x98]

s_lshl3_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x98]

s_lshl3_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x98]

s_lshl3_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x98]

s_lshl3_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x98]

s_lshl3_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x98]

s_lshl3_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x98]

s_lshl3_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x98]

s_lshl3_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x98]

s_lshl3_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x98]

s_lshl3_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x98]

s_lshl3_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x98]

s_lshl3_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x98]

s_lshl3_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x98]

s_lshl3_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x98]

s_lshl3_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x98]

s_lshl3_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x98]

s_lshl3_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x98,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x98,0x56,0x34,0x12,0xaf]

s_lshl3_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x98]

s_lshl3_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x98]

s_lshl3_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x98]

s_lshl3_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x98]

s_lshl3_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x98]

s_lshl3_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x98]

s_lshl3_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x98]

s_lshl3_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x98]

s_lshl3_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x98]

s_lshl3_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x98,0x73,0x72,0x71,0x3f]

s_lshl3_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x98,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x98]

s_lshl4_add_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x98]

s_lshl4_add_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x98]

s_lshl4_add_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x98]

s_lshl4_add_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x98]

s_lshl4_add_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x98]

s_lshl4_add_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x98]

s_lshl4_add_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x98]

s_lshl4_add_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x98]

s_lshl4_add_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x98]

s_lshl4_add_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x98]

s_lshl4_add_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x98]

s_lshl4_add_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x98]

s_lshl4_add_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x98]

s_lshl4_add_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x98]

s_lshl4_add_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x98]

s_lshl4_add_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x98]

s_lshl4_add_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x98]

s_lshl4_add_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x98]

s_lshl4_add_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x98]

s_lshl4_add_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x98]

s_lshl4_add_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x98]

s_lshl4_add_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x98,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x98,0x56,0x34,0x12,0xaf]

s_lshl4_add_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x98]

s_lshl4_add_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x98]

s_lshl4_add_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x98]

s_lshl4_add_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x98]

s_lshl4_add_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x98]

s_lshl4_add_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x98]

s_lshl4_add_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x98]

s_lshl4_add_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x98]

s_lshl4_add_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x98]

s_lshl4_add_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x98,0x73,0x72,0x71,0x3f]

s_lshl4_add_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x98,0x56,0x34,0x12,0xaf]

s_pack_ll_b32_b16 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x99]

s_pack_ll_b32_b16 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x99]

s_pack_ll_b32_b16 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x99]

s_pack_ll_b32_b16 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x99]

s_pack_ll_b32_b16 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x99]

s_pack_ll_b32_b16 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x99]

s_pack_ll_b32_b16 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x99]

s_pack_ll_b32_b16 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x99]

s_pack_ll_b32_b16 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x99]

s_pack_ll_b32_b16 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x99]

s_pack_ll_b32_b16 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x99]

s_pack_ll_b32_b16 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x99]

s_pack_ll_b32_b16 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x99]

s_pack_ll_b32_b16 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x99,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x99,0x56,0x34,0x12,0xaf]

s_pack_ll_b32_b16 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x99]

s_pack_ll_b32_b16 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x99,0x73,0x72,0x71,0x3f]

s_pack_ll_b32_b16 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x99]

s_pack_lh_b32_b16 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x99]

s_pack_lh_b32_b16 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x99]

s_pack_lh_b32_b16 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x99]

s_pack_lh_b32_b16 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x99]

s_pack_lh_b32_b16 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x99]

s_pack_lh_b32_b16 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x99]

s_pack_lh_b32_b16 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x99]

s_pack_lh_b32_b16 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x99]

s_pack_lh_b32_b16 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x99]

s_pack_lh_b32_b16 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x99]

s_pack_lh_b32_b16 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x99]

s_pack_lh_b32_b16 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x99]

s_pack_lh_b32_b16 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x99,0x73,0x72,0x71,0x3f]

s_pack_lh_b32_b16 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x99,0x56,0x34,0x12,0xaf]

s_pack_lh_b32_b16 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x99]

s_pack_lh_b32_b16 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x99,0x73,0x72,0x71,0x3f]

s_pack_lh_b32_b16 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x99,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x9a]

s_pack_hh_b32_b16 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x9a]

s_pack_hh_b32_b16 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x9a]

s_pack_hh_b32_b16 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x9a]

s_pack_hh_b32_b16 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x9a]

s_pack_hh_b32_b16 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x9a]

s_pack_hh_b32_b16 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x9a]

s_pack_hh_b32_b16 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x9a]

s_pack_hh_b32_b16 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x9a]

s_pack_hh_b32_b16 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x9a]

s_pack_hh_b32_b16 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x9a]

s_pack_hh_b32_b16 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x9a]

s_pack_hh_b32_b16 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9a,0x56,0x34,0x12,0xaf]

s_pack_hh_b32_b16 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x9a]

s_pack_hh_b32_b16 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x9a,0x73,0x72,0x71,0x3f]

s_pack_hh_b32_b16 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x80,0x9a]

s_mul_hi_u32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0xe9,0x9a]

s_mul_hi_u32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x80,0x9a]

s_mul_hi_u32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0xe9,0x9a]

s_mul_hi_u32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0xe9,0x9a]

s_mul_hi_u32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0xe9,0x9a]

s_mul_hi_u32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x80,0x9a]

s_mul_hi_u32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x80,0x9a]

s_mul_hi_u32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xfe,0x9a]

s_mul_hi_u32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xff,0x9a]

s_mul_hi_u32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0xea,0x9a]

s_mul_hi_u32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0xeb,0x9a]

s_mul_hi_u32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0xfc,0x9a]

s_mul_hi_u32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x80,0x9a]

s_mul_hi_u32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x80,0x9a]

s_mul_hi_u32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x80,0x9a]

s_mul_hi_u32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x80,0x9a]

s_mul_hi_u32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x80,0x9a]

s_mul_hi_u32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x80,0x9a]

s_mul_hi_u32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x80,0x9a]

s_mul_hi_u32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x80,0x9a]

s_mul_hi_u32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x80,0x9a]

s_mul_hi_u32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x80,0x9a,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x80,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_u32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x80,0x9a]

s_mul_hi_u32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x80,0x9a]

s_mul_hi_u32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x80,0x9a]

s_mul_hi_u32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x80,0x9a]

s_mul_hi_u32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x80,0x9a]

s_mul_hi_u32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x80,0x9a]

s_mul_hi_u32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x80,0x9a]

s_mul_hi_u32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x80,0x9a]

s_mul_hi_u32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x80,0x9a]

s_mul_hi_u32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x80,0x9a,0x73,0x72,0x71,0x3f]

s_mul_hi_u32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x80,0x9a,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s0, s1, s2
// GFX10: encoding: [0x01,0x02,0x00,0x9b]

s_mul_hi_i32 s105, s104, s103
// GFX10: encoding: [0x68,0x67,0x69,0x9b]

s_mul_hi_i32 s0, s104, s103
// GFX10: encoding: [0x68,0x67,0x00,0x9b]

s_mul_hi_i32 s105, s1, s103
// GFX10: encoding: [0x01,0x67,0x69,0x9b]

s_mul_hi_i32 s105, s104, s2
// GFX10: encoding: [0x68,0x02,0x69,0x9b]

s_mul_hi_i32 s105, s1, s2
// GFX10: encoding: [0x01,0x02,0x69,0x9b]

s_mul_hi_i32 s0, s104, s2
// GFX10: encoding: [0x68,0x02,0x00,0x9b]

s_mul_hi_i32 s0, s1, s103
// GFX10: encoding: [0x01,0x67,0x00,0x9b]

s_mul_hi_i32 exec_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x7e,0x9b]

s_mul_hi_i32 exec_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x7f,0x9b]

s_mul_hi_i32 vcc_lo, s1, s2
// GFX10: encoding: [0x01,0x02,0x6a,0x9b]

s_mul_hi_i32 vcc_hi, s1, s2
// GFX10: encoding: [0x01,0x02,0x6b,0x9b]

s_mul_hi_i32 m0, s1, s2
// GFX10: encoding: [0x01,0x02,0x7c,0x9b]

s_mul_hi_i32 s0, exec_lo, s2
// GFX10: encoding: [0x7e,0x02,0x00,0x9b]

s_mul_hi_i32 s0, exec_hi, s2
// GFX10: encoding: [0x7f,0x02,0x00,0x9b]

s_mul_hi_i32 s0, vcc_lo, s2
// GFX10: encoding: [0x6a,0x02,0x00,0x9b]

s_mul_hi_i32 s0, vcc_hi, s2
// GFX10: encoding: [0x6b,0x02,0x00,0x9b]

s_mul_hi_i32 s0, m0, s2
// GFX10: encoding: [0x7c,0x02,0x00,0x9b]

s_mul_hi_i32 s0, 0, s2
// GFX10: encoding: [0x80,0x02,0x00,0x9b]

s_mul_hi_i32 s0, -1, s2
// GFX10: encoding: [0xc1,0x02,0x00,0x9b]

s_mul_hi_i32 s0, 0.5, s2
// GFX10: encoding: [0xf0,0x02,0x00,0x9b]

s_mul_hi_i32 s0, -4.0, s2
// GFX10: encoding: [0xf7,0x02,0x00,0x9b]

s_mul_hi_i32 s0, 0x3f717273, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9b,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s0, 0xaf123456, s2
// GFX10: encoding: [0xff,0x02,0x00,0x9b,0x56,0x34,0x12,0xaf]

s_mul_hi_i32 s0, s1, exec_lo
// GFX10: encoding: [0x01,0x7e,0x00,0x9b]

s_mul_hi_i32 s0, s1, exec_hi
// GFX10: encoding: [0x01,0x7f,0x00,0x9b]

s_mul_hi_i32 s0, s1, vcc_lo
// GFX10: encoding: [0x01,0x6a,0x00,0x9b]

s_mul_hi_i32 s0, s1, vcc_hi
// GFX10: encoding: [0x01,0x6b,0x00,0x9b]

s_mul_hi_i32 s0, s1, m0
// GFX10: encoding: [0x01,0x7c,0x00,0x9b]

s_mul_hi_i32 s0, s1, 0
// GFX10: encoding: [0x01,0x80,0x00,0x9b]

s_mul_hi_i32 s0, s1, -1
// GFX10: encoding: [0x01,0xc1,0x00,0x9b]

s_mul_hi_i32 s0, s1, 0.5
// GFX10: encoding: [0x01,0xf0,0x00,0x9b]

s_mul_hi_i32 s0, s1, -4.0
// GFX10: encoding: [0x01,0xf7,0x00,0x9b]

s_mul_hi_i32 s0, s1, 0x3f717273
// GFX10: encoding: [0x01,0xff,0x00,0x9b,0x73,0x72,0x71,0x3f]

s_mul_hi_i32 s0, s1, 0xaf123456
// GFX10: encoding: [0x01,0xff,0x00,0x9b,0x56,0x34,0x12,0xaf]

//===----------------------------------------------------------------------===//
// ENC_SOPC.
//===----------------------------------------------------------------------===//

s_cmp_eq_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x00,0xbf]

s_cmp_eq_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x00,0xbf]

s_cmp_eq_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x00,0xbf]

s_cmp_eq_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x00,0xbf]

s_cmp_eq_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x00,0xbf]

s_cmp_eq_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x00,0xbf]

s_cmp_eq_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x00,0xbf]

s_cmp_eq_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x00,0xbf]

s_cmp_eq_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x00,0xbf]

s_cmp_eq_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x00,0xbf]

s_cmp_eq_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x00,0xbf]

s_cmp_eq_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x00,0xbf]

s_cmp_eq_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x00,0xbf]

s_cmp_eq_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x01,0xbf]

s_cmp_lg_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x01,0xbf]

s_cmp_lg_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x01,0xbf]

s_cmp_lg_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x01,0xbf]

s_cmp_lg_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x01,0xbf]

s_cmp_lg_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x01,0xbf]

s_cmp_lg_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x01,0xbf]

s_cmp_lg_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x01,0xbf]

s_cmp_lg_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x01,0xbf]

s_cmp_lg_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x01,0xbf]

s_cmp_lg_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x01,0xbf]

s_cmp_lg_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x01,0xbf]

s_cmp_lg_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x01,0xbf]

s_cmp_lg_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x02,0xbf]

s_cmp_gt_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x02,0xbf]

s_cmp_gt_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x02,0xbf]

s_cmp_gt_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x02,0xbf]

s_cmp_gt_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x02,0xbf]

s_cmp_gt_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x02,0xbf]

s_cmp_gt_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x02,0xbf]

s_cmp_gt_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x02,0xbf]

s_cmp_gt_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x02,0xbf]

s_cmp_gt_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x02,0xbf]

s_cmp_gt_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x02,0xbf]

s_cmp_gt_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x02,0xbf]

s_cmp_gt_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x02,0xbf]

s_cmp_gt_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x03,0xbf]

s_cmp_ge_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x03,0xbf]

s_cmp_ge_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x03,0xbf]

s_cmp_ge_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x03,0xbf]

s_cmp_ge_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x03,0xbf]

s_cmp_ge_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x03,0xbf]

s_cmp_ge_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x03,0xbf]

s_cmp_ge_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x03,0xbf]

s_cmp_ge_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x03,0xbf]

s_cmp_ge_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x03,0xbf]

s_cmp_ge_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x03,0xbf]

s_cmp_ge_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x03,0xbf]

s_cmp_ge_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x03,0xbf]

s_cmp_ge_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x04,0xbf]

s_cmp_lt_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x04,0xbf]

s_cmp_lt_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x04,0xbf]

s_cmp_lt_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x04,0xbf]

s_cmp_lt_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x04,0xbf]

s_cmp_lt_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x04,0xbf]

s_cmp_lt_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x04,0xbf]

s_cmp_lt_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x04,0xbf]

s_cmp_lt_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x04,0xbf]

s_cmp_lt_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x04,0xbf]

s_cmp_lt_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x04,0xbf]

s_cmp_lt_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x04,0xbf]

s_cmp_lt_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x04,0xbf]

s_cmp_lt_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s0, s1
// GFX10: encoding: [0x00,0x01,0x05,0xbf]

s_cmp_le_i32 s105, s104
// GFX10: encoding: [0x69,0x68,0x05,0xbf]

s_cmp_le_i32 s0, s104
// GFX10: encoding: [0x00,0x68,0x05,0xbf]

s_cmp_le_i32 s105, s1
// GFX10: encoding: [0x69,0x01,0x05,0xbf]

s_cmp_le_i32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x05,0xbf]

s_cmp_le_i32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x05,0xbf]

s_cmp_le_i32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x05,0xbf]

s_cmp_le_i32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x05,0xbf]

s_cmp_le_i32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x05,0xbf]

s_cmp_le_i32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x05,0xbf]

s_cmp_le_i32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x05,0xbf]

s_cmp_le_i32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x05,0xbf]

s_cmp_le_i32 s0, 0
// GFX10: encoding: [0x00,0x80,0x05,0xbf]

s_cmp_le_i32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x05,0xbf]

s_cmp_le_i32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x05,0xbf]

s_cmp_le_i32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x05,0xbf]

s_cmp_le_i32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x06,0xbf]

s_cmp_eq_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x06,0xbf]

s_cmp_eq_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x06,0xbf]

s_cmp_eq_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x06,0xbf]

s_cmp_eq_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x06,0xbf]

s_cmp_eq_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x06,0xbf]

s_cmp_eq_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x06,0xbf]

s_cmp_eq_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x06,0xbf]

s_cmp_eq_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x06,0xbf]

s_cmp_eq_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x06,0xbf]

s_cmp_eq_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x06,0xbf]

s_cmp_eq_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x06,0xbf]

s_cmp_eq_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x06,0xbf]

s_cmp_eq_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x07,0xbf]

s_cmp_lg_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x07,0xbf]

s_cmp_lg_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x07,0xbf]

s_cmp_lg_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x07,0xbf]

s_cmp_lg_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x07,0xbf]

s_cmp_lg_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x07,0xbf]

s_cmp_lg_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x07,0xbf]

s_cmp_lg_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x07,0xbf]

s_cmp_lg_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x07,0xbf]

s_cmp_lg_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x07,0xbf]

s_cmp_lg_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x07,0xbf]

s_cmp_lg_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x07,0xbf]

s_cmp_lg_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x07,0xbf]

s_cmp_lg_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x08,0xbf]

s_cmp_gt_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x08,0xbf]

s_cmp_gt_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x08,0xbf]

s_cmp_gt_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x08,0xbf]

s_cmp_gt_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x08,0xbf]

s_cmp_gt_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x08,0xbf]

s_cmp_gt_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x08,0xbf]

s_cmp_gt_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x08,0xbf]

s_cmp_gt_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x08,0xbf]

s_cmp_gt_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x08,0xbf]

s_cmp_gt_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x08,0xbf]

s_cmp_gt_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x08,0xbf]

s_cmp_gt_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x08,0xbf]

s_cmp_gt_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x09,0xbf]

s_cmp_ge_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x09,0xbf]

s_cmp_ge_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x09,0xbf]

s_cmp_ge_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x09,0xbf]

s_cmp_ge_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x09,0xbf]

s_cmp_ge_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x09,0xbf]

s_cmp_ge_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x09,0xbf]

s_cmp_ge_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x09,0xbf]

s_cmp_ge_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x09,0xbf]

s_cmp_ge_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x09,0xbf]

s_cmp_ge_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x09,0xbf]

s_cmp_ge_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x09,0xbf]

s_cmp_ge_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x09,0xbf]

s_cmp_ge_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0a,0xbf]

s_cmp_lt_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0a,0xbf]

s_cmp_lt_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0a,0xbf]

s_cmp_lt_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0a,0xbf]

s_cmp_lt_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0a,0xbf]

s_cmp_lt_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0a,0xbf]

s_cmp_lt_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0b,0xbf]

s_cmp_le_u32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0b,0xbf]

s_cmp_le_u32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0b,0xbf]

s_cmp_le_u32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0b,0xbf]

s_cmp_le_u32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0b,0xbf]

s_cmp_le_u32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0b,0xbf]

s_cmp_le_u32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0b,0xbf]

s_cmp_le_u32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0b,0xbf]

s_cmp_le_u32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0b,0xbf]

s_cmp_le_u32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0b,0xbf]

s_cmp_le_u32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0b,0xbf]

s_cmp_le_u32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0b,0xbf]

s_cmp_le_u32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0b,0xbf]

s_cmp_le_u32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0c,0xbf]

s_bitcmp0_b32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0c,0xbf]

s_bitcmp0_b32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0c,0xbf]

s_bitcmp0_b32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0c,0xbf]

s_bitcmp0_b32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0c,0xbf]

s_bitcmp0_b32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0c,0xbf]

s_bitcmp0_b32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s0, s1
// GFX10: encoding: [0x00,0x01,0x0d,0xbf]

s_bitcmp1_b32 s105, s104
// GFX10: encoding: [0x69,0x68,0x0d,0xbf]

s_bitcmp1_b32 s0, s104
// GFX10: encoding: [0x00,0x68,0x0d,0xbf]

s_bitcmp1_b32 s105, s1
// GFX10: encoding: [0x69,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s1
// GFX10: encoding: [0x7e,0x01,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s1
// GFX10: encoding: [0x7f,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s1
// GFX10: encoding: [0x6a,0x01,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s1
// GFX10: encoding: [0x6b,0x01,0x0d,0xbf]

s_bitcmp1_b32 m0, s1
// GFX10: encoding: [0x7c,0x01,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_lo
// GFX10: encoding: [0x00,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s0, exec_hi
// GFX10: encoding: [0x00,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s0, vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s0, m0
// GFX10: encoding: [0x00,0x7c,0x0d,0xbf]

s_bitcmp1_b32 s0, 0
// GFX10: encoding: [0x00,0x80,0x0d,0xbf]

s_bitcmp1_b32 s0, -1
// GFX10: encoding: [0x00,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s0, 0.5
// GFX10: encoding: [0x00,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s0, -4.0
// GFX10: encoding: [0x00,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s0, 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s0, 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[0:1], s2
// GFX10: encoding: [0x00,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s102
// GFX10: encoding: [0x68,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], s102
// GFX10: encoding: [0x00,0x66,0x0e,0xbf]

s_bitcmp0_b64 s[104:105], s2
// GFX10: encoding: [0x68,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// GFX10: encoding: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// GFX10: encoding: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_lo
// GFX10: encoding: [0x00,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], exec_hi
// GFX10: encoding: [0x00,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], m0
// GFX10: encoding: [0x00,0x7c,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[0:1], s2
// GFX10: encoding: [0x00,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s102
// GFX10: encoding: [0x68,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], s102
// GFX10: encoding: [0x00,0x66,0x0f,0xbf]

s_bitcmp1_b64 s[104:105], s2
// GFX10: encoding: [0x68,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// GFX10: encoding: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// GFX10: encoding: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_lo
// GFX10: encoding: [0x00,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], exec_hi
// GFX10: encoding: [0x00,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_lo
// GFX10: encoding: [0x00,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], vcc_hi
// GFX10: encoding: [0x00,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], m0
// GFX10: encoding: [0x00,0x7c,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u64 s[0:1], s[2:3]
// GFX10: encoding: [0x00,0x02,0x12,0xbf]

s_cmp_eq_u64 s[104:105], s[102:103]
// GFX10: encoding: [0x68,0x66,0x12,0xbf]

s_cmp_eq_u64 s[0:1], s[102:103]
// GFX10: encoding: [0x00,0x66,0x12,0xbf]

s_cmp_eq_u64 s[104:105], s[2:3]
// GFX10: encoding: [0x68,0x02,0x12,0xbf]

s_cmp_eq_u64 exec, s[2:3]
// GFX10: encoding: [0x7e,0x02,0x12,0xbf]

s_cmp_eq_u64 vcc, s[2:3]
// GFX10: encoding: [0x6a,0x02,0x12,0xbf]

s_cmp_eq_u64 s[0:1], exec
// GFX10: encoding: [0x00,0x7e,0x12,0xbf]

s_cmp_eq_u64 s[0:1], vcc
// GFX10: encoding: [0x00,0x6a,0x12,0xbf]

s_cmp_eq_u64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x12,0xbf]

s_cmp_eq_u64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x12,0xbf]

s_cmp_eq_u64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x12,0xbf]

s_cmp_eq_u64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x12,0xbf]

s_cmp_eq_u64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x12,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x12,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u64 s[0:1], s[2:3]
// GFX10: encoding: [0x00,0x02,0x13,0xbf]

s_cmp_lg_u64 s[104:105], s[102:103]
// GFX10: encoding: [0x68,0x66,0x13,0xbf]

s_cmp_lg_u64 s[0:1], s[102:103]
// GFX10: encoding: [0x00,0x66,0x13,0xbf]

s_cmp_lg_u64 s[104:105], s[2:3]
// GFX10: encoding: [0x68,0x02,0x13,0xbf]

s_cmp_lg_u64 exec, s[2:3]
// GFX10: encoding: [0x7e,0x02,0x13,0xbf]

s_cmp_lg_u64 vcc, s[2:3]
// GFX10: encoding: [0x6a,0x02,0x13,0xbf]

s_cmp_lg_u64 s[0:1], exec
// GFX10: encoding: [0x00,0x7e,0x13,0xbf]

s_cmp_lg_u64 s[0:1], vcc
// GFX10: encoding: [0x00,0x6a,0x13,0xbf]

s_cmp_lg_u64 s[0:1], 0
// GFX10: encoding: [0x00,0x80,0x13,0xbf]

s_cmp_lg_u64 s[0:1], -1
// GFX10: encoding: [0x00,0xc1,0x13,0xbf]

s_cmp_lg_u64 s[0:1], 0.5
// GFX10: encoding: [0x00,0xf0,0x13,0xbf]

s_cmp_lg_u64 s[0:1], -4.0
// GFX10: encoding: [0x00,0xf7,0x13,0xbf]

s_cmp_lg_u64 s[0:1], 0x3f717273
// GFX10: encoding: [0x00,0xff,0x13,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u64 s[0:1], 0xaf123456
// GFX10: encoding: [0x00,0xff,0x13,0xbf,0x56,0x34,0x12,0xaf]

//===----------------------------------------------------------------------===//
// ENC_SOPK.
//===----------------------------------------------------------------------===//

s_movk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb0]

s_movk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb0]

s_movk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb0]

s_movk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb0]

s_movk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb0]

s_movk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb0]

s_movk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb0]

s_movk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb0]

s_version 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb0]

s_version 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb0]

s_cmovk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb1]

s_cmovk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb1]

s_cmovk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb1]

s_cmovk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb1]

s_cmovk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb1]

s_cmovk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb1]

s_cmovk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb1]

s_cmovk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb1]

s_cmpk_eq_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb1]

s_cmpk_eq_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb1]

s_cmpk_eq_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb1]

s_cmpk_eq_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb1]

s_cmpk_eq_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb1]

s_cmpk_eq_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb1]

s_cmpk_eq_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb1]

s_cmpk_eq_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb1]

s_cmpk_lg_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb2]

s_cmpk_lg_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb2]

s_cmpk_lg_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb2]

s_cmpk_lg_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb2]

s_cmpk_lg_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb2]

s_cmpk_lg_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb2]

s_cmpk_lg_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb2]

s_cmpk_lg_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb2]

s_cmpk_gt_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb2]

s_cmpk_gt_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb2]

s_cmpk_gt_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb2]

s_cmpk_gt_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb2]

s_cmpk_gt_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb2]

s_cmpk_gt_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb2]

s_cmpk_gt_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb2]

s_cmpk_gt_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb2]

s_cmpk_ge_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb3]

s_cmpk_ge_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb3]

s_cmpk_ge_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb3]

s_cmpk_ge_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb3]

s_cmpk_ge_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb3]

s_cmpk_ge_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb3]

s_cmpk_ge_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb3]

s_cmpk_ge_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb3]

s_cmpk_lt_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb3]

s_cmpk_lt_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb3]

s_cmpk_lt_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb3]

s_cmpk_lt_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb3]

s_cmpk_lt_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb3]

s_cmpk_lt_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb3]

s_cmpk_lt_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb3]

s_cmpk_lt_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb3]

s_cmpk_le_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb4]

s_cmpk_le_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb4]

s_cmpk_le_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb4]

s_cmpk_le_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb4]

s_cmpk_le_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb4]

s_cmpk_le_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb4]

s_cmpk_le_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb4]

s_cmpk_le_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb4]

s_cmpk_eq_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb4]

s_cmpk_eq_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb4]

s_cmpk_eq_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb4]

s_cmpk_eq_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb4]

s_cmpk_eq_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb4]

s_cmpk_eq_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb4]

s_cmpk_eq_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb4]

s_cmpk_eq_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb4]

s_cmpk_lg_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb5]

s_cmpk_lg_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb5]

s_cmpk_lg_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb5]

s_cmpk_lg_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb5]

s_cmpk_lg_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb5]

s_cmpk_lg_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb5]

s_cmpk_lg_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb5]

s_cmpk_lg_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb5]

s_cmpk_gt_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb5]

s_cmpk_gt_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb5]

s_cmpk_gt_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb5]

s_cmpk_gt_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb5]

s_cmpk_gt_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb5]

s_cmpk_gt_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb5]

s_cmpk_gt_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb5]

s_cmpk_gt_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb5]

s_cmpk_ge_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb6]

s_cmpk_ge_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb6]

s_cmpk_ge_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb6]

s_cmpk_ge_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb6]

s_cmpk_ge_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb6]

s_cmpk_ge_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb6]

s_cmpk_ge_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb6]

s_cmpk_ge_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb6]

s_cmpk_lt_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb6]

s_cmpk_lt_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb6]

s_cmpk_lt_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb6]

s_cmpk_lt_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb6]

s_cmpk_lt_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb6]

s_cmpk_lt_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb6]

s_cmpk_lt_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb6]

s_cmpk_lt_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb6]

s_cmpk_le_u32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb7]

s_cmpk_le_u32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb7]

s_cmpk_le_u32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb7]

s_cmpk_le_u32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb7]

s_cmpk_le_u32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb7]

s_cmpk_le_u32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb7]

s_cmpk_le_u32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb7]

s_cmpk_le_u32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb7]

s_addk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xb7]

s_addk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xb7]

s_addk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xb7]

s_addk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xb7]

s_addk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xb7]

s_addk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xb7]

s_addk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xb7]

s_addk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xb7]

s_mulk_i32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb8]

s_mulk_i32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb8]

s_mulk_i32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb8]

s_mulk_i32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb8]

s_mulk_i32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb8]

s_mulk_i32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb8]

s_mulk_i32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb8]

s_mulk_i32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb8]

s_getreg_b32 s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xb9]

s_getreg_b32 s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xb9]

s_getreg_b32 s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xb9]

s_getreg_b32 exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xb9]

s_getreg_b32 exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xb9]

s_getreg_b32 vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xb9]

s_getreg_b32 vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xb9]

s_getreg_b32 m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xb9]

s_setreg_b32 0x1234, s0
// GFX10: encoding: [0x34,0x12,0x80,0xb9]

s_setreg_b32 0xc1d1, s0
// GFX10: encoding: [0xd1,0xc1,0x80,0xb9]

s_setreg_b32 0x1234, s105
// GFX10: encoding: [0x34,0x12,0xe9,0xb9]

s_setreg_b32 0x1234, exec_lo
// GFX10: encoding: [0x34,0x12,0xfe,0xb9]

s_setreg_b32 0x1234, exec_hi
// GFX10: encoding: [0x34,0x12,0xff,0xb9]

s_setreg_b32 0x1234, vcc_lo
// GFX10: encoding: [0x34,0x12,0xea,0xb9]

s_setreg_b32 0x1234, vcc_hi
// GFX10: encoding: [0x34,0x12,0xeb,0xb9]

s_setreg_b32 0x1234, m0
// GFX10: encoding: [0x34,0x12,0xfc,0xb9]

s_setreg_imm32_b32 0x1234, 0x11213141
// GFX10: encoding: [0x34,0x12,0x80,0xba,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0xc1d1, 0x11213141
// GFX10: encoding: [0xd1,0xc1,0x80,0xba,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0x1234, 0xa1b1c1d1
// GFX10: encoding: [0x34,0x12,0x80,0xba,0xd1,0xc1,0xb1,0xa1]

s_setreg_imm32_b32 0xc1d1, 0xa1b1c1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xba,0xd1,0xc1,0xb1,0xa1]

s_call_b64 s[0:1], 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbb]

s_call_b64 s[0:1], 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbb]

s_call_b64 s[104:105], 0x1234
// GFX10: encoding: [0x34,0x12,0x68,0xbb]

s_call_b64 exec, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbb]

s_call_b64 vcc, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbb]

s_waitcnt_vscnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbb]

s_waitcnt_vscnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbb]

s_waitcnt_vscnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xbb]

s_waitcnt_vscnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xbb]

s_waitcnt_vscnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xbb]

s_waitcnt_vscnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xbb]

s_waitcnt_vscnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xbb]

s_waitcnt_vscnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xbb]

s_waitcnt_vmcnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbc]

s_waitcnt_vmcnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbc]

s_waitcnt_vmcnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xbc]

s_waitcnt_vmcnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbc]

s_waitcnt_vmcnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xbc]

s_waitcnt_vmcnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbc]

s_waitcnt_vmcnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xbc]

s_waitcnt_vmcnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xbc]

s_waitcnt_expcnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbc]

s_waitcnt_expcnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbc]

s_waitcnt_expcnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xbc]

s_waitcnt_expcnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xbc]

s_waitcnt_expcnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xbc]

s_waitcnt_expcnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xbc]

s_waitcnt_expcnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xbc]

s_waitcnt_expcnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xbc]

s_waitcnt_lgkmcnt s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbd]

s_waitcnt_lgkmcnt s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbd]

s_waitcnt_lgkmcnt s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xbd]

s_waitcnt_lgkmcnt exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbd]

s_waitcnt_lgkmcnt exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xbd]

s_waitcnt_lgkmcnt vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbd]

s_waitcnt_lgkmcnt vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xbd]

s_waitcnt_lgkmcnt m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xbd]

s_waitcnt_depctr 0xfffe
// GFX10: encoding: [0xfe,0xff,0xa3,0xbf]

s_waitcnt_depctr 0
// GFX10: encoding: [0x00,0x00,0xa3,0xbf]

s_wait_idle
// GFX10: encoding: [0x00,0x00,0xa2,0xbf]

s_subvector_loop_begin s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbd]

s_subvector_loop_begin s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbd]

s_subvector_loop_begin s105, 0x1234
// GFX10: encoding: [0x34,0x12,0xe9,0xbd]

s_subvector_loop_begin exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xfe,0xbd]

s_subvector_loop_begin exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xff,0xbd]

s_subvector_loop_begin vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0xea,0xbd]

s_subvector_loop_begin vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0xeb,0xbd]

s_subvector_loop_begin m0, 0x1234
// GFX10: encoding: [0x34,0x12,0xfc,0xbd]

s_subvector_loop_end s0, 0x1234
// GFX10: encoding: [0x34,0x12,0x00,0xbe]

s_subvector_loop_end s0, 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x00,0xbe]

s_subvector_loop_end s105, 0x1234
// GFX10: encoding: [0x34,0x12,0x69,0xbe]

s_subvector_loop_end exec_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x7e,0xbe]

s_subvector_loop_end exec_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x7f,0xbe]

s_subvector_loop_end vcc_lo, 0x1234
// GFX10: encoding: [0x34,0x12,0x6a,0xbe]

s_subvector_loop_end vcc_hi, 0x1234
// GFX10: encoding: [0x34,0x12,0x6b,0xbe]

s_subvector_loop_end m0, 0x1234
// GFX10: encoding: [0x34,0x12,0x7c,0xbe]

//===----------------------------------------------------------------------===//
// ENC_SOPP.
//===----------------------------------------------------------------------===//

s_nop 0x0
// GFX10: encoding: [0x00,0x00,0x80,0xbf]

s_nop 0x1234
// GFX10: encoding: [0x34,0x12,0x80,0xbf]

s_nop 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x80,0xbf]

s_endpgm
// GFX10: encoding: [0x00,0x00,0x81,0xbf]

s_branch 0x0
// GFX10: encoding: [0x00,0x00,0x82,0xbf]

s_branch 0x1234
// GFX10: encoding: [0x34,0x12,0x82,0xbf]

s_branch 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x82,0xbf]

s_wakeup
// GFX10: encoding: [0x00,0x00,0x83,0xbf]

s_cbranch_scc0 0x0
// GFX10: encoding: [0x00,0x00,0x84,0xbf]

s_cbranch_scc0 0x1234
// GFX10: encoding: [0x34,0x12,0x84,0xbf]

s_cbranch_scc0 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x84,0xbf]

s_cbranch_scc1 0x0
// GFX10: encoding: [0x00,0x00,0x85,0xbf]

s_cbranch_scc1 0x1234
// GFX10: encoding: [0x34,0x12,0x85,0xbf]

s_cbranch_scc1 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x85,0xbf]

s_cbranch_vccz 0x0
// GFX10: encoding: [0x00,0x00,0x86,0xbf]

s_cbranch_vccz 0x1234
// GFX10: encoding: [0x34,0x12,0x86,0xbf]

s_cbranch_vccz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x86,0xbf]

s_cbranch_vccnz 0x0
// GFX10: encoding: [0x00,0x00,0x87,0xbf]

s_cbranch_vccnz 0x1234
// GFX10: encoding: [0x34,0x12,0x87,0xbf]

s_cbranch_vccnz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x87,0xbf]

s_cbranch_execz 0x0
// GFX10: encoding: [0x00,0x00,0x88,0xbf]

s_cbranch_execz 0x1234
// GFX10: encoding: [0x34,0x12,0x88,0xbf]

s_cbranch_execz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x88,0xbf]

s_cbranch_execnz 0x0
// GFX10: encoding: [0x00,0x00,0x89,0xbf]

s_cbranch_execnz 0x1234
// GFX10: encoding: [0x34,0x12,0x89,0xbf]

s_cbranch_execnz 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x89,0xbf]

s_barrier
// GFX10: encoding: [0x00,0x00,0x8a,0xbf]

s_setkill 0x0
// GFX10: encoding: [0x00,0x00,0x8b,0xbf]

s_setkill 0x1234
// GFX10: encoding: [0x34,0x12,0x8b,0xbf]

s_setkill 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8b,0xbf]

s_waitcnt 0x0
// GFX10: encoding: [0x00,0x00,0x8c,0xbf]

s_waitcnt 0x1234
// GFX10: encoding: [0x34,0x12,0x8c,0xbf]

s_waitcnt 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8c,0xbf]

s_sethalt 0x0
// GFX10: encoding: [0x00,0x00,0x8d,0xbf]

s_sethalt 0x1234
// GFX10: encoding: [0x34,0x12,0x8d,0xbf]

s_sethalt 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8d,0xbf]

s_sleep 0x0
// GFX10: encoding: [0x00,0x00,0x8e,0xbf]

s_sleep 0x1234
// GFX10: encoding: [0x34,0x12,0x8e,0xbf]

s_sleep 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8e,0xbf]

s_setprio 0x0
// GFX10: encoding: [0x00,0x00,0x8f,0xbf]

s_setprio 0x1234
// GFX10: encoding: [0x34,0x12,0x8f,0xbf]

s_setprio 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x8f,0xbf]

s_sendmsg 0x0
// GFX10: encoding: [0x00,0x00,0x90,0xbf]

s_sendmsg 0x1234
// GFX10: encoding: [0x34,0x12,0x90,0xbf]

s_sendmsg 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x90,0xbf]

s_sendmsghalt 0x0
// GFX10: encoding: [0x00,0x00,0x91,0xbf]

s_sendmsghalt 0x1234
// GFX10: encoding: [0x34,0x12,0x91,0xbf]

s_sendmsghalt 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x91,0xbf]

s_trap 0x0
// GFX10: encoding: [0x00,0x00,0x92,0xbf]

s_trap 0x1234
// GFX10: encoding: [0x34,0x12,0x92,0xbf]

s_trap 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x92,0xbf]

s_icache_inv
// GFX10: encoding: [0x00,0x00,0x93,0xbf]

s_incperflevel 0x0
// GFX10: encoding: [0x00,0x00,0x94,0xbf]

s_incperflevel 0x1234
// GFX10: encoding: [0x34,0x12,0x94,0xbf]

s_incperflevel 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x94,0xbf]

s_decperflevel 0x0
// GFX10: encoding: [0x00,0x00,0x95,0xbf]

s_decperflevel 0x1234
// GFX10: encoding: [0x34,0x12,0x95,0xbf]

s_decperflevel 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x95,0xbf]

s_ttracedata
// GFX10: encoding: [0x00,0x00,0x96,0xbf]

s_cbranch_cdbgsys 0x0
// GFX10: encoding: [0x00,0x00,0x97,0xbf]

s_cbranch_cdbgsys 0x1234
// GFX10: encoding: [0x34,0x12,0x97,0xbf]

s_cbranch_cdbgsys 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x97,0xbf]

s_cbranch_cdbguser 0x0
// GFX10: encoding: [0x00,0x00,0x98,0xbf]

s_cbranch_cdbguser 0x1234
// GFX10: encoding: [0x34,0x12,0x98,0xbf]

s_cbranch_cdbguser 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x98,0xbf]

s_cbranch_cdbgsys_or_user 0x0
// GFX10: encoding: [0x00,0x00,0x99,0xbf]

s_cbranch_cdbgsys_or_user 0x1234
// GFX10: encoding: [0x34,0x12,0x99,0xbf]

s_cbranch_cdbgsys_or_user 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x99,0xbf]

s_cbranch_cdbgsys_and_user 0x0
// GFX10: encoding: [0x00,0x00,0x9a,0xbf]

s_cbranch_cdbgsys_and_user 0x1234
// GFX10: encoding: [0x34,0x12,0x9a,0xbf]

s_cbranch_cdbgsys_and_user 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0x9a,0xbf]

s_endpgm_saved
// GFX10: encoding: [0x00,0x00,0x9b,0xbf]

s_endpgm_ordered_ps_done
// GFX10: encoding: [0x00,0x00,0x9e,0xbf]

s_code_end
// GFX10: encoding: [0x00,0x00,0x9f,0xbf]

s_inst_prefetch 0x0
// GFX10: encoding: [0x00,0x00,0xa0,0xbf]

s_inst_prefetch 0x1234
// GFX10: encoding: [0x34,0x12,0xa0,0xbf]

s_inst_prefetch 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa0,0xbf]

s_clause 0x0
// GFX10: encoding: [0x00,0x00,0xa1,0xbf]

s_clause 0x1234
// GFX10: encoding: [0x34,0x12,0xa1,0xbf]

s_clause 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa1,0xbf]

s_round_mode 0x0
// GFX10: encoding: [0x00,0x00,0xa4,0xbf]

s_round_mode 0x1234
// GFX10: encoding: [0x34,0x12,0xa4,0xbf]

s_round_mode 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa4,0xbf]

s_denorm_mode 0x0
// GFX10: encoding: [0x00,0x00,0xa5,0xbf]

s_denorm_mode 0x1234
// GFX10: encoding: [0x34,0x12,0xa5,0xbf]

s_denorm_mode 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa5,0xbf]

s_ttracedata_imm 0x0
// GFX10: encoding: [0x00,0x00,0xa8,0xbf]

s_ttracedata_imm 0x1234
// GFX10: encoding: [0x34,0x12,0xa8,0xbf]

s_ttracedata_imm 0xc1d1
// GFX10: encoding: [0xd1,0xc1,0xa8,0xbf]

//===----------------------------------------------------------------------===//
// ENC_VOP1.
//===----------------------------------------------------------------------===//

v_nop_e32
// GFX10: encoding: [0x00,0x00,0x00,0x7e]

v_nop_e64
// GFX10: encoding: [0x00,0x00,0x80,0xd5,0x00,0x00,0x00,0x00]

v_mov_b32_e32 v5, v1
// GFX10: encoding: [0x01,0x03,0x0a,0x7e]

v_mov_b32_e32 v255, v1
// GFX10: encoding: [0x01,0x03,0xfe,0x7f]

v_mov_b32_e32 v5, v255
// GFX10: encoding: [0xff,0x03,0x0a,0x7e]

v_mov_b32_e32 v5, s1
// GFX10: encoding: [0x01,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, s103
// GFX10: encoding: [0x67,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, m0
// GFX10: encoding: [0x7c,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, 0
// GFX10: encoding: [0x80,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, -1
// GFX10: encoding: [0xc1,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x02,0x0a,0x7e]

v_mov_b32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x02,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_mov_b32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x02,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_mov_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x81,0xd5,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xff,0x01,0x00,0x00]

v_mov_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x01,0x00,0x00,0x00]

v_mov_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x65,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x6a,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x6b,0x00,0x00,0x00]

v_mov_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x7c,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x7e,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x7f,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0x80,0x00,0x00,0x00]

v_mov_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xc1,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xf0,0x00,0x00,0x00]

v_mov_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x81,0xd5,0xf7,0x00,0x00,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_mov_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_mov_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_mov_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_mov_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_mov_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_mov_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_mov_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_mov_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_mov_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_mov_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x02,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_mov_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_mov_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_mov_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_mov_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_mov_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_mov_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_mov_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_mov_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_mov_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_mov_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x02,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_readfirstlane_b32 s5, v1
// GFX10: encoding: [0x01,0x05,0x0a,0x7e]

v_readfirstlane_b32 s103, v1
// GFX10: encoding: [0x01,0x05,0xce,0x7e]

v_readfirstlane_b32 ttmp11, v1
// GFX10: encoding: [0x01,0x05,0xee,0x7e]

v_readfirstlane_b32 s5, v255
// GFX10: encoding: [0xff,0x05,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, v[1:2]
// GFX10: encoding: [0x01,0x07,0x0a,0x7e]

v_cvt_i32_f64_e32 v255, v[1:2]
// GFX10: encoding: [0x01,0x07,0xfe,0x7f]

v_cvt_i32_f64_e32 v5, v[254:255]
// GFX10: encoding: [0xfe,0x07,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, s[2:3]
// GFX10: encoding: [0x02,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, s[4:5]
// GFX10: encoding: [0x04,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, s[102:103]
// GFX10: encoding: [0x66,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, vcc
// GFX10: encoding: [0x6a,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, exec
// GFX10: encoding: [0x7e,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, 0
// GFX10: encoding: [0x80,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, -1
// GFX10: encoding: [0xc1,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x06,0x0a,0x7e]

v_cvt_i32_f64_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x06,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f64_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x06,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x02,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x04,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x64,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x80,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0x83,0xd5,0x01,0x01,0x00,0x20]

v_cvt_i32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e32 v[5:6], v1
// GFX10: encoding: [0x01,0x09,0x0a,0x7e]

v_cvt_f64_i32_e32 v[254:255], v1
// GFX10: encoding: [0x01,0x09,0xfc,0x7f]

v_cvt_f64_i32_e32 v[5:6], v255
// GFX10: encoding: [0xff,0x09,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], s1
// GFX10: encoding: [0x01,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], s103
// GFX10: encoding: [0x67,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], vcc_lo
// GFX10: encoding: [0x6a,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], vcc_hi
// GFX10: encoding: [0x6b,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], ttmp11
// GFX10: encoding: [0x77,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], m0
// GFX10: encoding: [0x7c,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], exec_lo
// GFX10: encoding: [0x7e,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], exec_hi
// GFX10: encoding: [0x7f,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], 0
// GFX10: encoding: [0x80,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], -1
// GFX10: encoding: [0xc1,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x08,0x0a,0x7e]

v_cvt_f64_i32_e32 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x08,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_i32_e32 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x08,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_i32_e64 v[5:6], v1
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[254:255], v1
// GFX10: encoding: [0xfe,0x00,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v255
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s101
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_lo
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_hi
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], m0
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_lo
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_hi
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 clamp
// GFX10: encoding: [0x05,0x80,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 mul:2
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], v1 mul:4
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f64_i32_e64 v[5:6], v1 div:2
// GFX10: encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_i32_e32 v5, v1
// GFX10: encoding: [0x01,0x0b,0x0a,0x7e]

v_cvt_f32_i32_e32 v255, v1
// GFX10: encoding: [0x01,0x0b,0xfe,0x7f]

v_cvt_f32_i32_e32 v5, v255
// GFX10: encoding: [0xff,0x0b,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, s1
// GFX10: encoding: [0x01,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, s103
// GFX10: encoding: [0x67,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, m0
// GFX10: encoding: [0x7c,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, 0
// GFX10: encoding: [0x80,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, -1
// GFX10: encoding: [0xc1,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x0a,0x0a,0x7e]

v_cvt_f32_i32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x0a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_i32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x0a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_i32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_i32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_i32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_i32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_i32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0a,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_i32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_i32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_i32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_i32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_u32_e32 v5, v1
// GFX10: encoding: [0x01,0x0d,0x0a,0x7e]

v_cvt_f32_u32_e32 v255, v1
// GFX10: encoding: [0x01,0x0d,0xfe,0x7f]

v_cvt_f32_u32_e32 v5, v255
// GFX10: encoding: [0xff,0x0d,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, s1
// GFX10: encoding: [0x01,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, s103
// GFX10: encoding: [0x67,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, m0
// GFX10: encoding: [0x7c,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, 0
// GFX10: encoding: [0x80,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, -1
// GFX10: encoding: [0xc1,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x0c,0x0a,0x7e]

v_cvt_f32_u32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x0c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_u32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x0c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_u32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_u32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_u32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_u32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_u32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_u32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_u32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_u32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_u32_f32_e32 v5, v1
// GFX10: encoding: [0x01,0x0f,0x0a,0x7e]

v_cvt_u32_f32_e32 v255, v1
// GFX10: encoding: [0x01,0x0f,0xfe,0x7f]

v_cvt_u32_f32_e32 v5, v255
// GFX10: encoding: [0xff,0x0f,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, s1
// GFX10: encoding: [0x01,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, s103
// GFX10: encoding: [0x67,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, m0
// GFX10: encoding: [0x7c,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, 0
// GFX10: encoding: [0x80,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, -1
// GFX10: encoding: [0xc1,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x0e,0x0a,0x7e]

v_cvt_u32_f32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x0e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x0e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x65,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x80,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x87,0xd5,0x01,0x01,0x00,0x20]

v_cvt_u32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_u32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_u32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_u32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_u32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x0e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_u32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_u32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_u32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_u32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x0e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_i32_f32_e32 v5, v1
// GFX10: encoding: [0x01,0x11,0x0a,0x7e]

v_cvt_i32_f32_e32 v255, v1
// GFX10: encoding: [0x01,0x11,0xfe,0x7f]

v_cvt_i32_f32_e32 v5, v255
// GFX10: encoding: [0xff,0x11,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, s1
// GFX10: encoding: [0x01,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, s103
// GFX10: encoding: [0x67,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, m0
// GFX10: encoding: [0x7c,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, 0
// GFX10: encoding: [0x80,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, -1
// GFX10: encoding: [0xc1,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x10,0x0a,0x7e]

v_cvt_i32_f32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x10,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x10,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x65,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x80,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x88,0xd5,0x01,0x01,0x00,0x20]

v_cvt_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x10,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x10,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_mov_fed_b32_e32 v5, v1
// GFX10: encoding: [0x01,0x13,0x0a,0x7e]

v_mov_fed_b32_e32 v255, v1
// GFX10: encoding: [0x01,0x13,0xfe,0x7f]

v_mov_fed_b32_e32 v5, v255
// GFX10: encoding: [0xff,0x13,0x0a,0x7e]

v_mov_fed_b32_e32 v5, s1
// GFX10: encoding: [0x01,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, s103
// GFX10: encoding: [0x67,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, ttmp11
// GFX10: encoding: [0x77,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, m0
// GFX10: encoding: [0x7c,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, exec_lo
// GFX10: encoding: [0x7e,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, exec_hi
// GFX10: encoding: [0x7f,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, 0
// GFX10: encoding: [0x80,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, -1
// GFX10: encoding: [0xc1,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, 0.5
// GFX10: encoding: [0xf0,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, -4.0
// GFX10: encoding: [0xf7,0x12,0x0a,0x7e]

v_mov_fed_b32_e32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x12,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_mov_fed_b32_e32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x12,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_mov_fed_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x01,0x01,0x00,0x00]

v_mov_fed_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x89,0xd5,0x01,0x01,0x00,0x00]

v_mov_fed_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0xff,0x01,0x00,0x00]

v_mov_fed_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x01,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x65,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x6a,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x6b,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x7c,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x7e,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x7f,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0x80,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0xc1,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0xf0,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x89,0xd5,0xf7,0x00,0x00,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_fed_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_mov_fed_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_mov_fed_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_mov_fed_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_mov_fed_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x12,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_mov_fed_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_mov_fed_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_mov_fed_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_mov_fed_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_mov_fed_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_mov_fed_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_mov_fed_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x12,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f16_f32 v5, v1
// GFX10: encoding: [0x01,0x15,0x0a,0x7e]

v_cvt_f16_f32 v255, v1
// GFX10: encoding: [0x01,0x15,0xfe,0x7f]

v_cvt_f16_f32 v5, v255
// GFX10: encoding: [0xff,0x15,0x0a,0x7e]

v_cvt_f16_f32 v5, s1
// GFX10: encoding: [0x01,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, s103
// GFX10: encoding: [0x67,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, m0
// GFX10: encoding: [0x7c,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0
// GFX10: encoding: [0x80,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -1
// GFX10: encoding: [0xc1,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x14,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x14,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f16_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f16_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f16_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f16_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f16_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f16_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f16_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_f16_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x14,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f16_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f16_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f16_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f16_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x14,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_f16 v5, v1
// GFX10: encoding: [0x01,0x17,0x0a,0x7e]

v_cvt_f32_f16 v255, v1
// GFX10: encoding: [0x01,0x17,0xfe,0x7f]

v_cvt_f32_f16 v5, v255
// GFX10: encoding: [0xff,0x17,0x0a,0x7e]

v_cvt_f32_f16 v5, s1
// GFX10: encoding: [0x01,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, s103
// GFX10: encoding: [0x67,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_lo
// GFX10: encoding: [0x6a,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_hi
// GFX10: encoding: [0x6b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, ttmp11
// GFX10: encoding: [0x77,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, m0
// GFX10: encoding: [0x7c,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_lo
// GFX10: encoding: [0x7e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_hi
// GFX10: encoding: [0x7f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0
// GFX10: encoding: [0x80,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, -1
// GFX10: encoding: [0xc1,0x16,0x0a,0x7e]

v_cvt_f32_f16_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f32_f16_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_f16_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_f16_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_f16_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_f16_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_f16_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_f32_f16_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x16,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_f16_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_f16_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_f16_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_f16_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x16,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_rpi_i32_f32 v5, v1
// GFX10: encoding: [0x01,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v255, v1
// GFX10: encoding: [0x01,0x19,0xfe,0x7f]

v_cvt_rpi_i32_f32 v5, v255
// GFX10: encoding: [0xff,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s1
// GFX10: encoding: [0x01,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s103
// GFX10: encoding: [0x67,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, m0
// GFX10: encoding: [0x7c,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0
// GFX10: encoding: [0x80,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -1
// GFX10: encoding: [0xc1,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x18,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_rpi_i32_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x18,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_rpi_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xff,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x01,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x65,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x80,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8c,0xd5,0x01,0x01,0x00,0x20]

v_cvt_rpi_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_rpi_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_rpi_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_rpi_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x18,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_rpi_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_rpi_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x18,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_flr_i32_f32 v5, v1
// GFX10: encoding: [0x01,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v255, v1
// GFX10: encoding: [0x01,0x1b,0xfe,0x7f]

v_cvt_flr_i32_f32 v5, v255
// GFX10: encoding: [0xff,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s1
// GFX10: encoding: [0x01,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s103
// GFX10: encoding: [0x67,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, m0
// GFX10: encoding: [0x7c,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0
// GFX10: encoding: [0x80,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -1
// GFX10: encoding: [0xc1,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x1a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_flr_i32_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x1a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_flr_i32_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xff,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x01,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x65,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x80,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0x8d,0xd5,0x01,0x01,0x00,0x20]

v_cvt_flr_i32_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_flr_i32_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_flr_i32_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cvt_flr_i32_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_flr_i32_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_flr_i32_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_off_f32_i4 v5, v1
// GFX10: encoding: [0x01,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v255, v1
// GFX10: encoding: [0x01,0x1d,0xfe,0x7f]

v_cvt_off_f32_i4 v5, v255
// GFX10: encoding: [0xff,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s1
// GFX10: encoding: [0x01,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s103
// GFX10: encoding: [0x67,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_lo
// GFX10: encoding: [0x6a,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_hi
// GFX10: encoding: [0x6b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, ttmp11
// GFX10: encoding: [0x77,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, m0
// GFX10: encoding: [0x7c,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_lo
// GFX10: encoding: [0x7e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_hi
// GFX10: encoding: [0x7f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0
// GFX10: encoding: [0x80,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -1
// GFX10: encoding: [0xc1,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0.5
// GFX10: encoding: [0xf0,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -4.0
// GFX10: encoding: [0xf7,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0x4f
// GFX10: encoding: [0xff,0x1c,0x0a,0x7e,0x4f,0x00,0x00,0x00]

v_cvt_off_f32_i4 v5, 0x41
// GFX10: encoding: [0xff,0x1c,0x0a,0x7e,0x41,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xff,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x65,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x80,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x10]

v_cvt_off_f32_i4_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x18]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_off_f32_i4_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_off_f32_i4_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x1c,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_off_f32_i4_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_off_f32_i4_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x1c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_f64 v5, v[1:2]
// GFX10: encoding: [0x01,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v255, v[1:2]
// GFX10: encoding: [0x01,0x1f,0xfe,0x7f]

v_cvt_f32_f64 v5, v[254:255]
// GFX10: encoding: [0xfe,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v5, s[2:3]
// GFX10: encoding: [0x02,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[4:5]
// GFX10: encoding: [0x04,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[102:103]
// GFX10: encoding: [0x66,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, vcc
// GFX10: encoding: [0x6a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, exec
// GFX10: encoding: [0x7e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0
// GFX10: encoding: [0x80,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -1
// GFX10: encoding: [0xc1,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0.5
// GFX10: encoding: [0xf0,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -4.0
// GFX10: encoding: [0xf7,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0xaf123456
// GFX10: encoding: [0xff,0x1e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_f64 v5, 0x3f717273
// GFX10: encoding: [0xff,0x1e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x02,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x04,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x64,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_f64_e64 v5, v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_f64_e64 v5, v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f64_f32 v[5:6], v1
// GFX10: encoding: [0x01,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[254:255], v1
// GFX10: encoding: [0x01,0x21,0xfc,0x7f]

v_cvt_f64_f32 v[5:6], v255
// GFX10: encoding: [0xff,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s1
// GFX10: encoding: [0x01,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s103
// GFX10: encoding: [0x67,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_lo
// GFX10: encoding: [0x6a,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_hi
// GFX10: encoding: [0x6b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], ttmp11
// GFX10: encoding: [0x77,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], m0
// GFX10: encoding: [0x7c,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_lo
// GFX10: encoding: [0x7e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_hi
// GFX10: encoding: [0x7f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0
// GFX10: encoding: [0x80,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -1
// GFX10: encoding: [0xc1,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x20,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_f32 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x20,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_f32_e64 v[5:6], v1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[254:255], v1
// GFX10: encoding: [0xfe,0x00,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v255
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s101
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_lo
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_hi
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], m0
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_lo
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_hi
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -v1
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x20]

v_cvt_f64_f32_e64 v[5:6], |v1|
// GFX10: encoding: [0x05,0x01,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 clamp
// GFX10: encoding: [0x05,0x80,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 mul:2
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f64_f32_e64 v[5:6], v1 mul:4
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f64_f32_e64 v[5:6], v1 div:2
// GFX10: encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0 v5, v1
// GFX10: encoding: [0x01,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v255, v1
// GFX10: encoding: [0x01,0x23,0xfe,0x7f]

v_cvt_f32_ubyte0 v5, v255
// GFX10: encoding: [0xff,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s1
// GFX10: encoding: [0x01,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s103
// GFX10: encoding: [0x67,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_lo
// GFX10: encoding: [0x6a,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_hi
// GFX10: encoding: [0x6b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, ttmp11
// GFX10: encoding: [0x77,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, m0
// GFX10: encoding: [0x7c,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_lo
// GFX10: encoding: [0x7e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_hi
// GFX10: encoding: [0x7f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0
// GFX10: encoding: [0x80,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -1
// GFX10: encoding: [0xc1,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0.5
// GFX10: encoding: [0xf0,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -4.0
// GFX10: encoding: [0xf7,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0xaf123456
// GFX10: encoding: [0xff,0x22,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte0 v5, 0x3f717273
// GFX10: encoding: [0xff,0x22,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte0_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte0_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte0_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte0_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte0_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x22,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte0_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte0_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x22,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_ubyte1 v5, v1
// GFX10: encoding: [0x01,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v255, v1
// GFX10: encoding: [0x01,0x25,0xfe,0x7f]

v_cvt_f32_ubyte1 v5, v255
// GFX10: encoding: [0xff,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s1
// GFX10: encoding: [0x01,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s103
// GFX10: encoding: [0x67,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_lo
// GFX10: encoding: [0x6a,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_hi
// GFX10: encoding: [0x6b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, ttmp11
// GFX10: encoding: [0x77,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, m0
// GFX10: encoding: [0x7c,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_lo
// GFX10: encoding: [0x7e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_hi
// GFX10: encoding: [0x7f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0
// GFX10: encoding: [0x80,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -1
// GFX10: encoding: [0xc1,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0.5
// GFX10: encoding: [0xf0,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -4.0
// GFX10: encoding: [0xf7,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0xaf123456
// GFX10: encoding: [0xff,0x24,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte1 v5, 0x3f717273
// GFX10: encoding: [0xff,0x24,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte1_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte1_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte1_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte1_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte1_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x24,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte1_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte1_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x24,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_ubyte2 v5, v1
// GFX10: encoding: [0x01,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v255, v1
// GFX10: encoding: [0x01,0x27,0xfe,0x7f]

v_cvt_f32_ubyte2 v5, v255
// GFX10: encoding: [0xff,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s1
// GFX10: encoding: [0x01,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s103
// GFX10: encoding: [0x67,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_lo
// GFX10: encoding: [0x6a,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_hi
// GFX10: encoding: [0x6b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, ttmp11
// GFX10: encoding: [0x77,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, m0
// GFX10: encoding: [0x7c,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_lo
// GFX10: encoding: [0x7e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_hi
// GFX10: encoding: [0x7f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0
// GFX10: encoding: [0x80,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -1
// GFX10: encoding: [0xc1,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0.5
// GFX10: encoding: [0xf0,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -4.0
// GFX10: encoding: [0xf7,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0xaf123456
// GFX10: encoding: [0xff,0x26,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte2 v5, 0x3f717273
// GFX10: encoding: [0xff,0x26,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte2_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte2_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte2_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte2_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte2_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x26,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte2_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte2_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x26,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_f32_ubyte3 v5, v1
// GFX10: encoding: [0x01,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v255, v1
// GFX10: encoding: [0x01,0x29,0xfe,0x7f]

v_cvt_f32_ubyte3 v5, v255
// GFX10: encoding: [0xff,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s1
// GFX10: encoding: [0x01,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s103
// GFX10: encoding: [0x67,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_lo
// GFX10: encoding: [0x6a,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_hi
// GFX10: encoding: [0x6b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, ttmp11
// GFX10: encoding: [0x77,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, m0
// GFX10: encoding: [0x7c,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_lo
// GFX10: encoding: [0x7e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_hi
// GFX10: encoding: [0x7f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0
// GFX10: encoding: [0x80,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -1
// GFX10: encoding: [0xc1,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0.5
// GFX10: encoding: [0xf0,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -4.0
// GFX10: encoding: [0xf7,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0xaf123456
// GFX10: encoding: [0xff,0x28,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte3 v5, 0x3f717273
// GFX10: encoding: [0xff,0x28,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte3_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f32_ubyte3_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f32_ubyte3_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cvt_f32_ubyte3_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cvt_f32_ubyte3_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x28,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cvt_f32_ubyte3_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cvt_f32_ubyte3_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x28,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cvt_u32_f64 v5, v[1:2]
// GFX10: encoding: [0x01,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v255, v[1:2]
// GFX10: encoding: [0x01,0x2b,0xfe,0x7f]

v_cvt_u32_f64 v5, v[254:255]
// GFX10: encoding: [0xfe,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v5, s[2:3]
// GFX10: encoding: [0x02,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[4:5]
// GFX10: encoding: [0x04,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[102:103]
// GFX10: encoding: [0x66,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, vcc
// GFX10: encoding: [0x6a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, ttmp[10:11]
// GFX10: encoding: [0x76,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, exec
// GFX10: encoding: [0x7e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0
// GFX10: encoding: [0x80,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -1
// GFX10: encoding: [0xc1,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0.5
// GFX10: encoding: [0xf0,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -4.0
// GFX10: encoding: [0xf7,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0xaf123456
// GFX10: encoding: [0xff,0x2a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f64 v5, 0x3f717273
// GFX10: encoding: [0xff,0x2a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f64_e64 v5, v[1:2]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v255, v[1:2]
// GFX10: encoding: [0xff,0x00,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[254:255]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[2:3]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x02,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[4:5]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x04,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[100:101]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x64,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, vcc
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, exec
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x80,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -v[1:2]
// GFX10: encoding: [0x05,0x00,0x95,0xd5,0x01,0x01,0x00,0x20]

v_cvt_u32_f64_e64 v5, |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32 v[5:6], v1
// GFX10: encoding: [0x01,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[254:255], v1
// GFX10: encoding: [0x01,0x2d,0xfc,0x7f]

v_cvt_f64_u32 v[5:6], v255
// GFX10: encoding: [0xff,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s1
// GFX10: encoding: [0x01,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s103
// GFX10: encoding: [0x67,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_lo
// GFX10: encoding: [0x6a,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_hi
// GFX10: encoding: [0x6b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], ttmp11
// GFX10: encoding: [0x77,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], m0
// GFX10: encoding: [0x7c,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_lo
// GFX10: encoding: [0x7e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_hi
// GFX10: encoding: [0x7f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0
// GFX10: encoding: [0x80,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -1
// GFX10: encoding: [0xc1,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x2c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_u32 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x2c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_u32_e64 v[5:6], v1
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[254:255], v1
// GFX10: encoding: [0xfe,0x00,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v255
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s101
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x65,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_lo
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_hi
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], m0
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_lo
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_hi
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x80,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0xf7,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 clamp
// GFX10: encoding: [0x05,0x80,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 mul:2
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], v1 mul:4
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x10]

v_cvt_f64_u32_e64 v[5:6], v1 div:2
// GFX10: encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x18]

v_trunc_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x2f,0x0a,0x7e]

v_trunc_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x2f,0xfc,0x7f]

v_trunc_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x2f,0x0a,0x7e]

v_trunc_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x2e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x2e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xfe,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x02,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x04,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x64,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x80,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xf0,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0xf7,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x20]

v_trunc_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x08]

v_trunc_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x10]

v_trunc_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x18]

v_ceil_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x31,0x0a,0x7e]

v_ceil_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x31,0xfc,0x7f]

v_ceil_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x31,0x0a,0x7e]

v_ceil_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x30,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x30,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xfe,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x02,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x04,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x64,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x80,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xf0,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0xf7,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x20]

v_ceil_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x08]

v_ceil_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x10]

v_ceil_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x18]

v_rndne_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x33,0x0a,0x7e]

v_rndne_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x33,0xfc,0x7f]

v_rndne_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x33,0x0a,0x7e]

v_rndne_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x32,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x32,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xfe,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x02,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x04,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x64,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x80,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xf0,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0xf7,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x20]

v_rndne_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x08]

v_rndne_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x10]

v_rndne_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x18]

v_floor_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x35,0x0a,0x7e]

v_floor_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x35,0xfc,0x7f]

v_floor_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x35,0x0a,0x7e]

v_floor_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x34,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x34,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xfe,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x02,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x04,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x64,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x80,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xf0,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0xf7,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x20]

v_floor_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x08]

v_floor_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x10]

v_floor_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x18]

v_pipeflush
// GFX10: encoding: [0x00,0x36,0x00,0x7e]

v_pipeflush_e64
// GFX10: encoding: [0x00,0x00,0x9b,0xd5,0x00,0x00,0x00,0x00]

v_fract_f32 v5, v1
// GFX10: encoding: [0x01,0x41,0x0a,0x7e]

v_fract_f32 v255, v1
// GFX10: encoding: [0x01,0x41,0xfe,0x7f]

v_fract_f32 v5, v255
// GFX10: encoding: [0xff,0x41,0x0a,0x7e]

v_fract_f32 v5, s1
// GFX10: encoding: [0x01,0x40,0x0a,0x7e]

v_fract_f32 v5, s103
// GFX10: encoding: [0x67,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x40,0x0a,0x7e]

v_fract_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x40,0x0a,0x7e]

v_fract_f32 v5, m0
// GFX10: encoding: [0x7c,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x40,0x0a,0x7e]

v_fract_f32 v5, 0
// GFX10: encoding: [0x80,0x40,0x0a,0x7e]

v_fract_f32 v5, -1
// GFX10: encoding: [0xc1,0x40,0x0a,0x7e]

v_fract_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x40,0x0a,0x7e]

v_fract_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x40,0x0a,0x7e]

v_fract_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x40,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x40,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xff,0x01,0x00,0x00]

v_fract_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x00,0x00,0x00]

v_fract_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x65,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x6b,0x00,0x00,0x00]

v_fract_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x7f,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x80,0x00,0x00,0x00]

v_fract_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xf0,0x00,0x00,0x00]

v_fract_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0xf7,0x00,0x00,0x00]

v_fract_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x20]

v_fract_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x08]

v_fract_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x10]

v_fract_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x18]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_fract_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_fract_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_fract_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_fract_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_fract_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_fract_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_fract_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_fract_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_fract_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_fract_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_fract_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_fract_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_fract_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_fract_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x40,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_fract_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_fract_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_fract_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_fract_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_fract_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_fract_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_fract_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_fract_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_fract_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_fract_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_fract_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x40,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_trunc_f32 v5, v1
// GFX10: encoding: [0x01,0x43,0x0a,0x7e]

v_trunc_f32 v255, v1
// GFX10: encoding: [0x01,0x43,0xfe,0x7f]

v_trunc_f32 v5, v255
// GFX10: encoding: [0xff,0x43,0x0a,0x7e]

v_trunc_f32 v5, s1
// GFX10: encoding: [0x01,0x42,0x0a,0x7e]

v_trunc_f32 v5, s103
// GFX10: encoding: [0x67,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x42,0x0a,0x7e]

v_trunc_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x42,0x0a,0x7e]

v_trunc_f32 v5, m0
// GFX10: encoding: [0x7c,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0
// GFX10: encoding: [0x80,0x42,0x0a,0x7e]

v_trunc_f32 v5, -1
// GFX10: encoding: [0xc1,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x42,0x0a,0x7e]

v_trunc_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x42,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x42,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xff,0x01,0x00,0x00]

v_trunc_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x00,0x00,0x00]

v_trunc_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x65,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x6b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x7f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x80,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xf0,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0xf7,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x20]

v_trunc_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x08]

v_trunc_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x10]

v_trunc_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x18]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_trunc_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_trunc_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_trunc_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_trunc_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_trunc_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_trunc_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_trunc_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x42,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_trunc_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_trunc_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_trunc_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_trunc_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_trunc_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_trunc_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x42,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ceil_f32 v5, v1
// GFX10: encoding: [0x01,0x45,0x0a,0x7e]

v_ceil_f32 v255, v1
// GFX10: encoding: [0x01,0x45,0xfe,0x7f]

v_ceil_f32 v5, v255
// GFX10: encoding: [0xff,0x45,0x0a,0x7e]

v_ceil_f32 v5, s1
// GFX10: encoding: [0x01,0x44,0x0a,0x7e]

v_ceil_f32 v5, s103
// GFX10: encoding: [0x67,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x44,0x0a,0x7e]

v_ceil_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x44,0x0a,0x7e]

v_ceil_f32 v5, m0
// GFX10: encoding: [0x7c,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0
// GFX10: encoding: [0x80,0x44,0x0a,0x7e]

v_ceil_f32 v5, -1
// GFX10: encoding: [0xc1,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x44,0x0a,0x7e]

v_ceil_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x44,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x44,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xff,0x01,0x00,0x00]

v_ceil_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x00,0x00,0x00]

v_ceil_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x65,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x6b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x7f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x80,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xf0,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0xf7,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x20]

v_ceil_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x08]

v_ceil_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x10]

v_ceil_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x18]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ceil_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ceil_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_ceil_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_ceil_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ceil_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ceil_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_ceil_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x44,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ceil_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ceil_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ceil_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ceil_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ceil_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ceil_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x44,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rndne_f32 v5, v1
// GFX10: encoding: [0x01,0x47,0x0a,0x7e]

v_rndne_f32 v255, v1
// GFX10: encoding: [0x01,0x47,0xfe,0x7f]

v_rndne_f32 v5, v255
// GFX10: encoding: [0xff,0x47,0x0a,0x7e]

v_rndne_f32 v5, s1
// GFX10: encoding: [0x01,0x46,0x0a,0x7e]

v_rndne_f32 v5, s103
// GFX10: encoding: [0x67,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x46,0x0a,0x7e]

v_rndne_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x46,0x0a,0x7e]

v_rndne_f32 v5, m0
// GFX10: encoding: [0x7c,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0
// GFX10: encoding: [0x80,0x46,0x0a,0x7e]

v_rndne_f32 v5, -1
// GFX10: encoding: [0xc1,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x46,0x0a,0x7e]

v_rndne_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x46,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x46,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xff,0x01,0x00,0x00]

v_rndne_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x00,0x00,0x00]

v_rndne_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x65,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x6b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x7f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x80,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xf0,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0xf7,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x20]

v_rndne_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x08]

v_rndne_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x10]

v_rndne_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x18]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rndne_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rndne_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rndne_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rndne_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rndne_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rndne_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rndne_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x46,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rndne_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rndne_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rndne_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rndne_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rndne_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rndne_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x46,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_floor_f32 v5, v1
// GFX10: encoding: [0x01,0x49,0x0a,0x7e]

v_floor_f32 v255, v1
// GFX10: encoding: [0x01,0x49,0xfe,0x7f]

v_floor_f32 v5, v255
// GFX10: encoding: [0xff,0x49,0x0a,0x7e]

v_floor_f32 v5, s1
// GFX10: encoding: [0x01,0x48,0x0a,0x7e]

v_floor_f32 v5, s103
// GFX10: encoding: [0x67,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x48,0x0a,0x7e]

v_floor_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x48,0x0a,0x7e]

v_floor_f32 v5, m0
// GFX10: encoding: [0x7c,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x48,0x0a,0x7e]

v_floor_f32 v5, 0
// GFX10: encoding: [0x80,0x48,0x0a,0x7e]

v_floor_f32 v5, -1
// GFX10: encoding: [0xc1,0x48,0x0a,0x7e]

v_floor_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x48,0x0a,0x7e]

v_floor_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x48,0x0a,0x7e]

v_floor_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x48,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x48,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xff,0x01,0x00,0x00]

v_floor_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x00,0x00,0x00]

v_floor_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x65,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x6b,0x00,0x00,0x00]

v_floor_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x7f,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x80,0x00,0x00,0x00]

v_floor_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xf0,0x00,0x00,0x00]

v_floor_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0xf7,0x00,0x00,0x00]

v_floor_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x20]

v_floor_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x08]

v_floor_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x10]

v_floor_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x18]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_floor_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_floor_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_floor_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_floor_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_floor_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_floor_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_floor_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_floor_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_floor_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_floor_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_floor_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_floor_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_floor_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_floor_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x48,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_floor_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_floor_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_floor_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_floor_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_floor_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_floor_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_floor_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_floor_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_floor_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_floor_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_floor_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x48,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_exp_f32 v5, v1
// GFX10: encoding: [0x01,0x4b,0x0a,0x7e]

v_exp_f32 v255, v1
// GFX10: encoding: [0x01,0x4b,0xfe,0x7f]

v_exp_f32 v5, v255
// GFX10: encoding: [0xff,0x4b,0x0a,0x7e]

v_exp_f32 v5, s1
// GFX10: encoding: [0x01,0x4a,0x0a,0x7e]

v_exp_f32 v5, s103
// GFX10: encoding: [0x67,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x4a,0x0a,0x7e]

v_exp_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x4a,0x0a,0x7e]

v_exp_f32 v5, m0
// GFX10: encoding: [0x7c,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0
// GFX10: encoding: [0x80,0x4a,0x0a,0x7e]

v_exp_f32 v5, -1
// GFX10: encoding: [0xc1,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x4a,0x0a,0x7e]

v_exp_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x4a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x4a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_exp_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xff,0x01,0x00,0x00]

v_exp_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x00,0x00,0x00]

v_exp_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x65,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x6a,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x6b,0x00,0x00,0x00]

v_exp_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x7c,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x7e,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x7f,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x80,0x00,0x00,0x00]

v_exp_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xc1,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xf0,0x00,0x00,0x00]

v_exp_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0xf7,0x00,0x00,0x00]

v_exp_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x20]

v_exp_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x08]

v_exp_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x10]

v_exp_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x18]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_exp_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_exp_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_exp_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_exp_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_exp_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_exp_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_exp_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_exp_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_exp_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_exp_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_exp_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_exp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_exp_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_exp_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_exp_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_exp_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_exp_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_exp_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_exp_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_exp_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_exp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_exp_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_exp_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_exp_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_exp_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_log_f32 v5, v1
// GFX10: encoding: [0x01,0x4f,0x0a,0x7e]

v_log_f32 v255, v1
// GFX10: encoding: [0x01,0x4f,0xfe,0x7f]

v_log_f32 v5, v255
// GFX10: encoding: [0xff,0x4f,0x0a,0x7e]

v_log_f32 v5, s1
// GFX10: encoding: [0x01,0x4e,0x0a,0x7e]

v_log_f32 v5, s103
// GFX10: encoding: [0x67,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x4e,0x0a,0x7e]

v_log_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x4e,0x0a,0x7e]

v_log_f32 v5, m0
// GFX10: encoding: [0x7c,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x4e,0x0a,0x7e]

v_log_f32 v5, 0
// GFX10: encoding: [0x80,0x4e,0x0a,0x7e]

v_log_f32 v5, -1
// GFX10: encoding: [0xc1,0x4e,0x0a,0x7e]

v_log_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x4e,0x0a,0x7e]

v_log_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x4e,0x0a,0x7e]

v_log_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x4e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x4e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xff,0x01,0x00,0x00]

v_log_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x00,0x00,0x00]

v_log_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x65,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x6a,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x6b,0x00,0x00,0x00]

v_log_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x7c,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x7e,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x7f,0x00,0x00,0x00]

v_log_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x80,0x00,0x00,0x00]

v_log_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xc1,0x00,0x00,0x00]

v_log_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xf0,0x00,0x00,0x00]

v_log_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0xf7,0x00,0x00,0x00]

v_log_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x20]

v_log_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x08]

v_log_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x10]

v_log_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x18]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_log_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_log_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_log_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_log_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_log_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_log_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_log_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_log_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_log_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_log_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_log_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_log_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_log_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_log_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x4e,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_log_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_log_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_log_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_log_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_log_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_log_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_log_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_log_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_log_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_log_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_log_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_log_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_log_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_log_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_log_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_log_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x4e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_f32 v5, v1
// GFX10: encoding: [0x01,0x55,0x0a,0x7e]

v_rcp_f32 v255, v1
// GFX10: encoding: [0x01,0x55,0xfe,0x7f]

v_rcp_f32 v5, v255
// GFX10: encoding: [0xff,0x55,0x0a,0x7e]

v_rcp_f32 v5, s1
// GFX10: encoding: [0x01,0x54,0x0a,0x7e]

v_rcp_f32 v5, s103
// GFX10: encoding: [0x67,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x54,0x0a,0x7e]

v_rcp_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x54,0x0a,0x7e]

v_rcp_f32 v5, m0
// GFX10: encoding: [0x7c,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0
// GFX10: encoding: [0x80,0x54,0x0a,0x7e]

v_rcp_f32 v5, -1
// GFX10: encoding: [0xc1,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x54,0x0a,0x7e]

v_rcp_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x54,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x54,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xff,0x01,0x00,0x00]

v_rcp_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x00,0x00,0x00]

v_rcp_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x65,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x80,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x20]

v_rcp_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x08]

v_rcp_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x10]

v_rcp_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x18]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rcp_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rcp_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rcp_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x54,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rcp_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x54,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_iflag_f32 v5, v1
// GFX10: encoding: [0x01,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v255, v1
// GFX10: encoding: [0x01,0x57,0xfe,0x7f]

v_rcp_iflag_f32 v5, v255
// GFX10: encoding: [0xff,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v5, s1
// GFX10: encoding: [0x01,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, s103
// GFX10: encoding: [0x67,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, m0
// GFX10: encoding: [0x7c,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0
// GFX10: encoding: [0x80,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -1
// GFX10: encoding: [0xc1,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x56,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_iflag_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x56,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_iflag_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xff,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x65,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x80,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x20]

v_rcp_iflag_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x08]

v_rcp_iflag_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x10]

v_rcp_iflag_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x18]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rcp_iflag_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rcp_iflag_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rcp_iflag_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rcp_iflag_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x56,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rcp_iflag_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rcp_iflag_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x56,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rsq_f32 v5, v1
// GFX10: encoding: [0x01,0x5d,0x0a,0x7e]

v_rsq_f32 v255, v1
// GFX10: encoding: [0x01,0x5d,0xfe,0x7f]

v_rsq_f32 v5, v255
// GFX10: encoding: [0xff,0x5d,0x0a,0x7e]

v_rsq_f32 v5, s1
// GFX10: encoding: [0x01,0x5c,0x0a,0x7e]

v_rsq_f32 v5, s103
// GFX10: encoding: [0x67,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x5c,0x0a,0x7e]

v_rsq_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x5c,0x0a,0x7e]

v_rsq_f32 v5, m0
// GFX10: encoding: [0x7c,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0
// GFX10: encoding: [0x80,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -1
// GFX10: encoding: [0xc1,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x5c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x5c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xff,0x01,0x00,0x00]

v_rsq_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x00,0x00,0x00]

v_rsq_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x65,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x6b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x7f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x80,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xf0,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0xf7,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x20]

v_rsq_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x08]

v_rsq_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x10]

v_rsq_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x18]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_rsq_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_rsq_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_rsq_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_rsq_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_rsq_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_rsq_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_rsq_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x5c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_rsq_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_rsq_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_rsq_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_rsq_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_rsq_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_rsq_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x5c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_rcp_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x5f,0x0a,0x7e]

v_rcp_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x5f,0xfc,0x7f]

v_rcp_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x5f,0x0a,0x7e]

v_rcp_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x5e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x5e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xfe,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x02,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x04,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x64,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x80,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xf0,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0xf7,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x20]

v_rcp_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x08]

v_rcp_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x10]

v_rcp_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x18]

v_rsq_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x63,0x0a,0x7e]

v_rsq_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x63,0xfc,0x7f]

v_rsq_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x63,0x0a,0x7e]

v_rsq_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x62,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x62,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xfe,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x02,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x04,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x64,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x80,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xf0,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0xf7,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x20]

v_rsq_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x08]

v_rsq_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x10]

v_rsq_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x18]

v_sqrt_f32 v5, v1
// GFX10: encoding: [0x01,0x67,0x0a,0x7e]

v_sqrt_f32 v255, v1
// GFX10: encoding: [0x01,0x67,0xfe,0x7f]

v_sqrt_f32 v5, v255
// GFX10: encoding: [0xff,0x67,0x0a,0x7e]

v_sqrt_f32 v5, s1
// GFX10: encoding: [0x01,0x66,0x0a,0x7e]

v_sqrt_f32 v5, s103
// GFX10: encoding: [0x67,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x66,0x0a,0x7e]

v_sqrt_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x66,0x0a,0x7e]

v_sqrt_f32 v5, m0
// GFX10: encoding: [0x7c,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0
// GFX10: encoding: [0x80,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -1
// GFX10: encoding: [0xc1,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x66,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x66,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xff,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x65,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x6b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x7f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x80,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xf0,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0xf7,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x20]

v_sqrt_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x08]

v_sqrt_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x10]

v_sqrt_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x18]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_sqrt_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sqrt_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sqrt_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sqrt_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x66,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sqrt_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sqrt_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sqrt_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sqrt_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sqrt_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_sqrt_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x66,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_sqrt_f64 v[5:6], v[1:2]
// GFX10: encoding: [0x01,0x69,0x0a,0x7e]

v_sqrt_f64 v[254:255], v[1:2]
// GFX10: encoding: [0x01,0x69,0xfc,0x7f]

v_sqrt_f64 v[5:6], v[254:255]
// GFX10: encoding: [0xfe,0x69,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[2:3]
// GFX10: encoding: [0x02,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[4:5]
// GFX10: encoding: [0x04,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[102:103]
// GFX10: encoding: [0x66,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], vcc
// GFX10: encoding: [0x6a,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], ttmp[10:11]
// GFX10: encoding: [0x76,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], exec
// GFX10: encoding: [0x7e,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0
// GFX10: encoding: [0x80,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -1
// GFX10: encoding: [0xc1,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0.5
// GFX10: encoding: [0xf0,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -4.0
// GFX10: encoding: [0xf7,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0xaf123456
// GFX10: encoding: [0xff,0x68,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f64 v[5:6], 0x3f717273
// GFX10: encoding: [0xff,0x68,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f64_e64 v[5:6], v[1:2]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[254:255], v[1:2]
// GFX10: encoding: [0xfe,0x00,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[254:255]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xfe,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[2:3]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x02,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[4:5]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x04,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[100:101]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x64,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], vcc
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], exec
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x80,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -1
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0.5
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xf0,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -4.0
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0xf7,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -v[1:2]
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x20]

v_sqrt_f64_e64 v[5:6], |v[1:2]|
// GFX10: encoding: [0x05,0x01,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] clamp
// GFX10: encoding: [0x05,0x80,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:2
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x08]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:4
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x10]

v_sqrt_f64_e64 v[5:6], v[1:2] div:2
// GFX10: encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x18]

v_sin_f32 v5, v1
// GFX10: encoding: [0x01,0x6b,0x0a,0x7e]

v_sin_f32 v255, v1
// GFX10: encoding: [0x01,0x6b,0xfe,0x7f]

v_sin_f32 v5, v255
// GFX10: encoding: [0xff,0x6b,0x0a,0x7e]

v_sin_f32 v5, s1
// GFX10: encoding: [0x01,0x6a,0x0a,0x7e]

v_sin_f32 v5, s103
// GFX10: encoding: [0x67,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x6a,0x0a,0x7e]

v_sin_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x6a,0x0a,0x7e]

v_sin_f32 v5, m0
// GFX10: encoding: [0x7c,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0
// GFX10: encoding: [0x80,0x6a,0x0a,0x7e]

v_sin_f32 v5, -1
// GFX10: encoding: [0xc1,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x6a,0x0a,0x7e]

v_sin_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x6a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sin_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x6a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sin_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xff,0x01,0x00,0x00]

v_sin_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x00,0x00,0x00]

v_sin_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x65,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x6a,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x6b,0x00,0x00,0x00]

v_sin_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x7c,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x7e,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x7f,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x80,0x00,0x00,0x00]

v_sin_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xc1,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xf0,0x00,0x00,0x00]

v_sin_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0xf7,0x00,0x00,0x00]

v_sin_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x20]

v_sin_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x08]

v_sin_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x10]

v_sin_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x18]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_sin_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_sin_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_sin_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_sin_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_sin_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_sin_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_sin_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_sin_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_sin_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_sin_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_sin_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_sin_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_sin_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_sin_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6a,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_sin_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_sin_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_sin_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_sin_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_sin_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_sin_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_sin_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_sin_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_sin_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_sin_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_sin_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6a,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_cos_f32 v5, v1
// GFX10: encoding: [0x01,0x6d,0x0a,0x7e]

v_cos_f32 v255, v1
// GFX10: encoding: [0x01,0x6d,0xfe,0x7f]

v_cos_f32 v5, v255
// GFX10: encoding: [0xff,0x6d,0x0a,0x7e]

v_cos_f32 v5, s1
// GFX10: encoding: [0x01,0x6c,0x0a,0x7e]

v_cos_f32 v5, s103
// GFX10: encoding: [0x67,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x6c,0x0a,0x7e]

v_cos_f32 v5, ttmp11
// GFX10: encoding: [0x77,0x6c,0x0a,0x7e]

v_cos_f32 v5, m0
// GFX10: encoding: [0x7c,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_lo
// GFX10: encoding: [0x7e,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_hi
// GFX10: encoding: [0x7f,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0
// GFX10: encoding: [0x80,0x6c,0x0a,0x7e]

v_cos_f32 v5, -1
// GFX10: encoding: [0xc1,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0.5
// GFX10: encoding: [0xf0,0x6c,0x0a,0x7e]

v_cos_f32 v5, -4.0
// GFX10: encoding: [0xf7,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x6c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cos_f32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x6c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cos_f32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xff,0x01,0x00,0x00]

v_cos_f32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x00,0x00,0x00]

v_cos_f32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x65,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x6a,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x6b,0x00,0x00,0x00]

v_cos_f32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x7c,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x7e,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x7f,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x80,0x00,0x00,0x00]

v_cos_f32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xc1,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xf0,0x00,0x00,0x00]

v_cos_f32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0xf7,0x00,0x00,0x00]

v_cos_f32_e64 v5, -v1
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x20]

v_cos_f32_e64 v5, |v1|
// GFX10: encoding: [0x05,0x01,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 clamp
// GFX10: encoding: [0x05,0x80,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 mul:2
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x08]

v_cos_f32_e64 v5, v1 mul:4
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x10]

v_cos_f32_e64 v5, v1 div:2
// GFX10: encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x18]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_cos_f32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_cos_f32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_cos_f32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_cos_f32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_cos_f32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_cos_f32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_cos_f32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_cos_f32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_cos_f32_sdwa v5, v1 mul:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x46,0x06,0x00]

v_cos_f32_sdwa v5, v1 mul:4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x86,0x06,0x00]

v_cos_f32_sdwa v5, v1 div:2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0xc6,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_cos_f32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_cos_f32_sdwa v5, -v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x16,0x00]

v_cos_f32_sdwa v5, |v1| dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6c,0x0a,0x7e,0x01,0x06,0x26,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_cos_f32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_cos_f32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_cos_f32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_cos_f32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_cos_f32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_cos_f32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_cos_f32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_cos_f32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_cos_f32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_cos_f32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_cos_f32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6c,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_not_b32 v5, v1
// GFX10: encoding: [0x01,0x6f,0x0a,0x7e]

v_not_b32 v255, v1
// GFX10: encoding: [0x01,0x6f,0xfe,0x7f]

v_not_b32 v5, v255
// GFX10: encoding: [0xff,0x6f,0x0a,0x7e]

v_not_b32 v5, s1
// GFX10: encoding: [0x01,0x6e,0x0a,0x7e]

v_not_b32 v5, s103
// GFX10: encoding: [0x67,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x6e,0x0a,0x7e]

v_not_b32 v5, ttmp11
// GFX10: encoding: [0x77,0x6e,0x0a,0x7e]

v_not_b32 v5, m0
// GFX10: encoding: [0x7c,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_lo
// GFX10: encoding: [0x7e,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_hi
// GFX10: encoding: [0x7f,0x6e,0x0a,0x7e]

v_not_b32 v5, 0
// GFX10: encoding: [0x80,0x6e,0x0a,0x7e]

v_not_b32 v5, -1
// GFX10: encoding: [0xc1,0x6e,0x0a,0x7e]

v_not_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x6e,0x0a,0x7e]

v_not_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x6e,0x0a,0x7e]

v_not_b32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x6e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_not_b32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x6e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_not_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x01,0x01,0x00,0x00]

v_not_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb7,0xd5,0x01,0x01,0x00,0x00]

v_not_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xff,0x01,0x00,0x00]

v_not_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x01,0x00,0x00,0x00]

v_not_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x65,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x6a,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x6b,0x00,0x00,0x00]

v_not_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x7c,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x7e,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x7f,0x00,0x00,0x00]

v_not_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0x80,0x00,0x00,0x00]

v_not_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xc1,0x00,0x00,0x00]

v_not_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xf0,0x00,0x00,0x00]

v_not_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb7,0xd5,0xf7,0x00,0x00,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_not_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_not_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_not_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_not_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_not_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_not_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_not_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_not_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_not_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_not_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x6e,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_not_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_not_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_not_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_not_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_not_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_not_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_not_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_not_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_not_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_not_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_not_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_not_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_not_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_not_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_not_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_not_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x6e,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_bfrev_b32 v5, v1
// GFX10: encoding: [0x01,0x71,0x0a,0x7e]

v_bfrev_b32 v255, v1
// GFX10: encoding: [0x01,0x71,0xfe,0x7f]

v_bfrev_b32 v5, v255
// GFX10: encoding: [0xff,0x71,0x0a,0x7e]

v_bfrev_b32 v5, s1
// GFX10: encoding: [0x01,0x70,0x0a,0x7e]

v_bfrev_b32 v5, s103
// GFX10: encoding: [0x67,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x70,0x0a,0x7e]

v_bfrev_b32 v5, ttmp11
// GFX10: encoding: [0x77,0x70,0x0a,0x7e]

v_bfrev_b32 v5, m0
// GFX10: encoding: [0x7c,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_lo
// GFX10: encoding: [0x7e,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_hi
// GFX10: encoding: [0x7f,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0
// GFX10: encoding: [0x80,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -1
// GFX10: encoding: [0xc1,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x70,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_bfrev_b32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x70,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_bfrev_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb8,0xd5,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xff,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x01,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x65,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x6a,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x6b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x7c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x7e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x7f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0x80,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xc1,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xf0,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb8,0xd5,0xf7,0x00,0x00,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_bfrev_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_bfrev_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_bfrev_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x70,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_bfrev_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_bfrev_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_bfrev_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_bfrev_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_bfrev_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_bfrev_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x70,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ffbh_u32 v5, v1
// GFX10: encoding: [0x01,0x73,0x0a,0x7e]

v_ffbh_u32 v255, v1
// GFX10: encoding: [0x01,0x73,0xfe,0x7f]

v_ffbh_u32 v5, v255
// GFX10: encoding: [0xff,0x73,0x0a,0x7e]

v_ffbh_u32 v5, s1
// GFX10: encoding: [0x01,0x72,0x0a,0x7e]

v_ffbh_u32 v5, s103
// GFX10: encoding: [0x67,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x72,0x0a,0x7e]

v_ffbh_u32 v5, ttmp11
// GFX10: encoding: [0x77,0x72,0x0a,0x7e]

v_ffbh_u32 v5, m0
// GFX10: encoding: [0x7c,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_lo
// GFX10: encoding: [0x7e,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_hi
// GFX10: encoding: [0x7f,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0
// GFX10: encoding: [0x80,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -1
// GFX10: encoding: [0xc1,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0.5
// GFX10: encoding: [0xf0,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -4.0
// GFX10: encoding: [0xf7,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x72,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_u32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x72,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_u32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xb9,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xff,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x01,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x65,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x6a,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x6b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x7c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x7e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x7f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0x80,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xc1,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xf0,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xb9,0xd5,0xf7,0x00,0x00,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ffbh_u32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbh_u32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbh_u32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x72,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbh_u32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbh_u32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbh_u32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbh_u32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbh_u32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ffbh_u32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x72,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ffbl_b32 v5, v1
// GFX10: encoding: [0x01,0x75,0x0a,0x7e]

v_ffbl_b32 v255, v1
// GFX10: encoding: [0x01,0x75,0xfe,0x7f]

v_ffbl_b32 v5, v255
// GFX10: encoding: [0xff,0x75,0x0a,0x7e]

v_ffbl_b32 v5, s1
// GFX10: encoding: [0x01,0x74,0x0a,0x7e]

v_ffbl_b32 v5, s103
// GFX10: encoding: [0x67,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x74,0x0a,0x7e]

v_ffbl_b32 v5, ttmp11
// GFX10: encoding: [0x77,0x74,0x0a,0x7e]

v_ffbl_b32 v5, m0
// GFX10: encoding: [0x7c,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_lo
// GFX10: encoding: [0x7e,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_hi
// GFX10: encoding: [0x7f,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0
// GFX10: encoding: [0x80,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -1
// GFX10: encoding: [0xc1,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0.5
// GFX10: encoding: [0xf0,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -4.0
// GFX10: encoding: [0xf7,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x74,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbl_b32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x74,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbl_b32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xba,0xd5,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xff,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x01,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x65,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x6a,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x6b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x7c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x7e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x7f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0x80,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xc1,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xf0,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xba,0xd5,0xf7,0x00,0x00,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ffbl_b32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x04,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x05,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_SEXT src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x0e,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PRESERVE src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x16,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x00,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_1
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x01,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_2
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x02,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_3
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x03,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x04,0x00]

v_ffbl_b32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x05,0x00]

v_ffbl_b32_sdwa v5, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x74,0x0a,0x7e,0x01,0x06,0x0e,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x00]

v_ffbl_b32_dpp v255, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0xfe,0x7f,0x01,0xe4,0x00,0x00]

v_ffbl_b32_dpp v5, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0xff,0xe4,0x00,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1b,0x00,0x00]

v_ffbl_b32_dpp v5, v1 row_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x40,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_half_mirror row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x41,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shl:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x01,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shl:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x0f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shr:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x11,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_shr:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x1f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_ror:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x21,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_ror:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x2f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x10]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x30]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0xf0]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x01]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x03]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x00,0x0f]

v_ffbl_b32_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0xe4,0x08,0x00]

v_ffbl_b32_dpp v5, v1 row_share:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x51,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x5f,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_xmask:1 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x61,0x01,0x00]

v_ffbl_b32_dpp v5, v1 row_xmask:15 row_mask:0x0 bank_mask:0x0
// GFX10: encoding: [0xfa,0x74,0x0a,0x7e,0x01,0x6f,0x01,0x00]

v_ffbh_i32 v5, v1
// GFX10: encoding: [0x01,0x77,0x0a,0x7e]

v_ffbh_i32 v255, v1
// GFX10: encoding: [0x01,0x77,0xfe,0x7f]

v_ffbh_i32 v5, v255
// GFX10: encoding: [0xff,0x77,0x0a,0x7e]

v_ffbh_i32 v5, s1
// GFX10: encoding: [0x01,0x76,0x0a,0x7e]

v_ffbh_i32 v5, s103
// GFX10: encoding: [0x67,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_lo
// GFX10: encoding: [0x6a,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_hi
// GFX10: encoding: [0x6b,0x76,0x0a,0x7e]

v_ffbh_i32 v5, ttmp11
// GFX10: encoding: [0x77,0x76,0x0a,0x7e]

v_ffbh_i32 v5, m0
// GFX10: encoding: [0x7c,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_lo
// GFX10: encoding: [0x7e,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_hi
// GFX10: encoding: [0x7f,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0
// GFX10: encoding: [0x80,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -1
// GFX10: encoding: [0xc1,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0.5
// GFX10: encoding: [0xf0,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -4.0
// GFX10: encoding: [0xf7,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0xaf123456
// GFX10: encoding: [0xff,0x76,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_i32 v5, 0x3f717273
// GFX10: encoding: [0xff,0x76,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_i32_e64 v5, v1
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v255, v1
// GFX10: encoding: [0xff,0x00,0xbb,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, v255
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xff,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, s1
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x01,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, s101
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x65,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_lo
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x6a,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_hi
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x6b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, m0
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x7c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_lo
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x7e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_hi
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x7f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0x80,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -1
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xc1,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0.5
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xf0,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -4.0
// GFX10: encoding: [0x05,0x00,0xbb,0xd5,0xf7,0x00,0x00,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v255, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0xfe,0x7f,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v255 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0xff,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, s1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, s101 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x65,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x6a,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, vcc_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x6b,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, m0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x7c,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, exec_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x7e,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, exec_hi dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x7f,0x06,0x86,0x00]

v_ffbh_i32_sdwa v5, v1 clamp dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x26,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x06,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_0 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x00,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_1 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x01,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_2 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x02,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:BYTE_3 dst_unused:UNUSED_PAD src0_sel:DWORD
// GFX10: encoding: [0xf9,0x76,0x0a,0x7e,0x01,0x03,0x06,0x00]

v_ffbh_i32_sdwa v5, v1 dst_sel:WORD_0 dst_unused:UN