# Sourced by all ltsp-manager shell scripts, provides some common functions.
# Copyright (C) 2017 Alkis Georgopoulos <alkisg@gmail.com>
# License GNU GPL version 3 or newer <http://gnu.org/licenses/gpl.html>

# We're not using /usr/bin/gettext.sh at all.
# Always call this gettext function like this:
# echo "`gettext "Translated message with various %s params" "params go here"`"
gettext() {
    local text

    text="$1"
    shift
    if [ -x "/usr/bin/gettext" ]; then
        printf "`/usr/bin/gettext -d ltsp-manager "$text"`" "$@"
    else
        printf "$text" "$@"
    fi
}

# Print all parameters, followed by a newline.
printfn() {
    printf "%s\n" "$*"
}

bold() {
    if [ -z "$printbold_first_time" ]; then
        printbold_first_time=true
        bold_face=$(tput bold 2>/dev/null) || true
        normal_face=$(tput sgr0 2>/dev/null) || true
    fi
    printf "%s\n" "${bold_face}$*${normal_face}"
}

log() {
    logger -t ltsp-manager -p syslog.err "$@"
}

# Output a message to stderr and abort execution
die() {
    log "$@"
    bold "ERROR in ${0##*/}:" >&2
    echo "$@" >&2
    pause_exit 1
}

# Also contains the greek letters for Yes/No
is_true() {
    case "$1" in
        [YyΝν]|[Tt][Rr][Uu][Ee]|[Yy][Ee][Ss])
            return 0
        ;;
        *)
            return 1
        ;;
    esac
}

confirm() {
    local answer

    read -p "$1" answer
    test -n "$answer" || answer="true"
    if ! is_true "$answer"; then
        gettext "Cancelled by the user." >&2
        pause_exit 2
    fi
}

# $search must be ready for sed, e.g. '^whole line$'.
# Return 0 if a replacement was made, 1 otherwise.
search_and_replace() {
    local search replace file migrate old_search 
    search=$1
    replace=$2
    file=$3
    migrate=$4

    if grep -qs "$search" "$file"; then
        sed "s/$search/$replace # Commented by ltsp-manager: &/" -i "$file"
        return 0
    elif [ "$migrate" = true ] && grep -qs "^${replace}$" "$file"; then
        # strip ^$ from the search string, we'll use it in the replacement
        old_search=${search#^}
        old_search=${old_search%$}
        sed "s/^${replace}$/& # Commented by ltsp-manager: $old_search/" -i "$file"
        return 0
    fi
    return 1
}

test -f "common.sh" || cd /usr/share/ltsp-manager
version=$(. /usr/share/ltsp-manager/version.py >/dev/null && printf "%s\n" "$__version__")
