/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQObstatCurveTool_H
#define MvQObstatCurveTool_H

#include "MvQMainWindow.h"
#include "MvQObstatCurveData.h"

class QSplitter;
class QTextBrowser;

class MvKeyProfile;

class MvQObstatCurveToolBase;
class MvQKeyManager;
class MvQLogBrowser;

class MvQObstatCurveTool : public MvQMainWindow
{
    Q_OBJECT

public:
    	MvQObstatCurveTool(QWidget *parent = 0);
    	~MvQObstatCurveTool();
    	void init(MvQObstatCurveData*);

public slots:
	void slotSelectMessage(int);
	void slotSelectBlock(int);
	void slotLoadKeyProfile(MvKeyProfile *);
	void slotUpdateLogOutput();

	
	
private:
	void readSettings();
	void writeSettings();

	QSplitter*   centralSplitter_;
	QSplitter*   mainSplitter_;

	MvQObstatCurveData* data_;
	//MvQKeyManager *keyManager_;

	MvQObstatCurveToolBase* examinerBase_;
	MvQLogBrowser* logBrowser_;

	QString lastKeyProfileName_;
};

#endif
