/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * This file is available under and governed by the GNU General Public
 * License version 2 only, as published by the Free Software Foundation.
 * However, the following notice accompanied the original version of this
 * file:
 *
 * Written by Martin Buchholz with assistance from members of JCP
 * JSR-166 Expert Group and released to the public domain, as
 * explained at http://creativecommons.org/publicdomain/zero/1.0/
 */

/*
 * @test
 * @modules java.base/java.util.concurrent:open
 *          java.base/java.util:open
 * @run testng WhiteBox
 * @summary White box tests of implementation details
 */

import static org.testng.Assert.*;
import org.testng.annotations.Test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Test
public class WhiteBox {
    final ThreadLocalRandom rnd = ThreadLocalRandom.current();
    final VarHandle PQ_QUEUE = queueVarHandle(PriorityQueue.class);
    final VarHandle PBQ_QUEUE = queueVarHandle(PriorityBlockingQueue.class);

    VarHandle queueVarHandle(Class klazz) {
        return findVarHandle(klazz, "queue", Object[].class);
    }

    VarHandle findVarHandle(Class klazz, String fieldName, Class type) {
        try {
            return MethodHandles.privateLookupIn(klazz, MethodHandles.lookup())
                .findVarHandle(klazz, fieldName, type);
        } catch (ReflectiveOperationException ex) { throw new Error(ex); }
    }

    Object[] queue(PriorityQueue q) {
        return (Object[]) PQ_QUEUE.getOpaque(q);
    }

    Object[] queue(PriorityBlockingQueue q) {
        return (Object[]) PBQ_QUEUE.getOpaque(q);
    }

    /** PriorityQueue and PriorityBlockingQueue have identical heap management. */
    @Test
    public void randomLockstep() {
        PriorityBlockingQueue pbq = new PriorityBlockingQueue();
        PriorityQueue pq = new PriorityQueue();
        List<Consumer<Queue>> frobbers = List.of(
            q -> q.add(42),
            q -> assertTrue(q.offer(86)),
            q -> q.poll(),
            q -> q.peek(),
            q -> {
                Iterator it = q.iterator();
                if (it.hasNext()) {
                    it.next();
                    it.remove();
                }});
        for (int i = 0; i < 100; i++) {
            Consumer<Queue> frobber = frobbers.get(rnd.nextInt(frobbers.size()));
            frobber.accept(pq);
            frobber.accept(pbq);
            assertInvariants(pbq);
            assertInvariants(pq);
            assertTrue(Arrays.equals