//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Algo
 *
 *  Copyright 2005-2017 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTALGO_HXX
#define OPENTURNS_OTALGO_HXX

#include "openturns/ApproximationAlgorithmImplementation.hxx"
#include "openturns/ApproximationAlgorithm.hxx"
#include "openturns/ApproximationAlgorithmImplementationFactory.hxx"
#include "openturns/ClassifierImplementation.hxx"
#include "openturns/Classifier.hxx"
#include "openturns/ApproximationAlgorithm.hxx"
#include "openturns/FittingAlgorithmImplementation.hxx"
#include "openturns/FittingAlgorithm.hxx"
#include "openturns/KDTree.hxx"
#include "openturns/KFold.hxx"
#include "openturns/CorrectedLeaveOneOut.hxx"
#include "openturns/LeastSquaresMetaModelSelection.hxx"
#include "openturns/LeastSquaresMetaModelSelectionFactory.hxx"
#include "openturns/PenalizedLeastSquaresAlgorithm.hxx"
#include "openturns/PenalizedLeastSquaresAlgorithmFactory.hxx"
#include "openturns/FFTImplementation.hxx"
#include "openturns/FFT.hxx"
#include "openturns/KissFFT.hxx"
#include "openturns/IntegrationAlgorithmImplementation.hxx"
#include "openturns/IntegrationAlgorithm.hxx"
#include "openturns/GaussKronrod.hxx"
#include "openturns/GaussKronrodRule.hxx"
#include "openturns/GaussLegendre.hxx"
#include "openturns/IteratedQuadrature.hxx"
#include "openturns/DesignProxy.hxx"
#include "openturns/LeastSquaresMethodImplementation.hxx"
#include "openturns/LeastSquaresMethod.hxx"
#include "openturns/CholeskyMethod.hxx"
#include "openturns/QRMethod.hxx"
#include "openturns/SVDMethod.hxx"
#include "openturns/SparseMethod.hxx"
#include "openturns/KarhunenLoeveResultImplementation.hxx"
#include "openturns/KarhunenLoeveResult.hxx"
#include "openturns/KarhunenLoeveAlgorithmImplementation.hxx"
#include "openturns/KarhunenLoeveAlgorithm.hxx"
#include "openturns/KarhunenLoeveP1Algorithm.hxx"
#include "openturns/KarhunenLoeveSVDAlgorithm.hxx"
#include "openturns/KarhunenLoeveProjection.hxx"
#include "openturns/KarhunenLoeveLifting.hxx"

#endif /* OPENTURNS_OTALGO_HXX */
