//                                               -*- C++ -*-
/**
 *  @brief BarPlot class for barplots
 *
 *  Copyright 2005-2018 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef OPENTURNS_BARPLOT_HXX
#define OPENTURNS_BARPLOT_HXX

#include "openturns/OTprivate.hxx"
#include "openturns/DrawableImplementation.hxx"
#include "openturns/Sample.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class BarPlot
 *
 * The class describing a curve plot
 * Instance of Drawable
 */


class OT_API BarPlot : public DrawableImplementation
{

  CLASSNAME

public:
  /** Default constructor */
  BarPlot();

  /** Default constructor */
  BarPlot(const Sample & data,
          const Scalar origin,
          const String & legend = "");

  /** Constructor with parameters */
  BarPlot(const Sample & data,
          const Scalar origin,
          const String & color,
          const String & fillStyle,
          const String & lineStyle,
          const UnsignedInteger lineWidth,
          const String & legend = "");

  /** Constructor with old parameters */
  BarPlot(const Sample & data,
          const Scalar origin,
          const String & color,
          const String & fillStyle,
          const String & lineStyle,
          const String & legend = "");

  /** String converter */
  String __repr__() const;

  /** Accessor for origin */
  Scalar getOrigin() const;
  void setOrigin(const Scalar origin);

  /** Accessor for boundingbox */
  Interval getBoundingBox() const;

  /** Draw method */
  String draw() const;

  /** Clone method */
  virtual BarPlot * clone() const;


  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() stores the object through the StorageManager */
  void load(Advocate & adv);

protected:
  /** Check fo data validity */
  virtual void checkData(const Sample & data) const;

private:

  /** Origin of the BarPlot */
  Scalar origin_;

}; /* class BarPlot */



END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_BARPLOT_HXX */
