//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Type
 *
 *  Copyright 2005-2018 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTTYPE_HXX
#define OPENTURNS_OTTYPE_HXX

#include "openturns/BipartiteGraph.hxx"
#include "openturns/Cache.hxx"
#include "openturns/Collection.hxx"
#include "openturns/Description.hxx"
#include "openturns/IdentityMatrix.hxx"
#include "openturns/Indices.hxx"
#include "openturns/IndicesCollectionImplementation.hxx"
#include "openturns/IndicesCollection.hxx"
#include "openturns/Matrix.hxx"
#include "openturns/MatrixImplementation.hxx"
#include "openturns/Mesh.hxx"
#include "openturns/Point.hxx"
#include "openturns/PointWithDescription.hxx"
#include "openturns/PersistentCollection.hxx"
#include "openturns/SquareMatrix.hxx"
#include "openturns/SymmetricMatrix.hxx"
#include "openturns/SymmetricTensor.hxx"
#include "openturns/Tensor.hxx"
#include "openturns/TensorImplementation.hxx"
#include "openturns/ComplexTensorImplementation.hxx"
#include "openturns/ComplexTensor.hxx"
#include "openturns/DomainImplementation.hxx"
#include "openturns/Domain.hxx"
#include "openturns/Interval.hxx"
#include "openturns/ComplexMatrixImplementation.hxx"
#include "openturns/ComplexMatrix.hxx"
#include "openturns/HermitianMatrix.hxx"
#include "openturns/SquareComplexMatrix.hxx"
#include "openturns/TriangularMatrix.hxx"
#include "openturns/TriangularComplexMatrix.hxx"

#endif /* OPENTURNS_OTTYPE_HXX */
