//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS
 *
 *  Copyright 2005-2018 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OT_HXX
#define OPENTURNS_OT_HXX

/*
 * This include defines the configuration flags.
 */
#include "openturns/OTconfig.hxx"


/*
 * This include defines the debug level in all source code.
 */
#include "openturns/OTdebug.h"

/*
 * The OTtypes.hxx header file contains all type declarations used by
 * the OpenTURNS platform.
 */
#include "openturns/OTtypes.hxx"

/*
 * The OTmemory.hxx header file declares some debugging memory functions
 */
#include "openturns/OTmemory.hxx"

/**
 * Here is the list of all classes belonging to the external API of OpenTURNS
 * @todo List the classes belonging to the external API of OpenTURNS
 */
#include "openturns/OTBase.hxx"
#include "openturns/OTUncertainty.hxx"

#endif /* OPENTURNS_OT_HXX */
