#!/usr/bin/env python

from __future__ import print_function
import openturns as ot


size = 8
for dimension in [2, 3]:
    distribution = ot.Normal(dimension)
    for computeSecondOrder in [False, True]:
        experiment = ot.SobolIndicesExperiment(
            distribution, size, computeSecondOrder)
        print('experiment=', experiment)
        sample = experiment.generate()
        print('sample=', sample)
        print('size=', sample.getSize())
