[comment {-*- tcl -*- doctools manpage}]
[manpage_begin coroutine::auto n 1]
[keywords after]
[keywords channel]
[keywords coroutine]
[keywords events]
[keywords exit]
[keywords gets]
[keywords global]
[keywords {green threads}]
[keywords read]
[keywords threads]
[keywords update]
[keywords vwait]
[copyright {2010-2011 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Coroutine utilities}]
[category  Coroutine]
[titledesc {Automatic event and IO coroutine awareness}]
[require Tcl 8.6]
[require coroutine::auto 1.1.1]
[require coroutine 1.1]
[description]

The [package coroutine::auto] package provides no commands or other
directly visible functionality.

Built on top of the package [package coroutine], it intercepts various
builtin commands of the Tcl core to make any code using them
coroutine-oblivious, i.e. able to run inside and outside of a
coroutine without changes.

[para] The commands so affected by this package are
[list_begin definitions]
[def [cmd after]]
[def [cmd exit]]
[def [cmd gets]]
[def [cmd global]]
[def [cmd read]]
[def [cmd update]]
[def [cmd vwait]]
[list_end]

[vset CATEGORY coroutine]
[include ../doctools2base/include/feedback.inc]
[manpage_end]
