;; Copyright (C) 2014  Tommi Höynälänmaa
;; Distributed under GNU General Public License version 3,
;; see file doc/GPL-3.


; *** call-with-current-continuation ***


(import (th-scheme-utilities stdutils))


(define expr-call/cc
  (get-prim-proc-expression
   '_b_call/cc
   (let ((normal-tvar (make-builtin-tvar 'cc1))
	 (jump-tvar (make-builtin-tvar 'cc2)))
     (make-param-proc-class-object
      "instance of :param-proc"
      (list normal-tvar jump-tvar)
      (make-tpti-general-proc
       #t
       (make-tuple-type
	(make-tpti-general-proc
	 #t
	 (make-tuple-type
	  (make-tpti-general-proc
	   #t (make-tuple-type jump-tvar) tt-none #t #f #t #f))
	 normal-tvar #t #f #f #f))
       (make-tt-union normal-tvar jump-tvar)
       #t #f #f #f)))))


(define expr-call/cc-nonpure
  (get-prim-proc-expression
   '_b_call/cc
   (let ((normal-tvar (make-builtin-tvar 'cc3))
	 (jump-tvar (make-builtin-tvar 'cc4)))
     (make-param-proc-class-object
      "instance of :param-proc"
      (list normal-tvar jump-tvar)
      (make-tpti-general-proc
       #t
       (make-tuple-type
	(make-tpti-general-proc
	 #t
	 (make-tuple-type
	  (make-tpti-general-proc
	   #t (make-tuple-type jump-tvar) tt-none #t #f #t #f))
	 normal-tvar #f #f #f #f))
       (make-tt-union normal-tvar jump-tvar)
       #f #f #f #f)))))


(define expr-call/cc-without-result
  (get-prim-proc-expression
   '_b_call/cc-without-result
   (make-tpti-general-proc
    #t
    (make-tuple-type
     (make-tpti-general-proc
      #t
      (make-tuple-type
       (make-tpti-general-proc
	#t (make-tuple-type) tt-none #t #f #t #f))
      tt-none #f #f #f #f))
    tt-none
    #f #f #f #f)))


(define var-call/cc
  (make-normal-variable0
   (alloc-builtin-loc 'call/cc)
   (get-entity-type expr-call/cc)
   #t
   #t #t
   #f
   #f
   #f
   (get-entity-value expr-call/cc)
   expr-call/cc
   #f #f))


(define var-call/cc-nonpure
  (make-normal-variable0
   (alloc-builtin-loc 'call/cc-nonpure)
   (get-entity-type expr-call/cc-nonpure)
   #t
   #t #t
   #f
   #f
   #f
   (get-entity-value expr-call/cc-nonpure)
   expr-call/cc-nonpure
   #f #f))


(define var-call/cc-without-result
  (make-normal-variable0
   (alloc-builtin-loc 'call/cc-without-result)
   (get-entity-type expr-call/cc-without-result)
   #t
   #t #t
   #f
   #f
   #f
   (get-entity-value expr-call/cc-without-result)
   expr-call/cc-without-result
   #f #f))
