/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.sf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.tinyos.packet.BuildSource;
import net.tinyos.sf.SFRenderer;
import net.tinyos.sf.SerialForwarder;

public class SFWindow
extends JPanel
implements WindowListener,
SFRenderer {
    JScrollPane mssgPanel = new JScrollPane();
    JTextArea mssgArea = new JTextArea();
    BorderLayout toplayout = new BorderLayout();
    JTabbedPane pnlTabs = new JTabbedPane();
    JLabel labelPacketsSent = new JLabel();
    JLabel labelServerPort = new JLabel();
    JTextField fieldServerPort = new JTextField();
    JLabel labelMoteCom = new JLabel();
    JLabel labelPacketsReceived = new JLabel();
    JTextField fieldMoteCom = new JTextField();
    ButtonGroup bttnGroup = new ButtonGroup();
    JPanel pnlMain = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JLabel labelNumClients = new JLabel();
    JCheckBox cbVerboseMode = new JCheckBox();
    JButton bStopServer = new JButton();
    GridLayout gridLayout2 = new GridLayout();
    JButton bHelp = new JButton();
    JButton bClear = new JButton();
    JButton bQuit = new JButton();
    private SerialForwarder sf;

    public SFWindow(SerialForwarder serialForwarder) {
        this.sf = serialForwarder;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }

    public static SFWindow createGui(SerialForwarder serialForwarder, String string) {
        JFrame jFrame = new JFrame(string);
        SFWindow sFWindow = new SFWindow(serialForwarder);
        jFrame.setSize(sFWindow.getPreferredSize());
        jFrame.getContentPane().add("Center", sFWindow);
        jFrame.show();
        jFrame.addWindowListener(sFWindow);
        return sFWindow;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.toplayout);
        this.mssgPanel.setVerticalScrollBarPolicy(22);
        this.mssgPanel.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(500, 250));
        this.setPreferredSize(new Dimension(500, 300));
        this.labelPacketsSent.setFont(new Font("Dialog", 1, 10));
        this.labelPacketsSent.setHorizontalTextPosition(2);
        this.labelPacketsSent.setText("Pckts Read: 0");
        this.labelServerPort.setFont(new Font("Dialog", 1, 10));
        this.labelServerPort.setText("Server Port:");
        this.fieldServerPort.setFont(new Font("Dialog", 0, 10));
        this.fieldServerPort.setText(Integer.toString(this.sf.serverPort));
        this.labelMoteCom.setFont(new Font("Dialog", 1, 10));
        this.labelMoteCom.setText("Mote Communications:");
        this.labelPacketsReceived.setFont(new Font("Dialog", 1, 10));
        this.labelPacketsReceived.setHorizontalTextPosition(2);
        this.labelPacketsReceived.setText("Pckts Wrttn: 0");
        this.fieldMoteCom.setFont(new Font("Dialog", 0, 10));
        this.fieldMoteCom.setText(this.sf.motecom);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SFWindow.this.updateGlobals();
            }
        };
        this.bQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SFWindow.this.shutdown();
            }
        });
        this.bQuit.setText("Quit");
        this.bQuit.setFont(new Font("Dialog", 1, 10));
        this.bClear.addActionListener(new ActionListener(){

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                SFWindow.this.mssgArea.setText("");
                SFWindow.this.sf.clearCounts();
            }
        });
        this.bClear.setText("Clear");
        this.bClear.setFont(new Font("Dialog", 1, 10));
        this.bHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SFWindow.this.sf.message("The Mote communications field must");
                SFWindow.this.sf.message("specify a known packet source, one of:");
                SFWindow.this.sf.message(BuildSource.sourceHelp());
            }
        });
        this.bHelp.setText("Help");
        this.bHelp.setFont(new Font("Dialog", 1, 10));
        this.pnlMain.setLayout(this.gridLayout1);
        this.pnlMain.setMinimumSize(new Dimension(150, 75));
        this.pnlMain.setPreferredSize(new Dimension(150, 75));
        this.gridLayout1.setRows(13);
        this.labelNumClients.setFont(new Font("Dialog", 1, 10));
        this.labelNumClients.setText("Num Clients: 0");
        this.cbVerboseMode.setSelected(this.sf.verbose.on);
        this.cbVerboseMode.setText("Verbose Mode");
        this.cbVerboseMode.setFont(new Font("Dialog", 1, 10));
        this.cbVerboseMode.addActionListener(actionListener);
        this.bStopServer.setFont(new Font("Dialog", 1, 10));
        this.bStopServer.setText("Stop Server");
        this.bStopServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((SFWindow)SFWindow.this).sf.listenServer != null) {
                    SFWindow.this.sf.stopListenServer();
                } else {
                    SFWindow.this.updateGlobals();
                    SFWindow.this.sf.startListenServer();
                }
            }
        });
        this.gridLayout2.setRows(15);
        this.gridLayout2.setColumns(1);
        this.toplayout.setHgap(1);
        this.toplayout.setVgap(1);
        this.add((Component)this.mssgPanel, "Center");
        this.add((Component)this.pnlTabs, "East");
        this.pnlTabs.add((Component)this.pnlMain, "Main");
        this.pnlMain.add((Component)this.labelServerPort, null);
        this.pnlMain.add((Component)this.fieldServerPort, null);
        this.pnlMain.add((Component)this.labelMoteCom, null);
        this.pnlMain.add((Component)this.fieldMoteCom, null);
        this.pnlMain.add((Component)this.bStopServer, null);
        this.pnlMain.add((Component)this.cbVerboseMode, null);
        this.pnlMain.add((Component)this.labelPacketsSent, null);
        this.pnlMain.add((Component)this.labelPacketsReceived, null);
        this.pnlMain.add((Component)this.labelNumClients, null);
        this.pnlMain.add((Component)this.bHelp, null);
        this.pnlMain.add((Component)this.bClear, null);
        this.pnlMain.add((Component)this.bQuit, null);
        this.mssgPanel.getViewport().add((Component)this.mssgArea, null);
        this.mssgArea.setFont(new Font("Monospaced", 0, 12));
    }

    public synchronized void windowClosing(WindowEvent windowEvent) {
        this.shutdown();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public synchronized void message(String string) {
        this.mssgArea.append(string + "\n");
        this.mssgArea.setCaretPosition(this.mssgArea.getDocument().getLength());
    }

    public void updatePacketsRead(int n) {
        this.labelPacketsSent.setText("Pckts Read: " + n);
    }

    public void updatePacketsWritten(int n) {
        this.labelPacketsReceived.setText("Pckts Wrttn: " + n);
    }

    public void updateNumClients(int n) {
        this.labelNumClients.setText("Num Clients: " + n);
    }

    private void updateGlobals() {
        this.sf.verbose.on = this.cbVerboseMode.isSelected();
        this.sf.motecom = this.fieldMoteCom.getText();
        this.sf.serverPort = Integer.parseInt(this.fieldServerPort.getText());
    }

    public void updateListenServerStatus(boolean bl) {
        if (!bl) {
            this.bStopServer.setText("Start Server");
        } else {
            this.bStopServer.setText("Stop Server");
        }
    }

    private synchronized void shutdown() {
        this.sf.stopListenServer();
        System.out.println("Serial Forwarder Exited Normally\n");
        System.exit(0);
    }
}

