var UglifyJS = require("../node");
var assert = require("assert");

describe("operator", function() {
    it("Should handle mixing of ++/+/--/- correctly", function() {
        function evaluate(exp) {
            return new Function("var a=1,b=2,c=" + exp + ";return{a:a,b:b,c:c}")();
        }

        [ "", "+", "-" ].forEach(function(p) {
            [ "++a", "--a", "a", "a--", "a++" ].forEach(function(a) {
                [ "+", "-" ].forEach(function(o) {
                    [ "", "+", "-" ].forEach(function(q) {
                        [ "++b", "--b", "b", "b--", "b++" ].forEach(function(b) {
                            var exp = [p, a, o, q, b].join(" ");
                            var orig = evaluate(exp);
                            var uglify = evaluate(UglifyJS.parse(exp).print_to_string());
                            assert.strictEqual(orig.a, uglify.a);
                            assert.strictEqual(orig.b, uglify.b);
                            assert.strictEqual(orig.c, uglify.c);
                            var beautify = evaluate(UglifyJS.parse(exp).print_to_string({
                                beautify: true
                            }));
                            assert.strictEqual(orig.a, beautify.a);
                            assert.strictEqual(orig.b, beautify.b);
                            assert.strictEqual(orig.c, beautify.c);
                        });
                    });
                });
            });
        });
    });
    it("Should remove extraneous spaces", function() {
        [
            [ "++a + ++b", "++a+ ++b" ],
            [ "++a + --b", "++a+--b" ],
            [ "++a + b", "++a+b" ],
            [ "++a + b--", "++a+b--" ],
            [ "++a + b++", "++a+b++" ],
            [ "++a + + ++b", "++a+ + ++b" ],
            [ "++a + + --b", "++a+ +--b" ],
            [ "++a + + b", "++a+ +b" ],
            [ "++a + + b--", "++a+ +b--" ],
            [ "++a + + b++", "++a+ +b++" ],
            [ "++a + - ++b", "++a+-++b" ],
            [ "++a + - --b", "++a+- --b" ],
            [ "++a + - b", "++a+-b" ],
            [ "++a + - b--", "++a+-b--" ],
            [ "++a + - b++", "++a+-b++" ],
            [ "++a - ++b", "++a-++b" ],
            [ "++a - --b", "++a- --b" ],
            [ "++a - b", "++a-b" ],
            [ "++a - b--", "++a-b--" ],
            [ "++a - b++", "++a-b++" ],
            [ "++a - + ++b", "++a-+ ++b" ],
            [ "++a - + --b", "++a-+--b" ],
            [ "++a - + b", "++a-+b" ],
            [ "++a - + b--", "++a-+b--" ],
            [ "++a - + b++", "++a-+b++" ],
            [ "++a - - ++b", "++a- -++b" ],
            [ "++a - - --b", "++a- - --b" ],
            [ "++a - - b", "++a- -b" ],
            [ "++a - - b--", "++a- -b--" ],
            [ "++a - - b++", "++a- -b++" ],
            [ "--a + ++b", "--a+ ++b" ],
            [ "--a + --b", "--a+--b" ],
            [ "--a + b", "--a+b" ],
            [ "--a + b--", "--a+b--" ],
            [ "--a + b++", "--a+b++" ],
            [ "--a + + ++b", "--a+ + ++b" ],
            [ "--a + + --b", "--a+ +--b" ],
            [ "--a + + b", "--a+ +b" ],
            [ "--a + + b--", "--a+ +b--" ],
            [ "--a + + b++", "--a+ +b++" ],
            [ "--a + - ++b", "--a+-++b" ],
            [ "--a + - --b", "--a+- --b" ],
            [ "--a + - b", "--a+-b" ],
            [ "--a + - b--", "--a+-b--" ],
            [ "--a + - b++", "--a+-b++" ],
            [ "--a - ++b", "--a-++b" ],
            [ "--a - --b", "--a- --b" ],
            [ "--a - b", "--a-b" ],
            [ "--a - b--", "--a-b--" ],
            [ "--a - b++", "--a-b++" ],
            [ "--a - + ++b", "--a-+ ++b" ],
            [ "--a - + --b", "--a-+--b" ],
            [ "--a - + b", "--a-+b" ],
            [ "--a - + b--", "--a-+b--" ],
            [ "--a - + b++", "--a-+b++" ],
            [ "--a - - ++b", "--a- -++b" ],
            [ "--a - - --b", "--a- - --b" ],
            [ "--a - - b", "--a- -b" ],
            [ "--a - - b--", "--a- -b--" ],
            [ "--a - - b++", "--a- -b++" ],
            [ "a + ++b", "a+ ++b" ],
            [ "a + --b", "a+--b" ],
            [ "a + b", "a+b" ],
            [ "a + b--", "a+b--" ],
            [ "a + b++", "a+b++" ],
            [ "a + + ++b", "a+ + ++b" ],
            [ "a + + --b", "a+ +--b" ],
            [ "a + + b", "a+ +b" ],
            [ "a + + b--", "a+ +b--" ],
            [ "a + + b++", "a+ +b++" ],
            [ "a + - ++b", "a+-++b" ],
            [ "a + - --b", "a+- --b" ],
            [ "a + - b", "a+-b" ],
            [ "a + - b--", "a+-b--" ],
            [ "a + - b++", "a+-b++" ],
            [ "a - ++b", "a-++b" ],
            [ "a - --b", "a- --b" ],
            [ "a - b", "a-b" ],
            [ "a - b--", "a-b--" ],
            [ "a - b++", "a-b++" ],
            [ "a - + ++b", "a-+ ++b" ],
            [ "a - + --b", "a-+--b" ],
            [ "a - + b", "a-+b" ],
            [ "a - + b--", "a-+b--" ],
            [ "a - + b++", "a-+b++" ],
            [ "a - - ++b", "a- -++b" ],
            [ "a - - --b", "a- - --b" ],
            [ "a - - b", "a- -b" ],
            [ "a - - b--", "a- -b--" ],
            [ "a - - b++", "a- -b++" ],
            [ "a-- + ++b", "a--+ ++b" ],
            [ "a-- + --b", "a--+--b" ],
            [ "a-- + b", "a--+b" ],
            [ "a-- + b--", "a--+b--" ],
            [ "a-- + b++", "a--+b++" ],
            [ "a-- + + ++b", "a--+ + ++b" ],
            [ "a-- + + --b", "a--+ +--b" ],
            [ "a-- + + b", "a--+ +b" ],
            [ "a-- + + b--", "a--+ +b--" ],
            [ "a-- + + b++", "a--+ +b++" ],
            [ "a-- + - ++b", "a--+-++b" ],
            [ "a-- + - --b", "a--+- --b" ],
            [ "a-- + - b", "a--+-b" ],
            [ "a-- + - b--", "a--+-b--" ],
            [ "a-- + - b++", "a--+-b++" ],
            [ "a-- - ++b", "a---++b" ],
            [ "a-- - --b", "a--- --b" ],
            [ "a-- - b", "a---b" ],
            [ "a-- - b--", "a---b--" ],
            [ "a-- - b++", "a---b++" ],
            [ "a-- - + ++b", "a---+ ++b" ],
            [ "a-- - + --b", "a---+--b" ],
            [ "a-- - + b", "a---+b" ],
            [ "a-- - + b--", "a---+b--" ],
            [ "a-- - + b++", "a---+b++" ],
            [ "a-- - - ++b", "a--- -++b" ],
            [ "a-- - - --b", "a--- - --b" ],
            [ "a-- - - b", "a--- -b" ],
            [ "a-- - - b--", "a--- -b--" ],
            [ "a-- - - b++", "a--- -b++" ],
            [ "a++ + ++b", "a+++ ++b" ],
            [ "a++ + --b", "a+++--b" ],
            [ "a++ + b", "a+++b" ],
            [ "a++ + b--", "a+++b--" ],
            [ "a++ + b++", "a+++b++" ],
            [ "a++ + + ++b", "a+++ + ++b" ],
            [ "a++ + + --b", "a+++ +--b" ],
            [ "a++ + + b", "a+++ +b" ],
            [ "a++ + + b--", "a+++ +b--" ],
            [ "a++ + + b++", "a+++ +b++" ],
            [ "a++ + - ++b", "a+++-++b" ],
            [ "a++ + - --b", "a+++- --b" ],
            [ "a++ + - b", "a+++-b" ],
            [ "a++ + - b--", "a+++-b--" ],
            [ "a++ + - b++", "a+++-b++" ],
            [ "a++ - ++b", "a++-++b" ],
            [ "a++ - --b", "a++- --b" ],
            [ "a++ - b", "a++-b" ],
            [ "a++ - b--", "a++-b--" ],
            [ "a++ - b++", "a++-b++" ],
            [ "a++ - + ++b", "a++-+ ++b" ],
            [ "a++ - + --b", "a++-+--b" ],
            [ "a++ - + b", "a++-+b" ],
            [ "a++ - + b--", "a++-+b--" ],
            [ "a++ - + b++", "a++-+b++" ],
            [ "a++ - - ++b", "a++- -++b" ],
            [ "a++ - - --b", "a++- - --b" ],
            [ "a++ - - b", "a++- -b" ],
            [ "a++ - - b--", "a++- -b--" ],
            [ "a++ - - b++", "a++- -b++" ],
            [ "+ ++a + ++b", "+ ++a+ ++b" ],
            [ "+ ++a + --b", "+ ++a+--b" ],
            [ "+ ++a + b", "+ ++a+b" ],
            [ "+ ++a + b--", "+ ++a+b--" ],
            [ "+ ++a + b++", "+ ++a+b++" ],
            [ "+ ++a + + ++b", "+ ++a+ + ++b" ],
            [ "+ ++a + + --b", "+ ++a+ +--b" ],
            [ "+ ++a + + b", "+ ++a+ +b" ],
            [ "+ ++a + + b--", "+ ++a+ +b--" ],
            [ "+ ++a + + b++", "+ ++a+ +b++" ],
            [ "+ ++a + - ++b", "+ ++a+-++b" ],
            [ "+ ++a + - --b", "+ ++a+- --b" ],
            [ "+ ++a + - b", "+ ++a+-b" ],
            [ "+ ++a + - b--", "+ ++a+-b--" ],
            [ "+ ++a + - b++", "+ ++a+-b++" ],
            [ "+ ++a - ++b", "+ ++a-++b" ],
            [ "+ ++a - --b", "+ ++a- --b" ],
            [ "+ ++a - b", "+ ++a-b" ],
            [ "+ ++a - b--", "+ ++a-b--" ],
            [ "+ ++a - b++", "+ ++a-b++" ],
            [ "+ ++a - + ++b", "+ ++a-+ ++b" ],
            [ "+ ++a - + --b", "+ ++a-+--b" ],
            [ "+ ++a - + b", "+ ++a-+b" ],
            [ "+ ++a - + b--", "+ ++a-+b--" ],
            [ "+ ++a - + b++", "+ ++a-+b++" ],
            [ "+ ++a - - ++b", "+ ++a- -++b" ],
            [ "+ ++a - - --b", "+ ++a- - --b" ],
            [ "+ ++a - - b", "+ ++a- -b" ],
            [ "+ ++a - - b--", "+ ++a- -b--" ],
            [ "+ ++a - - b++", "+ ++a- -b++" ],
            [ "+ --a + ++b", "+--a+ ++b" ],
            [ "+ --a + --b", "+--a+--b" ],
            [ "+ --a + b", "+--a+b" ],
            [ "+ --a + b--", "+--a+b--" ],
            [ "+ --a + b++", "+--a+b++" ],
            [ "+ --a + + ++b", "+--a+ + ++b" ],
            [ "+ --a + + --b", "+--a+ +--b" ],
            [ "+ --a + + b", "+--a+ +b" ],
            [ "+ --a + + b--", "+--a+ +b--" ],
            [ "+ --a + + b++", "+--a+ +b++" ],
            [ "+ --a + - ++b", "+--a+-++b" ],
            [ "+ --a + - --b", "+--a+- --b" ],
            [ "+ --a + - b", "+--a+-b" ],
            [ "+ --a + - b--", "+--a+-b--" ],
            [ "+ --a + - b++", "+--a+-b++" ],
            [ "+ --a - ++b", "+--a-++b" ],
            [ "+ --a - --b", "+--a- --b" ],
            [ "+ --a - b", "+--a-b" ],
            [ "+ --a - b--", "+--a-b--" ],
            [ "+ --a - b++", "+--a-b++" ],
            [ "+ --a - + ++b", "+--a-+ ++b" ],
            [ "+ --a - + --b", "+--a-+--b" ],
            [ "+ --a - + b", "+--a-+b" ],
            [ "+ --a - + b--", "+--a-+b--" ],
            [ "+ --a - + b++", "+--a-+b++" ],
            [ "+ --a - - ++b", "+--a- -++b" ],
            [ "+ --a - - --b", "+--a- - --b" ],
            [ "+ --a - - b", "+--a- -b" ],
            [ "+ --a - - b--", "+--a- -b--" ],
            [ "+ --a - - b++", "+--a- -b++" ],
            [ "+ a + ++b", "+a+ ++b" ],
            [ "+ a + --b", "+a+--b" ],
            [ "+ a + b", "+a+b" ],
            [ "+ a + b--", "+a+b--" ],
            [ "+ a + b++", "+a+b++" ],
            [ "+ a + + ++b", "+a+ + ++b" ],
            [ "+ a + + --b", "+a+ +--b" ],
            [ "+ a + + b", "+a+ +b" ],
            [ "+ a + + b--", "+a+ +b--" ],
            [ "+ a + + b++", "+a+ +b++" ],
            [ "+ a + - ++b", "+a+-++b" ],
            [ "+ a + - --b", "+a+- --b" ],
            [ "+ a + - b", "+a+-b" ],
            [ "+ a + - b--", "+a+-b--" ],
            [ "+ a + - b++", "+a+-b++" ],
            [ "+ a - ++b", "+a-++b" ],
            [ "+ a - --b", "+a- --b" ],
            [ "+ a - b", "+a-b" ],
            [ "+ a - b--", "+a-b--" ],
            [ "+ a - b++", "+a-b++" ],
            [ "+ a - + ++b", "+a-+ ++b" ],
            [ "+ a - + --b", "+a-+--b" ],
            [ "+ a - + b", "+a-+b" ],
            [ "+ a - + b--", "+a-+b--" ],
            [ "+ a - + b++", "+a-+b++" ],
            [ "+ a - - ++b", "+a- -++b" ],
            [ "+ a - - --b", "+a- - --b" ],
            [ "+ a - - b", "+a- -b" ],
            [ "+ a - - b--", "+a- -b--" ],
            [ "+ a - - b++", "+a- -b++" ],
            [ "+ a-- + ++b", "+a--+ ++b" ],
            [ "+ a-- + --b", "+a--+--b" ],
            [ "+ a-- + b", "+a--+b" ],
            [ "+ a-- + b--", "+a--+b--" ],
            [ "+ a-- + b++", "+a--+b++" ],
            [ "+ a-- + + ++b", "+a--+ + ++b" ],
            [ "+ a-- + + --b", "+a--+ +--b" ],
            [ "+ a-- + + b", "+a--+ +b" ],
            [ "+ a-- + + b--", "+a--+ +b--" ],
            [ "+ a-- + + b++", "+a--+ +b++" ],
            [ "+ a-- + - ++b", "+a--+-++b" ],
            [ "+ a-- + - --b", "+a--+- --b" ],
            [ "+ a-- + - b", "+a--+-b" ],
            [ "+ a-- + - b--", "+a--+-b--" ],
            [ "+ a-- + - b++", "+a--+-b++" ],
            [ "+ a-- - ++b", "+a---++b" ],
            [ "+ a-- - --b", "+a--- --b" ],
            [ "+ a-- - b", "+a---b" ],
            [ "+ a-- - b--", "+a---b--" ],
            [ "+ a-- - b++", "+a---b++" ],
            [ "+ a-- - + ++b", "+a---+ ++b" ],
            [ "+ a-- - + --b", "+a---+--b" ],
            [ "+ a-- - + b", "+a---+b" ],
            [ "+ a-- - + b--", "+a---+b--" ],
            [ "+ a-- - + b++", "+a---+b++" ],
            [ "+ a-- - - ++b", "+a--- -++b" ],
            [ "+ a-- - - --b", "+a--- - --b" ],
            [ "+ a-- - - b", "+a--- -b" ],
            [ "+ a-- - - b--", "+a--- -b--" ],
            [ "+ a-- - - b++", "+a--- -b++" ],
            [ "+ a++ + ++b", "+a+++ ++b" ],
            [ "+ a++ + --b", "+a+++--b" ],
            [ "+ a++ + b", "+a+++b" ],
            [ "+ a++ + b--", "+a+++b--" ],
            [ "+ a++ + b++", "+a+++b++" ],
            [ "+ a++ + + ++b", "+a+++ + ++b" ],
            [ "+ a++ + + --b", "+a+++ +--b" ],
            [ "+ a++ + + b", "+a+++ +b" ],
            [ "+ a++ + + b--", "+a+++ +b--" ],
            [ "+ a++ + + b++", "+a+++ +b++" ],
            [ "+ a++ + - ++b", "+a+++-++b" ],
            [ "+ a++ + - --b", "+a+++- --b" ],
            [ "+ a++ + - b", "+a+++-b" ],
            [ "+ a++ + - b--", "+a+++-b--" ],
            [ "+ a++ + - b++", "+a+++-b++" ],
            [ "+ a++ - ++b", "+a++-++b" ],
            [ "+ a++ - --b", "+a++- --b" ],
            [ "+ a++ - b", "+a++-b" ],
            [ "+ a++ - b--", "+a++-b--" ],
            [ "+ a++ - b++", "+a++-b++" ],
            [ "+ a++ - + ++b", "+a++-+ ++b" ],
            [ "+ a++ - + --b", "+a++-+--b" ],
            [ "+ a++ - + b", "+a++-+b" ],
            [ "+ a++ - + b--", "+a++-+b--" ],
            [ "+ a++ - + b++", "+a++-+b++" ],
            [ "+ a++ - - ++b", "+a++- -++b" ],
            [ "+ a++ - - --b", "+a++- - --b" ],
            [ "+ a++ - - b", "+a++- -b" ],
            [ "+ a++ - - b--", "+a++- -b--" ],
            [ "+ a++ - - b++", "+a++- -b++" ],
            [ "- ++a + ++b", "-++a+ ++b" ],
            [ "- ++a + --b", "-++a+--b" ],
            [ "- ++a + b", "-++a+b" ],
            [ "- ++a + b--", "-++a+b--" ],
            [ "- ++a + b++", "-++a+b++" ],
            [ "- ++a + + ++b", "-++a+ + ++b" ],
            [ "- ++a + + --b", "-++a+ +--b" ],
            [ "- ++a + + b", "-++a+ +b" ],
            [ "- ++a + + b--", "-++a+ +b--" ],
            [ "- ++a + + b++", "-++a+ +b++" ],
            [ "- ++a + - ++b", "-++a+-++b" ],
            [ "- ++a + - --b", "-++a+- --b" ],
            [ "- ++a + - b", "-++a+-b" ],
            [ "- ++a + - b--", "-++a+-b--" ],
            [ "- ++a + - b++", "-++a+-b++" ],
            [ "- ++a - ++b", "-++a-++b" ],
            [ "- ++a - --b", "-++a- --b" ],
            [ "- ++a - b", "-++a-b" ],
            [ "- ++a - b--", "-++a-b--" ],
            [ "- ++a - b++", "-++a-b++" ],
            [ "- ++a - + ++b", "-++a-+ ++b" ],
            [ "- ++a - + --b", "-++a-+--b" ],
            [ "- ++a - + b", "-++a-+b" ],
            [ "- ++a - + b--", "-++a-+b--" ],
            [ "- ++a - + b++", "-++a-+b++" ],
            [ "- ++a - - ++b", "-++a- -++b" ],
            [ "- ++a - - --b", "-++a- - --b" ],
            [ "- ++a - - b", "-++a- -b" ],
            [ "- ++a - - b--", "-++a- -b--" ],
            [ "- ++a - - b++", "-++a- -b++" ],
            [ "- --a + ++b", "- --a+ ++b" ],
            [ "- --a + --b", "- --a+--b" ],
            [ "- --a + b", "- --a+b" ],
            [ "- --a + b--", "- --a+b--" ],
            [ "- --a + b++", "- --a+b++" ],
            [ "- --a + + ++b", "- --a+ + ++b" ],
            [ "- --a + + --b", "- --a+ +--b" ],
            [ "- --a + + b", "- --a+ +b" ],
            [ "- --a + + b--", "- --a+ +b--" ],
            [ "- --a + + b++", "- --a+ +b++" ],
            [ "- --a + - ++b", "- --a+-++b" ],
            [ "- --a + - --b", "- --a+- --b" ],
            [ "- --a + - b", "- --a+-b" ],
            [ "- --a + - b--", "- --a+-b--" ],
            [ "- --a + - b++", "- --a+-b++" ],
            [ "- --a - ++b", "- --a-++b" ],
            [ "- --a - --b", "- --a- --b" ],
            [ "- --a - b", "- --a-b" ],
            [ "- --a - b--", "- --a-b--" ],
            [ "- --a - b++", "- --a-b++" ],
            [ "- --a - + ++b", "- --a-+ ++b" ],
            [ "- --a - + --b", "- --a-+--b" ],
            [ "- --a - + b", "- --a-+b" ],
            [ "- --a - + b--", "- --a-+b--" ],
            [ "- --a - + b++", "- --a-+b++" ],
            [ "- --a - - ++b", "- --a- -++b" ],
            [ "- --a - - --b", "- --a- - --b" ],
            [ "- --a - - b", "- --a- -b" ],
            [ "- --a - - b--", "- --a- -b--" ],
            [ "- --a - - b++", "- --a- -b++" ],
            [ "- a + ++b", "-a+ ++b" ],
            [ "- a + --b", "-a+--b" ],
            [ "- a + b", "-a+b" ],
            [ "- a + b--", "-a+b--" ],
            [ "- a + b++", "-a+b++" ],
            [ "- a + + ++b", "-a+ + ++b" ],
            [ "- a + + --b", "-a+ +--b" ],
            [ "- a + + b", "-a+ +b" ],
            [ "- a + + b--", "-a+ +b--" ],
            [ "- a + + b++", "-a+ +b++" ],
            [ "- a + - ++b", "-a+-++b" ],
            [ "- a + - --b", "-a+- --b" ],
            [ "- a + - b", "-a+-b" ],
            [ "- a + - b--", "-a+-b--" ],
            [ "- a + - b++", "-a+-b++" ],
            [ "- a - ++b", "-a-++b" ],
            [ "- a - --b", "-a- --b" ],
            [ "- a - b", "-a-b" ],
            [ "- a - b--", "-a-b--" ],
            [ "- a - b++", "-a-b++" ],
            [ "- a - + ++b", "-a-+ ++b" ],
            [ "- a - + --b", "-a-+--b" ],
            [ "- a - + b", "-a-+b" ],
            [ "- a - + b--", "-a-+b--" ],
            [ "- a - + b++", "-a-+b++" ],
            [ "- a - - ++b", "-a- -++b" ],
            [ "- a - - --b", "-a- - --b" ],
            [ "- a - - b", "-a- -b" ],
            [ "- a - - b--", "-a- -b--" ],
            [ "- a - - b++", "-a- -b++" ],
            [ "- a-- + ++b", "-a--+ ++b" ],
            [ "- a-- + --b", "-a--+--b" ],
            [ "- a-- + b", "-a--+b" ],
            [ "- a-- + b--", "-a--+b--" ],
            [ "- a-- + b++", "-a--+b++" ],
            [ "- a-- + + ++b", "-a--+ + ++b" ],
            [ "- a-- + + --b", "-a--+ +--b" ],
            [ "- a-- + + b", "-a--+ +b" ],
            [ "- a-- + + b--", "-a--+ +b--" ],
            [ "- a-- + + b++", "-a--+ +b++" ],
            [ "- a-- + - ++b", "-a--+-++b" ],
            [ "- a-- + - --b", "-a--+- --b" ],
            [ "- a-- + - b", "-a--+-b" ],
            [ "- a-- + - b--", "-a--+-b--" ],
            [ "- a-- + - b++", "-a--+-b++" ],
            [ "- a-- - ++b", "-a---++b" ],
            [ "- a-- - --b", "-a--- --b" ],
            [ "- a-- - b", "-a---b" ],
            [ "- a-- - b--", "-a---b--" ],
            [ "- a-- - b++", "-a---b++" ],
            [ "- a-- - + ++b", "-a---+ ++b" ],
            [ "- a-- - + --b", "-a---+--b" ],
            [ "- a-- - + b", "-a---+b" ],
            [ "- a-- - + b--", "-a---+b--" ],
            [ "- a-- - + b++", "-a---+b++" ],
            [ "- a-- - - ++b", "-a--- -++b" ],
            [ "- a-- - - --b", "-a--- - --b" ],
            [ "- a-- - - b", "-a--- -b" ],
            [ "- a-- - - b--", "-a--- -b--" ],
            [ "- a-- - - b++", "-a--- -b++" ],
            [ "- a++ + ++b", "-a+++ ++b" ],
            [ "- a++ + --b", "-a+++--b" ],
            [ "- a++ + b", "-a+++b" ],
            [ "- a++ + b--", "-a+++b--" ],
            [ "- a++ + b++", "-a+++b++" ],
            [ "- a++ + + ++b", "-a+++ + ++b" ],
            [ "- a++ + + --b", "-a+++ +--b" ],
            [ "- a++ + + b", "-a+++ +b" ],
            [ "- a++ + + b--", "-a+++ +b--" ],
            [ "- a++ + + b++", "-a+++ +b++" ],
            [ "- a++ + - ++b", "-a+++-++b" ],
            [ "- a++ + - --b", "-a+++- --b" ],
            [ "- a++ + - b", "-a+++-b" ],
            [ "- a++ + - b--", "-a+++-b--" ],
            [ "- a++ + - b++", "-a+++-b++" ],
            [ "- a++ - ++b", "-a++-++b" ],
            [ "- a++ - --b", "-a++- --b" ],
            [ "- a++ - b", "-a++-b" ],
            [ "- a++ - b--", "-a++-b--" ],
            [ "- a++ - b++", "-a++-b++" ],
            [ "- a++ - + ++b", "-a++-+ ++b" ],
            [ "- a++ - + --b", "-a++-+--b" ],
            [ "- a++ - + b", "-a++-+b" ],
            [ "- a++ - + b--", "-a++-+b--" ],
            [ "- a++ - + b++", "-a++-+b++" ],
            [ "- a++ - - ++b", "-a++- -++b" ],
            [ "- a++ - - --b", "-a++- - --b" ],
            [ "- a++ - - b", "-a++- -b" ],
            [ "- a++ - - b--", "-a++- -b--" ],
            [ "- a++ - - b++", "-a++- -b++" ],
        ].forEach(function(exp) {
            assert.strictEqual(UglifyJS.parse(exp[0]).print_to_string(), exp[1] + ";");
        });
    });
});
