/* valagobjectmodule.c generated by valac, the Vala compiler
 * generated from valagobjectmodule.vala, do not modify */

/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <valaccode.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))

struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};


static gpointer vala_gobject_module_parent_class = NULL;

#define VALA_GOBJECT_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModulePrivate))
static void vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                           ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                            ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                                    ValaClass* cl);
static void vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                                   ValaClass* cl);
static gboolean vala_gobject_module_has_valid_gobject_property_type (ValaGObjectModule* self,
                                                              ValaProperty* prop);
static void vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                                 ValaSymbol* sym,
                                                 ValaCCodeExpression* expression);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self);
static void vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                                 ValaConstructor* c);
static gchar* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                                   ValaDynamicProperty* prop);
static gchar* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                          ValaDynamicSignal* node);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                         ValaDynamicSignal* sig);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                           ValaDynamicSignal* sig,
                                                           gboolean after);
static gchar* vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                               ValaDynamicSignal* sig);
static void vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                              ValaProperty* prop);
static gboolean vala_gobject_module_real_is_gobject_property (ValaCCodeBaseModule* base,
                                                       ValaProperty* prop);
static void vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static void vala_gobject_module_finalize (ValaCodeVisitor * obj);


static void
vala_gobject_module_real_visit_class (ValaCodeVisitor* base,
                                      ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceReference* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp8_ = FALSE;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_class ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), cl);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
	_tmp2_ = _tmp1_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp2_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp3_ = TRUE;
	} else {
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ > 0;
		_vala_iterable_unref0 (_tmp5_);
	}
	if (_tmp3_) {
		vala_gobject_module_add_get_property_function (self, cl);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp8_ = TRUE;
	} else {
		ValaList* _tmp9_;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp9_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ > 0;
		_vala_iterable_unref0 (_tmp10_);
	}
	if (_tmp8_) {
		vala_gobject_module_add_set_property_function (self, cl);
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static void
vala_gobject_module_real_generate_class_init (ValaGTypeModule* base,
                                              ValaClass* cl)
{
	ValaGObjectModule * self;
	ValaTypeSymbol* _tmp0_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp24_ = FALSE;
	ValaConstructor* _tmp40_;
	ValaConstructor* _tmp41_;
	gboolean _tmp60_ = FALSE;
	ValaList* _tmp61_;
	ValaList* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gboolean _tmp65_;
	ValaList* props = NULL;
	ValaList* _tmp237_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = ((ValaCCodeBaseModule*) self)->gobject_type;
	if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, _tmp0_)) {
		return;
	}
	_tmp1_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2_);
	_tmp4_ = _tmp3_;
	_vala_ccode_node_unref0 (_tmp2_);
	ccall = _tmp4_;
	_tmp5_ = ccall;
	_tmp6_ = vala_ccode_identifier_new ("klass");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (_tmp5_, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	if (vala_gobject_module_class_has_readable_properties (self, cl)) {
		_tmp8_ = TRUE;
	} else {
		ValaList* _tmp9_;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp9_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ > 0;
		_vala_iterable_unref0 (_tmp10_);
	}
	if (_tmp8_) {
		ValaCCodeFunction* _tmp13_;
		ValaCCodeFunction* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_;
		ValaCCodeMemberAccess* _tmp16_;
		ValaCCodeMemberAccess* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		ValaCCodeIdentifier* _tmp22_;
		ValaCCodeIdentifier* _tmp23_;
		_tmp13_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = ccall;
		_tmp16_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp15_, "get_property");
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("_vala_%s_get_property", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_ccode_identifier_new (_tmp21_);
		_tmp23_ = _tmp22_;
		vala_ccode_function_add_assignment (_tmp14_, (ValaCCodeExpression*) _tmp17_, (ValaCCodeExpression*) _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_vala_ccode_node_unref0 (_tmp17_);
	}
	if (vala_gobject_module_class_has_writable_properties (self, cl)) {
		_tmp24_ = TRUE;
	} else {
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp25_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_ > 0;
		_vala_iterable_unref0 (_tmp26_);
	}
	if (_tmp24_) {
		ValaCCodeFunction* _tmp29_;
		ValaCCodeFunction* _tmp30_;
		ValaCCodeFunctionCall* _tmp31_;
		ValaCCodeMemberAccess* _tmp32_;
		ValaCCodeMemberAccess* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		ValaCCodeIdentifier* _tmp38_;
		ValaCCodeIdentifier* _tmp39_;
		_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp30_ = _tmp29_;
		_tmp31_ = ccall;
		_tmp32_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp31_, "set_property");
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup_printf ("_vala_%s_set_property", _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_ccode_identifier_new (_tmp37_);
		_tmp39_ = _tmp38_;
		vala_ccode_function_add_assignment (_tmp30_, (ValaCCodeExpression*) _tmp33_, (ValaCCodeExpression*) _tmp39_);
		_vala_ccode_node_unref0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
		_vala_ccode_node_unref0 (_tmp33_);
	}
	_tmp40_ = vala_class_get_constructor (cl);
	_tmp41_ = _tmp40_;
	if (_tmp41_ != NULL) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp42_;
		ValaCCodeIdentifier* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeFunctionCall* _tmp46_;
		ValaCCodeIdentifier* _tmp47_;
		ValaCCodeIdentifier* _tmp48_;
		ValaCCodeFunction* _tmp49_;
		ValaCCodeFunction* _tmp50_;
		ValaCCodeFunctionCall* _tmp51_;
		ValaCCodeMemberAccess* _tmp52_;
		ValaCCodeMemberAccess* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		_tmp42_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
		_tmp45_ = _tmp44_;
		_vala_ccode_node_unref0 (_tmp43_);
		ccast = _tmp45_;
		_tmp46_ = ccast;
		_tmp47_ = vala_ccode_identifier_new ("klass");
		_tmp48_ = _tmp47_;
		vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
		_vala_ccode_node_unref0 (_tmp48_);
		_tmp49_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp50_ = _tmp49_;
		_tmp51_ = ccast;
		_tmp52_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp51_, "constructor");
		_tmp53_ = _tmp52_;
		_tmp54_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strdup_printf ("%s_constructor", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_ccode_identifier_new (_tmp57_);
		_tmp59_ = _tmp58_;
		vala_ccode_function_add_assignment (_tmp50_, (ValaCCodeExpression*) _tmp53_, (ValaCCodeExpression*) _tmp59_);
		_vala_ccode_node_unref0 (_tmp59_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_vala_ccode_node_unref0 (_tmp53_);
		_vala_ccode_node_unref0 (ccast);
	}
	_tmp61_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) cl);
	_tmp62_ = _tmp61_;
	_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = _tmp64_ > 0;
	_vala_iterable_unref0 (_tmp62_);
	if (_tmp65_) {
		_tmp60_ = TRUE;
	} else {
		ValaDestructor* _tmp66_;
		ValaDestructor* _tmp67_;
		_tmp66_ = vala_class_get_destructor (cl);
		_tmp67_ = _tmp66_;
		_tmp60_ = _tmp67_ != NULL;
	}
	if (_tmp60_) {
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeFunctionCall* _tmp70_;
		ValaCCodeFunctionCall* _tmp71_;
		ValaCCodeFunctionCall* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeFunction* _tmp75_;
		ValaCCodeFunction* _tmp76_;
		ValaCCodeFunctionCall* _tmp77_;
		ValaCCodeMemberAccess* _tmp78_;
		ValaCCodeMemberAccess* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		ValaCCodeIdentifier* _tmp84_;
		ValaCCodeIdentifier* _tmp85_;
		_tmp68_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp69_);
		_tmp71_ = _tmp70_;
		_vala_ccode_node_unref0 (_tmp69_);
		ccast = _tmp71_;
		_tmp72_ = ccast;
		_tmp73_ = vala_ccode_identifier_new ("klass");
		_tmp74_ = _tmp73_;
		vala_ccode_function_call_add_argument (_tmp72_, (ValaCCodeExpression*) _tmp74_);
		_vala_ccode_node_unref0 (_tmp74_);
		_tmp75_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = ccast;
		_tmp78_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp77_, "finalize");
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
		_tmp81_ = _tmp80_;
		_tmp82_ = g_strdup_printf ("%s_finalize", _tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_ccode_identifier_new (_tmp83_);
		_tmp85_ = _tmp84_;
		vala_ccode_function_add_assignment (_tmp76_, (ValaCCodeExpression*) _tmp79_, (ValaCCodeExpression*) _tmp85_);
		_vala_ccode_node_unref0 (_tmp85_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		_vala_ccode_node_unref0 (_tmp79_);
		_vala_ccode_node_unref0 (ccast);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp86_;
		gint _type_param_size = 0;
		ValaList* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _type_param_index = 0;
		_tmp86_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp86_;
		_tmp87_ = _type_param_list;
		_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
		_tmp89_ = _tmp88_;
		_type_param_size = _tmp89_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp93_;
			gint _tmp94_;
			gpointer _tmp95_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeConstant* func_name_constant = NULL;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeFunctionCall* cspec = NULL;
			gchar* name_prefix = NULL;
			ValaTypeParameter* _tmp96_;
			const gchar* _tmp97_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* canonical_prefix = NULL;
			const gchar* _tmp100_;
			gchar* _tmp101_;
			const gchar* _tmp102_;
			gchar* _tmp103_;
			const gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			ValaCCodeConstant* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			const gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			ValaCCodeIdentifier* _tmp114_;
			ValaCCodeIdentifier* _tmp115_;
			ValaCCodeFunctionCall* _tmp116_;
			ValaCCodeFunctionCall* _tmp117_;
			ValaCCodeFunctionCall* _tmp118_;
			ValaCCodeFunctionCall* _tmp119_;
			const gchar* _tmp120_;
			ValaCCodeConstant* _tmp121_;
			ValaCCodeConstant* _tmp122_;
			ValaCCodeIdentifier* _tmp123_;
			ValaCCodeIdentifier* _tmp124_;
			ValaCCodeFunctionCall* _tmp125_;
			ValaCCodeFunctionCall* _tmp126_;
			ValaCCodeConstant* _tmp127_;
			ValaCCodeFunctionCall* _tmp128_;
			ValaCCodeConstant* _tmp129_;
			ValaCCodeConstant* _tmp130_;
			ValaCCodeFunctionCall* _tmp131_;
			ValaCCodeConstant* _tmp132_;
			ValaCCodeConstant* _tmp133_;
			ValaCCodeFunctionCall* _tmp134_;
			ValaCCodeIdentifier* _tmp135_;
			ValaCCodeIdentifier* _tmp136_;
			ValaCCodeFunctionCall* _tmp137_;
			ValaCCodeConstant* _tmp138_;
			ValaCCodeConstant* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaCCodeFunction* _tmp142_;
			ValaCCodeFunction* _tmp143_;
			ValaCCodeFunctionCall* _tmp144_;
			ValaCCodeEnum* _tmp145_;
			const gchar* _tmp146_;
			ValaCCodeEnumValue* _tmp147_;
			ValaCCodeEnumValue* _tmp148_;
			const gchar* _tmp149_;
			gchar* _tmp150_;
			const gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			ValaCCodeConstant* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			const gchar* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			ValaCCodeIdentifier* _tmp161_;
			ValaCCodeIdentifier* _tmp162_;
			ValaCCodeFunctionCall* _tmp163_;
			ValaCCodeFunctionCall* _tmp164_;
			ValaCCodeFunctionCall* _tmp165_;
			ValaCCodeFunctionCall* _tmp166_;
			const gchar* _tmp167_;
			ValaCCodeConstant* _tmp168_;
			ValaCCodeConstant* _tmp169_;
			ValaCCodeIdentifier* _tmp170_;
			ValaCCodeIdentifier* _tmp171_;
			ValaCCodeFunctionCall* _tmp172_;
			ValaCCodeFunctionCall* _tmp173_;
			ValaCCodeConstant* _tmp174_;
			ValaCCodeFunctionCall* _tmp175_;
			ValaCCodeConstant* _tmp176_;
			ValaCCodeConstant* _tmp177_;
			ValaCCodeFunctionCall* _tmp178_;
			ValaCCodeConstant* _tmp179_;
			ValaCCodeConstant* _tmp180_;
			ValaCCodeFunctionCall* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			ValaCCodeConstant* _tmp183_;
			ValaCCodeFunctionCall* _tmp184_;
			ValaCCodeFunctionCall* _tmp185_;
			ValaCCodeFunction* _tmp186_;
			ValaCCodeFunction* _tmp187_;
			ValaCCodeFunctionCall* _tmp188_;
			ValaCCodeEnum* _tmp189_;
			const gchar* _tmp190_;
			ValaCCodeEnumValue* _tmp191_;
			ValaCCodeEnumValue* _tmp192_;
			const gchar* _tmp193_;
			gchar* _tmp194_;
			const gchar* _tmp195_;
			gchar* _tmp196_;
			gchar* _tmp197_;
			ValaCCodeConstant* _tmp198_;
			gchar* _tmp199_;
			gchar* _tmp200_;
			const gchar* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gchar* _tmp204_;
			ValaCCodeIdentifier* _tmp205_;
			ValaCCodeIdentifier* _tmp206_;
			ValaCCodeFunctionCall* _tmp207_;
			ValaCCodeFunctionCall* _tmp208_;
			ValaCCodeFunctionCall* _tmp209_;
			ValaCCodeFunctionCall* _tmp210_;
			const gchar* _tmp211_;
			ValaCCodeConstant* _tmp212_;
			ValaCCodeConstant* _tmp213_;
			ValaCCodeIdentifier* _tmp214_;
			ValaCCodeIdentifier* _tmp215_;
			ValaCCodeFunctionCall* _tmp216_;
			ValaCCodeFunctionCall* _tmp217_;
			ValaCCodeConstant* _tmp218_;
			ValaCCodeFunctionCall* _tmp219_;
			ValaCCodeConstant* _tmp220_;
			ValaCCodeConstant* _tmp221_;
			ValaCCodeFunctionCall* _tmp222_;
			ValaCCodeConstant* _tmp223_;
			ValaCCodeConstant* _tmp224_;
			ValaCCodeFunctionCall* _tmp225_;
			ValaCCodeConstant* _tmp226_;
			ValaCCodeConstant* _tmp227_;
			ValaCCodeFunctionCall* _tmp228_;
			ValaCCodeFunctionCall* _tmp229_;
			ValaCCodeFunction* _tmp230_;
			ValaCCodeFunction* _tmp231_;
			ValaCCodeFunctionCall* _tmp232_;
			ValaCCodeEnum* _tmp233_;
			const gchar* _tmp234_;
			ValaCCodeEnumValue* _tmp235_;
			ValaCCodeEnumValue* _tmp236_;
			_tmp90_ = _type_param_index;
			_type_param_index = _tmp90_ + 1;
			_tmp91_ = _type_param_index;
			_tmp92_ = _type_param_size;
			if (!(_tmp91_ < _tmp92_)) {
				break;
			}
			_tmp93_ = _type_param_list;
			_tmp94_ = _type_param_index;
			_tmp95_ = vala_list_get (_tmp93_, _tmp94_);
			type_param = (ValaTypeParameter*) _tmp95_;
			_tmp96_ = type_param;
			_tmp97_ = vala_symbol_get_name ((ValaSymbol*) _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_utf8_strdown (_tmp98_, (gssize) -1);
			name_prefix = _tmp99_;
			_tmp100_ = name_prefix;
			_tmp101_ = string_replace (_tmp100_, "_", "-");
			canonical_prefix = _tmp101_;
			_tmp102_ = name_prefix;
			_tmp103_ = g_strdup_printf ("%s_type", _tmp102_);
			_g_free0 (func_name);
			func_name = _tmp103_;
			_tmp104_ = canonical_prefix;
			_tmp105_ = g_strdup_printf ("\"%s-type\"", _tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_ccode_constant_new (_tmp106_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp107_;
			_g_free0 (_tmp106_);
			_tmp108_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp109_ = _tmp108_;
			_tmp110_ = func_name;
			_tmp111_ = g_strdup_printf ("%s_%s", _tmp109_, _tmp110_);
			_tmp112_ = _tmp111_;
			_tmp113_ = g_ascii_strup (_tmp112_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp113_;
			_g_free0 (_tmp112_);
			_g_free0 (_tmp109_);
			_tmp114_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp116_;
			_vala_ccode_node_unref0 (_tmp115_);
			_tmp117_ = cinst;
			_tmp118_ = ccall;
			vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp118_);
			_tmp119_ = cinst;
			_tmp120_ = enum_value;
			_tmp121_ = vala_ccode_constant_new (_tmp120_);
			_tmp122_ = _tmp121_;
			vala_ccode_function_call_add_argument (_tmp119_, (ValaCCodeExpression*) _tmp122_);
			_vala_ccode_node_unref0 (_tmp122_);
			_tmp123_ = vala_ccode_identifier_new ("g_param_spec_gtype");
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp124_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp125_;
			_vala_ccode_node_unref0 (_tmp124_);
			_tmp126_ = cspec;
			_tmp127_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp126_, (ValaCCodeExpression*) _tmp127_);
			_tmp128_ = cspec;
			_tmp129_ = vala_ccode_constant_new ("\"type\"");
			_tmp130_ = _tmp129_;
			vala_ccode_function_call_add_argument (_tmp128_, (ValaCCodeExpression*) _tmp130_);
			_vala_ccode_node_unref0 (_tmp130_);
			_tmp131_ = cspec;
			_tmp132_ = vala_ccode_constant_new ("\"type\"");
			_tmp133_ = _tmp132_;
			vala_ccode_function_call_add_argument (_tmp131_, (ValaCCodeExpression*) _tmp133_);
			_vala_ccode_node_unref0 (_tmp133_);
			_tmp134_ = cspec;
			_tmp135_ = vala_ccode_identifier_new ("G_TYPE_NONE");
			_tmp136_ = _tmp135_;
			vala_ccode_function_call_add_argument (_tmp134_, (ValaCCodeExpression*) _tmp136_);
			_vala_ccode_node_unref0 (_tmp136_);
			_tmp137_ = cspec;
			_tmp138_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY");
			_tmp139_ = _tmp138_;
			vala_ccode_function_call_add_argument (_tmp137_, (ValaCCodeExpression*) _tmp139_);
			_vala_ccode_node_unref0 (_tmp139_);
			_tmp140_ = cinst;
			_tmp141_ = cspec;
			vala_ccode_function_call_add_argument (_tmp140_, (ValaCCodeExpression*) _tmp141_);
			_tmp142_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp143_ = _tmp142_;
			_tmp144_ = cinst;
			vala_ccode_function_add_expression (_tmp143_, (ValaCCodeExpression*) _tmp144_);
			_tmp145_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp146_ = enum_value;
			_tmp147_ = vala_ccode_enum_value_new (_tmp146_, NULL);
			_tmp148_ = _tmp147_;
			vala_ccode_enum_add_value (_tmp145_, _tmp148_);
			_vala_ccode_node_unref0 (_tmp148_);
			_tmp149_ = name_prefix;
			_tmp150_ = g_strdup_printf ("%s_dup_func", _tmp149_);
			_g_free0 (func_name);
			func_name = _tmp150_;
			_tmp151_ = canonical_prefix;
			_tmp152_ = g_strdup_printf ("\"%s-dup-func\"", _tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_ccode_constant_new (_tmp153_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp154_;
			_g_free0 (_tmp153_);
			_tmp155_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp156_ = _tmp155_;
			_tmp157_ = func_name;
			_tmp158_ = g_strdup_printf ("%s_%s", _tmp156_, _tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = g_ascii_strup (_tmp159_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp160_;
			_g_free0 (_tmp159_);
			_g_free0 (_tmp156_);
			_tmp161_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp162_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp163_;
			_vala_ccode_node_unref0 (_tmp162_);
			_tmp164_ = cinst;
			_tmp165_ = ccall;
			vala_ccode_function_call_add_argument (_tmp164_, (ValaCCodeExpression*) _tmp165_);
			_tmp166_ = cinst;
			_tmp167_ = enum_value;
			_tmp168_ = vala_ccode_constant_new (_tmp167_);
			_tmp169_ = _tmp168_;
			vala_ccode_function_call_add_argument (_tmp166_, (ValaCCodeExpression*) _tmp169_);
			_vala_ccode_node_unref0 (_tmp169_);
			_tmp170_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp172_;
			_vala_ccode_node_unref0 (_tmp171_);
			_tmp173_ = cspec;
			_tmp174_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp173_, (ValaCCodeExpression*) _tmp174_);
			_tmp175_ = cspec;
			_tmp176_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp177_ = _tmp176_;
			vala_ccode_function_call_add_argument (_tmp175_, (ValaCCodeExpression*) _tmp177_);
			_vala_ccode_node_unref0 (_tmp177_);
			_tmp178_ = cspec;
			_tmp179_ = vala_ccode_constant_new ("\"dup func\"");
			_tmp180_ = _tmp179_;
			vala_ccode_function_call_add_argument (_tmp178_, (ValaCCodeExpression*) _tmp180_);
			_vala_ccode_node_unref0 (_tmp180_);
			_tmp181_ = cspec;
			_tmp182_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY");
			_tmp183_ = _tmp182_;
			vala_ccode_function_call_add_argument (_tmp181_, (ValaCCodeExpression*) _tmp183_);
			_vala_ccode_node_unref0 (_tmp183_);
			_tmp184_ = cinst;
			_tmp185_ = cspec;
			vala_ccode_function_call_add_argument (_tmp184_, (ValaCCodeExpression*) _tmp185_);
			_tmp186_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp187_ = _tmp186_;
			_tmp188_ = cinst;
			vala_ccode_function_add_expression (_tmp187_, (ValaCCodeExpression*) _tmp188_);
			_tmp189_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp190_ = enum_value;
			_tmp191_ = vala_ccode_enum_value_new (_tmp190_, NULL);
			_tmp192_ = _tmp191_;
			vala_ccode_enum_add_value (_tmp189_, _tmp192_);
			_vala_ccode_node_unref0 (_tmp192_);
			_tmp193_ = name_prefix;
			_tmp194_ = g_strdup_printf ("%s_destroy_func", _tmp193_);
			_g_free0 (func_name);
			func_name = _tmp194_;
			_tmp195_ = canonical_prefix;
			_tmp196_ = g_strdup_printf ("\"%s-destroy-func\"", _tmp195_);
			_tmp197_ = _tmp196_;
			_tmp198_ = vala_ccode_constant_new (_tmp197_);
			_vala_ccode_node_unref0 (func_name_constant);
			func_name_constant = _tmp198_;
			_g_free0 (_tmp197_);
			_tmp199_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp200_ = _tmp199_;
			_tmp201_ = func_name;
			_tmp202_ = g_strdup_printf ("%s_%s", _tmp200_, _tmp201_);
			_tmp203_ = _tmp202_;
			_tmp204_ = g_ascii_strup (_tmp203_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp204_;
			_g_free0 (_tmp203_);
			_g_free0 (_tmp200_);
			_tmp205_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp206_ = _tmp205_;
			_tmp207_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp206_);
			_vala_ccode_node_unref0 (cinst);
			cinst = _tmp207_;
			_vala_ccode_node_unref0 (_tmp206_);
			_tmp208_ = cinst;
			_tmp209_ = ccall;
			vala_ccode_function_call_add_argument (_tmp208_, (ValaCCodeExpression*) _tmp209_);
			_tmp210_ = cinst;
			_tmp211_ = enum_value;
			_tmp212_ = vala_ccode_constant_new (_tmp211_);
			_tmp213_ = _tmp212_;
			vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp213_);
			_vala_ccode_node_unref0 (_tmp213_);
			_tmp214_ = vala_ccode_identifier_new ("g_param_spec_pointer");
			_tmp215_ = _tmp214_;
			_tmp216_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp215_);
			_vala_ccode_node_unref0 (cspec);
			cspec = _tmp216_;
			_vala_ccode_node_unref0 (_tmp215_);
			_tmp217_ = cspec;
			_tmp218_ = func_name_constant;
			vala_ccode_function_call_add_argument (_tmp217_, (ValaCCodeExpression*) _tmp218_);
			_tmp219_ = cspec;
			_tmp220_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp221_ = _tmp220_;
			vala_ccode_function_call_add_argument (_tmp219_, (ValaCCodeExpression*) _tmp221_);
			_vala_ccode_node_unref0 (_tmp221_);
			_tmp222_ = cspec;
			_tmp223_ = vala_ccode_constant_new ("\"destroy func\"");
			_tmp224_ = _tmp223_;
			vala_ccode_function_call_add_argument (_tmp222_, (ValaCCodeExpression*) _tmp224_);
			_vala_ccode_node_unref0 (_tmp224_);
			_tmp225_ = cspec;
			_tmp226_ = vala_ccode_constant_new ("G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY");
			_tmp227_ = _tmp226_;
			vala_ccode_function_call_add_argument (_tmp225_, (ValaCCodeExpression*) _tmp227_);
			_vala_ccode_node_unref0 (_tmp227_);
			_tmp228_ = cinst;
			_tmp229_ = cspec;
			vala_ccode_function_call_add_argument (_tmp228_, (ValaCCodeExpression*) _tmp229_);
			_tmp230_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp231_ = _tmp230_;
			_tmp232_ = cinst;
			vala_ccode_function_add_expression (_tmp231_, (ValaCCodeExpression*) _tmp232_);
			_tmp233_ = ((ValaCCodeBaseModule*) self)->prop_enum;
			_tmp234_ = enum_value;
			_tmp235_ = vala_ccode_enum_value_new (_tmp234_, NULL);
			_tmp236_ = _tmp235_;
			vala_ccode_enum_add_value (_tmp233_, _tmp236_);
			_vala_ccode_node_unref0 (_tmp236_);
			_g_free0 (canonical_prefix);
			_g_free0 (name_prefix);
			_vala_ccode_node_unref0 (cspec);
			_vala_ccode_node_unref0 (cinst);
			_vala_ccode_node_unref0 (func_name_constant);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp237_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	props = _tmp237_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp238_;
		ValaList* _tmp239_;
		gint _prop_size = 0;
		ValaList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _prop_index = 0;
		_tmp238_ = props;
		_tmp239_ = _vala_iterable_ref0 (_tmp238_);
		_prop_list = _tmp239_;
		_tmp240_ = _prop_list;
		_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_prop_size = _tmp242_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			gint _tmp245_;
			ValaProperty* prop = NULL;
			ValaList* _tmp246_;
			gint _tmp247_;
			gpointer _tmp248_;
			ValaProperty* _tmp249_;
			ValaProperty* _tmp261_;
			ValaComment* _tmp262_;
			ValaComment* _tmp263_;
			ValaCCodeFunctionCall* cinst = NULL;
			ValaCCodeIdentifier* _tmp273_;
			ValaCCodeIdentifier* _tmp274_;
			ValaCCodeFunctionCall* _tmp275_;
			ValaCCodeFunctionCall* _tmp276_;
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaCCodeFunctionCall* _tmp279_;
			ValaProperty* _tmp280_;
			gchar* _tmp281_;
			gchar* _tmp282_;
			gchar* _tmp283_;
			gchar* _tmp284_;
			ValaCCodeConstant* _tmp285_;
			ValaCCodeConstant* _tmp286_;
			ValaCCodeFunctionCall* _tmp287_;
			ValaProperty* _tmp288_;
			ValaCCodeExpression* _tmp289_;
			ValaCCodeExpression* _tmp290_;
			ValaCCodeFunction* _tmp291_;
			ValaCCodeFunction* _tmp292_;
			ValaCCodeFunctionCall* _tmp293_;
			_tmp243_ = _prop_index;
			_prop_index = _tmp243_ + 1;
			_tmp244_ = _prop_index;
			_tmp245_ = _prop_size;
			if (!(_tmp244_ < _tmp245_)) {
				break;
			}
			_tmp246_ = _prop_list;
			_tmp247_ = _prop_index;
			_tmp248_ = vala_list_get (_tmp246_, _tmp247_);
			prop = (ValaProperty*) _tmp248_;
			_tmp249_ = prop;
			if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, _tmp249_)) {
				ValaProperty* _tmp250_;
				_tmp250_ = prop;
				if (!vala_gobject_module_has_valid_gobject_property_type (self, _tmp250_)) {
					ValaProperty* _tmp251_;
					ValaSourceReference* _tmp252_;
					ValaSourceReference* _tmp253_;
					ValaProperty* _tmp254_;
					ValaDataType* _tmp255_;
					ValaDataType* _tmp256_;
					gchar* _tmp257_;
					gchar* _tmp258_;
					gchar* _tmp259_;
					gchar* _tmp260_;
					_tmp251_ = prop;
					_tmp252_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = prop;
					_tmp255_ = vala_property_get_property_type (_tmp254_);
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_data_type_to_qualified_string (_tmp256_, NULL);
					_tmp258_ = _tmp257_;
					_tmp259_ = g_strdup_printf ("Type `%s' can not be used for a GLib.Object property", _tmp258_);
					_tmp260_ = _tmp259_;
					vala_report_warning (_tmp253_, _tmp260_);
					_g_free0 (_tmp260_);
					_g_free0 (_tmp258_);
				}
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp261_ = prop;
			_tmp262_ = vala_symbol_get_comment ((ValaSymbol*) _tmp261_);
			_tmp263_ = _tmp262_;
			if (_tmp263_ != NULL) {
				ValaCCodeFunction* _tmp264_;
				ValaCCodeFunction* _tmp265_;
				ValaProperty* _tmp266_;
				ValaComment* _tmp267_;
				ValaComment* _tmp268_;
				const gchar* _tmp269_;
				const gchar* _tmp270_;
				ValaCCodeComment* _tmp271_;
				ValaCCodeComment* _tmp272_;
				_tmp264_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp265_ = _tmp264_;
				_tmp266_ = prop;
				_tmp267_ = vala_symbol_get_comment ((ValaSymbol*) _tmp266_);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_comment_get_content (_tmp268_);
				_tmp270_ = _tmp269_;
				_tmp271_ = vala_ccode_comment_new (_tmp270_);
				_tmp272_ = _tmp271_;
				vala_ccode_function_add_statement (_tmp265_, (ValaCCodeNode*) _tmp272_);
				_vala_ccode_node_unref0 (_tmp272_);
			}
			_tmp273_ = vala_ccode_identifier_new ("g_object_class_install_property");
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp274_);
			_tmp276_ = _tmp275_;
			_vala_ccode_node_unref0 (_tmp274_);
			cinst = _tmp276_;
			_tmp277_ = cinst;
			_tmp278_ = ccall;
			vala_ccode_function_call_add_argument (_tmp277_, (ValaCCodeExpression*) _tmp278_);
			_tmp279_ = cinst;
			_tmp280_ = prop;
			_tmp281_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp280_, NULL);
			_tmp282_ = _tmp281_;
			_tmp283_ = g_strdup_printf ("%s_PROPERTY", _tmp282_);
			_tmp284_ = _tmp283_;
			_tmp285_ = vala_ccode_constant_new (_tmp284_);
			_tmp286_ = _tmp285_;
			vala_ccode_function_call_add_argument (_tmp279_, (ValaCCodeExpression*) _tmp286_);
			_vala_ccode_node_unref0 (_tmp286_);
			_g_free0 (_tmp284_);
			_g_free0 (_tmp282_);
			_tmp287_ = cinst;
			_tmp288_ = prop;
			_tmp289_ = vala_ccode_base_module_get_param_spec ((ValaCCodeBaseModule*) self, _tmp288_);
			_tmp290_ = _tmp289_;
			vala_ccode_function_call_add_argument (_tmp287_, _tmp290_);
			_vala_ccode_node_unref0 (_tmp290_);
			_tmp291_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp292_ = _tmp291_;
			_tmp293_ = cinst;
			vala_ccode_function_add_expression (_tmp292_, (ValaCCodeExpression*) _tmp293_);
			_vala_ccode_node_unref0 (cinst);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
}


static gboolean
vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		gint _prop_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp0_;
		_tmp1_ = _prop_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prop_size = _tmp3_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaProperty* prop = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaProperty* _tmp10_;
			ValaPropertyAccessor* _tmp11_;
			ValaPropertyAccessor* _tmp12_;
			_tmp4_ = _prop_index;
			_prop_index = _tmp4_ + 1;
			_tmp5_ = _prop_index;
			_tmp6_ = _prop_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prop_list;
			_tmp8_ = _prop_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prop = (ValaProperty*) _tmp9_;
			_tmp10_ = prop;
			_tmp11_ = vala_property_get_get_accessor (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}


static gboolean
vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self,
                                                   ValaClass* cl)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp0_;
		gint _prop_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prop_index = 0;
		_tmp0_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		_prop_list = _tmp0_;
		_tmp1_ = _prop_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prop_size = _tmp3_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaProperty* prop = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaProperty* _tmp10_;
			ValaPropertyAccessor* _tmp11_;
			ValaPropertyAccessor* _tmp12_;
			_tmp4_ = _prop_index;
			_prop_index = _tmp4_ + 1;
			_tmp5_ = _prop_index;
			_tmp6_ = _prop_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prop_list;
			_tmp8_ = _prop_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prop = (ValaProperty*) _tmp9_;
			_tmp10_ = prop;
			_tmp11_ = vala_property_get_set_accessor (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				result = TRUE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				return result;
			}
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	result = FALSE;
	return result;
}


static void
vala_gobject_module_add_guarded_expression (ValaGObjectModule* self,
                                            ValaSymbol* sym,
                                            ValaCCodeExpression* expression)
{
	ValaVersionAttribute* _tmp0_;
	ValaVersionAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (expression != NULL);
	_tmp0_ = vala_symbol_get_version (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_version_attribute_get_deprecated (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaCCodeGGnucSection* guard = NULL;
		ValaCCodeGGnucSection* _tmp4_;
		ValaCCodeFunction* _tmp5_;
		ValaCCodeFunction* _tmp6_;
		ValaCCodeGGnucSection* _tmp7_;
		ValaCCodeGGnucSection* _tmp8_;
		ValaCCodeExpressionStatement* _tmp9_;
		ValaCCodeExpressionStatement* _tmp10_;
		_tmp4_ = vala_ccode_ggnuc_section_new (VALA_GGNUC_SECTION_TYPE_IGNORE_DEPRECATIONS);
		guard = _tmp4_;
		_tmp5_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = guard;
		vala_ccode_function_add_statement (_tmp6_, (ValaCCodeNode*) _tmp7_);
		_tmp8_ = guard;
		_tmp9_ = vala_ccode_expression_statement_new (expression);
		_tmp10_ = _tmp9_;
		vala_ccode_fragment_append ((ValaCCodeFragment*) _tmp8_, (ValaCCodeNode*) _tmp10_);
		_vala_ccode_node_unref0 (_tmp10_);
		_vala_ccode_node_unref0 (guard);
	} else {
		ValaCCodeFunction* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		_tmp11_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp12_ = _tmp11_;
		vala_ccode_function_add_expression (_tmp12_, expression);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_gobject_module_add_get_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* get_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaCCodeFunction* _tmp281_;
	ValaCCodeFunction* _tmp282_;
	ValaCCodeFunction* _tmp283_;
	ValaCCodeFunction* _tmp284_;
	ValaCCodeFunction* _tmp285_;
	ValaCCodeFunction* _tmp286_;
	ValaCCodeFile* _tmp287_;
	ValaCCodeFunction* _tmp288_;
	ValaCCodeFile* _tmp289_;
	ValaCCodeFunction* _tmp290_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_get_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	get_prop = _tmp5_;
	_tmp6_ = get_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = get_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = get_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = get_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = get_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = get_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	props = _tmp37_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		gint _prop_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _prop_index = 0;
		_tmp38_ = props;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_prop_list = _tmp39_;
		_tmp40_ = _prop_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_prop_size = _tmp42_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			ValaProperty* prop = NULL;
			ValaList* _tmp46_;
			gint _tmp47_;
			gpointer _tmp48_;
			gboolean _tmp49_ = FALSE;
			ValaProperty* _tmp50_;
			ValaPropertyAccessor* _tmp51_;
			ValaPropertyAccessor* _tmp52_;
			ValaProperty* _tmp56_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp57_;
			ValaProperty* _tmp58_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp59_;
			ValaProperty* _tmp60_;
			ValaProperty* _tmp61_;
			ValaProperty* _tmp62_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp122_ = FALSE;
			ValaProperty* _tmp123_;
			ValaCCodeFunction* _tmp137_;
			ValaCCodeFunction* _tmp138_;
			ValaProperty* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaProperty* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaCCodeFunction* _tmp279_;
			ValaCCodeFunction* _tmp280_;
			_tmp43_ = _prop_index;
			_prop_index = _tmp43_ + 1;
			_tmp44_ = _prop_index;
			_tmp45_ = _prop_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _prop_list;
			_tmp47_ = _prop_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			prop = (ValaProperty*) _tmp48_;
			_tmp50_ = prop;
			_tmp51_ = vala_property_get_get_accessor (_tmp50_);
			_tmp52_ = _tmp51_;
			if (_tmp52_ == NULL) {
				_tmp49_ = TRUE;
			} else {
				ValaProperty* _tmp53_;
				gboolean _tmp54_;
				gboolean _tmp55_;
				_tmp53_ = prop;
				_tmp54_ = vala_property_get_is_abstract (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp49_ = _tmp55_;
			}
			if (_tmp49_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp56_ = prop;
			if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, _tmp56_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp57_ = prop;
			_tmp58_ = _vala_code_node_ref0 (_tmp57_);
			base_prop = _tmp58_;
			_tmp59_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp59_;
			_tmp60_ = prop;
			_tmp61_ = vala_property_get_base_property (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp63_;
				ValaProperty* _tmp64_;
				ValaProperty* _tmp65_;
				ValaSymbol* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaClass* _tmp68_;
				ValaProperty* _tmp69_;
				ValaProperty* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaObjectType* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaCCodeExpression* _tmp75_;
				ValaGLibValue* _tmp76_;
				ValaGLibValue* _tmp77_;
				ValaClass* _tmp78_;
				ValaObjectType* _tmp79_;
				ValaObjectType* _tmp80_;
				ValaProperty* _tmp81_;
				ValaTargetValue* _tmp82_;
				ValaTargetValue* _tmp83_;
				ValaCCodeExpression* _tmp84_;
				ValaProperty* _tmp85_;
				ValaProperty* _tmp86_;
				ValaProperty* _tmp87_;
				ValaPropertyAccessor* _tmp88_;
				ValaPropertyAccessor* _tmp89_;
				ValaCCodeFile* _tmp90_;
				_tmp63_ = prop;
				_tmp64_ = vala_property_get_base_property (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp68_;
				_tmp69_ = prop;
				_tmp70_ = vala_property_get_base_property (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = _vala_code_node_ref0 (_tmp71_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp72_;
				_tmp73_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp74_ = _tmp73_;
				_tmp75_ = cself;
				_tmp76_ = vala_glib_value_new ((ValaDataType*) _tmp74_, _tmp75_, TRUE);
				_tmp77_ = _tmp76_;
				_tmp78_ = base_type;
				_tmp79_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = prop;
				_tmp82_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp77_, (ValaDataType*) _tmp80_, (ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp83_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp84_;
				_vala_target_value_unref0 (_tmp83_);
				_vala_code_node_unref0 (_tmp80_);
				_vala_target_value_unref0 (_tmp77_);
				_vala_code_node_unref0 (_tmp74_);
				_tmp85_ = prop;
				_tmp86_ = vala_property_get_base_property (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_property_get_get_accessor (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp89_, _tmp90_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp91_;
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				_tmp91_ = prop;
				_tmp92_ = vala_property_get_base_interface_property (_tmp91_);
				_tmp93_ = _tmp92_;
				if (_tmp93_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp94_;
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaSymbol* _tmp97_;
					ValaSymbol* _tmp98_;
					ValaInterface* _tmp99_;
					ValaProperty* _tmp100_;
					ValaProperty* _tmp101_;
					ValaProperty* _tmp102_;
					ValaProperty* _tmp103_;
					ValaObjectType* _tmp104_;
					ValaObjectType* _tmp105_;
					ValaCCodeExpression* _tmp106_;
					ValaGLibValue* _tmp107_;
					ValaGLibValue* _tmp108_;
					ValaInterface* _tmp109_;
					ValaObjectType* _tmp110_;
					ValaObjectType* _tmp111_;
					ValaProperty* _tmp112_;
					ValaTargetValue* _tmp113_;
					ValaTargetValue* _tmp114_;
					ValaCCodeExpression* _tmp115_;
					ValaProperty* _tmp116_;
					ValaProperty* _tmp117_;
					ValaProperty* _tmp118_;
					ValaPropertyAccessor* _tmp119_;
					ValaPropertyAccessor* _tmp120_;
					ValaCCodeFile* _tmp121_;
					_tmp94_ = prop;
					_tmp95_ = vala_property_get_base_interface_property (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp99_;
					_tmp100_ = prop;
					_tmp101_ = vala_property_get_base_interface_property (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (_tmp102_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp103_;
					_tmp104_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp105_ = _tmp104_;
					_tmp106_ = cself;
					_tmp107_ = vala_glib_value_new ((ValaDataType*) _tmp105_, _tmp106_, TRUE);
					_tmp108_ = _tmp107_;
					_tmp109_ = base_type;
					_tmp110_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = prop;
					_tmp113_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp108_, (ValaDataType*) _tmp111_, (ValaCodeNode*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp114_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp115_;
					_vala_target_value_unref0 (_tmp114_);
					_vala_code_node_unref0 (_tmp111_);
					_vala_target_value_unref0 (_tmp108_);
					_vala_code_node_unref0 (_tmp105_);
					_tmp116_ = prop;
					_tmp117_ = vala_property_get_base_interface_property (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_property_get_get_accessor (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp120_, _tmp121_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp123_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp123_)) {
				ValaProperty* _tmp124_;
				_tmp124_ = base_prop;
				_tmp122_ = !vala_get_ccode_concrete_accessor (_tmp124_);
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaProperty* _tmp125_;
				ValaPropertyAccessor* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				ValaCCodeIdentifier* _tmp130_;
				_tmp125_ = base_prop;
				_tmp126_ = vala_property_get_get_accessor (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_get_ccode_name ((ValaCodeNode*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_ccode_identifier_new (_tmp129_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp130_;
				_g_free0 (_tmp129_);
			} else {
				ValaProperty* _tmp131_;
				ValaPropertyAccessor* _tmp132_;
				ValaPropertyAccessor* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				ValaCCodeIdentifier* _tmp136_;
				_tmp131_ = prop;
				_tmp132_ = vala_property_get_get_accessor (_tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_ccode_identifier_new (_tmp135_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp136_;
				_g_free0 (_tmp135_);
			}
			_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = prop;
			_tmp140_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp139_, NULL);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("%s_PROPERTY", _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			vala_ccode_function_add_case (_tmp138_, (ValaCCodeExpression*) _tmp145_);
			_vala_ccode_node_unref0 (_tmp145_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			_tmp146_ = prop;
			_tmp147_ = vala_property_get_property_type (_tmp146_);
			_tmp148_ = _tmp147_;
			if (vala_data_type_is_real_struct_type (_tmp148_)) {
				ValaStruct* st = NULL;
				ValaProperty* _tmp149_;
				ValaDataType* _tmp150_;
				ValaDataType* _tmp151_;
				ValaTypeSymbol* _tmp152_;
				ValaTypeSymbol* _tmp153_;
				ValaStruct* _tmp154_;
				ValaCCodeFunction* _tmp155_;
				ValaCCodeFunction* _tmp156_;
				ValaCCodeFunction* _tmp157_;
				ValaCCodeFunction* _tmp158_;
				ValaStruct* _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				ValaCCodeVariableDeclarator* _tmp162_;
				ValaCCodeVariableDeclarator* _tmp163_;
				ValaCCodeExpression* _tmp164_;
				ValaCCodeFunctionCall* _tmp165_;
				ValaCCodeFunctionCall* _tmp166_;
				ValaCCodeExpression* _tmp167_;
				ValaCCodeUnaryExpression* boxed_addr = NULL;
				ValaCCodeIdentifier* _tmp168_;
				ValaCCodeIdentifier* _tmp169_;
				ValaCCodeUnaryExpression* _tmp170_;
				ValaCCodeUnaryExpression* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeUnaryExpression* _tmp173_;
				ValaCCodeFunction* _tmp174_;
				ValaCCodeFunction* _tmp175_;
				ValaCCodeFunctionCall* _tmp176_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp177_;
				ValaCCodeFunctionCall* _tmp178_;
				ValaProperty* _tmp179_;
				ValaDataType* _tmp180_;
				ValaDataType* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeIdentifier* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaCCodeIdentifier* _tmp185_;
				ValaCCodeIdentifier* _tmp186_;
				ValaCCodeFunctionCall* _tmp187_;
				ValaCCodeUnaryExpression* _tmp188_;
				ValaProperty* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaProperty* _tmp191_;
				ValaPropertyAccessor* _tmp192_;
				ValaPropertyAccessor* _tmp193_;
				ValaDataType* _tmp194_;
				ValaDataType* _tmp195_;
				ValaCCodeFunction* _tmp209_;
				ValaCCodeFunction* _tmp210_;
				_tmp149_ = prop;
				_tmp150_ = vala_property_get_property_type (_tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_data_type_get_data_type (_tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp153_) : NULL);
				st = _tmp154_;
				_tmp155_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp156_ = _tmp155_;
				vala_ccode_function_open_block (_tmp156_);
				_tmp157_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp158_ = _tmp157_;
				_tmp159_ = st;
				_tmp160_ = vala_get_ccode_name ((ValaCodeNode*) _tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp163_ = _tmp162_;
				vala_ccode_function_add_declaration (_tmp158_, _tmp161_, (ValaCCodeDeclarator*) _tmp163_, 0);
				_vala_ccode_node_unref0 (_tmp163_);
				_g_free0 (_tmp161_);
				_tmp164_ = cfunc;
				_tmp165_ = vala_ccode_function_call_new (_tmp164_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp165_;
				_tmp166_ = ccall;
				_tmp167_ = cself;
				vala_ccode_function_call_add_argument (_tmp166_, _tmp167_);
				_tmp168_ = vala_ccode_identifier_new ("boxed");
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp169_);
				_tmp171_ = _tmp170_;
				_vala_ccode_node_unref0 (_tmp169_);
				boxed_addr = _tmp171_;
				_tmp172_ = ccall;
				_tmp173_ = boxed_addr;
				vala_ccode_function_call_add_argument (_tmp172_, (ValaCCodeExpression*) _tmp173_);
				_tmp174_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp175_ = _tmp174_;
				_tmp176_ = ccall;
				vala_ccode_function_add_expression (_tmp175_, (ValaCCodeExpression*) _tmp176_);
				_tmp177_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp177_;
				_tmp178_ = csetcall;
				_tmp179_ = prop;
				_tmp180_ = vala_property_get_property_type (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp181_);
				_tmp183_ = _tmp182_;
				vala_ccode_function_call_set_call (_tmp178_, (ValaCCodeExpression*) _tmp183_);
				_vala_ccode_node_unref0 (_tmp183_);
				_tmp184_ = csetcall;
				_tmp185_ = vala_ccode_identifier_new ("value");
				_tmp186_ = _tmp185_;
				vala_ccode_function_call_add_argument (_tmp184_, (ValaCCodeExpression*) _tmp186_);
				_vala_ccode_node_unref0 (_tmp186_);
				_tmp187_ = csetcall;
				_tmp188_ = boxed_addr;
				vala_ccode_function_call_add_argument (_tmp187_, (ValaCCodeExpression*) _tmp188_);
				_tmp189_ = prop;
				_tmp190_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp189_, (ValaCCodeExpression*) _tmp190_);
				_tmp191_ = prop;
				_tmp192_ = vala_property_get_get_accessor (_tmp191_);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_property_accessor_get_value_type (_tmp193_);
				_tmp195_ = _tmp194_;
				if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp195_)) {
					ValaCCodeFunction* _tmp196_;
					ValaCCodeFunction* _tmp197_;
					ValaProperty* _tmp198_;
					ValaPropertyAccessor* _tmp199_;
					ValaPropertyAccessor* _tmp200_;
					ValaDataType* _tmp201_;
					ValaDataType* _tmp202_;
					ValaCCodeIdentifier* _tmp203_;
					ValaCCodeIdentifier* _tmp204_;
					ValaGLibValue* _tmp205_;
					ValaGLibValue* _tmp206_;
					ValaCCodeExpression* _tmp207_;
					ValaCCodeExpression* _tmp208_;
					_tmp196_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = prop;
					_tmp199_ = vala_property_get_get_accessor (_tmp198_);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_property_accessor_get_value_type (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_ccode_identifier_new ("boxed");
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_glib_value_new (_tmp202_, (ValaCCodeExpression*) _tmp204_, TRUE);
					_tmp206_ = _tmp205_;
					_tmp207_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp206_, FALSE);
					_tmp208_ = _tmp207_;
					vala_ccode_function_add_expression (_tmp197_, _tmp208_);
					_vala_ccode_node_unref0 (_tmp208_);
					_vala_target_value_unref0 (_tmp206_);
					_vala_ccode_node_unref0 (_tmp204_);
				}
				_tmp209_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp210_ = _tmp209_;
				vala_ccode_function_close (_tmp210_);
				_vala_ccode_node_unref0 (csetcall);
				_vala_ccode_node_unref0 (boxed_addr);
				_vala_code_node_unref0 (st);
			} else {
				ValaCCodeExpression* _tmp211_;
				ValaCCodeFunctionCall* _tmp212_;
				ValaCCodeFunctionCall* _tmp213_;
				ValaCCodeExpression* _tmp214_;
				ValaArrayType* array_type = NULL;
				ValaProperty* _tmp215_;
				ValaDataType* _tmp216_;
				ValaDataType* _tmp217_;
				ValaArrayType* _tmp218_;
				gboolean _tmp219_ = FALSE;
				ValaArrayType* _tmp220_;
				ValaCCodeFunctionCall* csetcall = NULL;
				ValaCCodeFunctionCall* _tmp240_;
				ValaProperty* _tmp241_;
				ValaPropertyAccessor* _tmp242_;
				ValaPropertyAccessor* _tmp243_;
				ValaDataType* _tmp244_;
				ValaDataType* _tmp245_;
				gboolean _tmp246_;
				gboolean _tmp247_;
				ValaCCodeFunctionCall* _tmp260_;
				ValaCCodeIdentifier* _tmp261_;
				ValaCCodeIdentifier* _tmp262_;
				ValaCCodeFunctionCall* _tmp263_;
				ValaCCodeFunctionCall* _tmp264_;
				ValaProperty* _tmp265_;
				ValaCCodeFunctionCall* _tmp266_;
				gboolean _tmp267_ = FALSE;
				ValaArrayType* _tmp268_;
				_tmp211_ = cfunc;
				_tmp212_ = vala_ccode_function_call_new (_tmp211_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp212_;
				_tmp213_ = ccall;
				_tmp214_ = cself;
				vala_ccode_function_call_add_argument (_tmp213_, _tmp214_);
				_tmp215_ = prop;
				_tmp216_ = vala_property_get_property_type (_tmp215_);
				_tmp217_ = _tmp216_;
				_tmp218_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp217_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp217_) : NULL);
				array_type = _tmp218_;
				_tmp220_ = array_type;
				if (_tmp220_ != NULL) {
					ValaArrayType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaTypeSymbol* _tmp224_;
					ValaTypeSymbol* _tmp225_;
					ValaDataType* _tmp226_;
					ValaTypeSymbol* _tmp227_;
					ValaTypeSymbol* _tmp228_;
					_tmp221_ = array_type;
					_tmp222_ = vala_array_type_get_element_type (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_data_type_get_data_type (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp227_ = vala_data_type_get_data_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp219_ = _tmp225_ == _tmp228_;
				} else {
					_tmp219_ = FALSE;
				}
				if (_tmp219_) {
					ValaCCodeFunction* _tmp229_;
					ValaCCodeFunction* _tmp230_;
					ValaCCodeFunction* _tmp231_;
					ValaCCodeFunction* _tmp232_;
					ValaCCodeVariableDeclarator* _tmp233_;
					ValaCCodeVariableDeclarator* _tmp234_;
					ValaCCodeFunctionCall* _tmp235_;
					ValaCCodeIdentifier* _tmp236_;
					ValaCCodeIdentifier* _tmp237_;
					ValaCCodeUnaryExpression* _tmp238_;
					ValaCCodeUnaryExpression* _tmp239_;
					_tmp229_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp230_ = _tmp229_;
					vala_ccode_function_open_block (_tmp230_);
					_tmp231_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
					_tmp234_ = _tmp233_;
					vala_ccode_function_add_declaration (_tmp232_, "int", (ValaCCodeDeclarator*) _tmp234_, 0);
					_vala_ccode_node_unref0 (_tmp234_);
					_tmp235_ = ccall;
					_tmp236_ = vala_ccode_identifier_new ("length");
					_tmp237_ = _tmp236_;
					_tmp238_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp237_);
					_tmp239_ = _tmp238_;
					vala_ccode_function_call_add_argument (_tmp235_, (ValaCCodeExpression*) _tmp239_);
					_vala_ccode_node_unref0 (_tmp239_);
					_vala_ccode_node_unref0 (_tmp237_);
				}
				_tmp240_ = vala_ccode_function_call_new (NULL);
				csetcall = _tmp240_;
				_tmp241_ = prop;
				_tmp242_ = vala_property_get_get_accessor (_tmp241_);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_property_accessor_get_value_type (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = vala_data_type_get_value_owned (_tmp245_);
				_tmp247_ = _tmp246_;
				if (_tmp247_) {
					ValaCCodeFunctionCall* _tmp248_;
					ValaProperty* _tmp249_;
					ValaDataType* _tmp250_;
					ValaDataType* _tmp251_;
					ValaCCodeIdentifier* _tmp252_;
					ValaCCodeIdentifier* _tmp253_;
					_tmp248_ = csetcall;
					_tmp249_ = prop;
					_tmp250_ = vala_property_get_property_type (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, _tmp251_);
					_tmp253_ = _tmp252_;
					vala_ccode_function_call_set_call (_tmp248_, (ValaCCodeExpression*) _tmp253_);
					_vala_ccode_node_unref0 (_tmp253_);
				} else {
					ValaCCodeFunctionCall* _tmp254_;
					ValaProperty* _tmp255_;
					ValaDataType* _tmp256_;
					ValaDataType* _tmp257_;
					ValaCCodeIdentifier* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					_tmp254_ = csetcall;
					_tmp255_ = prop;
					_tmp256_ = vala_property_get_property_type (_tmp255_);
					_tmp257_ = _tmp256_;
					_tmp258_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, _tmp257_);
					_tmp259_ = _tmp258_;
					vala_ccode_function_call_set_call (_tmp254_, (ValaCCodeExpression*) _tmp259_);
					_vala_ccode_node_unref0 (_tmp259_);
				}
				_tmp260_ = csetcall;
				_tmp261_ = vala_ccode_identifier_new ("value");
				_tmp262_ = _tmp261_;
				vala_ccode_function_call_add_argument (_tmp260_, (ValaCCodeExpression*) _tmp262_);
				_vala_ccode_node_unref0 (_tmp262_);
				_tmp263_ = csetcall;
				_tmp264_ = ccall;
				vala_ccode_function_call_add_argument (_tmp263_, (ValaCCodeExpression*) _tmp264_);
				_tmp265_ = prop;
				_tmp266_ = csetcall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp265_, (ValaCCodeExpression*) _tmp266_);
				_tmp268_ = array_type;
				if (_tmp268_ != NULL) {
					ValaArrayType* _tmp269_;
					ValaDataType* _tmp270_;
					ValaDataType* _tmp271_;
					ValaTypeSymbol* _tmp272_;
					ValaTypeSymbol* _tmp273_;
					ValaDataType* _tmp274_;
					ValaTypeSymbol* _tmp275_;
					ValaTypeSymbol* _tmp276_;
					_tmp269_ = array_type;
					_tmp270_ = vala_array_type_get_element_type (_tmp269_);
					_tmp271_ = _tmp270_;
					_tmp272_ = vala_data_type_get_data_type (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp275_ = vala_data_type_get_data_type (_tmp274_);
					_tmp276_ = _tmp275_;
					_tmp267_ = _tmp273_ == _tmp276_;
				} else {
					_tmp267_ = FALSE;
				}
				if (_tmp267_) {
					ValaCCodeFunction* _tmp277_;
					ValaCCodeFunction* _tmp278_;
					_tmp277_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp278_ = _tmp277_;
					vala_ccode_function_close (_tmp278_);
				}
				_vala_ccode_node_unref0 (csetcall);
				_vala_code_node_unref0 (array_type);
			}
			_tmp279_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp280_ = _tmp279_;
			vala_ccode_function_add_break (_tmp280_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp281_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp282_ = _tmp281_;
	vala_ccode_function_add_default (_tmp282_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp283_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp284_ = _tmp283_;
	vala_ccode_function_add_break (_tmp284_);
	_tmp285_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp286_ = _tmp285_;
	vala_ccode_function_close (_tmp286_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp287_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp288_ = get_prop;
	vala_ccode_file_add_function_declaration (_tmp287_, _tmp288_);
	_tmp289_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp290_ = get_prop;
	vala_ccode_file_add_function (_tmp289_, _tmp290_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (get_prop);
}


static void
vala_gobject_module_add_set_property_function (ValaGObjectModule* self,
                                               ValaClass* cl)
{
	ValaCCodeFunction* set_prop = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaCCodeFunction* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeParameter* _tmp8_;
	ValaCCodeParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeParameter* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeParameter* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeFunction* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunction* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeIdentifier* _tmp35_;
	ValaCCodeIdentifier* _tmp36_;
	ValaList* props = NULL;
	ValaList* _tmp37_;
	ValaCCodeFunction* _tmp353_;
	ValaCCodeFunction* _tmp354_;
	ValaCCodeFunction* _tmp355_;
	ValaCCodeFunction* _tmp356_;
	ValaCCodeFunction* _tmp357_;
	ValaCCodeFunction* _tmp358_;
	ValaCCodeFile* _tmp359_;
	ValaCCodeFunction* _tmp360_;
	ValaCCodeFile* _tmp361_;
	ValaCCodeFunction* _tmp362_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_vala_%s_set_property", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_new (_tmp3_, "void");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	set_prop = _tmp5_;
	_tmp6_ = set_prop;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp6_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp7_ = set_prop;
	_tmp8_ = vala_ccode_parameter_new ("object", "GObject *");
	_tmp9_ = _tmp8_;
	vala_ccode_function_add_parameter (_tmp7_, _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = set_prop;
	_tmp11_ = vala_ccode_parameter_new ("property_id", "guint");
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp10_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = set_prop;
	_tmp14_ = vala_ccode_parameter_new ("value", "const GValue *");
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_parameter (_tmp13_, _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = set_prop;
	_tmp17_ = vala_ccode_parameter_new ("pspec", "GParamSpec *");
	_tmp18_ = _tmp17_;
	vala_ccode_function_add_parameter (_tmp16_, _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = set_prop;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("object");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp21_, (ValaTypeSymbol*) cl);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_get_ccode_name ((ValaCodeNode*) cl);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf ("%s *", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_variable_declarator_new ("self", (ValaCCodeExpression*) _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_declaration (_tmp25_, _tmp29_, (ValaCCodeDeclarator*) _tmp32_, 0);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_identifier_new ("property_id");
	_tmp36_ = _tmp35_;
	vala_ccode_function_open_switch (_tmp34_, (ValaCCodeExpression*) _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	props = _tmp37_;
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		gint _prop_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _prop_index = 0;
		_tmp38_ = props;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_prop_list = _tmp39_;
		_tmp40_ = _prop_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_prop_size = _tmp42_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			ValaProperty* prop = NULL;
			ValaList* _tmp46_;
			gint _tmp47_;
			gpointer _tmp48_;
			gboolean _tmp49_ = FALSE;
			ValaProperty* _tmp50_;
			ValaPropertyAccessor* _tmp51_;
			ValaPropertyAccessor* _tmp52_;
			ValaProperty* _tmp56_;
			ValaProperty* base_prop = NULL;
			ValaProperty* _tmp57_;
			ValaProperty* _tmp58_;
			ValaCCodeExpression* cself = NULL;
			ValaCCodeIdentifier* _tmp59_;
			ValaProperty* _tmp60_;
			ValaProperty* _tmp61_;
			ValaProperty* _tmp62_;
			ValaCCodeExpression* cfunc = NULL;
			gboolean _tmp122_ = FALSE;
			ValaProperty* _tmp123_;
			ValaCCodeFunction* _tmp137_;
			ValaCCodeFunction* _tmp138_;
			ValaProperty* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			ValaCCodeIdentifier* _tmp144_;
			ValaCCodeIdentifier* _tmp145_;
			ValaCCodeExpression* _tmp146_;
			ValaCCodeFunctionCall* _tmp147_;
			ValaCCodeFunctionCall* _tmp148_;
			ValaCCodeExpression* _tmp149_;
			gboolean _tmp150_ = FALSE;
			ValaProperty* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			ValaCCodeFunction* _tmp236_;
			ValaCCodeFunction* _tmp237_;
			_tmp43_ = _prop_index;
			_prop_index = _tmp43_ + 1;
			_tmp44_ = _prop_index;
			_tmp45_ = _prop_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _prop_list;
			_tmp47_ = _prop_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			prop = (ValaProperty*) _tmp48_;
			_tmp50_ = prop;
			_tmp51_ = vala_property_get_set_accessor (_tmp50_);
			_tmp52_ = _tmp51_;
			if (_tmp52_ == NULL) {
				_tmp49_ = TRUE;
			} else {
				ValaProperty* _tmp53_;
				gboolean _tmp54_;
				gboolean _tmp55_;
				_tmp53_ = prop;
				_tmp54_ = vala_property_get_is_abstract (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp49_ = _tmp55_;
			}
			if (_tmp49_) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp56_ = prop;
			if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, _tmp56_)) {
				_vala_code_node_unref0 (prop);
				continue;
			}
			_tmp57_ = prop;
			_tmp58_ = _vala_code_node_ref0 (_tmp57_);
			base_prop = _tmp58_;
			_tmp59_ = vala_ccode_identifier_new ("self");
			cself = (ValaCCodeExpression*) _tmp59_;
			_tmp60_ = prop;
			_tmp61_ = vala_property_get_base_property (_tmp60_);
			_tmp62_ = _tmp61_;
			if (_tmp62_ != NULL) {
				ValaClass* base_type = NULL;
				ValaProperty* _tmp63_;
				ValaProperty* _tmp64_;
				ValaProperty* _tmp65_;
				ValaSymbol* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaClass* _tmp68_;
				ValaProperty* _tmp69_;
				ValaProperty* _tmp70_;
				ValaProperty* _tmp71_;
				ValaProperty* _tmp72_;
				ValaObjectType* _tmp73_;
				ValaObjectType* _tmp74_;
				ValaCCodeExpression* _tmp75_;
				ValaGLibValue* _tmp76_;
				ValaGLibValue* _tmp77_;
				ValaClass* _tmp78_;
				ValaObjectType* _tmp79_;
				ValaObjectType* _tmp80_;
				ValaProperty* _tmp81_;
				ValaTargetValue* _tmp82_;
				ValaTargetValue* _tmp83_;
				ValaCCodeExpression* _tmp84_;
				ValaProperty* _tmp85_;
				ValaProperty* _tmp86_;
				ValaProperty* _tmp87_;
				ValaPropertyAccessor* _tmp88_;
				ValaPropertyAccessor* _tmp89_;
				ValaCCodeFile* _tmp90_;
				_tmp63_ = prop;
				_tmp64_ = vala_property_get_base_property (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_CLASS, ValaClass));
				base_type = _tmp68_;
				_tmp69_ = prop;
				_tmp70_ = vala_property_get_base_property (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = _vala_code_node_ref0 (_tmp71_);
				_vala_code_node_unref0 (base_prop);
				base_prop = _tmp72_;
				_tmp73_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
				_tmp74_ = _tmp73_;
				_tmp75_ = cself;
				_tmp76_ = vala_glib_value_new ((ValaDataType*) _tmp74_, _tmp75_, TRUE);
				_tmp77_ = _tmp76_;
				_tmp78_ = base_type;
				_tmp79_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = prop;
				_tmp82_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp77_, (ValaDataType*) _tmp80_, (ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp83_);
				_vala_ccode_node_unref0 (cself);
				cself = _tmp84_;
				_vala_target_value_unref0 (_tmp83_);
				_vala_code_node_unref0 (_tmp80_);
				_vala_target_value_unref0 (_tmp77_);
				_vala_code_node_unref0 (_tmp74_);
				_tmp85_ = prop;
				_tmp86_ = vala_property_get_base_property (_tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_property_get_set_accessor (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp89_, _tmp90_);
				_vala_code_node_unref0 (base_type);
			} else {
				ValaProperty* _tmp91_;
				ValaProperty* _tmp92_;
				ValaProperty* _tmp93_;
				_tmp91_ = prop;
				_tmp92_ = vala_property_get_base_interface_property (_tmp91_);
				_tmp93_ = _tmp92_;
				if (_tmp93_ != NULL) {
					ValaInterface* base_type = NULL;
					ValaProperty* _tmp94_;
					ValaProperty* _tmp95_;
					ValaProperty* _tmp96_;
					ValaSymbol* _tmp97_;
					ValaSymbol* _tmp98_;
					ValaInterface* _tmp99_;
					ValaProperty* _tmp100_;
					ValaProperty* _tmp101_;
					ValaProperty* _tmp102_;
					ValaProperty* _tmp103_;
					ValaObjectType* _tmp104_;
					ValaObjectType* _tmp105_;
					ValaCCodeExpression* _tmp106_;
					ValaGLibValue* _tmp107_;
					ValaGLibValue* _tmp108_;
					ValaInterface* _tmp109_;
					ValaObjectType* _tmp110_;
					ValaObjectType* _tmp111_;
					ValaProperty* _tmp112_;
					ValaTargetValue* _tmp113_;
					ValaTargetValue* _tmp114_;
					ValaCCodeExpression* _tmp115_;
					ValaProperty* _tmp116_;
					ValaProperty* _tmp117_;
					ValaProperty* _tmp118_;
					ValaPropertyAccessor* _tmp119_;
					ValaPropertyAccessor* _tmp120_;
					ValaCCodeFile* _tmp121_;
					_tmp94_ = prop;
					_tmp95_ = vala_property_get_base_interface_property (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_INTERFACE, ValaInterface));
					base_type = _tmp99_;
					_tmp100_ = prop;
					_tmp101_ = vala_property_get_base_interface_property (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = _vala_code_node_ref0 (_tmp102_);
					_vala_code_node_unref0 (base_prop);
					base_prop = _tmp103_;
					_tmp104_ = vala_object_type_new ((ValaObjectTypeSymbol*) cl);
					_tmp105_ = _tmp104_;
					_tmp106_ = cself;
					_tmp107_ = vala_glib_value_new ((ValaDataType*) _tmp105_, _tmp106_, TRUE);
					_tmp108_ = _tmp107_;
					_tmp109_ = base_type;
					_tmp110_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = prop;
					_tmp113_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp108_, (ValaDataType*) _tmp111_, (ValaCodeNode*) _tmp112_);
					_tmp114_ = _tmp113_;
					_tmp115_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp114_);
					_vala_ccode_node_unref0 (cself);
					cself = _tmp115_;
					_vala_target_value_unref0 (_tmp114_);
					_vala_code_node_unref0 (_tmp111_);
					_vala_target_value_unref0 (_tmp108_);
					_vala_code_node_unref0 (_tmp105_);
					_tmp116_ = prop;
					_tmp117_ = vala_property_get_base_interface_property (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_property_get_set_accessor (_tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_property_accessor_declaration ((ValaCCodeBaseModule*) self, _tmp120_, _tmp121_);
					_vala_code_node_unref0 (base_type);
				}
			}
			_tmp123_ = base_prop;
			if (!vala_get_ccode_no_accessor_method (_tmp123_)) {
				ValaProperty* _tmp124_;
				_tmp124_ = base_prop;
				_tmp122_ = !vala_get_ccode_concrete_accessor (_tmp124_);
			} else {
				_tmp122_ = FALSE;
			}
			if (_tmp122_) {
				ValaProperty* _tmp125_;
				ValaPropertyAccessor* _tmp126_;
				ValaPropertyAccessor* _tmp127_;
				gchar* _tmp128_;
				gchar* _tmp129_;
				ValaCCodeIdentifier* _tmp130_;
				_tmp125_ = base_prop;
				_tmp126_ = vala_property_get_set_accessor (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_get_ccode_name ((ValaCodeNode*) _tmp127_);
				_tmp129_ = _tmp128_;
				_tmp130_ = vala_ccode_identifier_new (_tmp129_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp130_;
				_g_free0 (_tmp129_);
			} else {
				ValaProperty* _tmp131_;
				ValaPropertyAccessor* _tmp132_;
				ValaPropertyAccessor* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				ValaCCodeIdentifier* _tmp136_;
				_tmp131_ = prop;
				_tmp132_ = vala_property_get_set_accessor (_tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_ccode_identifier_new (_tmp135_);
				_vala_ccode_node_unref0 (cfunc);
				cfunc = (ValaCCodeExpression*) _tmp136_;
				_g_free0 (_tmp135_);
			}
			_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = prop;
			_tmp140_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp139_, NULL);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("%s_PROPERTY", _tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_ccode_identifier_new (_tmp143_);
			_tmp145_ = _tmp144_;
			vala_ccode_function_add_case (_tmp138_, (ValaCCodeExpression*) _tmp145_);
			_vala_ccode_node_unref0 (_tmp145_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			_tmp146_ = cfunc;
			_tmp147_ = vala_ccode_function_call_new (_tmp146_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp147_;
			_tmp148_ = ccall;
			_tmp149_ = cself;
			vala_ccode_function_call_add_argument (_tmp148_, _tmp149_);
			_tmp151_ = prop;
			_tmp152_ = vala_property_get_property_type (_tmp151_);
			_tmp153_ = _tmp152_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, VALA_TYPE_ARRAY_TYPE)) {
				ValaProperty* _tmp154_;
				ValaDataType* _tmp155_;
				ValaDataType* _tmp156_;
				ValaDataType* _tmp157_;
				ValaDataType* _tmp158_;
				ValaTypeSymbol* _tmp159_;
				ValaTypeSymbol* _tmp160_;
				ValaDataType* _tmp161_;
				ValaTypeSymbol* _tmp162_;
				ValaTypeSymbol* _tmp163_;
				_tmp154_ = prop;
				_tmp155_ = vala_property_get_property_type (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_data_type_get_data_type (_tmp158_);
				_tmp160_ = _tmp159_;
				_tmp161_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp162_ = vala_data_type_get_data_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp150_ = _tmp160_ == _tmp163_;
			} else {
				_tmp150_ = FALSE;
			}
			if (_tmp150_) {
				ValaCCodeFunction* _tmp164_;
				ValaCCodeFunction* _tmp165_;
				ValaCCodeFunction* _tmp166_;
				ValaCCodeFunction* _tmp167_;
				ValaCCodeVariableDeclarator* _tmp168_;
				ValaCCodeVariableDeclarator* _tmp169_;
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaCCodeIdentifier* _tmp175_;
				ValaCCodeIdentifier* _tmp176_;
				ValaCCodeFunction* _tmp177_;
				ValaCCodeFunction* _tmp178_;
				ValaCCodeIdentifier* _tmp179_;
				ValaCCodeIdentifier* _tmp180_;
				ValaCCodeFunctionCall* _tmp181_;
				ValaCCodeFunctionCall* _tmp182_;
				ValaCCodeIdentifier* _tmp183_;
				ValaCCodeIdentifier* _tmp184_;
				ValaCCodeBinaryExpression* cisnull = NULL;
				ValaCCodeIdentifier* _tmp185_;
				ValaCCodeIdentifier* _tmp186_;
				ValaCCodeConstant* _tmp187_;
				ValaCCodeConstant* _tmp188_;
				ValaCCodeBinaryExpression* _tmp189_;
				ValaCCodeBinaryExpression* _tmp190_;
				ValaCCodeFunctionCall* cstrvlen = NULL;
				ValaCCodeIdentifier* _tmp191_;
				ValaCCodeIdentifier* _tmp192_;
				ValaCCodeFunctionCall* _tmp193_;
				ValaCCodeFunctionCall* _tmp194_;
				ValaCCodeFunctionCall* _tmp195_;
				ValaCCodeIdentifier* _tmp196_;
				ValaCCodeIdentifier* _tmp197_;
				ValaCCodeConditionalExpression* ccond = NULL;
				ValaCCodeBinaryExpression* _tmp198_;
				ValaCCodeConstant* _tmp199_;
				ValaCCodeConstant* _tmp200_;
				ValaCCodeFunctionCall* _tmp201_;
				ValaCCodeConditionalExpression* _tmp202_;
				ValaCCodeConditionalExpression* _tmp203_;
				ValaCCodeFunctionCall* _tmp204_;
				ValaCCodeConditionalExpression* _tmp205_;
				ValaProperty* _tmp206_;
				ValaCCodeFunctionCall* _tmp207_;
				ValaCCodeFunction* _tmp208_;
				ValaCCodeFunction* _tmp209_;
				_tmp164_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp165_ = _tmp164_;
				vala_ccode_function_open_block (_tmp165_);
				_tmp166_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_ccode_variable_declarator_new ("boxed", NULL, NULL);
				_tmp169_ = _tmp168_;
				vala_ccode_function_add_declaration (_tmp167_, "gpointer", (ValaCCodeDeclarator*) _tmp169_, 0);
				_vala_ccode_node_unref0 (_tmp169_);
				_tmp170_ = vala_ccode_identifier_new ("g_value_get_boxed");
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				cgetcall = _tmp173_;
				_tmp174_ = cgetcall;
				_tmp175_ = vala_ccode_identifier_new ("value");
				_tmp176_ = _tmp175_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp176_);
				_vala_ccode_node_unref0 (_tmp176_);
				_tmp177_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_ccode_identifier_new ("boxed");
				_tmp180_ = _tmp179_;
				_tmp181_ = cgetcall;
				vala_ccode_function_add_assignment (_tmp178_, (ValaCCodeExpression*) _tmp180_, (ValaCCodeExpression*) _tmp181_);
				_vala_ccode_node_unref0 (_tmp180_);
				_tmp182_ = ccall;
				_tmp183_ = vala_ccode_identifier_new ("boxed");
				_tmp184_ = _tmp183_;
				vala_ccode_function_call_add_argument (_tmp182_, (ValaCCodeExpression*) _tmp184_);
				_vala_ccode_node_unref0 (_tmp184_);
				_tmp185_ = vala_ccode_identifier_new ("boxed");
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_ccode_constant_new ("NULL");
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp186_, (ValaCCodeExpression*) _tmp188_);
				_tmp190_ = _tmp189_;
				_vala_ccode_node_unref0 (_tmp188_);
				_vala_ccode_node_unref0 (_tmp186_);
				cisnull = _tmp190_;
				_tmp191_ = vala_ccode_identifier_new ("g_strv_length");
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp192_);
				_tmp194_ = _tmp193_;
				_vala_ccode_node_unref0 (_tmp192_);
				cstrvlen = _tmp194_;
				_tmp195_ = cstrvlen;
				_tmp196_ = vala_ccode_identifier_new ("boxed");
				_tmp197_ = _tmp196_;
				vala_ccode_function_call_add_argument (_tmp195_, (ValaCCodeExpression*) _tmp197_);
				_vala_ccode_node_unref0 (_tmp197_);
				_tmp198_ = cisnull;
				_tmp199_ = vala_ccode_constant_new ("0");
				_tmp200_ = _tmp199_;
				_tmp201_ = cstrvlen;
				_tmp202_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp198_, (ValaCCodeExpression*) _tmp200_, (ValaCCodeExpression*) _tmp201_);
				_tmp203_ = _tmp202_;
				_vala_ccode_node_unref0 (_tmp200_);
				ccond = _tmp203_;
				_tmp204_ = ccall;
				_tmp205_ = ccond;
				vala_ccode_function_call_add_argument (_tmp204_, (ValaCCodeExpression*) _tmp205_);
				_tmp206_ = prop;
				_tmp207_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp206_, (ValaCCodeExpression*) _tmp207_);
				_tmp208_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp209_ = _tmp208_;
				vala_ccode_function_close (_tmp209_);
				_vala_ccode_node_unref0 (ccond);
				_vala_ccode_node_unref0 (cstrvlen);
				_vala_ccode_node_unref0 (cisnull);
				_vala_ccode_node_unref0 (cgetcall);
			} else {
				ValaCCodeFunctionCall* cgetcall = NULL;
				ValaCCodeFunctionCall* _tmp210_;
				ValaProperty* _tmp211_;
				ValaDataType* _tmp212_;
				ValaDataType* _tmp213_;
				ValaTypeSymbol* _tmp214_;
				ValaTypeSymbol* _tmp215_;
				ValaCCodeFunctionCall* _tmp229_;
				ValaCCodeIdentifier* _tmp230_;
				ValaCCodeIdentifier* _tmp231_;
				ValaCCodeFunctionCall* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaProperty* _tmp234_;
				ValaCCodeFunctionCall* _tmp235_;
				_tmp210_ = vala_ccode_function_call_new (NULL);
				cgetcall = _tmp210_;
				_tmp211_ = prop;
				_tmp212_ = vala_property_get_property_type (_tmp211_);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_data_type_get_data_type (_tmp213_);
				_tmp215_ = _tmp214_;
				if (_tmp215_ != NULL) {
					ValaCCodeFunctionCall* _tmp216_;
					ValaProperty* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					ValaTypeSymbol* _tmp220_;
					ValaTypeSymbol* _tmp221_;
					gchar* _tmp222_;
					gchar* _tmp223_;
					ValaCCodeIdentifier* _tmp224_;
					ValaCCodeIdentifier* _tmp225_;
					_tmp216_ = cgetcall;
					_tmp217_ = prop;
					_tmp218_ = vala_property_get_property_type (_tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_data_type_get_data_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_ccode_identifier_new (_tmp223_);
					_tmp225_ = _tmp224_;
					vala_ccode_function_call_set_call (_tmp216_, (ValaCCodeExpression*) _tmp225_);
					_vala_ccode_node_unref0 (_tmp225_);
					_g_free0 (_tmp223_);
				} else {
					ValaCCodeFunctionCall* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaCCodeIdentifier* _tmp228_;
					_tmp226_ = cgetcall;
					_tmp227_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp228_ = _tmp227_;
					vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp228_);
					_vala_ccode_node_unref0 (_tmp228_);
				}
				_tmp229_ = cgetcall;
				_tmp230_ = vala_ccode_identifier_new ("value");
				_tmp231_ = _tmp230_;
				vala_ccode_function_call_add_argument (_tmp229_, (ValaCCodeExpression*) _tmp231_);
				_vala_ccode_node_unref0 (_tmp231_);
				_tmp232_ = ccall;
				_tmp233_ = cgetcall;
				vala_ccode_function_call_add_argument (_tmp232_, (ValaCCodeExpression*) _tmp233_);
				_tmp234_ = prop;
				_tmp235_ = ccall;
				vala_gobject_module_add_guarded_expression (self, (ValaSymbol*) _tmp234_, (ValaCCodeExpression*) _tmp235_);
				_vala_ccode_node_unref0 (cgetcall);
			}
			_tmp236_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp237_ = _tmp236_;
			vala_ccode_function_add_break (_tmp237_);
			_vala_ccode_node_unref0 (cfunc);
			_vala_ccode_node_unref0 (cself);
			_vala_code_node_unref0 (base_prop);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _type_param_list = NULL;
		ValaList* _tmp238_;
		gint _type_param_size = 0;
		ValaList* _tmp239_;
		gint _tmp240_;
		gint _tmp241_;
		gint _type_param_index = 0;
		_tmp238_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
		_type_param_list = _tmp238_;
		_tmp239_ = _type_param_list;
		_tmp240_ = vala_collection_get_size ((ValaCollection*) _tmp239_);
		_tmp241_ = _tmp240_;
		_type_param_size = _tmp241_;
		_type_param_index = -1;
		while (TRUE) {
			gint _tmp242_;
			gint _tmp243_;
			gint _tmp244_;
			ValaTypeParameter* type_param = NULL;
			ValaList* _tmp245_;
			gint _tmp246_;
			gpointer _tmp247_;
			gchar* func_name = NULL;
			gchar* enum_value = NULL;
			ValaCCodeMemberAccess* cfield = NULL;
			ValaCCodeFunctionCall* cgetcall = NULL;
			ValaTypeParameter* _tmp248_;
			const gchar* _tmp249_;
			const gchar* _tmp250_;
			gchar* _tmp251_;
			gchar* _tmp252_;
			gchar* _tmp253_;
			gchar* _tmp254_;
			gchar* _tmp255_;
			const gchar* _tmp256_;
			gchar* _tmp257_;
			gchar* _tmp258_;
			gchar* _tmp259_;
			ValaCCodeFunction* _tmp260_;
			ValaCCodeFunction* _tmp261_;
			const gchar* _tmp262_;
			ValaCCodeIdentifier* _tmp263_;
			ValaCCodeIdentifier* _tmp264_;
			ValaCCodeIdentifier* _tmp265_;
			ValaCCodeIdentifier* _tmp266_;
			ValaCCodeMemberAccess* _tmp267_;
			ValaCCodeMemberAccess* _tmp268_;
			const gchar* _tmp269_;
			ValaCCodeMemberAccess* _tmp270_;
			ValaCCodeIdentifier* _tmp271_;
			ValaCCodeIdentifier* _tmp272_;
			ValaCCodeFunctionCall* _tmp273_;
			ValaCCodeFunctionCall* _tmp274_;
			ValaCCodeIdentifier* _tmp275_;
			ValaCCodeIdentifier* _tmp276_;
			ValaCCodeFunction* _tmp277_;
			ValaCCodeFunction* _tmp278_;
			ValaCCodeMemberAccess* _tmp279_;
			ValaCCodeFunctionCall* _tmp280_;
			ValaCCodeFunction* _tmp281_;
			ValaCCodeFunction* _tmp282_;
			ValaTypeParameter* _tmp283_;
			const gchar* _tmp284_;
			const gchar* _tmp285_;
			gchar* _tmp286_;
			gchar* _tmp287_;
			gchar* _tmp288_;
			gchar* _tmp289_;
			gchar* _tmp290_;
			const gchar* _tmp291_;
			gchar* _tmp292_;
			gchar* _tmp293_;
			gchar* _tmp294_;
			ValaCCodeFunction* _tmp295_;
			ValaCCodeFunction* _tmp296_;
			const gchar* _tmp297_;
			ValaCCodeIdentifier* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeIdentifier* _tmp300_;
			ValaCCodeIdentifier* _tmp301_;
			ValaCCodeMemberAccess* _tmp302_;
			ValaCCodeMemberAccess* _tmp303_;
			const gchar* _tmp304_;
			ValaCCodeMemberAccess* _tmp305_;
			ValaCCodeIdentifier* _tmp306_;
			ValaCCodeIdentifier* _tmp307_;
			ValaCCodeFunctionCall* _tmp308_;
			ValaCCodeFunctionCall* _tmp309_;
			ValaCCodeIdentifier* _tmp310_;
			ValaCCodeIdentifier* _tmp311_;
			ValaCCodeFunction* _tmp312_;
			ValaCCodeFunction* _tmp313_;
			ValaCCodeMemberAccess* _tmp314_;
			ValaCCodeFunctionCall* _tmp315_;
			ValaCCodeFunction* _tmp316_;
			ValaCCodeFunction* _tmp317_;
			ValaTypeParameter* _tmp318_;
			const gchar* _tmp319_;
			const gchar* _tmp320_;
			gchar* _tmp321_;
			gchar* _tmp322_;
			gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			const gchar* _tmp326_;
			gchar* _tmp327_;
			gchar* _tmp328_;
			gchar* _tmp329_;
			ValaCCodeFunction* _tmp330_;
			ValaCCodeFunction* _tmp331_;
			const gchar* _tmp332_;
			ValaCCodeIdentifier* _tmp333_;
			ValaCCodeIdentifier* _tmp334_;
			ValaCCodeIdentifier* _tmp335_;
			ValaCCodeIdentifier* _tmp336_;
			ValaCCodeMemberAccess* _tmp337_;
			ValaCCodeMemberAccess* _tmp338_;
			const gchar* _tmp339_;
			ValaCCodeMemberAccess* _tmp340_;
			ValaCCodeIdentifier* _tmp341_;
			ValaCCodeIdentifier* _tmp342_;
			ValaCCodeFunctionCall* _tmp343_;
			ValaCCodeFunctionCall* _tmp344_;
			ValaCCodeIdentifier* _tmp345_;
			ValaCCodeIdentifier* _tmp346_;
			ValaCCodeFunction* _tmp347_;
			ValaCCodeFunction* _tmp348_;
			ValaCCodeMemberAccess* _tmp349_;
			ValaCCodeFunctionCall* _tmp350_;
			ValaCCodeFunction* _tmp351_;
			ValaCCodeFunction* _tmp352_;
			_tmp242_ = _type_param_index;
			_type_param_index = _tmp242_ + 1;
			_tmp243_ = _type_param_index;
			_tmp244_ = _type_param_size;
			if (!(_tmp243_ < _tmp244_)) {
				break;
			}
			_tmp245_ = _type_param_list;
			_tmp246_ = _type_param_index;
			_tmp247_ = vala_list_get (_tmp245_, _tmp246_);
			type_param = (ValaTypeParameter*) _tmp247_;
			_tmp248_ = type_param;
			_tmp249_ = vala_symbol_get_name ((ValaSymbol*) _tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = g_ascii_strdown (_tmp250_, (gssize) -1);
			_tmp252_ = _tmp251_;
			_tmp253_ = g_strdup_printf ("%s_type", _tmp252_);
			_g_free0 (func_name);
			func_name = _tmp253_;
			_g_free0 (_tmp252_);
			_tmp254_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp255_ = _tmp254_;
			_tmp256_ = func_name;
			_tmp257_ = g_strdup_printf ("%s_%s", _tmp255_, _tmp256_);
			_tmp258_ = _tmp257_;
			_tmp259_ = g_ascii_strup (_tmp258_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp259_;
			_g_free0 (_tmp258_);
			_g_free0 (_tmp255_);
			_tmp260_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp261_ = _tmp260_;
			_tmp262_ = enum_value;
			_tmp263_ = vala_ccode_identifier_new (_tmp262_);
			_tmp264_ = _tmp263_;
			vala_ccode_function_add_case (_tmp261_, (ValaCCodeExpression*) _tmp264_);
			_vala_ccode_node_unref0 (_tmp264_);
			_tmp265_ = vala_ccode_identifier_new ("self");
			_tmp266_ = _tmp265_;
			_tmp267_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp266_, "priv");
			_tmp268_ = _tmp267_;
			_tmp269_ = func_name;
			_tmp270_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp268_, _tmp269_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp270_;
			_vala_ccode_node_unref0 (_tmp268_);
			_vala_ccode_node_unref0 (_tmp266_);
			_tmp271_ = vala_ccode_identifier_new ("g_value_get_gtype");
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp272_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp273_;
			_vala_ccode_node_unref0 (_tmp272_);
			_tmp274_ = cgetcall;
			_tmp275_ = vala_ccode_identifier_new ("value");
			_tmp276_ = _tmp275_;
			vala_ccode_function_call_add_argument (_tmp274_, (ValaCCodeExpression*) _tmp276_);
			_vala_ccode_node_unref0 (_tmp276_);
			_tmp277_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp278_ = _tmp277_;
			_tmp279_ = cfield;
			_tmp280_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp278_, (ValaCCodeExpression*) _tmp279_, (ValaCCodeExpression*) _tmp280_);
			_tmp281_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp282_ = _tmp281_;
			vala_ccode_function_add_break (_tmp282_);
			_tmp283_ = type_param;
			_tmp284_ = vala_symbol_get_name ((ValaSymbol*) _tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = g_ascii_strdown (_tmp285_, (gssize) -1);
			_tmp287_ = _tmp286_;
			_tmp288_ = g_strdup_printf ("%s_dup_func", _tmp287_);
			_g_free0 (func_name);
			func_name = _tmp288_;
			_g_free0 (_tmp287_);
			_tmp289_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp290_ = _tmp289_;
			_tmp291_ = func_name;
			_tmp292_ = g_strdup_printf ("%s_%s", _tmp290_, _tmp291_);
			_tmp293_ = _tmp292_;
			_tmp294_ = g_ascii_strup (_tmp293_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp294_;
			_g_free0 (_tmp293_);
			_g_free0 (_tmp290_);
			_tmp295_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp296_ = _tmp295_;
			_tmp297_ = enum_value;
			_tmp298_ = vala_ccode_identifier_new (_tmp297_);
			_tmp299_ = _tmp298_;
			vala_ccode_function_add_case (_tmp296_, (ValaCCodeExpression*) _tmp299_);
			_vala_ccode_node_unref0 (_tmp299_);
			_tmp300_ = vala_ccode_identifier_new ("self");
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp301_, "priv");
			_tmp303_ = _tmp302_;
			_tmp304_ = func_name;
			_tmp305_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp303_, _tmp304_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp305_;
			_vala_ccode_node_unref0 (_tmp303_);
			_vala_ccode_node_unref0 (_tmp301_);
			_tmp306_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp307_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp308_;
			_vala_ccode_node_unref0 (_tmp307_);
			_tmp309_ = cgetcall;
			_tmp310_ = vala_ccode_identifier_new ("value");
			_tmp311_ = _tmp310_;
			vala_ccode_function_call_add_argument (_tmp309_, (ValaCCodeExpression*) _tmp311_);
			_vala_ccode_node_unref0 (_tmp311_);
			_tmp312_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp313_ = _tmp312_;
			_tmp314_ = cfield;
			_tmp315_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp313_, (ValaCCodeExpression*) _tmp314_, (ValaCCodeExpression*) _tmp315_);
			_tmp316_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp317_ = _tmp316_;
			vala_ccode_function_add_break (_tmp317_);
			_tmp318_ = type_param;
			_tmp319_ = vala_symbol_get_name ((ValaSymbol*) _tmp318_);
			_tmp320_ = _tmp319_;
			_tmp321_ = g_ascii_strdown (_tmp320_, (gssize) -1);
			_tmp322_ = _tmp321_;
			_tmp323_ = g_strdup_printf ("%s_destroy_func", _tmp322_);
			_g_free0 (func_name);
			func_name = _tmp323_;
			_g_free0 (_tmp322_);
			_tmp324_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
			_tmp325_ = _tmp324_;
			_tmp326_ = func_name;
			_tmp327_ = g_strdup_printf ("%s_%s", _tmp325_, _tmp326_);
			_tmp328_ = _tmp327_;
			_tmp329_ = g_ascii_strup (_tmp328_, (gssize) -1);
			_g_free0 (enum_value);
			enum_value = _tmp329_;
			_g_free0 (_tmp328_);
			_g_free0 (_tmp325_);
			_tmp330_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp331_ = _tmp330_;
			_tmp332_ = enum_value;
			_tmp333_ = vala_ccode_identifier_new (_tmp332_);
			_tmp334_ = _tmp333_;
			vala_ccode_function_add_case (_tmp331_, (ValaCCodeExpression*) _tmp334_);
			_vala_ccode_node_unref0 (_tmp334_);
			_tmp335_ = vala_ccode_identifier_new ("self");
			_tmp336_ = _tmp335_;
			_tmp337_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp336_, "priv");
			_tmp338_ = _tmp337_;
			_tmp339_ = func_name;
			_tmp340_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp338_, _tmp339_);
			_vala_ccode_node_unref0 (cfield);
			cfield = _tmp340_;
			_vala_ccode_node_unref0 (_tmp338_);
			_vala_ccode_node_unref0 (_tmp336_);
			_tmp341_ = vala_ccode_identifier_new ("g_value_get_pointer");
			_tmp342_ = _tmp341_;
			_tmp343_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp342_);
			_vala_ccode_node_unref0 (cgetcall);
			cgetcall = _tmp343_;
			_vala_ccode_node_unref0 (_tmp342_);
			_tmp344_ = cgetcall;
			_tmp345_ = vala_ccode_identifier_new ("value");
			_tmp346_ = _tmp345_;
			vala_ccode_function_call_add_argument (_tmp344_, (ValaCCodeExpression*) _tmp346_);
			_vala_ccode_node_unref0 (_tmp346_);
			_tmp347_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp348_ = _tmp347_;
			_tmp349_ = cfield;
			_tmp350_ = cgetcall;
			vala_ccode_function_add_assignment (_tmp348_, (ValaCCodeExpression*) _tmp349_, (ValaCCodeExpression*) _tmp350_);
			_tmp351_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp352_ = _tmp351_;
			vala_ccode_function_add_break (_tmp352_);
			_vala_ccode_node_unref0 (cgetcall);
			_vala_ccode_node_unref0 (cfield);
			_g_free0 (enum_value);
			_g_free0 (func_name);
			_vala_code_node_unref0 (type_param);
		}
		_vala_iterable_unref0 (_type_param_list);
	}
	_tmp353_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp354_ = _tmp353_;
	vala_ccode_function_add_default (_tmp354_);
	vala_gobject_module_emit_invalid_property_id_warn (self);
	_tmp355_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp356_ = _tmp355_;
	vala_ccode_function_add_break (_tmp356_);
	_tmp357_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp358_ = _tmp357_;
	vala_ccode_function_close (_tmp358_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp359_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp360_ = set_prop;
	vala_ccode_file_add_function_declaration (_tmp359_, _tmp360_);
	_tmp361_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp362_ = set_prop;
	vala_ccode_file_add_function (_tmp361_, _tmp362_);
	_vala_iterable_unref0 (props);
	_vala_ccode_node_unref0 (ccall);
	_vala_ccode_node_unref0 (set_prop);
}


static void
vala_gobject_module_emit_invalid_property_id_warn (ValaGObjectModule* self)
{
	ValaCCodeFunctionCall* cwarn = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cwarn = _tmp3_;
	_tmp4_ = vala_ccode_identifier_new ("object");
	_tmp5_ = _tmp4_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp5_);
	_vala_ccode_node_unref0 (_tmp5_);
	_tmp6_ = vala_ccode_identifier_new ("property_id");
	_tmp7_ = _tmp6_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = vala_ccode_identifier_new ("pspec");
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	vala_ccode_function_add_expression (_tmp11_, (ValaCCodeExpression*) cwarn);
	_vala_ccode_node_unref0 (cwarn);
}


static void
vala_gobject_module_real_visit_constructor (ValaCodeVisitor* base,
                                            ValaConstructor* c)
{
	ValaGObjectModule * self;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaClass* _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaMemberBinding _tmp6_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) c);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
	cl = _tmp4_;
	_tmp5_ = vala_constructor_get_binding (c);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaClass* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaCCodeBaseModuleEmitContext* _tmp11_;
		ValaCCodeBaseModuleEmitContext* _tmp12_;
		ValaCCodeFunction* function = NULL;
		ValaClass* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ValaCCodeFunction* _tmp18_;
		ValaCCodeFunction* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaCCodeParameter* _tmp22_;
		ValaCCodeParameter* _tmp23_;
		ValaCCodeFunction* _tmp24_;
		ValaCCodeParameter* _tmp25_;
		ValaCCodeParameter* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeParameter* _tmp28_;
		ValaCCodeParameter* _tmp29_;
		ValaCCodeFile* _tmp30_;
		ValaCCodeFunction* _tmp31_;
		ValaCCodeFunction* _tmp32_;
		ValaCCodeFunction* _tmp33_;
		ValaCCodeFunction* _tmp34_;
		ValaCCodeVariableDeclarator* _tmp35_;
		ValaCCodeVariableDeclarator* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeFunction* _tmp38_;
		ValaCCodeVariableDeclarator* _tmp39_;
		ValaCCodeVariableDeclarator* _tmp40_;
		ValaCCodeFunctionCall* ccast = NULL;
		ValaCCodeIdentifier* _tmp41_;
		ValaCCodeIdentifier* _tmp42_;
		ValaCCodeFunctionCall* _tmp43_;
		ValaCCodeFunctionCall* _tmp44_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaClass* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunction* _tmp53_;
		ValaCCodeFunction* _tmp54_;
		ValaCCodeIdentifier* _tmp55_;
		ValaCCodeIdentifier* _tmp56_;
		ValaCCodeFunctionCall* _tmp57_;
		ValaCCodeFunctionCall* ccall = NULL;
		ValaCCodeIdentifier* _tmp58_;
		ValaCCodeIdentifier* _tmp59_;
		ValaCCodeMemberAccess* _tmp60_;
		ValaCCodeMemberAccess* _tmp61_;
		ValaCCodeFunctionCall* _tmp62_;
		ValaCCodeFunctionCall* _tmp63_;
		ValaCCodeFunctionCall* _tmp64_;
		ValaCCodeIdentifier* _tmp65_;
		ValaCCodeIdentifier* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaCCodeIdentifier* _tmp68_;
		ValaCCodeIdentifier* _tmp69_;
		ValaCCodeFunctionCall* _tmp70_;
		ValaCCodeIdentifier* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeFunction* _tmp73_;
		ValaCCodeFunction* _tmp74_;
		ValaCCodeIdentifier* _tmp75_;
		ValaCCodeIdentifier* _tmp76_;
		ValaCCodeFunctionCall* _tmp77_;
		ValaCCodeIdentifier* _tmp78_;
		ValaCCodeIdentifier* _tmp79_;
		ValaClass* _tmp80_;
		ValaCCodeFunctionCall* _tmp81_;
		ValaCCodeFunction* _tmp82_;
		ValaCCodeFunction* _tmp83_;
		ValaClass* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		ValaCCodeVariableDeclarator* _tmp89_;
		ValaCCodeVariableDeclarator* _tmp90_;
		ValaCCodeFunction* _tmp91_;
		ValaCCodeFunction* _tmp92_;
		ValaCCodeIdentifier* _tmp93_;
		ValaCCodeIdentifier* _tmp94_;
		ValaCCodeFunctionCall* _tmp95_;
		ValaBlock* _tmp96_;
		ValaBlock* _tmp97_;
		gboolean _tmp98_;
		gboolean _tmp99_;
		ValaCCodeFunction* _tmp106_;
		ValaCCodeFunction* _tmp107_;
		ValaCCodeIdentifier* _tmp108_;
		ValaCCodeIdentifier* _tmp109_;
		ValaCCodeFile* _tmp110_;
		ValaCCodeFunction* _tmp111_;
		_tmp7_ = cl;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		if (!vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp7_, _tmp8_)) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "construct blocks require GLib.Object");
			vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
			_vala_code_node_unref0 (cl);
			return;
		}
		_tmp11_ = vala_ccode_base_module_emit_context_new ((ValaSymbol*) c);
		_tmp12_ = _tmp11_;
		vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp12_);
		_vala_ccode_base_module_emit_context_unref0 (_tmp12_);
		_tmp13_ = cl;
		_tmp14_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%s_constructor", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_ccode_function_new (_tmp17_, "GObject *");
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		function = _tmp19_;
		_tmp20_ = function;
		vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp20_, VALA_CCODE_MODIFIERS_STATIC);
		_tmp21_ = function;
		_tmp22_ = vala_ccode_parameter_new ("type", "GType");
		_tmp23_ = _tmp22_;
		vala_ccode_function_add_parameter (_tmp21_, _tmp23_);
		_vala_ccode_node_unref0 (_tmp23_);
		_tmp24_ = function;
		_tmp25_ = vala_ccode_parameter_new ("n_construct_properties", "guint");
		_tmp26_ = _tmp25_;
		vala_ccode_function_add_parameter (_tmp24_, _tmp26_);
		_vala_ccode_node_unref0 (_tmp26_);
		_tmp27_ = function;
		_tmp28_ = vala_ccode_parameter_new ("construct_properties", "GObjectConstructParam *");
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_parameter (_tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp31_ = function;
		vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
		_tmp32_ = function;
		vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp32_);
		_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_ccode_variable_declarator_new ("obj", NULL, NULL);
		_tmp36_ = _tmp35_;
		vala_ccode_function_add_declaration (_tmp34_, "GObject *", (ValaCCodeDeclarator*) _tmp36_, 0);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_ccode_variable_declarator_new ("parent_class", NULL, NULL);
		_tmp40_ = _tmp39_;
		vala_ccode_function_add_declaration (_tmp38_, "GObjectClass *", (ValaCCodeDeclarator*) _tmp40_, 0);
		_vala_ccode_node_unref0 (_tmp40_);
		_tmp41_ = vala_ccode_identifier_new ("G_OBJECT_CLASS");
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp42_);
		_tmp44_ = _tmp43_;
		_vala_ccode_node_unref0 (_tmp42_);
		ccast = _tmp44_;
		_tmp45_ = ccast;
		_tmp46_ = cl;
		_tmp47_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup_printf ("%s_parent_class", _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = vala_ccode_identifier_new (_tmp50_);
		_tmp52_ = _tmp51_;
		vala_ccode_function_call_add_argument (_tmp45_, (ValaCCodeExpression*) _tmp52_);
		_vala_ccode_node_unref0 (_tmp52_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_ccode_identifier_new ("parent_class");
		_tmp56_ = _tmp55_;
		_tmp57_ = ccast;
		vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp57_);
		_vala_ccode_node_unref0 (_tmp56_);
		_tmp58_ = vala_ccode_identifier_new ("parent_class");
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp59_, "constructor");
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp61_);
		_tmp63_ = _tmp62_;
		_vala_ccode_node_unref0 (_tmp61_);
		_vala_ccode_node_unref0 (_tmp59_);
		ccall = _tmp63_;
		_tmp64_ = ccall;
		_tmp65_ = vala_ccode_identifier_new ("type");
		_tmp66_ = _tmp65_;
		vala_ccode_function_call_add_argument (_tmp64_, (ValaCCodeExpression*) _tmp66_);
		_vala_ccode_node_unref0 (_tmp66_);
		_tmp67_ = ccall;
		_tmp68_ = vala_ccode_identifier_new ("n_construct_properties");
		_tmp69_ = _tmp68_;
		vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp69_);
		_vala_ccode_node_unref0 (_tmp69_);
		_tmp70_ = ccall;
		_tmp71_ = vala_ccode_identifier_new ("construct_properties");
		_tmp72_ = _tmp71_;
		vala_ccode_function_call_add_argument (_tmp70_, (ValaCCodeExpression*) _tmp72_);
		_vala_ccode_node_unref0 (_tmp72_);
		_tmp73_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_ccode_identifier_new ("obj");
		_tmp76_ = _tmp75_;
		_tmp77_ = ccall;
		vala_ccode_function_add_assignment (_tmp74_, (ValaCCodeExpression*) _tmp76_, (ValaCCodeExpression*) _tmp77_);
		_vala_ccode_node_unref0 (_tmp76_);
		_tmp78_ = vala_ccode_identifier_new ("obj");
		_tmp79_ = _tmp78_;
		_tmp80_ = cl;
		_tmp81_ = vala_ccode_base_module_generate_instance_cast ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) _tmp79_, (ValaTypeSymbol*) _tmp80_);
		_vala_ccode_node_unref0 (ccall);
		ccall = _tmp81_;
		_vala_ccode_node_unref0 (_tmp79_);
		_tmp82_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp83_ = _tmp82_;
		_tmp84_ = cl;
		_tmp85_ = vala_get_ccode_name ((ValaCodeNode*) _tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = g_strdup_printf ("%s *", _tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_ccode_variable_declarator_new ("self", NULL, NULL);
		_tmp90_ = _tmp89_;
		vala_ccode_function_add_declaration (_tmp83_, _tmp88_, (ValaCCodeDeclarator*) _tmp90_, 0);
		_vala_ccode_node_unref0 (_tmp90_);
		_g_free0 (_tmp88_);
		_g_free0 (_tmp86_);
		_tmp91_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_ccode_identifier_new ("self");
		_tmp94_ = _tmp93_;
		_tmp95_ = ccall;
		vala_ccode_function_add_assignment (_tmp92_, (ValaCCodeExpression*) _tmp94_, (ValaCCodeExpression*) _tmp95_);
		_vala_ccode_node_unref0 (_tmp94_);
		_tmp96_ = vala_subroutine_get_body ((ValaSubroutine*) c);
		_tmp97_ = _tmp96_;
		vala_code_node_emit ((ValaCodeNode*) _tmp97_, (ValaCodeGenerator*) self);
		_tmp98_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
		_tmp99_ = _tmp98_;
		if (_tmp99_) {
			ValaCCodeFunction* _tmp100_;
			ValaCCodeFunction* _tmp101_;
			ValaCCodeConstant* _tmp102_;
			ValaCCodeConstant* _tmp103_;
			ValaCCodeVariableDeclarator* _tmp104_;
			ValaCCodeVariableDeclarator* _tmp105_;
			_tmp100_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp101_ = _tmp100_;
			_tmp102_ = vala_ccode_constant_new ("NULL");
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_ccode_variable_declarator_new_zero ("_inner_error_", (ValaCCodeExpression*) _tmp103_, NULL);
			_tmp105_ = _tmp104_;
			vala_ccode_function_add_declaration (_tmp101_, "GError *", (ValaCCodeDeclarator*) _tmp105_, 0);
			_vala_ccode_node_unref0 (_tmp105_);
			_vala_ccode_node_unref0 (_tmp103_);
		}
		_tmp106_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_ccode_identifier_new ("obj");
		_tmp109_ = _tmp108_;
		vala_ccode_function_add_return (_tmp107_, (ValaCCodeExpression*) _tmp109_);
		_vala_ccode_node_unref0 (_tmp109_);
		vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
		_tmp110_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp111_ = function;
		vala_ccode_file_add_function (_tmp110_, _tmp111_);
		vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		_vala_ccode_node_unref0 (ccall);
		_vala_ccode_node_unref0 (ccast);
		_vala_ccode_node_unref0 (function);
	} else {
		ValaMemberBinding _tmp112_;
		ValaMemberBinding _tmp113_;
		_tmp112_ = vala_constructor_get_binding (c);
		_tmp113_ = _tmp112_;
		if (_tmp113_ == VALA_MEMBER_BINDING_CLASS) {
			ValaClass* _tmp114_;
			gboolean _tmp115_;
			gboolean _tmp116_;
			ValaCCodeBaseModuleEmitContext* _tmp119_;
			ValaBlock* _tmp120_;
			ValaBlock* _tmp121_;
			gboolean _tmp122_;
			gboolean _tmp123_;
			_tmp114_ = cl;
			_tmp115_ = vala_class_get_is_compact (_tmp114_);
			_tmp116_ = _tmp115_;
			if (_tmp116_) {
				ValaSourceReference* _tmp117_;
				ValaSourceReference* _tmp118_;
				_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp118_ = _tmp117_;
				vala_report_error (_tmp118_, "class constructors are not supported in compact classes");
				vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
				_vala_code_node_unref0 (cl);
				return;
			}
			_tmp119_ = ((ValaCCodeBaseModule*) self)->base_init_context;
			vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp119_);
			_tmp120_ = vala_subroutine_get_body ((ValaSubroutine*) c);
			_tmp121_ = _tmp120_;
			vala_code_node_emit ((ValaCodeNode*) _tmp121_, (ValaCodeGenerator*) self);
			_tmp122_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
			_tmp123_ = _tmp122_;
			if (_tmp123_) {
				ValaCCodeFunction* _tmp124_;
				ValaCCodeFunction* _tmp125_;
				ValaCCodeConstant* _tmp126_;
				ValaCCodeConstant* _tmp127_;
				ValaCCodeVariableDeclarator* _tmp128_;
				ValaCCodeVariableDeclarator* _tmp129_;
				_tmp124_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp125_ = _tmp124_;
				_tmp126_ = vala_ccode_constant_new ("NULL");
				_tmp127_ = _tmp126_;
				_tmp128_ = vala_ccode_variable_declarator_new_zero ("_inner_error_", (ValaCCodeExpression*) _tmp127_, NULL);
				_tmp129_ = _tmp128_;
				vala_ccode_function_add_declaration (_tmp125_, "GError *", (ValaCCodeDeclarator*) _tmp129_, 0);
				_vala_ccode_node_unref0 (_tmp129_);
				_vala_ccode_node_unref0 (_tmp127_);
			}
			vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
		} else {
			ValaMemberBinding _tmp130_;
			ValaMemberBinding _tmp131_;
			_tmp130_ = vala_constructor_get_binding (c);
			_tmp131_ = _tmp130_;
			if (_tmp131_ == VALA_MEMBER_BINDING_STATIC) {
				ValaClass* _tmp132_;
				gboolean _tmp133_;
				gboolean _tmp134_;
				ValaCCodeBaseModuleEmitContext* _tmp137_;
				ValaBlock* _tmp138_;
				ValaBlock* _tmp139_;
				gboolean _tmp140_;
				gboolean _tmp141_;
				_tmp132_ = cl;
				_tmp133_ = vala_class_get_is_compact (_tmp132_);
				_tmp134_ = _tmp133_;
				if (_tmp134_) {
					ValaSourceReference* _tmp135_;
					ValaSourceReference* _tmp136_;
					_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
					_tmp136_ = _tmp135_;
					vala_report_error (_tmp136_, "static constructors are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) c, TRUE);
					_vala_code_node_unref0 (cl);
					return;
				}
				_tmp137_ = ((ValaCCodeBaseModule*) self)->class_init_context;
				vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp137_);
				_tmp138_ = vala_subroutine_get_body ((ValaSubroutine*) c);
				_tmp139_ = _tmp138_;
				vala_code_node_emit ((ValaCodeNode*) _tmp139_, (ValaCodeGenerator*) self);
				_tmp140_ = vala_ccode_base_module_get_current_method_inner_error ((ValaCCodeBaseModule*) self);
				_tmp141_ = _tmp140_;
				if (_tmp141_) {
					ValaCCodeFunction* _tmp142_;
					ValaCCodeFunction* _tmp143_;
					ValaCCodeConstant* _tmp144_;
					ValaCCodeConstant* _tmp145_;
					ValaCCodeVariableDeclarator* _tmp146_;
					ValaCCodeVariableDeclarator* _tmp147_;
					_tmp142_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp143_ = _tmp142_;
					_tmp144_ = vala_ccode_constant_new ("NULL");
					_tmp145_ = _tmp144_;
					_tmp146_ = vala_ccode_variable_declarator_new_zero ("_inner_error_", (ValaCCodeExpression*) _tmp145_, NULL);
					_tmp147_ = _tmp146_;
					vala_ccode_function_add_declaration (_tmp143_, "GError *", (ValaCCodeDeclarator*) _tmp147_, 0);
					_vala_ccode_node_unref0 (_tmp147_);
					_vala_ccode_node_unref0 (_tmp145_);
				}
				vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
			} else {
				ValaSourceReference* _tmp148_;
				ValaSourceReference* _tmp149_;
				_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp149_ = _tmp148_;
				vala_report_error (_tmp149_, "internal error: constructors must have instance, class, or static bind" \
"ing");
			}
		}
	}
	vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (cl);
}


static gchar*
vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* getter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeModifiers _tmp24_;
	ValaCCodeModifiers _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	ValaCCodeParameter* _tmp31_;
	ValaCCodeParameter* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaDataType* _tmp36_;
	ValaDataType* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	ValaCCodeVariableDeclarator* _tmp40_;
	ValaCCodeVariableDeclarator* _tmp41_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeUnaryExpression* _tmp55_;
	ValaCCodeUnaryExpression* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeFunction* _tmp63_;
	ValaCCodeFunction* _tmp64_;
	ValaCCodeIdentifier* _tmp65_;
	ValaCCodeIdentifier* _tmp66_;
	ValaCCodeFile* _tmp67_;
	ValaCCodeFunction* _tmp68_;
	ValaCCodeFile* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_get_%s%d", _tmp12_, _tmp13_);
	getter_cname = _tmp14_;
	_tmp15_ = getter_cname;
	_tmp16_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_get_ccode_name ((ValaCodeNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_ccode_function_new (_tmp15_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	func = _tmp21_;
	_tmp22_ = func;
	_tmp23_ = func;
	_tmp24_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp23_, _tmp25_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp26_ = func;
	_tmp27_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_ccode_parameter_new ("obj", _tmp30_);
	_tmp32_ = _tmp31_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp33_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_get_ccode_name ((ValaCodeNode*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp41_ = _tmp40_;
	vala_ccode_function_add_declaration (_tmp35_, _tmp39_, (ValaCCodeDeclarator*) _tmp41_, 0);
	_vala_ccode_node_unref0 (_tmp41_);
	_g_free0 (_tmp39_);
	_tmp42_ = vala_ccode_identifier_new ("g_object_get");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	call = _tmp45_;
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("obj");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = call;
	_tmp53_ = vala_ccode_identifier_new ("result");
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp56_);
	_vala_ccode_node_unref0 (_tmp56_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp57_ = call;
	_tmp58_ = vala_ccode_constant_new ("NULL");
	_tmp59_ = _tmp58_;
	vala_ccode_function_call_add_argument (_tmp57_, (ValaCCodeExpression*) _tmp59_);
	_vala_ccode_node_unref0 (_tmp59_);
	_tmp60_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = call;
	vala_ccode_function_add_expression (_tmp61_, (ValaCCodeExpression*) _tmp62_);
	_tmp63_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_identifier_new ("result");
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_return (_tmp64_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp67_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp68_ = func;
	vala_ccode_file_add_function_declaration (_tmp67_, _tmp68_);
	_tmp69_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp70_ = func;
	vala_ccode_file_add_function (_tmp69_, _tmp70_);
	result = getter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}


static gchar*
vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeBaseModule* base,
                                                            ValaDynamicProperty* prop)
{
	ValaGObjectModule * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* setter_cname = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeFunction* _tmp18_;
	ValaCCodeModifiers _tmp19_;
	ValaCCodeModifiers _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	ValaCCodeParameter* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeFunction* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeParameter* _tmp33_;
	ValaCCodeParameter* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunctionCall* _tmp54_;
	ValaCCodeFile* _tmp55_;
	ValaCCodeFunction* _tmp56_;
	ValaCCodeFile* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_property_get_dynamic_type (prop);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->dynamic_property_id;
	self->priv->dynamic_property_id = _tmp13_ + 1;
	_tmp14_ = g_strdup_printf ("_dynamic_set_%s%d", _tmp12_, _tmp13_);
	setter_cname = _tmp14_;
	_tmp15_ = setter_cname;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "void");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = func;
	_tmp19_ = vala_ccode_node_get_modifiers ((ValaCCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp18_, _tmp20_ | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp21_ = func;
	_tmp22_ = vala_dynamic_property_get_dynamic_type (prop);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_get_ccode_name ((ValaCodeNode*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_parameter_new ("obj", _tmp25_);
	_tmp27_ = _tmp26_;
	vala_ccode_function_add_parameter (_tmp21_, _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_g_free0 (_tmp25_);
	_tmp28_ = func;
	_tmp29_ = vala_property_get_property_type ((ValaProperty*) prop);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_parameter_new ("value", _tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_add_parameter (_tmp28_, _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_tmp35_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp36_ = vala_ccode_identifier_new ("g_object_set");
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp37_);
	_tmp39_ = _tmp38_;
	_vala_ccode_node_unref0 (_tmp37_);
	call = _tmp39_;
	_tmp40_ = call;
	_tmp41_ = vala_ccode_identifier_new ("obj");
	_tmp42_ = _tmp41_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
	_vala_ccode_node_unref0 (_tmp42_);
	_tmp43_ = call;
	_tmp44_ = vala_ccode_base_module_get_property_canonical_cconstant ((ValaCCodeBaseModule*) self, (ValaProperty*) prop);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp43_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("value");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = vala_ccode_constant_new ("NULL");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = call;
	vala_ccode_function_add_expression (_tmp53_, (ValaCCodeExpression*) _tmp54_);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp55_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp56_ = func;
	vala_ccode_file_add_function_declaration (_tmp55_, _tmp56_);
	_tmp57_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp58_ = func;
	vala_ccode_file_add_function (_tmp57_, _tmp58_);
	result = setter_cname;
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (func);
	return result;
}


static gchar*
vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeBaseModule* base,
                                                   ValaDynamicSignal* node)
{
	ValaGObjectModule * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) node);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->signal_wrapper_id;
	self->priv->signal_wrapper_id = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf ("dynamic_%s%d_", _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeBaseModule* base,
                                                                  ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, FALSE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}


static gchar*
vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name (ValaCCodeBaseModule* base,
                                                                        ValaDynamicSignal* sig)
{
	ValaGObjectModule * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaTypeSymbol* _tmp4_;
	gchar* connect_wrapper_name = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeFunction* func = NULL;
	const gchar* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFile* _tmp30_;
	ValaCCodeFunction* _tmp31_;
	ValaCCodeFile* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp1_ = vala_dynamic_signal_get_dynamic_type (sig);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_data_type_get_data_type (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp5_ = vala_dynamic_signal_get_dynamic_type (sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_get_data_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp0_ = !vala_typesymbol_is_subtype_of (_tmp8_, _tmp9_);
	}
	if (_tmp0_) {
		gchar* _tmp10_;
		_tmp10_ = VALA_CCODE_BASE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), sig);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = vala_ccode_base_module_get_dynamic_signal_cname ((ValaCCodeBaseModule*) self, sig);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("_%sconnect_after", _tmp12_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	connect_wrapper_name = _tmp14_;
	_tmp15_ = connect_wrapper_name;
	_tmp16_ = vala_ccode_function_new (_tmp15_, "gulong");
	func = _tmp16_;
	_tmp17_ = func;
	_tmp18_ = vala_ccode_parameter_new ("obj", "gpointer");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = func;
	_tmp21_ = vala_ccode_parameter_new ("signal_name", "const char *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = func;
	_tmp24_ = vala_ccode_parameter_new ("handler", "GCallback");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = func;
	_tmp27_ = vala_ccode_parameter_new ("data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = func;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, TRUE);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp30_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp31_ = func;
	vala_ccode_file_add_function_declaration (_tmp30_, _tmp31_);
	_tmp32_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp33_ = func;
	vala_ccode_file_add_function (_tmp32_, _tmp33_);
	result = connect_wrapper_name;
	_vala_ccode_node_unref0 (func);
	return result;
}


static void
vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self,
                                                      ValaDynamicSignal* sig,
                                                      gboolean after)
{
	ValaMethod* m = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaMethod* _tmp4_;
	gchar* connect_func = NULL;
	gchar* _tmp5_;
	ValaMethod* _tmp6_;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	ValaCCodeFunctionCall* call = NULL;
	const gchar* _tmp11_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeIdentifier* _tmp26_;
	ValaCCodeIdentifier* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMemberBinding _tmp29_;
	ValaMemberBinding _tmp30_;
	ValaCCodeFunction* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_dynamic_signal_get_handler (sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp5_ = g_strdup ("g_signal_connect_object");
	connect_func = _tmp5_;
	_tmp6_ = m;
	_tmp7_ = vala_method_get_binding (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup ("g_signal_connect");
			_g_free0 (connect_func);
			connect_func = _tmp9_;
		} else {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("g_signal_connect_after");
			_g_free0 (connect_func);
			connect_func = _tmp10_;
		}
	}
	_tmp11_ = connect_func;
	_tmp12_ = vala_ccode_identifier_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	call = _tmp15_;
	_tmp16_ = call;
	_tmp17_ = vala_ccode_identifier_new ("obj");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = call;
	_tmp20_ = vala_ccode_identifier_new ("signal_name");
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, (ValaCCodeExpression*) _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = call;
	_tmp23_ = vala_ccode_identifier_new ("handler");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = call;
	_tmp26_ = vala_ccode_identifier_new ("data");
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = m;
	_tmp29_ = vala_method_get_binding (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ == VALA_MEMBER_BINDING_INSTANCE) {
		if (!after) {
			ValaCCodeFunctionCall* _tmp31_;
			ValaCCodeConstant* _tmp32_;
			ValaCCodeConstant* _tmp33_;
			_tmp31_ = call;
			_tmp32_ = vala_ccode_constant_new ("0");
			_tmp33_ = _tmp32_;
			vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
		} else {
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeConstant* _tmp35_;
			ValaCCodeConstant* _tmp36_;
			_tmp34_ = call;
			_tmp35_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp36_ = _tmp35_;
			vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
		}
	}
	_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = call;
	vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (connect_func);
	_vala_code_node_unref0 (m);
}


static void
vala_gobject_module_real_visit_property (ValaCodeVisitor* base,
                                         ValaProperty* prop)
{
	ValaGObjectModule * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (prop != NULL);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), prop);
	if (vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, prop)) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
		_tmp2_ = _tmp1_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		ValaCCodeEnumValue* _tmp8_;
		ValaCCodeEnumValue* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp3_ = ((ValaCCodeBaseModule*) self)->prop_enum;
		_tmp4_ = vala_get_ccode_upper_case_name ((ValaSymbol*) prop, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%s_PROPERTY", _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_enum_value_new (_tmp7_, NULL);
		_tmp9_ = _tmp8_;
		vala_ccode_enum_add_value (_tmp3_, _tmp9_);
		_vala_ccode_node_unref0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_tmp12_ = vala_property_get_initializer (prop);
		_tmp13_ = _tmp12_;
		if (_tmp13_ != NULL) {
			ValaPropertyAccessor* _tmp14_;
			ValaPropertyAccessor* _tmp15_;
			_tmp14_ = vala_property_get_set_accessor (prop);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaPropertyAccessor* _tmp16_;
			ValaPropertyAccessor* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp16_ = vala_property_get_set_accessor (prop);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_property_accessor_get_automatic_body (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp10_ = !_tmp19_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gboolean has_spec_initializer = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			ValaTypeSymbol* _tmp22_;
			ValaTypeSymbol* _tmp23_;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_;
			gboolean _tmp36_;
			_tmp20_ = vala_property_get_property_type (prop);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_data_type_get_data_type (_tmp21_);
			_tmp23_ = _tmp22_;
			has_spec_initializer = G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_ENUM);
			_tmp25_ = has_spec_initializer;
			if (!_tmp25_) {
				ValaDataType* _tmp26_;
				ValaDataType* _tmp27_;
				ValaTypeSymbol* _tmp28_;
				ValaTypeSymbol* _tmp29_;
				_tmp26_ = vala_property_get_property_type (prop);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_data_type_get_data_type (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_STRUCT);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				gchar* param_spec_func = NULL;
				ValaDataType* _tmp30_;
				ValaDataType* _tmp31_;
				ValaTypeSymbol* _tmp32_;
				ValaTypeSymbol* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp30_ = vala_property_get_property_type (prop);
				_tmp31_ = _tmp30_;
				_tmp32_ = vala_data_type_get_data_type (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_get_ccode_param_spec_function ((ValaCodeNode*) _tmp33_);
				param_spec_func = _tmp34_;
				_tmp35_ = param_spec_func;
				has_spec_initializer = g_strcmp0 (_tmp35_, "g_param_spec_boxed") != 0;
				_g_free0 (param_spec_func);
			}
			_tmp36_ = has_spec_initializer;
			if (!_tmp36_) {
				ValaCCodeBaseModuleEmitContext* _tmp37_;
				ValaExpression* _tmp38_;
				ValaExpression* _tmp39_;
				ValaMemberAccess* inst_ma = NULL;
				ValaMemberAccess* _tmp40_;
				ValaMemberAccess* _tmp41_;
				ValaSymbol* _tmp42_;
				ValaSymbol* _tmp43_;
				ValaDataType* _tmp44_;
				ValaDataType* _tmp45_;
				ValaCCodeIdentifier* _tmp46_;
				ValaCCodeIdentifier* _tmp47_;
				ValaGLibValue* _tmp48_;
				ValaGLibValue* _tmp49_;
				ValaMemberAccess* _tmp50_;
				ValaExpression* _tmp51_;
				ValaExpression* _tmp52_;
				ValaTargetValue* _tmp53_;
				ValaTargetValue* _tmp54_;
				ValaArrayList* _tmp55_;
				ValaArrayList* _tmp56_;
				_tmp37_ = ((ValaCCodeBaseModule*) self)->instance_init_context;
				vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp37_);
				_tmp38_ = vala_property_get_initializer (prop);
				_tmp39_ = _tmp38_;
				vala_code_node_emit ((ValaCodeNode*) _tmp39_, (ValaCodeGenerator*) self);
				_tmp40_ = vala_member_access_new_simple ("this", NULL);
				inst_ma = _tmp40_;
				_tmp41_ = inst_ma;
				_tmp42_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_ccode_base_module_get_data_type_for_symbol ((ValaTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, VALA_TYPE_CLASS, ValaClass));
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_ccode_identifier_new ("self");
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_glib_value_new (_tmp45_, (ValaCCodeExpression*) _tmp47_, TRUE);
				_tmp49_ = _tmp48_;
				vala_expression_set_target_value ((ValaExpression*) _tmp41_, (ValaTargetValue*) _tmp49_);
				_vala_target_value_unref0 (_tmp49_);
				_vala_ccode_node_unref0 (_tmp47_);
				_vala_code_node_unref0 (_tmp45_);
				_tmp50_ = inst_ma;
				_tmp51_ = vala_property_get_initializer (prop);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_expression_get_target_value (_tmp52_);
				_tmp54_ = _tmp53_;
				vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, prop, (ValaExpression*) _tmp50_, _tmp54_);
				_tmp55_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
				_tmp56_ = _tmp55_;
				vala_collection_clear ((ValaCollection*) _tmp56_);
				vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
				_vala_code_node_unref0 (inst_ma);
			}
		}
	}
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
vala_gobject_module_real_is_gobject_property (ValaCCodeBaseModule* base,
                                              ValaProperty* prop)
{
	ValaGObjectModule * self;
	gboolean result = FALSE;
	ValaObjectTypeSymbol* type_sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaObjectTypeSymbol* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaObjectTypeSymbol* _tmp4_;
	ValaMemberBinding _tmp7_;
	ValaMemberBinding _tmp8_;
	ValaSymbolAccessibility _tmp9_;
	ValaSymbolAccessibility _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ValaObjectTypeSymbol* _tmp13_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	ValaObjectTypeSymbol* _tmp23_;
	gboolean _tmp30_ = FALSE;
	ValaObjectTypeSymbol* _tmp31_;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) prop);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_OBJECT_TYPE_SYMBOL) ? ((ValaObjectTypeSymbol*) _tmp1_) : NULL);
	type_sym = _tmp2_;
	_tmp4_ = type_sym;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		ValaObjectTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp5_ = type_sym;
		_tmp6_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_tmp3_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp5_, _tmp6_);
	}
	if (_tmp3_) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	_tmp7_ = vala_property_get_binding (prop);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	_tmp9_ = vala_symbol_get_access ((ValaSymbol*) prop);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	if (!vala_gobject_module_has_valid_gobject_property_type (self, prop)) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	_tmp13_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_CLASS)) {
		ValaProperty* _tmp14_;
		ValaProperty* _tmp15_;
		_tmp14_ = vala_property_get_base_interface_property (prop);
		_tmp15_ = _tmp14_;
		_tmp12_ = _tmp15_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaProperty* _tmp16_;
		ValaProperty* _tmp17_;
		_tmp16_ = vala_property_get_base_interface_property (prop);
		_tmp17_ = _tmp16_;
		_tmp11_ = !vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, _tmp17_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	_tmp18_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp19_ = _tmp18_;
	if (!g_ascii_isalpha (string_get (_tmp19_, (glong) 0))) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	_tmp23_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_INTERFACE)) {
		gboolean _tmp24_;
		gboolean _tmp25_;
		_tmp24_ = vala_property_get_is_abstract (prop);
		_tmp25_ = _tmp24_;
		_tmp22_ = !_tmp25_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gboolean _tmp26_;
		gboolean _tmp27_;
		_tmp26_ = vala_symbol_get_external ((ValaSymbol*) prop);
		_tmp27_ = _tmp26_;
		_tmp21_ = !_tmp27_;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp28_ = vala_symbol_get_external_package ((ValaSymbol*) prop);
		_tmp29_ = _tmp28_;
		_tmp20_ = !_tmp29_;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	_tmp31_ = type_sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_INTERFACE)) {
		ValaObjectTypeSymbol* _tmp32_;
		ValaAttribute* _tmp33_;
		ValaAttribute* _tmp34_;
		_tmp32_ = type_sym;
		_tmp33_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp32_, "DBus");
		_tmp34_ = _tmp33_;
		_tmp30_ = _tmp34_ != NULL;
		_vala_code_node_unref0 (_tmp34_);
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		result = FALSE;
		_vala_code_node_unref0 (type_sym);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (type_sym);
	return result;
}


static gboolean
vala_gobject_module_has_valid_gobject_property_type (ValaGObjectModule* self,
                                                     ValaProperty* prop)
{
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaStruct* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaStruct* _tmp6_;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDelegateType* d = NULL;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDelegateType* _tmp27_;
	gboolean _tmp28_ = FALSE;
	ValaDelegateType* _tmp29_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp0_ = vala_property_get_property_type (prop);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_get_data_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp3_) : NULL);
	st = _tmp4_;
	_tmp6_ = st;
	if (_tmp6_ != NULL) {
		gboolean _tmp7_ = FALSE;
		ValaStruct* _tmp8_;
		_tmp8_ = st;
		if (!vala_get_ccode_has_type_id ((ValaTypeSymbol*) _tmp8_)) {
			_tmp7_ = TRUE;
		} else {
			ValaDataType* _tmp9_;
			ValaDataType* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_property_get_property_type (prop);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_data_type_get_nullable (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = _tmp12_;
		}
		_tmp5_ = _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = FALSE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp14_ = vala_property_get_property_type (prop);
	_tmp15_ = _tmp14_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_ARRAY_TYPE)) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaTypeSymbol* _tmp21_;
		ValaDataType* _tmp22_;
		ValaTypeSymbol* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		_tmp16_ = vala_property_get_property_type (prop);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_data_type_get_data_type (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = ((ValaCCodeBaseModule*) self)->string_type;
		_tmp23_ = vala_data_type_get_data_type (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp13_ = _tmp21_ != _tmp24_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = FALSE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp25_ = vala_property_get_property_type (prop);
	_tmp26_ = _tmp25_;
	_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp26_) : NULL);
	d = _tmp27_;
	_tmp29_ = d;
	if (_tmp29_ != NULL) {
		ValaDelegateType* _tmp30_;
		ValaDelegate* _tmp31_;
		ValaDelegate* _tmp32_;
		gboolean _tmp33_;
		gboolean _tmp34_;
		_tmp30_ = d;
		_tmp31_ = vala_delegate_type_get_delegate_symbol (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_delegate_get_has_target (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp28_ = _tmp34_;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		result = FALSE;
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (st);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (d);
	_vala_code_node_unref0 (st);
	return result;
}


static void
vala_gobject_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGObjectModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		ValaMemberAccess* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaMemberAccess* _tmp9_;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_push_line ((ValaCCodeBaseModule*) self, _tmp3_);
		_tmp4_ = vala_method_call_get_call (expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
		ma = _tmp6_;
		_tmp9_ = ma;
		_tmp10_ = vala_member_access_get_inner (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ != NULL) {
			ValaMemberAccess* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			_tmp12_ = ma;
			_tmp13_ = vala_member_access_get_inner (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			_tmp8_ = _tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_SYMBOL, ValaSymbol);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			ValaMemberAccess* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp21_ = ma;
			_tmp22_ = vala_member_access_get_member_name (_tmp21_);
			_tmp23_ = _tmp22_;
			if (g_strcmp0 (_tmp23_, "new") == 0) {
				_tmp20_ = TRUE;
			} else {
				ValaMemberAccess* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp24_ = ma;
				_tmp25_ = vala_member_access_get_member_name (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = g_strcmp0 (_tmp26_, "newv") == 0;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				ValaMemberAccess* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				_tmp27_ = ma;
				_tmp28_ = vala_member_access_get_member_name (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp19_ = g_strcmp0 (_tmp29_, "new_valist") == 0;
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				ValaMemberAccess* _tmp30_;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = ma;
				_tmp31_ = vala_member_access_get_member_name (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp18_ = g_strcmp0 (_tmp32_, "new_with_properties") == 0;
			}
			_tmp7_ = _tmp18_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaCCodeFunctionCall* initiallyunowned_ccall = NULL;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaCCodeExpression* _tmp38_;
			ValaCCodeExpression* _tmp39_;
			ValaCCodeFunctionCall* sink_ref_ccall = NULL;
			ValaCCodeIdentifier* _tmp40_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeFunctionCall* _tmp42_;
			ValaCCodeFunctionCall* _tmp43_;
			ValaCCodeFunctionCall* _tmp44_;
			ValaCCodeExpression* _tmp45_;
			ValaCCodeExpression* _tmp46_;
			ValaCCodeConditionalExpression* cexpr = NULL;
			ValaCCodeFunctionCall* _tmp47_;
			ValaCCodeFunctionCall* _tmp48_;
			ValaCCodeExpression* _tmp49_;
			ValaCCodeExpression* _tmp50_;
			ValaCCodeConditionalExpression* _tmp51_;
			ValaCCodeConditionalExpression* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaCCodeConditionalExpression* _tmp55_;
			ValaGLibValue* _tmp56_;
			ValaGLibValue* _tmp57_;
			ValaTargetValue* _tmp58_;
			ValaTargetValue* _tmp59_;
			VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
			_tmp33_ = vala_ccode_identifier_new ("G_IS_INITIALLY_UNOWNED");
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			initiallyunowned_ccall = _tmp36_;
			_tmp37_ = initiallyunowned_ccall;
			_tmp38_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp39_ = _tmp38_;
			vala_ccode_function_call_add_argument (_tmp37_, _tmp39_);
			_vala_ccode_node_unref0 (_tmp39_);
			_tmp40_ = vala_ccode_identifier_new ("g_object_ref_sink");
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp41_);
			_tmp43_ = _tmp42_;
			_vala_ccode_node_unref0 (_tmp41_);
			sink_ref_ccall = _tmp43_;
			_tmp44_ = sink_ref_ccall;
			_tmp45_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp46_ = _tmp45_;
			vala_ccode_function_call_add_argument (_tmp44_, _tmp46_);
			_vala_ccode_node_unref0 (_tmp46_);
			_tmp47_ = initiallyunowned_ccall;
			_tmp48_ = sink_ref_ccall;
			_tmp49_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp47_, (ValaCCodeExpression*) _tmp48_, _tmp50_);
			_tmp52_ = _tmp51_;
			_vala_ccode_node_unref0 (_tmp50_);
			cexpr = _tmp52_;
			_tmp53_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp54_ = _tmp53_;
			_tmp55_ = cexpr;
			_tmp56_ = vala_glib_value_new (_tmp54_, (ValaCCodeExpression*) _tmp55_, FALSE);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp57_, (ValaCodeNode*) expr, NULL);
			_tmp59_ = _tmp58_;
			vala_expression_set_target_value ((ValaExpression*) expr, _tmp59_);
			_vala_target_value_unref0 (_tmp59_);
			_vala_target_value_unref0 (_tmp57_);
			_vala_ccode_node_unref0 (cexpr);
			_vala_ccode_node_unref0 (sink_ref_ccall);
			_vala_ccode_node_unref0 (initiallyunowned_ccall);
			_vala_code_node_unref0 (ma);
			return;
		} else {
			ValaMemberAccess* _tmp60_;
			ValaSymbol* _tmp61_;
			ValaSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			_tmp60_ = ma;
			_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = ((ValaCCodeBaseModule*) self)->gobject_type;
			if (_tmp62_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				{
					ValaList* _arg_list = NULL;
					ValaList* _tmp64_;
					gint _arg_size = 0;
					ValaList* _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					gint _arg_index = 0;
					_tmp64_ = vala_method_call_get_argument_list (expr);
					_arg_list = _tmp64_;
					_tmp65_ = _arg_list;
					_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
					_tmp67_ = _tmp66_;
					_arg_size = _tmp67_;
					_arg_index = -1;
					while (TRUE) {
						gint _tmp68_;
						gint _tmp69_;
						gint _tmp70_;
						ValaExpression* arg = NULL;
						ValaList* _tmp71_;
						gint _tmp72_;
						gpointer _tmp73_;
						ValaNamedArgument* named_argument = NULL;
						ValaExpression* _tmp74_;
						ValaNamedArgument* _tmp75_;
						ValaNamedArgument* _tmp76_;
						ValaProperty* prop = NULL;
						ValaClass* _tmp80_;
						ValaClass* _tmp81_;
						ValaNamedArgument* _tmp82_;
						const gchar* _tmp83_;
						const gchar* _tmp84_;
						ValaSymbol* _tmp85_;
						ValaProperty* _tmp86_;
						ValaProperty* _tmp87_;
						ValaProperty* _tmp100_;
						ValaExpression* _tmp109_;
						ValaDataType* _tmp110_;
						ValaDataType* _tmp111_;
						ValaProperty* _tmp112_;
						ValaDataType* _tmp113_;
						ValaDataType* _tmp114_;
						_tmp68_ = _arg_index;
						_arg_index = _tmp68_ + 1;
						_tmp69_ = _arg_index;
						_tmp70_ = _arg_size;
						if (!(_tmp69_ < _tmp70_)) {
							break;
						}
						_tmp71_ = _arg_list;
						_tmp72_ = _arg_index;
						_tmp73_ = vala_list_get (_tmp71_, _tmp72_);
						arg = (ValaExpression*) _tmp73_;
						_tmp74_ = arg;
						_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_NAMED_ARGUMENT) ? ((ValaNamedArgument*) _tmp74_) : NULL);
						named_argument = _tmp75_;
						_tmp76_ = named_argument;
						if (_tmp76_ == NULL) {
							ValaExpression* _tmp77_;
							ValaSourceReference* _tmp78_;
							ValaSourceReference* _tmp79_;
							_tmp77_ = arg;
							_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
							_tmp79_ = _tmp78_;
							vala_report_error (_tmp79_, "Named argument expected");
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp80_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp81_ = _tmp80_;
						_tmp82_ = named_argument;
						_tmp83_ = vala_named_argument_get_name (_tmp82_);
						_tmp84_ = _tmp83_;
						_tmp85_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp81_, _tmp84_);
						_tmp86_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp85_) : NULL;
						if (_tmp86_ == NULL) {
							_vala_code_node_unref0 (_tmp85_);
						}
						prop = _tmp86_;
						_tmp87_ = prop;
						if (_tmp87_ == NULL) {
							ValaExpression* _tmp88_;
							ValaSourceReference* _tmp89_;
							ValaSourceReference* _tmp90_;
							ValaNamedArgument* _tmp91_;
							const gchar* _tmp92_;
							const gchar* _tmp93_;
							ValaClass* _tmp94_;
							ValaClass* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							_tmp88_ = arg;
							_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = named_argument;
							_tmp92_ = vala_named_argument_get_name (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
							_tmp95_ = _tmp94_;
							_tmp96_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp95_);
							_tmp97_ = _tmp96_;
							_tmp98_ = g_strdup_printf ("Property `%s' not found in `%s'", _tmp93_, _tmp97_);
							_tmp99_ = _tmp98_;
							vala_report_error (_tmp90_, _tmp99_);
							_g_free0 (_tmp99_);
							_g_free0 (_tmp97_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp100_ = prop;
						if (!vala_ccode_base_module_is_gobject_property ((ValaCCodeBaseModule*) self, _tmp100_)) {
							ValaExpression* _tmp101_;
							ValaSourceReference* _tmp102_;
							ValaSourceReference* _tmp103_;
							ValaNamedArgument* _tmp104_;
							const gchar* _tmp105_;
							const gchar* _tmp106_;
							gchar* _tmp107_;
							gchar* _tmp108_;
							_tmp101_ = arg;
							_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp101_);
							_tmp103_ = _tmp102_;
							_tmp104_ = named_argument;
							_tmp105_ = vala_named_argument_get_name (_tmp104_);
							_tmp106_ = _tmp105_;
							_tmp107_ = g_strdup_printf ("Property `%s' not supported in Object (property: value) constructor ch" \
"ain up", _tmp106_);
							_tmp108_ = _tmp107_;
							vala_report_error (_tmp103_, _tmp108_);
							_g_free0 (_tmp108_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_tmp109_ = arg;
						_tmp110_ = vala_expression_get_value_type (_tmp109_);
						_tmp111_ = _tmp110_;
						_tmp112_ = prop;
						_tmp113_ = vala_property_get_property_type (_tmp112_);
						_tmp114_ = _tmp113_;
						if (!vala_data_type_compatible (_tmp111_, _tmp114_)) {
							ValaExpression* _tmp115_;
							ValaSourceReference* _tmp116_;
							ValaSourceReference* _tmp117_;
							ValaExpression* _tmp118_;
							ValaDataType* _tmp119_;
							ValaDataType* _tmp120_;
							gchar* _tmp121_;
							gchar* _tmp122_;
							ValaProperty* _tmp123_;
							ValaDataType* _tmp124_;
							ValaDataType* _tmp125_;
							gchar* _tmp126_;
							gchar* _tmp127_;
							gchar* _tmp128_;
							gchar* _tmp129_;
							_tmp115_ = arg;
							_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = arg;
							_tmp119_ = vala_expression_get_value_type (_tmp118_);
							_tmp120_ = _tmp119_;
							_tmp121_ = vala_code_node_to_string ((ValaCodeNode*) _tmp120_);
							_tmp122_ = _tmp121_;
							_tmp123_ = prop;
							_tmp124_ = vala_property_get_property_type (_tmp123_);
							_tmp125_ = _tmp124_;
							_tmp126_ = vala_code_node_to_string ((ValaCodeNode*) _tmp125_);
							_tmp127_ = _tmp126_;
							_tmp128_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp122_, _tmp127_);
							_tmp129_ = _tmp128_;
							vala_report_error (_tmp117_, _tmp129_);
							_g_free0 (_tmp129_);
							_g_free0 (_tmp127_);
							_g_free0 (_tmp122_);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (named_argument);
							_vala_code_node_unref0 (arg);
							break;
						}
						_vala_code_node_unref0 (prop);
						_vala_code_node_unref0 (named_argument);
						_vala_code_node_unref0 (arg);
					}
					_vala_iterable_unref0 (_arg_list);
				}
			}
		}
		vala_ccode_base_module_pop_line ((ValaCCodeBaseModule*) self);
		_vala_code_node_unref0 (ma);
	}
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GTYPE_MODULE, ValaGTypeModule), expr);
}


ValaGObjectModule*
vala_gobject_module_construct (GType object_type)
{
	ValaGObjectModule* self = NULL;
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type);
	return self;
}


ValaGObjectModule*
vala_gobject_module_new (void)
{
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE);
}


static void
vala_gobject_module_class_init (ValaGObjectModuleClass * klass)
{
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gobject_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGObjectModulePrivate));
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_gobject_module_real_visit_class;
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule *, ValaClass*)) vala_gobject_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor *, ValaConstructor*)) vala_gobject_module_real_visit_constructor;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_getter_cname = (gchar* (*) (ValaCCodeBaseModule *, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_getter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_property_setter_cname = (gchar* (*) (ValaCCodeBaseModule *, ValaDynamicProperty*)) vala_gobject_module_real_get_dynamic_property_setter_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_cname = (gchar* (*) (ValaCCodeBaseModule *, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_cname;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_wrapper_name = (gchar* (*) (ValaCCodeBaseModule *, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
	((ValaCCodeBaseModuleClass *) klass)->get_dynamic_signal_connect_after_wrapper_name = (gchar* (*) (ValaCCodeBaseModule *, ValaDynamicSignal*)) vala_gobject_module_real_get_dynamic_signal_connect_after_wrapper_name;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_gobject_module_real_visit_property;
	((ValaCCodeBaseModuleClass *) klass)->is_gobject_property = (gboolean (*) (ValaCCodeBaseModule *, ValaProperty*)) vala_gobject_module_real_is_gobject_property;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor *, ValaMethodCall*)) vala_gobject_module_real_visit_method_call;
}


static void
vala_gobject_module_instance_init (ValaGObjectModule * self)
{
	self->priv = VALA_GOBJECT_MODULE_GET_PRIVATE (self);
}


static void
vala_gobject_module_finalize (ValaCodeVisitor * obj)
{
	ValaGObjectModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule);
	VALA_CODE_VISITOR_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}


GType
vala_gobject_module_get_type (void)
{
	static volatile gsize vala_gobject_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gobject_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
		GType vala_gobject_module_type_id;
		vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gobject_module_type_id__volatile, vala_gobject_module_type_id);
	}
	return vala_gobject_module_type_id__volatile;
}



