/* valaforstatement.c generated by valac, the Vala compiler
 * generated from valaforstatement.vala, do not modify */

/* valaforstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaForStatementPrivate {
	ValaList* initializer;
	ValaList* iterator;
	ValaExpression* _condition;
	ValaBlock* _body;
};

static gint ValaForStatement_private_offset;
static gpointer vala_for_statement_parent_class = NULL;
static ValaStatementIface * vala_for_statement_vala_statement_parent_iface = NULL;

static void vala_for_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_for_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static void vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_for_statement_always_true (ValaForStatement* self,
                                         ValaExpression* condition);
static gboolean vala_for_statement_always_false (ValaForStatement* self,
                                          ValaExpression* condition);
static gboolean vala_for_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_for_statement_finalize (ValaCodeNode * obj);

static inline gpointer
vala_for_statement_get_instance_private (ValaForStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaForStatement_private_offset);
}

/**
 * Creates a new for statement.
 *
 * @param condition        loop condition
 * @param body             loop body
 * @param source_reference reference to source code
 * @return                 newly created for statement
 */
ValaForStatement*
vala_for_statement_construct (GType object_type,
                              ValaExpression* condition,
                              ValaBlock* body,
                              ValaSourceReference* source_reference)
{
	ValaForStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaForStatement*) vala_code_node_construct (object_type);
	vala_for_statement_set_condition (self, condition);
	vala_for_statement_set_body (self, body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaForStatement*
vala_for_statement_new (ValaExpression* condition,
                        ValaBlock* body,
                        ValaSourceReference* source_reference)
{
	return vala_for_statement_construct (VALA_TYPE_FOR_STATEMENT, condition, body, source_reference);
}

/**
 * Appends the specified expression to the list of initializers.
 *
 * @param init an initializer expression
 */
void
vala_for_statement_add_initializer (ValaForStatement* self,
                                    ValaExpression* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
	_tmp0_ = self->priv->initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
}

/**
 * Returns a copy of the list of initializers.
 *
 * @return initializer list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_for_statement_get_initializer (ValaForStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Appends the specified expression to the iterator.
 *
 * @param iter an iterator expression
 */
void
vala_for_statement_add_iterator (ValaForStatement* self,
                                 ValaExpression* iter)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) iter, (ValaCodeNode*) self);
	_tmp0_ = self->priv->iterator;
	vala_collection_add ((ValaCollection*) _tmp0_, iter);
}

/**
 * Returns a copy of the iterator.
 *
 * @return iterator
 */
ValaList*
vala_for_statement_get_iterator (ValaForStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->iterator;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_for_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_for_statement (visitor, self);
}

static void
vala_for_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaForStatement * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaBlock* _tmp24_;
	ValaBlock* _tmp25_;
	self = (ValaForStatement*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _init_expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _init_expr_index = 0;
		_tmp0_ = self->priv->initializer;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_init_expr_list = _tmp1_;
		_tmp2_ = _init_expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_init_expr_size = _tmp4_;
		_init_expr_index = -1;
		while (TRUE) {
			ValaExpression* init_expr = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			ValaExpression* _tmp8_;
			_init_expr_index = _init_expr_index + 1;
			if (!(_init_expr_index < _init_expr_size)) {
				break;
			}
			_tmp5_ = _init_expr_list;
			_tmp6_ = vala_list_get (_tmp5_, _init_expr_index);
			init_expr = (ValaExpression*) _tmp6_;
			_tmp7_ = init_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_tmp8_ = init_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp8_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp9_ = vala_for_statement_get_condition (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_for_statement_get_condition (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
		_tmp13_ = vala_for_statement_get_condition (self);
		_tmp14_ = _tmp13_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp14_);
	}
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _it_expr_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _it_expr_index = 0;
		_tmp15_ = self->priv->iterator;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_it_expr_list = _tmp16_;
		_tmp17_ = _it_expr_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_it_expr_size = _tmp19_;
		_it_expr_index = -1;
		while (TRUE) {
			ValaExpression* it_expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaExpression* _tmp22_;
			ValaExpression* _tmp23_;
			_it_expr_index = _it_expr_index + 1;
			if (!(_it_expr_index < _it_expr_size)) {
				break;
			}
			_tmp20_ = _it_expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _it_expr_index);
			it_expr = (ValaExpression*) _tmp21_;
			_tmp22_ = it_expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_tmp23_ = it_expr;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp23_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp24_ = vala_for_statement_get_body (self);
	_tmp25_ = _tmp24_;
	vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
}

static void
vala_for_statement_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaForStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaForStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_for_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_for_statement_set_condition (self, new_node);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaList* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->initializer;
				_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->initializer;
				_tmp8_ = vala_list_get (_tmp7_, i);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					_tmp11_ = self->priv->initializer;
					vala_list_set (_tmp11_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				ValaList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				ValaExpression* _tmp19_;
				gboolean _tmp20_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = self->priv->iterator;
				_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				if (!(i < _tmp16_)) {
					break;
				}
				_tmp17_ = self->priv->iterator;
				_tmp18_ = vala_list_get (_tmp17_, i);
				_tmp19_ = (ValaExpression*) _tmp18_;
				_tmp20_ = _tmp19_ == old_node;
				_vala_code_node_unref0 (_tmp19_);
				if (_tmp20_) {
					ValaList* _tmp21_;
					_tmp21_ = self->priv->iterator;
					vala_list_set (_tmp21_, i, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_for_statement_always_true (ValaForStatement* self,
                                ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}

static gboolean
vala_for_statement_always_false (ValaForStatement* self,
                                 ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}

static gboolean
vala_for_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaForStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* block = NULL;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaBlock* _tmp6_;
	gboolean _tmp21_ = FALSE;
	ValaExpression* _tmp22_;
	ValaExpression* _tmp23_;
	ValaLocalVariable* first_local = NULL;
	ValaSemanticAnalyzer* _tmp65_;
	ValaSemanticAnalyzer* _tmp66_;
	ValaDataType* _tmp67_;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	ValaSourceReference* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaBooleanLiteral* _tmp74_;
	ValaBooleanLiteral* _tmp75_;
	ValaSourceReference* _tmp76_;
	ValaSourceReference* _tmp77_;
	ValaLocalVariable* _tmp78_;
	ValaLocalVariable* _tmp79_;
	ValaBlock* _tmp80_;
	ValaLocalVariable* _tmp81_;
	ValaSourceReference* _tmp82_;
	ValaSourceReference* _tmp83_;
	ValaDeclarationStatement* _tmp84_;
	ValaDeclarationStatement* _tmp85_;
	ValaBlock* iterator_block = NULL;
	ValaSourceReference* _tmp86_;
	ValaSourceReference* _tmp87_;
	ValaBlock* _tmp88_;
	ValaIfStatement* first_if = NULL;
	ValaLocalVariable* _tmp103_;
	const gchar* _tmp104_;
	const gchar* _tmp105_;
	ValaSourceReference* _tmp106_;
	ValaSourceReference* _tmp107_;
	ValaMemberAccess* _tmp108_;
	ValaMemberAccess* _tmp109_;
	ValaSourceReference* _tmp110_;
	ValaSourceReference* _tmp111_;
	ValaUnaryExpression* _tmp112_;
	ValaUnaryExpression* _tmp113_;
	ValaBlock* _tmp114_;
	ValaSourceReference* _tmp115_;
	ValaSourceReference* _tmp116_;
	ValaIfStatement* _tmp117_;
	ValaIfStatement* _tmp118_;
	ValaBlock* _tmp119_;
	ValaBlock* _tmp120_;
	ValaIfStatement* _tmp121_;
	ValaBlock* _tmp122_;
	ValaBlock* _tmp123_;
	ValaLocalVariable* _tmp124_;
	const gchar* _tmp125_;
	const gchar* _tmp126_;
	ValaSourceReference* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaMemberAccess* _tmp129_;
	ValaMemberAccess* _tmp130_;
	ValaSourceReference* _tmp131_;
	ValaSourceReference* _tmp132_;
	ValaBooleanLiteral* _tmp133_;
	ValaBooleanLiteral* _tmp134_;
	ValaSourceReference* _tmp135_;
	ValaSourceReference* _tmp136_;
	ValaAssignment* _tmp137_;
	ValaAssignment* _tmp138_;
	ValaSourceReference* _tmp139_;
	ValaSourceReference* _tmp140_;
	ValaExpressionStatement* _tmp141_;
	ValaExpressionStatement* _tmp142_;
	ValaBlock* _tmp143_;
	ValaBlock* _tmp144_;
	ValaBlock* _tmp145_;
	ValaSourceReference* _tmp146_;
	ValaSourceReference* _tmp147_;
	ValaLoop* _tmp148_;
	ValaLoop* _tmp149_;
	ValaBlock* parent_block = NULL;
	ValaCodeNode* _tmp150_;
	ValaCodeNode* _tmp151_;
	ValaBlock* _tmp152_;
	ValaBlock* _tmp153_;
	ValaBlock* _tmp154_;
	ValaBlock* _tmp155_;
	gboolean _tmp156_;
	gboolean _tmp157_;
	self = (ValaForStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_block_new (_tmp5_);
	block = _tmp6_;
	{
		ValaList* _init_expr_list = NULL;
		ValaList* _tmp7_;
		ValaList* _tmp8_;
		gint _init_expr_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _init_expr_index = 0;
		_tmp7_ = self->priv->initializer;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_init_expr_list = _tmp8_;
		_tmp9_ = _init_expr_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_init_expr_size = _tmp11_;
		_init_expr_index = -1;
		while (TRUE) {
			ValaExpression* init_expr = NULL;
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaBlock* _tmp14_;
			ValaExpression* _tmp15_;
			ValaExpression* _tmp16_;
			ValaSourceReference* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaExpressionStatement* _tmp19_;
			ValaExpressionStatement* _tmp20_;
			_init_expr_index = _init_expr_index + 1;
			if (!(_init_expr_index < _init_expr_size)) {
				break;
			}
			_tmp12_ = _init_expr_list;
			_tmp13_ = vala_list_get (_tmp12_, _init_expr_index);
			init_expr = (ValaExpression*) _tmp13_;
			_tmp14_ = block;
			_tmp15_ = init_expr;
			_tmp16_ = init_expr;
			_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_expression_statement_new (_tmp15_, _tmp18_);
			_tmp20_ = _tmp19_;
			vala_block_add_statement (_tmp14_, (ValaStatement*) _tmp20_);
			_vala_code_node_unref0 (_tmp20_);
			_vala_code_node_unref0 (init_expr);
		}
		_vala_iterable_unref0 (_init_expr_list);
	}
	_tmp22_ = vala_for_statement_get_condition (self);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == NULL) {
		_tmp21_ = TRUE;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_for_statement_get_condition (self);
		_tmp25_ = _tmp24_;
		_tmp21_ = vala_for_statement_always_true (self, _tmp25_);
	}
	if (_tmp21_) {
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_for_statement_get_condition (self);
		_tmp27_ = _tmp26_;
		if (vala_for_statement_always_false (self, _tmp27_)) {
			ValaBlock* _tmp28_;
			ValaBlock* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaSourceReference* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaBreakStatement* _tmp34_;
			ValaBreakStatement* _tmp35_;
			_tmp28_ = vala_for_statement_get_body (self);
			_tmp29_ = _tmp28_;
			_tmp30_ = vala_for_statement_get_condition (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_break_statement_new (_tmp33_);
			_tmp35_ = _tmp34_;
			vala_block_insert_statement (_tmp29_, 0, (ValaStatement*) _tmp35_);
			_vala_code_node_unref0 (_tmp35_);
		} else {
			ValaUnaryExpression* if_condition = NULL;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaSourceReference* _tmp40_;
			ValaSourceReference* _tmp41_;
			ValaUnaryExpression* _tmp42_;
			ValaBlock* true_block = NULL;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaSourceReference* _tmp45_;
			ValaSourceReference* _tmp46_;
			ValaBlock* _tmp47_;
			ValaBlock* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaSourceReference* _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaBreakStatement* _tmp53_;
			ValaBreakStatement* _tmp54_;
			ValaIfStatement* if_stmt = NULL;
			ValaUnaryExpression* _tmp55_;
			ValaBlock* _tmp56_;
			ValaExpression* _tmp57_;
			ValaExpression* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaIfStatement* _tmp61_;
			ValaBlock* _tmp62_;
			ValaBlock* _tmp63_;
			ValaIfStatement* _tmp64_;
			_tmp36_ = vala_for_statement_get_condition (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_for_statement_get_condition (self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, _tmp37_, _tmp41_);
			if_condition = _tmp42_;
			_tmp43_ = vala_for_statement_get_condition (self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_block_new (_tmp46_);
			true_block = _tmp47_;
			_tmp48_ = true_block;
			_tmp49_ = vala_for_statement_get_condition (self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_break_statement_new (_tmp52_);
			_tmp54_ = _tmp53_;
			vala_block_add_statement (_tmp48_, (ValaStatement*) _tmp54_);
			_vala_code_node_unref0 (_tmp54_);
			_tmp55_ = if_condition;
			_tmp56_ = true_block;
			_tmp57_ = vala_for_statement_get_condition (self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_if_statement_new ((ValaExpression*) _tmp55_, _tmp56_, NULL, _tmp60_);
			if_stmt = _tmp61_;
			_tmp62_ = vala_for_statement_get_body (self);
			_tmp63_ = _tmp62_;
			_tmp64_ = if_stmt;
			vala_block_insert_statement (_tmp63_, 0, (ValaStatement*) _tmp64_);
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (if_condition);
		}
	}
	_tmp65_ = vala_code_context_get_analyzer (context);
	_tmp66_ = _tmp65_;
	_tmp67_ = _tmp66_->bool_type;
	_tmp68_ = vala_data_type_copy (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = vala_code_node_get_temp_name ();
	_tmp71_ = _tmp70_;
	_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_boolean_literal_new (TRUE, _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_local_variable_new (_tmp69_, _tmp71_, (ValaExpression*) _tmp75_, _tmp77_);
	_tmp79_ = _tmp78_;
	_vala_code_node_unref0 (_tmp75_);
	_g_free0 (_tmp71_);
	_vala_code_node_unref0 (_tmp69_);
	first_local = _tmp79_;
	_tmp80_ = block;
	_tmp81_ = first_local;
	_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp83_ = _tmp82_;
	_tmp84_ = vala_declaration_statement_new ((ValaSymbol*) _tmp81_, _tmp83_);
	_tmp85_ = _tmp84_;
	vala_block_add_statement (_tmp80_, (ValaStatement*) _tmp85_);
	_vala_code_node_unref0 (_tmp85_);
	_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp87_ = _tmp86_;
	_tmp88_ = vala_block_new (_tmp87_);
	iterator_block = _tmp88_;
	{
		ValaList* _it_expr_list = NULL;
		ValaList* _tmp89_;
		ValaList* _tmp90_;
		gint _it_expr_size = 0;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _it_expr_index = 0;
		_tmp89_ = self->priv->iterator;
		_tmp90_ = _vala_iterable_ref0 (_tmp89_);
		_it_expr_list = _tmp90_;
		_tmp91_ = _it_expr_list;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_it_expr_size = _tmp93_;
		_it_expr_index = -1;
		while (TRUE) {
			ValaExpression* it_expr = NULL;
			ValaList* _tmp94_;
			gpointer _tmp95_;
			ValaBlock* _tmp96_;
			ValaExpression* _tmp97_;
			ValaExpression* _tmp98_;
			ValaSourceReference* _tmp99_;
			ValaSourceReference* _tmp100_;
			ValaExpressionStatement* _tmp101_;
			ValaExpressionStatement* _tmp102_;
			_it_expr_index = _it_expr_index + 1;
			if (!(_it_expr_index < _it_expr_size)) {
				break;
			}
			_tmp94_ = _it_expr_list;
			_tmp95_ = vala_list_get (_tmp94_, _it_expr_index);
			it_expr = (ValaExpression*) _tmp95_;
			_tmp96_ = iterator_block;
			_tmp97_ = it_expr;
			_tmp98_ = it_expr;
			_tmp99_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_expression_statement_new (_tmp97_, _tmp100_);
			_tmp102_ = _tmp101_;
			vala_block_add_statement (_tmp96_, (ValaStatement*) _tmp102_);
			_vala_code_node_unref0 (_tmp102_);
			_vala_code_node_unref0 (it_expr);
		}
		_vala_iterable_unref0 (_it_expr_list);
	}
	_tmp103_ = first_local;
	_tmp104_ = vala_symbol_get_name ((ValaSymbol*) _tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_member_access_new_simple (_tmp105_, _tmp107_);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaExpression*) _tmp109_, _tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = iterator_block;
	_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_if_statement_new ((ValaExpression*) _tmp113_, _tmp114_, NULL, _tmp116_);
	_tmp118_ = _tmp117_;
	_vala_code_node_unref0 (_tmp113_);
	_vala_code_node_unref0 (_tmp109_);
	first_if = _tmp118_;
	_tmp119_ = vala_for_statement_get_body (self);
	_tmp120_ = _tmp119_;
	_tmp121_ = first_if;
	vala_block_insert_statement (_tmp120_, 0, (ValaStatement*) _tmp121_);
	_tmp122_ = vala_for_statement_get_body (self);
	_tmp123_ = _tmp122_;
	_tmp124_ = first_local;
	_tmp125_ = vala_symbol_get_name ((ValaSymbol*) _tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_member_access_new_simple (_tmp126_, _tmp128_);
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_boolean_literal_new (FALSE, _tmp132_);
	_tmp134_ = _tmp133_;
	_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp136_ = _tmp135_;
	_tmp137_ = vala_assignment_new ((ValaExpression*) _tmp130_, (ValaExpression*) _tmp134_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp136_);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_expression_statement_new ((ValaExpression*) _tmp138_, _tmp140_);
	_tmp142_ = _tmp141_;
	vala_block_insert_statement (_tmp123_, 1, (ValaStatement*) _tmp142_);
	_vala_code_node_unref0 (_tmp142_);
	_vala_code_node_unref0 (_tmp138_);
	_vala_code_node_unref0 (_tmp134_);
	_vala_code_node_unref0 (_tmp130_);
	_tmp143_ = block;
	_tmp144_ = vala_for_statement_get_body (self);
	_tmp145_ = _tmp144_;
	_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp147_ = _tmp146_;
	_tmp148_ = vala_loop_new (_tmp145_, _tmp147_);
	_tmp149_ = _tmp148_;
	vala_block_add_statement (_tmp143_, (ValaStatement*) _tmp149_);
	_vala_code_node_unref0 (_tmp149_);
	_tmp150_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp151_ = _tmp150_;
	_tmp152_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_BLOCK, ValaBlock));
	parent_block = _tmp152_;
	_tmp153_ = parent_block;
	_tmp154_ = block;
	vala_block_replace_statement (_tmp153_, (ValaStatement*) self, (ValaStatement*) _tmp154_);
	_tmp155_ = block;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp155_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
	_tmp156_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp157_ = _tmp156_;
	result = !_tmp157_;
	_vala_code_node_unref0 (parent_block);
	_vala_code_node_unref0 (first_if);
	_vala_code_node_unref0 (iterator_block);
	_vala_code_node_unref0 (first_local);
	_vala_code_node_unref0 (block);
	return result;
}

ValaExpression*
vala_for_statement_get_condition (ValaForStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}

void
vala_for_statement_set_condition (ValaForStatement* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_condition;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

ValaBlock*
vala_for_statement_get_body (ValaForStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
vala_for_statement_set_body (ValaForStatement* self,
                             ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static void
vala_for_statement_class_init (ValaForStatementClass * klass,
                               gpointer klass_data)
{
	vala_for_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_for_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaForStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_for_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_for_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_for_statement_real_check;
}

static void
vala_for_statement_vala_statement_interface_init (ValaStatementIface * iface,
                                                  gpointer iface_data)
{
	vala_for_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}

static void
vala_for_statement_instance_init (ValaForStatement * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_for_statement_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializer = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->iterator = (ValaList*) _tmp3_;
}

static void
vala_for_statement_finalize (ValaCodeNode * obj)
{
	ValaForStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FOR_STATEMENT, ValaForStatement);
	_vala_iterable_unref0 (self->priv->initializer);
	_vala_iterable_unref0 (self->priv->iterator);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_body);
	VALA_CODE_NODE_CLASS (vala_for_statement_parent_class)->finalize (obj);
}

/**
 * Represents a for iteration statement in the source code.
 */
GType
vala_for_statement_get_type (void)
{
	static volatile gsize vala_for_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_for_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaForStatement), 0, (GInstanceInitFunc) vala_for_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_for_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_for_statement_type_id;
		vala_for_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaForStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_for_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		ValaForStatement_private_offset = g_type_add_instance_private (vala_for_statement_type_id, sizeof (ValaForStatementPrivate));
		g_once_init_leave (&vala_for_statement_type_id__volatile, vala_for_statement_type_id);
	}
	return vala_for_statement_type_id__volatile;
}

