// Created by cells_xtra.sh from Xilinx models

module BSCANE2 (...);
    parameter DISABLE_JTAG = "FALSE";
    parameter integer JTAG_CHAIN = 1;
    output CAPTURE;
    output DRCK;
    output RESET;
    output RUNTEST;
    output SEL;
    output SHIFT;
    output TCK;
    output TDI;
    output TMS;
    output UPDATE;
    input TDO;
endmodule

module BUFGCE (...);
    parameter CE_TYPE = "SYNC";
    parameter [0:0] IS_CE_INVERTED = 1'b0;
    parameter [0:0] IS_I_INVERTED = 1'b0;
    output O;
    input CE;
    input I;
endmodule

module BUFGCE_1 (...);
    output O;
    input CE, I;
endmodule

module BUFGCTRL (...);
    output O;
    input CE0;
    input CE1;
    input I0;
    input I1;
    input IGNORE0;
    input IGNORE1;
    input S0;
    input S1;
    parameter integer INIT_OUT = 0;
    parameter PRESELECT_I0 = "FALSE";
    parameter PRESELECT_I1 = "FALSE";
    parameter [0:0] IS_CE0_INVERTED = 1'b0;
    parameter [0:0] IS_CE1_INVERTED = 1'b0;
    parameter [0:0] IS_I0_INVERTED = 1'b0;
    parameter [0:0] IS_I1_INVERTED = 1'b0;
    parameter [0:0] IS_IGNORE0_INVERTED = 1'b0;
    parameter [0:0] IS_IGNORE1_INVERTED = 1'b0;
    parameter [0:0] IS_S0_INVERTED = 1'b0;
    parameter [0:0] IS_S1_INVERTED = 1'b0;
endmodule

module BUFGMUX (...);
    parameter CLK_SEL_TYPE = "SYNC";
    output O;
    input I0, I1, S;
endmodule

module BUFGMUX_1 (...);
    parameter CLK_SEL_TYPE = "SYNC";
    output O;
    input I0, I1, S;
endmodule

module BUFGMUX_CTRL (...);
    output O;
    input I0;
    input I1;
    input S;
endmodule

module BUFH (...);
    output O;
    input I;
endmodule

module BUFHCE (...);
    parameter CE_TYPE = "SYNC";
    parameter integer INIT_OUT = 0;
    parameter [0:0] IS_CE_INVERTED = 1'b0;
    output O;
    input CE;
    input I;
endmodule

module BUFIO (...);
    output O;
    input I;
endmodule

module BUFMR (...);
    output O;
    input I;
endmodule

module BUFMRCE (...);
    parameter CE_TYPE = "SYNC";
    parameter integer INIT_OUT = 0;
    parameter [0:0] IS_CE_INVERTED = 1'b0;
    output O;
    input CE;
    input I;
endmodule

module BUFR (...);
    output O;
    input CE;
    input CLR;
    input I;
    parameter BUFR_DIVIDE = "BYPASS";
    parameter SIM_DEVICE = "7SERIES";
endmodule

(* keep *)
module CAPTUREE2 (...);
    parameter ONESHOT = "TRUE";
    input CAP;
    input CLK;
endmodule

module CFGLUT5 (...);
    parameter [31:0] INIT = 32'h00000000;
    parameter [0:0] IS_CLK_INVERTED = 1'b0;
    output CDO;
    output O5;
    output O6;
    input I4, I3, I2, I1, I0;
    input CDI, CE, CLK;
endmodule

(* keep *)
module DCIRESET (...);
    output LOCKED;
    input RST;
endmodule

module DNA_PORT (...);
    parameter [56:0] SIM_DNA_VALUE = 57'h0;
    output DOUT;
    input CLK, DIN, READ, SHIFT;
endmodule

module DSP48E1 (...);
    parameter integer ACASCREG = 1;
    parameter integer ADREG = 1;
    parameter integer ALUMODEREG = 1;
    parameter integer AREG = 1;
    parameter AUTORESET_PATDET = "NO_RESET";
    parameter A_INPUT = "DIRECT";
    parameter integer BCASCREG = 1;
    parameter integer BREG = 1;
    parameter B_INPUT = "DIRECT";
    parameter integer CARRYINREG = 1;
    parameter integer CARRYINSELREG = 1;
    parameter integer CREG = 1;
    parameter integer DREG = 1;
    parameter integer INMODEREG = 1;
    parameter integer MREG = 1;
    parameter integer OPMODEREG = 1;
    parameter integer PREG = 1;
    parameter SEL_MASK = "MASK";
    parameter SEL_PATTERN = "PATTERN";
    parameter USE_DPORT = "FALSE";
    parameter USE_MULT = "MULTIPLY";
    parameter USE_PATTERN_DETECT = "NO_PATDET";
    parameter USE_SIMD = "ONE48";
    parameter [47:0] MASK = 48'h3FFFFFFFFFFF;
    parameter [47:0] PATTERN = 48'h000000000000;
    parameter [3:0] IS_ALUMODE_INVERTED = 4'b0;
    parameter [0:0] IS_CARRYIN_INVERTED = 1'b0;
    parameter [0:0] IS_CLK_INVERTED = 1'b0;
    parameter [4:0] IS_INMODE_INVERTED = 5'b0;
    parameter [6:0] IS_OPMODE_INVERTED = 7'b0;
    output [29:0] ACOUT;
    output [17:0] BCOUT;
    output CARRYCASCOUT;
    output [3:0] CARRYOUT;
    output MULTSIGNOUT;
    output OVERFLOW;
    output [47:0] P;
    output PATTERNBDETECT;
    output PATTERNDETECT;
    output [47:0] PCOUT;
    output UNDERFLOW;
    input [29:0] A;
    input [29:0] ACIN;
    input [3:0] ALUMODE;
    input [17:0] B;
    input [17:0] BCIN;
    input [47:0] C;
    input CARRYCASCIN;
    input CARRYIN;
    input [2:0] CARRYINSEL;
    input CEA1;
    input CEA2;
    input CEAD;
    input CEALUMODE;
    input CEB1;
    input CEB2;
    input CEC;
    input CECARRYIN;
    input CECTRL;
    input CED;
    input CEINMODE;
    input CEM;
    input CEP;
    input CLK;
    input [24:0] D;
    input [4:0] INMODE;
    input MULTSIGNIN;
    input [6:0] OPMODE;
    input [47:0] PCIN;
    input RSTA;
    input RSTALLCARRYIN;
    input RSTALUMODE;
    input RSTB;
    input RSTC;
    input RSTCTRL;
    input RSTD;
    input RSTINMODE;
    input RSTM;
    input RSTP;
endmodule

module EFUSE_USR (...);
    parameter [31:0] SIM_EFUSE_VALUE = 32'h00000000;
    output [31:0] EFUSEUSR;
endmodule

module FIFO18E1 (...);
    parameter ALMOST_EMPTY_OFFSET = 13'h0080;
    parameter ALMOST_FULL_OFFSET = 13'h0080;
    parameter integer DATA_WIDTH = 4;
    parameter integer DO_REG = 1;
    parameter EN_SYN = "FALSE";
    parameter FIFO_MODE = "FIFO18";
    parameter FIRST_WORD_FALL_THROUGH = "FALSE";
    parameter INIT = 36'h0;
    parameter SIM_DEVICE = "VIRTEX6";
    parameter SRVAL = 36'h0;
    parameter IS_RDCLK_INVERTED = 1'b0;
    parameter IS_RDEN_INVERTED = 1'b0;
    parameter IS_RSTREG_INVERTED = 1'b0;
    parameter IS_RST_INVERTED = 1'b0;
    parameter IS_WRCLK_INVERTED = 1'b0;
    parameter IS_WREN_INVERTED = 1'b0;
    output ALMOSTEMPTY;
    output ALMOSTFULL;
    output [31:0] DO;
    output [3:0] DOP;
    output EMPTY;
    output FULL;
    output [11:0] RDCOUNT;
    output RDERR;
    output [11:0] WRCOUNT;
    output WRERR;
    input [31:0] DI;
    input [3:0] DIP;
    input RDCLK;
    input RDEN;
    input REGCE;
    input RST;
    input RSTREG;
    input WRCLK;
    input WREN;
endmodule

module FIFO36E1 (...);
    parameter ALMOST_EMPTY_OFFSET = 13'h0080;
    parameter ALMOST_FULL_OFFSET = 13'h0080;
    parameter integer DATA_WIDTH = 4;
    parameter integer DO_REG = 1;
    parameter EN_ECC_READ = "FALSE";
    parameter EN_ECC_WRITE = "FALSE";
    parameter EN_SYN = "FALSE";
    parameter FIFO_MODE = "FIFO36";
    parameter FIRST_WORD_FALL_THROUGH = "FALSE";
    parameter INIT = 72'h0;
    parameter SIM_DEVICE = "VIRTEX6";
    parameter SRVAL = 72'h0;
    parameter IS_RDCLK_INVERTED = 1'b0;
    parameter IS_RDEN_INVERTED = 1'b0;
    parameter IS_RSTREG_INVERTED = 1'b0;
    parameter IS_RST_INVERTED = 1'b0;
    parameter IS_WRCLK_INVERTED = 1'b0;
    parameter IS_WREN_INVERTED = 1'b0;
    output ALMOSTEMPTY;
    output ALMOSTFULL;
    output DBITERR;
    output [63:0] DO;
    output [7:0] DOP;
    output [7:0] ECCPARITY;
    output EMPTY;
    output FULL;
    output [12:0] RDCOUNT;
    output RDERR;
    output SBITERR;
    output [12:0] WRCOUNT;
    output WRERR;
    input [63:0] DI;
    input [7:0] DIP;
    input INJECTDBITERR;
    input INJECTSBITERR;
    input RDCLK;
    input RDEN;
    input REGCE;
    input RST;
    input RSTREG;
    input WRCLK;
    input WREN;
endmodule

module FRAME_ECCE2 (...);
    parameter FARSRC = "EFAR";
    parameter FRAME_RBT_IN_FILENAME = "NONE";
    output CRCERROR;
    output ECCERROR;
    output ECCERRORSINGLE;
    output SYNDROMEVALID;
    output [12:0] SYNDROME;
    output [25:0] FAR;
    output [4:0] SYNBIT;
    output [6:0] SYNWORD;
endmodule

module GTHE2_CHANNEL (...);
    parameter [0:0] ACJTAG_DEBUG_MODE = 1'b0;
    parameter [0:0] ACJTAG_MODE = 1'b0;
    parameter [0:0] ACJTAG_RESET = 1'b0;
    parameter [19:0] ADAPT_CFG0 = 20'h00C10;
    parameter ALIGN_COMMA_DOUBLE = "FALSE";
    parameter [9:0] ALIGN_COMMA_ENABLE = 10'b0001111111;
    parameter integer ALIGN_COMMA_WORD = 1;
    parameter ALIGN_MCOMMA_DET = "TRUE";
    parameter [9:0] ALIGN_MCOMMA_VALUE = 10'b1010000011;
    parameter ALIGN_PCOMMA_DET = "TRUE";
    parameter [9:0] ALIGN_PCOMMA_VALUE = 10'b0101111100;
    parameter [0:0] A_RXOSCALRESET = 1'b0;
    parameter CBCC_DATA_SOURCE_SEL = "DECODED";
    parameter [41:0] CFOK_CFG = 42'h24800040E80;
    parameter [5:0] CFOK_CFG2 = 6'b100000;
    parameter [5:0] CFOK_CFG3 = 6'b100000;
    parameter CHAN_BOND_KEEP_ALIGN = "FALSE";
    parameter integer CHAN_BOND_MAX_SKEW = 7;
    parameter [9:0] CHAN_BOND_SEQ_1_1 = 10'b0101111100;
    parameter [9:0] CHAN_BOND_SEQ_1_2 = 10'b0000000000;
    parameter [9:0] CHAN_BOND_SEQ_1_3 = 10'b0000000000;
    parameter [9:0] CHAN_BOND_SEQ_1_4 = 10'b0000000000;
    parameter [3:0] CHAN_BOND_SEQ_1_ENABLE = 4'b1111;
    parameter [9:0] CHAN_BOND_SEQ_2_1 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_2 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_3 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_4 = 10'b0100000000;
    parameter [3:0] CHAN_BOND_SEQ_2_ENABLE = 4'b1111;
    parameter CHAN_BOND_SEQ_2_USE = "FALSE";
    parameter integer CHAN_BOND_SEQ_LEN = 1;
    parameter CLK_CORRECT_USE = "TRUE";
    parameter CLK_COR_KEEP_IDLE = "FALSE";
    parameter integer CLK_COR_MAX_LAT = 20;
    parameter integer CLK_COR_MIN_LAT = 18;
    parameter CLK_COR_PRECEDENCE = "TRUE";
    parameter integer CLK_COR_REPEAT_WAIT = 0;
    parameter [9:0] CLK_COR_SEQ_1_1 = 10'b0100011100;
    parameter [9:0] CLK_COR_SEQ_1_2 = 10'b0000000000;
    parameter [9:0] CLK_COR_SEQ_1_3 = 10'b0000000000;
    parameter [9:0] CLK_COR_SEQ_1_4 = 10'b0000000000;
    parameter [3:0] CLK_COR_SEQ_1_ENABLE = 4'b1111;
    parameter [9:0] CLK_COR_SEQ_2_1 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_2 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_3 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_4 = 10'b0100000000;
    parameter [3:0] CLK_COR_SEQ_2_ENABLE = 4'b1111;
    parameter CLK_COR_SEQ_2_USE = "FALSE";
    parameter integer CLK_COR_SEQ_LEN = 1;
    parameter [28:0] CPLL_CFG = 29'h00BC07DC;
    parameter integer CPLL_FBDIV = 4;
    parameter integer CPLL_FBDIV_45 = 5;
    parameter [23:0] CPLL_INIT_CFG = 24'h00001E;
    parameter [15:0] CPLL_LOCK_CFG = 16'h01E8;
    parameter integer CPLL_REFCLK_DIV = 1;
    parameter DEC_MCOMMA_DETECT = "TRUE";
    parameter DEC_PCOMMA_DETECT = "TRUE";
    parameter DEC_VALID_COMMA_ONLY = "TRUE";
    parameter [23:0] DMONITOR_CFG = 24'h000A00;
    parameter [0:0] ES_CLK_PHASE_SEL = 1'b0;
    parameter [5:0] ES_CONTROL = 6'b000000;
    parameter ES_ERRDET_EN = "FALSE";
    parameter ES_EYE_SCAN_EN = "TRUE";
    parameter [11:0] ES_HORZ_OFFSET = 12'h000;
    parameter [9:0] ES_PMA_CFG = 10'b0000000000;
    parameter [4:0] ES_PRESCALE = 5'b00000;
    parameter [79:0] ES_QUALIFIER = 80'h00000000000000000000;
    parameter [79:0] ES_QUAL_MASK = 80'h00000000000000000000;
    parameter [79:0] ES_SDATA_MASK = 80'h00000000000000000000;
    parameter [8:0] ES_VERT_OFFSET = 9'b000000000;
    parameter [3:0] FTS_DESKEW_SEQ_ENABLE = 4'b1111;
    parameter [3:0] FTS_LANE_DESKEW_CFG = 4'b1111;
    parameter FTS_LANE_DESKEW_EN = "FALSE";
    parameter [2:0] GEARBOX_MODE = 3'b000;
    parameter [0:0] IS_CLKRSVD0_INVERTED = 1'b0;
    parameter [0:0] IS_CLKRSVD1_INVERTED = 1'b0;
    parameter [0:0] IS_CPLLLOCKDETCLK_INVERTED = 1'b0;
    parameter [0:0] IS_DMONITORCLK_INVERTED = 1'b0;
    parameter [0:0] IS_DRPCLK_INVERTED = 1'b0;
    parameter [0:0] IS_GTGREFCLK_INVERTED = 1'b0;
    parameter [0:0] IS_RXUSRCLK2_INVERTED = 1'b0;
    parameter [0:0] IS_RXUSRCLK_INVERTED = 1'b0;
    parameter [0:0] IS_SIGVALIDCLK_INVERTED = 1'b0;
    parameter [0:0] IS_TXPHDLYTSTCLK_INVERTED = 1'b0;
    parameter [0:0] IS_TXUSRCLK2_INVERTED = 1'b0;
    parameter [0:0] IS_TXUSRCLK_INVERTED = 1'b0;
    parameter [0:0] LOOPBACK_CFG = 1'b0;
    parameter [1:0] OUTREFCLK_SEL_INV = 2'b11;
    parameter PCS_PCIE_EN = "FALSE";
    parameter [47:0] PCS_RSVD_ATTR = 48'h000000000000;
    parameter [11:0] PD_TRANS_TIME_FROM_P2 = 12'h03C;
    parameter [7:0] PD_TRANS_TIME_NONE_P2 = 8'h19;
    parameter [7:0] PD_TRANS_TIME_TO_P2 = 8'h64;
    parameter [31:0] PMA_RSV = 32'b00000000000000000000000010000000;
    parameter [31:0] PMA_RSV2 = 32'b00011100000000000000000000001010;
    parameter [1:0] PMA_RSV3 = 2'b00;
    parameter [14:0] PMA_RSV4 = 15'b000000000001000;
    parameter [3:0] PMA_RSV5 = 4'b0000;
    parameter [0:0] RESET_POWERSAVE_DISABLE = 1'b0;
    parameter [4:0] RXBUFRESET_TIME = 5'b00001;
    parameter RXBUF_ADDR_MODE = "FULL";
    parameter [3:0] RXBUF_EIDLE_HI_CNT = 4'b1000;
    parameter [3:0] RXBUF_EIDLE_LO_CNT = 4'b0000;
    parameter RXBUF_EN = "TRUE";
    parameter RXBUF_RESET_ON_CB_CHANGE = "TRUE";
    parameter RXBUF_RESET_ON_COMMAALIGN = "FALSE";
    parameter RXBUF_RESET_ON_EIDLE = "FALSE";
    parameter RXBUF_RESET_ON_RATE_CHANGE = "TRUE";
    parameter integer RXBUF_THRESH_OVFLW = 61;
    parameter RXBUF_THRESH_OVRD = "FALSE";
    parameter integer RXBUF_THRESH_UNDFLW = 4;
    parameter [4:0] RXCDRFREQRESET_TIME = 5'b00001;
    parameter [4:0] RXCDRPHRESET_TIME = 5'b00001;
    parameter [82:0] RXCDR_CFG = 83'h0002007FE2000C208001A;
    parameter [0:0] RXCDR_FR_RESET_ON_EIDLE = 1'b0;
    parameter [0:0] RXCDR_HOLD_DURING_EIDLE = 1'b0;
    parameter [5:0] RXCDR_LOCK_CFG = 6'b001001;
    parameter [0:0] RXCDR_PH_RESET_ON_EIDLE = 1'b0;
    parameter [6:0] RXDFELPMRESET_TIME = 7'b0001111;
    parameter [15:0] RXDLY_CFG = 16'h001F;
    parameter [8:0] RXDLY_LCFG = 9'h030;
    parameter [15:0] RXDLY_TAP_CFG = 16'h0000;
    parameter RXGEARBOX_EN = "FALSE";
    parameter [4:0] RXISCANRESET_TIME = 5'b00001;
    parameter [13:0] RXLPM_HF_CFG = 14'b00001000000000;
    parameter [17:0] RXLPM_LF_CFG = 18'b001001000000000000;
    parameter [6:0] RXOOB_CFG = 7'b0000110;
    parameter RXOOB_CLK_CFG = "PMA";
    parameter [4:0] RXOSCALRESET_TIME = 5'b00011;
    parameter [4:0] RXOSCALRESET_TIMEOUT = 5'b00000;
    parameter integer RXOUT_DIV = 2;
    parameter [4:0] RXPCSRESET_TIME = 5'b00001;
    parameter [23:0] RXPHDLY_CFG = 24'h084020;
    parameter [23:0] RXPH_CFG = 24'hC00002;
    parameter [4:0] RXPH_MONITOR_SEL = 5'b00000;
    parameter [1:0] RXPI_CFG0 = 2'b00;
    parameter [1:0] RXPI_CFG1 = 2'b00;
    parameter [1:0] RXPI_CFG2 = 2'b00;
    parameter [1:0] RXPI_CFG3 = 2'b00;
    parameter [0:0] RXPI_CFG4 = 1'b0;
    parameter [0:0] RXPI_CFG5 = 1'b0;
    parameter [2:0] RXPI_CFG6 = 3'b100;
    parameter [4:0] RXPMARESET_TIME = 5'b00011;
    parameter [0:0] RXPRBS_ERR_LOOPBACK = 1'b0;
    parameter integer RXSLIDE_AUTO_WAIT = 7;
    parameter RXSLIDE_MODE = "OFF";
    parameter [0:0] RXSYNC_MULTILANE = 1'b0;
    parameter [0:0] RXSYNC_OVRD = 1'b0;
    parameter [0:0] RXSYNC_SKIP_DA = 1'b0;
    parameter [23:0] RX_BIAS_CFG = 24'b000011000000000000010000;
    parameter [5:0] RX_BUFFER_CFG = 6'b000000;
    parameter integer RX_CLK25_DIV = 7;
    parameter [0:0] RX_CLKMUX_PD = 1'b1;
    parameter [1:0] RX_CM_SEL = 2'b11;
    parameter [3:0] RX_CM_TRIM = 4'b0100;
    parameter integer RX_DATA_WIDTH = 20;
    parameter [5:0] RX_DDI_SEL = 6'b000000;
    parameter [13:0] RX_DEBUG_CFG = 14'b00000000000000;
    parameter RX_DEFER_RESET_BUF_EN = "TRUE";
    parameter [3:0] RX_DFELPM_CFG0 = 4'b0110;
    parameter [0:0] RX_DFELPM_CFG1 = 1'b0;
    parameter [0:0] RX_DFELPM_KLKH_AGC_STUP_EN = 1'b1;
    parameter [1:0] RX_DFE_AGC_CFG0 = 2'b00;
    parameter [2:0] RX_DFE_AGC_CFG1 = 3'b010;
    parameter [3:0] RX_DFE_AGC_CFG2 = 4'b0000;
    parameter [0:0] RX_DFE_AGC_OVRDEN = 1'b1;
    parameter [22:0] RX_DFE_GAIN_CFG = 23'h0020C0;
    parameter [11:0] RX_DFE_H2_CFG = 12'b000000000000;
    parameter [11:0] RX_DFE_H3_CFG = 12'b000001000000;
    parameter [10:0] RX_DFE_H4_CFG = 11'b00011100000;
    parameter [10:0] RX_DFE_H5_CFG = 11'b00011100000;
    parameter [10:0] RX_DFE_H6_CFG = 11'b00000100000;
    parameter [10:0] RX_DFE_H7_CFG = 11'b00000100000;
    parameter [32:0] RX_DFE_KL_CFG = 33'b000000000000000000000001100010000;
    parameter [1:0] RX_DFE_KL_LPM_KH_CFG0 = 2'b01;
    parameter [2:0] RX_DFE_KL_LPM_KH_CFG1 = 3'b010;
    parameter [3:0] RX_DFE_KL_LPM_KH_CFG2 = 4'b0010;
    parameter [0:0] RX_DFE_KL_LPM_KH_OVRDEN = 1'b1;
    parameter [1:0] RX_DFE_KL_LPM_KL_CFG0 = 2'b10;
    parameter [2:0] RX_DFE_KL_LPM_KL_CFG1 = 3'b010;
    parameter [3:0] RX_DFE_KL_LPM_KL_CFG2 = 4'b0010;
    parameter [0:0] RX_DFE_KL_LPM_KL_OVRDEN = 1'b1;
    parameter [15:0] RX_DFE_LPM_CFG = 16'h0080;
    parameter [0:0] RX_DFE_LPM_HOLD_DURING_EIDLE = 1'b0;
    parameter [53:0] RX_DFE_ST_CFG = 54'h00E100000C003F;
    parameter [16:0] RX_DFE_UT_CFG = 17'b00011100000000000;
    parameter [16:0] RX_DFE_VP_CFG = 17'b00011101010100011;
    parameter RX_DISPERR_SEQ_MATCH = "TRUE";
    parameter integer RX_INT_DATAWIDTH = 0;
    parameter [12:0] RX_OS_CFG = 13'b0000010000000;
    parameter integer RX_SIG_VALID_DLY = 10;
    parameter RX_XCLK_SEL = "RXREC";
    parameter integer SAS_MAX_COM = 64;
    parameter integer SAS_MIN_COM = 36;
    parameter [3:0] SATA_BURST_SEQ_LEN = 4'b1111;
    parameter [2:0] SATA_BURST_VAL = 3'b100;
    parameter SATA_CPLL_CFG = "VCO_3000MHZ";
    parameter [2:0] SATA_EIDLE_VAL = 3'b100;
    parameter integer SATA_MAX_BURST = 8;
    parameter integer SATA_MAX_INIT = 21;
    parameter integer SATA_MAX_WAKE = 7;
    parameter integer SATA_MIN_BURST = 4;
    parameter integer SATA_MIN_INIT = 12;
    parameter integer SATA_MIN_WAKE = 4;
    parameter SHOW_REALIGN_COMMA = "TRUE";
    parameter [2:0] SIM_CPLLREFCLK_SEL = 3'b001;
    parameter SIM_RECEIVER_DETECT_PASS = "TRUE";
    parameter SIM_RESET_SPEEDUP = "TRUE";
    parameter SIM_TX_EIDLE_DRIVE_LEVEL = "X";
    parameter SIM_VERSION = "1.1";
    parameter [14:0] TERM_RCAL_CFG = 15'b100001000010000;
    parameter [2:0] TERM_RCAL_OVRD = 3'b000;
    parameter [7:0] TRANS_TIME_RATE = 8'h0E;
    parameter [31:0] TST_RSV = 32'h00000000;
    parameter TXBUF_EN = "TRUE";
    parameter TXBUF_RESET_ON_RATE_CHANGE = "FALSE";
    parameter [15:0] TXDLY_CFG = 16'h001F;
    parameter [8:0] TXDLY_LCFG = 9'h030;
    parameter [15:0] TXDLY_TAP_CFG = 16'h0000;
    parameter TXGEARBOX_EN = "FALSE";
    parameter [0:0] TXOOB_CFG = 1'b0;
    parameter integer TXOUT_DIV = 2;
    parameter [4:0] TXPCSRESET_TIME = 5'b00001;
    parameter [23:0] TXPHDLY_CFG = 24'h084020;
    parameter [15:0] TXPH_CFG = 16'h0780;
    parameter [4:0] TXPH_MONITOR_SEL = 5'b00000;
    parameter [1:0] TXPI_CFG0 = 2'b00;
    parameter [1:0] TXPI_CFG1 = 2'b00;
    parameter [1:0] TXPI_CFG2 = 2'b00;
    parameter [0:0] TXPI_CFG3 = 1'b0;
    parameter [0:0] TXPI_CFG4 = 1'b0;
    parameter [2:0] TXPI_CFG5 = 3'b100;
    parameter [0:0] TXPI_GREY_SEL = 1'b0;
    parameter [0:0] TXPI_INVSTROBE_SEL = 1'b0;
    parameter TXPI_PPMCLK_SEL = "TXUSRCLK2";
    parameter [7:0] TXPI_PPM_CFG = 8'b00000000;
    parameter [2:0] TXPI_SYNFREQ_PPM = 3'b000;
    parameter [4:0] TXPMARESET_TIME = 5'b00001;
    parameter [0:0] TXSYNC_MULTILANE = 1'b0;
    parameter [0:0] TXSYNC_OVRD = 1'b0;
    parameter [0:0] TXSYNC_SKIP_DA = 1'b0;
    parameter integer TX_CLK25_DIV = 7;
    parameter [0:0] TX_CLKMUX_PD = 1'b1;
    parameter integer TX_DATA_WIDTH = 20;
    parameter [5:0] TX_DEEMPH0 = 6'b000000;
    parameter [5:0] TX_DEEMPH1 = 6'b000000;
    parameter TX_DRIVE_MODE = "DIRECT";
    parameter [2:0] TX_EIDLE_ASSERT_DELAY = 3'b110;
    parameter [2:0] TX_EIDLE_DEASSERT_DELAY = 3'b100;
    parameter integer TX_INT_DATAWIDTH = 0;
    parameter TX_LOOPBACK_DRIVE_HIZ = "FALSE";
    parameter [0:0] TX_MAINCURSOR_SEL = 1'b0;
    parameter [6:0] TX_MARGIN_FULL_0 = 7'b1001110;
    parameter [6:0] TX_MARGIN_FULL_1 = 7'b1001001;
    parameter [6:0] TX_MARGIN_FULL_2 = 7'b1000101;
    parameter [6:0] TX_MARGIN_FULL_3 = 7'b1000010;
    parameter [6:0] TX_MARGIN_FULL_4 = 7'b1000000;
    parameter [6:0] TX_MARGIN_LOW_0 = 7'b1000110;
    parameter [6:0] TX_MARGIN_LOW_1 = 7'b1000100;
    parameter [6:0] TX_MARGIN_LOW_2 = 7'b1000010;
    parameter [6:0] TX_MARGIN_LOW_3 = 7'b1000000;
    parameter [6:0] TX_MARGIN_LOW_4 = 7'b1000000;
    parameter [0:0] TX_QPI_STATUS_EN = 1'b0;
    parameter [13:0] TX_RXDETECT_CFG = 14'h1832;
    parameter [16:0] TX_RXDETECT_PRECHARGE_TIME = 17'h00000;
    parameter [2:0] TX_RXDETECT_REF = 3'b100;
    parameter TX_XCLK_SEL = "TXUSR";
    parameter [0:0] UCODEER_CLR = 1'b0;
    parameter [0:0] USE_PCS_CLK_PHASE_SEL = 1'b0;
    output CPLLFBCLKLOST;
    output CPLLLOCK;
    output CPLLREFCLKLOST;
    output DRPRDY;
    output EYESCANDATAERROR;
    output GTHTXN;
    output GTHTXP;
    output GTREFCLKMONITOR;
    output PHYSTATUS;
    output RSOSINTDONE;
    output RXBYTEISALIGNED;
    output RXBYTEREALIGN;
    output RXCDRLOCK;
    output RXCHANBONDSEQ;
    output RXCHANISALIGNED;
    output RXCHANREALIGN;
    output RXCOMINITDET;
    output RXCOMMADET;
    output RXCOMSASDET;
    output RXCOMWAKEDET;
    output RXDFESLIDETAPSTARTED;
    output RXDFESLIDETAPSTROBEDONE;
    output RXDFESLIDETAPSTROBESTARTED;
    output RXDFESTADAPTDONE;
    output RXDLYSRESETDONE;
    output RXELECIDLE;
    output RXOSINTSTARTED;
    output RXOSINTSTROBEDONE;
    output RXOSINTSTROBESTARTED;
    output RXOUTCLK;
    output RXOUTCLKFABRIC;
    output RXOUTCLKPCS;
    output RXPHALIGNDONE;
    output RXPMARESETDONE;
    output RXPRBSERR;
    output RXQPISENN;
    output RXQPISENP;
    output RXRATEDONE;
    output RXRESETDONE;
    output RXSYNCDONE;
    output RXSYNCOUT;
    output RXVALID;
    output TXCOMFINISH;
    output TXDLYSRESETDONE;
    output TXGEARBOXREADY;
    output TXOUTCLK;
    output TXOUTCLKFABRIC;
    output TXOUTCLKPCS;
    output TXPHALIGNDONE;
    output TXPHINITDONE;
    output TXPMARESETDONE;
    output TXQPISENN;
    output TXQPISENP;
    output TXRATEDONE;
    output TXRESETDONE;
    output TXSYNCDONE;
    output TXSYNCOUT;
    output [14:0] DMONITOROUT;
    output [15:0] DRPDO;
    output [15:0] PCSRSVDOUT;
    output [1:0] RXCLKCORCNT;
    output [1:0] RXDATAVALID;
    output [1:0] RXHEADERVALID;
    output [1:0] RXSTARTOFSEQ;
    output [1:0] TXBUFSTATUS;
    output [2:0] RXBUFSTATUS;
    output [2:0] RXSTATUS;
    output [4:0] RXCHBONDO;
    output [4:0] RXPHMONITOR;
    output [4:0] RXPHSLIPMONITOR;
    output [5:0] RXHEADER;
    output [63:0] RXDATA;
    output [6:0] RXMONITOROUT;
    output [7:0] RXCHARISCOMMA;
    output [7:0] RXCHARISK;
    output [7:0] RXDISPERR;
    output [7:0] RXNOTINTABLE;
    input CFGRESET;
    input CLKRSVD0;
    input CLKRSVD1;
    input CPLLLOCKDETCLK;
    input CPLLLOCKEN;
    input CPLLPD;
    input CPLLRESET;
    input DMONFIFORESET;
    input DMONITORCLK;
    input DRPCLK;
    input DRPEN;
    input DRPWE;
    input EYESCANMODE;
    input EYESCANRESET;
    input EYESCANTRIGGER;
    input GTGREFCLK;
    input GTHRXN;
    input GTHRXP;
    input GTNORTHREFCLK0;
    input GTNORTHREFCLK1;
    input GTREFCLK0;
    input GTREFCLK1;
    input GTRESETSEL;
    input GTRXRESET;
    input GTSOUTHREFCLK0;
    input GTSOUTHREFCLK1;
    input GTTXRESET;
    input QPLLCLK;
    input QPLLREFCLK;
    input RESETOVRD;
    input RX8B10BEN;
    input RXBUFRESET;
    input RXCDRFREQRESET;
    input RXCDRHOLD;
    input RXCDROVRDEN;
    input RXCDRRESET;
    input RXCDRRESETRSV;
    input RXCHBONDEN;
    input RXCHBONDMASTER;
    input RXCHBONDSLAVE;
    input RXCOMMADETEN;
    input RXDDIEN;
    input RXDFEAGCHOLD;
    input RXDFEAGCOVRDEN;
    input RXDFECM1EN;
    input RXDFELFHOLD;
    input RXDFELFOVRDEN;
    input RXDFELPMRESET;
    input RXDFESLIDETAPADAPTEN;
    input RXDFESLIDETAPHOLD;
    input RXDFESLIDETAPINITOVRDEN;
    input RXDFESLIDETAPONLYADAPTEN;
    input RXDFESLIDETAPOVRDEN;
    input RXDFESLIDETAPSTROBE;
    input RXDFETAP2HOLD;
    input RXDFETAP2OVRDEN;
    input RXDFETAP3HOLD;
    input RXDFETAP3OVRDEN;
    input RXDFETAP4HOLD;
    input RXDFETAP4OVRDEN;
    input RXDFETAP5HOLD;
    input RXDFETAP5OVRDEN;
    input RXDFETAP6HOLD;
    input RXDFETAP6OVRDEN;
    input RXDFETAP7HOLD;
    input RXDFETAP7OVRDEN;
    input RXDFEUTHOLD;
    input RXDFEUTOVRDEN;
    input RXDFEVPHOLD;
    input RXDFEVPOVRDEN;
    input RXDFEVSEN;
    input RXDFEXYDEN;
    input RXDLYBYPASS;
    input RXDLYEN;
    input RXDLYOVRDEN;
    input RXDLYSRESET;
    input RXGEARBOXSLIP;
    input RXLPMEN;
    input RXLPMHFHOLD;
    input RXLPMHFOVRDEN;
    input RXLPMLFHOLD;
    input RXLPMLFKLOVRDEN;
    input RXMCOMMAALIGNEN;
    input RXOOBRESET;
    input RXOSCALRESET;
    input RXOSHOLD;
    input RXOSINTEN;
    input RXOSINTHOLD;
    input RXOSINTNTRLEN;
    input RXOSINTOVRDEN;
    input RXOSINTSTROBE;
    input RXOSINTTESTOVRDEN;
    input RXOSOVRDEN;
    input RXPCOMMAALIGNEN;
    input RXPCSRESET;
    input RXPHALIGN;
    input RXPHALIGNEN;
    input RXPHDLYPD;
    input RXPHDLYRESET;
    input RXPHOVRDEN;
    input RXPMARESET;
    input RXPOLARITY;
    input RXPRBSCNTRESET;
    input RXQPIEN;
    input RXRATEMODE;
    input RXSLIDE;
    input RXSYNCALLIN;
    input RXSYNCIN;
    input RXSYNCMODE;
    input RXUSERRDY;
    input RXUSRCLK2;
    input RXUSRCLK;
    input SETERRSTATUS;
    input SIGVALIDCLK;
    input TX8B10BEN;
    input TXCOMINIT;
    input TXCOMSAS;
    input TXCOMWAKE;
    input TXDEEMPH;
    input TXDETECTRX;
    input TXDIFFPD;
    input TXDLYBYPASS;
    input TXDLYEN;
    input TXDLYHOLD;
    input TXDLYOVRDEN;
    input TXDLYSRESET;
    input TXDLYUPDOWN;
    input TXELECIDLE;
    input TXINHIBIT;
    input TXPCSRESET;
    input TXPDELECIDLEMODE;
    input TXPHALIGN;
    input TXPHALIGNEN;
    input TXPHDLYPD;
    input TXPHDLYRESET;
    input TXPHDLYTSTCLK;
    input TXPHINIT;
    input TXPHOVRDEN;
    input TXPIPPMEN;
    input TXPIPPMOVRDEN;
    input TXPIPPMPD;
    input TXPIPPMSEL;
    input TXPISOPD;
    input TXPMARESET;
    input TXPOLARITY;
    input TXPOSTCURSORINV;
    input TXPRBSFORCEERR;
    input TXPRECURSORINV;
    input TXQPIBIASEN;
    input TXQPISTRONGPDOWN;
    input TXQPIWEAKPUP;
    input TXRATEMODE;
    input TXSTARTSEQ;
    input TXSWING;
    input TXSYNCALLIN;
    input TXSYNCIN;
    input TXSYNCMODE;
    input TXUSERRDY;
    input TXUSRCLK2;
    input TXUSRCLK;
    input [13:0] RXADAPTSELTEST;
    input [15:0] DRPDI;
    input [15:0] GTRSVD;
    input [15:0] PCSRSVDIN;
    input [19:0] TSTIN;
    input [1:0] RXELECIDLEMODE;
    input [1:0] RXMONITORSEL;
    input [1:0] RXPD;
    input [1:0] RXSYSCLKSEL;
    input [1:0] TXPD;
    input [1:0] TXSYSCLKSEL;
    input [2:0] CPLLREFCLKSEL;
    input [2:0] LOOPBACK;
    input [2:0] RXCHBONDLEVEL;
    input [2:0] RXOUTCLKSEL;
    input [2:0] RXPRBSSEL;
    input [2:0] RXRATE;
    input [2:0] TXBUFDIFFCTRL;
    input [2:0] TXHEADER;
    input [2:0] TXMARGIN;
    input [2:0] TXOUTCLKSEL;
    input [2:0] TXPRBSSEL;
    input [2:0] TXRATE;
    input [3:0] RXOSINTCFG;
    input [3:0] RXOSINTID0;
    input [3:0] TXDIFFCTRL;
    input [4:0] PCSRSVDIN2;
    input [4:0] PMARSVDIN;
    input [4:0] RXCHBONDI;
    input [4:0] RXDFEAGCTRL;
    input [4:0] RXDFESLIDETAP;
    input [4:0] TXPIPPMSTEPSIZE;
    input [4:0] TXPOSTCURSOR;
    input [4:0] TXPRECURSOR;
    input [5:0] RXDFESLIDETAPID;
    input [63:0] TXDATA;
    input [6:0] TXMAINCURSOR;
    input [6:0] TXSEQUENCE;
    input [7:0] TX8B10BBYPASS;
    input [7:0] TXCHARDISPMODE;
    input [7:0] TXCHARDISPVAL;
    input [7:0] TXCHARISK;
    input [8:0] DRPADDR;
endmodule

module GTHE2_COMMON (...);
    parameter [63:0] BIAS_CFG = 64'h0000040000001000;
    parameter [31:0] COMMON_CFG = 32'h0000001C;
    parameter [0:0] IS_DRPCLK_INVERTED = 1'b0;
    parameter [0:0] IS_GTGREFCLK_INVERTED = 1'b0;
    parameter [0:0] IS_QPLLLOCKDETCLK_INVERTED = 1'b0;
    parameter [26:0] QPLL_CFG = 27'h0480181;
    parameter [3:0] QPLL_CLKOUT_CFG = 4'b0000;
    parameter [5:0] QPLL_COARSE_FREQ_OVRD = 6'b010000;
    parameter [0:0] QPLL_COARSE_FREQ_OVRD_EN = 1'b0;
    parameter [9:0] QPLL_CP = 10'b0000011111;
    parameter [0:0] QPLL_CP_MONITOR_EN = 1'b0;
    parameter [0:0] QPLL_DMONITOR_SEL = 1'b0;
    parameter [9:0] QPLL_FBDIV = 10'b0000000000;
    parameter [0:0] QPLL_FBDIV_MONITOR_EN = 1'b0;
    parameter [0:0] QPLL_FBDIV_RATIO = 1'b0;
    parameter [23:0] QPLL_INIT_CFG = 24'h000006;
    parameter [15:0] QPLL_LOCK_CFG = 16'h01E8;
    parameter [3:0] QPLL_LPF = 4'b1111;
    parameter integer QPLL_REFCLK_DIV = 2;
    parameter [0:0] QPLL_RP_COMP = 1'b0;
    parameter [1:0] QPLL_VTRL_RESET = 2'b00;
    parameter [1:0] RCAL_CFG = 2'b00;
    parameter [15:0] RSVD_ATTR0 = 16'h0000;
    parameter [15:0] RSVD_ATTR1 = 16'h0000;
    parameter [2:0] SIM_QPLLREFCLK_SEL = 3'b001;
    parameter SIM_RESET_SPEEDUP = "TRUE";
    parameter SIM_VERSION = "1.1";
    output DRPRDY;
    output QPLLFBCLKLOST;
    output QPLLLOCK;
    output QPLLOUTCLK;
    output QPLLOUTREFCLK;
    output QPLLREFCLKLOST;
    output REFCLKOUTMONITOR;
    output [15:0] DRPDO;
    output [15:0] PMARSVDOUT;
    output [7:0] QPLLDMONITOR;
    input BGBYPASSB;
    input BGMONITORENB;
    input BGPDB;
    input BGRCALOVRDENB;
    input DRPCLK;
    input DRPEN;
    input DRPWE;
    input GTGREFCLK;
    input GTNORTHREFCLK0;
    input GTNORTHREFCLK1;
    input GTREFCLK0;
    input GTREFCLK1;
    input GTSOUTHREFCLK0;
    input GTSOUTHREFCLK1;
    input QPLLLOCKDETCLK;
    input QPLLLOCKEN;
    input QPLLOUTRESET;
    input QPLLPD;
    input QPLLRESET;
    input RCALENB;
    input [15:0] DRPDI;
    input [15:0] QPLLRSVD1;
    input [2:0] QPLLREFCLKSEL;
    input [4:0] BGRCALOVRD;
    input [4:0] QPLLRSVD2;
    input [7:0] DRPADDR;
    input [7:0] PMARSVD;
endmodule

module GTPE2_CHANNEL (...);
    parameter [0:0] ACJTAG_DEBUG_MODE = 1'b0;
    parameter [0:0] ACJTAG_MODE = 1'b0;
    parameter [0:0] ACJTAG_RESET = 1'b0;
    parameter [19:0] ADAPT_CFG0 = 20'b00000000000000000000;
    parameter ALIGN_COMMA_DOUBLE = "FALSE";
    parameter [9:0] ALIGN_COMMA_ENABLE = 10'b0001111111;
    parameter integer ALIGN_COMMA_WORD = 1;
    parameter ALIGN_MCOMMA_DET = "TRUE";
    parameter [9:0] ALIGN_MCOMMA_VALUE = 10'b1010000011;
    parameter ALIGN_PCOMMA_DET = "TRUE";
    parameter [9:0] ALIGN_PCOMMA_VALUE = 10'b0101111100;
    parameter CBCC_DATA_SOURCE_SEL = "DECODED";
    parameter [42:0] CFOK_CFG = 43'b1001001000000000000000001000000111010000000;
    parameter [6:0] CFOK_CFG2 = 7'b0100000;
    parameter [6:0] CFOK_CFG3 = 7'b0100000;
    parameter [0:0] CFOK_CFG4 = 1'b0;
    parameter [1:0] CFOK_CFG5 = 2'b00;
    parameter [3:0] CFOK_CFG6 = 4'b0000;
    parameter CHAN_BOND_KEEP_ALIGN = "FALSE";
    parameter integer CHAN_BOND_MAX_SKEW = 7;
    parameter [9:0] CHAN_BOND_SEQ_1_1 = 10'b0101111100;
    parameter [9:0] CHAN_BOND_SEQ_1_2 = 10'b0000000000;
    parameter [9:0] CHAN_BOND_SEQ_1_3 = 10'b0000000000;
    parameter [9:0] CHAN_BOND_SEQ_1_4 = 10'b0000000000;
    parameter [3:0] CHAN_BOND_SEQ_1_ENABLE = 4'b1111;
    parameter [9:0] CHAN_BOND_SEQ_2_1 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_2 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_3 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_4 = 10'b0100000000;
    parameter [3:0] CHAN_BOND_SEQ_2_ENABLE = 4'b1111;
    parameter CHAN_BOND_SEQ_2_USE = "FALSE";
    parameter integer CHAN_BOND_SEQ_LEN = 1;
    parameter [0:0] CLK_COMMON_SWING = 1'b0;
    parameter CLK_CORRECT_USE = "TRUE";
    parameter CLK_COR_KEEP_IDLE = "FALSE";
    parameter integer CLK_COR_MAX_LAT = 20;
    parameter integer CLK_COR_MIN_LAT = 18;
    parameter CLK_COR_PRECEDENCE = "TRUE";
    parameter integer CLK_COR_REPEAT_WAIT = 0;
    parameter [9:0] CLK_COR_SEQ_1_1 = 10'b0100011100;
    parameter [9:0] CLK_COR_SEQ_1_2 = 10'b0000000000;
    parameter [9:0] CLK_COR_SEQ_1_3 = 10'b0000000000;
    parameter [9:0] CLK_COR_SEQ_1_4 = 10'b0000000000;
    parameter [3:0] CLK_COR_SEQ_1_ENABLE = 4'b1111;
    parameter [9:0] CLK_COR_SEQ_2_1 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_2 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_3 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_4 = 10'b0100000000;
    parameter [3:0] CLK_COR_SEQ_2_ENABLE = 4'b1111;
    parameter CLK_COR_SEQ_2_USE = "FALSE";
    parameter integer CLK_COR_SEQ_LEN = 1;
    parameter DEC_MCOMMA_DETECT = "TRUE";
    parameter DEC_PCOMMA_DETECT = "TRUE";
    parameter DEC_VALID_COMMA_ONLY = "TRUE";
    parameter [23:0] DMONITOR_CFG = 24'h000A00;
    parameter [0:0] ES_CLK_PHASE_SEL = 1'b0;
    parameter [5:0] ES_CONTROL = 6'b000000;
    parameter ES_ERRDET_EN = "FALSE";
    parameter ES_EYE_SCAN_EN = "FALSE";
    parameter [11:0] ES_HORZ_OFFSET = 12'h010;
    parameter [9:0] ES_PMA_CFG = 10'b0000000000;
    parameter [4:0] ES_PRESCALE = 5'b00000;
    parameter [79:0] ES_QUALIFIER = 80'h00000000000000000000;
    parameter [79:0] ES_QUAL_MASK = 80'h00000000000000000000;
    parameter [79:0] ES_SDATA_MASK = 80'h00000000000000000000;
    parameter [8:0] ES_VERT_OFFSET = 9'b000000000;
    parameter [3:0] FTS_DESKEW_SEQ_ENABLE = 4'b1111;
    parameter [3:0] FTS_LANE_DESKEW_CFG = 4'b1111;
    parameter FTS_LANE_DESKEW_EN = "FALSE";
    parameter [2:0] GEARBOX_MODE = 3'b000;
    parameter [0:0] IS_CLKRSVD0_INVERTED = 1'b0;
    parameter [0:0] IS_CLKRSVD1_INVERTED = 1'b0;
    parameter [0:0] IS_DMONITORCLK_INVERTED = 1'b0;
    parameter [0:0] IS_DRPCLK_INVERTED = 1'b0;
    parameter [0:0] IS_RXUSRCLK2_INVERTED = 1'b0;
    parameter [0:0] IS_RXUSRCLK_INVERTED = 1'b0;
    parameter [0:0] IS_SIGVALIDCLK_INVERTED = 1'b0;
    parameter [0:0] IS_TXPHDLYTSTCLK_INVERTED = 1'b0;
    parameter [0:0] IS_TXUSRCLK2_INVERTED = 1'b0;
    parameter [0:0] IS_TXUSRCLK_INVERTED = 1'b0;
    parameter [0:0] LOOPBACK_CFG = 1'b0;
    parameter [1:0] OUTREFCLK_SEL_INV = 2'b11;
    parameter PCS_PCIE_EN = "FALSE";
    parameter [47:0] PCS_RSVD_ATTR = 48'h000000000000;
    parameter [11:0] PD_TRANS_TIME_FROM_P2 = 12'h03C;
    parameter [7:0] PD_TRANS_TIME_NONE_P2 = 8'h19;
    parameter [7:0] PD_TRANS_TIME_TO_P2 = 8'h64;
    parameter [0:0] PMA_LOOPBACK_CFG = 1'b0;
    parameter [31:0] PMA_RSV = 32'h00000333;
    parameter [31:0] PMA_RSV2 = 32'h00002050;
    parameter [1:0] PMA_RSV3 = 2'b00;
    parameter [3:0] PMA_RSV4 = 4'b0000;
    parameter [0:0] PMA_RSV5 = 1'b0;
    parameter [0:0] PMA_RSV6 = 1'b0;
    parameter [0:0] PMA_RSV7 = 1'b0;
    parameter [4:0] RXBUFRESET_TIME = 5'b00001;
    parameter RXBUF_ADDR_MODE = "FULL";
    parameter [3:0] RXBUF_EIDLE_HI_CNT = 4'b1000;
    parameter [3:0] RXBUF_EIDLE_LO_CNT = 4'b0000;
    parameter RXBUF_EN = "TRUE";
    parameter RXBUF_RESET_ON_CB_CHANGE = "TRUE";
    parameter RXBUF_RESET_ON_COMMAALIGN = "FALSE";
    parameter RXBUF_RESET_ON_EIDLE = "FALSE";
    parameter RXBUF_RESET_ON_RATE_CHANGE = "TRUE";
    parameter integer RXBUF_THRESH_OVFLW = 61;
    parameter RXBUF_THRESH_OVRD = "FALSE";
    parameter integer RXBUF_THRESH_UNDFLW = 4;
    parameter [4:0] RXCDRFREQRESET_TIME = 5'b00001;
    parameter [4:0] RXCDRPHRESET_TIME = 5'b00001;
    parameter [82:0] RXCDR_CFG = 83'h0000107FE406001041010;
    parameter [0:0] RXCDR_FR_RESET_ON_EIDLE = 1'b0;
    parameter [0:0] RXCDR_HOLD_DURING_EIDLE = 1'b0;
    parameter [5:0] RXCDR_LOCK_CFG = 6'b001001;
    parameter [0:0] RXCDR_PH_RESET_ON_EIDLE = 1'b0;
    parameter [15:0] RXDLY_CFG = 16'h0010;
    parameter [8:0] RXDLY_LCFG = 9'h020;
    parameter [15:0] RXDLY_TAP_CFG = 16'h0000;
    parameter RXGEARBOX_EN = "FALSE";
    parameter [4:0] RXISCANRESET_TIME = 5'b00001;
    parameter [6:0] RXLPMRESET_TIME = 7'b0001111;
    parameter [0:0] RXLPM_BIAS_STARTUP_DISABLE = 1'b0;
    parameter [3:0] RXLPM_CFG = 4'b0110;
    parameter [0:0] RXLPM_CFG1 = 1'b0;
    parameter [0:0] RXLPM_CM_CFG = 1'b0;
    parameter [8:0] RXLPM_GC_CFG = 9'b111100010;
    parameter [2:0] RXLPM_GC_CFG2 = 3'b001;
    parameter [13:0] RXLPM_HF_CFG = 14'b00001111110000;
    parameter [4:0] RXLPM_HF_CFG2 = 5'b01010;
    parameter [3:0] RXLPM_HF_CFG3 = 4'b0000;
    parameter [0:0] RXLPM_HOLD_DURING_EIDLE = 1'b0;
    parameter [0:0] RXLPM_INCM_CFG = 1'b0;
    parameter [0:0] RXLPM_IPCM_CFG = 1'b0;
    parameter [17:0] RXLPM_LF_CFG = 18'b000000001111110000;
    parameter [4:0] RXLPM_LF_CFG2 = 5'b01010;
    parameter [2:0] RXLPM_OSINT_CFG = 3'b100;
    parameter [6:0] RXOOB_CFG = 7'b0000110;
    parameter RXOOB_CLK_CFG = "PMA";
    parameter [4:0] RXOSCALRESET_TIME = 5'b00011;
    parameter [4:0] RXOSCALRESET_TIMEOUT = 5'b00000;
    parameter integer RXOUT_DIV = 2;
    parameter [4:0] RXPCSRESET_TIME = 5'b00001;
    parameter [23:0] RXPHDLY_CFG = 24'h084000;
    parameter [23:0] RXPH_CFG = 24'hC00002;
    parameter [4:0] RXPH_MONITOR_SEL = 5'b00000;
    parameter [2:0] RXPI_CFG0 = 3'b000;
    parameter [0:0] RXPI_CFG1 = 1'b0;
    parameter [0:0] RXPI_CFG2 = 1'b0;
    parameter [4:0] RXPMARESET_TIME = 5'b00011;
    parameter [0:0] RXPRBS_ERR_LOOPBACK = 1'b0;
    parameter integer RXSLIDE_AUTO_WAIT = 7;
    parameter RXSLIDE_MODE = "OFF";
    parameter [0:0] RXSYNC_MULTILANE = 1'b0;
    parameter [0:0] RXSYNC_OVRD = 1'b0;
    parameter [0:0] RXSYNC_SKIP_DA = 1'b0;
    parameter [15:0] RX_BIAS_CFG = 16'b0000111100110011;
    parameter [5:0] RX_BUFFER_CFG = 6'b000000;
    parameter integer RX_CLK25_DIV = 7;
    parameter [0:0] RX_CLKMUX_EN = 1'b1;
    parameter [1:0] RX_CM_SEL = 2'b11;
    parameter [3:0] RX_CM_TRIM = 4'b0100;
    parameter integer RX_DATA_WIDTH = 20;
    parameter [5:0] RX_DDI_SEL = 6'b000000;
    parameter [13:0] RX_DEBUG_CFG = 14'b00000000000000;
    parameter RX_DEFER_RESET_BUF_EN = "TRUE";
    parameter RX_DISPERR_SEQ_MATCH = "TRUE";
    parameter [12:0] RX_OS_CFG = 13'b0001111110000;
    parameter integer RX_SIG_VALID_DLY = 10;
    parameter RX_XCLK_SEL = "RXREC";
    parameter integer SAS_MAX_COM = 64;
    parameter integer SAS_MIN_COM = 36;
    parameter [3:0] SATA_BURST_SEQ_LEN = 4'b1111;
    parameter [2:0] SATA_BURST_VAL = 3'b100;
    parameter [2:0] SATA_EIDLE_VAL = 3'b100;
    parameter integer SATA_MAX_BURST = 8;
    parameter integer SATA_MAX_INIT = 21;
    parameter integer SATA_MAX_WAKE = 7;
    parameter integer SATA_MIN_BURST = 4;
    parameter integer SATA_MIN_INIT = 12;
    parameter integer SATA_MIN_WAKE = 4;
    parameter SATA_PLL_CFG = "VCO_3000MHZ";
    parameter SHOW_REALIGN_COMMA = "TRUE";
    parameter SIM_RECEIVER_DETECT_PASS = "TRUE";
    parameter SIM_RESET_SPEEDUP = "TRUE";
    parameter SIM_TX_EIDLE_DRIVE_LEVEL = "X";
    parameter SIM_VERSION = "1.0";
    parameter [14:0] TERM_RCAL_CFG = 15'b100001000010000;
    parameter [2:0] TERM_RCAL_OVRD = 3'b000;
    parameter [7:0] TRANS_TIME_RATE = 8'h0E;
    parameter [31:0] TST_RSV = 32'h00000000;
    parameter TXBUF_EN = "TRUE";
    parameter TXBUF_RESET_ON_RATE_CHANGE = "FALSE";
    parameter [15:0] TXDLY_CFG = 16'h0010;
    parameter [8:0] TXDLY_LCFG = 9'h020;
    parameter [15:0] TXDLY_TAP_CFG = 16'h0000;
    parameter TXGEARBOX_EN = "FALSE";
    parameter [0:0] TXOOB_CFG = 1'b0;
    parameter integer TXOUT_DIV = 2;
    parameter [4:0] TXPCSRESET_TIME = 5'b00001;
    parameter [23:0] TXPHDLY_CFG = 24'h084000;
    parameter [15:0] TXPH_CFG = 16'h0400;
    parameter [4:0] TXPH_MONITOR_SEL = 5'b00000;
    parameter [1:0] TXPI_CFG0 = 2'b00;
    parameter [1:0] TXPI_CFG1 = 2'b00;
    parameter [1:0] TXPI_CFG2 = 2'b00;
    parameter [0:0] TXPI_CFG3 = 1'b0;
    parameter [0:0] TXPI_CFG4 = 1'b0;
    parameter [2:0] TXPI_CFG5 = 3'b000;
    parameter [0:0] TXPI_GREY_SEL = 1'b0;
    parameter [0:0] TXPI_INVSTROBE_SEL = 1'b0;
    parameter TXPI_PPMCLK_SEL = "TXUSRCLK2";
    parameter [7:0] TXPI_PPM_CFG = 8'b00000000;
    parameter [2:0] TXPI_SYNFREQ_PPM = 3'b000;
    parameter [4:0] TXPMARESET_TIME = 5'b00001;
    parameter [0:0] TXSYNC_MULTILANE = 1'b0;
    parameter [0:0] TXSYNC_OVRD = 1'b0;
    parameter [0:0] TXSYNC_SKIP_DA = 1'b0;
    parameter integer TX_CLK25_DIV = 7;
    parameter [0:0] TX_CLKMUX_EN = 1'b1;
    parameter integer TX_DATA_WIDTH = 20;
    parameter [5:0] TX_DEEMPH0 = 6'b000000;
    parameter [5:0] TX_DEEMPH1 = 6'b000000;
    parameter TX_DRIVE_MODE = "DIRECT";
    parameter [2:0] TX_EIDLE_ASSERT_DELAY = 3'b110;
    parameter [2:0] TX_EIDLE_DEASSERT_DELAY = 3'b100;
    parameter TX_LOOPBACK_DRIVE_HIZ = "FALSE";
    parameter [0:0] TX_MAINCURSOR_SEL = 1'b0;
    parameter [6:0] TX_MARGIN_FULL_0 = 7'b1001110;
    parameter [6:0] TX_MARGIN_FULL_1 = 7'b1001001;
    parameter [6:0] TX_MARGIN_FULL_2 = 7'b1000101;
    parameter [6:0] TX_MARGIN_FULL_3 = 7'b1000010;
    parameter [6:0] TX_MARGIN_FULL_4 = 7'b1000000;
    parameter [6:0] TX_MARGIN_LOW_0 = 7'b1000110;
    parameter [6:0] TX_MARGIN_LOW_1 = 7'b1000100;
    parameter [6:0] TX_MARGIN_LOW_2 = 7'b1000010;
    parameter [6:0] TX_MARGIN_LOW_3 = 7'b1000000;
    parameter [6:0] TX_MARGIN_LOW_4 = 7'b1000000;
    parameter [0:0] TX_PREDRIVER_MODE = 1'b0;
    parameter [13:0] TX_RXDETECT_CFG = 14'h1832;
    parameter [2:0] TX_RXDETECT_REF = 3'b100;
    parameter TX_XCLK_SEL = "TXUSR";
    parameter [0:0] UCODEER_CLR = 1'b0;
    parameter [0:0] USE_PCS_CLK_PHASE_SEL = 1'b0;
    output DRPRDY;
    output EYESCANDATAERROR;
    output GTPTXN;
    output GTPTXP;
    output PHYSTATUS;
    output PMARSVDOUT0;
    output PMARSVDOUT1;
    output RXBYTEISALIGNED;
    output RXBYTEREALIGN;
    output RXCDRLOCK;
    output RXCHANBONDSEQ;
    output RXCHANISALIGNED;
    output RXCHANREALIGN;
    output RXCOMINITDET;
    output RXCOMMADET;
    output RXCOMSASDET;
    output RXCOMWAKEDET;
    output RXDLYSRESETDONE;
    output RXELECIDLE;
    output RXHEADERVALID;
    output RXOSINTDONE;
    output RXOSINTSTARTED;
    output RXOSINTSTROBEDONE;
    output RXOSINTSTROBESTARTED;
    output RXOUTCLK;
    output RXOUTCLKFABRIC;
    output RXOUTCLKPCS;
    output RXPHALIGNDONE;
    output RXPMARESETDONE;
    output RXPRBSERR;
    output RXRATEDONE;
    output RXRESETDONE;
    output RXSYNCDONE;
    output RXSYNCOUT;
    output RXVALID;
    output TXCOMFINISH;
    output TXDLYSRESETDONE;
    output TXGEARBOXREADY;
    output TXOUTCLK;
    output TXOUTCLKFABRIC;
    output TXOUTCLKPCS;
    output TXPHALIGNDONE;
    output TXPHINITDONE;
    output TXPMARESETDONE;
    output TXRATEDONE;
    output TXRESETDONE;
    output TXSYNCDONE;
    output TXSYNCOUT;
    output [14:0] DMONITOROUT;
    output [15:0] DRPDO;
    output [15:0] PCSRSVDOUT;
    output [1:0] RXCLKCORCNT;
    output [1:0] RXDATAVALID;
    output [1:0] RXSTARTOFSEQ;
    output [1:0] TXBUFSTATUS;
    output [2:0] RXBUFSTATUS;
    output [2:0] RXHEADER;
    output [2:0] RXSTATUS;
    output [31:0] RXDATA;
    output [3:0] RXCHARISCOMMA;
    output [3:0] RXCHARISK;
    output [3:0] RXCHBONDO;
    output [3:0] RXDISPERR;
    output [3:0] RXNOTINTABLE;
    output [4:0] RXPHMONITOR;
    output [4:0] RXPHSLIPMONITOR;
    input CFGRESET;
    input CLKRSVD0;
    input CLKRSVD1;
    input DMONFIFORESET;
    input DMONITORCLK;
    input DRPCLK;
    input DRPEN;
    input DRPWE;
    input EYESCANMODE;
    input EYESCANRESET;
    input EYESCANTRIGGER;
    input GTPRXN;
    input GTPRXP;
    input GTRESETSEL;
    input GTRXRESET;
    input GTTXRESET;
    input PLL0CLK;
    input PLL0REFCLK;
    input PLL1CLK;
    input PLL1REFCLK;
    input PMARSVDIN0;
    input PMARSVDIN1;
    input PMARSVDIN2;
    input PMARSVDIN3;
    input PMARSVDIN4;
    input RESETOVRD;
    input RX8B10BEN;
    input RXBUFRESET;
    input RXCDRFREQRESET;
    input RXCDRHOLD;
    input RXCDROVRDEN;
    input RXCDRRESET;
    input RXCDRRESETRSV;
    input RXCHBONDEN;
    input RXCHBONDMASTER;
    input RXCHBONDSLAVE;
    input RXCOMMADETEN;
    input RXDDIEN;
    input RXDFEXYDEN;
    input RXDLYBYPASS;
    input RXDLYEN;
    input RXDLYOVRDEN;
    input RXDLYSRESET;
    input RXGEARBOXSLIP;
    input RXLPMHFHOLD;
    input RXLPMHFOVRDEN;
    input RXLPMLFHOLD;
    input RXLPMLFOVRDEN;
    input RXLPMOSINTNTRLEN;
    input RXLPMRESET;
    input RXMCOMMAALIGNEN;
    input RXOOBRESET;
    input RXOSCALRESET;
    input RXOSHOLD;
    input RXOSINTEN;
    input RXOSINTHOLD;
    input RXOSINTNTRLEN;
    input RXOSINTOVRDEN;
    input RXOSINTPD;
    input RXOSINTSTROBE;
    input RXOSINTTESTOVRDEN;
    input RXOSOVRDEN;
    input RXPCOMMAALIGNEN;
    input RXPCSRESET;
    input RXPHALIGN;
    input RXPHALIGNEN;
    input RXPHDLYPD;
    input RXPHDLYRESET;
    input RXPHOVRDEN;
    input RXPMARESET;
    input RXPOLARITY;
    input RXPRBSCNTRESET;
    input RXRATEMODE;
    input RXSLIDE;
    input RXSYNCALLIN;
    input RXSYNCIN;
    input RXSYNCMODE;
    input RXUSERRDY;
    input RXUSRCLK2;
    input RXUSRCLK;
    input SETERRSTATUS;
    input SIGVALIDCLK;
    input TX8B10BEN;
    input TXCOMINIT;
    input TXCOMSAS;
    input TXCOMWAKE;
    input TXDEEMPH;
    input TXDETECTRX;
    input TXDIFFPD;
    input TXDLYBYPASS;
    input TXDLYEN;
    input TXDLYHOLD;
    input TXDLYOVRDEN;
    input TXDLYSRESET;
    input TXDLYUPDOWN;
    input TXELECIDLE;
    input TXINHIBIT;
    input TXPCSRESET;
    input TXPDELECIDLEMODE;
    input TXPHALIGN;
    input TXPHALIGNEN;
    input TXPHDLYPD;
    input TXPHDLYRESET;
    input TXPHDLYTSTCLK;
    input TXPHINIT;
    input TXPHOVRDEN;
    input TXPIPPMEN;
    input TXPIPPMOVRDEN;
    input TXPIPPMPD;
    input TXPIPPMSEL;
    input TXPISOPD;
    input TXPMARESET;
    input TXPOLARITY;
    input TXPOSTCURSORINV;
    input TXPRBSFORCEERR;
    input TXPRECURSORINV;
    input TXRATEMODE;
    input TXSTARTSEQ;
    input TXSWING;
    input TXSYNCALLIN;
    input TXSYNCIN;
    input TXSYNCMODE;
    input TXUSERRDY;
    input TXUSRCLK2;
    input TXUSRCLK;
    input [13:0] RXADAPTSELTEST;
    input [15:0] DRPDI;
    input [15:0] GTRSVD;
    input [15:0] PCSRSVDIN;
    input [19:0] TSTIN;
    input [1:0] RXELECIDLEMODE;
    input [1:0] RXPD;
    input [1:0] RXSYSCLKSEL;
    input [1:0] TXPD;
    input [1:0] TXSYSCLKSEL;
    input [2:0] LOOPBACK;
    input [2:0] RXCHBONDLEVEL;
    input [2:0] RXOUTCLKSEL;
    input [2:0] RXPRBSSEL;
    input [2:0] RXRATE;
    input [2:0] TXBUFDIFFCTRL;
    input [2:0] TXHEADER;
    input [2:0] TXMARGIN;
    input [2:0] TXOUTCLKSEL;
    input [2:0] TXPRBSSEL;
    input [2:0] TXRATE;
    input [31:0] TXDATA;
    input [3:0] RXCHBONDI;
    input [3:0] RXOSINTCFG;
    input [3:0] RXOSINTID0;
    input [3:0] TX8B10BBYPASS;
    input [3:0] TXCHARDISPMODE;
    input [3:0] TXCHARDISPVAL;
    input [3:0] TXCHARISK;
    input [3:0] TXDIFFCTRL;
    input [4:0] TXPIPPMSTEPSIZE;
    input [4:0] TXPOSTCURSOR;
    input [4:0] TXPRECURSOR;
    input [6:0] TXMAINCURSOR;
    input [6:0] TXSEQUENCE;
    input [8:0] DRPADDR;
endmodule

module GTPE2_COMMON (...);
    parameter [63:0] BIAS_CFG = 64'h0000000000000000;
    parameter [31:0] COMMON_CFG = 32'h00000000;
    parameter [0:0] IS_DRPCLK_INVERTED = 1'b0;
    parameter [0:0] IS_GTGREFCLK0_INVERTED = 1'b0;
    parameter [0:0] IS_GTGREFCLK1_INVERTED = 1'b0;
    parameter [0:0] IS_PLL0LOCKDETCLK_INVERTED = 1'b0;
    parameter [0:0] IS_PLL1LOCKDETCLK_INVERTED = 1'b0;
    parameter [26:0] PLL0_CFG = 27'h01F03DC;
    parameter [0:0] PLL0_DMON_CFG = 1'b0;
    parameter integer PLL0_FBDIV = 4;
    parameter integer PLL0_FBDIV_45 = 5;
    parameter [23:0] PLL0_INIT_CFG = 24'h00001E;
    parameter [8:0] PLL0_LOCK_CFG = 9'h1E8;
    parameter integer PLL0_REFCLK_DIV = 1;
    parameter [26:0] PLL1_CFG = 27'h01F03DC;
    parameter [0:0] PLL1_DMON_CFG = 1'b0;
    parameter integer PLL1_FBDIV = 4;
    parameter integer PLL1_FBDIV_45 = 5;
    parameter [23:0] PLL1_INIT_CFG = 24'h00001E;
    parameter [8:0] PLL1_LOCK_CFG = 9'h1E8;
    parameter integer PLL1_REFCLK_DIV = 1;
    parameter [7:0] PLL_CLKOUT_CFG = 8'b00000000;
    parameter [15:0] RSVD_ATTR0 = 16'h0000;
    parameter [15:0] RSVD_ATTR1 = 16'h0000;
    parameter [2:0] SIM_PLL0REFCLK_SEL = 3'b001;
    parameter [2:0] SIM_PLL1REFCLK_SEL = 3'b001;
    parameter SIM_RESET_SPEEDUP = "TRUE";
    parameter SIM_VERSION = "1.0";
    output DRPRDY;
    output PLL0FBCLKLOST;
    output PLL0LOCK;
    output PLL0OUTCLK;
    output PLL0OUTREFCLK;
    output PLL0REFCLKLOST;
    output PLL1FBCLKLOST;
    output PLL1LOCK;
    output PLL1OUTCLK;
    output PLL1OUTREFCLK;
    output PLL1REFCLKLOST;
    output REFCLKOUTMONITOR0;
    output REFCLKOUTMONITOR1;
    output [15:0] DRPDO;
    output [15:0] PMARSVDOUT;
    output [7:0] DMONITOROUT;
    input BGBYPASSB;
    input BGMONITORENB;
    input BGPDB;
    input BGRCALOVRDENB;
    input DRPCLK;
    input DRPEN;
    input DRPWE;
    input GTEASTREFCLK0;
    input GTEASTREFCLK1;
    input GTGREFCLK0;
    input GTGREFCLK1;
    input GTREFCLK0;
    input GTREFCLK1;
    input GTWESTREFCLK0;
    input GTWESTREFCLK1;
    input PLL0LOCKDETCLK;
    input PLL0LOCKEN;
    input PLL0PD;
    input PLL0RESET;
    input PLL1LOCKDETCLK;
    input PLL1LOCKEN;
    input PLL1PD;
    input PLL1RESET;
    input RCALENB;
    input [15:0] DRPDI;
    input [15:0] PLLRSVD1;
    input [2:0] PLL0REFCLKSEL;
    input [2:0] PLL1REFCLKSEL;
    input [4:0] BGRCALOVRD;
    input [4:0] PLLRSVD2;
    input [7:0] DRPADDR;
    input [7:0] PMARSVD;
endmodule

module GTXE2_CHANNEL (...);
    parameter ALIGN_COMMA_DOUBLE = "FALSE";
    parameter [9:0] ALIGN_COMMA_ENABLE = 10'b0001111111;
    parameter integer ALIGN_COMMA_WORD = 1;
    parameter ALIGN_MCOMMA_DET = "TRUE";
    parameter [9:0] ALIGN_MCOMMA_VALUE = 10'b1010000011;
    parameter ALIGN_PCOMMA_DET = "TRUE";
    parameter [9:0] ALIGN_PCOMMA_VALUE = 10'b0101111100;
    parameter CBCC_DATA_SOURCE_SEL = "DECODED";
    parameter CHAN_BOND_KEEP_ALIGN = "FALSE";
    parameter integer CHAN_BOND_MAX_SKEW = 7;
    parameter [9:0] CHAN_BOND_SEQ_1_1 = 10'b0101111100;
    parameter [9:0] CHAN_BOND_SEQ_1_2 = 10'b0000000000;
    parameter [9:0] CHAN_BOND_SEQ_1_3 = 10'b0000000000;
    parameter [9:0] CHAN_BOND_SEQ_1_4 = 10'b0000000000;
    parameter [3:0] CHAN_BOND_SEQ_1_ENABLE = 4'b1111;
    parameter [9:0] CHAN_BOND_SEQ_2_1 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_2 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_3 = 10'b0100000000;
    parameter [9:0] CHAN_BOND_SEQ_2_4 = 10'b0100000000;
    parameter [3:0] CHAN_BOND_SEQ_2_ENABLE = 4'b1111;
    parameter CHAN_BOND_SEQ_2_USE = "FALSE";
    parameter integer CHAN_BOND_SEQ_LEN = 1;
    parameter CLK_CORRECT_USE = "TRUE";
    parameter CLK_COR_KEEP_IDLE = "FALSE";
    parameter integer CLK_COR_MAX_LAT = 20;
    parameter integer CLK_COR_MIN_LAT = 18;
    parameter CLK_COR_PRECEDENCE = "TRUE";
    parameter integer CLK_COR_REPEAT_WAIT = 0;
    parameter [9:0] CLK_COR_SEQ_1_1 = 10'b0100011100;
    parameter [9:0] CLK_COR_SEQ_1_2 = 10'b0000000000;
    parameter [9:0] CLK_COR_SEQ_1_3 = 10'b0000000000;
    parameter [9:0] CLK_COR_SEQ_1_4 = 10'b0000000000;
    parameter [3:0] CLK_COR_SEQ_1_ENABLE = 4'b1111;
    parameter [9:0] CLK_COR_SEQ_2_1 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_2 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_3 = 10'b0100000000;
    parameter [9:0] CLK_COR_SEQ_2_4 = 10'b0100000000;
    parameter [3:0] CLK_COR_SEQ_2_ENABLE = 4'b1111;
    parameter CLK_COR_SEQ_2_USE = "FALSE";
    parameter integer CLK_COR_SEQ_LEN = 1;
    parameter [23:0] CPLL_CFG = 24'hB007D8;
    parameter integer CPLL_FBDIV = 4;
    parameter integer CPLL_FBDIV_45 = 5;
    parameter [23:0] CPLL_INIT_CFG = 24'h00001E;
    parameter [15:0] CPLL_LOCK_CFG = 16'h01E8;
    parameter integer CPLL_REFCLK_DIV = 1;
    parameter DEC_MCOMMA_DETECT = "TRUE";
    parameter DEC_PCOMMA_DETECT = "TRUE";
    parameter DEC_VALID_COMMA_ONLY = "TRUE";
    parameter [23:0] DMONITOR_CFG = 24'h000A00;
    parameter [5:0] ES_CONTROL = 6'b000000;
    parameter ES_ERRDET_EN = "FALSE";
    parameter ES_EYE_SCAN_EN = "FALSE";
    parameter [11:0] ES_HORZ_OFFSET = 12'h000;
    parameter [9:0] ES_PMA_CFG = 10'b0000000000;
    parameter [4:0] ES_PRESCALE = 5'b00000;
    parameter [79:0] ES_QUALIFIER = 80'h00000000000000000000;
    parameter [79:0] ES_QUAL_MASK = 80'h00000000000000000000;
    parameter [79:0] ES_SDATA_MASK = 80'h00000000000000000000;
    parameter [8:0] ES_VERT_OFFSET = 9'b000000000;
    parameter [3:0] FTS_DESKEW_SEQ_ENABLE = 4'b1111;
    parameter [3:0] FTS_LANE_DESKEW_CFG = 4'b1111;
    parameter FTS_LANE_DESKEW_EN = "FALSE";
    parameter [2:0] GEARBOX_MODE = 3'b000;
    parameter [0:0] IS_CPLLLOCKDETCLK_INVERTED = 1'b0;
    parameter [0:0] IS_DRPCLK_INVERTED = 1'b0;
    parameter [0:0] IS_GTGREFCLK_INVERTED = 1'b0;
    parameter [0:0] IS_RXUSRCLK2_INVERTED = 1'b0;
    parameter [0:0] IS_RXUSRCLK_INVERTED = 1'b0;
    parameter [0:0] IS_TXPHDLYTSTCLK_INVERTED = 1'b0;
    parameter [0:0] IS_TXUSRCLK2_INVERTED = 1'b0;
    parameter [0:0] IS_TXUSRCLK_INVERTED = 1'b0;
    parameter [1:0] OUTREFCLK_SEL_INV = 2'b11;
    parameter PCS_PCIE_EN = "FALSE";
    parameter [47:0] PCS_RSVD_ATTR = 48'h000000000000;
    parameter [11:0] PD_TRANS_TIME_FROM_P2 = 12'h03C;
    parameter [7:0] PD_TRANS_TIME_NONE_P2 = 8'h19;
    parameter [7:0] PD_TRANS_TIME_TO_P2 = 8'h64;
    parameter [31:0] PMA_RSV = 32'h00000000;
    parameter [15:0] PMA_RSV2 = 16'h2050;
    parameter [1:0] PMA_RSV3 = 2'b00;
    parameter [31:0] PMA_RSV4 = 32'h00000000;
    parameter [4:0] RXBUFRESET_TIME = 5'b00001;
    parameter RXBUF_ADDR_MODE = "FULL";
    parameter [3:0] RXBUF_EIDLE_HI_CNT = 4'b1000;
    parameter [3:0] RXBUF_EIDLE_LO_CNT = 4'b0000;
    parameter RXBUF_EN = "TRUE";
    parameter RXBUF_RESET_ON_CB_CHANGE = "TRUE";
    parameter RXBUF_RESET_ON_COMMAALIGN = "FALSE";
    parameter RXBUF_RESET_ON_EIDLE = "FALSE";
    parameter RXBUF_RESET_ON_RATE_CHANGE = "TRUE";
    parameter integer RXBUF_THRESH_OVFLW = 61;
    parameter RXBUF_THRESH_OVRD = "FALSE";
    parameter integer RXBUF_THRESH_UNDFLW = 4;
    parameter [4:0] RXCDRFREQRESET_TIME = 5'b00001;
    parameter [4:0] RXCDRPHRESET_TIME = 5'b00001;
    parameter [71:0] RXCDR_CFG = 72'h0B000023FF20400020;
    parameter [0:0] RXCDR_FR_RESET_ON_EIDLE = 1'b0;
    parameter [0:0] RXCDR_HOLD_DURING_EIDLE = 1'b0;
    parameter [5:0] RXCDR_LOCK_CFG = 6'b010101;
    parameter [0:0] RXCDR_PH_RESET_ON_EIDLE = 1'b0;
    parameter [6:0] RXDFELPMRESET_TIME = 7'b0001111;
    parameter [15:0] RXDLY_CFG = 16'h001F;
    parameter [8:0] RXDLY_LCFG = 9'h030;
    parameter [15:0] RXDLY_TAP_CFG = 16'h0000;
    parameter RXGEARBOX_EN = "FALSE";
    parameter [4:0] RXISCANRESET_TIME = 5'b00001;
    parameter [13:0] RXLPM_HF_CFG = 14'b00000011110000;
    parameter [13:0] RXLPM_LF_CFG = 14'b00000011110000;
    parameter [6:0] RXOOB_CFG = 7'b0000110;
    parameter integer RXOUT_DIV = 2;
    parameter [4:0] RXPCSRESET_TIME = 5'b00001;
    parameter [23:0] RXPHDLY_CFG = 24'h084020;
    parameter [23:0] RXPH_CFG = 24'h000000;
    parameter [4:0] RXPH_MONITOR_SEL = 5'b00000;
    parameter [4:0] RXPMARESET_TIME = 5'b00011;
    parameter [0:0] RXPRBS_ERR_LOOPBACK = 1'b0;
    parameter integer RXSLIDE_AUTO_WAIT = 7;
    parameter RXSLIDE_MODE = "OFF";
    parameter [11:0] RX_BIAS_CFG = 12'b000000000000;
    parameter [5:0] RX_BUFFER_CFG = 6'b000000;
    parameter integer RX_CLK25_DIV = 7;
    parameter [0:0] RX_CLKMUX_PD = 1'b1;
    parameter [1:0] RX_CM_SEL = 2'b11;
    parameter [2:0] RX_CM_TRIM = 3'b100;
    parameter integer RX_DATA_WIDTH = 20;
    parameter [5:0] RX_DDI_SEL = 6'b000000;
    parameter [11:0] RX_DEBUG_CFG = 12'b000000000000;
    parameter RX_DEFER_RESET_BUF_EN = "TRUE";
    parameter [22:0] RX_DFE_GAIN_CFG = 23'h180E0F;
    parameter [11:0] RX_DFE_H2_CFG = 12'b000111100000;
    parameter [11:0] RX_DFE_H3_CFG = 12'b000111100000;
    parameter [10:0] RX_DFE_H4_CFG = 11'b00011110000;
    parameter [10:0] RX_DFE_H5_CFG = 11'b00011110000;
    parameter [12:0] RX_DFE_KL_CFG = 13'b0001111110000;
    parameter [31:0] RX_DFE_KL_CFG2 = 32'h3008E56A;
    parameter [15:0] RX_DFE_LPM_CFG = 16'h0904;
    parameter [0:0] RX_DFE_LPM_HOLD_DURING_EIDLE = 1'b0;
    parameter [16:0] RX_DFE_UT_CFG = 17'b00111111000000000;
    parameter [16:0] RX_DFE_VP_CFG = 17'b00011111100000000;
    parameter [12:0] RX_DFE_XYD_CFG = 13'b0000000010000;
    parameter RX_DISPERR_SEQ_MATCH = "TRUE";
    parameter integer RX_INT_DATAWIDTH = 0;
    parameter [12:0] RX_OS_CFG = 13'b0001111110000;
    parameter integer RX_SIG_VALID_DLY = 10;
    parameter RX_XCLK_SEL = "RXREC";
    parameter integer SAS_MAX_COM = 64;
    parameter integer SAS_MIN_COM = 36;
    parameter [3:0] SATA_BURST_SEQ_LEN = 4'b1111;
    parameter [2:0] SATA_BURST_VAL = 3'b100;
    parameter SATA_CPLL_CFG = "VCO_3000MHZ";
    parameter [2:0] SATA_EIDLE_VAL = 3'b100;
    parameter integer SATA_MAX_BURST = 8;
    parameter integer SATA_MAX_INIT = 21;
    parameter integer SATA_MAX_WAKE = 7;
    parameter integer SATA_MIN_BURST = 4;
    parameter integer SATA_MIN_INIT = 12;
    parameter integer SATA_MIN_WAKE = 4;
    parameter SHOW_REALIGN_COMMA = "TRUE";
    parameter [2:0] SIM_CPLLREFCLK_SEL = 3'b001;
    parameter SIM_RECEIVER_DETECT_PASS = "TRUE";
    parameter SIM_RESET_SPEEDUP = "TRUE";
    parameter SIM_TX_EIDLE_DRIVE_LEVEL = "X";
    parameter SIM_VERSION = "4.0";
    parameter [4:0] TERM_RCAL_CFG = 5'b10000;
    parameter [0:0] TERM_RCAL_OVRD = 1'b0;
    parameter [7:0] TRANS_TIME_RATE = 8'h0E;
    parameter [31:0] TST_RSV = 32'h00000000;
    parameter TXBUF_EN = "TRUE";
    parameter TXBUF_RESET_ON_RATE_CHANGE = "FALSE";
    parameter [15:0] TXDLY_CFG = 16'h001F;
    parameter [8:0] TXDLY_LCFG = 9'h030;
    parameter [15:0] TXDLY_TAP_CFG = 16'h0000;
    parameter TXGEARBOX_EN = "FALSE";
    parameter integer TXOUT_DIV = 2;
    parameter [4:0] TXPCSRESET_TIME = 5'b00001;
    parameter [23:0] TXPHDLY_CFG = 24'h084020;
    parameter [15:0] TXPH_CFG = 16'h0780;
    parameter [4:0] TXPH_MONITOR_SEL = 5'b00000;
    parameter [4:0] TXPMARESET_TIME = 5'b00001;
    parameter integer TX_CLK25_DIV = 7;
    parameter [0:0] TX_CLKMUX_PD = 1'b1;
    parameter integer TX_DATA_WIDTH = 20;
    parameter [4:0] TX_DEEMPH0 = 5'b00000;
    parameter [4:0] TX_DEEMPH1 = 5'b00000;
    parameter TX_DRIVE_MODE = "DIRECT";
    parameter [2:0] TX_EIDLE_ASSERT_DELAY = 3'b110;
    parameter [2:0] TX_EIDLE_DEASSERT_DELAY = 3'b100;
    parameter integer TX_INT_DATAWIDTH = 0;
    parameter TX_LOOPBACK_DRIVE_HIZ = "FALSE";
    parameter [0:0] TX_MAINCURSOR_SEL = 1'b0;
    parameter [6:0] TX_MARGIN_FULL_0 = 7'b1001110;
    parameter [6:0] TX_MARGIN_FULL_1 = 7'b1001001;
    parameter [6:0] TX_MARGIN_FULL_2 = 7'b1000101;
    parameter [6:0] TX_MARGIN_FULL_3 = 7'b1000010;
    parameter [6:0] TX_MARGIN_FULL_4 = 7'b1000000;
    parameter [6:0] TX_MARGIN_LOW_0 = 7'b1000110;
    parameter [6:0] TX_MARGIN_LOW_1 = 7'b1000100;
    parameter [6:0] TX_MARGIN_LOW_2 = 7'b1000010;
    parameter [6:0] TX_MARGIN_LOW_3 = 7'b1000000;
    parameter [6:0] TX_MARGIN_LOW_4 = 7'b1000000;
    parameter [0:0] TX_PREDRIVER_MODE = 1'b0;
    parameter [0:0] TX_QPI_STATUS_EN = 1'b0;
    parameter [13:0] TX_RXDETECT_CFG = 14'h1832;
    parameter [2:0] TX_RXDETECT_REF = 3'b100;
    parameter TX_XCLK_SEL = "TXUSR";
    parameter [0:0] UCODEER_CLR = 1'b0;
    output CPLLFBCLKLOST;
    output CPLLLOCK;
    output CPLLREFCLKLOST;
    output DRPRDY;
    output EYESCANDATAERROR;
    output GTREFCLKMONITOR;
    output GTXTXN;
    output GTXTXP;
    output PHYSTATUS;
    output RXBYTEISALIGNED;
    output RXBYTEREALIGN;
    output RXCDRLOCK;
    output RXCHANBONDSEQ;
    output RXCHANISALIGNED;
    output RXCHANREALIGN;
    output RXCOMINITDET;
    output RXCOMMADET;
    output RXCOMSASDET;
    output RXCOMWAKEDET;
    output RXDATAVALID;
    output RXDLYSRESETDONE;
    output RXELECIDLE;
    output RXHEADERVALID;
    output RXOUTCLK;
    output RXOUTCLKFABRIC;
    output RXOUTCLKPCS;
    output RXPHALIGNDONE;
    output RXPRBSERR;
    output RXQPISENN;
    output RXQPISENP;
    output RXRATEDONE;
    output RXRESETDONE;
    output RXSTARTOFSEQ;
    output RXVALID;
    output TXCOMFINISH;
    output TXDLYSRESETDONE;
    output TXGEARBOXREADY;
    output TXOUTCLK;
    output TXOUTCLKFABRIC;
    output TXOUTCLKPCS;
    output TXPHALIGNDONE;
    output TXPHINITDONE;
    output TXQPISENN;
    output TXQPISENP;
    output TXRATEDONE;
    output TXRESETDONE;
    output [15:0] DRPDO;
    output [15:0] PCSRSVDOUT;
    output [1:0] RXCLKCORCNT;
    output [1:0] TXBUFSTATUS;
    output [2:0] RXBUFSTATUS;
    output [2:0] RXHEADER;
    output [2:0] RXSTATUS;
    output [4:0] RXCHBONDO;
    output [4:0] RXPHMONITOR;
    output [4:0] RXPHSLIPMONITOR;
    output [63:0] RXDATA;
    output [6:0] RXMONITOROUT;
    output [7:0] DMONITOROUT;
    output [7:0] RXCHARISCOMMA;
    output [7:0] RXCHARISK;
    output [7:0] RXDISPERR;
    output [7:0] RXNOTINTABLE;
    output [9:0] TSTOUT;
    input CFGRESET;
    input CPLLLOCKDETCLK;
    input CPLLLOCKEN;
    input CPLLPD;
    input CPLLRESET;
    input DRPCLK;
    input DRPEN;
    input DRPWE;
    input EYESCANMODE;
    input EYESCANRESET;
    input EYESCANTRIGGER;
    input GTGREFCLK;
    input GTNORTHREFCLK0;
    input GTNORTHREFCLK1;
    input GTREFCLK0;
    input GTREFCLK1;
    input GTRESETSEL;
    input GTRXRESET;
    input GTSOUTHREFCLK0;
    input GTSOUTHREFCLK1;
    input GTTXRESET;
    input GTXRXN;
    input GTXRXP;
    input QPLLCLK;
    input QPLLREFCLK;
    input RESETOVRD;
    input RX8B10BEN;
    input RXBUFRESET;
    input RXCDRFREQRESET;
    input RXCDRHOLD;
    input RXCDROVRDEN;
    input RXCDRRESET;
    input RXCDRRESETRSV;
    input RXCHBONDEN;
    input RXCHBONDMASTER;
    input RXCHBONDSLAVE;
    input RXCOMMADETEN;
    input RXDDIEN;
    input RXDFEAGCHOLD;
    input RXDFEAGCOVRDEN;
    input RXDFECM1EN;
    input RXDFELFHOLD;
    input RXDFELFOVRDEN;
    input RXDFELPMRESET;
    input RXDFETAP2HOLD;
    input RXDFETAP2OVRDEN;
    input RXDFETAP3HOLD;
    input RXDFETAP3OVRDEN;
    input RXDFETAP4HOLD;
    input RXDFETAP4OVRDEN;
    input RXDFETAP5HOLD;
    input RXDFETAP5OVRDEN;
    input RXDFEUTHOLD;
    input RXDFEUTOVRDEN;
    input RXDFEVPHOLD;
    input RXDFEVPOVRDEN;
    input RXDFEVSEN;
    input RXDFEXYDEN;
    input RXDFEXYDHOLD;
    input RXDFEXYDOVRDEN;
    input RXDLYBYPASS;
    input RXDLYEN;
    input RXDLYOVRDEN;
    input RXDLYSRESET;
    input RXGEARBOXSLIP;
    input RXLPMEN;
    input RXLPMHFHOLD;
    input RXLPMHFOVRDEN;
    input RXLPMLFHOLD;
    input RXLPMLFKLOVRDEN;
    input RXMCOMMAALIGNEN;
    input RXOOBRESET;
    input RXOSHOLD;
    input RXOSOVRDEN;
    input RXPCOMMAALIGNEN;
    input RXPCSRESET;
    input RXPHALIGN;
    input RXPHALIGNEN;
    input RXPHDLYPD;
    input RXPHDLYRESET;
    input RXPHOVRDEN;
    input RXPMARESET;
    input RXPOLARITY;
    input RXPRBSCNTRESET;
    input RXQPIEN;
    input RXSLIDE;
    input RXUSERRDY;
    input RXUSRCLK2;
    input RXUSRCLK;
    input SETERRSTATUS;
    input TX8B10BEN;
    input TXCOMINIT;
    input TXCOMSAS;
    input TXCOMWAKE;
    input TXDEEMPH;
    input TXDETECTRX;
    input TXDIFFPD;
    input TXDLYBYPASS;
    input TXDLYEN;
    input TXDLYHOLD;
    input TXDLYOVRDEN;
    input TXDLYSRESET;
    input TXDLYUPDOWN;
    input TXELECIDLE;
    input TXINHIBIT;
    input TXPCSRESET;
    input TXPDELECIDLEMODE;
    input TXPHALIGN;
    input TXPHALIGNEN;
    input TXPHDLYPD;
    input TXPHDLYRESET;
    input TXPHDLYTSTCLK;
    input TXPHINIT;
    input TXPHOVRDEN;
    input TXPISOPD;
    input TXPMARESET;
    input TXPOLARITY;
    input TXPOSTCURSORINV;
    input TXPRBSFORCEERR;
    input TXPRECURSORINV;
    input TXQPIBIASEN;
    input TXQPISTRONGPDOWN;
    input TXQPIWEAKPUP;
    input TXSTARTSEQ;
    input TXSWING;
    input TXUSERRDY;
    input TXUSRCLK2;
    input TXUSRCLK;
    input [15:0] DRPDI;
    input [15:0] GTRSVD;
    input [15:0] PCSRSVDIN;
    input [19:0] TSTIN;
    input [1:0] RXELECIDLEMODE;
    input [1:0] RXMONITORSEL;
    input [1:0] RXPD;
    input [1:0] RXSYSCLKSEL;
    input [1:0] TXPD;
    input [1:0] TXSYSCLKSEL;
    input [2:0] CPLLREFCLKSEL;
    input [2:0] LOOPBACK;
    input [2:0] RXCHBONDLEVEL;
    input [2:0] RXOUTCLKSEL;
    input [2:0] RXPRBSSEL;
    input [2:0] RXRATE;
    input [2:0] TXBUFDIFFCTRL;
    input [2:0] TXHEADER;
    input [2:0] TXMARGIN;
    input [2:0] TXOUTCLKSEL;
    input [2:0] TXPRBSSEL;
    input [2:0] TXRATE;
    input [3:0] CLKRSVD;
    input [3:0] TXDIFFCTRL;
    input [4:0] PCSRSVDIN2;
    input [4:0] PMARSVDIN2;
    input [4:0] PMARSVDIN;
    input [4:0] RXCHBONDI;
    input [4:0] TXPOSTCURSOR;
    input [4:0] TXPRECURSOR;
    input [63:0] TXDATA;
    input [6:0] TXMAINCURSOR;
    input [6:0] TXSEQUENCE;
    input [7:0] TX8B10BBYPASS;
    input [7:0] TXCHARDISPMODE;
    input [7:0] TXCHARDISPVAL;
    input [7:0] TXCHARISK;
    input [8:0] DRPADDR;
endmodule

module GTXE2_COMMON (...);
    parameter [63:0] BIAS_CFG = 64'h0000040000001000;
    parameter [31:0] COMMON_CFG = 32'h00000000;
    parameter [0:0] IS_DRPCLK_INVERTED = 1'b0;
    parameter [0:0] IS_GTGREFCLK_INVERTED = 1'b0;
    parameter [0:0] IS_QPLLLOCKDETCLK_INVERTED = 1'b0;
    parameter [26:0] QPLL_CFG = 27'h0680181;
    parameter [3:0] QPLL_CLKOUT_CFG = 4'b0000;
    parameter [5:0] QPLL_COARSE_FREQ_OVRD = 6'b010000;
    parameter [0:0] QPLL_COARSE_FREQ_OVRD_EN = 1'b0;
    parameter [9:0] QPLL_CP = 10'b0000011111;
    parameter [0:0] QPLL_CP_MONITOR_EN = 1'b0;
    parameter [0:0] QPLL_DMONITOR_SEL = 1'b0;
    parameter [9:0] QPLL_FBDIV = 10'b0000000000;
    parameter [0:0] QPLL_FBDIV_MONITOR_EN = 1'b0;
    parameter [0:0] QPLL_FBDIV_RATIO = 1'b0;
    parameter [23:0] QPLL_INIT_CFG = 24'h000006;
    parameter [15:0] QPLL_LOCK_CFG = 16'h21E8;
    parameter [3:0] QPLL_LPF = 4'b1111;
    parameter integer QPLL_REFCLK_DIV = 2;
    parameter [2:0] SIM_QPLLREFCLK_SEL = 3'b001;
    parameter SIM_RESET_SPEEDUP = "TRUE";
    parameter SIM_VERSION = "4.0";
    output DRPRDY;
    output QPLLFBCLKLOST;
    output QPLLLOCK;
    output QPLLOUTCLK;
    output QPLLOUTREFCLK;
    output QPLLREFCLKLOST;
    output REFCLKOUTMONITOR;
    output [15:0] DRPDO;
    output [7:0] QPLLDMONITOR;
    input BGBYPASSB;
    input BGMONITORENB;
    input BGPDB;
    input DRPCLK;
    input DRPEN;
    input DRPWE;
    input GTGREFCLK;
    input GTNORTHREFCLK0;
    input GTNORTHREFCLK1;
    input GTREFCLK0;
    input GTREFCLK1;
    input GTSOUTHREFCLK0;
    input GTSOUTHREFCLK1;
    input QPLLLOCKDETCLK;
    input QPLLLOCKEN;
    input QPLLOUTRESET;
    input QPLLPD;
    input QPLLRESET;
    input RCALENB;
    input [15:0] DRPDI;
    input [15:0] QPLLRSVD1;
    input [2:0] QPLLREFCLKSEL;
    input [4:0] BGRCALOVRD;
    input [4:0] QPLLRSVD2;
    input [7:0] DRPADDR;
    input [7:0] PMARSVD;
endmodule

module IBUF_IBUFDISABLE (...);
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    input I;
    input IBUFDISABLE;
endmodule

module IBUF_INTERMDISABLE (...);
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    input I;
    input IBUFDISABLE;
    input INTERMDISABLE;
endmodule

module IBUFDS (...);
    parameter CAPACITANCE = "DONT_CARE";
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_DELAY_VALUE = "0";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IFD_DELAY_VALUE = "AUTO";
    parameter IOSTANDARD = "DEFAULT";
    output O;
    input I, IB;
endmodule

module IBUFDS_DIFF_OUT (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    output O, OB;
    input I, IB;
endmodule

module IBUFDS_DIFF_OUT_IBUFDISABLE (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    output OB;
    input I;
    input IB;
    input IBUFDISABLE;
endmodule

module IBUFDS_DIFF_OUT_INTERMDISABLE (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    output OB;
    input I;
    input IB;
    input IBUFDISABLE;
    input INTERMDISABLE;
endmodule

module IBUFDS_GTE2 (...);
    parameter CLKCM_CFG = "TRUE";
    parameter CLKRCV_TRST = "TRUE";
    parameter CLKSWING_CFG = "TRUE";
    output O;
    output ODIV2;
    input CEB;
    input I;
    input IB;
endmodule

module IBUFDS_IBUFDISABLE (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    input I;
    input IB;
    input IBUFDISABLE;
endmodule

module IBUFDS_INTERMDISABLE (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    input I;
    input IB;
    input IBUFDISABLE;
    input INTERMDISABLE;
endmodule

(* keep *)
module ICAPE2 (...);
    parameter [31:0] DEVICE_ID = 32'h04244093;
    parameter ICAP_WIDTH = "X32";
    parameter SIM_CFG_FILE_NAME = "NONE";
    output [31:0] O;
    input CLK;
    input CSIB;
    input RDWRB;
    input [31:0] I;
endmodule

module IDDR (...);
    parameter DDR_CLK_EDGE = "OPPOSITE_EDGE";
    parameter INIT_Q1 = 1'b0;
    parameter INIT_Q2 = 1'b0;
    parameter [0:0] IS_C_INVERTED = 1'b0;
    parameter [0:0] IS_D_INVERTED = 1'b0;
    parameter SRTYPE = "SYNC";
    parameter MSGON = "TRUE";
    parameter XON = "TRUE";
    output Q1;
    output Q2;
    input C;
    input CE;
    input D;
    input R;
    input S;
endmodule

module IDDR_2CLK (...);
    parameter DDR_CLK_EDGE = "OPPOSITE_EDGE";
    parameter INIT_Q1 = 1'b0;
    parameter INIT_Q2 = 1'b0;
    parameter [0:0] IS_CB_INVERTED = 1'b0;
    parameter [0:0] IS_C_INVERTED = 1'b0;
    parameter [0:0] IS_D_INVERTED = 1'b0;
    parameter SRTYPE = "SYNC";
    output Q1;
    output Q2;
    input C;
    input CB;
    input CE;
    input D;
    input R;
    input S;
endmodule

(* keep *)
module IDELAYCTRL (...);
    parameter SIM_DEVICE = "7SERIES";
    output RDY;
    input REFCLK;
    input RST;
endmodule

module IDELAYE2 (...);
    parameter CINVCTRL_SEL = "FALSE";
    parameter DELAY_SRC = "IDATAIN";
    parameter HIGH_PERFORMANCE_MODE = "FALSE";
    parameter IDELAY_TYPE = "FIXED";
    parameter integer IDELAY_VALUE = 0;
    parameter [0:0] IS_C_INVERTED = 1'b0;
    parameter [0:0] IS_DATAIN_INVERTED = 1'b0;
    parameter [0:0] IS_IDATAIN_INVERTED = 1'b0;
    parameter PIPE_SEL = "FALSE";
    parameter real REFCLK_FREQUENCY = 200.0;
    parameter SIGNAL_PATTERN = "DATA";
    parameter integer SIM_DELAY_D = 0;
    output [4:0] CNTVALUEOUT;
    output DATAOUT;
    input C;
    input CE;
    input CINVCTRL;
    input [4:0] CNTVALUEIN;
    input DATAIN;
    input IDATAIN;
    input INC;
    input LD;
    input LDPIPEEN;
    input REGRST;
endmodule

module IN_FIFO (...);
    parameter integer ALMOST_EMPTY_VALUE = 1;
    parameter integer ALMOST_FULL_VALUE = 1;
    parameter ARRAY_MODE = "ARRAY_MODE_4_X_8";
    parameter SYNCHRONOUS_MODE = "FALSE";
    output ALMOSTEMPTY;
    output ALMOSTFULL;
    output EMPTY;
    output FULL;
    output [7:0] Q0;
    output [7:0] Q1;
    output [7:0] Q2;
    output [7:0] Q3;
    output [7:0] Q4;
    output [7:0] Q5;
    output [7:0] Q6;
    output [7:0] Q7;
    output [7:0] Q8;
    output [7:0] Q9;
    input RDCLK;
    input RDEN;
    input RESET;
    input WRCLK;
    input WREN;
    input [3:0] D0;
    input [3:0] D1;
    input [3:0] D2;
    input [3:0] D3;
    input [3:0] D4;
    input [3:0] D7;
    input [3:0] D8;
    input [3:0] D9;
    input [7:0] D5;
    input [7:0] D6;
endmodule

module IOBUF (...);
    parameter integer DRIVE = 12;
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SLEW = "SLOW";
    output O;
    inout IO;
    input I, T;
endmodule

module IOBUF_DCIEN (...);
    parameter integer DRIVE = 12;
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter SLEW = "SLOW";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    inout IO;
    input DCITERMDISABLE;
    input I;
    input IBUFDISABLE;
    input T;
endmodule

module IOBUF_INTERMDISABLE (...);
    parameter integer DRIVE = 12;
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter SLEW = "SLOW";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    inout IO;
    input I;
    input IBUFDISABLE;
    input INTERMDISABLE;
    input T;
endmodule

module IOBUFDS (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SLEW = "SLOW";
    output O;
    inout IO, IOB;
    input I, T;
endmodule

module IOBUFDS_DCIEN (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter SLEW = "SLOW";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    inout IO;
    inout IOB;
    input DCITERMDISABLE;
    input I;
    input IBUFDISABLE;
    input T;
endmodule

module IOBUFDS_DIFF_OUT (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    output O;
    output OB;
    inout IO;
    inout IOB;
    input I;
    input TM;
    input TS;
endmodule

module IOBUFDS_DIFF_OUT_DCIEN (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    output OB;
    inout IO;
    inout IOB;
    input DCITERMDISABLE;
    input I;
    input IBUFDISABLE;
    input TM;
    input TS;
endmodule

module IOBUFDS_DIFF_OUT_INTERMDISABLE (...);
    parameter DIFF_TERM = "FALSE";
    parameter DQS_BIAS = "FALSE";
    parameter IBUF_LOW_PWR = "TRUE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SIM_DEVICE = "7SERIES";
    parameter USE_IBUFDISABLE = "TRUE";
    output O;
    output OB;
    inout IO;
    inout IOB;
    input I;
    input IBUFDISABLE;
    input INTERMDISABLE;
    input TM;
    input TS;
endmodule

module ISERDESE2 (...);
    parameter DATA_RATE = "DDR";
    parameter integer DATA_WIDTH = 4;
    parameter DYN_CLKDIV_INV_EN = "FALSE";
    parameter DYN_CLK_INV_EN = "FALSE";
    parameter [0:0] INIT_Q1 = 1'b0;
    parameter [0:0] INIT_Q2 = 1'b0;
    parameter [0:0] INIT_Q3 = 1'b0;
    parameter [0:0] INIT_Q4 = 1'b0;
    parameter INTERFACE_TYPE = "MEMORY";
    parameter IOBDELAY = "NONE";
    parameter [0:0] IS_CLKB_INVERTED = 1'b0;
    parameter [0:0] IS_CLKDIVP_INVERTED = 1'b0;
    parameter [0:0] IS_CLKDIV_INVERTED = 1'b0;
    parameter [0:0] IS_CLK_INVERTED = 1'b0;
    parameter [0:0] IS_D_INVERTED = 1'b0;
    parameter [0:0] IS_OCLKB_INVERTED = 1'b0;
    parameter [0:0] IS_OCLK_INVERTED = 1'b0;
    parameter integer NUM_CE = 2;
    parameter OFB_USED = "FALSE";
    parameter SERDES_MODE = "MASTER";
    parameter [0:0] SRVAL_Q1 = 1'b0;
    parameter [0:0] SRVAL_Q2 = 1'b0;
    parameter [0:0] SRVAL_Q3 = 1'b0;
    parameter [0:0] SRVAL_Q4 = 1'b0;
    output O;
    output Q1;
    output Q2;
    output Q3;
    output Q4;
    output Q5;
    output Q6;
    output Q7;
    output Q8;
    output SHIFTOUT1;
    output SHIFTOUT2;
    input BITSLIP;
    input CE1;
    input CE2;
    input CLK;
    input CLKB;
    input CLKDIV;
    input CLKDIVP;
    input D;
    input DDLY;
    input DYNCLKDIVSEL;
    input DYNCLKSEL;
    input OCLK;
    input OCLKB;
    input OFB;
    input RST;
    input SHIFTIN1;
    input SHIFTIN2;
endmodule

module KEEPER (...);
    inout O;
endmodule

module LDCE (...);
    parameter [0:0] INIT = 1'b0;
    parameter [0:0] IS_CLR_INVERTED = 1'b0;
    parameter [0:0] IS_G_INVERTED = 1'b0;
    parameter MSGON = "TRUE";
    parameter XON = "TRUE";
    output Q;
    input CLR, D, G, GE;
endmodule

module LDPE (...);
    parameter [0:0] INIT = 1'b1;
    parameter [0:0] IS_G_INVERTED = 1'b0;
    parameter [0:0] IS_PRE_INVERTED = 1'b0;
    parameter MSGON = "TRUE";
    parameter XON = "TRUE";
    output Q;
    input D, G, GE, PRE;
endmodule

module LUT6_2 (...);
    parameter [63:0] INIT = 64'h0000000000000000;
    input I0, I1, I2, I3, I4, I5;
    output O5, O6;
endmodule

module MMCME2_ADV (...);
    parameter BANDWIDTH = "OPTIMIZED";
    parameter real CLKFBOUT_MULT_F = 5.000;
    parameter real CLKFBOUT_PHASE = 0.000;
    parameter CLKFBOUT_USE_FINE_PS = "FALSE";
    parameter real CLKIN1_PERIOD = 0.000;
    parameter real CLKIN2_PERIOD = 0.000;
    parameter real CLKIN_FREQ_MAX = 1066.000;
    parameter real CLKIN_FREQ_MIN = 10.000;
    parameter real CLKOUT0_DIVIDE_F = 1.000;
    parameter real CLKOUT0_DUTY_CYCLE = 0.500;
    parameter real CLKOUT0_PHASE = 0.000;
    parameter CLKOUT0_USE_FINE_PS = "FALSE";
    parameter integer CLKOUT1_DIVIDE = 1;
    parameter real CLKOUT1_DUTY_CYCLE = 0.500;
    parameter real CLKOUT1_PHASE = 0.000;
    parameter CLKOUT1_USE_FINE_PS = "FALSE";
    parameter integer CLKOUT2_DIVIDE = 1;
    parameter real CLKOUT2_DUTY_CYCLE = 0.500;
    parameter real CLKOUT2_PHASE = 0.000;
    parameter CLKOUT2_USE_FINE_PS = "FALSE";
    parameter integer CLKOUT3_DIVIDE = 1;
    parameter real CLKOUT3_DUTY_CYCLE = 0.500;
    parameter real CLKOUT3_PHASE = 0.000;
    parameter CLKOUT3_USE_FINE_PS = "FALSE";
    parameter CLKOUT4_CASCADE = "FALSE";
    parameter integer CLKOUT4_DIVIDE = 1;
    parameter real CLKOUT4_DUTY_CYCLE = 0.500;
    parameter real CLKOUT4_PHASE = 0.000;
    parameter CLKOUT4_USE_FINE_PS = "FALSE";
    parameter integer CLKOUT5_DIVIDE = 1;
    parameter real CLKOUT5_DUTY_CYCLE = 0.500;
    parameter real CLKOUT5_PHASE = 0.000;
    parameter CLKOUT5_USE_FINE_PS = "FALSE";
    parameter integer CLKOUT6_DIVIDE = 1;
    parameter real CLKOUT6_DUTY_CYCLE = 0.500;
    parameter real CLKOUT6_PHASE = 0.000;
    parameter CLKOUT6_USE_FINE_PS = "FALSE";
    parameter real CLKPFD_FREQ_MAX = 550.000;
    parameter real CLKPFD_FREQ_MIN = 10.000;
    parameter COMPENSATION = "ZHOLD";
    parameter integer DIVCLK_DIVIDE = 1;
    parameter [0:0] IS_CLKINSEL_INVERTED = 1'b0;
    parameter [0:0] IS_PSEN_INVERTED = 1'b0;
    parameter [0:0] IS_PSINCDEC_INVERTED = 1'b0;
    parameter [0:0] IS_PWRDWN_INVERTED = 1'b0;
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter real REF_JITTER1 = 0.010;
    parameter real REF_JITTER2 = 0.010;
    parameter SS_EN = "FALSE";
    parameter SS_MODE = "CENTER_HIGH";
    parameter integer SS_MOD_PERIOD = 10000;
    parameter STARTUP_WAIT = "FALSE";
    parameter real VCOCLK_FREQ_MAX = 1600.000;
    parameter real VCOCLK_FREQ_MIN = 600.000;
    parameter STARTUP_WAIT = "FALSE";
    output CLKFBOUT;
    output CLKFBOUTB;
    output CLKFBSTOPPED;
    output CLKINSTOPPED;
    output CLKOUT0;
    output CLKOUT0B;
    output CLKOUT1;
    output CLKOUT1B;
    output CLKOUT2;
    output CLKOUT2B;
    output CLKOUT3;
    output CLKOUT3B;
    output CLKOUT4;
    output CLKOUT5;
    output CLKOUT6;
    output [15:0] DO;
    output DRDY;
    output LOCKED;
    output PSDONE;
    input CLKFBIN;
    input CLKIN1;
    input CLKIN2;
    input CLKINSEL;
    input [6:0] DADDR;
    input DCLK;
    input DEN;
    input [15:0] DI;
    input DWE;
    input PSCLK;
    input PSEN;
    input PSINCDEC;
    input PWRDWN;
    input RST;
endmodule

module MMCME2_BASE (...);
    parameter BANDWIDTH = "OPTIMIZED";
    parameter real CLKFBOUT_MULT_F = 5.000;
    parameter real CLKFBOUT_PHASE = 0.000;
    parameter real CLKIN1_PERIOD = 0.000;
    parameter real CLKOUT0_DIVIDE_F = 1.000;
    parameter real CLKOUT0_DUTY_CYCLE = 0.500;
    parameter real CLKOUT0_PHASE = 0.000;
    parameter integer CLKOUT1_DIVIDE = 1;
    parameter real CLKOUT1_DUTY_CYCLE = 0.500;
    parameter real CLKOUT1_PHASE = 0.000;
    parameter integer CLKOUT2_DIVIDE = 1;
    parameter real CLKOUT2_DUTY_CYCLE = 0.500;
    parameter real CLKOUT2_PHASE = 0.000;
    parameter integer CLKOUT3_DIVIDE = 1;
    parameter real CLKOUT3_DUTY_CYCLE = 0.500;
    parameter real CLKOUT3_PHASE = 0.000;
    parameter CLKOUT4_CASCADE = "FALSE";
    parameter integer CLKOUT4_DIVIDE = 1;
    parameter real CLKOUT4_DUTY_CYCLE = 0.500;
    parameter real CLKOUT4_PHASE = 0.000;
    parameter integer CLKOUT5_DIVIDE = 1;
    parameter real CLKOUT5_DUTY_CYCLE = 0.500;
    parameter real CLKOUT5_PHASE = 0.000;
    parameter integer CLKOUT6_DIVIDE = 1;
    parameter real CLKOUT6_DUTY_CYCLE = 0.500;
    parameter real CLKOUT6_PHASE = 0.000;
    parameter integer DIVCLK_DIVIDE = 1;
    parameter real REF_JITTER1 = 0.010;
    parameter STARTUP_WAIT = "FALSE";
    output CLKFBOUT;
    output CLKFBOUTB;
    output CLKOUT0;
    output CLKOUT0B;
    output CLKOUT1;
    output CLKOUT1B;
    output CLKOUT2;
    output CLKOUT2B;
    output CLKOUT3;
    output CLKOUT3B;
    output CLKOUT4;
    output CLKOUT5;
    output CLKOUT6;
    output LOCKED;
    input CLKFBIN;
    input CLKIN1;
    input PWRDWN;
    input RST;
endmodule

module OBUFDS (...);
    parameter CAPACITANCE = "DONT_CARE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SLEW = "SLOW";
    output O, OB;
    input I;
endmodule

module OBUFT (...);
    parameter CAPACITANCE = "DONT_CARE";
    parameter integer DRIVE = 12;
    parameter IOSTANDARD = "DEFAULT";
    parameter SLEW = "SLOW";
    output O;
    input I, T;
endmodule

module OBUFTDS (...);
    parameter CAPACITANCE = "DONT_CARE";
    parameter IOSTANDARD = "DEFAULT";
    parameter SLEW = "SLOW";
    output O, OB;
    input I, T;
endmodule

module ODDR (...);
    output Q;
    input C;
    input CE;
    input D1;
    input D2;
    input R;
    input S;
    parameter DDR_CLK_EDGE = "OPPOSITE_EDGE";
    parameter INIT = 1'b0;
    parameter [0:0] IS_C_INVERTED = 1'b0;
    parameter [0:0] IS_D1_INVERTED = 1'b0;
    parameter [0:0] IS_D2_INVERTED = 1'b0;
    parameter SRTYPE = "SYNC";
    parameter MSGON = "TRUE";
    parameter XON = "TRUE";
endmodule

module ODELAYE2 (...);
    parameter CINVCTRL_SEL = "FALSE";
    parameter DELAY_SRC = "ODATAIN";
    parameter HIGH_PERFORMANCE_MODE = "FALSE";
    parameter [0:0] IS_C_INVERTED = 1'b0;
    parameter [0:0] IS_ODATAIN_INVERTED = 1'b0;
    parameter ODELAY_TYPE = "FIXED";
    parameter integer ODELAY_VALUE = 0;
    parameter PIPE_SEL = "FALSE";
    parameter real REFCLK_FREQUENCY = 200.0;
    parameter SIGNAL_PATTERN = "DATA";
    parameter integer SIM_DELAY_D = 0;
    output [4:0] CNTVALUEOUT;
    output DATAOUT;
    input C;
    input CE;
    input CINVCTRL;
    input CLKIN;
    input [4:0] CNTVALUEIN;
    input INC;
    input LD;
    input LDPIPEEN;
    input ODATAIN;
    input REGRST;
endmodule

module OSERDESE2 (...);
    parameter DATA_RATE_OQ = "DDR";
    parameter DATA_RATE_TQ = "DDR";
    parameter integer DATA_WIDTH = 4;
    parameter [0:0] INIT_OQ = 1'b0;
    parameter [0:0] INIT_TQ = 1'b0;
    parameter [0:0] IS_CLKDIV_INVERTED = 1'b0;
    parameter [0:0] IS_CLK_INVERTED = 1'b0;
    parameter [0:0] IS_D1_INVERTED = 1'b0;
    parameter [0:0] IS_D2_INVERTED = 1'b0;
    parameter [0:0] IS_D3_INVERTED = 1'b0;
    parameter [0:0] IS_D4_INVERTED = 1'b0;
    parameter [0:0] IS_D5_INVERTED = 1'b0;
    parameter [0:0] IS_D6_INVERTED = 1'b0;
    parameter [0:0] IS_D7_INVERTED = 1'b0;
    parameter [0:0] IS_D8_INVERTED = 1'b0;
    parameter [0:0] IS_T1_INVERTED = 1'b0;
    parameter [0:0] IS_T2_INVERTED = 1'b0;
    parameter [0:0] IS_T3_INVERTED = 1'b0;
    parameter [0:0] IS_T4_INVERTED = 1'b0;
    parameter SERDES_MODE = "MASTER";
    parameter [0:0] SRVAL_OQ = 1'b0;
    parameter [0:0] SRVAL_TQ = 1'b0;
    parameter TBYTE_CTL = "FALSE";
    parameter TBYTE_SRC = "FALSE";
    parameter integer TRISTATE_WIDTH = 4;
    output OFB;
    output OQ;
    output SHIFTOUT1;
    output SHIFTOUT2;
    output TBYTEOUT;
    output TFB;
    output TQ;
    input CLK;
    input CLKDIV;
    input D1;
    input D2;
    input D3;
    input D4;
    input D5;
    input D6;
    input D7;
    input D8;
    input OCE;
    input RST;
    input SHIFTIN1;
    input SHIFTIN2;
    input T1;
    input T2;
    input T3;
    input T4;
    input TBYTEIN;
    input TCE;
endmodule

module OUT_FIFO (...);
    parameter integer ALMOST_EMPTY_VALUE = 1;
    parameter integer ALMOST_FULL_VALUE = 1;
    parameter ARRAY_MODE = "ARRAY_MODE_8_X_4";
    parameter OUTPUT_DISABLE = "FALSE";
    parameter SYNCHRONOUS_MODE = "FALSE";
    output ALMOSTEMPTY;
    output ALMOSTFULL;
    output EMPTY;
    output FULL;
    output [3:0] Q0;
    output [3:0] Q1;
    output [3:0] Q2;
    output [3:0] Q3;
    output [3:0] Q4;
    output [3:0] Q7;
    output [3:0] Q8;
    output [3:0] Q9;
    output [7:0] Q5;
    output [7:0] Q6;
    input RDCLK;
    input RDEN;
    input RESET;
    input WRCLK;
    input WREN;
    input [7:0] D0;
    input [7:0] D1;
    input [7:0] D2;
    input [7:0] D3;
    input [7:0] D4;
    input [7:0] D5;
    input [7:0] D6;
    input [7:0] D7;
    input [7:0] D8;
    input [7:0] D9;
endmodule

module PHASER_IN (...);
    parameter integer CLKOUT_DIV = 4;
    parameter DQS_BIAS_MODE = "FALSE";
    parameter EN_ISERDES_RST = "FALSE";
    parameter integer FINE_DELAY = 0;
    parameter FREQ_REF_DIV = "NONE";
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter real MEMREFCLK_PERIOD = 0.000;
    parameter OUTPUT_CLK_SRC = "PHASE_REF";
    parameter real PHASEREFCLK_PERIOD = 0.000;
    parameter real REFCLK_PERIOD = 0.000;
    parameter integer SEL_CLK_OFFSET = 5;
    parameter SYNC_IN_DIV_RST = "FALSE";
    output FINEOVERFLOW;
    output ICLK;
    output ICLKDIV;
    output ISERDESRST;
    output RCLK;
    output [5:0] COUNTERREADVAL;
    input COUNTERLOADEN;
    input COUNTERREADEN;
    input DIVIDERST;
    input EDGEADV;
    input FINEENABLE;
    input FINEINC;
    input FREQREFCLK;
    input MEMREFCLK;
    input PHASEREFCLK;
    input RST;
    input SYNCIN;
    input SYSCLK;
    input [1:0] RANKSEL;
    input [5:0] COUNTERLOADVAL;
endmodule

module PHASER_IN_PHY (...);
    parameter BURST_MODE = "FALSE";
    parameter integer CLKOUT_DIV = 4;
    parameter [0:0] DQS_AUTO_RECAL = 1'b1;
    parameter DQS_BIAS_MODE = "FALSE";
    parameter [2:0] DQS_FIND_PATTERN = 3'b001;
    parameter integer FINE_DELAY = 0;
    parameter FREQ_REF_DIV = "NONE";
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter real MEMREFCLK_PERIOD = 0.000;
    parameter OUTPUT_CLK_SRC = "PHASE_REF";
    parameter real PHASEREFCLK_PERIOD = 0.000;
    parameter real REFCLK_PERIOD = 0.000;
    parameter integer SEL_CLK_OFFSET = 5;
    parameter SYNC_IN_DIV_RST = "FALSE";
    parameter WR_CYCLES = "FALSE";
    output DQSFOUND;
    output DQSOUTOFRANGE;
    output FINEOVERFLOW;
    output ICLK;
    output ICLKDIV;
    output ISERDESRST;
    output PHASELOCKED;
    output RCLK;
    output WRENABLE;
    output [5:0] COUNTERREADVAL;
    input BURSTPENDINGPHY;
    input COUNTERLOADEN;
    input COUNTERREADEN;
    input FINEENABLE;
    input FINEINC;
    input FREQREFCLK;
    input MEMREFCLK;
    input PHASEREFCLK;
    input RST;
    input RSTDQSFIND;
    input SYNCIN;
    input SYSCLK;
    input [1:0] ENCALIBPHY;
    input [1:0] RANKSELPHY;
    input [5:0] COUNTERLOADVAL;
endmodule

module PHASER_OUT (...);
    parameter integer CLKOUT_DIV = 4;
    parameter COARSE_BYPASS = "FALSE";
    parameter integer COARSE_DELAY = 0;
    parameter EN_OSERDES_RST = "FALSE";
    parameter integer FINE_DELAY = 0;
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter real MEMREFCLK_PERIOD = 0.000;
    parameter OCLKDELAY_INV = "FALSE";
    parameter integer OCLK_DELAY = 0;
    parameter OUTPUT_CLK_SRC = "PHASE_REF";
    parameter real PHASEREFCLK_PERIOD = 0.000;
    parameter [2:0] PO = 3'b000;
    parameter real REFCLK_PERIOD = 0.000;
    parameter SYNC_IN_DIV_RST = "FALSE";
    output COARSEOVERFLOW;
    output FINEOVERFLOW;
    output OCLK;
    output OCLKDELAYED;
    output OCLKDIV;
    output OSERDESRST;
    output [8:0] COUNTERREADVAL;
    input COARSEENABLE;
    input COARSEINC;
    input COUNTERLOADEN;
    input COUNTERREADEN;
    input DIVIDERST;
    input EDGEADV;
    input FINEENABLE;
    input FINEINC;
    input FREQREFCLK;
    input MEMREFCLK;
    input PHASEREFCLK;
    input RST;
    input SELFINEOCLKDELAY;
    input SYNCIN;
    input SYSCLK;
    input [8:0] COUNTERLOADVAL;
endmodule

module PHASER_OUT_PHY (...);
    parameter integer CLKOUT_DIV = 4;
    parameter COARSE_BYPASS = "FALSE";
    parameter integer COARSE_DELAY = 0;
    parameter DATA_CTL_N = "FALSE";
    parameter DATA_RD_CYCLES = "FALSE";
    parameter integer FINE_DELAY = 0;
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter real MEMREFCLK_PERIOD = 0.000;
    parameter OCLKDELAY_INV = "FALSE";
    parameter integer OCLK_DELAY = 0;
    parameter OUTPUT_CLK_SRC = "PHASE_REF";
    parameter real PHASEREFCLK_PERIOD = 0.000;
    parameter [2:0] PO = 3'b000;
    parameter real REFCLK_PERIOD = 0.000;
    parameter SYNC_IN_DIV_RST = "FALSE";
    output COARSEOVERFLOW;
    output FINEOVERFLOW;
    output OCLK;
    output OCLKDELAYED;
    output OCLKDIV;
    output OSERDESRST;
    output RDENABLE;
    output [1:0] CTSBUS;
    output [1:0] DQSBUS;
    output [1:0] DTSBUS;
    output [8:0] COUNTERREADVAL;
    input BURSTPENDINGPHY;
    input COARSEENABLE;
    input COARSEINC;
    input COUNTERLOADEN;
    input COUNTERREADEN;
    input FINEENABLE;
    input FINEINC;
    input FREQREFCLK;
    input MEMREFCLK;
    input PHASEREFCLK;
    input RST;
    input SELFINEOCLKDELAY;
    input SYNCIN;
    input SYSCLK;
    input [1:0] ENCALIBPHY;
    input [8:0] COUNTERLOADVAL;
endmodule

module PHASER_REF (...);
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter [0:0] IS_PWRDWN_INVERTED = 1'b0;
    output LOCKED;
    input CLKIN;
    input PWRDWN;
    input RST;
endmodule

module PHY_CONTROL (...);
    parameter integer AO_TOGGLE = 0;
    parameter [3:0] AO_WRLVL_EN = 4'b0000;
    parameter BURST_MODE = "FALSE";
    parameter integer CLK_RATIO = 1;
    parameter integer CMD_OFFSET = 0;
    parameter integer CO_DURATION = 0;
    parameter DATA_CTL_A_N = "FALSE";
    parameter DATA_CTL_B_N = "FALSE";
    parameter DATA_CTL_C_N = "FALSE";
    parameter DATA_CTL_D_N = "FALSE";
    parameter DISABLE_SEQ_MATCH = "TRUE";
    parameter integer DI_DURATION = 0;
    parameter integer DO_DURATION = 0;
    parameter integer EVENTS_DELAY = 63;
    parameter integer FOUR_WINDOW_CLOCKS = 63;
    parameter MULTI_REGION = "FALSE";
    parameter PHY_COUNT_ENABLE = "FALSE";
    parameter integer RD_CMD_OFFSET_0 = 0;
    parameter integer RD_CMD_OFFSET_1 = 00;
    parameter integer RD_CMD_OFFSET_2 = 0;
    parameter integer RD_CMD_OFFSET_3 = 0;
    parameter integer RD_DURATION_0 = 0;
    parameter integer RD_DURATION_1 = 0;
    parameter integer RD_DURATION_2 = 0;
    parameter integer RD_DURATION_3 = 0;
    parameter SYNC_MODE = "FALSE";
    parameter integer WR_CMD_OFFSET_0 = 0;
    parameter integer WR_CMD_OFFSET_1 = 0;
    parameter integer WR_CMD_OFFSET_2 = 0;
    parameter integer WR_CMD_OFFSET_3 = 0;
    parameter integer WR_DURATION_0 = 0;
    parameter integer WR_DURATION_1 = 0;
    parameter integer WR_DURATION_2 = 0;
    parameter integer WR_DURATION_3 = 0;
    output PHYCTLALMOSTFULL;
    output PHYCTLEMPTY;
    output PHYCTLFULL;
    output PHYCTLREADY;
    output [1:0] INRANKA;
    output [1:0] INRANKB;
    output [1:0] INRANKC;
    output [1:0] INRANKD;
    output [1:0] PCENABLECALIB;
    output [3:0] AUXOUTPUT;
    output [3:0] INBURSTPENDING;
    output [3:0] OUTBURSTPENDING;
    input MEMREFCLK;
    input PHYCLK;
    input PHYCTLMSTREMPTY;
    input PHYCTLWRENABLE;
    input PLLLOCK;
    input READCALIBENABLE;
    input REFDLLLOCK;
    input RESET;
    input SYNCIN;
    input WRITECALIBENABLE;
    input [31:0] PHYCTLWD;
endmodule

module PLLE2_ADV (...);
    parameter BANDWIDTH = "OPTIMIZED";
    parameter COMPENSATION = "ZHOLD";
    parameter STARTUP_WAIT = "FALSE";
    parameter integer CLKOUT0_DIVIDE = 1;
    parameter integer CLKOUT1_DIVIDE = 1;
    parameter integer CLKOUT2_DIVIDE = 1;
    parameter integer CLKOUT3_DIVIDE = 1;
    parameter integer CLKOUT4_DIVIDE = 1;
    parameter integer CLKOUT5_DIVIDE = 1;
    parameter integer DIVCLK_DIVIDE = 1;
    parameter integer CLKFBOUT_MULT = 5;
    parameter real CLKFBOUT_PHASE = 0.000;
    parameter real CLKIN1_PERIOD = 0.000;
    parameter real CLKIN2_PERIOD = 0.000;
    parameter real CLKOUT0_DUTY_CYCLE = 0.500;
    parameter real CLKOUT0_PHASE = 0.000;
    parameter real CLKOUT1_DUTY_CYCLE = 0.500;
    parameter real CLKOUT1_PHASE = 0.000;
    parameter real CLKOUT2_DUTY_CYCLE = 0.500;
    parameter real CLKOUT2_PHASE = 0.000;
    parameter real CLKOUT3_DUTY_CYCLE = 0.500;
    parameter real CLKOUT3_PHASE = 0.000;
    parameter real CLKOUT4_DUTY_CYCLE = 0.500;
    parameter real CLKOUT4_PHASE = 0.000;
    parameter real CLKOUT5_DUTY_CYCLE = 0.500;
    parameter real CLKOUT5_PHASE = 0.000;
    parameter [0:0] IS_CLKINSEL_INVERTED = 1'b0;
    parameter [0:0] IS_PWRDWN_INVERTED = 1'b0;
    parameter [0:0] IS_RST_INVERTED = 1'b0;
    parameter real REF_JITTER1 = 0.010;
    parameter real REF_JITTER2 = 0.010;
    parameter real VCOCLK_FREQ_MAX = 2133.000;
    parameter real VCOCLK_FREQ_MIN = 800.000;
    parameter real CLKIN_FREQ_MAX = 1066.000;
    parameter real CLKIN_FREQ_MIN = 19.000;
    parameter real CLKPFD_FREQ_MAX = 550.0;
    parameter real CLKPFD_FREQ_MIN = 19.0;
    output CLKFBOUT;
    output CLKOUT0;
    output CLKOUT1;
    output CLKOUT2;
    output CLKOUT3;
    output CLKOUT4;
    output CLKOUT5;
    output DRDY;
    output LOCKED;
    output [15:0] DO;
    input CLKFBIN;
    input CLKIN1;
    input CLKIN2;
    input CLKINSEL;
    input DCLK;
    input DEN;
    input DWE;
    input PWRDWN;
    input RST;
    input [15:0] DI;
    input [6:0] DADDR;
endmodule

module PLLE2_BASE (...);
    parameter BANDWIDTH = "OPTIMIZED";
    parameter integer CLKFBOUT_MULT = 5;
    parameter real CLKFBOUT_PHASE = 0.000;
    parameter real CLKIN1_PERIOD = 0.000;
    parameter integer CLKOUT0_DIVIDE = 1;
    parameter real CLKOUT0_DUTY_CYCLE = 0.500;
    parameter real CLKOUT0_PHASE = 0.000;
    parameter integer CLKOUT1_DIVIDE = 1;
    parameter real CLKOUT1_DUTY_CYCLE = 0.500;
    parameter real CLKOUT1_PHASE = 0.000;
    parameter integer CLKOUT2_DIVIDE = 1;
    parameter real CLKOUT2_DUTY_CYCLE = 0.500;
    parameter real CLKOUT2_PHASE = 0.000;
    parameter integer CLKOUT3_DIVIDE = 1;
    parameter real CLKOUT3_DUTY_CYCLE = 0.500;
    parameter real CLKOUT3_PHASE = 0.000;
    parameter integer CLKOUT4_DIVIDE = 1;
    parameter real CLKOUT4_DUTY_CYCLE = 0.500;
    parameter real CLKOUT4_PHASE = 0.000;
    parameter integer CLKOUT5_DIVIDE = 1;
    parameter real CLKOUT5_DUTY_CYCLE = 0.500;
    parameter real CLKOUT5_PHASE = 0.000;
    parameter integer DIVCLK_DIVIDE = 1;
    parameter real REF_JITTER1 = 0.010;
    parameter STARTUP_WAIT = "FALSE";
    output CLKFBOUT;
    output CLKOUT0;
    output CLKOUT1;
    output CLKOUT2;
    output CLKOUT3;
    output CLKOUT4;
    output CLKOUT5;
    output LOCKED;
    input CLKFBIN;
    input CLKIN1;
    input PWRDWN;
    input RST;
endmodule

(* keep *)
module PS7 (...);
    output DMA0DAVALID;
    output DMA0DRREADY;
    output DMA0RSTN;
    output DMA1DAVALID;
    output DMA1DRREADY;
    output DMA1RSTN;
    output DMA2DAVALID;
    output DMA2DRREADY;
    output DMA2RSTN;
    output DMA3DAVALID;
    output DMA3DRREADY;
    output DMA3RSTN;
    output EMIOCAN0PHYTX;
    output EMIOCAN1PHYTX;
    output EMIOENET0GMIITXEN;
    output EMIOENET0GMIITXER;
    output EMIOENET0MDIOMDC;
    output EMIOENET0MDIOO;
    output EMIOENET0MDIOTN;
    output EMIOENET0PTPDELAYREQRX;
    output EMIOENET0PTPDELAYREQTX;
    output EMIOENET0PTPPDELAYREQRX;
    output EMIOENET0PTPPDELAYREQTX;
    output EMIOENET0PTPPDELAYRESPRX;
    output EMIOENET0PTPPDELAYRESPTX;
    output EMIOENET0PTPSYNCFRAMERX;
    output EMIOENET0PTPSYNCFRAMETX;
    output EMIOENET0SOFRX;
    output EMIOENET0SOFTX;
    output EMIOENET1GMIITXEN;
    output EMIOENET1GMIITXER;
    output EMIOENET1MDIOMDC;
    output EMIOENET1MDIOO;
    output EMIOENET1MDIOTN;
    output EMIOENET1PTPDELAYREQRX;
    output EMIOENET1PTPDELAYREQTX;
    output EMIOENET1PTPPDELAYREQRX;
    output EMIOENET1PTPPDELAYREQTX;
    output EMIOENET1PTPPDELAYRESPRX;
    output EMIOENET1PTPPDELAYRESPTX;
    output EMIOENET1PTPSYNCFRAMERX;
    output EMIOENET1PTPSYNCFRAMETX;
    output EMIOENET1SOFRX;
    output EMIOENET1SOFTX;
    output EMIOI2C0SCLO;
    output EMIOI2C0SCLTN;
    output EMIOI2C0SDAO;
    output EMIOI2C0SDATN;
    output EMIOI2C1SCLO;
    output EMIOI2C1SCLTN;
    output EMIOI2C1SDAO;
    output EMIOI2C1SDATN;
    output EMIOPJTAGTDO;
    output EMIOPJTAGTDTN;
    output EMIOSDIO0BUSPOW;
    output EMIOSDIO0CLK;
    output EMIOSDIO0CMDO;
    output EMIOSDIO0CMDTN;
    output EMIOSDIO0LED;
    output EMIOSDIO1BUSPOW;
    output EMIOSDIO1CLK;
    output EMIOSDIO1CMDO;
    output EMIOSDIO1CMDTN;
    output EMIOSDIO1LED;
    output EMIOSPI0MO;
    output EMIOSPI0MOTN;
    output EMIOSPI0SCLKO;
    output EMIOSPI0SCLKTN;
    output EMIOSPI0SO;
    output EMIOSPI0SSNTN;
    output EMIOSPI0STN;
    output EMIOSPI1MO;
    output EMIOSPI1MOTN;
    output EMIOSPI1SCLKO;
    output EMIOSPI1SCLKTN;
    output EMIOSPI1SO;
    output EMIOSPI1SSNTN;
    output EMIOSPI1STN;
    output EMIOTRACECTL;
    output EMIOUART0DTRN;
    output EMIOUART0RTSN;
    output EMIOUART0TX;
    output EMIOUART1DTRN;
    output EMIOUART1RTSN;
    output EMIOUART1TX;
    output EMIOUSB0VBUSPWRSELECT;
    output EMIOUSB1VBUSPWRSELECT;
    output EMIOWDTRSTO;
    output EVENTEVENTO;
    output MAXIGP0ARESETN;
    output MAXIGP0ARVALID;
    output MAXIGP0AWVALID;
    output MAXIGP0BREADY;
    output MAXIGP0RREADY;
    output MAXIGP0WLAST;
    output MAXIGP0WVALID;
    output MAXIGP1ARESETN;
    output MAXIGP1ARVALID;
    output MAXIGP1AWVALID;
    output MAXIGP1BREADY;
    output MAXIGP1RREADY;
    output MAXIGP1WLAST;
    output MAXIGP1WVALID;
    output SAXIACPARESETN;
    output SAXIACPARREADY;
    output SAXIACPAWREADY;
    output SAXIACPBVALID;
    output SAXIACPRLAST;
    output SAXIACPRVALID;
    output SAXIACPWREADY;
    output SAXIGP0ARESETN;
    output SAXIGP0ARREADY;
    output SAXIGP0AWREADY;
    output SAXIGP0BVALID;
    output SAXIGP0RLAST;
    output SAXIGP0RVALID;
    output SAXIGP0WREADY;
    output SAXIGP1ARESETN;
    output SAXIGP1ARREADY;
    output SAXIGP1AWREADY;
    output SAXIGP1BVALID;
    output SAXIGP1RLAST;
    output SAXIGP1RVALID;
    output SAXIGP1WREADY;
    output SAXIHP0ARESETN;
    output SAXIHP0ARREADY;
    output SAXIHP0AWREADY;
    output SAXIHP0BVALID;
    output SAXIHP0RLAST;
    output SAXIHP0RVALID;
    output SAXIHP0WREADY;
    output SAXIHP1ARESETN;
    output SAXIHP1ARREADY;
    output SAXIHP1AWREADY;
    output SAXIHP1BVALID;
    output SAXIHP1RLAST;
    output SAXIHP1RVALID;
    output SAXIHP1WREADY;
    output SAXIHP2ARESETN;
    output SAXIHP2ARREADY;
    output SAXIHP2AWREADY;
    output SAXIHP2BVALID;
    output SAXIHP2RLAST;
    output SAXIHP2RVALID;
    output SAXIHP2WREADY;
    output SAXIHP3ARESETN;
    output SAXIHP3ARREADY;
    output SAXIHP3AWREADY;
    output SAXIHP3BVALID;
    output SAXIHP3RLAST;
    output SAXIHP3RVALID;
    output SAXIHP3WREADY;
    output [11:0] MAXIGP0ARID;
    output [11:0] MAXIGP0AWID;
    output [11:0] MAXIGP0WID;
    output [11:0] MAXIGP1ARID;
    output [11:0] MAXIGP1AWID;
    output [11:0] MAXIGP1WID;
    output [1:0] DMA0DATYPE;
    output [1:0] DMA1DATYPE;
    output [1:0] DMA2DATYPE;
    output [1:0] DMA3DATYPE;
    output [1:0] EMIOUSB0PORTINDCTL;
    output [1:0] EMIOUSB1PORTINDCTL;
    output [1:0] EVENTSTANDBYWFE;
    output [1:0] EVENTSTANDBYWFI;
    output [1:0] MAXIGP0ARBURST;
    output [1:0] MAXIGP0ARLOCK;
    output [1:0] MAXIGP0ARSIZE;
    output [1:0] MAXIGP0AWBURST;
    output [1:0] MAXIGP0AWLOCK;
    output [1:0] MAXIGP0AWSIZE;
    output [1:0] MAXIGP1ARBURST;
    output [1:0] MAXIGP1ARLOCK;
    output [1:0] MAXIGP1ARSIZE;
    output [1:0] MAXIGP1AWBURST;
    output [1:0] MAXIGP1AWLOCK;
    output [1:0] MAXIGP1AWSIZE;
    output [1:0] SAXIACPBRESP;
    output [1:0] SAXIACPRRESP;
    output [1:0] SAXIGP0BRESP;
    output [1:0] SAXIGP0RRESP;
    output [1:0] SAXIGP1BRESP;
    output [1:0] SAXIGP1RRESP;
    output [1:0] SAXIHP0BRESP;
    output [1:0] SAXIHP0RRESP;
    output [1:0] SAXIHP1BRESP;
    output [1:0] SAXIHP1RRESP;
    output [1:0] SAXIHP2BRESP;
    output [1:0] SAXIHP2RRESP;
    output [1:0] SAXIHP3BRESP;
    output [1:0] SAXIHP3RRESP;
    output [28:0] IRQP2F;
    output [2:0] EMIOSDIO0BUSVOLT;
    output [2:0] EMIOSDIO1BUSVOLT;
    output [2:0] EMIOSPI0SSON;
    output [2:0] EMIOSPI1SSON;
    output [2:0] EMIOTTC0WAVEO;
    output [2:0] EMIOTTC1WAVEO;
    output [2:0] MAXIGP0ARPROT;
    output [2:0] MAXIGP0AWPROT;
    output [2:0] MAXIGP1ARPROT;
    output [2:0] MAXIGP1AWPROT;
    output [2:0] SAXIACPBID;
    output [2:0] SAXIACPRID;
    output [2:0] SAXIHP0RACOUNT;
    output [2:0] SAXIHP1RACOUNT;
    output [2:0] SAXIHP2RACOUNT;
    output [2:0] SAXIHP3RACOUNT;
    output [31:0] EMIOTRACEDATA;
    output [31:0] FTMTP2FDEBUG;
    output [31:0] MAXIGP0ARADDR;
    output [31:0] MAXIGP0AWADDR;
    output [31:0] MAXIGP0WDATA;
    output [31:0] MAXIGP1ARADDR;
    output [31:0] MAXIGP1AWADDR;
    output [31:0] MAXIGP1WDATA;
    output [31:0] SAXIGP0RDATA;
    output [31:0] SAXIGP1RDATA;
    output [3:0] EMIOSDIO0DATAO;
    output [3:0] EMIOSDIO0DATATN;
    output [3:0] EMIOSDIO1DATAO;
    output [3:0] EMIOSDIO1DATATN;
    output [3:0] FCLKCLK;
    output [3:0] FCLKRESETN;
    output [3:0] FTMTF2PTRIGACK;
    output [3:0] FTMTP2FTRIG;
    output [3:0] MAXIGP0ARCACHE;
    output [3:0] MAXIGP0ARLEN;
    output [3:0] MAXIGP0ARQOS;
    output [3:0] MAXIGP0AWCACHE;
    output [3:0] MAXIGP0AWLEN;
    output [3:0] MAXIGP0AWQOS;
    output [3:0] MAXIGP0WSTRB;
    output [3:0] MAXIGP1ARCACHE;
    output [3:0] MAXIGP1ARLEN;
    output [3:0] MAXIGP1ARQOS;
    output [3:0] MAXIGP1AWCACHE;
    output [3:0] MAXIGP1AWLEN;
    output [3:0] MAXIGP1AWQOS;
    output [3:0] MAXIGP1WSTRB;
    output [5:0] SAXIGP0BID;
    output [5:0] SAXIGP0RID;
    output [5:0] SAXIGP1BID;
    output [5:0] SAXIGP1RID;
    output [5:0] SAXIHP0BID;
    output [5:0] SAXIHP0RID;
    output [5:0] SAXIHP0WACOUNT;
    output [5:0] SAXIHP1BID;
    output [5:0] SAXIHP1RID;
    output [5:0] SAXIHP1WACOUNT;
    output [5:0] SAXIHP2BID;
    output [5:0] SAXIHP2RID;
    output [5:0] SAXIHP2WACOUNT;
    output [5:0] SAXIHP3BID;
    output [5:0] SAXIHP3RID;
    output [5:0] SAXIHP3WACOUNT;
    output [63:0] EMIOGPIOO;
    output [63:0] EMIOGPIOTN;
    output [63:0] SAXIACPRDATA;
    output [63:0] SAXIHP0RDATA;
    output [63:0] SAXIHP1RDATA;
    output [63:0] SAXIHP2RDATA;
    output [63:0] SAXIHP3RDATA;
    output [7:0] EMIOENET0GMIITXD;
    output [7:0] EMIOENET1GMIITXD;
    output [7:0] SAXIHP0RCOUNT;
    output [7:0] SAXIHP0WCOUNT;
    output [7:0] SAXIHP1RCOUNT;
    output [7:0] SAXIHP1WCOUNT;
    output [7:0] SAXIHP2RCOUNT;
    output [7:0] SAXIHP2WCOUNT;
    output [7:0] SAXIHP3RCOUNT;
    output [7:0] SAXIHP3WCOUNT;
    inout DDRCASB;
    inout DDRCKE;
    inout DDRCKN;
    inout DDRCKP;
    inout DDRCSB;
    inout DDRDRSTB;
    inout DDRODT;
    inout DDRRASB;
    inout DDRVRN;
    inout DDRVRP;
    inout DDRWEB;
    inout PSCLK;
    inout PSPORB;
    inout PSSRSTB;
    inout [14:0] DDRA;
    inout [2:0] DDRBA;
    inout [31:0] DDRDQ;
    inout [3:0] DDRDM;
    inout [3:0] DDRDQSN;
    inout [3:0] DDRDQSP;
    inout [53:0] MIO;
    input DMA0ACLK;
    input DMA0DAREADY;
    input DMA0DRLAST;
    input DMA0DRVALID;
    input DMA1ACLK;
    input DMA1DAREADY;
    input DMA1DRLAST;
    input DMA1DRVALID;
    input DMA2ACLK;
    input DMA2DAREADY;
    input DMA2DRLAST;
    input DMA2DRVALID;
    input DMA3ACLK;
    input DMA3DAREADY;
    input DMA3DRLAST;
    input DMA3DRVALID;
    input EMIOCAN0PHYRX;
    input EMIOCAN1PHYRX;
    input EMIOENET0EXTINTIN;
    input EMIOENET0GMIICOL;
    input EMIOENET0GMIICRS;
    input EMIOENET0GMIIRXCLK;
    input EMIOENET0GMIIRXDV;
    input EMIOENET0GMIIRXER;
    input EMIOENET0GMIITXCLK;
    input EMIOENET0MDIOI;
    input EMIOENET1EXTINTIN;
    input EMIOENET1GMIICOL;
    input EMIOENET1GMIICRS;
    input EMIOENET1GMIIRXCLK;
    input EMIOENET1GMIIRXDV;
    input EMIOENET1GMIIRXER;
    input EMIOENET1GMIITXCLK;
    input EMIOENET1MDIOI;
    input EMIOI2C0SCLI;
    input EMIOI2C0SDAI;
    input EMIOI2C1SCLI;
    input EMIOI2C1SDAI;
    input EMIOPJTAGTCK;
    input EMIOPJTAGTDI;
    input EMIOPJTAGTMS;
    input EMIOSDIO0CDN;
    input EMIOSDIO0CLKFB;
    input EMIOSDIO0CMDI;
    input EMIOSDIO0WP;
    input EMIOSDIO1CDN;
    input EMIOSDIO1CLKFB;
    input EMIOSDIO1CMDI;
    input EMIOSDIO1WP;
    input EMIOSPI0MI;
    input EMIOSPI0SCLKI;
    input EMIOSPI0SI;
    input EMIOSPI0SSIN;
    input EMIOSPI1MI;
    input EMIOSPI1SCLKI;
    input EMIOSPI1SI;
    input EMIOSPI1SSIN;
    input EMIOSRAMINTIN;
    input EMIOTRACECLK;
    input EMIOUART0CTSN;
    input EMIOUART0DCDN;
    input EMIOUART0DSRN;
    input EMIOUART0RIN;
    input EMIOUART0RX;
    input EMIOUART1CTSN;
    input EMIOUART1DCDN;
    input EMIOUART1DSRN;
    input EMIOUART1RIN;
    input EMIOUART1RX;
    input EMIOUSB0VBUSPWRFAULT;
    input EMIOUSB1VBUSPWRFAULT;
    input EMIOWDTCLKI;
    input EVENTEVENTI;
    input FPGAIDLEN;
    input FTMDTRACEINCLOCK;
    input FTMDTRACEINVALID;
    input MAXIGP0ACLK;
    input MAXIGP0ARREADY;
    input MAXIGP0AWREADY;
    input MAXIGP0BVALID;
    input MAXIGP0RLAST;
    input MAXIGP0RVALID;
    input MAXIGP0WREADY;
    input MAXIGP1ACLK;
    input MAXIGP1ARREADY;
    input MAXIGP1AWREADY;
    input MAXIGP1BVALID;
    input MAXIGP1RLAST;
    input MAXIGP1RVALID;
    input MAXIGP1WREADY;
    input SAXIACPACLK;
    input SAXIACPARVALID;
    input SAXIACPAWVALID;
    input SAXIACPBREADY;
    input SAXIACPRREADY;
    input SAXIACPWLAST;
    input SAXIACPWVALID;
    input SAXIGP0ACLK;
    input SAXIGP0ARVALID;
    input SAXIGP0AWVALID;
    input SAXIGP0BREADY;
    input SAXIGP0RREADY;
    input SAXIGP0WLAST;
    input SAXIGP0WVALID;
    input SAXIGP1ACLK;
    input SAXIGP1ARVALID;
    input SAXIGP1AWVALID;
    input SAXIGP1BREADY;
    input SAXIGP1RREADY;
    input SAXIGP1WLAST;
    input SAXIGP1WVALID;
    input SAXIHP0ACLK;
    input SAXIHP0ARVALID;
    input SAXIHP0AWVALID;
    input SAXIHP0BREADY;
    input SAXIHP0RDISSUECAP1EN;
    input SAXIHP0RREADY;
    input SAXIHP0WLAST;
    input SAXIHP0WRISSUECAP1EN;
    input SAXIHP0WVALID;
    input SAXIHP1ACLK;
    input SAXIHP1ARVALID;
    input SAXIHP1AWVALID;
    input SAXIHP1BREADY;
    input SAXIHP1RDISSUECAP1EN;
    input SAXIHP1RREADY;
    input SAXIHP1WLAST;
    input SAXIHP1WRISSUECAP1EN;
    input SAXIHP1WVALID;
    input SAXIHP2ACLK;
    input SAXIHP2ARVALID;
    input SAXIHP2AWVALID;
    input SAXIHP2BREADY;
    input SAXIHP2RDISSUECAP1EN;
    input SAXIHP2RREADY;
    input SAXIHP2WLAST;
    input SAXIHP2WRISSUECAP1EN;
    input SAXIHP2WVALID;
    input SAXIHP3ACLK;
    input SAXIHP3ARVALID;
    input SAXIHP3AWVALID;
    input SAXIHP3BREADY;
    input SAXIHP3RDISSUECAP1EN;
    input SAXIHP3RREADY;
    input SAXIHP3WLAST;
    input SAXIHP3WRISSUECAP1EN;
    input SAXIHP3WVALID;
    input [11:0] MAXIGP0BID;
    input [11:0] MAXIGP0RID;
    input [11:0] MAXIGP1BID;
    input [11:0] MAXIGP1RID;
    input [19:0] IRQF2P;
    input [1:0] DMA0DRTYPE;
    input [1:0] DMA1DRTYPE;
    input [1:0] DMA2DRTYPE;
    input [1:0] DMA3DRTYPE;
    input [1:0] MAXIGP0BRESP;
    input [1:0] MAXIGP0RRESP;
    input [1:0] MAXIGP1BRESP;
    input [1:0] MAXIGP1RRESP;
    input [1:0] SAXIACPARBURST;
    input [1:0] SAXIACPARLOCK;
    input [1:0] SAXIACPARSIZE;
    input [1:0] SAXIACPAWBURST;
    input [1:0] SAXIACPAWLOCK;
    input [1:0] SAXIACPAWSIZE;
    input [1:0] SAXIGP0ARBURST;
    input [1:0] SAXIGP0ARLOCK;
    input [1:0] SAXIGP0ARSIZE;
    input [1:0] SAXIGP0AWBURST;
    input [1:0] SAXIGP0AWLOCK;
    input [1:0] SAXIGP0AWSIZE;
    input [1:0] SAXIGP1ARBURST;
    input [1:0] SAXIGP1ARLOCK;
    input [1:0] SAXIGP1ARSIZE;
    input [1:0] SAXIGP1AWBURST;
    input [1:0] SAXIGP1AWLOCK;
    input [1:0] SAXIGP1AWSIZE;
    input [1:0] SAXIHP0ARBURST;
    input [1:0] SAXIHP0ARLOCK;
    input [1:0] SAXIHP0ARSIZE;
    input [1:0] SAXIHP0AWBURST;
    input [1:0] SAXIHP0AWLOCK;
    input [1:0] SAXIHP0AWSIZE;
    input [1:0] SAXIHP1ARBURST;
    input [1:0] SAXIHP1ARLOCK;
    input [1:0] SAXIHP1ARSIZE;
    input [1:0] SAXIHP1AWBURST;
    input [1:0] SAXIHP1AWLOCK;
    input [1:0] SAXIHP1AWSIZE;
    input [1:0] SAXIHP2ARBURST;
    input [1:0] SAXIHP2ARLOCK;
    input [1:0] SAXIHP2ARSIZE;
    input [1:0] SAXIHP2AWBURST;
    input [1:0] SAXIHP2AWLOCK;
    input [1:0] SAXIHP2AWSIZE;
    input [1:0] SAXIHP3ARBURST;
    input [1:0] SAXIHP3ARLOCK;
    input [1:0] SAXIHP3ARSIZE;
    input [1:0] SAXIHP3AWBURST;
    input [1:0] SAXIHP3AWLOCK;
    input [1:0] SAXIHP3AWSIZE;
    input [2:0] EMIOTTC0CLKI;
    input [2:0] EMIOTTC1CLKI;
    input [2:0] SAXIACPARID;
    input [2:0] SAXIACPARPROT;
    input [2:0] SAXIACPAWID;
    input [2:0] SAXIACPAWPROT;
    input [2:0] SAXIACPWID;
    input [2:0] SAXIGP0ARPROT;
    input [2:0] SAXIGP0AWPROT;
    input [2:0] SAXIGP1ARPROT;
    input [2:0] SAXIGP1AWPROT;
    input [2:0] SAXIHP0ARPROT;
    input [2:0] SAXIHP0AWPROT;
    input [2:0] SAXIHP1ARPROT;
    input [2:0] SAXIHP1AWPROT;
    input [2:0] SAXIHP2ARPROT;
    input [2:0] SAXIHP2AWPROT;
    input [2:0] SAXIHP3ARPROT;
    input [2:0] SAXIHP3AWPROT;
    input [31:0] FTMDTRACEINDATA;
    input [31:0] FTMTF2PDEBUG;
    input [31:0] MAXIGP0RDATA;
    input [31:0] MAXIGP1RDATA;
    input [31:0] SAXIACPARADDR;
    input [31:0] SAXIACPAWADDR;
    input [31:0] SAXIGP0ARADDR;
    input [31:0] SAXIGP0AWADDR;
    input [31:0] SAXIGP0WDATA;
    input [31:0] SAXIGP1ARADDR;
    input [31:0] SAXIGP1AWADDR;
    input [31:0] SAXIGP1WDATA;
    input [31:0] SAXIHP0ARADDR;
    input [31:0] SAXIHP0AWADDR;
    input [31:0] SAXIHP1ARADDR;
    input [31:0] SAXIHP1AWADDR;
    input [31:0] SAXIHP2ARADDR;
    input [31:0] SAXIHP2AWADDR;
    input [31:0] SAXIHP3ARADDR;
    input [31:0] SAXIHP3AWADDR;
    input [3:0] DDRARB;
    input [3:0] EMIOSDIO0DATAI;
    input [3:0] EMIOSDIO1DATAI;
    input [3:0] FCLKCLKTRIGN;
    input [3:0] FTMDTRACEINATID;
    input [3:0] FTMTF2PTRIG;
    input [3:0] FTMTP2FTRIGACK;
    input [3:0] SAXIACPARCACHE;
    input [3:0] SAXIACPARLEN;
    input [3:0] SAXIACPARQOS;
    input [3:0] SAXIACPAWCACHE;
    input [3:0] SAXIACPAWLEN;
    input [3:0] SAXIACPAWQOS;
    input [3:0] SAXIGP0ARCACHE;
    input [3:0] SAXIGP0ARLEN;
    input [3:0] SAXIGP0ARQOS;
    input [3:0] SAXIGP0AWCACHE;
    input [3:0] SAXIGP0AWLEN;
    input [3:0] SAXIGP0AWQOS;
    input [3:0] SAXIGP0WSTRB;
    input [3:0] SAXIGP1ARCACHE;
    input [3:0] SAXIGP1ARLEN;
    input [3:0] SAXIGP1ARQOS;
    input [3:0] SAXIGP1AWCACHE;
    input [3:0] SAXIGP1AWLEN;
    input [3:0] SAXIGP1AWQOS;
    input [3:0] SAXIGP1WSTRB;
    input [3:0] SAXIHP0ARCACHE;
    input [3:0] SAXIHP0ARLEN;
    input [3:0] SAXIHP0ARQOS;
    input [3:0] SAXIHP0AWCACHE;
    input [3:0] SAXIHP0AWLEN;
    input [3:0] SAXIHP0AWQOS;
    input [3:0] SAXIHP1ARCACHE;
    input [3:0] SAXIHP1ARLEN;
    input [3:0] SAXIHP1ARQOS;
    input [3:0] SAXIHP1AWCACHE;
    input [3:0] SAXIHP1AWLEN;
    input [3:0] SAXIHP1AWQOS;
    input [3:0] SAXIHP2ARCACHE;
    input [3:0] SAXIHP2ARLEN;
    input [3:0] SAXIHP2ARQOS;
    input [3:0] SAXIHP2AWCACHE;
    input [3:0] SAXIHP2AWLEN;
    input [3:0] SAXIHP2AWQOS;
    input [3:0] SAXIHP3ARCACHE;
    input [3:0] SAXIHP3ARLEN;
    input [3:0] SAXIHP3ARQOS;
    input [3:0] SAXIHP3AWCACHE;
    input [3:0] SAXIHP3AWLEN;
    input [3:0] SAXIHP3AWQOS;
    input [4:0] SAXIACPARUSER;
    input [4:0] SAXIACPAWUSER;
    input [5:0] SAXIGP0ARID;
    input [5:0] SAXIGP0AWID;
    input [5:0] SAXIGP0WID;
    input [5:0] SAXIGP1ARID;
    input [5:0] SAXIGP1AWID;
    input [5:0] SAXIGP1WID;
    input [5:0] SAXIHP0ARID;
    input [5:0] SAXIHP0AWID;
    input [5:0] SAXIHP0WID;
    input [5:0] SAXIHP1ARID;
    input [5:0] SAXIHP1AWID;
    input [5:0] SAXIHP1WID;
    input [5:0] SAXIHP2ARID;
    input [5:0] SAXIHP2AWID;
    input [5:0] SAXIHP2WID;
    input [5:0] SAXIHP3ARID;
    input [5:0] SAXIHP3AWID;
    input [5:0] SAXIHP3WID;
    input [63:0] EMIOGPIOI;
    input [63:0] SAXIACPWDATA;
    input [63:0] SAXIHP0WDATA;
    input [63:0] SAXIHP1WDATA;
    input [63:0] SAXIHP2WDATA;
    input [63:0] SAXIHP3WDATA;
    input [7:0] EMIOENET0GMIIRXD;
    input [7:0] EMIOENET1GMIIRXD;
    input [7:0] SAXIACPWSTRB;
    input [7:0] SAXIHP0WSTRB;
    input [7:0] SAXIHP1WSTRB;
    input [7:0] SAXIHP2WSTRB;
    input [7:0] SAXIHP3WSTRB;
endmodule

module PULLDOWN (...);
    output O;
endmodule

module PULLUP (...);
    output O;
endmodule

module RAM128X1D (...);
    parameter [127:0] INIT = 128'h00000000000000000000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output DPO, SPO;
    input [6:0] A;
    input [6:0] DPRA;
    input D;
    input WCLK;
    input WE;
endmodule

module RAM128X1S (...);
    parameter [127:0] INIT = 128'h00000000000000000000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O;
    input A0, A1, A2, A3, A4, A5, A6, D, WCLK, WE;
endmodule

module RAM256X1S (...);
    parameter [255:0] INIT = 256'h0;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O;
    input [7:0] A;
    input D;
    input WCLK;
    input WE;
endmodule

module RAM32M (...);
    parameter [63:0] INIT_A = 64'h0000000000000000;
    parameter [63:0] INIT_B = 64'h0000000000000000;
    parameter [63:0] INIT_C = 64'h0000000000000000;
    parameter [63:0] INIT_D = 64'h0000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output [1:0] DOA;
    output [1:0] DOB;
    output [1:0] DOC;
    output [1:0] DOD;
    input [4:0] ADDRA;
    input [4:0] ADDRB;
    input [4:0] ADDRC;
    input [4:0] ADDRD;
    input [1:0] DIA;
    input [1:0] DIB;
    input [1:0] DIC;
    input [1:0] DID;
    input WCLK;
    input WE;
endmodule

module RAM32X1D (...);
    parameter [31:0] INIT = 32'h00000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output DPO, SPO;
    input A0, A1, A2, A3, A4, D, DPRA0, DPRA1, DPRA2, DPRA3, DPRA4, WCLK, WE;
endmodule

module RAM32X1S (...);
    parameter [31:0] INIT = 32'h00000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O;
    input A0, A1, A2, A3, A4, D, WCLK, WE;
endmodule

module RAM32X1S_1 (...);
    parameter [31:0] INIT = 32'h00000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O;
    input A0, A1, A2, A3, A4, D, WCLK, WE;
endmodule

module RAM32X2S (...);
    parameter [31:0] INIT_00 = 32'h00000000;
    parameter [31:0] INIT_01 = 32'h00000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O0, O1;
    input A0, A1, A2, A3, A4, D0, D1, WCLK, WE;
endmodule

module RAM64M (...);
    parameter [63:0] INIT_A = 64'h0000000000000000;
    parameter [63:0] INIT_B = 64'h0000000000000000;
    parameter [63:0] INIT_C = 64'h0000000000000000;
    parameter [63:0] INIT_D = 64'h0000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output DOA;
    output DOB;
    output DOC;
    output DOD;
    input [5:0] ADDRA;
    input [5:0] ADDRB;
    input [5:0] ADDRC;
    input [5:0] ADDRD;
    input DIA;
    input DIB;
    input DIC;
    input DID;
    input WCLK;
    input WE;
endmodule

module RAM64X1D (...);
    parameter [63:0] INIT = 64'h0000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output DPO, SPO;
    input A0, A1, A2, A3, A4, A5, D, DPRA0, DPRA1, DPRA2, DPRA3, DPRA4, DPRA5, WCLK, WE;
endmodule

module RAM64X1S (...);
    parameter [63:0] INIT = 64'h0000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O;
    input A0, A1, A2, A3, A4, A5, D, WCLK, WE;
endmodule

module RAM64X1S_1 (...);
    parameter [63:0] INIT = 64'h0000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O;
    input A0, A1, A2, A3, A4, A5, D, WCLK, WE;
endmodule

module RAM64X2S (...);
    parameter [63:0] INIT_00 = 64'h0000000000000000;
    parameter [63:0] INIT_01 = 64'h0000000000000000;
    parameter [0:0] IS_WCLK_INVERTED = 1'b0;
    output O0, O1;
    input A0, A1, A2, A3, A4, A5, D0, D1, WCLK, WE;
endmodule

module ROM128X1 (...);
    parameter [127:0] INIT = 128'h00000000000000000000000000000000;
    output O;
    input A0, A1, A2, A3, A4, A5, A6;
endmodule

module ROM256X1 (...);
    parameter [255:0] INIT = 256'h0000000000000000000000000000000000000000000000000000000000000000;
    output O;
    input A0, A1, A2, A3, A4, A5, A6, A7;
endmodule

module ROM32X1 (...);
    parameter [31:0] INIT = 32'h00000000;
    output O;
    input A0, A1, A2, A3, A4;
endmodule

module ROM64X1 (...);
    parameter [63:0] INIT = 64'h0000000000000000;
    output O;
    input A0, A1, A2, A3, A4, A5;
endmodule

module SRL16E (...);
    parameter [15:0] INIT = 16'h0000;
    parameter [0:0] IS_CLK_INVERTED = 1'b0;
    output Q;
    input A0, A1, A2, A3, CE, CLK, D;
endmodule

module SRLC32E (...);
    parameter [31:0] INIT = 32'h00000000;
    parameter [0:0] IS_CLK_INVERTED = 1'b0;
    output Q;
    output Q31;
    input [4:0] A;
    input CE, CLK, D;
endmodule

(* keep *)
module STARTUPE2 (...);
    parameter PROG_USR = "FALSE";
    parameter real SIM_CCLK_FREQ = 0.0;
    output CFGCLK;
    output CFGMCLK;
    output EOS;
    output PREQ;
    input CLK;
    input GSR;
    input GTS;
    input KEYCLEARB;
    input PACK;
    input USRCCLKO;
    input USRCCLKTS;
    input USRDONEO;
    input USRDONETS;
endmodule

module USR_ACCESSE2 (...);
    output CFGCLK;
    output DATAVALID;
    output [31:0] DATA;
endmodule

module XADC (...);
    output BUSY;
    output DRDY;
    output EOC;
    output EOS;
    output JTAGBUSY;
    output JTAGLOCKED;
    output JTAGMODIFIED;
    output OT;
    output [15:0] DO;
    output [7:0] ALM;
    output [4:0] CHANNEL;
    output [4:0] MUXADDR;
    input CONVST;
    input CONVSTCLK;
    input DCLK;
    input DEN;
    input DWE;
    input RESET;
    input VN;
    input VP;
    input [15:0] DI;
    input [15:0] VAUXN;
    input [15:0] VAUXP;
    input [6:0] DADDR;
    parameter [15:0] INIT_40 = 16'h0;
    parameter [15:0] INIT_41 = 16'h0;
    parameter [15:0] INIT_42 = 16'h0800;
    parameter [15:0] INIT_43 = 16'h0;
    parameter [15:0] INIT_44 = 16'h0;
    parameter [15:0] INIT_45 = 16'h0;
    parameter [15:0] INIT_46 = 16'h0;
    parameter [15:0] INIT_47 = 16'h0;
    parameter [15:0] INIT_48 = 16'h0;
    parameter [15:0] INIT_49 = 16'h0;
    parameter [15:0] INIT_4A = 16'h0;
    parameter [15:0] INIT_4B = 16'h0;
    parameter [15:0] INIT_4C = 16'h0;
    parameter [15:0] INIT_4D = 16'h0;
    parameter [15:0] INIT_4E = 16'h0;
    parameter [15:0] INIT_4F = 16'h0;
    parameter [15:0] INIT_50 = 16'h0;
    parameter [15:0] INIT_51 = 16'h0;
    parameter [15:0] INIT_52 = 16'h0;
    parameter [15:0] INIT_53 = 16'h0;
    parameter [15:0] INIT_54 = 16'h0;
    parameter [15:0] INIT_55 = 16'h0;
    parameter [15:0] INIT_56 = 16'h0;
    parameter [15:0] INIT_57 = 16'h0;
    parameter [15:0] INIT_58 = 16'h0;
    parameter [15:0] INIT_59 = 16'h0;
    parameter [15:0] INIT_5A = 16'h0;
    parameter [15:0] INIT_5B = 16'h0;
    parameter [15:0] INIT_5C = 16'h0;
    parameter [15:0] INIT_5D = 16'h0;
    parameter [15:0] INIT_5E = 16'h0;
    parameter [15:0] INIT_5F = 16'h0;
    parameter IS_CONVSTCLK_INVERTED = 1'b0;
    parameter IS_DCLK_INVERTED = 1'b0;
    parameter SIM_DEVICE = "7SERIES";
    parameter SIM_MONITOR_FILE = "design.txt";
endmodule

