/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import javax.swing.JComboBox;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.JComboBoxDriver;
import org.fest.swing.driver.JComboBoxEditableQuery;
import org.fest.swing.driver.JTableStopCellEditingTask;
import org.fest.util.Collections;

public class JTableComboBoxEditorCellWriter
extends AbstractJTableCellWriter {
    private final JComboBoxDriver driver;

    public JTableComboBoxEditorCellWriter(Robot robot) {
        super(robot);
        this.driver = new JComboBoxDriver(robot);
    }

    @RunsInEDT
    public void enterValue(JTable table, int row, int column, String value) {
        JComboBox editor = this.doStartCellEditing(table, row, column);
        this.selectOrType(editor, value);
        JTableStopCellEditingTask.stopEditing(table, row, column);
    }

    private void selectOrType(JComboBox editor, String value) {
        boolean selectValue;
        boolean bl = selectValue = !JComboBoxEditableQuery.isEditable(editor);
        if (!selectValue) {
            selectValue = Collections.list((Object[])this.driver.contentsOf(editor)).contains(value);
        }
        if (selectValue) {
            this.driver.selectItem(editor, value);
            return;
        }
        this.driver.enterText(editor, value);
    }

    @RunsInEDT
    public void startCellEditing(JTable table, int row, int column) {
        this.doStartCellEditing(table, row, column);
    }

    @RunsInEDT
    private JComboBox doStartCellEditing(JTable table, int row, int column) {
        Point cellLocation = JTableComboBoxEditorCellWriter.cellLocation(table, row, column, this.location);
        this.robot.click((Component)table, cellLocation);
        JComboBox comboBox = this.waitForEditorActivation(table, row, column);
        this.cellEditor(JTableComboBoxEditorCellWriter.cellEditor(table, row, column));
        return comboBox;
    }

    @RunsInEDT
    private JComboBox waitForEditorActivation(JTable table, int row, int column) {
        return this.waitForEditorActivation(table, row, column, JComboBox.class);
    }
}

